import React, { PureComponent } from 'react';
import { Themeable2 } from '../../types';
interface Style {
    [key: string]: string;
}
interface ParsedChunk {
    style: Style;
    text: string;
}
interface Props extends Themeable2 {
    value: string;
    highlight?: {
        searchWords: string[];
        highlightClassName: string;
    };
}
interface State {
    chunks: ParsedChunk[];
    prevValue: string;
}
export declare class UnThemedLogMessageAnsi extends PureComponent<Props, State> {
    state: State;
    static getDerivedStateFromProps(props: Props, state: State): {
        chunks: ({
            style: Style;
            text: string;
        } | {
            text: string;
            style?: undefined;
        })[];
        prevValue: string;
    } | null;
    render(): (string | JSX.Element)[];
}
export declare const LogMessageAnsi: React.FunctionComponent<{
    value: string;
    highlight?: {
        searchWords: string[];
        highlightClassName: string;
    } | undefined;
}>;
export {};
