// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: client.proto

/*
	Package protocol is a generated protocol buffer package.

	It is generated from these files:
		client.proto

	It has these top-level messages:
		Error
		Command
		Reply
		Push
		ClientInfo
		Publication
		Join
		Leave
		Unsub
		Sub
		Message
		ConnectRequest
		ConnectResult
		RefreshRequest
		RefreshResult
		SubscribeRequest
		SubscribeResult
		SubRefreshRequest
		SubRefreshResult
		UnsubscribeRequest
		UnsubscribeResult
		PublishRequest
		PublishResult
		PresenceRequest
		PresenceResult
		PresenceStatsRequest
		PresenceStatsResult
		HistoryRequest
		HistoryResult
		PingRequest
		PingResult
		RPCRequest
		RPCResult
		SendRequest
*/
package protocol

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type MethodType int32

const (
	MethodTypeConnect       MethodType = 0
	MethodTypeSubscribe     MethodType = 1
	MethodTypeUnsubscribe   MethodType = 2
	MethodTypePublish       MethodType = 3
	MethodTypePresence      MethodType = 4
	MethodTypePresenceStats MethodType = 5
	MethodTypeHistory       MethodType = 6
	MethodTypePing          MethodType = 7
	MethodTypeSend          MethodType = 8
	MethodTypeRPC           MethodType = 9
	MethodTypeRefresh       MethodType = 10
	MethodTypeSubRefresh    MethodType = 11
)

var MethodType_name = map[int32]string{
	0:  "CONNECT",
	1:  "SUBSCRIBE",
	2:  "UNSUBSCRIBE",
	3:  "PUBLISH",
	4:  "PRESENCE",
	5:  "PRESENCE_STATS",
	6:  "HISTORY",
	7:  "PING",
	8:  "SEND",
	9:  "RPC",
	10: "REFRESH",
	11: "SUB_REFRESH",
}
var MethodType_value = map[string]int32{
	"CONNECT":        0,
	"SUBSCRIBE":      1,
	"UNSUBSCRIBE":    2,
	"PUBLISH":        3,
	"PRESENCE":       4,
	"PRESENCE_STATS": 5,
	"HISTORY":        6,
	"PING":           7,
	"SEND":           8,
	"RPC":            9,
	"REFRESH":        10,
	"SUB_REFRESH":    11,
}

func (x MethodType) String() string {
	return proto.EnumName(MethodType_name, int32(x))
}
func (MethodType) EnumDescriptor() ([]byte, []int) { return fileDescriptorClient, []int{0} }

type PushType int32

const (
	PushTypePublication PushType = 0
	PushTypeJoin        PushType = 1
	PushTypeLeave       PushType = 2
	PushTypeUnsub       PushType = 3
	PushTypeMessage     PushType = 4
	PushTypeSub         PushType = 5
)

var PushType_name = map[int32]string{
	0: "PUBLICATION",
	1: "JOIN",
	2: "LEAVE",
	3: "UNSUB",
	4: "MESSAGE",
	5: "SUB",
}
var PushType_value = map[string]int32{
	"PUBLICATION": 0,
	"JOIN":        1,
	"LEAVE":       2,
	"UNSUB":       3,
	"MESSAGE":     4,
	"SUB":         5,
}

func (x PushType) String() string {
	return proto.EnumName(PushType_name, int32(x))
}
func (PushType) EnumDescriptor() ([]byte, []int) { return fileDescriptorClient, []int{1} }

type Error struct {
	Code    uint32 `protobuf:"varint,1,opt,name=code,proto3" json:"code"`
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message"`
}

func (m *Error) Reset()                    { *m = Error{} }
func (m *Error) String() string            { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()               {}
func (*Error) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{0} }

func (m *Error) GetCode() uint32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *Error) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type Command struct {
	ID     uint32     `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Method MethodType `protobuf:"varint,2,opt,name=method,proto3,enum=protocol.MethodType" json:"method,omitempty"`
	Params Raw        `protobuf:"bytes,3,opt,name=params,proto3,customtype=Raw" json:"params,omitempty"`
}

func (m *Command) Reset()                    { *m = Command{} }
func (m *Command) String() string            { return proto.CompactTextString(m) }
func (*Command) ProtoMessage()               {}
func (*Command) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{1} }

func (m *Command) GetID() uint32 {
	if m != nil {
		return m.ID
	}
	return 0
}

func (m *Command) GetMethod() MethodType {
	if m != nil {
		return m.Method
	}
	return MethodTypeConnect
}

type Reply struct {
	ID     uint32 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Error  *Error `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
	Result Raw    `protobuf:"bytes,3,opt,name=result,proto3,customtype=Raw" json:"result,omitempty"`
}

func (m *Reply) Reset()                    { *m = Reply{} }
func (m *Reply) String() string            { return proto.CompactTextString(m) }
func (*Reply) ProtoMessage()               {}
func (*Reply) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{2} }

func (m *Reply) GetID() uint32 {
	if m != nil {
		return m.ID
	}
	return 0
}

func (m *Reply) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

type Push struct {
	Type    PushType `protobuf:"varint,1,opt,name=type,proto3,enum=protocol.PushType" json:"type,omitempty"`
	Channel string   `protobuf:"bytes,2,opt,name=channel,proto3" json:"channel,omitempty"`
	Data    Raw      `protobuf:"bytes,3,opt,name=data,proto3,customtype=Raw" json:"data"`
}

func (m *Push) Reset()                    { *m = Push{} }
func (m *Push) String() string            { return proto.CompactTextString(m) }
func (*Push) ProtoMessage()               {}
func (*Push) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{3} }

func (m *Push) GetType() PushType {
	if m != nil {
		return m.Type
	}
	return PushTypePublication
}

func (m *Push) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type ClientInfo struct {
	User     string `protobuf:"bytes,1,opt,name=user,proto3" json:"user"`
	Client   string `protobuf:"bytes,2,opt,name=client,proto3" json:"client"`
	ConnInfo Raw    `protobuf:"bytes,3,opt,name=conn_info,json=connInfo,proto3,customtype=Raw" json:"conn_info,omitempty"`
	ChanInfo Raw    `protobuf:"bytes,4,opt,name=chan_info,json=chanInfo,proto3,customtype=Raw" json:"chan_info,omitempty"`
}

func (m *ClientInfo) Reset()                    { *m = ClientInfo{} }
func (m *ClientInfo) String() string            { return proto.CompactTextString(m) }
func (*ClientInfo) ProtoMessage()               {}
func (*ClientInfo) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{4} }

func (m *ClientInfo) GetUser() string {
	if m != nil {
		return m.User
	}
	return ""
}

func (m *ClientInfo) GetClient() string {
	if m != nil {
		return m.Client
	}
	return ""
}

type Publication struct {
	Seq    uint32      `protobuf:"varint,1,opt,name=seq,proto3" json:"seq,omitempty"`
	Gen    uint32      `protobuf:"varint,2,opt,name=gen,proto3" json:"gen,omitempty"`
	UID    string      `protobuf:"bytes,3,opt,name=uid,proto3" json:"uid,omitempty"`
	Data   Raw         `protobuf:"bytes,4,opt,name=data,proto3,customtype=Raw" json:"data"`
	Info   *ClientInfo `protobuf:"bytes,5,opt,name=info" json:"info,omitempty"`
	Offset uint64      `protobuf:"varint,6,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (m *Publication) Reset()                    { *m = Publication{} }
func (m *Publication) String() string            { return proto.CompactTextString(m) }
func (*Publication) ProtoMessage()               {}
func (*Publication) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{5} }

func (m *Publication) GetSeq() uint32 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *Publication) GetGen() uint32 {
	if m != nil {
		return m.Gen
	}
	return 0
}

func (m *Publication) GetUID() string {
	if m != nil {
		return m.UID
	}
	return ""
}

func (m *Publication) GetInfo() *ClientInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Publication) GetOffset() uint64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type Join struct {
	Info ClientInfo `protobuf:"bytes,1,opt,name=info" json:"info"`
}

func (m *Join) Reset()                    { *m = Join{} }
func (m *Join) String() string            { return proto.CompactTextString(m) }
func (*Join) ProtoMessage()               {}
func (*Join) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{6} }

func (m *Join) GetInfo() ClientInfo {
	if m != nil {
		return m.Info
	}
	return ClientInfo{}
}

type Leave struct {
	Info ClientInfo `protobuf:"bytes,1,opt,name=info" json:"info"`
}

func (m *Leave) Reset()                    { *m = Leave{} }
func (m *Leave) String() string            { return proto.CompactTextString(m) }
func (*Leave) ProtoMessage()               {}
func (*Leave) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{7} }

func (m *Leave) GetInfo() ClientInfo {
	if m != nil {
		return m.Info
	}
	return ClientInfo{}
}

type Unsub struct {
	Resubscribe bool `protobuf:"varint,1,opt,name=resubscribe,proto3" json:"resubscribe,omitempty"`
}

func (m *Unsub) Reset()                    { *m = Unsub{} }
func (m *Unsub) String() string            { return proto.CompactTextString(m) }
func (*Unsub) ProtoMessage()               {}
func (*Unsub) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{8} }

func (m *Unsub) GetResubscribe() bool {
	if m != nil {
		return m.Resubscribe
	}
	return false
}

type Sub struct {
	Recoverable bool   `protobuf:"varint,1,opt,name=recoverable,proto3" json:"recoverable,omitempty"`
	Seq         uint32 `protobuf:"varint,2,opt,name=seq,proto3" json:"seq,omitempty"`
	Gen         uint32 `protobuf:"varint,3,opt,name=gen,proto3" json:"gen,omitempty"`
	Epoch       string `protobuf:"bytes,4,opt,name=epoch,proto3" json:"epoch,omitempty"`
	Offset      uint64 `protobuf:"varint,5,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (m *Sub) Reset()                    { *m = Sub{} }
func (m *Sub) String() string            { return proto.CompactTextString(m) }
func (*Sub) ProtoMessage()               {}
func (*Sub) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{9} }

func (m *Sub) GetRecoverable() bool {
	if m != nil {
		return m.Recoverable
	}
	return false
}

func (m *Sub) GetSeq() uint32 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *Sub) GetGen() uint32 {
	if m != nil {
		return m.Gen
	}
	return 0
}

func (m *Sub) GetEpoch() string {
	if m != nil {
		return m.Epoch
	}
	return ""
}

func (m *Sub) GetOffset() uint64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type Message struct {
	Data Raw `protobuf:"bytes,1,opt,name=data,proto3,customtype=Raw" json:"data"`
}

func (m *Message) Reset()                    { *m = Message{} }
func (m *Message) String() string            { return proto.CompactTextString(m) }
func (*Message) ProtoMessage()               {}
func (*Message) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{10} }

type ConnectRequest struct {
	Token   string                       `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	Data    Raw                          `protobuf:"bytes,2,opt,name=data,proto3,customtype=Raw" json:"data,omitempty"`
	Subs    map[string]*SubscribeRequest `protobuf:"bytes,3,rep,name=subs" json:"subs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	Name    string                       `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	Version string                       `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
}

func (m *ConnectRequest) Reset()                    { *m = ConnectRequest{} }
func (m *ConnectRequest) String() string            { return proto.CompactTextString(m) }
func (*ConnectRequest) ProtoMessage()               {}
func (*ConnectRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{11} }

func (m *ConnectRequest) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *ConnectRequest) GetSubs() map[string]*SubscribeRequest {
	if m != nil {
		return m.Subs
	}
	return nil
}

func (m *ConnectRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ConnectRequest) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type ConnectResult struct {
	Client  string                      `protobuf:"bytes,1,opt,name=client,proto3" json:"client"`
	Version string                      `protobuf:"bytes,2,opt,name=version,proto3" json:"version"`
	Expires bool                        `protobuf:"varint,3,opt,name=expires,proto3" json:"expires,omitempty"`
	TTL     uint32                      `protobuf:"varint,4,opt,name=ttl,proto3" json:"ttl,omitempty"`
	Data    Raw                         `protobuf:"bytes,5,opt,name=data,proto3,customtype=Raw" json:"data,omitempty"`
	Subs    map[string]*SubscribeResult `protobuf:"bytes,6,rep,name=subs" json:"subs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ConnectResult) Reset()                    { *m = ConnectResult{} }
func (m *ConnectResult) String() string            { return proto.CompactTextString(m) }
func (*ConnectResult) ProtoMessage()               {}
func (*ConnectResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{12} }

func (m *ConnectResult) GetClient() string {
	if m != nil {
		return m.Client
	}
	return ""
}

func (m *ConnectResult) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *ConnectResult) GetExpires() bool {
	if m != nil {
		return m.Expires
	}
	return false
}

func (m *ConnectResult) GetTTL() uint32 {
	if m != nil {
		return m.TTL
	}
	return 0
}

func (m *ConnectResult) GetSubs() map[string]*SubscribeResult {
	if m != nil {
		return m.Subs
	}
	return nil
}

type RefreshRequest struct {
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token"`
}

func (m *RefreshRequest) Reset()                    { *m = RefreshRequest{} }
func (m *RefreshRequest) String() string            { return proto.CompactTextString(m) }
func (*RefreshRequest) ProtoMessage()               {}
func (*RefreshRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{13} }

func (m *RefreshRequest) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

type RefreshResult struct {
	Client  string `protobuf:"bytes,1,opt,name=client,proto3" json:"client"`
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version"`
	Expires bool   `protobuf:"varint,3,opt,name=expires,proto3" json:"expires,omitempty"`
	TTL     uint32 `protobuf:"varint,4,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (m *RefreshResult) Reset()                    { *m = RefreshResult{} }
func (m *RefreshResult) String() string            { return proto.CompactTextString(m) }
func (*RefreshResult) ProtoMessage()               {}
func (*RefreshResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{14} }

func (m *RefreshResult) GetClient() string {
	if m != nil {
		return m.Client
	}
	return ""
}

func (m *RefreshResult) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *RefreshResult) GetExpires() bool {
	if m != nil {
		return m.Expires
	}
	return false
}

func (m *RefreshResult) GetTTL() uint32 {
	if m != nil {
		return m.TTL
	}
	return 0
}

type SubscribeRequest struct {
	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel,omitempty"`
	Token   string `protobuf:"bytes,2,opt,name=token,proto3" json:"token,omitempty"`
	Recover bool   `protobuf:"varint,3,opt,name=recover,proto3" json:"recover,omitempty"`
	Seq     uint32 `protobuf:"varint,4,opt,name=seq,proto3" json:"seq,omitempty"`
	Gen     uint32 `protobuf:"varint,5,opt,name=gen,proto3" json:"gen,omitempty"`
	Epoch   string `protobuf:"bytes,6,opt,name=epoch,proto3" json:"epoch,omitempty"`
	Offset  uint64 `protobuf:"varint,7,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (m *SubscribeRequest) Reset()                    { *m = SubscribeRequest{} }
func (m *SubscribeRequest) String() string            { return proto.CompactTextString(m) }
func (*SubscribeRequest) ProtoMessage()               {}
func (*SubscribeRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{15} }

func (m *SubscribeRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *SubscribeRequest) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *SubscribeRequest) GetRecover() bool {
	if m != nil {
		return m.Recover
	}
	return false
}

func (m *SubscribeRequest) GetSeq() uint32 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *SubscribeRequest) GetGen() uint32 {
	if m != nil {
		return m.Gen
	}
	return 0
}

func (m *SubscribeRequest) GetEpoch() string {
	if m != nil {
		return m.Epoch
	}
	return ""
}

func (m *SubscribeRequest) GetOffset() uint64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type SubscribeResult struct {
	Expires      bool           `protobuf:"varint,1,opt,name=expires,proto3" json:"expires,omitempty"`
	TTL          uint32         `protobuf:"varint,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
	Recoverable  bool           `protobuf:"varint,3,opt,name=recoverable,proto3" json:"recoverable,omitempty"`
	Seq          uint32         `protobuf:"varint,4,opt,name=seq,proto3" json:"seq,omitempty"`
	Gen          uint32         `protobuf:"varint,5,opt,name=gen,proto3" json:"gen,omitempty"`
	Epoch        string         `protobuf:"bytes,6,opt,name=epoch,proto3" json:"epoch,omitempty"`
	Publications []*Publication `protobuf:"bytes,7,rep,name=publications" json:"publications,omitempty"`
	Recovered    bool           `protobuf:"varint,8,opt,name=recovered,proto3" json:"recovered,omitempty"`
	Offset       uint64         `protobuf:"varint,9,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (m *SubscribeResult) Reset()                    { *m = SubscribeResult{} }
func (m *SubscribeResult) String() string            { return proto.CompactTextString(m) }
func (*SubscribeResult) ProtoMessage()               {}
func (*SubscribeResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{16} }

func (m *SubscribeResult) GetExpires() bool {
	if m != nil {
		return m.Expires
	}
	return false
}

func (m *SubscribeResult) GetTTL() uint32 {
	if m != nil {
		return m.TTL
	}
	return 0
}

func (m *SubscribeResult) GetRecoverable() bool {
	if m != nil {
		return m.Recoverable
	}
	return false
}

func (m *SubscribeResult) GetSeq() uint32 {
	if m != nil {
		return m.Seq
	}
	return 0
}

func (m *SubscribeResult) GetGen() uint32 {
	if m != nil {
		return m.Gen
	}
	return 0
}

func (m *SubscribeResult) GetEpoch() string {
	if m != nil {
		return m.Epoch
	}
	return ""
}

func (m *SubscribeResult) GetPublications() []*Publication {
	if m != nil {
		return m.Publications
	}
	return nil
}

func (m *SubscribeResult) GetRecovered() bool {
	if m != nil {
		return m.Recovered
	}
	return false
}

func (m *SubscribeResult) GetOffset() uint64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

type SubRefreshRequest struct {
	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel"`
	Token   string `protobuf:"bytes,2,opt,name=token,proto3" json:"token"`
}

func (m *SubRefreshRequest) Reset()                    { *m = SubRefreshRequest{} }
func (m *SubRefreshRequest) String() string            { return proto.CompactTextString(m) }
func (*SubRefreshRequest) ProtoMessage()               {}
func (*SubRefreshRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{17} }

func (m *SubRefreshRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

func (m *SubRefreshRequest) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

type SubRefreshResult struct {
	Expires bool   `protobuf:"varint,1,opt,name=expires,proto3" json:"expires,omitempty"`
	TTL     uint32 `protobuf:"varint,2,opt,name=ttl,proto3" json:"ttl,omitempty"`
}

func (m *SubRefreshResult) Reset()                    { *m = SubRefreshResult{} }
func (m *SubRefreshResult) String() string            { return proto.CompactTextString(m) }
func (*SubRefreshResult) ProtoMessage()               {}
func (*SubRefreshResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{18} }

func (m *SubRefreshResult) GetExpires() bool {
	if m != nil {
		return m.Expires
	}
	return false
}

func (m *SubRefreshResult) GetTTL() uint32 {
	if m != nil {
		return m.TTL
	}
	return 0
}

type UnsubscribeRequest struct {
	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel"`
}

func (m *UnsubscribeRequest) Reset()                    { *m = UnsubscribeRequest{} }
func (m *UnsubscribeRequest) String() string            { return proto.CompactTextString(m) }
func (*UnsubscribeRequest) ProtoMessage()               {}
func (*UnsubscribeRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{19} }

func (m *UnsubscribeRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type UnsubscribeResult struct {
}

func (m *UnsubscribeResult) Reset()                    { *m = UnsubscribeResult{} }
func (m *UnsubscribeResult) String() string            { return proto.CompactTextString(m) }
func (*UnsubscribeResult) ProtoMessage()               {}
func (*UnsubscribeResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{20} }

type PublishRequest struct {
	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel"`
	Data    Raw    `protobuf:"bytes,2,opt,name=data,proto3,customtype=Raw" json:"data"`
}

func (m *PublishRequest) Reset()                    { *m = PublishRequest{} }
func (m *PublishRequest) String() string            { return proto.CompactTextString(m) }
func (*PublishRequest) ProtoMessage()               {}
func (*PublishRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{21} }

func (m *PublishRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type PublishResult struct {
}

func (m *PublishResult) Reset()                    { *m = PublishResult{} }
func (m *PublishResult) String() string            { return proto.CompactTextString(m) }
func (*PublishResult) ProtoMessage()               {}
func (*PublishResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{22} }

type PresenceRequest struct {
	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel"`
}

func (m *PresenceRequest) Reset()                    { *m = PresenceRequest{} }
func (m *PresenceRequest) String() string            { return proto.CompactTextString(m) }
func (*PresenceRequest) ProtoMessage()               {}
func (*PresenceRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{23} }

func (m *PresenceRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type PresenceResult struct {
	Presence map[string]*ClientInfo `protobuf:"bytes,1,rep,name=presence" json:"presence" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *PresenceResult) Reset()                    { *m = PresenceResult{} }
func (m *PresenceResult) String() string            { return proto.CompactTextString(m) }
func (*PresenceResult) ProtoMessage()               {}
func (*PresenceResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{24} }

func (m *PresenceResult) GetPresence() map[string]*ClientInfo {
	if m != nil {
		return m.Presence
	}
	return nil
}

type PresenceStatsRequest struct {
	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel"`
}

func (m *PresenceStatsRequest) Reset()                    { *m = PresenceStatsRequest{} }
func (m *PresenceStatsRequest) String() string            { return proto.CompactTextString(m) }
func (*PresenceStatsRequest) ProtoMessage()               {}
func (*PresenceStatsRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{25} }

func (m *PresenceStatsRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type PresenceStatsResult struct {
	NumClients uint32 `protobuf:"varint,1,opt,name=num_clients,json=numClients,proto3" json:"num_clients"`
	NumUsers   uint32 `protobuf:"varint,2,opt,name=num_users,json=numUsers,proto3" json:"num_users"`
}

func (m *PresenceStatsResult) Reset()                    { *m = PresenceStatsResult{} }
func (m *PresenceStatsResult) String() string            { return proto.CompactTextString(m) }
func (*PresenceStatsResult) ProtoMessage()               {}
func (*PresenceStatsResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{26} }

func (m *PresenceStatsResult) GetNumClients() uint32 {
	if m != nil {
		return m.NumClients
	}
	return 0
}

func (m *PresenceStatsResult) GetNumUsers() uint32 {
	if m != nil {
		return m.NumUsers
	}
	return 0
}

type HistoryRequest struct {
	Channel string `protobuf:"bytes,1,opt,name=channel,proto3" json:"channel"`
}

func (m *HistoryRequest) Reset()                    { *m = HistoryRequest{} }
func (m *HistoryRequest) String() string            { return proto.CompactTextString(m) }
func (*HistoryRequest) ProtoMessage()               {}
func (*HistoryRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{27} }

func (m *HistoryRequest) GetChannel() string {
	if m != nil {
		return m.Channel
	}
	return ""
}

type HistoryResult struct {
	Publications []*Publication `protobuf:"bytes,1,rep,name=publications" json:"publications"`
}

func (m *HistoryResult) Reset()                    { *m = HistoryResult{} }
func (m *HistoryResult) String() string            { return proto.CompactTextString(m) }
func (*HistoryResult) ProtoMessage()               {}
func (*HistoryResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{28} }

func (m *HistoryResult) GetPublications() []*Publication {
	if m != nil {
		return m.Publications
	}
	return nil
}

type PingRequest struct {
}

func (m *PingRequest) Reset()                    { *m = PingRequest{} }
func (m *PingRequest) String() string            { return proto.CompactTextString(m) }
func (*PingRequest) ProtoMessage()               {}
func (*PingRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{29} }

type PingResult struct {
}

func (m *PingResult) Reset()                    { *m = PingResult{} }
func (m *PingResult) String() string            { return proto.CompactTextString(m) }
func (*PingResult) ProtoMessage()               {}
func (*PingResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{30} }

type RPCRequest struct {
	Data   Raw    `protobuf:"bytes,1,opt,name=data,proto3,customtype=Raw" json:"data"`
	Method string `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
}

func (m *RPCRequest) Reset()                    { *m = RPCRequest{} }
func (m *RPCRequest) String() string            { return proto.CompactTextString(m) }
func (*RPCRequest) ProtoMessage()               {}
func (*RPCRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{31} }

func (m *RPCRequest) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

type RPCResult struct {
	Data Raw `protobuf:"bytes,1,opt,name=data,proto3,customtype=Raw" json:"data,omitempty"`
}

func (m *RPCResult) Reset()                    { *m = RPCResult{} }
func (m *RPCResult) String() string            { return proto.CompactTextString(m) }
func (*RPCResult) ProtoMessage()               {}
func (*RPCResult) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{32} }

type SendRequest struct {
	Data Raw `protobuf:"bytes,1,opt,name=data,proto3,customtype=Raw" json:"data"`
}

func (m *SendRequest) Reset()                    { *m = SendRequest{} }
func (m *SendRequest) String() string            { return proto.CompactTextString(m) }
func (*SendRequest) ProtoMessage()               {}
func (*SendRequest) Descriptor() ([]byte, []int) { return fileDescriptorClient, []int{33} }

func init() {
	proto.RegisterType((*Error)(nil), "protocol.Error")
	proto.RegisterType((*Command)(nil), "protocol.Command")
	proto.RegisterType((*Reply)(nil), "protocol.Reply")
	proto.RegisterType((*Push)(nil), "protocol.Push")
	proto.RegisterType((*ClientInfo)(nil), "protocol.ClientInfo")
	proto.RegisterType((*Publication)(nil), "protocol.Publication")
	proto.RegisterType((*Join)(nil), "protocol.Join")
	proto.RegisterType((*Leave)(nil), "protocol.Leave")
	proto.RegisterType((*Unsub)(nil), "protocol.Unsub")
	proto.RegisterType((*Sub)(nil), "protocol.Sub")
	proto.RegisterType((*Message)(nil), "protocol.Message")
	proto.RegisterType((*ConnectRequest)(nil), "protocol.ConnectRequest")
	proto.RegisterType((*ConnectResult)(nil), "protocol.ConnectResult")
	proto.RegisterType((*RefreshRequest)(nil), "protocol.RefreshRequest")
	proto.RegisterType((*RefreshResult)(nil), "protocol.RefreshResult")
	proto.RegisterType((*SubscribeRequest)(nil), "protocol.SubscribeRequest")
	proto.RegisterType((*SubscribeResult)(nil), "protocol.SubscribeResult")
	proto.RegisterType((*SubRefreshRequest)(nil), "protocol.SubRefreshRequest")
	proto.RegisterType((*SubRefreshResult)(nil), "protocol.SubRefreshResult")
	proto.RegisterType((*UnsubscribeRequest)(nil), "protocol.UnsubscribeRequest")
	proto.RegisterType((*UnsubscribeResult)(nil), "protocol.UnsubscribeResult")
	proto.RegisterType((*PublishRequest)(nil), "protocol.PublishRequest")
	proto.RegisterType((*PublishResult)(nil), "protocol.PublishResult")
	proto.RegisterType((*PresenceRequest)(nil), "protocol.PresenceRequest")
	proto.RegisterType((*PresenceResult)(nil), "protocol.PresenceResult")
	proto.RegisterType((*PresenceStatsRequest)(nil), "protocol.PresenceStatsRequest")
	proto.RegisterType((*PresenceStatsResult)(nil), "protocol.PresenceStatsResult")
	proto.RegisterType((*HistoryRequest)(nil), "protocol.HistoryRequest")
	proto.RegisterType((*HistoryResult)(nil), "protocol.HistoryResult")
	proto.RegisterType((*PingRequest)(nil), "protocol.PingRequest")
	proto.RegisterType((*PingResult)(nil), "protocol.PingResult")
	proto.RegisterType((*RPCRequest)(nil), "protocol.RPCRequest")
	proto.RegisterType((*RPCResult)(nil), "protocol.RPCResult")
	proto.RegisterType((*SendRequest)(nil), "protocol.SendRequest")
	proto.RegisterEnum("protocol.MethodType", MethodType_name, MethodType_value)
	proto.RegisterEnum("protocol.PushType", PushType_name, PushType_value)
}
func (this *Error) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Error)
	if !ok {
		that2, ok := that.(Error)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Code != that1.Code {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *Command) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Command)
	if !ok {
		that2, ok := that.(Command)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ID != that1.ID {
		return false
	}
	if this.Method != that1.Method {
		return false
	}
	if !this.Params.Equal(that1.Params) {
		return false
	}
	return true
}
func (this *Reply) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Reply)
	if !ok {
		that2, ok := that.(Reply)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ID != that1.ID {
		return false
	}
	if !this.Error.Equal(that1.Error) {
		return false
	}
	if !this.Result.Equal(that1.Result) {
		return false
	}
	return true
}
func (this *Push) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Push)
	if !ok {
		that2, ok := that.(Push)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Channel != that1.Channel {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	return true
}
func (this *ClientInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ClientInfo)
	if !ok {
		that2, ok := that.(ClientInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if this.Client != that1.Client {
		return false
	}
	if !this.ConnInfo.Equal(that1.ConnInfo) {
		return false
	}
	if !this.ChanInfo.Equal(that1.ChanInfo) {
		return false
	}
	return true
}
func (this *Publication) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Publication)
	if !ok {
		that2, ok := that.(Publication)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Seq != that1.Seq {
		return false
	}
	if this.Gen != that1.Gen {
		return false
	}
	if this.UID != that1.UID {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	if !this.Info.Equal(that1.Info) {
		return false
	}
	if this.Offset != that1.Offset {
		return false
	}
	return true
}
func (this *Join) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Join)
	if !ok {
		that2, ok := that.(Join)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Info.Equal(&that1.Info) {
		return false
	}
	return true
}
func (this *Leave) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Leave)
	if !ok {
		that2, ok := that.(Leave)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Info.Equal(&that1.Info) {
		return false
	}
	return true
}
func (this *Unsub) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Unsub)
	if !ok {
		that2, ok := that.(Unsub)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Resubscribe != that1.Resubscribe {
		return false
	}
	return true
}
func (this *Sub) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Sub)
	if !ok {
		that2, ok := that.(Sub)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Recoverable != that1.Recoverable {
		return false
	}
	if this.Seq != that1.Seq {
		return false
	}
	if this.Gen != that1.Gen {
		return false
	}
	if this.Epoch != that1.Epoch {
		return false
	}
	if this.Offset != that1.Offset {
		return false
	}
	return true
}
func (this *Message) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Message)
	if !ok {
		that2, ok := that.(Message)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	return true
}
func (this *ConnectRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConnectRequest)
	if !ok {
		that2, ok := that.(ConnectRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Token != that1.Token {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	if len(this.Subs) != len(that1.Subs) {
		return false
	}
	for i := range this.Subs {
		if !this.Subs[i].Equal(that1.Subs[i]) {
			return false
		}
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	return true
}
func (this *ConnectResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConnectResult)
	if !ok {
		that2, ok := that.(ConnectResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Client != that1.Client {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.Expires != that1.Expires {
		return false
	}
	if this.TTL != that1.TTL {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	if len(this.Subs) != len(that1.Subs) {
		return false
	}
	for i := range this.Subs {
		if !this.Subs[i].Equal(that1.Subs[i]) {
			return false
		}
	}
	return true
}
func (this *RefreshRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshRequest)
	if !ok {
		that2, ok := that.(RefreshRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Token != that1.Token {
		return false
	}
	return true
}
func (this *RefreshResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RefreshResult)
	if !ok {
		that2, ok := that.(RefreshResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Client != that1.Client {
		return false
	}
	if this.Version != that1.Version {
		return false
	}
	if this.Expires != that1.Expires {
		return false
	}
	if this.TTL != that1.TTL {
		return false
	}
	return true
}
func (this *SubscribeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SubscribeRequest)
	if !ok {
		that2, ok := that.(SubscribeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Channel != that1.Channel {
		return false
	}
	if this.Token != that1.Token {
		return false
	}
	if this.Recover != that1.Recover {
		return false
	}
	if this.Seq != that1.Seq {
		return false
	}
	if this.Gen != that1.Gen {
		return false
	}
	if this.Epoch != that1.Epoch {
		return false
	}
	if this.Offset != that1.Offset {
		return false
	}
	return true
}
func (this *SubscribeResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SubscribeResult)
	if !ok {
		that2, ok := that.(SubscribeResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Expires != that1.Expires {
		return false
	}
	if this.TTL != that1.TTL {
		return false
	}
	if this.Recoverable != that1.Recoverable {
		return false
	}
	if this.Seq != that1.Seq {
		return false
	}
	if this.Gen != that1.Gen {
		return false
	}
	if this.Epoch != that1.Epoch {
		return false
	}
	if len(this.Publications) != len(that1.Publications) {
		return false
	}
	for i := range this.Publications {
		if !this.Publications[i].Equal(that1.Publications[i]) {
			return false
		}
	}
	if this.Recovered != that1.Recovered {
		return false
	}
	if this.Offset != that1.Offset {
		return false
	}
	return true
}
func (this *SubRefreshRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SubRefreshRequest)
	if !ok {
		that2, ok := that.(SubRefreshRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Channel != that1.Channel {
		return false
	}
	if this.Token != that1.Token {
		return false
	}
	return true
}
func (this *SubRefreshResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SubRefreshResult)
	if !ok {
		that2, ok := that.(SubRefreshResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Expires != that1.Expires {
		return false
	}
	if this.TTL != that1.TTL {
		return false
	}
	return true
}
func (this *UnsubscribeRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UnsubscribeRequest)
	if !ok {
		that2, ok := that.(UnsubscribeRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Channel != that1.Channel {
		return false
	}
	return true
}
func (this *UnsubscribeResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UnsubscribeResult)
	if !ok {
		that2, ok := that.(UnsubscribeResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *PublishRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PublishRequest)
	if !ok {
		that2, ok := that.(PublishRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Channel != that1.Channel {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	return true
}
func (this *PublishResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PublishResult)
	if !ok {
		that2, ok := that.(PublishResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *PresenceRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PresenceRequest)
	if !ok {
		that2, ok := that.(PresenceRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Channel != that1.Channel {
		return false
	}
	return true
}
func (this *PresenceResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PresenceResult)
	if !ok {
		that2, ok := that.(PresenceResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Presence) != len(that1.Presence) {
		return false
	}
	for i := range this.Presence {
		if !this.Presence[i].Equal(that1.Presence[i]) {
			return false
		}
	}
	return true
}
func (this *PresenceStatsRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PresenceStatsRequest)
	if !ok {
		that2, ok := that.(PresenceStatsRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Channel != that1.Channel {
		return false
	}
	return true
}
func (this *PresenceStatsResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PresenceStatsResult)
	if !ok {
		that2, ok := that.(PresenceStatsResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NumClients != that1.NumClients {
		return false
	}
	if this.NumUsers != that1.NumUsers {
		return false
	}
	return true
}
func (this *HistoryRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryRequest)
	if !ok {
		that2, ok := that.(HistoryRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Channel != that1.Channel {
		return false
	}
	return true
}
func (this *HistoryResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HistoryResult)
	if !ok {
		that2, ok := that.(HistoryResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Publications) != len(that1.Publications) {
		return false
	}
	for i := range this.Publications {
		if !this.Publications[i].Equal(that1.Publications[i]) {
			return false
		}
	}
	return true
}
func (this *PingRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PingRequest)
	if !ok {
		that2, ok := that.(PingRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *PingResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PingResult)
	if !ok {
		that2, ok := that.(PingResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *RPCRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RPCRequest)
	if !ok {
		that2, ok := that.(RPCRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	if this.Method != that1.Method {
		return false
	}
	return true
}
func (this *RPCResult) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*RPCResult)
	if !ok {
		that2, ok := that.(RPCResult)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	return true
}
func (this *SendRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SendRequest)
	if !ok {
		that2, ok := that.(SendRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Data.Equal(that1.Data) {
		return false
	}
	return true
}
func (m *Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Code))
	}
	if len(m.Message) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Message)))
		i += copy(dAtA[i:], m.Message)
	}
	return i, nil
}

func (m *Command) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Command) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.ID))
	}
	if m.Method != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Method))
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Params.Size()))
	n1, err := m.Params.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *Reply) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Reply) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.ID))
	}
	if m.Error != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Error.Size()))
		n2, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Result.Size()))
	n3, err := m.Result.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	return i, nil
}

func (m *Push) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Push) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Type))
	}
	if len(m.Channel) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Channel)))
		i += copy(dAtA[i:], m.Channel)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Data.Size()))
	n4, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	return i, nil
}

func (m *ClientInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClientInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.User) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.User)))
		i += copy(dAtA[i:], m.User)
	}
	if len(m.Client) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Client)))
		i += copy(dAtA[i:], m.Client)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.ConnInfo.Size()))
	n5, err := m.ConnInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x22
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.ChanInfo.Size()))
	n6, err := m.ChanInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	return i, nil
}

func (m *Publication) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Publication) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Seq != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Seq))
	}
	if m.Gen != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Gen))
	}
	if len(m.UID) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.UID)))
		i += copy(dAtA[i:], m.UID)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Data.Size()))
	n7, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	if m.Info != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Info.Size()))
		n8, err := m.Info.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Offset != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Offset))
	}
	return i, nil
}

func (m *Join) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Join) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Info.Size()))
	n9, err := m.Info.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	return i, nil
}

func (m *Leave) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Leave) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Info.Size()))
	n10, err := m.Info.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	return i, nil
}

func (m *Unsub) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Unsub) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Resubscribe {
		dAtA[i] = 0x8
		i++
		if m.Resubscribe {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Sub) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Sub) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Recoverable {
		dAtA[i] = 0x8
		i++
		if m.Recoverable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Seq != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Seq))
	}
	if m.Gen != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Gen))
	}
	if len(m.Epoch) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Epoch)))
		i += copy(dAtA[i:], m.Epoch)
	}
	if m.Offset != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Offset))
	}
	return i, nil
}

func (m *Message) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Message) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Data.Size()))
	n11, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func (m *ConnectRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Token) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Token)))
		i += copy(dAtA[i:], m.Token)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Data.Size()))
	n12, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	if len(m.Subs) > 0 {
		for k, _ := range m.Subs {
			dAtA[i] = 0x1a
			i++
			v := m.Subs[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovClient(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovClient(uint64(len(k))) + msgSize
			i = encodeVarintClient(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintClient(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintClient(dAtA, i, uint64(v.Size()))
				n13, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n13
			}
		}
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	return i, nil
}

func (m *ConnectResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Client) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Client)))
		i += copy(dAtA[i:], m.Client)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	if m.Expires {
		dAtA[i] = 0x18
		i++
		if m.Expires {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.TTL != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.TTL))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Data.Size()))
	n14, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	if len(m.Subs) > 0 {
		for k, _ := range m.Subs {
			dAtA[i] = 0x32
			i++
			v := m.Subs[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovClient(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovClient(uint64(len(k))) + msgSize
			i = encodeVarintClient(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintClient(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintClient(dAtA, i, uint64(v.Size()))
				n15, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n15
			}
		}
	}
	return i, nil
}

func (m *RefreshRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Token) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Token)))
		i += copy(dAtA[i:], m.Token)
	}
	return i, nil
}

func (m *RefreshResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RefreshResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Client) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Client)))
		i += copy(dAtA[i:], m.Client)
	}
	if len(m.Version) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Version)))
		i += copy(dAtA[i:], m.Version)
	}
	if m.Expires {
		dAtA[i] = 0x18
		i++
		if m.Expires {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.TTL != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.TTL))
	}
	return i, nil
}

func (m *SubscribeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubscribeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Channel)))
		i += copy(dAtA[i:], m.Channel)
	}
	if len(m.Token) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Token)))
		i += copy(dAtA[i:], m.Token)
	}
	if m.Recover {
		dAtA[i] = 0x18
		i++
		if m.Recover {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Seq != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Seq))
	}
	if m.Gen != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Gen))
	}
	if len(m.Epoch) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Epoch)))
		i += copy(dAtA[i:], m.Epoch)
	}
	if m.Offset != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Offset))
	}
	return i, nil
}

func (m *SubscribeResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubscribeResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Expires {
		dAtA[i] = 0x8
		i++
		if m.Expires {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.TTL != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.TTL))
	}
	if m.Recoverable {
		dAtA[i] = 0x18
		i++
		if m.Recoverable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Seq != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Seq))
	}
	if m.Gen != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Gen))
	}
	if len(m.Epoch) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Epoch)))
		i += copy(dAtA[i:], m.Epoch)
	}
	if len(m.Publications) > 0 {
		for _, msg := range m.Publications {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintClient(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Recovered {
		dAtA[i] = 0x40
		i++
		if m.Recovered {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Offset != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.Offset))
	}
	return i, nil
}

func (m *SubRefreshRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubRefreshRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Channel)))
		i += copy(dAtA[i:], m.Channel)
	}
	if len(m.Token) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Token)))
		i += copy(dAtA[i:], m.Token)
	}
	return i, nil
}

func (m *SubRefreshResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubRefreshResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Expires {
		dAtA[i] = 0x8
		i++
		if m.Expires {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.TTL != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.TTL))
	}
	return i, nil
}

func (m *UnsubscribeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnsubscribeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Channel)))
		i += copy(dAtA[i:], m.Channel)
	}
	return i, nil
}

func (m *UnsubscribeResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnsubscribeResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *PublishRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PublishRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Channel)))
		i += copy(dAtA[i:], m.Channel)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Data.Size()))
	n16, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	return i, nil
}

func (m *PublishResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PublishResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *PresenceRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PresenceRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Channel)))
		i += copy(dAtA[i:], m.Channel)
	}
	return i, nil
}

func (m *PresenceResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PresenceResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Presence) > 0 {
		for k, _ := range m.Presence {
			dAtA[i] = 0xa
			i++
			v := m.Presence[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovClient(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovClient(uint64(len(k))) + msgSize
			i = encodeVarintClient(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintClient(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintClient(dAtA, i, uint64(v.Size()))
				n17, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n17
			}
		}
	}
	return i, nil
}

func (m *PresenceStatsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PresenceStatsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Channel)))
		i += copy(dAtA[i:], m.Channel)
	}
	return i, nil
}

func (m *PresenceStatsResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PresenceStatsResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NumClients != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.NumClients))
	}
	if m.NumUsers != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintClient(dAtA, i, uint64(m.NumUsers))
	}
	return i, nil
}

func (m *HistoryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Channel) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Channel)))
		i += copy(dAtA[i:], m.Channel)
	}
	return i, nil
}

func (m *HistoryResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HistoryResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Publications) > 0 {
		for _, msg := range m.Publications {
			dAtA[i] = 0xa
			i++
			i = encodeVarintClient(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *PingRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PingRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *PingResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PingResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RPCRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RPCRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Data.Size()))
	n18, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	if len(m.Method) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintClient(dAtA, i, uint64(len(m.Method)))
		i += copy(dAtA[i:], m.Method)
	}
	return i, nil
}

func (m *RPCResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RPCResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Data.Size()))
	n19, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	return i, nil
}

func (m *SendRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SendRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintClient(dAtA, i, uint64(m.Data.Size()))
	n20, err := m.Data.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	return i, nil
}

func encodeVarintClient(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedError(r randyClient, easy bool) *Error {
	this := &Error{}
	this.Code = uint32(r.Uint32())
	this.Message = string(randStringClient(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedCommand(r randyClient, easy bool) *Command {
	this := &Command{}
	this.ID = uint32(r.Uint32())
	this.Method = MethodType([]int32{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}[r.Intn(12)])
	v1 := NewPopulatedRaw(r)
	this.Params = *v1
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedReply(r randyClient, easy bool) *Reply {
	this := &Reply{}
	this.ID = uint32(r.Uint32())
	if r.Intn(10) != 0 {
		this.Error = NewPopulatedError(r, easy)
	}
	v2 := NewPopulatedRaw(r)
	this.Result = *v2
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPush(r randyClient, easy bool) *Push {
	this := &Push{}
	this.Type = PushType([]int32{0, 1, 2, 3, 4, 5}[r.Intn(6)])
	this.Channel = string(randStringClient(r))
	v3 := NewPopulatedRaw(r)
	this.Data = *v3
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedClientInfo(r randyClient, easy bool) *ClientInfo {
	this := &ClientInfo{}
	this.User = string(randStringClient(r))
	this.Client = string(randStringClient(r))
	v4 := NewPopulatedRaw(r)
	this.ConnInfo = *v4
	v5 := NewPopulatedRaw(r)
	this.ChanInfo = *v5
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPublication(r randyClient, easy bool) *Publication {
	this := &Publication{}
	this.Seq = uint32(r.Uint32())
	this.Gen = uint32(r.Uint32())
	this.UID = string(randStringClient(r))
	v6 := NewPopulatedRaw(r)
	this.Data = *v6
	if r.Intn(10) != 0 {
		this.Info = NewPopulatedClientInfo(r, easy)
	}
	this.Offset = uint64(uint64(r.Uint32()))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedJoin(r randyClient, easy bool) *Join {
	this := &Join{}
	v7 := NewPopulatedClientInfo(r, easy)
	this.Info = *v7
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedLeave(r randyClient, easy bool) *Leave {
	this := &Leave{}
	v8 := NewPopulatedClientInfo(r, easy)
	this.Info = *v8
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedUnsub(r randyClient, easy bool) *Unsub {
	this := &Unsub{}
	this.Resubscribe = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSub(r randyClient, easy bool) *Sub {
	this := &Sub{}
	this.Recoverable = bool(bool(r.Intn(2) == 0))
	this.Seq = uint32(r.Uint32())
	this.Gen = uint32(r.Uint32())
	this.Epoch = string(randStringClient(r))
	this.Offset = uint64(uint64(r.Uint32()))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMessage(r randyClient, easy bool) *Message {
	this := &Message{}
	v9 := NewPopulatedRaw(r)
	this.Data = *v9
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedConnectRequest(r randyClient, easy bool) *ConnectRequest {
	this := &ConnectRequest{}
	this.Token = string(randStringClient(r))
	v10 := NewPopulatedRaw(r)
	this.Data = *v10
	if r.Intn(10) != 0 {
		v11 := r.Intn(10)
		this.Subs = make(map[string]*SubscribeRequest)
		for i := 0; i < v11; i++ {
			this.Subs[randStringClient(r)] = NewPopulatedSubscribeRequest(r, easy)
		}
	}
	this.Name = string(randStringClient(r))
	this.Version = string(randStringClient(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedConnectResult(r randyClient, easy bool) *ConnectResult {
	this := &ConnectResult{}
	this.Client = string(randStringClient(r))
	this.Version = string(randStringClient(r))
	this.Expires = bool(bool(r.Intn(2) == 0))
	this.TTL = uint32(r.Uint32())
	v12 := NewPopulatedRaw(r)
	this.Data = *v12
	if r.Intn(10) != 0 {
		v13 := r.Intn(10)
		this.Subs = make(map[string]*SubscribeResult)
		for i := 0; i < v13; i++ {
			this.Subs[randStringClient(r)] = NewPopulatedSubscribeResult(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedRefreshRequest(r randyClient, easy bool) *RefreshRequest {
	this := &RefreshRequest{}
	this.Token = string(randStringClient(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedRefreshResult(r randyClient, easy bool) *RefreshResult {
	this := &RefreshResult{}
	this.Client = string(randStringClient(r))
	this.Version = string(randStringClient(r))
	this.Expires = bool(bool(r.Intn(2) == 0))
	this.TTL = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSubscribeRequest(r randyClient, easy bool) *SubscribeRequest {
	this := &SubscribeRequest{}
	this.Channel = string(randStringClient(r))
	this.Token = string(randStringClient(r))
	this.Recover = bool(bool(r.Intn(2) == 0))
	this.Seq = uint32(r.Uint32())
	this.Gen = uint32(r.Uint32())
	this.Epoch = string(randStringClient(r))
	this.Offset = uint64(uint64(r.Uint32()))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSubscribeResult(r randyClient, easy bool) *SubscribeResult {
	this := &SubscribeResult{}
	this.Expires = bool(bool(r.Intn(2) == 0))
	this.TTL = uint32(r.Uint32())
	this.Recoverable = bool(bool(r.Intn(2) == 0))
	this.Seq = uint32(r.Uint32())
	this.Gen = uint32(r.Uint32())
	this.Epoch = string(randStringClient(r))
	if r.Intn(10) != 0 {
		v14 := r.Intn(5)
		this.Publications = make([]*Publication, v14)
		for i := 0; i < v14; i++ {
			this.Publications[i] = NewPopulatedPublication(r, easy)
		}
	}
	this.Recovered = bool(bool(r.Intn(2) == 0))
	this.Offset = uint64(uint64(r.Uint32()))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSubRefreshRequest(r randyClient, easy bool) *SubRefreshRequest {
	this := &SubRefreshRequest{}
	this.Channel = string(randStringClient(r))
	this.Token = string(randStringClient(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSubRefreshResult(r randyClient, easy bool) *SubRefreshResult {
	this := &SubRefreshResult{}
	this.Expires = bool(bool(r.Intn(2) == 0))
	this.TTL = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedUnsubscribeRequest(r randyClient, easy bool) *UnsubscribeRequest {
	this := &UnsubscribeRequest{}
	this.Channel = string(randStringClient(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedUnsubscribeResult(r randyClient, easy bool) *UnsubscribeResult {
	this := &UnsubscribeResult{}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPublishRequest(r randyClient, easy bool) *PublishRequest {
	this := &PublishRequest{}
	this.Channel = string(randStringClient(r))
	v15 := NewPopulatedRaw(r)
	this.Data = *v15
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPublishResult(r randyClient, easy bool) *PublishResult {
	this := &PublishResult{}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPresenceRequest(r randyClient, easy bool) *PresenceRequest {
	this := &PresenceRequest{}
	this.Channel = string(randStringClient(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPresenceResult(r randyClient, easy bool) *PresenceResult {
	this := &PresenceResult{}
	if r.Intn(10) != 0 {
		v16 := r.Intn(10)
		this.Presence = make(map[string]*ClientInfo)
		for i := 0; i < v16; i++ {
			this.Presence[randStringClient(r)] = NewPopulatedClientInfo(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPresenceStatsRequest(r randyClient, easy bool) *PresenceStatsRequest {
	this := &PresenceStatsRequest{}
	this.Channel = string(randStringClient(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPresenceStatsResult(r randyClient, easy bool) *PresenceStatsResult {
	this := &PresenceStatsResult{}
	this.NumClients = uint32(r.Uint32())
	this.NumUsers = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedHistoryRequest(r randyClient, easy bool) *HistoryRequest {
	this := &HistoryRequest{}
	this.Channel = string(randStringClient(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedHistoryResult(r randyClient, easy bool) *HistoryResult {
	this := &HistoryResult{}
	if r.Intn(10) != 0 {
		v17 := r.Intn(5)
		this.Publications = make([]*Publication, v17)
		for i := 0; i < v17; i++ {
			this.Publications[i] = NewPopulatedPublication(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPingRequest(r randyClient, easy bool) *PingRequest {
	this := &PingRequest{}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedPingResult(r randyClient, easy bool) *PingResult {
	this := &PingResult{}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedRPCRequest(r randyClient, easy bool) *RPCRequest {
	this := &RPCRequest{}
	v18 := NewPopulatedRaw(r)
	this.Data = *v18
	this.Method = string(randStringClient(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedRPCResult(r randyClient, easy bool) *RPCResult {
	this := &RPCResult{}
	v19 := NewPopulatedRaw(r)
	this.Data = *v19
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSendRequest(r randyClient, easy bool) *SendRequest {
	this := &SendRequest{}
	v20 := NewPopulatedRaw(r)
	this.Data = *v20
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyClient interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneClient(r randyClient) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringClient(r randyClient) string {
	v21 := r.Intn(100)
	tmps := make([]rune, v21)
	for i := 0; i < v21; i++ {
		tmps[i] = randUTF8RuneClient(r)
	}
	return string(tmps)
}
func randUnrecognizedClient(r randyClient, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldClient(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldClient(dAtA []byte, r randyClient, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateClient(dAtA, uint64(key))
		v22 := r.Int63()
		if r.Intn(2) == 0 {
			v22 *= -1
		}
		dAtA = encodeVarintPopulateClient(dAtA, uint64(v22))
	case 1:
		dAtA = encodeVarintPopulateClient(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateClient(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateClient(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateClient(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateClient(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Error) Size() (n int) {
	var l int
	_ = l
	if m.Code != 0 {
		n += 1 + sovClient(uint64(m.Code))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	return n
}

func (m *Command) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovClient(uint64(m.ID))
	}
	if m.Method != 0 {
		n += 1 + sovClient(uint64(m.Method))
	}
	l = m.Params.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func (m *Reply) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovClient(uint64(m.ID))
	}
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovClient(uint64(l))
	}
	l = m.Result.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func (m *Push) Size() (n int) {
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovClient(uint64(m.Type))
	}
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = m.Data.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func (m *ClientInfo) Size() (n int) {
	var l int
	_ = l
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = len(m.Client)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = m.ConnInfo.Size()
	n += 1 + l + sovClient(uint64(l))
	l = m.ChanInfo.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func (m *Publication) Size() (n int) {
	var l int
	_ = l
	if m.Seq != 0 {
		n += 1 + sovClient(uint64(m.Seq))
	}
	if m.Gen != 0 {
		n += 1 + sovClient(uint64(m.Gen))
	}
	l = len(m.UID)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = m.Data.Size()
	n += 1 + l + sovClient(uint64(l))
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovClient(uint64(l))
	}
	if m.Offset != 0 {
		n += 1 + sovClient(uint64(m.Offset))
	}
	return n
}

func (m *Join) Size() (n int) {
	var l int
	_ = l
	l = m.Info.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func (m *Leave) Size() (n int) {
	var l int
	_ = l
	l = m.Info.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func (m *Unsub) Size() (n int) {
	var l int
	_ = l
	if m.Resubscribe {
		n += 2
	}
	return n
}

func (m *Sub) Size() (n int) {
	var l int
	_ = l
	if m.Recoverable {
		n += 2
	}
	if m.Seq != 0 {
		n += 1 + sovClient(uint64(m.Seq))
	}
	if m.Gen != 0 {
		n += 1 + sovClient(uint64(m.Gen))
	}
	l = len(m.Epoch)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	if m.Offset != 0 {
		n += 1 + sovClient(uint64(m.Offset))
	}
	return n
}

func (m *Message) Size() (n int) {
	var l int
	_ = l
	l = m.Data.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func (m *ConnectRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = m.Data.Size()
	n += 1 + l + sovClient(uint64(l))
	if len(m.Subs) > 0 {
		for k, v := range m.Subs {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovClient(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovClient(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovClient(uint64(mapEntrySize))
		}
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	return n
}

func (m *ConnectResult) Size() (n int) {
	var l int
	_ = l
	l = len(m.Client)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	if m.Expires {
		n += 2
	}
	if m.TTL != 0 {
		n += 1 + sovClient(uint64(m.TTL))
	}
	l = m.Data.Size()
	n += 1 + l + sovClient(uint64(l))
	if len(m.Subs) > 0 {
		for k, v := range m.Subs {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovClient(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovClient(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovClient(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *RefreshRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	return n
}

func (m *RefreshResult) Size() (n int) {
	var l int
	_ = l
	l = len(m.Client)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	if m.Expires {
		n += 2
	}
	if m.TTL != 0 {
		n += 1 + sovClient(uint64(m.TTL))
	}
	return n
}

func (m *SubscribeRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	if m.Recover {
		n += 2
	}
	if m.Seq != 0 {
		n += 1 + sovClient(uint64(m.Seq))
	}
	if m.Gen != 0 {
		n += 1 + sovClient(uint64(m.Gen))
	}
	l = len(m.Epoch)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	if m.Offset != 0 {
		n += 1 + sovClient(uint64(m.Offset))
	}
	return n
}

func (m *SubscribeResult) Size() (n int) {
	var l int
	_ = l
	if m.Expires {
		n += 2
	}
	if m.TTL != 0 {
		n += 1 + sovClient(uint64(m.TTL))
	}
	if m.Recoverable {
		n += 2
	}
	if m.Seq != 0 {
		n += 1 + sovClient(uint64(m.Seq))
	}
	if m.Gen != 0 {
		n += 1 + sovClient(uint64(m.Gen))
	}
	l = len(m.Epoch)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	if len(m.Publications) > 0 {
		for _, e := range m.Publications {
			l = e.Size()
			n += 1 + l + sovClient(uint64(l))
		}
	}
	if m.Recovered {
		n += 2
	}
	if m.Offset != 0 {
		n += 1 + sovClient(uint64(m.Offset))
	}
	return n
}

func (m *SubRefreshRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	return n
}

func (m *SubRefreshResult) Size() (n int) {
	var l int
	_ = l
	if m.Expires {
		n += 2
	}
	if m.TTL != 0 {
		n += 1 + sovClient(uint64(m.TTL))
	}
	return n
}

func (m *UnsubscribeRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	return n
}

func (m *UnsubscribeResult) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *PublishRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	l = m.Data.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func (m *PublishResult) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *PresenceRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	return n
}

func (m *PresenceResult) Size() (n int) {
	var l int
	_ = l
	if len(m.Presence) > 0 {
		for k, v := range m.Presence {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovClient(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovClient(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovClient(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *PresenceStatsRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	return n
}

func (m *PresenceStatsResult) Size() (n int) {
	var l int
	_ = l
	if m.NumClients != 0 {
		n += 1 + sovClient(uint64(m.NumClients))
	}
	if m.NumUsers != 0 {
		n += 1 + sovClient(uint64(m.NumUsers))
	}
	return n
}

func (m *HistoryRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Channel)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	return n
}

func (m *HistoryResult) Size() (n int) {
	var l int
	_ = l
	if len(m.Publications) > 0 {
		for _, e := range m.Publications {
			l = e.Size()
			n += 1 + l + sovClient(uint64(l))
		}
	}
	return n
}

func (m *PingRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *PingResult) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *RPCRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Data.Size()
	n += 1 + l + sovClient(uint64(l))
	l = len(m.Method)
	if l > 0 {
		n += 1 + l + sovClient(uint64(l))
	}
	return n
}

func (m *RPCResult) Size() (n int) {
	var l int
	_ = l
	l = m.Data.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func (m *SendRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Data.Size()
	n += 1 + l + sovClient(uint64(l))
	return n
}

func sovClient(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozClient(x uint64) (n int) {
	return sovClient(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Command) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Command: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Command: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= (MethodType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Params", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Params.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Reply) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reply: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reply: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Push) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Push: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Push: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (PushType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClientInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClientInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClientInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Client", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Client = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnInfo", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ConnInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChanInfo", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChanInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Publication) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Publication: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Publication: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seq", wireType)
			}
			m.Seq = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seq |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gen", wireType)
			}
			m.Gen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Gen |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &ClientInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Join) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Join: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Join: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Leave) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Leave: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Leave: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Unsub) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Unsub: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Unsub: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resubscribe", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Resubscribe = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Sub) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Sub: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Sub: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Recoverable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Recoverable = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seq", wireType)
			}
			m.Seq = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seq |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gen", wireType)
			}
			m.Gen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Gen |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Epoch = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Message) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Message: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Message: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subs == nil {
				m.Subs = make(map[string]*SubscribeRequest)
			}
			var mapkey string
			var mapvalue *SubscribeRequest
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowClient
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClient
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthClient
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClient
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthClient
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthClient
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &SubscribeRequest{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipClient(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthClient
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Subs[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Client", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Client = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Expires = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTL", wireType)
			}
			m.TTL = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TTL |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subs == nil {
				m.Subs = make(map[string]*SubscribeResult)
			}
			var mapkey string
			var mapvalue *SubscribeResult
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowClient
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClient
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthClient
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClient
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthClient
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthClient
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &SubscribeResult{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipClient(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthClient
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Subs[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RefreshResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RefreshResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RefreshResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Client", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Client = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Expires = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTL", wireType)
			}
			m.TTL = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TTL |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubscribeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubscribeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubscribeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Recover", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Recover = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seq", wireType)
			}
			m.Seq = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seq |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gen", wireType)
			}
			m.Gen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Gen |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Epoch = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubscribeResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubscribeResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubscribeResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Expires = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTL", wireType)
			}
			m.TTL = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TTL |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Recoverable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Recoverable = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seq", wireType)
			}
			m.Seq = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Seq |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gen", wireType)
			}
			m.Gen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Gen |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Epoch = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Publications", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Publications = append(m.Publications, &Publication{})
			if err := m.Publications[len(m.Publications)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Recovered", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Recovered = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubRefreshRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubRefreshRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubRefreshRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubRefreshResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubRefreshResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubRefreshResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expires", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Expires = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTL", wireType)
			}
			m.TTL = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TTL |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnsubscribeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnsubscribeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnsubscribeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnsubscribeResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnsubscribeResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnsubscribeResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PublishRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PublishRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PublishRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PublishResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PublishResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PublishResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PresenceRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PresenceRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PresenceRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PresenceResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PresenceResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PresenceResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Presence", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Presence == nil {
				m.Presence = make(map[string]*ClientInfo)
			}
			var mapkey string
			var mapvalue *ClientInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowClient
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClient
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthClient
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowClient
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthClient
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthClient
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &ClientInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipClient(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthClient
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Presence[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PresenceStatsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PresenceStatsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PresenceStatsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PresenceStatsResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PresenceStatsResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PresenceStatsResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumClients", wireType)
			}
			m.NumClients = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumClients |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumUsers", wireType)
			}
			m.NumUsers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumUsers |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Channel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Channel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HistoryResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HistoryResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HistoryResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Publications", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Publications = append(m.Publications, &Publication{})
			if err := m.Publications[len(m.Publications)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PingRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PingRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PingRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PingResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PingResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PingResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RPCRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RPCRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RPCRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Method = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RPCResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RPCResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RPCResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SendRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowClient
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SendRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SendRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowClient
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthClient
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Data.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipClient(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthClient
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipClient(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowClient
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClient
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowClient
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthClient
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowClient
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipClient(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthClient = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowClient   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("client.proto", fileDescriptorClient) }

var fileDescriptorClient = []byte{
	// 1796 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0xdd, 0x6f, 0xe3, 0x58,
	0x15, 0xaf, 0xe3, 0x7c, 0x9e, 0x34, 0xa9, 0x7b, 0x3b, 0x9d, 0xc9, 0x98, 0x52, 0x1b, 0xc3, 0xcc,
	0x76, 0xab, 0xa5, 0xdd, 0x29, 0x62, 0x77, 0x35, 0x0b, 0xbb, 0x9a, 0x64, 0xc2, 0x4e, 0x86, 0x4e,
	0x27, 0xd8, 0x2d, 0x12, 0x02, 0x69, 0xc8, 0xc7, 0x6d, 0x6a, 0x6d, 0x62, 0x67, 0x62, 0xbb, 0xd0,
	0xff, 0x00, 0xf2, 0xc4, 0x23, 0x0f, 0xe4, 0x09, 0x1e, 0x78, 0xe2, 0x0d, 0xc1, 0x33, 0x4f, 0xfb,
	0x84, 0xe6, 0x19, 0x21, 0x0b, 0x8a, 0x90, 0x50, 0xfe, 0x02, 0x1e, 0xd1, 0xfd, 0xb0, 0x7d, 0x9d,
	0xed, 0x76, 0xd2, 0x91, 0x40, 0xe2, 0x25, 0xf1, 0x3d, 0xdf, 0xe7, 0x9e, 0xdf, 0x39, 0xf7, 0xda,
	0xb0, 0xda, 0x1b, 0xda, 0xd8, 0xf1, 0xf7, 0xc6, 0x13, 0xd7, 0x77, 0x51, 0x91, 0xfe, 0xf5, 0xdc,
	0xa1, 0xfa, 0xf5, 0x81, 0xed, 0x9f, 0x05, 0xdd, 0xbd, 0x9e, 0x3b, 0xda, 0x1f, 0xb8, 0x03, 0x77,
	0x9f, 0x72, 0xba, 0xc1, 0x29, 0x5d, 0xd1, 0x05, 0x7d, 0x62, 0x8a, 0xc6, 0x21, 0xe4, 0x9a, 0x93,
	0x89, 0x3b, 0x41, 0x5b, 0x90, 0xed, 0xb9, 0x7d, 0x5c, 0x93, 0x74, 0x69, 0xa7, 0x52, 0x2f, 0xce,
	0x43, 0x8d, 0xae, 0x4d, 0xfa, 0x8b, 0xee, 0x41, 0x61, 0x84, 0x3d, 0xaf, 0x33, 0xc0, 0xb5, 0x8c,
	0x2e, 0xed, 0x94, 0xea, 0xe5, 0x79, 0xa8, 0x45, 0x24, 0x33, 0x7a, 0x30, 0x7e, 0x27, 0x41, 0xa1,
	0xe1, 0x8e, 0x46, 0x1d, 0xa7, 0x8f, 0xee, 0x43, 0xc6, 0xee, 0x73, 0x73, 0xb7, 0x2f, 0x43, 0x2d,
	0xd3, 0x7a, 0x3c, 0x0f, 0xb5, 0x55, 0xbb, 0xff, 0x8e, 0x3b, 0xb2, 0x7d, 0x3c, 0x1a, 0xfb, 0x17,
	0x66, 0xc6, 0xee, 0xa3, 0x3a, 0xe4, 0x47, 0xd8, 0x3f, 0x73, 0xfb, 0xd4, 0x72, 0xf5, 0xe0, 0xd6,
	0x5e, 0x94, 0xcb, 0xde, 0x33, 0x4a, 0x3f, 0xbe, 0x18, 0xe3, 0xfa, 0xad, 0x79, 0xa8, 0x29, 0x4c,
	0x4e, 0xd0, 0xe7, 0x9a, 0xe8, 0x7d, 0xc8, 0x8f, 0x3b, 0x93, 0xce, 0xc8, 0xab, 0xc9, 0xba, 0xb4,
	0xb3, 0x5a, 0xd7, 0x3e, 0x0b, 0xb5, 0x95, 0xbf, 0x84, 0x9a, 0x6c, 0x76, 0x7e, 0x42, 0x14, 0x19,
	0x53, 0x54, 0x64, 0x14, 0xe3, 0x37, 0x12, 0xe4, 0x4c, 0x3c, 0x1e, 0x5e, 0x2c, 0x1d, 0xee, 0x43,
	0xc8, 0x61, 0xb2, 0x61, 0x34, 0xda, 0xf2, 0xc1, 0x5a, 0x12, 0x2d, 0xdd, 0xc7, 0xfa, 0xc6, 0x3c,
	0xd4, 0xd6, 0xa8, 0x84, 0xa0, 0xc8, 0x54, 0x48, 0x98, 0x13, 0xec, 0x05, 0x43, 0xff, 0x0b, 0xc2,
	0x64, 0x4c, 0x31, 0x4c, 0x46, 0x31, 0x7e, 0x25, 0x41, 0xb6, 0x1d, 0x78, 0x67, 0xe8, 0x21, 0x64,
	0xfd, 0x8b, 0x31, 0xab, 0x52, 0xf5, 0x00, 0x25, 0xce, 0x09, 0x97, 0x6e, 0x14, 0x9a, 0x87, 0x5a,
	0x95, 0xc8, 0x08, 0x66, 0xa8, 0x0e, 0xda, 0x87, 0x42, 0xef, 0xac, 0xe3, 0x38, 0x78, 0xc8, 0x6b,
	0xb8, 0x39, 0x0f, 0xb5, 0x75, 0x4e, 0x12, 0xa4, 0x23, 0x29, 0xf4, 0x16, 0x64, 0xfb, 0x1d, 0xbf,
	0xc3, 0x83, 0xdd, 0x48, 0x07, 0x4b, 0x59, 0x26, 0xfd, 0x35, 0x5e, 0x49, 0x00, 0x0d, 0x0a, 0xc7,
	0x96, 0x73, 0xea, 0x12, 0x28, 0x05, 0x1e, 0x9e, 0xd0, 0x20, 0x4b, 0x0c, 0x4a, 0x64, 0x6d, 0xd2,
	0x5f, 0x64, 0x40, 0x9e, 0x41, 0x97, 0x47, 0x01, 0xf3, 0x50, 0xe3, 0x14, 0x93, 0xff, 0xa3, 0x8f,
	0xa1, 0xd4, 0x73, 0x1d, 0xe7, 0x85, 0xed, 0x9c, 0xba, 0xdc, 0xbd, 0x91, 0x76, 0xbf, 0x11, 0xf3,
	0x85, 0xc8, 0x8b, 0x84, 0x48, 0x43, 0x20, 0x06, 0xce, 0x3a, 0xdc, 0x40, 0xf6, 0x6a, 0x03, 0x11,
	0x3f, 0x65, 0xe0, 0xac, 0x43, 0x0d, 0x18, 0xbf, 0xcc, 0x40, 0xb9, 0x1d, 0x74, 0x87, 0x76, 0xaf,
	0xe3, 0xdb, 0xae, 0x83, 0xbe, 0x0a, 0xb2, 0x87, 0x5f, 0x72, 0x7c, 0xac, 0xcf, 0x43, 0xad, 0xe2,
	0xe1, 0x97, 0x82, 0x26, 0xe1, 0x12, 0xa1, 0x01, 0x76, 0x68, 0x5e, 0x5c, 0x68, 0x80, 0x1d, 0x51,
	0x68, 0x80, 0x1d, 0xb4, 0x0b, 0x72, 0x60, 0xf7, 0x69, 0x56, 0xa5, 0x7a, 0xed, 0x32, 0xd4, 0xe4,
	0x13, 0x0a, 0xb5, 0x4a, 0x90, 0xc2, 0x1a, 0x11, 0x8a, 0x2b, 0x90, 0x7d, 0x4d, 0x05, 0xd0, 0xb7,
	0x20, 0x4b, 0x53, 0xcd, 0x51, 0x50, 0x0a, 0x2d, 0x94, 0x94, 0x85, 0x21, 0x63, 0x21, 0x61, 0xaa,
	0x85, 0xde, 0x81, 0xbc, 0x7b, 0x7a, 0xea, 0x61, 0xbf, 0x96, 0xd7, 0xa5, 0x9d, 0x2c, 0x6b, 0x36,
	0x46, 0x11, 0xc1, 0xc8, 0x28, 0xc6, 0x47, 0x90, 0x7d, 0xea, 0xda, 0x0e, 0x7a, 0x8f, 0xfb, 0x94,
	0xae, 0xf1, 0xb9, 0x4a, 0x42, 0x26, 0xb1, 0x12, 0x49, 0xe6, 0xcd, 0xf8, 0x18, 0x72, 0x87, 0xb8,
	0x73, 0x8e, 0xdf, 0xd8, 0xc0, 0x63, 0xc8, 0x9d, 0x38, 0x5e, 0xd0, 0x45, 0x1f, 0x42, 0x99, 0x34,
	0x48, 0xd7, 0xeb, 0x4d, 0xec, 0x2e, 0x6b, 0x8a, 0x62, 0xfd, 0xee, 0x3c, 0xd4, 0x36, 0x05, 0xb2,
	0x90, 0x81, 0x28, 0x6d, 0xfc, 0x53, 0x02, 0xd9, 0x8a, 0x8c, 0xf4, 0xdc, 0x73, 0x3c, 0xe9, 0x74,
	0x87, 0x0b, 0x46, 0x62, 0x72, 0xda, 0x48, 0x4c, 0x8e, 0x60, 0x91, 0x59, 0x06, 0x16, 0xf2, 0xb5,
	0xb0, 0x78, 0x1b, 0x72, 0x78, 0xec, 0xf6, 0xce, 0x68, 0xad, 0x4b, 0x7c, 0x8c, 0x10, 0x42, 0x6a,
	0x8c, 0x10, 0x82, 0x50, 0xae, 0xdc, 0x12, 0xe5, 0x3a, 0x80, 0xc2, 0x33, 0x36, 0x9e, 0x63, 0x38,
	0x49, 0xaf, 0x6b, 0xe8, 0x7f, 0x65, 0xa0, 0xda, 0x70, 0x1d, 0x07, 0xf7, 0x7c, 0x13, 0xbf, 0x0c,
	0xb0, 0xe7, 0x93, 0xf8, 0x7c, 0xf7, 0x53, 0xec, 0xf0, 0xae, 0xa6, 0xf1, 0x51, 0x82, 0x18, 0x1f,
	0x25, 0xa0, 0x07, 0xdc, 0x4d, 0x86, 0xba, 0xf9, 0x72, 0xda, 0x4d, 0x95, 0xb0, 0x44, 0x04, 0x52,
	0xfc, 0x3e, 0x85, 0x2c, 0xa9, 0x4c, 0x4d, 0xd6, 0xe5, 0x9d, 0xf2, 0x81, 0x21, 0x40, 0x21, 0x15,
	0xc5, 0x9e, 0x15, 0x74, 0xbd, 0xa6, 0xe3, 0x4f, 0x2e, 0x18, 0x9a, 0x89, 0x8e, 0x68, 0x8b, 0xac,
	0xd1, 0x7d, 0xc8, 0x3a, 0x9d, 0x11, 0xe6, 0x1b, 0x49, 0xe5, 0xc8, 0x5a, 0x94, 0x23, 0x6b, 0x32,
	0x0f, 0xcf, 0xf1, 0xc4, 0xb3, 0x5d, 0x87, 0xee, 0x23, 0x9f, 0x87, 0x9c, 0x24, 0xce, 0x43, 0x4e,
	0x52, 0x2d, 0x28, 0xc5, 0xfe, 0x91, 0x02, 0xf2, 0xa7, 0xf8, 0x82, 0xed, 0x86, 0x49, 0x1e, 0xd1,
	0xbb, 0x90, 0x3b, 0xef, 0x0c, 0x03, 0xcc, 0x4f, 0x06, 0x35, 0x49, 0xc2, 0x8a, 0x40, 0xc7, 0xd3,
	0x30, 0x99, 0xe0, 0xc3, 0xcc, 0x07, 0x92, 0xf1, 0x73, 0x19, 0x2a, 0x71, 0x92, 0x64, 0xd8, 0x0b,
	0x03, 0x52, 0xfa, 0xc2, 0x01, 0x79, 0x2f, 0x89, 0x5d, 0x38, 0x8f, 0x39, 0x29, 0x8e, 0x98, 0xa4,
	0x88, 0x7f, 0x3a, 0xb6, 0x27, 0x98, 0x1d, 0x8c, 0x45, 0x96, 0x22, 0x27, 0x89, 0x29, 0x72, 0x12,
	0x19, 0x4e, 0xbe, 0x3f, 0xa4, 0x5b, 0x57, 0x61, 0xc3, 0xe9, 0xf8, 0xf8, 0x90, 0x20, 0xd6, 0xf7,
	0xc5, 0x23, 0x82, 0x08, 0xc5, 0x65, 0xce, 0x2d, 0x5f, 0xe6, 0x16, 0x2f, 0x73, 0x9e, 0x96, 0xf9,
	0x2b, 0x57, 0x94, 0x99, 0xec, 0xc0, 0x32, 0x55, 0x56, 0xcd, 0xeb, 0x8b, 0xb1, 0x9f, 0x2e, 0xc6,
	0xdd, 0x2b, 0x8b, 0x41, 0x9c, 0x89, 0xb5, 0x78, 0x00, 0x55, 0x13, 0x9f, 0x4e, 0xb0, 0x77, 0x16,
	0xa1, 0x5e, 0x4b, 0xa3, 0xbe, 0x34, 0x0f, 0x35, 0x46, 0xe0, 0x58, 0x37, 0xfe, 0x20, 0x41, 0x25,
	0xd6, 0xf9, 0x7f, 0x2a, 0x9f, 0xf1, 0xa7, 0x0c, 0x28, 0x8b, 0xc0, 0x14, 0xef, 0x08, 0xd2, 0x52,
	0x77, 0x84, 0x78, 0x2c, 0x64, 0x5e, 0x3b, 0x16, 0xf6, 0xa1, 0xc0, 0x47, 0xa7, 0x98, 0x0d, 0x27,
	0x89, 0xb6, 0x39, 0x29, 0x1a, 0xae, 0xd9, 0x65, 0x86, 0x6b, 0x6e, 0xb9, 0xe1, 0x9a, 0xbf, 0xc1,
	0x70, 0x2d, 0x2c, 0x31, 0x5c, 0xff, 0x2a, 0xc3, 0xda, 0x02, 0xa0, 0xc4, 0xaa, 0x49, 0x37, 0xa9,
	0x5a, 0x66, 0x99, 0xa6, 0x5b, 0x38, 0xad, 0xe4, 0x37, 0x39, 0xad, 0xfe, 0xb7, 0x1b, 0x7a, 0x02,
	0xab, 0xe3, 0xe4, 0x22, 0xe5, 0xd5, 0x0a, 0xb4, 0xf7, 0x37, 0xc5, 0xab, 0x6b, 0xcc, 0xad, 0xab,
	0xf3, 0x50, 0xbb, 0x2d, 0x8a, 0x0b, 0xf6, 0x52, 0x66, 0xd0, 0x37, 0xa1, 0xc4, 0x53, 0xc3, 0xfd,
	0x5a, 0x91, 0x6e, 0xc3, 0x1d, 0x72, 0xad, 0x8b, 0x89, 0x82, 0x66, 0x22, 0x29, 0x94, 0xb7, 0xb4,
	0x44, 0x79, 0x7f, 0x08, 0xeb, 0x56, 0xd0, 0x5d, 0x98, 0x09, 0xf7, 0x16, 0x7b, 0x84, 0x36, 0x2f,
	0x27, 0x25, 0x9d, 0xa1, 0xa5, 0x3b, 0xe3, 0xf3, 0xa3, 0xc3, 0xa5, 0xfd, 0x97, 0x1e, 0x1e, 0xff,
	0x4d, 0xec, 0x18, 0x1f, 0x02, 0xa2, 0xf7, 0xa6, 0x74, 0xcb, 0x2f, 0x97, 0x8e, 0xb1, 0x01, 0xeb,
	0x29, 0x65, 0xfa, 0x5e, 0xf2, 0x63, 0xa8, 0xd2, 0xea, 0xdd, 0x78, 0x73, 0xde, 0x4a, 0x5d, 0x11,
	0xae, 0xb9, 0x89, 0xac, 0x41, 0x25, 0xf6, 0x40, 0x5d, 0x7e, 0x00, 0x6b, 0xed, 0x09, 0xf6, 0xb0,
	0xd3, 0xbb, 0x69, 0x06, 0xbf, 0x97, 0xa0, 0x9a, 0xa8, 0xd2, 0xed, 0x6e, 0x43, 0x71, 0xcc, 0x29,
	0x35, 0x89, 0xe2, 0xf2, 0xbe, 0x80, 0xcb, 0x94, 0x6c, 0xbc, 0x64, 0x07, 0xd3, 0xea, 0x3c, 0xd4,
	0x62, 0x5d, 0x33, 0x7e, 0x52, 0xbf, 0x07, 0x95, 0x94, 0xe0, 0x15, 0x47, 0xd3, 0x6e, 0xfa, 0x68,
	0xba, 0xf2, 0xde, 0x2b, 0x9e, 0x4a, 0xdf, 0x86, 0x5b, 0x91, 0x49, 0xcb, 0xef, 0xf8, 0xde, 0x0d,
	0xd3, 0xf6, 0x60, 0x63, 0x41, 0x9d, 0xa6, 0xfe, 0x2e, 0x94, 0x9d, 0x60, 0xf4, 0x82, 0x1d, 0x48,
	0x1e, 0x7f, 0xb1, 0x59, 0x9b, 0x87, 0x9a, 0x48, 0x36, 0xc1, 0x09, 0x46, 0x2c, 0x2a, 0x02, 0xb5,
	0x12, 0x61, 0x91, 0x97, 0x38, 0x8f, 0x03, 0xae, 0x32, 0x0f, 0xb5, 0x84, 0x68, 0x16, 0x9d, 0x60,
	0x74, 0x42, 0x9e, 0x8c, 0xf7, 0xa1, 0xfa, 0xc4, 0xf6, 0x7c, 0x77, 0x72, 0x71, 0xc3, 0x68, 0x7f,
	0x04, 0x95, 0x58, 0x91, 0xc6, 0xf9, 0xdd, 0x85, 0xf1, 0x21, 0x5d, 0x37, 0x3e, 0x14, 0xf2, 0xca,
	0x2e, 0x8a, 0xa7, 0x87, 0x86, 0x51, 0x81, 0x72, 0xdb, 0x76, 0x06, 0x3c, 0x26, 0x63, 0x15, 0x80,
	0x2d, 0x29, 0xb2, 0x7a, 0x00, 0x66, 0xbb, 0x11, 0xc5, 0xbb, 0xec, 0x5d, 0x99, 0x4c, 0x14, 0xe1,
	0xfb, 0x45, 0xe9, 0xfa, 0x2f, 0x15, 0xc6, 0x47, 0x50, 0xa2, 0x4e, 0x68, 0x6e, 0x0f, 0x52, 0x3e,
	0x96, 0xb9, 0x41, 0x19, 0xef, 0x41, 0xd9, 0xc2, 0x4e, 0xff, 0xa6, 0x51, 0xee, 0xbe, 0x92, 0x01,
	0x92, 0xcf, 0x29, 0xc8, 0x80, 0x42, 0xe3, 0xf9, 0xd1, 0x51, 0xb3, 0x71, 0xac, 0xac, 0xa8, 0x9b,
	0xd3, 0x99, 0xbe, 0x9e, 0x30, 0xf9, 0x5d, 0x0c, 0xdd, 0x87, 0x92, 0x75, 0x52, 0xb7, 0x1a, 0x66,
	0xab, 0xde, 0x54, 0x24, 0xf5, 0xce, 0x74, 0xa6, 0x6f, 0x24, 0x52, 0xf1, 0xa9, 0x87, 0x76, 0xa1,
	0x7c, 0x72, 0x94, 0x48, 0x66, 0xd4, 0xbb, 0xd3, 0x99, 0xbe, 0x99, 0x48, 0x0a, 0x63, 0x83, 0xf8,
	0x6d, 0x9f, 0xd4, 0x0f, 0x5b, 0xd6, 0x13, 0x45, 0x5e, 0xf4, 0xcb, 0xfb, 0x1c, 0x7d, 0x0d, 0x8a,
	0x6d, 0xb3, 0x69, 0x35, 0x8f, 0x1a, 0x4d, 0x25, 0xab, 0xde, 0x9e, 0xce, 0x74, 0x24, 0x08, 0x71,
	0x28, 0xa3, 0x7d, 0xa8, 0x46, 0x52, 0x2f, 0xac, 0xe3, 0x47, 0xc7, 0x96, 0x92, 0x53, 0xbf, 0x34,
	0x9d, 0xe9, 0x77, 0x3e, 0x2f, 0x4b, 0x61, 0x4f, 0x5c, 0x3f, 0x69, 0x59, 0xc7, 0xcf, 0xcd, 0x1f,
	0x28, 0xf9, 0x45, 0xd7, 0x1c, 0x72, 0x68, 0x0b, 0xb2, 0xed, 0xd6, 0xd1, 0x27, 0x4a, 0x41, 0x45,
	0xd3, 0x99, 0x5e, 0x15, 0x4c, 0xd9, 0xce, 0x80, 0x70, 0xad, 0xe6, 0xd1, 0x63, 0xa5, 0xb8, 0xc8,
	0x25, 0x15, 0x41, 0x2a, 0xc8, 0x66, 0xbb, 0xa1, 0x94, 0xd4, 0xf5, 0xe9, 0x4c, 0xaf, 0x24, 0x4c,
	0xb3, 0xdd, 0x20, 0xbe, 0xcd, 0xe6, 0x77, 0xcc, 0xa6, 0xf5, 0x44, 0x81, 0x45, 0xdf, 0xfc, 0x00,
	0x40, 0x6f, 0x43, 0xd9, 0x3a, 0xa9, 0xbf, 0x88, 0xe4, 0xca, 0x6a, 0x6d, 0x3a, 0xd3, 0x6f, 0xa5,
	0x36, 0x9c, 0x8b, 0xaa, 0xd9, 0x9f, 0xfd, 0x7a, 0x7b, 0x65, 0xf7, 0xcf, 0x12, 0x14, 0xa3, 0xcf,
	0x3e, 0x68, 0x07, 0xca, 0x74, 0x63, 0x1b, 0x8f, 0x8e, 0x5b, 0xcf, 0x8f, 0x94, 0x15, 0x56, 0xae,
	0x88, 0x2d, 0x7e, 0xc9, 0x50, 0x21, 0xfb, 0xf4, 0x79, 0xeb, 0x48, 0x91, 0x54, 0x65, 0x3a, 0xd3,
	0x57, 0x23, 0x11, 0xfa, 0x4a, 0xbf, 0x05, 0xb9, 0xc3, 0xe6, 0xa3, 0xef, 0x93, 0x22, 0xd2, 0x2c,
	0x22, 0x26, 0x7b, 0x5f, 0xdf, 0x82, 0x1c, 0x2d, 0xb4, 0x22, 0xa7, 0xb9, 0xec, 0x65, 0x5c, 0x87,
	0xc2, 0xb3, 0xa6, 0x65, 0x3d, 0xfa, 0x84, 0x54, 0x6d, 0x63, 0x3a, 0xd3, 0xd7, 0x22, 0x7e, 0xf4,
	0xfa, 0x59, 0x03, 0x99, 0x68, 0xe7, 0xd4, 0xb5, 0xe9, 0x4c, 0x2f, 0x47, 0x5c, 0x2b, 0xe8, 0xb2,
	0x84, 0xea, 0x5b, 0xff, 0xfe, 0xfb, 0xb6, 0xf4, 0xdb, 0xcb, 0x6d, 0xe9, 0x8f, 0x97, 0xdb, 0xd2,
	0x67, 0x97, 0xdb, 0xd2, 0xab, 0xcb, 0x6d, 0xe9, 0x6f, 0x97, 0xdb, 0xd2, 0x2f, 0xfe, 0xb1, 0xbd,
	0xd2, 0xcd, 0xd3, 0x8e, 0xff, 0xc6, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x0f, 0xed, 0xbc, 0xca,
	0xf9, 0x14, 0x00, 0x00,
}
