"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hfround = hfround;

var _converter = require("./_converter.cjs");

/**
 * returns the nearest half precision float representation of a number.
 *
 * @param {number} num
 * @returns {number}
 */
function hfround(num) {
  if (typeof num === "bigint") {
    throw TypeError("Cannot convert a BigInt value to a number");
  }

  num = Number(num); // for optimization

  if (!Number.isFinite(num) || num === 0) {
    return num;
  }

  const x16 = (0, _converter.roundToFloat16Bits)(num);
  return (0, _converter.convertToNumber)(x16);
}