"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fileTestDelta = void 0;
const formatter = Intl.NumberFormat();
function fileTestDelta(delta) {
    if (!delta) {
        return '';
    }
    const { baseline, diff, result } = delta;
    const resultFormatted = formatter.format(result);
    if (diff === 0) {
        return ` (${resultFormatted} ${getIssuesStr(result)})`;
    }
    const diffIssues = getIssuesStr(diff);
    if (baseline != null && diff < 0) {
        const diffFormatted = formatter.format(-diff);
        return ` (${diffFormatted} fixed ${diffIssues}, ${resultFormatted} remaining)`;
    }
    if (baseline != null && diff > 0) {
        const diffFormatted = formatter.format(diff);
        return ` (${diffFormatted} new ${diffIssues}, ${resultFormatted} total)`;
    }
    return '';
}
exports.fileTestDelta = fileTestDelta;
function getIssuesStr(n) {
    return Math.abs(n) === 1 ? 'issue' : 'issues';
}
//# sourceMappingURL=file-test-delta.js.map