/// <reference types="node" />
import * as http from 'http';
import * as https from 'https';
import * as collectorTypes from '../../types';
import { CollectorExporterNodeBase } from './CollectorExporterNodeBase';
import { CollectorExporterNodeConfigBase } from '.';
/**
 * Sends data using http
 * @param collector
 * @param data
 * @param contentType
 * @param onSuccess
 * @param onError
 */
export declare function sendWithHttp<ExportItem, ServiceRequest>(collector: CollectorExporterNodeBase<ExportItem, ServiceRequest>, data: string | Buffer, contentType: string, onSuccess: () => void, onError: (error: collectorTypes.CollectorExporterError) => void): void;
export declare function createHttpAgent(config: CollectorExporterNodeConfigBase): http.Agent | https.Agent | undefined;
//# sourceMappingURL=util.d.ts.map