"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PageTitleAppender = void 0;
const DocHeading_1 = require("../../nodes/DocHeading");
class PageTitleAppender {
    constructor(configuration) {
        this._configuration = configuration;
    }
    append(output, apiItem) {
        const title = this._titleFromItem(apiItem);
        if (!title) {
            return;
        }
        output.appendNode(new DocHeading_1.DocHeading({
            configuration: this._configuration,
            title,
            level: 1
        }));
    }
    _titleFromItem(apiItem) {
        const scopedName = apiItem.getScopedNameWithinPackage();
        switch (apiItem.kind) {
            case "Class" /* Class */:
                return `${scopedName} class`;
            case "Enum" /* Enum */:
                return `${scopedName} enum`;
            case "Interface" /* Interface */:
                return `${scopedName} interface`;
            case "Function" /* Function */:
                return `${scopedName} function`;
            case "Model" /* Model */:
                return `API Reference`;
            case "Namespace" /* Namespace */:
                return `${scopedName} namespace`;
            case "Package" /* Package */:
                return `${apiItem.displayName} package`;
            case "TypeAlias" /* TypeAlias */:
                return `${scopedName} type`;
            case "Variable" /* Variable */:
                return `${scopedName} variable`;
        }
        return;
    }
}
exports.PageTitleAppender = PageTitleAppender;
;
//# sourceMappingURL=PageTitleAppender.js.map