Bridge.assembly("Kusto.JavaScript.Client",function($asm,globals){"use strict";Bridge.define("Kusto.Charting.AnomalyDataHelper2",{statics:{props:{TimestampColumnName:null,ValueColumnName:null,SeriesColumnName:null,AnomalySerieSuffix:null},ctors:{init:function(){this.TimestampColumnName="Timestamp";this.ValueColumnName="Value";this.SeriesColumnName="Series";this.AnomalySerieSuffix="(anomaly)"}},methods:{EnchanceDataWithAnomalyDataFromServiceAsync:function(kustoContext,data){var $step=0,$task1,$taskResult1,$jumpFromFinally,$tcs=new System.Threading.Tasks.TaskCompletionSource,$returnValue,res,dataAsCsl,query,results,$t,$async_e,$asyncBody=Bridge.fn.bind(this,function(){try{for(;;){$step=System.Array.min([0,1],$step);switch($step){case 0:if(res=new Kusto.Charting.AnomalyDataHelper2.AnomalyDataFromServiceResult,kustoContext==null){res.Data=data;res.HasErrors=!0;res.Message="Failed sending the request for anomalies to the service";$tcs.setResult(res);return}if(dataAsCsl=Kusto.Charting.AnomalyDataHelper2.DataItemsToDataTableLiteral(data),query=(dataAsCsl||"")+(System.String.format("| summarize dt = makelist({0}, 100000), y=makelist({1}, 100000) by {2}\r\n| extend (anomalies, scores, baseline)=series_decompose_anomalies(y)\r\n| project dt, y, anomalies, Series\r\n| mvexpand dt to typeof(datetime), y to typeof(double), anomalies to typeof(double) limit 1000000\r\n| where anomalies != 0\r\n| project dt, anomaly_value = (anomalies * anomalies)*y, Series",Kusto.Charting.AnomalyDataHelper2.TimestampColumnName,Kusto.Charting.AnomalyDataHelper2.ValueColumnName,Kusto.Charting.AnomalyDataHelper2.SeriesColumnName)||""),System.Text.Encoding.UTF8.GetByteCount$2(query)>2e6){res.Data=data;res.HasErrors=!0;res.Message="The anomalies request to the service exceeds the 2MB limit, consider adding more filters";$tcs.setResult(res);return}if($task1=kustoContext.Kusto$Charting$IKustoClientContext$ExecuteQueryAsync(Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord,query),$step=1,$task1.isCompleted())continue;$task1.continue($asyncBody);return;case 1:if($taskResult1=$task1.getAwaitedResult(),results=$taskResult1,results=($t=Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord,System.Linq.Enumerable.from(results,$t).ToArray($t)),results==null||!System.Linq.Enumerable.from(results,Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord).any()){res.Data=data;res.HasErrors=!0;res.Message="Failed retrieving the anomalies result from the service";$tcs.setResult(res);return}data.AddRange(System.Linq.Enumerable.from(results,Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord).select($asm.$.Kusto.Charting.AnomalyDataHelper2.f1));res.Data=data;res.HasErrors=!1;res.Message="";$tcs.setResult(res);return;default:$tcs.setResult(null);return}}}catch($async_e1){$async_e=System.Exception.create($async_e1);$tcs.setException($async_e)}},arguments);return $asyncBody(),$tcs.task},DataItemsToDataTableLiteral:function(items){var $t,result=new System.Text.StringBuilder,item,seriesName;result.append("datatable");result.appendLine(System.String.format("({0}:datetime,{1}:double,{2}:string)",Kusto.Charting.AnomalyDataHelper2.TimestampColumnName,Kusto.Charting.AnomalyDataHelper2.ValueColumnName,Kusto.Charting.AnomalyDataHelper2.SeriesColumnName));result.append("[");$t=Bridge.getEnumerator(items,Kusto.Charting.DataItem);try{while($t.moveNext())item=$t.Current,result.append("datetime("),result.append(System.DateTime.format(item.ArgumentDateTime,"o")),result.append("),"),result.append("double("),result.append(System.Double.format(item.ValueData)),result.append("),"),seriesName=Kusto.Cloud.Platform.Text.StringLiteral.GetLiteral(item.SeriesName),result.append(seriesName),result.appendLine(",")}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return result.appendLine("]"),result.toString()},EnchanceDataWithAnomalyDataFromColumns:function(data,anomalyColumns,anomalySeriesMap){var $t,$t1,valueData,anomalyColumn,anomalyData,anomalyPointsCount,i,valuePoint,anomalyPoint,seriesName,a,a1;anomalySeriesMap.v=new(System.Collections.Generic.Dictionary$2(System.String,System.String).ctor);var result=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem).ctor),anomalyColumnsHashset=new(System.Collections.Generic.HashSet$1(System.String).$ctor1)(anomalyColumns),valueColumn=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).where(function(d){return!anomalyColumnsHashset.contains(d.ValueName)}).select($asm.$.Kusto.Charting.AnomalyDataHelper2.f2).firstOrDefault(null,null);if(System.String.isNullOrEmpty(valueColumn))return data;result.AddRange(System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).where(function(d){return!anomalyColumnsHashset.contains(d.ValueName)}));valueData=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).where(function(d){return System.String.equals(d.ValueName,valueColumn)}).ToArray(Kusto.Charting.DataItem);$t=Bridge.getEnumerator(anomalyColumns);try{while($t.moveNext()){if(anomalyColumn={v:$t.Current},anomalyData=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).where(function($me,anomalyColumn){return function(d){return System.String.equals(d.ValueName,anomalyColumn.v)}}(this,anomalyColumn)).ToArray(Kusto.Charting.DataItem),valueData.length!==anomalyData.length)return data;for(anomalyPointsCount=0,i=0;i<valueData.length;i=i+1|0)valuePoint=valueData[System.Array.index(i,valueData)],anomalyPoint=anomalyData[System.Array.index(i,anomalyData)],anomalyPoint.ValueData!==0&&(anomalyPointsCount=anomalyPointsCount+1|0,seriesName=(anomalyPoint.SeriesName||"")+(Kusto.Charting.AnomalyDataHelper2.AnomalySerieSuffix||""),a=($t1=new Kusto.Charting.DataItem.ctor,$t1.ArgumentDateTime=anomalyPoint.ArgumentDateTime,$t1.ArgumentData=anomalyPoint.ArgumentData,$t1.SeriesName=seriesName,$t1.ValueData=valuePoint.ValueData,$t1.PrefferredChartKind=Kusto.Charting.ChartKind.Point,$t1),result.add(a),anomalySeriesMap.v.containsKey(seriesName)||anomalySeriesMap.v.add(seriesName,valuePoint.SeriesName));anomalyPointsCount===0&&(a1=($t1=new Kusto.Charting.DataItem.ctor,$t1.ArgumentDateTime=anomalyData[System.Array.index(0,anomalyData)].ArgumentDateTime,$t1.ArgumentData=null,$t1.SeriesName=(anomalyData[System.Array.index(0,anomalyData)].SeriesName||"")+(Kusto.Charting.AnomalyDataHelper2.AnomalySerieSuffix||""),$t1.ValueData=Number.NaN,$t1.PrefferredChartKind=Kusto.Charting.ChartKind.Point,$t1),result.add(a1))}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return result}}}});Bridge.ns("Kusto.Charting.AnomalyDataHelper2",$asm.$);Bridge.apply($asm.$.Kusto.Charting.AnomalyDataHelper2,{f1:function(r){var $t1;return $t1=new Kusto.Charting.DataItem.ctor,$t1.ArgumentDateTime=r.Timestamp,$t1.ArgumentData=System.DateTime.format(r.Timestamp,"o"),$t1.SeriesName=(r.Series||"")+(Kusto.Charting.AnomalyDataHelper2.AnomalySerieSuffix||""),$t1.ValueData=r.Value,$t1.PrefferredChartKind=Kusto.Charting.ChartKind.Point,$t1},f2:function(d){return d.ValueName}});Bridge.define("Kusto.Charting.AnomalyDataHelper2.AnomalyDataFromServiceResult",{$kind:"nested class",fields:{Data:null,HasErrors:!1,Message:null}});Bridge.define("Kusto.Charting.AnomalyDataHelper2.AnomalyInputOutputRecord",{$kind:"nested class",fields:{Timestamp:null,Value:0,Series:null},ctors:{init:function(){this.Timestamp=System.DateTime.getDefaultValue()}}});Bridge.define("Kusto.Charting.ArgumentColumnType",{$kind:"enum",statics:{fields:{None:0,Numeric:2,DateTime:4,TimeSpan:8,String:16,Object:32,Geospatial:64,DateTimeOrTimeSpan:12,StringOrDateTimeOrTimeSpan:28,NumericOrDateTimeOrTimeSpan:14,StringOrObject:48,AllExceptGeospatial:62}},$flags:!0});Bridge.define("Kusto.Charting.ArgumentRestrictions",{$kind:"enum",statics:{fields:{None:0,MustHave:1,NotIncludedInSeries:2,GeospatialAsSeries:4,PreferLast:8,NumericAsSeries:16}},$flags:!0});Bridge.define("Kusto.Charting.ChartKind",{$kind:"enum",statics:{fields:{Unspecified:0,Line:1,Point:2,Bar:3}}});Bridge.define("Kusto.Charting.ChartLimitsPolicy",{props:{MaxPointsPerChartError:0,MaxPointsPerChartWarning:0,MaxSeriesPerChartError:0,MaxSeriesPerChartWarning:0,MaxDatetimePeriodError:null},ctors:{init:function(){this.MaxDatetimePeriodError=new System.TimeSpan},ctor:function(maxPointsPerChartError,maxPointsPerChartWarning,maxSeriesPerChartError,maxSeriesPerChartWarning,maxDatetimePeriodError){this.$initialize();this.MaxPointsPerChartError=maxPointsPerChartError;this.MaxPointsPerChartWarning=maxPointsPerChartWarning;this.MaxSeriesPerChartError=maxSeriesPerChartError;this.MaxSeriesPerChartWarning=maxSeriesPerChartWarning;this.MaxDatetimePeriodError=maxDatetimePeriodError}}});Bridge.define("Kusto.Charting.DataChartsHelper",{statics:{fields:{c_minFractionOfIntervalsToDetectDistribution:0,c_minElementsAmountToFillGapsWithNans:0,c_decimalRoundingPrecision:0,c_doubleAcceptableApproximation:0,c_defaultArgumentNumeric:0,c_defaultArgumentString:null,c_defaultArgumentDatetime:null},ctors:{init:function(){this.c_defaultArgumentDatetime=System.DateTime.getDefaultValue();this.c_minFractionOfIntervalsToDetectDistribution=.8;this.c_minElementsAmountToFillGapsWithNans=4;this.c_decimalRoundingPrecision=8;this.c_doubleAcceptableApproximation=1e-8;this.c_defaultArgumentNumeric=Number.NaN;this.c_defaultArgumentString="<empty>";this.c_defaultArgumentDatetime=Bridge.getDefaultValue(System.DateTime)}},methods:{GetData:function(table,argumentColumnType,argumentRestrictions,seriesColumns,accumulateResults,xColumn,yColumns){argumentColumnType===void 0&&(argumentColumnType=16);argumentRestrictions===void 0&&(argumentRestrictions=0);seriesColumns===void 0&&(seriesColumns=null);accumulateResults===void 0&&(accumulateResults=!1);xColumn===void 0&&(xColumn=null);yColumns===void 0&&(yColumns=null);var chartProps=Kusto.Charting.DataChartsHelper.GetMetaData(table,argumentColumnType,argumentRestrictions,seriesColumns,xColumn,yColumns);return Kusto.Charting.DataChartsHelper.GetData$1(table,chartProps,accumulateResults)},GetData$1:function(table,metaData,accumulateResults){var i,baseSeriesName;if(accumulateResults===void 0&&(accumulateResults=!1),table==null||metaData==null)return System.Linq.Enumerable.empty();var tableSchema=table.Kusto$Charting$IChartingDataSource$GetSchema(),allColumns=System.Linq.Enumerable.from(tableSchema,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).select($asm.$.Kusto.Charting.DataChartsHelper.f1).toList(Kusto.Charting.DataChartsHelper.ColumnDesc),seriesList=System.Linq.Enumerable.from(metaData.Kusto$Charting$IChartMetaData$SeriesIndexes,System.Int32).any()?System.Linq.Enumerable.from(allColumns,Kusto.Charting.DataChartsHelper.ColumnDesc).where(function(col){return System.Linq.Enumerable.from(metaData.Kusto$Charting$IChartMetaData$SeriesIndexes,System.Int32).contains(col.Index)}).ToArray(Kusto.Charting.DataChartsHelper.ColumnDesc):null,dataColumns=System.Linq.Enumerable.from(allColumns,Kusto.Charting.DataChartsHelper.ColumnDesc).where(function(col){return System.Linq.Enumerable.from(metaData.Kusto$Charting$IChartMetaData$DataIndexes,System.Int32).contains(col.Index)}).ToArray(Kusto.Charting.DataChartsHelper.ColumnDesc),unusedColumns=System.Linq.Enumerable.from(allColumns,Kusto.Charting.DataChartsHelper.ColumnDesc).where(function(col){return System.Linq.Enumerable.from(metaData.Kusto$Charting$IChartMetaData$UnusedIndexes,System.Int32).contains(col.Index)}).ToArray(Kusto.Charting.DataChartsHelper.ColumnDesc),argumentData=new Kusto.Charting.DataChartsHelper.ArgumentData(metaData.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex,metaData.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex>=0?allColumns.getItem(metaData.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex).Name:"",metaData.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex>=0?System.Linq.Enumerable.from(tableSchema,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(metaData.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex).Item2:Kusto.Charting.ArgumentColumnType.None,metaData.Kusto$Charting$IChartMetaData$ArgumentColumnType,metaData.Kusto$Charting$IChartMetaData$GeospatialColumnIndexes),result=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem).ctor),lastValues=new(System.Collections.Generic.Dictionary$2(System.String,System.Double).ctor);for(i=0;i<table.Kusto$Charting$IChartingDataSource$RowsCount;i=i+1|0)baseSeriesName=Kusto.Charting.DataChartsHelper.GetBaseSeriesName(table,seriesList,i),metaData.Kusto$Charting$IChartMetaData$IsDataFormedAsSeries?Kusto.Charting.DataChartsHelper.ResolveDataSeriesFromDataRow(result,table,dataColumns,unusedColumns,i,baseSeriesName,metaData.Kusto$Charting$IChartMetaData$ArgumentColumnType,accumulateResults,metaData.Kusto$Charting$IChartMetaData$ArgumentDataColumnIndex):(argumentData.ResolveArgumentFromRow(table,i),Kusto.Charting.DataChartsHelper.ResolveDataItemsFromDataRow(result,table,dataColumns,unusedColumns,i,baseSeriesName,argumentData,lastValues,accumulateResults));return result},GetMetaData:function(table,argumentColumnType,argumentRestrictions,seriesColumns,xColumn,yColumns){var tableSchema,metaData,isTableValidForCharting,tempDataIndex,firstDataIndex;return(argumentColumnType===void 0&&(argumentColumnType=16),argumentRestrictions===void 0&&(argumentRestrictions=0),seriesColumns===void 0&&(seriesColumns=null),xColumn===void 0&&(xColumn=null),yColumns===void 0&&(yColumns=null),tableSchema=table.Kusto$Charting$IChartingDataSource$GetSchema(),tableSchema==null||!System.Linq.Enumerable.from(tableSchema,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).any())?null:(seriesColumns==null&&(seriesColumns=new(System.Collections.Generic.List$1(System.String).ctor)),yColumns==null&&(yColumns=new(System.Collections.Generic.List$1(System.String).ctor)),metaData={v:new Kusto.Charting.DataChartsHelper.ChartMetaData(argumentColumnType)},Kusto.Charting.DataChartsHelper.ResolvePredefinedColumnsIndexes(table,seriesColumns,yColumns,xColumn,argumentRestrictions,metaData),isTableValidForCharting=!1,metaData.v.IsDataFormedAsSeries||(isTableValidForCharting=Kusto.Charting.DataChartsHelper.DetectChartDimensionsUsingColumnTypesAndData(tableSchema,table,argumentRestrictions,metaData),metaData.v.IsDataFormedAsSeries=!isTableValidForCharting),metaData.v.IsDataFormedAsSeries&&(isTableValidForCharting=Kusto.Charting.DataChartsHelper.DetectChartDimensionsUsingData(tableSchema,table,seriesColumns,argumentRestrictions,metaData)),!isTableValidForCharting)?null:(tempDataIndex=metaData.v.DataIndexes,metaData.v.DataIndexesList=System.Linq.Enumerable.from(tableSchema,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).select(function(col,index){return index!==metaData.v.ArgumentDataColumnIndex&&!metaData.v.GeospatiaColumnlIndexesList.contains(index)&&(!System.Linq.Enumerable.from(tempDataIndex,System.Int32).any()||System.Linq.Enumerable.from(tempDataIndex,System.Int32).contains(index))&&!System.Linq.Enumerable.from(metaData.v.SeriesIndexes,System.Int32).contains(index)&&(!metaData.v.IsDataFormedAsSeries&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.NumericOrDateTimeOrTimeSpan,Bridge.box(col.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||metaData.v.IsDataFormedAsSeries&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.StringOrObject,Bridge.box(col.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))?index:-1}).where($asm.$.Kusto.Charting.DataChartsHelper.f2).toList(System.Int32),metaData.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&(metaData.v.DataIndexesList.Count>1&&(firstDataIndex=System.Linq.Enumerable.from(metaData.v.DataIndexesList,System.Int32).first(),metaData.v.DataIndexesList.clear(),metaData.v.DataIndexesList.add(firstDataIndex)),argumentRestrictions===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&(metaData.v.ArgumentDataColumnIndex===-1||!System.Linq.Enumerable.from(metaData.v.DataIndexesList,System.Int32).any())))?null:(metaData.v.UnusedIndexes=System.Linq.Enumerable.range(0,System.Linq.Enumerable.from(tableSchema,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count()).except(metaData.v.DataIndexes).except(metaData.v.GeospatialColumnIndexes).except(metaData.v.SeriesIndexes).except(System.Array.init([metaData.v.ArgumentDataColumnIndex],System.Int32)).toList(System.Int32),metaData.v)},IsNumericType:function(type,considerDateTimeAndTimeSpanAsNumeric){if(considerDateTimeAndTimeSpanAsNumeric===void 0&&(considerDateTimeAndTimeSpanAsNumeric=!0),type==null)return!1;else if(Bridge.referenceEquals(type,System.TimeSpan)||Bridge.referenceEquals(type,System.DateTime))return considerDateTimeAndTimeSpanAsNumeric;else if(Bridge.referenceEquals(type,System.Byte)||Bridge.referenceEquals(type,System.Decimal)||Bridge.referenceEquals(type,System.Double)||Bridge.referenceEquals(type,System.Int16)||Bridge.referenceEquals(type,System.Int32)||Bridge.referenceEquals(type,System.Int64)||Bridge.referenceEquals(type,System.SByte)||Bridge.referenceEquals(type,System.UInt16)||Bridge.referenceEquals(type,System.UInt32)||Bridge.referenceEquals(type,System.UInt64))return!0;else if(Bridge.referenceEquals(type,System.Object)&&Bridge.Reflection.isGenericType(type)&&Bridge.referenceEquals(Bridge.Reflection.getGenericTypeDefinition(type),System.Nullable$1))return Kusto.Charting.DataChartsHelper.IsNumericType(System.Nullable.getUnderlyingType(type),considerDateTimeAndTimeSpanAsNumeric);return!1},GetAllArgumentColumns:function(table,columnsToExclude){var i,columnName;columnsToExclude===void 0&&(columnsToExclude=null);var result=new(System.Collections.Generic.List$1(System.String).ctor),schema=table.Kusto$Charting$IChartingDataSource$GetSchema(),n=System.Linq.Enumerable.from(table.Kusto$Charting$IChartingDataSource$GetSchema(),System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count(),columnsToExcludeDefined=columnsToExclude!=null&&System.Linq.Enumerable.from(columnsToExclude,System.String).any();if(n>1)for(i=0;i<n;i=i+1|0)(columnName=System.Linq.Enumerable.from(schema,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(i).Item1,columnsToExcludeDefined&&System.Linq.Enumerable.from(columnsToExclude,System.String).contains(columnName))||result.add(columnName);return result},GetFirstStringColumnName:function(table,amountToSkip){var schema,n,i;for(amountToSkip===void 0&&(amountToSkip=0),schema=table.Kusto$Charting$IChartingDataSource$GetSchema(),n=System.Linq.Enumerable.from(table.Kusto$Charting$IChartingDataSource$GetSchema(),System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count(),i=0;i<n;i=i+1|0)if(System.Linq.Enumerable.from(schema,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(i).Item2===Kusto.Charting.ArgumentColumnType.String)if(amountToSkip===0)return System.Linq.Enumerable.from(schema,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(i).Item1;else amountToSkip=amountToSkip-1|0;return null},FillGapsWithNaNs:function(data,argType){var $t,dataGroups,result,dg,serieDataItems;if(data==null||!System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).any()||data.Count<Kusto.Charting.DataChartsHelper.c_minElementsAmountToFillGapsWithNans)return data;dataGroups=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).groupBy($asm.$.Kusto.Charting.DataChartsHelper.f3);result=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem).$ctor2)(data.Count);$t=Bridge.getEnumerator(dataGroups);try{while($t.moveNext())dg=$t.Current,serieDataItems=Kusto.Charting.DataChartsHelper.FillGapsWithNaNs$1(dg.select($asm.$.Kusto.Charting.DataChartsHelper.f4),argType),result.AddRange(serieDataItems)}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return result},FillGapsWithNaNs$1:function(data,argType){var $t,argData,result,prevItem,item,currentDistance,gapLength,mod,j,newItem;if(System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).count()<Kusto.Charting.DataChartsHelper.c_minElementsAmountToFillGapsWithNans)return data;switch(argType){case Kusto.Charting.ArgumentColumnType.TimeSpan:case Kusto.Charting.ArgumentColumnType.DateTime:data=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).orderBy($asm.$.Kusto.Charting.DataChartsHelper.f5);argData=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).select($asm.$.Kusto.Charting.DataChartsHelper.f6).ToArray(System.Double);break;case Kusto.Charting.ArgumentColumnType.Numeric:data=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).orderBy($asm.$.Kusto.Charting.DataChartsHelper.f7);argData=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).select($asm.$.Kusto.Charting.DataChartsHelper.f7).ToArray(System.Double);break;default:return data}if(argData==null||!System.Linq.Enumerable.from(argData,System.Double).any())return data;var distances=Kusto.Charting.DataChartsHelper.SelectSuccessivePairs(argData),maxGroup=Kusto.Charting.DataChartsHelper.GetTopGroupByCount(distances,argType),initialDistance=maxGroup.Item1;if(maxGroup==null||System.Convert.toDouble(Bridge.box(maxGroup.Item2,System.Int32))/System.Linq.Enumerable.from(distances,System.Double).count()<Kusto.Charting.DataChartsHelper.c_minFractionOfIntervalsToDetectDistribution)return data;result=new(System.Collections.Generic.List$1(Kusto.Charting.DataItem).$ctor2)(System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).count());prevItem=null;$t=Bridge.getEnumerator(data,Kusto.Charting.DataItem);try{while($t.moveNext()){if(item=$t.Current,prevItem==null){result.add(item);prevItem=item;continue}if(currentDistance=Kusto.Charting.DataChartsHelper.GetDistance(prevItem,item,argType),currentDistance-initialDistance>Kusto.Charting.DataChartsHelper.c_doubleAcceptableApproximation){gapLength=0;try{gapLength=System.Convert.toInt32(Bridge.box(Bridge.Math.round(currentDistance/initialDistance,0,6),System.Double,System.Double.format,System.Double.getHashCode))}catch($e1){return $e1=System.Exception.create($e1),data}if(mod=currentDistance-gapLength*initialDistance,mod>Kusto.Charting.DataChartsHelper.c_doubleAcceptableApproximation)return data;for(j=1;j<gapLength;j=j+1|0){newItem=prevItem.Clone();newItem.ValueData=Number.NaN;switch(argType){case Kusto.Charting.ArgumentColumnType.Numeric:newItem.ArgumentNumeric+=initialDistance*j;newItem.ArgumentData=System.Double.format(newItem.ArgumentNumeric);break;case Kusto.Charting.ArgumentColumnType.DateTime:newItem.ArgumentDateTime=System.DateTime.addTicks(newItem.ArgumentDateTime,System.Convert.toInt64(Bridge.box(initialDistance,System.Double,System.Double.format,System.Double.getHashCode)).mul(System.Int64(j)));newItem.ArgumentData=System.DateTime.format(newItem.ArgumentDateTime);break;case Kusto.Charting.ArgumentColumnType.TimeSpan:newItem.ArgumentDateTime=System.DateTime.addTicks(newItem.ArgumentDateTime,System.Convert.toInt64(Bridge.box(initialDistance,System.Double,System.Double.format,System.Double.getHashCode)).mul(System.Int64(j)));newItem.ArgumentData=Bridge.toString(System.TimeSpan.fromTicks(System.DateTime.getTicks(newItem.ArgumentDateTime)));break}result.add(newItem)}}result.add(item);prevItem=item}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return result},ResolveArgumentType:function(data){if(data==null||!System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).any())return Kusto.Charting.ArgumentColumnType.None;var ts={};return System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).all(function(d){return!System.String.isNullOrEmpty(d.ArgumentData)&&System.String.indexOf(d.ArgumentData,":")>0&&System.TimeSpan.tryParse(d.ArgumentData,null,ts)})?Kusto.Charting.ArgumentColumnType.TimeSpan:System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).all($asm.$.Kusto.Charting.DataChartsHelper.f8)?Kusto.Charting.ArgumentColumnType.DateTime:System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).any($asm.$.Kusto.Charting.DataChartsHelper.f9)?Kusto.Charting.ArgumentColumnType.Numeric:Kusto.Charting.ArgumentColumnType.String},ValidateData:function(data,argType,limits,error){var $t,minValue,maxValue,item,seriesCount,dataPoints;if(error.v="",data==null||!System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).any())return error.v="Data was not provided",Kusto.Charting.ValidationStatus.PolicyViolationError;if(System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).where($asm.$.Kusto.Charting.DataChartsHelper.f10).any())return error.v="Data includes non-finite values",Kusto.Charting.ValidationStatus.PolicyViolationError;if(argType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).any($asm.$.Kusto.Charting.DataChartsHelper.f11))return error.v="Data includes invalid geospatial coordinates. Longitude values must be in range [-180,180]. Latitude values must be in range [-90,90].",Kusto.Charting.ValidationStatus.PolicyViolationError;if(argType===Kusto.Charting.ArgumentColumnType.DateTime&&System.TimeSpan.neq(limits.MaxDatetimePeriodError,Bridge.getDefaultValue(System.TimeSpan))){minValue=System.DateTime.getMaxValue();maxValue=System.DateTime.getMinValue();$t=Bridge.getEnumerator(data,Kusto.Charting.DataItem);try{while($t.moveNext())item=$t.Current,System.DateTime.lt(maxValue,item.ArgumentDateTime)&&(maxValue=item.ArgumentDateTime),System.DateTime.gt(minValue,item.ArgumentDateTime)&&(minValue=item.ArgumentDateTime)}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}if(System.DateTime.gt(minValue,maxValue)||System.TimeSpan.gt(System.DateTime.subdd(maxValue,minValue),limits.MaxDatetimePeriodError))return error.v="Input time range is too wide to fit into chart",Kusto.Charting.ValidationStatus.PolicyViolationError}return(seriesCount=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).select($asm.$.Kusto.Charting.DataChartsHelper.f3).distinct().count(),dataPoints=System.Linq.Enumerable.from(data,Kusto.Charting.DataItem).count(),seriesCount>limits.MaxSeriesPerChartError)?(error.v="Too many series\n"+(System.String.format("Provided data contains {0} series which exceeds allowed amount for the chart: {1}",Bridge.box(seriesCount,System.Int32),Bridge.box(limits.MaxSeriesPerChartError,System.Int32))||""),Kusto.Charting.ValidationStatus.PolicyViolationError):dataPoints>limits.MaxPointsPerChartError?(error.v="Too many points\n"+(System.String.format("Provided data contains {0} points which exceeds allowed amount for the chart: {1}",Bridge.box(dataPoints,System.Int32),Bridge.box(limits.MaxPointsPerChartError,System.Int32))||""),Kusto.Charting.ValidationStatus.PolicyViolationError):seriesCount>limits.MaxSeriesPerChartWarning||dataPoints>limits.MaxPointsPerChartWarning?(error.v="Too many series or data points\nChart can perform badly when large amount of data is used.\n"+(System.String.format("You are about to plot {0} series with {1} points.",Bridge.box(seriesCount,System.Int32),Bridge.box(dataPoints,System.Int32))||""),Kusto.Charting.ValidationStatus.PolicyViolationWarning):Kusto.Charting.ValidationStatus.Valid},ResolveJsonArrayType:function(value){var arr;try{arr=Newtonsoft.Json.JsonConvert.DeserializeObject(value,System.Array.type(System.String))}catch($e1){return $e1=System.Exception.create($e1),Kusto.Charting.ArgumentColumnType.None}return arr==null||System.Linq.Enumerable.from(arr,System.String).count()===0?Kusto.Charting.ArgumentColumnType.None:Kusto.Charting.DataChartsHelper.ArrayIsDouble(arr)?Kusto.Charting.ArgumentColumnType.Numeric:Kusto.Charting.DataChartsHelper.ArrayIsTimespan(arr)?Kusto.Charting.ArgumentColumnType.TimeSpan:Kusto.Charting.DataChartsHelper.ArrayIsDatetime(arr)?Kusto.Charting.ArgumentColumnType.DateTime:Kusto.Charting.ArgumentColumnType.String},SelectSuccessivePairs:function(collection){var $t,item;if(collection==null||System.Linq.Enumerable.from(collection,System.Double).count()<=1)return null;var result=System.Array.init(System.Linq.Enumerable.from(collection,System.Double).count()-1|0,0,System.Double),isFirstElement=!0,prev=Bridge.getDefaultValue(System.Double),idx=0;$t=Bridge.getEnumerator(collection);try{while($t.moveNext()){if(item=$t.Current,isFirstElement){isFirstElement=!1;prev=item;continue}result[System.Array.index(idx,result)]=Math.abs(item-prev);idx=idx+1|0;prev=item}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return result},GetTopGroupByCount:function(data,sequenceType){var $t,sorted=System.Linq.Enumerable.from(data,System.Double).orderBy($asm.$.Kusto.Charting.DataChartsHelper.f4),currentGroup=new(System.Collections.Generic.List$1(System.Double).$ctor2)(System.Linq.Enumerable.from(data,System.Double).count()),maxGroupCount=0,maxGroupValue=0,prevNum=null,num,diff;$t=Bridge.getEnumerator(sorted);try{while($t.moveNext()){if(num=$t.Current,!System.Nullable.hasValue(prevNum)){prevNum=num;currentGroup.add(num);continue}diff=num-System.Nullable.getValue(prevNum);diff>Kusto.Charting.DataChartsHelper.c_doubleAcceptableApproximation&&(System.Linq.Enumerable.from(currentGroup,System.Double).count()>maxGroupCount&&(maxGroupCount=System.Linq.Enumerable.from(currentGroup,System.Double).count(),maxGroupValue=Bridge.Math.round(System.Linq.Enumerable.from(currentGroup,System.Double).average(),Kusto.Charting.DataChartsHelper.c_decimalRoundingPrecision,6)),currentGroup.clear());currentGroup.add(num);prevNum=num}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return{Item1:maxGroupValue,Item2:maxGroupCount}},GetDistance:function(start,end,sequenceType){if(start==null||end==null)return-1;var distance=-1;switch(sequenceType){case Kusto.Charting.ArgumentColumnType.TimeSpan:case Kusto.Charting.ArgumentColumnType.DateTime:distance=System.Int64.toNumber(System.DateTime.getTicks(end.ArgumentDateTime).sub(System.DateTime.getTicks(start.ArgumentDateTime)));break;case Kusto.Charting.ArgumentColumnType.Numeric:distance=end.ArgumentNumeric-start.ArgumentNumeric;break}return Bridge.Math.round(Math.abs(distance),Kusto.Charting.DataChartsHelper.c_decimalRoundingPrecision,6)},ResolvePredefinedColumnsIndexes:function(data,seriesColumns,yColumns,xColumn,argumentRestrictions,metaData){var dataIsSeries=null,columns=data.Kusto$Charting$IChartingDataSource$GetSchema(),i,column,columnName,isY,isX,columnType,isSeries,value,type;if(argumentRestrictions===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&System.Linq.Enumerable.from(seriesColumns,System.String).any()&&(System.Linq.Enumerable.from(yColumns,System.String).any()||!System.String.isNullOrWhiteSpace(xColumn)))throw new Kusto.Charting.SeriesCreationException("GeospatialAsSeries: it's not possible to set both series and x/y columns.");for(i=0;i<System.Linq.Enumerable.from(columns,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count();i=i+1|0){if(column=System.Linq.Enumerable.from(columns,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(i),columnName=column.Item1,System.Linq.Enumerable.from(seriesColumns,System.String).any()&&System.Linq.Enumerable.from(seriesColumns,System.String).contains(columnName)){metaData.v.SeriesIndexesList.add(i);argumentRestrictions===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&metaData.v.GeospatiaColumnlIndexesList.add(i);continue}if(isY=System.Linq.Enumerable.from(yColumns,System.String).any()&&System.Linq.Enumerable.from(yColumns,System.String).contains(columnName),isX=!System.String.isNullOrWhiteSpace(xColumn)&&Bridge.referenceEquals(xColumn,columnName),isY||isX){if(columnType=column.Item2,isSeries=!1,System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.StringOrObject,Bridge.box(columnType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&metaData.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial&&(value=Bridge.toString(data.Kusto$Charting$IChartingDataSource$GetValue(0,i)),type=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(value),type!==Kusto.Charting.ArgumentColumnType.None&&(columnType=type,isSeries=!0)),System.Nullable.hasValue(dataIsSeries)){if(System.Nullable.getValue(dataIsSeries)!==isSeries)throw new Kusto.Charting.SeriesCreationException("Y-Axes and X-Axis both should be defined as scalars or as series");}else dataIsSeries=isSeries;if(metaData.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial)metaData.v.GeospatiaColumnlIndexesList.Count>0&&isX?metaData.v.GeospatiaColumnlIndexesList.insert(0,i):metaData.v.GeospatiaColumnlIndexesList.add(i),argumentRestrictions===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries&&(metaData.v.SeriesIndexesList.Count>0&&isX?metaData.v.SeriesIndexesList.insert(0,i):metaData.v.SeriesIndexesList.add(i));else if(isX)if(System.Enum.hasFlag(metaData.v.ArgumentColumnType,Bridge.box(columnType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))metaData.v.ArgumentDataColumnIndex=i;else throw new Kusto.Charting.SeriesCreationException(System.String.format("Type of column {0}, provided as X-Axis, does not match required by chart type",[columnName]));else if(isY)if(System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.NumericOrDateTimeOrTimeSpan,Bridge.box(columnType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))metaData.v.DataIndexesList.add(i);else throw new Kusto.Charting.SeriesCreationException(System.String.format("Column {0}, provided as Y-Axis, sould be one of types: Numeric, DateTime, Timespan",[columnName]));}}if(metaData.v.IsDataFormedAsSeries=System.Nullable.hasValue(dataIsSeries)?System.Nullable.getValue(dataIsSeries):!1,!System.Linq.Enumerable.from(metaData.v.DataIndexesList,System.Int32).any()&&System.Linq.Enumerable.from(yColumns,System.String).any()&&metaData.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial)throw new Kusto.Charting.SeriesCreationException("Any of columns defined as Y-Axes were not found in data, not of an appropriate type or used as argument or series");if(!System.String.isNullOrWhiteSpace(xColumn)&&metaData.v.ArgumentDataColumnIndex<0&&metaData.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial)throw new Kusto.Charting.SeriesCreationException(System.String.format("Column {0}, provided as X-Axis, was not found in data",[xColumn]));if(System.Linq.Enumerable.from(seriesColumns,System.String).any()&&!System.Linq.Enumerable.from(metaData.v.SeriesIndexesList,System.Int32).any())throw new Kusto.Charting.SeriesCreationException("Any of columns, provided as Series, were not found in data");},ResolveDataSeriesFromDataRow:function(result,table,columns,propertyColumns,rowIdx,baseSeriesName,argumentColumnType,accumulate,argumentDataColumnIndex){var $t,$t1,$t2,argumentValue=table.Kusto$Charting$IChartingDataSource$GetValue(rowIdx,argumentDataColumnIndex),argumentActualType=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(Bridge.toString(argumentValue)),values,j,argumentData,dataItem;$t=Bridge.getEnumerator(columns,Kusto.Charting.DataChartsHelper.ColumnDesc);try{while($t.moveNext()){var column=$t.Current,cellValue=table.Kusto$Charting$IChartingDataSource$GetValue(rowIdx,column.Index),value=($t1=Bridge.as(cellValue,System.String),$t1!=null?$t1:Bridge.toString(cellValue)),type=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(value);if(type!==Kusto.Charting.ArgumentColumnType.None&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.NumericOrDateTimeOrTimeSpan,Bridge.box(type,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))){if(values=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsDouble(value,!0),values==null||System.Linq.Enumerable.from(value,System.Char).count()===0)continue;var seriesName=System.String.isNullOrEmpty(baseSeriesName)?column.Name:(baseSeriesName||"")+":"+(column.Name||""),lastValue=0,argumentDateTime=Kusto.Charting.DataChartsHelper.GetArgumentDateTimeArray(argumentValue,argumentActualType,argumentDataColumnIndex,System.Linq.Enumerable.from(values,System.Double).count()),argumentNumeric=Kusto.Charting.DataChartsHelper.GetArgumentNumericArray(argumentValue,argumentActualType,argumentDataColumnIndex,System.Linq.Enumerable.from(values,System.Double).count()),argumentString=Kusto.Charting.DataChartsHelper.GetArgumentStringArray(argumentValue,argumentActualType,argumentDataColumnIndex,System.Linq.Enumerable.from(values,System.Double).count()),argumentProperties=System.Linq.Enumerable.from(propertyColumns,Kusto.Charting.DataChartsHelper.ColumnDesc).select(function(p){return table.Kusto$Charting$IChartingDataSource$GetValue(rowIdx,p.Index)}).select($asm.$.Kusto.Charting.DataChartsHelper.f12).ToArray(System.Object);for(j=0;j<values.length;j=j+1|0)argumentData="",System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(argumentColumnType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(argumentActualType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))?argumentData=System.DateTime.format(argumentDateTime[System.Array.index(j,argumentDateTime)]):System.Enum.hasFlag(argumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&argumentActualType===Kusto.Charting.ArgumentColumnType.Numeric?argumentData=System.Double.format(argumentNumeric[System.Array.index(j,argumentNumeric)]):System.Enum.hasFlag(argumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.String,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&(argumentData=argumentString[System.Array.index(j,argumentString)],System.String.isNullOrEmpty(argumentData)&&(argumentData=Bridge.as(argumentValue,System.String))),dataItem=($t2=new Kusto.Charting.DataItem.ctor,$t2.ArgumentData=argumentData,$t2.ArgumentDateTime=argumentDateTime[System.Array.index(j,argumentDateTime)],$t2.ArgumentNumeric=argumentNumeric[System.Array.index(j,argumentNumeric)],$t2.ValueData=accumulate?values[System.Array.index(j,values)]+lastValue:values[System.Array.index(j,values)],$t2.ValueName=column.Name,$t2.SeriesName=seriesName,$t2.Properties=Kusto.Charting.DataChartsHelper.ResolvePropertiesFromMultiValue(table,argumentProperties,propertyColumns,j),$t2),System.String.isNullOrEmpty(dataItem.ArgumentData)&&(dataItem.ArgumentData=Kusto.Charting.DataChartsHelper.c_defaultArgumentString),result.add(dataItem),lastValue=dataItem.ValueData}}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}},ResolveProperties:function(table,rowIdx,propertyColumns){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Charting.DataChartsHelper.ColumnDesc,propertyColumns)?"":Bridge.toArray(System.Linq.Enumerable.from(propertyColumns,Kusto.Charting.DataChartsHelper.ColumnDesc).select(function(column){var cellValue=table.Kusto$Charting$IChartingDataSource$GetValue(rowIdx,column.Index),value=Kusto.Charting.DataChartsHelper.ObjectToString(cellValue);return System.String.format("{0}:{1}",column.Name,value)})).join(", ")},ResolvePropertiesFromMultiValue:function(table,properties,propertyColumns,j){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Charting.DataChartsHelper.ColumnDesc,propertyColumns)?"":Bridge.toArray(System.Linq.Enumerable.from(propertyColumns,Kusto.Charting.DataChartsHelper.ColumnDesc).zip(properties,$asm.$.Kusto.Charting.DataChartsHelper.f13).select(function(kvp){var value,arr;return value=(arr=Bridge.as(kvp.Item2,System.Array.type(System.String)))!=null?arr[System.Array.index(j,arr)]:Kusto.Charting.DataChartsHelper.ObjectToString(kvp.Item2),System.String.format("{0}:{1}",kvp.Item1.Name,value)})).join(", ")},ObjectToString:function(o){var s,d;return(s=Bridge.as(o,System.String))!=null?s:Bridge.equals(d=Bridge.is(o,System.DateTime)?System.Nullable.getValue(Bridge.cast(Bridge.unbox(o,System.DateTime),System.DateTime)):null,null)?Bridge.toString(o):Kusto.Cloud.Platform.Utils.ExtendedDateTime.ToUtcString(d)},GetArgumentStringArray:function(value,argumentColumnType,argumentDataColumnIndex,count){if(!System.Enum.hasFlag(argumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.String,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||argumentDataColumnIndex<0)return System.Array.init(count,null,System.String);var result=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsString(Bridge.toString(value));return result==null?System.Array.init(count,null,System.String):result},GetArgumentNumericArray:function(value,argumentColumnType,argumentDataColumnIndex,count){if(argumentColumnType!==Kusto.Charting.ArgumentColumnType.Numeric||argumentDataColumnIndex<0)return System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,count).ToArray(System.Double);var result=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsDouble(Bridge.toString(value));return result==null?System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,count).ToArray(System.Double):result},GetArgumentDateTimeArray:function(value,argumentColumnType,argumentDataColumnIndex,count){if(!System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(argumentColumnType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||argumentDataColumnIndex<0)return System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime,count).ToArray(System.DateTime);var result=Kusto.Charting.DataChartsHelper.ParseJsonArrayAsDateTime(Bridge.toString(value),argumentColumnType);return result==null?System.Linq.Enumerable.repeat(Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime,count).ToArray(System.DateTime):result},ResolveDataItemsFromDataRow:function(result,table,columns,propertyColumns,rowIdx,baseSeriesName,argumentData,lastValues,accumulate){var $t,$t1;System.Linq.Enumerable.from(columns,Kusto.Charting.DataChartsHelper.ColumnDesc).any()||argumentData.GeospatialArgumentDataType!==Kusto.Charting.ArgumentColumnType.Geospatial||result.add(($t=new Kusto.Charting.DataItem.ctor,$t.GeoCoordinates=argumentData.GeoCoordinates,$t.SeriesName=System.String.isNullOrWhiteSpace(baseSeriesName)?"":baseSeriesName,$t.Properties=Kusto.Charting.DataChartsHelper.ResolveProperties(table,rowIdx,propertyColumns),$t));$t=Bridge.getEnumerator(columns,Kusto.Charting.DataChartsHelper.ColumnDesc);try{while($t.moveNext()){var column=$t.Current,cellValue=table.Kusto$Charting$IChartingDataSource$GetValue(rowIdx,column.Index),value=Kusto.Charting.DataChartsHelper.TryConvertToDouble(cellValue,column.Type),lastValue={},dataItem=($t1=new Kusto.Charting.DataItem.ctor,$t1.ArgumentData=argumentData.Value,$t1.ArgumentDateTime=argumentData.DateTime,$t1.ArgumentNumeric=argumentData.NumericValue,$t1.ValueName=column.Name,$t1.Properties=Kusto.Charting.DataChartsHelper.ResolveProperties(table,rowIdx,propertyColumns),$t1);argumentData.GeospatialArgumentDataType===Kusto.Charting.ArgumentColumnType.Geospatial?(dataItem.SeriesName=System.String.isNullOrWhiteSpace(baseSeriesName)?"":baseSeriesName,dataItem.GeoCoordinates=argumentData.GeoCoordinates):dataItem.SeriesName=System.String.isNullOrEmpty(baseSeriesName)?column.Name:(baseSeriesName||"")+":"+(column.Name||"");dataItem.ValueData=accumulate&&lastValues.tryGetValue(dataItem.SeriesName,lastValue)?value+lastValue.v:value;result.add(dataItem);lastValues.setItem(dataItem.SeriesName,dataItem.ValueData)}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}},GetBaseSeriesName:function(table,seriesColumns,rowIdx){var $t,baseSeriesName="",baseSeriesNameBuilder,column,columnValue;if(seriesColumns!=null){baseSeriesNameBuilder=new System.Text.StringBuilder;$t=Bridge.getEnumerator(seriesColumns,Kusto.Charting.DataChartsHelper.ColumnDesc);try{while($t.moveNext())column=$t.Current,baseSeriesNameBuilder.getLength()>0&&baseSeriesNameBuilder.append(", "),columnValue=Bridge.toString(table.Kusto$Charting$IChartingDataSource$GetValue(rowIdx,column.Index)),columnValue=System.String.isNullOrWhiteSpace(columnValue)?Kusto.Charting.DataChartsHelper.c_defaultArgumentString:columnValue,baseSeriesNameBuilder.appendFormat("{0}:{1}",column.Name,columnValue)}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}baseSeriesName=baseSeriesNameBuilder.toString()}return baseSeriesName},TrySetGeoJSONPoint:function(value,point){point.v=null;try{point.v=Newtonsoft.Json.JsonConvert.DeserializeObject(value,Kusto.Charting.DataChartsHelper.GeoJSONPoint)}catch($e1){if($e1=System.Exception.create($e1),Bridge.is($e1,Newtonsoft.Json.JsonException))return!1;else throw $e1;}if((point.v!=null?point.v.coordinates:null)==null)return!1;else if(point.v.coordinates.length!==2)return!1;return!0},GetArgumentDateTime:function(value,argumentColumnType){if(!System.Enum.hasFlag(argumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.DateTime,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&!System.Enum.hasFlag(argumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.TimeSpan,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))return Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime;if(Bridge.is(value,System.DateTime))return System.Nullable.getValue(Bridge.cast(Bridge.unbox(value,System.DateTime),System.DateTime));else if(Bridge.is(value,System.TimeSpan))return Kusto.Charting.DataChartsHelper.TimeSpanToDateTime(System.Nullable.getValue(Bridge.cast(Bridge.unbox(value,System.TimeSpan),System.TimeSpan)));return Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime},ConvertToDouble:function(obj,type){var value=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric;if(obj==null)return value;if(type===Kusto.Charting.ArgumentColumnType.DateTime)value=Kusto.Charting.DataChartsHelper.DateTimeToTotalSeconds(System.Nullable.getValue(Bridge.cast(Bridge.unbox(obj,System.DateTime),System.DateTime)));else if(type===Kusto.Charting.ArgumentColumnType.TimeSpan)value=Kusto.Charting.DataChartsHelper.TimeSpanToTotalSeconds(System.Nullable.getValue(Bridge.cast(Bridge.unbox(obj,System.TimeSpan),System.TimeSpan)));else try{value=System.Convert.toDouble(obj)}catch($e1){$e1=System.Exception.create($e1);value=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric}return value},TryConvertToDouble:function(value,type){return value==null||Kusto.Charting.DataChartsHelper.IsEmptyValue(value)?Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric:Kusto.Charting.DataChartsHelper.ConvertToDouble(value,type)},DetectChartDimensionsUsingData:function(columns,table,seriesColumns,argumentRestrictions,metaData){var $t,resolvedColumnTypes=System.Array.init(System.Linq.Enumerable.from(columns,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count(),0,Kusto.Charting.ArgumentColumnType),firstNumericColumnIndex,i,column;if(table.Kusto$Charting$IChartingDataSource$RowsCount===0)return!1;for(firstNumericColumnIndex=-1,i=0;i<System.Linq.Enumerable.from(columns,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count();i=i+1|0)if((column=System.Linq.Enumerable.from(columns,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(i),resolvedColumnTypes[System.Array.index(i,resolvedColumnTypes)]=column.Item2,!metaData.v.DataIndexesList.contains(i))&&(column.Item2===Kusto.Charting.ArgumentColumnType.String||column.Item2===Kusto.Charting.ArgumentColumnType.Object)){var item=table.Kusto$Charting$IChartingDataSource$GetValue(0,i),value=($t=Bridge.as(item,System.String),$t!=null?$t:Bridge.toString(item)),type=Kusto.Charting.DataChartsHelper.ResolveJsonArrayType(value);if(type===Kusto.Charting.ArgumentColumnType.None){!System.Linq.Enumerable.from(seriesColumns,System.String).any()&&metaData.v.ArgumentDataColumnIndex<0&&metaData.v.SeriesIndexesList.add(i);continue}resolvedColumnTypes[System.Array.index(i,resolvedColumnTypes)]=type;System.Enum.hasFlag(metaData.v.ArgumentColumnType,Bridge.box(type,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&(metaData.v.ArgumentDataColumnIndex<0||System.Enum.hasFlag(argumentRestrictions,Bridge.box(Kusto.Charting.ArgumentRestrictions.PreferLast,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions))))?metaData.v.ArgumentDataColumnIndex=i:type===Kusto.Charting.ArgumentColumnType.Numeric&&firstNumericColumnIndex<0&&(firstNumericColumnIndex=i)}return Kusto.Charting.DataChartsHelper.CompleteChartDimentionsDetection(columns,argumentRestrictions,firstNumericColumnIndex,resolvedColumnTypes,metaData)},DetectChartDimensionsUsingColumnTypesAndData:function(columns,table,argumentRestrictions,metaData){for(var column,resolvedColumnTypes,$t,firstNumericColumnIndex=-1,geoJSONPointCandidateColumns=new(System.Collections.Generic.List$1(System.Int32).ctor),geoColumnsPredefined=System.Linq.Enumerable.from(metaData.v.GeospatiaColumnlIndexesList,System.Int32).any(),i=0;i<System.Linq.Enumerable.from(columns,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count();i=i+1|0)if(!metaData.v.DataIndexesList.contains(i)&&!metaData.v.SeriesIndexesList.contains(i))if(column=System.Linq.Enumerable.from(columns,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).elementAt(i),metaData.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.StringOrObject,Bridge.box(column.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&geoJSONPointCandidateColumns.add(i),metaData.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.Numeric,Bridge.box(column.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.Linq.Enumerable.from(metaData.v.GeospatiaColumnlIndexesList,System.Int32).count()<2&&!geoColumnsPredefined)metaData.v.GeospatiaColumnlIndexesList.add(i);else if(System.Enum.hasFlag(metaData.v.ArgumentColumnType,Bridge.box(column.Item2,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&(metaData.v.ArgumentDataColumnIndex<0||System.Enum.hasFlag(argumentRestrictions,Bridge.box(Kusto.Charting.ArgumentRestrictions.PreferLast,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))))metaData.v.ArgumentDataColumnIndex=i;else if(column.Item2===Kusto.Charting.ArgumentColumnType.Numeric&&metaData.v.ArgumentDataColumnIndex!==-1&&System.Enum.hasFlag(argumentRestrictions,Bridge.box(Kusto.Charting.ArgumentRestrictions.NumericAsSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))){firstNumericColumnIndex=i;break}if(metaData.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&System.Linq.Enumerable.from(metaData.v.GeospatiaColumnlIndexesList,System.Int32).count()<2&&!geoColumnsPredefined){metaData.v.GeospatiaColumnlIndexesList.clear();$t=Bridge.getEnumerator(geoJSONPointCandidateColumns);try{while($t.moveNext()){var columnId=$t.Current,columnFirstValue=Bridge.toString(table.Kusto$Charting$IChartingDataSource$GetValue(0,columnId)),geojsonPoint={};if(Kusto.Charting.DataChartsHelper.TrySetGeoJSONPoint(columnFirstValue,geojsonPoint)){metaData.v.GeospatiaColumnlIndexesList.add(columnId);break}}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}}return resolvedColumnTypes=System.Linq.Enumerable.from(columns,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).select($asm.$.Kusto.Charting.DataChartsHelper.f14).ToArray(Kusto.Charting.ArgumentColumnType),Kusto.Charting.DataChartsHelper.CompleteChartDimentionsDetection(columns,argumentRestrictions,firstNumericColumnIndex,resolvedColumnTypes,metaData)},CompleteChartDimentionsDetection:function(columns,argumentRestrictions,firstNumericColumnIndex,resolvedColumnTypes,metaData){var $t,seriesOrArgumentDataIndex,geoColumnIndex,seriesDefaultIndex;if(metaData.v.ArgumentDataColumnIndex>=0&&System.Linq.Enumerable.from(metaData.v.SeriesIndexesList,System.Int32).any())return!0;if(metaData.v.ArgumentDataColumnIndex<0&&firstNumericColumnIndex<0&&System.Enum.hasFlag(metaData.v.ArgumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))return!1;else if(metaData.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial&&!System.Linq.Enumerable.from(metaData.v.GeospatiaColumnlIndexesList,System.Int32).any())return!1;if(metaData.v.ArgumentDataColumnIndex<0&&metaData.v.ArgumentColumnType!==Kusto.Charting.ArgumentColumnType.Geospatial){if(System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTimeOrTimeSpan,Bridge.box(metaData.v.ArgumentColumnType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType))))return!1;System.Enum.hasFlag(metaData.v.ArgumentColumnType,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))?System.Linq.Enumerable.from(columns,System.Tuple$2(System.String,Kusto.Charting.ArgumentColumnType)).count()>1&&(metaData.v.ArgumentDataColumnIndex=firstNumericColumnIndex):metaData.v.ArgumentDataColumnIndex=System.Enum.hasFlag(argumentRestrictions,Bridge.box(Kusto.Charting.ArgumentRestrictions.NotIncludedInSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))?Kusto.Charting.DataChartsHelper.GoBackwardsAndFindColumnNotInList(firstNumericColumnIndex,metaData.v.SeriesIndexes,metaData.v.DataIndexes):firstNumericColumnIndex-1|0}if(metaData.v.ArgumentDataColumnIndex<0&&System.Enum.hasFlag(argumentRestrictions,Bridge.box(Kusto.Charting.ArgumentRestrictions.MustHave,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&(metaData.v.ArgumentDataColumnIndex=0),metaData.v.ArgumentColumnType===Kusto.Charting.ArgumentColumnType.Geospatial)if(seriesOrArgumentDataIndex=Kusto.Charting.DataChartsHelper.GetFirstStringAvailableColumnIndexOrNonStringIfAbsent(resolvedColumnTypes,metaData.v.GeospatialColumnIndexes),argumentRestrictions===Kusto.Charting.ArgumentRestrictions.GeospatialAsSeries){if(metaData.v.ArgumentDataColumnIndex=seriesOrArgumentDataIndex,!System.Linq.Enumerable.from(metaData.v.SeriesIndexesList,System.Int32).any()){$t=Bridge.getEnumerator(metaData.v.GeospatiaColumnlIndexesList);try{while($t.moveNext())geoColumnIndex=$t.Current,metaData.v.SeriesIndexesList.add(geoColumnIndex)}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}}}else seriesOrArgumentDataIndex===-1||System.Linq.Enumerable.from(metaData.v.SeriesIndexesList,System.Int32).any()||metaData.v.SeriesIndexesList.add(seriesOrArgumentDataIndex);else!System.Linq.Enumerable.from(metaData.v.SeriesIndexesList,System.Int32).any()&&metaData.v.ArgumentDataColumnIndex>=0&&(seriesDefaultIndex=metaData.v.ArgumentDataColumnIndex,resolvedColumnTypes[System.Array.index(metaData.v.ArgumentDataColumnIndex,resolvedColumnTypes)]!==Kusto.Charting.ArgumentColumnType.String?seriesDefaultIndex=Kusto.Charting.DataChartsHelper.GetFirstStringColumnIndex(resolvedColumnTypes):System.Enum.hasFlag(argumentRestrictions,Bridge.box(Kusto.Charting.ArgumentRestrictions.NotIncludedInSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&(seriesDefaultIndex=metaData.v.ArgumentDataColumnIndex-1|0),metaData.v.IsDataFormedAsSeries||seriesDefaultIndex===-1&&System.Enum.hasFlag(argumentRestrictions,Bridge.box(Kusto.Charting.ArgumentRestrictions.NumericAsSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&(seriesDefaultIndex=Kusto.Charting.DataChartsHelper.GetFirstStringAvailableColumnIndexOrNonStringIfAbsent(resolvedColumnTypes,null),System.Enum.hasFlag(argumentRestrictions,Bridge.box(Kusto.Charting.ArgumentRestrictions.NotIncludedInSeries,Kusto.Charting.ArgumentRestrictions,System.Enum.toStringFn(Kusto.Charting.ArgumentRestrictions)))&&seriesDefaultIndex===metaData.v.ArgumentDataColumnIndex&&(seriesDefaultIndex=-1)),seriesDefaultIndex>=0&&!metaData.v.DataIndexesList.contains(seriesDefaultIndex)&&metaData.v.SeriesIndexesList.add(seriesDefaultIndex));return!0},GoBackwardsAndFindColumnNotInList:function(startIndex,seriesIndices,yIndexes){for(var isNotInSeries,isNotInYs,i=startIndex-1|0;i>=0;i=i-1|0)if(isNotInSeries=seriesIndices==null?!0:!System.Linq.Enumerable.from(seriesIndices,System.Int32).contains(i),isNotInYs=yIndexes==null?!0:!System.Linq.Enumerable.from(yIndexes,System.Int32).contains(i),isNotInSeries&&isNotInYs)return i;return-1},GetFirstStringColumnIndex:function(columns){for(var i=0;i<System.Linq.Enumerable.from(columns,Kusto.Charting.ArgumentColumnType).count();i=i+1|0)if(System.Linq.Enumerable.from(columns,Kusto.Charting.ArgumentColumnType).elementAt(i)===Kusto.Charting.ArgumentColumnType.String)return i;return-1},GetFirstStringAvailableColumnIndexOrNonStringIfAbsent:function(columns,indexesToExclude){for(var $t,$t1,nonStringIndex=-1,i=0;i<System.Linq.Enumerable.from(columns,Kusto.Charting.ArgumentColumnType).count();i=i+1|0)if(columns[System.Array.index(i,columns)]===Kusto.Charting.ArgumentColumnType.String&&($t=System.Nullable.not(indexesToExclude!=null?System.Linq.Enumerable.from(indexesToExclude,System.Int32).contains(i):null),$t!=null?$t:!0))return i;else nonStringIndex===-1&&($t1=System.Nullable.not(indexesToExclude!=null?System.Linq.Enumerable.from(indexesToExclude,System.Int32).contains(i):null),$t1!=null?$t1:!0)&&(nonStringIndex=i);return nonStringIndex},TimeSpanToDateTime:function(ts){return ts.getTicks().lte(System.Int64(0))?System.DateTime.getMinValue():System.DateTime.create$2(ts.getTicks(),1)},TimeSpanToTotalSeconds:function(ts){return ts.getTotalSeconds()},DateTimeToTotalSeconds:function(dt){return System.TimeSpan.fromTicks(System.DateTime.getTicks(dt)).getTotalSeconds()},ParseJsonArrayAsDateTime:function(value,columnType){if(System.String.isNullOrWhiteSpace(value)||!System.String.startsWith(value.trim(),"[",4))return null;try{if(columnType===Kusto.Charting.ArgumentColumnType.DateTime)return System.Linq.Enumerable.from(Newtonsoft.Json.JsonConvert.DeserializeObject(value,System.Array.type(System.DateTime)),System.DateTime).select($asm.$.Kusto.Charting.DataChartsHelper.f15).ToArray(System.DateTime);else if(columnType===Kusto.Charting.ArgumentColumnType.TimeSpan){var resultAsTimeSpan=Newtonsoft.Json.JsonConvert.DeserializeObject(value,System.Array.type(System.TimeSpan));return System.Linq.Enumerable.from(resultAsTimeSpan,System.TimeSpan).select($asm.$.Kusto.Charting.DataChartsHelper.f16).ToArray(System.DateTime)}}catch($e1){$e1=System.Exception.create($e1)}return null},ParseJsonArrayAsDouble:function(value,considerDateTimeAndTimeSpanAsDouble){var result,valueAsArr,resolvedValueType,d,i,val,ts,dt;if(considerDateTimeAndTimeSpanAsDouble===void 0&&(considerDateTimeAndTimeSpanAsDouble=!1),System.String.isNullOrWhiteSpace(value)||!System.String.startsWith(value.trim(),"[",4))return null;try{valueAsArr=Newtonsoft.Json.JsonConvert.DeserializeObject(value,System.Array.type(System.String));result=System.Array.init(System.Linq.Enumerable.from(valueAsArr,System.String).count(),0,System.Double)}catch($e1){return $e1=System.Exception.create($e1),null}for(resolvedValueType=Kusto.Charting.ArgumentColumnType.None,d={},i=0;i<valueAsArr.length;i=i+1|0){if(val=valueAsArr[System.Array.index(i,valueAsArr)],val==null){result[System.Array.index(i,result)]=Number.NaN;continue}else if(System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.Numeric,Bridge.box(resolvedValueType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.Double.tryParse(val,null,d)){resolvedValueType===Kusto.Charting.ArgumentColumnType.None&&(resolvedValueType=Kusto.Charting.ArgumentColumnType.Numeric);result[System.Array.index(i,result)]=d.v;continue}else if(considerDateTimeAndTimeSpanAsDouble){if(ts={},System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.TimeSpan,Bridge.box(resolvedValueType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.TimeSpan.tryParse(val,null,ts)){resolvedValueType===Kusto.Charting.ArgumentColumnType.None&&(resolvedValueType=Kusto.Charting.ArgumentColumnType.TimeSpan);result[System.Array.index(i,result)]=ts.v.getTotalSeconds();continue}if(dt={},System.Enum.hasFlag(Kusto.Charting.ArgumentColumnType.DateTime,Bridge.box(resolvedValueType,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))&&System.DateTime.tryParse(val,null,dt)){resolvedValueType===Kusto.Charting.ArgumentColumnType.None&&(resolvedValueType=Kusto.Charting.ArgumentColumnType.DateTime);result[System.Array.index(i,result)]=System.TimeSpan.fromTicks(System.DateTime.getTicks(dt.v)).getTotalSeconds();continue}}return null}return resolvedValueType!==Kusto.Charting.ArgumentColumnType.None?result:null},ParseJsonArrayAsString:function(value){if(System.String.isNullOrWhiteSpace(value)||!System.String.startsWith(value.trim(),"[",4))return null;try{return Newtonsoft.Json.JsonConvert.DeserializeObject(value,System.Array.type(System.String))}catch($e1){$e1=System.Exception.create($e1)}return null},ArrayIsTimespan:function(arr){var $t,hasTimeSpanValues=!1,ts={},val;$t=Bridge.getEnumerator(arr);try{while($t.moveNext()){if(val=$t.Current,val==null)continue;else if(System.TimeSpan.tryParse(val,null,ts)){hasTimeSpanValues=!0;continue}return!1}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return hasTimeSpanValues},ArrayIsDatetime:function(arr){var $t,hasDateTimeValues=!1,d={},val;$t=Bridge.getEnumerator(arr);try{while($t.moveNext()){if(val=$t.Current,val==null)continue;else if(System.DateTime.tryParse(val,null,d)){hasDateTimeValues=!0;continue}return!1}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return hasDateTimeValues},ArrayIsDouble:function(arr){var $t,hasNumericValues=!1,d={},val;$t=Bridge.getEnumerator(arr);try{while($t.moveNext()){if(val=$t.Current,val==null)continue;else if(System.Double.tryParse(val,null,d)){hasNumericValues=!0;continue}return!1}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return hasNumericValues},IsEmptyValue:function(value){return value==null?!0:Bridge.referenceEquals(value,System.DBNull.Value)?!0:Bridge.is(value,System.String)&&System.String.isNullOrEmpty(Bridge.cast(value,System.String))?!0:!1}}}});Bridge.ns("Kusto.Charting.DataChartsHelper",$asm.$);Bridge.apply($asm.$.Kusto.Charting.DataChartsHelper,{f1:function(col,index){return new Kusto.Charting.DataChartsHelper.ColumnDesc(col.Item1,col.Item2,index)},f2:function(colIndex){return colIndex>=0},f3:function(d){return d.SeriesName},f4:function(d){return d},f5:function(d){return System.DateTime.getTicks(d.ArgumentDateTime)},f6:function(d){return System.Convert.toDouble(System.DateTime.getTicks(d.ArgumentDateTime))},f7:function(d){return d.ArgumentNumeric},f8:function(d){return!Bridge.equals(d.ArgumentDateTime,Kusto.Charting.DataChartsHelper.c_defaultArgumentDatetime)},f9:function(d){return!isNaN(d.ArgumentNumeric)},f10:function(d){return Math.abs(d.ValueData)===Number.POSITIVE_INFINITY},f11:function(d){return d.GeoCoordinates!=null&&(d.GeoCoordinates.Longitude>180||d.GeoCoordinates.Longitude<-180||d.GeoCoordinates.Latitude>90||d.GeoCoordinates.Latitude<-90)},f12:function(o){return Kusto.Charting.DataChartsHelper.ParseJsonArrayAsString(Bridge.as(o,System.String))||o},f13:function(a,b){return{Item1:a,Item2:b}},f14:function(c){return c.Item2},f15:function(dt){return Kusto.Cloud.Platform.Utils.ExtendedDateTime.ToUtc(dt)},f16:function(ts){return Kusto.Charting.DataChartsHelper.TimeSpanToDateTime(ts)}});Bridge.define("Kusto.Charting.DataChartsHelper.ArgumentData",{$kind:"nested class",fields:{m_requestedType:0,m_colIndex:0,m_colName:null,m_colType:0,m_geospatialIndexes:null},props:{GeospatialArgumentDataType:0,Value:null,DateTime:null,NumericValue:0,GeoCoordinates:null},ctors:{init:function(){this.DateTime=System.DateTime.getDefaultValue()},ctor:function(colIndex,colName,colType,requestedType,geospatialColumnIndexes){geospatialColumnIndexes===void 0&&(geospatialColumnIndexes=null);var $t;this.$initialize();this.m_colIndex=colIndex;this.m_colName=colName;this.m_colType=colType;this.m_requestedType=requestedType;geospatialColumnIndexes!=null&&System.Linq.Enumerable.from(geospatialColumnIndexes,System.Int32).any()?(this.m_geospatialIndexes=($t=System.Int32,System.Linq.Enumerable.from(geospatialColumnIndexes,$t).toList($t)),this.GeospatialArgumentDataType=Kusto.Charting.ArgumentColumnType.Geospatial):this.GeospatialArgumentDataType=Kusto.Charting.ArgumentColumnType.None}},methods:{ResolveArgumentFromRow:function(table,rowIndex){var $t,$t1,$t2,longitudeValue,latitudeValue,geojsonPoint;if(this.m_requestedType!==Kusto.Charting.ArgumentColumnType.Geospatial){this.ResolveArgument(table,rowIndex);return}this.m_geospatialIndexes.Count===2?(longitudeValue=table.Kusto$Charting$IChartingDataSource$GetValue(rowIndex,this.m_geospatialIndexes.getItem(0)),latitudeValue=table.Kusto$Charting$IChartingDataSource$GetValue(rowIndex,this.m_geospatialIndexes.getItem(1)),this.GeoCoordinates=($t=new Kusto.Charting.GeospatialCoordinates,$t.Longitude=Kusto.Charting.DataChartsHelper.TryConvertToDouble(longitudeValue,Kusto.Charting.ArgumentColumnType.Numeric),$t.Latitude=Kusto.Charting.DataChartsHelper.TryConvertToDouble(latitudeValue,Kusto.Charting.ArgumentColumnType.Numeric),$t)):(geojsonPoint={},this.GeoCoordinates=this.m_geospatialIndexes.Count===1&&Kusto.Charting.DataChartsHelper.TrySetGeoJSONPoint(Bridge.toString(table.Kusto$Charting$IChartingDataSource$GetValue(rowIndex,this.m_geospatialIndexes.getItem(0))),geojsonPoint)?($t=new Kusto.Charting.GeospatialCoordinates,$t.Longitude=($t1=geojsonPoint.v.coordinates)[System.Array.index(0,$t1)],$t.Latitude=($t2=geojsonPoint.v.coordinates)[System.Array.index(1,$t2)],$t):($t=new Kusto.Charting.GeospatialCoordinates,$t.Longitude=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,$t.Latitude=Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric,$t));this.m_colIndex!==-1&&this.ResolveArgument(table,rowIndex,!0)},ResolveArgument:function(table,rowIndex,includeColName){var argumentValue,argumentActualType,value;includeColName===void 0&&(includeColName=!1);argumentValue=table.Kusto$Charting$IChartingDataSource$GetValue(rowIndex,this.m_colIndex);argumentActualType=argumentValue==null?this.m_requestedType:this.m_colType;this.DateTime=Kusto.Charting.DataChartsHelper.GetArgumentDateTime(argumentValue,argumentActualType);value=this.m_colIndex>=0?Bridge.toString(argumentValue):"";System.String.isNullOrWhiteSpace(value)&&(value=Kusto.Charting.DataChartsHelper.c_defaultArgumentString);this.Value=includeColName?System.String.format("{0}:{1}",this.m_colName,value):value;this.NumericValue=!System.Enum.hasFlag(argumentActualType,Bridge.box(Kusto.Charting.ArgumentColumnType.Numeric,Kusto.Charting.ArgumentColumnType,System.Enum.toStringFn(Kusto.Charting.ArgumentColumnType)))||Kusto.Charting.DataChartsHelper.IsEmptyValue(argumentValue)?Kusto.Charting.DataChartsHelper.c_defaultArgumentNumeric:Kusto.Charting.DataChartsHelper.TryConvertToDouble(argumentValue,argumentActualType)}}});Bridge.define("Kusto.Charting.IChartMetaData",{$kind:"interface"});Bridge.define("Kusto.Charting.DataChartsHelper.ColumnDesc",{$kind:"nested class",props:{Name:null,Type:0,Index:0},ctors:{ctor:function(name,type,index){this.$initialize();this.Name=name;this.Type=type;this.Index=index}}});Bridge.define("Kusto.Charting.DataChartsHelper.GeoJSON",{$kind:"nested enum",statics:{fields:{Point:0}}});Bridge.define("Kusto.Charting.DataChartsHelper.GeoJSONPoint",{$kind:"nested class",props:{type:0,coordinates:null}});Bridge.define("Kusto.Charting.DataItem",{props:{SeriesName:null,ArgumentData:null,ValueData:0,ValueName:null,ArgumentDateTime:null,ArgumentNumeric:0,GeoCoordinates:null,SecondaryAxisYName:null,PrefferredChartKind:0,Properties:null,PropertiesTruncated:{get:function(){if(System.String.isNullOrEmpty(this.Properties))return"";var maxLen=150;return this.Properties.length<maxLen?this.Properties:(this.Properties.substr(0,maxLen)||"")+"..."}}},ctors:{init:function(){this.ArgumentDateTime=System.DateTime.getDefaultValue()},ctor:function(){this.$initialize()},$ctor1:function(other){var $t;this.$initialize();this.SeriesName=other.SeriesName;this.ArgumentData=other.ArgumentData;this.ValueData=other.ValueData;this.ValueName=other.ValueName;this.ArgumentDateTime=other.ArgumentDateTime;this.ArgumentNumeric=other.ArgumentNumeric;this.SecondaryAxisYName=other.SecondaryAxisYName;this.PrefferredChartKind=other.PrefferredChartKind;this.Properties=other.Properties;this.GeoCoordinates=other.GeoCoordinates==null?null:($t=new Kusto.Charting.GeospatialCoordinates,$t.Longitude=other.GeoCoordinates.Longitude,$t.Latitude=other.GeoCoordinates.Latitude,$t)}},methods:{Clone:function(){return new Kusto.Charting.DataItem.$ctor1(this)}}});Bridge.define("Kusto.Charting.ExtendedDouble",{statics:{methods:{IsFinite:function(d){return!(Math.abs(d)===Number.POSITIVE_INFINITY)&&!isNaN(d)}}}});Bridge.define("Kusto.Charting.GeospatialCoordinates",{props:{Longitude:0,Latitude:0}});Bridge.define("Kusto.Charting.IChartingDataSource",{$kind:"interface"});Bridge.define("Kusto.Charting.IKustoClientContext",{$kind:"interface"});Bridge.define("Kusto.Charting.SeriesCreationException",{inherits:[System.Exception],ctors:{ctor:function(error){this.$initialize();System.Exception.ctor.call(this,error)}}});Bridge.define("Kusto.Charting.ValidationStatus",{$kind:"enum",statics:{fields:{Valid:0,PolicyViolationError:1,PolicyViolationWarning:2}}});Bridge.define("Kusto.Cloud.Platform.Text.StringLiteral",{statics:{fields:{MultiLineStringQuote:null,AlternateMultiLineStringQuote:null,categoryForLatin1:null},ctors:{init:function(){this.MultiLineStringQuote="```";this.AlternateMultiLineStringQuote="~~~";this.categoryForLatin1=System.Array.init([14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,24,24,24,26,24,24,24,20,21,24,25,24,19,24,24,8,8,8,8,8,8,8,8,8,8,24,24,25,25,25,24,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,24,21,27,18,27,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,20,25,21,25,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,11,24,26,26,26,26,28,28,27,28,1,22,25,19,28,27,28,25,10,10,27,1,28,24,27,10,1,23,10,10,10,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,25,1,1,1,1,1,1,1,1],System.Byte)}},methods:{ParseStringLiteral:function(literal){var _discard1={};return Kusto.Cloud.Platform.Text.StringLiteral.ParseStringLiteral$1(literal,_discard1)},ParseStringLiteral$1:function(literal,isHidden){var result={};if(Kusto.Cloud.Platform.Text.StringLiteral.TryParseStringLiteral$1(literal,result,isHidden))return result.v;throw new System.ArgumentException.$ctor1(System.String.format("Malformed string literal: '{0}'",[literal]));},TryParseStringLiteral:function(str,literal){var _discard2={};return Kusto.Cloud.Platform.Text.StringLiteral.TryParseStringLiteral$1(str,literal,_discard2)},TryParseStringLiteral$1:function(str,literal,isHidden){var multiLineLiteral,ret,ret1;if(literal.v=str,isHidden.v=!1,System.String.isNullOrWhiteSpace(literal.v))return!1;if((literal.v.charCodeAt(0)===104||literal.v.charCodeAt(0)===72)&&(isHidden.v=!0,literal.v=literal.v.substr(1)),multiLineLiteral={},Kusto.Cloud.Platform.Text.StringLiteral.TryParseMultiLineStringLiteral(literal.v,multiLineLiteral))return literal.v=multiLineLiteral.v,!0;if(System.String.startsWith(literal.v,'"',4)){if(literal.v.length>=2&&System.String.endsWith(literal.v,'"'))return(literal.v=literal.v.substr(1,literal.v.length-2|0),!Kusto.Cloud.Platform.Utils.ExtendedRegex.TryUnescape(literal.v,literal))?!1:!0}else if(System.String.startsWith(literal.v,"'",4)){if(literal.v.length>=2&&System.String.endsWith(literal.v,"'",4))return(literal.v=literal.v.substr(1,literal.v.length-2|0),!Kusto.Cloud.Platform.Utils.ExtendedRegex.TryUnescape(literal.v,literal))?!1:!0}else if(System.String.startsWith(literal.v,'@"',4)){if(literal.v.length>=3&&System.String.endsWith(literal.v,'"',4))return ret=literal.v.substr(2,literal.v.length-3|0),literal.v=System.String.replaceAll(ret,'""','"'),!0}else if(System.String.startsWith(literal.v,"@'",4)&&literal.v.length>=3&&System.String.endsWith(literal.v,"'",4))return ret1=literal.v.substr(2,literal.v.length-3|0),literal.v=System.String.replaceAll(ret1,"''","'"),!0;return!1},TryParseMultiLineStringLiteral:function(str,literal){return Kusto.Cloud.Platform.Text.StringLiteral.TryParseSimpleStringLiteral(str,Kusto.Cloud.Platform.Text.StringLiteral.MultiLineStringQuote,literal)||Kusto.Cloud.Platform.Text.StringLiteral.TryParseSimpleStringLiteral(str,Kusto.Cloud.Platform.Text.StringLiteral.AlternateMultiLineStringQuote,literal)},TryParseSimpleStringLiteral:function(str,quote,literal){if(System.String.startsWith(str,quote,4)){var twiceQuoteLen=quote.length<<1;return str.length>=twiceQuoteLen&&System.String.endsWith(str,quote,4)?(literal.v=str.substr(quote.length,str.length-twiceQuoteLen|0),!0):(literal.v=str.substr(quote.length),!0)}return literal.v=null,!1},Equals:function(str1,str2){return str1==null&&str2==null?!0:str1==null||str2==null?!1:System.String.equals(str1,str2,4)},TrimSingleQuotes:function(name){return System.String.isNullOrWhiteSpace(name)?name:(System.String.startsWith(name,"'",4)&&System.String.endsWith(name,"'",4)&&name.length>=2&&(name=name.substr(1,name.length-2|0)),name)},TrimBrackets:function(input){return System.String.startsWith(input,"[",4)&&System.String.endsWith(input,"]",4)&&input.length>=2&&(input=input.substr(1,input.length-2|0)),input},InitArray:function(T,arr,value){if(arr!=null)for(var i=0;i<arr.length;i=i+1|0)arr[System.Array.index(i,arr)]=value},GetLiteral:function(value){return Kusto.Cloud.Platform.Text.StringLiteral.GetLiteral$1(value,!1)},GetLiteral$1:function(value,hidden){var $t,literal,c;if(value==null)return null;literal=new System.Text.StringBuilder;hidden&&literal.append("h");literal.append('"');$t=Bridge.getEnumerator(value);try{while($t.moveNext()){c=$t.Current;switch(c){case 39:literal.append("\\'");break;case 34:literal.append('\\"');break;case 92:literal.append("\\\\");break;case 0:literal.append("\\0");break;case 7:literal.append("\\a");break;case 8:literal.append("\\b");break;case 12:literal.append("\\f");break;case 10:literal.append("\\n");break;case 13:literal.append("\\r");break;case 9:literal.append("\\t");break;case 11:literal.append("\\v");break;default:Kusto.Cloud.Platform.Text.StringLiteral.ShouldBeEscaped(c)?(literal.append("\\u"),literal.append(System.UInt16.format(c,"x4"))):literal.append(String.fromCharCode(c));break}}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return literal.append('"'),literal.toString()},GetLiteralAsHiddenString:function(value){return Kusto.Cloud.Platform.Text.StringLiteral.GetLiteral$1(value,!0)},ShouldBeEscaped:function(c){return Kusto.Cloud.Platform.Text.StringLiteral.IsLatin1(c)?Kusto.Cloud.Platform.Text.StringLiteral.GetLatin1UnicodeCategory(c)===14:!0},GetLatin1UnicodeCategory:function(ch){return Kusto.Cloud.Platform.Text.StringLiteral.categoryForLatin1[System.Array.index(ch,Kusto.Cloud.Platform.Text.StringLiteral.categoryForLatin1)]},IsLatin1:function(ch){return ch<=255},IsAscii:function(ch){return ch<=127}}}});Bridge.define("Kusto.Cloud.Platform.Utils.BitTwiddling",{statics:{methods:{CountBits:function(n){for(var ret=0;n!==0;)n=n&(n-1|0),ret=ret+1|0;return ret},CountBits$1:function(n){for(var ret=0;n.ne(System.Int64(0));)n=n.and(n.sub(System.Int64(1))),ret=ret+1|0;return ret}}}});Bridge.define("Kusto.Cloud.Platform.Utils.ChopOptions",{$kind:"enum",statics:{fields:{ChopFromBeginning:1,ChopFromEnd:2,ChopFromMiddle:4,ThreeDotsCharacterNotSupported:8}}});Bridge.define("Kusto.Cloud.Platform.Utils.CountConstants",{statics:{fields:{_1K:0,_64K:0,_1M:0},ctors:{init:function(){this._1K=1e3;this._64K=64e3;this._1M=1e6}}}});Bridge.define("Kusto.Cloud.Platform.Utils.DateTimeRange",{inherits:function(){return[System.IEquatable$1(Kusto.Cloud.Platform.Utils.DateTimeRange)]},$kind:"struct",statics:{fields:{All:null},ctors:{init:function(){this.All=new Kusto.Cloud.Platform.Utils.DateTimeRange;this.All=new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc,Kusto.Cloud.Platform.Utils.ExtendedDateTime.MaxValueUtc)}},methods:{Aggregate:function(a,b){return new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(System.DateTime.gt(a.Begin,b.Begin)?b.Begin:a.Begin,System.DateTime.gt(a.End,b.End)?a.End:b.End)},Merge:function(ranges){var $t,count=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastCountUpTo(Kusto.Cloud.Platform.Utils.DateTimeRange,ranges,System.Int64(2)),range;if(count.equals(System.Int64(0)))return new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange).ctor);else if(count.equals(System.Int64(1)))return new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange).$ctor1)(ranges);var result=new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange).ctor),orderedRanges=System.Linq.Enumerable.from(ranges,Kusto.Cloud.Platform.Utils.DateTimeRange).orderBy($asm.$.Kusto.Cloud.Platform.Utils.DateTimeRange.f1),firstItem=!0,begin=null,end=null;$t=Bridge.getEnumerator(orderedRanges);try{while($t.moveNext())range=$t.Current,firstItem&&(begin=range.Begin,end=range.End,firstItem=!1),System.DateTime.lte(range.Begin,end)?System.DateTime.lt(end,range.End)&&(end=range.End):(result.add(new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(System.Nullable.getValue(begin),System.Nullable.getValue(end))),begin=range.Begin,end=range.End)}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return result.add(new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(System.Nullable.getValue(begin),System.Nullable.getValue(end))),result},Intersect:function(rangeGroupA,rangeGroupB){var $t,$t1,intersectedTimeRanges,rangeFromA;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Cloud.Platform.Utils.DateTimeRange,rangeGroupA)||Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(Kusto.Cloud.Platform.Utils.DateTimeRange,rangeGroupB))return new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange).ctor);intersectedTimeRanges=new(System.Collections.Generic.HashSet$1(Kusto.Cloud.Platform.Utils.DateTimeRange).ctor);$t=Bridge.getEnumerator(rangeGroupA,Kusto.Cloud.Platform.Utils.DateTimeRange);try{while($t.moveNext()){rangeFromA=$t.Current;$t1=Bridge.getEnumerator(rangeGroupB,Kusto.Cloud.Platform.Utils.DateTimeRange);try{while($t1.moveNext()){var rangeFromB=$t1.Current,intersectedStart=System.DateTime.create$2(System.Int64.max(System.DateTime.getTicks(rangeFromA.Begin),System.DateTime.getTicks(rangeFromB.Begin)),1),intersectedEnd=System.DateTime.create$2(System.Int64.min(System.DateTime.getTicks(rangeFromA.End),System.DateTime.getTicks(rangeFromB.End)),1);System.DateTime.lte(intersectedStart,intersectedEnd)&&intersectedTimeRanges.add(new Kusto.Cloud.Platform.Utils.DateTimeRange.$ctor1(intersectedStart,intersectedEnd))}}finally{Bridge.is($t1,System.IDisposable)&&$t1.System$IDisposable$Dispose()}}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return intersectedTimeRanges},getDefaultValue:function(){return new Kusto.Cloud.Platform.Utils.DateTimeRange}}},fields:{m_begin:null,m_end:null},props:{Begin:{get:function(){return this.m_begin}},End:{get:function(){return this.m_end}},Span:{get:function(){return System.DateTime.subdd(this.End,this.Begin)}},IsOpenRange:{get:function(){return Bridge.equalsT(this.Begin,Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc)||Bridge.equalsT(this.End,Kusto.Cloud.Platform.Utils.ExtendedDateTime.MaxValueUtc)}}},alias:["equalsT","System$IEquatable$1$Kusto$Cloud$Platform$Utils$DateTimeRange$equalsT"],ctors:{init:function(){this.m_begin=System.DateTime.getDefaultValue();this.m_end=System.DateTime.getDefaultValue()},$ctor1:function(begin,end){this.$initialize();this.m_begin=begin;this.m_end=end;throw new System.ArgumentException.$ctor1("DateTimeRange construction: End parameter should be later than Begin parameter");},ctor:function(){this.$initialize()}},methods:{IsInRangeInclusive:function(value){return System.DateTime.lte(this.Begin,value)&&System.DateTime.lte(value,this.End)},IsInRangeExclusive:function(value){return System.DateTime.lt(this.Begin,value)&&System.DateTime.lt(value,this.End)},equalsT:function(other){return Bridge.equalsT(this.Begin,other.Begin)&&Bridge.equalsT(this.End,other.End)},equals:function(other){return other==null?!1:Bridge.is(other,Kusto.Cloud.Platform.Utils.DateTimeRange)?this.equalsT(System.Nullable.getValue(Bridge.cast(Bridge.unbox(other,Kusto.Cloud.Platform.Utils.DateTimeRange),Kusto.Cloud.Platform.Utils.DateTimeRange))):!1},getHashCode:function(){return Bridge.getHashCode(this.Begin)^Bridge.getHashCode(this.End)},toString:function(){return System.String.formatProvider(System.Globalization.CultureInfo.invariantCulture,"[Begin={0}, End={1}]",System.DateTime.format(this.Begin,"R"),System.DateTime.format(this.End,"R"))},$clone:function(to){var s=to||new Kusto.Cloud.Platform.Utils.DateTimeRange;return s.m_begin=this.m_begin,s.m_end=this.m_end,s}}});Bridge.ns("Kusto.Cloud.Platform.Utils.DateTimeRange",$asm.$);Bridge.apply($asm.$.Kusto.Cloud.Platform.Utils.DateTimeRange,{f1:function(r){return r.Begin}});Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedDateTime",{statics:{fields:{MaxUnixTimeMilliseconds:System.Int64(0),MinUnixTimeMilliseconds:System.Int64(0),MaxUnixTimeMicroseconds:System.Int64(0),MinUnixTimeMicroseconds:System.Int64(0),MicrosecondsPerMillisecond:System.Int64(0),TicksPerMillisecond:System.Int64(0),TicksPerSecond:System.Int64(0),TicksPerMinute:System.Int64(0),TicksPerHour:System.Int64(0),TicksPerDay:System.Int64(0),MillisPerSecond:0,MillisPerMinute:0,MillisPerHour:0,MillisPerDay:0,DaysPerYear:0,DaysPer4Years:0,DaysPer100Years:0,DaysPer400Years:0,DaysTo1601:0,DaysTo1899:0,DaysTo1970:0,DaysTo10000:0,MinTicks:System.Int64(0),MaxTicks:System.Int64(0),MaxMillis:System.Int64(0),FileTimeOffset:System.Int64(0),DoubleDateOffset:System.Int64(0),OADateMinAsTicks:System.Int64(0),OADateMinAsDouble:0,OADateMaxAsDouble:0,DatePartYear:0,DatePartDayOfYear:0,DatePartMonth:0,DatePartDay:0,MinValueUtc:null,MaxValueUtc:null,SupportedNonStandardFormats:null,EpochStart:null,s_simulating:!1,s_numCharactersInIso8601:0,ts_lastUtcNow:null,ts_lastUtcNowAsString:null,DaysToMonth365:null,DaysToMonth366:null},events:{OnStopSimulatingTime:null},props:{IsSimulatingTime:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedDateTime.s_simulating}},UtcNow:{get:function(){return System.DateTime.getUtcNow()}}},ctors:{init:function(){this.MinValueUtc=System.DateTime.getDefaultValue();this.MaxValueUtc=System.DateTime.getDefaultValue();this.EpochStart=System.DateTime.getDefaultValue();this.ts_lastUtcNow=System.DateTime.getDefaultValue();this.MaxUnixTimeMilliseconds=System.Int64([-769664001,58999]);this.MinUnixTimeMilliseconds=System.Int64([-304928768,-14468]);this.MaxUnixTimeMicroseconds=System.Int64([-864855016,58999820]);this.MinUnixTimeMicroseconds=System.Int64([13910016,-14467071]);this.MicrosecondsPerMillisecond=System.Int64(1e3);this.TicksPerMillisecond=System.Int64(1e4);this.TicksPerSecond=System.Int64(1e7);this.TicksPerMinute=System.Int64(6e8);this.TicksPerHour=System.Int64([1640261632,8]);this.TicksPerDay=System.Int64([711573504,201]);this.MillisPerSecond=1e3;this.MillisPerMinute=6e4;this.MillisPerHour=36e5;this.MillisPerDay=864e5;this.DaysPerYear=365;this.DaysPer4Years=1461;this.DaysPer100Years=36524;this.DaysPer400Years=146097;this.DaysTo1601=584388;this.DaysTo1899=693593;this.DaysTo1970=719162;this.DaysTo10000=3652059;this.MinTicks=System.Int64(0);this.MaxTicks=System.Int64([-197705729,734668917]);this.MaxMillis=System.Int64([-464735232,73466]);this.FileTimeOffset=System.Int64([578224128,117558807]);this.DoubleDateOffset=System.Int64([-880558080,139527104]);this.OADateMinAsTicks=System.Int64([-1362739200,7273949]);this.OADateMinAsDouble=-657435;this.OADateMaxAsDouble=2958466;this.DatePartYear=0;this.DatePartDayOfYear=1;this.DatePartMonth=2;this.DatePartDay=3;this.MinValueUtc=System.DateTime.create$2(System.DateTime.getTicks(System.DateTime.getMinValue()),1);this.MaxValueUtc=System.DateTime.create$2(System.DateTime.getTicks(System.DateTime.getMaxValue()),1);this.SupportedNonStandardFormats=$asm.$.Kusto.Cloud.Platform.Utils.ExtendedDateTime.f1(new(System.Collections.Generic.Dictionary$2(System.Int32,System.Array.type(System.String)).ctor));this.EpochStart=System.DateTime.create(1970,1,1,0,0,0,0,1);this.s_numCharactersInIso8601=System.DateTime.format(Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc,"O").length;this.ts_lastUtcNow=Kusto.Cloud.Platform.Utils.ExtendedDateTime.MinValueUtc;this.ts_lastUtcNowAsString=System.DateTime.format(Kusto.Cloud.Platform.Utils.ExtendedDateTime.ts_lastUtcNow,"O");this.DaysToMonth365=System.Array.init([0,31,59,90,120,151,181,212,243,273,304,334,365],System.Int32);this.DaysToMonth366=System.Array.init([0,31,60,91,121,152,182,213,244,274,305,335,366],System.Int32)}},methods:{StopSimulatingTime:function(){Kusto.Cloud.Platform.Utils.ExtendedDateTime.s_simulating=!1;Bridge.staticEquals(Kusto.Cloud.Platform.Utils.ExtendedDateTime.OnStopSimulatingTime,null)||Kusto.Cloud.Platform.Utils.ExtendedDateTime.OnStopSimulatingTime()},ToUtcString:function(value){return Kusto.Cloud.Platform.Utils.ExtendedDateTime.ToUtcString$1(value,System.Globalization.CultureInfo.invariantCulture)},ToUtcString$1:function(value,culture){var inputTime=value,utcTime=inputTime;return System.DateTime.getKind(inputTime)===0?utcTime=System.DateTime.create$2(System.DateTime.getTicks(value),1):System.DateTime.getKind(inputTime)===2&&(utcTime=System.DateTime.toUniversalTime(inputTime)),System.String.formatProvider(culture,"{0:yyyy-MM-dd HH:mm:ss.fffffff}",[Bridge.box(utcTime,System.DateTime,System.DateTime.format)])},Max:function(t1,t2){return System.DateTime.gt(t1,t2)?t1:t2},Max$1:function(t1,t2){return Bridge.equals(t2,null)?t1:Bridge.equals(t1,null)?t2:Kusto.Cloud.Platform.Utils.ExtendedDateTime.Max(System.Nullable.getValue(t1),System.Nullable.getValue(t2))},Min:function(t1,t2){return System.DateTime.lt(t1,t2)?t1:t2},Min$1:function(t1,t2){return Bridge.equals(t2,null)?t1:Bridge.equals(t1,null)?t2:Kusto.Cloud.Platform.Utils.ExtendedDateTime.Min(System.Nullable.getValue(t1),System.Nullable.getValue(t2))},RangesIntersect:function(firstStart,firstEnd,secondStart,secondEnd){return System.DateTime.gte(firstStart,secondStart)&&System.DateTime.lte(firstStart,secondEnd)||System.DateTime.gte(firstEnd,secondStart)&&System.DateTime.lte(firstEnd,secondEnd)||System.DateTime.gte(secondStart,firstStart)&&System.DateTime.lte(secondStart,firstEnd)||System.DateTime.gte(secondEnd,firstStart)&&System.DateTime.lte(secondEnd,firstEnd)},ToUnixTimeSpan:function(date){return System.DateTime.subdd(System.DateTime.toUniversalTime(date),Kusto.Cloud.Platform.Utils.ExtendedDateTime.EpochStart)},FromTimeSpan:function(timeSpan){return System.DateTime.create$2(timeSpan.getTicks())},ToZonalTimeDisplayString:function(dateTime){return System.DateTime.format(dateTime,"yyyy-MM-dd HH:mm:ss zzz")},ToUtc:function(value){switch(System.DateTime.getKind(value)){case 1:return value;case 0:return System.DateTime.create$2(System.DateTime.getTicks(value),1);case 2:return System.DateTime.toUniversalTime(value);default:throw new System.ArgumentException.$ctor1(System.String.format("DateTimeKind: {0} is not supported",[Bridge.box(System.DateTime.getKind(value),System.DateTimeKind,System.Enum.toStringFn(System.DateTimeKind))]));}},FastAppendFormattedInt7:function(sb,value){var g=System.Int64.clipu16(System.Int64(48).add(value.mod(System.Int64(10)))),f,e,d,c,b,a;value=value.div(System.Int64(10));f=System.Int64.clipu16(System.Int64(48).add(value.mod(System.Int64(10))));value=value.div(System.Int64(10));e=System.Int64.clipu16(System.Int64(48).add(value.mod(System.Int64(10))));value=value.div(System.Int64(10));d=System.Int64.clipu16(System.Int64(48).add(value.mod(System.Int64(10))));value=value.div(System.Int64(10));c=System.Int64.clipu16(System.Int64(48).add(value.mod(System.Int64(10))));value=value.div(System.Int64(10));b=System.Int64.clipu16(System.Int64(48).add(value.mod(System.Int64(10))));value=value.div(System.Int64(10));a=System.Int64.clipu16(System.Int64(48).add(value.mod(System.Int64(10))));sb.append(String.fromCharCode(a));sb.append(String.fromCharCode(b));sb.append(String.fromCharCode(c));sb.append(String.fromCharCode(d));sb.append(String.fromCharCode(e));sb.append(String.fromCharCode(f));sb.append(String.fromCharCode(g))},FastAppendFormattedInt4:function(sb,value){var d=(48+value%10|0)&65535,c,b,a;value=Bridge.Int.div(value,10)|0;c=(48+value%10|0)&65535;value=Bridge.Int.div(value,10)|0;b=(48+value%10|0)&65535;value=Bridge.Int.div(value,10)|0;a=(48+value%10|0)&65535;sb.append(String.fromCharCode(a));sb.append(String.fromCharCode(b));sb.append(String.fromCharCode(c));sb.append(String.fromCharCode(d))},FastAppendFormattedInt2:function(sb,value){var b=(48+value%10|0)&65535,a;value=Bridge.Int.div(value,10)|0;a=(48+value%10|0)&65535;sb.append(String.fromCharCode(a));sb.append(String.fromCharCode(b))},FastGetParts:function(value,year,month,day,hour,minute,second,fraction){var ticks=System.DateTime.getTicks(value),n=System.Int64.clip32(ticks.div(Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerDay)),y400=Bridge.Int.div(n,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer400Years)|0,y100,y4,y1;n=n-Bridge.Int.mul(y400,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer400Years)|0;y100=Bridge.Int.div(n,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer100Years)|0;y100===4&&(y100=3);n=n-Bridge.Int.mul(y100,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer100Years)|0;y4=Bridge.Int.div(n,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer4Years)|0;n=n-Bridge.Int.mul(y4,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPer4Years)|0;y1=Bridge.Int.div(n,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPerYear)|0;y1===4&&(y1=3);year.v=(((Bridge.Int.mul(y400,400)+Bridge.Int.mul(y100,100)|0)+Bridge.Int.mul(y4,4)|0)+y1|0)+1|0;n=n-Bridge.Int.mul(y1,Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysPerYear)|0;for(var leapYear=y1===3&&(y4!==24||y100===3),days=leapYear?Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysToMonth366:Kusto.Cloud.Platform.Utils.ExtendedDateTime.DaysToMonth365,m=n>>6;n>=days[System.Array.index(m,days)];)m=m+1|0;month.v=m;day.v=(n-days[System.Array.index(m-1|0,days)]|0)+1|0;hour.v=System.DateTime.getHour(value);minute.v=System.DateTime.getMinute(value);second.v=System.DateTime.getSecond(value);fraction.v=ticks.mod(Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerSecond)},FromUnixTimeSeconds$1:function(seconds){return System.DateTimeOffset.FromUnixTimeSeconds(seconds).UtcDateTime},FromUnixTimeSeconds:function(seconds){var secondsLong=Bridge.Int.clip64(seconds),additionTicks=Bridge.Int.clip64((seconds-System.Int64.toNumber(secondsLong))*Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerSecond);return System.DateTimeOffset.FromUnixTimeSeconds(secondsLong).AddTicks(additionTicks).UtcDateTime},FromUnixTimeMilliseconds$1:function(milliseconds){return System.DateTimeOffset.FromUnixTimeMilliseconds(milliseconds).UtcDateTime},FromUnixTimeMilliseconds:function(milliseconds){var millisecondsLong=Bridge.Int.clip64(milliseconds),additionTicks=Bridge.Int.clip64((milliseconds-System.Int64.toNumber(millisecondsLong))*Kusto.Cloud.Platform.Utils.ExtendedDateTime.TicksPerMillisecond);return System.DateTimeOffset.FromUnixTimeMilliseconds(millisecondsLong).AddTicks(additionTicks).UtcDateTime},FromUnixTimeMicroseconds$1:function(microseconds){var TicksPerMicrosecond=System.Int64(10),MicrosecondsPerMillisecond=System.Int64(1e3),milliseconds=microseconds.div(MicrosecondsPerMillisecond),additionTicks=microseconds.sub(milliseconds.mul(MicrosecondsPerMillisecond)).mul(TicksPerMicrosecond);return System.DateTimeOffset.FromUnixTimeMilliseconds(milliseconds).AddTicks(additionTicks).UtcDateTime},FromUnixTimeMicroseconds:function(microseconds){var TicksPerMicrosecond=System.Int64(10),MicrosecondsPerMillisecond=System.Int64(1e3),milliseconds=Bridge.Int.clip64(microseconds/MicrosecondsPerMillisecond),additionTicks=Bridge.Int.clip64((microseconds-System.Int64.toNumber(milliseconds.mul(MicrosecondsPerMillisecond)))*TicksPerMicrosecond);return System.DateTimeOffset.FromUnixTimeMilliseconds(milliseconds).AddTicks(additionTicks).UtcDateTime},FromUnixTimeNanoseconds:function(nanoseconds){var NanosecondsPerTick=System.Int64(100),NanosecondsPerMillisecond=System.Int64(1e6),milliseconds=nanoseconds.div(NanosecondsPerMillisecond),additionTicks=nanoseconds.sub(milliseconds.mul(NanosecondsPerMillisecond)).div(NanosecondsPerTick);return System.DateTimeOffset.FromUnixTimeMilliseconds(milliseconds).AddTicks(additionTicks).UtcDateTime}}}});Bridge.ns("Kusto.Cloud.Platform.Utils.ExtendedDateTime",$asm.$);Bridge.apply($asm.$.Kusto.Cloud.Platform.Utils.ExtendedDateTime,{f1:function(_o1){return _o1.add(4,System.Array.init(["yyyy"],System.String)),_o1.add(6,System.Array.init(["yyyyMM"],System.String)),_o1.add(8,System.Array.init(["yyyyMMdd"],System.String)),_o1.add(10,System.Array.init(["yyyyMMddHH"],System.String)),_o1.add(12,System.Array.init(["yyyyMMddHHmm"],System.String)),_o1.add(14,System.Array.init(["yyyyMMddHHmmss"],System.String)),_o1.add(17,System.Array.init(["yyyyMMdd HH:mm:ss"],System.String)),_o1.add(19,System.Array.init(["yyyyMMdd HH:mm:ss.f"],System.String)),_o1.add(20,System.Array.init(["yyyyMMdd HH:mm:ss.ff"],System.String)),_o1.add(21,System.Array.init(["yyyyMMdd HH:mm:ss.fff"],System.String)),_o1.add(22,System.Array.init(["yyyyMMdd HH:mm:ss.ffff"],System.String)),_o1.add(23,System.Array.init(["yyyyMMdd HH:mm:ss.fffff"],System.String)),_o1.add(24,System.Array.init(["yyyyMMdd HH:mm:ss.ffffff"],System.String)),_o1.add(25,System.Array.init(["yyyyMMdd HH:mm:ss.fffffff"],System.String)),_o1}});Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedDateTime.RoundTo",{$kind:"nested enum",statics:{fields:{Second:0,Minute:1,Hour:2,Day:3}}});Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedEnumerable",{statics:{methods:{LongCount:function(TSource,source,maxCount){if(maxCount.equals(System.Int64.MaxValue))return System.Linq.Enumerable.from(source,TSource).count();if(source==null)throw new System.ArgumentNullException.$ctor1("source");if(maxCount.lt(System.Int64(0)))throw new System.ArgumentOutOfRangeException.$ctor1("maxCount");var count=System.Int64(0),e=Bridge.getEnumerator(source,TSource);try{while(e.System$Collections$IEnumerator$moveNext())if(count=count.inc(1),count.equals(maxCount))break}finally{Bridge.hasValue(e)&&e.System$IDisposable$Dispose()}return count},SafeFastDistinct:function(T,collection){var asICollectionT,asICollection;return collection==null?null:(asICollectionT=Bridge.as(collection,System.Collections.Generic.ICollection$1(T)))!=null&&System.Array.getCount(asICollectionT,T)<=1?collection:(asICollection=Bridge.as(collection,System.Collections.ICollection))!=null&&System.Array.getCount(asICollection)<=1?collection:System.Linq.Enumerable.from(collection,T).distinct()},SafeFastCountUpTo:function(T,collection,maxCount){var asICollectionT,asICollection;if(maxCount.lt(System.Int64(0)))throw new System.ArgumentOutOfRangeException.$ctor1("maxCount");return collection==null?System.Int64(0):(asICollectionT=Bridge.as(collection,System.Collections.Generic.ICollection$1(T)))!=null?System.Int64.min(maxCount,System.Int64(System.Array.getCount(asICollectionT,T))):(asICollection=Bridge.as(collection,System.Collections.ICollection))!=null?System.Int64.min(maxCount,System.Int64(System.Array.getCount(asICollection))):Kusto.Cloud.Platform.Utils.ExtendedEnumerable.LongCount(T,collection,maxCount)},SafeSequenceEquals:function(T,collection,other,equalityComparer){equalityComparer===void 0&&(equalityComparer=null);var basicComparison=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.BasicCompare(T,collection,other);return System.Nullable.hasValue(basicComparison)?System.Nullable.getValue(basicComparison):System.Linq.Enumerable.from(System.Linq.Enumerable.from(collection,T).orderBy($asm.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f1),T).sequenceEqual(System.Linq.Enumerable.from(other,T).orderBy($asm.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f2),equalityComparer)},SortedSequenceEquals:function(T,sortedCollection1,sortedCollection2,equalityComparer){var $t,basicComparison;return(equalityComparer===void 0&&(equalityComparer=null),basicComparison=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.BasicCompare(T,sortedCollection1,sortedCollection2),System.Nullable.hasValue(basicComparison))?System.Nullable.getValue(basicComparison):Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SequenceEqual(T,sortedCollection1,sortedCollection2,Bridge.fn.cacheBind($t=equalityComparer||System.Collections.Generic.EqualityComparer$1(T).def,$t)[Bridge.geti($t,"System$Collections$Generic$IEqualityComparer$1$"+Bridge.getTypeAlias(T)+"$equals2","System$Collections$Generic$IEqualityComparer$1$equals2")])},SequenceEqual:function(T,collection,other,predicate){var basicComparison=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.BasicCompare(T,collection,other),enumerator1,enumerator2;if(System.Nullable.hasValue(basicComparison))return System.Nullable.getValue(basicComparison);enumerator1=Bridge.getEnumerator(collection,T);try{enumerator2=Bridge.getEnumerator(other,T);try{while(enumerator1.System$Collections$IEnumerator$moveNext())if(!enumerator2.System$Collections$IEnumerator$moveNext()||!predicate(enumerator1[Bridge.geti(enumerator1,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(T)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")],enumerator2[Bridge.geti(enumerator2,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(T)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]))return!1;if(enumerator2.System$Collections$IEnumerator$moveNext())return!1}finally{Bridge.hasValue(enumerator2)&&enumerator2.System$IDisposable$Dispose()}}finally{Bridge.hasValue(enumerator1)&&enumerator1.System$IDisposable$Dispose()}return!0},SafeSetEquals:function(T,that,other){return Bridge.referenceEquals(that,other)?!0:that==null||other==null?!1:new(System.Collections.Generic.HashSet$1(T).$ctor1)(that).setEquals(other)},BasicCompare:function(T,collection,other){if(Bridge.referenceEquals(collection,other))return!0;if(collection==null||other==null)return!1;var length1=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.GetSequenceLength(T,collection),length2=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.GetSequenceLength(T,other);return System.Nullable.hasValue(length1)&&System.Nullable.hasValue(length2)&&System.Nullable.getValue(length1).ne(System.Nullable.getValue(length2))?!1:null},GetSequenceLength:function(T,sequence){var asArrayT,asIReadOnlyCollectionT,asICollectionT,asICollection;return(asArrayT=Bridge.as(sequence,System.Array.type(T)))!=null?System.Int64.lift(asArrayT.length):(asIReadOnlyCollectionT=Bridge.as(sequence,System.Collections.Generic.IReadOnlyCollection$1(T)))!=null?System.Int64.lift(System.Array.getCount(asIReadOnlyCollectionT,T)):(asICollectionT=Bridge.as(sequence,System.Collections.Generic.ICollection$1(T)))!=null?System.Int64.lift(System.Array.getCount(asICollectionT,T)):(asICollection=Bridge.as(sequence,System.Collections.ICollection))!=null?System.Int64.lift(System.Array.getCount(asICollection)):System.Int64.lift(null)},ToDisplayString:function(T,collection,delimiter,maxTake,nullString,estimatedStringSize,elementPrefix,elementPostfix){var $t,$t1,$t2,$t3,toStringRes,toStringRes1;if(delimiter===void 0&&(delimiter=", "),maxTake===void 0&&(maxTake=null),nullString===void 0&&(nullString="null"),estimatedStringSize===void 0&&(estimatedStringSize=128),elementPrefix===void 0&&(elementPrefix=""),elementPostfix===void 0&&(elementPostfix=""),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(T,collection)||System.Nullable.lte(maxTake,0))return"";delimiter=($t=delimiter,$t!=null?$t:", ");nullString=($t1=nullString,$t1!=null?$t1:"null");var displayStringBuilder=new System.Text.StringBuilder("",estimatedStringSize),itemsPassed=0,enumerator=Bridge.getEnumerator(collection,T);try{for(enumerator.System$Collections$IEnumerator$moveNext()&&(toStringRes=($t2=enumerator[Bridge.geti(enumerator,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(T)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")])!=null?Bridge.toString($t2):null,displayStringBuilder.append(toStringRes!=null?(elementPrefix||"")+(toStringRes||"")+(elementPostfix||""):nullString),itemsPassed=itemsPassed+1|0);enumerator.System$Collections$IEnumerator$moveNext()&&!System.Nullable.gte(itemsPassed,maxTake);)displayStringBuilder.append(delimiter),toStringRes1=($t3=enumerator[Bridge.geti(enumerator,"System$Collections$Generic$IEnumerator$1$"+Bridge.getTypeAlias(T)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")])!=null?Bridge.toString($t3):null,displayStringBuilder.append(toStringRes1!=null?(elementPrefix||"")+(toStringRes1||"")+(elementPostfix||""):nullString),itemsPassed=itemsPassed+1|0;enumerator.System$Collections$IEnumerator$moveNext()&&(displayStringBuilder=displayStringBuilder.append(delimiter).append("... more"))}finally{Bridge.hasValue(enumerator)&&enumerator.System$IDisposable$Dispose()}return displayStringBuilder.toString()},SafeShallowClone:function(T,collection){return collection==null?null:new(System.Collections.Generic.List$1(T).$ctor1)(collection)},IndexOf:function(TCollection,collection,predicate){var $t,i,item;if(Bridge.staticEquals(predicate,null)||collection==null)return-1;i=0;$t=Bridge.getEnumerator(collection,TCollection);try{while($t.moveNext()){if(item=$t.Current,predicate(item))return i;i=i+1|0}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return-1},SafeConcat:function(T,first,second){return first==null?second:second==null?first:System.Linq.Enumerable.from(first,T).concat(second)},SafeUnion:function(T,first,second){return first==null&&second==null?null:first==null?System.Linq.Enumerable.from(second,T).distinct():second==null?System.Linq.Enumerable.from(first,T).distinct():System.Linq.Enumerable.from(first,T).union(second)},SafeFastNullIfEmpty:function(TCollection,collection){return collection==null||Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone(collection)?null:collection},SafeEmptyIEnumerableIfNull:function(T,collectionEnumerable){return collectionEnumerable||System.Linq.Enumerable.empty()},SafeFastAny$2:function(T,collection){var asICollection,asIReadOnlyCollection;return collection==null?!1:(asICollection=Bridge.as(collection,System.Collections.ICollection))!=null?System.Array.getCount(asICollection)!==0:(asIReadOnlyCollection=Bridge.as(collection,System.Collections.Generic.IReadOnlyCollection$1(T)))!=null?System.Array.getCount(asIReadOnlyCollection,T)!==0:System.Linq.Enumerable.from(collection,T).any()},SafeFastAny$4:function(T,list){return list!=null&&list.Count>0},SafeFastAny$1:function(T,collection){return collection!=null&&System.Array.getCount(collection,T)>0},SafeFastAny:function(collection){var $t,asICollection,e;if(collection==null)return!1;if((asICollection=Bridge.as(collection,System.Collections.ICollection))!=null)return System.Array.getCount(asICollection)!==0;e=Bridge.getEnumerator(collection);$t=Bridge.as(e,System.IDisposable);try{if(e.System$Collections$IEnumerator$moveNext())return!0}finally{Bridge.hasValue($t)&&$t.System$IDisposable$Dispose()}return!1},SafeFastAny$3:function(T,collection,predicate){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(T,collection)?System.Linq.Enumerable.from(collection,T).any(predicate):!1},SafeFastNone$2:function(T,collection){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(T,collection)},SafeFastNone$1:function(T,collection){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(T,collection)},SafeFastNone:function(collection){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny(collection)},SafeFastNone$3:function(T,collection,predicate){return!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$3(T,collection,predicate)},None$1:function(T,source,predicate){return!System.Linq.Enumerable.from(source,T).any(predicate)},None:function(T,source){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(T,source)},SafeFastContains:function(T,collection,item,comparer){return(comparer===void 0&&(comparer=null),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(T,collection))?!1:System.Linq.Enumerable.from(collection,T).contains(item,comparer)},DistinctBy:function(T,TKey,source,keySelector){return System.Linq.Enumerable.from(source,T).groupBy(keySelector).select($asm.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f3)},Intersect:function(T,collections){var enumerator,result;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(System.Collections.Generic.IEnumerable$1(T),collections))return null;if(enumerator=Bridge.getEnumerator(collections,System.Collections.Generic.IEnumerable$1(T)),enumerator.System$Collections$IEnumerator$moveNext()){for(result=new(System.Collections.Generic.HashSet$1(T).$ctor1)(enumerator[Bridge.geti(enumerator,"System$Collections$Generic$IEnumerator$1$System$Collections$Generic$IEnumerable$1$"+Bridge.getTypeAlias(T)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]);enumerator.System$Collections$IEnumerator$moveNext();)result.intersectWith(enumerator[Bridge.geti(enumerator,"System$Collections$Generic$IEnumerator$1$System$Collections$Generic$IEnumerable$1$"+Bridge.getTypeAlias(T)+"$Current$1","System$Collections$Generic$IEnumerator$1$Current$1")]);return result}return null},SplitBy:function(T,TR,collection,isFirst,transform){var $t,typeOfT,list1,list2;if(transform===void 0&&(transform=null),typeOfT=T,Kusto.Cloud.Platform.Utils.ExtendedEnumerable.IsTupleType(typeOfT)&&Bridge.staticEquals(transform,null)?transform=$asm.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable.f4:Bridge.referenceEquals(typeOfT,TR)&&Bridge.staticEquals(transform,null)&&(transform=function(t){return Bridge.cast(Bridge.unbox(t,TR),TR)}),Bridge.staticEquals(transform,null))throw new System.NullReferenceException.ctor;list1=new(System.Collections.Generic.List$1(TR).ctor);list2=new(System.Collections.Generic.List$1(TR).ctor);$t=Bridge.getEnumerator(collection,T);try{while($t.moveNext()){var item=$t.Current,itemToAdd=transform(item),first=isFirst(item);switch(first){case null:case undefined:continue;case!0:list1.add(itemToAdd);break;default:list2.add(itemToAdd);break}}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return{Item1:list1,Item2:list2}},IntersectWith:function(T,collection,other){if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(T,collection)||Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(T,other))return System.Linq.Enumerable.empty();var result=new(System.Collections.Generic.HashSet$1(T).$ctor1)(collection);return result.intersectWith(other),result},IsTupleType:function(type,checkBaseTypes){if(checkBaseTypes===void 0&&(checkBaseTypes=!1),type==null)throw new System.ArgumentNullException.$ctor1("type");if(Bridge.referenceEquals(type,System.Tuple))return!0;while(type!=null){if(Bridge.Reflection.isGenericType(type)){var genType=Bridge.Reflection.getGenericTypeDefinition(type);if(Bridge.referenceEquals(genType,System.Tuple$1)||Bridge.referenceEquals(genType,System.Tuple$2)||Bridge.referenceEquals(genType,System.Tuple$3)||Bridge.referenceEquals(genType,System.Tuple$4)||Bridge.referenceEquals(genType,System.Tuple$5)||Bridge.referenceEquals(genType,System.Tuple$6)||Bridge.referenceEquals(genType,System.Tuple$7)||Bridge.referenceEquals(genType,System.Tuple$8)||Bridge.referenceEquals(genType,System.Tuple$8))return!0}if(!checkBaseTypes)break;type=Bridge.Reflection.getBaseType(type)}return!1}}}});Bridge.ns("Kusto.Cloud.Platform.Utils.ExtendedEnumerable",$asm.$);Bridge.apply($asm.$.Kusto.Cloud.Platform.Utils.ExtendedEnumerable,{f1:function(item){return item},f2:function(items){return items},f3:function(x){return x.first()},f4:function(t){return t.Item1}});Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedRegex",{statics:{methods:{TryUnescape:function(str,result){result.v="";try{return result.v=System.Text.RegularExpressions.Regex.unescape(str),!0}catch($e1){if($e1=System.Exception.create($e1),Bridge.is($e1,System.ArgumentException))return!1;else throw $e1;}},TryTransformWildCardPatternToRegex:function(wildcardPattern){try{var input=System.String.trim(wildcardPattern,[91,93]),regexString=System.String.replaceAll(input,"*",".*");return new System.Text.RegularExpressions.Regex.ctor(regexString,0)}catch($e1){return $e1=System.Exception.create($e1),null}},IsWildCardPattern:function(wildcardPattern){return System.String.indexOf(wildcardPattern,String.fromCharCode(42))>=0},RegexEquals:function(regex,other){if(Bridge.referenceEquals(regex,other))return!0;var otherAsRegex;return regex==null||other==null||!((otherAsRegex=Bridge.as(other,System.Text.RegularExpressions.Regex))!=null)?!1:Kusto.Cloud.Platform.Utils.ExtendedRegex.RegexEquals$1(regex,otherAsRegex)},RegexEquals$1:function(regex,other){return Bridge.referenceEquals(regex,other)?!0:regex==null||other==null?!1:System.String.equals(Bridge.toString(regex),Bridge.toString(other))&&regex.getOptions()===other.getOptions()&&System.TimeSpan.eq(regex.getMatchTimeout(),other.getMatchTimeout())},RegexEquivalent:function(regex,other){return Bridge.referenceEquals(regex,other)?!0:regex==null||other==null?!1:System.String.equals(Bridge.toString(regex),Bridge.toString(other))&&regex.getOptions()===other.getOptions()},ReplaceAndCountReplacements:function(regex,input,replacement,replacesCount){var count=0,result=regex.replace(input,function(match){return count=count+1|0,replacement});return replacesCount.v=count,result}}}});Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedString",{statics:{fields:{c_postfix:null,c_wrap:null,c_newlineAsStringArray:null,c_nullGuids:null,SafeToString:null,EmptyArray:null,s_alternativeSpaceChars:null,s_alternativeNewlineChars:null,s_alternativeQutoes:null},ctors:{init:function(){this.c_postfix="...";this.c_wrap="  ";this.c_newlineAsStringArray=System.Array.init(["\n"],System.String);this.c_nullGuids=System.Array.init([System.Guid.Empty.toString(),"{"+(System.Guid.Empty.toString()||"")+"}"],System.String);this.SafeToString=$asm.$.Kusto.Cloud.Platform.Utils.ExtendedString.f1;this.EmptyArray=System.Array.init(0,null,System.String);this.s_alternativeSpaceChars=$asm.$.Kusto.Cloud.Platform.Utils.ExtendedString.f2(new(System.Collections.Generic.HashSet$1(System.Char).ctor));this.s_alternativeNewlineChars=$asm.$.Kusto.Cloud.Platform.Utils.ExtendedString.f3(new(System.Collections.Generic.HashSet$1(System.Char).ctor));this.s_alternativeQutoes=$asm.$.Kusto.Cloud.Platform.Utils.ExtendedString.f4(new(System.Collections.Generic.HashSet$1(System.Char).ctor))}},methods:{SafeGetHashCode:function(value){return value==null?20080512:Bridge.getHashCode(value)},GuidSafeFastGetHashCode:function(value){return value==null||value.length<26?Kusto.Cloud.Platform.Utils.ExtendedString.SafeGetHashCode(value):(value.charCodeAt(1)^value.charCodeAt(9)<<8|value.charCodeAt(10))^(value.charCodeAt(16)<<16|value.charCodeAt(17))^(value.charCodeAt(24)<<24|value.charCodeAt(25))},SafeToTraceString:function(value){return value==null?"[null]":value.length===0?"[empty]":value},SafeFormat:function(format,args){var args2,a,arg,arg2,argStr;if(args===void 0&&(args=[]),format==null)return"[format:null]";if(args==null||args.length===0)return System.String.format.apply(System.String,[format].concat(args));for(args2=System.Array.init(args.length,null,System.String),a=0;a<args.length;a=a+1|0)arg=args[System.Array.index(a,args)],arg==null?arg2="[null]":(argStr=Bridge.toString(arg),arg2=argStr==null?"[ToStringNull]":argStr.length===0?"[ToStringEmpty]":System.String.isNullOrWhiteSpace(argStr)?"[ToStringWhitespace]":argStr),args2[System.Array.index(a,args2)]=arg2;return System.String.format.apply(System.String,[format].concat(args2))},FormatWithCurrentCulture:function(format,args){return args===void 0&&(args=[]),Kusto.Cloud.Platform.Utils.ExtendedString.FormatWith(format,System.Globalization.CultureInfo.getCurrentCulture(),args)},FormatWithInvariantCulture:function(format,args){return args===void 0&&(args=[]),Kusto.Cloud.Platform.Utils.ExtendedString.FormatWith(format,System.Globalization.CultureInfo.invariantCulture,args)},FormatWith:function(format,formatProvider,args){return args===void 0&&(args=[]),System.String.formatProvider.apply(System.String,[formatProvider,format].concat(args))},SafeIsNullGuid:function(value){return System.String.isNullOrWhiteSpace(value)||Bridge.referenceEquals(value,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids[System.Array.index(0,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids)])||Bridge.referenceEquals(value,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids[System.Array.index(1,Kusto.Cloud.Platform.Utils.ExtendedString.c_nullGuids)])},SafeIsValidGuid:function(value){var _discard1={v:new System.Guid};return!Kusto.Cloud.Platform.Utils.ExtendedString.SafeIsNullGuid(value)&&System.Guid.TryParse(value,_discard1)},GetDiff:function(lhs,rhs){var i;if(Bridge.referenceEquals(lhs,rhs)){if(lhs==null)return"Strings are the same (both null)";else if(Bridge.referenceEquals(lhs,""))return"Strings are the same (both empty)";return"Strings are the same"}if(lhs==null)return"LHS is null, RHS is not";if(rhs==null)return"RHS is null, LHS is not";for(i=0;i<Math.min(lhs.length,rhs.length);i=i+1|0)if(lhs.charCodeAt(i)!==rhs.charCodeAt(i))return Kusto.Cloud.Platform.Utils.ExtendedString.GetDiffFromPosition(lhs,rhs,i);return Kusto.Cloud.Platform.Utils.ExtendedString.GetDiffFromPosition(lhs,rhs,Math.min(lhs.length,rhs.length))},GetDiffFromPosition:function(lhs,rhs,position){var before=20,after=20,start=Math.max(0,position-before|0),count=before+after|0;return"Strings differ starting from position "+(Bridge.toString(position)||"")+" \nLHS=...'"+(Kusto.Cloud.Platform.Utils.ExtendedString.SafeSubstring(lhs,start,count)||"")+"'...\nRHS=...'"+(Kusto.Cloud.Platform.Utils.ExtendedString.SafeSubstring(rhs,start,count)||"")+"'...\n"+(System.String.fromCharCount(32,((start===0?position:before)+1|0)+7|0)||"")+"^"},SafeSubstring:function(value,startIndex,count){return value==null?null:(startIndex=Math.max(0,startIndex),startIndex>=value.length)?"":count<=0?"":(count=Math.min(count,value.length-startIndex|0),value.substr(startIndex,count))},SafeIsValidNonEmptyBase64:function(value,allowWhitespace){var $t,offsetFirstEquality,i,c,j;if((allowWhitespace===void 0&&(allowWhitespace=!1),allowWhitespace&&value!=null&&(value=value.trim()),System.String.isNullOrEmpty(value))||value.length%4!=0)return!1;offsetFirstEquality=-1;i=-1;$t=Bridge.getEnumerator(value);try{while($t.moveNext())if(c=$t.Current,i=i+1|0,(!(c>=48)||!(c<=57))&&(!(c>=65)||!(c<=90))&&(!(c>=97)||!(c<=122))&&c!==43&&c!==47){if(c===61){offsetFirstEquality=i;break}return!1}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}if(offsetFirstEquality===-1)return value.length%4==0;if((value.length-offsetFirstEquality|0)>3)return!1;for(j=offsetFirstEquality;j<value.length;j=j+1|0)if(value.charCodeAt(j)!==61)return!1;return!0},SafeIsDoubleSlashCommentOrEmptyBlock:function(cmd){if(System.String.isNullOrWhiteSpace(cmd))return!0;for(var slash=!1,i=0,c;;){if(i>=cmd.length)return!slash;if(c=cmd.charCodeAt(i),c===47){if(slash){while((i=i+1|0)<cmd.length)if(c=cmd.charCodeAt(i),c===13||c===10)break;slash=!1}else slash=!0;i=i+1|0;continue}if(slash)return!1;if(System.Char.isWhiteSpace(String.fromCharCode(c))||c===13||c===10){i=i+1|0;continue}return!1}},SafeFastTrimEmptyLines:function(text){var nextNewLine;if(System.String.isNullOrEmpty(text)||System.String.indexOf(text,"\n")===-1)return text;for(var sb=Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache.Acquire(Math.min(text.length,Kusto.Cloud.Platform.Utils.MemoryConstants.LargeObjectHeapChars)),hasPrecedingText=!1,i=0;i<text.length;){if(nextNewLine=System.String.indexOf(text,"\n",i),nextNewLine===-1){hasPrecedingText&&sb.appendLine();sb.append(text,i,text.length-i|0);break}if(nextNewLine!==i){hasPrecedingText&&sb.appendLine();sb.append(text,i,nextNewLine-i|0);i=nextNewLine+1|0;hasPrecedingText=!0;continue}i=i+1|0}return Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache.GetStringAndRelease(sb)},SafeFastTrim:function(text){return System.String.isNullOrEmpty(text)?text:text.trim()},TrimStart$1:function(text,prefix,comparison){return(comparison===void 0&&(comparison=4),System.String.startsWith(text,prefix,comparison))?text.substr(prefix.length,text.length-prefix.length|0):text},TrimStart:function(text,c,justOne){if(System.String.isNullOrEmpty(text))return text;if(justOne)return text.charCodeAt(0)===c?text.substr(1):text;if(text.charCodeAt(0)!==c)return text;for(var i=0;i<text.length&&text.charCodeAt(i)===c;)i=i+1|0;return i===text.length?"":text.substr(i)},TrimEnd:function(text,suffix,comparison){return(comparison===void 0&&(comparison=4),System.String.endsWith(text,suffix,comparison))?text.substr(0,text.length-suffix.length|0):text},TrimBalancedSquareBrackets:function(text){return text!=null&&text.length>=2&&text.charCodeAt(0)===91&&text.charCodeAt(text.length-1|0)===93&&(text=text.substr(1,text.length-2|0)),text},TrimBalancedRoundBrackets:function(text){return Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalanced(text,"(",")")},TrimBalancedCurlyBrackets:function(text){return Kusto.Cloud.Platform.Utils.ExtendedString.TrimBalanced(text,"{","}")},TrimBalanced:function(text,openning,closing,comparison){return comparison===void 0&&(comparison=4),text!=null&&System.String.startsWith(text,openning,comparison)&&System.String.endsWith(text,closing,comparison)&&(text=text.substr(openning.length,text.length-(openning.length+closing.length|0)|0)),text},TrimBalancedSingleAndDoubleQuotes:function(text){if(System.String.isNullOrEmpty(text))return text;for(var start=0,end=text.length-1|0;start<end;){if(text.charCodeAt(start)===34&&text.charCodeAt(end)===34){start=start+1|0;end=end-1|0;continue}if(text.charCodeAt(start)===39&&text.charCodeAt(end)===39){start=start+1|0;end=end-1|0;continue}break}return start>end?"":text.substr(start,(end-start|0)+1|0)},DetermineMaxLineWidth:function(text){var ret,currentPos,i,c;if(System.String.isNullOrEmpty(text))return 0;for(ret=0,currentPos=0,i=0;i<text.length;i=i+1|0)c=text.charCodeAt(i),c===13||c===10?(ret=Math.max(ret,i-currentPos|0),currentPos=i+1|0):i===(text.length-1|0)&&(ret=Math.max(ret,(i-currentPos|0)+1|0));return ret},SafeCountCharacterUpTo:function(value,c,maxCount){var ret,i;if(value==null)return System.Int64(-1);for(ret=0,i=0;i<value.length;i=i+1|0)if(value.charCodeAt(i)===c&&(ret=ret+1|0),System.Int64(ret).equals(maxCount))break;return System.Int64(ret)},SafeCountAnyCharacterUpTo:function(value,chars,maxCount){var ret,i;if(value==null)return System.Int64(-1);for(ret=0,i=0;i<value.length;i=i+1|0)if(System.Array.contains(chars,value.charCodeAt(i),System.Char)&&(ret=ret+1|0),System.Int64(ret).equals(maxCount))break;return System.Int64(ret)},FindFirstNonWhitespaceCharacter:function(value,index){if(index===void 0&&(index=0),value==null)return-1;for(;;){if(index>=value.length)return-1;if(!System.Char.isWhiteSpace(String.fromCharCode(value.charCodeAt(index))))return index;index=index+1|0}},FirstFirstUnequalCharacter:function(lhs,rhs){if(Bridge.referenceEquals(lhs,rhs))return-1;if(lhs==null||rhs==null||lhs.length===0||rhs.length===0)return 0;for(var i=0;i<lhs.length&&i<rhs.length;i=i+1|0)if(lhs.charCodeAt(i)!==rhs.charCodeAt(i))return i;return i},CountNonOverlappingSubstrings:function(text,substring,comparison){if(comparison===void 0&&(comparison=4),System.String.isNullOrEmpty(text)||System.String.isNullOrEmpty(substring))return 0;for(var count=0,i=0;i<text.length;){if(i=System.String.indexOf(text,substring,i,null,comparison),i<0)return count;count=count+1|0;i=i+substring.length|0}return count},SafeStartsWith:function(what,c){return System.String.isNullOrEmpty(what)?!1:what.charCodeAt(0)===c},SafeStartsWith$1:function(what,value,comparison){return(comparison===void 0&&(comparison=4),System.String.isNullOrEmpty(what))?!1:System.String.startsWith(what,value,comparison)},EqualsOrdinalIgnoreCase:function(me,other){return System.String.equals(me,other,5)},IsEmpty:function(me){return Bridge.referenceEquals(me,"")},IsNotEmpty:function(me){return!Bridge.referenceEquals(me,"")},IsNullOrEmpty:function(me){return System.String.isNullOrEmpty(me)},IsNotNullOrEmpty:function(me){return!System.String.isNullOrEmpty(me)},SafeGetTail:function(what,length){return what==null?null:length<=0?"":length>=what.length?what:what.substr(what.length-length|0)},SafeIndexOf:function(what,value){return System.String.isNullOrEmpty(what)?-1:System.String.indexOf(what,String.fromCharCode(value))},SafeIndexOf$2:function(what,value,startIndex,comparisonType){return System.String.isNullOrEmpty(what)||System.String.isNullOrEmpty(value)||startIndex>what.length?-1:System.String.indexOf(what,value,startIndex,null,comparisonType)},SafeIndexOf$1:function(what,value,startIndex,count,comparisonType){return System.String.isNullOrEmpty(what)||System.String.isNullOrEmpty(value)||(startIndex+value.length|0)>what.length?-1:System.String.indexOf(what,value,startIndex,count,comparisonType)},SplitFirst$2:function(what,delimiter,comparison){var delimiterIndex;return(comparison===void 0&&(comparison=4),what==null||System.String.isNullOrEmpty(delimiter))?null:(delimiterIndex=System.String.indexOf(what,delimiter,0,null,comparison),delimiterIndex<0)?what:what.substr(0,delimiterIndex)},SplitFirst:function(what,delimiter){var delimiterIndex;return what==null?null:(delimiterIndex=System.String.indexOf(what,String.fromCharCode(delimiter)),delimiterIndex<0)?what:what.substr(0,delimiterIndex)},SplitFirst$1:function(what,delimiters){var delimitersIndex;return what==null||delimiters==null||delimiters.length===0?null:(delimitersIndex=System.String.indexOfAny(what,delimiters),delimitersIndex<0)?what:what.substr(0,delimitersIndex)},Rotate:function(s){return System.String.isNullOrEmpty(s)||s.length<2?s:(s.substr(1,s.length-1|0)||"")+(s.substr(0,1)||"")},AdjustNewLineDelimiter:function(text){for(var c,isNextChar_slashN,resultBuilder=new System.Text.StringBuilder,i=0;i<text.length;i=i+1|0){c=text.charCodeAt(i);switch(c){case 13:isNextChar_slashN=i<(text.length-1|0)&&text.charCodeAt(i+1|0)===10;isNextChar_slashN&&(i=i+1|0);resultBuilder.append("\n");break;case 10:resultBuilder.append("\n");break;default:resultBuilder.append(String.fromCharCode(c));break}}return resultBuilder.toString()},ReplaceInvisibleWhitespaces:function(value){var c_space=" ";return Kusto.Cloud.Platform.Utils.ExtendedString.Replace$1(value,function(c,replacement){return replacement.v=null,Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeSpaceChars.contains(c)?replacement.v=c_space:Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeNewlineChars.contains(c)&&(replacement.v="\n"),replacement.v!=null})},HasNonAsciiQuotes:function(value){return System.String.isNullOrWhiteSpace(value)?!1:System.Linq.Enumerable.from(value,System.Char).any(Bridge.fn.cacheBind(Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeQutoes,Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeQutoes.contains))},ReplaceNonAsciiQuotes:function(value){var c_quotes='"';return Kusto.Cloud.Platform.Utils.ExtendedString.Replace$1(value,function(c,replacement){return replacement.v=c_quotes,Kusto.Cloud.Platform.Utils.ExtendedString.s_alternativeQutoes.contains(c)})},Replace:function(value,replacements){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(System.Collections.Generic.KeyValuePair$2(System.Char,System.String),replacements)?Kusto.Cloud.Platform.Utils.ExtendedString.Replace$1(value,Bridge.fn.cacheBind(replacements,replacements.System$Collections$Generic$IDictionary$2$System$Char$System$String$tryGetValue)):value},Replace$1:function(value,shouldReplace){var sb,i,c,replacement;if(System.String.isNullOrEmpty(value))return value;for(sb=null,i=0;i<value.length;i=i+1|0)c=value.charCodeAt(i),replacement={},shouldReplace(c,replacement)?(sb=Kusto.Cloud.Platform.Utils.ExtendedStringBuilder.InitializeStringBuildIfNeeded(value,sb,i),sb.append(replacement.v)):sb!=null&&sb.append(String.fromCharCode(c));return sb==null?value:sb.toString()}}}});Bridge.ns("Kusto.Cloud.Platform.Utils.ExtendedString",$asm.$);Bridge.apply($asm.$.Kusto.Cloud.Platform.Utils.ExtendedString,{f1:function(obj){var $t;return obj!=null?($t=Bridge.toString(obj),$t!=null?$t:"[ToStringNull]"):"[null]"},f2:function(_o1){return _o1.add(160),_o1.add(5760),_o1.add(6158),_o1.add(8192),_o1.add(8193),_o1.add(8194),_o1.add(8195),_o1.add(8196),_o1.add(8197),_o1.add(8198),_o1.add(8199),_o1.add(8200),_o1.add(8201),_o1.add(8202),_o1.add(8203),_o1.add(8239),_o1.add(8287),_o1.add(12288),_o1.add(65279),_o1},f3:function(_o2){return _o2.add(11),_o2},f4:function(_o3){return _o3.add(171),_o3.add(187),_o3.add(8216),_o3.add(8217),_o3.add(8218),_o3.add(8220),_o3.add(8221),_o3.add(8222),_o3.add(8249),_o3.add(8250),_o3}});Bridge.define("Kusto.Cloud.Platform.Utils.ExtendedStringBuilder",{statics:{methods:{InitializeStringBuildIfNeeded:function(value,sb,i){return sb!=null?sb:(sb=new System.Text.StringBuilder("",value.length),i>0&&sb.append(value.substr(0,i)),sb)}}}});Bridge.define("Kusto.Cloud.Platform.Utils.MemoryConstants",{statics:{fields:{_1KB:0,_2KB:0,_4KB:0,_8KB:0,_16KB:0,_32KB:0,_64KB:0,_128KB:0,_256KB:0,_512KB:0,_1MB:0,_2MB:0,_32MB:0,_64MB:0,_512MB:0,_1GB:0,_1TB:System.Int64(0),_1PB:System.Int64(0),LargeObjectHeap:0,LargeObjectHeapChars:0,LargeObjectHeapCharsStreamReaderWriter:0},ctors:{init:function(){this._1KB=1024;this._2KB=2048;this._4KB=4096;this._8KB=8192;this._16KB=16384;this._32KB=32768;this._64KB=65536;this._128KB=131072;this._256KB=262144;this._512KB=524288;this._1MB=1048576;this._2MB=2097152;this._32MB=33554432;this._64MB=67108864;this._512MB=536870912;this._1GB=1073741824;this._1TB=System.Int64([0,256]);this._1PB=System.Int64([0,262144]);this.LargeObjectHeap=65536;this.LargeObjectHeapChars=32768;this.LargeObjectHeapCharsStreamReaderWriter=24576}}}});Bridge.define("Kusto.Cloud.Platform.Utils.StringBuilderCache",{statics:{fields:{MAX_BUILDER_SIZE:0,DEFAULT_CAPACITY:0},ctors:{init:function(){this.MAX_BUILDER_SIZE=32768;this.DEFAULT_CAPACITY=16}},methods:{Acquire:function(threadStaticStringBuilder,capacity,maxBuilderSize){if(capacity===void 0&&(capacity=16),maxBuilderSize===void 0&&(maxBuilderSize=32768),capacity<=maxBuilderSize){var sb=threadStaticStringBuilder.v;if(sb!=null&&capacity<=sb.getCapacity())return threadStaticStringBuilder.v=null,sb.clear(),sb}return new System.Text.StringBuilder("",capacity)},Acquire$1:function(threadStaticStringBuilder,value){var sb=Kusto.Cloud.Platform.Utils.StringBuilderCache.Acquire(threadStaticStringBuilder,Math.max(value.length,Kusto.Cloud.Platform.Utils.StringBuilderCache.DEFAULT_CAPACITY));return sb.append(value),sb},Release:function(threadStaticStringBuilder,sb,maxBuilderSize){maxBuilderSize===void 0&&(maxBuilderSize=32768);sb.getCapacity()<=maxBuilderSize&&(threadStaticStringBuilder.v=sb)},GetStringAndRelease:function(threadStaticStringBuilder,sb,maxBuilderSize){maxBuilderSize===void 0&&(maxBuilderSize=32768);var result=sb.toString();return Kusto.Cloud.Platform.Utils.StringBuilderCache.Release(threadStaticStringBuilder,sb,maxBuilderSize),result},GetStringAndClear:function(threadStaticStringBuilder,sb){var result=sb.toString();return sb.clear(),result}}}});Bridge.define("Kusto.Cloud.Platform.Utils.TimeSpanConstants",{statics:{fields:{_2sec:null,_10sec:null,_20sec:null,_1min:null,_2min:null,_3min:null,_4min:null,_5min:null,_10min:null,_59min:null,_60min:null,_1hour:null,_2hours:null,_3hours:null,_4hours:null,_5hours:null,_6hours:null,_10hours:null},ctors:{init:function(){this._2sec=new System.TimeSpan;this._10sec=new System.TimeSpan;this._20sec=new System.TimeSpan;this._1min=new System.TimeSpan;this._2min=new System.TimeSpan;this._3min=new System.TimeSpan;this._4min=new System.TimeSpan;this._5min=new System.TimeSpan;this._10min=new System.TimeSpan;this._59min=new System.TimeSpan;this._60min=new System.TimeSpan;this._1hour=new System.TimeSpan;this._2hours=new System.TimeSpan;this._3hours=new System.TimeSpan;this._4hours=new System.TimeSpan;this._5hours=new System.TimeSpan;this._6hours=new System.TimeSpan;this._10hours=new System.TimeSpan;this._2sec=System.TimeSpan.fromSeconds(2);this._10sec=System.TimeSpan.fromSeconds(10);this._20sec=System.TimeSpan.fromSeconds(20);this._1min=System.TimeSpan.fromMinutes(1);this._2min=System.TimeSpan.fromMinutes(2);this._3min=System.TimeSpan.fromMinutes(3);this._4min=System.TimeSpan.fromMinutes(4);this._5min=System.TimeSpan.fromMinutes(5);this._10min=System.TimeSpan.fromMinutes(10);this._59min=System.TimeSpan.fromMinutes(59);this._60min=System.TimeSpan.fromMinutes(60);this._1hour=System.TimeSpan.fromHours(1);this._2hours=System.TimeSpan.fromHours(2);this._3hours=System.TimeSpan.fromHours(3);this._4hours=System.TimeSpan.fromHours(4);this._5hours=System.TimeSpan.fromHours(5);this._6hours=System.TimeSpan.fromHours(6);this._10hours=System.TimeSpan.fromHours(10)}}}});Bridge.define("Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache",{statics:{fields:{MAX_BUILDER_SIZE:0,DEFAULT_CAPACITY:0,t_cachedInstance:null},ctors:{init:function(){this.MAX_BUILDER_SIZE=24576;this.DEFAULT_CAPACITY=16}},methods:{Acquire:function(capacity){return capacity===void 0&&(capacity=16),Kusto.Cloud.Platform.Utils.StringBuilderCache.Acquire(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),capacity)},Acquire$1:function(value){return Kusto.Cloud.Platform.Utils.StringBuilderCache.Acquire$1(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),value)},Release:function(sb){Kusto.Cloud.Platform.Utils.StringBuilderCache.Release(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),sb)},GetStringAndRelease:function(sb){return Kusto.Cloud.Platform.Utils.StringBuilderCache.GetStringAndRelease(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),sb)},GetStringAndClear:function(sb){return Kusto.Cloud.Platform.Utils.StringBuilderCache.GetStringAndClear(Bridge.ref(Kusto.Cloud.Platform.Utils.UtilsStringBuilderCache,"t_cachedInstance"),sb)}}}});Bridge.define("Kusto.Data.Common.CslQueryParser",{statics:{methods:{PrettifyQuery:function(query,appendText){var parser=new Kusto.Data.IntelliSense.CslCommandParser,commands=parser.Parse(null,query,Kusto.Data.IntelliSense.ParseMode.CommandTokensOnly),queryFormatted;return System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).count()!==1?query:(queryFormatted=System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).first().FormatAsString("\n",7),System.String.isNullOrEmpty(queryFormatted)&&(queryFormatted=query),System.String.isNullOrEmpty(appendText)||(queryFormatted=(queryFormatted||"")+(appendText||"")),queryFormatted)}}}});Bridge.define("Kusto.Data.Common.CslSyntaxGenerator",{statics:{fields:{s_keywords:null},ctors:{init:function(){this.s_keywords=$asm.$.Kusto.Data.Common.CslSyntaxGenerator.f1(new(System.Collections.Generic.HashSet$1(System.String).ctor))}},methods:{NormalizeDatabaseName$1:function(databaseName,forceNormalization){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(databaseName,forceNormalization)},NormalizeDatabaseName:function(databaseName){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(databaseName,!1)},NormalizeVirutalClusterName:function(virtualClusterName,forceNormalization){return forceNormalization===void 0&&(forceNormalization=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(virtualClusterName,forceNormalization)},NormalizeFunctionName:function(functionName,forceNormalizeFunctionName){return forceNormalizeFunctionName===void 0&&(forceNormalizeFunctionName=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(functionName,forceNormalizeFunctionName)},NormalizeTableName:function(tableName,forceNormalizeTableName){return forceNormalizeTableName===void 0&&(forceNormalizeTableName=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(tableName,forceNormalizeTableName)},NormalizeColumnName:function(columnName,forceNormalizeColumnName){return forceNormalizeColumnName===void 0&&(forceNormalizeColumnName=!1),Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(columnName,forceNormalizeColumnName)},NormalizeRowStoreName:function(rowStoreName){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(rowStoreName,!1)},NormalizeWorkloadGroupName:function(workloadGroupName){return Kusto.Data.Common.CslSyntaxGenerator.NormalizeName(workloadGroupName,!1)},IsIdentifier:function(token){if(System.String.isNullOrEmpty(token)||!System.Char.isLetter(token.charCodeAt(0))&&token.charCodeAt(0)!==95)return!1;return System.Linq.Enumerable.from(token,System.Char).all($asm.$.Kusto.Data.Common.CslSyntaxGenerator.f2)},IsAscii:function(c){return c<=127},NormalizeName:function(name,forceNormalization){return System.String.isNullOrEmpty(name)?name:!forceNormalization&&Kusto.Data.Common.CslSyntaxGenerator.IsIdentifier(name)&&!Kusto.Data.Common.CslSyntaxGenerator.IsKeyword(name)?name:System.String.startsWith(name,"[",4)?name:System.String.contains(name,"'")?'["'+(name||"")+'"]':"['"+(name||"")+"']"},IsKeyword:function(token){return Kusto.Data.Common.CslSyntaxGenerator.s_keywords.contains(token)}}}});Bridge.ns("Kusto.Data.Common.CslSyntaxGenerator",$asm.$);Bridge.apply($asm.$.Kusto.Data.Common.CslSyntaxGenerator,{f1:function(_o1){return _o1.add("access"),_o1.add("accounts"),_o1.add("accumulate"),_o1.add("add"),_o1.add("adl"),_o1.add("admin"),_o1.add("admins"),_o1.add("aggregations"),_o1.add("alias"),_o1.add("all"),_o1.add("alldatabasesadmins"),_o1.add("alldatabasesmonitors"),_o1.add("alldatabasesviewers"),_o1.add("alter"),_o1.add("alter-merge"),_o1.add("and"),_o1.add("anomalycolumns"),_o1.add("append"),_o1.add("artifacts"),_o1.add("as"),_o1.add("asc"),_o1.add("assert-schema"),_o1.add("async"),_o1.add("attach"),_o1.add("autoUpdateSchema"),_o1.add("auto_delete"),_o1.add("avro"),_o1.add("apacheavro"),_o1.add("axes"),_o1.add("base"),_o1.add("based-on"),_o1.add("basicauth"),_o1.add("between"),_o1.add("bin"),_o1.add("blob"),_o1.add("block"),_o1.add("blocked"),_o1.add("by"),_o1.add("cache"),_o1.add("caching"),_o1.add("cachingpolicy"),_o1.add("call-tree"),_o1.add("callout"),_o1.add("cancel"),_o1.add("capacity"),_o1.add("classification"),_o1.add("clean"),_o1.add("clear"),_o1.add("cluster"),_o1.add("column"),_o1.add("columns"),_o1.add("column-docstrings"),_o1.add("commands"),_o1.add("commands-and-queries"),_o1.add("commconcurrency"),_o1.add("commpools"),_o1.add("compact"),_o1.add("completed"),_o1.add("compressed"),_o1.add("consume"),_o1.add("contains"),_o1.add("continuous-export"),_o1.add("continuous-exports"),_o1.add("continuous-job"),_o1.add("conservative"),_o1.add("copy"),_o1.add("corrupted"),_o1.add("count"),_o1.add("crash"),_o1.add("create"),_o1.add("create-or-alter"),_o1.add("createdon"),_o1.add("create-merge"),_o1.add("csl"),_o1.add("cslschema"),_o1.add("csv"),_o1.add("cursor"),_o1.add("data"),_o1.add("database"),_o1.add("databasecreators"),_o1.add("databases"),_o1.add("dataexport"),_o1.add("data-export"),_o1.add("dataformat"),_o1.add("datatable"),_o1.add("declare"),_o1.add("decryption-certificate-thumbprint"),_o1.add("default"),_o1.add("define"),_o1.add("delete"),_o1.add("delta"),_o1.add("desc"),_o1.add("detach"),_o1.add("details"),_o1.add("diagnostics"),_o1.add("disable"),_o1.add("distinct"),_o1.add("dnshostname"),_o1.add("docstring"),_o1.add("drop"),_o1.add("drop-pretend"),_o1.add("dup-next-failed-ingest"),_o1.add("dup-next-ingest"),_o1.add("earliest"),_o1.add("echo"),_o1.add("effective"),_o1.add("enable"),_o1.add("encoding"),_o1.add("encodingpolicy"),_o1.add("entity"),_o1.add("entity_group"),_o1.add("entity_groups"),_o1.add("ephemeral"),_o1.add("evaluate"),_o1.add("except"),_o1.add("execute"),_o1.add("export"),_o1.add("extend"),_o1.add("extent"),_o1.add("extentcontainers"),_o1.add("extents"),_o1.add("extentsmerge"),_o1.add("extents-merge"),_o1.add("extents-partition"),_o1.add("extent_tags_retention"),_o1.add("external"),_o1.add("externaldata"),_o1.add("external_data"),_o1.add("fabric"),_o1.add("fabriccache"),_o1.add("fabricclocks"),_o1.add("fabriclocks"),_o1.add("facet"),_o1.add("failures"),_o1.add("featureflags"),_o1.add("filter"),_o1.add("find"),_o1.add("first"),_o1.add("flags"),_o1.add("folder"),_o1.add("fork"),_o1.add("freshness"),_o1.add("from"),_o1.add("function"),_o1.add("functions"),_o1.add("generic"),_o1.add("get"),_o1.add("getschema"),_o1.add("granny-asc"),_o1.add("granny-desc"),_o1.add("granularity"),_o1.add("groups"),_o1.add("harddelete"),_o1.add("hardretention"),_o1.add("has"),_o1.add("has_all"),_o1.add("has_any"),_o1.add("hash"),_o1.add("hidden"),_o1.add("hot"),_o1.add("hotdata"),_o1.add("hotindex"),_o1.add("hours"),_o1.add("id"),_o1.add("if_later_than"),_o1.add("ifexists"),_o1.add("ifnotexists"),_o1.add("in"),_o1.add("in~"),_o1.add("info"),_o1.add("ingest"),_o1.add("ingest-from-storage"),_o1.add("ingest-inline"),_o1.add("ingestion"),_o1.add("ingestionbatching"),_o1.add("ingestions"),_o1.add("ingestiontime"),_o1.add("ingestors"),_o1.add("inline"),_o1.add("internal"),_o1.add("into"),_o1.add("invoke"),_o1.add("journal"),_o1.add("json"),_o1.add("jobs"),_o1.add("key"),_o1.add("keys"),_o1.add("kind"),_o1.add("last"),_o1.add("latest"),_o1.add("legend"),_o1.add("let"),_o1.add("limit"),_o1.add("linear"),_o1.add("list"),_o1.add("load"),_o1.add("local"),_o1.add("location"),_o1.add("lookback"),_o1.add("lookup"),_o1.add("log"),_o1.add("macro-expand"),_o1.add("maintenance_mode"),_o1.add("make-series"),_o1.add("management"),_o1.add("map"),_o1.add("mapping"),_o1.add("mappings"),_o1.add("managed_identity"),_o1.add("materialize"),_o1.add("materialized-view"),_o1.add("materialized-views"),_o1.add("materialized-view-combine"),_o1.add("maxRecords"),_o1.add("mdm"),_o1.add("memory"),_o1.add("mempools"),_o1.add("merge"),_o1.add("metadata"),_o1.add("method"),_o1.add("missing"),_o1.add("monitoring"),_o1.add("monitors"),_o1.add("move"),_o1.add("multidatabaseadmins"),_o1.add("mv-apply"),_o1.add("mv-expand"),_o1.add("mvapply"),_o1.add("mvexpand"),_o1.add("nan"),_o1.add("node"),_o1.add("nodes"),_o1.add("none"),_o1.add("!between"),_o1.add("!in"),_o1.add("!in~"),_o1.add("null"),_o1.add("nulls"),_o1.add("of"),_o1.add("on"),_o1.add("older"),_o1.add("operation"),_o1.add("operations"),_o1.add("ops"),_o1.add("optional"),_o1.add("or"),_o1.add("orc"),_o1.add("order"),_o1.add("others"),_o1.add("output"),_o1.add("over"),_o1.add("pack"),_o1.add("panels"),_o1.add("parse"),_o1.add("parse-where"),_o1.add("parquet"),_o1.add("partition"),_o1.add("__partitionby"),_o1.add("partitioning"),_o1.add("password"),_o1.add("patch"),_o1.add("pathformat"),_o1.add("pattern"),_o1.add("pending"),_o1.add("period"),_o1.add("periodic-storage-artifacts-cleanup"),_o1.add("persist"),_o1.add("plugin"),_o1.add("plugins"),_o1.add("policies"),_o1.add("policy"),_o1.add("pretend"),_o1.add("prettyname"),_o1.add("principal"),_o1.add("principals"),_o1.add("print"),_o1.add("project"),_o1.add("project-away"),_o1.add("project-keep"),_o1.add("project-rename"),_o1.add("project-reorder"),_o1.add("project-smart"),_o1.add("purge"),_o1.add("purge-cleanup"),_o1.add("purge-storage-artifacts-cleanup"),_o1.add("queries"),_o1.add("query"),_o1.add("query_parameters"),_o1.add("queryexecution"),_o1.add("queryplan"),_o1.add("query_weak_consistency"),_o1.add("query_results"),_o1.add("range"),_o1.add("readonly"),_o1.add("readwrite"),_o1.add("reason"),_o1.add("rebuild"),_o1.add("record"),_o1.add("records"),_o1.add("recycle"),_o1.add("reduce"),_o1.add("remote-schema"),_o1.add("rename"),_o1.add("render"),_o1.add("replace"),_o1.add("resources"),_o1.add("restore"),_o1.add("restrict"),_o1.add("restricted_view_access"),_o1.add("resume-purges"),_o1.add("retention"),_o1.add("request_classification"),_o1.add("request_support"),_o1.add("roles"),_o1.add("row_level_security"),_o1.add("roworder"),_o1.add("roworderpolicy"),_o1.add("rowstore"),_o1.add("rowstorepolicy"),_o1.add("rowstore_references"),_o1.add("rowstores"),_o1.add("rowstore_sealinfo"),_o1.add("run"),_o1.add("running"),_o1.add("sample"),_o1.add("sample-distinct"),_o1.add("sandbox"),_o1.add("sandboxes"),_o1.add("save"),_o1.add("scalein"),_o1.add("scan"),_o1.add("schema"),_o1.add("script"),_o1.add("seal"),_o1.add("seals"),_o1.add("search"),_o1.add("serialize"),_o1.add("series"),_o1.add("servicepoints"),_o1.add("services"),_o1.add("set"),_o1.add("set-or-append"),_o1.add("set-or-replace"),_o1.add("sharding"),_o1.add("shards"),_o1.add("shard-groups"),_o1.add("shards_grouping"),_o1.add("show"),_o1.add("softdelete"),_o1.add("softretention"),_o1.add("sort"),_o1.add("sql"),_o1.add("stacked"),_o1.add("stacked100"),_o1.add("state"),_o1.add("stats"),_o1.add("statistics"),_o1.add("step"),_o1.add("storedqueryresultcontainers"),_o1.add("stream"),_o1.add("streamingingestion"),_o1.add("streaming-ingestion-post-processing"),_o1.add("stored-query-results"),_o1.add("summarize"),_o1.add("sstream"),_o1.add("storage"),_o1.add("suspend"),_o1.add("systemdb"),_o1.add("table"),_o1.add("tablepurge"),_o1.add("table-purge"),_o1.add("tables"),_o1.add("tags"),_o1.add("take"),_o1.add("tcpconnections"),_o1.add("tcpports"),_o1.add("tempstorage"),_o1.add("tenants"),_o1.add("threadpools"),_o1.add("threshold"),_o1.add("throw"),_o1.add("title"),_o1.add("to"),_o1.add("top"),_o1.add("top-hitters"),_o1.add("top-nested"),_o1.add("toscalar"),_o1.add("totable"),_o1.add("trace"),_o1.add("traceresults"),_o1.add("tsv"),_o1.add("type"),_o1.add("typeof"),_o1.add("undo"),_o1.add("unstacked"),_o1.add("unrestrictedviewers"),_o1.add("update"),_o1.add("usage"),_o1.add("user"),_o1.add("users"),_o1.add("using"),_o1.add("uuid"),_o1.add("verbose"),_o1.add("version"),_o1.add("view"),_o1.add("views"),_o1.add("viewers"),_o1.add("virtual_cluster"),_o1.add("virtual_clusters"),_o1.add("visible"),_o1.add("volatile"),_o1.add("v9"),_o1.add("v10"),_o1.add("w3clogfile"),_o1.add("warm"),_o1.add("warming"),_o1.add("whatif"),_o1.add("where"),_o1.add("with"),_o1.add("workload_group"),_o1.add("workload_groups"),_o1.add("writeaheadlog"),_o1.add("xaxis"),_o1.add("xcolumn"),_o1.add("xmin"),_o1.add("xmax"),_o1.add("xtitle"),_o1.add("yaxis"),_o1.add("ycolumns"),_o1.add("ymin"),_o1.add("ymax"),_o1.add("ysplit"),_o1.add("ytitle"),_o1.add("bool"),_o1.add("boolean"),_o1.add("int8"),_o1.add("char"),_o1.add("uint8"),_o1.add("byte"),_o1.add("int16"),_o1.add("uint16"),_o1.add("int"),_o1.add("int32"),_o1.add("uint"),_o1.add("uint32"),_o1.add("long"),_o1.add("int64"),_o1.add("ulong"),_o1.add("uint64"),_o1.add("float"),_o1.add("real"),_o1.add("double"),_o1.add("string"),_o1.add("time"),_o1.add("timespan"),_o1.add("date"),_o1.add("datetime"),_o1.add("guid"),_o1.add("uniqueid"),_o1.add("dynamic"),_o1.add("decimal"),_o1.add("GB"),_o1.add("MB"),_o1.add("application"),_o1.add("blockedprincipals"),_o1.add("bytes"),_o1.add("callstacks"),_o1.add("concurrency"),_o1.add("configuration"),_o1.add("container"),_o1.add("containers"),_o1.add("datasize"),_o1.add("datastats"),_o1.add("datetime_pattern"),_o1.add("days"),_o1.add("dimensions"),_o1.add("disabled"),_o1.add("dryrun"),_o1.add("empty"),_o1.add("enabled"),_o1.add("exclude"),_o1.add("expired_tables_cleanup"),_o1.add("extentsize"),_o1.add("follower"),_o1.add("for"),_o1.add("format_datetime"),_o1.add("hot_window"),_o1.add("identity"),_o1.add("include"),_o1.add("network"),_o1.add("recoverability"),_o1.add("startofday"),_o1.add("startofmonth"),_o1.add("startofweek"),_o1.add("startofyear"),_o1.add("stored_query_result"),_o1.add("stored_query_results"),_o1.add("transactions"),_o1.add("trim"),_o1.add("union"),_o1.add("until"),_o1.add("unused"),_o1.add("utilization"),_o1.add("violations"),_o1.add("3Dchart"),_o1.add("__contextual_datatable"),_o1.add("__crossCluster"),_o1.add("__crossDB"),_o1.add("__executeAndCache"),_o1.add("__id"),_o1.add("__isFuzzy"),_o1.add("__noWithSource"),_o1.add("__packedColumn"),_o1.add("__projectAway"),_o1.add("__sourceColumnIndex"),_o1.add("anomalychart"),_o1.add("areachart"),_o1.add("bagexpansion"),_o1.add("barchart"),_o1.add("bin_legacy"),_o1.add("card"),_o1.add("columnchart"),_o1.add("datascope"),_o1.add("decodeblocks"),_o1.add("expandoutput"),_o1.add("hotcache"),_o1.add("isfuzzy"),_o1.add("join"),_o1.add("ladderchart"),_o1.add("linechart"),_o1.add("nooptimization"),_o1.add("piechart"),_o1.add("pivotchart"),_o1.add("regex"),_o1.add("relaxed"),_o1.add("scatterchart"),_o1.add("simple"),_o1.add("stackedareachart"),_o1.add("timechart"),_o1.add("timeline"),_o1.add("timepivot"),_o1.add("treemap"),_o1.add("with_itemindex"),_o1.add("with_match_id"),_o1.add("with_source"),_o1.add("with_step_name"),_o1.add("withsource"),_o1},f2:function(c){return(System.Char.isDigit(c)||System.Char.isLetter(c))&&Kusto.Data.Common.CslSyntaxGenerator.IsAscii(c)||c===95}});Bridge.define("Kusto.Data.Common.DatabaseShowFlavor",{$kind:"enum",statics:{fields:{Identity:0,Verbose:1,Policies:2,DataStats:3,Default:4}}});Bridge.define("Kusto.Data.Common.DataConnectionError",{$kind:"enum",statics:{fields:{ManagedIdentityUnauthorized:0,ManagedIdentityNotFound:1,UsingDeprecatedConnectionString:2}}});Bridge.define("Kusto.Data.Common.DataRecoverability",{$kind:"enum",statics:{fields:{Unknown:0,Enabled:1,Disabled:2}}});Bridge.define("Kusto.Data.Common.DataSourceCompressionType",{$kind:"enum",statics:{fields:{None:0,GZip:1,Zip:2}}});Bridge.define("Kusto.Data.Common.EntityType",{$kind:"enum",statics:{fields:{Unknown:0,Cluster:1,Database:2,Table:3,Column:4,Function:5,ExternalTable:6,MaterializedView:7}}});Bridge.define("Kusto.Data.Common.ExtendedDatabaseShowFlavor",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.DatabaseShowFlavor.Identity:return"Identity";case Kusto.Data.Common.DatabaseShowFlavor.Verbose:return"Verbose";case Kusto.Data.Common.DatabaseShowFlavor.Policies:return"Policies";case Kusto.Data.Common.DatabaseShowFlavor.DataStats:return"DataStats";case Kusto.Data.Common.DatabaseShowFlavor.Default:return"Default";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Common.DatabaseShowFlavor};return Kusto.Data.Common.ExtendedDatabaseShowFlavor.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Common.DatabaseShowFlavor.Identity:return!0;case Kusto.Data.Common.DatabaseShowFlavor.Verbose:return!0;case Kusto.Data.Common.DatabaseShowFlavor.Policies:return!0;case Kusto.Data.Common.DatabaseShowFlavor.DataStats:return!0;case Kusto.Data.Common.DatabaseShowFlavor.Default:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.DatabaseShowFlavor};if(Kusto.Data.Common.ExtendedDatabaseShowFlavor.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"Identity":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.Identity,!0;case"1":case"Verbose":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.Verbose,!0;case"2":case"Policies":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.Policies,!0;case"3":case"DataStats":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.DataStats,!0;case"4":case"Default":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.Default,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"identity":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.Identity,!0;case"verbose":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.Verbose,!0;case"policies":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.Policies,!0;case"datastats":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.DataStats,!0;case"default":return ret.v=Kusto.Data.Common.DatabaseShowFlavor.Default,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.DatabaseShowFlavor.Identity:return"";case Kusto.Data.Common.DatabaseShowFlavor.Verbose:return"";case Kusto.Data.Common.DatabaseShowFlavor.Policies:return"";case Kusto.Data.Common.DatabaseShowFlavor.DataStats:return"";case Kusto.Data.Common.DatabaseShowFlavor.Default:return"";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtendedDataConnectionError",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized:return"ManagedIdentityUnauthorized";case Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound:return"ManagedIdentityNotFound";case Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString:return"UsingDeprecatedConnectionString";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Common.DataConnectionError};return Kusto.Data.Common.ExtendedDataConnectionError.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized:return!0;case Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound:return!0;case Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.DataConnectionError};if(Kusto.Data.Common.ExtendedDataConnectionError.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"ManagedIdentityUnauthorized":return ret.v=Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized,!0;case"ManagedIdentityNotFound":return ret.v=Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound,!0;case"UsingDeprecatedConnectionString":return ret.v=Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"managedidentityunauthorized":return ret.v=Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized,!0;case"managedidentitynotfound":return ret.v=Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound,!0;case"usingdeprecatedconnectionstring":return ret.v=Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.DataConnectionError.ManagedIdentityUnauthorized:return"Managed Identity doesn't have sufficient authorizations. This likely indicates that the user didn't provide the Managed Identity with the necessary role or scope.";case Kusto.Data.Common.DataConnectionError.ManagedIdentityNotFound:return"Managed Identity doesn't exist in the cluster. This likely indicates the user didn't link their Managed Identity to this ADX cluster.";case Kusto.Data.Common.DataConnectionError.UsingDeprecatedConnectionString:return"Data Connection authenticates using a connection string instead of a managed identity, which is deprecated.";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtendedDataRecoverability",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.DataRecoverability.Unknown:return"Unknown";case Kusto.Data.Common.DataRecoverability.Enabled:return"Enabled";case Kusto.Data.Common.DataRecoverability.Disabled:return"Disabled";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Common.DataRecoverability};return Kusto.Data.Common.ExtendedDataRecoverability.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Common.DataRecoverability.Unknown:return!0;case Kusto.Data.Common.DataRecoverability.Enabled:return!0;case Kusto.Data.Common.DataRecoverability.Disabled:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.DataRecoverability};if(Kusto.Data.Common.ExtendedDataRecoverability.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"Unknown":return ret.v=Kusto.Data.Common.DataRecoverability.Unknown,!0;case"1":case"Enabled":return ret.v=Kusto.Data.Common.DataRecoverability.Enabled,!0;case"2":case"Disabled":return ret.v=Kusto.Data.Common.DataRecoverability.Disabled,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"unknown":return ret.v=Kusto.Data.Common.DataRecoverability.Unknown,!0;case"enabled":return ret.v=Kusto.Data.Common.DataRecoverability.Enabled,!0;case"disabled":return ret.v=Kusto.Data.Common.DataRecoverability.Disabled,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.DataRecoverability.Unknown:return"";case Kusto.Data.Common.DataRecoverability.Enabled:return"";case Kusto.Data.Common.DataRecoverability.Disabled:return"";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtendedDataSourceCompressionType",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.DataSourceCompressionType.None:return"None";case Kusto.Data.Common.DataSourceCompressionType.GZip:return"GZip";case Kusto.Data.Common.DataSourceCompressionType.Zip:return"Zip";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Common.DataSourceCompressionType};return Kusto.Data.Common.ExtendedDataSourceCompressionType.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Common.DataSourceCompressionType.None:return!0;case Kusto.Data.Common.DataSourceCompressionType.GZip:return!0;case Kusto.Data.Common.DataSourceCompressionType.Zip:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.DataSourceCompressionType};if(Kusto.Data.Common.ExtendedDataSourceCompressionType.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"None":return ret.v=Kusto.Data.Common.DataSourceCompressionType.None,!0;case"1":case"GZip":return ret.v=Kusto.Data.Common.DataSourceCompressionType.GZip,!0;case"2":case"Zip":return ret.v=Kusto.Data.Common.DataSourceCompressionType.Zip,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"none":return ret.v=Kusto.Data.Common.DataSourceCompressionType.None,!0;case"gzip":return ret.v=Kusto.Data.Common.DataSourceCompressionType.GZip,!0;case"zip":return ret.v=Kusto.Data.Common.DataSourceCompressionType.Zip,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.DataSourceCompressionType.None:return"No compression";case Kusto.Data.Common.DataSourceCompressionType.GZip:return"GZip compression";case Kusto.Data.Common.DataSourceCompressionType.Zip:return"Zip compression";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtendedEntityType",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.EntityType.Unknown:return"Unknown";case Kusto.Data.Common.EntityType.Cluster:return"Cluster";case Kusto.Data.Common.EntityType.Database:return"Database";case Kusto.Data.Common.EntityType.Table:return"Table";case Kusto.Data.Common.EntityType.Column:return"Column";case Kusto.Data.Common.EntityType.Function:return"Function";case Kusto.Data.Common.EntityType.ExternalTable:return"ExternalTable";case Kusto.Data.Common.EntityType.MaterializedView:return"MaterializedView";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Common.EntityType};return Kusto.Data.Common.ExtendedEntityType.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Common.EntityType.Unknown:return!0;case Kusto.Data.Common.EntityType.Cluster:return!0;case Kusto.Data.Common.EntityType.Database:return!0;case Kusto.Data.Common.EntityType.Table:return!0;case Kusto.Data.Common.EntityType.Column:return!0;case Kusto.Data.Common.EntityType.Function:return!0;case Kusto.Data.Common.EntityType.ExternalTable:return!0;case Kusto.Data.Common.EntityType.MaterializedView:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.EntityType};if(Kusto.Data.Common.ExtendedEntityType.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"Unknown":return ret.v=Kusto.Data.Common.EntityType.Unknown,!0;case"1":case"Cluster":return ret.v=Kusto.Data.Common.EntityType.Cluster,!0;case"2":case"Database":return ret.v=Kusto.Data.Common.EntityType.Database,!0;case"3":case"Table":return ret.v=Kusto.Data.Common.EntityType.Table,!0;case"4":case"Column":return ret.v=Kusto.Data.Common.EntityType.Column,!0;case"5":case"Function":return ret.v=Kusto.Data.Common.EntityType.Function,!0;case"6":case"ExternalTable":return ret.v=Kusto.Data.Common.EntityType.ExternalTable,!0;case"7":case"MaterializedView":case"materialized-view":return ret.v=Kusto.Data.Common.EntityType.MaterializedView,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"unknown":return ret.v=Kusto.Data.Common.EntityType.Unknown,!0;case"cluster":return ret.v=Kusto.Data.Common.EntityType.Cluster,!0;case"database":return ret.v=Kusto.Data.Common.EntityType.Database,!0;case"table":return ret.v=Kusto.Data.Common.EntityType.Table,!0;case"column":return ret.v=Kusto.Data.Common.EntityType.Column,!0;case"function":return ret.v=Kusto.Data.Common.EntityType.Function,!0;case"externaltable":return ret.v=Kusto.Data.Common.EntityType.ExternalTable,!0;case"materializedview":case"materialized-view":return ret.v=Kusto.Data.Common.EntityType.MaterializedView,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.EntityType.Unknown:return"Unknown";case Kusto.Data.Common.EntityType.Cluster:return"Cluster entity type";case Kusto.Data.Common.EntityType.Database:return"Database entity type";case Kusto.Data.Common.EntityType.Table:return"Table entity type";case Kusto.Data.Common.EntityType.Column:return"Column entity type";case Kusto.Data.Common.EntityType.Function:return"Function entity type";case Kusto.Data.Common.EntityType.ExternalTable:return"External table entity type";case Kusto.Data.Common.EntityType.MaterializedView:return"Materialized view entity type";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtendedExtentsMergeLookbackPeriodKind",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default:return"Default";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache:return"HotCache";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All:return"All";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom:return"Custom";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Common.ExtentsMergeLookbackPeriodKind};return Kusto.Data.Common.ExtendedExtentsMergeLookbackPeriodKind.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default:return!0;case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache:return!0;case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All:return!0;case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.ExtentsMergeLookbackPeriodKind};if(Kusto.Data.Common.ExtendedExtentsMergeLookbackPeriodKind.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"Default":return ret.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default,!0;case"1":case"HotCache":return ret.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache,!0;case"2":case"All":return ret.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All,!0;case"3":case"Custom":return ret.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"default":return ret.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default,!0;case"hotcache":return ret.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache,!0;case"all":return ret.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All,!0;case"custom":return ret.v=Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Default:return"The default lookback period, as defined by the system";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.HotCache:return"The hot cache period";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.All:return"The entire period in which data exists";case Kusto.Data.Common.ExtentsMergeLookbackPeriodKind.Custom:return"A custom period, provided by the admin of the entity";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtendedIngestionErrorCategory",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.IngestionErrorCategory.Unknown:return"Unknown";case Kusto.Data.Common.IngestionErrorCategory.InternalServiceError:return"InternalServiceError";case Kusto.Data.Common.IngestionErrorCategory.BadFormat:return"BadFormat";case Kusto.Data.Common.IngestionErrorCategory.BadRequest:return"BadRequest";case Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure:return"UpdatePolicyFailure";case Kusto.Data.Common.IngestionErrorCategory.EntityNotFound:return"EntityNotFound";case Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized:return"UserAccessNotAuthorized";case Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized:return"DataAccessNotAuthorized";case Kusto.Data.Common.IngestionErrorCategory.FileTooLarge:return"FileTooLarge";case Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine:return"ThrottledOnEngine";case Kusto.Data.Common.IngestionErrorCategory.DownloadFailed:return"DownloadFailed";case Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded:return"RetryAttemptsExceeded";case Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived:return"BlobAlreadyReceived";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Common.IngestionErrorCategory};return Kusto.Data.Common.ExtendedIngestionErrorCategory.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Common.IngestionErrorCategory.Unknown:return!0;case Kusto.Data.Common.IngestionErrorCategory.InternalServiceError:return!0;case Kusto.Data.Common.IngestionErrorCategory.BadFormat:return!0;case Kusto.Data.Common.IngestionErrorCategory.BadRequest:return!0;case Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure:return!0;case Kusto.Data.Common.IngestionErrorCategory.EntityNotFound:return!0;case Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized:return!0;case Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized:return!0;case Kusto.Data.Common.IngestionErrorCategory.FileTooLarge:return!0;case Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine:return!0;case Kusto.Data.Common.IngestionErrorCategory.DownloadFailed:return!0;case Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded:return!0;case Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.IngestionErrorCategory};if(Kusto.Data.Common.ExtendedIngestionErrorCategory.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"Unknown":return ret.v=Kusto.Data.Common.IngestionErrorCategory.Unknown,!0;case"InternalServiceError":return ret.v=Kusto.Data.Common.IngestionErrorCategory.InternalServiceError,!0;case"BadFormat":return ret.v=Kusto.Data.Common.IngestionErrorCategory.BadFormat,!0;case"BadRequest":return ret.v=Kusto.Data.Common.IngestionErrorCategory.BadRequest,!0;case"UpdatePolicyFailure":return ret.v=Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure,!0;case"EntityNotFound":return ret.v=Kusto.Data.Common.IngestionErrorCategory.EntityNotFound,!0;case"UserAccessNotAuthorized":return ret.v=Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized,!0;case"DataAccessNotAuthorized":return ret.v=Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized,!0;case"FileTooLarge":return ret.v=Kusto.Data.Common.IngestionErrorCategory.FileTooLarge,!0;case"ThrottledOnEngine":return ret.v=Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine,!0;case"DownloadFailed":return ret.v=Kusto.Data.Common.IngestionErrorCategory.DownloadFailed,!0;case"RetryAttemptsExceeded":return ret.v=Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded,!0;case"BlobAlreadyReceived":return ret.v=Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"unknown":return ret.v=Kusto.Data.Common.IngestionErrorCategory.Unknown,!0;case"internalserviceerror":return ret.v=Kusto.Data.Common.IngestionErrorCategory.InternalServiceError,!0;case"badformat":return ret.v=Kusto.Data.Common.IngestionErrorCategory.BadFormat,!0;case"badrequest":return ret.v=Kusto.Data.Common.IngestionErrorCategory.BadRequest,!0;case"updatepolicyfailure":return ret.v=Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure,!0;case"entitynotfound":return ret.v=Kusto.Data.Common.IngestionErrorCategory.EntityNotFound,!0;case"useraccessnotauthorized":return ret.v=Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized,!0;case"dataaccessnotauthorized":return ret.v=Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized,!0;case"filetoolarge":return ret.v=Kusto.Data.Common.IngestionErrorCategory.FileTooLarge,!0;case"throttledonengine":return ret.v=Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine,!0;case"downloadfailed":return ret.v=Kusto.Data.Common.IngestionErrorCategory.DownloadFailed,!0;case"retryattemptsexceeded":return ret.v=Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded,!0;case"blobalreadyreceived":return ret.v=Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.IngestionErrorCategory.Unknown:return"";case Kusto.Data.Common.IngestionErrorCategory.InternalServiceError:return"";case Kusto.Data.Common.IngestionErrorCategory.BadFormat:return"";case Kusto.Data.Common.IngestionErrorCategory.BadRequest:return"";case Kusto.Data.Common.IngestionErrorCategory.UpdatePolicyFailure:return"";case Kusto.Data.Common.IngestionErrorCategory.EntityNotFound:return"";case Kusto.Data.Common.IngestionErrorCategory.UserAccessNotAuthorized:return"";case Kusto.Data.Common.IngestionErrorCategory.DataAccessNotAuthorized:return"";case Kusto.Data.Common.IngestionErrorCategory.FileTooLarge:return"";case Kusto.Data.Common.IngestionErrorCategory.ThrottledOnEngine:return"";case Kusto.Data.Common.IngestionErrorCategory.DownloadFailed:return"";case Kusto.Data.Common.IngestionErrorCategory.RetryAttemptsExceeded:return"";case Kusto.Data.Common.IngestionErrorCategory.BlobAlreadyReceived:return"";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtendedIngestionErrorCode",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.IngestionErrorCode.Unknown:return"Unknown";case Kusto.Data.Common.IngestionErrorCode.OutOfMemory:return"OutOfMemory";case Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields:return"Stream_WrongNumberOfFields";case Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge:return"Stream_InputStreamTooLarge";case Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest:return"Stream_NoDataToIngest";case Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing:return"Stream_ClosingQuoteMissing";case Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge:return"Stream_DynamicPropertyBagTooLarge";case Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound:return"Download_SourceNotFound";case Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied:return"Download_AccessConditionNotSatisfied";case Kusto.Data.Common.IngestionErrorCode.Download_Forbidden:return"Download_Forbidden";case Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound:return"Download_AccountNotFound";case Kusto.Data.Common.IngestionErrorCode.Download_BadRequest:return"Download_BadRequest";case Kusto.Data.Common.IngestionErrorCode.Download_NotTransient:return"Download_NotTransient";case Kusto.Data.Common.IngestionErrorCode.Download_UnknownError:return"Download_UnknownError";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:return"UpdatePolicy_QuerySchemaDoesNotMatchTableSchema";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction:return"UpdatePolicy_FailedDescendantTransaction";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError:return"UpdatePolicy_IngestionError";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError:return"UpdatePolicy_UnknownError";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure:return"BadRequest_MissingMappingFailure";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob:return"BadRequest_InvalidBlob";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob:return"BadRequest_EmptyBlob";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat:return"BadRequest_NoRecordsOrWrongFormat";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive:return"BadRequest_EmptyArchive";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive:return"BadRequest_InvalidArchive";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri:return"BadRequest_InvalidBlobUri";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri:return"BadRequest_EmptyBlobUri";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist:return"BadRequest_DatabaseNotExist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist:return"BadRequest_TableNotExist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken:return"BadRequest_InvalidKustoIdentityToken";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge:return"BadRequest_FileTooLarge";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied:return"BadRequest_TableAccessDenied";case Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded:return"General_RetryAttemptsExceeded";case Kusto.Data.Common.IngestionErrorCode.General_BadRequest:return"General_BadRequest";case Kusto.Data.Common.IngestionErrorCode.General_InternalServerError:return"General_InternalServerError";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed:return"UpdatePolicy_Cyclic_Update_Not_Allowed";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping:return"BadRequest_InvalidMapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference:return"BadRequest_InvalidMappingReference";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound:return"BadRequest_MappingReferenceWasNotFound";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported:return"BadRequest_FormatNotSupported";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping:return"BadRequest_DuplicateMapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage:return"BadRequest_CorruptedMessage";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping:return"BadRequest_InconsistentMapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError:return"BadRequest_SyntaxError";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName:return"BadRequest_InvalidOrEmptyTableName";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName:return"BadRequest_EmptyDatabaseName";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier:return"BadRequest_EmptyTenantIdentifier";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference:return"BadRequest_EmptyMappingReference";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound:return"BadRequest_EntityNotFound";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid:return"BadRequest_EntityNameIsNotValid";case Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion:return"General_AbandonedIngestion";case Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion:return"General_ThrottledIngestion";case Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch:return"General_TransientSchemaMismatch";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied:return"BadRequest_DatabaseAccessDenied";case Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream:return"BadRequest_UnexpectedCharacterInInputStream";case Kusto.Data.Common.IngestionErrorCode.Forbidden:return"Forbidden";case Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:return"BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod:return"BadRequest_CreationTimeEarlierThanSoftDeletePeriod";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported:return"BadRequest_NotSupported";case Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists:return"Skipped_IngestByTagAlreadyExists";case Kusto.Data.Common.IngestionErrorCode.Timeout:return"Timeout";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty:return"BadRequest_MalformedIngestionProperty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext:return"BadRequest_IngestionPropertyNotSupportedInThisContext";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication:return"BadRequest_InvalidAuthentication";case Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch:return"BlobAlreadyReceived_BlobAlreadyFoundInBatch";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity:return"BadRequest_InvalidManagedIdentity";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached:return"BadRequest_DataCapacityLimitReached";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest:return"UpdatePolicy_BadRequest";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection:return"BadRequest_NonMultiDatabaseDataConnection";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.UInt32)])},FastIsDefined:function(value){var dummy={v:new Kusto.Data.Common.IngestionErrorCode};return Kusto.Data.Common.ExtendedIngestionErrorCode.FastTryParse(value,dummy,!1,!0)},FastIsDefined$1:function(value){switch(value){case Kusto.Data.Common.IngestionErrorCode.Unknown:return!0;case Kusto.Data.Common.IngestionErrorCode.OutOfMemory:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing:return!0;case Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_Forbidden:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_BadRequest:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_NotTransient:return!0;case Kusto.Data.Common.IngestionErrorCode.Download_UnknownError:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied:return!0;case Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded:return!0;case Kusto.Data.Common.IngestionErrorCode.General_BadRequest:return!0;case Kusto.Data.Common.IngestionErrorCode.General_InternalServerError:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid:return!0;case Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion:return!0;case Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion:return!0;case Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream:return!0;case Kusto.Data.Common.IngestionErrorCode.Forbidden:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported:return!0;case Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists:return!0;case Kusto.Data.Common.IngestionErrorCode.Timeout:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication:return!0;case Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached:return!0;case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest:return!0;case Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)>>>0===flag},FastHasFlag:function(that,flag){return(that&flag)>>>0===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.IngestionErrorCode};if(Kusto.Data.Common.ExtendedIngestionErrorCode.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"Unknown":return ret.v=Kusto.Data.Common.IngestionErrorCode.Unknown,!0;case"0x80DA0007":case"OutOfMemory":return ret.v=Kusto.Data.Common.IngestionErrorCode.OutOfMemory,!0;case"0x80DA0008":case"Stream_WrongNumberOfFields":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields,!0;case"0x80DA0009":case"Stream_InputStreamTooLarge":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge,!0;case"Stream_NoDataToIngest":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest,!0;case"0x80DA000b":case"Stream_ClosingQuoteMissing":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing,!0;case"0x80DA000E":case"Stream_DynamicPropertyBagTooLarge":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge,!0;case"Download_SourceNotFound":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound,!0;case"Download_AccessConditionNotSatisfied":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied,!0;case"Download_Forbidden":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_Forbidden,!0;case"Download_AccountNotFound":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound,!0;case"Download_BadRequest":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_BadRequest,!0;case"Download_NotTransient":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_NotTransient,!0;case"Download_UnknownError":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_UnknownError,!0;case"UpdatePolicy_QuerySchemaDoesNotMatchTableSchema":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema,!0;case"UpdatePolicy_FailedDescendantTransaction":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction,!0;case"UpdatePolicy_IngestionError":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError,!0;case"UpdatePolicy_UnknownError":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError,!0;case"BadRequest_MissingMappingFailure":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure,!0;case"BadRequest_InvalidBlob":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob,!0;case"BadRequest_EmptyBlob":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob,!0;case"BadRequest_NoRecordsOrWrongFormat":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat,!0;case"BadRequest_EmptyArchive":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive,!0;case"BadRequest_InvalidArchive":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive,!0;case"BadRequest_InvalidBlobUri":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri,!0;case"BadRequest_EmptyBlobUri":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri,!0;case"BadRequest_DatabaseNotExist":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist,!0;case"BadRequest_TableNotExist":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist,!0;case"BadRequest_InvalidKustoIdentityToken":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken,!0;case"BadRequest_FileTooLarge":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge,!0;case"BadRequest_TableAccessDenied":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied,!0;case"General_RetryAttemptsExceeded":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded,!0;case"General_BadRequest":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_BadRequest,!0;case"General_InternalServerError":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_InternalServerError,!0;case"UpdatePolicy_Cyclic_Update_Not_Allowed":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed,!0;case"BadRequest_InvalidMapping":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping,!0;case"BadRequest_InvalidMappingReference":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference,!0;case"BadRequest_MappingReferenceWasNotFound":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound,!0;case"BadRequest_FormatNotSupported":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported,!0;case"BadRequest_DuplicateMapping":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping,!0;case"BadRequest_CorruptedMessage":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage,!0;case"BadRequest_InconsistentMapping":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping,!0;case"BadRequest_SyntaxError":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError,!0;case"BadRequest_InvalidOrEmptyTableName":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName,!0;case"BadRequest_EmptyDatabaseName":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName,!0;case"BadRequest_EmptyTenantIdentifier":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier,!0;case"BadRequest_EmptyMappingReference":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference,!0;case"BadRequest_EntityNotFound":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound,!0;case"BadRequest_EntityNameIsNotValid":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid,!0;case"General_AbandonedIngestion":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion,!0;case"General_ThrottledIngestion":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion,!0;case"General_TransientSchemaMismatch":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch,!0;case"BadRequest_DatabaseAccessDenied":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied,!0;case"BadRequest_UnexpectedCharacterInInputStream":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream,!0;case"Forbidden":return ret.v=Kusto.Data.Common.IngestionErrorCode.Forbidden,!0;case"BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy,!0;case"BadRequest_CreationTimeEarlierThanSoftDeletePeriod":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod,!0;case"BadRequest_NotSupported":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported,!0;case"Skipped_IngestByTagAlreadyExists":return ret.v=Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists,!0;case"0x80131505":case"Timeout":return ret.v=Kusto.Data.Common.IngestionErrorCode.Timeout,!0;case"BadRequest_MalformedIngestionProperty":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty,!0;case"BadRequest_IngestionPropertyNotSupportedInThisContext":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext,!0;case"BadRequest_InvalidAuthentication":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication,!0;case"BlobAlreadyReceived_BlobAlreadyFoundInBatch":return ret.v=Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch,!0;case"BadRequest_InvalidManagedIdentity":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity,!0;case"BadRequest_DataCapacityLimitReached":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached,!0;case"UpdatePolicy_BadRequest":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest,!0;case"BadRequest_NonMultiDatabaseDataConnection":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"unknown":return ret.v=Kusto.Data.Common.IngestionErrorCode.Unknown,!0;case"outofmemory":return ret.v=Kusto.Data.Common.IngestionErrorCode.OutOfMemory,!0;case"stream_wrongnumberoffields":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields,!0;case"stream_inputstreamtoolarge":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge,!0;case"stream_nodatatoingest":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest,!0;case"stream_closingquotemissing":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing,!0;case"stream_dynamicpropertybagtoolarge":return ret.v=Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge,!0;case"download_sourcenotfound":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound,!0;case"download_accessconditionnotsatisfied":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied,!0;case"download_forbidden":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_Forbidden,!0;case"download_accountnotfound":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound,!0;case"download_badrequest":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_BadRequest,!0;case"download_nottransient":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_NotTransient,!0;case"download_unknownerror":return ret.v=Kusto.Data.Common.IngestionErrorCode.Download_UnknownError,!0;case"updatepolicy_queryschemadoesnotmatchtableschema":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema,!0;case"updatepolicy_faileddescendanttransaction":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction,!0;case"updatepolicy_ingestionerror":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError,!0;case"updatepolicy_unknownerror":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError,!0;case"badrequest_missingmappingfailure":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure,!0;case"badrequest_invalidblob":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob,!0;case"badrequest_emptyblob":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob,!0;case"badrequest_norecordsorwrongformat":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat,!0;case"badrequest_emptyarchive":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive,!0;case"badrequest_invalidarchive":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive,!0;case"badrequest_invalidbloburi":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri,!0;case"badrequest_emptybloburi":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri,!0;case"badrequest_databasenotexist":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist,!0;case"badrequest_tablenotexist":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist,!0;case"badrequest_invalidkustoidentitytoken":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken,!0;case"badrequest_filetoolarge":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge,!0;case"badrequest_tableaccessdenied":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied,!0;case"general_retryattemptsexceeded":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded,!0;case"general_badrequest":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_BadRequest,!0;case"general_internalservererror":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_InternalServerError,!0;case"updatepolicy_cyclic_update_not_allowed":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed,!0;case"badrequest_invalidmapping":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping,!0;case"badrequest_invalidmappingreference":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference,!0;case"badrequest_mappingreferencewasnotfound":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound,!0;case"badrequest_formatnotsupported":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported,!0;case"badrequest_duplicatemapping":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping,!0;case"badrequest_corruptedmessage":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage,!0;case"badrequest_inconsistentmapping":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping,!0;case"badrequest_syntaxerror":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError,!0;case"badrequest_invalidoremptytablename":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName,!0;case"badrequest_emptydatabasename":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName,!0;case"badrequest_emptytenantidentifier":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier,!0;case"badrequest_emptymappingreference":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference,!0;case"badrequest_entitynotfound":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound,!0;case"badrequest_entitynameisnotvalid":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid,!0;case"general_abandonedingestion":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion,!0;case"general_throttledingestion":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion,!0;case"general_transientschemamismatch":return ret.v=Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch,!0;case"badrequest_databaseaccessdenied":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied,!0;case"badrequest_unexpectedcharacterininputstream":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream,!0;case"forbidden":return ret.v=Kusto.Data.Common.IngestionErrorCode.Forbidden,!0;case"badrequest_zeroretentionpolicywithnoupdatepolicy":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy,!0;case"badrequest_creationtimeearlierthansoftdeleteperiod":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod,!0;case"badrequest_notsupported":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported,!0;case"skipped_ingestbytagalreadyexists":return ret.v=Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists,!0;case"timeout":return ret.v=Kusto.Data.Common.IngestionErrorCode.Timeout,!0;case"badrequest_malformedingestionproperty":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty,!0;case"badrequest_ingestionpropertynotsupportedinthiscontext":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext,!0;case"badrequest_invalidauthentication":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication,!0;case"blobalreadyreceived_blobalreadyfoundinbatch":return ret.v=Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch,!0;case"badrequest_invalidmanagedidentity":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity,!0;case"badrequest_datacapacitylimitreached":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached,!0;case"updatepolicy_badrequest":return ret.v=Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest,!0;case"badrequest_nonmultidatabasedataconnection":return ret.v=Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v>>>0,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that|0},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.IngestionErrorCode.Unknown:return"Unknown error occurred";case Kusto.Data.Common.IngestionErrorCode.OutOfMemory:return"Ingestion operation ran out of memory";case Kusto.Data.Common.IngestionErrorCode.Stream_WrongNumberOfFields:return"Wrong number of fields.";case Kusto.Data.Common.IngestionErrorCode.Stream_InputStreamTooLarge:return"Input stream/record/field too large.";case Kusto.Data.Common.IngestionErrorCode.Stream_NoDataToIngest:return"No data streams to ingest";case Kusto.Data.Common.IngestionErrorCode.Stream_ClosingQuoteMissing:return"Invalid csv format - closing quote missing.";case Kusto.Data.Common.IngestionErrorCode.Stream_DynamicPropertyBagTooLarge:return"The combined size of the property bag's distinct keys is getting too large.";case Kusto.Data.Common.IngestionErrorCode.Download_SourceNotFound:return"Failed to download source from Azure storage - source not found";case Kusto.Data.Common.IngestionErrorCode.Download_AccessConditionNotSatisfied:return"Failed to download source from Azure storage - access condition not satisfied";case Kusto.Data.Common.IngestionErrorCode.Download_Forbidden:return"Failed to download source from Azure storage - access forbidden";case Kusto.Data.Common.IngestionErrorCode.Download_AccountNotFound:return"Failed to download source from Azure storage - account not found";case Kusto.Data.Common.IngestionErrorCode.Download_BadRequest:return"Failed to download source from Azure storage - bad request";case Kusto.Data.Common.IngestionErrorCode.Download_NotTransient:return"Failed to download source from Azure storage - not transient error";case Kusto.Data.Common.IngestionErrorCode.Download_UnknownError:return"Failed to download source from Azure storage - unknown error";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:return"Failed to invoke update policy. Query schema does not match table schema";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_FailedDescendantTransaction:return"Failed to invoke update policy. Failed descendant transactional update policy";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_IngestionError:return"Failed to invoke update policy. Ingestion Error occurred";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_UnknownError:return"Failed to invoke update policy. Unknown error occurred";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MissingMappingFailure:return"A format that requires ingestion mapping was sent without the one. Identity ingestion mapping can be auto-created only when the ingestion format is specified";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlob:return"Blob is invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlob:return"Blob is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NoRecordsOrWrongFormat:return"No records to ingest or using wrong data format";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyArchive:return"Archive is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidArchive:return"Archive is invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidBlobUri:return"Blob Uri is invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyBlobUri:return"Blob Uri is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseNotExist:return"Database does not exist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableNotExist:return"Table does not exist";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidKustoIdentityToken:return"Invalid kusto identity token";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FileTooLarge:return"File too large";case Kusto.Data.Common.IngestionErrorCode.BadRequest_TableAccessDenied:return"Access to table is denied";case Kusto.Data.Common.IngestionErrorCode.General_RetryAttemptsExceeded:return"Operation has exceeded the retry attempts limit or timespan following a recurring transient error";case Kusto.Data.Common.IngestionErrorCode.General_BadRequest:return"Bad request";case Kusto.Data.Common.IngestionErrorCode.General_InternalServerError:return"Internal server error occurred";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_Cyclic_Update_Not_Allowed:return"Failed to invoke update policy. Cyclic update is not allowed";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMapping:return"Failed to parse ingestion mapping.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidMappingReference:return"Invalid mapping reference.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MappingReferenceWasNotFound:return"Mapping reference wasn't found.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_FormatNotSupported:return"Format is not supported";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DuplicateMapping:return"Ingestion properties contains ingestion mapping and ingestion mapping reference.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CorruptedMessage:return"Message is corrupted";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InconsistentMapping:return"Inconsistent ingestion mapping";case Kusto.Data.Common.IngestionErrorCode.BadRequest_SyntaxError:return"Syntax error";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidOrEmptyTableName:return"Table name is empty or invalid";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyDatabaseName:return"Database name is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyTenantIdentifier:return"TenantIdentifier is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EmptyMappingReference:return"MappingReference is empty";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNotFound:return"Failed to locate an entity";case Kusto.Data.Common.IngestionErrorCode.BadRequest_EntityNameIsNotValid:return"Entity name is not valid";case Kusto.Data.Common.IngestionErrorCode.General_AbandonedIngestion:return"Abandoned ingestion.";case Kusto.Data.Common.IngestionErrorCode.General_ThrottledIngestion:return"Throttled ingestion.";case Kusto.Data.Common.IngestionErrorCode.General_TransientSchemaMismatch:return"Schema of target table at start time doesn't match the one at commit time.";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DatabaseAccessDenied:return"Access to database is denied";case Kusto.Data.Common.IngestionErrorCode.BadRequest_UnexpectedCharacterInInputStream:return"Unexpected character in the input stream";case Kusto.Data.Common.IngestionErrorCode.Forbidden:return"Insufficient security permissions to execute request";case Kusto.Data.Common.IngestionErrorCode.BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:return"Table has zero rentention policy and is not the source table for any update policy";case Kusto.Data.Common.IngestionErrorCode.BadRequest_CreationTimeEarlierThanSoftDeletePeriod:return"Specified creation time is earlier than table's soft delete period";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NotSupported:return"Request not supported";case Kusto.Data.Common.IngestionErrorCode.Skipped_IngestByTagAlreadyExists:return"Another stream with the same ingest-by tag was already ingested";case Kusto.Data.Common.IngestionErrorCode.Timeout:return"Ingestion operation timed out";case Kusto.Data.Common.IngestionErrorCode.BadRequest_MalformedIngestionProperty:return"Ingestion property is malformed";case Kusto.Data.Common.IngestionErrorCode.BadRequest_IngestionPropertyNotSupportedInThisContext:return"Ingestion property is not supported in this context";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidAuthentication:return"Authentication to data is not valid";case Kusto.Data.Common.IngestionErrorCode.BlobAlreadyReceived_BlobAlreadyFoundInBatch:return"One copy of this blob has already been processed. The service will only attempt to ingest one copy of the blob";case Kusto.Data.Common.IngestionErrorCode.BadRequest_InvalidManagedIdentity:return"Managed Identity is not defined, not allowed by a policy, or doesn't have permissions on the resource";case Kusto.Data.Common.IngestionErrorCode.BadRequest_DataCapacityLimitReached:return"Raised to indicate that storage data capacity has reached its limit";case Kusto.Data.Common.IngestionErrorCode.UpdatePolicy_BadRequest:return"Failed to invoke update policy as a result of a bad request, e.g. query semantic error";case Kusto.Data.Common.IngestionErrorCode.BadRequest_NonMultiDatabaseDataConnection:return"Event contains the 'database' property directing the ingestion into a database different than the target database configured in the data connection's settings. Since this data connection is set to multiDatabase = false, dynamic database routing is forbidden.";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtendedStorageEngineKind",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.StorageEngineKind.StorageV2:return"StorageV2";case Kusto.Data.Common.StorageEngineKind.StorageV3:return"StorageV3";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Common.StorageEngineKind};return Kusto.Data.Common.ExtendedStorageEngineKind.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Common.StorageEngineKind.StorageV2:return!0;case Kusto.Data.Common.StorageEngineKind.StorageV3:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.StorageEngineKind};if(Kusto.Data.Common.ExtendedStorageEngineKind.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"StorageV2":return ret.v=Kusto.Data.Common.StorageEngineKind.StorageV2,!0;case"1":case"StorageV3":return ret.v=Kusto.Data.Common.StorageEngineKind.StorageV3,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"storagev2":return ret.v=Kusto.Data.Common.StorageEngineKind.StorageV2,!0;case"storagev3":return ret.v=Kusto.Data.Common.StorageEngineKind.StorageV3,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.StorageEngineKind.StorageV2:return"V2 - extents data storage engine";case Kusto.Data.Common.StorageEngineKind.StorageV3:return"V3 - shard data storage engine";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtendedTransformationMethod",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Common.TransformationMethod.None:return"None";case Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary:return"PropertyBagArrayToDictionary";case Kusto.Data.Common.TransformationMethod.SourceLocation:return"SourceLocation";case Kusto.Data.Common.TransformationMethod.SourceLineNumber:return"SourceLineNumber";case Kusto.Data.Common.TransformationMethod.UnknownMethod1:return"UnknownMethod1";case Kusto.Data.Common.TransformationMethod.UnknownMethod:return"UnknownMethod";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds:return"DateTimeFromUnixSeconds";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds:return"DateTimeFromUnixMilliseconds";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds:return"DateTimeFromUnixMicroseconds";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds:return"DateTimeFromUnixNanoseconds";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Common.TransformationMethod};return Kusto.Data.Common.ExtendedTransformationMethod.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Common.TransformationMethod.None:return!0;case Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary:return!0;case Kusto.Data.Common.TransformationMethod.SourceLocation:return!0;case Kusto.Data.Common.TransformationMethod.SourceLineNumber:return!0;case Kusto.Data.Common.TransformationMethod.UnknownMethod1:return!0;case Kusto.Data.Common.TransformationMethod.UnknownMethod:return!0;case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds:return!0;case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds:return!0;case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds:return!0;case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Common.TransformationMethod};if(Kusto.Data.Common.ExtendedTransformationMethod.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"None":return ret.v=Kusto.Data.Common.TransformationMethod.None,!0;case"1":case"PropertyBagArrayToDictionary":return ret.v=Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary,!0;case"2":case"SourceLocation":return ret.v=Kusto.Data.Common.TransformationMethod.SourceLocation,!0;case"3":case"SourceLineNumber":return ret.v=Kusto.Data.Common.TransformationMethod.SourceLineNumber,!0;case"4":case"UnknownMethod1":return ret.v=Kusto.Data.Common.TransformationMethod.UnknownMethod1,!0;case"5":case"UnknownMethod":return ret.v=Kusto.Data.Common.TransformationMethod.UnknownMethod,!0;case"6":case"DateTimeFromUnixSeconds":return ret.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds,!0;case"7":case"DateTimeFromUnixMilliseconds":return ret.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds,!0;case"8":case"DateTimeFromUnixMicroseconds":return ret.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds,!0;case"9":case"DateTimeFromUnixNanoseconds":return ret.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"none":return ret.v=Kusto.Data.Common.TransformationMethod.None,!0;case"propertybagarraytodictionary":return ret.v=Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary,!0;case"sourcelocation":return ret.v=Kusto.Data.Common.TransformationMethod.SourceLocation,!0;case"sourcelinenumber":return ret.v=Kusto.Data.Common.TransformationMethod.SourceLineNumber,!0;case"unknownmethod1":return ret.v=Kusto.Data.Common.TransformationMethod.UnknownMethod1,!0;case"unknownmethod":return ret.v=Kusto.Data.Common.TransformationMethod.UnknownMethod,!0;case"datetimefromunixseconds":return ret.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds,!0;case"datetimefromunixmilliseconds":return ret.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds,!0;case"datetimefromunixmicroseconds":return ret.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds,!0;case"datetimefromunixnanoseconds":return ret.v=Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Common.TransformationMethod.None:return"Comma-separated value.";case Kusto.Data.Common.TransformationMethod.PropertyBagArrayToDictionary:return"Property bag array to dictionary.";case Kusto.Data.Common.TransformationMethod.SourceLocation:return"Source location.";case Kusto.Data.Common.TransformationMethod.SourceLineNumber:return"Source line number.";case Kusto.Data.Common.TransformationMethod.UnknownMethod1:return"Was GetPathElement";case Kusto.Data.Common.TransformationMethod.UnknownMethod:return"Unknown method.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixSeconds:return"Converts UNIX epoch (seconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMilliseconds:return"Converts UNIX epoch (milliseconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixMicroseconds:return"Converts UNIX epoch (microseconds) to UTC datetime.";case Kusto.Data.Common.TransformationMethod.DateTimeFromUnixNanoseconds:return"Converts UNIX epoch (nanoseconds) to UTC datetime.";default:return null}}}}});Bridge.define("Kusto.Data.Common.ExtentsMergeLookbackPeriodKind",{$kind:"enum",statics:{fields:{Default:0,HotCache:1,All:2,Custom:3}}});Bridge.define("Kusto.Data.Common.IngestionErrorCategory",{$kind:"enum",statics:{fields:{Unknown:0,InternalServiceError:1,BadFormat:2,BadRequest:3,UpdatePolicyFailure:4,EntityNotFound:5,UserAccessNotAuthorized:6,DataAccessNotAuthorized:7,FileTooLarge:8,ThrottledOnEngine:9,DownloadFailed:10,RetryAttemptsExceeded:11,BlobAlreadyReceived:12}}});Bridge.define("Kusto.Data.Common.IngestionErrorCode",{$kind:"enum",statics:{fields:{Unknown:0,OutOfMemory:2161770503,Stream_WrongNumberOfFields:2161770504,Stream_InputStreamTooLarge:2161770505,Stream_NoDataToIngest:2161770506,Stream_ClosingQuoteMissing:2161770507,Stream_DynamicPropertyBagTooLarge:2161770510,Download_SourceNotFound:2161770511,Download_AccessConditionNotSatisfied:2161770512,Download_Forbidden:2161770513,Download_AccountNotFound:2161770514,Download_BadRequest:2161770515,Download_NotTransient:2161770516,Download_UnknownError:2161770517,UpdatePolicy_QuerySchemaDoesNotMatchTableSchema:2161770518,UpdatePolicy_FailedDescendantTransaction:2161770519,UpdatePolicy_IngestionError:2161770520,UpdatePolicy_UnknownError:2161770521,BadRequest_MissingMappingFailure:2161770522,BadRequest_InvalidBlob:2161770523,BadRequest_EmptyBlob:2161770524,BadRequest_NoRecordsOrWrongFormat:2161770525,BadRequest_EmptyArchive:2161770526,BadRequest_InvalidArchive:2161770527,BadRequest_InvalidBlobUri:2161770528,BadRequest_EmptyBlobUri:2161770529,BadRequest_DatabaseNotExist:2161770530,BadRequest_TableNotExist:2161770531,BadRequest_InvalidKustoIdentityToken:2161770532,BadRequest_FileTooLarge:2161770533,BadRequest_TableAccessDenied:2161770534,General_RetryAttemptsExceeded:2161770535,General_BadRequest:2161770536,General_InternalServerError:2161770537,UpdatePolicy_Cyclic_Update_Not_Allowed:2161770538,BadRequest_InvalidMapping:2161770539,BadRequest_InvalidMappingReference:2161770540,BadRequest_MappingReferenceWasNotFound:2161770541,BadRequest_FormatNotSupported:2161770542,BadRequest_DuplicateMapping:2161770543,BadRequest_CorruptedMessage:2161770544,BadRequest_InconsistentMapping:2161770545,BadRequest_SyntaxError:2161770546,BadRequest_InvalidOrEmptyTableName:2161770547,BadRequest_EmptyDatabaseName:2161770548,BadRequest_EmptyTenantIdentifier:2161770549,BadRequest_EmptyMappingReference:2161770550,BadRequest_EntityNotFound:2161770551,BadRequest_EntityNameIsNotValid:2161770552,General_AbandonedIngestion:2161770553,General_ThrottledIngestion:2161770554,General_TransientSchemaMismatch:2161770555,BadRequest_DatabaseAccessDenied:2161770556,BadRequest_UnexpectedCharacterInInputStream:2161770557,Forbidden:2161770558,BadRequest_ZeroRetentionPolicyWithNoUpdatePolicy:2161770559,BadRequest_CreationTimeEarlierThanSoftDeletePeriod:2161770560,BadRequest_NotSupported:2161770561,Skipped_IngestByTagAlreadyExists:2161770562,Timeout:2148734213,BadRequest_MalformedIngestionProperty:2148734214,BadRequest_IngestionPropertyNotSupportedInThisContext:2148734215,BadRequest_InvalidAuthentication:2148734216,BlobAlreadyReceived_BlobAlreadyFoundInBatch:2148734217,BadRequest_InvalidManagedIdentity:2148734218,BadRequest_DataCapacityLimitReached:2148734219,UpdatePolicy_BadRequest:2148734220,BadRequest_NonMultiDatabaseDataConnection:2148734221}},$utype:System.UInt32});Bridge.define("Kusto.Data.Common.StorageEngineKind",{$kind:"enum",statics:{fields:{StorageV2:0,StorageV3:1}}});Bridge.define("Kusto.Data.Common.TransformationMethod",{$kind:"enum",statics:{fields:{None:0,PropertyBagArrayToDictionary:1,SourceLocation:2,SourceLineNumber:3,UnknownMethod1:4,UnknownMethod:5,DateTimeFromUnixSeconds:6,DateTimeFromUnixMilliseconds:7,DateTimeFromUnixMicroseconds:8,DateTimeFromUnixNanoseconds:9}}});Bridge.define("Kusto.Data.DmSettingsType",{$kind:"enum",statics:{fields:{AdminSettings:0,DataObtainerServiceSettings:1,DataAggregatorSettings:2,DataObtainerSettings:3,CloudManagersSettings:5,SchemaManagmentSettings:6,CommonSettings:7,DataImporterSettings:8,StatusReporterSettings:9,All:10,VirtualDmsSettings:11}}});Bridge.define("Kusto.Data.ExtendedDmSettingsType",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.DmSettingsType.AdminSettings:return"AdminSettings";case Kusto.Data.DmSettingsType.DataObtainerServiceSettings:return"DataObtainerServiceSettings";case Kusto.Data.DmSettingsType.DataAggregatorSettings:return"DataAggregatorSettings";case Kusto.Data.DmSettingsType.DataObtainerSettings:return"DataObtainerSettings";case Kusto.Data.DmSettingsType.CloudManagersSettings:return"CloudManagersSettings";case Kusto.Data.DmSettingsType.SchemaManagmentSettings:return"SchemaManagmentSettings";case Kusto.Data.DmSettingsType.CommonSettings:return"CommonSettings";case Kusto.Data.DmSettingsType.DataImporterSettings:return"DataImporterSettings";case Kusto.Data.DmSettingsType.StatusReporterSettings:return"StatusReporterSettings";case Kusto.Data.DmSettingsType.All:return"All";case Kusto.Data.DmSettingsType.VirtualDmsSettings:return"VirtualDmsSettings";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.DmSettingsType};return Kusto.Data.ExtendedDmSettingsType.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.DmSettingsType.AdminSettings:return!0;case Kusto.Data.DmSettingsType.DataObtainerServiceSettings:return!0;case Kusto.Data.DmSettingsType.DataAggregatorSettings:return!0;case Kusto.Data.DmSettingsType.DataObtainerSettings:return!0;case Kusto.Data.DmSettingsType.CloudManagersSettings:return!0;case Kusto.Data.DmSettingsType.SchemaManagmentSettings:return!0;case Kusto.Data.DmSettingsType.CommonSettings:return!0;case Kusto.Data.DmSettingsType.DataImporterSettings:return!0;case Kusto.Data.DmSettingsType.StatusReporterSettings:return!0;case Kusto.Data.DmSettingsType.All:return!0;case Kusto.Data.DmSettingsType.VirtualDmsSettings:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.DmSettingsType};if(Kusto.Data.ExtendedDmSettingsType.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"AdminSettings":return ret.v=Kusto.Data.DmSettingsType.AdminSettings,!0;case"1":case"DataObtainerServiceSettings":return ret.v=Kusto.Data.DmSettingsType.DataObtainerServiceSettings,!0;case"2":case"DataAggregatorSettings":return ret.v=Kusto.Data.DmSettingsType.DataAggregatorSettings,!0;case"3":case"DataObtainerSettings":return ret.v=Kusto.Data.DmSettingsType.DataObtainerSettings,!0;case"5":case"CloudManagersSettings":return ret.v=Kusto.Data.DmSettingsType.CloudManagersSettings,!0;case"6":case"SchemaManagmentSettings":return ret.v=Kusto.Data.DmSettingsType.SchemaManagmentSettings,!0;case"7":case"CommonSettings":return ret.v=Kusto.Data.DmSettingsType.CommonSettings,!0;case"8":case"DataImporterSettings":return ret.v=Kusto.Data.DmSettingsType.DataImporterSettings,!0;case"9":case"StatusReporterSettings":return ret.v=Kusto.Data.DmSettingsType.StatusReporterSettings,!0;case"10":case"All":return ret.v=Kusto.Data.DmSettingsType.All,!0;case"11":case"VirtualDmsSettings":return ret.v=Kusto.Data.DmSettingsType.VirtualDmsSettings,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"adminsettings":return ret.v=Kusto.Data.DmSettingsType.AdminSettings,!0;case"dataobtainerservicesettings":return ret.v=Kusto.Data.DmSettingsType.DataObtainerServiceSettings,!0;case"dataaggregatorsettings":return ret.v=Kusto.Data.DmSettingsType.DataAggregatorSettings,!0;case"dataobtainersettings":return ret.v=Kusto.Data.DmSettingsType.DataObtainerSettings,!0;case"cloudmanagerssettings":return ret.v=Kusto.Data.DmSettingsType.CloudManagersSettings,!0;case"schemamanagmentsettings":return ret.v=Kusto.Data.DmSettingsType.SchemaManagmentSettings,!0;case"commonsettings":return ret.v=Kusto.Data.DmSettingsType.CommonSettings,!0;case"dataimportersettings":return ret.v=Kusto.Data.DmSettingsType.DataImporterSettings,!0;case"statusreportersettings":return ret.v=Kusto.Data.DmSettingsType.StatusReporterSettings,!0;case"all":return ret.v=Kusto.Data.DmSettingsType.All,!0;case"virtualdmssettings":return ret.v=Kusto.Data.DmSettingsType.VirtualDmsSettings,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.DmSettingsType.AdminSettings:return"";case Kusto.Data.DmSettingsType.DataObtainerServiceSettings:return"";case Kusto.Data.DmSettingsType.DataAggregatorSettings:return"";case Kusto.Data.DmSettingsType.DataObtainerSettings:return"";case Kusto.Data.DmSettingsType.CloudManagersSettings:return"";case Kusto.Data.DmSettingsType.SchemaManagmentSettings:return"";case Kusto.Data.DmSettingsType.CommonSettings:return"";case Kusto.Data.DmSettingsType.DataImporterSettings:return"";case Kusto.Data.DmSettingsType.StatusReporterSettings:return"";case Kusto.Data.DmSettingsType.All:return"";case Kusto.Data.DmSettingsType.VirtualDmsSettings:return"";default:return null}}}}});Bridge.define("Kusto.Data.ExtendedIngestionQueueType",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.IngestionQueueType.All:return"All";case Kusto.Data.IngestionQueueType.InputQueue:return"InputQueue";case Kusto.Data.IngestionQueueType.InternalQueue:return"InternalQueue";case Kusto.Data.IngestionQueueType.ReadyForAggregationQueue:return"ReadyForAggregationQueue";case Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue:return"SecuredReadyForAggregationQueue";case Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue:return"AggregatedReadyForImportQueue";case Kusto.Data.IngestionQueueType.FailedIngestionsQueue:return"FailedIngestionsQueue";case Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue:return"SuccessfulIngestionsQueue";case Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue:return"AbandonedIngestionsQueue";case Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue:return"SecuredAbandonedIngestionsQueue";case Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue:return"InternalFailedIngestionsQueue";case Kusto.Data.IngestionQueueType.AbandonedInputQueues:return"AbandonedInputQueues";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.IngestionQueueType};return Kusto.Data.ExtendedIngestionQueueType.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.IngestionQueueType.All:return!0;case Kusto.Data.IngestionQueueType.InputQueue:return!0;case Kusto.Data.IngestionQueueType.InternalQueue:return!0;case Kusto.Data.IngestionQueueType.ReadyForAggregationQueue:return!0;case Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue:return!0;case Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue:return!0;case Kusto.Data.IngestionQueueType.FailedIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue:return!0;case Kusto.Data.IngestionQueueType.AbandonedInputQueues:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.IngestionQueueType};if(Kusto.Data.ExtendedIngestionQueueType.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"All":return ret.v=Kusto.Data.IngestionQueueType.All,!0;case"1":case"InputQueue":return ret.v=Kusto.Data.IngestionQueueType.InputQueue,!0;case"2":case"InternalQueue":return ret.v=Kusto.Data.IngestionQueueType.InternalQueue,!0;case"3":case"ReadyForAggregationQueue":return ret.v=Kusto.Data.IngestionQueueType.ReadyForAggregationQueue,!0;case"4":case"SecuredReadyForAggregationQueue":return ret.v=Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue,!0;case"5":case"AggregatedReadyForImportQueue":return ret.v=Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue,!0;case"6":case"FailedIngestionsQueue":return ret.v=Kusto.Data.IngestionQueueType.FailedIngestionsQueue,!0;case"7":case"SuccessfulIngestionsQueue":return ret.v=Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue,!0;case"9":case"AbandonedIngestionsQueue":return ret.v=Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue,!0;case"10":case"SecuredAbandonedIngestionsQueue":return ret.v=Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue,!0;case"11":case"InternalFailedIngestionsQueue":return ret.v=Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue,!0;case"12":case"AbandonedInputQueues":return ret.v=Kusto.Data.IngestionQueueType.AbandonedInputQueues,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"all":return ret.v=Kusto.Data.IngestionQueueType.All,!0;case"inputqueue":return ret.v=Kusto.Data.IngestionQueueType.InputQueue,!0;case"internalqueue":return ret.v=Kusto.Data.IngestionQueueType.InternalQueue,!0;case"readyforaggregationqueue":return ret.v=Kusto.Data.IngestionQueueType.ReadyForAggregationQueue,!0;case"securedreadyforaggregationqueue":return ret.v=Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue,!0;case"aggregatedreadyforimportqueue":return ret.v=Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue,!0;case"failedingestionsqueue":return ret.v=Kusto.Data.IngestionQueueType.FailedIngestionsQueue,!0;case"successfulingestionsqueue":return ret.v=Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue,!0;case"abandonedingestionsqueue":return ret.v=Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue,!0;case"securedabandonedingestionsqueue":return ret.v=Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue,!0;case"internalfailedingestionsqueue":return ret.v=Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue,!0;case"abandonedinputqueues":return ret.v=Kusto.Data.IngestionQueueType.AbandonedInputQueues,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.IngestionQueueType.All:return"";case Kusto.Data.IngestionQueueType.InputQueue:return"";case Kusto.Data.IngestionQueueType.InternalQueue:return"";case Kusto.Data.IngestionQueueType.ReadyForAggregationQueue:return"";case Kusto.Data.IngestionQueueType.SecuredReadyForAggregationQueue:return"";case Kusto.Data.IngestionQueueType.AggregatedReadyForImportQueue:return"";case Kusto.Data.IngestionQueueType.FailedIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.SuccessfulIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.AbandonedIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.SecuredAbandonedIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.InternalFailedIngestionsQueue:return"";case Kusto.Data.IngestionQueueType.AbandonedInputQueues:return"";default:return null}}}}});Bridge.define("Kusto.Data.Ingestion.ExtendedIngestionMappingKind",{statics:{methods:{FastToString:function(that){switch(that){case Kusto.Data.Ingestion.IngestionMappingKind.Unknown:return"Unknown";case Kusto.Data.Ingestion.IngestionMappingKind.Csv:return"Csv";case Kusto.Data.Ingestion.IngestionMappingKind.Json:return"Json";case Kusto.Data.Ingestion.IngestionMappingKind.Avro:return"Avro";case Kusto.Data.Ingestion.IngestionMappingKind.Parquet:return"Parquet";case Kusto.Data.Ingestion.IngestionMappingKind.SStream:return"SStream";case Kusto.Data.Ingestion.IngestionMappingKind.Orc:return"Orc";case Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro:return"ApacheAvro";case Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile:return"W3CLogFile";default:break}return System.String.format("[unknown: {0}]",[Bridge.box(that,System.Int32)])},FastIsDefined$1:function(value){var dummy={v:new Kusto.Data.Ingestion.IngestionMappingKind};return Kusto.Data.Ingestion.ExtendedIngestionMappingKind.FastTryParse(value,dummy,!1,!0)},FastIsDefined:function(value){switch(value){case Kusto.Data.Ingestion.IngestionMappingKind.Unknown:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Csv:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Json:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Avro:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Parquet:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.SStream:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.Orc:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro:return!0;case Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile:return!0;default:return!1}},FastHasFlag$1:function(that,flag){return(that&flag)===flag},FastHasFlag:function(that,flag){return(that&flag)===flag},FastParse:function(value,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);var ret={v:new Kusto.Data.Ingestion.IngestionMappingKind};if(Kusto.Data.Ingestion.ExtendedIngestionMappingKind.FastTryParse(value,ret,ignoreCase,ignoreInts))return ret.v;throw new System.Exception("Invalid enum value: "+(value||""));},FastTryParse:function(value,ret,ignoreCase,ignoreInts){ignoreCase===void 0&&(ignoreCase=!1);ignoreInts===void 0&&(ignoreInts=!1);switch(value){case"0":case"Unknown":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Unknown,!0;case"1":case"Csv":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Csv,!0;case"2":case"Json":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Json,!0;case"4":case"Avro":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Avro,!0;case"5":case"Parquet":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Parquet,!0;case"6":case"SStream":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.SStream,!0;case"7":case"Orc":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Orc,!0;case"8":case"ApacheAvro":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro,!0;case"9":case"W3CLogFile":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile,!0;default:break}if(ignoreCase&&!System.String.isNullOrEmpty(value))switch(value.toLowerCase()){case"unknown":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Unknown,!0;case"csv":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Csv,!0;case"json":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Json,!0;case"avro":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Avro,!0;case"parquet":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Parquet,!0;case"sstream":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.SStream,!0;case"orc":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.Orc,!0;case"apacheavro":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro,!0;case"w3clogfile":return ret.v=Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile,!0;default:break}if(!ignoreInts){var reti={v:0};if(System.Int32.tryParse(value,reti))return ret.v=reti.v,!0}return ret.v=0,!1},FastGetHashCode:function(that){return that},FastGetDescription:function(that){switch(that){case Kusto.Data.Ingestion.IngestionMappingKind.Unknown:return"Unknown";case Kusto.Data.Ingestion.IngestionMappingKind.Csv:return"Csv";case Kusto.Data.Ingestion.IngestionMappingKind.Json:return"Json";case Kusto.Data.Ingestion.IngestionMappingKind.Avro:return"Avro";case Kusto.Data.Ingestion.IngestionMappingKind.Parquet:return"Parquet";case Kusto.Data.Ingestion.IngestionMappingKind.SStream:return"SStream";case Kusto.Data.Ingestion.IngestionMappingKind.Orc:return"Orc";case Kusto.Data.Ingestion.IngestionMappingKind.ApacheAvro:return"Apache Avro (through avro2json)";case Kusto.Data.Ingestion.IngestionMappingKind.W3CLogFile:return"W3C Extended Log File format";default:return null}}}}});Bridge.define("Kusto.Data.Ingestion.IngestionMappingKind",{$kind:"enum",statics:{fields:{Unknown:0,Csv:1,Json:2,Avro:4,Parquet:5,SStream:6,Orc:7,ApacheAvro:8,W3CLogFile:9}}});Bridge.define("Kusto.Data.IngestionQueueType",{$kind:"enum",statics:{fields:{All:0,InputQueue:1,InternalQueue:2,ReadyForAggregationQueue:3,SecuredReadyForAggregationQueue:4,AggregatedReadyForImportQueue:5,FailedIngestionsQueue:6,SuccessfulIngestionsQueue:7,AbandonedIngestionsQueue:9,SecuredAbandonedIngestionsQueue:10,InternalFailedIngestionsQueue:11,AbandonedInputQueues:12}}});Bridge.define("Kusto.Data.IntelliSense.AdminEngineRuleKind",{$kind:"enum",statics:{fields:{None:0,Start:0,YieldShowCommandOptions:0,YieldTableNamesForAdminOptions:1,YieldFunctionNamesForAdminOptions:2,YieldDatabaseNames:3,YieldShowBasicAuthOptions:4,YieldShowDatabasePrincipalsPoliciesAndSchemaOptions:5,YieldShowDatabasesOptions:6,YieldShowClusterPrincipalsOptions:7,YieldSetDatabaseAdminsUsersViewersPrettyNameOptions:8,YieldSetClusterAdminsUsersViewersDatabaseCreatorsOptions:9,YieldSetTableAdminsOptions:10,YieldAddDatabaseAdminsUsersViewersOptions:11,YieldDropDatabaseOptions:12,YieldAddClusterAdminsUsersViewersDatabaseCreatorsBlockedPrincipalsOptions:13,YieldDropClusterAdminsUsersViewersDatabaseCreatorsBlockedPrincipalsOptions:14,YieldAddClusterBlockedPrincipalsOptions:15,YieldAddTableAdminsOptions:16,YieldDropTableEntitiesOptions:17,YieldDeleteTableEntitiesOptions:18,YieldCreateTableEntitiesOptions:19,YieldAlterTableEntitiesOptions:20,YieldDropTableColumnsSyntaxOptions:21,YieldSetDatabaseUsersNoneOptions:22,YieldSetDatabaseAdminsNoneOptions:23,YieldSetDatabaseViewersNoneOptions:24,YieldSetClusterUsersNoneOptions:25,YieldSetClusterAdminsNoneOptions:26,YieldSetClusterViewersNoneOptions:27,YieldSetClusterDatabaseCreatorsNoneOptions:28,YieldSetTableAdminsNoneOptions:29,YieldShowTableEntitiesOptions:30,YieldAlterExtentTagsOptions:31,YieldAttachExtentsOptions:32,YieldAttachExtentsIntoTableOptions:33,YieldDropExtentTagsOptions:34,YieldMoveExtentsOptions:35,YieldMoveSpecifiedExtentsOptions:36,YieldMoveExtentsToTableOptions:37,YieldReplaceCommandOptions:38,YieldReplaceExtentsOptions:39,YieldRunCommandOptions:40,YieldShowExtentsOptions:41,YieldShowExtentsByEntityOptions:42,YieldShowExtentsByEntityWithTagsFiltersOptions:43,YieldSetCommandOptions:44,YieldSetOrAppendCommandOptions:45,YieldAddCommandOptions:46,YieldAttachCommandOptions:47,YieldDropCommandOptions:48,YieldMoveCommandOptions:49,YieldPoliciesOptions:50,YieldClusterPoliciesOptions:51,YieldDatabasePoliciesOptions:52,YieldTablePoliciesOptions:53,YieldColumnPoliciesOptions:54,YieldAlterCommandOptions:55,YieldAlterMergeCommandOptions:56,YieldDeleteCommandOptions:57,YieldCreateCommandOptions:58,YieldMultiplePoliciesOptions:59,YieldDatabaseCreatePersistencyOptions:60,YieldCreateIfNotExistsOptions:61,YieldAdminCommandsOptions:62,YieldExportCommandOptions:63,YieldExportCommandWithModifiersAndOptions:64,YieldExportCommandNoModifiersAndOptions:65,YieldAlterDatabaseCommandOptions:66,YieldDeleteMultiplePoliciesOptions:67,YieldIngestionDuplicationOptions:68,YieldPurgeOptions:69,YieldPurgeCleanupOptions:70,YieldPurgeWhatIfOptions:71,YieldPurgeWithPropertiesOptions:72,YieldPurgeTableOptions:73,YieldShowPrincipalCommandOptions:74,YieldAlterFunctionEntitiesOptions:75,YieldAlterMergePolicyRetentionOptions:76,YieldAlterMergePolicyRetentionSoftDeleteDefinedOptions:77,YieldAlterTimeSpanPolicyOptions:78,YieldCreateOrAlterOptions:79,YieldShowFabricOptions:80,YieldRowStoreCreatePersistencyOptions:81,YieldSetDatabaseIngestorsNoneOptions:82,YieldSetTableIngestorsNoneOptions:83,YieldSuspendNodeControlCommandOptions:84},ctors:{init:function(){this.None=Kusto.Data.IntelliSense.RuleKind.None;this.Start=Kusto.Data.IntelliSense.RuleKind.Last}}}});Bridge.define("Kusto.Data.IntelliSense.AnalyzedCommand",{fields:{Command:null,Context:null}});Bridge.define("Kusto.Data.IntelliSense.ApiKind",{$kind:"enum",statics:{fields:{Query:0,AdminSyncCommand:1,AdminAsyncCommand:2}}});Bridge.define("Kusto.Data.IntelliSense.ApplyPolicy",{statics:{fields:{NullApplyPolicy:null,AppendSpacePolicy:null,AppendPipePolicy:null,AppendStringLiteralArrayPolicy:null,StringComparisonPolicy:null,AppendCommaPolicy:null,AppendDoubleCommaPolicy:null,AppendSpaceStepBackPolicy:null,AppendSpaceAfterBracketPolicy:null,MoveAfterTheBracketPolicy:null,AppendAssignmentPolicy:null,AppendJoinClauseWithOpenningBracketPolicy:null,AppendJoinClauseWithoutOpenningBracketPolicy:null,AppendFindInClausePolicy:null,AppendSearchInClausePolicy:null,AppendFindInClauseWithoutOpenningBracketPolicy:null},ctors:{init:function(){var $t;this.NullApplyPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text="",$t);this.AppendSpacePolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text=" ",$t);this.AppendPipePolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text=" | ",$t);this.AppendStringLiteralArrayPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text=' ("", "")',$t.OffsetPosition=2,$t.OffsetToken="(",$t);this.StringComparisonPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text=' "" ',$t.OffsetPosition=-2,$t);this.AppendCommaPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text=", ",$t.OffsetPosition=0,$t);this.AppendDoubleCommaPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text=", , ",$t.OffsetPosition=-2,$t);this.AppendSpaceStepBackPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text=" ",$t.OffsetPosition=-2,$t);this.AppendSpaceAfterBracketPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text=" ",$t.OffsetToken="(",$t.OffsetPosition=1,$t);this.MoveAfterTheBracketPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text="",$t.OffsetToken=")",$t.OffsetPosition=1,$t);this.AppendAssignmentPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.Text=" = ",$t);this.AppendJoinClauseWithOpenningBracketPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.OffsetPosition=-13,$t.Text=" (\r\n    \r\n) on Key1 ",$t);this.AppendJoinClauseWithoutOpenningBracketPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.OffsetPosition=-13,$t.Text="\r\n    \r\n) on Key1 ",$t);this.AppendFindInClausePolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.OffsetPosition=-8,$t.Text=" () where ",$t);this.AppendSearchInClausePolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.OffsetPosition=-2,$t.Text=" () ",$t);this.AppendFindInClauseWithoutOpenningBracketPolicy=($t=new Kusto.Data.IntelliSense.ApplyPolicy,$t.OffsetPosition=-8,$t.Text=") where ",$t)}}},props:{Text:null,OffsetPosition:0,OffsetToken:null},ctors:{ctor:function(){this.$initialize()}}});Bridge.define("Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase",{statics:{fields:{CommonRegexOptions:0,DefaultRegexOptions:0,s_isCommandRegex:null,s_firstWordAfterPipeRegex:null},ctors:{init:function(){this.CommonRegexOptions=16;this.DefaultRegexOptions=0;this.s_isCommandRegex=new System.Text.RegularExpressions.Regex.ctor("^\\s*\\.",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions);this.s_firstWordAfterPipeRegex=new System.Text.RegularExpressions.Regex.ctor("^\\s*(?<FirstWord>[\\w\\-]+)\\s+",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions)}},methods:{FindRules:function(rules,command,commandContext,lastPart,keywordFromCommand){var $t,r,hasKeywordMatch;$t=Bridge.getEnumerator(rules);try{while($t.moveNext())if((r=$t.Current,r.RequiredKeywords==null||!(r.RequiredKeywords.Count>0)||(hasKeywordMatch=!1,hasKeywordMatch=r.RequiresFullCommand?System.Linq.Enumerable.from(r.RequiredKeywords,System.String).any(function(keyword){return System.String.contains(command,keyword)}):!System.String.isNullOrEmpty(keywordFromCommand)&&r.RequiredKeywords.contains(keywordFromCommand),hasKeywordMatch))&&r.IsMatch(commandContext,r.RequiresFullCommand?command:lastPart))return r}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return null},FindLastStatement:function(statements){return System.String.isNullOrEmpty(statements)?"":System.Linq.Enumerable.from(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.ParseAsStatements(statements,59,!1),System.String).lastOrDefault(null,null)},ParseAsStatements:function(input,delimeter,trimDelimeter){var result=new(System.Collections.Generic.List$1(System.String).ctor),currentStatementStart,chars,i,ch,eofString,len;if(System.String.isNullOrEmpty(input))return result;for(currentStatementStart=0,chars=System.String.toCharArray(input,0,input.length),i=0;i<chars.length;i=i+1|0)ch=chars[System.Array.index(i,chars)],!(ch===34|ch===39)||(i=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.SkipToBalancedChar(chars,i+1|0,ch,System.Array.init([34,39],System.Char))),eofString=i===(chars.length-1|0),(ch===delimeter||eofString)&&(len=(i-currentStatementStart|0)+1|0,trimDelimeter&&ch===delimeter&&(len=len-1|0),len>0&&result.add(input.substr(currentStatementStart,len)),currentStatementStart=i+1|0);return result},SkipToBalancedChar:function(chars,start,balancedChar,recursionChars){for(var ch,i=start;i<chars.length;i=i+1|0){if(ch=chars[System.Array.index(i,chars)],ch===balancedChar)return i;System.Array.contains(recursionChars,ch,System.Char)&&(i=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.SkipToBalancedChar(chars,i+1|0,ch,recursionChars))}return chars.length-1|0},GetApproximateCommandLastPart:function(command,lastPart,firstWordAfterPipe){var parts=System.String.split(command,[124].map(function(i){return String.fromCharCode(i)})),last=System.Linq.Enumerable.from(parts,System.String).lastOrDefault(null,null);if(lastPart.v=last,parts.length>1&&(lastPart.v="|"+(last||"")),System.String.isNullOrEmpty(last)){firstWordAfterPipe.v="";return}firstWordAfterPipe.v=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.GetFirstWordAfterPipe(last)},GetFirstWordAfterPipe:function(input){var match=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.s_firstWordAfterPipeRegex.match(input);return match.getGroups().getByName("FirstWord").toString()}}},props:{Locker:null,GeneralRules:null,CommandRules:null,QueryParametersRules:null,DefaultRule:null,CommandToolTips:null,ContextConnection:null},ctors:{ctor:function(){this.$initialize();this.Locker={}}},methods:{TryMatchAnyRule:function(command,rule){var $t,$t1,analyzedCommand=this.AnalyzeCommand$1(command,null),commandContext=analyzedCommand.Context,firstWordAfterPipe={},lastPart={},isCommand,r,r1;if(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.GetApproximateCommandLastPart(analyzedCommand.Command,lastPart,firstWordAfterPipe),isCommand=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.s_isCommandRegex.isMatch(command),rule.v=null,isCommand){Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: start matching rules for commands rules");$t=Bridge.getEnumerator(this.CommandRules);try{while($t.moveNext())if(r=$t.Current,r.IsMatch(commandContext,r.RequiresFullCommand?command:lastPart.v)){rule.v=r;break}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}}if(rule.v==null&&(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: start matching rules for general rules"),rule.v=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.FindRules(this.GeneralRules,command,commandContext,lastPart.v,firstWordAfterPipe.v)),rule.v==null){Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: start matching rules for query parameters rules");$t1=Bridge.getEnumerator(this.QueryParametersRules);try{while($t1.moveNext())if(r1=$t1.Current,r1.IsMatch(commandContext,r1.RequiresFullCommand?command:lastPart.v)){rule.v=r1;break}}finally{Bridge.is($t1,System.IDisposable)&&$t1.System$IDisposable$Dispose()}}return rule.v!=null&&rule.v.IsContextual?(Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: rule {0} was found",[Bridge.box(rule.v.Kind,System.Int32)]),this.UpdateProviderAvailableEntities(command,commandContext),Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: Entities were updated",[Bridge.box(rule.v.Kind,System.Int32)])):Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.PrivateTracer.Tracer.TraceVerbose("TryMatchAnyRule: no rule was found"),rule.v!=null},TryMatchSpecificRule:function(command,commandContext,ruleKind,rule){rule.v=null;var isCommand=Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.s_isCommandRegex.isMatch(command);return isCommand&&(rule.v=System.Linq.Enumerable.from(this.CommandRules,Kusto.Data.IntelliSense.IntelliSenseRule).firstOrDefault(function(r){return r.Kind===ruleKind&&r.IsMatch(commandContext,command)},null)),rule.v==null&&(rule.v=System.Linq.Enumerable.from(this.GeneralRules,Kusto.Data.IntelliSense.IntelliSenseRule).firstOrDefault(function(r){return r.Kind===ruleKind&&r.IsMatch(commandContext,command)},null)),rule.v!=null&&rule.v.IsContextual&&this.UpdateProviderAvailableEntities(command,commandContext),rule.v!=null},SetQueryParametersRule:function(queryParameters){},Initialize:function(){this.CommandRules=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseRule).ctor);this.GeneralRules=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseRule).ctor);this.CommandToolTips=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseCommandTip).ctor);this.QueryParametersRules=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.IntelliSenseRule).ctor)}}});Bridge.define("Kusto.Data.IntelliSense.CMRuleKind",{$kind:"enum",statics:{fields:{None:0,Start:0,YieldServiceCancelMaintenance:0,YieldServiceMoveToMaintenance:1,YieldShowRegionsByHosters:2,YieldAdminCommandsOptions:3,YieldPipeOptions:4,YieldOperatorsAfterPipe:5,YieldShowCommandOptions:6,YieldShowFabricCommandOptions:7,YieldShowAccountCommandOptions:8,YieldShowAccountsKeywordOptions:9,YieldMoveAccountCommandOptions:10,YieldMoveAccountSubscriptionCommandOptions:11,YieldMoveCommandOptions:12,YieldAlterCommandOptions:13,YieldAddCommandOptions:14,YieldDropCommandOptions:15,YieldRemoveCommandOptions:16,YieldCreateCommandOptions:17,YieldCreateExternalCommandOptions:18,YieldDeleteCommandOptions:19,YieldDetachCommandOptions:20,YieldCheckCommandOptions:21,YieldSetCommandOptions:22,YieldRegisterCommandOptions:23,YieldPutCommandOptions:24,YieldListCommandOptions:25,YieldListKustoPoolsServicesCommandPropertiesSuffix:26,YieldSyncCommandOptions:27,YieldServiceKeywordOptions:28,YieldServiceOrClusterKeywordOptions:29,YieldStorageAccountsKeywordOptions:30,YieldIngestLogsIntoKeywordsOptions:31,YieldInServiceKeywordOptions:32,YieldShowClusterKeywordOptions:33,YieldOperationsKeywordOptions:34,YieldOrchestrationKeywordOptions:35,YieldOrchestrationTaskHubKeywordOptions:36,YieldPcCodeKeywordOptions:37,YieldsAlterServiceConfigurationKeywordOptions:38,YieldFromAccountKeywordOptions:39,YieldShowAuditLogCommandOptions:40,YieldShowAuditLogFromCommandOptions:41,YieldShowCmServiceCommandOptions:42,YieldShowClusterClientOptions:43,YieldShowClusterClientSubscriptionCommandOptions:44,YieldShowClusterClusterNamePrincipalCommandOptions:45,YieldShowServicesCompletionKeywordsOptions:46,YieldConfigurationPropertySetKeywordOptions:47,YieldConfigurationPropertyDropKeywordOptions:48,YieldToStringKeywordOptions:49,YieldToKeywordOptions:50,YieldConfigurationPropertyWithConsentKeywordOptions:51,YieldAccountAlterOperationsKeywordOptions:52,YieldAccountAddOperationsKeywordOptions:53,YieldAccountRemoveOperationsKeywordOptions:54,YieldAccountSetOperationsKeywordOptions:55,YieldAccountRenameOperationsKeywordOptions:56,YieldServiceAlterOperationsKeywordOptions:57,YieldMetadataKeywordOptions:58,YieldSummaryKeywordOptions:59,YieldSummaryOrMetadataKeywordOptions:60,YieldDatabaseOrAccountMetadataKeywordOptions:61,YieldAccountNames:62,YieldDmServiceAddKeywordOptions:63,YieldDmServiceDropKeywordOptions:64,YieldDmServiceAlterKeywordOptions:65,YieldDmServiceAlterSettingsOptions:66,YieldDmServiceShowKeywordOptions:67,YieldServicesNames:68,YieldServicesNamesCombinedWithOptions:69,YieldTargetServiceOptions:70,YieldWithPropertiesSuffix:71,YieldWithEventHubPropertiesSuffix:72,YieldInstallCommandOptions:73,YieldReinstallCommandOptions:74,YieldUninstallServiceCommandOptions:75,YieldUninstallCommandOptions:76,YieldUpdateCommandOptions:77,YieldMigrateServiceCommandOptions:78,YieldMigrateClusterCommandOptions:79,YieldFromServiceKeywordOptions:80,YieldDatabaseMoveFromServiceCommandOptions:81,YieldSetClusterPrincipalsCommandOptions:82,YieldAddClusterPrincipalsCommandOptions:83,YieldDropClusterPrincipalsCommandOptions:84,YieldAddClusterJitPrincipalsCommandOptions:85,YieldDropClusterJitPrincipalsCommandOptions:86,YieldSetClusterPrincipalsNoneOptions:87,YieldDropAccountPrincipalsCommandOptions:88,YieldDatabaseCreateCommandOptions:89,YieldServiceCreateCommandOptions:90,YieldShowPrincipalRolesCommandOptions:91,YieldAddKeywordOptions:92,YieldAlterServiceConfigurationPropertiesOptions:93,YieldAlterServiceConfigurationCommandOptions:94,YieldMoveServiceConfigurationCommandOptions:95,YieldAddServiceServiceNameOptions:96,YieldLoadBalancerKeywordOptions:97,YieldOperationKeywordOptions:98,YieldShowSubscriptionCommandOptions:99,YieldShowServiceSecurityRulesCommandOptions:100,YieldKeysCommandOptions:101,YieldKeyTypesCommandOptions:102,YieldAlterServiceStorageAccountsCommandOptions:103,YieldCmNotifyCommandOptions:104,YieldExecuteCommandOptions:105,YieldExecuteJobCommandOptions:106,YieldGenerateCommandOptions:107,YieldPublishCommandOptions:108,YieldSkuAvailabilityPrefix:109,YieldSkuAvailabilityCommandValues:110,YieldSkuAvailabilityPropertiesSuffix:111,YieldServiceRegenerateSuffix:112,YieldVersionKeywordOptions:113,YieldExportCommandOptions:114,YieldExportPackageForOptions:115,YieldExportPackageForServiceTypeOptions:116,YieldSharedIdentity:117,YieldSetRegionVisibility:118,YieldRegisterFeature:119,YieldBillingServiceCreateResources:120,YieldPublishServiceCommandOptions:121,YieldUnPublishCommandOptions:122,YieldUnPublishServiceCommandOptions:123,YieldRotateCommandOptions:124,YieldRotateServiceCommandOptions:125,YieldCreateFollowerDatabaseInServiceCommandOptions:126,YieldColumnNamesAfterPipeCommandOptions:127,YieldPutClientSubscriptionsNotification:128,YieldDatabaseKeywordOptions:129,YieldSyncKustoPoolRbacCommandOptions:130},ctors:{init:function(){this.None=Kusto.Data.IntelliSense.RuleKind.None;this.Start=Kusto.Data.IntelliSense.RuleKind.Last}}}});Bridge.define("Kusto.Data.IntelliSense.CompletionOption",{props:{Kind:0,Value:null},ctors:{ctor:function(kind,value){this.$initialize();this.Kind=kind;this.Value=value}}});Bridge.define("Kusto.Data.IntelliSense.CompletionOptionCollection",{fields:{m_materializedOptions:null},props:{Kind:0,Values:null,Priority:0},ctors:{ctor:function(kind,values,priority){priority===void 0&&(priority=0);this.$initialize();this.Kind=kind;this.Values=values;this.Priority=priority}},methods:{GetCompletionOptions:function(){return this.m_materializedOptions==null&&(this.m_materializedOptions=System.Linq.Enumerable.from(this.Values,System.String).select(Bridge.fn.bind(this,$asm.$.Kusto.Data.IntelliSense.CompletionOptionCollection.f1)).ToArray(Kusto.Data.IntelliSense.CompletionOption)),this.m_materializedOptions}}});Bridge.ns("Kusto.Data.IntelliSense.CompletionOptionCollection",$asm.$);Bridge.apply($asm.$.Kusto.Data.IntelliSense.CompletionOptionCollection,{f1:function(o){return new Kusto.Data.IntelliSense.CompletionOption(this.Kind,o)}});Bridge.define("Kusto.Data.IntelliSense.ContextOperation",{$kind:"enum",statics:{fields:{None:0,Union:1,Intersect:2}}});Bridge.define("Kusto.Data.IntelliSense.IntelliSenseRule",{props:{Kind:0,RequiredKeywords:null,AfterApplyPolicies:null,BeforeApplyPolicies:null,DefaultAfterApplyPolicy:null,DefaultBeforeApplyPolicy:null},methods:{GetAfterApplyInfo:function(selectedOption){var policy={v:null};return this.AfterApplyPolicies!=null&&this.AfterApplyPolicies.tryGetValue(selectedOption,policy),policy.v||this.DefaultAfterApplyPolicy||Kusto.Data.IntelliSense.ApplyPolicy.NullApplyPolicy},GetBeforeApplyInfo:function(selectedOption){var policy={v:null};return this.BeforeApplyPolicies!=null&&this.BeforeApplyPolicies.tryGetValue(selectedOption,policy),policy.v||this.DefaultBeforeApplyPolicy||Kusto.Data.IntelliSense.ApplyPolicy.NullApplyPolicy}}});Bridge.define("Kusto.Data.IntelliSense.CslCommand",{statics:{fields:{c_tabulation:null,s_newLineRegex:null,s_removeWhiteSpacesAfterPipeRegex:null,s_joinStartRegex:null,s_joinEndRegex:null,s_makeSeriesOperatorRegex:null,s_operatorRegex:null,s_operatorsNotRequiringFullEntitiesResolve:null,s_nameOrListRegex:null,s_hasAssignmentOperationRegex:null,s_startsWithAlpha:null},ctors:{init:function(){this.c_tabulation="    ";this.s_newLineRegex=new System.Text.RegularExpressions.Regex.ctor("[\\n\\r]",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions);this.s_removeWhiteSpacesAfterPipeRegex=new System.Text.RegularExpressions.Regex.ctor("^\\|\\s+",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions);this.s_joinStartRegex=new System.Text.RegularExpressions.Regex.ctor("(?<JoinOpPart>^\\s*\\|\\s*join\\s+(kind\\s*=\\s*\\w+\\s*)?)(?<Bracket>\\()?(?<PostJoinPart>.+$)",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions);this.s_joinEndRegex=new System.Text.RegularExpressions.Regex.ctor("(?!^.*\\bmake-series\\b.*$)((?<InnerJoinPart>^.*?)(?<Bracket>\\)?)\\s*\\b(?<JoinOnPart>on\\s+.+))",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.CommonRegexOptions);this.s_makeSeriesOperatorRegex=new System.Text.RegularExpressions.Regex.ctor("\\bmake-series\\b",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions);this.s_operatorRegex=new System.Text.RegularExpressions.Regex.ctor("\\|\\s*(?<Operator>[\\w-]+)",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions);this.s_operatorsNotRequiringFullEntitiesResolve=$asm.$.Kusto.Data.IntelliSense.CslCommand.f1(new(System.Collections.Generic.HashSet$1(System.String).ctor));this.s_nameOrListRegex="(?:\\w+)|(?:\\((\\w+)(,\\s*\\w+)*\\))";this.s_hasAssignmentOperationRegex=new System.Text.RegularExpressions.Regex.ctor("(^\\s*\\|\\s*(extend|parse|summarize|project|mvexpand|mv-expand|make-series|project-rename)\\s+"+(Kusto.Data.IntelliSense.CslCommand.s_nameOrListRegex||"")+")|(^\\s*range)",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions);this.s_startsWithAlpha=new System.Text.RegularExpressions.Regex.ctor("^\\s*[a-z]",1)}},methods:{MakeTrivialCommandFromText:function(text){var $t,$t1;return $t=new Kusto.Data.IntelliSense.CslCommand,$t.m_commandParts=($t1=Kusto.Data.IntelliSense.CslCommandToken,System.Linq.Enumerable.from(System.Array.init([new Kusto.Data.IntelliSense.CslCommandToken(text,0,Kusto.Data.IntelliSense.CslCommandToken.Kind.CslCommandToken)],Kusto.Data.IntelliSense.CslCommandToken),$t1).toList($t1)),$t.Text=text,$t.Length=text.length,$t.AbsolutePositionBias=0,$t.RelativeStart=0,$t.ParseMode=Kusto.Data.IntelliSense.ParseMode.CommandTokensOnly,$t.IsRunnable=!System.String.isNullOrWhiteSpace(text),$t},UnionCommands:function(commands){var $t,firstCommand,result;return System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).count()<2?System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).firstOrDefault(null,null):(firstCommand=System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).first(),result=($t=new Kusto.Data.IntelliSense.CslCommand,$t.m_tokens=System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).selectMany($asm.$.Kusto.Data.IntelliSense.CslCommand.f2).toList(Kusto.Data.IntelliSense.CslCommandToken),$t.m_commandParts=System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).selectMany($asm.$.Kusto.Data.IntelliSense.CslCommand.f3).toList(Kusto.Data.IntelliSense.CslCommandToken),$t.m_commentsParts=System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).selectMany($asm.$.Kusto.Data.IntelliSense.CslCommand.f4).toList(Kusto.Data.IntelliSense.CslCommandToken),$t.m_clientDirectivesParts=System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).selectMany($asm.$.Kusto.Data.IntelliSense.CslCommand.f5).toList(Kusto.Data.IntelliSense.CslCommandToken),$t.m_bracketParts=System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).selectMany($asm.$.Kusto.Data.IntelliSense.CslCommand.f6).toList(Kusto.Data.IntelliSense.CslCommandToken),$t.Text=Bridge.toArray(System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).selectMany($asm.$.Kusto.Data.IntelliSense.CslCommand.f7)).join(""),$t.IsRunnable=System.Linq.Enumerable.from(commands,Kusto.Data.IntelliSense.CslCommand).any($asm.$.Kusto.Data.IntelliSense.CslCommand.f8),$t.RelativeStart=firstCommand.RelativeStart,$t.AbsolutePositionBias=firstCommand.AbsolutePositionBias,$t.ParseMode=firstCommand.ParseMode,$t),result.Length=result.Text.length,result)},NormalizeCommandPart:function(partValue){return partValue=partValue.trim(),Kusto.Data.IntelliSense.CslCommand.s_removeWhiteSpacesAfterPipeRegex.replace(partValue,"| ")},AppendTabulatedText:function(sb,level,text){Kusto.Data.IntelliSense.CslCommand.AppendTabulations(sb,level);sb.append(text)},AppendTabulations:function(sb,level){if(!(level<=0))for(var j=0;j<level;j=j+1|0)sb.append(Kusto.Data.IntelliSense.CslCommand.c_tabulation)},ResolveOperatorContext:function(part){return part==null?"":System.String.indexOf(part.Text," on ")>0&&!Kusto.Data.IntelliSense.CslCommand.s_makeSeriesOperatorRegex.isMatch(part.Text)?"":Kusto.Data.IntelliSense.CslCommand.s_operatorRegex.match(part.Text).getGroups().getByName("Operator").toString()},GetKnownEntities:function(rulesProvider,mapOfKnownEntities,mapOfOriginallyKnownEntities,part,commandBuilder,context,operatorContext,knownEntities,originallyKnownEntities){if((knownEntities.v=new(System.Collections.Generic.List$1(System.String).ctor),originallyKnownEntities.v=mapOfOriginallyKnownEntities.containsKey(context)?mapOfOriginallyKnownEntities.getItem(context):new(System.Collections.Generic.List$1(System.String).ctor),part==null)||Kusto.Data.IntelliSense.CslCommand.s_operatorsNotRequiringFullEntitiesResolve.contains(operatorContext))return mapOfKnownEntities.containsKey(context)&&(knownEntities.v=mapOfKnownEntities.getItem(context)),!1;var command=commandBuilder.toString();return rulesProvider.GetKnownEntities(command,context,mapOfOriginallyKnownEntities,knownEntities,originallyKnownEntities)},IsMatchingRegex:function(commandPart,opRegex){return System.String.isNullOrWhiteSpace(commandPart)?!1:opRegex.isMatch(commandPart)},StartsWithAlpha:function(text){return System.String.isNullOrWhiteSpace(text)?!1:Kusto.Data.IntelliSense.CslCommand.s_startsWithAlpha.isMatch(text)}}},fields:{m_tokens:null,m_commandParts:null,m_commentsParts:null,m_clientDirectivesParts:null,m_bracketParts:null,m_commandPartsParseStates:null},props:{CslExpressionStartPosition:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts)?0:this.m_commandParts.getItem(0).RelativeStart}},CslExpressionLength:{get:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts)?0:System.Linq.Enumerable.from(this.m_commandParts,Kusto.Data.IntelliSense.CslCommandToken).last().RelativeEnd-this.m_commandParts.getItem(0).RelativeStart|0}},Tokens:{get:function(){return this.m_tokens}},CommandParts:{get:function(){return this.m_commandParts}},CommentParts:{get:function(){return this.m_commentsParts}},BracketParts:{get:function(){return this.m_bracketParts}},AllParts:{get:function(){var linqParts=0,result=null;return(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts)&&(linqParts=linqParts+1|0,result=this.m_commandParts),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommandToken,this.m_commentsParts)&&(linqParts=linqParts+1|0,result=result!=null?System.Linq.Enumerable.from(result,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_commentsParts):Bridge.cast(this.m_commentsParts,System.Collections.Generic.IEnumerable$1(Kusto.Data.IntelliSense.CslCommandToken))),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommandToken,this.m_clientDirectivesParts)&&(linqParts=linqParts+1|0,result=result!=null?System.Linq.Enumerable.from(result,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_clientDirectivesParts):Bridge.cast(this.m_clientDirectivesParts,System.Collections.Generic.IEnumerable$1(Kusto.Data.IntelliSense.CslCommandToken))),linqParts>1)?System.Linq.Enumerable.from(result,Kusto.Data.IntelliSense.CslCommandToken).orderBy($asm.$.Kusto.Data.IntelliSense.CslCommand.f9):result}},Text:null,RelativeStart:0,Length:0,RelativeEnd:{get:function(){return(this.RelativeStart+this.Length|0)-1|0}},AbsoluteStart:{get:function(){return this.AbsolutePositionBias+this.RelativeStart|0}},AbsoluteEnd:{get:function(){return this.AbsolutePositionBias+this.RelativeEnd|0}},AbsolutePositionBias:0,IsRunnable:!1,ParseMode:0,ContextCache:null},ctors:{ctor:function(){this.$initialize()}},methods:{FormatAsString:function(separator,traits){var $t,parts,part,partValue,wasHandled;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_commandParts))return"";parts=this.m_commandParts;System.Enum.hasFlag(traits,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.IncludeComments,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommandToken,this.m_commentsParts)&&(parts=System.Linq.Enumerable.from(parts,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_commentsParts).union(this.m_clientDirectivesParts).orderBy($asm.$.Kusto.Data.IntelliSense.CslCommand.f10).toList(Kusto.Data.IntelliSense.CslCommandToken));var sb=new System.Text.StringBuilder,level={v:0},isFirstTime=!0;$t=Bridge.getEnumerator(parts);try{while($t.moveNext())part=$t.Current,partValue=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(part.Value," "),isFirstTime||sb.append(separator),isFirstTime=!1,Kusto.Data.IntelliSense.CslCommand.AppendTabulations(sb,level.v),wasHandled=!1,!wasHandled&&System.Enum.hasFlag(traits,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.IncludeComments,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&(wasHandled=this.HandleCommentsAndClientDirectives(separator,sb,level,part,partValue)),!wasHandled&&System.Enum.hasFlag(traits,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.TabulateOnFunctionBoundaries,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&(wasHandled=this.HandleFunctions(separator,sb,level,part)),!wasHandled&&System.Enum.hasFlag(traits,Bridge.box(Kusto.Data.IntelliSense.CslCommand.FormatTraits.TabulateOnJoins,Kusto.Data.IntelliSense.CslCommand.FormatTraits,System.Enum.toStringFn(Kusto.Data.IntelliSense.CslCommand.FormatTraits)))&&(wasHandled=this.HandleJoins(separator,sb,level,part,partValue)),wasHandled||sb.append(Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(partValue))}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return sb.toString()},HandleCommentsAndClientDirectives:function(separator,sb,level,part,partValue){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None$1(Kusto.Data.IntelliSense.CslCommandToken,System.Linq.Enumerable.from(this.m_commentsParts,Kusto.Data.IntelliSense.CslCommandToken).union(this.m_clientDirectivesParts),function(cp){return cp.AbsoluteStart===part.AbsoluteStart&&cp.AbsoluteEnd===part.AbsoluteEnd})?!1:(sb.append(partValue.trim()),!0)},HandleFunctions:function(separator,sb,level,part){var wasHandled=!1,processedStart=0,startRelativeIndex=System.String.indexOf(part.Value,String.fromCharCode(123)),startAbsoluteIndex=part.AbsoluteStart+startRelativeIndex|0,funcPrefix,endRelativeIndex,endAbsoluteIndex,boddy,funcSuffix,boddy1;return startRelativeIndex>=0&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_tokens,function(t){return startAbsoluteIndex>=t.AbsoluteStart&&startAbsoluteIndex<=t.AbsoluteEnd})&&(funcPrefix=part.Value.substr(0,startRelativeIndex).trim(),funcPrefix=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(funcPrefix," "),sb.append(funcPrefix),sb.append(separator),sb.append("{"),sb.append(separator),level.v=level.v+1|0,wasHandled=!0,processedStart=startRelativeIndex+1|0),endRelativeIndex=System.String.indexOf(part.Value,String.fromCharCode(125)),endAbsoluteIndex=part.AbsoluteStart+endRelativeIndex|0,endRelativeIndex>=0&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None$1(Kusto.Data.IntelliSense.CslCommandToken,this.m_tokens,function(t){return endAbsoluteIndex>=t.AbsoluteStart&&endAbsoluteIndex<=t.AbsoluteEnd})&&startRelativeIndex<endRelativeIndex?(boddy=part.Value.substr(processedStart,endRelativeIndex-processedStart|0).trim(),funcSuffix=part.Value.substr(endRelativeIndex+1|0).trim(),funcSuffix=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(funcSuffix," "),wasHandled&&Kusto.Data.IntelliSense.CslCommand.AppendTabulations(sb,level.v),sb.append(boddy),sb.append(separator),sb.append("}"),level.v=level.v-1|0,level.v<0&&(level.v=0),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(sb,level.v,funcSuffix),wasHandled=!0):wasHandled&&(boddy1=part.Value.substr(processedStart).trim(),boddy1=Kusto.Data.IntelliSense.CslCommand.s_newLineRegex.replace(boddy1," "),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(sb,level.v,boddy1)),wasHandled},HandleJoins:function(separator,sb,level,part,partValue){var assumeJoinStartedWithBracket=!1,wasHandled=!1,remainingText=partValue,joinStartMatch=Kusto.Data.IntelliSense.CslCommand.s_joinStartRegex.match(remainingText),relativePosition=0,joinOpPart,joinEndMatch,tabLength,bracketClosed;if(joinStartMatch.getSuccess()&&(joinOpPart=joinStartMatch.getGroups().getByName("JoinOpPart").toString(),sb.append(Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(joinOpPart)),sb.append(separator),assumeJoinStartedWithBracket=!System.String.isNullOrEmpty(joinStartMatch.getGroups().getByName("Bracket").toString()),level.v=level.v+1|0,remainingText=joinStartMatch.getGroups().getByName("PostJoinPart").toString(),relativePosition=joinStartMatch.getGroups().getByName("PostJoinPart").getIndex(),wasHandled=!0),joinEndMatch=Kusto.Data.IntelliSense.CslCommand.s_joinEndRegex.match(remainingText),joinEndMatch.getSuccess()&&System.Linq.Enumerable.from(this.m_tokens,Kusto.Data.IntelliSense.CslCommandToken).any(function(t){return t.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken&&Bridge.referenceEquals(t.Value,"on")&&t.AbsoluteStart===((joinEndMatch.getGroups().getByName("JoinOnPart").getIndex()+part.AbsoluteStart|0)+relativePosition|0)})){var joinInnerPart=Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(joinEndMatch.getGroups().getByName("InnerJoinPart").toString()),onJoinPart=Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(joinEndMatch.getGroups().getByName("JoinOnPart").toString()),hasBracket=!System.String.isNullOrEmpty(joinEndMatch.getGroups().getByName("Bracket").toString()),shouldCloseBracket=hasBracket||assumeJoinStartedWithBracket,openBrackets=Kusto.Cloud.Platform.Utils.ExtendedString.CountNonOverlappingSubstrings(joinInnerPart,"("),closeBrackets=Kusto.Cloud.Platform.Utils.ExtendedString.CountNonOverlappingSubstrings(joinInnerPart,")");hasBracket&&openBrackets>closeBrackets&&(shouldCloseBracket=!1,joinInnerPart=(joinInnerPart||"")+")");joinStartMatch.getSuccess()&&(assumeJoinStartedWithBracket&&(Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(sb,level.v-1|0,"("),sb.append(separator)),Kusto.Data.IntelliSense.CslCommand.AppendTabulations(sb,level.v));level.v=level.v-1|0;level.v<0&&(level.v=0);System.String.isNullOrEmpty(joinInnerPart)?(tabLength=Kusto.Data.IntelliSense.CslCommand.c_tabulation.length,sb.replace(Kusto.Data.IntelliSense.CslCommand.c_tabulation,"",sb.getLength()-tabLength|0,tabLength),bracketClosed=!1,shouldCloseBracket&&(sb.append(")"),sb.append(separator),bracketClosed=!0),bracketClosed?Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(sb,level.v,Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(onJoinPart)):sb.append(onJoinPart)):(sb.append(joinInnerPart),sb.append(separator),shouldCloseBracket&&(Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(sb,level.v,")"),sb.append(separator)),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(sb,level.v,Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(onJoinPart)));wasHandled=!0}else joinStartMatch.getSuccess()&&(assumeJoinStartedWithBracket&&(Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(sb,level.v-1|0,"("),sb.append(separator)),Kusto.Data.IntelliSense.CslCommand.AppendTabulatedText(sb,level.v,Kusto.Data.IntelliSense.CslCommand.NormalizeCommandPart(remainingText)));return wasHandled},AcquireTokens:function(other){this.m_tokens=System.Linq.Enumerable.from(other.m_tokens,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,$asm.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken);this.m_commandParts=System.Linq.Enumerable.from(other.m_commandParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,$asm.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken);this.m_commentsParts=System.Linq.Enumerable.from(other.m_commentsParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,$asm.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken);this.m_clientDirectivesParts=System.Linq.Enumerable.from(other.m_clientDirectivesParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,$asm.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken);this.m_bracketParts=System.Linq.Enumerable.from(other.m_bracketParts,Kusto.Data.IntelliSense.CslCommandToken).select(Bridge.fn.bind(this,$asm.$.Kusto.Data.IntelliSense.CslCommand.f11)).toList(Kusto.Data.IntelliSense.CslCommandToken)},ParseTokens:function(rulesProvider,parseMode,previousCandidate){var tokens=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor),allowQueryParameters,indexer,recognizedTokens,commandParts,commentsParts,clientDirectivesPositions;if(System.String.isNullOrEmpty(this.Text)){this.m_tokens=tokens;return}rulesProvider!=null&&(rulesProvider.ResetState(),previousCandidate!=null&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(System.Collections.Generic.KeyValuePair$2(System.Int32,Kusto.Data.IntelliSense.KustoCommandContext),previousCandidate.ContextCache)&&(rulesProvider.ContextCache=new(System.Collections.Generic.Dictionary$2(System.Int32,Kusto.Data.IntelliSense.KustoCommandContext).$ctor1)(previousCandidate.ContextCache)));allowQueryParameters=rulesProvider!=null?rulesProvider.AllowQueryParameters:!1;indexer=new Kusto.Data.IntelliSense.CslCommandIndexer(allowQueryParameters);indexer.AntiTokenizers=new(System.Collections.Generic.HashSet$1(System.Char).$ctor1)(System.Array.init([45,95,40],System.Char));indexer.TokenStarters=System.Array.init([46],System.Char);indexer.TokenTerminators=new(System.Collections.Generic.HashSet$1(System.Char).$ctor1)(System.Array.init([40,46],System.Char));indexer.IndexText(this.Text);recognizedTokens=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor);this.m_commandParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor);commandParts=indexer.GetCommandPartsPositions();this.AddCategorizedTokens(this.m_commandParts,null,commandParts,Kusto.Data.IntelliSense.CslCommandToken.Kind.CommandPartToken);this.m_commentsParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor);commentsParts=indexer.GetCommentsPositions();this.AddCategorizedTokens(this.m_commentsParts,null,commentsParts,Kusto.Data.IntelliSense.CslCommandToken.Kind.CommentToken);this.m_clientDirectivesParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor);clientDirectivesPositions=indexer.GetClientDirectivesPositions();this.AddCategorizedTokens(this.m_clientDirectivesParts,null,clientDirectivesPositions,Kusto.Data.IntelliSense.CslCommandToken.Kind.ClientDirectiveToken);this.m_bracketParts=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor);this.AddCategorizedTokens(this.m_bracketParts,null,indexer.GetBracketsPositions(),Kusto.Data.IntelliSense.CslCommandToken.Kind.BracketRangeToken);this.AddCategorizedTokens(tokens,recognizedTokens,commentsParts,Kusto.Data.IntelliSense.CslCommandToken.Kind.CommentToken);this.AddCategorizedTokens(tokens,recognizedTokens,clientDirectivesPositions,Kusto.Data.IntelliSense.CslCommandToken.Kind.ClientDirectiveToken);allowQueryParameters&&this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetQueryParametersPositions(),Kusto.Data.IntelliSense.CslCommandToken.Kind.QueryParametersToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetStringLiteralsPositions(),Kusto.Data.IntelliSense.CslCommandToken.Kind.StringLiteralToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.ControlCommandsTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.ControlCommandToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.CslCommandsTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.CslCommandToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.OperatorCommandTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.SubOperatorsTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.JoinKindTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.ReduceByKindTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.SubOperatorToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.DataTypesTokens),Kusto.Data.IntelliSense.CslCommandToken.Kind.DataTypeToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.FunctionsTokens,40),Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken);this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(Kusto.Data.IntelliSense.CslCommandParser.PluginTokens,40),Kusto.Data.IntelliSense.CslCommandToken.Kind.PluginToken);rulesProvider!=null&&this.AddEntitiesTokens(rulesProvider,tokens,recognizedTokens,indexer,commandParts,previousCandidate);tokens.Sort$2($asm.$.Kusto.Data.IntelliSense.CslCommand.f12);this.ValidateTokensOutput(tokens,this.Text);parseMode===Kusto.Data.IntelliSense.ParseMode.TokenizeAllText&&(this.EnsureAllTextIsAnnotated(indexer,tokens,recognizedTokens),tokens.Sort$2($asm.$.Kusto.Data.IntelliSense.CslCommand.f12));this.m_tokens=tokens;rulesProvider!=null&&(this.ContextCache=rulesProvider.ContextCache)},ValidateTokensOutput:function(tokens,text){for(var t,tokenToRemove,$t,invalidTokens=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandToken).ctor),currentEnd=0,maxLen=text.length,i=0;i<System.Linq.Enumerable.from(tokens,Kusto.Data.IntelliSense.CslCommandToken).count();i=i+1|0)t=tokens.getItem(i),t.RelativeEnd<currentEnd||t.RelativeStart<currentEnd||t.RelativeEnd>maxLen?invalidTokens.add(t):currentEnd=t.RelativeEnd;$t=Bridge.getEnumerator(invalidTokens);try{while($t.moveNext())tokenToRemove=$t.Current,tokens.remove(tokenToRemove)}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}},AddEntitiesTokens:function(rulesProvider,tokens,recognizedTokens,indexer,commandParts,refernceCommand){var i,prevPart,part,command,tableContext,calculatedColumns,availableTableColumns,newCalculatedColumns,result,prevCalculatedColumns,calculatedColumnTokens;this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetAllTokenPositions(rulesProvider.TableNames),Kusto.Data.IntelliSense.CslCommandToken.Kind.TableToken);this.m_commandPartsParseStates=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState).ctor);var commandBuilder=new System.Text.StringBuilder,letVariables=new(System.Collections.Generic.HashSet$1(System.String).$ctor1)(rulesProvider.FunctionNames),canUseReference=refernceCommand!=null,state=null,analyzedCommand=null;for(i=0;i<(System.Array.getCount(commandParts,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)+1|0);i=i+1|0){if(prevPart=i>0?System.Array.getItem(commandParts,i-1|0,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition):null,part={v:i<System.Array.getCount(commandParts,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)?System.Array.getItem(commandParts,i,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition):null},state=state!=null?state.Clone():new Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState,part.v!=null&&commandBuilder.append(part.v.Text),canUseReference=!!(canUseReference&(part.v!=null&&refernceCommand!=null&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(Kusto.Data.IntelliSense.CslCommandToken,refernceCommand.CommandParts)&&Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState,refernceCommand.m_commandPartsParseStates)&&System.Linq.Enumerable.from(refernceCommand.m_commandPartsParseStates,Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState).count()>i&&System.Linq.Enumerable.from(refernceCommand.CommandParts,Kusto.Data.IntelliSense.CslCommandToken).count()>i&&System.String.equals(part.v.Text,System.Linq.Enumerable.from(refernceCommand.CommandParts,Kusto.Data.IntelliSense.CslCommandToken).elementAt(i).Value))),canUseReference){var referencePart=System.Linq.Enumerable.from(refernceCommand.CommandParts,Kusto.Data.IntelliSense.CslCommandToken).elementAt(i),offset={v:part.v.Start-referencePart.RelativeStart|0},capturedTokens=System.Linq.Enumerable.from(refernceCommand.Tokens,Kusto.Data.IntelliSense.CslCommandToken).where(function($me,part){return function(t){return(t.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.CalculatedColumnToken||t.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.TableColumnToken||t.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.TableToken||t.TokenKind===Kusto.Data.IntelliSense.CslCommandToken.Kind.LetVariablesToken)&&t.RelativeStart>=part.v.Start&&t.RelativeEnd<=part.v.End}}(this,part)).select(function($me,offset){return function(t){var clonedToken=Bridge.as(t.clone(),Kusto.Data.IntelliSense.CslCommandToken);return clonedToken.RelativeStart=clonedToken.RelativeStart+offset.v|0,clonedToken}}(this,offset)).ToArray(Kusto.Data.IntelliSense.CslCommandToken);tokens.AddRange(capturedTokens);recognizedTokens.AddRange(indexer.GetTokenPositionsInRange(System.Linq.Enumerable.from(capturedTokens,Kusto.Data.IntelliSense.CslCommandToken).select($asm.$.Kusto.Data.IntelliSense.CslCommand.f13),part.v.Start,part.v.End));this.AddLetStatementTokens(tokens,recognizedTokens,indexer,letVariables,part.v);state=refernceCommand.m_commandPartsParseStates.getItem(i).Clone();this.m_commandPartsParseStates.add(state);continue}if(part.v!=null&&this.AddLetStatementTokens(tokens,recognizedTokens,indexer,letVariables,part.v),analyzedCommand==null?(command=commandBuilder.toString(),analyzedCommand=rulesProvider.AnalyzeCommand$1(command,refernceCommand)):part.v!=null&&(analyzedCommand=rulesProvider.AnalyzeCommand(analyzedCommand,part.v.Text)),tableContext=analyzedCommand.Context,!tableContext.IsEmpty()){var operatorContext=Kusto.Data.IntelliSense.CslCommand.ResolveOperatorContext(part.v),knownEntities={},originallyKnownEntities={},wasFullyResolved=Kusto.Data.IntelliSense.CslCommand.GetKnownEntities(rulesProvider,state.MapOfKnownEntities,state.MapOfOriginallyKnownEntities,part.v,commandBuilder,tableContext,operatorContext,knownEntities,originallyKnownEntities);if(part.v!=null&&(rulesProvider.ResolveKnownEntitiesFromContext(tableContext),calculatedColumns=System.Linq.Enumerable.from(knownEntities.v,System.String).except(originallyKnownEntities.v),availableTableColumns=System.Linq.Enumerable.from(originallyKnownEntities.v,System.String).intersect(knownEntities.v),this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetTokenPositionsInRange(availableTableColumns,part.v.Start,part.v.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.TableColumnToken),this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetTokenPositionsInRange(calculatedColumns,part.v.Start,part.v.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.CalculatedColumnToken),this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetTokenPositionsInRange(rulesProvider.RemoteTableNames,part.v.Start,part.v.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.TableToken)),!wasFullyResolved&&part.v!=null){newCalculatedColumns=new(System.Collections.Generic.List$1(System.String).ctor);result=rulesProvider.ResolveEntitiesFromCommand((part.v.Text||"")+" | ",newCalculatedColumns,knownEntities.v);switch(result){case Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult.ReplaceEntities:knownEntities.v=newCalculatedColumns;break;case Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult.None:break;case Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveResult.AppendEntities:knownEntities.v=System.Linq.Enumerable.from(knownEntities.v,System.String).union(newCalculatedColumns).toList(System.String);break}}state.MapOfKnownEntities.setItem(tableContext,knownEntities.v);prevPart!=null&&Kusto.Data.IntelliSense.CslCommand.IsMatchingRegex(prevPart.Text,Kusto.Data.IntelliSense.CslCommand.s_hasAssignmentOperationRegex)&&state.MapOfPreviousCalculatedEntities.containsKey(tableContext)&&(prevCalculatedColumns=state.MapOfPreviousCalculatedEntities.getItem(tableContext),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(System.String,prevCalculatedColumns)&&(calculatedColumnTokens=indexer.GetTokenPositionsInRange(prevCalculatedColumns,prevPart.Start,prevPart.End),System.Linq.Enumerable.from(calculatedColumnTokens,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).any()&&this.AddCategorizedTokens(tokens,recognizedTokens,calculatedColumnTokens,Kusto.Data.IntelliSense.CslCommandToken.Kind.CalculatedColumnToken)));state.MapOfPreviousCalculatedEntities.setItem(tableContext,System.Linq.Enumerable.from(knownEntities.v,System.String).except(originallyKnownEntities.v).toList(System.String));this.m_commandPartsParseStates.add(state)}}},AddLetStatementTokens:function(tokens,recognizedTokens,indexer,letVariables,part){var letVariable=Kusto.Data.IntelliSense.CslQueryIntelliSenseRulesProvider.ResolveLetVariable(part.Text);System.String.isNullOrEmpty(letVariable)||letVariables.add(letVariable);letVariables.Count>0&&this.AddCategorizedTokens(tokens,recognizedTokens,indexer.GetTokenPositionsInRange(letVariables,part.Start,part.End),Kusto.Data.IntelliSense.CslCommandToken.Kind.LetVariablesToken)},AddCategorizedTokens:function(target,recognizedTokenList,textTokens,tokenKind){recognizedTokenList!=null&&recognizedTokenList.AddRange(textTokens);target.AddRange(System.Linq.Enumerable.from(textTokens,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select(Bridge.fn.bind(this,function(t){var $t;return $t=new Kusto.Data.IntelliSense.CslCommandToken(t.Text,this.RelativeStart,tokenKind),$t.Length=t.Length,$t.RelativeStart=t.Start,$t})))},EnsureAllTextIsAnnotated:function(indexer,tokens,recognizedTokens){var start,tokensCount,i,token,newTokenLen,tokenText,tokenText1;if(tokens!=null){for(this.AddUnrecognizedTokens(indexer,tokens,recognizedTokens),tokens.Sort$2($asm.$.Kusto.Data.IntelliSense.CslCommand.f12),start=0,tokensCount=tokens.Count,i=0;i<tokensCount;i=i+1|0)token=tokens.getItem(i),start<token.RelativeStart&&(newTokenLen=token.RelativeStart-start|0,newTokenLen>0&&(tokenText=this.Text.substr(start,newTokenLen),this.AddPlainOrUnrecognizedTokens(tokens,start,tokenText))),start=token.RelativeEnd;start<this.Length&&(tokenText1=this.Text.substr(start,this.Length-start|0),this.AddPlainOrUnrecognizedTokens(tokens,start,tokenText1))}},AddUnrecognizedTokens:function(indexer,tokens,recognizedTokens){var $t,unrecognizedTokens=indexer.GetUnrecognizedTokenPositions(recognizedTokens),t;$t=Bridge.getEnumerator(unrecognizedTokens,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition);try{while($t.moveNext())t=$t.Current,this.AddPlainOrUnrecognizedTokens(tokens,t.Start,t.Text)}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}},AddPlainOrUnrecognizedTokens:function(tokens,tokenStart,text){for(var prefixText,prefixToken,suffixText,suffixToken,$t,chars=System.String.toCharArray(text,0,text.length),startTextIndex=-1,endTextIndex=chars.length,i=0;i<chars.length;i=i+1|0)System.Char.isWhiteSpace(String.fromCharCode(chars[System.Array.index(i,chars)]))||(endTextIndex=i+1|0,startTextIndex=startTextIndex>=0?startTextIndex:i);startTextIndex>0?(prefixText=text.substr(0,startTextIndex),prefixToken=($t=new Kusto.Data.IntelliSense.CslCommandToken(prefixText,this.RelativeStart,Kusto.Data.IntelliSense.CslCommandToken.Kind.PlainTextToken),$t.Length=startTextIndex,$t.RelativeStart=tokenStart,$t),tokens.add(prefixToken)):startTextIndex=0;var tokenText=text.substr(startTextIndex,endTextIndex-startTextIndex|0),tokenKind=Kusto.Data.IntelliSense.CslCommand.StartsWithAlpha(tokenText)?Kusto.Data.IntelliSense.CslCommandToken.Kind.UnknownToken:Kusto.Data.IntelliSense.CslCommandToken.Kind.PlainTextToken,token=($t=new Kusto.Data.IntelliSense.CslCommandToken(tokenText,this.RelativeStart,tokenKind),$t.Length=tokenText.length,$t.RelativeStart=tokenStart+startTextIndex|0,$t);tokens.add(token);endTextIndex<chars.length&&(suffixText=text.substr(endTextIndex,chars.length-endTextIndex|0),suffixToken=($t=new Kusto.Data.IntelliSense.CslCommandToken(suffixText,this.RelativeStart,Kusto.Data.IntelliSense.CslCommandToken.Kind.PlainTextToken),$t.Length=suffixText.length,$t.RelativeStart=tokenStart+endTextIndex|0,$t),tokens.add(suffixToken))}}});Bridge.ns("Kusto.Data.IntelliSense.CslCommand",$asm.$);Bridge.apply($asm.$.Kusto.Data.IntelliSense.CslCommand,{f1:function(_o1){return _o1.add("distinct"),_o1.add("extend"),_o1.add("project"),_o1.add("project-rename"),_o1.add("mvexpand"),_o1.add("mv-expand"),_o1.add("where"),_o1.add("filter"),_o1.add("parse"),_o1.add("limit"),_o1.add("count"),_o1.add("order"),_o1.add("sort"),_o1.add("reduce"),_o1.add("take"),_o1.add("summarize"),_o1.add("top"),_o1.add("top-nested"),_o1.add("top-hitters"),_o1.add("render"),_o1.add("fork"),_o1.add("find"),_o1.add("sample"),_o1.add("sample-distinct"),_o1.add("search"),_o1.add("make-series"),_o1},f2:function(c){return c.m_tokens},f3:function(c){return c.m_commandParts},f4:function(c){return c.m_commentsParts},f5:function(c){return c.m_clientDirectivesParts},f6:function(c){return c.m_bracketParts},f7:function(c){return c.Text},f8:function(c){return c.IsRunnable},f9:function(p){return p.AbsoluteStart},f10:function(p){return p.RelativeStart},f11:function(t){var token=Bridge.as(t.clone(),Kusto.Data.IntelliSense.CslCommandToken);return token.AbsolutePositionBias=this.RelativeStart,token},f12:function(x,y){return x.CompareTo(y)},f13:function(ct){return ct.Value}});Bridge.define("Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState",{$kind:"nested class",fields:{MapOfKnownEntities:null,MapOfPreviousCalculatedEntities:null,MapOfOriginallyKnownEntities:null},ctors:{init:function(){this.MapOfKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).ctor);this.MapOfPreviousCalculatedEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).ctor);this.MapOfOriginallyKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).ctor)}},methods:{Clone:function(){var $t;return $t=new Kusto.Data.IntelliSense.CslCommand.AddEntitiesTokensState,$t.MapOfKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).$ctor1)(this.MapOfKnownEntities),$t.MapOfOriginallyKnownEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).$ctor1)(this.MapOfOriginallyKnownEntities),$t.MapOfPreviousCalculatedEntities=new(System.Collections.Generic.Dictionary$2(Kusto.Data.IntelliSense.KustoCommandContext,System.Collections.Generic.List$1(System.String)).$ctor1)(this.MapOfPreviousCalculatedEntities),$t}}});Bridge.define("Kusto.Data.IntelliSense.CslCommand.FormatTraits",{$kind:"nested enum",statics:{fields:{None:0,IncludeComments:1,TabulateOnJoins:2,TabulateOnFunctionBoundaries:4}},$flags:!0});Bridge.define("Kusto.Data.IntelliSense.CslCommand.PrivateTracer",{$kind:"nested class",statics:{fields:{Tracer:null},ctors:{init:function(){this.Tracer=new Kusto.Data.IntelliSense.CslCommand.PrivateTracer}}},methods:{TraceVerbose:function(format,list){list===void 0&&(list=[])}}});Bridge.define("Kusto.Data.IntelliSense.CslCommandIndexer",{statics:{fields:{MultiLineRegexOptions:0,SingleLineRegexOptions:0,s_defaultCommentRegex:null,s_defaultClientDirectivesRegex:null,s_defaultStringLiteralsRegex:null,s_defaultQueryParametersRegex:null,s_matchingBrackets:null},ctors:{init:function(){this.MultiLineRegexOptions=2;this.SingleLineRegexOptions=16;this.s_defaultCommentRegex=new System.Text.RegularExpressions.Regex.ctor("(^\\s*//.*?(\\n|$))",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions);this.s_defaultClientDirectivesRegex=new System.Text.RegularExpressions.Regex.ctor("(^\\s*#.*?(\\n|$))",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions);this.s_defaultStringLiteralsRegex=new System.Text.RegularExpressions.Regex.ctor("(@?'.*?\\'|@?\\\".*?\\\")",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions);this.s_defaultQueryParametersRegex=new System.Text.RegularExpressions.Regex.ctor("\\{([a-zA-Z]\\w+?)\\}",Kusto.Data.IntelliSense.CslCommandIndexer.MultiLineRegexOptions);this.s_matchingBrackets=$asm.$.Kusto.Data.IntelliSense.CslCommandIndexer.f1(new(System.Collections.Generic.Dictionary$2(System.Char,System.Char).ctor))}},methods:{AddToCollection:function(text,chars,tokenStart,scanStart,target){var $t,endOfArray={},terminators=System.Array.init([10,13],System.Char),token=($t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,$t.Start=tokenStart,$t.End=Kusto.Data.IntelliSense.CslCommandIndexer.ReadTill(chars,scanStart+1|0,terminators,null,endOfArray),$t),len;return token.End>token.Start&&(endOfArray.v&&(token.End=token.End-1|0),len=(token.End-token.Start|0)+1|0,token.Text=text.substr(token.Start,len),target.add(token)),token.End},ReadTill:function(chars,i,terminators,escaping,endOfArray){endOfArray.v=!0;for(var foundTerminators=new(System.Collections.Generic.HashSet$1(System.Char).ctor);i<chars.length;i=i+1|0){if(System.Linq.Enumerable.from(foundTerminators,System.Char).any()){if(System.Array.contains(terminators,chars[System.Array.index(i,chars)],System.Char)&&!foundTerminators.contains(chars[System.Array.index(i,chars)])){foundTerminators.add(chars[System.Array.index(i,chars)]);continue}endOfArray.v=!1;i=i-1|0;break}if(System.Array.contains(terminators,chars[System.Array.index(i,chars)],System.Char)){foundTerminators.add(chars[System.Array.index(i,chars)]);continue}escaping!=null&&System.Linq.Enumerable.from(escaping,System.Char).any(function(t){return chars[System.Array.index(i,chars)]===t})&&(i=i+1|0)}return i>chars.length?chars.length:i},ReadVerbatimTill:function(chars,i,terminators,endOfArray){endOfArray.v=!0;for(var escapeSequence=0;i<chars.length;i=i+1|0)if(System.Array.contains(terminators,chars[System.Array.index(i,chars)],System.Char)&&(escapeSequence=escapeSequence+1|0,escapeSequence%2!=0&&i<(chars.length-1|0)&&!System.Array.contains(terminators,chars[System.Array.index(i+1|0,chars)],System.Char))){endOfArray.v=!1;break}return i},CaptureTokensUsingRegex:function(text,regexList,tokenList){var $t,$t1,$t2,$t3,commentRegex,matches,m,c,token;if(!Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(System.Text.RegularExpressions.Regex,regexList)){$t=Bridge.getEnumerator(regexList);try{while($t.moveNext()){commentRegex=$t.Current;matches=commentRegex.matches(text);$t1=Bridge.getEnumerator(matches);try{while($t1.moveNext()){m=Bridge.cast($t1.Current,System.Text.RegularExpressions.Match);$t2=Bridge.getEnumerator(m.getCaptures());try{while($t2.moveNext())c=Bridge.cast($t2.Current,System.Text.RegularExpressions.Capture),token=($t3=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,$t3.Start=c.getIndex(),$t3.End=(c.getIndex()+c.getLength()|0)-1|0,$t3.Text=c.getValue(),$t3),tokenList.add(token)}finally{Bridge.is($t2,System.IDisposable)&&$t2.System$IDisposable$Dispose()}}}finally{Bridge.is($t1,System.IDisposable)&&$t1.System$IDisposable$Dispose()}}}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}}}}},fields:{m_tokensAndPositions:null,m_commentTokenPositions:null,m_clientDirectivesTokenPositions:null,m_stringLiteralsPositions:null,m_queryParametersPositions:null,m_commandPartsPositions:null,m_bracketPartsPositions:null,m_sourceText:null,m_commentRegexCollection:null,m_clientDirectivesRegexCollection:null,m_stringLiteralsRegexCollection:null,m_queryParametersRegexCollection:null},props:{AntiTokenizers:null,TokenTerminators:null,TokenStarters:null},ctors:{init:function(){this.m_tokensAndPositions=new(System.Collections.Generic.Dictionary$2(System.String,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).ctor);this.m_commentTokenPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor);this.m_clientDirectivesTokenPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor);this.m_stringLiteralsPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor);this.m_queryParametersPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor);this.m_commandPartsPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor);this.m_bracketPartsPositions=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor);this.m_commentRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex).ctor);this.m_clientDirectivesRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex).ctor);this.m_stringLiteralsRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex).ctor);this.m_queryParametersRegexCollection=new(System.Collections.Generic.List$1(System.Text.RegularExpressions.Regex).ctor)},ctor:function(indexQueryParameters){this.$initialize();this.m_commentRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultCommentRegex);this.m_clientDirectivesRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultClientDirectivesRegex);this.m_stringLiteralsRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultStringLiteralsRegex);indexQueryParameters&&this.m_queryParametersRegexCollection.add(Kusto.Data.IntelliSense.CslCommandIndexer.s_defaultQueryParametersRegex)}},methods:{IndexText:function(text){var $t,chars,i,len,partText,bracketItem,bracketToken,isTokenEnd;this.m_tokensAndPositions.clear();this.m_sourceText=text;chars=System.String.toCharArray(text,0,text.length);this.DetectCommentsAndStringLiterals(text);var skipRanges=this.GetTokenLookupSkipRanges(text.length),tokenLookupState=Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenStart,tokenBuilder=null,tokenPosition=null,commandPartPosition=null,bracketsStack=new(System.Collections.Generic.Stack$1(System.Tuple$2(System.Char,System.Int32)).ctor);for(i=0;i<chars.length;i=i+1|0){var isInsideTokenLookupSkipRange=skipRanges[System.Array.index(i,skipRanges)],isInsideCommentRange=System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(r){return i>=r.Start&&i<=r.End}).any(),c=chars[System.Array.index(i,chars)],isAfterWhiteSpace=i===0||System.Char.isWhiteSpace(String.fromCharCode(chars[System.Array.index(i-1|0,chars)])),canStartNewPart=!0;commandPartPosition!=null&&((c===124||c===59)&&!isInsideTokenLookupSkipRange||isInsideCommentRange||i===(chars.length-1|0))&&(i===(chars.length-1|0)||c===59?(commandPartPosition.End=i,canStartNewPart=!1):commandPartPosition.End=i-1|0,len=(commandPartPosition.End-commandPartPosition.Start|0)+1|0,len>1&&(partText=text.substr(commandPartPosition.Start,len),commandPartPosition.Text=partText,System.String.equals(partText,"\n")||System.String.isNullOrWhiteSpace(partText)||this.m_commandPartsPositions.add(commandPartPosition)),commandPartPosition=null);commandPartPosition==null&&!isInsideCommentRange&&canStartNewPart&&(commandPartPosition=($t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,$t.Start=i,$t.End=i,$t));isInsideTokenLookupSkipRange||Kusto.Data.IntelliSense.CslCommandIndexer.s_matchingBrackets.containsKey(c)&&(bracketsStack.Count>0&&bracketsStack.Peek().Item1===c?(bracketItem=bracketsStack.Pop(),bracketToken=($t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,$t.Start=bracketItem.Item2,$t.End=i,$t),bracketToken.Text=text.substr(bracketToken.Start,(bracketToken.End-bracketToken.Start|0)+1|0),this.m_bracketPartsPositions.add(bracketToken)):bracketsStack.Push({Item1:Kusto.Data.IntelliSense.CslCommandIndexer.s_matchingBrackets.getItem(c),Item2:i}));switch(tokenLookupState){case Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenStart:!isInsideTokenLookupSkipRange&&(this.IsPartOfTheToken(c)&&!this.IsTokenTerminator(c)||isAfterWhiteSpace&&this.IsTokenStarter(c))&&(tokenBuilder=new System.Text.StringBuilder,tokenPosition=($t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,$t.Start=i,$t.End=i,$t),tokenBuilder.append(String.fromCharCode(c)),tokenLookupState=Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenEnd);break;case Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenEnd:isTokenEnd=!1;!isInsideTokenLookupSkipRange&&this.IsPartOfTheToken(c)?this.IsTokenTerminator(c)?(tokenPosition.TokenTerminator=c,isTokenEnd=!0):(tokenBuilder.append(String.fromCharCode(c)),tokenPosition.End=i):isTokenEnd=!0;(isTokenEnd||i===(chars.length-1|0))&&(tokenPosition.Text=tokenBuilder.toString(),this.AddTokenPosition(tokenPosition),tokenLookupState=Kusto.Data.IntelliSense.CslCommandIndexer.State.LookingForTokenStart);break}}},GetTokenLookupSkipRanges:function(size){var ranges=new(System.Collections.Generic.List$1(System.Tuple$2(System.Int32,System.Int32)).ctor),i;ranges.AddRange(System.Linq.Enumerable.from(this.m_stringLiteralsPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select($asm.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2));ranges.AddRange(System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select($asm.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2));ranges.AddRange(System.Linq.Enumerable.from(this.m_clientDirectivesTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select($asm.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2));ranges.AddRange(System.Linq.Enumerable.from(this.m_queryParametersPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).select($asm.$.Kusto.Data.IntelliSense.CslCommandIndexer.f2));ranges.Sort$2($asm.$.Kusto.Data.IntelliSense.CslCommandIndexer.f3);var rIndex=0,currentSkipRange=System.Linq.Enumerable.from(ranges,System.Tuple$2(System.Int32,System.Int32)).firstOrDefault(null,null),result=System.Array.init(size,!1,System.Boolean);for(i=0;i<size&&currentSkipRange!=null;i=i+1|0)i>=currentSkipRange.Item1&&(result[System.Array.index(i,result)]=!0),currentSkipRange.Item2===i&&(currentSkipRange=System.Linq.Enumerable.from(ranges,System.Tuple$2(System.Int32,System.Int32)).elementAtOrDefault(rIndex=rIndex+1|0,null));return result},GetCommandPartsPositions:function(){return this.m_commandPartsPositions},GetCommentsPositions:function(){return this.m_commentTokenPositions},GetClientDirectivesPositions:function(){return this.m_clientDirectivesTokenPositions},GetStringLiteralsPositions:function(){return this.m_stringLiteralsPositions},GetQueryParametersPositions:function(){return this.m_queryParametersPositions},GetBracketsPositions:function(){return this.m_bracketPartsPositions},GetUnrecognizedTokenPositions:function(recognizedTokens){return System.Linq.Enumerable.from(this.m_tokensAndPositions.Values,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)).selectMany($asm.$.Kusto.Data.IntelliSense.CslCommandIndexer.f4).except(recognizedTokens)},GetTokenPositionsInRange:function(searchForTokens,rangeStart,rangeEnd){var $t,result=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),token,tokensInRange;if(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(System.String,searchForTokens))return result;$t=Bridge.getEnumerator(searchForTokens,System.String);try{while($t.moveNext())(token=$t.Current,System.String.isNullOrEmpty(token))||this.m_tokensAndPositions.containsKey(token)&&(tokensInRange=System.Linq.Enumerable.from(this.m_tokensAndPositions.getItem(token),Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(t){return t.Start>=rangeStart&&t.End<=rangeEnd}),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,tokensInRange)&&result.AddRange(tokensInRange))}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return result},GetAllTokensSortedByPosition:function(){return Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$1(System.Collections.Generic.KeyValuePair$2(System.String,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition)),this.m_tokensAndPositions)?null:System.Linq.Enumerable.from(this.m_tokensAndPositions,System.Collections.Generic.KeyValuePair$2(System.String,System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition))).selectMany($asm.$.Kusto.Data.IntelliSense.CslCommandIndexer.f5).orderBy($asm.$.Kusto.Data.IntelliSense.CslCommandIndexer.f6)},GetAllTokenPositions:function(tokens,tokenSuffix){var $t,result,token;if(tokenSuffix===void 0&&(tokenSuffix=0),result=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastNone$2(System.String,tokens))return result;$t=Bridge.getEnumerator(tokens,System.String);try{while($t.moveNext())token=$t.Current,this.m_tokensAndPositions.containsKey(token)&&result.AddRange(System.Linq.Enumerable.from(this.m_tokensAndPositions.getItem(token),Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function(t){return t.TokenTerminator===tokenSuffix}))}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return result},IsPartOfTheToken:function(c){return System.Char.isDigit(c)||System.Char.isLetter(c)||this.AntiTokenizers!=null&&this.AntiTokenizers.contains(c)},IsTokenTerminator:function(c){return this.TokenTerminators!=null&&this.TokenTerminators.contains(c)},IsTokenStarter:function(c){return this.TokenStarters!=null&&System.Array.contains(this.TokenStarters,c,System.Char)},DetectCommentsAndStringLiterals:function(text){Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(text,this.m_queryParametersRegexCollection,this.m_queryParametersPositions);Kusto.Cloud.Platform.Utils.ExtendedEnumerable.None(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,this.m_queryParametersPositions)?this.DetectCommentsAndStringLiterals_Simple(text):this.DetectCommentsAndStringLiterals_Complex(text)},DetectCommentsAndStringLiterals_Simple:function(text){for(var ch,chars=System.String.toCharArray(text,0,text.length),state=0,i=0;i<chars.length;i=i+1|0){ch=chars[System.Array.index(i,chars)];switch(state){case 0:ch===64?state=1:ch===39||ch===34?i=this.AddStringLiteralToken(text,chars,i,i,ch,!1):ch===47?state=2:ch===35&&(i=this.AddClientDirectiveToken(text,chars,i,i),state=0);break;case 1:(ch===39||ch===34)&&(i=this.AddStringLiteralToken(text,chars,i-1|0,i,ch,!0));state=0;break;case 2:ch===47&&(i=this.AddCommentToken(text,chars,i-1|0,i));state=0;break}}},AddCommentToken:function(text,chars,tokenStart,scanStart){return Kusto.Data.IntelliSense.CslCommandIndexer.AddToCollection(text,chars,tokenStart,scanStart,this.m_commentTokenPositions)},AddClientDirectiveToken:function(text,chars,tokenStart,scanStart){return Kusto.Data.IntelliSense.CslCommandIndexer.AddToCollection(text,chars,tokenStart,scanStart,this.m_clientDirectivesTokenPositions)},AddStringLiteralToken:function(text,chars,start,position,ch,ifVerbatim){var $t,endOfArray={},token=($t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,$t.Start=start,$t.End=ifVerbatim?Kusto.Data.IntelliSense.CslCommandIndexer.ReadVerbatimTill(chars,position+1|0,System.Array.init([ch],System.Char),endOfArray):Kusto.Data.IntelliSense.CslCommandIndexer.ReadTill(chars,position+1|0,System.Array.init([ch],System.Char),System.Array.init([92],System.Char),endOfArray),$t),len;return token.End>token.Start&&(endOfArray.v&&(token.End=token.End-1|0),len=(token.End-token.Start|0)+1|0,token.Text=text.substr(token.Start,len),this.m_stringLiteralsPositions.add(token)),token.End},DetectCommentsAndStringLiterals_Complex:function(text){var $t,i,slp,i1,slp1,i2,qpp,slp2,newSlp;for(Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(text,this.m_commentRegexCollection,this.m_commentTokenPositions),Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(text,this.m_clientDirectivesRegexCollection,this.m_clientDirectivesTokenPositions),i=this.m_queryParametersPositions.Count-1|0;i>=0;i=i-1|0)slp={v:this.m_queryParametersPositions.getItem(i)},System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function($me,slp){return function(comment){return comment.Start<=slp.v.Start&&comment.End>=slp.v.End}}(this,slp)).any()&&this.m_queryParametersPositions.removeAt(i);for(Kusto.Data.IntelliSense.CslCommandIndexer.CaptureTokensUsingRegex(text,this.m_stringLiteralsRegexCollection,this.m_stringLiteralsPositions),i1=this.m_stringLiteralsPositions.Count-1|0;i1>=0;i1=i1-1|0)slp1={v:this.m_stringLiteralsPositions.getItem(i1)},System.Linq.Enumerable.from(this.m_commentTokenPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function($me,slp1){return function(comment){return comment.Start<=slp1.v.Start&&comment.End>=slp1.v.End}}(this,slp1)).any()&&this.m_stringLiteralsPositions.removeAt(i1);for(i2=this.m_queryParametersPositions.Count-1|0;i2>=0;i2=i2-1|0)qpp={v:this.m_queryParametersPositions.getItem(i2)},slp2=System.Linq.Enumerable.from(this.m_stringLiteralsPositions,Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).where(function($me,qpp){return function(s){return s.Start<=qpp.v.Start&&s.End>=qpp.v.End}}(this,qpp)).firstOrDefault(null,null),slp2!=null&&(newSlp=($t=new Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition,$t.Start=qpp.v.End+1|0,$t.End=slp2.End,$t.Text=slp2.Text.substr((qpp.v.End-slp2.Start|0)+1|0),$t),slp2.End=qpp.v.Start-1|0,slp2.Text=slp2.Text.substr(0,slp2.Length),this.m_stringLiteralsPositions.add(newSlp))},AddTokenPosition:function(tokenPosition){this.m_tokensAndPositions.containsKey(tokenPosition.Text)||this.m_tokensAndPositions.add(tokenPosition.Text,new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition).ctor));this.m_tokensAndPositions.getItem(tokenPosition.Text).add(tokenPosition)}}});Bridge.ns("Kusto.Data.IntelliSense.CslCommandIndexer",$asm.$);Bridge.apply($asm.$.Kusto.Data.IntelliSense.CslCommandIndexer,{f1:function(_o1){return _o1.add(40,41),_o1.add(41,40),_o1.add(91,93),_o1.add(93,91),_o1.add(123,125),_o1.add(125,123),_o1},f2:function(p){return{Item1:p.Start,Item2:p.End}},f3:function(r1,r2){return Bridge.compare(r1.Item1,r2.Item1)},f4:function(t){return t},f5:function(kvp){return kvp.value},f6:function(t){return t.Start}});Bridge.define("Kusto.Data.IntelliSense.CslCommandIndexer.State",{$kind:"nested enum",statics:{fields:{LookingForTokenStart:0,LookingForTokenEnd:1,InsideComment:2,InsideStringLiteral:3}}});Bridge.define("Kusto.Data.IntelliSense.CslCommandIndexer.TokenPosition",{$kind:"nested class",props:{Text:null,Start:0,End:0,TokenTerminator:0,Length:{get:function(){return(this.End-this.Start|0)+1|0}}},ctors:{ctor:function(){this.$initialize();this.TokenTerminator=0}}});Bridge.define("Kusto.Data.IntelliSense.CslCommandParser",{statics:{fields:{ControlCommandsTokens:null,CslCommandsTokens:null,ChartRenderTypesTokens:null,ChartRenderKindTokens:null,SubOperatorsTokens:null,JoinKindTokens:null,ReduceByKindTokens:null,DataTypesTokens:null,ScalarFunctionsDateTimeTokens:null,ScalarFunctionsNoDateTimeTokens:null,SingleParameterFunctionsDateTimeTokens:null,ZeroParameterFunctionsNoDateTimeTokens:null,SingleParameterFunctionsNoDateTimeTokens:null,IntrinsicFunctionTokens:null,TwoParameterFunctionsTokens:null,ThreeParameterFunctionsTokens:null,ManyParametersFunctionsTokens:null,PromotedOperatorCommandTokens:null,ClientDirectiveTokens:null,OperatorCommandTokens:null,DataOperatorTokens:null,SummarizeAggregationSingleParameterTokens:null,SummarizeAggregationTwoParametersTokens:null,SummarizeAggregationThreeParametersTokens:null,SummarizeAggregationManyParametersTokens:null,MakeSeriesAggregationTokens:null,PluginTokens:null,DatetimeFunctionsTokens:null,ScalarFunctionsTokens:null,SingleParameterFunctionsTokens:null,SummarizeAggregationTokens:null,SummarizeAggregationAliasesTokens:null,SortedSummarizeAggregators:null,SortedMakeSeriesAggregationTokens:null,SortedDatetimeFunctions:null,SortedExtendFunctions:null,FunctionsTokens:null,SortedEvaluateFunctions:null,s_asyncSeeker:null,s_isCommentLineRegex:null},ctors:{init:function(){this.ControlCommandsTokens=System.Array.init([".add",".alter",".alter-merge",".attach",".append",".create",".create-merge",".create-set",".create-or-alter",".define",".detach",".delete",".drop",".drop-pretend",".dup-next-ingest",".dup-next-failed-ingest",".ingest",".export",".load",".move",".purge",".purge-cleanup",".remove",".replace",".save",".set",".set-or-append",".set-or-replace",".show",".rename",".run","async","data","into","ifnotexists","whatif","compressed","monitoring","metadata","folder","docstring","details","hot","records","until","as","csv","tsv","json","sql","policy","encoding","retention","merge","policies","update","ingestiontime","caching","sharding","callout","restricted_view_access","ingestionbatching","query_weak_consistency","partitioning","softdelete","harddelete","rowstore","rowstores","seal","writeaheadlog","streamingingestion","rowstore_references","follower"],System.String);this.CslCommandsTokens=System.Array.init(["set","let","restrict","access","alias","pattern","declare","query_parameters"],System.String);this.ChartRenderTypesTokens=System.Linq.Enumerable.from(System.Array.init(["columnchart","barchart","piechart","timechart","anomalychart","linechart","ladderchart","pivotchart","areachart","stackedareachart","scatterchart","timepivot","timeline","card","table","list","treemap"],System.String),System.String).orderBy($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f1).ToArray(System.String);this.ChartRenderKindTokens=System.Array.init(["default","stacked","stacked100","unstacked","map"],System.String);this.SubOperatorsTokens=System.Linq.Enumerable.from(System.Array.init(["like","notlike","contains","notcontains","!contains","contains_cs","!contains_cs","startswith","!startswith","has","!has","has_cs","!has_cs","hasprefix","!hasprefix","hassuffix","!hassuffix","matches","regex","in","!in","endswith","!endswith","between","!between","extent","database","diagnostics","jitmanagers","admins","basicauth","cache","capacity","cluster","continuous-export","continuous-exports","databases","extents","external","journal","memory","extentcontainers","viewers","unrestrictedviewers","tags","prettyname","blockedprincipals","failed","operations","password","principal","principals","settings","schema","table","tables","user","users","ingestors","monitors","version","roles","fabric","locks","service","services","nodes","unallocated","subscriptions","nonregistered","packages","configuration","commands","commands-and-queries","queries","query","function","functions","by","on","of","true","false","and","or","asc","desc","nulls","last","first","with","withsource","kind","flags","from","to","step","ingestion","failures","mapping","mappings","geneva","eventhub","source","sources","types","application","period","reason","title"],System.String),System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ChartRenderTypesTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ChartRenderKindTokens).distinct().ToArray(System.String);this.JoinKindTokens=System.Array.init(["anti","inner","innerunique","fullouter","leftanti","leftantisemi","leftouter","leftsemi","rightanti","rightantisemi","rightsemi","rightouter"],System.String);this.ReduceByKindTokens=System.Array.init(["mining"],System.String);this.DataTypesTokens=System.Array.init(["timespan","datetime","int","long","real","string","bool","double","dynamic","decimal","guid"],System.String);this.ScalarFunctionsDateTimeTokens=System.Array.init(["now","ago","datetime","ingestion_time"],System.String);this.ScalarFunctionsNoDateTimeTokens=System.Array.init(["time","timespan","dynamic","decimal"],System.String);this.SingleParameterFunctionsDateTimeTokens=System.Array.init(["todatetime","between","!between"],System.String);this.ZeroParameterFunctionsNoDateTimeTokens=System.Array.init(["row_number","extent_id","extent_tags","pi","pack_all","rowstore_ordinal_range"],System.String);this.SingleParameterFunctionsNoDateTimeTokens=System.Array.init(["strlen","tostring","toupper","tolower","typeof","reverse","parsejson","parse_json","parse_xml","parse_csv","tobool","toboolean","todynamic","toobject","toint","tolong","toguid","todouble","toreal","totimespan","tohex","todecimal","isempty","isnotempty","isnull","isnotnull","isnan","isinf","isfinite","dayofweek","dayofmonth","dayofyear","week_of_year","monthofyear","sqrt","rand","log","log10","log2","exp","exp2","exp10","abs","degrees","radians","sign","sin","cos","tan","asin","acos","atan","cot","getmonth","getyear","array_length","gettype","bag_keys","cursor_after","gamma","loggamma","dcount_hll","parse_ipv4","parse_url","parse_path","parse_version","parse_urlquery","url_encode","url_decode","binary_not","not","toscalar","materialize","series_stats","series_fit_line","series_fit_2lines","series_stats_dynamic","series_fit_line_dynamic","series_fit_2lines_dynamic","base64_encodestring","base64_decodestring","hash_sha256","ceiling","string_size","isascii","isutf8","geo_geohash_to_central_point"],System.String);this.IntrinsicFunctionTokens=System.Array.init(["cluster","database","table"],System.String);this.TwoParameterFunctionsTokens=System.Array.init(["bin","columnifexists","floor","countof","hash","round","pow","binary_and","binary_or","binary_xor","binary_shift_left","binary_shift_right","datepart","datetime_part","repeat","series_seasonal","series_outliers","array_split","series_add","series_subtract","series_multiply","series_divide","series_pow","series_pearson_correlation","series_greater","series_greater_equals","series_less","series_less_equals","series_equals","series_not_equals","rank_tdigest","percentrank_tdigest","trim","trim_start","trim_end","startofday","startofweek","startofmonth","startofyear","endofday","endofweek","endofmonth","endofyear","series_fill_backward","series_fill_forward","atan2","format_datetime","format_timespan","strrep","strcat_array","parse_user_agent","strcmp","row_cumsum"],System.String);this.ThreeParameterFunctionsTokens=System.Array.init(["iff","iif","range","replace","translate","series_iir","bin_at","series_fill_const","series_decompose","series_decompose_forecast","series_decompose_anomalies","datetime_diff","datetime_add","geo_point_to_geohash","geo_point_in_polygon"],System.String);this.ManyParametersFunctionsTokens=System.Array.init(["extract","extractjson","extractall","strcat","strcat_delim","substring","indexof","split","case","coalesce","max_of","min_of","percentile_tdigest","zip","pack","pack_dictionary","pack_array","array_concat","array_slice","welch_test","row_window_session","series_fir","series_periods_detect","prev","next","tdigest_merge","hll_merge","series_fill_linear","series_periods_validate","datatable","make_datetime","make_timespan","make_string","geo_distance_2points","geo_point_in_circle"],System.String);this.PromotedOperatorCommandTokens=System.Array.init(["where","count","extend","join","limit","order","project","project-away","project-rename","project-reorder","project-keep","render","sort","summarize","distinct","take","top","top-nested","top-hitters","union","mv-expand","mv-apply","reduce","evaluate","parse","parse-where","sample","sample-distinct","make-series","getschema","serialize","invoke","as","scan"],System.String);this.ClientDirectiveTokens=System.Array.init(["connect"],System.String);this.OperatorCommandTokens=System.Linq.Enumerable.from(System.Array.init(["filter","fork","facet","range","consume","find","search","print","partition","lookup"],System.String),System.String).union(Kusto.Data.IntelliSense.CslCommandParser.PromotedOperatorCommandTokens).ToArray(System.String);this.DataOperatorTokens=System.Array.init(["datatable","externaldata"],System.String);this.SummarizeAggregationSingleParameterTokens=System.Array.init(["count","countif","dcount","dcountif","sum","min","max","avg","avgif","any","makelist","makeset","make_dictionary","stdev","stdevif","varianceif","variance","buildschema","hll","hll_merge","tdigest","tdigest_merge"],System.String);this.SummarizeAggregationTwoParametersTokens=System.Array.init(["percentile","sumif"],System.String);this.SummarizeAggregationThreeParametersTokens=System.Array.init(["percentilew"],System.String);this.SummarizeAggregationManyParametersTokens=System.Array.init(["arg_min","arg_max","percentilesw_array","percentilesw","percentiles_array","percentiles"],System.String);this.MakeSeriesAggregationTokens=System.Array.init(["count","countif","dcount","dcountif","sum","min","max","avg","any","stdev","stdevp","variance","variancep","sumif"],System.String);this.PluginTokens=System.Array.init(["autocluster","diffpatterns","basket","extractcolumns"],System.String);this.DatetimeFunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsDateTimeTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsDateTimeTokens).ToArray(System.String);this.ScalarFunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsDateTimeTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsNoDateTimeTokens).ToArray(System.String);this.SingleParameterFunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsDateTimeTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsNoDateTimeTokens).ToArray(System.String);this.SummarizeAggregationTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationSingleParameterTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationManyParametersTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationThreeParametersTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationTwoParametersTokens).ToArray(System.String);this.SummarizeAggregationAliasesTokens=System.Array.init(["argmax","argmin"],System.String);this.SortedSummarizeAggregators=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationTokens,System.String).orderBy($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String);this.SortedMakeSeriesAggregationTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.MakeSeriesAggregationTokens,System.String).orderBy($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String);this.SortedDatetimeFunctions=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.DatetimeFunctionsTokens,System.String).orderBy($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String);this.SortedExtendFunctions=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ManyParametersFunctionsTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ZeroParameterFunctionsNoDateTimeTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.TwoParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ThreeParameterFunctionsTokens).orderBy($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f2).select($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f3).ToArray(System.String);this.FunctionsTokens=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.ManyParametersFunctionsTokens,System.String).union(Kusto.Data.IntelliSense.CslCommandParser.ScalarFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ZeroParameterFunctionsNoDateTimeTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SingleParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.TwoParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.ThreeParameterFunctionsTokens).union(Kusto.Data.IntelliSense.CslCommandParser.SummarizeAggregationTokens).union(Kusto.Data.IntelliSense.CslCommandParser.IntrinsicFunctionTokens).ToArray(System.String);this.SortedEvaluateFunctions=System.Linq.Enumerable.from(Kusto.Data.IntelliSense.CslCommandParser.PluginTokens,System.String).orderBy($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f2).ToArray(System.String);this.s_asyncSeeker=new System.Text.RegularExpressions.Regex.ctor("^\\.[\\w\\-]+\\s+async",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions);this.s_isCommentLineRegex=new System.Text.RegularExpressions.Regex.ctor("^\\s*//",Kusto.Data.IntelliSense.IntelliSenseRulesProviderBase.DefaultRegexOptions)}},methods:{IsAdminCommand$1:function(query,queryWithoutLeadingComments){return Kusto.Data.IntelliSense.CslCommandParser.IsStartingWithPrefix(query,".",queryWithoutLeadingComments)},IsAdminCommand:function(command){var commandWithoutLeadingComments={};return Kusto.Data.IntelliSense.CslCommandParser.IsAdminCommand$1(command,commandWithoutLeadingComments)},ResolveRequestApiKind:function(requestContent){var requestContentWithoutLeadingComments={},isAdminCommand=Kusto.Data.IntelliSense.CslCommandParser.IsStartingWithPrefix(requestContent,".",requestContentWithoutLeadingComments);return isAdminCommand?Kusto.Data.IntelliSense.CslCommandParser.s_asyncSeeker.isMatch(requestContentWithoutLeadingComments.v)?Kusto.Data.IntelliSense.ApiKind.AdminAsyncCommand:Kusto.Data.IntelliSense.ApiKind.AdminSyncCommand:Kusto.Data.IntelliSense.ApiKind.Query},IsStartingWithPrefix:function(query,prefix,queryWithoutLeadingComments){var lines,i,line;for(queryWithoutLeadingComments.v=query.trim(),lines=System.String.split(query,System.Array.init([13,10],System.Char).map(function(i){return String.fromCharCode(i)}),null,1),i=0;i<lines.length;i=i+1|0){if(line=lines[System.Array.index(i,lines)],System.String.startsWith(System.String.trimStart(line),prefix))return i>0&&(queryWithoutLeadingComments.v=Bridge.toArray(System.Linq.Enumerable.from(lines,System.String).skip(i)).join("\n").trim()),!0;if(!Kusto.Data.IntelliSense.CslCommandParser.s_isCommentLineRegex.isMatch(line))return i>0&&(queryWithoutLeadingComments.v=Bridge.toArray(System.Linq.Enumerable.from(lines,System.String).skip(i)).join("\n").trim()),!1}return!1},IsClientDirective:function(command,directiveWithoutLeadingComments){return Kusto.Data.IntelliSense.CslCommandParser.IsStartingWithPrefix(command,"#",directiveWithoutLeadingComments)}}},fields:{m_hashedCommands:null,m_rulesProvider:null},props:{Results:null},ctors:{ctor:function(){this.$initialize();this.Reset()}},methods:{Reset:function(){this.m_hashedCommands=new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Data.IntelliSense.CslCommand).ctor);this.Results=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand).ctor)},Parse:function(rulesProvider,text,parseMode){var results=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand).ctor),parsedCommands,i,newCommand,wasFound,previousCandidate;if(Bridge.referenceEquals(this.m_rulesProvider,rulesProvider)||(this.Reset(),this.m_rulesProvider=rulesProvider),parsedCommands=Kusto.Data.IntelliSense.CslCommandParser.CslCommandTokenizer.GetCommands(text),Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$4(Kusto.Data.IntelliSense.CslCommand,parsedCommands))for(i=0;i<parsedCommands.Count;i=i+1|0)newCommand=parsedCommands.getItem(i),newCommand.ParseMode=parseMode,wasFound=this.FetchFromCache(parseMode,newCommand),wasFound||(previousCandidate=this.Results!=null?System.Linq.Enumerable.from(this.Results,Kusto.Data.IntelliSense.CslCommand).elementAtOrDefault(i,null):null,newCommand.ParseTokens(rulesProvider,parseMode,previousCandidate)),results.add(newCommand);return this.m_hashedCommands=System.Linq.Enumerable.from(Kusto.Cloud.Platform.Utils.ExtendedEnumerable.DistinctBy(Kusto.Data.IntelliSense.CslCommand,System.String,results,$asm.$.Kusto.Data.IntelliSense.CslCommandParser.f4),Kusto.Data.IntelliSense.CslCommand).toDictionary($asm.$.Kusto.Data.IntelliSense.CslCommandParser.f4,$asm.$.Kusto.Data.IntelliSense.CslCommandParser.f5,System.String,Kusto.Data.IntelliSense.CslCommand),this.Results=results,results},FetchFromCache:function(parseMode,newCommand){var wasFound=!1,previouslyParsedCommand={};return this.m_hashedCommands.tryGetValue(newCommand.Text,previouslyParsedCommand)&&previouslyParsedCommand.v.ParseMode===parseMode&&(newCommand.AcquireTokens(previouslyParsedCommand.v),wasFound=!0),wasFound},Clone:function(){var $t,parser=new Kusto.Data.IntelliSense.CslCommandParser;return parser.m_hashedCommands=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$1(System.Collections.Generic.KeyValuePair$2(System.String,Kusto.Data.IntelliSense.CslCommand),this.m_hashedCommands)?new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Data.IntelliSense.CslCommand).$ctor1)(this.m_hashedCommands):new(System.Collections.Generic.Dictionary$2(System.String,Kusto.Data.IntelliSense.CslCommand).ctor),parser.m_rulesProvider=this.m_rulesProvider,parser.Results=Kusto.Cloud.Platform.Utils.ExtendedEnumerable.SafeFastAny$2(Kusto.Data.IntelliSense.CslCommand,this.Results)?($t=Kusto.Data.IntelliSense.CslCommand,System.Linq.Enumerable.from(this.Results,$t).toList($t)):new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand).ctor),parser}}});Bridge.ns("Kusto.Data.IntelliSense.CslCommandParser",$asm.$);Bridge.apply($asm.$.Kusto.Data.IntelliSense.CslCommandParser,{f1:function(t){return t},f2:function(f){return f},f3:function(f){return(f||"")+"()"},f4:function(c){return c.Text},f5:function(c){return c}});Bridge.define("Kusto.Data.IntelliSense.CslCommandParser.CslCommandTokenizer",{$kind:"nested class",statics:{methods:{GetCommands:function(text){var $t,$t1,result=new(System.Collections.Generic.List$1(Kusto.Data.IntelliSense.CslCommand).ctor),i,ch,commandLength;if(System.String.isNullOrEmpty(text))return result;var command=null,mode=0,endOfStream=!1,expectedNewLine=0,chars=($t=System.Char,System.Linq.Enumerable.from(text,$t).ToArray($t));for(i=0;i<chars.length;i=i+1|0){ch=chars[System.Array.index(i,chars)];endOfStream=i===(chars.length-1|0);endOfStream&&(mode===0&&(command=($t1=new Kusto.Data.IntelliSense.CslCommand,$t1.RelativeStart=i,$t1)),mode=2);switch(mode){case 0:command=($t1=new Kusto.Data.IntelliSense.CslCommand,$t1.RelativeStart=i,$t1);mode=1;break;case 1:(ch===13||ch===10)&&(expectedNewLine=ch,mode=2);break;case 2:if((ch===10||ch===13)&&chars[System.Array.index(i-1|0,chars)]===ch&&(ch=expectedNewLine),ch===expectedNewLine||endOfStream){if(command!=null){while(!endOfStream){if(chars[System.Array.index(i+1|0,chars)]===13||chars[System.Array.index(i+1|0,chars)]===10)i=i+1|0;else break;endOfStream=i===(chars.length-1|0)}commandLength=(i-command.RelativeStart|0)+1|0;command.Text=text.substr(command.RelativeStart,commandLength);command.Length=commandLength;command.IsRunnable=!System.String.isNullOrWhiteSpace(command.Text);result.add(command)}mode=0;command=null}else System.Char.isWhiteSpace(String.fromCharCode(ch))||(mode=1);break}}return result}}}});Bridge.define("Kusto.Data.IntelliSense.CslCommandToken",{inherits:[System.ICloneable],props:{AbsolutePositionBias:0,Value:null,TokenKind:0,AbsoluteStart:{get:function(){return this.RelativeStart+this.AbsolutePositionBias|0}},AbsoluteEnd:{get:function(){return this.RelativeEnd+this.AbsolutePositionBias|0}},RelativeStart:0,Length:0,RelativeEnd:{get:function(){return this.RelativeStart+this.Length|0}}},alias:["clone","System$ICloneable$clone"],ctors:{ctor:function(value,absolutePositionBias,tokenKind){this.$initialize();this.Value=value;this.TokenKind=tokenKind;this.AbsolutePositionBias=absolutePositionBias}},methods:{CompareTo:function(other){return other==null?1:this.RelativeStart===other.RelativeStart?0:this.RelativeStart<other.RelativeStart?-1:1},clone:function(){var $t;return $t=new Kusto.Data.IntelliSense.CslCommandToken(this.Value,this.AbsolutePositionBias,this.TokenKind),$t.RelativeStart=this.RelativeStart,$t.Length=this.Length,$t},equals:function(obj){var other=Bridge.as(obj,Kusto.Data.IntelliSense.CslCommandToken);return other==null?!1:Bridge.referenceEquals(this.Value,other.Value)&&this.TokenKind===other.TokenKind&&this.RelativeStart===other.RelativeStart&&this.RelativeEnd===other.RelativeEnd&&this.AbsolutePositionBias===other.AbsolutePositionBias},getHashCode:function(){return Bridge.getHashCode(this.Value)^Bridge.getHashCode(this.TokenKind)^this.RelativeStart^this.RelativeEnd^this.AbsolutePositionBias}}});Bridge.define("Kusto.Data.IntelliSense.CslCommandToken.Kind",{$kind:"nested enum",statics:{fields:{TableToken:2,TableColumnToken:4,OperatorToken:8,SubOperatorToken:16,CalculatedColumnToken:32,StringLiteralToken:64,FunctionNameToken:128,UnknownToken:256,CommentToken:512,PlainTextToken:1024,DataTypeToken:2048,ControlCommandToken:4096,CommandPartToken:8192,QueryParametersToken:16384,CslCommandToken:32768,LetVariablesToken:65536,PluginToken:131072,BracketRangeToken:262144,ClientDirectiveToken:524288,IsRecognizedEntity:536870912,IsMismatchedTokenValue:1073741824}},$flags:!0});Bridge.define("Kusto.Data.IntelliSense.CslDocumentation",{statics:{fields:{s_instance:null},props:{Instance:{get:function(){return Kusto.Data.IntelliSense.CslDocumentation.s_instance==null&&(Kusto.Data.IntelliSense.CslDocumentation.s_instance=new Kusto.Data.IntelliSense.CslDocumentation,Kusto.Data.IntelliSense.CslDocumentation.s_instance.Initialize()),Kusto.Data.IntelliSense.CslDocumentation.s_instance}}},methods:{TrimFunctionParameters:function(signature){var parenStart=System.String.indexOf(signature,String.fromCharCode(40));return parenStart>0?signature.substr(0,parenStart):signature}}},fields:{m_documentation:null},props:{Topics:{get:function(){return this.m_documentation==null?System.Linq.Enumerable.empty():System.Linq.Enumerable.from(this.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).select($asm.$.Kusto.Data.IntelliSense.CslDocumentation.f1)}}},ctors:{init:function(){this.m_documentation=new(System.Collections.Generic.Dictionary$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation).ctor)}},methods:{AddTopic:function(topic){var key={Item1:topic.TokenKind,Item2:topic.Name.toLowerCase()};this.m_documentation.setItem(key,topic)},GetTopic:function(option){if(option.Kind===Kusto.Data.IntelliSense.OptionKind.Operator)return this.GetTopic$1(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,option.Value);else if(option.Kind===Kusto.Data.IntelliSense.OptionKind.FunctionAggregation||option.Kind===Kusto.Data.IntelliSense.OptionKind.FunctionScalar)return this.GetTopic$1(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,Kusto.Data.IntelliSense.CslDocumentation.TrimFunctionParameters(option.Value));return null},GetTopic$1:function(tokenKind,name){var key={Item1:tokenKind,Item2:name.toLowerCase()},result={};return this.m_documentation.tryGetValue(key,result),result.v},GetTopicByMarkdownSource:function(markdownSource){var $t,kvp;if(System.String.isNullOrWhiteSpace(markdownSource))return null;$t=Bridge.getEnumerator(this.m_documentation);try{while($t.moveNext())if(kvp=$t.Current,Bridge.referenceEquals(kvp.value.MarkdownSource,markdownSource))return kvp.value}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return null},GetTopicByName:function(name){var $t,kvp;if(System.String.isNullOrWhiteSpace(name))return null;$t=Bridge.getEnumerator(this.m_documentation);try{while($t.moveNext())if(kvp=$t.Current,Bridge.referenceEquals(kvp.key.Item2,name))return kvp.value}finally{Bridge.is($t,System.IDisposable)&&$t.System$IDisposable$Dispose()}return null},equals:function(obj){if(obj==null)return!1;var other=Bridge.as(obj,Kusto.Data.IntelliSense.CslDocumentation);return other==null?!1:this.m_documentation.Count!==other.m_documentation.Count?!1:System.Linq.Enumerable.from(other.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).except(this.m_documentation).any()?!1:System.Linq.Enumerable.from(this.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).except(other.m_documentation).any()?!1:!0},getHashCode:function(){return Bridge.getHashCode(this.m_documentation)},Initialize:function(){System.Linq.Enumerable.from(this.m_documentation,System.Collections.Generic.KeyValuePair$2(System.Tuple$2(Kusto.Data.IntelliSense.CslCommandToken.Kind,System.String),Kusto.Data.IntelliSense.CslTopicDocumentation)).any()||(this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!~","Filters a record set for data that does not match a case-insensitive string.",'The following table provides a comparison of the `==` (equals) operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`==`](equals-cs-operator.md)|Equals |Yes|`"aBc" == "aBc"`|\r\n|[`!=`](not-equals-cs-operator.md)|Not equals |Yes |`"abc" != "ABC"`|\r\n|[`=~`](equals-operator.md) |Equals |No |`"abc" =~ "ABC"`|\r\n|[`!~`](not-equals-operator.md) |Not equals |No |`"aBc" !~ "xyz"`|\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `==`, not `=~`.\r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `!~` `(`*expression*`)` \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where (State !~ "texas") and (event_count > 3000)\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|KANSAS|3,166|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-equals-operator","not-equals-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!=","Filters a record set for data that does not match a case-sensitive string.",'The following table provides a comparison of the `==` (equals) operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`==`](equals-cs-operator.md)|Equals |Yes|`"aBc" == "aBc"`|\r\n|[`!=`](not-equals-cs-operator.md)|Not equals |Yes |`"abc" != "ABC"`|\r\n|[`=~`](equals-operator.md) |Equals |No |`"abc" =~ "ABC"`|\r\n|[`!~`](not-equals-operator.md) |Not equals |No |`"aBc" !~ "xyz"`|\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `==`, not `=~`.\r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `!=` `(`*list of scalar expressions*`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where (State != "FLORIDA") and (event_count > 4000)\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|TEXAS|4,701|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-equals-cs-operator","not-equals-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!between","Matches the input that is outside the inclusive range.","```\r\nTable1 | where Num1 !between (1 .. 10)\r\nTable1 | where Time !between (datetime(2017-01-01) .. datetime(2017-01-01))\r\n```\r\n\r\n`!between` can operate on any numeric, datetime, or timespan expression.\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *expr* `!between` `(`*leftRange*` .. `*rightRange*`)`   \r\n\r\nIf *expr* expression is datetime - another syntactic sugar syntax is provided:\r\n\r\n*T* `|` `where` *expr* `!between` `(`*leftRangeDateTime*` .. `*rightRangeTimespan*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be matched.\r\n* *expr* - the expression to filter.\r\n* *leftRange* - expression of the left range (inclusive).\r\n* *rightRange* - expression of the right range (inclusive).\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate of (*expr* < *leftRange* or *expr* > *rightRange*) evaluates to `true`.","### Filter numeric values   \r\n\r\n```\r\nrange x from 1 to 10 step 1\r\n| where x !between (5 .. 9)\r\n```\r\n\r\n|x|\r\n|---|\r\n|1|\r\n|2|\r\n|3|\r\n|4|\r\n|10|\r\n\r\n### Filter datetime  \r\n\r\n```\r\nStormEvents\r\n| where StartTime !between (datetime(2007-07-27) .. datetime(2007-07-30))\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|58590|\r\n\r\n```\r\nStormEvents\r\n| where StartTime !between (datetime(2007-07-27) .. 3d)\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|58590|","https://docs.microsoft.com/azure/data-explorer/kusto/query/notbetweenoperator","notbetweenoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!contains","Filters a record set for data that does not include a case-sensitive string. `contains` searches for characters rather than [terms](datatypes-string-operators.md#what-is-a-term) of three or more characters. The query scans the values in the column, which is slower than looking up a term in a term index.",'The following table provides a comparison of the `contains` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`contains`](contains-operator.md) |RHS occurs as a subsequence of LHS |No |`"FabriKam" contains "BRik"`|\r\n|[`!contains`](not-contains-operator.md) |RHS doesn\'t occur in LHS |No |`"Fabrikam" !contains "xyz"`|\r\n|[`contains_cs`](contains-cs-operator.md) |RHS occurs as a subsequence of LHS |Yes |`"FabriKam" contains_cs "Kam"`|\r\n|[`!contains_cs`](not-contains-cs-operator.md)   |RHS doesn\'t occur in LHS |Yes |`"Fabrikam" !contains_cs "Kam"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `contains_cs`, not `contains`.\r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. Also, `has` works faster than `contains`, `startswith`, or `endswith`, however it is not as precise and could provide unwanted records.\r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n### Case insensitive syntax\r\n\r\n*T* `|` `where` *Column* `!contains` `(`*Expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !contains "kan"\r\n    | where event_count > 3000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|TEXAS|4701|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-contains-operator","not-contains-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!contains_cs","Filters a record set for data that does not include a case-sensitive string. `contains` searches for characters rather than [terms](datatypes-string-operators.md#what-is-a-term) of three or more characters. The query scans the values in the column, which is slower than looking up a term in a term index.",'The following table provides a comparison of the `contains` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`contains`](contains-operator.md) |RHS occurs as a subsequence of LHS |No |`"FabriKam" contains "BRik"`|\r\n|[`!contains`](not-contains-operator.md) |RHS doesn\'t occur in LHS |No |`"Fabrikam" !contains "xyz"`|\r\n|[`contains_cs`](contains-cs-operator.md) |RHS occurs as a subsequence of LHS |Yes |`"FabriKam" contains_cs "Kam"`|\r\n|[`!contains_cs`](not-contains-cs-operator.md)   |RHS doesn\'t occur in LHS |Yes |`"Fabrikam" !contains_cs "Kam"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `contains_cs`, not `contains`.\r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. Also, `has` works faster than `contains`, `startswith`, or `endswith`, however it is not as precise and could provide unwanted records.\r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n### Case-sensitive syntax\r\n\r\n*T* `|` `where` *Column* `!contains_cs` `(`*Expression*`)` \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !contains_cs "AS"\r\n    | count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|-----|\r\n|59|\r\n\r\n```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !contains_cs "TEX"\r\n    | where event_count > 3000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|KANSAS|3,166|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-contains-cs-operator","not-contains-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!endswith","Filters a record set for data that excludes a case-insensitive ending string.",'The following table provides a comparison of the `endswith` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`endswith`](endswith-operator.md) |RHS is a closing subsequence of LHS |No |`"Fabrikam" endswith "Kam"`|\r\n|[`!endswith`](not-endswith-operator.md) |RHS isn\'t a closing subsequence of LHS |No |`"Fabrikam" !endswith "brik"`|\r\n|[`endswith_cs`](endswith-cs-operator.md) |RHS is a closing subsequence of LHS |Yes |`"Fabrikam" endswith_cs "kam"`|\r\n|[`!endswith_cs`](not-endswith-cs-operator.md) |RHS isn\'t a closing subsequence of LHS |Yes |`"Fabrikam" !endswith_cs "brik"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `endswith_cs`, not `endswith`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `!endswith` `(`*expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !endswith "is"\r\n    | where event_count > 2000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|TEXAS|4701|\r\n|KANSAS|3166|\r\n|IOWA|2337|\r\n|MISSOURI|2016|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-endswith-operator","not-endswith-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!endswith_cs","Filters a record set for data that does not contain a case-insensitive ending string.",'The following table provides a comparison of the `endswith` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`endswith`](endswith-operator.md) |RHS is a closing subsequence of LHS |No |`"Fabrikam" endswith "Kam"`|\r\n|[`!endswith`](not-endswith-operator.md) |RHS isn\'t a closing subsequence of LHS |No |`"Fabrikam" !endswith "brik"`|\r\n|[`endswith_cs`](endswith-cs-operator.md) |RHS is a closing subsequence of LHS |Yes |`"Fabrikam" endswith_cs "kam"`|\r\n|[`!endswith_cs`](not-endswith-cs-operator.md) |RHS isn\'t a closing subsequence of LHS |Yes |`"Fabrikam" !endswith_cs "brik"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `endswith_cs`, not `endswith`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `!endswith_cs` `(`*expression*`)`  \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !endswith_cs "AS"\r\n    | count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|-----|\r\n|64|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-endswith-cs-operator","not-endswith-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!has","Filters a record set for data that does not have a matching case-insensitive string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `has` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`has`](has-operator.md) |Right-hand-side (RHS) is a whole term in left-hand-side (LHS) |No |`"North America" has "america"`|\r\n|[`!has`](not-has-operator.md) |RHS isn\'t a full term in LHS |No |`"North America" !has "amer"`|\r\n|[`has_cs`](has-cs-operator.md) |RHS is a whole term in LHS |Yes |`"North America" has_cs "America"`|\r\n|[`!has_cs`](not-has-cs-operator.md) |RHS isn\'t a full term in LHS |Yes |`"North America" !has_cs "amer"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `has_cs`, not `has`.\r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `!has` `(`*Expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !has "NEW"\r\n    | where event_count > 3000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|TEXAS|4,701|\r\n|KANSAS|3,166|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-has-operator","not-has-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!has_cs","Filters a record set for data that does not have a matching case-sensitive string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `has` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`has`](has-operator.md) |Right-hand-side (RHS) is a whole term in left-hand-side (LHS) |No |`"North America" has "america"`|\r\n|[`!has`](not-has-operator.md) |RHS isn\'t a full term in LHS |No |`"North America" !has "amer"`|\r\n|[`has_cs`](has-cs-operator.md) |RHS is a whole term in LHS |Yes |`"North America" has_cs "America"`|\r\n|[`!has_cs`](not-has-cs-operator.md) |RHS isn\'t a full term in LHS |Yes |`"North America" !has_cs "amer"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `has_cs`, not `has`.\r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `!has_cs` `(`*Expression*`)`  \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !has_cs "new"\r\n    | count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|-----|\r\n|67|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-has-cs-operator","not-has-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!hasprefix","Filters a record set for data that does not include a case-insensitive starting string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `hasprefix` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`hasprefix`](hasprefix-operator.md) |RHS is a term prefix in LHS |No |`"North America" hasprefix "ame"`|\r\n|[`!hasprefix`](not-hasprefix-operator.md) |RHS isn\'t a term prefix in LHS |No |`"North America" !hasprefix "mer"`|\r\n|[`hasprefix_cs`](hasprefix-cs-operator.md) |RHS is a term prefix in LHS |Yes |`"North America" hasprefix_cs "Ame"`|\r\n|[`!hasprefix_cs`](not-hasprefix-cs-operator.md) |RHS isn\'t a term prefix in LHS |Yes |`"North America" !hasprefix_cs "CA"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hasprefix_cs`, not `hasprefix`.\r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `!hasprefix` `(`*Expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !hasprefix "N"\r\n    | where event_count > 2000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|TEXAS|4701|\r\n|KANSAS|3166|\r\n|IOWA|2337|\r\n|ILLINOIS|2022|\r\n|MISSOURI|2016|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-hasprefix-operator","not-hasprefix-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!hasprefix_cs","Filters a record set for data that does not have a case-sensitive starting string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`hasprefix`](hasprefix-operator.md) |RHS is a term prefix in LHS |No |`"North America" hasprefix "ame"`|\r\n|[`!hasprefix`](not-hasprefix-operator.md) |RHS isn\'t a term prefix in LHS |No |`"North America" !hasprefix "mer"`|\r\n|[`hasprefix_cs`](hasprefix-cs-operator.md) |RHS is a term prefix in LHS |Yes |`"North America" hasprefix_cs "Ame"`|\r\n|[`!hasprefix_cs`](not-hasprefix-cs-operator.md) |RHS isn\'t a term prefix in LHS |Yes |`"North America" !hasprefix_cs "CA"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hasprefix_cs`, not `hasprefix`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `!hasprefix_cs` `(`*Expression*`)`  \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !hasprefix_cs "P"\r\n    | count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|-----|\r\n|64|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-hasprefix-cs-operator","not-hasprefix-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!hassuffix","Filters a record set for data that does not have a case-insensitive ending string.`has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `hassuffix` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`hassuffix`](hassuffix-operator.md) |RHS is a term suffix in LHS |No |`"North America" hassuffix "ica"`|\r\n|[`!hassuffix`](not-hassuffix-operator.md) |RHS isn\'t a term suffix in LHS |No |`"North America" !hassuffix "americ"`|\r\n|[`hassuffix_cs`](hassuffix-cs-operator.md)  |RHS is a term suffix in LHS |Yes |`"North America" hassuffix_cs "ica"`|\r\n|[`!hassuffix_cs`](not-hassuffix-cs-operator.md) |RHS isn\'t a term suffix in LHS |Yes |`"North America" !hassuffix_cs "icA"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hassuffix_cs`, not `hassuffix`. \r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `!hassuffix` `(`*Expression*`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !hassuffix "A"\r\n    | where event_count > 2000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|TEXAS|4701|\r\n|KANSAS|3166|\r\n|ILLINOIS|2022|\r\n|MISSOURI|2016|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-hassuffix-operator","not-hassuffix-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!hassuffix_cs","Filters a record set for data that does not have a case-sensitive ending string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `hassuffix` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`hassuffix`](hassuffix-operator.md) |RHS is a term suffix in LHS |No |`"North America" hassuffix "ica"`|\r\n|[`!hassuffix`](not-hassuffix-operator.md) |RHS isn\'t a term suffix in LHS |No |`"North America" !hassuffix "americ"`|\r\n|[`hassuffix_cs`](hassuffix-cs-operator.md)  |RHS is a term suffix in LHS |Yes |`"North America" hassuffix_cs "ica"`|\r\n|[`!hassuffix_cs`](not-hassuffix-cs-operator.md) |RHS isn\'t a term suffix in LHS |Yes |`"North America" !hassuffix_cs "icA"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hassuffix_cs`, not `hassuffix`. \r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `!hassuffix_cs` `(`*Expression*`)`  \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !hassuffix_cs "AS"\r\n    | where event_count > 2000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|IOWA|2337|\r\n|ILLINOIS|2022|\r\n|MISSOURI|2016|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-hassuffix-cs-operator","not-hassuffix-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!in","Filters a record set for data without a case-sensitive string.",'The following table provides a comparison of the `has` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`in`](in-cs-operator.md) |Equals to one of the elements |Yes |`"abc" in ("123", "345", "abc")`|\r\n|[`!in`](not-in-cs-operator.md) |Not equals to any of the elements |Yes | `"bca" !in ("123", "345", "abc")` |\r\n|[`in~`](inoperator.md) |Equals to any of the elements |No | `"Abc" in~ ("123", "345", "abc")` |\r\n|[`!in~`](not-in-operator.md) |Not equals to any of the elements |No | `"bCa" !in~ ("123", "345", "ABC")` |\r\n\r\n> [!NOTE]\r\n>\r\n> * In tabular expressions, the first column of the result set is selected.\r\n> * The expression list can produce up to `1,000,000` values.\r\n> * Nested arrays are flattened into a single list of values. For example, `x in (dynamic([1,[2,3]]))` becomes `x in (1,2,3)`.\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `in`, not `in~`. \r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `!in` `(`*list of scalar expressions*`)`\r\n*T* `|` `where` *col* `!in` `(`*tabular expression*`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *list of expressions* - A comma-separated list of tabular, scalar, or literal expressions.\r\n* *tabular expression* - A tabular expression that has a set of values. If the expression has multiple columns, the first column is used.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents \r\n| where State !in ("FLORIDA", "GEORGIA", "NEW YORK") \r\n| count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|---|\r\n|54291|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-in-cs-operator","not-in-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!in~","Filters a record set for data without a case-insensitive string.",'The following table provides a comparison of the `has` operators:.\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`in`](in-cs-operator.md) |Equals to one of the elements |Yes |`"abc" in ("123", "345", "abc")`|\r\n|[`!in`](not-in-cs-operator.md) |Not equals to any of the elements |Yes | `"bca" !in ("123", "345", "abc")` |\r\n|[`in~`](inoperator.md) |Equals to any of the elements |No | `"Abc" in~ ("123", "345", "abc")` |\r\n|[`!in~`](not-in-operator.md) |Not equals to any of the elements |No | `"bCa" !in~ ("123", "345", "ABC")` |\r\n\r\n> [!NOTE]\r\n>\r\n> * In tabular expressions, the first column of the result set is selected.\r\n> * The expression list can produce up to `1,000,000` values.\r\n> * Nested arrays are flattened into a single list of values. For example, `x in (dynamic([1,[2,3]]))` becomes `x in (1,2,3)`.\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `in`, not `in~`. \r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `!in~` `(`*list of scalar expressions*`)`  \r\n*T* `|` `where` *col* `!in~` `(`*tabular expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *list of expressions* - A comma-separated list of tabular, scalar, or literal expressions.\r\n* *tabular expression* - A tabular expression that has a set of values. If the expression has multiple columns, the first column is used.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents \r\n| where State !in~ ("Florida", "Georgia", "New York") \r\n| count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|---|\r\n|54,291|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-in-operator","not-in-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!startswith","Filters a record set retrieving data that does not start a case-insensitive search string.",'The following table provides a comparison of the `startswith` operators:\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table below:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`startswith`](startswith-operator.md) |RHS is an initial subsequence of LHS |No |`"Fabrikam" startswith "fab"`|\r\n|[`!startswith`](not-startswith-operator.md) |RHS isn\'t an initial subsequence of LHS |No |`"Fabrikam" !startswith "kam"`|\r\n|[`startswith_cs`](startswith-cs-operator.md)  |RHS is an initial subsequence of LHS |Yes |`"Fabrikam" startswith_cs "Fab"`|\r\n|[`!startswith_cs`](not-startswith-cs-operator.md) |RHS isn\'t an initial subsequence of LHS |Yes |`"Fabrikam" !startswith_cs "fab"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hassuffix_cs`, not `hassuffix`. \r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `!startswith` `(`*expression*`)` \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !startswith "i"\r\n    | where event_count > 2000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|TEXAS|4701|\r\n|KANSAS|3166|\r\n|MISSOURI|2016|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-startswith-operator","not-startswith-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"!startswith_cs","Filters a record set for data that does not start with a case-sensitive search string.",'The following table provides a comparison of the `startswith` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`startswith`](startswith-operator.md) |RHS is an initial subsequence of LHS |No |`"Fabrikam" startswith "fab"`|\r\n|[`!startswith`](not-startswith-operator.md) |RHS isn\'t an initial subsequence of LHS |No |`"Fabrikam" !startswith "kam"`|\r\n|[`startswith_cs`](startswith-cs-operator.md)  |RHS is an initial subsequence of LHS |Yes |`"Fabrikam" startswith_cs "Fab"`|\r\n|[`!startswith_cs`](not-startswith-cs-operator.md) |RHS isn\'t an initial subsequence of LHS |Yes |`"Fabrikam" !startswith_cs "fab"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hassuffix_cs`, not `hassuffix`. \r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `!startswith_cs` `(`*expression*`)`  \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State !startswith_cs "I"\r\n    | where event_count > 2000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|TEXAS|4701|\r\n|KANSAS|3166|\r\n|MISSOURI|2016|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/not-startswith-cs-operator","not-startswith-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"=~","Filters a record set for data with a case-insensitive string.",'The following table provides a comparison of the `==` (equals) operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`==`](equals-cs-operator.md)|Equals |Yes|`"aBc" == "aBc"`|\r\n|[`!=`](not-equals-cs-operator.md)|Not equals |Yes |`"abc" != "ABC"`|\r\n|[`=~`](equals-operator.md) |Equals |No |`"abc" =~ "ABC"`|\r\n|[`!~`](not-equals-operator.md) |Not equals |No |`"aBc" !~ "xyz"`|\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `==`, not `=~`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax \r\n\r\n*T* `|` `where` *col* `=~` `(`*expression*`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | where State =~ "kansas"\r\n    | count \r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|---|\r\n|3,166|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/equals-operator","equals-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"==","Filters a record set for data matching a case-sensitive string.",'The following table provides a comparison of the `==` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`==`](equals-cs-operator.md)|Equals |Yes|`"aBc" == "aBc"`|\r\n|[`!=`](not-equals-cs-operator.md)|Not equals |Yes |`"abc" != "ABC"`|\r\n|[`=~`](equals-operator.md) |Equals |No |`"abc" =~ "ABC"`|\r\n|[`!~`](not-equals-operator.md) |Not equals |No |`"aBc" !~ "xyz"`|\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `==`, not `=~`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `==` `(`*expressions`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | where State == "kansas"\r\n    | count \r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|---|\r\n|0|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/equals-cs-operator","equals-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"abs","Calculates the absolute value of the input.","## Syntax\r\n\r\n`abs(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: An integer or real number, or a timespan value.\r\n\r\n## Returns\r\n\r\n* Absolute value of x.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/abs-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"acos","Returns the angle whose cosine is the specified number (the inverse operation of [`cos()`](cosfunction.md)).","## Syntax\r\n\r\n`acos(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number in range [-1, 1].\r\n\r\n## Returns\r\n\r\n* The value of the arc cosine of `x`\r\n* `null` if `x` < -1 or `x` > 1","","https://docs.microsoft.com/azure/data-explorer/kusto/query/acosfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"active_users_count","Calculates distinct count of values, where each value has appeared in at least a minimum number of periods in a lookback period.",'Useful for calculating distinct counts of "fans" only,  while not including appearances of "non-fans". A user is counted as a "fan" only if it was active during the lookback period. The lookback period is only used to determine whether a user is considered `active` ("fan") or not. The aggregation itself doesn\'t include users from the lookback window. In comparison, the [sliding_window_counts](sliding-window-counts-plugin.md) aggregation is performed over a sliding window of the lookback period.\r\n\r\n```\r\nT | evaluate active_users_count(id, datetime_column, startofday(ago(30d)), startofday(now()), 7d, 1d, 2, 7d, dim1, dim2, dim3)\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| evaluate` `active_users_count(`*IdColumn*`,` *TimelineColumn*`,` *Start*`,` *End*`,` *LookbackWindow*`,` *Period*`,` *ActivePeriodsCount*`,` *Bin* `,` [*dim1*`,` *dim2*`,` ...]`)`\r\n\r\n## Arguments\r\n\r\n* *T*: The input tabular expression.\r\n* *IdColumn*: The name of the column with ID values that represent user activity.\r\n* *TimelineColumn*: The name of the column that represents timeline.\r\n* *Start*: (optional) Scalar with value of the analysis start period.\r\n* *End*: (optional) Scalar with value of the analysis end period.\r\n* *LookbackWindow*: A sliding time window defining a period where user appearance is checked. Lookback period starts at ([current appearance] - [lookback window]) and ends on ([current appearance]).\r\n* *Period*: Scalar constant timespan to count as single appearance (a user will be counted as active if it appears in at least distinct ActivePeriodsCount of this timespan.\r\n* *ActivePeriodsCount*: Minimal number of distinct active periods to decide if user is active. Active users are those users who appeared in at least (equal or greater than) active periods count.\r\n* *Bin*: Scalar constant value of the analysis step period. Can be a numeric/datetime/timestamp value, or a string that is `week`/`month`/`year`. All periods will be the corresponding [startofweek](startofweekfunction.md)/[startofmonth](startofmonthfunction.md)/[startofyear](startofyearfunction.md) functions.\r\n* *dim1*, *dim2*, ...: (optional) list of the dimensions columns that slice the activity metrics calculation.\r\n\r\n## Returns\r\n\r\nReturns a table that has distinct count values for IDs that have appeared in ActivePeriodCounts in the following periods: the lookback period, each timeline period, and each existing dimensions combination.\r\n\r\nOutput table schema is:\r\n\r\n|*TimelineColumn*|dim1|..|dim_n|dcount_values|\r\n|---|---|---|---|---|\r\n|type: as of *TimelineColumn*|..|..|..|long|','Calculate weekly number of distinct users that appeared in at least three different days over a period of prior eight days. Period of analysis: July 2018.\r\n\r\n```\r\nlet Start = datetime(2018-07-01);\r\nlet End = datetime(2018-07-31);\r\nlet LookbackWindow = 8d;\r\nlet Period = 1d;\r\nlet ActivePeriods = 3;\r\nlet Bin = 7d; \r\nlet T =  datatable(User:string, Timestamp:datetime)\r\n[\r\n    "B",      datetime(2018-06-29),\r\n    "B",      datetime(2018-06-30),\r\n    "A",      datetime(2018-07-02),\r\n    "B",      datetime(2018-07-04),\r\n    "B",      datetime(2018-07-08),\r\n    "A",      datetime(2018-07-10),\r\n    "A",      datetime(2018-07-14),\r\n    "A",      datetime(2018-07-17),\r\n    "A",      datetime(2018-07-20),\r\n    "B",      datetime(2018-07-24)\r\n]; \r\nT | evaluate active_users_count(User, Timestamp, Start, End, LookbackWindow, Period, ActivePeriods, Bin)\r\n```\r\n\r\n|Timestamp|`dcount`|\r\n|---|---|\r\n|2018-07-01 00:00:00.0000000|1|\r\n|2018-07-15 00:00:00.0000000|1|\r\n\r\nA user is considered active if it fulfills both of the following criteria:\r\n\r\n* The user was seen in at least three distinct days (Period = 1d, ActivePeriods=3).\r\n* The user was seen in a lookback window of 8d before and including their current appearance.\r\n\r\n\r\nIn the illustration below, the only appearances that are active by this criteria are the following instances: User A on 7/20 and User B on 7/4 (see plugin results above).\r\nThe appearances of User B are included for the lookback window on 7/4, but not for the Start-End time range of 6/29-30.\r\n\r\n![Graph showing active users based on the loopback window and active period specified in the query.](images/queries/active-users-count.png)',"https://docs.microsoft.com/azure/data-explorer/kusto/query/active-users-count-plugin","active-users-count-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"activity_counts_metrics","Calculates useful activity metrics for each time window compared/aggregated to *all* previous time windows. Metrics include: total count values, distinct count values, distinct count of new values, and aggregated distinct count. Compare this plugin to [activity_metrics plugin](activity-metrics-plugin.md), in which every time window is compared to its previous time window only.","```\r\nT | evaluate activity_counts_metrics(id, datetime_column, startofday(ago(30d)), startofday(now()), 1d, dim1, dim2, dim3)\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| evaluate` `activity_counts_metrics(`*IdColumn*`,` *TimelineColumn*`,` *Start*`,` *End*`,` *Window* [`,` *Cohort*] [`,` *dim1*`,` *dim2*`,` ...] [`,` *Lookback*] `)`\r\n\r\n## Arguments\r\n\r\n* *T*: The input tabular expression.\r\n* *IdColumn*: The name of the column with ID values that represent user activity.\r\n* *TimelineColumn*: The name of the column that represents the timeline.\r\n* *Start*: Scalar with value of the analysis start period.\r\n* *End*: Scalar with value of the analysis end period.\r\n* *Window*: Scalar with value of the analysis window period. Can be either a numeric/datetime/timestamp value, or a string that is one of `week`/`month`/`year`, in which case all periods will be [startofweek](startofweekfunction.md)/[startofmonth](startofmonthfunction.md) or [startofyear](startofyearfunction.md).\r\n* *dim1*, *dim2*, ...: (optional) list of the dimensions columns that slice the activity metrics calculation.\r\n\r\n## Returns\r\n\r\nReturns a table that has: total count values, distinct count values, distinct count of new values, and aggregated distinct count for each time window.\r\n\r\nOutput table schema is:\r\n\r\n|`TimelineColumn`|`dim1`|...|`dim_n`|`count`|`dcount`|`new_dcount`|`aggregated_dcount`|\r\n|---|---|---|---|---|---|---|---|\r\n|type: as of *`TimelineColumn`*|..|..|..|long|long|long|long|\r\n\r\n* *`TimelineColumn`*: The time window start time.\r\n* *`count`*: The total records count in the time window and *dim(s)*\r\n* *`dcount`*: The distinct ID values count in the time window and *dim(s)*\r\n* *`new_dcount`*: The distinct ID values in the time window and *dim(s)* compared to all previous time windows.\r\n* *`aggregated_dcount`*: The total aggregated distinct ID values of *dim(s)* from first-time window to current (inclusive).","### Daily activity counts\r\n\r\nThe next query calculates daily activity counts for the provided input table\r\n\r\n```\r\nlet start=datetime(2017-08-01);\r\nlet end=datetime(2017-08-04);\r\nlet window=1d;\r\nlet T = datatable(UserId:string, Timestamp:datetime)\r\n[\r\n'A', datetime(2017-08-01),\r\n'D', datetime(2017-08-01), \r\n'J', datetime(2017-08-01),\r\n'B', datetime(2017-08-01),\r\n'C', datetime(2017-08-02),  \r\n'T', datetime(2017-08-02),\r\n'J', datetime(2017-08-02),\r\n'H', datetime(2017-08-03),\r\n'T', datetime(2017-08-03),\r\n'T', datetime(2017-08-03),\r\n'J', datetime(2017-08-03),\r\n'B', datetime(2017-08-03),\r\n'S', datetime(2017-08-03),\r\n'S', datetime(2017-08-04),\r\n];\r\n T \r\n | evaluate activity_counts_metrics(UserId, Timestamp, start, end, window)\r\n```\r\n\r\n|`Timestamp`|`count`|`dcount`|`new_dcount`|`aggregated_dcount`|\r\n|---|---|---|---|---|\r\n|2017-08-01 00:00:00.0000000|4|4|4|4|\r\n|2017-08-02 00:00:00.0000000|3|3|2|6|\r\n|2017-08-03 00:00:00.0000000|6|5|2|8|\r\n|2017-08-04 00:00:00.0000000|1|1|0|8|","https://docs.microsoft.com/azure/data-explorer/kusto/query/activity-counts-metrics-plugin","activity-counts-metrics-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"activity_engagement","Calculates activity engagement ratio based on ID column over a sliding timeline window.","activity_engagement plugin can be used for calculating DAU/WAU/MAU (daily/weekly/monthly activities).\r\n\r\n```\r\nT | evaluate activity_engagement(id, datetime_column, 1d, 30d)\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| evaluate` `activity_engagement(`*IdColumn*`,` *TimelineColumn*`,` [*Start*`,` *End*`,`] *InnerActivityWindow*`,` *OuterActivityWindow* [`,` *dim1*`,` *dim2*`,` ...]`)`\r\n\r\n## Arguments\r\n\r\n* *T*: The input tabular expression.\r\n* *IdColumn*: The name of the column with ID values that represent user activity.\r\n* *TimelineColumn*: The name of the column that represents timeline.\r\n* *Start*: (optional) Scalar with value of the analysis start period.\r\n* *End*: (optional) Scalar with value of the analysis end period.\r\n* *InnerActivityWindow*: Scalar with value of the inner-scope analysis window period.\r\n* *OuterActivityWindow*: Scalar with value of the outer-scope analysis window period.\r\n* *dim1*, *dim2*, ...: (optional) list of the dimensions columns that slice the activity metrics calculation.\r\n\r\n## Returns\r\n\r\nReturns a table that has a distinct count of ID values inside an inner-scope window, a distinct count of ID values inside an outer-scope window, and the activity ratio for each inner-scope window period, and for each existing dimensions combination.\r\n\r\nOutput table schema is:\r\n\r\n|TimelineColumn|dcount_activities_inner|dcount_activities_outer|activity_ratio|dim1|..|dim_n|\r\n|---|---|---|---|--|--|--|--|--|--|\r\n|type: as of *TimelineColumn*|long|long|double|..|..|..|","### DAU/WAU calculation\r\n\r\nThe following example calculates DAU/WAU (Daily Active Users / Weekly Active Users ratio) over a randomly generated data.\r\n\r\n```\r\n// Generate random data of user activities\r\nlet _start = datetime(2017-01-01);\r\nlet _end = datetime(2017-01-31);\r\nrange _day from _start to _end  step 1d\r\n| extend d = tolong((_day - _start)/1d)\r\n| extend r = rand()+1\r\n| extend _users=range(tolong(d*50*r), tolong(d*50*r+100*r-1), 1) \r\n| mv-expand id=_users to typeof(long) limit 1000000\r\n// Calculate DAU/WAU ratio\r\n| evaluate activity_engagement(['id'], _day, _start, _end, 1d, 7d)\r\n| project _day, Dau_Wau=activity_ratio*100 \r\n| render timechart \r\n```\r\n\r\n![Graph displaying the ratio of daily active users to weekly active users as specified in the query.](images/activity-engagement-plugin/activity-engagement-dau-wau.png)\r\n\r\n### DAU/MAU calculation\r\n\r\nThe following example calculates DAU/WAU (Daily Active Users / Weekly Active Users ratio) over a randomly generated data.\r\n\r\n```\r\n// Generate random data of user activities\r\nlet _start = datetime(2017-01-01);\r\nlet _end = datetime(2017-05-31);\r\nrange _day from _start to _end  step 1d\r\n| extend d = tolong((_day - _start)/1d)\r\n| extend r = rand()+1\r\n| extend _users=range(tolong(d*50*r), tolong(d*50*r+100*r-1), 1) \r\n| mv-expand id=_users to typeof(long) limit 1000000\r\n// Calculate DAU/MAU ratio\r\n| evaluate activity_engagement(['id'], _day, _start, _end, 1d, 30d)\r\n| project _day, Dau_Mau=activity_ratio*100 \r\n| render timechart \r\n```\r\n\r\n![Graph displaying the ratio of daily active users to monthly active users as specified in the query.](images/activity-engagement-plugin/activity-engagement-dau-mau.png)\r\n\r\n### DAU/MAU calculation with additional dimensions\r\n\r\nThe following example calculates DAU/WAU (Daily Active Users / Weekly Active Users ratio) over a randomly generated data with additional dimension (`mod3`).\r\n\r\n```\r\n// Generate random data of user activities\r\nlet _start = datetime(2017-01-01);\r\nlet _end = datetime(2017-05-31);\r\nrange _day from _start to _end  step 1d\r\n| extend d = tolong((_day - _start)/1d)\r\n| extend r = rand()+1\r\n| extend _users=range(tolong(d*50*r), tolong(d*50*r+100*r-1), 1) \r\n| mv-expand id=_users to typeof(long) limit 1000000\r\n| extend mod3 = strcat(\"mod3=\", id % 3)\r\n// Calculate DAU/MAU ratio\r\n| evaluate activity_engagement(['id'], _day, _start, _end, 1d, 30d, mod3)\r\n| project _day, Dau_Mau=activity_ratio*100, mod3 \r\n| render timechart \r\n```\r\n\r\n![Graph displaying the ratio of daily active users to monthly active users with modulo 3 as specified in the query.](images/activity-engagement-plugin/activity-engagement-dau-mau-mod3.png)","https://docs.microsoft.com/azure/data-explorer/kusto/query/activity-engagement-plugin","activity-engagement-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"activity_metrics","Calculates useful activity metrics based on the current period window compared to the previous period window. The metrics include distinct count values, distinct count of new values, retention rate, and churn rate. This plugin is different from [activity_counts_metrics plugin](activity-counts-metrics-plugin.md) in which every time window is compared to *all* previous time windows.","```\r\nT | evaluate activity_metrics(id, datetime_column, startofday(ago(30d)), startofday(now()), 1d, dim1, dim2, dim3)\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| evaluate` `activity_metrics(`*IdColumn*`,` *TimelineColumn*`,` [*Start*`,` *End*`,`] *Window* [`,` *dim1*`,` *dim2*`,` ...]`)`\r\n\r\n## Arguments\r\n\r\n* *T*: The input tabular expression.\r\n* *IdColumn*: The name of the column with ID values that represent user activity.\r\n* *TimelineColumn*: The name of the column that represents timeline.\r\n* *Start*: (optional) Scalar with value of the analysis start period.\r\n* *End*: (optional) Scalar with value of the analysis end period.\r\n* *Window*: Scalar with value of the analysis window period. Can be either a numeric, datetime, timestamp, or string value. Strings are either `week`, `month`, `year`, in which case all periods will be [startofweek](startofweekfunction.md), [startofmonth](startofmonthfunction.md), [startofyear](startofyearfunction.md) respectively.\r\n* *dim1*, *dim2*, ...: (optional) list of the dimensions columns that slice the activity metrics calculation.\r\n\r\n## Returns\r\n\r\nThe plugin returns a table with the distinct count values, distinct count of new values, retention rate, and churn rate for each timeline period, and for each existing dimensions combination.\r\n\r\nOutput table schema is:\r\n\r\n|*TimelineColumn*|dcount_values|dcount_newvalues|retention_rate|churn_rate|dim1|..|dim_n|\r\n|---|---|---|---|---|--|--|--|--|--|--|\r\n|type: as of *TimelineColumn*|long|long|double|double|..|..|..|\r\n\r\n### Notes\r\n\r\n***Retention Rate Definition***\r\n\r\n`Retention Rate` over a period is calculated as:\r\n\r\n> *number of customers returned during the period*\r\n> / (divided by)\r\n> *number customers at the beginning of the period*\r\n\r\nwhere the `# of customers returned during the period` is defined as:\r\n\r\n> *number of customers at end of period*\r\n> \\- (minus)\r\n> *number of new customers acquired during the period*\r\n\r\n`Retention Rate` can vary from 0.0 to 1.0\r\nThe higher score means the larger number of returning users.\r\n\r\n***Churn Rate Definition***\r\n\r\n`Churn Rate` over a period is calculated as:\r\n\r\n> *number of customers lost in the period*\r\n> / (divided by)\r\n> *number of customers at the beginning of the period*\r\n\r\nwhere the `# of customer lost in the period` is defined as:\r\n\r\n> *number of customers at the beginning of the period*\r\n> \\- (minus)\r\n> *number of customers at the end of the period*\r\n\r\n`Churn Rate` can vary from 0.0 to 1.0\r\nThe higher score means the larger number of users are NOT returning to the service.\r\n\r\n***Churn vs. Retention Rate***\r\n\r\nDerived from the definition of `Churn Rate` and `Retention Rate`, the following calculation is always true:\r\n\r\n> [`Retention Rate`] = 100.0% - [`Churn Rate`]","### Weekly retention rate and churn rate\r\n\r\nThe next query calculates retention and churn rate for week-over-week window.\r\n\r\n```\r\n// Generate random data of user activities\r\nlet _start = datetime(2017-01-02);\r\nlet _end = datetime(2017-05-31);\r\nrange _day from _start to _end  step 1d\r\n| extend d = tolong((_day - _start)/1d)\r\n| extend r = rand()+1\r\n| extend _users=range(tolong(d*50*r), tolong(d*50*r+200*r-1), 1)\r\n| mv-expand id=_users to typeof(long) limit 1000000\r\n//\r\n| evaluate activity_metrics(['id'], _day, _start, _end, 7d)\r\n| project _day, retention_rate, churn_rate\r\n| render timechart\r\n```\r\n\r\n|_day|retention_rate|churn_rate|\r\n|---|---|---|\r\n|2017-01-02 00:00:00.0000000|NaN|NaN|\r\n|2017-01-09 00:00:00.0000000|0.179910044977511|0.820089955022489|\r\n|2017-01-16 00:00:00.0000000|0.744374437443744|0.255625562556256|\r\n|2017-01-23 00:00:00.0000000|0.612096774193548|0.387903225806452|\r\n|2017-01-30 00:00:00.0000000|0.681141439205955|0.318858560794045|\r\n|2017-02-06 00:00:00.0000000|0.278145695364238|0.721854304635762|\r\n|2017-02-13 00:00:00.0000000|0.223172628304821|0.776827371695179|\r\n|2017-02-20 00:00:00.0000000|0.38|0.62|\r\n|2017-02-27 00:00:00.0000000|0.295519001701645|0.704480998298355|\r\n|2017-03-06 00:00:00.0000000|0.280387770320656|0.719612229679344|\r\n|2017-03-13 00:00:00.0000000|0.360628154795289|0.639371845204711|\r\n|2017-03-20 00:00:00.0000000|0.288008028098344|0.711991971901656|\r\n|2017-03-27 00:00:00.0000000|0.306134969325153|0.693865030674847|\r\n|2017-04-03 00:00:00.0000000|0.356866537717602|0.643133462282398|\r\n|2017-04-10 00:00:00.0000000|0.495098039215686|0.504901960784314|\r\n|2017-04-17 00:00:00.0000000|0.198296836982968|0.801703163017032|\r\n|2017-04-24 00:00:00.0000000|0.0618811881188119|0.938118811881188|\r\n|2017-05-01 00:00:00.0000000|0.204657727593507|0.795342272406493|\r\n|2017-05-08 00:00:00.0000000|0.517391304347826|0.482608695652174|\r\n|2017-05-15 00:00:00.0000000|0.143667296786389|0.856332703213611|\r\n|2017-05-22 00:00:00.0000000|0.199122325836533|0.800877674163467|\r\n|2017-05-29 00:00:00.0000000|0.063468992248062|0.936531007751938|\r\n\r\n![Table showing the calculated retention and churn rates per 7 days as specified in the query.](images/activity-metrics-plugin/activity-metrics-churn-and-retention.png)\r\n\r\n### Distinct values and distinct 'new' values\r\n\r\nThe next query calculates distinct values and 'new' values (IDs that didn't appear in previous time window) for week-over-week window.\r\n\r\n```\r\n// Generate random data of user activities\r\nlet _start = datetime(2017-01-02);\r\nlet _end = datetime(2017-05-31);\r\nrange _day from _start to _end  step 1d\r\n| extend d = tolong((_day - _start)/1d)\r\n| extend r = rand()+1\r\n| extend _users=range(tolong(d*50*r), tolong(d*50*r+200*r-1), 1)\r\n| mv-expand id=_users to typeof(long) limit 1000000\r\n//\r\n| evaluate activity_metrics(['id'], _day, _start, _end, 7d)\r\n| project _day, dcount_values, dcount_newvalues\r\n| render timechart\r\n```\r\n\r\n| _day | dcount_values | dcount_newvalues |\r\n|--|--|--|\r\n| 2017-01-02 00:00:00.0000000 | 630 | 630 |\r\n| 2017-01-09 00:00:00.0000000 | 738 | 575 |\r\n| 2017-01-16 00:00:00.0000000 | 1187 | 841 |\r\n| 2017-01-23 00:00:00.0000000 | 1092 | 465 |\r\n| 2017-01-30 00:00:00.0000000 | 1261 | 647 |\r\n| 2017-02-06 00:00:00.0000000 | 1744 | 1043 |\r\n| 2017-02-13 00:00:00.0000000 | 1563 | 432 |\r\n| 2017-02-20 00:00:00.0000000 | 1406 | 818 |\r\n| 2017-02-27 00:00:00.0000000 | 1956 | 1429 |\r\n| 2017-03-06 00:00:00.0000000 | 1593 | 848 |\r\n| 2017-03-13 00:00:00.0000000 | 1801 | 1423 |\r\n| 2017-03-20 00:00:00.0000000 | 1710 | 1017 |\r\n| 2017-03-27 00:00:00.0000000 | 1796 | 1516 |\r\n| 2017-04-03 00:00:00.0000000 | 1381 | 1008 |\r\n| 2017-04-10 00:00:00.0000000 | 1756 | 1162 |\r\n| 2017-04-17 00:00:00.0000000 | 1831 | 1409 |\r\n| 2017-04-24 00:00:00.0000000 | 1823 | 1164 |\r\n| 2017-05-01 00:00:00.0000000 | 1811 | 1353 |\r\n| 2017-05-08 00:00:00.0000000 | 1691 | 1246 |\r\n| 2017-05-15 00:00:00.0000000 | 1812 | 1608 |\r\n| 2017-05-22 00:00:00.0000000 | 1740 | 1017 |\r\n| 2017-05-29 00:00:00.0000000 | 960 | 756 |\r\n\r\n![Table showing the count of distinct values (dcount_values) and of new distinct values (dcount_newvalues) that didn](images/activity-metrics-plugin/activity-metrics-dcount-and-dcount-newvalues.png)","https://docs.microsoft.com/azure/data-explorer/kusto/query/activity-metrics-plugin","activity-metrics-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ago","Subtracts the given timespan from the current UTC clock time.","```\r\nago(1h)\r\nago(1d)\r\n```\r\n\r\nLike `now()`, this function can be used multiple times\r\nin a statement and the UTC clock time being referenced will be the same\r\nfor all instantiations.\r\n\r\n## Syntax\r\n\r\n`ago(`*a_timespan*`)`\r\n\r\n## Arguments\r\n\r\n* *[a_timespan](scalar-data-types/timespan.md)*: Interval to subtract from the current UTC clock time\r\n(`now()`).\r\n\r\n## Returns\r\n\r\n`now() - a_timespan`","All rows with a timestamp in the past hour:\r\n\r\n```\r\nT | where Timestamp > ago(1h)\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/agofunction","agofunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"arg_max","Finds a row in the group that maximizes *ExprToMaximize*, and returns the value of *ExprToReturn* (or `*` to return the entire row).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`arg_max` `(`*ExprToMaximize*`,` *\\** | *ExprToReturn*  [`,` ...]`)`\r\n\r\n## Arguments\r\n\r\n* *ExprToMaximize*: Expression that will be used for aggregation calculation.\r\n* *ExprToReturn*: Expression that will be used for returning the value when *ExprToMaximize* is\r\n  maximum. Expression to return may be a wildcard (*) to return all columns of the input table.\r\n\r\n## Returns\r\n\r\nFinds a row in the group that maximizes *ExprToMaximize*, and\r\nreturns the value of *ExprToReturn* (or `*` to return the entire row).","See examples for [arg_min()](arg-min-aggfunction.md) aggregation function.","https://docs.microsoft.com/azure/data-explorer/kusto/query/arg-max-aggfunction","arg-max-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"arg_min","Finds a row in the group that minimizes *ExprToMinimize*, and returns the value of *ExprToReturn* (or `*` to return the entire row).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`arg_min` `(`*ExprToMinimize*`,` *\\** | *ExprToReturn*  [`,` ...]`)`\r\n\r\n## Arguments\r\n\r\n* *ExprToMinimize*: Expression that will be used for aggregation calculation.\r\n* *ExprToReturn*: Expression that will be used for returning the value when *ExprToMinimize* is\r\n  minimum. Expression to return may be a wildcard (*) to return all columns of the input table.\r\n  \r\n\r\n## Null handling\r\n\r\nWhen *ExprToMinimize* is null for all rows in a group, one row in the group is picked. Otherwise, rows where *ExprToMinimize* is null are ignored.\r\n\r\n## Returns\r\n\r\nFinds a row in the group that minimizes *ExprToMinimize*, and returns the value of *ExprToReturn* (or `*` to return the entire row).",'Show cheapest supplier of each product:\r\n\r\n```\r\nSupplies | summarize arg_min(Price, Supplier) by Product\r\n```\r\n\r\nShow all the details, not just the supplier name:\r\n\r\n```\r\nSupplies | summarize arg_min(Price, *) by Product\r\n```\r\n\r\nFind the southernmost city in each continent, with its country:\r\n\r\n```\r\nPageViewLog \r\n| summarize (latitude, min_lat_City, min_lat_country)=arg_min(latitude, City, country) \r\n    by continent\r\n```\r\n\r\n![Table showing the southernmost city with its country as calculated by the query.](images/arg-min-aggfunction/arg-min.png)\r\nNull handling example:\r\n\r\n```\r\ndatatable(Fruit: string, Color: string, Version: int) [\r\n    "Apple", "Red", 1,\r\n    "Apple", "Green", int(null),\r\n    "Banana", "Yellow", int(null),\r\n    "Banana", "Green", int(null),\r\n    "Pear", "Brown", 1,\r\n    "Pear", "Green", 2,\r\n]\r\n| summarize arg_min(Version, *) by Fruit\r\n```\r\n\r\n|Fruit|Version|Color|\r\n|---|---|---|\r\n|Apple|1|Red|\r\n|Banana||Yellow|\r\n|Pear|1|Brown|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/arg-min-aggfunction","arg-min-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"around","Returns a `bool` value indicating if the first argument is within a range around the center value.","## Syntax\r\n\r\n`around(`*value*`,`*center*`,`*delta*`)`\r\n\r\n## Arguments\r\n\r\n* *value*: A number, date, or [timespan](scalar-data-types/timespan.md) that is evaluated.\r\n* *center*: A number, date, or [timespan](scalar-data-types/timespan.md) representing the center of the range defined as [(`center`-`delta`) .. (`center` + `delta`)].\r\n* *delta*: A number, or [timespan](scalar-data-types/timespan.md) representing the delta value of the range defined as [(`center`-`delta`) .. (`center` + `delta`)].\r\n\r\n## Returns\r\n\r\nReturns `true` if the value is within the range, `false` if the value is outside the range.\r\nReturns `null` if any of the arguments is `null`.\r\n\r\n## Example: Filtering values around a specific timestamp\r\n\r\nThe following example filters rows around specific timestamp.\r\n\r\n```\r\nrange dt \r\n    from datetime(2021-01-01 01:00) \r\n    to datetime(2021-01-01 02:00) \r\n    step 1min\r\n| where around(dt, datetime(2021-01-01 01:30), 1min)\r\n```\r\n\r\n|dt|\r\n|---|\r\n|2021-01-01 01:29:00.0000000|\r\n|2021-01-01 01:30:00.0000000|\r\n|2021-01-01 01:31:00.0000000|","","https://docs.microsoft.com/azure/data-explorer/kusto/query/around-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_concat","Concatenates many dynamic arrays to a single array.","## Syntax\r\n\r\n`array_concat(`*arr1*`[`, `*arr2*, ...]`)`\r\n\r\n## Arguments\r\n\r\n* *arr1...arrN*: Input arrays to be concatenated into a dynamic array. All arguments must be dynamic arrays (see [pack_array](packarrayfunction.md)).\r\n\r\n## Returns\r\n\r\nDynamic array of arrays with arr1, arr2, ... , arrN.","```\r\nrange x from 1 to 3 step 1\r\n| extend y = x * 2\r\n| extend z = y * 2\r\n| extend a1 = pack_array(x,y,z), a2 = pack_array(x, y)\r\n| project array_concat(a1, a2)\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|[1,2,4,1,2]|\r\n|[2,4,8,2,4]|\r\n|[3,6,12,3,6]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/arrayconcatfunction","arrayconcatfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_iif","Element-wise iif function on dynamic arrays.","Another alias: array_iff().\r\n\r\n## Syntax\r\n\r\n`array_iif(`*ConditionArray*, *IfTrue*, *IfFalse*]`)`\r\n\r\n## Arguments\r\n\r\n* *conditionArray*: Input array of *boolean* or numeric values, must be dynamic array.\r\n* *ifTrue*: Input array of values or primitive value - the result value(s) when the corresponding value of *ConditionArray* is *true*.\r\n* *ifFalse*: Input array of values or primitive value - the result value(s) when the corresponding value of *ConditionArray* is *false*.\r\n\r\n### Notes\r\n\r\n* The result length is the length of *conditionArray*.\r\n* Numeric condition value is treated as *condition* != *0*.\r\n* Non-numeric/null condition value will have null in the corresponding index of the result.\r\n* Missing values (in shorter length arrays) are treated as null.\r\n\r\n## Returns\r\n\r\nDynamic array of the values taken either from the *IfTrue* or *IfFalse* [array] values, according to the corresponding value of the Condition array.","```\r\nprint condition=dynamic([true,false,true]), l=dynamic([1,2,3]), r=dynamic([4,5,6]) \r\n| extend res=array_iif(condition, l, r)\r\n```\r\n\r\n|condition|l|r|res|\r\n|---|---|---|---|\r\n|[true, false, true]|[1, 2, 3]|[4, 5, 6]|[1, 5, 3]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/arrayifffunction","arrayifffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_index_of","Searches the array for the specified item, and returns its position.","## Syntax\r\n\r\n`array_index_of(`*array*,*lookup*`)`\r\n\r\n## Arguments\r\n\r\n* *array*: Input array to search.\r\n* *lookup*: Value to lookup. The value should be of type long, integer, double, datetime, timespan, decimal, string, or guid.\r\n* *start_index*: Search start position. A negative value will offset the starting search value from the end of the array by this many steps: abs(start_index). Optional.\r\n* *length*: Number of values to examine. A value of -1 means unlimited length. Optional.\r\n* *occurrence*: The number of the occurrence. Default 1. Optional.\r\n\r\n## Returns\r\n\r\nZero-based index position of lookup.\r\nReturns -1 if the value isn't found in the array.\r\n\r\nFor irrelevant inputs (*occurrence* < 0 or  *length* < -1) - returns *null*.",'```\r\nlet arr=dynamic(["this", "is", "an", "example", "an", "example"]);\r\nprint\r\n idx1 = array_index_of(arr,"an")    // lookup found in input string\r\n , idx2 = array_index_of(arr,"example",1,3) // lookup found in researched range \r\n , idx3 = array_index_of(arr,"example",1,2) // search starts from index 1, but stops after 2 values, so lookup can\'t be found\r\n , idx4 = array_index_of(arr,"is",2,4) // search starts after occurrence of lookup\r\n , idx5 = array_index_of(arr,"example",2,-1)  // lookup found\r\n , idx6 = array_index_of(arr, "an", 1, -1, 2)   // second occurrence found in input range\r\n , idx7 = array_index_of(arr, "an", 1, -1, 3)   // no third occurrence in input array\r\n , idx8 = array_index_of(arr, "an", -3)   // negative start index will look at last 3 elements\r\n , idx9 = array_index_of(arr, "is", -4)   // negative start index will look at last 3 elements\r\n```\r\n\r\n|idx1|idx2|idx3|idx4|idx5|idx6|idx7|idx8|idx9|\r\n|----|----|----|----|----|----|----|----|----|\r\n|2   |3   |-1  |-1   |3   |4   |-1  |4  |-1  |\r\n\r\n## See also\r\n\r\nIf you only want to check whether a value exists in an array,\r\nbut you are not interested in its position, you can use\r\n[set_has_element(`arr`, `value`)](sethaselementfunction.md). This function will improve the readability of your query. Both functions have the same performance.',"https://docs.microsoft.com/azure/data-explorer/kusto/query/arrayindexoffunction","arrayindexoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_length","Calculates the number of elements in a dynamic array.","## Syntax\r\n\r\n`array_length(`*array*`)`\r\n\r\n## Arguments\r\n\r\n* *array*: A `dynamic` value.\r\n\r\n## Returns\r\n\r\nThe number of elements in *array*, or `null` if *array* is not an array.","```\r\nprint array_length(parse_json('[1, 2, 3, \"four\"]')) == 4\r\n\r\nprint array_length(parse_json('[8]')) == 1\r\n\r\nprint array_length(parse_json('[{}]')) == 1\r\n\r\nprint array_length(parse_json('[]')) == 0\r\n\r\nprint array_length(parse_json('{}')) == null\r\n\r\nprint array_length(parse_json('21')) == null\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/arraylengthfunction","arraylengthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_reverse","Reverses the order of the elements in a dynamic array.","## Syntax\r\n\r\n`array_reverse(`*array*`)`\r\n\r\n## Arguments\r\n\r\n*array*: Input array to reverse.\r\n\r\n## Returns\r\n\r\nAn array that contains exactly the same elements as the input array, but in reverse order.",'```\r\nprint arr=dynamic(["this", "is", "an", "example"]) \r\n| project Result=array_reverse(arr)\r\n```\r\n\r\n|Result|\r\n|---|\r\n|["example","an","is","this"]|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/array-reverse-function","array-reverse-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_rotate_left","Rotates values inside a `dynamic` array to the left.","## Syntax\r\n\r\n`array_rotate_left(`*array*, *rotate_count*`)`\r\n\r\n## Arguments\r\n\r\n* *array*: Input array to rotate, must be dynamic array.\r\n* *rotate_count*: Integer specifying the number of positions that array elements will be rotated to the left. If the value is negative, the elements will be rotated to the right.\r\n\r\n## Returns\r\n\r\nDynamic array containing the same amount of the elements as in original array, where each element was rotated according to *rotate_count*.\r\n\r\n## See also\r\n\r\n* For rotating array to the right, see [array_rotate_right()](array_rotate_rightfunction.md).\r\n* For shifting array to the left, see [array_shift_left()](array_shift_leftfunction.md).\r\n* For shifting array to the right, see [array_shift_right()](array_shift_rightfunction.md).","* Rotating to the left by two positions:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_rotated=array_rotate_left(arr, 2)\r\n    ```\r\n\r\n    |arr|arr_rotated|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,1,2]|\r\n\r\n* Rotating to the right by two positions by using negative rotate_count value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_rotated=array_rotate_left(arr, -2)\r\n    ```\r\n\r\n    |arr|arr_rotated|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[4,5,1,2,3]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/array_rotate_leftfunction","array_rotate_leftfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_rotate_right","Rotates values inside a `dynamic` array to the right.","## Syntax\r\n\r\n`array_rotate_right(`*array*, *rotate_count*`)`\r\n\r\n## Arguments\r\n\r\n* *array*: Input array to rotate, must be dynamic array.\r\n* *rotate_count*: Integer specifying the number of positions that array elements will be rotated to the right. If the value is negative, the elements will be rotated to the left.\r\n\r\n## Returns\r\n\r\nDynamic array containing the same amount of the elements as in the original array, where each element was rotated according to *rotate_count*.\r\n\r\n## See also\r\n\r\n* For rotating array to the left, see [array_rotate_left()](array_rotate_leftfunction.md).\r\n* For shifting array to the left, see [array_shift_left()](array_shift_leftfunction.md).\r\n* For shifting array to the right, see [array_shift_right()](array_shift_rightfunction.md).","* Rotating to the right by two positions:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_rotated=array_rotate_right(arr, 2)\r\n    ```\r\n\r\n    |arr|arr_rotated|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[4,5,1,2,3]|\r\n\r\n* Rotating to the left by two positions by using negative rotate_count value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_rotated=array_rotate_right(arr, -2)\r\n    ```\r\n\r\n    |arr|arr_rotated|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,1,2]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/array_rotate_rightfunction","array_rotate_rightfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_shift_left","Shifts the values inside a `dynamic` array to the left.","## Syntax\r\n\r\n`array_shift_left(`*array*, *shift_count* `[,` *fill_value* ]`)`\r\n\r\n## Arguments\r\n\r\n* *array*: Input array to shift, must be dynamic array.\r\n* *shift_count*: Integer specifying the number of positions that array elements will be shifted to the left. If the value is negative, the elements will be shifted to the right.\r\n* *fill_value*: Scalar value that is used for inserting elements instead of the ones that were shifted and removed. Default: null value or empty string (depending on the *array* type).\r\n\r\n## Returns\r\n\r\nDynamic array containing the same number of elements as in the original array. Each element has been shifted according to *shift_count*. New elements that are added in place of removed elements will have a value of *fill_value*.\r\n\r\n## See also\r\n\r\n* For shifting array right, see [array_shift_right()](array_shift_rightfunction.md).\r\n* For rotating array right, see [array_rotate_right()](array_rotate_rightfunction.md).\r\n* For rotating array left, see [array_rotate_left()](array_rotate_leftfunction.md).","* Shifting to the left by two positions:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_left(arr, 2)\r\n    ```\r\n\r\n    |`arr`|`arr_shift`|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,null,null]|\r\n\r\n* Shifting to the left by two positions and adding default value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_left(arr, 2, -1)\r\n    ```\r\n\r\n    |`arr`|`arr_shift`|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,-1,-1]|\r\n\r\n* Shifting to the right by two positions by using negative *shift_count* value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_left(arr, -2, -1)\r\n    ```\r\n\r\n    |`arr`|`arr_shift`|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[-1,-1,1,2,3]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/array_shift_leftfunction","array_shift_leftfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_shift_right","`array_shift_right()` shifts values inside an array to the right.","## Syntax\r\n\r\n`array_shift_right(`*array*, *shift_count* [, *fill_value* ]`)`\r\n\r\n## Arguments\r\n\r\n* *array*: Input array to shift, must be dynamic array.\r\n* *shift_count*: Integer specifying the number of positions that array elements will be shifted to the right. If the value is negative, the elements will be shifted to the left.\r\n* *fill_value*: scalar value that is used for inserting elements instead of the ones that were shifted and removed. Default: null value or empty string (depending on the *array* type).\r\n\r\n## Returns\r\n\r\nDynamic array containing the same amount of the elements as in the original array. Each element has been shifted according to *shift_count*. New elements that are added instead of the removed elements will have a value of *fill_value*.\r\n\r\n## See also\r\n\r\n* For shifting array left, see [array_shift_left()](array_shift_leftfunction.md).\r\n* For rotating array right, see [array_rotate_right()](array_rotate_rightfunction.md).\r\n* For rotating array left, see [array_rotate_left()](array_rotate_leftfunction.md).","* Shifting to the right by two positions:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_right(arr, 2)\r\n    ```\r\n\r\n    |arr|arr_shift|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[null,null,1,2,3]|\r\n\r\n* Shifting to the right by two positions and adding a default value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_right(arr, 2, -1)\r\n    ```\r\n\r\n    |arr|arr_shift|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[-1,-1,1,2,3]|\r\n\r\n* Shifting to the left by two positions by using a negative shift_count value:\r\n\r\n    \r\n    ```\r\n    print arr=dynamic([1,2,3,4,5]) \r\n    | extend arr_shift=array_shift_right(arr, -2, -1)\r\n    ```\r\n\r\n    |arr|arr_shift|\r\n    |---|---|\r\n    |[1,2,3,4,5]|[3,4,5,-1,-1]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/array_shift_rightfunction","array_shift_rightfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_slice","Extracts a slice of a dynamic array.","## Syntax\r\n\r\n`array_slice`(*array*, *start*, *end*)\r\n\r\n## Arguments\r\n\r\n* *array*: Input array to extract the slice from must be dynamic array.\r\n* *start*: zero-based (inclusive) start index of the slice, negative values are converted to array_length+start.\r\n* *end*: zero-based (inclusive) end index of the slice, negative values are converted to array_length+end.\r\n\r\nNote: out of bounds indices are ignored.\r\n\r\n## Returns\r\n\r\nDynamic array of the values in the range [`start..end`] from `array`.","```\r\nprint arr=dynamic([1,2,3]) \r\n| extend sliced=array_slice(arr, 1, 2)\r\n```\r\n\r\n|`arr`|`sliced`|\r\n|---|---|\r\n|[1,2,3]|[2,3]|\r\n\r\n```\r\nprint arr=dynamic([1,2,3,4,5]) \r\n| extend sliced=array_slice(arr, 2, -1)\r\n```\r\n\r\n|`arr`|sliced|\r\n|---|---|\r\n|[1,2,3,4,5]|[3,4,5]|\r\n\r\n```\r\nprint arr=dynamic([1,2,3,4,5]) \r\n| extend sliced=array_slice(arr, -3, -2)\r\n```\r\n\r\n|`arr`|sliced|\r\n|---|---|\r\n|[1,2,3,4,5]|[3,4]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/arrayslicefunction","arrayslicefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_sort_asc","Receives one or more arrays. Sorts the first array in ascending order. Orders the remaining arrays to match the reordered first array.",'## Syntax\r\n\r\n`array_sort_asc(`*array1*[, ..., *argumentN*]`)`\r\n\r\n`array_sort_asc(`*array1*[, ..., *argumentN*]`,`*nulls_last*`)`\r\n\r\nIf *nulls_last* isn\'t provided, a default value of `true` is used.\r\n\r\n## Arguments\r\n\r\n* *array1...arrayN*: Input arrays.\r\n* *nulls_last*: A bool indicating whether `null`s should be last\r\n\r\n## Returns\r\n\r\nReturns the same number of arrays as in the input, with the first array sorted in ascending order, and the remaining arrays ordered to match the reordered first array.\r\n\r\n`null` will be returned for every array that differs in length from the first one.\r\n\r\nIf an array contains elements of different types, it will be sorted in the following order:\r\n\r\n* Numeric, `datetime`, and `timespan` elements\r\n* String elements\r\n* Guid elements\r\n* All other elements\r\n\r\n## Example 1 - Sorting two arrays\r\n\r\n```\r\nlet array1 = dynamic([1,3,4,5,2]);\r\nlet array2 = dynamic(["a","b","c","d","e"]);\r\nprint array_sort_asc(array1,array2)\r\n```\r\n\r\n|`array1_sorted`|`array2_sorted`|\r\n|---|---|\r\n|[1,2,3,4,5]|["a","e","b","c","d"]|\r\n\r\n> [!Note]\r\n> The output column names are generated automatically, based on the arguments to the function. To assign different names to the output columns, use the following syntax: `... | extend (out1, out2) = array_sort_asc(array1,array2)`\r\n\r\n## Example 2 - Sorting substrings\r\n\r\n```\r\nlet Names = "John,Paul,George,Ringo";\r\nlet SortedNames = strcat_array(array_sort_asc(split(Names, ",")), ",");\r\nprint result = SortedNames\r\n```\r\n\r\n|`result`|\r\n|---|\r\n|George,John,Paul,Ringo|\r\n\r\n## Example 3 - Combining summarize and array_sort_asc\r\n\r\n```\r\ndatatable(command:string, command_time:datetime, user_id:string)\r\n[\r\n    \'chmod\',   datetime(2019-07-15),   "user1",\r\n    \'ls\',      datetime(2019-07-02),   "user1",\r\n    \'dir\',     datetime(2019-07-22),   "user1",\r\n    \'mkdir\',   datetime(2019-07-14),   "user1",\r\n    \'rm\',      datetime(2019-07-27),   "user1",\r\n    \'pwd\',     datetime(2019-07-25),   "user1",\r\n    \'rm\',      datetime(2019-07-23),   "user2",\r\n    \'pwd\',     datetime(2019-07-25),   "user2",\r\n]\r\n| summarize timestamps = make_list(command_time), commands = make_list(command) by user_id\r\n| project user_id, commands_in_chronological_order = array_sort_asc(timestamps, commands)[1]\r\n```\r\n\r\n|`user_id`|`commands_in_chronological_order`|\r\n|---|---|\r\n|user1|[<br>  "ls",<br>  "mkdir",<br>  "chmod",<br>  "dir",<br>  "pwd",<br>  "rm"<br>]|\r\n|user2|[<br>  "rm",<br>  "pwd"<br>]|\r\n\r\n> [!Note]\r\n> If your data may contain `null` values, use [make_list_with_nulls](make-list-with-nulls-aggfunction.md) instead of [make_list](makelist-aggfunction.md).\r\n\r\n## Example 4 - Controlling location of `null` values\r\n\r\nBy default, `null` values are put last in the sorted array. However, you can control it explicitly by adding a `bool` value as the last argument to `array_sort_asc()`.\r\n\r\nExample with default behavior:\r\n\r\n```\r\nprint array_sort_asc(dynamic([null,"blue","yellow","green",null]))\r\n```\r\n\r\n|`print_0`|\r\n|---|\r\n|["blue","green","yellow",null,null]|\r\n\r\nExample with non-default behavior:\r\n\r\n```\r\nprint array_sort_asc(dynamic([null,"blue","yellow","green",null]), false)\r\n```\r\n\r\n|`print_0`|\r\n|---|\r\n|[null,null,"blue","green","yellow"]|\r\n\r\n## See also\r\n\r\nTo sort the first array in descending order, use [array_sort_desc()](arraysortdescfunction.md).',"","https://docs.microsoft.com/azure/data-explorer/kusto/query/arraysortascfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_sort_desc","Receives one or more arrays. Sorts the first array in descending order. Orders the remaining arrays to match the reordered first array.",'## Syntax\r\n\r\n`array_sort_desc(`*array1*[, ..., *argumentN*]`)`\r\n\r\n`array_sort_desc(`*array1*[, ..., *argumentN*]`,`*nulls_last*`)`\r\n\r\nIf *nulls_last* isn\'t provided, a default value of `true` is used.\r\n\r\n## Arguments\r\n\r\n* *array1...arrayN*: Input arrays.\r\n* *nulls_last*: A bool indicating whether `null`s should be last\r\n\r\n## Returns\r\n\r\nReturns the same number of arrays as in the input, with the first array sorted in ascending order, and the remaining arrays ordered to match the reordered first array.\r\n\r\n`null` will be returned for every array that differs in length from the first one.\r\n\r\nIf an array contains elements of different types, it will be sorted in the following order:\r\n\r\n* Numeric, `datetime`, and `timespan` elements\r\n* String elements\r\n* Guid elements\r\n* All other elements\r\n\r\n## Example 1 - Sorting two arrays\r\n\r\n```\r\nlet array1 = dynamic([1,3,4,5,2]);\r\nlet array2 = dynamic(["a","b","c","d","e"]);\r\nprint array_sort_desc(array1,array2)\r\n```\r\n\r\n|`array1_sorted`|`array2_sorted`|\r\n|---|---|\r\n|[5,4,3,2,1]|["d","c","b","e","a"]|\r\n\r\n> [!Note]\r\n> The output column names are generated automatically, based on the arguments to the function. To assign different names to the output columns, use the following syntax: `... | extend (out1, out2) = array_sort_desc(array1,array2)`\r\n\r\n## Example 2 - Sorting substrings\r\n\r\n```\r\nlet Names = "John,Paul,George,Ringo";\r\nlet SortedNames = strcat_array(array_sort_desc(split(Names, ",")), ",");\r\nprint result = SortedNames\r\n```\r\n\r\n|`result`|\r\n|---|\r\n|Ringo,Paul,John,George|\r\n\r\n## Example 3 - Combining summarize and array_sort_desc\r\n\r\n```\r\ndatatable(command:string, command_time:datetime, user_id:string)\r\n[\r\n    \'chmod\',   datetime(2019-07-15),   "user1",\r\n    \'ls\',      datetime(2019-07-02),   "user1",\r\n    \'dir\',     datetime(2019-07-22),   "user1",\r\n    \'mkdir\',   datetime(2019-07-14),   "user1",\r\n    \'rm\',      datetime(2019-07-27),   "user1",\r\n    \'pwd\',     datetime(2019-07-25),   "user1",\r\n    \'rm\',      datetime(2019-07-23),   "user2",\r\n    \'pwd\',     datetime(2019-07-25),   "user2",\r\n]\r\n| summarize timestamps = make_list(command_time), commands = make_list(command) by user_id\r\n| project user_id, commands_in_chronological_order = array_sort_desc(timestamps, commands)[1]\r\n```\r\n\r\n|`user_id`|`commands_in_chronological_order`|\r\n|---|---|\r\n|user1|[<br>  "rm",<br>  "pwd",<br>  "dir",<br>  "chmod",<br>  "mkdir",<br>  "ls"<br>]|\r\n|user2|[<br>  "pwd",<br>  "rm"<br>]|\r\n\r\n> [!Note]\r\n> If your data may contain `null` values, use [make_list_with_nulls](make-list-with-nulls-aggfunction.md) instead of [make_list](makelist-aggfunction.md).\r\n\r\n## Example 4 - Controlling location of `null` values\r\n\r\nBy default, `null` values are put last in the sorted array. However, you can control it explicitly by adding a `bool` value as the last argument to `array_sort_desc()`.\r\n\r\nExample with default behavior:\r\n\r\n```\r\nprint array_sort_desc(dynamic([null,"blue","yellow","green",null]))\r\n```\r\n\r\n|`print_0`|\r\n|---|\r\n|["yellow","green","blue",null,null]|\r\n\r\nExample with non-default behavior:\r\n\r\n```\r\nprint array_sort_desc(dynamic([null,"blue","yellow","green",null]), false)\r\n```\r\n\r\n|`print_0`|\r\n|---|\r\n|[null,null,"yellow","green","blue"]|\r\n\r\n## See also\r\n\r\nTo sort the first array in ascending order, use [array_sort_asc()](arraysortascfunction.md).',"","https://docs.microsoft.com/azure/data-explorer/kusto/query/arraysortdescfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_split","Splits an array to multiple arrays according to the split indices and packs the generated array in a dynamic array.","## Syntax\r\n\r\n`array_split`(*array*, *`indices`*)\r\n\r\n## Arguments\r\n\r\n* *array*: Input array to split, must be dynamic array.\r\n* *indices*: Integer or dynamic array of integers with the split indices (zero based), negative values are converted to array_length + value.\r\n\r\n## Returns\r\n\r\nDynamic array containing N+1 arrays with the values in the range `[0..i1), [i1..i2), ... [iN..array_length)` from `array`, where N is the number of input indices and `i1...iN` are the indices.","```\r\nprint arr=dynamic([1,2,3,4,5]) \r\n| extend arr_split=array_split(arr, 2)\r\n```\r\n\r\n|`arr`|`arr_split`|\r\n|---|---|\r\n|[1,2,3,4,5]|[[1,2],[3,4,5]]|\r\n\r\n```\r\nprint arr=dynamic([1,2,3,4,5]) \r\n| extend arr_split=array_split(arr, dynamic([1,3]))\r\n```\r\n\r\n|`arr`|`arr_split`|\r\n|---|---|\r\n|[1,2,3,4,5]|[[1],[2,3],[4,5]]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/arraysplitfunction","arraysplitfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"array_sum","Calculates the sum of elements in a dynamic array.","## Syntax\r\n\r\n`array_sum`(*array*)\r\n\r\n## Arguments\r\n\r\n* *array*: Input array.\r\n\r\n## Returns\r\n\r\nDouble type value with the sum of the elements of the array.\r\n\r\n> [!NOTE]\r\n> If the array contains elements of non-numeric types, the result is `null`.","```\r\nprint arr=dynamic([1,2,3,4]) \r\n| extend arr_sum=array_sum(arr)\r\n```\r\n\r\n|`arr`|`arr_sum`|\r\n|---|---|\r\n|[1,2,3,4]|10|","https://docs.microsoft.com/azure/data-explorer/kusto/query/array-sum-function","array-sum-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"as","Binds a name to the operator's input tabular expression, thus allowing the query to reference the value of the tabular expression multiple times without breaking the query and binding a name through the [let statement](letstatement.md).","## Syntax\r\n\r\n*T* `|` `as` [`hint.materialized` `=` `true`] *Name*\r\n\r\n## Arguments\r\n\r\n* *T*: A tabular expression.\r\n* *Name*: A temporary name for the tabular expression.\r\n* `hint.materialized`: If set to `true`, the value of the tabular expression will be\r\n  materialized as if it was wrapped by a [materialize()](./materializefunction.md) function\r\n  call.\r\n\r\n> [!NOTE]\r\n>\r\n> * The name given by `as` will be used in the `withsource=` column of [union](./unionoperator.md), the `source_` column of [find](./findoperator.md), and the `$table` column of [search](./searchoperator.md).\r\n> * The tabular expression named using the operator in a [join](./joinoperator.md)'s outer tabular input (`$left`) can also be used in the join's tabular inner input (`$right`).",'```\r\n// 1. In the following 2 example the union\'s generated TableName column will consist of \'T1\' and \'T2\'\r\nrange x from 1 to 10 step 1 \r\n| as T1 \r\n| union withsource=TableName (range x from 1 to 10 step 1 | as T2)\r\n\r\n// Alternatively, you can write the same example, as follows:\r\nunion withsource=TableName (range x from 1 to 10 step 1 | as T1), (range x from 1 to 10 step 1 | as T2)\r\n\r\n// 2. In the following example, the \'left side\' of the join will be: \r\n//      MyLogTable filtered by type == "Event" and Name == "Start"\r\n//    and the \'right side\' of the join will be: \r\n//      MyLogTable filtered by type == "Event" and Name == "Stop"\r\nMyLogTable  \r\n| where type == "Event"\r\n| as T\r\n| where Name == "Start"\r\n| join (\r\n    T\r\n    | where Name == "Stop"\r\n) on ActivityId\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/asoperator","asoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"asin","Returns the angle whose sine is the specified number (the inverse operation of [`sin()`](sinfunction.md)) .","## Syntax\r\n\r\n`asin(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number in range [-1, 1].\r\n\r\n## Returns\r\n\r\n* The value of the arc sine of `x`\r\n* `null` if `x` < -1 or `x` > 1","","https://docs.microsoft.com/azure/data-explorer/kusto/query/asinfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"assert","Checks for a condition. If the condition is false, outputs error messages and fails the query.","## Syntax\r\n\r\n`assert(`*condition*`, `*message*`)`\r\n\r\n## Arguments\r\n\r\n* *condition*: The conditional expression to evaluate. If the condition is `false`, the specified message is used to report an error. If the condition is `true`, it returns `true` as an evaluation result. Condition must be evaluated to constant during the query analysis phase.\r\n* *message*: The message used if assertion is evaluated to `false`. The *message* must be a string literal.\r\n\r\n> [!NOTE]\r\n> `condition` must be evaluated to constant during the query analysis phase. In other words, it can be constructed from other expressions referencing constants, and can't be bound to row-context.\r\n\r\n## Returns\r\n\r\n* `true` - if the condition is `true`\r\n* Raises semantic error if the condition is evaluated to `false`.","The following query defines a function `checkLength()` that checks input string length, and uses `assert` to validate input length parameter (checks that it is greater than zero).\r\n\r\n```\r\nlet checkLength = (len:long, s:string)\r\n{\r\n    assert(len > 0, \"Length must be greater than zero\") and \r\n    strlen(s) > len\r\n};\r\ndatatable(input:string)\r\n[\r\n    '123',\r\n    '4567'\r\n]\r\n| where checkLength(len=long(-1), input)\r\n```\r\n\r\nRunning this query yields an error:  \r\n`assert() has failed with message: 'Length must be greater than zero'`\r\n\r\nExample of running with valid `len` input:\r\n\r\n```\r\nlet checkLength = (len:long, s:string)\r\n{\r\n    assert(len > 0, \"Length must be greater than zero\") and strlen(s) > len\r\n};\r\ndatatable(input:string)\r\n[\r\n    '123',\r\n    '4567'\r\n]\r\n| where checkLength(len=3, input)\r\n```\r\n\r\n|input|\r\n|---|\r\n|4567|","https://docs.microsoft.com/azure/data-explorer/kusto/query/assert-function","assert-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"atan","Returns the angle whose tangent is the specified number (the inverse operation of [`tan()`](tanfunction.md)) .","## Syntax\r\n\r\n`atan(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The value of the arc tangent of `x`","","https://docs.microsoft.com/azure/data-explorer/kusto/query/atanfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"atan2","Calculates the angle, in radians, between the positive x-axis and the ray from the origin to the point (y, x).","## Syntax\r\n\r\n`atan2(`*y*`,`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: X coordinate (a real number).\r\n* *y*: Y coordinate (a real number).\r\n\r\n## Returns\r\n\r\n* The angle, in radians, between the positive x-axis and the ray from the origin to the point (y, x).","```\r\nprint atan2_0 = atan2(1,1) // Pi / 4 radians (45 degrees)\r\n| extend atan2_1 = atan2(0,-1) // Pi radians (180 degrees)\r\n| extend atan2_2 = atan2(-1,0) // - Pi / 2 radians (-90 degrees)\r\n```\r\n\r\n|atan2_0|atan2_1|atan2_2|\r\n|---|---|---|\r\n|0.785398163397448|3.14159265358979|-1.5707963267949|","https://docs.microsoft.com/azure/data-explorer/kusto/query/atan2function","atan2function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"autocluster","`autocluster` finds common patterns of discrete attributes (dimensions) in the data. It then reduces the results of the original query, whether it's 100 or 100k rows, to a small number of patterns. The plugin was developed to help analyze failures (such as exceptions or crashes) but can potentially work on any filtered data set. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","> [!NOTE]\r\n> `autocluster` is largely based on the Seed-Expand algorithm from the following paper: [Algorithms for Telemetry Data Mining using Discrete Attributes](https://www.scitepress.org/DigitalLibrary/PublicationsDetail.aspx?ID=d5kcrO+cpEU=&t=1). \r\n\r\n## Syntax\r\n\r\n*Table* | `evaluate` `autocluster` `(`[*SizeWeight*, *WeightColumn*, *NumSeeds*, *CustomWildcard*, *CustomWildcard*, ...]`)`\r\n\r\n## Arguments \r\n\r\n> [!NOTE] \r\n> All arguments are optional.\r\n\r\nAll arguments are optional, but they must be ordered as above. To indicate that the default value should be used, put the string tilde value '~' (see the \"Example\" column in the table).\r\n\r\n|Argument  | Type, range, default  |Description | Example   |\r\n|----------------|-----------------------------------|---------------------------|------------------------------------------------|\r\n| SizeWeight     | 0 < *double* < 1 [default: 0.5]   | Gives you some control over the balance between generic (high coverage) and informative (many shared) values. If you increase the value, it usually reduces the number of patterns, and each pattern tends to cover a larger percentage coverage. If you decrease the value, it usually produces more specific patterns with more shared values, and a smaller percentage coverage. The under-the-hood formula is a weighted geometric mean, between the normalized generic score and the informative score with weights `SizeWeight` and `1-SizeWeight`    | `T | evaluate autocluster(0.8)`                |\r\n|WeightColumn    | *column_name*     | Considers each row in the input according to the specified weight (by default each row has a weight of '1'). The argument must be a name of a numeric column (such as int, long, real). A common usage of a weight column is to take into account sampling or bucketing/aggregation of the data that is already embedded into each row.   | `T | evaluate autocluster('~', sample_Count)` | \r\n| NumSeeds        | *int* [default: 25]  | The number of seeds determines the number of initial local search points of the algorithm. In some cases, depending on the structure of the data and if you increase the number of seeds, then the number (or quality) of the results increases through the expanded search space with a slower query tradeoff. The value has diminishing results in both directions, so if you decrease it to below five, it will achieve negligible performance improvements. If you increase to above 50, it will rarely generate additional patterns.  | `T | evaluate autocluster('~', '~', 15)`       |\r\n| CustomWildcard  | *\"any_value_per_type\"* | Sets the wildcard value for a specific type in the results table. It will indicate that the current pattern doesn't have a restriction on this column. The default is null, since the string default is an empty string. If the default is a good value in the data, a different wildcard value should be used (such as `*`).   | `T | evaluate autocluster('~', '~', '~', '*', int(-1), double(-1), long(0), datetime(1900-1-1))` |\r\n\r\n## Returns\r\n\r\nThe `autocluster` plugin returns a (usually small) set of patterns. The patterns capture portions of the data with shared common values across multiple discrete attributes. Each pattern in the results is represented by a row.\r\n\r\nThe first column is the segment ID. The next two columns are the count and percentage of rows out of the original query that are captured by the pattern. The remaining columns are from the original query. Their value is either a specific value from the column, or a wildcard value (which are by default null) meaning variable values.\r\n\r\nThe patterns aren't distinct, may be overlapping, and usually don't cover all the original rows. Some rows may not fall under any pattern.\r\n\r\n> [!TIP]\r\n> Use [where](./whereoperator.md) and [project](./projectoperator.md) in the input pipe to reduce the data to just what you're interested in.\r\n>\r\n> When you find an interesting row, you might want to drill into it further by adding its specific values to your `where` filter.",'### Using evaluate\r\n\r\n```\r\nT | evaluate autocluster()\r\n```\r\n\r\n### Using autocluster\r\n\r\n```\r\nStormEvents \r\n| where monthofyear(StartTime) == 5\r\n| extend Damage = iff(DamageCrops + DamageProperty > 0 , "YES" , "NO")\r\n| project State , EventType , Damage\r\n| evaluate autocluster(0.6)\r\n```\r\n\r\n|SegmentId|Count|Percent|State|EventType|Damage|\r\n|---|---|---|---|---|---|---|---|---|\r\n|0|2278|38.7||Hail|NO\r\n|1|512|8.7||Thunderstorm Wind|YES\r\n|2|898|15.3|TEXAS||\r\n\r\n### Using custom wildcards\r\n\r\n```\r\nStormEvents \r\n| where monthofyear(StartTime) == 5\r\n| extend Damage = iff(DamageCrops + DamageProperty > 0 , "YES" , "NO")\r\n| project State , EventType , Damage \r\n| evaluate autocluster(0.2, \'~\', \'~\', \'*\')\r\n```\r\n\r\n|SegmentId|Count|Percent|State|EventType|Damage|\r\n|---|---|---|---|---|---|---|---|---|\r\n|0|2278|38.7|\\*|Hail|NO\r\n|1|512|8.7|\\*|Thunderstorm Wind|YES\r\n|2|898|15.3|TEXAS|\\*|\\*\r\n\r\n## See also\r\n\r\n* [basket](./basketplugin.md)\r\n* [reduce](./reduceoperator.md)\r\n\r\n\r\n\r\n---\r\n\r\n> [!IMPORTANT]\r\n> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r\n\r\n# autocluster plugin - Internal\r\n\r\nIf you have questions about autocluster or other ML related workflows in Kusto you can post them on the following DL: [KustoML](mailto:kustoML@microsoft.com).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/autoclusterplugin","autoclusterplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"avg","Calculates the average (arithmetic mean) of *Expr* across the group.","* Can only be used in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`avg` `(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. Records with `null` values are ignored and not included in the calculation.\r\n\r\n## Returns\r\n\r\nThe average value of *Expr* across the group.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/avg-aggfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"avgif","Calculates the [average](avg-aggfunction.md) of *Expr* across the group for which *Predicate* evaluates to `true`.","* Can only be used in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`avgif` `(`*Expr*`,` *Predicate*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. Records with `null` values are ignored and not included in the calculation.\r\n* *Predicate*:  predicate that if true, the *Expr* calculated value will be added to the average.\r\n\r\n## Returns\r\n\r\nThe average value of *Expr* across the group where *Predicate* evaluates to `true`.","```\r\nrange x from 1 to 100 step 1\r\n| summarize avgif(x, x%2 == 0)\r\n```\r\n\r\n|avgif_x|\r\n|---|\r\n|51|","https://docs.microsoft.com/azure/data-explorer/kusto/query/avgif-aggfunction","avgif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"azure_digital_twins_query_request","The `azure_digital_twins_query_request` plugin runs an Azure Digital Twins query as part of a Kusto Query Language query. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","Using the plugin, you can query across data in both Azure Digital Twins and any data source accessible through the Kusto Query Language. For example, you can use the plugin to contextualize time series data in a Kusto query by joining it with knowledge graph data held in Azure Digital Twins.\r\n\r\n## Syntax\r\n\r\n`evaluate` `azure_digital_twins_query_request` `(` *AdtInstanceEndpoint* `,` *AdtQuery* `)`\r\n\r\n## Arguments\r\n\r\n* *AdtInstanceEndpoint*: A `string` literal indicating the Azure Digital Twins instance endpoint to be queried.\r\n* *AdtQuery*: A `string` literal indicating the query that is to be run against the Azure Digital Twins endpoint. This query is written in a custom SQL-like query language for Azure Digital Twins, referred to as the **Azure Digital Twins query language**. For more information, see [**Query language for Azure Digital Twins**](https://docs.microsoft.com/azure/digital-twins/concepts-query-language).\r\n\r\n## Authentication and authorization\r\n\r\nThe azure_digital_twins_query_request plugin uses the Azure AD account of the user running the query to authenticate. To run a query, a user must at least be granted the **Azure Digital Twins Data Reader** role. Information on how to assign this role can be found in [**Security for Azure Digital Twins solutions**](https://docs.microsoft.com/azure/digital-twins/concepts-security#authorization-azure-roles-for-azure-digital-twins).","The following examples show how you can run various Azure Digital Twins queries, including queries that use additional Kusto expressions.\r\n\r\n### Retrieval of all twins within an Azure Digital Twins instance\r\n\r\nThe following example returns all digital twins within an Azure Digital Twins instance.\r\n\r\n```\r\nevaluate azure_digital_twins_query_request(\r\n  'https://contoso.api.wcus.digitaltwins.azure.net',\r\n  'SELECT T AS Twins FROM DIGITALTWINS T')\r\n```\r\n\r\n**Output**\r\n\r\n![Screenshot of the twins present in the Azure Digital Twins instance.](images/azure-digital-twins-query-request-plugin/adt-twins.png)\r\n\r\n### Projection of twin properties as columns along with additional Kusto expressions\r\n\r\nThe following example returns the result from the plugin as separate columns, and then performs additional operations using Kusto expressions.\r\n\r\n```\r\nevaluate azure_digital_twins_query_request(\r\n  'https://contoso.api.wcus.digitaltwins.azure.net',\r\n  'SELECT T.Temperature, T.Humidity FROM DIGITALTWINS T WHERE IS_PRIMITIVE(T.Temperature) AND IS_PRIMITIVE(T.Humidity)')\r\n| where Temperature > 20\r\n| project TemperatureInC = Temperature, Humidity\r\n```\r\n\r\n**Output**\r\n\r\n|TemperatureInC|Humidity|\r\n|---|---|\r\n|21|48|\r\n|49|34|\r\n|80|32|\r\n\r\n### Joining the plugin results with another data source\r\n\r\nThe following example shows how to perform complex analysis, such as anomaly detection, through a `join` operation between the plugin results and a table containing historical data in a Kusto table, based on the ID column (`$dtid`).\r\n\r\n```\r\nevaluate azure_digital_twins_query_request(\r\n  'https://contoso.api.wcus.digitaltwins.azure.net',\r\n  'SELECT T.$dtId AS tid, T.Temperature FROM DIGITALTWINS T WHERE IS_PRIMITIVE(T.$dtId) AND IS_PRIMITIVE(T.Temperature)')\r\n| project tostring(tid), todouble(Temperature)\r\n| join kind=inner (\r\n    ADT_Data_History\r\n) on $left.tid == $right.twinId\r\n| make-series num=avg(value) on timestamp from min_t to max_t step dt by tid\r\n| extend (anomalies, score , baseline) = \r\n          series_decompose_anomalies(num, 1.5, -1, 'linefit')\r\n| render anomalychart with(anomalycolumns=anomalies, title= 'Test, anomalies')\r\n```\r\n\r\nADT_Data_History is a table whose schema as follows:\r\n\r\n|timestamp|twinId|modelId|name|value|relationshipTarget|relationshipId|\r\n|---|---|---|---|---|---|---|\r\n|2021-02-01 17:24|contosoRoom|dtmi:com:contoso:Room;1|Temperature|24|...|..|\r\n\r\n**Output**\r\n\r\n![Screenshot of the Anomaly chart of the test expression. Highlighted point is the anomaly.](images/azure-digital-twins-query-request-plugin/adt-anomaly.png)\r\n\r\n---\r\n\r\n> [!IMPORTANT]\r\n> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r\n\r\n# azure_digital_twins_query_request plugin (preview)\r\n\r\nRuns an Azure Digital Twins query as part of the KQL query.\r\n\r\nUsing the plugin, you can reason across data in both Azure Digital Twins and any data source accessible through the Kusto Query Language (KQL). For example, you can use the plugin to contextualize time series data in Kusto by joining it with knowledge graph data held in Azure Digital Twins.\r\n\r\n>[!NOTE]\r\n>* The Azure Digital Twins query plugin is in preview.\r\n\r\n## Syntax\r\n\r\n`evaluate` `azure_digital_twins_query_request` `(` *AdtInstanceEndpoint* `,` *AdtQuery* `)`\r\n\r\n## Arguments\r\n\r\n* *AdtInstanceEndpoint*: A `string` literal indicating the Azure Digital Twins instance endpoint to be queried.\r\n\r\n* *AdtQuery*: A `string` literal indicating the query that is to be executed against the Azure Digital Twins endpoint. This query is written in a custom SQL-like query language for Azure Digital Twins, referred to as the **Azure Digital Twins query language**. For more information on the query language, see [**Query language | Azure Digital Twins documentation**](https://docs.microsoft.com/azure/digital-twins/concepts-query-language).\r\n\r\n\r\n## Authentication and Authorization\r\n\r\nThe user of the azure_digital_twins_query_request plugin must be granted the **Azure Digital Twins Data Reader** role, as the user's Azure AD token is used to authenticate. Information on how to assign this role can be found in [**Security for Azure Digital Twins solutions | Azure Digital Twins documentation**](https://docs.microsoft.com/azure/digital-twins/concepts-security#authorization-azure-roles-for-azure-digital-twins).\r\n\r\n## Setup\r\n\r\nThis plugin is disabled by default, as it is in still in preview. To enable the plugin on your cluster, run the following command:\r\n`.enable plugin azure_digital_twins_query_request`. This command requires **All Databases admin** permission. \r\n\r\nFor more information on this command, see [**.enable plugin | Azure Data Explorer documentation**](../management/enable-plugin.md). For more information on role-based authorization in Kusto, see [**Role-based Authorization in Kusto | Azure Data Explorer documentation**](https://docs.microsoft.com/azure/data-explorer/kusto/management/access-control/role-based-authorization).\r\n\r\n## Examples\r\n\r\nThe following examples show how you can perform various queries, along with using additional Kusto expressions.\r\n\r\n### Retrieval of all twins within an Azure Digital Twins instance\r\n\r\nThis example returns all digital twins within an Azure Digital Twins instance.\r\n\r\n```kusto\r\nevaluate azure_digital_twins_query_request(\r\n  'https://contoso.api.wcus.digitaltwins.azure.net',\r\n  'SELECT T AS Twins FROM DIGITALTWINS T')\r\n```\r\n\r\nThe result looks like this:\r\n\r\n![The twins present in the Azure Digital Twins instance](images/adt-twins.png \"The twins present in the Azure Digital Twins instance\")\r\n\r\n### Projection of twin properties as columns along with additional Kusto expressions\r\n\r\nThis example returns the result from the plugin as separate columns, and then performs additional operations using Kusto expressions.\r\n\r\n```kusto\r\nevaluate azure_digital_twins_query_request(\r\n  'https://contoso.api.wcus.digitaltwins.azure.net',\r\n  'SELECT T.Temperature, T.Humidity FROM DIGITALTWINS T WHERE IS_PRIMITIVE(T.Temperature) AND IS_PRIMITIVE(T.Humidity)')\r\n| where Temperature > 20\r\n| project TemperatureInC = Temperature, Humidity\r\n```\r\n\r\nThe result looks like this:\r\n\r\n|TemperatureInC|Humidity|\r\n|---|---|\r\n|21|48|\r\n|49|34|\r\n|80|32|\r\n\r\n### Joining the plugin results with another data source\r\n\r\nThis example shows how to perform complex analysis, such as anomaly detection, through a `join` operation between the plugin results and a table containing historical data in a Kusto table, based on the ID column (`$dtid`).\r\n\r\n```kusto\r\nevaluate azure_digital_twins_query_request(\r\n  'https://contoso.api.wcus.digitaltwins.azure.net',\r\n  'SELECT T.$dtId AS tid, T.Temperature FROM DIGITALTWINS T WHERE IS_PRIMITIVE(T.$dtId) AND IS_PRIMITIVE(T.Temperature)')\r\n| project tostring(tid), todouble(Temperature)\r\n| join kind=inner (\r\n    ADT_Data_History\r\n) on $left.tid == $right.twinId\r\n| make-series num=avg(value) on timestamp from min_t to max_t step dt by tid\r\n| extend (anomalies, score , baseline) = \r\n          series_decompose_anomalies(num, 1.5, -1, 'linefit')\r\n| render anomalychart with(anomalycolumns=anomalies, title= 'Test, anomalies')\r\n```\r\n\r\nADT_Data_History is a table whose schema as follows:\r\n\r\n|timestamp|twinId|modelId|name|value|relationshipTarget|relationshipId|\r\n|---|---|---|---|---|---|---|\r\n|2021-02-01 17:24|contosoRoom|dtmi:com:contoso:Room;1|Temperature|24|...|..|\r\n\r\nThe output looks like this:\r\n\r\n![Anomaly chart of the above expression](images/adt-anomaly.png \"Highlighted point is the anomaly\")","https://docs.microsoft.com/azure/data-explorer/kusto/query/azure-digital-twins-query-request-plugin","azure-digital-twins-query-request-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_has_key","Checks whether a dynamic bag column contains a given key.","## Syntax\r\n\r\n`bag_has_key(`*bag*`, `*key*`)`\r\n\r\n## Arguments\r\n\r\n| Name | Type | Required | Description |\r\n| -- | -- | -- | -- |\r\n| *bag* | dynamic | &check; | The property bag to search. |\r\n| *key* | string | &check; | The key to search for.  You can search for a nested key using the [JSONPath](jsonpath.md) notation. For an example, see [Search using a JSONPath key](#search-using-a-jsonpath-key). |\r\n\r\n## Returns\r\n\r\nTrue or false depending on if the key exists in the bag.","```\r\ndatatable(input: dynamic)\r\n[\r\n    dynamic({'key1' : 123, 'key2': 'abc'}),\r\n    dynamic({'key1' : 123, 'key3': 'abc'}),\r\n]\r\n| extend result = bag_has_key(input, 'key2')\r\n```\r\n\r\n|input|result|\r\n|---|---|\r\n|{<br>  \"key1\": 123,<br>  \"key2\": \"abc\"<br>}|true<br>|\r\n|{<br>  \"key1\": 123,<br>  \"key3\": \"abc\"<br>}|false<br>|\r\n\r\n### Search using a JSONPath key\r\n\r\n```\r\ndatatable(input: dynamic)\r\n[\r\n    dynamic({'key1': 123, 'key2': {'prop1' : 'abc', 'prop2': 'xyz'}, 'key3': [100, 200]}),\r\n]\r\n| extend result = bag_has_key(input, '$.key2.prop1')\r\n```\r\n\r\n|input|result|\r\n|---|---|\r\n|{<br>  \"key1\": 123,<br>  \"key2\": {<br>    \"prop1\": \"abc\",<br>    \"prop2\": \"xyz\"<br>  },<br>  \"key3\": [<br>    100,<br>    200<br>  ]<br>}|true<br>|","https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-has-key-function","bag-has-key-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_keys","Enumerates all the root keys in a dynamic property-bag object.","## Syntax\r\n\r\n`bag_keys(`*dynamic object*`)`\r\n\r\n## Returns\r\n\r\nAn array of keys, order is undetermined.",'```\r\ndatatable(index:long, d:dynamic) [\r\n1, dynamic({\'a\':\'b\', \'c\':123}), \r\n2, dynamic({\'a\':\'b\', \'c\':{\'d\':123}}),\r\n3, dynamic({\'a\':\'b\', \'c\':[{\'d\':123}]}),\r\n4, dynamic(null),\r\n5, dynamic({}),\r\n6, dynamic(\'a\'),\r\n7, dynamic([])]\r\n| extend keys = bag_keys(d)\r\n```\r\n\r\n|index|d|keys|\r\n|---|---|---|\r\n|1|{<br>  "a": "b",<br>  "c": 123<br>}|[<br>  "a",<br>  "c"<br>]|\r\n|2|{<br>  "a": "b",<br>  "c": {<br>    "d": 123<br>  }<br>}|[<br>  "a",<br>  "c"<br>]|\r\n|3|{<br>  "a": "b",<br>  "c": [<br>    {<br>      "d": 123<br>    }<br>  ]<br>}|[<br>  "a",<br>  "c"<br>]|\r\n|4|||\r\n|5|{}|[]|\r\n|6|a||\r\n|7|[]||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/bagkeysfunction","bagkeysfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_merge","Merges `dynamic` property-bags into a `dynamic` property-bag with all properties merged.","## Syntax\r\n\r\n`bag_merge(`*bag1*`, `*bag2*`[`,` *bag3*, ...])`\r\n\r\n## Arguments\r\n\r\n* *bag1...bagN*: Input `dynamic` property-bags. The function accepts between 2 to 64 arguments.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` property-bag. Results from merging all of the input property-bag objects. If a key appears in more than one input object, an arbitrary value (out of the possible values for this key) will be chosen.","Expression:\r\n\r\n```\r\nprint result = bag_merge(\r\n   dynamic({'A1':12, 'B1':2, 'C1':3}),\r\n   dynamic({'A2':81, 'B2':82, 'A1':1}))\r\n```\r\n\r\n|result|\r\n|---|\r\n|{<br>  \"A1\": 12,<br>  \"B1\": 2,<br>  \"C1\": 3,<br>  \"A2\": 81,<br>  \"B2\": 82<br>}|","https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-merge-function","bag-merge-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_pack","Creates a `dynamic` object (property bag) from a list of names and values.","Alias to `pack_dictionary()` function.\r\n\r\n> [!NOTE]\r\n> The `bag_pack()` and `pack()` functions are interpreted equivalently.\r\n\r\n## Syntax\r\n\r\n`bag_pack(`*key1*`,` *value1*`,` *key2*`,` *value2*`,... )`\r\n\r\n`pack(`*key1*`,` *value1*`,` *key2*`,` *value2*`,... )`\r\n\r\n## Arguments\r\n\r\n* An alternating list of keys and values (the total length of the list must be even)\r\n* All keys must be non-empty constant strings",'The following example returns `{"Level":"Information","ProcessID":1234,"Data":{"url":"www.bing.com"}}`:\r\n\r\n```\r\nbag_pack("Level", "Information", "ProcessID", 1234, "Data", bag_pack("url", "www.bing.com"))\r\n```\r\n\r\nLets take 2 tables, SmsMessages and MmsMessages:\r\n\r\nTable SmsMessages \r\n\r\n|SourceNumber |TargetNumber| CharsCount\r\n|---|---|---\r\n|555-555-1234 |555-555-1212 | 46 \r\n|555-555-1234 |555-555-1213 | 50 \r\n|555-555-1212 |555-555-1234 | 32 \r\n\r\nTable MmsMessages \r\n\r\n|SourceNumber |TargetNumber| AttachmentSize | AttachmentType | AttachmentName\r\n|---|---|---|---|---\r\n|555-555-1212 |555-555-1213 | 200 | jpeg | Pic1\r\n|555-555-1234 |555-555-1212 | 250 | jpeg | Pic2\r\n|555-555-1234 |555-555-1213 | 300 | png | Pic3\r\n\r\nThe following query:\r\n\r\n```\r\nSmsMessages \r\n| extend Packed=bag_pack("CharsCount", CharsCount) \r\n| union withsource=TableName kind=inner \r\n( MmsMessages \r\n  | extend Packed=bag_pack("AttachmentSize", AttachmentSize, "AttachmentType", AttachmentType, "AttachmentName", AttachmentName))\r\n| where SourceNumber == "555-555-1234"\r\n``` \r\n\r\nReturns:\r\n\r\n|TableName |SourceNumber |TargetNumber | Packed\r\n|---|---|---|---\r\n|SmsMessages|555-555-1234 |555-555-1212 | {"CharsCount": 46}\r\n|SmsMessages|555-555-1234 |555-555-1213 | {"CharsCount": 50}\r\n|MmsMessages|555-555-1234 |555-555-1212 | {"AttachmentSize": 250, "AttachmentType": "jpeg", "AttachmentName": "Pic2"}\r\n|MmsMessages|555-555-1234 |555-555-1213 | {"AttachmentSize": 300, "AttachmentType": "png", "AttachmentName": "Pic3"}',"https://docs.microsoft.com/azure/data-explorer/kusto/query/packfunction","packfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_remove_keys","Removes keys and associated values from a `dynamic` property-bag.","## Syntax\r\n\r\n`bag_remove_keys(`*bag*`, `*keys*`)`\r\n\r\n## Arguments\r\n\r\n* *bag*: `dynamic` property-bag input.\r\n* *keys*: `dynamic` array includes keys to be removed from the input. Keys refer to the first level of the property bag.\r\nYou can specify keys on the nested levels using [JSONPath](jsonpath.md) notation.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` property-bag without specified keys and their values.",'```\r\ndatatable(input:dynamic)\r\n[\r\n    dynamic({\'key1\' : 123,     \'key2\': \'abc\'}),\r\n    dynamic({\'key1\' : \'value\', \'key3\': 42.0}),\r\n]\r\n| extend result=bag_remove_keys(input, dynamic([\'key2\', \'key4\']))\r\n```\r\n\r\n|input|result|\r\n|---|---|\r\n|{<br>  "key1": 123,<br>  "key2": "abc"<br>}|{<br>  "key1": 123<br>}|\r\n|{<br>  "key1": "value",<br>  "key3": 42.0<br>}|{<br>  "key1": "value",<br>  "key3": 42.0<br>}|\r\n\r\n### Remove inner properties of dynamic values using JSONPath notation\r\n\r\n```\r\ndatatable(input:dynamic)\r\n[\r\n    dynamic({\'key1\': 123, \'key2\': {\'prop1\' : \'abc\', \'prop2\': \'xyz\'}, \'key3\': [100, 200]}),\r\n]\r\n| extend result=bag_remove_keys(input, dynamic([\'$.key2.prop1\', \'key3\']))\r\n```\r\n\r\n|input|result|\r\n|---|---|\r\n|{<br>  "key1": 123,<br>  "key2": {<br>    "prop1": "abc",<br>    "prop2": "xyz"<br>  },<br>  "key3": [<br>    100,<br>    200<br>  ]<br>}|{<br>  "key1": 123,<br>  "key2": {<br>    "prop2": "xyz"<br>  }<br>}|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-remove-keys-function","bag-remove-keys-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bag_unpack","The `bag_unpack` plugin unpacks a single column of type `dynamic`, by treating each property bag top-level slot as a column. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","## Syntax\r\n\r\n*T* `|` `evaluate` `bag_unpack(` *Column* [`,` *OutputColumnPrefix* ] [`,` *columnsConflict* ] [`,` *ignoredProperties* ] `)`\r\n\r\n## Arguments\r\n\r\n* *T*: The tabular input whose column *Column* is to be unpacked.\r\n* *Column*: The column of *T* to unpack. Must be of type `dynamic`.\r\n* *OutputColumnPrefix*: A common prefix to add to all columns produced by the plugin. This argument is optional.\r\n* *columnsConflict*: A direction for column conflict resolution. This argument is optional. When argument is provided, it's expected to be a string literal matching one of the following values:\r\n    - `error` - Query produces an error (default)\r\n    - `replace_source` - Source column is replaced\r\n    - `keep_source` - Source column is kept\r\n* *ignoredProperties*: Optional set of bag properties to be ignored. When argument is provided, it's expected to be a constant of `dynamic` array with one or more string literals.\r\n\r\n## Returns\r\n\r\nThe `bag_unpack` plugin returns a table with as many records as its tabular input (*T*). The schema of the table is the same as the schema of its tabular input with the following modifications:\r\n\r\n* The specified input column (*Column*) is removed.\r\n* The schema is extended with as many columns as there are distinct slots in\r\n  the top-level property bag values of *T*. The name of each column corresponds\r\n  to the name of each slot, optionally prefixed by *OutputColumnPrefix*. Its\r\n  type is either the type of the slot, if all values of the same slot have the\r\n  same type, or `dynamic`, if the values differ in type.\r\n\r\n> [!NOTE]\r\n> The plugin's output schema depends on the data values, making it as \"unpredictable\"\r\n> as the data itself. Multiple executions of the plugin, using different\r\n> data inputs, may produce different output schema.\r\n\r\n> [!NOTE]\r\n> The input data to the plugin must be such that the output schema follows all the rules for a tabular schema. In particular:\r\n>\r\n> * An output column name can't be the same as an existing column in the tabular\r\n    input *T*, unless it's the column to be unpacked (*Column*), since that will produce two columns with the same name.\r\n>\r\n> * All slot names, when prefixed by *OutputColumnPrefix*, must be valid\r\n    entity names and follow the [identifier naming rules](./schema-entities/entity-names.md#identifier-naming-rules).",'### Expand a bag\r\n\r\n```\r\ndatatable(d:dynamic)\r\n[\r\n    dynamic({"Name": "John", "Age":20}),\r\n    dynamic({"Name": "Dave", "Age":40}),\r\n    dynamic({"Name": "Jasmine", "Age":30}),\r\n]\r\n| evaluate bag_unpack(d)\r\n```\r\n\r\n**Output**\r\n\r\n|Age|Name   |\r\n|---|-------|\r\n|20 |John   |\r\n|40 |Dave   |\r\n|30 |Jasmine|\r\n\r\n### Expand a bag with OutputColumnPrefix\r\n\r\nExpand a bag and use the `OutputColumnPrefix` option to produce column names that begin with the prefix \'Property_\'.\r\n\r\n```\r\ndatatable(d:dynamic)\r\n[\r\n    dynamic({"Name": "John", "Age":20}),\r\n    dynamic({"Name": "Dave", "Age":40}),\r\n    dynamic({"Name": "Jasmine", "Age":30}),\r\n]\r\n| evaluate bag_unpack(d, \'Property_\')\r\n```\r\n\r\n**Output**\r\n\r\n|Property_Age|Property_Name|\r\n|------------|-------------|\r\n|20          |John         |\r\n|40          |Dave         |\r\n|30          |Jasmine      |\r\n\r\n### Expand a bag with columnsConflict\r\n\r\nExpand a bag and use the `columnsConflict` option to resolve conflicts between existing columns and columns produced by the `bag_unpack()` operator.\r\n\r\n```\r\ndatatable(Name:string, d:dynamic)\r\n[\r\n    \'Old_name\', dynamic({"Name": "John", "Age":20}),\r\n    \'Old_name\', dynamic({"Name": "Dave", "Age":40}),\r\n    \'Old_name\', dynamic({"Name": "Jasmine", "Age":30}),\r\n]\r\n| evaluate bag_unpack(d, columnsConflict=\'replace_source\') // Use new name\r\n```\r\n\r\n**Output**\r\n\r\n|Age|Name   |\r\n|---|-------|\r\n|20 |John   |\r\n|40 |Dave   |\r\n|30 |Jasmine|\r\n\r\n```\r\ndatatable(Name:string, d:dynamic)\r\n[\r\n    \'Old_name\', dynamic({"Name": "John", "Age":20}),\r\n    \'Old_name\', dynamic({"Name": "Dave", "Age":40}),\r\n    \'Old_name\', dynamic({"Name": "Jasmine", "Age":30}),\r\n]\r\n| evaluate bag_unpack(d, columnsConflict=\'keep_source\') // Keep old name\r\n```\r\n\r\n**Output**\r\n\r\n|Age|Name     |\r\n|---|---------|\r\n|20 |Old_name |\r\n|40 |Old_name |\r\n|30 |Old_name |\r\n\r\n### Expand a bag with ignoredProperties\r\n\r\nExpand a bag and use the `ignoredProperties` option to ignore certain properties in the property bag.\r\n\r\n```\r\ndatatable(d:dynamic)\r\n[\r\n    dynamic({"Name": "John", "Age":20, "Address": "Address-1" }),\r\n    dynamic({"Name": "Dave", "Age":40, "Address": "Address-2"}),\r\n    dynamic({"Name": "Jasmine", "Age":30, "Address": "Address-3"}),\r\n]\r\n// Ignore \'Age\' and \'Address\' properties\r\n| evaluate bag_unpack(d, ignoredProperties=dynamic([\'Address\', \'Age\']))\r\n```\r\n\r\n**Output**\r\n\r\n|Name|\r\n|---|\r\n|John|\r\n|Dave|\r\n|Jasmine|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/bag-unpackplugin","bag-unpackplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_decode_toarray","Decodes a base64 string to an array of long values.","## Syntax\r\n\r\n`base64_decode_toarray(`*String*`)`\r\n\r\n## Arguments\r\n\r\n* *String*: Input base64 string to be decoded from base64 to an array of long values.\r\n\r\n## Returns\r\n\r\nReturns an array of long values decoded from a base64 string.\r\n\r\n* To decode base64 strings to a UTF-8 string, see [base64_decode_tostring()](base64_decode_tostringfunction.md)\r\n* To encode strings to a base64 string, see [base64_encode_tostring()](base64_encode_tostringfunction.md)","```\r\nprint Quine=base64_decode_toarray(\"S3VzdG8=\")  \r\n// 'K', 'u', 's', 't', 'o'\r\n```\r\n\r\n|Quine|\r\n|-----|\r\n|[75,117,115,116,111]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/base64_decode_toarrayfunction","base64_decode_toarrayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_decode_toguid","Decodes a base64 string to a [GUID](./scalar-data-types/guid.md).","## Syntax\r\n\r\n`base64_decode_toguid(`*String*`)`\r\n\r\n## Arguments\r\n\r\n* *String*: Input string to be decoded from base64 to a [GUID](./scalar-data-types/guid.md). \r\n\r\n## Returns\r\n\r\nReturns a [GUID](./scalar-data-types/guid.md) decoded from a base64 string.\r\n\r\n* To encode a [GUID](./scalar-data-types/guid.md) to a base64 string, see [base64_encode_fromguid()](base64-encode-fromguid-function.md)",'```\r\nprint Quine = base64_decode_toguid("JpbpECu8dUy7Pv5gbeJXAA==")  \r\n```\r\n\r\n|Quine|\r\n|-----|\r\n|10e99626-bc2b-754c-bb3e-fe606de25700|\r\n\r\nIf you try to decode an invalid base64 string, "null" will be returned:\r\n\r\n```\r\nprint Empty = base64_decode_toarray("abcd1231")\r\n```\r\n\r\n|Empty|\r\n|-----|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64-decode-toguid-function","base64-decode-toguid-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_decode_tostring","Decodes a base64 string to a UTF-8 string.","## Syntax\r\n\r\n`base64_decode_tostring(`*String*`)`\r\n\r\n## Arguments\r\n\r\n* *String*: Input string to be decoded from base64 to UTF-8 string.\r\n\r\n## Returns\r\n\r\nReturns UTF-8 string decoded from base64 string.\r\n\r\n* To decode base64 strings to an array of long values, see [base64_decode_toarray()](base64_decode_toarrayfunction.md)\r\n* To encode strings to base64 string, see [base64_encode_tostring()](base64_encode_tostringfunction.md)",'```\r\nprint Quine=base64_decode_tostring("S3VzdG8=")\r\n```\r\n\r\n|Quine|\r\n|-----|\r\n|Kusto|\r\n\r\nTrying to decode a base64 string that was generated from invalid UTF-8 encoding will return null:\r\n\r\n```\r\nprint Empty=base64_decode_tostring("U3RyaW5n0KHR0tGA0L7Rh9C60LA=")\r\n```\r\n\r\n|Empty|\r\n|-----|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64_decode_tostringfunction","base64_decode_tostringfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_encode_fromarray","Encodes a base64 string from a bytes array.","## Syntax\r\n\r\n`base64_encode_fromarray(`*BytesArray*`)`\r\n\r\n## Arguments\r\n\r\n* *BytesArray*: Input bytes array to be encoded into base64 string.\r\n\r\n## Returns\r\n\r\nReturns the base64 string encoded from the bytes array.\r\n\r\n* For decoding base64 strings to a UTF-8 string see [base64_decode_tostring()](base64_decode_tostringfunction.md)\r\n* For encoding strings to base64 string see [base64_encode_tostring()](base64_encode_tostringfunction.md)\r\n* This function is the inverse of [base64_decode_toarray()](base64_decode_toarrayfunction.md)",'```\r\nlet bytes_array = toscalar(print base64_decode_toarray("S3VzdG8="));\r\nprint decoded_base64_string = base64_encode_fromarray(bytes_array)\r\n```\r\n\r\n|decoded_base64_string|\r\n|---|\r\n|S3VzdG8=|\r\n\r\nTrying to encode a base64 string from an invalid bytes array which was generated from invalid UTF-8 encoded string will return null:\r\n\r\n```\r\nlet empty_bytes_array = toscalar(print base64_decode_toarray("U3RyaW5n0KHR0tGA0L7Rh9C60LA"));\r\nprint empty_string = base64_encode_fromarray(empty_bytes_array)\r\n```\r\n\r\n|empty_string|\r\n|---|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64_encode_fromarrayfunction","base64_encode_fromarrayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_encode_fromguid","Encodes a [GUID](./scalar-data-types/guid.md) to a base64 string.","## Syntax\r\n\r\n`base64_encode_fromguid(`*GUID*`)`\r\n\r\n## Arguments\r\n\r\n* *GUID*: Input [GUID](./scalar-data-types/guid.md) to be encoded to a base64 string. \r\n\r\n## Returns\r\n\r\nReturns a base64 string encoded from a GUID.\r\n\r\n* To decode a base64 string to a [GUID](./scalar-data-types/guid.md), see [base64_decode_toguid()](base64-decode-toguid-function.md)\r\n* To create a [GUID](./scalar-data-types/guid.md) from a string, see [toguid()](toguidfunction.md)",'```\r\nprint Quine = base64_encode_fromguid(toguid("ae3133f2-6e22-49ae-b06a-16e6a9b212eb"))  \r\n```\r\n\r\n|Quine|\r\n|-----|\r\n|8jMxriJurkmwahbmqbIS6w==|\r\n\r\nIf you try to encode anything that isn\'t a [GUID](./scalar-data-types/guid.md) as below, an error will be thrown:\r\n\r\n```\r\nprint Empty = base64_encode_fromguid("abcd1231")\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64-encode-fromguid-function","base64-encode-fromguid-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"base64_encode_tostring","Encodes a string as base64 string.","## Syntax\r\n\r\n`base64_encode_tostring(`*String*`)`\r\n\r\n## Arguments\r\n\r\n* *String*: Input string to be encoded as base64 string.\r\n\r\n## Returns\r\n\r\nReturns the string encoded as base64 string.\r\n\r\n* To decode base64 strings to UTF-8 strings, see [base64_decode_tostring()](base64_decode_tostringfunction.md)\r\n* To decode base64 strings to an array of long values, see [base64_decode_toarray()](base64_decode_toarrayfunction.md)",'```\r\nprint Quine=base64_encode_tostring("Kusto")\r\n```\r\n\r\n|Quine   |\r\n|--------|\r\n|S3VzdG8=|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/base64_encode_tostringfunction","base64_encode_tostringfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"basket","The `basket` plugin finds frequent patterns of attributes in the data and returns the patterns that pass a frequency threshold in that data. A pattern represents a subset of the rows that have the same value across one or more columns. The `basket` plugin is based on the [Apriori algorithm](https://en.wikipedia.org/wiki/Association_rule_learning#Apriori_algorithm) originally developed for basket analysis data mining.","## Syntax\r\n\r\n*T* | `evaluate` `basket` `(` [*Threshold*, *WeightColumn*, *MaxDimensions*, *CustomWildcard*, *CustomWildcard*, ...]`)`\r\n\r\n## Arguments\r\n\r\nAll arguments are optional, but they must be ordered as above. To indicate that the default value should be used, use the string tilde value - '~'. See examples below.\r\n\r\nAvailable arguments:\r\n\r\n* Threshold - 0.015 < *double* < 1 [default: 0.05]\r\n    Sets the minimal ratio of the rows to be considered frequent. Patterns with a smaller ratio won't be returned.\r\n    \r\n    Example: `T | evaluate basket(0.02)`\r\n* WeightColumn - *column_name*\r\n    Considers each row in the input according to the specified weight. By default, each row has a weight of '1'. The argument must be a name of a numeric column, such as int, long, real. A common use of a weight column, is to take into account sampling or bucketing/aggregation of the data that is already embedded into each row.\r\n    Example: `T | evaluate basket('~', sample_Count)`\r\n* MaxDimensions - 1 < *int* [default: 5]\r\n    Sets the maximal number of uncorrelated dimensions per basket, limited by default, to minimize the query runtime.\r\n    Example: `T | evaluate basket('~', '~', 3)`\r\n* CustomWildcard - *\"any_value_per_type\"*\r\n    Sets the wildcard value for a specific type in the result table that will indicate that the current pattern doesn't have a restriction on this column.\r\n    Default is null. The default for a string is an empty string. If the default is a good value in the data, a different wildcard value should be used, such as `*`.\r\n    For example:\r\n     `T | evaluate basket('~', '~', '~', '*', int(-1), double(-1), long(0), datetime(1900-1-1))`\r\n\r\n## Returns\r\n\r\nThe `basket` plugin returns frequent patterns that pass a ratio threshold. The default threshold is 0.05. \r\n\r\nEach pattern is represented by a row in the results. The first column is the segment ID. The next two columns are the *count* and *percentage of rows*, from the original query that match the pattern. The remaining columns relate to the original query, with either a specific value from the column or a wildcard value, which is by default null, meaning a variable value.\r\n\r\n**Notes**\r\nThe algorithm uses sampling to determine the initial frequent values. Consequently, the results could slightly differ between multiple runs for patterns whose frequency is close to the threshold.",'```\r\nStormEvents \r\n| where monthofyear(StartTime) == 5\r\n| extend Damage = iff(DamageCrops + DamageProperty > 0 , "YES" , "NO")\r\n| project State, EventType, Damage, DamageCrops\r\n| evaluate basket(0.2)\r\n```\r\n\r\n**Output**\r\n\r\n|SegmentId|Count|Percent|State|EventType|Damage|DamageCrops|\r\n|---|---|---|---|---|---|---|---|---|\r\n|0|4574|77.7|||NO|0\r\n|1|2278|38.7||Hail|NO|0\r\n|2|5675|96.4||||0\r\n|3|2371|40.3||Hail||0\r\n|4|1279|21.7||Thunderstorm Wind||0\r\n|5|2468|41.9||Hail||\r\n|6|1310|22.3|||YES|\r\n|7|1291|21.9||Thunderstorm Wind||\r\n\r\n**Example with custom wildcards**\r\n\r\n```\r\nStormEvents \r\n| where monthofyear(StartTime) == 5\r\n| extend Damage = iff(DamageCrops + DamageProperty > 0 , "YES" , "NO")\r\n| project State, EventType, Damage, DamageCrops\r\n| evaluate basket(0.2, \'~\', \'~\', \'*\', int(-1))\r\n```\r\n\r\n**Output**\r\n\r\n|SegmentId|Count|Percent|State|EventType|Damage|DamageCrops|\r\n|---|---|---|---|---|---|---|---|---|\r\n|0|4574|77.7|\\*|\\*|NO|0\r\n|1|2278|38.7|\\*|Hail|NO|0\r\n|2|5675|96.4|\\*|\\*|\\*|0\r\n|3|2371|40.3|\\*|Hail|\\*|0\r\n|4|1279|21.7|\\*|Thunderstorm Wind|\\*|0\r\n|5|2468|41.9|\\*|Hail|\\*|-1\r\n|6|1310|22.3|\\*|\\*|YES|-1\r\n|7|1291|21.9|\\*|Thunderstorm Wind|\\*|-1\r\n\r\n---\r\n\r\n> [!IMPORTANT]\r\n> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r\n\r\n# Basket plugin - Internal\r\n\r\nIf you have questions about basket or other ML related workflows in Kusto you can post them on the following DL: [KustoML](mailto:kustoML@microsoft.com).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/basketplugin","basketplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"beta_cdf","Returns the standard cumulative beta distribution function.","```\r\nbeta_cdf(0.2, 10.0, 50.0)\r\n```\r\n\r\nIf *probability* = `beta_cdf(`*x*,...`)`, then `beta_inv(`*probability*,...`)` = *x*.\r\n\r\nThe beta distribution is commonly used to study variation in the percentage of something across samples, such as the fraction of the day people spend watching television.\r\n\r\n## Syntax\r\n\r\n`beta_cdf(`*x*`, `*alpha*`, `*beta*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A value at which to evaluate the function.\r\n* *alpha*: A parameter of the distribution.\r\n* *beta*: A parameter of the distribution.\r\n\r\n## Returns\r\n\r\n* The [cumulative beta distribution function](https://en.wikipedia.org/wiki/Beta_distribution#Cumulative_distribution_function).\r\n\r\n**Notes**\r\n\r\nIf any argument is nonnumeric, beta_cdf() returns null value.\r\n\r\nIf x < 0 or x > 1, beta_cdf() returns NaN value.\r\n\r\nIf alpha \u2264 0 or alpha > 10000, beta_cdf() returns the NaN value.\r\n\r\nIf beta \u2264 0 or beta > 10000, beta_cdf() returns the NaN value.",'```\r\ndatatable(x:double, alpha:double, beta:double, comment:string)\r\n[\r\n    0.9, 10.0, 20.0, "Valid input",\r\n    1.5, 10.0, 20.0, "x > 1, yields NaN",\r\n    double(-10), 10.0, 20.0, "x < 0, yields NaN",\r\n    0.1, double(-1.0), 20.0, "alpha is < 0, yields NaN"\r\n]\r\n| extend b = beta_cdf(x, alpha, beta)\r\n```\r\n\r\n|x|alpha|beta|comment|b|\r\n|---|---|---|---|---|\r\n|0.9|10|20|Valid input|0.999999999999959|\r\n|1.5|10|20|x > 1, yields NaN|NaN|\r\n|-10|10|20|x < 0, yields NaN|NaN|\r\n|0.1|-1|20|alpha is < 0, yields NaN|NaN|\r\n\r\n## See also\r\n\r\n* For computing the inverse of the beta cumulative probability density function, see [beta-inv()](./beta-invfunction.md).\r\n* For computing probability density function, see [beta-pdf()](./beta-pdffunction.md).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/beta-cdffunction","beta-cdffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"beta_inv","Returns the inverse of the beta cumulative probability beta density function.","```\r\nbeta_inv(0.1, 10.0, 50.0)\r\n```\r\n\r\nIf *probability* = `beta_cdf(`*x*,...`)`, then `beta_inv(`*probability*,...`)` = *x*. \r\n\r\nThe beta distribution can be used in project planning to model probable completion times given an expected completion time and variability.\r\n\r\n## Syntax\r\n\r\n`beta_inv(`*probability*`, `*alpha*`, `*beta*`)`\r\n\r\n## Arguments\r\n\r\n* *probability*: A probability associated with the beta distribution.\r\n* *alpha*: A parameter of the distribution.\r\n* *beta*: A parameter of the distribution.\r\n\r\n## Returns\r\n\r\n* The inverse of the beta cumulative probability density function [beta_cdf()](./beta-cdffunction.md)\r\n\r\n**Notes**\r\n\r\nIf any argument is nonnumeric, beta_inv() returns null value.\r\n\r\nIf alpha \u2264 0 or beta \u2264 0, beta_inv() returns the null value.\r\n\r\nIf probability \u2264 0 or probability > 1, beta_inv() returns the NaN value.\r\n\r\nGiven a value for probability, beta_inv() seeks that value x such that beta_cdf(x, alpha, beta) = probability.",'```\r\ndatatable(p:double, alpha:double, beta:double, comment:string)\r\n[\r\n    0.1, 10.0, 20.0, "Valid input",\r\n    1.5, 10.0, 20.0, "p > 1, yields null",\r\n    0.1, double(-1.0), 20.0, "alpha is < 0, yields NaN"\r\n]\r\n| extend b = beta_inv(p, alpha, beta)\r\n```\r\n\r\n|p|alpha|beta|comment|b|\r\n|---|---|---|---|---|\r\n|0.1|10|20|Valid input|0.226415022388749|\r\n|1.5|10|20|p > 1, yields null||\r\n|0.1|-1|20|alpha is < 0, yields NaN|NaN|\r\n\r\n## See also\r\n\r\n* For computing cumulative beta distribution function, see [beta-cdf()](./beta-cdffunction.md).\r\n* For computing probability beta density function, see [beta-pdf()](./beta-pdffunction.md).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/beta-invfunction","beta-invfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"beta_pdf","Returns the probability density beta function.","```\r\nbeta_pdf(0.2, 10.0, 50.0)\r\n```\r\n\r\nThe beta distribution is commonly used to study variation in the percentage of something across samples, such as the fraction of the day people spend watching television.\r\n\r\n## Syntax\r\n\r\n`beta_pdf(`*x*`, `*alpha*`, `*beta*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A value at which to evaluate the function.\r\n* *alpha*: A parameter of the distribution.\r\n* *beta*: A parameter of the distribution.\r\n\r\n## Returns\r\n\r\n* The [probability beta density function](https://en.wikipedia.org/wiki/Beta_distribution#Probability_density_function).\r\n\r\n**Notes**\r\n\r\nIf any argument is nonnumeric, beta_pdf() returns null value.\r\n\r\nIf x \u2264 0 or 1 \u2264 x, beta_pdf() returns NaN value.\r\n\r\nIf alpha \u2264 0 or beta \u2264 0, beta_pdf() returns the NaN value.",'```\r\ndatatable(x:double, alpha:double, beta:double, comment:string)\r\n[\r\n    0.5, 10.0, 20.0, "Valid input",\r\n    1.5, 10.0, 20.0, "x > 1, yields NaN",\r\n    double(-10), 10.0, 20.0, "x < 0, yields NaN",\r\n    0.1, double(-1.0), 20.0, "alpha is < 0, yields NaN"\r\n]\r\n| extend r = beta_pdf(x, alpha, beta)\r\n```\r\n\r\n|x|alpha|beta|comment|r|\r\n|---|---|---|---|---|\r\n|0.5|10|20|Valid input|0.746176019310951|\r\n|1.5|10|20|x > 1, yields NaN|NaN|\r\n|-10|10|20|x < 0, yields NaN|NaN|\r\n|0.1|-1|20|alpha is < 0, yields NaN|NaN|\r\n\r\n**References**\r\n\r\n* For computing the inverse of the beta cumulative probability density function, see [beta-inv()](./beta-invfunction.md).\r\n* For the standard cumulative beta distribution function, see [beta-cdf()](./beta-cdffunction.md).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/beta-pdffunction","beta-pdffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"between","Filters a record set for data matching the values in an inclusive range.","`between` can operate on any numeric, datetime, or timespan expression.\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *expr* `between` `(`*leftRange*` .. `*rightRange*`)`   \r\n\r\nIf *expr* expression is datetime - another syntactic sugar syntax is provided:\r\n\r\n*T* `|` `where` *expr* `between` `(`*leftRangeDateTime*` .. `*rightRangeTimespan*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be matched.\r\n* *expr* - the expression to filter.\r\n* *leftRange* - expression of the left range (inclusive).\r\n* *rightRange* - expression of the right range (inclusive).\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate of (*expr* >= *leftRange* and *expr* <= *rightRange*) evaluates to `true`.","### Filter numeric values   \r\n\r\n```\r\nrange x from 1 to 100 step 1\r\n| where x between (50 .. 55)\r\n```\r\n\r\n|x|\r\n|---|\r\n|50|\r\n|51|\r\n|52|\r\n|53|\r\n|54|\r\n|55|\r\n\r\n### Filter datetime \r\n\r\n```\r\nStormEvents\r\n| where StartTime between (datetime(2007-07-27) .. datetime(2007-07-30))\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|476|\r\n\r\n```\r\nStormEvents\r\n| where StartTime between (datetime(2007-07-27) .. 3d)\r\n| count \r\n```\r\n\r\n|Count|\r\n|---|\r\n|476|","https://docs.microsoft.com/azure/data-explorer/kusto/query/betweenoperator","betweenoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bin","Rounds values down to an integer multiple of a given bin size.",'Used frequently in combination with [`summarize by ...`](./summarizeoperator.md).\r\nIf you have a scattered set of values, they will be grouped into a smaller set of specific values.\r\n\r\nNull values, a null bin size, or a negative bin size will result in null. \r\n\r\nAlias to `floor()` function.\r\n\r\n## Syntax\r\n\r\n`bin(`*value*`,`*roundTo*`)`\r\n\r\n## Arguments\r\n\r\n* *value*: A number, date, or [timespan](scalar-data-types/timespan.md). \r\n* *roundTo*: The "bin size". A number or timespan that divides *value*. \r\n\r\n## Returns\r\n\r\nThe nearest multiple of *roundTo* below *value*.  \r\n\r\n```\r\n(toint((value/roundTo))) * roundTo`\r\n```',"Expression | Result\r\n---|---\r\n`bin(4.5, 1)` | `4.0`\r\n`bin(time(16d), 7d)` | `14d`\r\n`bin(datetime(1970-05-11 13:45:07), 1d)`|  `datetime(1970-05-11)`\r\n\r\nThe following expression calculates a histogram of durations,\r\nwith a bucket size of 1 second:\r\n\r\n```\r\nT | summarize Hits=count() by bin(Duration, 1s)\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/binfunction","binfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bin_at",'Rounds values down to a fixed-size "bin", with control over the bin\'s starting point.\r\n(See also [`bin function`](./binfunction.md).)','## Syntax\r\n\r\n`bin_at` `(`*Expression*`,` *BinSize*`, ` *FixedPoint*`)`\r\n\r\n## Arguments\r\n\r\n* *Expression*: A scalar expression of a numeric type (including `datetime` and `timespan`)\r\n  indicating the value to round.\r\n* *BinSize*: A scalar constant of a numeric type or `timespan` (for a `datetime` or `timespan` *Expression*) indicating\r\n  the size of each bin.\r\n* *FixedPoint*: A scalar constant of the same type as *Expression* indicating\r\n  one value of *Expression* which is a "fixed point" (that is, a value `fixed_point`\r\n  for which `bin_at(fixed_point, bin_size, fixed_point) == fixed_point`.)\r\n\r\n## Returns\r\n\r\nThe nearest multiple of *BinSize* below *Expression*, shifted so that *FixedPoint*\r\nwill be translated into itself.','|Expression                                                                    |Result                           |Comments                   |\r\n|------------------------------------------------------------------------------|---------------------------------|---------------------------|\r\n|`bin_at(6.5, 2.5, 7)`                                                         |`4.5`                            ||\r\n|`bin_at(time(1h), 1d, 12h)`                                                   |`-12h`                           ||\r\n|`bin_at(datetime(2017-05-15 10:20:00.0), 1d, datetime(1970-01-01 12:00:00.0))`|`datetime(2017-05-14 12:00:00.0)`|All bins will be at noon   |\r\n|`bin_at(datetime(2017-05-17 10:20:00.0), 7d, datetime(2017-06-04 00:00:00.0))`|`datetime(2017-05-14 00:00:00.0)`|All bins will be on Sundays|\r\n\r\nIn the following example, notice that the `"fixed point"` arg is returned as one of the bins and the other bins are aligned to it based on the `bin_size`. Also note that each datetime bin represents the starting time of that bin:\r\n\r\n```\r\n\r\ndatatable(Date:datetime, Num:int)[\r\ndatetime(2018-02-24T15:14),3,\r\ndatetime(2018-02-23T16:14),4,\r\ndatetime(2018-02-26T15:14),5]\r\n| summarize sum(Num) by bin_at(Date, 1d, datetime(2018-02-24 15:14:00.0000000)) \r\n```\r\n\r\n|Date|sum_Num|\r\n|---|---|\r\n|2018-02-23 15:14:00.0000000|4|\r\n|2018-02-24 15:14:00.0000000|3|\r\n|2018-02-26 15:14:00.0000000|5|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/binatfunction","binatfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bin_auto",'Rounds values down to a fixed-size "bin", with control over the bin size and starting point provided by a query property.','## Syntax\r\n\r\n`bin_auto` `(` *Expression* `)`\r\n\r\n## Arguments\r\n\r\n* *Expression*: A scalar expression of a numeric type indicating the value to round.\r\n\r\n**Client Request Properties**\r\n\r\n* `query_bin_auto_size`: A numeric literal indicating the size of each bin.\r\n* `query_bin_auto_at`: A numeric literal indicating one value of *Expression* which is a "fixed point" (that is, a value `fixed_point`\r\n  for which `bin_auto(fixed_point)` == `fixed_point`.)\r\n\r\n## Returns\r\n\r\nThe nearest multiple of `query_bin_auto_at` below *Expression*, shifted so that `query_bin_auto_at`\r\nwill be translated into itself.',"```\r\nset query_bin_auto_size=1h;\r\nset query_bin_auto_at=datetime(2017-01-01 00:05);\r\nrange Timestamp from datetime(2017-01-01 00:05) to datetime(2017-01-01 02:00) step 1m\r\n| summarize count() by bin_auto(Timestamp)\r\n```\r\n\r\n|Timestamp                    | count_|\r\n|-----------------------------|-------|\r\n|2017-01-01 00:05:00.0000000  | 60    |\r\n|2017-01-01 01:05:00.0000000  | 56    |","https://docs.microsoft.com/azure/data-explorer/kusto/query/bin-autofunction","bin-autofunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_all_and","Accumulates values using the binary `AND` operation per summarization group (or in total, if summarization is done without grouping).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`binary_all_and` `(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: long number.\r\n\r\n## Returns\r\n\r\nReturns a value that is aggregated using the binary `AND` operation over records per summarization group (or in total, if summarization is done without grouping).","Producing 'cafe-food' using binary `AND` operations:\r\n\r\n```\r\ndatatable(num:long)\r\n[\r\n  0xFFFFFFFF, \r\n  0xFFFFF00F,\r\n  0xCFFFFFFD,\r\n  0xFAFEFFFF,\r\n]\r\n| summarize result = toupper(tohex(binary_all_and(num)))\r\n```\r\n\r\n|result|\r\n|---|\r\n|CAFEF00D|","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-all-and-aggfunction","binary-all-and-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_all_or","Accumulates values using the binary `OR` operation per summarization group (or in total, if summarization is done without grouping).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`binary_all_or` `(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: long number.\r\n\r\n## Returns\r\n\r\nReturns a value that is aggregated using the binary `OR` operation over records per summarization group (or in total, if summarization is done without grouping).","Producing 'cafe-food' using binary `OR` operations:\r\n\r\n```\r\ndatatable(num:long)\r\n[\r\n  0x88888008,\r\n  0x42000000,\r\n  0x00767000,\r\n  0x00000005, \r\n]\r\n| summarize result = toupper(tohex(binary_all_or(num)))\r\n```\r\n\r\n|result|\r\n|---|\r\n|CAFEF00D|","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-all-or-aggfunction","binary-all-or-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_all_xor","Accumulates values using the binary `XOR` operation per summarization group (or in total, if summarization is done without grouping).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`binary_all_xor` `(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: long number.\r\n\r\n## Returns\r\n\r\nReturns a value that is aggregated using the binary `XOR` operation over records per summarization group (or in total, if summarization is done without grouping).","Producing 'cafe-food' using binary `XOR` operations:\r\n\r\n```\r\ndatatable(num:long)\r\n[\r\n  0x44404440,\r\n  0x1E1E1E1E,\r\n  0x90ABBA09,\r\n  0x000B105A,\r\n]\r\n| summarize result = toupper(tohex(binary_all_xor(num)))\r\n```\r\n\r\n|result|\r\n|---|\r\n|CAFEF00D|","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-all-xor-aggfunction","binary-all-xor-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_and","Returns a result of the bitwise `and` operation between two values.","```\r\nbinary_and(x,y)\t\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_and(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: long numbers.\r\n\r\n## Returns\r\n\r\nReturns logical AND operation on a pair of numbers: num1 & num2.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-andfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_not","Returns a bitwise negation of the input value.","```\r\nbinary_not(x)\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_not(`*num1*`)`\r\n\r\n## Arguments\r\n\r\n* *num1*: numeric \r\n\r\n## Returns\r\n\r\nReturns logical NOT operation on a number: num1.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-notfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_or","Returns a result of the bitwise `or` operation of the two values.","```\r\nbinary_or(x,y)\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_or(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: long numbers.\r\n\r\n## Returns\r\n\r\nReturns logical OR operation on a pair of numbers: num1 | num2.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-orfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_shift_left","Returns binary shift left operation on a pair of numbers.","```\r\nbinary_shift_left(x,y)\t\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_shift_left(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: int numbers.\r\n\r\n## Returns\r\n\r\nReturns binary shift left operation on a pair of numbers: num1 << (num2%64).\r\nIf n is negative a NULL value is returned.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-shift-leftfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_shift_right","Returns binary shift right operation on a pair of numbers.","```\r\nbinary_shift_right(x,y)\t\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_shift_right(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: long numbers.\r\n\r\n## Returns\r\n\r\nReturns binary shift right operation on a pair of numbers: num1 >> (num2%64).\r\nIf n is negative a NULL value is returned.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-shift-rightfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"binary_xor","Returns a result of the bitwise `xor` operation of the two values.","```\r\nbinary_xor(x,y)\r\n```\r\n\r\n## Syntax\r\n\r\n`binary_xor(`*num1*`,` *num2* `)`\r\n\r\n## Arguments\r\n\r\n* *num1*, *num2*: long numbers.\r\n\r\n## Returns\r\n\r\nReturns logical XOR operation on a pair of numbers: num1 ^ num2.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/binary-xorfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"bitset_count_ones","Returns the number of set bits in the binary representation of a number.","```\r\nbitset_count_ones(42)\r\n```\r\n\r\n## Syntax\r\n\r\n`bitset_count_ones(`*num1*``)`\r\n\r\n## Arguments\r\n\r\n* *num1*: long or integer number.\r\n\r\n## Returns\r\n\r\nReturns the number of set bits in the binary representation of a number.","```\r\n// 42 = 32+8+2 : b'00101010' == 3 bits set\r\nprint ones = bitset_count_ones(42) \r\n```\r\n\r\n|ones|\r\n|---|\r\n|3|","https://docs.microsoft.com/azure/data-explorer/kusto/query/bitset-count-onesfunction","bitset-count-onesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"buildschema","Returns the minimal schema that admits all values of *DynamicExpr*.","* Can be used only in context of aggregation, inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`buildschema` `(`*DynamicExpr*`)`\r\n\r\n## Arguments\r\n\r\n* *DynamicExpr*: Expression that is used for the aggregation calculation. The parameter column type must be `dynamic`. \r\n\r\n## Returns\r\n\r\nThe maximum value of *`Expr`* across the group.\r\n\r\n> [!TIP] \r\n> If `buildschema(json_column)` gives a syntax error:\r\n>\r\n> > *Is your `json_column` a string rather than a dynamic object?*\r\n>\r\n> then use `buildschema(parsejson(json_column))`.",'Assume the input column has three dynamic values.\r\n\r\n* `{"x":1, "y":3.5}`\r\n* `{"x":"somevalue", "z":[1, 2, 3]}`\r\n* `{"y":{"w":"zzz"}, "t":["aa", "bb"], "z":["foo"]}`\r\n\r\n\r\nThe resulting schema would be:\r\n\r\n```\r\n{ \r\n    "x":["int", "string"],\r\n    "y":["double", {"w": "string"}],\r\n    "z":{"`indexer`": ["int", "string"]},\r\n    "t":{"`indexer`": "string"}\r\n}\r\n```\r\n\r\nThe schema tells us that:\r\n\r\n* The root object is a container with four properties named x, y, z, and t.\r\n* The property called "x" that could be of type "int" or of type "string".\r\n* The property called "y" that could be of type "double", or another container with a property called "w" of type "string".\r\n* The ``indexer`` keyword indicates that "z" and "t" are arrays.\r\n* Each item in the array "z" is of type "int" or of type "string".\r\n* "t" is an array of strings.\r\n* Every property is implicitly optional, and any array may be empty.\r\n\r\n\r\n### Schema model\r\n\r\nThe syntax of the returned schema is:\r\n\r\n```output\r\nContainer ::= \'{\' Named-type* \'}\';\r\nNamed-type ::= (name | \'"`indexer`"\') \':\' Type;\r\nType ::= Primitive-type | Union-type | Container;\r\nUnion-type ::= \'[\' Type* \']\';\r\nPrimitive-type ::= "int" | "string" | ...;\r\n```\r\n\r\nThe values are equivalent to a subset of the TypeScript type annotations, encoded as a Kusto dynamic value. \r\nIn Typescript, the example schema would be:\r\n\r\n```typescript\r\nvar someobject: \r\n{\r\n    x?: (number | string),\r\n    y?: (number | { w?: string}),\r\n    z?: { [n:number] : (int | string)},\r\n    t?: { [n:number]: string }\r\n}\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/buildschema-aggfunction","buildschema-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"case","Evaluates a list of predicates and returns the first result expression whose predicate is satisfied.","If neither of the predicates return `true`, the result of the last expression (the `else`) is returned.\r\nAll odd arguments (count starts at 1) must be expressions that evaluate to a  `boolean` value.\r\nAll even arguments (the `then`s) and the last argument (the `else`) must be of the same type.\r\n\r\n## Syntax\r\n\r\n`case(`*predicate_1*, *then_1*,\r\n       *predicate_2*, *then_2*,\r\n       *predicate_3*, *then_3*,\r\n       *else*`)`\r\n\r\n## Arguments\r\n\r\n* *predicate_i*: An expression that evaluates to a `boolean` value.\r\n* *then_i*: An expression that gets evaluated and its value is returned from the function if *predicate_i* is the first predicate that evaluates to `true`.\r\n* *else*: An expression that gets evaluated and its value is returned from the function if neither of the *predicate_i* evaluate to `true`.\r\n\r\n## Returns\r\n\r\nThe value of the first *then_i* whose *predicate_i* evaluates to `true`, or the value of *else* if neither of the predicates are satisfied.",'```\r\nrange Size from 1 to 15 step 2\r\n| extend bucket = case(Size <= 3, "Small", \r\n                       Size <= 10, "Medium", \r\n                       "Large")\r\n```\r\n\r\n|Size|bucket|\r\n|---|---|\r\n|1|Small|\r\n|3|Small|\r\n|5|Medium|\r\n|7|Medium|\r\n|9|Medium|\r\n|11|Large|\r\n|13|Large|\r\n|15|Large|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/casefunction","casefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ceiling","Calculates the smallest integer greater than, or equal to, the specified numeric expression.","## Syntax\r\n\r\n`ceiling(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The smallest integer greater than, or equal to, the specified numeric expression.","```\r\nprint c1 = ceiling(-1.1), c2 = ceiling(0), c3 = ceiling(0.9)\r\n```\r\n\r\n|c1|c2|c3|\r\n|---|---|---|\r\n|-1|0|1|","https://docs.microsoft.com/azure/data-explorer/kusto/query/ceilingfunction","ceilingfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cluster","Changes the reference of the query to a remote cluster.","```\r\ncluster('help').database('Sample').SomeTable\r\n```\r\n\r\n## Syntax\r\n\r\n`cluster(`*stringConstant*`)`\r\n\r\n## Arguments\r\n\r\n* *stringConstant*: Name of the cluster that is referenced. Cluster name can be either \r\na fully qualified DNS name, or a string that will be suffixed with `.kusto.windows.net`. Argument has to be _constant_ prior to the query's execution,\r\ni.e. cannot come from sub-query evaluation.\r\n\r\n**Notes**\r\n\r\n* For accessing database within the same cluster - use [database()](databasefunction.md) function.\r\n* More information about cross-cluster and cross-database queries available [here](cross-cluster-or-database-queries.md)","### Use cluster() to access remote cluster \r\n\r\nThe next query can be run on any of the Kusto clusters.\r\n\r\n```\r\ncluster('help').database('Samples').StormEvents | count\r\n\r\ncluster('help.kusto.windows.net').database('Samples').StormEvents | count  \r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use cluster() inside let statements \r\n\r\nThe same query as above can be rewritten to use inline function (let statement) that \r\nreceives a parameter `clusterName` - which is passed into the cluster() function.\r\n\r\n```\r\nlet foo = (clusterName:string)\r\n{\r\n    cluster(clusterName).database('Samples').StormEvents | count\r\n};\r\nfoo('help')\r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use cluster() inside Functions \r\n\r\nThe same query as above can be rewritten to be used in a function that \r\nreceives a parameter `clusterName` - which is passed into the cluster() function.\r\n\r\n```\r\n.create function foo(clusterName:string)\r\n{\r\n    cluster(clusterName).database('Samples').StormEvents | count\r\n};\r\n```\r\n\r\n**Note:** such functions can be used only locally and not in the cross-cluster query.","https://docs.microsoft.com/azure/data-explorer/kusto/query/clusterfunction","clusterfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"coalesce","Evaluates a list of expressions and returns the first non-null (or non-empty for string) expression.",'```\r\ncoalesce(tolong("not a number"), tolong("42"), 33) == 42\r\n```\r\n\r\n## Syntax\r\n\r\n`coalesce(`*expr_1*`, `*expr_2*`,` ...)\r\n\r\n## Arguments\r\n\r\n* *expr_i*: A scalar expression, to be evaluated.\r\n\r\n- All arguments must be of the same type.\r\n- Maximum of 64 arguments is supported.\r\n\r\n\r\n## Returns\r\n\r\nThe value of the first *expr_i* whose value is not null (or not-empty for string expressions).','```\r\nprint result=coalesce(tolong("not a number"), tolong("42"), 33)\r\n```\r\n\r\n|result|\r\n|---|\r\n|42|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/coalescefunction","coalescefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"consume","Consumes the tabular data stream handed to the operator.","The `consume` operator is mostly used for triggering the query side-effect without actually returning\r\nthe results back to the caller.\r\n\r\n```\r\nT | consume\r\n```\r\n\r\n## Syntax\r\n\r\n`consume` [`decodeblocks` `=` *DecodeBlocks*]\r\n\r\n## Arguments\r\n\r\n* *DecodeBlocks*: A constant Boolean value. If set to `true`, or if the request\r\n  property `perftrace` is set to `true`, the `consume` operator will not just\r\n  enumerate the records at its input, but actually force each value in those\r\n  records to be decompressed and decoded.\r\n\r\nThe `consume` operator can be used for estimating the\r\ncost of a query without actually delivering the results back to the client.\r\n(The estimation is not exact for a variety of reasons; for example, `consume`\r\nis calculated distributively, so `T | consume` will not transmit the table's\r\ndata between the nodes of the cluster.)","","https://docs.microsoft.com/azure/data-explorer/kusto/query/consumeoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"contains","Filters a record set for data containing a case-insensitive string. `contains` searches for characters rather than [terms](datatypes-string-operators.md#what-is-a-term) of three or more characters. The query scans the values in the column, which is slower than looking up a term in a term index.",'The following table provides a comparison of the `contains` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`contains`](contains-operator.md) |RHS occurs as a subsequence of LHS |No |`"FabriKam" contains "BRik"`|\r\n|[`!contains`](not-contains-operator.md) |RHS doesn\'t occur in LHS |No |`"Fabrikam" !contains "xyz"`|\r\n|[`contains_cs`](contains-cs-operator.md) |RHS occurs as a subsequence of LHS |Yes |`"FabriKam" contains_cs "Kam"`|\r\n|[`!contains_cs`](not-contains-cs-operator.md)   |RHS doesn\'t occur in LHS |Yes |`"Fabrikam" !contains_cs "Kam"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor better performance, try the case-sensitive version of an operator, for example, `contains_cs`, not `contains`. \r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for better performance, try `has` or `in`. Also, `has` works faster than `contains`, `startswith`, or `endswith`, however it is not as precise and could provide unwanted records.\r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `contains` `(`*expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State contains "enn"\r\n    | where event_count > 10\r\n    | project State, event_count\r\n    | render table\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|PENNSYLVANIA|1687|\r\n|TENNESSEE|1125|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/contains-operator","contains-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"contains_cs","Filters a record set for data containing a case-sensitive string. `contains` searches for characters rather than [terms](datatypes-string-operators.md#what-is-a-term) of three or more characters. The query scans the values in the column, which is slower than looking up a term in a term index.",'The following table provides a comparison of the `contains` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`contains`](contains-operator.md) |RHS occurs as a subsequence of LHS |No |`"FabriKam" contains "BRik"`|\r\n|[`!contains`](not-contains-operator.md) |RHS doesn\'t occur in LHS |No |`"Fabrikam" !contains "xyz"`|\r\n|[`contains_cs`](contains-cs-operator.md) |RHS occurs as a subsequence of LHS |Yes |`"FabriKam" contains_cs "Kam"`|\r\n|[`!contains_cs`](not-contains-cs-operator.md)   |RHS doesn\'t occur in LHS |Yes |`"Fabrikam" !contains_cs "Kam"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\nFor faster results, use the case-sensitive version of an operator, for example, `contains_cs`, not `contains`.\r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. Also, `has` works faster than `contains`, `startswith`, or `endswith`, however it is not as precise and could provide unwanted records.\r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `contains_cs` `(`*expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State contains_cs "AS"\r\n    | count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|-----|\r\n|8|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/contains-cs-operator","contains-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cos","Returns the cosine function.","## Syntax\r\n\r\n`cos(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The result of `cos(x)`","","https://docs.microsoft.com/azure/data-explorer/kusto/query/cosfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cosmosdb_sql_request","The `cosmosdb_sql_request` plugin sends a SQL query to a Cosmos DB SQL network endpoint and returns the results of the query. This plugin is primarily designed for querying small datasets, for example, enriching data with reference data stored in [Azure Cosmos DB](https://docs.microsoft.com/azure/cosmos-db/). The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.",'## Syntax\r\n\r\n`evaluate` `cosmosdb_sql_request` `(` *ConnectionString* `,` *SqlQuery* [`,` *SqlParameters* [`,` *Options*]] `)`\r\n\r\n## Arguments\r\n\r\n|Argument name | Description | Required/optional | \r\n|---|---|---|\r\n| *ConnectionString* | A `string` literal indicating the connection string that points to the Cosmos DB collection to query. It must include *AccountEndpoint*, *Database*, and *Collection*. It may include *AccountKey* if a master key is used for authentication. <br> **Example:** `\'AccountEndpoint=https://cosmosdbacc.documents.azure.com/ ;Database=MyDatabase;Collection=MyCollection;AccountKey=\' h\'R8PM...;\'`| Required |\r\n| *SqlQuery*| A `string` literal indicating the query to execute. | Required |\r\n| *SqlParameters* | A constant value of type `dynamic` that holds key-value pairs to pass as parameters along with the query. Parameter names must begin with `@`. | Optional |\r\n| *Options* | A constant value of type `dynamic` that holds more advanced settings as key-value pairs. | Optional |\r\n|| ----*Supported Options settings include:*-----\r\n|      `armResourceId` | Retrieve the API key from the Azure Resource Manager <br> **Example:** `/subscriptions/a0cd6542-7eaf-43d2-bbdd-b678a869aad1/resourceGroups/ cosmoddbresourcegrouput/providers/Microsoft.DocumentDb/databaseAccounts/cosmosdbacc`| \r\n|  `token` | Provide the Azure AD access token used to authenticate with the Azure Resource Manager.\r\n| `preferredLocations` | Control which region the data is queried from. <br> **Example:** `[\'East US\']` | |  \r\n\r\n## Set callout policy\r\n\r\nThe plugin makes callouts to the Cosmos DB. Make sure that the cluster\'s [callout policy](../management/calloutpolicy.md) enables calls of type `cosmosdb` to the target *CosmosDbUri*.\r\n\r\nThe following example shows how to define the callout policy for Cosmos DB. It\'s recommended to restrict it to specific endpoints (`my_endpoint1`, `my_endpoint2`).\r\n\r\n```\r\n[\r\n  {\r\n    "CalloutType": "CosmosDB",\r\n    "CalloutUriRegex": "my_endpoint1\\\\.documents\\\\.azure\\\\.com",\r\n    "CanCall": true\r\n  },\r\n  {\r\n    "CalloutType": "CosmosDB",\r\n    "CalloutUriRegex": "my_endpoint2\\\\.documents\\\\.azure\\\\.com",\r\n    "CanCall": true\r\n  }\r\n]\r\n```\r\n\r\nThe following example shows an alter callout policy command for `cosmosdb` *CalloutType*\r\n\r\n```\r\n.alter cluster policy callout @\'[{"CalloutType": "cosmosdb", "CalloutUriRegex": "\\\\.documents\\\\.azure\\\\.com", "CanCall": true}]\'\r\n```',"### Query Cosmos DB\r\n\r\nThe following example uses the *cosmosdb_sql_request* plugin to send a SQL query to fetch data from Cosmos DB using its SQL API.\r\n\r\n```\r\nevaluate cosmosdb_sql_request(\r\n  'AccountEndpoint=https://cosmosdbacc.documents.azure.com/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;',\r\n  'SELECT * from c')\r\n```\r\n\r\n### Query Cosmos DB with parameters\r\n\r\nThe following example uses SQL query parameters and queries the data from an alternate region. For more information, see [`preferredLocations`](https://docs.microsoft.com/azure/cosmos-db/tutorial-global-distribution-sql-api?tabs=dotnetv2%2Capi-async#preferred-locations).\r\n\r\n```\r\nevaluate cosmosdb_sql_request(\r\n    'AccountEndpoint=https://cosmosdbacc.documents.azure.com/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;',\r\n    \"SELECT c.id, c.lastName, @param0 as Column0 FROM c WHERE c.dob >= '1970-01-01T00:00:00Z'\",\r\n    dynamic({'@param0': datetime(2019-04-16 16:47:26.7423305)}),\r\n    dynamic({'preferredLocations': ['East US']}))\r\n| where lastName == 'Smith'\r\n```\r\n\r\n---\r\n\r\n> [!IMPORTANT]\r\n> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r\n\r\n# cosmosdb_sql_request plugin - Internal\r\n\r\nThe `cosmosdb_sql_request` plugin sends an SQL query to a Cosmos DB SQL network endpoint.\r\n\r\n- `evaluate` `cosmosdb_sql_request` `(` *ConnectionString* `,` *SqlQuery* [`,` *SqlParameters* [`,` *Options*]] `)`\r\n- `evaluate` `cosmosdb_sql_request` `(` *CosmosDbUri* `,` *authorization_key* `,` *database_name* `,` *collection_name* `,` *SqlQuery* `)`\r\n\r\n\r\n> [!NOTE]\r\n> It's recommended to use the syntax with `ConnectionString`. The other syntax is kept for backward-compatibility purposes.\r\n\r\n**Arguments**\r\n\r\n* *ConnectionString*: A `string` literal indicating the connection string that\r\n  points to the Cosmos DB collection to query. It must include `AccountEndpoint`, `Database`, `Collection`\r\n  and may include `AccountKey` if an API key is used for authentication. \r\n\r\n  Example:\r\n  `'AccountEndpoint=https://cosmosdbut.documents.azure.com:443/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;'`,\r\n  where the key is an [obfuscated string literal](./scalar-data-types/string.md#obfuscated-string-literals)\r\n  to prevent secret leakage.\r\n\r\n* *SqlQuery*: A `string` literal indicating the query to execute.\r\n\r\n* *SqlParameters*: A constant value of type `dynamic` that holds key-value pairs\r\n  to pass as parameters along with the query. Parameter names must begin with `@`. Optional.\r\n  \r\n* *Options*: A constant value of type `dynamic` that holds more advanced settings\r\n  as key-value pairs. Supported settings include `armResourceId` (Example: `/subscriptions/a0cd6542-7eaf-43d2-bbdd-b678a869aad1/resourceGroups/cosmoddbresourcegrouput/providers/Microsoft.DocumentDb/databaseAccounts/cosmosdbut`)\r\n  to retrieve the API key from ARM, `token` to provide the AAD access token used to authenticate with ARM, and `preferredLocations` (Example: `['East US']`)\r\n  to control which region the data is queried from. Optional.\r\n\r\n* *CosmosDbUri*: A `string` literal indicating the URI of the Cosmos DB endpoint\r\n  to connect to.\r\n\r\n* *authorization_key*: A `string` literal specifying CosmosDB resource or master token.\r\n  It is **strongly recommended** that this argument use the\r\n  [obfuscated string literals](./scalar-data-types/string.md#obfuscated-string-literals)\r\n  to prevent secret leakage.\r\n\r\n* *database_name*: A `string` literal specifying CosmosDB Database name.\r\n\r\n* *collection_name*: A `string` literal specifying CosmosDB collection name.\r\n\r\n\r\n**Restrictions**\r\n\r\nThe plugin makes callouts to Cosmos DB and so make sure that the\r\ncluster's [Callout policy](../management/calloutpolicy.md) enables calls of type\r\n`cosmosdb` to the target *CosmosDbUri*.\r\n\r\nBelow is an example of defining call-out policy for CosmosDB. It's recommended to restrict it to specific endpoints (`my_endpoint1`, `my_endpoint2`).\r\n\r\n```json\r\n[\r\n  {\r\n    \"CalloutType\": \"CosmosDB\",\r\n    \"CalloutUriRegex\": \"my_endpoint1.documents.azure.com\",\r\n    \"CanCall\": true\r\n  },\r\n  {\r\n    \"CalloutType\": \"CosmosDB\",\r\n    \"CalloutUriRegex\": \"my_endpoint2.documents.azure.com\",\r\n    \"CanCall\": true\r\n  }\r\n]\r\n```\r\n\r\n**Examples**\r\n\r\nUsing SQL query to fetch all rows from Cosmos DB:\r\n\r\n```\r\nevaluate cosmosdb_sql_request(\r\n  'AccountEndpoint=https://cosmosdbut.documents.azure.com:443/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;',\r\n  'SELECT * from c')\r\n```\r\n\r\nUsing SQL query parameters and querying the data from an alternate region:\r\n\r\n```\r\nevaluate cosmosdb_sql_request(\r\n    'AccountEndpoint=https://cosmosdbut.documents.azure.com:443/;Database=MyDatabase;Collection=MyCollection;AccountKey=' h'R8PM...;',\r\n    \"SELECT c.id, c.lastName, @param0 as Column0 FROM c WHERE c.dob >= '1970-01-01T00:00:00Z'\",\r\n    dynamic({'@param0': datetime(2019-04-16 16:47:26.7423305)}),\r\n    dynamic({'preferredLocations': ['East US']}))\r\n| where lastName == 'Smith'\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/cosmosdb-plugin","cosmosdb-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cot","Calculates the trigonometric cotangent of the specified angle, in radians.","## Syntax\r\n\r\n`cot(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\n* The cotangent function value for `x`","","https://docs.microsoft.com/azure/data-explorer/kusto/query/cotfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"count","Returns a count of the records per summarization group (or in total, if summarization is done without grouping).","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n* Use the [countif](countif-aggfunction.md) aggregation function\r\n  to count only records for which some predicate returns `true`.\r\n\r\n## Syntax\r\n\r\n`count` `(` `)`\r\n\r\n## Returns\r\n\r\nReturns a count of the records per summarization group (or in total, if summarization is done without grouping).",'Counting events in states starting with letter `W`:\r\n\r\n```\r\nStormEvents\r\n| where State startswith "W"\r\n| summarize Count=count() by State\r\n```\r\n\r\n|State|Count|\r\n|---|---|\r\n|WEST VIRGINIA|757|\r\n|WYOMING|396|\r\n|WASHINGTON|261|\r\n|WISCONSIN|1850|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/count-aggfunction","count-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"count","Returns the number of records in the input record set.","## Syntax\r\n\r\n`T | count`\r\n\r\n## Arguments\r\n\r\n*T*: The tabular data whose records are to be counted.\r\n\r\n## Returns\r\n\r\nThis function returns a table with a single record and column of type\r\n`long`. The value of the only cell is the number of records in *T*.","```\r\nStormEvents | count\r\n```\r\n\r\n## See also\r\n\r\nFor information about the count() aggregation function, see [count() (aggregation function)](count-aggfunction.md).","https://docs.microsoft.com/azure/data-explorer/kusto/query/countoperator","countoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"countif","Returns a count of rows for which *Predicate* evaluates to `true`. Can only be used only in context of aggregation inside [summarize](summarizeoperator.md).","## Syntax\r\n\r\n`countif` `(`*Predicate*`)`\r\n\r\n## Arguments\r\n\r\n*Predicate*: Expression that will be used for aggregation calculation. *Predicate* can be any scalar expression with return type of bool (evaluating to true/false).\r\n\r\n## Returns\r\n\r\nReturns a count of rows for which *Predicate* evaluates to `true`.",'```\r\nlet T = datatable(name:string, day_of_birth:long)\r\n[\r\n   "John", 9,\r\n   "Paul", 18,\r\n   "George", 25,\r\n   "Ringo", 7\r\n];\r\nT\r\n| summarize countif(strlen(name) > 4)\r\n```\r\n\r\n|countif_|\r\n|----|\r\n|2|\r\n\r\n## See also\r\n\r\n[count()](count-aggfunction.md) function, which counts rows without predicate expression.',"https://docs.microsoft.com/azure/data-explorer/kusto/query/countif-aggfunction","countif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"countof","Counts occurrences of a substring in a string. Plain string matches may overlap; regex matches do not.",'```\r\ncountof("The cat sat on the mat", "at") == 3\r\ncountof("The cat sat on the mat", @"\\b.at\\b", "regex") == 3\r\n```\r\n\r\n## Syntax\r\n\r\n`countof(`*source*`,` *search* [`,` *kind*]`)`\r\n\r\n## Arguments\r\n\r\n* *source*: A string.\r\n* *search*: The plain string or [regular expression](./re2.md) to match inside *source*.\r\n* *kind*: `"normal"|"regex"` Default `normal`. \r\n\r\n## Returns\r\n\r\nThe number of times that the search string can be matched in the container. Plain string matches may overlap; regex matches do not.','|Function call|Result|\r\n|---|---\r\n|`countof("aaa", "a")`| 3 \r\n|`countof("aaaa", "aa")`| 3 (not 2!)\r\n|`countof("ababa", "ab", "normal")`| 2\r\n|`countof("ababa", "aba")`| 2\r\n|`countof("ababa", "aba", "regex")`| 1\r\n|`countof("abcabc", "a.c", "regex")`| 2',"https://docs.microsoft.com/azure/data-explorer/kusto/query/countoffunction","countoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_cluster_endpoint","Returns the network endpoint (DNS name) of the current cluster being queried.","## Syntax\r\n\r\n`current_cluster_endpoint()`\r\n\r\n## Returns\r\n\r\nThe network endpoint (DNS name) of the current cluster being queried,\r\nas a value of type `string`.",'```\r\nprint strcat("This query executed on: ", current_cluster_endpoint())\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/current-cluster-endpoint-function","current-cluster-endpoint-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_database","Returns the name of the database in scope (database that all query\r\nentities are resolved against if no other database is specified).","## Syntax\r\n\r\n`current_database()`\r\n\r\n## Returns\r\n\r\nThe name of the database in scope as a value of type `string`.",'```\r\nprint strcat("Database in scope: ", current_database())\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/current-database-function","current-database-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_principal","Returns the current principal name that runs the query.","## Syntax\r\n\r\n`current_principal()`\r\n\r\n## Returns\r\n\r\nThe current principal fully qualified name (FQN) as a `string`.  \r\nThe string format is:  \r\n*PrinciplaType*`=`*PrincipalId*`;`*TenantId*","```\r\nprint fqn=current_principal()\r\n```\r\n\r\n|fqn|\r\n|---|\r\n|aaduser=346e950e-4a62-42bf-96f5-4cf4eac3f11e;72f988bf-86f1-41af-91ab-2d7cd011db47|","https://docs.microsoft.com/azure/data-explorer/kusto/query/current-principalfunction","current-principalfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_principal_details","Returns details of the principal running the query.","## Syntax\r\n\r\n`current_principal_details()`\r\n\r\n## Returns\r\n\r\nThe details of the current principal as a `dynamic`.",'```\r\nprint d=current_principal_details()\r\n```\r\n\r\n|d|\r\n|---|\r\n|{<br>  "UserPrincipalName": "user@fabrikam.com",<br>  "IdentityProvider": "https://sts.windows.net",<br>  "Authority": "72f988bf-86f1-41af-91ab-2d7cd011db47",<br>  "Mfa": "True",<br>  "Type": "AadUser",<br>  "DisplayName": "James Smith (upn: user@fabrikam.com)",<br>  "ObjectId": "346e950e-4a62-42bf-96f5-4cf4eac3f11e",<br>  "FQN": null,<br>  "Notes": null<br>}|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/current-principal-detailsfunction","current-principal-detailsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"current_principal_is_member_of","Checks group membership or principal identity of the current principal running the query.","## Syntax\r\n\r\n`current_principal_is_member_of`(`*list of string literals*`)\r\n\r\n## Arguments\r\n\r\n* *list of expressions* - a comma-separated list of string literals, where each literal represents an AAD principal. See [examples for AAD principals](../management/access-control/principals-and-identity-providers.md#aad-tenants).\r\n\r\n## Returns\r\n\r\nThe function returns:\r\n\r\n* `true`: if the current principal running the query was successfully matched for at least one input argument.\r\n* `false`: otherwise","```\r\nprint result=current_principal_is_member_of(\r\n    'aaduser=user1@fabrikam.com', \r\n    'aadgroup=group1@fabrikam.com',\r\n    'aadapp=66ad1332-3a94-4a69-9fa2-17732f093664;72f988bf-86f1-41af-91ab-2d7cd011db47'\r\n    )\r\n```\r\n\r\n| result |\r\n|--------|\r\n| false  |\r\n\r\nUsing dynamic array instead of multiple arguments:\r\n\r\n```\r\nprint result=current_principal_is_member_of(\r\n    dynamic([\r\n    'aaduser=user1@fabrikam.com', \r\n    'aadgroup=group1@fabrikam.com',\r\n    'aadapp=66ad1332-3a94-4a69-9fa2-17732f093664;72f988bf-86f1-41af-91ab-2d7cd011db47'\r\n    ]))\r\n```\r\n\r\n| result |\r\n|--------|\r\n| false  |","https://docs.microsoft.com/azure/data-explorer/kusto/query/current-principal-ismemberoffunction","current-principal-ismemberoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cursor_after","A predicate over the records of a table to compare their ingestion time\r\nagainst a database cursor.","## Syntax\r\n\r\n`cursor_after` `(` *RHS* `)`\r\n\r\n## Arguments\r\n\r\n* *RHS*: Either an empty string literal, or a valid database cursor value.\r\n\r\n## Returns\r\n\r\nA scalar value of type `bool` that indicates whether the record was ingested\r\nafter the database cursor *RHS* (`true`) or not (`false`).\r\n\r\n**Notes**\r\n\r\nSee [database cursors](../management/databasecursor.md) for additional\r\ndetails on database cursors.\r\n\r\nThis function can only be invoked on records of a table which has the\r\n[IngestionTime policy](../management/ingestiontimepolicy.md) enabled.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/cursorafterfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"cursor_before_or_at","A predicate over the records of a table to compare their ingestion time\r\nagainst a database cursor.","## Syntax\r\n\r\n`cursor_before_or_at` `(` *RHS* `)`\r\n\r\n## Arguments\r\n\r\n* *RHS*: Either an empty string literal, or a valid database cursor value.\r\n\r\n## Returns\r\n\r\nA scalar value of type `bool` that indicates whether the record was ingested\r\nbefore or at the database cursor *RHS* (`true`) or not (`false`).\r\n\r\n**Notes**\r\n\r\nSee [database cursors](../management/databasecursor.md) for additional\r\ndetails on database cursors.\r\n\r\nThis function can only be invoked on records of a table which has the\r\n[IngestionTime policy](../management/ingestiontimepolicy.md) enabled.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/cursorbeforeoratfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"database","Changes the reference of the query to a specific database within the cluster scope.","```\r\ndatabase('Sample').StormEvents\r\ncluster('help').database('Sample').StormEvents\r\n```\r\n\r\n> [!NOTE]\r\n> * For more information, see [cross-database and cross-cluster queries](cross-cluster-or-database-queries.md).\r\n> * For accessing remote cluster and remote database, see [cluster()](clusterfunction.md) scope function.\r\n\r\n## Syntax\r\n\r\n`database(`*stringConstant*`)`\r\n\r\n## Arguments\r\n\r\n* *stringConstant*: Name of the database that is referenced. Database identified can be either `DatabaseName` or `PrettyName`. Argument has to be _constant_ prior of query execution, i.e. cannot come from sub-query evaluation.","### Use database() to access table of other database\r\n\r\n```\r\ndatabase('Samples').StormEvents | count\r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use database() inside let statements \r\n\r\nThe same query as above can be rewritten to use inline function (let statement) that \r\nreceives a parameter `dbName` - which is passed into the database() function.\r\n\r\n```\r\nlet foo = (dbName:string)\r\n{\r\n    database(dbName).StormEvents | count\r\n};\r\nfoo('help')\r\n```\r\n\r\n|Count|\r\n|---|\r\n|59066|\r\n\r\n### Use database() inside functions \r\n\r\nThe same query as above can be rewritten to be used in a function that \r\nreceives a parameter `dbName` - which is passed into the database() function.\r\n\r\n```\r\n.create function foo(dbName:string)\r\n{\r\n    database(dbName).StormEvents | count\r\n};\r\n```\r\n\r\n> [!NOTE]\r\n> Such functions can be used only locally and not in the cross-cluster query.","https://docs.microsoft.com/azure/data-explorer/kusto/query/databasefunction","databasefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"datatable","Returns a table whose schema and values are defined in the query itself.","> [!NOTE]\r\n> This operator doesn't have a pipeline input.\r\n\r\n## Syntax\r\n\r\n`datatable` `(` *ColumnName* `:` *ColumnType* [`,` ...] `)` `[` *ScalarValue* [`,` *ScalarValue* ...] `]`\r\n\r\n## Arguments\r\n\r\n* *ColumnName*, *ColumnType*: These arguments define the schema of the table. The arguments use the same syntax as used when defining a table.\r\n  For more information, see [.create table](../management/create-table-command.md)).\r\n* *ScalarValue*: A constant scalar value to insert into the table. The number of values\r\n  must be an integer multiple of the columns in the table. The *n*'th value\r\n  must have a type that corresponds to column *n* % *NumColumns*.\r\n\r\n\r\n## Returns\r\n\r\nThis operator returns a data table of the given schema and data.",'```\r\ndatatable(Date:datetime, Event:string, MoreData:dynamic) [\r\n    datetime(1910-06-11), "Born", dynamic({"key1":"value1", "key2":"value2"}),\r\n    datetime(1930-01-01), "Enters Ecole Navale", dynamic({"key1":"value3", "key2":"value4"}),\r\n    datetime(1953-01-01), "Published first book", dynamic({"key1":"value5", "key2":"value6"}),\r\n    datetime(1997-06-25), "Died", dynamic({"key1":"value7", "key2":"value8"}),\r\n]\r\n| where strlen(Event) > 4\r\n| extend key2 = MoreData.key2\r\n```\r\n\r\nResult:\r\n\r\n|Date|Event|MoreData|key2|\r\n|---|---|---|---|\r\n|1930-01-01 00:00:00.0000000|Enters Ecole Navale|{<br>  "key1": "value3",<br>  "key2": "value4"<br>}|value4|\r\n|1953-01-01 00:00:00.0000000|Published first book|{<br>  "key1": "value5",<br>  "key2": "value6"<br>}|value6|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/datatableoperator","datatableoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_add","Calculates a new [datetime](./scalar-data-types/datetime.md) from a specified datepart multiplied by a specified amount, added to a specified [datetime](./scalar-data-types/datetime.md).","## Syntax\r\n\r\n`datetime_add(`*period*`,`*amount*`,`*datetime*`)`\r\n\r\n## Arguments\r\n\r\n* `period`: [string](./scalar-data-types/string.md). \r\n* `amount`: [integer](./scalar-data-types/int.md).\r\n* `datetime`: [datetime](./scalar-data-types/datetime.md) value.\r\n\r\nPossible values of *period*: \r\n\r\n- Year\r\n- Quarter\r\n- Month\r\n- Week\r\n- Day\r\n- Hour\r\n- Minute\r\n- Second\r\n- Millisecond\r\n- Microsecond\r\n- Nanosecond\r\n\r\n## Returns\r\n\r\nA date after a certain time/date interval has been added.","```\r\nprint  year = datetime_add('year',1,make_datetime(2017,1,1)),\r\nquarter = datetime_add('quarter',1,make_datetime(2017,1,1)),\r\nmonth = datetime_add('month',1,make_datetime(2017,1,1)),\r\nweek = datetime_add('week',1,make_datetime(2017,1,1)),\r\nday = datetime_add('day',1,make_datetime(2017,1,1)),\r\nhour = datetime_add('hour',1,make_datetime(2017,1,1)),\r\nminute = datetime_add('minute',1,make_datetime(2017,1,1)),\r\nsecond = datetime_add('second',1,make_datetime(2017,1,1))\r\n\r\n```\r\n\r\n|year|quarter|month|week|day|hour|minute|second|\r\n|---|---|---|---|---|---|---|---|\r\n|2018-01-01 00:00:00.0000000|2017-04-01 00:00:00.0000000|2017-02-01 00:00:00.0000000|2017-01-08 00:00:00.0000000|2017-01-02 00:00:00.0000000|2017-01-01 01:00:00.0000000|2017-01-01 00:01:00.0000000|2017-01-01 00:00:01.0000000|","https://docs.microsoft.com/azure/data-explorer/kusto/query/datetime-addfunction","datetime-addfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_diff","Calculates calendarian difference between two [datetime](./scalar-data-types/datetime.md) values.","## Syntax\r\n\r\n`datetime_diff(`*period*`,`*datetime_1*`,`*datetime_2*`)`\r\n\r\n## Arguments\r\n\r\n* `period`: `string`. \r\n* `datetime_1`: [datetime](./scalar-data-types/datetime.md) value.\r\n* `datetime_2`: [datetime](./scalar-data-types/datetime.md) value.\r\n\r\nPossible values of *period*: \r\n\r\n- Year\r\n- Quarter\r\n- Month\r\n- Week\r\n- Day\r\n- Hour\r\n- Minute\r\n- Second\r\n- Millisecond\r\n- Microsecond\r\n- Nanosecond\r\n\r\n## Returns\r\n\r\nAn integer, which represents amount of `periods` in the result of subtraction (`datetime_1` - `datetime_2`).","```\r\nprint\r\nyear = datetime_diff('year',datetime(2017-01-01),datetime(2000-12-31)),\r\nquarter = datetime_diff('quarter',datetime(2017-07-01),datetime(2017-03-30)),\r\nmonth = datetime_diff('month',datetime(2017-01-01),datetime(2015-12-30)),\r\nweek = datetime_diff('week',datetime(2017-10-29 00:00),datetime(2017-09-30 23:59)),\r\nday = datetime_diff('day',datetime(2017-10-29 00:00),datetime(2017-09-30 23:59)),\r\nhour = datetime_diff('hour',datetime(2017-10-31 01:00),datetime(2017-10-30 23:59)),\r\nminute = datetime_diff('minute',datetime(2017-10-30 23:05:01),datetime(2017-10-30 23:00:59)),\r\nsecond = datetime_diff('second',datetime(2017-10-30 23:00:10.100),datetime(2017-10-30 23:00:00.900)),\r\nmillisecond = datetime_diff('millisecond',datetime(2017-10-30 23:00:00.200100),datetime(2017-10-30 23:00:00.100900)),\r\nmicrosecond = datetime_diff('microsecond',datetime(2017-10-30 23:00:00.1009001),datetime(2017-10-30 23:00:00.1008009)),\r\nnanosecond = datetime_diff('nanosecond',datetime(2017-10-30 23:00:00.0000000),datetime(2017-10-30 23:00:00.0000007))\r\n```\r\n\r\n|year|quarter|month|week|day|hour|minute|second|millisecond|microsecond|nanosecond|\r\n|---|---|---|---|---|---|---|---|---|---|---|\r\n|17|2|13|5|29|2|5|10|100|100|-700|","https://docs.microsoft.com/azure/data-explorer/kusto/query/datetime-difffunction","datetime-difffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"datetime_part","Extracts the requested date part as an integer value.",'```\r\ndatetime_part("Day",datetime(2015-12-14))\r\n```\r\n\r\n## Syntax\r\n\r\n`datetime_part(`*part*`,`*datetime*`)`\r\n\r\n## Arguments\r\n\r\n* `date`: `datetime`\r\n* `part`: `string`\r\n\r\nPossible values of `part`: \r\n\r\n* Year\r\n* Quarter\r\n* Month\r\n* week_of_year\r\n* Day\r\n* DayOfYear\r\n* Hour\r\n* Minute\r\n* Second\r\n* Millisecond\r\n* Microsecond\r\n* Nanosecond\r\n\r\n## Returns\r\n\r\nAn integer representing the extracted part.\r\n\r\n> [!NOTE]\r\n> `week_of_year` returns an integer which represents the week number. The week number is calculated from the first week of a year, which is the one that includes the first Thursday.','```\r\nlet dt = datetime(2017-10-30 01:02:03.7654321); \r\nprint \r\nyear = datetime_part("year", dt),\r\nquarter = datetime_part("quarter", dt),\r\nmonth = datetime_part("month", dt),\r\nweekOfYear = datetime_part("week_of_year", dt),\r\nday = datetime_part("day", dt),\r\ndayOfYear = datetime_part("dayOfYear", dt),\r\nhour = datetime_part("hour", dt),\r\nminute = datetime_part("minute", dt),\r\nsecond = datetime_part("second", dt),\r\nmillisecond = datetime_part("millisecond", dt),\r\nmicrosecond = datetime_part("microsecond", dt),\r\nnanosecond = datetime_part("nanosecond", dt)\r\n\r\n```\r\n\r\n|year|quarter|month|weekOfYear|day|dayOfYear|hour|minute|second|millisecond|microsecond|nanosecond|\r\n|---|---|---|---|---|---|---|---|---|---|---|---|\r\n|2017|4|10|44|30|303|1|2|3|765|765432|765432100|\r\n\r\n> [!NOTE]\r\n> `weekofyear` is an obsolete variant of `week_of_year` part. `weekofyear` was not ISO 8601 compliant; the first week of a year was defined as the week with the year\'s first Wednesday in it.\r\n> `week_of_year` is ISO 8601 compliant; the first week of a year is defined as the week with the year\'s first Thursday in it. [For more information](https://en.wikipedia.org/wiki/ISO_8601#Week_dates).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/datetime-partfunction","datetime-partfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dayofmonth","Returns the integer number representing the day number of the given month","```\r\ndayofmonth(datetime(2015-12-14)) == 14\r\n```\r\n\r\n## Syntax\r\n\r\n`dayofmonth(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\n`day number` of the given month.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/dayofmonthfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dayofweek","Returns the integer number of days since the preceding Sunday, as a `timespan`.","```\r\ndayofweek(datetime(2015-12-14)) == 1d  // Monday\r\n```\r\n\r\n## Syntax\r\n\r\n`dayofweek(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\nThe `timespan` since midnight at the beginning of the preceding Sunday, rounded down to an integer number of days.","```\r\ndayofweek(datetime(1947-11-30 10:00:05))  // time(0.00:00:00), indicating Sunday\r\ndayofweek(datetime(1970-05-11))           // time(1.00:00:00), indicating Monday\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/dayofweekfunction","dayofweekfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dayofyear","Returns the integer number represents the day number of the given year.","```\r\ndayofyear(datetime(2015-12-14))\r\n```\r\n\r\n## Syntax\r\n\r\n`dayofyear(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\n`day number` of the given year.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/dayofyearfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcount","Returns an estimate for the number of distinct values that are taken by a scalar expression in the summary group.","> [!NOTE]\r\n> The `dcount()` aggregation function is primarily useful for estimating the cardinality of huge sets. It trades performance for accuracy, and may return a result that varies between executions. The order of inputs may have an effect on its output.\r\n\r\n## Syntax\r\n\r\n`dcount` `(`*Expr*[`,` *Accuracy*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: A scalar expression whose distinct values are to be counted.\r\n* *Accuracy*: An optional `int` literal that defines the requested estimation accuracy. See below for supported values. If unspecified, the default value\r\n  `1` is used.\r\n\r\n## Returns\r\n\r\nReturns an estimate of the number of distinct values of *`Expr`* in the group.",'```\r\nPageViewLog | summarize countries=dcount(country) by continent\r\n```\r\n\r\n![D count.](images/dcount-aggfunction/dcount.png)\r\nGet an exact count of distinct values of `V` grouped by `G`.\r\n\r\n```\r\nT | summarize by V, G | summarize count() by G\r\n```\r\n\r\nThis calculation requires a great amount of internal memory, since distinct values of `V` are multiplied by the number of distinct values of `G`.\r\nIt may result in memory errors or large execution times. \r\n`dcount()`provides a fast and reliable alternative:\r\n\r\n```\r\nT | summarize dcount(V) by G | count\r\n```\r\n\r\n## Estimation accuracy\r\n\r\nThe `dcount()` aggregate function uses a variant of the [HyperLogLog (HLL) algorithm](https://en.wikipedia.org/wiki/HyperLogLog),\r\nwhich does a stochastic estimation of set cardinality. The algorithm provides a "knob" that can be used to balance accuracy and execution time per memory size:\r\n\r\n|Accuracy|Error (%)|Entry count   |\r\n|--------|---------|--------------|\r\n|       0|      1.6|2<sup>12<\/sup>|\r\n|       1|      0.8|2<sup>14<\/sup>|\r\n|       2|      0.4|2<sup>16<\/sup>|\r\n|       3|     0.28|2<sup>17<\/sup>|\r\n|       4|      0.2|2<sup>18<\/sup>|\r\n\r\n> [!NOTE]\r\n> The "entry count" column is the number of 1-byte counters in the HLL implementation.\r\n\r\nThe algorithm includes some provisions for doing a perfect count (zero error), if the set cardinality is small enough:\r\n\r\n* When the accuracy level is `1`, 1000 values are returned\r\n* When the accuracy level is `2`, 8000 values are returned\r\n\r\n\r\nThe error bound is probabilistic, not a theoretical bound. The value is the standard deviation of error distribution (the sigma), and 99.7% of the estimations will have a relative error of under 3 x sigma.\r\n\r\nThe following image shows the probability distribution function of the relative\r\nestimation error, in percentages, for all supported accuracy settings:\r\n\r\n![hll error distribution.](images/dcount-aggfunction/hll-error-distribution.png)',"https://docs.microsoft.com/azure/data-explorer/kusto/query/dcount-aggfunction","dcount-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcount_hll","Calculates the dcount from hll results (that were generated by [hll](hll-aggfunction.md) or [hll_merge](hll-merge-aggfunction.md)).","Read about the [underlying algorithm (*H*yper*L*og*L*og) and estimation accuracy](dcount-aggfunction.md#estimation-accuracy).\r\n\r\n## Syntax\r\n\r\n`dcount_hll(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that was generated by [hll](hll-aggfunction.md) or [hll-merge](hll-merge-aggfunction.md)\r\n\r\n## Returns\r\n\r\nThe distinct count of each value in *Expr*","```\r\nStormEvents\r\n| summarize hllRes = hll(DamageProperty) by bin(StartTime,10m)\r\n| summarize hllMerged = hll_merge(hllRes)\r\n| project dcount_hll(hllMerged)\r\n```\r\n\r\n|dcount_hll_hllMerged|\r\n|---|\r\n|315|","https://docs.microsoft.com/azure/data-explorer/kusto/query/dcount-hllfunction","dcount-hllfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcount_intersect","Calculates intersection between N sets based on `hll` values (N in range of [2..16]), and returns N `dcount` values. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","Given sets S<sub>1<\/sub>, S<sub>2<\/sub>, .. S<sub>n<\/sub> - returns values will be representing distinct counts of:  \r\nS<sub>1<\/sub>,  \r\nS<sub>1<\/sub> \u2229 S<sub>2<\/sub>,  \r\nS<sub>1<\/sub> \u2229 S<sub>2<\/sub> \u2229 S<sub>3<\/sub>,  \r\n... ,  \r\nS<sub>1<\/sub> \u2229 S<sub>2<\/sub> \u2229 ... \u2229 S<sub>n<\/sub>\r\n\r\n```\r\nT | evaluate dcount_intersect(hll_1, hll_2, hll_3)\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| evaluate` `dcount_intersect(`*hll_1*, *hll_2*, [`,` *hll_3*`,` ...]`)`\r\n\r\n## Arguments\r\n\r\n* *T*: The input tabular expression.\r\n* *hll_i*: the values of set S<sub>i<\/sub> calculated with [`hll()`](./hll-aggfunction.md) function.\r\n\r\n## Returns\r\n\r\nReturns a table with N `dcount` values (per column, representing set intersections).\r\nColumn names are s0, s1, ... (until n-1).","```\r\n// Generate numbers from 1 to 100\r\nrange x from 1 to 100 step 1\r\n| extend isEven = (x % 2 == 0), isMod3 = (x % 3 == 0), isMod5 = (x % 5 == 0)\r\n// Calculate conditional HLL values (note that '0' is included in each of them as additional value, so we will subtract it later)\r\n| summarize hll_even = hll(iif(isEven, x, 0), 2),\r\n            hll_mod3 = hll(iif(isMod3, x, 0), 2),\r\n            hll_mod5 = hll(iif(isMod5, x, 0), 2) \r\n// Invoke the plugin that calculates dcount intersections         \r\n| evaluate dcount_intersect(hll_even, hll_mod3, hll_mod5)\r\n| project evenNumbers = s0 - 1,             //                             100 / 2 = 50\r\n          even_and_mod3 = s1 - 1,           // gcd(2,3) = 6, therefor:     100 / 6 = 16\r\n          even_and_mod3_and_mod5 = s2 - 1   // gcd(2,3,5) is 30, therefore: 100 / 30 = 3 \r\n```\r\n\r\n|evenNumbers|even_and_mod3|even_and_mod3_and_mod5|\r\n|---|---|---|\r\n|50|16|3|","https://docs.microsoft.com/azure/data-explorer/kusto/query/dcount-intersect-plugin","dcount-intersect-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dcountif","Returns an estimate of the number of distinct values of *Expr* of rows for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md).\r\n\r\nRead about the [estimation accuracy](dcount-aggfunction.md#estimation-accuracy).\r\n\r\n## Syntax\r\n\r\n`dcountif` `(`*Expr*, *Predicate*, [`,` *Accuracy*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n* *Predicate*: Expression that will be used to filter rows.\r\n* *Accuracy*, if specified, controls the balance between speed and accuracy.\r\n    * `0` = the least accurate and fastest calculation. 1.6% error\r\n    * `1` = the default, which balances accuracy and calculation time; about 0.8% error.\r\n    * `2` = accurate and slow calculation; about 0.4% error.\r\n    * `3` = extra accurate and slow calculation; about 0.28% error.\r\n    * `4` = super accurate and slowest calculation; about 0.2% error.\r\n\t\r\n\r\n## Returns\r\n\r\nReturns an estimate of the number of distinct values of *Expr*  of rows for which *Predicate* evaluates to `true` in the group.",'```\r\nPageViewLog | summarize countries=dcountif(country, country startswith "United") by continent\r\n```\r\n\r\n**Tip: Offset error**\r\n\r\n`dcountif()` might result in a one-off error in the edge cases where all rows\r\npass, or none of the rows pass, the `Predicate` expression',"https://docs.microsoft.com/azure/data-explorer/kusto/query/dcountif-aggfunction","dcountif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"degrees","Converts angle value in radians into value in degrees, using formula `degrees = (180 / PI ) * angle_in_radians`","## Syntax\r\n\r\n`degrees(`*a*`)`\r\n\r\n## Arguments\r\n\r\n* *a*: Angle in radians (a real number).\r\n\r\n## Returns\r\n\r\n* The corresponding angle in degrees for an angle specified in radians.","```\r\nprint degrees0 = degrees(pi()/4), degrees1 = degrees(pi()*1.5), degrees2 = degrees(0)\r\n\r\n```\r\n\r\n|degrees0|degrees1|degrees2|\r\n|---|---|---|\r\n|45|270|0|","https://docs.microsoft.com/azure/data-explorer/kusto/query/degreesfunction","degreesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"diff","Compares two data sets of the same structure and finds patterns of discrete attributes (dimensions) that characterize differences between the two data sets. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.",'`Diffpatterns` was developed to help analyze failures (for example, by comparing failures to non-failures in a given time frame), but can potentially find differences between any two data sets of the same structure. \r\n\r\n> [!NOTE]\r\n> `diffpatterns` aims to find significant patterns (that capture portions of the data difference between the sets) and isn\'t meant for row-by-row differences.\r\n\r\n## Syntax\r\n\r\n`T | evaluate diffpatterns(SplitColumn, SplitValueA, SplitValueB [,\u00a0WeightColumn,\u00a0Threshold, MaxDimensions,\u00a0CustomWildcard, ...])` \r\n\r\n## Arguments \r\n\r\n### Required arguments\r\n\r\n* SplitColumn - *column_name*\r\n    Tells the algorithm how to split the query into data sets. According to the specified values for the SplitValueA and SplitValueB arguments (see below), the algorithm splits the query into two data sets, \u201cA\u201d and \u201cB\u201d, and analyze the differences between them. As such, the split column must have at least two distinct values.\r\n* SplitValueA - *string*\r\n    A string representation of one of the values in the SplitColumn that was specified. All the rows that have this value in their SplitColumn considered as data set \u201cA\u201d.\r\n* SplitValueB - *string*\r\n    A string representation of one of the values in the SplitColumn that was specified. All the rows that have this value in their SplitColumn considered as data set  \u201cB\u201d.\r\n    Example: `T | extend splitColumn=iff(request_responseCode == 200, "Success" , "Failure") | evaluate diffpatterns(splitColumn, "Success","Failure") `\r\n\r\n### Optional arguments\r\n\r\nAll other arguments are optional, but they must be ordered as below. To indicate that the default value should be used, put the string tilde value - \'~\' (see examples below).\r\n\r\n* WeightColumn - *column_name*\r\n    Considers each row in the input according to the specified weight (by default each row has a weight of \'1\'). The argument must be a name of a numeric column (for example, `int`, `long`, `real`).\r\n    A common usage of a weight column is to take into account sampling or bucketing/aggregation of the data that is already embedded into each row.\r\n    \r\n    Example: `T | extend splitColumn=iff(request_responseCode == 200, "Success" , "Failure") | evaluate diffpatterns(splitColumn, "Success","Failure", sample_Count) `\r\n* Threshold - 0.015 < *double* < 1 [default: 0.05]\r\n    Sets the minimal pattern (ratio) difference between the two sets.\r\n    Example:  `T | extend splitColumn = iff(request-responseCode == 200, "Success" , "Failure") | evaluate diffpatterns(splitColumn, "Success","Failure", "~", 0.04)`\r\n* MaxDimensions  - 0 < *int* [default: unlimited]\r\n    Sets the maximum number of uncorrelated dimensions per result pattern. By specifying a limit, you decrease the query runtime.\r\n    Example:  `T | extend splitColumn = iff(request-responseCode == 200, "Success" , "Failure") | evaluate diffpatterns(splitColumn, "Success","Failure", "~", "~", 3)`\r\n* CustomWildcard - *"any-value-per-type"*\r\n    Sets the wildcard value for a specific type in the result table that will indicate that the current pattern doesn\'t have a restriction on this column.\r\n    Default is null, for string default is an empty string. If the default is a viable value in the data, a different wildcard value should be used (for example, `*`).\r\n    See an example below.\r\n    Example: `T | extend splitColumn = iff(request-responseCode == 200, "Success" , "Failure") | evaluate diffpatterns(splitColumn, "Success","Failure", "~", "~", "~", int(-1), double(-1), long(0), datetime(1900-1-1))`\r\n\r\n## Returns\r\n\r\n`Diffpatterns` returns a small set of patterns that capture different portions of the data in the two sets (that is, a pattern capturing a large percentage of the rows in the first data set and low percentage of the rows in the second set). Each pattern is represented by a row in the results.\r\n\r\nThe result of `diffpatterns` returns the following columns:\r\n\r\n* SegmentId: the identity assigned to the pattern in the current query (note: IDs are not guaranteed to be the same in repeating queries).\r\n* CountA: the number of rows captured by the pattern in Set A (Set A is the equivalent of `where tostring(splitColumn) == SplitValueA`).\r\n* CountB: the number of rows captured by the pattern in Set B (Set B is the equivalent of `where tostring(splitColumn) == SplitValueB`).\r\n* PercentA: the percentage of rows in Set A captured by the pattern (100.0 * CountA / count(SetA)).\r\n* PercentB: the percentage of rows in Set B captured by the pattern (100.0 * CountB / count(SetB)).\r\n* PercentDiffAB: the absolute percentage point difference between A and B (|PercentA - PercentB|) is the main measure of significance of patterns in describing the difference between the two sets.\r\n* Rest of the columns: are the original schema of the input and describe the pattern, each row (pattern) reresents the intersection of the non-wildcard values of the columns (equivalent of `where col1==val1 and col2==val2 and ... colN=valN` for each non-wildcard value in the row).\r\n\r\nFor each pattern, columns that are not set in the pattern (that is, without restriction on a specific value) will contain a wildcard value, which is null by default. See in the Arguments section below how wildcards can be manually changed.\r\n\r\n* Note: the patterns are often not distinct. They may be overlapping, and usually do not cover all the original rows. Some rows may not fall under any pattern.\r\n\r\n> [!TIP]\r\n> * Use [where](./whereoperator.md) and [project](./projectoperator.md) in the input pipe to reduce the data to just what you\'re interested in.\r\n> * When you find an interesting row, you might want to drill into it further by adding its specific values to your `where` filter.','```\r\nStormEvents \r\n| where monthofyear(StartTime) == 5\r\n| extend Damage = iff(DamageCrops + DamageProperty > 0 , 1 , 0)\r\n| project State , EventType , Source , Damage, DamageCrops\r\n| evaluate diffpatterns(Damage, "0", "1" )\r\n```\r\n\r\n|SegmentId|CountA|CountB|PercentA|PercentB|PercentDiffAB|State|EventType|Source|DamageCrops|\r\n|---|---|---|---|---|---|---|---|---|---|\r\n|0|2278|93|49.8|7.1|42.7||Hail||0|\r\n|1|779|512|17.03|39.08|22.05||Thunderstorm Wind|||\r\n|2|1098|118|24.01|9.01|15|||Trained Spotter|0|\r\n|3|136|158|2.97|12.06|9.09|||Newspaper||\r\n|4|359|214|7.85|16.34|8.49||Flash Flood|||\r\n|5|50|122|1.09|9.31|8.22|IOWA||||\r\n|6|655|279|14.32|21.3|6.98|||Law Enforcement||\r\n|7|150|117|3.28|8.93|5.65||Flood|||\r\n|8|362|176|7.91|13.44|5.52|||Emergency Manager||\r\n\r\n---\r\n\r\n> [!IMPORTANT]\r\n> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r\n\r\n# diffpatterns plugin - Internal\r\n\r\nIf you have questions about diffpatterns or other ML related workflows in Kusto you can post them on the following DL: [KustoML](mailto:kustoML@microsoft.com).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/diffpatternsplugin","diffpatternsplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"diffpatterns_text","Compares two data sets of string values and finds text patterns that characterize differences between the two data sets. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","The `diffpatterns_text` returns a set of text patterns that capture different portions of the data in the two sets (i.e. a pattern capturing a large percentage of the rows when the condition is `true` and low percentage of the rows when the condition is `false`). The patterns are built from consecutive tokens (separated by white space), with a token from the text column or a `*` representing a wildcard. Each pattern is represented by a row in the results.\r\n\r\n## Syntax\r\n\r\n`T | evaluate diffpatterns_text(`TextColumn, BooleanCondition [, MinTokens,\u00a0Threshold , MaxTokens]`)` \r\n\r\n## Arguments\r\n\r\n### Required arguments\r\n\r\n* TextColumn - *column_name*\r\n    The text column to analyze, must be of type string.\r\n    \r\n* BooleanCondition - *Boolean expression*\r\n    Defines how to generate the two record subsets to compare to the input table. The algorithm splits the query into two data sets, \u201cTrue\u201d and \u201cFalse\u201d according to the condition, then analyzes the (text) differences between them. \r\n\r\n### Optional arguments\r\n\r\nAll other arguments are optional, but they must be ordered as below. \r\n\r\n* MinTokens  - 0 < *int* < 200 [default: 1]\r\n    Sets the minimal number of non-wildcard tokens per result pattern.\r\n* Threshold - 0.015 < *double* < 1 [default: 0.05]\r\n    Sets the minimal pattern (ratio) difference between the two sets (see [diffpatterns](diffpatternsplugin.md)).\r\n* MaxTokens  - 0 < *int* [default: 20]\r\n    Sets the maximal number of tokens (from the beginning) per result pattern, specifying a lower limit decreases the query runtime.\r\n\r\n## Returns\r\n\r\nThe result of diffpatterns_text returns the following columns:\r\n\r\n* Count_of_True: The number of rows matching the pattern when the condition is `true`.\r\n* Count_of_False: The number of rows matching the pattern when the condition is `false`.\r\n* Percent_of_True: The percentage of rows matching the pattern from the rows when the condition is `true`.\r\n* Percent_of_False: The percentage of rows matching the pattern from the rows when the condition is `false`.\r\n* Pattern: The text pattern containing tokens from the text string and '`*`' for wildcards. \r\n\r\n> [!NOTE]\r\n> The patterns aren't necessarily distinct and may not provide full coverage of the data set. The patterns may be overlapping and some rows may not match any pattern.",'The following example uses data from the StormEvents table in the help cluster. To access this data, sign in to [https://dataexplorer.azure.com/clusters/help/databases/Samples](https://dataexplorer.azure.com/clusters/help/databases/Samples). In the left menu, browse to **help** > **Samples** > **Tables** > **Storm_Events**.\r\n\r\n```\r\nStormEvents     \r\n| where EventNarrative != "" and monthofyear(StartTime) > 1 and monthofyear(StartTime) < 9\r\n| where EventType == "Drought" or EventType == "Extreme Cold/Wind Chill"\r\n| evaluate diffpatterns_text(EpisodeNarrative, EventType == "Extreme Cold/Wind Chill", 2)\r\n```\r\n\r\n|Count_of_True|Count_of_False|Percent_of_True|Percent_of_False|Pattern|\r\n|---|---|---|---|---|\r\n|11|0|6.29|0|Winds shifting northwest in * wake * a surface trough brought heavy lake effect snowfall downwind * Lake Superior from|\r\n|9|0|5.14|0|Canadian high pressure settled * * region * produced the coldest temperatures since February * 2006. Durations * freezing temperatures|\r\n|0|34|0|6.24|* * * * * * * * * * * * * * * * * * West Tennessee,|\r\n|0|42|0|7.71|* * * * * * caused * * * * * * * * across western Colorado. *|\r\n|0|45|0|8.26|* * below normal *|\r\n|0|110|0|20.18|Below normal *|\r\n\r\n---\r\n\r\n> [!IMPORTANT]\r\n> The content below is Microsoft confidential(not available in the [public site](https://docs.microsoft.com/en-us/azure/data-explorer/))\r\n\r\n# diffpatterns_text plugin - Internal\r\n\r\nIf you have questions about diffpatterns_text or other ML related workflows in Kusto you can post them on the following DL: [KustoML](mailto:kustoML@microsoft.com).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/diffpatterns-textplugin","diffpatterns-textplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"distinct","Produces a table with the distinct combination of the provided columns of the input table.","```\r\nT | distinct Column1, Column2\r\n```\r\n\r\nProduces a table with the distinct combination of all columns in the input table.\r\n\r\n```\r\nT | distinct *\r\n```","Shows the distinct combination of fruit and price.\r\n\r\n```\r\nTable | distinct fruit, price\r\n```\r\n\r\n![Two tables. One has suppliers, fruit types, and prices, with some fruit-price combinations repeated. The second table lists only unique combinations.](images/distinctoperator/distinct.PNG)\r\n**Notes**\r\n\r\n* Unlike `summarize by ...`, the `distinct` operator supports providing an asterisk (`*`) as the group key, making it easier to use for wide tables.\r\n* If the group by keys are of high cardinalities, using `summarize by ...` with the [shuffle strategy](shufflequery.md) could be useful.","https://docs.microsoft.com/azure/data-explorer/kusto/query/distinctoperator","distinctoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"dynamic_to_json","Converts a scalar value of type `dynamic` to a canonical `string` representation.","## Syntax\r\n\r\n`dynamic_to_json(Expr)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression of `dynamic` type. The function accepts one argument.\r\n\r\n## Returns\r\n\r\nReturns a canonical representation of the input as a value of type `string`,\r\naccording to the following rules:\r\n\r\n* If the input is a scalar value of type other than `dynamic`,\r\n   the output is the application of `tostring()` to that value.\r\n* If the input in an array of values, the output is composed of the\r\n   characters `[`, `,`, and `]` interspersed with the canonical representation\r\n   described here of each array element.\r\n* If the input is a property bag, the output is composed of the characters\r\n   `{`, `,`, and `}` interspersed with the colon (`:`)-delimited name/value pairs\r\n   of the properties. The pairs are sorted by the names, and the values\r\n   are in the canonical representation described here of each array element.","Expression:\r\n\r\n```\r\nlet bag1 = dynamic_to_json(\r\n  dynamic({\r\n    'Y10':dynamic({}),\r\n    'X8': dynamic({\r\n      'c3':1,\r\n      'd8':5,\r\n      'a4':6\r\n    }),\r\n    'D1':114,\r\n    'A1':12,\r\n    'B1':2,\r\n    'C1':3,\r\n    'A14':[15, 13, 18]\r\n}));\r\nlet bag2 = dynamic_to_json(\r\n  dynamic({\r\n    'X8': dynamic({\r\n      'a4':6,\r\n      'c3':1,\r\n      'd8':5\r\n    }),\r\n    'A14':[15, 13, 18],\r\n    'C1':3,\r\n    'B1':2,\r\n    'Y10': dynamic({}),\r\n    'A1':12, 'D1':114\r\n  }));\r\nprint AreEqual=bag1 == bag2, Result=bag1\r\n```\r\n\r\nResult:\r\n\r\n|AreEqual|Result|\r\n|---|---|\r\n|true|{\"A1\":12,\"A14\":[15,13,18],\"B1\":2,\"C1\":3,\"D1\":114,\"X8\":{\"a4\":6,\"c3\":1,\"d8\":5},\"Y10\":{}}|","https://docs.microsoft.com/azure/data-explorer/kusto/query/dynamic-to-json-function","dynamic-to-json-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofday","Returns the end of the day containing the date, shifted by an offset, if provided.","## Syntax\r\n\r\n`endofday(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset days from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the end of the day for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project dayEnd = endofday(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|dayEnd|\r\n|---|\r\n|2016-12-31 23:59:59.9999999|\r\n|2017-01-01 23:59:59.9999999|\r\n|2017-01-02 23:59:59.9999999|","https://docs.microsoft.com/azure/data-explorer/kusto/query/endofdayfunction","endofdayfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofmonth","Returns the end of the month containing the date, shifted by an offset, if provided.","## Syntax\r\n\r\n`endofmonth(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset months from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the end of the month for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project monthEnd = endofmonth(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|monthEnd|\r\n|---|\r\n|2016-12-31 23:59:59.9999999|\r\n|2017-01-31 23:59:59.9999999|\r\n|2017-02-28 23:59:59.9999999|","https://docs.microsoft.com/azure/data-explorer/kusto/query/endofmonthfunction","endofmonthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofweek","Returns the end of the week containing the date, shifted by an offset, if provided.","Last day of the week is considered to be a Saturday.\r\n\r\n## Syntax\r\n\r\n`endofweek(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset weeks from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the end of the week for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project weekEnd = endofweek(datetime(2017-01-01 10:10:17), offset)  \r\n\r\n```\r\n\r\n|weekEnd|\r\n|---|\r\n|2016-12-31 23:59:59.9999999|\r\n|2017-01-07 23:59:59.9999999|\r\n|2017-01-14 23:59:59.9999999|","https://docs.microsoft.com/azure/data-explorer/kusto/query/endofweekfunction","endofweekfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"endofyear","Returns the end of the year containing the date, shifted by an offset, if provided.","## Syntax\r\n\r\n`endofyear(`*date* [`,`*offset*]`)`\r\n\r\n## Arguments\r\n\r\n* `date`: The input date.\r\n* `offset`: An optional number of offset years from the input date (integer, default - 0).\r\n\r\n## Returns\r\n\r\nA datetime representing the end of the year for the given *date* value, with the offset, if specified.","```\r\n  range offset from -1 to 1 step 1\r\n | project yearEnd = endofyear(datetime(2017-01-01 10:10:17), offset) \r\n```\r\n\r\n|yearEnd|\r\n|---|\r\n|2016-12-31 23:59:59.9999999|\r\n|2017-12-31 23:59:59.9999999|\r\n|2018-12-31 23:59:59.9999999|","https://docs.microsoft.com/azure/data-explorer/kusto/query/endofyearfunction","endofyearfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"endswith","Filters a record set for data with a case-insensitive ending string.",'The following table provides a comparison of the `endswith` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`endswith`](endswith-operator.md) |RHS is a closing subsequence of LHS |No |`"Fabrikam" endswith "Kam"`|\r\n|[`!endswith`](not-endswith-operator.md) |RHS isn\'t a closing subsequence of LHS |No |`"Fabrikam" !endswith "brik"`|\r\n|[`endswith_cs`](endswith-cs-operator.md) |RHS is a closing subsequence of LHS |Yes |`"Fabrikam" endswith_cs "kam"`|\r\n|[`!endswith_cs`](not-endswith-cs-operator.md) |RHS isn\'t a closing subsequence of LHS |Yes |`"Fabrikam" !endswith_cs "brik"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `endswith_cs`, not `endswith`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `endswith` `(`*expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State endswith "sas"\r\n    | where event_count > 10\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|KANSAS|3166|\r\n|ARKANSAS|1028|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/endswith-operator","endswith-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"endswith_cs","Filters a record set for data with a case-sensitive ending string.",'The following table provides a comparison of the `endswith` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`endswith`](endswith-operator.md) |RHS is a closing subsequence of LHS |No |`"Fabrikam" endswith "Kam"`|\r\n|[`!endswith`](not-endswith-operator.md) |RHS isn\'t a closing subsequence of LHS |No |`"Fabrikam" !endswith "brik"`|\r\n|[`endswith_cs`](endswith-cs-operator.md) |RHS is a closing subsequence of LHS |Yes |`"Fabrikam" endswith_cs "kam"`|\r\n|[`!endswith_cs`](not-endswith-cs-operator.md) |RHS isn\'t a closing subsequence of LHS |Yes |`"Fabrikam" !endswith_cs "brik"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `endswith_cs`, not `endswith`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `endswith_cs` `(`*expression*`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State endswith_cs "IDA"\r\n    | count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|-----|\r\n|1|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/endswith-cs-operator","endswith-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"estimate_data_size","Returns an estimated data size in bytes of the selected columns of the tabular expression.","```\r\nestimate_data_size(*)\r\nestimate_data_size(Col1, Col2, Col3)\r\n```\r\n\r\n## Syntax\r\n\r\n`estimate_data_size(*)`\r\n\r\n`estimate_data_size(`*col1*`, `*col2*`, `...`)`\r\n\r\n## Arguments\r\n\r\n* *col1*, *col2*: Selection of column references in the source tabular expression that are used for data size estimation. To include all columns, use `*` (asterisk) syntax.\r\n\r\n## Returns\r\n\r\n* The estimated data size  in bytes of the record size. Estimation is based on data types and values lengths.","Calculating total data size using `estimate_data_size()`:\r\n\r\n```\r\nrange x from 1 to 10 step 1                    // x (long) is 8 \r\n| extend Text = '1234567890'                   // Text length is 10  \r\n| summarize Total=sum(estimate_data_size(*))   // (8+10)x10 = 180\r\n```\r\n\r\n|Total|\r\n|---|\r\n|180|","https://docs.microsoft.com/azure/data-explorer/kusto/query/estimate-data-sizefunction","estimate-data-sizefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"evaluate","Invokes a service-side query extension (plugin).","The `evaluate` operator is a tabular operator that provides the ability to\r\ninvoke query language extensions known as **plugins**. Plugins can be enabled\r\nor disabled (unlike other language constructs, which are always available),\r\nand aren't \"bound\" by the relational nature of the language (for example, they may\r\nnot have a predefined, statically determined, output schema).\r\n\r\n> [!NOTE]\r\n> * Syntactically, `evaluate` behaves similarly to the [invoke operator](./invokeoperator.md), which invokes tabular functions.\r\n> * Plugins provided through the evaluate operator aren't bound by the regular rules of query execution or argument evaluation.\r\n> * Specific plugins may have specific restrictions. For example, plugins whose output schema depends on the data (for example, [bag_unpack plugin](./bag-unpackplugin.md) and [pivot plugin](./pivotplugin.md)) can't be used when performing cross-cluster queries.\r\n\r\n## Syntax \r\n\r\n[*T* `|`] `evaluate` [ *evaluateParameters* ] *PluginName* `(` [*PluginArg1* [`,` *PluginArg2*]... `)`\r\n\r\n## Arguments\r\n\r\n* *T* is an optional tabular input to the plugin. (Some plugins don't take\r\n  any input, and act as a tabular data source.)\r\n* *PluginName* is the mandatory name of the plugin being invoked.\r\n* *PluginArg1*, ... are the optional arguments to the plugin.\r\n* *evaluateParameters*: Zero or more (space-separated) parameters in the form of\r\n  *Name* `=` *Value* that control the behavior of the evaluate operation and execution plan. Each plugin may decide differently how to handle each parameter. Refer to each plugin's documentation for specific behavior.  \r\n\r\n## Parameters\r\n\r\nThe following parameters are supported: \r\n\r\n|Name                |Values                           |Description                                |\r\n  |--------------------|---------------------------------|-------------------------------------------|\r\n  |`hint.distribution` |`single`, `per_node`, `per_shard`| [Distribution hints](#distribution-hints) |\r\n  |`hint.pass_filters` |`true`, `false`| Allow `evaluate` operator to passthrough any matching filters before the plugin. Filter is considered as 'matched' if it refers to a column existing before the `evaluate` operator. Default: `false` |\r\n  |`hint.pass_filters_column` |*column_name*| Allow plugin operator to passthrough filters referring to *column_name* before the plugin. Parameter can be used multiple times with different column names. |\r\n\r\n## Plugins\r\n\r\nThe following plugins are supported:\r\n\r\n- [autocluster plugin](autoclusterplugin.md)\r\n- [azure-digital-twins-query-request plugin](azure-digital-twins-query-request-plugin.md)\r\n- [bag-unpack plugin](bag-unpackplugin.md)\r\n- [basket plugin](basketplugin.md)\r\n- [cosmosdb-sql-request plugin](cosmosdb-plugin.md)\r\n- [dcount-intersect plugin](dcount-intersect-plugin.md)\r\n- [diffpatterns plugin](diffpatternsplugin.md)\r\n- [diffpatterns-text plugin](diffpatterns-textplugin.md)\r\n- [infer-storage-schema plugin](inferstorageschemaplugin.md)\r\n- [ipv4-lookup plugin](ipv4-lookup-plugin.md)\r\n- [mysql-request-plugin](mysqlrequest-plugin.md)\r\n- [narrow plugin](narrowplugin.md)\r\n- [pivot plugin](pivotplugin.md)\r\n- [preview plugin](previewplugin.md)\r\n- [R plugin](rplugin.md)\r\n- [rolling-percentile plugin](rolling-percentile-plugin.md)\r\n- [rows-near plugin](rows-near-plugin.md)\r\n- [schema-merge plugin](schemamergeplugin.md)\r\n- [sql-request plugin](mysqlrequest-plugin.md)\r\n- [sequence-detect plugin](sequence-detect-plugin.md)\r\n\r\n## Distribution hints\r\n\r\nDistribution hints specify how the plugin execution will be distributed across multiple cluster nodes. Each plugin may implement a different support for the distribution. The plugin's documentation specifies the distribution options supported by the plugin.\r\n\r\nPossible values:\r\n\r\n* `single`: A single instance of the plugin will run over the entire query data.\r\n* `per_node`: If the query before the plugin call is distributed across nodes, then an instance of the plugin will run on each node over the data that it contains.\r\n* `per_shard`: If the data before the plugin call is distributed across shards, then an instance of the plugin will run over each shard of the data.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/evaluateoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"exp","The base-e exponential function of x, which is e raised to the power x: e^x.","## Syntax\r\n\r\n`exp(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number, value of the exponent.\r\n\r\n## Returns\r\n\r\n* Exponential value of x.\r\n* For natural (base-e) logarithms, see [log()](log-function.md).\r\n* For exponential functions of base-2 and base-10 logarithms, see [exp2()](exp2-function.md), [exp10()](exp10-function.md)","","https://docs.microsoft.com/azure/data-explorer/kusto/query/exp-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"exp10","The base-10 exponential function of x, which is 10 raised to the power x: 10^x.","## Syntax\r\n\r\n`exp10(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number, value of the exponent.\r\n\r\n## Returns\r\n\r\n* Exponential value of x.\r\n* For natural (base-10) logarithms, see [log10()](log10-function.md).\r\n* For exponential functions of base-e and base-2 logarithms, see [exp()](exp-function.md), [exp2()](exp2-function.md)","","https://docs.microsoft.com/azure/data-explorer/kusto/query/exp10-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"exp2","The base-2 exponential function of x, which is 2 raised to the power x: 2^x.","## Syntax\r\n\r\n`exp2(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number, value of the exponent.\r\n\r\n## Returns\r\n\r\n* Exponential value of x.\r\n* For natural (base-2) logarithms, see [log2()](log2-function.md).\r\n* For exponential functions of base-e and base-10 logarithms, see [exp()](exp-function.md), [exp10()](exp10-function.md)","","https://docs.microsoft.com/azure/data-explorer/kusto/query/exp2-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"extend","Create calculated columns and append them to the result set.","```\r\nT | extend duration = endTime - startTime\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| extend` [*ColumnName* | `(`*ColumnName*[`,` ...]`)` `=`] *Expression* [`,` ...]\r\n\r\n## Arguments\r\n\r\n* *T*: The input tabular result set.\r\n* *ColumnName:* Optional. The name of the column to add or update. If omitted, the name will be generated. If *Expression* returns more than one column, a list of column names can be specified in parentheses. In this case *Expression*'s output columns will be given the specified names, dropping the rest of the output columns, if there are any. If a list of the column names is not specified, all *Expression*'s output columns with generated names will be added to the output.\r\n* *Expression:* A calculation over the columns of the input.\r\n\r\n## Returns\r\n\r\nA copy of the input tabular result set, such that:\r\n\r\n1. Column names noted by `extend` that already exist in the input are removed\r\n   and appended as their new calculated values.\r\n2. Column names noted by `extend` that do not exist in the input are appended\r\n   as their new calculated values.\r\n\r\n**Tips**\r\n\r\n* The `extend` operator adds a new column to the input result set, which does\r\n  **not** have an index. In most cases, if the new column is set to be exactly\r\n  the same as an existing table column that has an index, Kusto can automatically\r\n  use the existing index. However, in some complex scenarios this propagation is\r\n  not done. In such cases, if the goal is to rename a column,\r\n  use the [`project-rename` operator](projectrenameoperator.md) instead.",'```\r\nLogs\r\n| extend\r\n    Duration = CreatedOn - CompletedOn\r\n    , Age = now() - CreatedOn\r\n    , IsSevere = Level == "Critical" or Level == "Error"\r\n```\r\n\r\nYou can use the [series_stats](series-statsfunction.md) function to return multiple columns.',"https://docs.microsoft.com/azure/data-explorer/kusto/query/extendoperator","extendoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extent_id",'Returns a unique identifier that identifies the data shard ("extent") that the current record resides in.',"Applying this function to calculated data that isn't attached to a data shard returns an empty guid (all zeros).\r\n\r\n## Syntax\r\n\r\n`extent_id()`\r\n\r\n## Returns\r\n\r\nA value of type `guid` that identifies the current record's data shard,\r\nor an empty guid (all zeros).","The following example shows how to get a list of all the data shards\r\nthat have records from an hour ago with a specific value for the\r\ncolumn `ActivityId`. It demonstrates that some query operators (here,\r\nthe `where` operator, and also `extend` and `project`)\r\npreserve the information about the data shard hosting the record.\r\n\r\n```\r\nT\r\n| where Timestamp > ago(1h)\r\n| where ActivityId == 'dd0595d4-183e-494e-b88e-54c52fe90e5a'\r\n| extend eid=extent_id()\r\n| summarize by eid\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/extentidfunction","extentidfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extent_tags",'Returns a dynamic array with the [tags](../management/extents-overview.md#extent-tagging) of the data shard ("extent") that the current record is in.',"Applying this function to calculated data, which isn't attached to a data shard, returns an empty value.\r\n\r\n## Syntax\r\n\r\n`extent_tags()`\r\n\r\n## Returns\r\n\r\nA value of type `dynamic` that is an array holding the current record's extent tags,\r\nor an empty value.","Some query operators preserve the information about the data shard hosting the record.\r\nThese operators include `where`, `extend`, and `project`.\r\nThe following example shows how to get a list the tags of all the data shards\r\nthat have records from an hour ago, with a specific value for the\r\ncolumn `ActivityId`. \r\n\r\n```\r\nT\r\n| where Timestamp > ago(1h)\r\n| where ActivityId == 'dd0595d4-183e-494e-b88e-54c52fe90e5a'\r\n| extend tags = extent_tags()\r\n| summarize by tostring(tags)\r\n```\r\n\r\nThe following example shows how to obtain a count of all records from the \r\nlast hour, which are stored in extents tagged with the tag `MyTag`\r\n(and potentially other tags), but not tagged with the tag `drop-by:MyOtherTag`.\r\n\r\n```\r\nT\r\n| where Timestamp > ago(1h)\r\n| extend Tags = extent_tags()\r\n| where Tags has_cs 'MyTag' and Tags !has_cs 'drop-by:MyOtherTag'\r\n| count\r\n```\r\n\r\n> [!NOTE]\r\n> Filtering on the value of `extent_tags()` performs best when one of the following string operators is used:\r\n> `has`, `has_cs`, `!has`, `!has_cs`.","https://docs.microsoft.com/azure/data-explorer/kusto/query/extenttagsfunction","extenttagsfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"external_table","References an [external table](schema-entities/externaltables.md) by name.","```\r\nexternal_table('StormEvent')\r\n```\r\n\r\n> [!NOTE]\r\n> * The `external_table` function has similar restrictions as the [table](tablefunction.md) function.\r\n> * Standard [query limits](../concepts/querylimits.md) apply to external table queries as well.\r\n\r\n## Syntax\r\n\r\n`external_table` `(` *TableName* [`,` *MappingName* ] `)`\r\n\r\n## Arguments\r\n\r\n* *TableName*: The name of the external table being queried.\r\n  Must be a string literal referencing an external table of kind\r\n  `blob`, `adl` or `sql`.\r\n* *MappingName*: An optional name of the mapping object that maps the\r\n  fields in the actual (external) data shards to the columns output\r\n  by this function.\r\n\r\n## Next steps\r\n\r\n* [External tables overview](schema-entities/externaltables.md)\r\n* [Create and alter Azure Storage external tables](../management/external-tables-azurestorage-azuredatalake.md)\r\n* [Create and alter SQL Server external tables](../management/external-sql-tables.md)","","https://docs.microsoft.com/azure/data-explorer/kusto/query/externaltablefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"externaldata","The `externaldata` operator returns a table whose schema is defined in the query itself, and whose data is read from an external storage artifact, such as a blob in \r\nAzure Blob Storage or a file in Azure Data Lake Storage.","## Syntax\r\n\r\n`externaldata` `(` *ColumnName* `:` *ColumnType* [`,` ...] `)`   \r\n`[` *StorageConnectionString* [`,` ...] `]`   \r\n[`with` `(` *PropertyName* `=` *PropertyValue* [`,` ...] `)`]\r\n\r\n## Arguments\r\n\r\n* *ColumnName*, *ColumnType*: The arguments define the schema of the table.\r\n  The syntax is the same as the syntax used when defining a table in [`.create table`](../management/create-table-command.md).\r\n* *StorageConnectionString*: [Storage connection strings](../api/connection-strings/storage-connection-strings.md) that describe the storage artifacts holding the data to return.\r\n\r\n> [!NOTE]\r\n> The `externaldata` operator supports Shared Access (SAS) key, Access key, and Azure AD Token authentication methods. For more information, see [Storage authentication methods](../api/connection-strings/storage-authentication-methods.md).\r\n\r\n* *PropertyName*, *PropertyValue*, ...: Additional properties that describe how to interpret\r\n  the data retrieved from storage, as listed under [ingestion properties](../../ingestion-properties.md).\r\n\r\nCurrently supported properties are:\r\n\r\n| Property         | Type     | Description       |\r\n|------------------|----------|-------------------|\r\n| `format`         | `string` | Data format. If not specified, an attempt is made to detect the data format from file extension (defaults to `CSV`). Any of the [ingestion data formats](../../ingestion-supported-formats.md) are supported. |\r\n| `ignoreFirstRecord` | `bool` | If set to true, indicates that the first record in every file is ignored. This property is useful when querying CSV files with headers. |\r\n| `ingestionMapping` | `string` | A string value that indicates how to map data from the source file to the actual columns in the operator result set. See [data mappings](../management/mappings.md). |\r\n\r\n> [!NOTE]\r\n> * This operator doesn't accept any pipeline input.\r\n> * Standard [query limits](../concepts/querylimits.md) apply to external data queries as well.\r\n\r\n## Returns\r\n\r\nThe `externaldata` operator returns a data table of the given schema whose data was parsed from the specified storage artifact, indicated by the storage connection string.",'**Fetch a list of user IDs stored in Azure Blob Storage**\r\n\r\nThe following example shows how to find all records in a table whose `UserID` column falls into a known set of IDs, held (one per line) in an external storage file. Since the data format isn\'t specified, the detected data format is `TXT`.\r\n\r\n```\r\nUsers\r\n| where UserID in ((externaldata (UserID:string) [\r\n    @"https://storageaccount.blob.core.windows.net/storagecontainer/users.txt" \r\n      h@"?...SAS..." // Secret token needed to access the blob\r\n    ]))\r\n| ...\r\n```\r\n\r\n**Query multiple data files**\r\n\r\nThe following example queries multiple data files stored in external storage.\r\n\r\n```\r\nexternaldata(Timestamp:datetime, ProductId:string, ProductDescription:string)\r\n[\r\n  h@"https://mycompanystorage.blob.core.windows.net/archivedproducts/2019/01/01/part-00000-7e967c99-cf2b-4dbb-8c53-ce388389470d.csv.gz?...SAS...",\r\n  h@"https://mycompanystorage.blob.core.windows.net/archivedproducts/2019/01/02/part-00000-ba356fa4-f85f-430a-8b5a-afd64f128ca4.csv.gz?...SAS...",\r\n  h@"https://mycompanystorage.blob.core.windows.net/archivedproducts/2019/01/03/part-00000-acb644dc-2fc6-467c-ab80-d1590b23fc31.csv.gz?...SAS..."\r\n]\r\nwith(format="csv")\r\n| summarize count() by ProductId\r\n```\r\n\r\nThe above example can be thought of as a quick way to query multiple data files without defining an [external table](schema-entities/externaltables.md).\r\n\r\n> [!NOTE]\r\n> Data partitioning isn\'t recognized by the `externaldata` operator.\r\n\r\n**Query hierarchical data formats**\r\n\r\nTo query hierarchical data format, such as `JSON`, `Parquet`, `Avro`, or `ORC`, `ingestionMapping` must be specified in the operator properties. \r\nIn this example, there\'s a JSON file stored in Azure Blob Storage with the following contents:\r\n\r\n```JSON\r\n{\r\n  "timestamp": "2019-01-01 10:00:00.238521",   \r\n  "data": {    \r\n    "tenant": "e1ef54a6-c6f2-4389-836e-d289b37bcfe0",   \r\n    "method": "RefreshTableMetadata"   \r\n  }   \r\n}   \r\n{\r\n  "timestamp": "2019-01-01 10:00:01.845423",   \r\n  "data": {   \r\n    "tenant": "9b49d0d7-b3e6-4467-bb35-fa420a25d324",   \r\n    "method": "GetFileList"   \r\n  }   \r\n}\r\n...\r\n```\r\n\r\nTo query this file using the `externaldata` operator, a data mapping must be specified. The mapping dictates how to map JSON fields to the operator result set columns:\r\n\r\n```\r\nexternaldata(Timestamp: datetime, TenantId: guid, MethodName: string)\r\n[ \r\n   h@\'https://mycompanystorage.blob.core.windows.net/events/2020/09/01/part-0000046c049c1-86e2-4e74-8583-506bda10cca8.json?...SAS...\'\r\n]\r\nwith(format=\'multijson\', ingestionMapping=\'[{"Column":"Timestamp","Properties":{"Path":"$.timestamp"}},{"Column":"TenantId","Properties":{"Path":"$.data.tenant"}},{"Column":"MethodName","Properties":{"Path":"$.data.method"}}]\')\r\n```\r\n\r\nThe `MultiJSON` format is used here because single JSON records are spanned into multiple lines.\r\n\r\nFor more info on mapping syntax, see [data mappings](../management/mappings.md).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/externaldata-operator","externaldata-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extract","Get a match for a [regular expression](./re2.md) from a source string.",'Optionally, convert the extracted substring to the indicated type.\r\n\r\n```\r\nextract("x=([0-9.]+)", 1, "hello x=45.6|wo") == "45.6"\r\n```\r\n\r\n## Syntax\r\n\r\n`extract(`*regex*`,` *captureGroup*`,` *source* [`,` *typeLiteral*]`)`\r\n\r\n## Arguments\r\n\r\n* *regex*: A [regular expression](./re2.md).\r\n* *captureGroup*: A positive `int` constant indicating the\r\ncapture group to extract. 0 stands for the entire match, 1 for the value matched by the first \'(\'parenthesis\')\' in the regular expression, 2 or more for subsequent parentheses.\r\n* *source*: A `string` to search.\r\n* *typeLiteral*: An optional type literal (e.g., `typeof(long)`). If provided, the extracted substring is converted to this type. \r\n\r\n## Returns\r\n\r\nIf *regex* finds a match in *source*: the substring matched against the indicated capture group *captureGroup*, optionally converted to *typeLiteral*.\r\n\r\nIf there\'s no match, or the type conversion fails: `null`.','The example string `Trace` is searched for a definition for `Duration`. \r\nThe match is converted to `real`, then multiplied it by a time constant (`1s`) so that `Duration` is of type `timespan`. In this example, it is equal to 123.45 seconds:\r\n\r\n```\r\n...\r\n| extend Trace="A=1, B=2, Duration=123.45, ..."\r\n| extend Duration = extract("Duration=([0-9.]+)", 1, Trace, typeof(real)) * time(1s) \r\n```\r\n\r\nThis example is equivalent to `substring(Text, 2, 4)`:\r\n\r\n```\r\nextract("^.{2,2}(.{4,4})", 1, Text)\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/extractfunction","extractfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extract_all","Get all matches for a [regular expression](./re2.md) from a source string.\r\nOptionally, retrieve a subset of matching groups.",'```\r\nprint extract_all(@"(\\d+)", "a set of numbers: 123, 567 and 789") // results with the dynamic array ["123", "567", "789"]\r\n```\r\n\r\n## Syntax\r\n\r\n`extract_all(`*regex*`,` [*captureGroups*`,`] *source*`)`\r\n\r\n## Arguments\r\n\r\n|Argument        |Description                                  |Required or Optional  |\r\n|----------------|---------------------------------------------|----------------------|\r\n|regex           | A [regular expression](./re2.md) containing between one and 16 capture groups. Example of a valid regex: `@"(\\d+)"`. Example of an invalid regex: `@"\\d+"`                                                         |Required              |\r\n|captureGroups   |A dynamic array constant that indicates the capture group to extract. Valid values are from 1 to the number of capturing groups in the regular expression. Named capture groups are allowed as well (See [Examples](#examples))|Optional         |\r\n|source            |A `string` to search                         |Required              |\r\n\r\n## Returns\r\n\r\n* If *regex* finds a match in *source*: Returns dynamic array including all matches against the indicated capture groups *captureGroups*, or all of capturing groups in the *regex*.\r\n* If number of *captureGroups* is 1: The returned array has a single dimension of matched values.\r\n* If number of *captureGroups* is more than 1: The returned array is a two-dimensional collection of multi-value matches per *captureGroups* selection, or all capture groups present in the *regex* if *captureGroups* is omitted.\r\n* If there\'s no match: `null`.','### Extract a single capture group\r\n\r\nReturns hex-byte representation (two hex-digits) of the GUID.\r\n\r\n```\r\nprint Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r\n| extend guid_bytes = extract_all(@"([\\da-f]{2})", Id) \r\n```\r\n\r\n|ID|guid_bytes|\r\n|---|---|\r\n|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|["82","b8","be","2d","df","a7","4b","d1","8f","63","24","ad","26","d3","14","49"]|\r\n\r\n### Extract several capture groups \r\n\r\nUses a regular expression with three capturing groups to split each GUID part into first letter, last letter, and whatever is in the middle.\r\n\r\n```\r\nprint Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r\n| extend guid_bytes = extract_all(@"(\\w)(\\w+)(\\w)", Id)\r\n```\r\n\r\n|ID|guid_bytes|\r\n|---|---|\r\n|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|[["8","2b8be2","d"],["d","fa","7"],["4","bd","1"],["8","f6","3"],["2","4ad26d3144","9"]]|\r\n\r\n### Extract a subset of capture groups\r\n\r\nShows how to select a subset of capturing groups. \r\nThe regular expression matches the first letter, last letter, and all the rest. \r\nThe *captureGroups* parameter is used to select only the first and the last parts.\r\n\r\n```\r\nprint Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r\n| extend guid_bytes = extract_all(@"(\\w)(\\w+)(\\w)", dynamic([1,3]), Id) \r\n```\r\n\r\n|ID|guid_bytes|\r\n|---|---|\r\n|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|[["8","d"],["d","7"],["4","1"],["8","3"],["2","9"]]|\r\n\r\n### Using named capture groups\r\n\r\nYou can use named capture groups of RE2 in extract_all().\r\nThe *captureGroups* uses both capture group indexes and named capture group reference to fetch matching values.\r\n\r\n```\r\nprint Id="82b8be2d-dfa7-4bd1-8f63-24ad26d31449"\r\n| extend guid_bytes = extract_all(@"(?P<first>\\w)(?P<middle>\\w+)(?P<last>\\w)", dynamic([\'first\',2,\'last\']), Id) \r\n```\r\n\r\n|ID|guid_bytes|\r\n|---|---|\r\n|82b8be2d-dfa7-4bd1-8f63-24ad26d31449|[["8","2b8be2","d"],["d","fa","7"],["4","bd","1"],["8","f6","3"],["2","4ad26d3144","9"]]|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/extractallfunction","extractallfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"extract_json","Get a specified element out of a JSON text using a path expression.",'Optionally convert the extracted string to a specific type.\r\n\r\n> [!NOTE]\r\n> The `extract_json()` and `extractjson()` functions are interpreted equivalently.\r\n\r\n```\r\nextract_json("$.hosts[1].AvailableMB", EventText, typeof(int))\r\n```\r\n\r\n## Syntax\r\n\r\n`extract_json(`*jsonPath*`,` *dataSource*`, ` *type*`)` \r\n\r\n`extractjson(`*jsonPath*`,` *dataSource*`, ` *type*`)`\r\n\r\n## Arguments\r\n\r\n* *jsonPath*: [JSONPath](jsonpath.md) string that defines an accessor into the JSON document.\r\n* *dataSource*: A JSON document.\r\n* *type*: An optional type literal (for example, typeof(long)). If provided, the extracted value is converted to this type.\r\n\r\n## Returns\r\n\r\nThis function performs a [JSONPath](jsonpath.md) query into dataSource, which contains a valid JSON string, optionally converting that value to another type depending on the third argument.',"The `[`bracket`]` notation and dot (`.`) notation are equivalent:\r\n\r\n```\r\nT\r\n| extend AvailableMB = extract_json(\"$.hosts[1].AvailableMB\", EventText, typeof(int))\r\n\r\nT\r\n| extend AvailableMB = extract_json(\"$['hosts'][1]['AvailableMB']\", EventText, typeof(int))\r\n```\r\n\r\n**Performance tips**\r\n\r\n* Apply where-clauses before using `extract_json()`\r\n* Consider using a regular expression match with [extract](extractfunction.md) instead. This can run very much faster, and is effective if the JSON is produced from a template.\r\n* Use `parse_json()` if you need to extract more than one value from the JSON.\r\n* Consider having the JSON parsed at ingestion by declaring the type of the column to be dynamic.","https://docs.microsoft.com/azure/data-explorer/kusto/query/extractjsonfunction","extractjsonfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"facet","Returns a set of tables, one for each specified column.\r\nEach table specifies the list of values taken by its column.\r\nAn additional table can be created by using the `with` clause.","## Syntax\r\n\r\n*T* `| facet by` *ColumnName* [`, ` ...] [`with (` *filterPipe* `)`\r\n\r\n## Arguments\r\n\r\n* *ColumnName:* The name of column in the input, to be summarized as an output table.\r\n* *filterPipe:* A query expression applied to the input table to produce one of the outputs.\r\n\r\n## Returns\r\n\r\nMultiple tables: one for the `with` clause, and one for each column.",'```\r\nStormEvents\r\n| where State startswith "A" and EventType has "Heavy"\r\n| facet by State, EventType\r\n  with \r\n  (\r\n  where StartTime between(datetime(2007-01-04) .. 7d) \r\n  | project StartTime, Source, EpisodeId, EventType\r\n  | take 5\r\n  )\r\n```\r\n\r\n|StartTime|Source|EpisodeId|EventType|\r\n|---|---|---|---|\r\n|2007-01-04 12:00:00.0000000|COOP Observer|2192|Heavy Snow|\r\n|2007-01-04 15:00:00.0000000|Trained Spotter|2192|Heavy Snow|\r\n|2007-01-04 15:00:00.0000000|Trained Spotter|2192|Heavy Snow|\r\n|2007-01-04 15:00:00.0000000|Trained Spotter|2192|Heavy Snow|\r\n|2007-01-06 18:00:00.0000000|COOP Observer|2193|Heavy Snow|\r\n\r\n|State|count_State|\r\n|---|---|\r\n|ALABAMA|19|\r\n|ARIZONA|33|\r\n|ARKANSAS|1|\r\n|AMERICAN SAMOA|1|\r\n|ALASKA|58|\r\n\r\n|EventType|count_EventType|\r\n|---|---|\r\n|Heavy Rain|34|\r\n|Heavy Snow|78|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/facetoperator","facetoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"find","Finds rows that match a predicate across a set of tables.","The scope of the `find` can also be cross-database or cross-cluster.\r\n\r\n```\r\nfind in (Table1, Table2, Table3) where Fruit==\"apple\"\r\nfind in (database('*').*) where Fruit == \"apple\"\r\nfind in (cluster('cluster_name').database('MyDB*'.*)) where Fruit == \"apple\"\r\n```\r\n\r\n## Syntax\r\n\r\n* `find` [`withsource`=*ColumnName*] [`in` `(`*Table* [`,` *Table*, ...]`)`] `where` *Predicate* [`project-smart` | `project` *ColumnName* [`:`*ColumnType*] [`,` *ColumnName*[`:`*ColumnType*], ...][`,` `pack(*)`]] \r\n* `find` *Predicate* [`project-smart` | `project` *ColumnName*[`:`*ColumnType*] [`,` *ColumnName*[`:`*ColumnType*], ...] [`, pack(*)`]] \r\n\r\n## Arguments\r\n\r\n* `withsource=`*ColumnName*: Optional. By default, the output will include a column called *source_* whose values indicate which source table has contributed each row. If specified, *ColumnName* will be used instead of *source_*.\r\nAfter wildcard matching, if the query references tables from more than one database (including the default database), the value of this column will have a table name qualified with the database. Similarly *cluster* and *database* qualifications will be present in the value if more than one cluster is referenced.\r\n* *Predicate*: A `boolean` [expression](./scalar-data-types/bool.md) over the columns of the input tables *Table* [`,` *Table*, ...]. It's evaluated for each row in each input table. For more information, see  [predicate-syntax details](./findoperator.md#predicate-syntax).\r\n* `Table`: Optional. By default, *find* will look in all the tables in the current database, for:\r\n    *  The name of a table, such as `Events`\r\n    *  A query expression, such as `(Events | where id==42)`\r\n    *  A set of tables specified with a wildcard. For example, `E*` would form the union of all the tables in the database whose names begin with `E`.\r\n* `project-smart` | `project`: If not specified, `project-smart` will be used by default. For more information, see [output-schema details](./findoperator.md#output-schema).\r\n\r\n\r\n## Returns\r\n\r\nTransformation of rows in *Table* [`,` *Table*, ...] for which *Predicate* is `true`. The rows are transformed according to the [output schema](#output-schema).\r\n\r\n## Output schema\r\n\r\n**source_ column**\r\n\r\nThe find operator output will always include a *source_* column with the source table name. The column can be renamed using the `withsource` parameter.\r\n\r\n**results columns**\r\n\r\nSource tables that don't contain any column used by the predicate evaluation, will be filtered out.\r\n\r\nWhen using `project-smart`, the columns that will appear in the output will be:\r\n\r\n* Columns that appear explicitly in the predicate.\r\n* Columns that are common to all the filtered tables.\r\n\r\nThe rest of the columns will be packed into a property bag and will appear in an additional `pack_` column.\r\nA column that is referenced explicitly by the predicate and appears in multiple tables with multiple types, will have a different column in the result schema for each such type. Each of the column names will be constructed from the original column name and type, separated by an underscore.\r\n\r\nWhen using `project` *ColumnName*[`:`*ColumnType*] [`,` *ColumnName*[`:`*ColumnType*], ...][`,` `pack(*)`]:\r\n\r\n* The result table will include the columns specified in the list. If a source table doesn't contain a certain column, the values in the corresponding rows will be null.\r\n* When specifying a *ColumnType* with a *ColumnName*, this column in the \"result\" will have the given type, and the values will be cast to that type if needed. The casting won't have an effect on the column type when evaluating the *Predicate*.\r\n* When `pack(*)` is used, the rest of the columns will be packed into a property bag and will appear in an additional `pack_` column.\r\n\r\n**pack_ column**\r\n\r\nThis column will contain a property bag with the data from all the columns that doesn't appear in the output schema. The source column name will serve as the property name and the column value will serve as the property value.\r\n\r\n## Predicate syntax\r\n\r\nThe *find* operator supports an alternative syntax for the `* has` term, and using just *term*, will search a term across all input columns.\r\n\r\nFor a summary of some filtering functions, see [where operator](./whereoperator.md).\r\n\r\n## Notes\r\n\r\n* If the `project` clause references a column that appears in multiple tables and has multiple types, a type must follow this column reference in the project clause\r\n* If a column appears in multiple tables and has multiple types and `project-smart` is in use, there will be a corresponding column for each type in the `find`'s result, as described in [union](./unionoperator.md)\r\n* When using *project-smart*, changes in the predicate, in the source tables set, or in the tables schema, may result in a change to the output schema. If a constant result schema is needed, use *project* instead\r\n* `find` scope can't include [functions](../management/functions.md). To include a function in the find scope, define a [let statement](./letstatement.md) with [view keyword](./letstatement.md).\r\n\r\n## Performance tips\r\n\r\n* Use [tables](../management/tables.md) as opposed to [tabular expressions](./tabularexpressionstatements.md).\r\nIf tabular expression, the find operator falls back to a `union` query that can result in degraded performance.\r\n* If a column that appears in multiple tables and has multiple types, is part of the project clause, prefer adding a *ColumnType* to the project clause over modifying the table before passing it to `find`.\r\n* Add time-based filters to the predicate. Use a datetime column value or [ingestion_time()](./ingestiontimefunction.md).\r\n* Search in specific columns rather than a full text search.\r\n* It's better not to reference columns that appear in multiple tables and have multiple types. If the predicate is valid when resolving such columns type for more than one type, the query will fall back to union.\r\nFor example, see [examples of cases where find will act as a union](./findoperator.md#examples-of-cases-where-find-will-act-as-union).",'### Term lookup across all tables in current database\r\n\r\nThe query finds all rows from all tables in the current database in which any column includes the word `Kusto`.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind "Kusto"\r\n```\r\n\r\n## Term lookup across all tables matching a name pattern in the current database\r\n\r\nThe query finds all rows from all tables in the current database whose name starts with `K`, and in which any column includes the word `Kusto`.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind in (K*) where * has "Kusto"\r\n```\r\n\r\n### Term lookup across all tables in all databases in the cluster\r\n\r\nThe query finds all rows from all tables in all databases in which any column includes the word `Kusto`.\r\nThis query is a [cross-database](./cross-cluster-or-database-queries.md) query.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind in (database(\'*\').*) "Kusto"\r\n```\r\n\r\n### Term lookup across all tables and databases matching a name pattern in the cluster\r\n\r\nThe query finds all rows from all tables whose name starts with `K` in all databases whose name start with `B` and in which any column includes the word `Kusto`.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind in (database("B*").K*) where * has "Kusto"\r\n```\r\n\r\n### Term lookup in several clusters\r\n\r\nThe query finds all rows from all tables whose name starts with `K` in all databases whose name start with `B` and in which any column includes the word `Kusto`.\r\nThe resulting records are transformed according to the [output schema](#output-schema).\r\n\r\n```\r\nfind in (cluster("cluster1").database("B*").K*, cluster("cluster2").database("C*".*))\r\nwhere * has "Kusto"\r\n```\r\n\r\n## Examples of `find` output results  \r\n\r\nThe following examples show how `find` can be used over two tables: *EventsTable1* and *EventsTable2*.\r\nAssume we have the next content of these two tables:\r\n\r\n### EventsTable1\r\n\r\n|Session_Id|Level|EventText|Version\r\n|---|---|---|---|\r\n|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Text1|v1.0.0\r\n|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Text2|v1.0.0\r\n|28b8e46e-3c31-43cf-83cb-48921c3986fc|Error|Some Text3|v1.0.1\r\n|8f057b11-3281-45c3-a856-05ebb18a3c59|Information|Some Text4|v1.1.0\r\n\r\n### EventsTable2\r\n\r\n|Session_Id|Level|EventText|EventName\r\n|---|---|---|---|\r\n|f7d5f95f-f580-4ea6-830b-5776c8d64fdd|Information|Some Other Text1|Event1\r\n|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Other Text2|Event2\r\n|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Other Text3|Event3\r\n|15eaeab5-8576-4b58-8fc6-478f75d8fee4|Error|Some Other Text4|Event4\r\n\r\n### Search in common columns, project common and uncommon columns, and pack the rest  \r\n\r\n```\r\nfind in (EventsTable1, EventsTable2) \r\n     where Session_Id == \'acbd207d-51aa-4df7-bfa7-be70eb68f04e\' and Level == \'Error\' \r\n     project EventText, Version, EventName, pack(*)\r\n```\r\n\r\n|source_|EventText|Version|EventName|pack_\r\n|---|---|---|---|---|\r\n|EventsTable1|Some Text2|v1.0.0||{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error"}\r\n|EventsTable2|Some Other Text3||Event3|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error"}\r\n\r\n### Search in common and uncommon columns\r\n\r\n```\r\nfind Version == \'v1.0.0\' or EventName == \'Event1\' project Session_Id, EventText, Version, EventName\r\n```\r\n\r\n|source_|Session_Id|EventText|Version|EventName|\r\n|---|---|---|---|---|\r\n|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Some Text1|v1.0.0\r\n|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Some Text2|v1.0.0\r\n|EventsTable2|f7d5f95f-f580-4ea6-830b-5776c8d64fdd|Some Other Text1||Event1\r\n\r\nNote: in practice, *EventsTable1* rows will be filtered with ```Version == \'v1.0.0\'``` predicate and *EventsTable2* rows will be filtered with ```EventName == \'Event1\'``` predicate.\r\n\r\n### Use abbreviated notation to search across all tables in the current database\r\n\r\n```\r\nfind Session_Id == \'acbd207d-51aa-4df7-bfa7-be70eb68f04e\'\r\n```\r\n\r\n|source_|Session_Id|Level|EventText|pack_|\r\n|---|---|---|---|---|\r\n|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Text1|{"Version":"v1.0.0"}\r\n|EventsTable1|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Text2|{"Version":"v1.0.0"}\r\n|EventsTable2|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Information|Some Other Text2|{"EventName":"Event2"}\r\n|EventsTable2|acbd207d-51aa-4df7-bfa7-be70eb68f04e|Error|Some Other Text3|{"EventName":"Event3"}\r\n\r\n### Return the results from each row as a property bag\r\n\r\n```\r\nfind Session_Id == \'acbd207d-51aa-4df7-bfa7-be70eb68f04e\' project pack(*)\r\n```\r\n\r\n|source_|pack_|\r\n|---|---|\r\n|EventsTable1|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Information", "EventText":"Some Text1", "Version":"v1.0.0"}\r\n|EventsTable1|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error", "EventText":"Some Text2", "Version":"v1.0.0"}\r\n|EventsTable2|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Information", "EventText":"Some Other Text2", "EventName":"Event2"}\r\n|EventsTable2|{"Session_Id":"acbd207d-51aa-4df7-bfa7-be70eb68f04e", "Level":"Error", "EventText":"Some Other Text3", "EventName":"Event3"}\r\n\r\n## Examples of cases where `find` will act as `union`\r\n\r\n### Using a non-tabular expression as find operand\r\n\r\n```\r\nlet PartialEventsTable1 = view() { EventsTable1 | where Level == \'Error\' };\r\nfind in (PartialEventsTable1, EventsTable2) \r\n     where Session_Id == \'acbd207d-51aa-4df7-bfa7-be70eb68f04e\'\r\n```\r\n\r\n### Referencing a column that appears in multiple tables and has multiple types\r\n\r\nAssume we\'ve created two tables by running: \r\n\r\n```\r\n.create tables \r\n  Table1 (Level:string, Timestamp:datetime, ProcessId:string),\r\n  Table2 (Level:string, Timestamp:datetime, ProcessId:int64)\r\n```\r\n\r\n* The following query will be executed as `union`.\r\n\r\n\r\n\r\n```\r\nfind in (Table1, Table2) where ProcessId == 1001\r\n```\r\n\r\nThe output result schema will be *(Level:string, Timestamp, ProcessId_string, ProcessId_int)*.\r\n\r\n* The following query will also be executed as `union`, but will produce a different result schema.\r\n\r\n\r\n\r\n```\r\nfind in (Table1, Table2) where ProcessId == 1001 project Level, Timestamp, ProcessId:string \r\n```\r\n\r\nThe output result schema will be *(Level:string, Timestamp, ProcessId_string)*',"https://docs.microsoft.com/azure/data-explorer/kusto/query/findoperator","findoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"floor","An alias for [`bin()`](binfunction.md).","","","https://docs.microsoft.com/azure/data-explorer/kusto/query/floorfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"fork","Runs multiple consumer operators in parallel.","## Syntax\r\n\r\n*T* `|` `fork` [*name*`=`]`(`*subquery*`)` [*name*`=`]`(`*subquery*`)` ...\r\n\r\n## Arguments\r\n\r\n* *subquery* is a downstream pipeline of query operators\r\n* *name* is a temporary name for the subquery result table\r\n\r\n## Returns\r\n\r\nMultiple result tables, one for each of the subqueries.\r\n\r\n**Supported Operators**\r\n\r\n[`as`](asoperator.md), [`count`](countoperator.md), [`extend`](extendoperator.md), [`parse`](parseoperator.md), [`where`](whereoperator.md), [`take`](takeoperator.md), [`project`](projectoperator.md), [`project-away`](projectawayoperator.md), [`project-keep`](project-keep-operator.md), [`project-rename`](projectrenameoperator.md), [`project-reorder`](projectreorderoperator.md), [`summarize`](summarizeoperator.md), [`top`](topoperator.md), [`top-nested`](topnestedoperator.md), [`sort`](sortoperator.md), [`mv-expand`](mvexpandoperator.md), [`reduce`](reduceoperator.md)\r\n\r\n**Notes**\r\n\r\n* [`materialize`](materializefunction.md) function can be used as a replacement for using [`join`](joinoperator.md) or [`union`](unionoperator.md) on fork legs.\r\nThe input stream will be cached by materialize and then the cached expression can be used in join/union legs.\r\n* A name, given by the `name` argument or by using [`as`](asoperator.md) operator will be used as the to name the result tab in [`Kusto.Explorer`](../tools/kusto-explorer.md) tool.\r\n* Avoid using `fork` with a single subquery.\r\n* Prefer using [batch](batches.md) with [`materialize`](materializefunction.md) of tabular expression statements over `fork` operator.",'In the following example, the result tables will be named "GenericResult",  "GenericResult_2" and "GenericResult_3":\r\n\r\n```\r\nKustoLogs\r\n| where Timestamp > ago(1h)\r\n| fork\r\n    ( where Level == "Error" | project EventText | limit 100 )\r\n    ( project Timestamp, EventText | top 1000 by Timestamp desc)\r\n    ( summarize min(Timestamp), max(Timestamp) by ActivityID )\r\n```\r\n\r\nIn the following examples, the result tables will be named "Errors", "EventsTexts" and "TimeRangePerActivityID":\r\n\r\n```\r\nKustoLogs\r\n| where Timestamp > ago(1h)\r\n| fork\r\n    ( where Level == "Error" | project EventText | limit 100 | as Errors )\r\n    ( project Timestamp, EventText | top 1000 by Timestamp desc | as EventsTexts )\r\n    ( summarize min(Timestamp), max(Timestamp) by ActivityID | as TimeRangePerActivityID )\r\n```\r\n\r\n```\r\nKustoLogs\r\n| where Timestamp > ago(1h)\r\n| fork\r\n    Errors = ( where Level == "Error" | project EventText | limit 100 )\r\n    EventsTexts = ( project Timestamp, EventText | top 1000 by Timestamp desc )\r\n    TimeRangePerActivityID = ( summarize min(Timestamp), max(Timestamp) by ActivityID )\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/forkoperator","forkoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_bytes","Formats a number as a string representing data size in bytes.","```\r\nformat_bytes(1024) == '1 KB'\"\r\n```\r\n\r\n## Syntax\r\n\r\n`format_bytes(`*value* [`,` *precision* [`,` *units*]]`)`\r\n\r\n## Arguments\r\n\r\n* `value`: a number to be formatted as data size in bytes.\r\n* `precision`: (optional) Number of digits the value will be rounded to. (default value is 0).\r\n* `units`: (optional) Units of the target data size the string formatting will use (`Bytes`, `KB`, `MB`, `GB`, `TB`, `PB`). If parameter is empty - the units will be auto-selected based on input value.\r\n\r\n## Returns\r\n\r\nThe string with the format result.",'```\r\nprint \r\nv1 = format_bytes(564),\r\nv2 = format_bytes(10332, 1),\r\nv3 = format_bytes(20010332),\r\nv4 = format_bytes(20010332, 2),\r\nv5 = format_bytes(20010332, 0, "KB")\r\n```\r\n\r\n|v1|v2|v3|v4|v5|\r\n|---|---|---|---|---|\r\n|564 Bytes|10.1 KB|19 MB|19.08 MB|19541 KB|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/format-bytesfunction","format-bytesfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_datetime","Formats a datetime according to the provided format.","```\r\nformat_datetime(datetime(2015-12-14 02:03:04.12345), 'y-M-d h:m:s.fffffff') == \"15-12-14 2:3:4.1234500\"\r\n```\r\n\r\n## Syntax\r\n\r\n`format_datetime(`*datetime* `,` *format*`)`\r\n\r\n## Arguments\r\n\r\n* `datetime`: value of a type `datetime`.\r\n* `format`: format specifier string, consisting of one or more [format elements](#supported-formats).\r\n\r\n## Returns\r\n\r\nThe string with the format result.\r\n\r\n## Supported formats\r\n\r\n|Format specifier\t|Description\t|Examples\r\n|---|---|---\r\n|`d`\t|The day of the month, from 1 through 31. |\t2009-06-01T13:45:30 -> 1, 2009-06-15T13:45:30 -> 15\r\n|`dd`\t|The day of the month, from 01 through 31.|\t2009-06-01T13:45:30 -> 01, 2009-06-15T13:45:30 -> 15\r\n|`f`\t|The tenths of a second in a date and time value. |2009-06-15T13:45:30.6170000 -> 6, 2009-06-15T13:45:30.05 -> 0\r\n|`ff`\t|The hundredths of a second in a date and time value. |2009-06-15T13:45:30.6170000 -> 61, 2009-06-15T13:45:30.0050000 -> 00\r\n|`fff`\t|The milliseconds in a date and time value. |6/15/2009 13:45:30.617 -> 617, 6/15/2009 13:45:30.0005 -> 000\r\n|`ffff`\t|The ten thousandths of a second in a date and time value. |2009-06-15T13:45:30.6175000 -> 6175, 2009-06-15T13:45:30.0000500 -> 0000\r\n|`fffff`\t|The hundred thousandths of a second in a date and time value. |2009-06-15T13:45:30.6175400 -> 61754, 2009-06-15T13:45:30.000005 -> 00000\r\n|`ffffff`\t|The millionths of a second in a date and time value. |2009-06-15T13:45:30.6175420 -> 617542, 2009-06-15T13:45:30.0000005 -> 000000\r\n|`fffffff`\t|The ten millionths of a second in a date and time value. |2009-06-15T13:45:30.6175425 -> 6175425, 2009-06-15T13:45:30.0001150 -> 0001150\r\n|`F`\t|If non-zero, the tenths of a second in a date and time value. |2009-06-15T13:45:30.6170000 -> 6, 2009-06-15T13:45:30.0500000 -> (no output)\r\n|`FF`\t|If non-zero, the hundredths of a second in a date and time value. |2009-06-15T13:45:30.6170000 -> 61, 2009-06-15T13:45:30.0050000 -> (no output)\r\n|`FFF`\t|If non-zero, the milliseconds in a date and time value. |2009-06-15T13:45:30.6170000 -> 617, 2009-06-15T13:45:30.0005000 -> (no output)\r\n|`FFFF`\t|If non-zero, the ten thousandths of a second in a date and time value. |2009-06-15T13:45:30.5275000 -> 5275, 2009-06-15T13:45:30.0000500 -> (no output)\r\n|`FFFFF`\t|If non-zero, the hundred thousandths of a second in a date and time value. |2009-06-15T13:45:30.6175400 -> 61754, 2009-06-15T13:45:30.0000050 -> (no output)\r\n|`FFFFFF`\t|If non-zero, the millionths of a second in a date and time value. |2009-06-15T13:45:30.6175420 -> 617542, 2009-06-15T13:45:30.0000005 -> (no output)\r\n|`FFFFFFF`\t|If non-zero, the ten millionths of a second in a date and time value. |2009-06-15T13:45:30.6175425 -> 6175425, 2009-06-15T13:45:30.0001150 -> 000115\r\n|`h`\t|The hour, using a 12-hour clock from 1 to 12. |2009-06-15T01:45:30 -> 1, 2009-06-15T13:45:30 -> 1\r\n|`hh`\t|The hour, using a 12-hour clock from 01 to 12. |2009-06-15T01:45:30 -> 01, 2009-06-15T13:45:30 -> 01\r\n|`H`\t|The hour, using a 24-hour clock from 0 to 23. |2009-06-15T01:45:30 -> 1, 2009-06-15T13:45:30 -> 13\r\n|`HH`\t|The hour, using a 24-hour clock from 00 to 23. |2009-06-15T01:45:30 -> 01, 2009-06-15T13:45:30 -> 13\r\n|`m`\t|The minute, from 0 through 59. |2009-06-15T01:09:30 -> 9, 2009-06-15T13:29:30 -> 29\r\n|`mm`\t|The minute, from 00 through 59. |2009-06-15T01:09:30 -> 09, 2009-06-15T01:45:30 -> 45\r\n|`M`\t|The month, from 1 through 12. |2009-06-15T13:45:30 -> 6\r\n|`MM`\t|The month, from 01 through 12.|2009-06-15T13:45:30 -> 06\r\n|`s`\t|The second, from 0 through 59. |2009-06-15T13:45:09 -> 9\r\n|`ss`\t|The second, from 00 through 59. |2009-06-15T13:45:09 -> 09\r\n|`y`\t|The year, from 0 to 99. |0001-01-01T00:00:00 -> 1, 0900-01-01T00:00:00 -> 0, 1900-01-01T00:00:00 -> 0, 2009-06-15T13:45:30 -> 9, 2019-06-15T13:45:30 -> 19\r\n|`yy`\t|The year, from 00 to 99. |\t0001-01-01T00:00:00 -> 01, 0900-01-01T00:00:00 -> 00, 1900-01-01T00:00:00 -> 00, 2019-06-15T13:45:30 -> 19\r\n|`yyyy`\t|The year as a four-digit number. |\t0001-01-01T00:00:00 -> 0001, 0900-01-01T00:00:00 -> 0900, 1900-01-01T00:00:00 -> 1900, 2009-06-15T13:45:30 -> 2009\r\n|`tt`\t|AM / PM hours |2009-06-15T13:45:09 -> PM\r\n\r\n**Supported delimeters**\r\n\r\nFormat specifier can include following delimeters characters:\r\n\r\n|Delimeter|Comment|\r\n|---------|-------|\r\n|`' '`| Space|\r\n|`'/'`||\r\n|`'-'`|Dash|\r\n|`':'`||\r\n|`','`||\r\n|`'.'`||\r\n|`'_'`||\r\n|`'['`||\r\n|`']'`||","```\r\nlet dt = datetime(2017-01-29 09:00:05);\r\nprint \r\nv1=format_datetime(dt,'yy-MM-dd [HH:mm:ss]'), \r\nv2=format_datetime(dt, 'yyyy-M-dd [H:mm:ss]'),\r\nv3=format_datetime(dt, 'yy-MM-dd [hh:mm:ss tt]')\r\n```\r\n\r\n|v1|v2|v3|\r\n|---|---|---|\r\n|17-01-29 [09:00:05]|2017-1-29 [9:00:05]|17-01-29 [09:00:05 AM]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/format-datetimefunction","format-datetimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_ipv4","Parses input with a netmask and returns string representing IPv4 address.","```\r\nprint format_ipv4('192.168.1.255', 24) == '192.168.1.0'\r\nprint format_ipv4(3232236031, 24) == '192.168.1.0'\r\n```\r\n\r\n## Syntax\r\n\r\n`format_ipv4(`*Expr* [`,` *PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: A string or number representation of the IPv4 address.\r\n* *`PrefixMask`*: (Optional) An integer from 0 to 32 representing the number of most-significant bits that are taken into account. If argument isn't specified, all bit-masks are used (32).\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result will be a string representing IPv4 address.\r\nIf conversion isn't successful, the result will be an empty string.\r\n\r\n## See also\r\n\r\n- [format_ipv4_mask()](format-ipv4-mask-function.md): For IPv4 address formatting including CIDR notation.\r\n- [IPv4 and IPv6 functions](scalarfunctions.md#ipv4ipv6-functions)","```\r\ndatatable(address:string, mask:long)\r\n[\r\n '192.168.1.1', 24,          \r\n '192.168.1.1', 32,          \r\n '192.168.1.1/24', 32,       \r\n '192.168.1.1/24', long(-1), \r\n]\r\n| extend result = format_ipv4(address, mask), \r\n         result_mask = format_ipv4_mask(address, mask)\r\n```\r\n\r\n|address|mask|result|result_mask|\r\n|---|---|---|---|\r\n|192.168.1.1|24|192.168.1.0|192.168.1.0/24|\r\n|192.168.1.1|32|192.168.1.1|192.168.1.1/32|\r\n|192.168.1.1/24|32|192.168.1.0|192.168.1.0/24|\r\n|192.168.1.1/24|-1|||","https://docs.microsoft.com/azure/data-explorer/kusto/query/format-ipv4-function","format-ipv4-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_ipv4_mask","Parses input with a netmask and returns string representing IPv4 address as CIDR notation.","```\r\nprint format_ipv4_mask('192.168.1.255', 24) == '192.168.1.0/24'\r\nprint format_ipv4_mask(3232236031, 24) == '192.168.1.0/24'\r\n```\r\n\r\n## Syntax\r\n\r\n`format_ipv4_mask(`*Expr* [`,` *PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *`Expr`*: A string or number representation of the IPv4 address as CIDR notation.\r\n* *`PrefixMask`*: (Optional) An integer from 0 to 32 representing the number of most-significant bits that are taken into account. If argument isn't specified, all bit-masks are used (32).\r\n\r\n## Returns\r\n\r\nIf conversion is successful, the result will be a string representing IPv4 address as CIDR notation.\r\nIf conversion isn't successful, the result will be an empty string.\r\n\r\n## See also\r\n\r\n- [format_ipv4()](format-ipv4-function.md): For IPv4 address formatting without CIDR notation.\r\n- [IPv4 and IPv6 functions](scalarfunctions.md#ipv4ipv6-functions)","```\r\ndatatable(address:string, mask:long)\r\n[\r\n '192.168.1.1', 24,          \r\n '192.168.1.1', 32,          \r\n '192.168.1.1/24', 32,       \r\n '192.168.1.1/24', long(-1), \r\n]\r\n| extend result = format_ipv4(address, mask), \r\n         result_mask = format_ipv4_mask(address, mask)\r\n```\r\n\r\n|address|mask|result|result_mask|\r\n|---|---|---|---|\r\n|192.168.1.1|24|192.168.1.0|192.168.1.0/24|\r\n|192.168.1.1|32|192.168.1.1|192.168.1.1/32|\r\n|192.168.1.1/24|32|192.168.1.0|192.168.1.0/24|\r\n|192.168.1.1/24|-1|||","https://docs.microsoft.com/azure/data-explorer/kusto/query/format-ipv4-mask-function","format-ipv4-mask-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"format_timespan","Formats a timespan according to the provided format.","```\r\nformat_timespan(time(14.02:03:04.12345), 'h:m:s.fffffff') == \"2:3:4.1234500\"\r\n```\r\n\r\n## Syntax\r\n\r\n`format_timespan(`*timespan* `,` *format*`)`\r\n\r\n## Arguments\r\n\r\n* `timespan`: value of a type `timespan`.\r\n* `format`: format specifier string, consisting of one or more [format elements](#supported-formats).\r\n\r\n## Returns\r\n\r\nThe string with the format result.\r\n\r\n## Supported formats\r\n\r\n|Format specifier\t|Description\t|Examples\r\n|---|---|---\r\n|`d`-`dddddddd`\t|The number of whole days in the time interval. Padded with zeros if needed.|\t15.13:45:30: d -> 15, dd -> 15, ddd -> 015\r\n|`f`\t|The tenths of a second in the time interval. |15.13:45:30.6170000 -> 6, 15.13:45:30.05 -> 0\r\n|`ff`\t|The hundredths of a second in the time interval. |15.13:45:30.6170000 -> 61, 15.13:45:30.0050000 -> 00\r\n|`fff`\t|The milliseconds in the time interval. |6/15/2009 13:45:30.617 -> 617, 6/15/2009 13:45:30.0005 -> 000\r\n|`ffff`\t|The ten thousandths of a second in the time interval. |15.13:45:30.6175000 -> 6175, 15.13:45:30.0000500 -> 0000\r\n|`fffff`\t|The hundred thousandths of a second in the time interval. |15.13:45:30.6175400 -> 61754, 15.13:45:30.000005 -> 00000\r\n|`ffffff`\t|The millionths of a second in the time interval. |15.13:45:30.6175420 -> 617542, 15.13:45:30.0000005 -> 000000\r\n|`fffffff`\t|The ten millionths of a second in the time interval. |15.13:45:30.6175425 -> 6175425, 15.13:45:30.0001150 -> 0001150\r\n|`F`\t|If non-zero, the tenths of a second in the time interval. |15.13:45:30.6170000 -> 6, 15.13:45:30.0500000 -> (no output)\r\n|`FF`\t|If non-zero, the hundredths of a second in the time interval. |15.13:45:30.6170000 -> 61, 15.13:45:30.0050000 -> (no output)\r\n|`FFF`\t|If non-zero, the milliseconds in the time interval. |15.13:45:30.6170000 -> 617, 15.13:45:30.0005000 -> (no output)\r\n|`FFFF`\t|If non-zero, the ten thousandths of a second in the time interval. |15.13:45:30.5275000 -> 5275, 15.13:45:30.0000500 -> (no output)\r\n|`FFFFF`\t|If non-zero, the hundred thousandths of a second in the time interval. |15.13:45:30.6175400 -> 61754, 15.13:45:30.0000050 -> (no output)\r\n|`FFFFFF`\t|If non-zero, the millionths of a second in the time interval. |15.13:45:30.6175420 -> 617542, 15.13:45:30.0000005 -> (no output)\r\n|`FFFFFFF`\t|If non-zero, the ten millionths of a second in the time interval. |15.13:45:30.6175425 -> 6175425, 15.13:45:30.0001150 -> 000115\r\n|`H`\t|The hour, using a 24-hour clock from 0 to 23. |15.01:45:30 -> 1, 15.13:45:30 -> 13\r\n|`HH`\t|The hour, using a 24-hour clock from 00 to 23. |15.01:45:30 -> 01, 15.13:45:30 -> 13\r\n|`m`\t|The number of whole minutes in the time interval that are not included as part of hours or days. Single-digit minutes do not have a leading zero. |15.01:09:30 -> 9, 15.13:29:30 -> 29\r\n|`mm`\t|The number of whole minutes in the time interval that are not included as part of hours or days. Single-digit minutes have a leading zero. |15.01:09:30 -> 09, 15.01:45:30 -> 45\r\n|`s`\t|The number of whole seconds in the time interval that are not included as part of hours, days, or minutes. Single-digit seconds do not have a leading zero. |15.13:45:09 -> 9\r\n|`ss`\t|The number of whole seconds in the time interval that are not included as part of hours, days, or minutes. Single-digit seconds have a leading zero. |15.13:45:09 -> 09\r\n\r\n**Supported delimeters**\r\n\r\nFormat specifier can include following delimeters characters:\r\n\r\n|Delimeter|Comment|\r\n|---------|-------|\r\n|`' '`| Space|\r\n|`'/'`||\r\n|`'-'`|Dash|\r\n|`':'`||\r\n|`','`||\r\n|`'.'`||\r\n|`'_'`||\r\n|`'['`||\r\n|`']'`||","```\r\nlet t = time(29.09:00:05.12345);\r\nprint \r\nv1=format_timespan(t, 'dd.hh:mm:ss:FF'),\r\nv2=format_timespan(t, 'ddd.h:mm:ss [fffffff]')\r\n```\r\n\r\n|v1|v2|\r\n|---|---|\r\n|29.09:00:05:12|029.9:00:05 [1234500]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/format-timespanfunction","format-timespanfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"funnel_sequence","Calculates distinct count of users who have taken a sequence of states, and the distribution of previous/next states that have led to/were followed by the sequence. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","```\r\nT | evaluate funnel_sequence(id, datetime_column, startofday(ago(30d)), startofday(now()), 10m, 1d, state_column, dynamic(['S1', 'S2', 'S3']))\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| evaluate` `funnel_sequence(`*IdColumn*`,` *TimelineColumn*`,` *Start*`,` *End*`,` *MaxSequenceStepWindow*, *Step*, *StateColumn*, *Sequence*`)`\r\n\r\n## Arguments\r\n\r\n* *T*: the input tabular expression.\r\n* *IdColum*: column reference, must be present in the source expression.\r\n* *TimelineColumn*: column reference representing timeline, must be present in the source expression.\r\n* *Start*: scalar constant value of the analysis start period.\r\n* *End*: scalar constant value of the analysis end period.\r\n* *MaxSequenceStepWindow*: scalar constant value of the max allowed timespan between two sequential steps in the sequence.\r\n* *Step*: scalar constant value of the analysis step period (bin).\r\n* *StateColumn*: column reference representing the state, must be present in the source expression.\r\n* *Sequence*: a constant dynamic array with the sequence values (values are looked up in `StateColumn`).\r\n\r\n## Returns\r\n\r\nReturns three output tables, which are useful for constructing a sankey diagram for the analyzed sequence:\r\n\r\n* Table #1 - prev-sequence-next `dcount`\r\n    - TimelineColumn: the analyzed time window\r\n    - prev: the prev state (may be empty if there were any users that only had events for the searched sequence, but not any events prior to it). \r\n    - next: the next state (may be empty if there were any users that only had events for the searched sequence, but not any events that followed it). \r\n    - `dcount`: distinct count of `IdColumn` in time window that transitioned `prev` --> `Sequence` --> `next`. \r\n    - samples: an array of IDs (from `IdColumn`) corresponding to the row's sequence (a maximum of 128 IDs are returned). \r\n* Table #2 - prev-sequence `dcount`\r\n    - TimelineColumn: the analyzed time window\r\n    - prev: the prev state (may be empty if there were any users that only had events for the searched sequence, but not any events prior to it). \r\n    - `dcount`: distinct count of `IdColumn` in time window that transitioned `prev` --> `Sequence` --> `next`. \r\n    - samples: an array of IDs (from `IdColumn`) corresponding to the row's sequence (a maximum of 128 IDs are returned). \r\n* Table #3 - sequence-next `dcount`\r\n    - TimelineColumn: the analyzed time window\r\n    - next: the next state (may be empty if there were any users that only had events for the searched sequence, but not any events that followed it). \r\n    - `dcount`: distinct count of `IdColumn` in time window that transitioned `prev` --> `Sequence` --> `next`.\r\n    - samples: an array of IDs (from `IdColumn`) corresponding to the row's sequence (a maximum of 128 IDs are returned).","### Exploring Storm Events \r\n\r\nThe following query looks at the table StormEvents (weather statistics for 2007) and shows which events happened before/after all Tornado events occurred in 2007.\r\n\r\n```\r\n// Looking on StormEvents statistics: \r\n// Q1: What happens before Tornado event?\r\n// Q2: What happens after Tornado event?\r\nStormEvents\r\n| evaluate funnel_sequence(EpisodeId, StartTime, datetime(2007-01-01), datetime(2008-01-01), 1d,365d, EventType, dynamic(['Tornado']))\r\n```\r\n\r\nResult includes three tables:\r\n\r\n* Table #1: All possible variants of what happened before and after the sequence. For example, the second line means that there were 87 different events that had following sequence: `Hail` -> `Tornado` -> `Hail`\r\n\r\n\r\n\r\n|`StartTime`|`prev`|`next`|`dcount`|\r\n|---|---|---|---|\r\n|2007-01-01 00:00:00.0000000|||293|\r\n|2007-01-01 00:00:00.0000000|Hail|Hail|87|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind|Thunderstorm Wind|77|\r\n|2007-01-01 00:00:00.0000000|Hail|Thunderstorm Wind|28|\r\n|2007-01-01 00:00:00.0000000|Hail||28|\r\n|2007-01-01 00:00:00.0000000||Hail|27|\r\n|2007-01-01 00:00:00.0000000||Thunderstorm Wind|25|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind|Hail|24|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind||24|\r\n|2007-01-01 00:00:00.0000000|Flash Flood|Flash Flood|12|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind|Flash Flood|8|\r\n|2007-01-01 00:00:00.0000000|Flash Flood||8|\r\n|2007-01-01 00:00:00.0000000|Funnel Cloud|Thunderstorm Wind|6|\r\n|2007-01-01 00:00:00.0000000||Funnel Cloud|6|\r\n|2007-01-01 00:00:00.0000000||Flash Flood|6|\r\n|2007-01-01 00:00:00.0000000|Funnel Cloud|Funnel Cloud|6|\r\n|2007-01-01 00:00:00.0000000|Hail|Flash Flood|4|\r\n|2007-01-01 00:00:00.0000000|Flash Flood|Thunderstorm Wind|4|\r\n|2007-01-01 00:00:00.0000000|Hail|Funnel Cloud|4|\r\n|2007-01-01 00:00:00.0000000|Funnel Cloud|Hail|4|\r\n|2007-01-01 00:00:00.0000000|Funnel Cloud||4|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind|Funnel Cloud|3|\r\n|2007-01-01 00:00:00.0000000|Heavy Rain|Thunderstorm Wind|2|\r\n|2007-01-01 00:00:00.0000000|Flash Flood|Funnel Cloud|2|\r\n|2007-01-01 00:00:00.0000000|Flash Flood|Hail|2|\r\n|2007-01-01 00:00:00.0000000|Strong Wind|Thunderstorm Wind|1|\r\n|2007-01-01 00:00:00.0000000|Heavy Rain|Flash Flood|1|\r\n|2007-01-01 00:00:00.0000000|Heavy Rain|Hail|1|\r\n|2007-01-01 00:00:00.0000000|Hail|Flood|1|\r\n|2007-01-01 00:00:00.0000000|Lightning|Hail|1|\r\n|2007-01-01 00:00:00.0000000|Heavy Rain|Lightning|1|\r\n|2007-01-01 00:00:00.0000000|Funnel Cloud|Heavy Rain|1|\r\n|2007-01-01 00:00:00.0000000|Flash Flood|Flood|1|\r\n|2007-01-01 00:00:00.0000000|Flood|Flash Flood|1|\r\n|2007-01-01 00:00:00.0000000||Heavy Rain|1|\r\n|2007-01-01 00:00:00.0000000|Funnel Cloud|Lightning|1|\r\n|2007-01-01 00:00:00.0000000|Lightning|Thunderstorm Wind|1|\r\n|2007-01-01 00:00:00.0000000|Flood|Thunderstorm Wind|1|\r\n|2007-01-01 00:00:00.0000000|Hail|Lightning|1|\r\n|2007-01-01 00:00:00.0000000||Lightning|1|\r\n|2007-01-01 00:00:00.0000000|Tropical Storm|Hurricane (Typhoon)|1|\r\n|2007-01-01 00:00:00.0000000|Coastal Flood||1|\r\n|2007-01-01 00:00:00.0000000|Rip Current||1|\r\n|2007-01-01 00:00:00.0000000|Heavy Snow||1|\r\n|2007-01-01 00:00:00.0000000|Strong Wind||1|\r\n\r\n* Table #2: shows all distinct events grouped by the previous event. For example, the second line shows that there were a total of 150 events of `Hail` that happened just before `Tornado`.\r\n\r\n\r\n|`StartTime`|`prev`|`dcount`|\r\n|---------|-----|------|\r\n|2007-01-01 00:00:00.0000000||331|\r\n|2007-01-01 00:00:00.0000000|Hail|150|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind|135|\r\n|2007-01-01 00:00:00.0000000|Flash Flood|28|\r\n|2007-01-01 00:00:00.0000000|Funnel Cloud|22|\r\n|2007-01-01 00:00:00.0000000|Heavy Rain|5|\r\n|2007-01-01 00:00:00.0000000|Flood|2|\r\n|2007-01-01 00:00:00.0000000|Lightning|2|\r\n|2007-01-01 00:00:00.0000000|Strong Wind|2|\r\n|2007-01-01 00:00:00.0000000|Heavy Snow|1|\r\n|2007-01-01 00:00:00.0000000|Rip Current|1|\r\n|2007-01-01 00:00:00.0000000|Coastal Flood|1|\r\n|2007-01-01 00:00:00.0000000|Tropical Storm|1|\r\n\r\n* Table #3: shows all distinct events grouped by next event. For example, the second line shows that there were a total of 143 events of `Hail` that happened after `Tornado`.\r\n\r\n\r\n|`StartTime`|`next`|`dcount`|\r\n|---------|-----|------|\r\n|2007-01-01 00:00:00.0000000||332|\r\n|2007-01-01 00:00:00.0000000|Hail|145|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind|143|\r\n|2007-01-01 00:00:00.0000000|Flash Flood|32|\r\n|2007-01-01 00:00:00.0000000|Funnel Cloud|21|\r\n|2007-01-01 00:00:00.0000000|Lightning|4|\r\n|2007-01-01 00:00:00.0000000|Heavy Rain|2|\r\n|2007-01-01 00:00:00.0000000|Flood|2|\r\n|2007-01-01 00:00:00.0000000|Hurricane (Typhoon)|1|\r\n\r\nNow, let's try to find out how the following sequence continues:  \r\n`Hail` -> `Tornado` -> `Thunderstorm Wind`\r\n\r\n```\r\nStormEvents\r\n| evaluate funnel_sequence(EpisodeId, StartTime, datetime(2007-01-01), datetime(2008-01-01), 1d,365d, EventType, \r\ndynamic(['Hail', 'Tornado', 'Thunderstorm Wind']))\r\n```\r\n\r\nSkipping `Table #1` and `Table #2`, and looking at `Table #3`, we can conclude that sequence `Hail` -> `Tornado` -> `Thunderstorm Wind` in 92 events ended with this sequence, continued as `Hail` in 41 events, and turned back to `Tornado` in 14.\r\n\r\n|`StartTime`|`next`|`dcount`|\r\n|---------|-----|------|\r\n|2007-01-01 00:00:00.0000000||92|\r\n|2007-01-01 00:00:00.0000000|Hail|41|\r\n|2007-01-01 00:00:00.0000000|Tornado|14|\r\n|2007-01-01 00:00:00.0000000|Flash Flood|11|\r\n|2007-01-01 00:00:00.0000000|Lightning|2|\r\n|2007-01-01 00:00:00.0000000|Heavy Rain|1|\r\n|2007-01-01 00:00:00.0000000|Flood|1|","https://docs.microsoft.com/azure/data-explorer/kusto/query/funnel-sequence-plugin","funnel-sequence-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"funnel_sequence_completion","Calculates a funnel of completed sequence steps while comparing different time periods. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","```\r\nT | evaluate funnel_sequence_completion(id, datetime_column, startofday(ago(30d)), startofday(now()), 1d, state_column, dynamic(['S1', 'S2', 'S3']), dynamic([10m, 30min, 1h]))\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| evaluate` `funnel_sequence_completion(`*IdColumn*`,` *TimelineColumn*`,` *Start*`,` *End*`,` *BinSize*`,` *StateColumn*`,` *Sequence*`,` *MaxSequenceStepWindows*`)`\r\n\r\n## Arguments\r\n\r\n* *T*: The input tabular expression.\r\n* *IdColum*: column reference, must be present in the source expression.\r\n* *TimelineColumn*: column reference representing timeline, must be present in the source expression.\r\n* *Start*: scalar constant value of the analysis start period.\r\n* *End*: scalar constant value of the analysis end period.\r\n* *BinSize*: scalar constant value of the analysis window (bin) size, each window is analyzed separately.\r\n* *StateColumn*: column reference representing the state, must be present in the source expression.\r\n* *Sequence*: a constant dynamic array with the sequence values (values are looked up in `StateColumn`).\r\n* *MaxSequenceStepPeriods*: scalar constant dynamic array with the values of the max allowed timespan between the first and last sequential steps in the sequence. Each period in the array generates a funnel analysis result.\r\n\r\n## Returns\r\n\r\nReturns a single table useful for constructing a funnel diagram for the analyzed sequence:\r\n\r\n* `TimelineColumn`: the analyzed time window (bin), each bin in the analysis timeframe (*Start* to *End*) generates a funnel analysis separately.\r\n* `StateColumn`: the state of the sequence.\r\n* `Period`: the maximal period allowed for completing steps in the funnel sequence measured from the first step in the sequence. Each value in *MaxSequenceStepPeriods* generates a funnel analysis with a separate period. \r\n* `dcount`: distinct count of `IdColumn` in time window that transitioned from first sequence state to the value of `StateColumn`.\r\n\r\n## See also\r\n\r\n* [scan operator](scan-operator.md)","### Exploring Storm Events \r\n\r\nThe following query checks the completion funnel of the sequence: `Hail` -> `Tornado` -> `Thunderstorm Wind`\r\nin \"overall\" time of 1hour, 4hours, 1day. \r\n\r\n```\r\nlet _start = datetime(2007-01-01);\r\nlet _end =  datetime(2008-01-01);\r\nlet _windowSize = 365d;\r\nlet _sequence = dynamic(['Hail', 'Tornado', 'Thunderstorm Wind']);\r\nlet _periods = dynamic([1h, 4h, 1d]);\r\nStormEvents\r\n| evaluate funnel_sequence_completion(EpisodeId, StartTime, _start, _end, _windowSize, EventType, _sequence, _periods) \r\n```\r\n\r\n|`StartTime`|`EventType`|`Period`|`dcount`|\r\n|---|---|---|---|\r\n|2007-01-01 00:00:00.0000000|Hail|01:00:00|2877|\r\n|2007-01-01 00:00:00.0000000|Tornado|01:00:00|208|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind|01:00:00|87|\r\n|2007-01-01 00:00:00.0000000|Hail|04:00:00|2877|\r\n|2007-01-01 00:00:00.0000000|Tornado|04:00:00|231|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind|04:00:00|141|\r\n|2007-01-01 00:00:00.0000000|Hail|1.00:00:00|2877|\r\n|2007-01-01 00:00:00.0000000|Tornado|1.00:00:00|244|\r\n|2007-01-01 00:00:00.0000000|Thunderstorm Wind|1.00:00:00|155|\r\n\r\nUnderstanding the results:  \r\nThe outcome is three funnels (for periods: One hour, 4 hours, and one day). For each funnel step, a number \r\nof distinct counts of  are shown. You can see that the more time is given to complete the whole sequence of `Hail` -> `Tornado` -> `Thunderstorm Wind`, the higher `dcount` value is obtained. In other words, there were more occurrences of the sequence reaching the funnel step.","https://docs.microsoft.com/azure/data-explorer/kusto/query/funnel-sequence-completion-plugin","funnel-sequence-completion-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"gamma","Computes [gamma function](https://en.wikipedia.org/wiki/Gamma_function)","## Syntax\r\n\r\n`gamma(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Parameter for the gamma function\r\n\r\n## Returns\r\n\r\n* Gamma function of x.\r\n* For computing log-gamma function, see [loggamma()](loggammafunction.md).","","https://docs.microsoft.com/azure/data-explorer/kusto/query/gammafunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_distance_2points","Calculates the shortest distance between two geospatial coordinates on Earth.","## Syntax\r\n\r\n`geo_distance_2points(`*p1_longitude*`, `*p1_latitude*`, `*p2_longitude*`, `*p2_latitude*`)`\r\n\r\n## Arguments\r\n\r\n* *p1_longitude*: First geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *p1_latitude*: First geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *p2_longitude*: Second geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *p2_latitude*: Second geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n\r\n## Returns\r\n\r\nThe shortest distance, in meters, between two geographic locations on Earth. If the coordinates are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere.",'The following example finds the shortest distance between Seattle and Los Angeles.\r\n\r\n![Distance between Seattle and Los Angeles.](images/geo-distance-2points-function/distance_2points_seattle_los_angeles.png)\r\n\r\n```\r\nprint distance_in_meters = geo_distance_2points(-122.407628, 47.578557, -118.275287, 34.019056)\r\n```\r\n\r\n| distance_in_meters |\r\n|--------------------|\r\n| 1546754.35197381   |\r\n\r\nHere is an approximation of shortest path from Seattle to London. The line consists of coordinates along the LineString and within 500 meters from it.\r\n\r\n![Seattle to London LineString.](images/geo-distance-2points-function/line_seattle_london.png)\r\n\r\n```\r\nrange i from 1 to 1000000 step 1\r\n| project lng = rand() * real(-122), lat = rand() * 90\r\n| where lng between(real(-122) .. 0) and lat between(47 .. 90)\r\n| where geo_distance_point_to_line(lng,lat,dynamic({"type":"LineString","coordinates":[[-122,47],[0,51]]})) < 500\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example finds all rows in which the shortest distance between two coordinates is between 1 and 11 meters.\r\n\r\n```\r\nStormEvents\r\n| extend distance_1_to_11m = geo_distance_2points(BeginLon, BeginLat, EndLon, EndLat)\r\n| where distance_1_to_11m between (1 .. 11)\r\n| project distance_1_to_11m\r\n```\r\n\r\n| distance_1_to_11m |\r\n|-------------------|\r\n| 10.5723100154958  |\r\n| 7.92153588248414  |\r\n\r\nThe following example returns a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint distance = geo_distance_2points(300,1,1,1)\r\n```\r\n\r\n| distance |\r\n|----------|\r\n|          |',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-distance-2points-function","geo-distance-2points-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_distance_point_to_line","Calculates the shortest distance between a coordinate and a line or multiline on Earth.",'## Syntax\r\n\r\n`geo_distance_point_to_line(`*longitude*`, `*latitude*`, `*lineString*`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Geospatial coordinate longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *latitude*: Geospatial coordinate latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *lineString*: Line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nThe shortest distance, in meters, between a coordinate and a line or multiline on Earth. If the coordinate or lineString are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r\n\r\n**LineString definition and constraints**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* Coordinates [longitude,latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r\n* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n\r\n> [!TIP]\r\n> * Using literal LineString or a MultiLineString may result in better performance.\r\n> * If you want to know the shortest distance between one or more points to many lines, consider folding these lines into one multiline. See the [example](#examples) below.','The following example finds the shortest distance between North Las Vegas Airport and a nearby road.\r\n\r\n![Distance between North Las Vegas Airport and road.](images/geo-distance-point-to-line-function/distance-point-to-line.png)\r\n\r\n```\r\nprint distance_in_meters = geo_distance_point_to_line(-115.199625, 36.210419, dynamic({ "type":"LineString","coordinates":[[-115.115385,36.229195],[-115.136995,36.200366],[-115.140252,36.192470],[-115.143558,36.188523],[-115.144076,36.181954],[-115.154662,36.174483],[-115.166431,36.176388],[-115.183289,36.175007],[-115.192612,36.176736],[-115.202485,36.173439],[-115.225355,36.174365]]}))\r\n```\r\n\r\n| distance_in_meters |\r\n|--------------------|\r\n| 3797.88887253334   |\r\n\r\nStorm events in south coast US. The events are filtered by a maximum distance of 5 km from the defined shore line.\r\n\r\n![Storm events in the US south coast.](images/geo-distance-point-to-line-function/us-south-coast-storm-events.png)\r\n\r\n```\r\nlet southCoast = dynamic({"type":"LineString","coordinates":[[-97.18505859374999,25.997549919572112],[-97.58056640625,26.96124577052697],[-97.119140625,27.955591004642553],[-94.04296874999999,29.726222319395504],[-92.98828125,29.82158272057499],[-89.18701171875,29.11377539511439],[-89.384765625,30.315987718557867],[-87.5830078125,30.221101852485987],[-86.484375,30.4297295750316],[-85.1220703125,29.6880527498568],[-84.00146484374999,30.14512718337613],[-82.6611328125,28.806173508854776],[-82.81494140625,28.033197847676377],[-82.177734375,26.52956523826758],[-80.9912109375,25.20494115356912]]});\r\nStormEvents\r\n| project BeginLon, BeginLat, EventType\r\n| where geo_distance_point_to_line(BeginLon, BeginLat, southCoast) < 5000\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nNY taxi pickups. Pickups are filtered by maximum distance of 0.1 meters from the defined multiline.\r\n\r\n![NYC taxi pickups on Madison Ave.](images/geo-distance-point-to-line-function/madison-ave-road.png)\r\n\r\n```\r\nlet MadisonAve = dynamic({"type":"MultiLineString","coordinates":[[[-73.9879823,40.7408625],[-73.9876492,40.7413345],[-73.9874982,40.7415046],[-73.9870343,40.7421446],[-73.9865812,40.7427655],[-73.9861292,40.7433756],[-73.9856813,40.7439956],[-73.9854932,40.7442606],[-73.9852232,40.7446216],[-73.9847903,40.7452305],[-73.9846232,40.7454536],[-73.9844803,40.7456606],[-73.9843413,40.7458585],[-73.9839533,40.7463955],[-73.9839002,40.7464696],[-73.9837683,40.7466566],[-73.9834342,40.7471015],[-73.9833833,40.7471746],[-73.9829712,40.7477686],[-73.9824752,40.7484255],[-73.9820262,40.7490436],[-73.9815623,40.7496566],[-73.9811212,40.7502796],[-73.9809762,40.7504976],[-73.9806982,40.7509255],[-73.9802752,40.7515216],[-73.9798033,40.7521795],[-73.9795863,40.7524656],[-73.9793082,40.7528316],[-73.9787872,40.7534725],[-73.9783433,40.7540976],[-73.9778912,40.7547256],[-73.9774213,40.7553365],[-73.9769402,40.7559816],[-73.9764622,40.7565766],[-73.9760073,40.7572036],[-73.9755592,40.7578366],[-73.9751013,40.7584665],[-73.9746532,40.7590866],[-73.9741902,40.7597326],[-73.9737632,40.7603566],[-73.9733032,40.7609866],[-73.9728472,40.7616205],[-73.9723422,40.7622826],[-73.9718672,40.7629556],[-73.9714042,40.7635726],[-73.9709362,40.7642185],[-73.9705282,40.7647636],[-73.9704903,40.7648196],[-73.9703342,40.7650355],[-73.9701562,40.7652826],[-73.9700322,40.7654535],[-73.9695742,40.7660886],[-73.9691232,40.7667166],[-73.9686672,40.7673375],[-73.9682142,40.7679605],[-73.9677482,40.7685786],[-73.9672883,40.7692076],[-73.9668412,40.7698296],[-73.9663882,40.7704605],[-73.9659222,40.7710936],[-73.9654262,40.7717756],[-73.9649292,40.7724595],[-73.9644662,40.7730955],[-73.9640012,40.7737285],[-73.9635382,40.7743615],[-73.9630692,40.7749936],[-73.9626122,40.7756275],[-73.9621172,40.7763106],[-73.9616111,40.7769896],[-73.9611552,40.7776245],[-73.9606891,40.7782625],[-73.9602212,40.7788866],[-73.9597532,40.7795236],[-73.9595842,40.7797445],[-73.9592942,40.7801635],[-73.9591122,40.7804105],[-73.9587982,40.7808305],[-73.9582992,40.7815116],[-73.9578452,40.7821455],[-73.9573802,40.7827706],[-73.9569262,40.7833965],[-73.9564802,40.7840315],[-73.9560102,40.7846486],[-73.9555601,40.7852755],[-73.9551221,40.7859005],[-73.9546752,40.7865426],[-73.9542571,40.7871505],[-73.9541771,40.7872335],[-73.9540892,40.7873366],[-73.9536971,40.7879115],[-73.9532792,40.7884706],[-73.9532142,40.7885205],[-73.9531522,40.7885826],[-73.9527382,40.7891785],[-73.9523081,40.7897545],[-73.9518332,40.7904115],[-73.9513721,40.7910435],[-73.9509082,40.7916695],[-73.9504602,40.7922995],[-73.9499882,40.7929195],[-73.9495051,40.7936045],[-73.9490071,40.7942835],[-73.9485542,40.7949065],[-73.9480832,40.7955345],[-73.9476372,40.7961425],[-73.9471772,40.7967915],[-73.9466841,40.7974475],[-73.9453432,40.7992905],[-73.9448332,40.7999835],[-73.9443442,40.8006565],[-73.9438862,40.8012945],[-73.9434262,40.8019196],[-73.9431412,40.8023325],[-73.9429842,40.8025585],[-73.9425691,40.8031855],[-73.9424401,40.8033609],[-73.9422987,40.8035533],[-73.9422013,40.8036857],[-73.9421022,40.8038205],[-73.9420024,40.8039552],[-73.9416372,40.8044485],[-73.9411562,40.8050725],[-73.9406471,40.8057176],[-73.9401481,40.8064135],[-73.9397022,40.8070255],[-73.9394081,40.8074155],[-73.9392351,40.8076495],[-73.9387842,40.8082715],[-73.9384681,40.8087086],[-73.9383211,40.8089025],[-73.9378792,40.8095215],[-73.9374011,40.8101795],[-73.936405,40.8115707],[-73.9362328,40.8118098]],[[-73.9362328,40.8118098],[-73.9362432,40.8118567],[-73.9361239,40.8120222],[-73.9360302,40.8120805]],[[-73.9362328,40.8118098],[-73.9361571,40.8118294],[-73.9360443,40.8119993],[-73.9360302,40.8120805]],[[-73.9360302,40.8120805],[-73.9359423,40.8121378],[-73.9358551,40.8122385],[-73.9352181,40.8130815],[-73.9348702,40.8135515],[-73.9347541,40.8137145],[-73.9346332,40.8138615],[-73.9345542,40.8139595],[-73.9344981,40.8139945],[-73.9344571,40.8140165],[-73.9343962,40.8140445],[-73.9343642,40.8140585],[-73.9343081,40.8140725],[-73.9341971,40.8140895],[-73.9341041,40.8141005],[-73.9340022,40.8140965],[-73.9338442,40.8141005],[-73.9333712,40.8140895],[-73.9325541,40.8140755],[-73.9324561,40.8140705],[-73.9324022,40.8140695]],[[-73.9360302,40.8120805],[-73.93605,40.8121667],[-73.9359632,40.8122805],[-73.9353631,40.8130795],[-73.9351482,40.8133625],[-73.9350072,40.8135415],[-73.9347441,40.8139168],[-73.9346611,40.8140125],[-73.9346101,40.8140515],[-73.9345401,40.8140965],[-73.9344381,40.8141385],[-73.9343451,40.8141555],[-73.9342991,40.8141675],[-73.9341552,40.8141985],[-73.9338601,40.8141885],[-73.9333991,40.8141815],[-73.9323981,40.8141665]]]});\r\nnyc_taxi\r\n| project pickup_longitude, pickup_latitude\r\n| where geo_distance_point_to_line(pickup_longitude, pickup_latitude, MadisonAve) <= 0.1\r\n| take 100\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example folds many lines into one multiline and queries this multiline. The query finds all taxi pickups that happened 10km away from all roads in Manhattan.\r\n\r\n![Lines folding.](images/geo-distance-point-to-line-function/lines-folding.png)\r\n\r\n```\r\nlet ManhattanRoads =\r\n    datatable(features:dynamic)\r\n    [\r\n        dynamic({"type":"Feature","properties":{"Label":"145thStreetBrg"},"geometry":{"type":"MultiLineString","coordinates":[[[-73.9322259,40.8194635],[-73.9323259,40.8194743],[-73.9323973,40.8194779]]]}}),\r\n        dynamic({"type":"Feature","properties":{"Label":"W120thSt"},"geometry":{"type":"MultiLineString","coordinates":[[[-73.9619541,40.8104844],[-73.9621542,40.8105725],[-73.9630542,40.8109455],[-73.9635902,40.8111714],[-73.9639492,40.8113174],[-73.9640502,40.8113705]]]}}),\r\n        dynamic({"type":"Feature","properties":{"Label":"1stAve"},"geometry":{"type":"MultiLineString","coordinates":[[[-73.9704124,40.748033],[-73.9702043,40.7480906],[-73.9696892,40.7487346],[-73.9695012,40.7491976],[-73.9694522,40.7493196]],[[-73.9699932,40.7488636],[-73.9694522,40.7493196]],[[-73.9694522,40.7493196],[-73.9693113,40.7494946],[-73.9688832,40.7501056],[-73.9686562,40.7504196],[-73.9684231,40.7507476],[-73.9679832,40.7513586],[-73.9678702,40.7514986]],[[-73.9676833,40.7520426],[-73.9675462,40.7522286],[-73.9673532,40.7524976],[-73.9672892,40.7525906],[-73.9672122,40.7526806]]]}})\r\n        // ... more roads ...\r\n    ];\r\nlet allRoads=toscalar(\r\n    ManhattanRoads\r\n    | project road_coordinates=features.geometry.coordinates\r\n    | summarize make_list(road_coordinates)\r\n    | project multiline = pack("type","MultiLineString", "coordinates", list_road_coordinates));\r\nnyc_taxi\r\n| project pickup_longitude, pickup_latitude\r\n| where pickup_longitude != 0 and pickup_latitude != 0\r\n| where geo_distance_point_to_line(pickup_longitude, pickup_latitude, todynamic(allRoads)) > 10000\r\n| take 10\r\n| render scatterchart with (kind=map)\r\n```\r\n\r\nThe following example will return a null result because of the invalid LineString input.\r\n\r\n```\r\nprint distance_in_meters = geo_distance_point_to_line(1,1, dynamic({ "type":"LineString"}))\r\n```\r\n\r\n| distance_in_meters |\r\n|--------------------|\r\n|                    |\r\n\r\nThe following example will return a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint distance_in_meters = geo_distance_point_to_line(300, 3, dynamic({ "type":"LineString","coordinates":[[1,1],[2,2]]}))\r\n```\r\n\r\n| distance_in_meters |\r\n|--------------------|\r\n|                    |',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-distance-point-to-line-function","geo-distance-point-to-line-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_distance_point_to_polygon","Calculates the shortest distance between a coordinate and a polygon or multipolygon on Earth.",'## Syntax\r\n\r\n`geo_distance_point_to_polygon(`*longitude*`, `*latitude*`, `*polygon*`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *latitude*: Geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *polygon*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nThe shortest distance, in meters, between a coordinate and a polygon or a multipolygon on Earth. If polygon contains point, the distance will be 0. If the coordinate or polygon are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r\n\r\n**Polygon definition and constraints**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r\n* Polygon doesn\'t necessarily contain its vertices.\r\n\r\n> [!TIP]\r\n> * Using literal polygons may result in better performance.\r\n> * If you want to know if polygon contains point, see [geo_point_in_polygon()](./geo-point-in-polygon-function.md)','The following example calculates shortest distance in meters from some location in NYC to Central Park.\r\n\r\n```\r\nlet central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r\nprint geo_distance_point_to_polygon(-73.9839, 40.7705, central_park)\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|259.940756070596|\r\n\r\nThe following example enriches the data with distance.\r\n\r\n```\r\nlet multipolygon = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]],[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]],[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]]});\r\nlet coordinates = \r\n    datatable(longitude:real, latitude:real, description:string)\r\n    [\r\n        real(-73.9741), 40.7914, \'Upper West Side\',\r\n        real(-73.9950), 40.7340, \'Greenwich Village\',\r\n        real(-73.8743), 40.7773, \'LaGuardia Airport\',\r\n    ];\r\ncoordinates\r\n| extend distance = geo_distance_point_to_polygon(longitude, latitude, multipolygon)\r\n```\r\n\r\n|longitude|latitude|description|distance|\r\n|---|---|---|---|\r\n|-73.9741|40.7914|Upper West Side|0|\r\n|-73.995|40.734|Greenwich Village|0|\r\n|-73.8743|40.7773|LaGuardia Airport|5702.15731467514|\r\n\r\nThe following example finds all states that are within 200 km distance, excluding state that contains the point.\r\n\r\n```\r\nUS_States\r\n| project name = features.properties.NAME, polygon = features.geometry\r\n| project name, distance = ceiling(geo_distance_point_to_polygon(-111.905, 40.634, polygon) / 1000)\r\n| where distance < 200 and distance > 0\r\n```\r\n\r\n|name|distance|\r\n|---|---|\r\n|Idaho|152|\r\n|Nevada|181|\r\n|Wyoming|83|\r\n\r\nThe following example will return a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint distance = geo_distance_point_to_polygon(500,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,1],[0,0]]]}))\r\n```\r\n\r\n| distance |\r\n|------------|\r\n|            |\r\n\r\nThe following example will return a null result because of the invalid polygon input.\r\n\r\n```\r\nprint distance = geo_distance_point_to_polygon(1,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]}))\r\n```\r\n\r\n| distance |\r\n|------------|\r\n|            |',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-distance-point-to-polygon-function","geo-distance-point-to-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_geohash_to_central_point","Calculates the geospatial coordinates that represent the center of a geohash rectangular area.","Read more about [`geohash`](https://en.wikipedia.org/wiki/Geohash).  \r\n\r\n## Syntax\r\n\r\n`geo_geohash_to_central_point(`*geohash*`)`\r\n\r\n## Arguments\r\n\r\n*geohash*: Geohash string value as it was calculated by [geo_point_to_geohash()](geo-point-to-geohash-function.md). The geohash string can be 1 to 18 characters.\r\n\r\n## Returns\r\n\r\nThe geospatial coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the geohash is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> The GeoJSON format specifies longitude first and latitude second.",'```\r\nprint point = geo_geohash_to_central_point("sunny")\r\n| extend coordinates = point.coordinates\r\n| extend longitude = coordinates[0], latitude = coordinates[1]\r\n```\r\n\r\n|point|coordinates|longitude|latitude|\r\n|---|---|---|---|\r\n|{<br>  "type": "Point",<br>  "coordinates": [<br>    42.47314453125,<br>    23.70849609375<br>  ]<br>}|[<br>  42.47314453125,<br>  23.70849609375<br>]|42.47314453125|23.70849609375|\r\n\r\nThe following example returns a null result because of the invalid geohash input.\r\n\r\n```\r\nprint geohash = geo_geohash_to_central_point("a")\r\n```\r\n\r\n|geohash|\r\n|---|\r\n||\r\n\r\n## Example: Creating location deep-links for Bing Maps\r\n\r\nYou can use the geohash value to create a deep-link URL to Bing Maps by pointing to the geohash center point:\r\n\r\n```\r\n// Use string concatenation to create Bing Map deep-link URL from a geo-point\r\nlet point_to_map_url = (_point:dynamic, _title:string) \r\n{\r\n    strcat(\'https://www.bing.com/maps?sp=point.\', _point.coordinates[1] ,\'_\', _point.coordinates[0], \'_\', url_encode(_title)) \r\n};\r\n// Convert geohash to center point, and then use \'point_to_map_url\' to create Bing Map deep-link\r\nlet geohash_to_map_url = (_geohash:string, _title:string)\r\n{\r\n    point_to_map_url(geo_geohash_to_central_point(_geohash), _title)\r\n};\r\nprint geohash = \'sv8wzvy7\'\r\n| extend url = geohash_to_map_url(geohash, "You are here")\r\n```\r\n\r\n|geohash|url|\r\n|---|---|\r\n|sv8wzvy7|[https://www.bing.com/maps?sp=point.32.15620994567871_34.80245590209961_You+are+here](https://www.bing.com/maps?sp=point.32.15620994567871_34.80245590209961_You+are+here)|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-geohash-to-central-point-function","geo-geohash-to-central-point-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_geohash_to_polygon","Calculates the polygon that represents the geohash rectangular area.","Read more about [geohash](https://en.wikipedia.org/wiki/Geohash).  \r\n\r\n## Syntax\r\n\r\n`geo_geohash_to_polygon(`*geohash*`)`\r\n\r\n## Arguments\r\n\r\n*geohash*: Geohash string value as it was calculated by [geo_point_to_geohash()](geo-point-to-geohash-function.md). The geohash string must be between 1 and 18 characters.\r\n\r\n## Returns\r\n\r\nPolygon in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the geohash is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> Geohash edges are straight lines and aren't geodesics. If the geohash polygon is part of some other calculation, consider densifying it with [geo_polygon_densify()](geo-polygon-densify-function.md).",'```\r\nprint GeohashPolygon = geo_geohash_to_polygon("dr5ru");\r\n```\r\n\r\n|GeohashPolygon|\r\n|---|\r\n|{<br>"type": "Polygon",<br>"coordinates": [<br>[[-74.00390625, 40.7373046875], [-73.9599609375, 40.7373046875], [-73.9599609375, 40.78125], [-74.00390625, 40.78125], [-74.00390625, 40.7373046875]]]<br>}|\r\n\r\nThe following example assembles GeoJSON geometry collection of geohash polygons.\r\n\r\n```\r\n// Geohash GeoJSON collection\r\ndatatable(lng:real, lat:real)\r\n[\r\n    -73.975212, 40.789608,\r\n    -73.916869, 40.818314,\r\n    -73.989148, 40.743273,\r\n]\r\n| project geohash = geo_point_to_geohash(lng, lat, 5)\r\n| project geohash_polygon = geo_geohash_to_polygon(geohash)\r\n| summarize geohash_polygon_lst = make_list(geohash_polygon)\r\n| project pack(\r\n    "type", "Feature",\r\n    "geometry", pack("type", "GeometryCollection", "geometries", geohash_polygon_lst),\r\n    "properties", pack("name", "Geohash polygons collection"))\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|{<br>"type": "Feature",<br>"geometry": {"type": "GeometryCollection","geometries": [<br>{"type": "Polygon", "coordinates": [[[-74.00390625, 40.78125], [-73.9599609375, 40.78125], [-73.9599609375, 40.8251953125],[ -74.00390625, 40.8251953125], [ -74.00390625, 40.78125]]]},<br>{"type": "Polygon", "coordinates": [[[ -73.9599609375, 40.78125], [-73.916015625, 40.78125], [-73.916015625, 40.8251953125], [-73.9599609375, 40.8251953125], [-73.9599609375, 40.78125]]]},<br>{"type": "Polygon", "coordinates": [[[-74.00390625, 40.7373046875], [-73.9599609375, 40.7373046875], [-73.9599609375, 40.78125], [-74.00390625, 40.78125], [-74.00390625, 40.7373046875]]]}]<br>},<br>"properties": {"name": "Geohash polygons collection"<br>}}|\r\n\r\nThe following example returns a null result because of the invalid geohash input.\r\n\r\n```\r\nprint GeohashPolygon = geo_geohash_to_polygon("a");\r\n```\r\n\r\n|GeohashPolygon|\r\n|---|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-geohash-to-polygon-function","geo-geohash-to-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_children","Calculates the H3 cell children.","Read more about [H3 Cell](https://eng.uber.com/h3/).\r\n\r\n## Syntax\r\n\r\n`geo_h3cell_children(`*h3cell*`, `*resolution*`)`\r\n\r\n## Arguments\r\n\r\n* *h3cell*: H3 Cell token string value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).\r\n* *resolution*: An optional `int` that defines the requested children cells resolution. Supported values are in the range [1, 15]. If unspecified, an immediate children tokens will be calculated.\r\n\r\n## Returns\r\n\r\nArray of H3 Cell children tokens. If the H3 Cell is invalid or child resolution is lower than given cell, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n>\r\n> A difference between cell resolution and its children can't be more than 5. A difference of 5 levels will be resulted in up to 16807 children tokens.",'```\r\nprint children = geo_h3cell_children(\'862a1072fffffff\')\r\n```\r\n\r\n|children|\r\n|---|\r\n|[ "872a10728ffffff", "872a10729ffffff", "872a1072affffff", "872a1072bffffff", "872a1072cffffff", "872a1072dffffff", "872a1072effffff" ]|\r\n\r\nThe following example counts children 3 levels below a given cell.\r\n\r\n```\r\nlet h3_cell = \'862a1072fffffff\'; \r\nprint children_count = array_length(geo_h3cell_children(h3_cell, geo_h3cell_level(h3_cell) + 3))\r\n```\r\n\r\n|children_count|\r\n|---|\r\n|343|\r\n\r\nThe following example assembles GeoJSON geometry collection of H3 Cell children polygons.\r\n\r\n```\r\nprint children = geo_h3cell_children(\'862a1072fffffff\')\r\n| mv-expand children to typeof(string)\r\n| project child = geo_h3cell_to_polygon(children)\r\n| summarize h3_hash_polygon_lst = make_list(child)\r\n| project geojson = pack(\r\n    "type", "Feature",\r\n    "geometry", pack("type", "GeometryCollection", "geometries", h3_hash_polygon_lst),\r\n    "properties", pack("name", "H3 polygons collection"))\r\n```\r\n\r\n|geojson|\r\n|---|\r\n|{ "type": "Feature", "geometry": { "type": "GeometryCollection", "geometries": [ ... ... ... ] }, "properties": { "name": "H3 polygons collection" }}|\r\n\r\nThe following example returns true because of the invalid cell.\r\n\r\n```\r\nprint is_null = isnull(geo_h3cell_children(\'abc\'))\r\n```\r\n\r\n|is_null|\r\n|---|\r\n|1|\r\n\r\nThe following example returns true because the level difference between cell and its children is more than 5.\r\n\r\n```\r\nprint is_null = isnull(geo_h3cell_children(geo_point_to_h3cell(1, 1, 9), 15))\r\n```\r\n\r\n|is_null|\r\n|---|\r\n|1|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-children-function","geo-h3cell-children-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_level","Calculates the H3 cell resolution.","Read more about [H3 Cell](https://eng.uber.com/h3/).\r\n\r\n## Syntax\r\n\r\n`geo_h3cell_level(`*h3cell*`)`\r\n\r\n## Arguments\r\n\r\n*h3cell*: H3 Cell token string value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).\r\n\r\n## Returns\r\n\r\nAn Integer that represents H3 Cell level. Valid level is in range [0, 15]. If the H3 Cell is invalid, the query will produce a null result.","```\r\nprint cell_res = geo_h3cell_level('862a1072fffffff')\r\n```\r\n\r\n|cell_res|\r\n|---|\r\n|6|\r\n\r\n```\r\nprint cell_res = geo_h3cell_level(geo_point_to_h3cell(1,1,10))\r\n```\r\n\r\n|cell_res|\r\n|---|\r\n|10|\r\n\r\nThe following example returns true because of the invalid H3 Cell token input.\r\n\r\n```\r\nprint invalid_res = isnull(geo_h3cell_level('abc'))\r\n```\r\n\r\n|invalid_res|\r\n|---|\r\n|1|","https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-level-function","geo-h3cell-level-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_parent","Calculates the H3 cell parent.","Read more about [H3 Cell](https://eng.uber.com/h3/).\r\n\r\n## Syntax\r\n\r\n`geo_h3cell_parent(`*h3cell*`, `*resolution*`)`\r\n\r\n## Arguments\r\n\r\n* *h3cell*: H3 Cell token string value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).\r\n* *resolution*: An optional `int` that defines the requested parent cell resolution. Supported values are in the range [0, 14]. If unspecified, an immediate parent will be calculated.\r\n\r\n## Returns\r\n\r\nH3 Cell parent token `string`. If the H3 Cell is invalid or parent resolution is higher than given cell, the query will produce an empty result.","```\r\nprint parent_cell = geo_h3cell_parent('862a1072fffffff')\r\n```\r\n\r\n|parent_cell|\r\n|---|\r\n|852a1073fffffff|\r\n\r\nThe following calculates cell parent at level 1.\r\n\r\n```\r\nprint parent_cell = geo_h3cell_parent('862a1072fffffff', 1)\r\n```\r\n\r\n|parent_cell|\r\n|---|\r\n|812a3ffffffffff|\r\n\r\n```\r\nprint parent_res = geo_h3cell_level(geo_h3cell_parent((geo_point_to_h3cell(1,1,10))))\r\n```\r\n\r\n|parent_res|\r\n|---|\r\n|9|\r\n\r\n```\r\nprint parent_res = geo_h3cell_level(geo_h3cell_parent(geo_point_to_h3cell(1,1,10), 3))\r\n```\r\n\r\n|parent_res|\r\n|---|\r\n|3|\r\n\r\nThe following example produces an empty result because of the invalid cell input.\r\n\r\n```\r\nprint invalid = isempty(geo_h3cell_parent('123'))\r\n```\r\n\r\n|invalid|\r\n|---|\r\n|1|\r\n\r\nThe following example produces an empty result because of the invalid parent resolution.\r\n\r\n```\r\nprint invalid = isempty(geo_h3cell_parent('862a1072fffffff', 100))\r\n```\r\n\r\n|invalid|\r\n|---|\r\n|1|\r\n\r\nThe following example produces an empty result because parent can't be of a higher resolution than child.\r\n\r\n```\r\nprint invalid = isempty(geo_h3cell_parent('862a1072fffffff', 15))\r\n```\r\n\r\n|invalid|\r\n|---|\r\n|1|","https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-parent-function","geo-h3cell-parent-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_rings","Calculates the H3 cell Rings.","Read more about [H3 Cell](https://eng.uber.com/h3/).\r\n\r\n## Syntax\r\n\r\n`geo_h3cell_rings(`*h3cell*`, `*distance*`)`\r\n\r\n## Arguments\r\n\r\n* *h3cell*: H3 Cell token string value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).\r\n* *distance*: An `int` that defines the maximum ring distance from given cell. Valid distance is in range [0, 142].\r\n\r\n## Returns\r\n\r\nAn ordered array of ring arrays where 1st ring contains the original cell, 2nd ring contains neighboring cells, and so on. If either the H3 Cell or distance is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n>\r\n> A cell might be not present in the ring if pentagonal distortion was encountered.",'The following example produces rings up to distance 2.\r\n\r\n```\r\nprint rings = geo_h3cell_rings(\'861f8894fffffff\', 2)\r\n```\r\n\r\n|rings|\r\n|---|\r\n|[<br> ["861f8894fffffff"],<br> ["861f88947ffffff","861f8895fffffff","861f88867ffffff","861f8d497ffffff","861f8d4b7ffffff","861f8896fffffff"],<br> ["861f88967ffffff","861f88977ffffff","861f88957ffffff","861f8882fffffff","861f88877ffffff","861f88847ffffff","861f8886fffffff","861f8d49fffffff","861f8d487ffffff","861f8d4a7ffffff","861f8d59fffffff","861f8d597ffffff"]<br> ]|\r\n\r\nThe following example produces all cells at level 1 (all neighbors).\r\n\r\n```\r\nprint neighbors = geo_h3cell_rings(\'861f8894fffffff\', 1)[1]\r\n```\r\n\r\n|neighbors|\r\n|---|\r\n|["861f88947ffffff", "861f8895fffffff", "861f88867ffffff", "861f8d497ffffff", "861f8d4b7ffffff","861f8896fffffff"]|\r\n\r\nThe following example produces list of cells from all rings.\r\n\r\n```\r\nprint rings = geo_h3cell_rings(\'861f8894fffffff\', 1)\r\n| mv-apply rings on \r\n(\r\n  summarize cells = make_list(rings)\r\n)\r\n```\r\n\r\n|cells|\r\n|---|\r\n|["861f8894fffffff","861f88947ffffff","861f8895fffffff","861f88867ffffff","861f8d497ffffff","861f8d4b7ffffff","861f8896fffffff"]|\r\n\r\nThe following example assembles GeoJSON geometry collection of all cells.\r\n\r\n```\r\nprint rings = geo_h3cell_rings(\'861f8894fffffff\', 1)\r\n| mv-apply rings on \r\n(\r\n  summarize make_list(rings)\r\n)\r\n| mv-expand list_rings to typeof(string)\r\n| project polygon = geo_h3cell_to_polygon(list_rings)\r\n| summarize polygon_lst = make_list(polygon)\r\n| project geojson = pack(\r\n    "type", "Feature",\r\n    "geometry", pack("type", "GeometryCollection", "geometries", polygon_lst),\r\n    "properties", pack("name", "H3 polygons collection"))\r\n```\r\n\r\n|geojson|\r\n|---|\r\n|{ "type": "Feature", "geometry": { "type": "GeometryCollection", "geometries": [ ... ... ... ]}, "properties": { "name": "H3 polygons collection" }}|\r\n\r\nThe following example returns true because of the invalid cell.\r\n\r\n```\r\nprint is_null = isnull(geo_h3cell_rings(\'abc\', 3))\r\n```\r\n\r\n|is_null|\r\n|---|\r\n|1|\r\n\r\nThe following example returns true because of the invalid distance.\r\n\r\n```\r\nprint is_null = isnull(geo_h3cell_rings(\'861f8894fffffff\', 150))\r\n```\r\n\r\n|is_null|\r\n|---|\r\n|1|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-rings-function","geo-h3cell-rings-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_to_central_point","Calculates the geospatial coordinates that represent the center of an H3 Cell.","Read more about [H3 Cell](https://eng.uber.com/h3/).\r\n\r\n## Syntax\r\n\r\n`geo_h3cell_to_central_point(`*h3cell*`)`\r\n\r\n## Arguments\r\n\r\n*h3cell*: H3 cell token string value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).\r\n\r\n## Returns\r\n\r\nThe geospatial coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the H3 cell token is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> The GeoJSON format specifies longitude first and latitude second.",'```\r\nprint h3cell = geo_h3cell_to_central_point("862a1072fffffff")\r\n```\r\n\r\n|h3cell|\r\n|---|\r\n|{<br>"type": "Point",<br>"coordinates": [-74.016008479792447, 40.7041679083504]<br>}|\r\n\r\nThe following example returns the longitude of the H3 Cell center point:\r\n\r\n```\r\nprint longitude = geo_h3cell_to_central_point("862a1072fffffff").coordinates[0]\r\n```\r\n\r\n|longitude|\r\n|---|\r\n|-74.0160084797924|\r\n\r\nThe following example returns a null result because of the invalid H3 cell token input.\r\n\r\n```\r\nprint h3cell = geo_h3cell_to_central_point("1")\r\n```\r\n\r\n|h3cell|\r\n|---|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-to-central-point-function","geo-h3cell-to-central-point-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_h3cell_to_polygon","Calculates the polygon that represents the H3 Cell rectangular area.","Read more about [H3 Cell](https://eng.uber.com/h3/).\r\n\r\n## Syntax\r\n\r\n`geo_h3cell_to_polygon(`*h3cell*`)`\r\n\r\n## Arguments\r\n\r\n*h3cell*: H3 Cell token string value as it was calculated by [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).\r\n\r\n## Returns\r\n\r\nPolygon in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the H3 Cell is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> H3 Cell polygon edges are straight lines and aren't geodesics. If an H3 Cell polygon is part of some other calculation, consider densifying it with [geo_polygon_densify()](geo-polygon-densify-function.md).",'```\r\nprint geo_h3cell_to_polygon("862a1072fffffff")\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|{<br>"type": "Polygon",<br>"coordinates": [[[-74.0022744646159, 40.735376026215022], [-74.046908029686236, 40.727986222489115], [-74.060610712223664, 40.696775140349033],[  -74.029724408156682, 40.672970047595463], [-73.985140983708192, 40.680349049267583],[  -73.971393761028622, 40.71154393543933], [-74.0022744646159, 40.735376026215022]]]<br>}|\r\n\r\nThe following example assembles GeoJSON geometry collection of H3 Cell polygons.\r\n\r\n```\r\n// H3 cell GeoJSON collection\r\ndatatable(lng:real, lat:real)\r\n[\r\n    -73.956683, 40.807907,\r\n    -73.916869, 40.818314,\r\n    -73.989148, 40.743273,\r\n]\r\n| project h3_hash = geo_point_to_h3cell(lng, lat, 6)\r\n| project h3_hash_polygon = geo_h3cell_to_polygon(h3_hash)\r\n| summarize h3_hash_polygon_lst = make_list(h3_hash_polygon)\r\n| project pack(\r\n    "type", "Feature",\r\n    "geometry", pack("type", "GeometryCollection", "geometries", h3_hash_polygon_lst),\r\n    "properties", pack("name", "H3 polygons collection"))\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|{<br>"type": "Feature",<br>"geometry": {"type": "GeometryCollection", "geometries": [{"type": "Polygon","coordinates": [[[-73.9609635556213, 40.829061732419916], [-74.005691351383675, 40.821680937801922], [-74.019448383546617, 40.790439140236963], [-73.988522328408948, 40.766594382212254], [-73.943844904976629, 40.773964402038523], [-73.930043202964953, 40.805189944379514], [-73.9609635556213, 40.829061732419916] ]]},<br>{"type": "Polygon", "coordinates": [[[-73.902385078754875, 40.867671551513595], [-73.94715685019348, 40.860310688399885], [-73.9609635556213, 40.829061732419916], [-73.930043202964953, 40.805189944379514], [-73.885321931061725, 40.812540084842404 ], [-73.871470551071766, 40.843772725733125], [ -73.902385078754875, 40.867671551513595]]]},<br>{"type": "Polygon","coordinates": [[[-73.943844904976629, 40.773964402038523], [-73.988522328408948, 40.766594382212254], [-74.0022744646159, 40.735376026215022], [-73.971393761028622, 40.71154393543933], [-73.926766604813565, 40.718903205013063], [ -73.912969923470314, 40.750105305345329 ], [-73.943844904976629, 40.773964402038523]]]}]<br>},<br>"properties": {"name": "H3 polygons collection"}<br>}|\r\n\r\nThe following example returns a null result because of the invalid H3 Cell token input.\r\n\r\n```\r\nprint geo_h3cell_to_polygon("@")\r\n```\r\n\r\n|print_0|\r\n|---|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-h3cell-to-polygon-function","geo-h3cell-to-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_intersects_2lines","Calculates whether the two lines or multilines intersects.",'## Syntax\r\n\r\n`geo_intersects_2lines(`*lineString1*`, `*lineString2*`)`\r\n\r\n## Arguments\r\n\r\n* *lineString1*: Line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n* *lineString2*: Line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nIndicates whether the two lines or multilines intersects. If lineString or a multiLineString are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r\n\r\n**LineString definition and constraints**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* Coordinates [longitude,latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r\n* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n\r\n> [!TIP]\r\n> * Using literal LineString or a MultiLineString may result in better performance.','The following example checks whether some two literal lines intersects.\r\n\r\n```\r\nlet lineString1 = dynamic({"type":"LineString","coordinates":[[-73.978929,40.785155],[-73.980903,40.782621]]});\r\nlet lineString2 = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275],[-73.974552,40.779761]]});\r\nprint intersects = geo_intersects_2lines(lineString1, lineString2)\r\n```\r\n\r\n|intersects|\r\n|---|\r\n|True|\r\n\r\nThe following example finds all roads in NYC GeoJSON roads table which intersects with some line of interest.\r\n\r\n```\r\nlet my_road = dynamic({"type":"LineString","coordinates":[[-73.97892951965332,40.78515573551921],[-73.98090362548828,40.78262115769851]]});\r\nNY_Manhattan_Roads\r\n| project name = features.properties.Label, road = features.geometry\r\n| where geo_intersects_2lines(road, my_road)\r\n| project name\r\n```\r\n\r\n|name|\r\n|---|\r\n|Broadway|\r\n|W 78th St|\r\n|W 79th St|\r\n|W 80th St|\r\n|W 81st St|\r\n\r\nThe following example will return a null result because one of lines is invalid.\r\n\r\n```\r\nlet lineString1 = dynamic({"type":"LineString","coordinates":[[-73.978929,40.785155],[-73.980903,40.782621]]});\r\nlet lineString2 = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275]]});\r\nprint isnull(geo_intersects_2lines(lineString1, lineString2))\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-intersects-2lines-function","geo-intersects-2lines-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_intersects_2polygons","Calculates whether the two polygons or multipolygons intersects.",'## Syntax\r\n\r\n`geo_intersects_2polygons(`*polygon1*`, `*polygon1*`)`\r\n\r\n## Arguments\r\n\r\n* *polygon1*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n* *polygon2*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nIndicates whether the two polygons or a multipolygons intersects. If Polygon or a MultiPolygon are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r\n\r\n**Polygon definition and constraints**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r\n* Polygon doesn\'t necessarily contain its vertices.\r\n\r\n> [!TIP]\r\n> * Using literal Polygon or a MultiPolygon may result in better performance.','The following example checks whether some two literal polygons intersects.\r\n\r\n```\r\nlet polygon1 = dynamic({"type":"Polygon","coordinates":[[[-73.9630937576294,40.77498840732385],[-73.963565826416,40.774383111780914],[-73.96205306053162,40.773745311181585],[-73.96160781383514,40.7743912365898],[-73.9630937576294,40.77498840732385]]]});\r\nlet polygon2 = dynamic({"type":"Polygon","coordinates":[[[-73.96213352680206,40.775045280447145],[-73.9631313085556,40.774578106920345],[-73.96207988262177,40.77416780398293],[-73.96213352680206,40.775045280447145]]]});\r\nprint geo_intersects_2polygons(polygon1, polygon2)\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|True|\r\n\r\nThe following example finds all counties in USA which intersect with area of interest literal polygon.\r\n\r\n```\r\nlet area_of_interest = dynamic({"type":"Polygon","coordinates":[[[-73.96213352680206,40.775045280447145],[-73.9631313085556,40.774578106920345],[-73.96207988262177,40.77416780398293],[-73.96213352680206,40.775045280447145]]]});\r\nUS_Counties\r\n| project name = features.properties.NAME, county = features.geometry\r\n| where geo_intersects_2polygons(county, area_of_interest)\r\n| project name\r\n```\r\n\r\n|name|\r\n|---|\r\n|New York|\r\n\r\nThe following example will return a null result because one of the polygons is invalid.\r\n\r\n```\r\nlet central_park_polygon = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r\nlet invalid_polygon = dynamic({"type":"Polygon"});\r\nprint isnull(geo_intersects_2polygons(invalid_polygon, central_park_polygon))\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-intersects-2polygons-function","geo-intersects-2polygons-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_intersects_line_with_polygon","Calculates whether the lines or multiline intersects with polygon or a multipolygon.",'## Syntax\r\n\r\n`geo_intersects_line_with_polygon(`*lineString*`, `*polygon*`)`\r\n\r\n## Arguments\r\n\r\n* *lineString*: LineString or MultiLineString in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n* *polygon*: Polygon or MultiPolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nIndicates whether the line or multiline intersects with polygon or a multipolygon. If lineString or a multiLineString or a polygon or a multipolygon are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input line or a polygon edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) or a [geo_polygon_densify()](geo-polygon-densify-function.md) in order to convert planar edges to geodesics.\r\n\r\n**LineString definition and constraints**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* Coordinates [longitude,latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r\n* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n\r\n**Polygon definition and constraints**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r\n* Polygon doesn\'t necessarily contain its vertices.\r\n\r\n> [!TIP]\r\n> * Using literal LineString or a MultiLineString or a Polygon or a MultiPolygon may result in better performance.','The following example checks whether a literal LineString intersects with Polygon.\r\n\r\n```\r\nlet lineString = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275],[-73.974552,40.779761]]});\r\nlet polygon = dynamic({"type":"Polygon","coordinates":[[[-73.9712905883789,40.78580561168767],[-73.98004531860352,40.775276834803655],[-73.97000312805176,40.77852663535664],[-73.9712905883789,40.78580561168767]]]});\r\nprint intersects = geo_intersects_line_with_polygon(lineString, polygon)\r\n```\r\n\r\n|intersects|\r\n|---|\r\n|True|\r\n\r\nThe following example finds all roads in NYC GeoJSON roads table which intersects with area of interest literal polygon.\r\n\r\n```\r\nlet area_of_interest = dynamic({"type":"Polygon","coordinates":[[[-73.95768642425537,40.80065354924362],[-73.9582872390747,40.80089719667298],[-73.95869493484497,40.80050736035672],[-73.9580512046814,40.80019873831593],[-73.95768642425537,40.80065354924362]]]});\r\nNY_Manhattan_Roads\r\n| project name = features.properties.Label, road = features.geometry\r\n| where geo_intersects_line_with_polygon(road, area_of_interest)\r\n| project name\r\n```\r\n\r\n|name|\r\n|---|\r\n|Central Park W|\r\n|Frederick Douglass Cir|\r\n|W 110th St|\r\n|West Dr|\r\n\r\nThe following example finds all counties in USA which intersect with area of interest literal LineString.\r\n\r\n```\r\nlet area_of_interest = dynamic({"type":"LineString","coordinates":[[-73.97159099578857,40.794513338780895],[-73.96738529205322,40.792758888618756],[-73.96978855133057,40.789769718601505]]});\r\nUS_Counties\r\n| project name = features.properties.NAME, county = features.geometry\r\n| where geo_intersects_line_with_polygon(area_of_interest, county)\r\n| project name\r\n```\r\n\r\n|name|\r\n|---|\r\n|New York|\r\n\r\nThe following example will return a null result because the LineString is invalid.\r\n\r\n```\r\nlet lineString = dynamic({"type":"LineString","coordinates":[[-73.985195,40.788275]]});\r\nlet polygon = dynamic({"type":"Polygon","coordinates":[[[-73.95768642425537,40.80065354924362],[-73.9582872390747,40.80089719667298],[-73.95869493484497,40.80050736035672],[-73.9580512046814,40.80019873831593],[-73.95768642425537,40.80065354924362]]]});\r\nprint isnull(geo_intersects_2lines(lineString, polygon))\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|True|\r\n\r\nThe following example will return a null result because the polygon is invalid.\r\n\r\n```\r\nlet lineString = dynamic({"type":"LineString","coordinates":[[-73.97159099578857,40.794513338780895],[-73.96738529205322,40.792758888618756],[-73.96978855133057,40.789769718601505]]});\r\nlet polygon = dynamic({"type":"Polygon","coordinates":[]});\r\nprint isnull(geo_intersects_2lines(lineString, polygon))\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-intersects-line-with-polygon-function","geo-intersects-line-with-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_centroid","Calculates the centroid of line or a multiline on Earth.",'## Syntax\r\n\r\n`geo_line_centroid(`*lineString*`)`\r\n\r\n## Arguments\r\n\r\n* *lineString*: Line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nThe centroid coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If line or multiline are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r\n> * If input is a multiline and contains more than one line, the result will be the centroid of lines union.\r\n\r\n**LineString definition and constraints**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* Coordinates [longitude,latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r\n* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.','The following example calculates line centroid.\r\n\r\n```\r\nlet line = dynamic({"type":"LineString","coordinates":[[-73.95796, 40.80042], [-73.97317, 40.764486]]});\r\nprint centroid = geo_line_centroid(line);\r\n```\r\n\r\n|centroid|\r\n|---|\r\n|{"type": "Point", "coordinates": [-73.965567057230942, 40.782453249627416]}|\r\n\r\nThe following example calculates line centroid longitude.\r\n\r\n```\r\nlet line = dynamic({"type":"LineString","coordinates":[[-73.95807266235352,40.800426144169315],[-73.94966125488281,40.79691751000055],[-73.97317886352539,40.764486356930334],[-73.98210525512695,40.76786669510221],[-73.96004676818848,40.7980870753293]]});\r\nprint centroid = geo_line_centroid(line)\r\n| project lng = centroid.coordinates[0]\r\n```\r\n\r\n|lng|\r\n|---|\r\n|-73.9660675626837|\r\n\r\nThe following example visualizes line centroid on a map.\r\n\r\n```\r\nlet line = dynamic({"type":"MultiLineString","coordinates":[[[-73.95798683166502,40.800556090021466],[-73.98193359375,40.76819171855746]],[[-73.94940376281738,40.79691751000055],[-73.97317886352539,40.76435634049001]]]});\r\nprint centroid = geo_line_centroid(line)\r\n| render scatterchart with (kind = map)\r\n```\r\n\r\n![Screenshot of N Y C Central park line centroid.](images/geo-line-centroid-function/nyc-central-park-centroid.png)\r\nThe following example returns True because of the invalid line.\r\n\r\n```\r\nprint is_bad_line = isnull(geo_line_centroid(dynamic({"type":"LineString","coordinates":[[1, 1]]})))\r\n```\r\n\r\n|is_bad_line|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-line-centroid-function","geo-line-centroid-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_densify","Converts planar line or multiline edges to geodesics by adding intermediate points.",'## Syntax\r\n\r\n`geo_line_densify(`*lineString*`, `*tolerance*`)`\r\n\r\n## Arguments\r\n\r\n* *lineString*: Line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n* *tolerance*: An optional numeric that defines maximum distance in meters between the original planar edge and the converted geodesic edge chain. Supported values are in the range [0.1, 10000]. If unspecified, the default value `10` is used.\r\n\r\n## Returns\r\n\r\nDensified line in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If either the line or tolerance is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n\r\n**LineString definition**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* The coordinates [longitude,latitude] must be valid. The longitude must be a real number in the range [-180, +180] and the latitude must be a real number in the range [-90, +90].\r\n* The edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n\r\n**Constraints**\r\n\r\n* The maximum number of points in the densified line is limited to 10485760.\r\n* Storing lines in [dynamic](./scalar-data-types/dynamic.md) format has size limits.\r\n\r\n**Motivation**\r\n\r\n* [GeoJSON format](https://tools.ietf.org/html/rfc7946) defines an edge between two points as a straight cartesian line.\r\n* The decision to use geodesic or planar edges might depend on the dataset and is especially relevant in long edges.','The following example densifies a road in Manhattan island. The edge is short and the distance between the planar edge and its geodesic counterpart is less than the distance specified by tolerance. As such, the result remains unchanged.\r\n\r\n```\r\nprint densified_line = tostring(geo_line_densify(dynamic({"type":"LineString","coordinates":[[-73.949247, 40.796860],[-73.973017, 40.764323]]})))\r\n```\r\n\r\n|densified_line|\r\n|---|\r\n|{"type":"LineString","coordinates":[[-73.949247, 40.796860], [-73.973017, 40.764323]]}|\r\n\r\nThe following example densifies an edge of ~130km length\r\n\r\n```\r\nprint densified_line = tostring(geo_line_densify(dynamic({"type":"LineString","coordinates":[[50, 50], [51, 51]]})))\r\n```\r\n\r\n|densified_line|\r\n|---|\r\n|{"type":"LineString","coordinates":[[50,50],[50.125,50.125],[50.25,50.25],[50.375,50.375],[50.5,50.5],[50.625,50.625],[50.75,50.75],[50.875,50.875],[51,51]]}|\r\n\r\nThe following example returns a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint densified_line = geo_line_densify(dynamic({"type":"LineString","coordinates":[[300,1],[1,1]]}))\r\n```\r\n\r\n|densified_line|\r\n|---|\r\n||\r\n\r\nThe following example returns a null result because of the invalid tolerance input.\r\n\r\n```\r\nprint densified_line = geo_line_densify(dynamic({"type":"LineString","coordinates":[[1,1],[2,2]]}), 0)\r\n```\r\n\r\n|densified_line|\r\n|---|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-line-densify-function","geo-line-densify-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_length","Calculates the total length of line or a multiline on Earth.",'## Syntax\r\n\r\n`geo_line_length(`*lineString*`)`\r\n\r\n## Arguments\r\n\r\n* *lineString*: Line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nThe total length of a line or a multiline, in meters, on Earth. If line or multiline are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r\n> * If input is a multiline and contains more than one line, the result will be total length of lines union.\r\n\r\n**LineString definition and constraints**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* Coordinates [longitude,latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r\n* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.','The following example calculates total line length, in meters.\r\n\r\n```\r\nlet line = dynamic({"type":"LineString","coordinates":[[-73.95807266235352,40.800426144169315],[-73.94966125488281,40.79691751000055],[-73.97317886352539,40.764486356930334]]});\r\nprint length = geo_line_length(line)\r\n```\r\n\r\n|length|\r\n|---|\r\n|4922.48016992081|\r\n\r\nThe following example calculates total multiline length, in meters.\r\n\r\n```\r\nlet line = dynamic({"type":"MultiLineString","coordinates":[[[-73.95798683166502,40.800556090021466],[-73.98193359375,40.76819171855746]],[[-73.94940376281738,40.79691751000055],[-73.97317886352539,40.76435634049001]]]});\r\nprint length = geo_line_length(line)\r\n```\r\n\r\n|length|\r\n|---|\r\n|8262.24339753741|\r\n\r\nThe following example returns True because of the invalid line.\r\n\r\n```\r\nprint is_bad_line = isnull(geo_line_length(dynamic({"type":"LineString","coordinates":[[1, 1]]})))\r\n```\r\n\r\n|is_bad_line|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-line-length-function","geo-line-length-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_line_simplify","Simplifies line or a multiline by replacing nearly straight chains of short edges with a single long edge on Earth.",'## Syntax\r\n\r\n`geo_line_simplify(`*lineString*`, `*tolerance*`)`\r\n\r\n## Arguments\r\n\r\n* *lineString*: Line or multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n* *tolerance*: An optional numeric that defines minimum distance in meters between any two vertices. Supported values are in the range [0, ~7,800,000 meters). If unspecified, the default value `10` is used.\r\n\r\n## Returns\r\n\r\nSimplified line or a multiline in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type, with no two vertices with distance less than tolerance. If either the line or tolerance is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere. Line edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r\n> * If input is a multiline and contains more than one line, the result will be simplification of lines union.\r\n> * High tolerance may cause small line to disappear.\r\n\r\n**LineString definition and constraints**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* Coordinates [longitude,latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r\n* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.','The following example simplifies line by removing vertices that are within 10 meters distance from each other.\r\n\r\n```\r\nlet line = dynamic({"type":"LineString","coordinates":[[-73.97033169865608,40.789063020152824],[-73.97039607167244,40.78897975920816],[-73.9704617857933,40.78888837512432],[-73.97052884101868,40.7887949601531],[-73.9706052839756,40.788698498903564],[-73.97065222263336,40.78862640672032],[-73.97072866559029,40.78852791445617],[-73.97079303860664,40.788434498977836]]});\r\nprint simplified = geo_line_simplify(line, 10)\r\n```\r\n\r\n|simplified|\r\n|---|\r\n|{"type": "LineString", "coordinates": [[-73.97033169865608, 40.789063020152824], [-73.97079303860664, 40.788434498977836]]}|\r\n\r\nThe following example simplifies lines and combines results into GeoJSON geometry collection.\r\n\r\n```\r\nNY_Manhattan_Roads\r\n| project road = features.geometry\r\n| project road_simplified = geo_line_simplify(road, 100)\r\n| summarize roads_lst = make_list(road_simplified)\r\n| project geojson = pack("type", "Feature","geometry", pack("type", "GeometryCollection", "geometries", roads_lst), "properties", pack("name", "roads"))\r\n```\r\n\r\n|geojson|\r\n|---|\r\n|{"type": "Feature", "geometry": {"type": "GeometryCollection", "geometries": [ ... ]}, "properties": {"name": "roads"}}|\r\n\r\nThe following example simplifies lines and unifies result\r\n\r\n```\r\nNY_Manhattan_Roads\r\n| project road = features.geometry\r\n| project road_simplified = geo_line_simplify(road, 100)\r\n| summarize roads_lst = make_list(road_simplified)\r\n| project roads = geo_union_lines_array(roads_lst)\r\n```\r\n\r\n|roads|\r\n|---|\r\n|{"type": "MultiLineString", "coordinates": [ ... ]}|\r\n\r\nThe following example returns True because of the invalid line.\r\n\r\n```\r\nprint is_invalid_line = isnull(geo_line_simplify(dynamic({"type":"LineString","coordinates":[[1, 1]]})))\r\n```\r\n\r\n|is_invalid_line|\r\n|---|\r\n|True|\r\n\r\nThe following example returns True because of the invalid tolerance.\r\n\r\n```\r\nprint is_invalid_line = isnull(geo_line_simplify(dynamic({"type":"LineString","coordinates":[[1, 1],[2,2]]}), -1))\r\n```\r\n\r\n|is_invalid_line|\r\n|---|\r\n|True|\r\n\r\nThe following example returns True because high tolerance causes small line to disappear.\r\n\r\n```\r\nprint is_invalid_line = isnull(geo_line_simplify(dynamic({"type":"LineString","coordinates":[[1.1, 1.1],[1.2,1.2]]}), 100000))\r\n```\r\n\r\n|is_invalid_line|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-line-simplify-function","geo-line-simplify-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_in_circle","Calculates whether the geospatial coordinates are inside a circle on Earth.","## Syntax\r\n\r\n`geo_point_in_circle(`*p_longitude*`, `*p_latitude*`, `*pc_longitude*`, `*pc_latitude*`, `*c_radius*`)`\r\n\r\n## Arguments\r\n\r\n* *p_longitude*: Geospatial coordinate longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *p_latitude*: Geospatial coordinate latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *pc_longitude*: Circle center geospatial coordinate longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *pc_latitude*: circle center geospatial coordinate latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *c_radius*: Circle radius in meters. Valid value must be positive.\r\n\r\n## Returns\r\n\r\nIndicates whether the geospatial coordinates are inside a circle. If the coordinates or circle is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n>* The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n>* The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used to measure distance on Earth is a sphere.\r\n>* A circle is a spherical cap on Earth. The radius of the cap is measured along the surface of the sphere.","The following query finds all the places in the area defined by the following circle: Radius of 18 km, center at [-122.317404, 47.609119] coordinates.\r\n\r\n![Places near Seattle.](images/geo-point-in-circle-function/circle-seattle.png)\r\n\r\n```\r\ndatatable(longitude:real, latitude:real, place:string)\r\n[\r\n    real(-122.317404), 47.609119, 'Seattle',                   // In circle \r\n    real(-123.497688), 47.458098, 'Olympic National Forest',   // In exterior of circle  \r\n    real(-122.201741), 47.677084, 'Kirkland',                  // In circle\r\n    real(-122.443663), 47.247092, 'Tacoma',                    // In exterior of circle\r\n    real(-122.121975), 47.671345, 'Redmond',                   // In circle\r\n]\r\n| where geo_point_in_circle(longitude, latitude, -122.317404, 47.609119, 18000)\r\n| project place\r\n```\r\n\r\n|place|\r\n|---|\r\n|Seattle|\r\n|Kirkland|\r\n|Redmond|\r\n\r\nStorm events in Orlando. The events are filtered by 100 km within Orlando coordinates, and aggregated by event type and hash.\r\n\r\n![Storm events in Orlando.](images/geo-point-in-circle-function/orlando-storm-events.png)\r\n\r\n```\r\nStormEvents\r\n| project BeginLon, BeginLat, EventType\r\n| where geo_point_in_circle(BeginLon, BeginLat, real(-81.3891), 28.5346, 1000 * 100)\r\n| summarize count() by EventType, hash = geo_point_to_s2cell(BeginLon, BeginLat)\r\n| project geo_s2cell_to_central_point(hash), EventType, count_\r\n| render piechart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example shows NY Taxi pickups within 10 meters of a particular location. Relevant pickups are aggregated by hash.\r\n\r\n![NY Taxi nearby Pickups.](images/geo-point-in-circle-function/circle-junction.png)\r\n\r\n```\r\nnyc_taxi\r\n| project pickup_longitude, pickup_latitude\r\n| where geo_point_in_circle( pickup_longitude, pickup_latitude, real(-73.9928), 40.7429, 10)\r\n| summarize by hash = geo_point_to_s2cell(pickup_longitude, pickup_latitude, 22)\r\n| project geo_s2cell_to_central_point(hash)\r\n| render scatterchart with (kind = map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example will return true.\r\n\r\n```\r\nprint in_circle = geo_point_in_circle(-122.143564, 47.535677, -122.100896, 47.527351, 3500)\r\n```\r\n\r\n|in_circle|\r\n|---|\r\n|1|\r\n\r\nThe following example will return false.\r\n\r\n```\r\nprint in_circle = geo_point_in_circle(-122.137575, 47.630683, -122.100896, 47.527351, 3500)\r\n```\r\n\r\n|in_circle|\r\n|---|\r\n|0|\r\n\r\nThe following example will return a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint in_circle = geo_point_in_circle(200, 1, 1, 1, 1)\r\n```\r\n\r\n|in_circle|\r\n|---|\r\n||\r\n\r\nThe following example will return a  null result because of the invalid circle radius input.\r\n\r\n```\r\nprint in_circle = geo_point_in_circle(1, 1, 1, 1, -1)\r\n```\r\n\r\n|in_circle|\r\n|---|\r\n||","https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-in-circle-function","geo-point-in-circle-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_in_polygon","Calculates whether the geospatial coordinates are inside a polygon or a multipolygon on Earth.",'## Syntax\r\n\r\n`geo_point_in_polygon(`*longitude*`, `*latitude*`, `*polygon*`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Geospatial coordinate, longitude value in degrees. Valid value is a real number and in the range [-180, +180].\r\n* *latitude*: Geospatial coordinate, latitude value in degrees. Valid value is a real number and in the range [-90, +90].\r\n* *polygon*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nIndicates whether the geospatial coordinates are inside a polygon. If the coordinates or polygon is invalid, the query will produce a null result. \r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r\n\r\n**Polygon definition and constraints**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n* LinearRings must not cross and must not share edges. LinearRings may share vertices.\r\n* Polygon doesn\'t necessarily contain its vertices. Point containment in polygon is defined so that if the Earth is subdivided into polygons, every point is contained by exactly one polygon.\r\n\r\n> [!TIP]\r\n> * Using literal Polygon or a MultiPolygon may result in better performance.\r\n> * If you want to know if any of the polygons contains a point, try the following steps: Fold the collection of polygons into one multipolygon. Then query this multipolygon. This may improve performance. See the example below.','Manhattan island without Central Park.\r\n\r\n![Screenshot of a map of the Manhattan area, with markers for a landmark, a museum, and an airport. The island appears dimmed except for Central Park.](images/geo-point-in-polygon-function/polygon-manhattan-with-hole.png)\r\n\r\n```\r\ndatatable(longitude:real, latitude:real, description:string)\r\n[\r\n    real(-73.985654), 40.748487, \'Empire State Building\',           // In Polygon \r\n    real(-73.963249), 40.779525, \'The Metropolitan Museum of Art\',  // In exterior of polygon\r\n    real(-73.874367), 40.777356, \'LaGuardia Airport\',               // In exterior of polygon\r\n]\r\n| where geo_point_in_polygon(longitude, latitude, dynamic({"type":"Polygon","coordinates":[[[-73.92597198486328,40.87821814104651],[-73.94691467285156,40.85069618625578],[-73.94691467285156,40.841865966890786],[-74.01008605957031,40.7519385984599],[-74.01866912841797,40.704586878965245],[-74.01214599609375,40.699901911003046],[-73.99772644042969,40.70875101828792],[-73.97747039794922,40.71083299030839],[-73.97026062011719,40.7290474687069],[-73.97506713867186,40.734510840309376],[-73.970947265625,40.74543623770158],[-73.94210815429688,40.77586181063573],[-73.9434814453125,40.78080140115127],[-73.92974853515625,40.79691751000055],[-73.93077850341797,40.804454347291006],[-73.93489837646484,40.80965166748853],[-73.93524169921875,40.837190668541105],[-73.92288208007812,40.85770758108904],[-73.9101791381836,40.871728144624974],[-73.92597198486328,40.87821814104651]],[[-73.95824432373047,40.80071852197889],[-73.98206233978271,40.76815921628347],[-73.97309303283691,40.76422632379533],[-73.94914627075195,40.796949998204596],[-73.95824432373047,40.80071852197889]]]}))\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.985654|40.748487|Empire State Building|\r\n\r\nSearch for coordinates in multipolygon.\r\n\r\n![Screenshot of a map of the Manhattan area, with markers for the Upper West Side, Greenwich Village, and an airport. Three neighborhoods appear dimmed.](images/geo-point-in-polygon-function/multipolygon-manhattan.png)\r\n\r\n```\r\nlet multipolygon = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]],[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]],[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]]});\r\nlet coordinates = \r\n    datatable(longitude:real, latitude:real, description:string)\r\n    [\r\n        real(-73.9741), 40.7914, \'Upper West Side\',    // In MultiPolygon\r\n        real(-73.9950), 40.7340, \'Greenwich Village\',  // In MultiPolygon\r\n        real(-73.8743), 40.7773, \'LaGuardia Airport\',  // In exterior of MultiPolygon\r\n    ];\r\ncoordinates\r\n| where geo_point_in_polygon(longitude, latitude, multipolygon)\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.9741|40.7914|Upper West Side|\r\n|-73.995|40.734|Greenwich Village|\r\n\r\nStorm events in California. The events are filtered by a California state polygon and aggregated by event type and hash.\r\n\r\n![Storm events in California.](images/geo-point-in-polygon-function/california-storm-events.png)\r\n\r\n```\r\nlet california = dynamic({"type":"Polygon","coordinates":[[[-123.233256,42.006186],[-122.378853,42.011663],[-121.037003,41.995232],[-120.001861,41.995232],[-119.996384,40.264519],[-120.001861,38.999346],[-118.71478,38.101128],[-117.498899,37.21934],[-116.540435,36.501861],[-115.85034,35.970598],[-114.634459,35.00118],[-114.634459,34.87521],[-114.470151,34.710902],[-114.333228,34.448009],[-114.136058,34.305608],[-114.256551,34.174162],[-114.415382,34.108438],[-114.535874,33.933176],[-114.497536,33.697668],[-114.524921,33.54979],[-114.727567,33.40739],[-114.661844,33.034958],[-114.524921,33.029481],[-114.470151,32.843265],[-114.524921,32.755634],[-114.72209,32.717295],[-116.04751,32.624187],[-117.126467,32.536556],[-117.24696,32.668003],[-117.252437,32.876127],[-117.329114,33.122589],[-117.471515,33.297851],[-117.7837,33.538836],[-118.183517,33.763391],[-118.260194,33.703145],[-118.413548,33.741483],[-118.391641,33.840068],[-118.566903,34.042715],[-118.802411,33.998899],[-119.218659,34.146777],[-119.278905,34.26727],[-119.558229,34.415147],[-119.875891,34.40967],[-120.138784,34.475393],[-120.472878,34.448009],[-120.64814,34.579455],[-120.609801,34.858779],[-120.670048,34.902595],[-120.631709,35.099764],[-120.894602,35.247642],[-120.905556,35.450289],[-121.004141,35.461243],[-121.168449,35.636505],[-121.283465,35.674843],[-121.332757,35.784382],[-121.716143,36.195153],[-121.896882,36.315645],[-121.935221,36.638785],[-121.858544,36.6114],[-121.787344,36.803093],[-121.929744,36.978355],[-122.105006,36.956447],[-122.335038,37.115279],[-122.417192,37.241248],[-122.400761,37.361741],[-122.515777,37.520572],[-122.515777,37.783465],[-122.329561,37.783465],[-122.406238,38.15042],[-122.488392,38.112082],[-122.504823,37.931343],[-122.701993,37.893004],[-122.937501,38.029928],[-122.97584,38.265436],[-123.129194,38.451652],[-123.331841,38.566668],[-123.44138,38.698114],[-123.737134,38.95553],[-123.687842,39.032208],[-123.824765,39.366301],[-123.764519,39.552517],[-123.85215,39.831841],[-124.109566,40.105688],[-124.361506,40.259042],[-124.410798,40.439781],[-124.158859,40.877937],[-124.109566,41.025814],[-124.158859,41.14083],[-124.065751,41.442061],[-124.147905,41.715908],[-124.257444,41.781632],[-124.213628,42.000709],[-123.233256,42.006186]]]});\r\nStormEvents\r\n| project BeginLon, BeginLat, EventType\r\n| where geo_point_in_polygon(BeginLon, BeginLat, california)\r\n| summarize count() by EventType, hash = geo_point_to_s2cell(BeginLon, BeginLat, 7)\r\n| project geo_s2cell_to_central_point(hash), EventType, count_\r\n| render piechart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\nThe following example shows how to classify coordinates to polygons using the [partition](./partitionoperator.md) operator.\r\n\r\n```\r\nlet Polygons = datatable(description:string, polygon:dynamic)\r\n    [  \r\n      "New York city area", dynamic({"type":"Polygon","coordinates":[[[-73.85009765625,40.85744791303121],[-74.16046142578125,40.84290487729676],[-74.190673828125,40.59935608796518],[-73.83087158203125,40.61812224225511],[-73.85009765625,40.85744791303121]]]}),\r\n      "Seattle area",       dynamic({"type":"Polygon","coordinates":[[[-122.200927734375,47.68573021131587],[-122.4591064453125,47.68573021131587],[-122.4755859375,47.468949677672484],[-122.17620849609374,47.47266286861342],[-122.200927734375,47.68573021131587]]]}),\r\n      "Las Vegas",          dynamic({"type":"Polygon","coordinates":[[[-114.9,36.36],[-115.4498291015625,36.33282808737917],[-115.4498291015625,35.84453450421662],[-114.949951171875,35.902399875143615],[-114.9,36.36]]]}),\r\n    ];\r\nlet Locations = datatable(longitude:real, latitude:real)\r\n    [\r\n      real(-73.95),  real(40.75), // Somewhere in New York\r\n      real(-122.3),  real(47.6),  // Somewhere in Seattle\r\n      real(-115.18), real(36.16)  // Somewhere in Las Vegas\r\n    ];\r\nPolygons\r\n| project polygonPartition = tostring(pack("description", description, "polygon", polygon))\r\n| partition hint.materialized=true by polygonPartition\r\n{   \r\n     Locations\r\n     | extend description = todynamic(toscalar(polygonPartition)).description\r\n     | extend polygon = todynamic(toscalar(polygonPartition)).polygon\r\n     | where geo_point_in_polygon(longitude, latitude, polygon)\r\n     | project-away polygon\r\n}\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.95|40.75|New York city area|\r\n|-122.3|47.6|Seattle area|\r\n|-115.18|36.16|Las Vegas|\r\n\r\nSee also [geo_polygon_to_s2cells()](geo-polygon-to-s2cells-function.md).\r\n\r\nFolding several polygons into one multipolygon and querying it.\r\n\r\n```\r\nlet Polygons = \r\n    datatable(polygon:dynamic)\r\n    [\r\n        dynamic({"type":"Polygon","coordinates":[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]]}),\r\n        dynamic({"type":"Polygon","coordinates":[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]]}),\r\n        dynamic({"type":"Polygon","coordinates":[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]}),\r\n    ];\r\nlet Coordinates = \r\n    datatable(longitude:real, latitude:real, description:string)\r\n    [\r\n        real(-73.9741), 40.7914, \'Upper West Side\',\r\n        real(-73.9950), 40.7340, \'Greenwich Village\',\r\n        real(-73.8743), 40.7773, \'LaGuardia Airport\',\r\n    ];\r\nlet multipolygon = toscalar(\r\n    Polygons\r\n    | project individual_polygon = pack_array(polygon.coordinates)\r\n    | summarize multipolygon_coordinates = make_list(individual_polygon)\r\n    | project multipolygon = pack("type","MultiPolygon", "coordinates", multipolygon_coordinates));\r\nCoordinates\r\n| where geo_point_in_polygon(longitude, latitude, multipolygon)\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.9741|40.7914|Upper West Side|\r\n|-73.995|40.734|Greenwich Village|\r\n\r\nThe following example will return a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint in_polygon = geo_point_in_polygon(200,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,1],[0,0]]]}))\r\n```\r\n\r\n| in_polygon |\r\n|------------|\r\n|            |\r\n\r\nThe following example will return a null result because of the invalid polygon input.\r\n\r\n```\r\nprint in_polygon = geo_point_in_polygon(1,1,dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]}))\r\n```\r\n\r\n| in_polygon |\r\n|------------|\r\n|            |',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-in-polygon-function","geo-point-in-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_to_geohash","Calculates the geohash string value for a geographic location.","Read more about [geohash](https://en.wikipedia.org/wiki/Geohash).  \r\n\r\n## Syntax\r\n\r\n`geo_point_to_geohash(`*longitude*`, `*latitude*`, `[*accuracy*]`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Longitude value of a geographic location. Longitude x will be considered valid if x is a real number and is in the range [-180, +180]. \r\n* *latitude*: Latitude value of a geographic location. Latitude y will be considered valid if y is a real number and y is in the range [-90, +90]. \r\n* *accuracy*: An optional `int` that defines the requested accuracy. Supported values are in the range [1,18]. If unspecified, the default value `5` is used.\r\n\r\n## Returns\r\n\r\nThe geohash string value of a given geographic location with requested accuracy length. If the coordinate or accuracy is invalid, the query will produce an empty result.\r\n\r\n> [!NOTE]\r\n>\r\n> * Geohash can be a useful geospatial clustering tool.\r\n> * Geohash has 18 accuracy levels with area coverage ranging from 25 Million km\u00b2 at the highest level 1 to 0.6 \u03bc\u00b2 at the lowest level 18.\r\n> * Common prefixes of geohash indicate proximity of points to each other. The longer a shared prefix is, the closer the two places are. Accuracy value translates to geohash length.\r\n> * Geohash is a rectangular area on a plane surface.\r\n> * Invoking the [geo_geohash_to_central_point()](geo-geohash-to-central-point-function.md) function on a geohash string that was calculated on longitude x and latitude y won't necessarily return x and y.\r\n> * Due to the geohash definition, it's possible that two geographic locations are very close to each other but have different geohash codes.\r\n\r\n**Geohash rectangular area coverage per accuracy value:**\r\n\r\n| Accuracy | Width     | Height    |\r\n|----------|-----------|-----------|\r\n| 1        | 5000 km   | 5000 km   |\r\n| 2        | 1250 km   | 625 km    |\r\n| 3        | 156.25 km | 156.25 km |\r\n| 4        | 39.06 km  | 19.53 km  |\r\n| 5        | 4.88 km   | 4.88 km   |\r\n| 6        | 1.22 km   | 0.61 km   |\r\n| 7        | 152.59 m  | 152.59 m  |\r\n| 8        | 38.15 m   | 19.07 m   |\r\n| 9        | 4.77 m    | 4.77 m    |\r\n| 10       | 1.19 m    | 0.59 m    |\r\n| 11       | 149.01 mm | 149.01 mm |\r\n| 12       | 37.25 mm  | 18.63 mm  |\r\n| 13       | 4.66 mm   | 4.66 mm   |\r\n| 14       | 1.16 mm   | 0.58 mm   |\r\n| 15       | 145.52 \u03bc  | 145.52 \u03bc  |\r\n| 16       | 36.28 \u03bc   | 18.19 \u03bc   |\r\n| 17       | 4.55 \u03bc    | 4.55 \u03bc    |\r\n| 18       | 1.14 \u03bc    | 0.57 \u03bc    |\r\n\r\nSee also [geo_point_to_s2cell()](geo-point-to-s2cell-function.md), [geo_point_to_h3cell()](geo-point-to-h3cell-function.md).\r\n\r\nFor comparison with other available grid systems, see [geospatial clustering with Kusto Query Language](geospatial-grid-systems.md).",'US storm events aggregated by geohash.\r\n\r\n![US geohash.](images/geo-point-to-geohash-function/geohash.png)\r\n\r\n```\r\nStormEvents\r\n| project BeginLon, BeginLat\r\n| summarize by hash=geo_point_to_geohash(BeginLon, BeginLat, 3)\r\n| project geo_geohash_to_central_point(hash)\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\n```\r\nprint geohash = geo_point_to_geohash(139.806115, 35.554128, 12)  \r\n```\r\n\r\n| geohash      |\r\n|--------------|\r\n| xn76m27ty9g4 |\r\n\r\n```\r\nprint geohash = geo_point_to_geohash(-80.195829, 25.802215, 8)\r\n```\r\n\r\n|geohash|\r\n|---|\r\n|dhwfz15h|\r\n\r\nThe following example finds groups of coordinates. Every pair of coordinates in the group resides in a rectangular area of 4.88 km by 4.88 km.\r\n\r\n```\r\ndatatable(location_id:string, longitude:real, latitude:real)\r\n[\r\n  "A", double(-122.303404), 47.570482,\r\n  "B", double(-122.304745), 47.567052,\r\n  "C", double(-122.278156), 47.566936,\r\n]\r\n| summarize count = count(),                                          // items per group count\r\n            locations = make_list(location_id)                        // items in the group\r\n            by geohash = geo_point_to_geohash(longitude, latitude)    // geohash of the group\r\n```\r\n\r\n| geohash | count | locations  |\r\n|---------|-------|------------|\r\n| c23n8   | 2     | ["A", "B"] |\r\n| c23n9   | 1     | ["C"]      |\r\n\r\nThe following example produces an empty result because of the invalid coordinate input.\r\n\r\n```\r\nprint geohash = geo_point_to_geohash(200,1,8)\r\n```\r\n\r\n| geohash |\r\n|---------|\r\n|         |\r\n\r\nThe following example produces an empty result because of the invalid accuracy input.\r\n\r\n```\r\nprint geohash = geo_point_to_geohash(1,1,int(null))\r\n```\r\n\r\n| geohash |\r\n|---------|\r\n|         |',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-to-geohash-function","geo-point-to-geohash-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_to_h3cell","Calculates the H3 Cell token string value for a geographic location.","Read more about [H3 Cell](https://eng.uber.com/h3/).\r\n\r\n## Syntax\r\n\r\n`geo_point_to_h3cell(`*longitude*`, `*latitude*`, `*resolution*`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Longitude value of a geographic location. Longitude *x* will be considered valid if *x* is a real number and *x* is in the range [-180, +180].\r\n* *latitude*: Latitude value of a geographic location. Latitude *y* will be considered valid if y is a real number and y in the range [-90, +90].\r\n* *resolution*: An optional `int` that defines the requested cell resolution. Supported values are in the range [0, 15]. If unspecified, the default value `6` is used.\r\n\r\n## Returns\r\n\r\nThe H3 Cell token string value of a given geographic location. If the coordinates or levels are invalid, the query will produce an empty result.\r\n\r\n> [!NOTE]\r\n>\r\n> * H3 Cell can be a useful geospatial clustering tool.\r\n> * H3 Cell has 16 levels of hierarchy with area coverage ranging from 4,250,547km\u00b2 at the highest level 0 to 0.9m\u00b2 at the lowest level 15.\r\n> * H3 Cell has a unique hexagon shape and this leads some unique properties:\r\n>   - Hexagons have 6 neighbors\r\n>   - Hexagons allow us to approximate radiuses easily and all neighbors are equidistant\r\n>   - Hexagons are visually pleasant to look at\r\n> * In some rare cases the shape is pentagon.\r\n> * H3 Cell has a rectangular area on a plane surface.\r\n> * Invoking the [geo_h3cell_to_central_point()](geo-h3cell-to-central-point-function.md) function on an H3 Cell token string that was calculated on longitude x and latitude y won't necessarily return x and y.\r\n> * It's possible that two geographic locations are very close to each other but have different H3 Cell tokens.\r\n\r\n**H3 Cell approximate area coverage per resolution value**\r\n\r\n|Level|Average Hexagon Edge Length|\r\n|--|--|\r\n|0|1108 km|\r\n|1|419 km|\r\n|2|158 km|\r\n|3|60 km|\r\n|4|23 km|\r\n|5|8 km|\r\n|6|3 km|\r\n|7|1 km|\r\n|8|460 m|\r\n|9|174 m|\r\n|10|66 m|\r\n|11|25 m|\r\n|12|9 m|\r\n|13|3 m|\r\n|14|1 m|\r\n|15|0.5 m|\r\n\r\nThe table source can be found [in this H3 Cell statistical resource](https://h3geo.org/docs/core-library/restable/).\r\n\r\nSee also [geo_point_to_s2cell()](geo-point-to-s2cell-function.md), [geo_point_to_geohash()](geo-point-to-geohash-function.md).\r\n\r\nFor comparison with other available grid systems. see [geospatial clustering with Kusto Query Language](geospatial-grid-systems.md).",'```\r\nprint h3cell = geo_point_to_h3cell(-74.04450446039874, 40.689250859314974, 6)\r\n```\r\n\r\n|h3cell|\r\n|---|\r\n|862a1072fffffff|\r\n\r\nThe following example finds groups of coordinates. Every pair of coordinates in the group resides in the H3 Cell with average hexagon area of 253 km\u00b2.\r\n\r\n```\r\ndatatable(location_id:string, longitude:real, latitude:real)\r\n[\r\n    "A", -73.956683, 40.807907,\r\n    "B", -73.916869, 40.818314,\r\n    "C", -73.989148, 40.743273,\r\n]\r\n| summarize count = count(),                                         // Items per group count\r\n            locations = make_list(location_id)                       // Items in the group\r\n            by h3cell = geo_point_to_h3cell(longitude, latitude, 5)  // H3 Cell of the group\r\n```\r\n\r\n|h3cell|count|locations|\r\n|---|---|---|\r\n|852a100bfffffff|2|[<br>  "A",<br>  "B"<br>]|\r\n|852a1073fffffff|1|[<br>  "C"<br>]|\r\n\r\nThe following example produces an empty result because of the invalid coordinate input.\r\n\r\n```\r\nprint h3cell = geo_point_to_h3cell(300,1,8)\r\n```\r\n\r\n|h3cell|\r\n|---|\r\n||\r\n\r\nThe following example produces an empty result because of the invalid level input.\r\n\r\n```\r\nprint h3cell = geo_point_to_h3cell(1,1,16)\r\n```\r\n\r\n|h3cell|\r\n|---|\r\n||\r\n\r\nThe following example produces an empty result because of the invalid level input.\r\n\r\n```\r\nprint h3cell = geo_point_to_h3cell(1,1,int(null))\r\n```\r\n\r\n|h3cell|\r\n|---|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-to-h3cell-function","geo-point-to-h3cell-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_point_to_s2cell","Calculates the S2 cell token string value for a geographic location.","S2 Cell can be a useful geospatial clustering tool. The S2 Cell is a cell on a spherical surface and its edges are geodesics. S2 Cell has 31 levels of hierarchy with area coverage ranging from 85,011,012.19km\u00b2 at the highest level of 0 to 0.44cm\u00b2 at the lowest level of 30. S2 Cell preserves the cell center well during level increase from 0 to 30. Two geographic locations can be very close to each other but have different S2 cell tokens.\r\n\r\n>[!NOTE]\r\n> If you invoke the [geo_s2cell_to_central_point()](geo-s2cell-to-central-point-function.md) function on an S2 cell token string that was calculated on longitude x and latitude y, the function won't necessarily return x and y.\r\n\r\nRead more about [S2 cell hierarchy](https://s2geometry.io/devguide/s2cell_hierarchy).\r\n\r\n## Syntax\r\n\r\n`geo_point_to_s2cell(`*longitude*`, `*latitude*`, `*level*`)`\r\n\r\n## Arguments\r\n\r\n* *longitude*: Longitude value of a geographic location. Longitude *x* will be considered valid if *x* is a real number and *x* is in the range [-180, +180]. \r\n* *latitude*: Latitude value of a geographic location. Latitude y will be considered valid if y is a real number and y in the range [-90, +90]. \r\n* *level*: An optional `int` that defines the requested cell level. Supported values are in the range [0, 30]. If unspecified, the default value `11` is used.\r\n\r\n## Returns\r\n\r\nThe S2 cell token string value of a given geographic location. If the coordinates or levels are invalid, the query will produce an empty result.\r\n\r\n## S2 Cell approximate area coverage per level value\r\n\r\nFor every level, the size of the S2 Cell is similar but not exactly equal. Nearby cell sizes tend to be more equal.\r\n\r\n|Level|Minimum random cell edge length (UK)|Maximum random cell edge length (US)|\r\n|--|--|--|\r\n|0|7842 km|7842 km|\r\n|1|3921 km|5004 km|\r\n|2|1825 km|2489 km|\r\n|3|840 km|1310 km|\r\n|4|432 km|636 km|\r\n|5|210 km|315 km|\r\n|6|108 km|156 km|\r\n|7|54 km|78 km|\r\n|8|27 km|39 km|\r\n|9|14 km|20 km|\r\n|10|7 km|10 km|\r\n|11|3 km|5 km|\r\n|12|1699 m|2 km|\r\n|13|850 m|1225 m|\r\n|14|425 m|613 m|\r\n|15|212 m|306 m|\r\n|16|106 m|153 m|\r\n|17|53 m|77 m|\r\n|18|27 m|38 m|\r\n|19|13 m|19 m|\r\n|20|7 m|10 m|\r\n|21|3 m|5 m|\r\n|22|166 cm|2 m|\r\n|23|83 cm|120 cm|\r\n|24|41 cm|60 cm|\r\n|25|21 cm|30 cm|\r\n|26|10 cm|15 cm|\r\n|27|5 cm|7 cm|\r\n|28|2 cm|4 cm|\r\n|29|12 mm|18 mm|\r\n|30|6 mm|9 mm|\r\n\r\nThe table source can be found [in this S2 Cell statistical resource](https://s2geometry.io/resources/s2cell_statistics).\r\n\r\nFor comparison with other available grid systems, see [geospatial clustering with Kusto Query Language](geospatial-grid-systems.md).",'### US storm events aggregated by S2 Cell.\r\n\r\n![US s2cell.](images/geo-point-to-s2cell-function/s2cell.png)\r\n\r\n```\r\nStormEvents\r\n| project BeginLon, BeginLat\r\n| summarize by hash=geo_point_to_s2cell(BeginLon, BeginLat, 5)\r\n| project geo_s2cell_to_central_point(hash)\r\n| render scatterchart with (kind=map) // map rendering available in Kusto Explorer desktop\r\n```\r\n\r\n```\r\nprint s2cell = geo_point_to_s2cell(-80.195829, 25.802215, 8)\r\n```\r\n\r\n| s2cell |\r\n|--------|\r\n| 88d9b  |\r\n\r\n### Find a group of coordinates\r\n\r\nThe following example finds groups of coordinates. Every pair of coordinates in the group resides in the S2 cell with a maximum area of 1632.45 km\u00b2.\r\n\r\n```\r\ndatatable(location_id:string, longitude:real, latitude:real)\r\n[\r\n  "A", 10.1234, 53,\r\n  "B", 10.3579, 53,\r\n  "C", 10.6842, 53,\r\n]\r\n| summarize count = count(),                                        // items per group count\r\n            locations = make_list(location_id)                      // items in the group\r\n            by s2cell = geo_point_to_s2cell(longitude, latitude, 8) // s2 cell of the group\r\n```\r\n\r\n| s2cell | count | locations |\r\n|--------|-------|-----------|\r\n| 47b1d  | 2     | ["A","B"] |\r\n| 47ae3  | 1     | ["C"]     |\r\n\r\n### Empty results\r\n\r\nThe following example produces an empty result because of the invalid coordinate input.\r\n\r\n```\r\nprint s2cell = geo_point_to_s2cell(300,1,8)\r\n```\r\n\r\n| s2cell |\r\n|--------|\r\n|        |\r\n\r\nThe following example produces an empty result because of the invalid level input.\r\n\r\n```\r\nprint s2cell = geo_point_to_s2cell(1,1,35)\r\n```\r\n\r\n| s2cell |\r\n|--------|\r\n|        |\r\n\r\nThe following example produces an empty result because of the invalid level input.\r\n\r\n```\r\nprint s2cell = geo_point_to_s2cell(1,1,int(null))\r\n```\r\n\r\n| s2cell |\r\n|--------|\r\n|        |\r\n\r\n## See also\r\n\r\n* [geo_point_to_geohash()](geo-point-to-geohash-function.md)\r\n* [geo_point_to_h3cell()](geo-point-to-h3cell-function.md)',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-point-to-s2cell-function","geo-point-to-s2cell-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_area","Calculates the area of polygon or a multipolygon on Earth.",'## Syntax\r\n\r\n`geo_polygon_area(`*polygon*`)`\r\n\r\n## Arguments\r\n\r\n* *polygon*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nThe area of a polygon or a multipolygon, in square meters, on Earth. If polygon or multipolygon are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r\n> * If input is a multipolygon and contains more than one polygon, the result will be the area of polygons union.\r\n\r\n**Polygon definition and constraints**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n* LinearRings must not cross and must not share edges. LinearRings may share vertices.','The following example calculates NYC Central Park area.\r\n\r\n```\r\nlet central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r\nprint area = geo_polygon_area(central_park)\r\n```\r\n\r\n|area|\r\n|---|\r\n|3475207.28346606|\r\n\r\nThe following example performs union of polygons in multipolygon and calculates area on the unified polygon.\r\n\r\n```\r\nlet polygons = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]],[[[-73.94262313842773,40.775991804565585],[-73.98107528686523,40.791849155467695],[-73.99600982666016,40.77092185281977],[-73.96150588989258,40.75609977566361],[-73.94262313842773,40.775991804565585]]]]});\r\nprint polygons_union_area = geo_polygon_area(polygons)\r\n```\r\n\r\n|polygons_union_area|\r\n|---|\r\n|10889971.5343487|\r\n\r\nThe following example calculates top 5 biggest US states by area.\r\n\r\n```\r\nUS_States\r\n| project name = features.properties.NAME, polygon = geo_polygon_densify(features.geometry)\r\n| project name, area = geo_polygon_area(polygon)\r\n| top 5 by area desc\r\n```\r\n\r\n|name|area|\r\n|---|---|\r\n|Alaska|1550934810070.61|\r\n|Texas|693231378868.483|\r\n|California|410339536449.521|\r\n|Montana|379583933973.436|\r\n|New Mexico|314979912310.579|\r\n\r\nThe following example returns True because of the invalid polygon.\r\n\r\n```\r\nprint isnull(geo_polygon_area(dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]})))\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-area-function","geo-polygon-area-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_centroid","Calculates the centroid of polygon or a multipolygon on Earth.",'## Syntax\r\n\r\n`geo_polygon_centroid(`*polygon*`)`\r\n\r\n## Arguments\r\n\r\n* *polygon*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nThe centroid coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If polygon or multipolygon are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r\n> * If input is a multipolygon and contains more than one polygon, the result will be the centroid of polygons union.\r\n\r\n**Polygon definition and constraints**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n* LinearRings must not cross and must not share edges. LinearRings may share vertices.','The following example calculates NYC Central Park centroid.\r\n\r\n```\r\nlet central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r\nprint centroid = geo_polygon_centroid(central_park)\r\n```\r\n\r\n|centroid|\r\n|---|\r\n|{"type": "Point", "coordinates": [-73.965735689907618, 40.782550538057812]}|\r\n\r\nThe following example calculates NYC Central Park centroid longitude.\r\n\r\n```\r\nlet central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r\nprint \r\ncentroid = geo_polygon_centroid(central_park)\r\n| project lng = centroid.coordinates[0]\r\n```\r\n\r\n|lng|\r\n|---|\r\n|-73.9657356899076|\r\n\r\nThe following example performs union of polygons in multipolygon and calculates centroid of the unified polygon.\r\n\r\n```\r\nlet polygons = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]],[[[-73.94262313842773,40.775991804565585],[-73.98107528686523,40.791849155467695],[-73.99600982666016,40.77092185281977],[-73.96150588989258,40.75609977566361],[-73.94262313842773,40.775991804565585]]]]});\r\nprint polygons_union_centroid = geo_polygon_centroid(polygons)\r\n```\r\n\r\n|polygons_union_centroid|\r\n|---|\r\n|"type": "Point", "coordinates": [-73.968569587829577, 40.776310752555119]}|\r\n\r\nThe following example visualizes NYC Central Park centroid on a map\r\n\r\n```\r\nlet central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r\nprint \r\ncentroid = geo_polygon_centroid(central_park)\r\n| render scatterchart with (kind = map)\r\n```\r\n\r\n![Screenshot of N Y C Central park centroid.](images/geo-polygon-centroid-function/nyc-central-park-centroid.png)\r\nThe following example returns True because of the invalid polygon.\r\n\r\n```\r\nprint isnull(geo_polygon_centroid(dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]})))\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-centroid-function","geo-polygon-centroid-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_densify","Converts polygon or multipolygon planar edges to geodesics by adding intermediate points.",'## Syntax\r\n\r\n`geo_polygon_densify(`*polygon*`, `*tolerance*`)`\r\n\r\n## Arguments\r\n\r\n* *polygon*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n* *tolerance*: An optional numeric that defines maximum distance in meters between the original planar edge and the converted geodesic edge chain. Supported values are in the range [0.1, 10000]. If unspecified, the default value is  `10`.\r\n\r\n### Polygon definition\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* `LinearRingShell` is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* `LinearRingHole` is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* `LinearRing` vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* `LinearRingShell` encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* `LinearRing` edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n\r\n### Constraints\r\n\r\n* The maximum number of points in the densified polygon is limited to 10485760.\r\n* Storing polygons in [dynamic](./scalar-data-types/dynamic.md) format has size limits.\r\n* Densifying a valid polygon may invalidate the polygon. The algorithm adds points in a non-uniform manner, and as such may cause edges to intertwine with each other.\r\n\r\n### Motivation\r\n\r\n* [GeoJSON format](https://tools.ietf.org/html/rfc7946) defines an edge between two points as a straight cartesian line.\r\n* The decision to use geodesic or planar edges might depend on the dataset and is especially relevant in long edges.\r\n\r\n## Returns\r\n\r\nDensified polygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If either the polygon or tolerance is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The polygon must be correctly defined, but the function does not check polygon validity.','The following example densifies Manhattan Central Park polygon. The edges are short and the distance between planar edges and their geodesic counterparts is less than the distance specified by tolerance. As such, the result remains unchanged.\r\n\r\n```\r\nprint densified_polygon = tostring(geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[-73.958244,40.800719],[-73.949146,40.79695],[-73.973093,40.764226],[-73.982062,40.768159],[-73.958244,40.800719]]]})))\r\n```\r\n\r\n|densified_polygon|\r\n|---|\r\n|{"type":"Polygon","coordinates":[[[-73.958244,40.800719],[-73.949146,40.79695],[-73.973093,40.764226],[-73.982062,40.768159],[-73.958244,40.800719]]]}|\r\n\r\nThe following example densifies two edges of the polygon. Densified edges length is ~110 km\r\n\r\n```\r\nprint densified_polygon = tostring(geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[10,10],[11,10],[11,11],[10,11],[10,10]]]})))\r\n```\r\n\r\n|densified_polygon|\r\n|---|\r\n|{"type":"Polygon","coordinates":[[[10,10],[10.25,10],[10.5,10],[10.75,10],[11,10],[11,11],[10.75,11],[10.5,11],[10.25,11],[10,11],[10,10]]]}|\r\n\r\nThe following example returns a null result because of the invalid coordinate input.\r\n\r\n```\r\nprint densified_polygon = geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[10,900],[11,10],[11,11],[10,11],[10,10]]]}))\r\n```\r\n\r\n|densified_polygon|\r\n|---|\r\n||\r\n\r\nThe following example returns a null result because of the invalid tolerance input.\r\n\r\n```\r\nprint densified_polygon = geo_polygon_densify(dynamic({"type":"Polygon","coordinates":[[[10,10],[11,10],[11,11],[10,11],[10,10]]]}), 0)\r\n```\r\n\r\n|densified_polygon|\r\n|---|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-densify-function","geo-polygon-densify-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_perimeter","Calculates the length of the boundary of polygon or a multipolygon on Earth.",'## Syntax\r\n\r\n`geo_polygon_perimeter(`*polygon*`)`\r\n\r\n## Arguments\r\n\r\n* *polygon*: Polygon or multipolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nThe length of the boundary of polygon or a multipolygon, in meters, on Earth. If polygon or multipolygon are invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r\n> * If input is a multipolygon and contains more than one polygon, the result will be the length of the boundary of polygons union.\r\n\r\n**Polygon definition and constraints**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n* LinearRings must not cross and must not share edges. LinearRings may share vertices.','The following example calculates NYC Central Park perimeter, in meters.\r\n\r\n```\r\nlet central_park = dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]]});\r\nprint perimeter = geo_polygon_perimeter(central_park)\r\n```\r\n\r\n|perimeter|\r\n|---|\r\n|9930.30149604938|\r\n\r\nThe following example performs union of polygons in multipolygon and calculates perimeter of the unified polygon.\r\n\r\n```\r\nlet polygons = dynamic({"type":"MultiPolygon","coordinates":[[[[-73.9495,40.7969],[-73.95807266235352,40.80068603561921],[-73.98201942443848,40.76825672305777],[-73.97317886352539,40.76455136505513],[-73.9495,40.7969]]],[[[-73.94262313842773,40.775991804565585],[-73.98107528686523,40.791849155467695],[-73.99600982666016,40.77092185281977],[-73.96150588989258,40.75609977566361],[-73.94262313842773,40.775991804565585]]]]});\r\nprint perimeter = geo_polygon_perimeter(polygons)\r\n```\r\n\r\n|perimeter|\r\n|---|\r\n|15943.5384578745|\r\n\r\nThe following example returns True because of the invalid polygon.\r\n\r\n```\r\nprint is_invalid = isnull(geo_polygon_perimeter(dynamic({"type": "Polygon","coordinates": [[[0,0],[10,10],[10,10],[0,0]]]})))\r\n```\r\n\r\n|is_invalid|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-perimeter-function","geo-polygon-perimeter-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_polygon_to_s2cells","Calculates S2 cell tokens that cover a polygon or multipolygon on Earth. This function is a useful geospatial join tool.",'Read more about [S2 cell hierarchy](https://s2geometry.io/devguide/s2cell_hierarchy).\r\n\r\n## Syntax\r\n\r\n`geo_polygon_to_s2cells(`*polygon*`, `*level*`)`\r\n\r\n## Arguments\r\n\r\n* *polygon*: Polygon or multiPolygon in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. \r\n* *level*: An optional `int` that defines the requested cell level. Supported values are in the range [0, 30]. If unspecified, the default value `11` is used.\r\n\r\n## Returns\r\n\r\nArray of S2 cell token strings that cover a polygon or multipolygon. If either the polygon or level is invalid, or the cell count exceeds the limit, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n>\r\n> * Covering the polygon with S2 cell tokens can be useful in matching coordinates to polygons that might include these coordinates and matching polygons to polygons.\r\n> * The polygon covering tokens are of the same S2 cell level.\r\n> * The maximum count of tokens per polygon is 65536.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [Geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) in order to convert planar edges to geodesics.\r\n\r\n**Motivation for covering polygons with S2 cell tokens**\r\n\r\nWithout this function, here is one approach we could take in order to classify coordinates into polygons containing these coordinates.\r\n\r\n```\r\nlet Polygons = \r\n    datatable(description:string, polygon:dynamic)\r\n    [  \r\n      "New York",  dynamic({"type":"Polygon","coordinates":[[[-73.85009765625,40.85744791303121],[-74.16046142578125,40.84290487729676],[-74.190673828125,40.59935608796518],[-73.83087158203125,40.61812224225511],[-73.85009765625,40.85744791303121]]]}),\r\n      "Seattle",   dynamic({"type":"Polygon","coordinates":[[[-122.200927734375,47.68573021131587],[-122.4591064453125,47.68573021131587],[-122.4755859375,47.468949677672484],[-122.17620849609374,47.47266286861342],[-122.200927734375,47.68573021131587]]]}),\r\n      "Las Vegas", dynamic({"type":"Polygon","coordinates":[[[-114.9,36.36],[-115.4498291015625,36.33282808737917],[-115.4498291015625,35.84453450421662],[-114.949951171875,35.902399875143615],[-114.9,36.36]]]}),\r\n    ];\r\nlet Coordinates = \r\n    datatable(longitude:real, latitude:real)\r\n    [\r\n      real(-73.95),  real(40.75), // New York\r\n      real(-122.3),  real(47.6),  // Seattle\r\n      real(-115.18), real(36.16)  // Las Vegas\r\n    ];\r\nPolygons | extend dummy=1\r\n| join kind=inner (Coordinates | extend dummy=1) on dummy\r\n| where geo_point_in_polygon(longitude, latitude, polygon)\r\n| project longitude, latitude, description\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.95|40.75|New York city|\r\n|-122.3|47.6|Seattle|\r\n|-115.18|36.16|Las Vegas|\r\n\r\nWhile this method works in some cases, it is inefficient. This method does a cross-join, meaning that it tries to match every polygon to every point. This process consumes a large amount of memory and compute resources.\r\nInstead, we would like to match every polygon to a point with a high probability of containment success, and filter out other points.\r\n\r\nThis match can be achieved by the following process:\r\n\r\n1. Converting polygons to S2 cells of level k,\r\n1. Converting points to the same S2 cells level k, \r\n1. Joining on S2 cells,\r\n1. Filtering by [geo_point_in_polygon()](geo-point-in-polygon-function.md).\r\n\r\n**Choosing the S2 cell level**\r\n\r\n* Ideally we would want to cover every polygon with one or just a few unique cells such that no two polygons share the same cell.\r\n* If the polygons are close to each other, choose the [S2 cell level](geo-point-to-s2cell-function.md) such that its cell edge will be smaller (4, 8, 12 times smaller) than the edge of the average polygon.\r\n* If the polygons are far from each other, choose the [S2 cell level](geo-point-to-s2cell-function.md) such that its cell edge will be similar to the edge of the average polygon.\r\n* In practice, covering a polygon with more than 10000 cells might not yield good performance.\r\n* Sample use cases:\r\n   - S2 cell level 5 might prove to be good for covering countries.\r\n   - S2 cell level 16 can cover dense and relatively small Manhattan (New York) neighborhoods.\r\n   - S2 cell level 11 can be used for covering suburbs of Australia.\r\n* Query run time and memory consumption might differ because of different S2 cell level values.\r\n\r\n> [!WARNING]\r\n> Covering a large-area polygon with small-area cells can lead to a huge amount of covering cells. As a result, the query might return null.','The following example classifies coordinates into polygons.\r\n\r\n```\r\nlet Polygons = \r\n    datatable(description:string, polygon:dynamic)\r\n    [\r\n        \'Greenwich Village\', dynamic({"type":"Polygon","coordinates":[[[-73.991460000000131,40.731738000000206],[-73.992854491775518,40.730082566051351],[-73.996772,40.725432000000154],[-73.997634685522883,40.725786309886963],[-74.002855946639244,40.728346630056791],[-74.001413,40.731065000000207],[-73.996796995070824,40.73736378205173],[-73.991724524037934,40.735245208931886],[-73.990703782359589,40.734781896080477],[-73.991460000000131,40.731738000000206]]]}),\r\n        \'Upper West Side\',   dynamic({"type":"Polygon","coordinates":[[[-73.958357552055688,40.800369095633819],[-73.98143901556422,40.768762584141953],[-73.981548752788598,40.7685590292784],[-73.981565335901905,40.768307084720796],[-73.981754418060945,40.768399727738668],[-73.982038573548124,40.768387823012056],[-73.982268248204349,40.768298621883247],[-73.982384797518051,40.768097213086911],[-73.982320919746599,40.767894461792181],[-73.982155532845766,40.767756204474757],[-73.98238873834039,40.767411004834273],[-73.993650353659021,40.772145571634361],[-73.99415893763998,40.772493009137818],[-73.993831082030937,40.772931787850908],[-73.993891252437052,40.772955194876722],[-73.993962585514595,40.772944653908901],[-73.99401262480508,40.772882846631894],[-73.994122058082397,40.77292405902601],[-73.994136652588594,40.772901870174394],[-73.994301342391154,40.772970028663913],[-73.994281535134448,40.77299380206933],[-73.994376552751078,40.77303955110149],[-73.994294029824005,40.773156243992048],[-73.995023275860802,40.773481196576356],[-73.99508939189289,40.773388475039134],[-73.995013963716758,40.773358035426909],[-73.995050284699261,40.773297153189958],[-73.996240651898916,40.773789791397689],[-73.996195837470992,40.773852356184044],[-73.996098807369748,40.773951805299085],[-73.996179459973888,40.773986954351571],[-73.996095245226442,40.774086186437756],[-73.995572265161172,40.773870731394297],[-73.994017424135961,40.77321375261053],[-73.993935876811335,40.773179512586211],[-73.993861942928888,40.773269531698837],[-73.993822393527211,40.773381758622882],[-73.993767019318497,40.773483981224835],[-73.993698463744295,40.773562141052594],[-73.993358326468751,40.773926888327956],[-73.992622663865575,40.774974056037109],[-73.992577842766124,40.774956016359418],[-73.992527743951555,40.775002110439829],[-73.992469745815342,40.775024159551755],[-73.992403837191887,40.775018140390664],[-73.99226708903538,40.775116033858794],[-73.99217809026365,40.775279293897171],[-73.992059084937338,40.775497598192516],[-73.992125372394938,40.775509075053385],[-73.992226867797001,40.775482211026116],[-73.992329346608813,40.775468900958522],[-73.992361756801131,40.775501899766638],[-73.992386042960277,40.775557180424634],[-73.992087684712729,40.775983970821372],[-73.990927174149746,40.777566878763238],[-73.99039616003671,40.777585065679204],[-73.989461267506471,40.778875124584417],[-73.989175778438053,40.779287524015778],[-73.988868617400072,40.779692922911607],[-73.988871874499793,40.779713738253008],[-73.989219022880576,40.779697895209402],[-73.98927785904425,40.779723439271038],[-73.989409054180143,40.779737706471963],[-73.989498614927044,40.779725044389757],[-73.989596493388234,40.779698146683387],[-73.989679812902509,40.779677568658038],[-73.989752702937935,40.779671244211556],[-73.989842247806507,40.779680752670664],[-73.990040102120489,40.779707677698219],[-73.990137977524839,40.779699769704784],[-73.99033584033225,40.779661794394983],[-73.990430598697046,40.779664973055503],[-73.990622199396725,40.779676064914298],[-73.990745069505479,40.779671328184051],[-73.990872114282197,40.779646007643876],[-73.990961672224358,40.779639683751753],[-73.991057472829539,40.779652352625774],[-73.991157429497036,40.779669775606465],[-73.991242817404469,40.779671367084504],[-73.991255318289745,40.779650782516491],[-73.991294887120119,40.779630209208889],[-73.991321967649895,40.779631796041372],[-73.991359455569423,40.779585883337383],[-73.991551059227476,40.779574821437407],[-73.99141982585985,40.779755280287233],[-73.988886144117032,40.779878898532999],[-73.988939656706265,40.779956178440393],[-73.988926103530844,40.780059292013632],[-73.988911680264692,40.780096037146606],[-73.988919261468567,40.780226094343945],[-73.988381050202634,40.780981074045783],[-73.988232413846987,40.781233144215555],[-73.988210420831663,40.781225482542055],[-73.988140000000143,40.781409000000224],[-73.988041288067166,40.781585961353777],[-73.98810029382463,40.781602878305286],[-73.988076449145055,40.781650935001608],[-73.988018059972219,40.781634188810422],[-73.987960792842145,40.781770987031535],[-73.985465811970457,40.785360700575431],[-73.986172704965611,40.786068452258647],[-73.986455862401996,40.785919219081421],[-73.987072345615601,40.785189638820121],[-73.98711901394276,40.785210319004058],[-73.986497781023601,40.785951202887254],[-73.986164628806279,40.786121882448327],[-73.986128422486075,40.786239001331111],[-73.986071135219746,40.786240706026611],[-73.986027274789123,40.786228964236727],[-73.986097637849426,40.78605822569795],[-73.985429321269592,40.785413942184597],[-73.985081137732209,40.785921935110366],[-73.985198833254501,40.785966552197777],[-73.985170502389906,40.78601333415817],[-73.985216218673656,40.786030501816427],[-73.98525509797993,40.785976205511588],[-73.98524273937646,40.785972572653328],[-73.98524962933017,40.785963139855845],[-73.985281779186749,40.785978620950075],[-73.985240032884533,40.786035858136792],[-73.985683885242182,40.786222123919686],[-73.985717529004575,40.786175994668795],[-73.985765660297687,40.786196274858618],[-73.985682871922691,40.786309786213067],[-73.985636270930442,40.786290150649279],[-73.985670722564691,40.786242911993817],[-73.98520511880038,40.786047669212785],[-73.985211035607492,40.786039554883686],[-73.985162639946992,40.786020999769754],[-73.985131636312062,40.786060297019972],[-73.985016964065125,40.78601423719563],[-73.984655078830457,40.786534741807841],[-73.985743787901043,40.786570082854738],[-73.98589227228328,40.786426529019593],[-73.985942854994988,40.786452847880334],[-73.985949561556794,40.78648711396653],[-73.985812373526713,40.786616865357047],[-73.985135209703174,40.78658761889551],[-73.984619428584324,40.786586016349787],[-73.981952458164173,40.790393724337193],[-73.972823037363767,40.803428052816756],[-73.971036786332192,40.805918478839672],[-73.966701,40.804169000000186],[-73.959647,40.801156000000113],[-73.958508540159471,40.800682279767472],[-73.95853274080838,40.800491362464697],[-73.958357552055688,40.800369095633819]]]}),\r\n        \'Upper East Side\',   dynamic({"type":"Polygon","coordinates":[[[-73.943592454622546,40.782747908206574],[-73.943648235390199,40.782656161333449],[-73.943870759887162,40.781273026571704],[-73.94345932494096,40.780048275653243],[-73.943213862652243,40.779317588660199],[-73.943004239504688,40.779639495474292],[-73.942716005450905,40.779544169476175],[-73.942712374762181,40.779214856940001],[-73.942535563208608,40.779090956062532],[-73.942893408188027,40.778614093246276],[-73.942438481745029,40.777315235766039],[-73.942244919522594,40.777104088947254],[-73.942074188038887,40.776917846977142],[-73.942002667222781,40.776185317382648],[-73.942620205199006,40.775180871576474],[-73.94285645694552,40.774796600349191],[-73.94293043781397,40.774676268036011],[-73.945870899588215,40.771692257932997],[-73.946618690150586,40.77093339256956],[-73.948664164778933,40.768857624399587],[-73.950069793030679,40.767025088383498],[-73.954418260786071,40.762184104951245],[-73.95650786241211,40.760285256574043],[-73.958787773424007,40.758213471309809],[-73.973015157270069,40.764278692864671],[-73.955760332998182,40.787906554459667],[-73.944023,40.782960000000301],[-73.943592454622546,40.782747908206574]]]}),\r\n    ];\r\nlet Coordinates = \r\n    datatable(longitude:real, latitude:real)\r\n    [\r\n        real(-73.9741), 40.7914, // Upper West Side\r\n        real(-73.9950), 40.7340, // Greenwich Village\r\n        real(-73.9584), 40.7688, // Upper East Side\r\n    ];\r\nlet Level = 16;\r\nPolygons\r\n| extend covering = geo_polygon_to_s2cells(polygon, Level) // cover every polygon with s2 cell token array\r\n| mv-expand covering to typeof(string)                     // expand cells array such that every row will have one cell mapped to its polygon\r\n| join kind=inner hint.strategy=broadcast                  // assume that Polygons count is small (In some specific case)\r\n(\r\n    Coordinates\r\n    | extend covering = geo_point_to_s2cell(longitude, latitude, Level) // cover point with cell\r\n) on covering // join on the cell, this filters out rows of point and polygons where the point definitely does not belong to the polygon\r\n| where geo_point_in_polygon(longitude, latitude, polygon)\r\n| project longitude, latitude, description\r\n```\r\n\r\n|longitude|latitude|description|\r\n|---|---|---|\r\n|-73.9741|40.7914|Upper West Side|\r\n|-73.995|40.734|Greenwich Village|\r\n|-73.9584|40.7688|Upper East Side|\r\n\r\nThe following example filters out polygons that don\'t intersect with the area of the polygon of interest. The maximum error is diagonal of s2cell length. This example is based on a polygonized earth at night raster file.\r\n\r\n```\r\nlet intersection_level_hint = 7;\r\nlet area_of_interest = dynamic({"type": "Polygon","coordinates": [[[-73.94966125488281,40.79698248639272],[-73.95841598510742,40.800426144169315],[-73.98124694824219,40.76806170936614],[-73.97283554077148,40.7645513650551],[-73.94966125488281,40.79698248639272]]]});\r\nlet area_of_interest_covering = geo_polygon_to_s2cells(area_of_interest, intersection_level_hint);\r\nEarthAtNight\r\n| project value = features.properties.DN, polygon = features.geometry\r\n| extend covering = geo_polygon_to_s2cells(polygon, intersection_level_hint)\r\n| mv-apply c = covering to typeof(string) on\r\n(\r\n    summarize is_intersects = anyif(1, array_index_of(area_of_interest_covering, c) != -1)\r\n)\r\n| where is_intersects == 1\r\n| count\r\n```\r\n\r\n|Count|\r\n|---|\r\n|83|\r\n\r\nCount of cells that will be needed in order to cover some polygon with S2 cells of level 5.\r\n\r\n```\r\nlet polygon = dynamic({"type":"Polygon","coordinates":[[[0,0],[0,50],[100,50],[0,0]]]});\r\nprint s2_cell_token_count = array_length(geo_polygon_to_s2cells(polygon, 5));\r\n```\r\n\r\n|s2_cell_token_count|\r\n|---|\r\n|286|\r\n\r\nCovering a large-area polygon with small-area cells returns null.\r\n\r\n```\r\nlet polygon = dynamic({"type":"Polygon","coordinates":[[[0,0],[0,50],[100,50],[0,0]]]});\r\nprint geo_polygon_to_s2cells(polygon, 30);\r\n```\r\n\r\n|print_0|\r\n|---|\r\n||\r\n\r\nCovering a large-area polygon with small-area cells returns null.\r\n\r\n```\r\nlet polygon = dynamic({"type":"Polygon","coordinates":[[[0,0],[0,50],[100,50],[0,0]]]});\r\nprint isnull(geo_polygon_to_s2cells(polygon, 30));\r\n```\r\n\r\n|print_0|\r\n|---|\r\n|1|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-polygon-to-s2cells-function","geo-polygon-to-s2cells-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_s2cell_to_central_point","Calculates the geospatial coordinates that represent the center of an S2 cell.","Read more about [S2 cell hierarchy](https://s2geometry.io/devguide/s2cell_hierarchy).\r\n\r\n## Syntax\r\n\r\n`geo_s2cell_to_central_point(`*s2cell*`)`\r\n\r\n## Arguments\r\n\r\n*s2cell*: S2 cell token string value as it was calculated by [geo_point_to_s2cell()](geo-point-to-s2cell-function.md). The S2 cell token maximum string length is 16 characters.\r\n\r\n## Returns\r\n\r\nThe geospatial coordinate values in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the S2 cell token is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> The GeoJSON format specifies longitude first and latitude second.",'```\r\nprint point = geo_s2cell_to_central_point("1234567")\r\n| extend coordinates = point.coordinates\r\n| extend longitude = coordinates[0], latitude = coordinates[1]\r\n```\r\n\r\n|point|coordinates|longitude|latitude|\r\n|---|---|---|---|\r\n|{<br>  "type": "Point",<br>  "coordinates": [<br>    9.86830731850408,<br>    27.468392925827604<br>  ]<br>}|[<br>  9.86830731850408,<br>  27.468392925827604<br>]|9.86830731850408|27.4683929258276|\r\n\r\nThe following example returns a null result because of the invalid S2 cell token input.\r\n\r\n```\r\nprint point = geo_s2cell_to_central_point("a")\r\n```\r\n\r\n|point|\r\n|---|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-s2cell-to-central-point-function","geo-s2cell-to-central-point-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_s2cell_to_polygon","Calculates the polygon that represents the S2 Cell rectangular area.","Read more about [S2 Cells](https://s2geometry.io/devguide/s2cell_hierarchy).\r\n\r\n## Syntax\r\n\r\n`geo_s2cell_to_polygon(`*s2cell*`)`\r\n\r\n## Arguments\r\n\r\n*s2cell*: S2 Cell token string value as it was calculated by [geo_point_to_s2cell()](geo-point-to-s2cell-function.md). The S2 Cell token maximum string length is 16 characters.\r\n\r\n## Returns\r\n\r\nPolygon in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If the s2cell is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> S2 Cell edges are spherical geodesics.",'```\r\nprint s2cellPolygon = geo_s2cell_to_polygon("89c259")\r\n```\r\n\r\n|s2cellPolygon|\r\n|---|\r\n|{<br>"type": "Polygon",<br>"coordinates": [[[-74.030012249838478, 40.8012684339439], [-74.030012249838478, 40.7222262918358], [-73.935982114337421, 40.708880489804564], [-73.935982114337421, 40.787917134506841], [-74.030012249838478, 40.8012684339439]]]<br>}|\r\n\r\nThe following example assembles GeoJSON geometry collection of S2 Cell polygons.\r\n\r\n```\r\ndatatable(lng:real, lat:real)\r\n[\r\n    -73.956683, 40.807907,\r\n    -73.916869, 40.818314,\r\n    -73.989148, 40.743273,\r\n]\r\n| project s2_hash = geo_point_to_s2cell(lng, lat, 10)\r\n| project s2_hash_polygon = geo_s2cell_to_polygon(s2_hash)\r\n| summarize s2_hash_polygon_lst = make_list(s2_hash_polygon)\r\n| project pack(\r\n    "type", "Feature",\r\n    "geometry", pack("type", "GeometryCollection", "geometries", s2_hash_polygon_lst),\r\n    "properties", pack("name", "S2 Cell polygons collection"))\r\n```\r\n\r\n|Column1|\r\n|---|\r\n|{<br>"type": "Feature",<br>"geometry": {"type": "GeometryCollection", "geometries": [<br>{"type": "Polygon", "coordinates": [[[-74.030012249838478, 40.880202851376716], [-74.030012249838478, 40.8012684339439], [-73.935982114337421, 40.787917134506841], [-73.935982114337421, 40.866846163445771], [-74.030012249838478, 40.880202851376716]]]},<br>{"type": "Polygon", "coordinates": [[[-73.935982114337421, 40.866846163445771], [-73.935982114337421, 40.787917134506841], [-73.841906340776248, 40.774477568182071], [-73.841906340776248, 40.853401155678846], [-73.935982114337421, 40.866846163445771]]]},<br>{"type": "Polygon", "coordinates": [[[-74.030012249838478, 40.8012684339439], [-74.030012249838478, 40.7222262918358], [-73.935982114337421, 40.708880489804564], [-73.935982114337421, 40.787917134506841], [-74.030012249838478, 40.8012684339439]]]}]<br>},<br> "properties": {"name": "S2 Cell polygons collection"}<br>}|\r\n\r\nThe following example returns a null result because of the invalid s2cell token input.\r\n\r\n```\r\nprint s2cellPolygon = geo_s2cell_to_polygon("a")\r\n```\r\n\r\n|s2cellPolygon|\r\n|---|\r\n||',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-s2cell-to-polygon-function","geo-s2cell-to-polygon-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_union_lines_array","Calculates the union of lines or multilines on Earth.",'## Syntax\r\n\r\n`geo_union_lines_array(`*lineStrings*`)`\r\n\r\n## Arguments\r\n\r\n* *lineStrings*: An array of lines or multilines in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nLine or a multiline in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If any of the provided lines or multilines is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input line edges are straight cartesian lines, consider using [geo_line_densify()](geo-line-densify-function.md) in order to convert planar edges to geodesics.\r\n\r\n**LineString definition and constraints**\r\n\r\ndynamic({"type": "LineString","coordinates": [ [lng_1,lat_1], [lng_2,lat_2] ,..., [lng_N,lat_N] ]})\r\n\r\ndynamic({"type": "MultiLineString","coordinates": [ [ line_1, line_2 ,..., line_N ] ]})\r\n\r\n* LineString coordinates array must contain at least two entries.\r\n* Coordinates [longitude,latitude] must be valid where longitude is a real number in the range [-180, +180] and latitude is a real number in the range [-90, +90].\r\n* Edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.','The following example performs geospatial union on line rows.\r\n\r\n```\r\ndatatable(lines:dynamic)\r\n[\r\n    dynamic({"type":"LineString","coordinates":[[-73.95683884620665,40.80502891480884],[-73.95633727312088,40.8057171711177],[-73.95489156246185,40.80510200431311]]}),\r\n    dynamic({"type":"LineString","coordinates":[[-73.95633727312088,40.8057171711177],[-73.95489156246185,40.80510200431311],[-73.95537436008453,40.804413741624515]]}),\r\n    dynamic({"type":"LineString","coordinates":[[-73.95633727312088,40.8057171711177],[-73.95489156246185,40.80510200431311]]})\r\n]\r\n| summarize lines_arr = make_list(lines)\r\n| project lines_union = geo_union_lines_array(lines_arr)\r\n```\r\n\r\n|lines_union|\r\n|---|\r\n|{"type": "LineString", "coordinates": [[-73.956838846206651, 40.805028914808844], [-73.95633727312088, 40.8057171711177], [ -73.954891562461853, 40.80510200431312], [-73.955374360084534, 40.804413741624522]]}|\r\n\r\nThe following example performs geospatial union on line columns.\r\n\r\n```\r\ndatatable(line1:dynamic, line2:dynamic)\r\n[\r\n    dynamic({"type":"LineString","coordinates":[[-73.95683884620665,40.80502891480884],[-73.95633727312088,40.8057171711177],[-73.95489156246185,40.80510200431311]]}), dynamic({"type":"LineString","coordinates":[[-73.95633727312088,40.8057171711177],[-73.95489156246185,40.80510200431311],[-73.95537436008453,40.804413741624515]]})\r\n]\r\n| project lines_arr = pack_array(line1, line2)\r\n| project lines_union = geo_union_lines_array(lines_arr)\r\n```\r\n\r\n|lines_union|\r\n|---|\r\n|{"type": "LineString", "coordinates":[[-73.956838846206651, 40.805028914808844], [-73.95633727312088, 40.8057171711177], [-73.954891562461853, 40.80510200431312], [-73.955374360084534, 40.804413741624522]]}|\r\n\r\nThe following example returns True because one of the lines is invalid.\r\n\r\n```\r\ndatatable(lines:dynamic)\r\n[\r\n    dynamic({"type":"LineString","coordinates":[[-73.95683884620665,40.80502891480884],[-73.95633727312088,40.8057171711177],[-73.95489156246185,40.80510200431311]]}),\r\n    dynamic({"type":"LineString","coordinates":[[1, 1]]})\r\n]\r\n| summarize lines_arr = make_list(lines)\r\n| project invalid_union = isnull(geo_union_lines_array(lines_arr))\r\n```\r\n\r\n|invalid_union|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-union-lines-array-function","geo-union-lines-array-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"geo_union_polygons_array","Calculates the union of polygons or multipolygons on Earth.",'## Syntax\r\n\r\n`geo_union_polygons_array(`*polygons*`)`\r\n\r\n## Arguments\r\n\r\n* *polygons*: An array of polygons or multipolygons in the [GeoJSON format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type.\r\n\r\n## Returns\r\n\r\nPolygon or a multipolygon in [GeoJSON Format](https://tools.ietf.org/html/rfc7946) and of a [dynamic](./scalar-data-types/dynamic.md) data type. If any of the provided polygons or multipolygons is invalid, the query will produce a null result.\r\n\r\n> [!NOTE]\r\n> * The geospatial coordinates are interpreted as represented by the [WGS-84](https://earth-info.nga.mil/GandG/update/index.php?action=home) coordinate reference system.\r\n> * The [geodetic datum](https://en.wikipedia.org/wiki/Geodetic_datum) used for measurements on Earth is a sphere. Polygon edges are [geodesics](https://en.wikipedia.org/wiki/Geodesic) on the sphere.\r\n> * If input polygon edges are straight cartesian lines, consider using [geo_polygon_densify()](geo-polygon-densify-function.md) to convert planar edges to geodesics.\r\n\r\n**Polygon definition and constraints**\r\n\r\ndynamic({"type": "Polygon","coordinates": [ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ]})\r\n\r\ndynamic({"type": "MultiPolygon","coordinates": [[ LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_N ] ,..., [LinearRingShell, LinearRingHole_1 ,..., LinearRingHole_M]]})\r\n\r\n* LinearRingShell is required and defined as a `counterclockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be only one shell.\r\n* LinearRingHole is optional and defined as a `clockwise` ordered array of coordinates [[lng_1,lat_1],...,[lng_i,lat_i],...,[lng_j,lat_j],...,[lng_1,lat_1]]. There can be any number of interior rings and holes.\r\n* LinearRing vertices must be distinct with at least three coordinates. The first coordinate must be equal to the last. At least four entries are required.\r\n* Coordinates [longitude,latitude] must be valid. Longitude must be a real number in the range [-180, +180] and latitude must be a real number in the range [-90, +90].\r\n* LinearRingShell encloses at most half of the sphere. LinearRing divides the sphere into two regions. The smaller of the two regions will be chosen.\r\n* LinearRing edge length must be less than 180 degrees. The shortest edge between the two vertices will be chosen.\r\n* LinearRings must not cross and must not share edges. LinearRings may share vertices.','The following example performs geospatial union on polygon rows.\r\n\r\n```\r\ndatatable(polygons:dynamic)\r\n[\r\n    dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807,40.80068],[-73.98201,40.76825],[-73.97317,40.76455],[-73.9495,40.7969]]]}),\r\n    dynamic({"type":"Polygon","coordinates":[[[-73.94622,40.79249],[-73.96888,40.79282],[-73.9577,40.7789],[-73.94622,40.79249]]]}),\r\n    dynamic({"type":"Polygon","coordinates":[[[-73.97335,40.77274],[-73.9936,40.76630],[-73.97171,40.75655],[-73.97335,40.77274]]]})\r\n]\r\n| summarize polygons_arr = make_list(polygons)\r\n| project polygons_union = geo_union_polygons_array(polygons_arr)\r\n```\r\n\r\n|polygons_union|\r\n|---|\r\n|{"type":"Polygon","coordinates":[[[-73.972599326729608,40.765330371902991],[-73.960302383706178,40.782140794645024],[-73.9577,40.7789],[-73.94622,40.79249],[-73.9526593223173,40.792584227716468],[-73.9495,40.7969],[-73.95807,40.80068],[-73.9639277517478,40.792748258673875],[-73.96888,40.792819999999992],[-73.9662719791645,40.7895734224338],[-73.9803360309571,40.770518810606404],[-73.9936,40.7663],[-73.97171,40.756550000000004],[-73.972599326729608,40.765330371902991]]]}|\r\n\r\nThe following example performs geospatial union on polygon columns.\r\n\r\n```\r\ndatatable(polygon1:dynamic, polygon2:dynamic)\r\n[\r\n    dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807,40.80068],[-73.98201,40.76825],[-73.97317,40.76455],[-73.9495,40.7969]]]}), dynamic({"type":"Polygon","coordinates":[[[-73.94622,40.79249],[-73.96888,40.79282],[-73.9577,40.7789],[-73.94622,40.79249]]]})\r\n]\r\n| project polygons_arr = pack_array(polygon1, polygon2)\r\n| project polygons_union = geo_union_polygons_array(polygons_arr)\r\n```\r\n\r\n|polygons_union|\r\n|---|\r\n|{"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807,40.80068],[-73.9639277517478,40.792748258673875],[-73.96888,40.792819999999992],[-73.9662719791645,40.7895734224338],[-73.98201,40.76825],[-73.97317,40.76455],[-73.960302383706178,40.782140794645024],[-73.9577,40.7789],[-73.94622,40.79249],[-73.9526593223173,40.792584227716468],[-73.9495,40.7969]]]}|\r\n\r\nThe following example returns True because one of the polygons is invalid.\r\n\r\n```\r\ndatatable(polygons:dynamic)\r\n[\r\n    dynamic({"type":"Polygon","coordinates":[[[-73.9495,40.7969],[-73.95807,40.80068],[-73.98201,40.76825],[-73.97317,40.76455],[-73.9495,40.7969]]]}),\r\n    dynamic({"type":"Polygon","coordinates":[[[-73.94622,40.79249]]]})\r\n]\r\n| summarize polygons_arr = make_list(polygons)\r\n| project invalid_union = isnull(geo_union_polygons_array(polygons_arr))\r\n```\r\n\r\n|invalid_union|\r\n|---|\r\n|True|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/geo-union-polygons-array-function","geo-union-polygons-array-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"getmonth","Get the month number (1-12) from a datetime.","Another alias: monthoyear()","```\r\nprint month = getmonth(datetime(2015-10-12))\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/getmonthfunction","getmonthfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"getschema","Produce a table that represents a tabular schema of the input.","```\r\nT | summarize MyCount=count() by Country | getschema \r\n```\r\n\r\n## Syntax\r\n\r\n*T* `| ` `getschema`","```\r\nStormEvents\r\n| top 10 by Timestamp\r\n| getschema\r\n```\r\n\r\n|ColumnName|ColumnOrdinal|DataType|ColumnType|\r\n|---|---|---|---|\r\n|Timestamp|0|System.DateTime|datetime|\r\n|Language|1|System.String|string|\r\n|Page|2|System.String|string|\r\n|Views|3|System.Int64|long\r\n|BytesDelivered|4|System.Int64|long","https://docs.microsoft.com/azure/data-explorer/kusto/query/getschemaoperator","getschemaoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"gettype","Returns the runtime type of its single argument.","The runtime type may be different than the nominal (static) type for expressions whose nominal type is `dynamic`; in such cases `gettype()` can be useful to reveal the type of the actual value (how the value is encoded in memory).\r\n\r\n## Syntax\r\n\r\n`gettype(`*Expr*`)`\r\n\r\n## Returns\r\n\r\nA string representing the runtime type of its single argument.","|Expression                          |Returns      |\r\n|------------------------------------|-------------|\r\n|`gettype(\"a\")`                      |`string`     |\r\n|`gettype(111)`                      |`long`       |\r\n|`gettype(1==1)`                     |`bool`       |\r\n|`gettype(now())`                    |`datetime`   |\r\n|`gettype(1s)`                       |`timespan`   |\r\n|`gettype(parse_json('1'))`           |`int`        |\r\n|`gettype(parse_json(' \"abc\" '))`     |`string`     |\r\n|`gettype(parse_json(' {\"abc\":1} '))` |`dictionary` | \r\n|`gettype(parse_json(' [1, 2, 3] '))` |`array`      |\r\n|`gettype(123.45)`                   |`real`       |\r\n|`gettype(guid(12e8b78d-55b4-46ae-b068-26d7a0080254))`|`guid`| \r\n|`gettype(parse_json(''))`            |`null`|","https://docs.microsoft.com/azure/data-explorer/kusto/query/gettypefunction","gettypefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"getyear","Returns the year part of the `datetime` argument.","","```\r\nT\r\n| extend year = getyear(datetime(2015-10-12))\r\n// year == 2015\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/getyearfunction","getyearfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"has","Filters a record set for data with a case-insensitive string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `has` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`has`](has-operator.md) |Right-hand-side (RHS) is a whole term in left-hand-side (LHS) |No |`"North America" has "america"`|\r\n|[`!has`](not-has-operator.md) |RHS isn\'t a full term in LHS |No |`"North America" !has "amer"`|\r\n|[`has_cs`](has-cs-operator.md) |RHS is a whole term in LHS |Yes |`"North America" has_cs "America"`|\r\n|[`!has_cs`](not-has-cs-operator.md) |RHS isn\'t a full term in LHS |Yes |`"North America" !has_cs "amer"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `has_cs`, not `has`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `has` `(`*Expression*`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State has "New"\r\n    | where event_count > 10\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|NEW YORK|1,750|\r\n|NEW JERSEY|1,044|\r\n|NEW MEXICO|527|\r\n|NEW HAMPSHIRE|394|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/has-operator","has-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"has_all","Filters a record set for data with one or more case-insensitive search strings. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.","For more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md).\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `has_cs`, not `has`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `has_all` `(`*list of scalar expressions*`)`   \r\n*T* `|` `where` *Column* `has_all` `(`*tabular expression*`)`\r\n\r\n## Arguments\r\n\r\n* *T*: Tabular input whose records are to be filtered.\r\n* *Column*: Column to filter.\r\n* *list of expressions*: Comma separated list of tabular, scalar, or literal expressions.  \r\n* *tabular expression*: Tabular expression that has a set of values (if expression has multiple columns, the first column is used).\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`\r\n\r\n> [!NOTE]\r\n>\r\n> * The expression list can produce up to `256` values.\r\n> * For tabular expressions, the first column of the result set is selected.",'### Use has_all operator with a list\r\n\r\n```\r\nStormEvents \r\n| where EpisodeNarrative has_all ("cold", "strong", "afternoon", "hail")\r\n| summarize Count=count() by EventType\r\n| top 3 by Count\r\n```\r\n\r\n**Output**\r\n\r\n|EventType|Count|\r\n|---|---|\r\n|Thunderstorm Wind|517|\r\n|Hail|392|\r\n|Flash Flood|24|\r\n\r\n### Use has_all operator with a dynamic array\r\n\r\nThe same result can be achieved using a dynamic array notation:\r\n\r\n```\r\nlet keywords = dynamic(["cold", "strong", "afternoon", "hail"]);\r\nStormEvents \r\n| where EpisodeNarrative has_all (keywords)\r\n| summarize Count=count() by EventType\r\n| top 3 by Count\r\n```\r\n\r\n**Output**\r\n\r\n|EventType|Count|\r\n|---|---|\r\n|Thunderstorm Wind|517|\r\n|Hail|392|\r\n|Flash Flood|24|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/has-all-operator","has-all-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"has_any","Filters a record set for data with any of a set of case-insensitive strings. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.","For more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md).\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `has_cs`, not `has`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `has_any` `(`*list of scalar expressions*`)`   \r\n*T* `|` `where` *Column* `has_any` `(`*tabular expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - Tabular input whose records are to be filtered.\r\n* *Column* - Column to filter.\r\n* *list of expressions* - Comma separated list of scalar or literal expressions\r\n* *tabular expression* - Tabular expression that has a set of values (if expression has multiple columns, the first column is used)\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`\r\n\r\n## Notes\r\n\r\n* The expression list can produce up to `10,000` values.    \r\n* For tabular expressions, the first column of the result set is selected.",'### Use has_any operator with a list \r\n\r\n```\r\nStormEvents \r\n| where State has_any ("CAROLINA", "DAKOTA", "NEW") \r\n| summarize count() by State\r\n```\r\n\r\n**Output**\r\n\r\n|State|count_|\r\n|---|---|\r\n|NEW YORK|1750|\r\n|NORTH CAROLINA|1721|\r\n|SOUTH DAKOTA|1567|\r\n|NEW JERSEY|1044|\r\n|SOUTH CAROLINA|915|\r\n|NORTH DAKOTA|905|\r\n|NEW MEXICO|527|\r\n|NEW HAMPSHIRE|394|\r\n\r\n### Use has_any operator with a dynamic array\r\n\r\n```\r\nlet states = dynamic([\'south\', \'north\']);\r\nStormEvents \r\n| where State has_any (states)\r\n| summarize count() by State\r\n```\r\n\r\n**Output**\r\n\r\n|State|count_|\r\n|---|---|\r\n|NORTH CAROLINA|1721|\r\n|SOUTH DAKOTA|1567|\r\n|SOUTH CAROLINA|915|\r\n|NORTH DAKOTA|905|\r\n|ATLANTIC SOUTH|193|\r\n|ATLANTIC NORTH|188|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/has-anyoperator","has-anyoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"has_any_index","Searches the string for items specified in the array and returns the position in the array of the first item found in the string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.","## Syntax\r\n\r\n`has_any_index` `(`*string*`,` *lookup_array*`)`\r\n\r\n## Arguments\r\n\r\n* *string*: Input string to search.\r\n* *lookup_array*: Array of scalar or literal expressions to look up. The value should be of type long, integer, double, decimal, string, or guid.\r\n\r\n## Returns\r\n\r\nZero-based index position of the first item in *lookup_array* that is found in *string*.\r\nReturns -1 if none of the array items were found in the string or if *lookup_array* is empty.","```\r\nprint\r\n idx1 = has_any_index(\"this is an example\", dynamic(['this', 'example']))  // first lookup found in input string\r\n , idx2 = has_any_index(\"this is an example\", dynamic(['not', 'example'])) // last lookup found in input string\r\n , idx3 = has_any_index(\"this is an example\", dynamic(['not', 'found'])) // no lookup found in input string\r\n , idx4 = has_any_index(\"Example number 2\", range(1, 3, 1)) // Lookup array of integers\r\n , idx5 = has_any_index(\"this is an example\", dynamic([]))  // Empty lookup array\r\n```\r\n\r\n|idx1|idx2|idx3|idx4|idx5|\r\n|----|----|----|----|----|\r\n| 0  | 1 | -1 |1 | -1 |","https://docs.microsoft.com/azure/data-explorer/kusto/query/has-any-index-function","has-any-index-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"has_any_ipv4","Returns a value indicating whether one of specified IPv4 addresses appears in a text.",'IP address entrances in a text must be properly delimited with non-alphanumeric characters. For example, properly delimited IP addresses are:\r\n\r\n* "These requests came from: 192.168.1.1, 10.1.1.115 and 10.1.1.201"\r\n * "05:04:54 127.0.0.1 GET /favicon.ico 404"\r\n\r\n## Syntax\r\n\r\n`has_any_ipv4(`*text* `,` *ip_address* [ `,` *ip_address* ...] `)`     \r\n\r\n`has_any_ipv4(`*text* `,` *ip_addresses* `)`\r\n\r\n## Arguments\r\n\r\n* *text*: The value containing the text to search in.\r\n* *ip_address*: String value containing the IP address to look for.\r\n* *ip_addresses*: Dynamic array containing the list of IP addresses to look for.\r\n\r\n## Returns\r\n\r\n`true` if one of specified IP addresses is a valid IPv4 address, and it was found in *text*. Otherwise, the function returns `false`.',"```\r\nhas_any_ipv4('05:04:54 127.0.0.1 GET /favicon.ico 404', '127.0.0.1', '127.0.0.2') // true\r\n\r\nhas_any_ipv4('05:04:54 127.0.0.256 GET /favicon.ico 404', dynamic([\"127.0.0.256\", \"192.168.1.1\"])) // false, invalid IPv4 address\r\n\r\nhas_any_ipv4('05:04:54127.0.0.1 GET /favicon.ico 404', '127.0.0.1', '192.168.1.1') // false, improperly delimited IP address\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/has-any-ipv4-function","has-any-ipv4-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"has_any_ipv4_prefix","Returns a value indicating whether one of specified IPv4 address prefixes appears in a text.",'A valid IP address prefix is either a complete IPv4 address (`192.168.1.11`) or its prefix ending with a dot (`192.`, `192.168.` or `192.168.1.`).\r\n\r\nIP address entrances in a text must be properly delimited with non-alphanumeric characters. For example, properly delimited IP addresses are:\r\n\r\n* "These requests came from: 192.168.1.1, 10.1.1.115 and 10.1.1.201"\r\n * "05:04:54 127.0.0.1 GET /favicon.ico 404"\r\n\r\n## Syntax\r\n\r\n`has_any_ipv4_prefix(`*text* `,` *ip_address_prefix* [`,` *ip_address_prefix* ...] `)`     \r\n\r\n`has_any_ipv4_prefix(`*text* `,` *ip_address_prefixes* `)`\r\n\r\n## Arguments\r\n\r\n* *text*: The value containing the text to search in.\r\n* *ip_address_prefix*: String value containing the IP address prefix to look for.\r\n* *ip_address_prefixes*: Dynamic array containing IP address prefixes to look for.\r\n\r\n## Returns\r\n\r\n`true` if the one of specified IP address prefixes is a valid IPv4 address prefix, and it was found in *text*. Otherwise, the function returns `false`.',"```\r\nhas_any_ipv4_prefix('05:04:54 127.0.0.1 GET /favicon.ico 404', '127.0.', '192.168.') // true\r\n\r\nhas_any_ipv4_prefix('05:04:54 127.0.0.1 GET /favicon.ico 404', dynamic([\"127.0\", \"192.168.\"])) // false, invalid IPv4 prefix\r\n\r\nhas_any_ipv4_prefix('05:04:54 127.0.0.256 GET /favicon.ico 404', '127.0.', '192.168.') // false, invalid IPv4 address\r\n\r\nhas_any_ipv4_prefix('05:04:54127.0.0.1 GET /favicon.ico 404', '127.0.', '192.') // false, improperly delimited IP address\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/has-any-ipv4-prefix-function","has-any-ipv4-prefix-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"has_cs_","Filters a record set for data with a case-sensitive search string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `has` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`has`](has-operator.md) |Right-hand-side (RHS) is a whole term in left-hand-side (LHS) |No |`"North America" has "america"`|\r\n|[`!has`](not-has-operator.md) |RHS isn\'t a full term in LHS |No |`"North America" !has "amer"`|\r\n|[`has_cs`](has-cs-operator.md) |RHS is a whole term in LHS |Yes |`"North America" has_cs "America"`|\r\n|[`!has_cs`](not-has-cs-operator.md) |RHS isn\'t a full term in LHS |Yes |`"North America" !has_cs "amer"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `has_cs`, not `has`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `has_cs` `(`*Expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State has_cs "New"\r\n    | count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|-----|\r\n|0|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/has-cs-operator","has-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"has_ipv4","Returns a value indicating whether a specified IPv4 address appears in a text.",'IP address entrances in a text must be properly delimited with non-alphanumeric characters. For example, properly delimited IP addresses are:\r\n\r\n* "These requests came from: 192.168.1.1, 10.1.1.115 and 10.1.1.201"\r\n * "05:04:54 127.0.0.1 GET /favicon.ico 404"\r\n\r\n## Syntax\r\n\r\n`has_ipv4(`*source* `,` *ip_address* `)`\r\n\r\n## Arguments\r\n\r\n* *source*: The value containing the text to search in.\r\n* *ip_address*: String value containing the IP address to look for.\r\n\r\n## Returns\r\n\r\n`true`  if the *ip_address* is a valid IPv4 address, and it was found in *source*. Otherwise, the function returns `false`.\r\n\r\n> [!TIP]\r\n>\r\n> * To search for many IPv4 addresses at once, use [has_any_ipv4()](has-any-ipv4-function.md) function.\r\n> * To search for IPv4 addresses prefix, use [has_ipv4_prefix()](has-ipv4-prefix-function.md) function.',"```\r\nhas_ipv4('05:04:54 127.0.0.1 GET /favicon.ico 404', '127.0.0.1') // true\r\n\r\nhas_ipv4('05:04:54 127.0.0.256 GET /favicon.ico 404', '127.0.0.256') // false, invalid IPv4 address\r\n\r\nhas_ipv4('05:04:54127.0.0.1 GET /favicon.ico 404', '127.0.0.1') // false, improperly delimited IP address\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/has-ipv4-function","has-ipv4-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"has_ipv4_prefix","Returns a value indicating whether a specified IPv4 address prefix appears in a text.",'A valid IP address prefix is either a complete IPv4 address (`192.168.1.11`) or its prefix ending with a dot (`192.`, `192.168.` or `192.168.1.`).\r\n\r\nIP address entrances in a text must be properly delimited with non-alphanumeric characters. For example, properly delimited IP addresses are:\r\n\r\n* "These requests came from: 192.168.1.1, 10.1.1.115 and 10.1.1.201"\r\n * "05:04:54 127.0.0.1 GET /favicon.ico 404"\r\n\r\n## Syntax\r\n\r\n`has_ipv4_prefix(`*source* `,` *ip_address_prefix* `)`\r\n\r\n## Arguments\r\n\r\n* *source*: The value containing the text to search in.\r\n* *ip_address_prefix*: String value containing the IP address prefix to look for.\r\n\r\n## Returns\r\n\r\n`true` if the *ip_address_prefix* is a valid IPv4 address prefix, and it was found in *source*. Otherwise, the function returns `false`.\r\n\r\n> [!TIP]\r\n> To search for many IPv4 prefixes at once, use the [has_any_ipv4_prefix()](has-any-ipv4-prefix-function.md) function.',"```\r\nhas_ipv4_prefix('05:04:54 127.0.0.1 GET /favicon.ico 404', '127.0.') // true\r\n\r\nhas_ipv4_prefix('05:04:54 127.0.0.1 GET /favicon.ico 404', '127.0') // false, invalid IPv4 prefix\r\n\r\nhas_ipv4_prefix('05:04:54 127.0.0.256 GET /favicon.ico 404', '127.0.') // false, invalid IPv4 address\r\n\r\nhas_ipv4_prefix('05:04:54127.0.0.1 GET /favicon.ico 404', '127.0.') // false, improperly delimited IP address\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/has-ipv4-prefix-function","has-ipv4-prefix-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash","Returns a hash value for the input value.","## Syntax\r\n\r\n`hash(`*source* [`,` *mod*]`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The value to be hashed.\r\n* *mod*: An optional modulo value to be applied to the hash result, so that\r\n  the output value is between `0` and *mod* - 1\r\n\r\n## Returns\r\n\r\nThe hash value of *source*. If *mod* is specified, the function returns the hash value modulo the value of *mod*.\r\n\r\n> [!WARNING]\r\n> The function uses the *xxhash64* algorithm to calculate the hash for each scalar, but this may change. We therefore only recommend using this function within a single query where all invocations of the function will use the same algorithm.\r\n>\r\n> If you need to persist a combined hash, we recommend using [hash_sha256()](sha256hashfunction.md), [hash_sha1()](sha1-hash-function.md), or [hash_md5()](md5hashfunction.md) and combining the hashes into a single hash with a [bitwise operator](binoperators.md). Note that these functions are more complex to calculate than `hash()`.",'```\r\nhash("World")                   // 1846988464401551951\r\nhash("World", 100)              // 51 (1846988464401551951 % 100)\r\nhash(datetime("2015-01-01"))    // 1380966698541616202\r\n```\r\n\r\nYou can use the `hash()` function for sampling data if the values in one of its columns are uniformly distributed. In the following example, *StartTime* values are uniformly distributed and the function is used to run a query on 10% of the data.\r\n\r\n```\r\nStormEvents \r\n| where hash(StartTime, 10) == 0\r\n| summarize StormCount = count(), TypeOfStorms = dcount(EventType) by State \r\n| top 5 by StormCount desc\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/hashfunction","hashfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_combine","Combines hash values of two or more hashes.","## Syntax\r\n\r\n`hash_combine(`*h1* `,` *h2* [`,` *h3* ...]`)`\r\n\r\n## Arguments\r\n\r\n* *h1*: Long value representing the first hash value.\r\n* *h2*: Long value representing the second hash value.\r\n* *hN*: Long value representing Nth hash value.\r\n\r\n## Returns\r\n\r\nThe combined hash value of the given scalars.",'```\r\nprint value1 = "Hello", value2 = "World"\r\n| extend h1 = hash(value1), h2=hash(value2)\r\n| extend combined = hash_combine(h1, h2)\r\n```\r\n\r\n|value1|value2|h1|h2|combined|\r\n|---|---|---|---|---|\r\n|Hello|World|753694413698530628|1846988464401551951|-1440138333540407281|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/hash_combinefunction","hash_combinefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_many","Returns a combined hash value of multiple values.","## Syntax\r\n\r\n`hash_many(`*s1* `,` *s2* [`,` *s3* ...]`)`\r\n\r\n## Arguments\r\n\r\n* *s1*, *s2*, ..., *sN*: input values that will be hashed together.\r\n\r\n## Returns\r\n\r\nThe [hash()](hashfunction.md) function is applied to each of the specified scalars. The resulting hashes are combined into a single hash and returned.\r\n\r\n> [!WARNING]\r\n> The function uses the *xxhash64* algorithm to calculate the hash for each scalar, but this may change. We therefore only recommend using this function within a single query where all invocations of the function will use the same algorithm.\r\n>\r\n> If you need to persist a combined hash, we recommend using [hash_sha256()](sha256hashfunction.md), [hash_sha1()](sha1-hash-function.md), or [hash_md5()](md5hashfunction.md) and combining the hashes into a single hash with a [bitwise operator](binoperators.md). Note that these functions are more complex to calculate than `hash()`.",'```\r\nprint value1 = "Hello", value2 = "World"\r\n| extend combined = hash_many(value1, value2)\r\n```\r\n\r\n|value1|value2|combined|\r\n|---|---|---|\r\n|Hello|World|-1440138333540407281|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/hash_manyfunction","hash_manyfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_md5","Returns an MD5 hash value for the input value.",'## Syntax\r\n\r\n`hash_md5(`*source*`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The value to be hashed.\r\n\r\n## Returns\r\n\r\nThe MD5 hash value of the given scalar, encoded as a hex string (a string\r\nof characters, each two of which represent a single Hex number between 0\r\nand 255).\r\n\r\n> [!WARNING]\r\n> The algorithm used by this function (MD5) is guaranteed\r\n> to not be modified in the future, but is very complex to calculate. Users that\r\n> need a "lightweight" hash function for the duration of a single query are advised\r\n> to use the function [hash()](./hashfunction.md) instead.','```\r\nprint \r\nh1=hash_md5("World"),\r\nh2=hash_md5(datetime(2020-01-01))\r\n```\r\n\r\n|h1|h2|\r\n|---|---|\r\n|f5a7924e621e84c9280a9a27e1bcb7f6|786c530672d1f8db31fee25ea8a9390b|\r\n\r\nThe following example uses the `hash_md5()` function to aggregate StormEvents based on State\'s MD5 hash value. \r\n\r\n```\r\nStormEvents\r\n| summarize StormCount = count() by State, StateHash=hash_md5(State)\r\n| top 5 by StormCount\r\n```\r\n\r\n|State|StateHash|StormCount|\r\n|---|---|---|\r\n|TEXAS|3b00dbe6e07e7485a1c12d36c8e9910a|4701|\r\n|KANSAS|e1338d0ac8be43846cf9ae967bd02e7f|3166|\r\n|IOWA|6d4a7c02942f093576149db764d4e2d2|2337|\r\n|ILLINOIS|8c00d9e0b3fcd55aed5657e42cc40cf1|2022|\r\n|MISSOURI|2d82f0c963c0763012b2539d469e5008|2016|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/md5hashfunction","md5hashfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_sha1","Returns a sha1 hash value for the input value.",'## Syntax\r\n\r\n`hash_sha1(`*source*`)`\r\n\r\n## Arguments\r\n\r\n*source*: The value to be hashed.\r\n\r\n## Returns\r\n\r\nThe sha1 hash value of the given scalar, encoded as a hex string (a string\r\nof characters, each two of which represent a single Hex number between 0\r\nand 255).\r\n\r\n> [!WARNING]\r\n> The algorithm used by this function (SHA1) is guaranteed\r\n> to not be modified in the future, but is very complex to calculate. If you\r\n> need a "lightweight" hash function for the duration of a single query, consider using [hash()](./hashfunction.md).','```\r\nprint \r\nh1=hash_sha1("World"),\r\nh2=hash_sha1(datetime(2020-01-01))\r\n```\r\n\r\n|h1|h2|\r\n|---|---|\r\n|70c07ec18ef89c5309bbb0937f3a6342411e1fdd|e903e533f4d636b4fc0dcf3cf81e7b7f330de776|\r\n\r\nThe following example uses the `hash_sha1()` function to aggregate StormEvents based on State\'s SHA1 hash value. \r\n\r\n```\r\nStormEvents \r\n| summarize StormCount = count() by State, StateHash=hash_sha1(State)\r\n| top 5 by StormCount desc\r\n```\r\n\r\n|State|StateHash|StormCount|\r\n|---|---|---|\r\n|TEXAS|3128d805194d4e6141766cc846778eeacb12e3ea|4701|\r\n|KANSAS|ea926e17098148921e472b1a760cd5a8117e84d6|3166|\r\n|IOWA|cacf86ec119cfd5b574bde5b59604774de3273db|2337|\r\n|ILLINOIS|03740763b16dae9d799097f51623fe635d8c4852|2022|\r\n|MISSOURI|26d938907240121b54d9e039473dacc96e712f61|2016|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/sha1-hash-function","sha1-hash-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_sha256","Returns a sha256 hash value for the input value.",'## Syntax\r\n\r\n`hash_sha256(`*source*`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The value to be hashed.\r\n\r\n## Returns\r\n\r\nThe sha256 hash value of the given scalar, encoded as a hex string (a string\r\nof characters, each two of which represent a single Hex number between 0\r\nand 255).\r\n\r\n> [!WARNING]\r\n> The algorithm used by this function (SHA256) is guaranteed\r\n> to not be modified in the future, but is very complex to calculate. Users that\r\n> need a "lightweight" hash function for the duration of a single query are advised\r\n> to use the function [hash()](./hashfunction.md) instead.','```\r\nprint \r\nh1=hash_sha256("World"),\r\nh2=hash_sha256(datetime(2020-01-01))\r\n```\r\n\r\n|h1|h2|\r\n|---|---|\r\n|78ae647dc5544d227130a0682a51e30bc7777fbb6d8a8f17007463a3ecd1d524|ba666752dc1a20eb750b0eb64e780cc4c968bc9fb8813461c1d7e750f302d71d|\r\n\r\nThe following example uses the `hash_sha256()` function to aggregate StormEvents based on State\'s SHA256 hash value. \r\n\r\n```\r\nStormEvents \r\n| summarize StormCount = count() by State, StateHash=hash_sha256(State)\r\n| top 5 by StormCount desc\r\n```\r\n\r\n|State|StateHash|StormCount|\r\n|---|---|---|\r\n|TEXAS|9087f20f23f91b5a77e8406846117049029e6798ebbd0d38aea68da73a00ca37|4701|\r\n|KANSAS|c80e328393541a3181b258cdb4da4d00587c5045e8cf3bb6c8fdb7016b69cc2e|3166|\r\n|IOWA|f85893dca466f779410f65cd904fdc4622de49e119ad4e7c7e4a291ceed1820b|2337|\r\n|ILLINOIS|ae3eeabfd7eba3d9a4ccbfed6a9b8cff269dc43255906476282e0184cf81b7fd|2022|\r\n|MISSOURI|d15dfc28abc3ee73b7d1f664a35980167ca96f6f90e034db2a6525c0b8ba61b1|2016|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/sha256hashfunction","sha256hashfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hash_xxhash64","Returns an xxhash64 value for the input value.","## Syntax\r\n\r\n`hash_xxhash64(`*source* [`,` *mod*]`)`\r\n\r\n## Arguments\r\n\r\n* *source*: The value to be hashed.\r\n* *mod*: An optional modulo value to be applied to the hash result, so that\r\n  the output value is between `0` and *mod* - 1\r\n\r\n## Returns\r\n\r\nThe hash value of *source*. If *mod* is specified, the function returns the hash value modulo the value of *mod*.",'```\r\nxxhash64("World")                   // 1846988464401551951\r\nxxhash64("World", 100)              // 51 (1846988464401551951 % 100)\r\nxxhash64(datetime("2015-01-01"))    // 1380966698541616202\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/hash-xxhash64-function","hash-xxhash64-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"hasprefix","Filters a record set for data with a case-insensitive starting string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `hasprefix` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`hasprefix`](hasprefix-operator.md) |RHS is a term prefix in LHS |No |`"North America" hasprefix "ame"`|\r\n|[`!hasprefix`](not-hasprefix-operator.md) |RHS isn\'t a term prefix in LHS |No |`"North America" !hasprefix "mer"`|\r\n|[`hasprefix_cs`](hasprefix-cs-operator.md) |RHS is a term prefix in LHS |Yes |`"North America" hasprefix_cs "Ame"`|\r\n|[`!hasprefix_cs`](not-hasprefix-cs-operator.md) |RHS isn\'t a term prefix in LHS |Yes |`"North America" !hasprefix_cs "CA"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor more information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hasprefix_cs`, not `hasprefix`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `hasprefix` `(`*Expression*`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','### Use hasprefix operator\r\n\r\n```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State hasprefix "la"\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|LAKE MICHIGAN|182|\r\n|LAKE HURON|63|\r\n|LAKE SUPERIOR|34|\r\n|LAKE ST CLAIR|32|\r\n|LAKE ERIE|27|\r\n|LAKE ONTARIO|8|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/hasprefix-operator","hasprefix-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"hasprefix_cs","Filters a record set for data with a case-sensitive starting string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `has` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`hasprefix`](hasprefix-operator.md) |RHS is a term prefix in LHS |No |`"North America" hasprefix "ame"`|\r\n|[`!hasprefix`](not-hasprefix-operator.md) |RHS isn\'t a term prefix in LHS |No |`"North America" !hasprefix "mer"`|\r\n|[`hasprefix_cs`](hasprefix-cs-operator.md) |RHS is a term prefix in LHS |Yes |`"North America" hasprefix_cs "Ame"`|\r\n|[`!hasprefix_cs`](not-hasprefix-cs-operator.md) |RHS isn\'t a term prefix in LHS |Yes |`"North America" !hasprefix_cs "CA"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hasprefix_cs`, not `hasprefix`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `hasprefix_cs` `(`*expression*`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State hasprefix_cs "P"\r\n    | count \r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|-----|\r\n|3|\r\n\r\n```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State hasprefix_cs "P"\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|PENNSYLVANIA|1687|\r\n|PUERTO RICO|192|\r\n|E PACIFIC|10|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/hasprefix-cs-operator","hasprefix-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"hassuffix","Filters a record set for data with a case-insensitive ending string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `hassuffix` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`hassuffix`](hassuffix-operator.md) |RHS is a term suffix in LHS |No |`"North America" hassuffix "ica"`|\r\n|[`!hassuffix`](not-hassuffix-operator.md) |RHS isn\'t a term suffix in LHS |No |`"North America" !hassuffix "americ"`|\r\n|[`hassuffix_cs`](hassuffix-cs-operator.md)  |RHS is a term suffix in LHS |Yes |`"North America" hassuffix_cs "ica"`|\r\n|[`!hassuffix_cs`](not-hassuffix-cs-operator.md) |RHS isn\'t a term suffix in LHS |Yes |`"North America" !hassuffix_cs "icA"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hassuffix_cs`, not `hassuffix`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *Column* `hassuffix` `(`*Expression*`)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *Column* - The column to filter.\r\n* *Expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State hassuffix "o"\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|COLORADO|1654|\r\n|OHIO|1233|\r\n|GULF OF MEXICO|577|\r\n|NEW MEXICO|527|\r\n|IDAHO|247|\r\n|PUERTO RICO|192|\r\n|LAKE ONTARIO|8|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/hassuffix-operator","hassuffix-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"hassuffix_cs","Filters a record set for data with a case-sensitive ending string. `has` searches for indexed terms, where a [term](datatypes-string-operators.md#what-is-a-term) is three or more characters. If your term is fewer than three characters, the query scans the values in the column, which is slower than looking up the term in the term index.",'The following table provides a comparison of the `hassuffix` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`hassuffix`](hassuffix-operator.md) |RHS is a term suffix in LHS |No |`"North America" hassuffix "ica"`|\r\n|[`!hassuffix`](not-hassuffix-operator.md) |RHS isn\'t a term suffix in LHS |No |`"North America" !hassuffix "americ"`|\r\n|[`hassuffix_cs`](hassuffix-cs-operator.md)  |RHS is a term suffix in LHS |Yes |`"North America" hassuffix_cs "ica"`|\r\n|[`!hassuffix_cs`](not-hassuffix-cs-operator.md) |RHS isn\'t a term suffix in LHS |Yes |`"North America" !hassuffix_cs "icA"`|\r\n\r\n> [!NOTE]\r\n> The following abbreviations are used in the table above:\r\n>\r\n> * RHS = right hand side of the expression\r\n> * LHS = left hand side of the expression\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `hassuffix_cs`, not `hassuffix`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `hassuffix_cs` `(`*expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *expression* - Scalar or literal expression.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents\r\n    | summarize event_count=count() by State\r\n    | where State hassuffix_cs "AS"\r\n    | where event_count > 2000\r\n    | project State, event_count\r\n```\r\n\r\n**Output**\r\n\r\n|State|event_count|\r\n|-----|-----------|\r\n|TEXAS|4701|\r\n|KANSAS|3166|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/hassuffix-cs-operator","hassuffix-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hll","Calculates the Intermediate results of [`dcount`](dcount-aggfunction.md) across the group, only in context of aggregation inside [summarize](summarizeoperator.md).","Read about the [underlying algorithm (*H*yper*L*og*L*og) and the estimation accuracy](dcount-aggfunction.md#estimation-accuracy).\r\n\r\n## Syntax\r\n\r\n`hll` `(`*Expr* [`,` *Accuracy*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation. \r\n* *Accuracy*, if specified, controls the balance between speed and accuracy.\r\n  |Accuracy Value |Accuracy  |Speed  |Error  |\r\n  |---------|---------|---------|---------|\r\n  |`0` | lowest | fastest | 1.6% |\r\n  |`1` | default  | balanced | 0.8% |\r\n  |`2` | high | slow | 0.4%  |\r\n  |`3` | high | slow | 0.28% |\r\n  |`4` | extra high | slowest | 0.2% |\r\n\t\r\n\r\n## Returns\r\n\r\nThe Intermediate results of distinct count of *`Expr`* across the group.\r\n\r\n**Tips**\r\n\r\n1. You may use the aggregation function [`hll_merge`](hll-merge-aggfunction.md) to merge more than one `hll` intermediate results (it works on `hll` output only).\r\n1. You may use the function [`dcount_hll`](dcount-hllfunction.md), which will calculate the `dcount` from `hll` / `hll_merge` aggregation functions.","```\r\nStormEvents\r\n| summarize hll(DamageProperty) by bin(StartTime,10m)\r\n\r\n```\r\n\r\n|StartTime|`hll_DamageProperty`|\r\n|---|---|\r\n|2007-09-18 20:00:00.0000000|[[1024,14],[-5473486921211236216,-6230876016761372746,3953448761157777955,4246796580750024372],[]]|\r\n|2007-09-20 21:50:00.0000000|[[1024,14],[4835649640695509390],[]]|\r\n|2007-09-29 08:10:00.0000000|[[1024,14],[4246796580750024372],[]]|\r\n|2007-12-30 16:00:00.0000000|[[1024,14],[4246796580750024372,-8936707700542868125],[]]|","https://docs.microsoft.com/azure/data-explorer/kusto/query/hll-aggfunction","hll-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hll_merge","Merges `hll` results (scalar version of the aggregate version [`hll_merge()`](hll-merge-aggfunction.md)).","Read about the [underlying algorithm (*H*yper*L*og*L*og) and estimation accuracy](dcount-aggfunction.md#estimation-accuracy).\r\n\r\n## Syntax\r\n\r\n`hll_merge(` *Expr1*`,` *Expr2*`, ...)`\r\n\r\n## Arguments\r\n\r\n* Columns that have `hll` values to be merged.\r\n\r\n## Returns\r\n\r\nThe result for merging the columns `*Exrp1*`, `*Expr2*`, ... `*ExprN*` to one `hll` value.","```\r\nrange x from 1 to 10 step 1 \r\n| extend y = x + 10\r\n| summarize hll_x = hll(x), hll_y = hll(y)\r\n| project merged = hll_merge(hll_x, hll_y)\r\n| project dcount_hll(merged)\r\n```\r\n\r\n|`dcount_hll_merged`|\r\n|---|\r\n|20|","https://docs.microsoft.com/azure/data-explorer/kusto/query/hllmergefunction","hllmergefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"hourofday","Returns the integer number representing the hour number of the given date","```\r\nhourofday(datetime(2015-12-14 18:54)) == 18\r\n```\r\n\r\n## Syntax\r\n\r\n`hourofday(`*a_date*`)`\r\n\r\n## Arguments\r\n\r\n* `a_date`: A `datetime`.\r\n\r\n## Returns\r\n\r\n`hour number` of the day (0-23).","","https://docs.microsoft.com/azure/data-explorer/kusto/query/hourofdayfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"http_request","The `http_request` (GET) and `http_request_post` (POST) plugins send an HTTP request and convert the response into a table.","> [!IMPORTANT]\r\n> Both plugins are disabled by default, as they allow queries to send data\r\n> and the user's security token to external user-specified network endpoints.\r\n> Once enabled, both plugins are further subject to the configured\r\n> [callout policy](../management/calloutpolicy.md) that cluster admins\r\n> can use to granularly control which URIs the request can be sent to.\r\n\r\n## Syntax\r\n\r\n`evaluate` `http_request` `(` *Uri* [`,` *RequestHeaders* [`,` *Options*]] `)`\r\n\r\n`evaluate` `http_request_post` `(` *Uri* [`,` *RequestHeaders* [`,` *Options* [`,` *Content*]]] `)`\r\n\r\n## Arguments\r\n\r\n| Name | Type | Required | Description |\r\n|--|--|--|--|\r\n| *Uri* | string | &check; | The destination URI for the HTTP or HTTPS request. |\r\n| *RequestHeaders* | dynamic |  | A property bag containing [HTTP headers](#headers) to send with the request. |\r\n| *Options* | dynamic |  | A property bag containing additional properties of the request. |\r\n| *Content* | string |  | The body content to send with the request. The content is encoded in `UTF-8` and the media type for the `Content-Type` attribute is `application/json`. |\r\n\r\n## Returns\r\n\r\nBoth plugins return a table that has a single record with the following dynamic columns:\r\n\r\n* *ResponseHeaders*: A property bag with the response header.\r\n* *ResponseBody*: The response body parsed as a value of type `dynamic`.\r\n\r\n## Prerequisites\r\n\r\nBefore you use the `http_request` and `http_request_post` plugins, make sure that requests meet the following requirements:\r\n\r\n* The specified *Uri* value must be a destination that is enabled for `webapi` callout by the [Callout policy](../management/calloutpolicy.md). Otherwise, running the query results in an error.\r\n* If you're using authentication, you must use the HTTPS protocol. Attempts to use HTTP with authentication enabled results in an error.\r\n\r\n## Authentication\r\n\r\nYou can use the query arguments to specify authentication parameters for the `http_request` and `http_request_post` plugins. The following scenarios are supported:\r\n\r\n| Argument | Description |\r\n|--|--|\r\n| *Uri* | The URI to authenticate with. |\r\n| *RequestHeaders* | Using the HTTP standard `Authorization` header or any custom header supported by the web service. |\r\n| *Options* | Using the HTTP standard `Authorization` header.<br />If you want to use Azure Active Directory (Azure AD) authentication, you must use an HTTPS URI for the request and set the following values:<br />* `azure_active_directory` to `Active Directory Integrated`<br />* `AadResourceId` to the Azure AD ResourceId value of the target web service. |\r\n\r\n> [!WARNING]\r\n> Be extra careful not to send secret information, such as\r\n> authentication tokens, over HTTP connections. Additionally, if the query includes\r\n> confidential information, make sure that the relevant parts of the\r\n> query text are obfuscated so that they'll be omitted from any tracing.\r\n> For more information, see [obfuscated string literals](./scalar-data-types/string.md#obfuscated-string-literals).\r\n\r\n## Headers\r\n\r\nThe *RequestHeaders* argument can be used to add custom headers\r\nto the outgoing HTTP request. In addition to the standard HTTP request headers\r\nand the user-provided custom headers, the plugin also adds the following\r\ncustom headers:\r\n\r\n| Name | Description |\r\n|--|--|\r\n| `x-ms-client-request-id` | A correlation ID that identifies the request. Multiple invocations of the plugin in the same query will all have the same ID. |\r\n| `x-ms-readonly` | A flag indicating that the processor of this request shouldn't make any persistent changes. |\r\n\r\n> [!WARNING]\r\n> The `x-ms-readonly` flag is set for every HTTP request sent by the plugin\r\n> that was triggered by a query and not a control command. Web services should\r\n> treat any requests with this flag as one that does not make internal\r\n> state changes, otherwise they should refuse the request. This protects users from being\r\n> sent seemingly-innocent queries that end up making unwanted changes by using\r\n> a Kusto query as the launchpad for such attacks.","The following example retrieves the canonical list of country codes:\r\n\r\n```\r\nevaluate http_request('http://services.groupkt.com/country/get/all')\r\n| project CC=ResponseBody.RestResponse.result\r\n| mv-expand CC limit 10000\r\n| project\r\n    name        = tostring(CC.name),\r\n    alpha2_code = tostring(CC.alpha2_code),\r\n    alpha3_code = tostring(CC.alpha3_code)\r\n| where name startswith 'b'\r\n```\r\n\r\nname                              | alpha2_code  | alpha3_code\r\n----------------------------------|--------------|-------------\r\nBahamas                           | BS           | BHS\r\nBahrain                           | BH           | BHR\r\nBangladesh                        | BD           | BGD\r\nBarbados                          | BB           | BRB\r\nBelarus                           | BY           | BLR\r\nBelgium                           | BE           | BEL\r\nBelize                            | BZ           | BLZ\r\nBenin                             | BJ           | BEN\r\nBermuda                           | BM           | BMU\r\nBhutan                            | BT           | BTN\r\nBolivia (Plurinational State of)  | BO           | BOL\r\nBonaire, Sint Eustatius and Saba  | BQ           | BES\r\nBosnia and Herzegovina            | BA           | BIH\r\nBotswana                          | BW           | BWA\r\nBouvet Island                     | BV           | BVT\r\nBrazil                            | BR           | BRA\r\nBritish Indian Ocean Territory    | IO           | IOT\r\nBrunei Darussalam                 | BN           | BRN\r\nBulgaria                          | BG           | BGR\r\nBurkina Faso                      | BF           | BFA\r\nBurundi                           | BI           | BDI\r\n\r\nThe following example is for a hypothetical HTTPS web service that accepts additional request headers and must be authenticated to using Azure AD:\r\n\r\n```\r\nlet uri='https://example.com/node/js/on/eniac';\r\nlet headers=dynamic({'x-ms-correlation-vector':'abc.0.1.0'});\r\nlet options=dynamic({'Authentication':'Active Directory Integrated',\r\n  'AadResourceId':'https://eniac.to.the.max.example.com/'});\r\nevaluate http_request_post(uri, headers, options)\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/http-request-plugin","http-request-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"iff","Evaluates the first argument (the predicate), and returns the value of either the second or third arguments, depending on whether the predicate evaluated to `true` (second) or `false` (third).","The second and third arguments must be of the same type.\r\n\r\n## Syntax\r\n\r\n`iff(`*predicate*`,` *ifTrue*`,` *ifFalse*`)`\r\n\r\n## Arguments\r\n\r\n* *predicate*: An expression that evaluates to a `boolean` value.\r\n* *ifTrue*: An expression that gets evaluated and its value returned from the function if *predicate* evaluates to `true`.\r\n* *ifFalse*: An expression that gets evaluated and its value returned from the function if *predicate* evaluates to `false`.\r\n\r\n## Returns\r\n\r\nThis function returns the value of *ifTrue* if *predicate* evaluates to `true`,\r\nor the value of *ifFalse* otherwise.",'```\r\nT \r\n| extend day = iff(floor(Timestamp, 1d)==floor(now(), 1d), "today", "anotherday")\r\n```',"https://docs.microsoft.com/azure/data-explorer/kusto/query/ifffunction","ifffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"iif","Evaluates the first argument (the predicate), and returns the value of either the second or third arguments, depending on whether the predicate evaluated to `true` (second) or `false` (third).","The second and third arguments must be of the same type.\r\n\r\n## Syntax\r\n\r\n`iif(`*predicate*`,` *ifTrue*`,` *ifFalse*`)`\r\n\r\n## Arguments\r\n\r\n* *predicate*: An expression that evaluates to a `boolean` value.\r\n* *ifTrue*: An expression that gets evaluated and its value returned from the function if *predicate* evaluates to `true`.\r\n* *ifFalse*: An expression that gets evaluated and its value returned from the function if *predicate* evaluates to `false`.\r\n\r\n## Returns\r\n\r\nThis function returns the value of *ifTrue* if *predicate* evaluates to `true`,\r\nor the value of *ifFalse* otherwise.",'```\r\nT \r\n| extend day = iif(floor(Timestamp, 1d)==floor(now(), 1d), "today", "anotherday")\r\n```\r\n\r\nAn alias for [`iff()`](ifffunction.md).',"https://docs.microsoft.com/azure/data-explorer/kusto/query/iiffunction","iiffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"in","Filters a record set for data with a case-sensitive string.",'The following table provides a comparison of the `in` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`in`](in-cs-operator.md) |Equals to any of the elements |Yes |`"abc" in ("123", "345", "abc")`|\r\n|[`!in`](not-in-cs-operator.md) |Not equals to any of the elements |Yes | `"bca" !in ("123", "345", "abc")` |\r\n|[`in~`](inoperator.md) |Equals to any of the elements |No | `"Abc" in~ ("123", "345", "abc")` |\r\n|[`!in~`](not-in-operator.md) |Not equals to any of the elements |No | `"bCa" !in~ ("123", "345", "ABC")` |\r\n\r\n> [!NOTE]\r\n>\r\n> * In tabular expressions, the first column of the result set is selected.\r\n> * The expression list can produce up to `1,000,000` values.\r\n> * Nested arrays are flattened into a single list of values. For example, `x in (dynamic([1,[2,3]]))` becomes `x in (1,2,3)`.\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `in`, not `in~`. For best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `in` `(`*list of scalar expressions*`)`   \r\n*T* `|` `where` *col* `in` `(`*tabular expression*`)`   \r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *list of expressions* - A comma-separated list of tabular, scalar, or literal expressions.\r\n* *tabular expression* - A tabular expression that has a set of values. If the expression has multiple columns, the first column is used.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','### Use in operator\r\n\r\n```\r\nStormEvents \r\n| where State in ("FLORIDA", "GEORGIA", "NEW YORK") \r\n| count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|---|\r\n|4775|  \r\n\r\n### Use dynamic array\r\n\r\n```\r\nlet states = dynamic([\'FLORIDA\', \'ATLANTIC SOUTH\', \'GEORGIA\']);\r\nStormEvents \r\n| where State in (states)\r\n| count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|---|\r\n|3218|\r\n\r\n### Subquery\r\n\r\n```\r\n// Using subquery\r\nlet Top_5_States = \r\nStormEvents\r\n| summarize count() by State\r\n| top 5 by count_; \r\nStormEvents \r\n| where State in (Top_5_States) \r\n| count\r\n```\r\n\r\nThe same query can be written as:\r\n\r\n```\r\n// Inline subquery \r\nStormEvents \r\n| where State in (\r\n    ( StormEvents\r\n    | summarize count() by State\r\n    | top 5 by count_ )\r\n) \r\n| count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|---|\r\n|14242|  \r\n\r\n### Top with other example\r\n\r\n```\r\nlet Lightning_By_State = materialize(StormEvents | summarize lightning_events = countif(EventType == \'Lightning\') by State);\r\nlet Top_5_States = Lightning_By_State | top 5 by lightning_events | project State; \r\nLightning_By_State\r\n| extend State = iif(State in (Top_5_States), State, "Other")\r\n| summarize sum(lightning_events) by State \r\n```\r\n\r\n**Output**\r\n\r\n| State     | sum_lightning_events |\r\n|-----------|----------------------|\r\n| ALABAMA   | 29                   |\r\n| WISCONSIN | 31                   |\r\n| TEXAS     | 55                   |\r\n| FLORIDA   | 85                   |\r\n| GEORGIA   | 106                  |\r\n| Other     | 415                  |\r\n\r\n### Use a static list returned by a function\r\n\r\n```\r\nStormEvents | where State in (InterestingStates()) | count\r\n\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|---|\r\n|4775|  \r\n\r\nThe function definition.\r\n\r\n```\r\n.show function InterestingStates\r\n```\r\n\r\n**Output**\r\n\r\n|Name|Parameters|Body|Folder|DocString|\r\n|---|---|---|---|---|\r\n|InterestingStates|()|{ dynamic(["WASHINGTON", "FLORIDA", "GEORGIA", "NEW YORK"]) }',"https://docs.microsoft.com/azure/data-explorer/kusto/query/in-cs-operator","in-cs-operator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"in~","Filters a record set for data with a case-insensitive string.",'The following table provides a comparison of the `in` operators:\r\n\r\n|Operator   |Description   |Case-Sensitive  |Example (yields `true`)  |\r\n|-----------|--------------|----------------|-------------------------|\r\n|[`in`](in-cs-operator.md) |Equals to one of the elements |Yes |`"abc" in ("123", "345", "abc")`|\r\n|[`!in`](not-in-cs-operator.md) |Not equals to any of the elements |Yes | `"bca" !in ("123", "345", "abc")` |\r\n|[`in~`](inoperator.md) |Equals to any of the elements |No | `"Abc" in~ ("123", "345", "abc")` |\r\n|[`!in~`](not-in-operator.md) |Not equals to any of the elements |No | `"bCa" !in~ ("123", "345", "ABC")` |\r\n\r\n> [!NOTE]\r\n>\r\n> * In tabular expressions, the first column of the result set is selected.\r\n> * The expression list can produce up to `1,000,000` values.\r\n> * Nested arrays are flattened into a single list of values. For example, `x in (dynamic([1,[2,3]]))` becomes `x in (1,2,3)`.\r\n\r\nFor further information about other operators and to determine which operator is most appropriate for your query, see [datatype string operators](datatypes-string-operators.md). \r\n\r\nCase-insensitive operators are currently supported only for ASCII-text. For non-ASCII comparison, use the [tolower()](tolowerfunction.md) function.\r\n\r\n## Performance tips\r\n\r\n> [!NOTE]\r\n> Performance depends on the type of search and the structure of the data.\r\n\r\nFor faster results, use the case-sensitive version of an operator, for example, `in`, not `in~`. \r\n\r\nIf you\'re testing for the presence of a symbol or alphanumeric word that is bound by non-alphanumeric characters at the start or end of a field, for faster results use `has` or `in`. \r\n\r\nFor best practices, see [Query best practices](best-practices.md).\r\n\r\n## Syntax\r\n\r\n*T* `|` `where` *col* `in~` `(` *list of scalar expressions* `)`\r\n*T* `|` `where` *col* `in~` `(` *tabular expression* `)`\r\n\r\n## Arguments\r\n\r\n* *T* - The tabular input whose records are to be filtered.\r\n* *col* - The column to filter.\r\n* *list of expressions* - A comma-separated list of tabular, scalar, or literal expressions.\r\n* *tabular expression* - A tabular expression that has a set of values. If the expression has multiple columns, the first column is used.\r\n\r\n## Returns\r\n\r\nRows in *T* for which the predicate is `true`.','```\r\nStormEvents \r\n| where State in~ ("FLORIDA", "georgia", "NEW YORK") \r\n| count\r\n```\r\n\r\n**Output**\r\n\r\n|Count|\r\n|---|\r\n|4775|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/inoperator","inoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"indexof","Reports the zero-based index of the first occurrence of a specified string within the input string.","If lookup or input string isn't of *string* type, the function forcibly casts the value to *string*.\r\n\r\nFor more information, see [`indexof_regex()`](indexofregexfunction.md).\r\n\r\n## Syntax\r\n\r\n`indexof(`*source*`,`*lookup*`[,`*start_index*`[,`*length*`[,`*occurrence*`]]])`\r\n\r\n## Arguments\r\n\r\n* *source*: Input string.  \r\n* *lookup*: String to look up.\r\n* *start_index*: Search start position. A negative value will offset the starting search position from the end of the *source* by this many steps: abs(*start_index*). Optional.\r\n* *length*: Number of character positions to examine. A value of -1 means unlimited length. Optional.\r\n* *occurrence*: The number of the occurrence. Default 1. Optional.\r\n\r\n## Returns\r\n\r\nZero-based index position of *lookup*.\r\n\r\nReturns -1 if the string isn't found in the input.\r\n\r\nFor irrelevant inputs (*occurrence* < 0 or  *length* < -1) - returns *null*.",'```\r\nprint\r\n idx1 = indexof("abcdefg","cde")    // lookup found in input string\r\n , idx2 = indexof("abcdefg","cde",1,4) // lookup found in researched range \r\n , idx3 = indexof("abcdefg","cde",1,2) // search starts from index 1, but stops after 2 chars, so full lookup can\'t be found\r\n , idx4 = indexof("abcdefg","cde",3,4) // search starts after occurrence of lookup\r\n , idx5 = indexof("abcdefg","cde",-5)  // negative start index\r\n , idx6 = indexof(1234567,5,1,4)       // two first parameters were forcibly casted to strings "12345" and "5"\r\n , idx7 = indexof("abcdefg","cde",2,-1)  // lookup found in input string\r\n , idx8 = indexof("abcdefgabcdefg", "cde", 1, 10, 2)   // lookup found in input range\r\n , idx9 = indexof("abcdefgabcdefg", "cde", 1, -1, 3)   // the third occurrence of lookup is not in researched range\r\n```\r\n\r\n|idx1|idx2|idx3|idx4|idx5|idx6|idx7|idx8|idx9|\r\n|----|----|----|----|----|----|----|----|----|\r\n|2   |2   |-1  |-1  | 2  |4   |2   |9   |-1  |',"https://docs.microsoft.com/azure/data-explorer/kusto/query/indexoffunction","indexoffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"indexof_regex","Returns the zero-based index of the first occurrence of a specified lookup regular expression within the input string.","See [`indexof()`](indexoffunction.md).\r\n\r\n## Syntax\r\n\r\n`indexof_regex(`*source*`,`*lookup*`[,`*start_index*`[,`*length*`[,`*occurrence*`]]])`\r\n\r\n## Arguments\r\n\r\n|Arguments     | Description                                     |Required or Optional|\r\n|--------------|-------------------------------------------------|--------------------|\r\n|source        | Input string                                    |Required            |\r\n|lookup        | Regular expression lookup string.               |Required            |\r\n|start_index   | Search start position                           |Optional            |\r\n|length        | Number of character positions to examine. -1 defines an unlimited length |Optional            |\r\n|occurrence    | Find the index of the N-th appearance of the pattern. \r\n                 Default is 1, the index of the first occurrence |Optional            |\r\n\r\n## Returns\r\n\r\nZero-based index position of *lookup*.\r\n\r\n* Returns -1 if the string isn't found in the input.\r\n* Returns *null* if:\r\n     * start_index is less than 0.\r\n     * occurrence is less than 0.\r\n     * length parameter is less than -1.\r\n\r\n> [!NOTE]\r\n\r\n- Overlapping matches lookup aren't supported.\r\n- Regular expression strings may contain characters that require either escaping or using @'' string-literals.",'```\r\nprint\r\n idx1 = indexof_regex("abcabc", @"a.c") // lookup found in input string\r\n , idx2 = indexof_regex("abcabcdefg", @"a.c", 0, 9, 2)  // lookup found in input string\r\n , idx3 = indexof_regex("abcabc", @"a.c", 1, -1, 2)  // there is no second occurrence in the search range\r\n , idx4 = indexof_regex("ababaa", @"a.a", 0, -1, 2)  // Matches do not overlap so full lookup can\'t be found\r\n , idx5 = indexof_regex("abcabc", @"a|ab", -1)  // invalid start_index argument\r\n```\r\n\r\n|idx1|idx2|idx3|idx4|idx5|\r\n|----|----|----|----|----|\r\n|0   |3   |-1  |-1  |    |',"https://docs.microsoft.com/azure/data-explorer/kusto/query/indexofregexfunction","indexofregexfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"infer_storage_schema","This plug-in infers schema of external data, and returns it as CSL schema string. The string can be used when [creating external tables](../management/external-tables-azurestorage-azuredatalake.md#create-or-alter-external-table). The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","## Syntax\r\n\r\n`evaluate` `infer_storage_schema(` *Options* `)`\r\n\r\n## Arguments\r\n\r\nA single *Options* argument is a constant value of type `dynamic` that holds\r\na property bag specifying properties of the request:\r\n\r\n|Name                    |Required|Description|\r\n|------------------------|--------|-----------|\r\n|`StorageContainers`|Yes|List of [storage connection strings](../api/connection-strings/storage-connection-strings.md) that represent prefix URI for stored data artifacts|\r\n|`DataFormat`|Yes|One of supported [data formats](../../ingestion-supported-formats.md).|\r\n|`FileExtension`|No|Only scan files ending with this file extension. It's not required, but specifying it may speed up the process (or eliminate data reading issues)|\r\n|`FileNamePrefix`|No|Only scan files starting with this prefix. It's not required, but specifying it may speed up the process|\r\n|`Mode`|No|Schema inference strategy, one of: `any`, `last`, `all`. Infer data schema from any (first found) file, from last written file, or from all files respectively. The default value is `last`.|\r\n\r\n## Returns\r\n\r\nThe `infer_storage_schema` plugin returns a single result table containing a single row/column holding CSL schema string.\r\n\r\n> [!NOTE]\r\n> * Storage container URI secret keys must have the permissions for *List* in addition to *Read*.\r\n> * Schema inference strategy 'all' is a very \"expensive\" operation, as it implies reading from *all* artifacts found and merging their schema.\r\n> * Some returned types may not be the actual ones as a result of wrong type guess (or, as a result of schema merge process). This is why you should review the result carefully before creating an external table.","```\r\nlet options = dynamic({\r\n  'StorageContainers': [\r\n    h@'https://storageaccount.blob.core.windows.net/MovileEvents;secretKey'\r\n  ],\r\n  'FileExtension': '.parquet',\r\n  'FileNamePrefix': 'part-',\r\n  'DataFormat': 'parquet'\r\n});\r\nevaluate infer_storage_schema(options)\r\n```\r\n\r\n*Result*\r\n\r\n|CslSchema|\r\n|---|\r\n|app_id:string, user_id:long, event_time:datetime, country:string, city:string, device_type:string, device_vendor:string, ad_network:string, campaign:string, site_id:string, event_type:string, event_name:string, organic:string, days_from_install:int, revenue:real|\r\n\r\nUse the returned schema in external table definition:\r\n\r\n```\r\n.create external table MobileEvents(\r\n    app_id:string, user_id:long, event_time:datetime, country:string, city:string, device_type:string, device_vendor:string, ad_network:string, campaign:string, site_id:string, event_type:string, event_name:string, organic:string, days_from_install:int, revenue:real\r\n)\r\nkind=blob\r\npartition by (dt:datetime = bin(event_time, 1d), app:string = app_id)\r\npathformat = ('app=' app '/dt=' datetime_pattern('yyyyMMdd', dt))\r\ndataformat = parquet\r\n(\r\n    h@'https://storageaccount.blob.core.windows.net/MovileEvents;secretKey'\r\n)\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/inferstorageschemaplugin","inferstorageschemaplugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ingestion_time","Returns the approximate time at which the current record was ingested.",'This function must be used in the context of a table of ingested data for which the [IngestionTime policy](../management/ingestiontimepolicy.md) was enabled when the data was ingested. Otherwise, this function produces null values.\r\n\r\n> [!NOTE]\r\n> The value returned by this function is only approximate, as the ingestion process may take several minutes to complete and multiple ingestion activities may take place concurrently. To process all records of a table with exactly-once guarantees, use [database cursors](../management/databasecursor.md).\r\n\r\n> [!TIP] \r\n> The ingestion_time() function returns values according to the service clock as measured when ingestion was completed. As a result, this value cannot be used to "order" ingestion operations, as two operations that overlap in time might have any ordering of these values. If ordering records is important for application semantics, one should ensure that the htable has a timestamp column as measured by the source of the data instead of relying on the ingestion_time() value.\r\n\r\n## Syntax\r\n\r\n`ingestion_time()`\r\n\r\n## Returns\r\n\r\nA `datetime` value specifying the approximate time of ingestion into a table.',"```\r\nT\r\n| extend ingestionTime = ingestion_time() | top 10 by ingestionTime\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/ingestiontimefunction","ingestiontimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"invoke","Invokes lambda that receives the source of `invoke` as tabular parameter argument.","```\r\nT | invoke foo(param1, param2)\r\n```\r\n\r\n> [!NOTE]\r\n> See [let statements](./letstatement.md) for more details on how to declare lambda expressions that can accept tabular arguments.\r\n\r\n## Syntax\r\n\r\n`T | invoke` *function*`(`[*param1*`,` *param2*]`)`\r\n\r\n## Arguments\r\n\r\n* *T*: The tabular source.\r\n* *function*: The name of the lambda expression or function name to be evaluated.\r\n* *param1*, *param2* ... : additional lambda arguments.\r\n\r\n## Returns\r\n\r\nReturns the result of the evaluated expression.","The following example shows how to use `invoke` operator to call lambda expression:\r\n\r\n```\r\n// clipped_average(): calculates percentiles limits, and then makes another \r\n//                    pass over the data to calculate average with values inside the percentiles\r\nlet clipped_average = (T:(x: long), lowPercentile:double, upPercentile:double)\r\n{\r\n   let high = toscalar(T | summarize percentiles(x, upPercentile));\r\n   let low = toscalar(T | summarize percentiles(x, lowPercentile));\r\n   T \r\n   | where x > low and x < high\r\n   | summarize avg(x) \r\n};\r\nrange x from 1 to 100 step 1\r\n| invoke clipped_average(5, 99)\r\n```\r\n\r\n|avg_x|\r\n|---|\r\n|52|","https://docs.microsoft.com/azure/data-explorer/kusto/query/invokeoperator","invokeoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv4_compare","Compares two IPv4 strings. The two IPv4 strings are parsed and compared while accounting for the combined IP-prefix mask calculated from argument prefixes, and the optional `PrefixMask` argument.","```\r\nipv4_compare(\"127.0.0.1\", \"127.0.0.1\") == 0\r\nipv4_compare('192.168.1.1', '192.168.1.255') < 0\r\nipv4_compare('192.168.1.1/24', '192.168.1.255/24') == 0\r\nipv4_compare('192.168.1.1', '192.168.1.255', 24) == 0\r\n```\r\n\r\n## Syntax\r\n\r\n`ipv4_compare(`*Expr1*`, `*Expr2*`[ ,`*PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *Expr1*, *Expr2*: A string expression representing an IPv4 address. IPv4 strings can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n* *PrefixMask*: An integer from 0 to 32 representing the number of most-significant bits that are taken into account.\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 32) to the RIGHT of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, 192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\n* `0`: If the long representation of the first IPv4 string argument is equal to the second IPv4 string argument\r\n* `1`: If the long representation of the first IPv4 string argument is greater than the second IPv4 string argument\r\n* `-1`: If the long representation of the first IPv4 string argument is less than the second IPv4 string argument\r\n* `null`: If conversion for one of the two IPv4 strings wasn't successful.\r\n\r\n## Examples: IPv4 comparison equality cases\r\n\r\n### Compare IPs using the IP-prefix notation specified inside the IPv4 strings\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string)\r\n[\r\n '192.168.1.0',    '192.168.1.0',       // Equal IPs\r\n '192.168.1.1/24', '192.168.1.255',     // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255/24',  // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1/30', '192.168.1.255/24',  // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv4_compare(ip1_string, ip2_string)\r\n```\r\n\r\n|ip1_string|ip2_string|result|\r\n|---|---|---|\r\n|192.168.1.0|192.168.1.0|0|\r\n|192.168.1.1/24|192.168.1.255|0|\r\n|192.168.1.1|192.168.1.255/24|0|\r\n|192.168.1.1/30|192.168.1.255/24|0|\r\n\r\n### Compare IPs using IP-prefix notation specified inside the IPv4 strings and as additional argument of the `ipv4_compare()` function\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string, prefix:long)\r\n[\r\n '192.168.1.1',    '192.168.1.0',   31, // 31 bit IP-prefix is used for comparison\r\n '192.168.1.1/24', '192.168.1.255', 31, // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255', 24, // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv4_compare(ip1_string, ip2_string, prefix)\r\n```\r\n\r\n|ip1_string|ip2_string|prefix|result|\r\n|---|---|---|---|\r\n|192.168.1.1|192.168.1.0|31|0|\r\n|192.168.1.1/24|192.168.1.255|31|0|\r\n|192.168.1.1|192.168.1.255|24|0|","","https://docs.microsoft.com/azure/data-explorer/kusto/query/ipv4-comparefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv4_is_in_any_range","Checks whether IPv4 string address is in any of the specified IPv4 address ranges.","```\r\nipv4_is_in_any_range(\"127.0.0.1\", dynamic([\"127.0.0.1\", \"192.168.1.1\"])) == true\r\nipv4_is_in_any_range('192.168.1.6', '192.168.1.1/24', '10.0.0.1/8', '127.1.0.1/16') == true\r\nipv4_is_in_any_range('192.168.1.1', '192.168.2.1/24', '10.0.0.1/8', '127.1.0.1/16') == false\r\n```\r\n\r\n## Syntax\r\n\r\n`ipv4_is_in_any_range(`*Ipv4Address* `,` *Ipv4Range* [ `,` *Ipv4Range* ...] `)`\r\n\r\n`ipv4_is_in_any_range(`*Ipv4Address* `,` *Ipv4Ranges* `)`\r\n\r\n## Arguments\r\n\r\n* *Ipv4Address*: A string expression representing an IPv4 address.\r\n* *Ipv4Range*: A string expression representing an IPv4 range using [IP-prefix notation](#ip-prefix-notation).\r\n* *Ipv4Ranges*: A dynamic array containing IPv4 ranges using [IP-prefix notation](#ip-prefix-notation).\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character. The IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 32) to the RIGHT of the slash (`/`) is the number of contiguous 1 bit in the netmask.\r\n\r\nFor example, 192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\n* `true`: If the IPv4 address is in the range of any of the specified IPv4 networks.\r\n* `false`: Otherwise.\r\n* `null`: If conversion for one of the two IPv4 strings wasn't successful.",'### IPv4 range check\r\n\r\n```\r\nlet LocalNetworks=dynamic([\r\n    "192.168.1.1/16",\r\n    "127.0.0.1/8",\r\n    "10.0.0.1/8"\r\n]);\r\nlet IPs=datatable(IP:string) [\r\n    "10.1.2.3",\r\n    "192.168.1.5",\r\n    "123.1.11.21",\r\n    "1.1.1.1"\r\n];\r\nIPs\r\n| extend IsLocal=ipv4_is_in_any_range(IP, LocalNetworks)\r\n```\r\n\r\n|IP|IsLocal|\r\n|---|---|\r\n|10.1.2.3|1|\r\n|192.168.1.5|1|\r\n|123.1.11.21|0|\r\n|1.1.1.1|0|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/ipv4-is-in-any-range-function","ipv4-is-in-any-range-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv4_is_in_range","Checks if IPv4 string address is in IPv4-prefix notation range.","```\r\nipv4_is_in_range(\"127.0.0.1\", \"127.0.0.1\") == true\r\nipv4_is_in_range('192.168.1.6', '192.168.1.1/24') == true\r\nipv4_is_in_range('192.168.1.1', '192.168.2.1/24') == false\r\n```\r\n\r\n## Syntax\r\n\r\n`ipv4_is_in_range(`*Ipv4Address*`, `*Ipv4Range*`)`\r\n\r\n## Arguments\r\n\r\n* *Ipv4Address*: A string expression representing an IPv4 address. \r\n* *Ipv4Range*: A string expression representing an IPv4 range using [IP-prefix notation](#ip-prefix-notation).\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character. The IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 32) to the RIGHT of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, 192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\n* `true`: If the long representation of the first IPv4 string argument is in range of the second IPv4 string argument.\r\n* `false`: Otherwise.\r\n* `null`: If conversion for one of the two IPv4 strings wasn't successful.","### IPv4 range check\r\n\r\n```\r\ndatatable(ip_address:string, ip_range:string)\r\n[\r\n '192.168.1.1',    '192.168.1.1',       // Equal IPs\r\n '192.168.1.1',    '192.168.1.255/24',  // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv4_is_in_range(ip_address, ip_range)\r\n```\r\n\r\n|ip_address|ip_range|result|\r\n|---|---|---|\r\n|192.168.1.1|192.168.1.1|1|\r\n|192.168.1.1|192.168.1.255/24|1|","https://docs.microsoft.com/azure/data-explorer/kusto/query/ipv4-is-in-range-function","ipv4-is-in-range-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv4_is_match","Matches two IPv4 strings. The two IPv4 strings are parsed and compared while accounting for the combined IP-prefix mask calculated from argument prefixes, and the optional `PrefixMask` argument.","```\r\nipv4_is_match(\"127.0.0.1\", \"127.0.0.1\") == true\r\nipv4_is_match('192.168.1.1', '192.168.1.255') == false\r\nipv4_is_match('192.168.1.1/24', '192.168.1.255/24') == true\r\nipv4_is_match('192.168.1.1', '192.168.1.255', 24) == true\r\n```\r\n\r\n## Syntax\r\n\r\n`ipv4_is_match(`*Expr1*`, `*Expr2*`[ ,`*PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *Expr1*, *Expr2*: A string expression representing an IPv4 address. IPv4 strings can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n* *PrefixMask*: An integer from 0 to 32 representing the number of most-significant bits that are taken into account.\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character. The IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 32) to the RIGHT of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, 192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\n* `true`: If the long representation of the first IPv4 string argument is equal to the second IPv4 string argument.\r\n*  `false`: Otherwise.\r\n* `null`: If conversion for one of the two IPv4 strings wasn't successful.","### IPv4 comparison equality - IP-prefix notation specified inside the IPv4 strings\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string)\r\n[\r\n '192.168.1.0',    '192.168.1.0',       // Equal IPs\r\n '192.168.1.1/24', '192.168.1.255',     // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255/24',  // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1/30', '192.168.1.255/24',  // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv4_is_match(ip1_string, ip2_string)\r\n```\r\n\r\n|ip1_string|ip2_string|result|\r\n|---|---|---|\r\n|192.168.1.0|192.168.1.0|1|\r\n|192.168.1.1/24|192.168.1.255|1|\r\n|192.168.1.1|192.168.1.255/24|1|\r\n|192.168.1.1/30|192.168.1.255/24|1|\r\n\r\n### IPv4 comparison equality - IP-prefix notation specified inside the IPv4 strings and an additional argument of the `ipv4_is_match()` function\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string, prefix:long)\r\n[\r\n '192.168.1.1',    '192.168.1.0',   31, // 31 bit IP-prefix is used for comparison\r\n '192.168.1.1/24', '192.168.1.255', 31, // 24 bit IP-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255', 24, // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv4_is_match(ip1_string, ip2_string, prefix)\r\n```\r\n\r\n|ip1_string|ip2_string|prefix|result|\r\n|---|---|---|---|\r\n|192.168.1.1|192.168.1.0|31|1|\r\n|192.168.1.1/24|192.168.1.255|31|1|\r\n|192.168.1.1|192.168.1.255|24|1|","https://docs.microsoft.com/azure/data-explorer/kusto/query/ipv4-is-matchfunction","ipv4-is-matchfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv4_is_private","Checks if IPv4 string address belongs to a set of private network IPs.","[Private network addresses](https://en.wikipedia.org/wiki/Private_network) were originally defined to assist in delaying IPv4 address exhaustion. IP packets originating from or addressed to a private IP address cannot be routed through the public internet.\r\n\r\n## Private IPv4 addresses\r\n\r\nThe Internet Engineering Task Force (IETF) has directed the Internet Assigned Numbers Authority (IANA) to reserve the following IPv4 address ranges for private networks:\r\n\r\n| IP address range|Number of addresses|Largest CIDR block (subnet mask)|\r\n|-----------------|-------------------|--------------------------------|\r\n|10.0.0.0 \u2013 10.255.255.255|16777216|10.0.0.0/8 (255.0.0.0)|\r\n|172.16.0.0 \u2013 172.31.255.255|1048576|172.16.0.0/12 (255.240.0.0)|\r\n|192.168.0.0 \u2013 192.168.255.255|65536|192.168.0.0/16 (255.255.0.0)|\r\n\r\n```\r\nipv4_is_private('192.168.1.1/24') == true\r\nipv4_is_private('10.1.2.3/24') == true\r\nipv4_is_private('202.1.2.3') == false\r\nipv4_is_private(\"127.0.0.1\") == false\r\n```\r\n\r\n## Syntax\r\n\r\n`ipv4_is_private(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n*Expr*: A string expression representing an IPv4 address. IPv4 strings can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n\r\n### IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character. The IP address to the left of the slash (`/`) is the base IP address. The number (1 to 32) to the right of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, 192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\n* `true`: If the IPv4 address belongs to any of the private network ranges.\r\n* `false`: Otherwise.\r\n* `null`: If parsing of the input as IPv4 address string wasn't successful.\r\n\r\n## Example: Check if IPv4 belongs to a private network\r\n\r\n```\r\ndatatable(ip_string:string)\r\n[\r\n '10.1.2.3',\r\n '192.168.1.1/24',\r\n '127.0.0.1',\r\n]\r\n| extend result = ipv4_is_private(ip_string)\r\n```\r\n\r\n|ip_string|result|\r\n|---|---|\r\n|10.1.2.3|1|\r\n|192.168.1.1/24|1|\r\n|127.0.0.1|0|","","https://docs.microsoft.com/azure/data-explorer/kusto/query/ipv4-is-privatefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv4_lookup","The `ipv4_lookup` plugin looks up an IPv4 value in a lookup table and returns rows with matched values. The plugin is invoked with the [`evaluate`](evaluateoperator.md) operator.","```\r\nT | evaluate ipv4_lookup(LookupTable, SourceIPv4Key, IPv4LookupKey)\r\nT | evaluate ipv4_lookup(LookupTable, SourceIPv4Key, IPv4LookupKey, return_unmatched = true)\r\nT | evaluate ipv4_lookup(LookupTable, SourceIPv4Key, IPv4LookupKey, ExtraKey1, ExtraKey2, return_unmatched = true)\r\n```\r\n\r\n## Syntax\r\n\r\n*T* `|` `evaluate` `ipv4_lookup(` *LookupTable* `,` *SourceIPv4Key* `,` *IPv4LookupKey* [`,` *ExtraKey1* [.. `,` *ExtraKeyN* [`,` *return_unmatched* ]]] `)`\r\n\r\n## Arguments\r\n\r\n* *T*: The tabular input whose column *SourceIPv4Key* will be used for IPv4 matching.\r\n* *LookupTable*: Table or tabular expression with IPv4 lookup data, whose column *LookupKey* will be used for IPv4 matching. IPv4 values can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n* *SourceIPv4Key*: The column of *T* with IPv4 string to be looked up in *LookupTable*. IPv4 values can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n* *IPv4LookupKey*: The column of *LookupTable* with IPv4 string that is matched against each *SourceIPv4Key* value.\r\n* *ExtraKey1* .. *ExtraKeyN*: (Optional) Additional column references that are used for lookup matches. Similar to `join` operation: records with equal values will be considered matching. Column name references must exist both is source table `T` and `LookupTable`.\r\n* *return_unmatched*: A boolean flag that defines if the result should include all or only matching rows (default: `false` - only matching rows returned).\r\n\r\n### IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the left of the slash (`/`) is the base IP address. The number (1 to 32) to the right of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, 192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\nThe `ipv4_lookup` plugin returns a result of join (lookup) based on IPv4 key. The schema of the table is the union of the source table and the lookup table, similar to the result of the [`lookup` operator](lookupoperator.md).\r\n\r\nIf the *return_unmatched* argument is set to `true`, the resulting table will include both matched and unmatched rows (filled with nulls).\r\n\r\nIf the *return_unmatched* argument is set to `false`, or omitted (the default value of `false` is used), the resulting table will have as many records as matching results. This variant of lookup has better performance compared to `return_unmatched=true` execution.\r\n\r\n> [!NOTE]\r\n> * This plugin covers the scenario of IPv4-based join, assuming a small lookup table size (100K-200K rows), with the input table optionally having a larger size.\r\n> * The performance of the plugin will depend on the sizes of the lookup and data source tables, the number of columns, and number of matching records.",'### IPv4 lookup - matching rows only\r\n\r\n```\r\n// IP lookup table: IP_Data\r\n// Partial data from: https://raw.githubusercontent.com/datasets/geoip2-ipv4/master/data/geoip2-ipv4.csv\r\nlet IP_Data = datatable(network:string, continent_code:string ,continent_name:string, country_iso_code:string, country_name:string)\r\n[\r\n  "111.68.128.0/17","AS","Asia","JP","Japan",\r\n  "5.8.0.0/19","EU","Europe","RU","Russia",\r\n  "223.255.254.0/24","AS","Asia","SG","Singapore",\r\n  "46.36.200.51/32","OC","Oceania","CK","Cook Islands",\r\n  "2.20.183.0/24","EU","Europe","GB","United Kingdom",\r\n];\r\nlet IPs = datatable(ip:string)\r\n[\r\n  \'2.20.183.12\',   // United Kingdom\r\n  \'5.8.1.2\',       // Russia\r\n  \'192.165.12.17\', // Unknown\r\n];\r\nIPs\r\n| evaluate ipv4_lookup(IP_Data, ip, network)\r\n```\r\n\r\n|ip|network|continent_code|continent_name|country_iso_code|country_name|\r\n|---|---|---|---|---|---|\r\n|2.20.183.12|2.20.183.0/24|EU|Europe|GB|United Kingdom|\r\n|5.8.1.2|5.8.0.0/19|EU|Europe|RU|Russia|\r\n\r\n### IPv4 lookup - return both matching and non-matching rows\r\n\r\n```\r\n// IP lookup table: IP_Data\r\n// Partial data from: \r\n// https://raw.githubusercontent.com/datasets/geoip2-ipv4/master/data/geoip2-ipv4.csv\r\nlet IP_Data = datatable(network:string,continent_code:string ,continent_name:string ,country_iso_code:string ,country_name:string )\r\n[\r\n    "111.68.128.0/17","AS","Asia","JP","Japan",\r\n    "5.8.0.0/19","EU","Europe","RU","Russia",\r\n    "223.255.254.0/24","AS","Asia","SG","Singapore",\r\n    "46.36.200.51/32","OC","Oceania","CK","Cook Islands",\r\n    "2.20.183.0/24","EU","Europe","GB","United Kingdom",\r\n];\r\nlet IPs = datatable(ip:string)\r\n[\r\n    \'2.20.183.12\',   // United Kingdom\r\n    \'5.8.1.2\',       // Russia\r\n    \'192.165.12.17\', // Unknown\r\n];\r\nIPs\r\n| evaluate ipv4_lookup(IP_Data, ip, network, return_unmatched = true)\r\n```\r\n\r\n|ip|network|continent_code|continent_name|country_iso_code|country_name|\r\n|---|---|---|---|---|---|\r\n|2.20.183.12|2.20.183.0/24|EU|Europe|GB|United Kingdom|\r\n|5.8.1.2|5.8.0.0/19|EU|Europe|RU|Russia|\r\n|192.165.12.17||||||\r\n\r\n### IPv4 lookup - using source in external_data()\r\n\r\n```\r\nlet IP_Data = external_data(network:string,geoname_id:long,continent_code:string,continent_name:string ,country_iso_code:string,country_name:string,is_anonymous_proxy:bool,is_satellite_provider:bool)\r\n    [\'https://raw.githubusercontent.com/datasets/geoip2-ipv4/master/data/geoip2-ipv4.csv\'];\r\nlet IPs = datatable(ip:string)\r\n[\r\n    \'2.20.183.12\',   // United Kingdom\r\n    \'5.8.1.2\',       // Russia\r\n    \'192.165.12.17\', // Sweden\r\n];\r\nIPs\r\n| evaluate ipv4_lookup(IP_Data, ip, network, return_unmatched = true)\r\n```\r\n\r\n|ip|network|geoname_id|continent_code|continent_name|country_iso_code|country_name|is_anonymous_proxy|is_satellite_provider|\r\n|---|---|---|---|---|---|---|---|---|\r\n|2.20.183.12|2.20.183.0/24|2635167|EU|Europe|GB|United Kingdom|0|0|\r\n|5.8.1.2|5.8.0.0/19|2017370|EU|Europe|RU|Russia|0|0|\r\n|192.165.12.17|192.165.8.0/21|2661886|EU|Europe|SE|Sweden|0|0|\r\n\r\n### IPv4 lookup - using extra columns for matching\r\n\r\n```\r\nlet IP_Data = external_data(network:string,geoname_id:long,continent_code:string,continent_name:string ,country_iso_code:string,country_name:string,is_anonymous_proxy:bool,is_satellite_provider:bool)\r\n    [\'https://raw.githubusercontent.com/datasets/geoip2-ipv4/master/data/geoip2-ipv4.csv\'];\r\nlet IPs = datatable(ip:string, continent_name:string, country_iso_code:string)\r\n[\r\n    \'2.20.183.12\',   \'Europe\', \'GB\', // United Kingdom\r\n    \'5.8.1.2\',       \'Europe\', \'RU\', // Russia\r\n    \'192.165.12.17\', \'Europe\', \'\',   // Sweden is \'SE\' - so it won\'t be matched\r\n];\r\nIPs\r\n| evaluate ipv4_lookup(IP_Data, ip, network, continent_name, country_iso_code)\r\n```\r\n\r\n|ip|continent_name|country_iso_code|network|geoname_id|continent_code|country_name|is_anonymous_proxy|is_satellite_provider|\r\n|---|---|---|---|---|---|---|---|---|\r\n|2.20.183.12|Europe|GB|2.20.183.0/24|2635167|EU|United Kingdom|0|0|\r\n|5.8.1.2|Europe|RU|5.8.0.0/19|2017370|EU|Russia|0|0|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/ipv4-lookup-plugin","ipv4-lookup-plugin.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv4_netmask_suffix","Returns the value of the IPv4 netmask suffix from IPv4 string address.","```\r\nipv4_netmask_suffix('192.168.1.1/24') == 24\r\nipv4_netmask_suffix('192.168.1.1') == 32\r\n```\r\n\r\n## Syntax\r\n\r\n`ipv4_netmask_suffix(`*Expr*`)`\r\n\r\n## Arguments\r\n\r\n*Expr*: A string expression representing an IPv4 address. IPv4 strings can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n\r\n### IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character. The IP address to the left of the slash (`/`) is the base IP address. The number (1 to 32) to the right of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, 192.168.2.0/24 will have an associated net/subnetmask containing 24 contiguous bits or 255.255.255.0 in dotted decimal format.\r\n\r\n## Returns\r\n\r\n* The value of the netmask suffix the IPv4 address. If suffix is not present in the input, a value of `32` (full netmask suffix) is returned.\r\n* `null`: If parsing of the input as IPv4 address string wasn't successful.\r\n\r\n## Example: Resolve IPv4 mask suffix\r\n\r\n```\r\ndatatable(ip_string:string)\r\n[\r\n '10.1.2.3',\r\n '192.168.1.1/24',\r\n '127.0.0.1/16',\r\n]\r\n| extend cidr_suffix = ipv4_netmask_suffix(ip_string)\r\n```\r\n\r\n|ip_string|cidr_suffix|\r\n|---|---|\r\n|10.1.2.3|32|\r\n|192.168.1.1/24|24|\r\n|127.0.0.1/16|16|","","https://docs.microsoft.com/azure/data-explorer/kusto/query/ipv4-netmask-suffix-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv6_compare","Compares two IPv6 or IPv4 network address strings. The two IPv6 strings are parsed and compared while accounting for the combined IP-prefix mask calculated from argument prefixes, and the optional `PrefixMask` argument.","```\r\nipv6_compare('::ffff:7f00:1', '127.0.0.1') == 0\r\nipv6_compare('fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995')  < 0\r\nipv6_compare('192.168.1.1/24', '192.168.1.255/24') == 0\r\nipv6_compare('fe80::85d:e82c:9446:7994/127', 'fe80::85d:e82c:9446:7995/127') == 0\r\nipv6_compare('fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995', 127) == 0\r\n```\r\n\r\n> [!Note]\r\n> The function can accept and compare arguments representing both IPv6 and IPv4 network addresses. However, if the caller knows that arguments are in IPv4 format, use [ipv4_is_compare()](./ipv4-comparefunction.md) function. This function will result in better runtime performance.\r\n\r\n## Syntax\r\n\r\n`ipv6_compare(`*Expr1*`, `*Expr2*`[ ,`*PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *Expr1*, *Expr2*: A string expression representing an IPv6 or IPv4 address. IPv6 and IPv4 strings can be masked using IP-prefix notation (see note).\r\n* *PrefixMask*: An integer from 0 to 128 representing the number of most significant bits that are taken into account.\r\n\r\n## IP-prefix notation\r\n\r\nIt's common practice to define IP addresses with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the LEFT of the slash (`/`) is the base IP address, and the number (1 to 127) to the RIGHT of the slash (`/`) is the number of contiguous 1 bits in the netmask. \r\n\r\nFor example, fe80::85d:e82c:9446:7994/120 will have an associated net/subnetmask containing 120 contiguous bits.\r\n\r\n## Returns\r\n\r\n* `0`: If the long representation of the first IPv6 string argument is equal to the second IPv6 string argument.\r\n* `1`: If the long representation of the first IPv6 string argument is greater than the second IPv6 string argument.\r\n* `-1`: If the long representation of the first IPv6 string argument is less than the second IPv6 string argument.\r\n* `null`: If conversion for one of the two IPv6 strings wasn't successful.\r\n\r\n## Examples: IPv6/IPv4 comparison equality cases\r\n\r\n### Compare IPs using the IP-prefix notation specified inside the IPv6/IPv4 strings\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string)\r\n[\r\n // IPv4 are compared as IPv6 addresses\r\n '192.168.1.1',    '192.168.1.1',       // Equal IPs\r\n '192.168.1.1/24', '192.168.1.255',     // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255/24',  // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1/30', '192.168.1.255/24',  // 24 bit IP4-prefix is used for comparison\r\n  // IPv6 cases\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7994',         // Equal IPs\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998',     // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7998/120',     // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998/120', // 120 bit IP6-prefix is used for comparison\r\n // Mixed case of IPv4 and IPv6\r\n '192.168.1.1',      '::ffff:c0a8:0101', // Equal IPs\r\n '192.168.1.1/24',   '::ffff:c0a8:01ff', // 24 bit IP-prefix is used for comparison\r\n '::ffff:c0a8:0101', '192.168.1.255/24', // 24 bit IP-prefix is used for comparison\r\n '::192.168.1.1/30', '192.168.1.255/24', // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv6_compare(ip1_string, ip2_string)\r\n```\r\n\r\n|ip1_string|ip2_string|result|\r\n|---|---|---|\r\n|192.168.1.1|192.168.1.1|0|\r\n|192.168.1.1/24|192.168.1.255|0|\r\n|192.168.1.1|192.168.1.255/24|0|\r\n|192.168.1.1/30|192.168.1.255/24|0|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7994|0|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998|0|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7998/120|0|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998/120|0|\r\n|192.168.1.1|::ffff:c0a8:0101|0|\r\n|192.168.1.1/24|::ffff:c0a8:01ff|0|\r\n|::ffff:c0a8:0101|192.168.1.255/24|0|\r\n|::192.168.1.1/30|192.168.1.255/24|0|\r\n\r\n### Compare IPs using IP-prefix notation specified inside the IPv6/IPv4 strings and as additional argument of the `ipv6_compare()` function\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string, prefix:long)\r\n[\r\n // IPv4 are compared as IPv6 addresses \r\n '192.168.1.1',    '192.168.1.0',   31, // 31 bit IP4-prefix is used for comparison\r\n '192.168.1.1/24', '192.168.1.255', 31, // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255', 24, // 24 bit IP4-prefix is used for comparison\r\n   // IPv6 cases\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995',     127, // 127 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/127', 'fe80::85d:e82c:9446:7998', 120, // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998', 127, // 120 bit IP6-prefix is used for comparison\r\n // Mixed case of IPv4 and IPv6\r\n '192.168.1.1/24',   '::ffff:c0a8:01ff', 127, // 127 bit IP6-prefix is used for comparison\r\n '::ffff:c0a8:0101', '192.168.1.255',    120, // 120 bit IP6-prefix is used for comparison\r\n '::192.168.1.1/30', '192.168.1.255/24', 127, // 120 bit IP6-prefix is used for comparison\r\n]\r\n| extend result = ipv6_compare(ip1_string, ip2_string, prefix)\r\n```\r\n\r\n|ip1_string|ip2_string|prefix|result|\r\n|---|---|---|---|\r\n|192.168.1.1|192.168.1.0|31|0|\r\n|192.168.1.1/24|192.168.1.255|31|0|\r\n|192.168.1.1|192.168.1.255|24|0|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7995|127|0|\r\n|fe80::85d:e82c:9446:7994/127|fe80::85d:e82c:9446:7998|120|0|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998|127|0|\r\n|192.168.1.1/24|::ffff:c0a8:01ff|127|0|\r\n|::ffff:c0a8:0101|192.168.1.255|120|0|\r\n|::192.168.1.1/30|192.168.1.255/24|127|0|","","https://docs.microsoft.com/azure/data-explorer/kusto/query/ipv6-comparefunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"ipv6_is_match","Matches two IPv6 or IPv4 network address strings. The two IPv6/IPv4 strings are parsed and compared while accounting for the combined IP-prefix mask calculated from argument prefixes, and the optional `PrefixMask` argument.","```\r\nipv6_is_match('::ffff:7f00:1', '127.0.0.1') == true\r\nipv6_is_match('fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995') == false\r\nipv6_is_match('192.168.1.1/24', '192.168.1.255/24') == true\r\nipv6_is_match('fe80::85d:e82c:9446:7994/127', 'fe80::85d:e82c:9446:7995/127') == true\r\nipv6_is_match('fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995', 127) == true\r\n```\r\n\r\n> [!NOTE]\r\n> The function can accept and compare arguments representing both IPv6 and IPv4 network addresses. If the caller knows that arguments are in IPv4 format, use the [ipv4_is_match()](./ipv4-is-matchfunction.md) function. This function will result in better runtime performance.\r\n\r\n## Syntax\r\n\r\n`ipv6_is_match(`*Expr1*`, `*Expr2*`[ ,`*PrefixMask*`])`\r\n\r\n## Arguments\r\n\r\n* *Expr1*, *Expr2*: A string expression representing an IPv6 or IPv4 address. IPv6 and IPv4 strings can be masked using [IP-prefix notation](#ip-prefix-notation).\r\n* *PrefixMask*: An integer from 0 to 128 representing the number of most-significant bits that are taken into account.\r\n\r\n## IP-prefix notation\r\n\r\nIP addresses can be defined with `IP-prefix notation` using a slash (`/`) character.\r\nThe IP address to the LEFT of the slash (`/`) is the base IP address. The number (1 to 127) to the RIGHT of the slash (`/`) is the number of contiguous 1 bit in the netmask. \r\n\r\nFor example, fe80::85d:e82c:9446:7994/120 will have an associated net/subnetmask containing 120 contiguous bits.\r\n\r\n## Returns\r\n\r\n* `true`: If the long representation of the first IPv6/IPv4 string argument is equal to the second IPv6/IPv4 string argument.\r\n* `false`: Otherwise.\r\n* `null`: If conversion for one of the two IPv6/IPv4 strings wasn't successful.","### IPv6/IPv4 comparison equality case - IP-prefix notation specified inside the IPv6/IPv4 strings\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string)\r\n[\r\n // IPv4 are compared as IPv6 addresses\r\n '192.168.1.1',    '192.168.1.1',       // Equal IPs\r\n '192.168.1.1/24', '192.168.1.255',     // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255/24',  // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1/30', '192.168.1.255/24',  // 24 bit IP4-prefix is used for comparison\r\n  // IPv6 cases\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7994',         // Equal IPs\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998',     // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7998/120',     // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998/120', // 120 bit IP6-prefix is used for comparison\r\n // Mixed case of IPv4 and IPv6\r\n '192.168.1.1',      '::ffff:c0a8:0101', // Equal IPs\r\n '192.168.1.1/24',   '::ffff:c0a8:01ff', // 24 bit IP-prefix is used for comparison\r\n '::ffff:c0a8:0101', '192.168.1.255/24', // 24 bit IP-prefix is used for comparison\r\n '::192.168.1.1/30', '192.168.1.255/24', // 24 bit IP-prefix is used for comparison\r\n]\r\n| extend result = ipv6_is_match(ip1_string, ip2_string)\r\n```\r\n\r\n|ip1_string|ip2_string|result|\r\n|---|---|---|\r\n|192.168.1.1|192.168.1.1|1|\r\n|192.168.1.1/24|192.168.1.255|1|\r\n|192.168.1.1|192.168.1.255/24|1|\r\n|192.168.1.1/30|192.168.1.255/24|1|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7994|1|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998|1|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7998/120|1|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998/120|1|\r\n|192.168.1.1|::ffff:c0a8:0101|1|\r\n|192.168.1.1/24|::ffff:c0a8:01ff|1|\r\n|::ffff:c0a8:0101|192.168.1.255/24|1|\r\n|::192.168.1.1/30|192.168.1.255/24|1|\r\n\r\n### IPv6/IPv4 comparison equality case- IP-prefix notation specified inside the IPv6/IPv4 strings and as additional argument of the `ipv6_is_match()` function\r\n\r\n```\r\ndatatable(ip1_string:string, ip2_string:string, prefix:long)\r\n[\r\n // IPv4 are compared as IPv6 addresses \r\n '192.168.1.1',    '192.168.1.0',   31, // 31 bit IP4-prefix is used for comparison\r\n '192.168.1.1/24', '192.168.1.255', 31, // 24 bit IP4-prefix is used for comparison\r\n '192.168.1.1',    '192.168.1.255', 24, // 24 bit IP4-prefix is used for comparison\r\n   // IPv6 cases\r\n 'fe80::85d:e82c:9446:7994', 'fe80::85d:e82c:9446:7995',     127, // 127 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/127', 'fe80::85d:e82c:9446:7998', 120, // 120 bit IP6-prefix is used for comparison\r\n 'fe80::85d:e82c:9446:7994/120', 'fe80::85d:e82c:9446:7998', 127, // 120 bit IP6-prefix is used for comparison\r\n // Mixed case of IPv4 and IPv6\r\n '192.168.1.1/24',   '::ffff:c0a8:01ff', 127, // 127 bit IP6-prefix is used for comparison\r\n '::ffff:c0a8:0101', '192.168.1.255',    120, // 120 bit IP6-prefix is used for comparison\r\n '::192.168.1.1/30', '192.168.1.255/24', 127, // 120 bit IP6-prefix is used for comparison\r\n]\r\n| extend result = ipv6_is_match(ip1_string, ip2_string, prefix)\r\n```\r\n\r\n|ip1_string|ip2_string|prefix|result|\r\n|---|---|---|---|\r\n|192.168.1.1|192.168.1.0|31|1|\r\n|192.168.1.1/24|192.168.1.255|31|1|\r\n|192.168.1.1|192.168.1.255|24|1|\r\n|fe80::85d:e82c:9446:7994|fe80::85d:e82c:9446:7995|127|1|\r\n|fe80::85d:e82c:9446:7994/127|fe80::85d:e82c:9446:7998|120|1|\r\n|fe80::85d:e82c:9446:7994/120|fe80::85d:e82c:9446:7998|127|1|\r\n|192.168.1.1/24|::ffff:c0a8:01ff|127|1|\r\n|::ffff:c0a8:0101|192.168.1.255|120|1|\r\n|::192.168.1.1/30|192.168.1.255/24|127|1|","https://docs.microsoft.com/azure/data-explorer/kusto/query/ipv6-is-matchfunction","ipv6-is-matchfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isempty","Returns `true` if the argument is an empty string or is null.",'```\r\nisempty("") == true\r\n```\r\n\r\n## Syntax\r\n\r\n`isempty(`[*value*]`)`\r\n\r\n## Returns\r\n\r\nIndicates whether the argument is an empty string or isnull.\r\n\r\n|x|isempty(x)\r\n|---|---\r\n| "" | true\r\n|"x" | false\r\n|parsejson("")|true\r\n|parsejson("[]")|false\r\n|parsejson("{}")|false',"```\r\nT\r\n| where isempty(fieldName)\r\n| count\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/isemptyfunction","isemptyfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isfinite","Returns whether input is a finite value (is neither infinite nor NaN).","## Syntax\r\n\r\n`isfinite(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\nA non-zero value (true) if x is finite; and zero (false) otherwise.\r\n\r\n## See also\r\n\r\n* For checking if value is null, see [isnull()](isnullfunction.md).\r\n* For checking if value is infinite, see [isinf()](isinffunction.md).\r\n* For checking if value is NaN (Not-a-Number), see [isnan()](isnanfunction.md).","```\r\nrange x from -1 to 1 step 1\r\n| extend y = 0.0\r\n| extend div = 1.0*x/y\r\n| extend isfinite=isfinite(div)\r\n```\r\n\r\n|x|y|div|isfinite|\r\n|---|---|---|---|\r\n|-1|0|-\u221e|0|\r\n|0|0|NaN|0|\r\n|1|0|\u221e|0|","https://docs.microsoft.com/azure/data-explorer/kusto/query/isfinitefunction","isfinitefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isinf","Returns whether input is an infinite (positive or negative) value.","## Syntax\r\n\r\n`isinf(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\nA non-zero value (true) if x is a positive or negative infinite; and zero (false) otherwise.\r\n\r\n## See also\r\n\r\n* For checking if value is null, see [isnull()](isnullfunction.md).\r\n* For checking if value is finite, see [isfinite()](isfinitefunction.md).\r\n* For checking if value is NaN (Not-a-Number), see [isnan()](isnanfunction.md).","```\r\nrange x from -1 to 1 step 1\r\n| extend y = 0.0\r\n| extend div = 1.0*x/y\r\n| extend isinf=isinf(div)\r\n```\r\n\r\n|x|y|div|isinf|\r\n|---|---|---|---|\r\n|-1|0|-\u221e|1|\r\n|0|0|NaN|0|\r\n|1|0|\u221e|1|","https://docs.microsoft.com/azure/data-explorer/kusto/query/isinffunction","isinffunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isnan","Returns whether input is Not-a-Number (NaN) value.","## Syntax\r\n\r\n`isnan(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number.\r\n\r\n## Returns\r\n\r\nA non-zero value (true) if x is NaN; and zero (false) otherwise.\r\n\r\n## See also\r\n\r\n* For checking if value is null, see [isnull()](isnullfunction.md).\r\n* For checking if value is finite, see [isfinite()](isfinitefunction.md).\r\n* For checking if value is infinite, see [isinf()](isinffunction.md).","```\r\nrange x from -1 to 1 step 1\r\n| extend y = (-1*x) \r\n| extend div = 1.0*x/y\r\n| extend isnan=isnan(div)\r\n```\r\n\r\n|x|y|div|isnan|\r\n|---|---|---|---|\r\n|-1|1|-1|0|\r\n|0|0|NaN|1|\r\n|1|-1|-1|0|","https://docs.microsoft.com/azure/data-explorer/kusto/query/isnanfunction","isnanfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isnotempty","Returns `true` if the argument isn't an empty string, and it isn't null.",'```\r\nisnotempty("") == false\r\n```\r\n\r\n## Syntax\r\n\r\n`isnotempty(`[*value*]`)`\r\n\r\n`notempty(`[*value*]`)` -- alias of `isnotempty`',"```\r\nT\r\n| where isnotempty(fieldName)\r\n| count\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/isnotemptyfunction","isnotemptyfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isnotnull","Returns `true` if the argument is not null.","## Syntax\r\n\r\n`isnotnull(`[*value*]`)`\r\n\r\n`notnull(`[*value*]`)` - alias for `isnotnull`","```\r\nT | where isnotnull(PossiblyNull) | count\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/isnotnullfunction","isnotnullfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"isnull","Evaluates its sole argument and returns a `bool` value indicating if the argument evaluates to a null value.",'```\r\nisnull(parse_json("")) == true\r\n```\r\n\r\n## Syntax\r\n\r\n`isnull(`*Expr*`)`\r\n\r\n## Returns\r\n\r\nTrue or false, depending on whether or not the value is null.\r\n\r\n**Notes**\r\n\r\n* `string` values cannot be null. Use [isempty](./isemptyfunction.md)\r\n  to determine if a value of type `string` is empty or not.\r\n\r\n|x                |`isnull(x)`|\r\n|-----------------|-----------|\r\n|`""`             |`false`    |\r\n|`"x"`            |`false`    |\r\n|`parse_json("")`  |`true`     |\r\n|`parse_json("[]")`|`false`    |\r\n|`parse_json("{}")`|`false`    |',"```\r\nT | where isnull(PossiblyNull) | count\r\n```","https://docs.microsoft.com/azure/data-explorer/kusto/query/isnullfunction","isnullfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"jaccard_index","Calculates the [Jaccard index](https://en.wikipedia.org/wiki/Jaccard_index) of two sets","## Syntax\r\n\r\n`jaccard_index`(*set1*, *set2*)\r\n\r\n## Arguments\r\n\r\n* *set1*: Input array representing the first set for the calculation.\r\n* *set2*: Input array representing the second set for the calculation.\r\n\r\n> [!NOTE]\r\n> Duplicate values in the input arrays are ignored.\r\n\r\n## Returns\r\n\r\nThe [Jaccard index](https://en.wikipedia.org/wiki/Jaccard_index) of the two input sets. The Jaccard index formula is |*set1* \u2229 *set2*| / |*set1* \u222a *set2*|.","```\r\nprint set1=dynamic([1,2,3]), set2=dynamic([1,2,3,4])\r\n| extend jaccard=jaccard_index(set1, set2)\r\n```\r\n\r\n|`set1`|`set2`|`jaccard`|\r\n|---|---|---|\r\n|[1,2,3]|[1,2,3,4]|0.75|","https://docs.microsoft.com/azure/data-explorer/kusto/query/jaccard-index-function","jaccard-index-function.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"join","Merge the rows of two tables to form a new table by matching values of the specified columns from each table.","```\r\nTable1 | join (Table2) on CommonColumn, $left.Col1 == $right.Col2\r\n```\r\n\r\n## Syntax\r\n\r\n*LeftTable* `|` `join` [*JoinParameters*] `(` *RightTable* `)` `on` *Attributes*\r\n\r\n## Arguments\r\n\r\n* *LeftTable*: The **left** table or tabular expression, sometimes called **outer** table, whose rows are to be merged. Denoted as `$left`.\r\n* *RightTable*: The **right** table or tabular expression, sometimes called **inner** table, whose rows are to be merged. Denoted as `$right`.\r\n* *Attributes*: One or more comma-separated **rules** that describe how rows from\r\n  *LeftTable* are matched to rows from *RightTable*. Multiple rules are evaluated using the `and` logical operator.\r\n  A **rule** can be one of:\r\n  |Rule kind        |Syntax          |Predicate    |\r\n  |-----------------|--------------|-------------------------|\r\n  |Equality by name |*ColumnName*    |`where` *LeftTable*.*ColumnName* `==` *RightTable*.*ColumnName*|\r\n  |Equality by value|`$left.`*LeftColumn* `==` `$right.`*RightColumn*|`where` `$left.`*LeftColumn* `==` `$right.`*RightColumn*       |\r\n    > [!NOTE]\r\n    > For 'equality by value', the column names *must* be qualified with the applicable owner table denoted by `$left` and `$right` notations.\r\n* *JoinParameters*: Zero or more space-separated parameters in the form of *Name* `=` *Value* that control the behavior of the row-match operation and execution plan. The following parameters are supported:\r\n\r\n    |Parameters name |Values |Description  |\r\n    |---|---|---|\r\n    |`kind`|Join flavors|See [Join Flavors](#join-flavors)|\r\n    |`hint.remote`  |`auto`, `left`, `local`, `right` |See [Cross-Cluster Join](joincrosscluster.md)|\r\n    |`hint.strategy=broadcast` |Specifies the way to share the query load on cluster nodes. |See [broadcast join](broadcastjoin.md) |\r\n    |`hint.shufflekey=<key>` |The `shufflekey` query shares the query load on cluster nodes, using a key to partition data. |See [shuffle query](shufflequery.md) |\r\n    |`hint.strategy=shuffle` |The `shuffle` strategy query shares the query load on cluster nodes, where each node will process one partition of the data. |See [shuffle query](shufflequery.md)  |\r\n\r\n\r\n> [!WARNING]\r\n> If `kind` isn't specified, the default join flavor is `innerunique`. This is different than some other analytics products that have `inner` as the default flavor.  See [join-flavors](#join-flavors) to understand the differences and make sure  the query yields the intended results.\r\n\r\n## Returns\r\n\r\n**The output schema depends on the join flavor:**\r\n\r\n| Join flavor | Output schema |\r\n|---|---|\r\n|`kind=leftanti`, `kind=leftsemi`| The result table contains columns from the left side only.|\r\n| `kind=rightanti`, `kind=rightsemi` | The result table contains columns from the right side only.|\r\n|  `kind=innerunique`, `kind=inner`, `kind=leftouter`, `kind=rightouter`, `kind=fullouter` |  A column for every column in each of the two tables, including the matching keys. The columns of the right side will be automatically renamed if there are name clashes. |\r\n\r\n**Output records depend on the join flavor:**\r\n\r\n> [!NOTE]\r\n   >\r\n   > If there are several rows with the same values for those fields, you'll get rows for all the combinations.\r\n   > A match is a row selected from one table that has the same value for all the `on` fields as a row in the other table.\r\n\r\n| Join flavor | Output records |\r\n|---|---|\r\n| `kind=leftanti`, `kind=leftantisemi`| Returns all the records from the left side that don't have matches from the right|\r\n| `kind=rightanti`, `kind=rightantisemi`| Returns all the records from the right side that don't have matches from the left.|\r\n| `kind` unspecified, `kind=innerunique`| Only one row from the left side is matched for each value of the `on` key. The output contains a row for each match of this row with rows from the right.|\r\n| `kind=leftsemi`| Returns all the records from the left side that have matches from the right. |\r\n| `kind=rightsemi`| Returns all the records from the right side that have matches from the left. |\r\n| `kind=inner`| Returns all matching records from left and right sides. |\r\n| `kind=fullouter`| Returns all the records for all the records from the left and right sides. Unmatched cells contain nulls. |\r\n| `kind=leftouter`| Returns all the records from the left side and only matching records from the right side. |\r\n| `kind=rightouter`| Returns all the records from the right side and only matching records from the left side. |\r\n\r\n> [!TIP]\r\n>\r\n> For best performance, if one table is always smaller than the other, use it as the left (piped) side of the join.","Get extended activities from a `login` that some entries mark as the start and end of an activity.\r\n\r\n```\r\nlet Events = MyLogTable | where type==\"Event\" ;\r\nEvents\r\n| where Name == \"Start\"\r\n| project Name, City, ActivityId, StartTime=timestamp\r\n| join (Events\r\n    | where Name == \"Stop\"\r\n        | project StopTime=timestamp, ActivityId)\r\n    on ActivityId\r\n| project City, ActivityId, StartTime, StopTime, Duration = StopTime - StartTime\r\n```\r\n\r\n```\r\nlet Events = MyLogTable | where type==\"Event\" ;\r\nEvents\r\n| where Name == \"Start\"\r\n| project Name, City, ActivityIdLeft = ActivityId, StartTime=timestamp\r\n| join (Events\r\n        | where Name == \"Stop\"\r\n        | project StopTime=timestamp, ActivityIdRight = ActivityId)\r\n    on $left.ActivityIdLeft == $right.ActivityIdRight\r\n| project City, ActivityId, StartTime, StopTime, Duration = StopTime - StartTime\r\n```\r\n\r\n## Join flavors\r\n\r\nThe exact flavor of the join operator is specified with the *kind* keyword. The following flavors of the join operator are supported:\r\n\r\n|Join kind/flavor|Description|\r\n|--|--|\r\n|[`innerunique`](#default-join-flavor) (or empty as default)|Inner join with left side deduplication|\r\n|[`inner`](#inner-join-flavor)|Standard inner join|\r\n|[`leftouter`](#left-outer-join-flavor)|Left outer join|\r\n|[`rightouter`](#right-outer-join-flavor)|Right outer join|\r\n|[`fullouter`](#full-outer-join-flavor)|Full outer join|\r\n|[`leftanti`](#left-anti-join-flavor), [`anti`](#left-anti-join-flavor), or [`leftantisemi`](#left-anti-join-flavor)|Left anti join|\r\n|[`rightanti`](#right-anti-join-flavor) or [`rightantisemi`](#right-anti-join-flavor)|Right anti join|\r\n|[`leftsemi`](#left-semi-join-flavor)|Left semi join|\r\n|[`rightsemi`](#right-semi-join-flavor)|Right semi join|\r\n\r\n### Default join flavor\r\n\r\nThe default join flavor is an inner join with left side deduplication. Default join implementation is useful in typical log/trace analysis scenarios where you want to correlate two events, each matching some filtering criterion, under the same correlation ID. You want to get back all appearances of the phenomenon, and ignore multiple appearances of the contributing trace records.\r\n\r\n```\r\nX | join Y on Key\r\n \r\nX | join kind=innerunique Y on Key\r\n```\r\n\r\nThe following two sample tables are used to explain the operation of the join.\r\n\r\n**Table X**\r\n\r\n|Key |Value1\r\n|---|---\r\n|a |1\r\n|b |2\r\n|b |3\r\n|c |4\r\n\r\n**Table Y**\r\n\r\n|Key |Value2\r\n|---|---\r\n|b |10\r\n|c |20\r\n|c |30\r\n|d |40\r\n\r\nThe default join does an inner join after deduplicating the left side on the join key (deduplication keeps the first record).\r\n\r\nGiven this statement: `X | join Y on Key`\r\n\r\nthe effective left side of the join, table X after deduplication, would be:\r\n\r\n|Key |Value1\r\n|---|---\r\n|a |1\r\n|b |2\r\n|c |4\r\n\r\nand the result of the join would be:\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|b|2|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n\r\n> [!NOTE]\r\n> The keys 'a' and 'd' don't appear in the output, since there were no matching keys on both left and right sides.\r\n\r\n### Inner-join flavor\r\n\r\nThe inner-join function is like the standard inner-join from the SQL world. An output record is produced whenever a record on the left side has the same join key as the record on the right side.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=inner Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|b|3|b|10|\r\n|b|2|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n\r\n> [!NOTE]\r\n> * (b,10) from the right side, was joined twice: with both (b,2) and (b,3) on the left.\r\n> * (c,4) on the left side, was joined twice: with both (c,20) and (c,30) on the right.\r\n\r\n### Innerunique-join flavor\r\n\r\nUse **innerunique-join flavor** to deduplicate keys from the left side. The result will be a row in the output from every combination of deduplicated left keys and right keys.\r\n\r\n> [!NOTE]\r\n> **innerunique flavor** may yield two possible outputs and both are correct.\r\n    In the first output, the join operator randomly selected the first key that appears in t1, with the value \"val1.1\" and matched it with t2 keys.\r\n    In the second output, the join operator randomly selected the second key that appears in t1, with the value \"val1.2\" and matched it with t2 keys.\r\n\r\n```\r\nlet t1 = datatable(key:long, value:string)  \r\n[\r\n1, \"val1.1\",  \r\n1, \"val1.2\"  \r\n];\r\nlet t2 = datatable(key:long, value:string)  \r\n[  \r\n1, \"val1.3\",\r\n1, \"val1.4\"  \r\n];\r\nt1\r\n| join kind = innerunique\r\n    t2\r\non key\r\n```\r\n\r\n|key|value|key1|value1|\r\n|---|---|---|---|\r\n|1|val1.1|1|val1.3|\r\n|1|val1.1|1|val1.4|\r\n\r\n```\r\nlet t1 = datatable(key:long, value:string)  \r\n[\r\n1, \"val1.1\",  \r\n1, \"val1.2\"  \r\n];\r\nlet t2 = datatable(key:long, value:string)  \r\n[  \r\n1, \"val1.3\", \r\n1, \"val1.4\"  \r\n];\r\nt1\r\n| join kind = innerunique\r\n    t2\r\non key\r\n```\r\n\r\n|key|value|key1|value1|\r\n|---|---|---|---|\r\n|1|val1.2|1|val1.3|\r\n|1|val1.2|1|val1.4|\r\n\r\n* Kusto is optimized to push filters that come after the `join`, towards the appropriate join side, left or right, when possible.\r\n\r\n* Sometimes, the flavor used is **innerunique** and the filter is propagated to the left side of the join. The flavor will be automatically propagated and the keys that apply to that filter will always appear in the output.\r\n    \r\n* Use the example above and add a filter `where value == \"val1.2\" `. It will always give the second result and will never give the first result for the datasets:\r\n\r\n\r\n\r\n```\r\nlet t1 = datatable(key:long, value:string)  \r\n[\r\n1, \"val1.1\",  \r\n1, \"val1.2\"  \r\n];\r\nlet t2 = datatable(key:long, value:string)  \r\n[  \r\n1, \"val1.3\", \r\n1, \"val1.4\"  \r\n];\r\nt1\r\n| join kind = innerunique\r\n    t2\r\non key\r\n| where value == \"val1.2\"\r\n```\r\n\r\n|key|value|key1|value1|\r\n|---|---|---|---|\r\n|1|val1.2|1|val1.3|\r\n|1|val1.2|1|val1.4|\r\n\r\n### Left outer-join flavor\r\n\r\nThe result of a left outer-join for tables X and Y always contains all records of the left table (X), even if the join condition doesn't find any matching record in the right table (Y).\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=leftouter Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|a|1|||\r\n|b|2|b|10|\r\n|b|3|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n\r\n### Right outer-join flavor\r\n\r\nThe right outer-join flavor resembles the left outer-join, but the treatment of the tables is reversed.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=rightouter Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|b|2|b|10|\r\n|b|3|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n|||d|40|\r\n\r\n### Full outer-join flavor\r\n\r\nA full outer-join combines the effect of applying both left and right outer-joins. Whenever records in the joined tables don't match, the result set will have `null` values for every column of the table that lacks a matching row. For those records that do match, a single row will be produced in the result set, containing fields populated from both tables.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=fullouter Y on Key\r\n```\r\n\r\n|Key|Value1|Key1|Value2|\r\n|---|---|---|---|\r\n|a|1|||\r\n|b|2|b|10|\r\n|b|3|b|10|\r\n|c|4|c|20|\r\n|c|4|c|30|\r\n|||d|40|\r\n\r\n### Left anti-join flavor\r\n\r\nLeft anti-join returns all records from the left side that don't match any record from the right side.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=leftanti Y on Key\r\n```\r\n\r\n|Key|Value1|\r\n|---|---|\r\n|a|1|\r\n\r\n> [!NOTE]\r\n> Anti-join models the \"NOT IN\" query.\r\n\r\n### Right anti-join flavor\r\n\r\nRight anti-join returns all records from the right side that don't match any record from the left side.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=rightanti Y on Key\r\n```\r\n\r\n|Key|Value2|\r\n|---|---|\r\n|d|40|\r\n\r\n> [!NOTE]\r\n> Anti-join models the \"NOT IN\" query.\r\n\r\n### Left semi-join flavor\r\n\r\nLeft semi-join returns all records from the left side that match a record from the right side. Only columns from the left side are returned.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=leftsemi Y on Key\r\n```\r\n\r\n|Key|Value1|\r\n|---|---|\r\n|b|2|\r\n|b|3|\r\n|c|4|\r\n\r\n### Right semi-join flavor\r\n\r\nRight semi-join returns all records from the right side that match a record from the left side. Only columns from the right side are returned.\r\n\r\n```\r\nlet X = datatable(Key:string, Value1:long)\r\n[\r\n    'a',1,\r\n    'b',2,\r\n    'b',3,\r\n    'c',4\r\n];\r\nlet Y = datatable(Key:string, Value2:long)\r\n[\r\n    'b',10,\r\n    'c',20,\r\n    'c',30,\r\n    'd',40\r\n];\r\nX | join kind=rightsemi Y on Key\r\n```\r\n\r\n|Key|Value2|\r\n|---|---|\r\n|b|10|\r\n|c|20|\r\n|c|30|\r\n\r\n### Cross-join\r\n\r\nKusto doesn't natively provide a cross-join flavor. You can't mark the operator with the `kind=cross`.\r\nTo simulate, use a dummy key.\r\n\r\n`X | extend dummy=1 | join kind=inner (Y | extend dummy=1) on dummy`\r\n\r\n## Join hints\r\n\r\nThe `join` operator supports a number of hints that control the way a query runs.\r\nThese hints don't change the semantic of `join`, but may affect its performance.\r\n\r\nJoin hints are explained in the following articles:\r\n\r\n* `hint.shufflekey=<key>` and `hint.strategy=shuffle` - [shuffle query](shufflequery.md)\r\n* `hint.strategy=broadcast` - [broadcast join](broadcastjoin.md)\r\n* `hint.remote=<strategy>` - [cross-cluster join](joincrosscluster.md)","https://docs.microsoft.com/azure/data-explorer/kusto/query/joinoperator","joinoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"limit","Return up to the specified number of rows.","```\r\nT | limit 5\r\n```\r\n\r\n**Alias**\r\n\r\n[take operator](takeoperator.md)","","https://docs.microsoft.com/azure/data-explorer/kusto/query/limitoperator","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"log","`log()` returns the natural logarithm function.","## Syntax\r\n\r\n`log(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number > 0.\r\n\r\n## Returns\r\n\r\n* The natural logarithm is the base-e logarithm: the inverse of the natural exponential function (exp).\r\n* `null` if the argument is negative or null or can't be converted to a `real` value. \r\n\r\n## See also\r\n\r\n* For common (base-10) logarithms, see [log10()](log10-function.md).\r\n* For base-2 logarithms, see [log2()](log2-function.md)","","https://docs.microsoft.com/azure/data-explorer/kusto/query/log-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"log10","`log10()` returns the common (base-10) logarithm function.","## Syntax\r\n\r\n`log10(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number > 0.\r\n\r\n## Returns\r\n\r\n* The common logarithm is the base-10 logarithm: the inverse of the exponential function (exp) with base 10.\r\n* `null` if the argument is negative or null or can't be converted to a `real` value. \r\n\r\n## See also\r\n\r\n* For natural (base-e) logarithms, see [log()](log-function.md).\r\n* For base-2 logarithms, see [log2()](log2-function.md)","","https://docs.microsoft.com/azure/data-explorer/kusto/query/log10-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"log2","`log2()` returns the base-2 logarithm function.","## Syntax\r\n\r\n`log2(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: A real number > 0.\r\n\r\n## Returns\r\n\r\n* The logarithm is the base-2 logarithm: the inverse of the exponential function (exp) with base 2.\r\n* `null` if the argument is negative or null or can't be converted to a `real` value. \r\n\r\n## See also\r\n\r\n* For natural (base-e) logarithms, see [log()](log-function.md).\r\n* For common (base-10) logarithms, see [log10()](log10-function.md).","","https://docs.microsoft.com/azure/data-explorer/kusto/query/log2-function","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"loggamma","Computes log of absolute value of the [gamma function](https://en.wikipedia.org/wiki/Gamma_function)","## Syntax\r\n\r\n`loggamma(`*x*`)`\r\n\r\n## Arguments\r\n\r\n* *x*: Parameter for the gamma function\r\n\r\n## Returns\r\n\r\n* Returns the natural logarithm of the absolute value of the gamma function of x.\r\n* For computing gamma function, see [gamma()](gammafunction.md).","","https://docs.microsoft.com/azure/data-explorer/kusto/query/loggammafunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.OperatorToken,"lookup","The `lookup` operator extends the columns of a fact table with values\r\nlooked-up in a dimension table.","```\r\nFactTable | lookup kind=leftouter (DimensionTable) on CommonColumn, $left.Col1 == $right.Col2\r\n```\r\n\r\nHere, the result is a table that extends the `FactTable` (`$left`) with data from `DimensionTable` (referenced by `$right`)\r\n by performing a lookup of each pair (`CommonColumn`,`Col`) from the former table\r\nwith each pair (`CommonColumn1`,`Col2`) in the latter table. \r\nFor the differences between fact and dimension tables, see [fact and dimension tables](../concepts/fact-and-dimension-tables.md). \r\n\r\nThe `lookup` operator performs an operation similar to the [join operator](joinoperator.md)\r\nwith the following differences:\r\n\r\n* The result does not repeat columns from the `$right` table that are the basis\r\n  for the join operation.\r\n* Only two kinds of lookup are supported, `leftouter` and `inner`,\r\n  with `leftouter` being the default.\r\n* In terms of performance, the system by default assumes that the `$left` table\r\n  is the larger (facts) table, and the `$right` table is the smaller (dimensions)\r\n  table. This is exactly opposite to the assumption used by the `join` operator.\r\n* The `lookup` operator automatically broadcasts the `$right` table to the `$left`\r\n  table (essentially, behaves as if `hint.broadcast` was specified). Note that\r\n  this limits the size of the `$right` table.\r\n\r\n## Syntax\r\n\r\n*LeftTable* `|` `lookup` [`kind` `=` (`leftouter`|`inner`)] `(` *RightTable* `)` `on` *Attributes*\r\n\r\n## Arguments\r\n\r\n* *LeftTable*: The table or tabular expression that is the basis for the lookup.\r\n  Denoted as `$left`.\r\n* *RightTable*: The table or tabular expression that is used to \"populate\"\r\n  new columns in the fact table. Denoted as `$right`.\r\n* *Attributes*: A comma-delimited list of one or more rules that describe how rows from\r\n  *LeftTable* are matched to rows from *RightTable*. Multiple rules are evaluated using the `and` logical operator.\r\n  A rule can be one of:\r\n  |Rule kind        |Syntax                                          |Predicate                                                      |\r\n  |-----------------|------------------------------------------------|---------------------------------------------------------------|\r\n  |Equality by name |*ColumnName*                                    |`where` *LeftTable*.*ColumnName* `==` *RightTable*.*ColumnName*|\r\n  |Equality by value|`$left.`*LeftColumn* `==` `$right.`*RightColumn*|`where` `$left.`*LeftColumn* `==` `$right.`*RightColumn        |\r\n  > [!Note] \r\n  > In case of 'equality by value', the column names *must* be qualified with the applicable owner table denoted by `$left` and `$right` notations.\r\n* `kind`: An optional instruction on how to treat rows in *LeftTable* that\r\n  have no match in *RightTable*. By default, `leftouter` is used, which means\r\n  all those rows will appear in the output with null values used for the\r\n  missing values of *RightTable* columns added by the operator. If `inner`\r\n  is used, such rows are omitted from the output. (Other kinds\r\n  of join are not supported by the `lookup` operator.)\r\n  \r\n\r\n## Returns\r\n\r\nA table with:\r\n\r\n* A column for every column in each of the two tables, including the matching keys.\r\n  The columns of the right side will be automatically renamed if there are name conflicts.\r\n* A row for every match between the input tables. A match is a row selected from one table that has the same value for all the `on` fields as a row in the other table. \r\n* The Attributes (lookup keys) will appear only once in the output table.\r\n * `kind` unspecified, `kind=leftouter`\r\n     In addition to the inner matches, there's a row for every row on the left (and/or right), even if it has no match. In that case, the unmatched output cells contain nulls.\r\n * `kind=inner`\r\n     There's a row in the output for every combination of matching rows from left and right.",'```\r\nlet FactTable=datatable(Row:string,Personal:string,Family:string) [\r\n  "1", "Bill",   "Gates",\r\n  "2", "Bill",   "Clinton",\r\n  "3", "Bill",   "Clinton",\r\n  "4", "Steve",  "Ballmer",\r\n  "5", "Tim",    "Cook"\r\n];\r\nlet DimTable=datatable(Personal:string,Family:string,Alias:string) [\r\n  "Bill",  "Gates",   "billg",\r\n  "Bill",  "Clinton", "billc",\r\n  "Steve", "Ballmer", "steveb",\r\n  "Tim",   "Cook",    "timc"\r\n];\r\nFactTable\r\n| lookup kind=leftouter DimTable on Personal, Family\r\n```\r\n\r\nRow     | Personal  | Family   | Alias\r\n--------|-----------|----------|--------\r\n1       | Bill      | Gates    | billg\r\n2       | Bill      | Clinton  | billc\r\n3       | Bill      | Clinton  | billc\r\n4       | Steve     | Ballmer  | steveb\r\n5       | Tim       | Cook     | timc',"https://docs.microsoft.com/azure/data-explorer/kusto/query/lookupoperator","lookupoperator.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_bag","Returns a `dynamic` (JSON) property-bag (dictionary) of all the values of *`Expr`* in the group.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`make_bag` `(`*Expr* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression of type `dynamic` that is used for aggregation calculations.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned. The default is *1048576*. MaxSize value can't exceed *1048576*.\r\n\r\n> [!NOTE]\r\n> `make_dictionary()` is a legacy and obsolete version of `make_bag()`. The legacy version has a default limit of *MaxSize* = 128.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) property-bag (dictionary) of all the values of *`Expr`* in the group, which are property-bags.\r\nNon-dictionary values will be skipped.\r\nIf a key appears in more than one row, an arbitrary value, out of the possible values for this key, will be selected.\r\n\r\n## See also\r\n\r\nUse the [bag_unpack()](bag-unpackplugin.md) plugin for expanding dynamic JSON objects into columns that use property bag keys.",'```\r\nlet T = datatable(prop:string, value:string)\r\n[\r\n    "prop01", "val_a",\r\n    "prop02", "val_b",\r\n    "prop03", "val_c",\r\n];\r\nT\r\n| extend p = pack(prop, value)\r\n| summarize dict=make_bag(p)\r\n\r\n```\r\n\r\n|dict|\r\n|----|\r\n|{ "prop01": "val_a", "prop02": "val_b", "prop03": "val_c" } |\r\n\r\nUse the [bag_unpack()](bag-unpackplugin.md) plugin for transforming the bag keys in the make_bag() output into columns. \r\n\r\n```\r\nlet T = datatable(prop:string, value:string)\r\n[\r\n    "prop01", "val_a",\r\n    "prop02", "val_b",\r\n    "prop03", "val_c",\r\n];\r\nT\r\n| extend p = pack(prop, value)\r\n| summarize bag=make_bag(p)\r\n| evaluate bag_unpack(bag) \r\n\r\n```\r\n\r\n|prop01|prop02|prop03|\r\n|---|---|---|\r\n|val_a|val_b|val_c|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/make-bag-aggfunction","make-bag-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_bag_if","Returns a `dynamic` (JSON) property-bag (dictionary) of all the values of *'Expr'* in the group, for which *Predicate* evaluates to `true`.","> [!NOTE]\r\n> Can only be used in context of aggregation inside [summarize](summarizeoperator.md).\r\n\r\n## Syntax\r\n\r\n`make_bag_if` `(`*Expr*`,` *Predicate* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression of type `dynamic` that will be used for aggregation calculation.\r\n* *Predicate*: Predicate that has to evaluate to `true`, in order for *'Expr'* to be added to the result.\r\n* *MaxSize*: An optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value can't exceed 1048576.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) property-bag (dictionary) of all the values of *'Expr'* in the group that are property-bags (dictionaries), for which *Predicate* evaluates to `true`.\r\nNon-dictionary values will be skipped.\r\nIf a key appears in more than one row, an arbitrary value, out of the possible values for this key, will be selected.\r\n\r\n> [!NOTE]\r\n> The [`make_bag`](./make-bag-aggfunction.md) function, is similar to make_bag_if() without predicate expression.",'```\r\nlet T = datatable(prop:string, value:string, predicate:bool)\r\n[\r\n    "prop01", "val_a", true,\r\n    "prop02", "val_b", false,\r\n    "prop03", "val_c", true\r\n];\r\nT\r\n| extend p = pack(prop, value)\r\n| summarize dict=make_bag_if(p, predicate)\r\n\r\n```\r\n\r\n|dict|\r\n|----|\r\n|{ "prop01": "val_a", "prop03": "val_c" } |\r\n\r\nUse [bag_unpack()](bag-unpackplugin.md) plugin for transforming the bag keys in the make_bag_if() output into columns. \r\n\r\n```\r\nlet T = datatable(prop:string, value:string, predicate:bool)\r\n[\r\n    "prop01", "val_a", true,\r\n    "prop02", "val_b", false,\r\n    "prop03", "val_c", true\r\n];\r\nT\r\n| extend p = pack(prop, value)\r\n| summarize bag=make_bag_if(p, predicate)\r\n| evaluate bag_unpack(bag)\r\n\r\n```\r\n\r\n|prop01|prop03|\r\n|---|---|\r\n|val_a|val_c|',"https://docs.microsoft.com/azure/data-explorer/kusto/query/make-bag-if-aggfunction","make-bag-if-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_datetime","Creates a [datetime](./scalar-data-types/datetime.md) scalar value from the specified date and time.","```\r\nmake_datetime(2017,10,01,12,10) == datetime(2017-10-01 12:10)\r\n```\r\n\r\n## Syntax\r\n\r\n`make_datetime(`*year*,*month*,*day*`)`\r\n\r\n`make_datetime(`*year*,*month*,*day*,*hour*,*minute*`)`\r\n\r\n`make_datetime(`*year*,*month*,*day*,*hour*,*minute*,*second*`)`\r\n\r\n## Arguments\r\n\r\n* *year*: year (an integer value, from 0 to 9999)\r\n* *month*: month (an integer value, from 1 to 12)\r\n* *day*: day (an integer value, from 1 to 28-31)\r\n* *hour*: hour (an integer value, from 0 to 23)\r\n* *minute*: minute (an integer value, from 0 to 59)\r\n* *second*: second (a real value, from 0 to 59.9999999)\r\n\r\n## Returns\r\n\r\nIf creation is successful, result will be a [datetime](./scalar-data-types/datetime.md) value, otherwise, result will be null.","```\r\nprint year_month_day = make_datetime(2017,10,01)\r\n```\r\n\r\n|year_month_day|\r\n|---|\r\n|2017-10-01 00:00:00.0000000|\r\n\r\n```\r\nprint year_month_day_hour_minute = make_datetime(2017,10,01,12,10)\r\n```\r\n\r\n|year_month_day_hour_minute|\r\n|---|\r\n|2017-10-01 12:10:00.0000000|\r\n\r\n```\r\nprint year_month_day_hour_minute_second = make_datetime(2017,10,01,12,11,0.1234567)\r\n```\r\n\r\n|year_month_day_hour_minute_second|\r\n|---|\r\n|2017-10-01 12:11:00.1234567|","https://docs.microsoft.com/azure/data-explorer/kusto/query/make-datetimefunction","make-datetimefunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_list","Returns a `dynamic` (JSON) array of all the values of *Expr* in the group.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`make_list` `(`*Expr* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value cannot exceed 1048576.\r\n\r\n> [!NOTE]\r\n> `makelist()` is a legacy and obsolete version of the `make_list` function. The legacy version has a default limit of *MaxSize* = 128.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of all the values of *Expr* in the group.\r\nIf the input to the `summarize` operator is not sorted, the order of elements in the resulting array is undefined.\r\nIf the input to the `summarize` operator is sorted, the order of elements in the resulting array tracks that of the input.\r\n\r\n> [!TIP]\r\n> Use the [`array_sort_asc()`](./arraysortascfunction.md) or [`array_sort_desc()`](./arraysortdescfunction.md) function to create an ordered list by some key.",'### One column\r\n\r\nThe simplest example is to make a list out of a single column:\r\n\r\n```\r\nlet shapes = datatable (name: string, sideCount: int)\r\n[\r\n    "triangle", 3,\r\n    "square", 4,\r\n    "rectangle", 4,\r\n    "pentagon", 5,\r\n    "hexagon", 6,\r\n    "heptagon", 7,\r\n    "octogon", 8,\r\n    "nonagon", 9,\r\n    "decagon", 10\r\n];\r\nshapes\r\n| summarize mylist = make_list(name)\r\n```\r\n\r\n|mylist|\r\n|---|\r\n|["triangle","square","rectangle","pentagon","hexagon","heptagon","octogon","nonagon","decagon"]|\r\n\r\n### Using the \'by\' clause\r\n\r\nIn the following query, you group using the `by` clause:\r\n\r\n```\r\nlet shapes = datatable (name: string, sideCount: int)\r\n[\r\n    "triangle", 3,\r\n    "square", 4,\r\n    "rectangle", 4,\r\n    "pentagon", 5,\r\n    "hexagon", 6,\r\n    "heptagon", 7,\r\n    "octogon", 8,\r\n    "nonagon", 9,\r\n    "decagon", 10\r\n];\r\nshapes\r\n| summarize mylist = make_list(name) by isEvenSideCount = sideCount % 2 == 0\r\n```\r\n\r\n|isEvenSideCount| mylist|\r\n|---|---|\r\n|false|["triangle","pentagon","heptagon","nonagon"]|\r\n|true|["square","rectangle","hexagon","octogon","decagon"]|\r\n\r\n### Packing a dynamic object\r\n\r\nYou can [pack](./packfunction.md) a dynamic object in a column before making a list out of it, as seen in the following query:\r\n\r\n```\r\nlet shapes = datatable (name: string, sideCount: int)\r\n[\r\n    "triangle", 3,\r\n    "square", 4,\r\n    "rectangle", 4,\r\n    "pentagon", 5,\r\n    "hexagon", 6,\r\n    "heptagon", 7,\r\n    "octogon", 8,\r\n    "nonagon", 9,\r\n    "decagon", 10\r\n];\r\nshapes\r\n| extend d = pack("name", name, "sideCount", sideCount)\r\n| summarize mylist = make_list(d) by isEvenSideCount = sideCount % 2 == 0\r\n```\r\n\r\n|mylist|isEvenSideCount|\r\n|---|---|\r\n|false|[{"name":"triangle","sideCount":3},{"name":"pentagon","sideCount":5},{"name":"heptagon","sideCount":7},{"name":"nonagon","sideCount":9}]|\r\n|true|[{"name":"square","sideCount":4},{"name":"rectangle","sideCount":4},{"name":"hexagon","sideCount":6},{"name":"octogon","sideCount":8},{"name":"decagon","sideCount":10}]|\r\n\r\n## See also\r\n\r\n[`make_list_if`](./makelistif-aggfunction.md) operator is similar to `make_list`, except it also accepts a predicate.',"https://docs.microsoft.com/azure/data-explorer/kusto/query/makelist-aggfunction","makelist-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_list_if","Returns a `dynamic` (JSON) array of all the values of *Expr* in the group, for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`make_list_if` `(`*Expr*`,` *Predicate* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n* *Predicate*: Predicate that has to evaluate to `true`, in order for *Expr* to be added to the result.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value cannot exceed 1048576.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of all the values of *Expr* in the group, for which *Predicate* evaluates to `true`.\r\nIf the input to the `summarize` operator is not sorted, the order of elements in the resulting array is undefined.\r\nIf the input to the `summarize` operator is sorted, the order of elements in the resulting array tracks that of the input.",'```\r\nlet T = datatable(name:string, day_of_birth:long)\r\n[\r\n   "John", 9,\r\n   "Paul", 18,\r\n   "George", 25,\r\n   "Ringo", 7\r\n];\r\nT\r\n| summarize make_list_if(name, strlen(name) > 4)\r\n```\r\n\r\n|list_name|\r\n|----|\r\n|["George", "Ringo"]|\r\n\r\n## See also\r\n\r\n[`make_list`](./makelist-aggfunction.md) function, which does the same, without predicate expression.',"https://docs.microsoft.com/azure/data-explorer/kusto/query/makelistif-aggfunction","makelistif-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_list_with_nulls","Returns a `dynamic` (JSON) array of all the values of *Expr* in the group, including null values.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`make_list_with_nulls` `(` *Expr* `)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of all the values of *Expr* in the group, including null values.\r\nIf the input to the `summarize` operator is not sorted, the order of elements in the resulting array is undefined.\r\nIf the input to the `summarize` operator is sorted, the order of elements in the resulting array tracks that of the input.\r\n\r\n> [!TIP]\r\n> Use the [`array_sort_asc()`](./arraysortascfunction.md) or [`array_sort_desc()`](./arraysortdescfunction.md) function to create an ordered list by some key.","","https://docs.microsoft.com/azure/data-explorer/kusto/query/make-list-with-nulls-aggfunction","")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_set","Returns a `dynamic` (JSON) array of the set of distinct values that *Expr* takes in the group.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`make_set` `(`*Expr* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression for aggregation calculation.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value cannot exceed 1048576.\r\n\r\n> [!NOTE]\r\n> `makeset()` is a legacy and obsolete version of the function `make_set`. The legacy version has a default limit of *MaxSize* = 128.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of the set of distinct values that *Expr* takes in the group.\r\nThe array's sort order is undefined.\r\n\r\n> [!TIP]\r\n> To only count distinct values, use [dcount()](dcount-aggfunction.md)","```\r\nPageViewLog \r\n| summarize countries=make_set(country) by continent\r\n```\r\n\r\n![Table showing Kusto Query summarize countries by continent in Azure Data Explorer.](images/makeset-aggfunction/makeset.png)\r\n\r\n## See also\r\n\r\n* Use [`mv-expand`](./mvexpandoperator.md) operator for the opposite function.\r\n* [`make_set_if`](./makesetif-aggfunction.md) operator is similar to `make_set`, except it also accepts a predicate.","https://docs.microsoft.com/azure/data-explorer/kusto/query/makeset-aggfunction","makeset-aggfunction.md")),this.AddTopic(new Kusto.Data.IntelliSense.CslTopicDocumentation(Kusto.Data.IntelliSense.CslCommandToken.Kind.FunctionNameToken,"make_set_if","Returns a `dynamic` (JSON) array of the set of distinct values that *Expr* takes in the group, for which *Predicate* evaluates to `true`.","* Can be used only in context of aggregation inside [summarize](summarizeoperator.md)\r\n\r\n## Syntax\r\n\r\n`make_set_if` `(`*Expr*`,` *Predicate* [`,` *MaxSize*]`)`\r\n\r\n## Arguments\r\n\r\n* *Expr*: Expression that will be used for aggregation calculation.\r\n* *Predicate*: Predicate that has to evaluate to `true` for *Expr* to be added to the result.\r\n* *MaxSize* is an optional integer limit on the maximum number of elements returned (default is *1048576*). MaxSize value cannot exceed 1048576.\r\n\r\n## Returns\r\n\r\nReturns a `dynamic` (JSON) array of the set of distinct values that *Expr* takes in the group, for which *Predicate* evaluates to `true`.\r\nThe array's sort order is undefined.\r\n\r\n> [!TIP]\r\n> To only count the distinct values, use [dcountif()](dcountif-aggfunction.md)\r\n\r\n## See also\r\n\r\n[`make_set`](./makeset-aggfunction.md) function, which does the same, without predicate expression.",'```\r\nlet T = datatable(name:string, day_of_birth:long)\r\n[\r\n   "John", 9,\r\n   "Paul", 18,\r\n   "George", 25,\r\n   "Ringo", 7\r\n];\r\nT\r\n| summarize make_set_if(name, strlen(name) > 4)\r