"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.init = void 0;
const tslib_1 = require("tslib");
const render_1 = require("@betterer/render");
const path_1 = (0, tslib_1.__importDefault)(require("path"));
const init_1 = require("./init/init");
const options_1 = require("./options");
const BETTERER_TS = './.betterer.ts';
const BETTERER_RESULTS = './.betterer.results';
const TS_EXTENSION = '.ts';
/**
 * Run the **Betterer** `init` command to initialise **Betterer** in a new project.
 */
function init(cwd) {
    const command = (0, options_1.initCommand)();
    command.description('init Betterer in a project');
    command.action(async (config) => {
        (0, options_1.setEnv)(config);
        const RENDER_OPTIONS = {
            debug: process.env.NODE_ENV === 'test'
        };
        const finalConfig = config.config || BETTERER_TS;
        const finalResults = config.results || BETTERER_RESULTS;
        const ext = path_1.default.extname(finalConfig);
        const ts = ext === TS_EXTENSION;
        const app = (0, render_1.render)(render_1.React.createElement(init_1.Init, { automerge: config.automerge, configPath: finalConfig, cwd: cwd, resultsPath: finalResults, ts: ts }), RENDER_OPTIONS);
        await app.waitUntilExit();
    });
    return command;
}
exports.init = init;
//# sourceMappingURL=init.js.map