import { BettererResultsSerialised } from './types';
/**
 * Parses the contents of a given results file path. If the file doesn't exist, it will
 * return an empty object. If the file exists, but has merge conflicts, it will merge the
 * files using {@link mergeResults | `mergeResults`}.
 *
 * @throws {@link @betterer/errors#BettererError | `BettererError` }
 * Throws if the results file cannot be parsed, or if it contains merge conflicts that
 * can't be resolved.
 */
export declare function parseResults(resultsPath: string): Promise<BettererResultsSerialised>;
//# sourceMappingURL=parse.d.ts.map