"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BettererResultsSummaryΩ = void 0;
const fs_1 = require("../fs");
const globals_1 = require("../globals");
const test_1 = require("../test");
class BettererResultsSummaryΩ {
    constructor(resultSummaries, onlyFileTests) {
        this.resultSummaries = onlyFileTests
            ? resultSummaries.filter((resultSummary) => resultSummary.isFileTest)
            : resultSummaries;
    }
    static async create(options) {
        const { config, resultsFile, versionControl } = await (0, globals_1.createGlobals)({
            configPaths: options.configPaths,
            cwd: options.cwd,
            excludes: options.excludes,
            filters: options.filters,
            includes: options.includes,
            resultsPath: options.resultsPath
        });
        const testFactories = (0, test_1.loadTestMeta)(config);
        let testNames = Object.keys(testFactories);
        if (config.filters.length) {
            testNames = testNames.filter((name) => config.filters.some((filter) => filter.test(name)));
        }
        const { cwd, includes, excludes, resultsPath } = config;
        const resolver = new fs_1.BettererFileResolverΩ(cwd, versionControl);
        resolver.include(...includes);
        resolver.exclude(...excludes);
        const filePaths = await resolver.files();
        const onlyFileTests = includes.length > 0 || excludes.length > 0;
        const testStatuses = await Promise.all(testNames.map(async (name) => {
            const test = await testFactories[name].factory();
            const isFileTest = (0, test_1.isBettererFileTest)(test);
            const [expectedJSON] = resultsFile.getExpected(name);
            const serialised = JSON.parse(expectedJSON);
            const deserialised = test.config.serialiser.deserialise(serialised, resultsPath);
            if (isFileTest) {
                const resultΩ = deserialised;
                const details = resultΩ.files
                    .filter((file) => !onlyFileTests || filePaths.includes(file.absolutePath))
                    .reduce((summary, file) => {
                    summary[file.absolutePath] = file.issues;
                    return summary;
                }, {});
                return { name, isFileTest, details };
            }
            else {
                const details = await test.config.printer(deserialised);
                return { name, isFileTest, details };
            }
        }));
        const status = new BettererResultsSummaryΩ(testStatuses, onlyFileTests);
        await versionControl.destroy();
        return status;
    }
}
exports.BettererResultsSummaryΩ = BettererResultsSummaryΩ;
//# sourceMappingURL=results-summary.js.map