/// <reference types="node" />
import nodeModule from 'module';
export declare type ModulePrivate = typeof nodeModule.Module & {
    _resolveFilename(id: string, module: NodeModule): string;
};
export declare type Func = (...args: Array<unknown>) => unknown;
export declare type Constructor = new (...args: Array<unknown>) => unknown;
export declare type FuncMap = Record<string, Func | Constructor>;
export declare type DebugIncludes = Array<RegExp>;
export declare type DebugIgnores = Array<string>;
export declare type DebugLogger = (logString: string) => void;
export declare type DebugOptions = {
    enabled: boolean;
    time: boolean;
    values: boolean;
    logPath: string;
    header: string;
    include: DebugIncludes;
    ignore: DebugIgnores;
    logger: DebugLogger;
};
