"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var schema_utils_1 = __importDefault(require("@webpack-contrib/schema-utils"));
var schema = {
    type: "object",
    additionalProperties: false,
    properties: {
        skipPropsWithName: {
            anyOf: [
                { type: "string", minLength: 1 },
                { type: "array", minItems: 1, items: { type: "string", minLength: 1 } },
            ],
        },
        skipPropsWithoutDoc: {
            type: "boolean",
        },
        componentNameResolver: {
            // this is really { type: "function" }
            not: {
                oneOf: [
                    { type: "string" },
                    { type: "number" },
                    { type: "object" },
                    { type: "array" },
                ],
            },
        },
        propFilter: {
            // this is really { type: "function" }
            not: {
                oneOf: [
                    { type: "string" },
                    { type: "number" },
                    { type: "object" },
                    { type: "array" },
                ],
            },
        },
        tsconfigPath: {
            type: "string",
            minLength: 1,
        },
        compilerOptions: {
            type: "object",
        },
        docgenCollectionName: {
            anyOf: [{ type: "string", minLength: 1 }, { type: "null" }],
        },
        setDisplayName: {
            type: "boolean",
        },
        shouldExtractLiteralValuesFromEnum: {
            type: "boolean",
        },
        savePropValueAsString: {
            type: "boolean",
        },
        typePropName: {
            type: "string",
        },
    },
};
function validateOptions(options) {
    if (options === void 0) { options = {}; }
    schema_utils_1.default({
        name: "react-docgen-typescript-loader",
        schema: schema,
        target: options,
    });
}
exports.default = validateOptions;
//# sourceMappingURL=validateOptions.js.map