import { DataSourcePluginOptionsEditorProps, SelectableValue } from '@grafana/data';
import { InputActionMeta } from '@grafana/ui/components/Select/types';
import { AwsAuthDataSourceJsonData, AwsAuthDataSourceSecureJsonData } from '../../types';
export interface ConfigSelectProps extends DataSourcePluginOptionsEditorProps<AwsAuthDataSourceJsonData, AwsAuthDataSourceSecureJsonData> {
    value: string;
    fetch: () => Promise<Array<string | SelectableValue<string>>>;
    onChange: (e: SelectableValue<string> | null) => void;
    dependencies?: string[];
    label?: string;
    'data-testid'?: string;
    hidden?: boolean;
    disabled?: boolean;
    allowCustomValue?: boolean;
    saveOptions: () => Promise<void>;
    autoFocus?: boolean;
    backspaceRemovesValue?: boolean;
    className?: string;
    invalid?: boolean;
    isClearable?: boolean;
    isMulti?: boolean;
    inputId?: string;
    showAllSelectedWhenOpen?: boolean;
    maxMenuHeight?: number;
    minMenuHeight?: number;
    maxVisibleValues?: number;
    menuPlacement?: 'auto' | 'bottom' | 'top';
    menuPosition?: 'fixed' | 'absolute';
    noOptionsMessage?: string;
    onBlur?: () => void;
    onCreateOption?: (value: string) => void;
    onInputChange?: (value: string, actionMeta: InputActionMeta) => void;
    placeholder?: string;
    width?: number;
    isOptionDisabled?: () => boolean;
}
export declare function ConfigSelect(props: ConfigSelectProps): JSX.Element;
