import { monacoTypes } from '@grafana/ui';
import { TokenType } from '../types';
export declare class LinkedToken {
    type: string;
    value: string;
    range: monacoTypes.IRange;
    previous: LinkedToken | null;
    next: LinkedToken | null;
    constructor(type: string, value: string, range: monacoTypes.IRange, previous: LinkedToken | null, next: LinkedToken | null);
    isKeyword(): boolean;
    isWhiteSpace(): boolean;
    isParenthesis(): boolean;
    isIdentifier(): boolean;
    isString(): boolean;
    isNumber(): boolean;
    isDoubleQuotedString(): boolean;
    isVariable(): boolean;
    isFunction(): boolean;
    isOperator(): boolean;
    isTemplateVariable(): boolean;
    is(type: TokenType, value?: string | number | boolean): boolean;
    getPreviousNonWhiteSpaceToken(): LinkedToken | null;
    getPreviousOfType(type: TokenType, value?: string): LinkedToken | null;
    getPreviousUntil(type: TokenType, ignoreTypes: TokenType[], value?: string): LinkedToken[] | null;
    getNextUntil(type: TokenType, ignoreTypes: TokenType[], value?: string): LinkedToken[] | null;
    getPreviousKeyword(): LinkedToken | null;
    getNextNonWhiteSpaceToken(): LinkedToken | null;
    getNextOfType(type: TokenType, value?: string): LinkedToken | null;
}
