/* Copyright (c) 2023, 2025, GreatDB Software Co., Ltd. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
*/

#include "sql/parse_tree_pivot.h"
#include "sql/item_sum.h"
#include "sql/parse_tree_nodes.h"

bool PT_pivot::do_contextualize(Parse_context *pc) {
  if (Parse_tree_node::do_contextualize(pc)) return true;

  pc->select->m_pivot = this;
  this->set_owner(pc->select);

  if (sum_funcs->contextualize(pc)) return true;
  for (auto it : sum_funcs->value) {
    if (it->has_wf()) {
      my_error(ER_WINDOW_INVALID_WINDOW_FUNC_USE, MYF(0),
               down_cast<Item_sum *>(it)->func_name());
      return true;
    }
    it->walk(&Item::add_pivot_ref_flag, enum_walk::POSTFIX, nullptr);
  }

  if (cond_var->itemize(pc, &cond_var)) return true;
  cond_var->walk(&Item::add_pivot_ref_flag, enum_walk::POSTFIX, nullptr);

  if (cond_values->contextualize(pc)) return true;
  for (auto it : cond_values->value) {
    it->walk(&Item::add_pivot_ref_flag, enum_walk::POSTFIX, nullptr);
    if (it->type() == Item::ROW_ITEM &&
        (!it->item_name.is_set() || it->item_name.is_autogenerated())) {
      Item_row *item = down_cast<Item_row *>(it);
      item->setup_pivot_name(pc->thd);
    } else if (dynamic_cast<Item_string *>(it) && it->item_name.is_set()) {
      Item_string *item = down_cast<Item_string *>(it);
      if (item->item_name.is_autogenerated()) {
        char buff[MAX_FIELD_WIDTH];
        String str(buff, sizeof(buff), system_charset_info);
        str.length(0);
        str.append('\'');
        str.append(item->item_name.ptr(), item->item_name.length());
        str.append('\'');
        item->item_name.copy(str.c_ptr_safe(), str.length(),
                             system_charset_info, true);
      } else {
        item->item_name.copy(item->item_name.ptr(), item->item_name.length(),
                             system_charset_info, false);
      }
    }
  }

  return false;
}
