/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _ASM_SW64_UNCORE_IO_JUNZHANG_H
#define _ASM_SW64_UNCORE_IO_JUNZHANG_H

#include <asm/platform.h>

#define IO_BASE			(0x1UL << 47)
#define PCI_BASE		(0x1UL << 43)
#define PCI_IOR0_BASE		(0x2UL << 32)
#define PCI_IOR1_BASE		(0x3UL << 32)

#define PCI_RC_CFG		(0x5UL << 32)

#define PCI_EP_CFG		(0x3UL << 33)
#define PCI_LEGACY_IO		(0x1UL << 32)
#define PCI_LEGACY_IO_SIZE	(0x100000000UL)
#define PCI_MEM_UNPRE		0x0UL
#define PCI_32BIT_VT_MEMIO	(0xc0000000UL)
#define PCI_32BIT_MEMIO		(0xe0000000UL)
#define PCI_32BIT_MEMIO_SIZE	(0x20000000UL)
#define PCI_64BIT_MEMIO		(0x1UL << 39)
#define PCI_64BIT_MEMIO_SIZE	(0x8000000000UL)

#define IO_RC_SHIFT		40
#define IO_NODE_SHIFT		44
#define IO_MARK_BIT		47

#define VT_MAX_CPUS_SHIFT	0
#define VT_MAX_CPUS_MASK	0x3ff
#define VT_CORES_SHIFT		10
#define VT_CORES_MASK		0x3ff
#define VT_THREADS_SHIFT	20
#define VT_THREADS_MASK		0xfff

#define QEMU_PRINTF_BUFF_BASE	(IO_BASE | SPBU_BASE | 0x40000UL)

/* MSIConfig */
#define MSICONFIG_VALID		(0x1UL << 63)
#define MSICONFIG_EN		(0x1UL << 62)
#define MSICONFIG_VECTOR_SHIFT	10

#define MSIX_MSG_ADDR		(0xfff00000UL)

#define SW64_PCI_IO_BASE(m, n)	\
	(IO_BASE | ((m) << IO_NODE_SHIFT) | PCI_BASE | ((n) << IO_RC_SHIFT))
#define SW64_IO_BASE(x)		(IO_BASE | ((x) << IO_NODE_SHIFT))

#define SW64_PCI0_BUS		0
#define PCI0_BUS		SW64_PCI0_BUS

#define SPBU_BASE		(0x3UL << 36)
#define INTPU_BASE		(0x3aUL << 32)
#define IIC0_BASE		(0x31UL << 32)
#define SPI_BASE		(0x32UL << 32)
#define UART_BASE		(0x33UL << 32)
#define IIC1_BASE		(0x34UL << 32)
#define IIC2_BASE		(0x35UL << 32)
#define GPIO_BASE		(0x36UL << 32)
#define LPC_BASE		(0x37UL << 32)
#define LPC_LEGACY_IO		(0x1UL << 28 | IO_BASE | LPC_BASE)
#define LPC_MEM_IO		(0x2UL << 28 | IO_BASE | LPC_BASE)
#define LPC_FIRMWARE_IO		(0x3UL << 28 | IO_BASE | LPC_BASE)
#define PCI_VT_LEGACY_IO	(IO_BASE | PCI_BASE | PCI_LEGACY_IO)

#define PME_ENABLE_INTD_CORE0	(0x1UL << 62 | 0x8UL << 10)
#define AER_ENABLE_INTD_CORE0	(0x1UL << 62 | 0x8UL << 10)

#define PIUCONFIG0_INIT_VAL	0x38016

/*-----------------------addr-----------------------*/
/* INTPU REG */
enum {
	DEVINT_MISS =		INTPU_BASE | 0x100UL,
	MT_INT_CONFIG =		INTPU_BASE | 0x300UL,
	DEV_INT_CONFIG =	INTPU_BASE | 0x480UL,
	FMT_ERR	=		INTPU_BASE | 0x700UL,
	FAULT_INT_CONFIG =	INTPU_BASE | 0x780UL,
	SERR_CNTTH =		INTPU_BASE | 0x880UL,
	SPBUSERR_CNT =		INTPU_BASE | 0x900UL,
	IRUSERR_CNT =		INTPU_BASE | 0xa80UL,
	ERRRPT_EN =		INTPU_BASE | 0xb00UL,
	IINT_MISS_VECTOR0 =	INTPU_BASE | 0x1080UL,
	IINT_MISS_VECTOR1 =	INTPU_BASE | 0x1100UL,
	IINT_MISS =		INTPU_BASE | 0x1180UL,
	IINT_MISS_RPTEN =	INTPU_BASE | 0x1200UL,
	DEVINT_MISS_RPTEN =	INTPU_BASE | 0x1280UL,
	ECCSERR =		INTPU_BASE | 0x1300UL,
	ECCSERR_RPTEN =		INTPU_BASE | 0x1380UL,
	ECCMERR =		INTPU_BASE | 0x1400UL,
	ECCMERR_RPTEN =		INTPU_BASE | 0x1480UL,
	DEVINT_WKEN =		INTPU_BASE | 0x1500UL,
	ADR_INT_CONFIG =	INTPU_BASE | 0x1580UL,
	DEVINTWK_INTEN =	INTPU_BASE | 0x1600UL,
};

/* SPBU CSR */
enum {
	SMP_INFO =		SPBU_BASE | 0x80UL,
	INIT_CTL =		SPBU_BASE | 0x680UL,
	CORE_ONLINE =		SPBU_BASE | 0x780UL,
	DLI_RLTD_FAULT =	SPBU_BASE | 0x980UL,
	DLI_RLTD_FAULT_EN =	SPBU_BASE | 0xa00UL,
	DLI_RLTD_FAULT_INTEN =	SPBU_BASE | 0xa80UL,
	CFG_INFO =		SPBU_BASE | 0x1100UL,
	IO_START =		SPBU_BASE | 0x1300UL,
	I2C0_SRST_L =		SPBU_BASE | 0x1900UL,
	I2C1_SRST_L =		SPBU_BASE | 0x1980UL,
	I2C2_SRST_L =		SPBU_BASE | 0x1a00UL,
	MCU_DVC_INT =		SPBU_BASE | 0x3000UL,
	MCU_DVC_INT_EN =	SPBU_BASE | 0x3080UL,
	SI_FAULT_STAT =		SPBU_BASE | 0x3100UL,
	SI_FAULT_STAT_EN =	SPBU_BASE | 0x3180UL,
	SI_FAULT_INT_EN =	SPBU_BASE | 0x3200UL,
	ADR_CTL =		SPBU_BASE | 0x3600UL,
	MC_ONLINE =		SPBU_BASE | 0x3780UL,
	CLK_CTL =               SPBU_BASE | 0x3b80UL,
	CLU_LV2_SELH =          SPBU_BASE | 0x3a00UL,
	CLU_LV2_SELL =          SPBU_BASE | 0x3b00UL,
	PIU_TOP0_CONFIG =	SPBU_BASE | 0x4c80UL,
	PIU_TOP1_CONFIG =	SPBU_BASE | 0x4d00UL,
	SOFT_INFO0 =		SPBU_BASE | 0xa000UL,
};

/*--------------------------offset-----------------------------------*/
/* PIU IOR0 */
enum {
	PIUCONFIG0 =		0x0UL,
	EPDMABAR =		0x80UL,
	IOMMUSEGITEM0 =		0x100UL,
	IOMMUEXCPT_CTRL =	0x2100UL,
	MSIADDR =		0x2180UL,
	MSICONFIG0 =		0x2200UL,
	INTACONFIG =		0xa200UL,
	INTBCONFIG =		0xa280UL,
	INTCCONFIG =		0xa300UL,
	INTDCONFIG =		0xa380UL,
	AERERRINTCONFIG =	0xa400UL,
	AERERRMSICONFIG =	0xa480UL,
	PMEINTCONFIG =		0xa500UL,
	PMEMSICONFIG =		0xa580UL,
	HPINTCONFIG =		0xa600UL,
	HPMSICONFIG =		0xa680UL,
	DTBASEADDR =		0xb000UL,
	DTLB_FLUSHALL =		0xb080UL,
	DTLB_FLUSHDEV =		0xb100UL,
	PTLB_FLUSHALL =		0xb180UL,
	PTLB_FLUSHDEV =		0xb200UL,
	PTLB_FLUSHVADDR =	0xb280UL,
	PCACHE_FLUSHALL =	0xb300UL,
	PCACHE_FLUSHDEV =	0xb380UL,
	PCACHE_FLUSHPADDR =	0xb400UL,
	TIMEOUT_CONFIG =	0xb480UL,
	IOMMUEXCPT_STATUS =	0xb500UL,
	IOMMUPAGE_PADDR1 =	0xb580UL,
	IOMMUPAGE_PADDR2 =	0xb600UL,
	IOMMUPAGE_PADDR3 =	0xb680UL,
	PTLB_ACCESS =		0xb700UL,
	PTLB_ITEM_TAG =		0xb780UL,
	PTLB_ITEM_DATA =	0xb800UL,
	PCACHE_ACCESS =		0xb880UL,
	PCACHE_ITEM_TAG =	0xb900UL,
	PCACHE_ITEM_DATA0 =	0xb980UL,
};

/* PIU IOR1 */
enum {
	PIUCONFIG1 =		0x0UL,
	ERRENABLE =		0x880UL,
	RCDEBUGINF1 =		0xc80UL,
	DCACONTROL =		0x1a00UL,
	DEVICEID0 =		0x1a80UL,
};

/* RC */
enum {
	RC_VENDOR_ID =		0x0UL,
	RC_COMMAND =		0x80UL,
	RC_REVISION_ID =	0x100UL,
	RC_PRIMARY_BUS =	0x300UL,
	RC_MSI_CONTROL =	0xa00UL,
	RC_EXP_DEVCAP =		0xe80UL,
	RC_EXP_DEVCTL =		0xf00UL,
	RC_SLOT_CTRL =		0x1100UL,
	RC_LINK_STAT =		0x1000UL,
	RC_CONTROL =		0X1180UL,
	RC_STATUS =		0X1200UL,
	RC_EXP_DEVCTL2 =	0x1300UL,
	RC_PORT_LINK_CTL =	0xe200UL,
	RC_ORDER_RULE_CTL =	0x11680UL,
	RC_MISC_CONTROL_1 =	0x11780UL,
	RC_PHY_INT_REG =	0x80000UL,
	RC_PHY_EXT_GEN1 =	0x82400UL,
	RC_PHY_EXT_GEN2 =	0x82480UL,
};
/* GPIO */
enum {
	GPIO_SWPORTA_DR =	GPIO_BASE | 0x0UL,
	GPIO_SWPORTA_DDR =	GPIO_BASE | 0x200UL,
};
/*--------------------------------------------------------------------------*/
#endif /* _ASM_SW64_UNCORE_IO_JUNZHANG_H */
