; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=constraint-elimination -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"


declare void @use(ptr)
declare void @use.i1(i1)
declare void @llvm.assume(i1)
declare i1 @cond()

define void @test_monotonic_ptr_iv_inc_1_struct_type(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_struct_type(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, i8, i8 }, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, i8, i8}, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_struct_type_offset_0(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_struct_type_offset_0(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, i8, i8 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 0
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, i8, i8}, ptr %start, i16 %len, i32 0
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_struct_type_offset_16(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_struct_type_offset_16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, i8, i8 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, i8, i8}, ptr %start, i16 %len, i32 1
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_struct_type_with_early_exit(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_struct_type_with_early_exit(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, i8, i8 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 0
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, i8, i8}, ptr %start, i16 %len, i32 0
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_struct_type_offset_0_with_early_exit(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_struct_type_offset_0_with_early_exit(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, i8, i8 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 0
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, i8, i8}, ptr %start, i16 %len, i32 0
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_struct_type_offset_16_with_early_exit(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_struct_type_offset_16_with_early_exit(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, i8, i8 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, i8, i8}, ptr %start, i16 %len, i32 1
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_2_struct_type_with_early_exit(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_2_struct_type_with_early_exit(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds { i16, i8, i8 }, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds {i16, i8, i8}, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_2_struct_type_offset_0_with_early_exit(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_2_struct_type_offset_0_with_early_exit(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds { i16, i8, i8 }, ptr [[PTR_IV]], i16 1, i32 0
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds {i16, i8, i8}, ptr %ptr.iv, i16 1, i32 0
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_2_struct_type_offset_16_with_early_exit(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_2_struct_type_offset_16_with_early_exit(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i32, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds { i16, i8, i8 }, ptr [[PTR_IV]], i16 1, i32 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i32, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds {i16, i8, i8}, ptr %ptr.iv, i16 1, i32 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, { i16, i16 }, i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i64, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, {i16, i16}, i16}, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i64, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct_offset_32_step_64(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct_offset_32_step_64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, { i16, i16 }, i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1, i32 1
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i64, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, {i16, i16}, i16}, ptr %start, i16 %len, i32 1, i32 1
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i64, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct_offset_32_step_32(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct_offset_32_step_32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, { i16, i16 }, i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1, i32 1
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, {i16, i16}, i16}, ptr %start, i16 %len, i32 1, i32 1
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct_offset_32_step_16(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct_offset_32_step_16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, { i16, i16 }, i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1, i32 1
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i16, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, {i16, i16}, i16}, ptr %start, i16 %len, i32 1, i32 1
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i16, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_16(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_16(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, [10 x i32], i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1, i16 [[LEN]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i16, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, [10 x i32], i16}, ptr %start, i16 %len, i32 1, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i16, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_16_2(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_16_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, [10 x i32], i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1, i16 [[LEN]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i8, ptr [[PTR_IV]], i16 2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, [10 x i32], i16}, ptr %start, i16 %len, i32 1, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i8, ptr %ptr.iv, i16 2
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_32(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, [10 x i32], i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1, i16 [[LEN]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i32, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, [10 x i32], i16}, ptr %start, i16 %len, i32 1, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i32, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_32_2(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_32_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, [10 x i32], i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1, i16 [[LEN]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i16, ptr [[PTR_IV]], i16 2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, [10 x i32], i16}, ptr %start, i16 %len, i32 1, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i16, ptr %ptr.iv, i16 2
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_64(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, [10 x i32], i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1, i16 [[LEN]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i64, ptr [[PTR_IV]], i16 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, [10 x i32], i16}, ptr %start, i16 %len, i32 1, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i64, ptr %ptr.iv, i16 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_var(ptr %start, i16 %len, i16 %step) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_1_nested_struct_offset_16_plus_32_var_step_var(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds { i16, [10 x i32], i16 }, ptr [[START:%.*]], i16 [[LEN:%.*]], i32 1, i16 [[LEN]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds i16, ptr [[PTR_IV]], i16 [[STEP:%.*]]
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds {i16, [10 x i32], i16}, ptr %start, i16 %len, i32 1, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds i16, ptr %ptr.iv, i16 %step
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_with_struct_type_with_early_exit_offset_48(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_with_struct_type_with_early_exit_offset_48(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i64, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds { i16, i16, i16 }, ptr [[PTR_IV]], i16 1, i32 0
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i64, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds { i16, i16, i16 }, ptr %ptr.iv, i16 1, i32 0
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_with_struct_type_with_early_exit_offset_64(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_with_struct_type_with_early_exit_offset_64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i64, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds { i16, i16, i16 }, ptr [[PTR_IV]], i16 1, i32 1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i64, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds { i16, i16, i16 }, ptr %ptr.iv, i16 1, i32 1
  br label %loop.header

exit:
  ret void
}

define void @test_monotonic_ptr_iv_inc_with_struct_type_with_early_exit_offset_80(ptr %start, i16 %len) {
; CHECK-LABEL: @test_monotonic_ptr_iv_inc_with_struct_type_with_early_exit_offset_80(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UPPER:%.*]] = getelementptr inbounds i64, ptr [[START:%.*]], i16 [[LEN:%.*]]
; CHECK-NEXT:    [[LEN_NEG:%.*]] = icmp slt i16 [[LEN]], 0
; CHECK-NEXT:    br i1 [[LEN_NEG]], label [[EXIT:%.*]], label [[LOOP_PH:%.*]]
; CHECK:       loop.ph:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[START]], [[LOOP_PH]] ], [ [[PTR_IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[C:%.*]] = icmp eq ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    br i1 [[C]], label [[EXIT]], label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[C_1:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[C_1]], label [[LOOP_NEXT:%.*]], label [[EXIT]]
; CHECK:       loop.next:
; CHECK-NEXT:    [[T_1:%.*]] = icmp uge ptr [[PTR_IV]], [[START]]
; CHECK-NEXT:    [[T_2:%.*]] = icmp ult ptr [[PTR_IV]], [[UPPER]]
; CHECK-NEXT:    [[AND:%.*]] = and i1 [[T_1]], [[T_2]]
; CHECK-NEXT:    br i1 [[AND]], label [[LOOP_LATCH]], label [[EXIT]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(ptr [[PTR_IV]])
; CHECK-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds { i16, i16, i16 }, ptr [[PTR_IV]], i16 1, i32 2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %upper = getelementptr inbounds i64, ptr %start, i16 %len
  %len.neg = icmp slt i16 %len, 0
  br i1 %len.neg, label %exit, label %loop.ph

loop.ph:
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %start, %loop.ph ], [ %ptr.iv.next, %loop.latch ]
  %c = icmp eq ptr %ptr.iv, %upper
  br i1 %c, label %exit, label %for.body

for.body:
  %c.1 = call i1 @cond()
  br i1 %c.1, label %loop.next, label %exit

loop.next:
  %t.1 = icmp uge ptr %ptr.iv, %start
  %t.2 = icmp ult ptr %ptr.iv, %upper
  %and = and i1 %t.1, %t.2
  br i1 %and, label %loop.latch, label %exit

loop.latch:
  call void @use(ptr %ptr.iv)
  %ptr.iv.next = getelementptr inbounds { i16, i16, i16 }, ptr %ptr.iv, i16 1, i32 2
  br label %loop.header

exit:
  ret void
}
