/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef _OB_TABLE_PROCESS_TYPE_H
#define _OB_TABLE_PROCESS_TYPE_H 1

#include "sql/resolver/ob_stmt_type.h"
#include "lib/utility/ob_print_utils.h"

namespace oceanbase
{
namespace observer
{
enum ObTableProccessType
{
  TABLE_API_PROCESS_TYPE_INVALID = 0,
  // table single mutate
  TABLE_API_SINGLE_INSERT,
  TABLE_API_SINGLE_GET,
  TABLE_API_SINGLE_DELETE,
  TABLE_API_SINGLE_UPDATE,
  TABLE_API_SINGLE_INSERT_OR_UPDATE,
  TABLE_API_SINGLE_REPLACE,
  TABLE_API_SINGLE_INCREMENT,
  TABLE_API_SINGLE_APPEND,
  TABLE_API_SINGLE_PUT,

  // table batch mutate
  TABLE_API_MULTI_INSERT,
  TABLE_API_MULTI_GET,
  TABLE_API_MULTI_DELETE,
  TABLE_API_MULTI_UPDATE,
  TABLE_API_MULTI_INSERT_OR_UPDATE,
  TABLE_API_MULTI_REPLACE,
  TABLE_API_MULTI_INCREMENT,
  TABLE_API_MULTI_APPEND,
  TABLE_API_BATCH_RETRIVE,
  TABLE_API_BATCH_HYBRID,
  TABLE_API_MULTI_PUT,

  // hbase mutate
  TABLE_API_HBASE_DELETE,
  TABLE_API_HBASE_PUT,
  TABLE_API_HBASE_CHECK_AND_DELETE,
  TABLE_API_HBASE_CHECK_AND_PUT,
  TABLE_API_HBASE_INCREMENT,
  TABLE_API_HBASE_APPEND,
  TABLE_API_HBASE_HYBRID,

  // query
  TABLE_API_TABLE_QUERY,
  TABLE_API_HBASE_QUERY,
  TABLE_API_TABLE_QUERY_ASYNC,
  TABLE_API_HBASE_QUERY_ASYNC,

  // query_and_mutate
  TABLE_API_QUERY_AND_MUTATE,
  TABLE_API_CHECK_AND_INSERT_UP,
  TABLE_API_MULTI_CHECK_AND_INSERT_UP,

  // redis
  // The sequence of redis ObTableProccessType is associated with that of RedisCommandType.
  // If you want to change it, you need to change RedisCommandType simultaneously
  TABLE_API_REDIS_TYPE_OFFSET,
  TABLE_API_REDIS_LINDEX,
  TABLE_API_REDIS_LSET,
  TABLE_API_REDIS_LRANGE,
  TABLE_API_REDIS_LTRIM,
  TABLE_API_REDIS_LPUSH,
  TABLE_API_REDIS_LPUSHX,
  TABLE_API_REDIS_RPUSH,
  TABLE_API_REDIS_RPUSHX,
  TABLE_API_REDIS_LPOP,
  TABLE_API_REDIS_RPOP,
  TABLE_API_REDIS_LREM,
  TABLE_API_REDIS_RPOPLPUSH,
  TABLE_API_REDIS_LINSERT,
  TABLE_API_REDIS_LLEN,
  TABLE_API_REDIS_SDIFF,
  TABLE_API_REDIS_SDIFFSTORE,
  TABLE_API_REDIS_SINTER,
  TABLE_API_REDIS_SINTERSTORE,
  TABLE_API_REDIS_SUNION,
  TABLE_API_REDIS_SUNIONSTORE,
  TABLE_API_REDIS_SADD,
  TABLE_API_REDIS_SCARD,
  TABLE_API_REDIS_SISMEMBER,
  TABLE_API_REDIS_SMEMBERS,
  TABLE_API_REDIS_SMOVE,
  TABLE_API_REDIS_SPOP,
  TABLE_API_REDIS_SRANDMEMBER,
  TABLE_API_REDIS_SREM,
  TABLE_API_REDIS_ZADD,
  TABLE_API_REDIS_ZCARD,
  TABLE_API_REDIS_ZREM,
  TABLE_API_REDIS_ZINCRBY,
  TABLE_API_REDIS_ZSCORE,
  TABLE_API_REDIS_ZRANK,
  TABLE_API_REDIS_ZREVRANK,
  TABLE_API_REDIS_ZRANGE,
  TABLE_API_REDIS_ZREVRANGE,
  TABLE_API_REDIS_ZREMRANGEBYRANK,
  TABLE_API_REDIS_ZCOUNT,
  TABLE_API_REDIS_ZRANGEBYSCORE,
  TABLE_API_REDIS_ZREVRANGEBYSCORE,
  TABLE_API_REDIS_ZREMRANGEBYSCORE,
  TABLE_API_REDIS_ZINTERSTORE,
  TABLE_API_REDIS_ZUNIONSTORE,
  TABLE_API_REDIS_HSET,
  TABLE_API_REDIS_HMSET,
  TABLE_API_REDIS_HSETNX,
  TABLE_API_REDIS_HGET,
  TABLE_API_REDIS_HMGET,
  TABLE_API_REDIS_HGETALL,
  TABLE_API_REDIS_HVALS,
  TABLE_API_REDIS_HKEYS,
  TABLE_API_REDIS_HEXISTS,
  TABLE_API_REDIS_HDEL,
  TABLE_API_REDIS_HINCRBY,
  TABLE_API_REDIS_HINCRBYFLOAT,
  TABLE_API_REDIS_HLEN,
  TABLE_API_REDIS_GETSET,
  TABLE_API_REDIS_SETBIT,
  TABLE_API_REDIS_INCR,
  TABLE_API_REDIS_INCRBY,
  TABLE_API_REDIS_DECR,
  TABLE_API_REDIS_DECRBY,
  TABLE_API_REDIS_APPEND,
  TABLE_API_REDIS_BITCOUNT,
  TABLE_API_REDIS_GET,
  TABLE_API_REDIS_GETBIT,
  TABLE_API_REDIS_GETRANGE,
  TABLE_API_REDIS_INCRBYFLOAT,
  TABLE_API_REDIS_MGET,
  TABLE_API_REDIS_MSET,
  TABLE_API_REDIS_SET,
  TABLE_API_REDIS_PSETEX,
  TABLE_API_REDIS_SETEX,
  TABLE_API_REDIS_SETNX,
  TABLE_API_REDIS_SETRANGE,
  TABLE_API_REDIS_STRLEN,
  TABLE_API_REDIS_TTL,
  TABLE_API_REDIS_PTTL,
  TABLE_API_REDIS_EXPIRE,
  TABLE_API_REDIS_PEXPIRE,
  TABLE_API_REDIS_EXPIREAT,
  TABLE_API_REDIS_PEXPIREAT,
  TABLE_API_REDIS_DEL,
  TABLE_API_REDIS_EXISTS,
  TABLE_API_REDIS_TYPE,
  TABLE_API_REDIS_PERSIST,
  TABLE_API_REDIS_TYPE_MAX,

  // group commit
  TABLE_API_GROUP_TRIGGER,

  TABLE_API_PROCESS_TYPE_MAX
};

struct ObTableHistogramType {
  sql::stmt::StmtType sql_type_;
  ObTableProccessType table_type_;

  TO_STRING_KV(K(sql_type_), K(table_type_));
};
} // end namespace observer
} // end namespace oceanbase

#endif /* _OB_TABLE_PROCESS_TYPE_H */
