/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */
#include "lib/charset/ob_mysql_global.h"

extern const int MIN_ZH2_HAN_PAGE = 0x34;
extern const int MAX_ZH2_HAN_PAGE = 0x313;

uint16 zh2_han_p034[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x1C90,   /* U+3400 */
  0x1C91,   /* U+3401 */
  0x5C49,   /* U+3402 */
  0x5C49,   /* U+3403 */
  0x1CCE,   /* U+3404 */
  0x1D4D,   /* U+3405 */
  0x1D51,   /* U+3406 */
  0x5C49,   /* U+3407 */
  0x5C49,   /* U+3408 */
  0x5C49,   /* U+3409 */
  0x5C49,   /* U+340A */
  0x5C49,   /* U+340B */
  0x1D90,   /* U+340C */
  0x5C49,   /* U+340D */
  0x5C49,   /* U+340E */
  0x5C49,   /* U+340F */
  0x5C49,   /* U+3410 */
  0x5C49,   /* U+3411 */
  0x5C49,   /* U+3412 */
  0x5C49,   /* U+3413 */
  0x5C49,   /* U+3414 */
  0x5C49,   /* U+3415 */
  0x1D92,   /* U+3416 */
  0x5C49,   /* U+3417 */
  0x5C49,   /* U+3418 */
  0x5C49,   /* U+3419 */
  0x5C49,   /* U+341A */
  0x5C49,   /* U+341B */
  0x1D94,   /* U+341C */
  0x5C49,   /* U+341D */
  0x5C49,   /* U+341E */
  0x5C49,   /* U+341F */
  0x5C49,   /* U+3420 */
  0x1D8D,   /* U+3421 */
  0x5C49,   /* U+3422 */
  0x5C49,   /* U+3423 */
  0x1D97,   /* U+3424 */
  0x5C49,   /* U+3425 */
  0x5C49,   /* U+3426 */
  0x5C49,   /* U+3427 */
  0x1DD3,   /* U+3428 */
  0x1E12,   /* U+3429 */
  0x5C49,   /* U+342A */
  0x1E50,   /* U+342B */
  0x1E51,   /* U+342C */
  0x1E52,   /* U+342D */
  0x1E57,   /* U+342E */
  0x1E5B,   /* U+342F */
  0x1E8F,   /* U+3430 */
  0x1E8F,   /* U+3431 */
  0x1E8F,   /* U+3432 */
  0x1E8F,   /* U+3433 */
  0x1E8F,   /* U+3434 */
  0x1E8F,   /* U+3435 */
  0x5C49,   /* U+3436 */
  0x1E8F,   /* U+3437 */
  0x1E90,   /* U+3438 */
  0x1E90,   /* U+3439 */
  0x1E90,   /* U+343A */
  0x1E90,   /* U+343B */
  0x1E90,   /* U+343C */
  0x1E90,   /* U+343D */
  0x1E90,   /* U+343E */
  0x5C49,   /* U+343F */
  0x5C49,   /* U+3440 */
  0x1E91,   /* U+3441 */
  0x1E91,   /* U+3442 */
  0x1E91,   /* U+3443 */
  0x1E91,   /* U+3444 */
  0x1E91,   /* U+3445 */
  0x1E91,   /* U+3446 */
  0x1E91,   /* U+3447 */
  0x1E91,   /* U+3448 */
  0x1E92,   /* U+3449 */
  0x1E92,   /* U+344A */
  0x1E92,   /* U+344B */
  0x1E92,   /* U+344C */
  0x1E92,   /* U+344D */
  0x1E92,   /* U+344E */
  0x1E92,   /* U+344F */
  0x1E92,   /* U+3450 */
  0x5C49,   /* U+3451 */
  0x5C49,   /* U+3452 */
  0x5C49,   /* U+3453 */
  0x1E92,   /* U+3454 */
  0x1E92,   /* U+3455 */
  0x5C49,   /* U+3456 */
  0x1E93,   /* U+3457 */
  0x1E93,   /* U+3458 */
  0x1E93,   /* U+3459 */
  0x1E93,   /* U+345A */
  0x1E93,   /* U+345B */
  0x1E93,   /* U+345C */
  0x1E93,   /* U+345D */
  0x1E93,   /* U+345E */
  0x1E93,   /* U+345F */
  0x1E93,   /* U+3460 */
  0x5C49,   /* U+3461 */
  0x1E93,   /* U+3462 */
  0x1E94,   /* U+3463 */
  0x1E95,   /* U+3464 */
  0x1E94,   /* U+3465 */
  0x1E94,   /* U+3466 */
  0x1E94,   /* U+3467 */
  0x5C49,   /* U+3468 */
  0x1E94,   /* U+3469 */
  0x5C49,   /* U+346A */
  0x1E94,   /* U+346B */
  0x5C49,   /* U+346C */
  0x5C49,   /* U+346D */
  0x1E95,   /* U+346E */
  0x1E95,   /* U+346F */
  0x1E95,   /* U+3470 */
  0x1E95,   /* U+3471 */
  0x1E95,   /* U+3472 */
  0x1E8D,   /* U+3473 */
  0x1E8D,   /* U+3474 */
  0x1E8D,   /* U+3475 */
  0x1E8D,   /* U+3476 */
  0x1E8D,   /* U+3477 */
  0x1E8D,   /* U+3478 */
  0x5C49,   /* U+3479 */
  0x1E8D,   /* U+347A */
  0x1E97,   /* U+347B */
  0x1E97,   /* U+347C */
  0x1E97,   /* U+347D */
  0x1E97,   /* U+347E */
  0x1E97,   /* U+347F */
  0x1E97,   /* U+3480 */
  0x1E97,   /* U+3481 */
  0x1E98,   /* U+3482 */
  0x1E98,   /* U+3483 */
  0x1E98,   /* U+3484 */
  0x1E98,   /* U+3485 */
  0x1E98,   /* U+3486 */
  0x1E98,   /* U+3487 */
  0x1E98,   /* U+3488 */
  0x1E98,   /* U+3489 */
  0x1E98,   /* U+348A */
  0x1E98,   /* U+348B */
  0x1E98,   /* U+348C */
  0x1E98,   /* U+348D */
  0x1E98,   /* U+348E */
  0x5C49,   /* U+348F */
  0x5C49,   /* U+3490 */
  0x1E99,   /* U+3491 */
  0x1E99,   /* U+3492 */
  0x1E99,   /* U+3493 */
  0x1E99,   /* U+3494 */
  0x1E99,   /* U+3495 */
  0x1E99,   /* U+3496 */
  0x5C49,   /* U+3497 */
  0x1E99,   /* U+3498 */
  0x1E9A,   /* U+3499 */
  0x1E9A,   /* U+349A */
  0x1E9A,   /* U+349B */
  0x1E9A,   /* U+349C */
  0x1E9B,   /* U+349D */
  0x1E9B,   /* U+349E */
  0x1E9C,   /* U+349F */
  0x1E9C,   /* U+34A0 */
  0x1E9D,   /* U+34A1 */
  0x5C49,   /* U+34A2 */
  0x5C49,   /* U+34A3 */
  0x1E9E,   /* U+34A4 */
  0x1E9E,   /* U+34A5 */
  0x1E9E,   /* U+34A6 */
  0x1E9F,   /* U+34A7 */
  0x1E9F,   /* U+34A8 */
  0x1EA1,   /* U+34A9 */
  0x1EA4,   /* U+34AA */
  0x1ED0,   /* U+34AB */
  0x1ED2,   /* U+34AC */
  0x1ED4,   /* U+34AD */
  0x1ED5,   /* U+34AE */
  0x5C49,   /* U+34AF */
  0x1F0F,   /* U+34B0 */
  0x5C49,   /* U+34B1 */
  0x1F10,   /* U+34B2 */
  0x1F11,   /* U+34B3 */
  0x1F11,   /* U+34B4 */
  0x1F51,   /* U+34B5 */
  0x1F51,   /* U+34B6 */
  0x1F51,   /* U+34B7 */
  0x1F53,   /* U+34B8 */
  0x1F5E,   /* U+34B9 */
  0x5C49,   /* U+34BA */
  0x1F95,   /* U+34BB */
  0x1F95,   /* U+34BC */
  0x1F8D,   /* U+34BD */
  0x1F97,   /* U+34BE */
  0x1F8E,   /* U+34BF */
  0x5C49,   /* U+34C0 */
  0x5C49,   /* U+34C1 */
  0x1FD3,   /* U+34C2 */
  0x1FCD,   /* U+34C3 */
  0x1FD9,   /* U+34C4 */
  0x200E,   /* U+34C5 */
  0x2010,   /* U+34C6 */
  0x5C49,   /* U+34C7 */
  0x2011,   /* U+34C8 */
  0x2012,   /* U+34C9 */
  0x2012,   /* U+34CA */
  0x2012,   /* U+34CB */
  0x2012,   /* U+34CC */
  0x2012,   /* U+34CD */
  0x2013,   /* U+34CE */
  0x2013,   /* U+34CF */
  0x2014,   /* U+34D0 */
  0x2014,   /* U+34D1 */
  0x5C49,   /* U+34D2 */
  0x2015,   /* U+34D3 */
  0x200D,   /* U+34D4 */
  0x5C49,   /* U+34D5 */
  0x2017,   /* U+34D6 */
  0x2018,   /* U+34D7 */
  0x2055,   /* U+34D8 */
  0x5C49,   /* U+34D9 */
  0x20CF,   /* U+34DA */
  0x5C49,   /* U+34DB */
  0x20CF,   /* U+34DC */
  0x20D0,   /* U+34DD */
  0x20D0,   /* U+34DE */
  0x20D1,   /* U+34DF */
  0x20D1,   /* U+34E0 */
  0x20D2,   /* U+34E1 */
  0x20D2,   /* U+34E2 */
  0x20D2,   /* U+34E3 */
  0x20D2,   /* U+34E4 */
  0x20D2,   /* U+34E5 */
  0x20D2,   /* U+34E6 */
  0x20D3,   /* U+34E7 */
  0x20D3,   /* U+34E8 */
  0x20D3,   /* U+34E9 */
  0x20D3,   /* U+34EA */
  0x20D3,   /* U+34EB */
  0x20D4,   /* U+34EC */
  0x20D4,   /* U+34ED */
  0x20D4,   /* U+34EE */
  0x20D4,   /* U+34EF */
  0x5C49,   /* U+34F0 */
  0x20D5,   /* U+34F1 */
  0x20D5,   /* U+34F2 */
  0x20D5,   /* U+34F3 */
  0x20D5,   /* U+34F4 */
  0x20D5,   /* U+34F5 */
  0x20D5,   /* U+34F6 */
  0x20CD,   /* U+34F7 */
  0x20CD,   /* U+34F8 */
  0x20CD,   /* U+34F9 */
  0x20CD,   /* U+34FA */
  0x20CD,   /* U+34FB */
  0x20D7,   /* U+34FC */
  0x20D7,   /* U+34FD */
  0x20D8,   /* U+34FE */
  0x5C49,   /* U+34FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3400 */
  0x0020,   /* U+3401 */
  0x0020,   /* U+3402 */
  0x0020,   /* U+3403 */
  0x0020,   /* U+3404 */
  0x0020,   /* U+3405 */
  0x0020,   /* U+3406 */
  0x0020,   /* U+3407 */
  0x0020,   /* U+3408 */
  0x0020,   /* U+3409 */
  0x0020,   /* U+340A */
  0x0020,   /* U+340B */
  0x0020,   /* U+340C */
  0x0020,   /* U+340D */
  0x0020,   /* U+340E */
  0x0020,   /* U+340F */
  0x0020,   /* U+3410 */
  0x0020,   /* U+3411 */
  0x0020,   /* U+3412 */
  0x0020,   /* U+3413 */
  0x0020,   /* U+3414 */
  0x0020,   /* U+3415 */
  0x0020,   /* U+3416 */
  0x0020,   /* U+3417 */
  0x0020,   /* U+3418 */
  0x0020,   /* U+3419 */
  0x0020,   /* U+341A */
  0x0020,   /* U+341B */
  0x0020,   /* U+341C */
  0x0020,   /* U+341D */
  0x0020,   /* U+341E */
  0x0020,   /* U+341F */
  0x0020,   /* U+3420 */
  0x0020,   /* U+3421 */
  0x0020,   /* U+3422 */
  0x0020,   /* U+3423 */
  0x0020,   /* U+3424 */
  0x0020,   /* U+3425 */
  0x0020,   /* U+3426 */
  0x0020,   /* U+3427 */
  0x0020,   /* U+3428 */
  0x0020,   /* U+3429 */
  0x0020,   /* U+342A */
  0x0020,   /* U+342B */
  0x0020,   /* U+342C */
  0x0020,   /* U+342D */
  0x0020,   /* U+342E */
  0x0020,   /* U+342F */
  0x0020,   /* U+3430 */
  0x0020,   /* U+3431 */
  0x0020,   /* U+3432 */
  0x0020,   /* U+3433 */
  0x0020,   /* U+3434 */
  0x0020,   /* U+3435 */
  0x0020,   /* U+3436 */
  0x0020,   /* U+3437 */
  0x0020,   /* U+3438 */
  0x0020,   /* U+3439 */
  0x0020,   /* U+343A */
  0x0020,   /* U+343B */
  0x0020,   /* U+343C */
  0x0020,   /* U+343D */
  0x0020,   /* U+343E */
  0x0020,   /* U+343F */
  0x0020,   /* U+3440 */
  0x0020,   /* U+3441 */
  0x0020,   /* U+3442 */
  0x0020,   /* U+3443 */
  0x0020,   /* U+3444 */
  0x0020,   /* U+3445 */
  0x0020,   /* U+3446 */
  0x0020,   /* U+3447 */
  0x0020,   /* U+3448 */
  0x0020,   /* U+3449 */
  0x0020,   /* U+344A */
  0x0020,   /* U+344B */
  0x0020,   /* U+344C */
  0x0020,   /* U+344D */
  0x0020,   /* U+344E */
  0x0020,   /* U+344F */
  0x0020,   /* U+3450 */
  0x0020,   /* U+3451 */
  0x0020,   /* U+3452 */
  0x0020,   /* U+3453 */
  0x0020,   /* U+3454 */
  0x0020,   /* U+3455 */
  0x0020,   /* U+3456 */
  0x0020,   /* U+3457 */
  0x0020,   /* U+3458 */
  0x0020,   /* U+3459 */
  0x0020,   /* U+345A */
  0x0020,   /* U+345B */
  0x0020,   /* U+345C */
  0x0020,   /* U+345D */
  0x0020,   /* U+345E */
  0x0020,   /* U+345F */
  0x0020,   /* U+3460 */
  0x0020,   /* U+3461 */
  0x0020,   /* U+3462 */
  0x0020,   /* U+3463 */
  0x0020,   /* U+3464 */
  0x0020,   /* U+3465 */
  0x0020,   /* U+3466 */
  0x0020,   /* U+3467 */
  0x0020,   /* U+3468 */
  0x0020,   /* U+3469 */
  0x0020,   /* U+346A */
  0x0020,   /* U+346B */
  0x0020,   /* U+346C */
  0x0020,   /* U+346D */
  0x0020,   /* U+346E */
  0x0020,   /* U+346F */
  0x0020,   /* U+3470 */
  0x0020,   /* U+3471 */
  0x0020,   /* U+3472 */
  0x0020,   /* U+3473 */
  0x0020,   /* U+3474 */
  0x0020,   /* U+3475 */
  0x0020,   /* U+3476 */
  0x0020,   /* U+3477 */
  0x0020,   /* U+3478 */
  0x0020,   /* U+3479 */
  0x0020,   /* U+347A */
  0x0020,   /* U+347B */
  0x0020,   /* U+347C */
  0x0020,   /* U+347D */
  0x0020,   /* U+347E */
  0x0020,   /* U+347F */
  0x0020,   /* U+3480 */
  0x0020,   /* U+3481 */
  0x0020,   /* U+3482 */
  0x0020,   /* U+3483 */
  0x0020,   /* U+3484 */
  0x0020,   /* U+3485 */
  0x0020,   /* U+3486 */
  0x0020,   /* U+3487 */
  0x0020,   /* U+3488 */
  0x0020,   /* U+3489 */
  0x0020,   /* U+348A */
  0x0020,   /* U+348B */
  0x0020,   /* U+348C */
  0x0020,   /* U+348D */
  0x0020,   /* U+348E */
  0x0020,   /* U+348F */
  0x0020,   /* U+3490 */
  0x0020,   /* U+3491 */
  0x0020,   /* U+3492 */
  0x0020,   /* U+3493 */
  0x0020,   /* U+3494 */
  0x0020,   /* U+3495 */
  0x0020,   /* U+3496 */
  0x0020,   /* U+3497 */
  0x0020,   /* U+3498 */
  0x0020,   /* U+3499 */
  0x0020,   /* U+349A */
  0x0020,   /* U+349B */
  0x0020,   /* U+349C */
  0x0020,   /* U+349D */
  0x0020,   /* U+349E */
  0x0020,   /* U+349F */
  0x0020,   /* U+34A0 */
  0x0020,   /* U+34A1 */
  0x0020,   /* U+34A2 */
  0x0020,   /* U+34A3 */
  0x0020,   /* U+34A4 */
  0x0020,   /* U+34A5 */
  0x0020,   /* U+34A6 */
  0x0020,   /* U+34A7 */
  0x0020,   /* U+34A8 */
  0x0020,   /* U+34A9 */
  0x0020,   /* U+34AA */
  0x0020,   /* U+34AB */
  0x0020,   /* U+34AC */
  0x0020,   /* U+34AD */
  0x0020,   /* U+34AE */
  0x0020,   /* U+34AF */
  0x0020,   /* U+34B0 */
  0x0020,   /* U+34B1 */
  0x0020,   /* U+34B2 */
  0x0020,   /* U+34B3 */
  0x0020,   /* U+34B4 */
  0x0020,   /* U+34B5 */
  0x0020,   /* U+34B6 */
  0x0020,   /* U+34B7 */
  0x0020,   /* U+34B8 */
  0x0020,   /* U+34B9 */
  0x0020,   /* U+34BA */
  0x0020,   /* U+34BB */
  0x0020,   /* U+34BC */
  0x0020,   /* U+34BD */
  0x0020,   /* U+34BE */
  0x0020,   /* U+34BF */
  0x0020,   /* U+34C0 */
  0x0020,   /* U+34C1 */
  0x0020,   /* U+34C2 */
  0x0020,   /* U+34C3 */
  0x0020,   /* U+34C4 */
  0x0020,   /* U+34C5 */
  0x0020,   /* U+34C6 */
  0x0020,   /* U+34C7 */
  0x0020,   /* U+34C8 */
  0x0020,   /* U+34C9 */
  0x0020,   /* U+34CA */
  0x0020,   /* U+34CB */
  0x0020,   /* U+34CC */
  0x0020,   /* U+34CD */
  0x0020,   /* U+34CE */
  0x0020,   /* U+34CF */
  0x0020,   /* U+34D0 */
  0x0020,   /* U+34D1 */
  0x0020,   /* U+34D2 */
  0x0020,   /* U+34D3 */
  0x0020,   /* U+34D4 */
  0x0020,   /* U+34D5 */
  0x0020,   /* U+34D6 */
  0x0020,   /* U+34D7 */
  0x0020,   /* U+34D8 */
  0x0020,   /* U+34D9 */
  0x0020,   /* U+34DA */
  0x0020,   /* U+34DB */
  0x0020,   /* U+34DC */
  0x0020,   /* U+34DD */
  0x0020,   /* U+34DE */
  0x0020,   /* U+34DF */
  0x0020,   /* U+34E0 */
  0x0020,   /* U+34E1 */
  0x0020,   /* U+34E2 */
  0x0020,   /* U+34E3 */
  0x0020,   /* U+34E4 */
  0x0020,   /* U+34E5 */
  0x0020,   /* U+34E6 */
  0x0020,   /* U+34E7 */
  0x0020,   /* U+34E8 */
  0x0020,   /* U+34E9 */
  0x0020,   /* U+34EA */
  0x0020,   /* U+34EB */
  0x0020,   /* U+34EC */
  0x0020,   /* U+34ED */
  0x0020,   /* U+34EE */
  0x0020,   /* U+34EF */
  0x0020,   /* U+34F0 */
  0x0020,   /* U+34F1 */
  0x0020,   /* U+34F2 */
  0x0020,   /* U+34F3 */
  0x0020,   /* U+34F4 */
  0x0020,   /* U+34F5 */
  0x0020,   /* U+34F6 */
  0x0020,   /* U+34F7 */
  0x0020,   /* U+34F8 */
  0x0020,   /* U+34F9 */
  0x0020,   /* U+34FA */
  0x0020,   /* U+34FB */
  0x0020,   /* U+34FC */
  0x0020,   /* U+34FD */
  0x0020,   /* U+34FE */
  0x0020,   /* U+34FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3400 */
  0x0002,   /* U+3401 */
  0x0002,   /* U+3402 */
  0x0002,   /* U+3403 */
  0x0002,   /* U+3404 */
  0x0002,   /* U+3405 */
  0x0002,   /* U+3406 */
  0x0002,   /* U+3407 */
  0x0002,   /* U+3408 */
  0x0002,   /* U+3409 */
  0x0002,   /* U+340A */
  0x0002,   /* U+340B */
  0x0002,   /* U+340C */
  0x0002,   /* U+340D */
  0x0002,   /* U+340E */
  0x0002,   /* U+340F */
  0x0002,   /* U+3410 */
  0x0002,   /* U+3411 */
  0x0002,   /* U+3412 */
  0x0002,   /* U+3413 */
  0x0002,   /* U+3414 */
  0x0002,   /* U+3415 */
  0x0002,   /* U+3416 */
  0x0002,   /* U+3417 */
  0x0002,   /* U+3418 */
  0x0002,   /* U+3419 */
  0x0002,   /* U+341A */
  0x0002,   /* U+341B */
  0x0002,   /* U+341C */
  0x0002,   /* U+341D */
  0x0002,   /* U+341E */
  0x0002,   /* U+341F */
  0x0002,   /* U+3420 */
  0x0002,   /* U+3421 */
  0x0002,   /* U+3422 */
  0x0002,   /* U+3423 */
  0x0002,   /* U+3424 */
  0x0002,   /* U+3425 */
  0x0002,   /* U+3426 */
  0x0002,   /* U+3427 */
  0x0002,   /* U+3428 */
  0x0002,   /* U+3429 */
  0x0002,   /* U+342A */
  0x0002,   /* U+342B */
  0x0002,   /* U+342C */
  0x0002,   /* U+342D */
  0x0002,   /* U+342E */
  0x0002,   /* U+342F */
  0x0002,   /* U+3430 */
  0x0002,   /* U+3431 */
  0x0002,   /* U+3432 */
  0x0002,   /* U+3433 */
  0x0002,   /* U+3434 */
  0x0002,   /* U+3435 */
  0x0002,   /* U+3436 */
  0x0002,   /* U+3437 */
  0x0002,   /* U+3438 */
  0x0002,   /* U+3439 */
  0x0002,   /* U+343A */
  0x0002,   /* U+343B */
  0x0002,   /* U+343C */
  0x0002,   /* U+343D */
  0x0002,   /* U+343E */
  0x0002,   /* U+343F */
  0x0002,   /* U+3440 */
  0x0002,   /* U+3441 */
  0x0002,   /* U+3442 */
  0x0002,   /* U+3443 */
  0x0002,   /* U+3444 */
  0x0002,   /* U+3445 */
  0x0002,   /* U+3446 */
  0x0002,   /* U+3447 */
  0x0002,   /* U+3448 */
  0x0002,   /* U+3449 */
  0x0002,   /* U+344A */
  0x0002,   /* U+344B */
  0x0002,   /* U+344C */
  0x0002,   /* U+344D */
  0x0002,   /* U+344E */
  0x0002,   /* U+344F */
  0x0002,   /* U+3450 */
  0x0002,   /* U+3451 */
  0x0002,   /* U+3452 */
  0x0002,   /* U+3453 */
  0x0002,   /* U+3454 */
  0x0002,   /* U+3455 */
  0x0002,   /* U+3456 */
  0x0002,   /* U+3457 */
  0x0002,   /* U+3458 */
  0x0002,   /* U+3459 */
  0x0002,   /* U+345A */
  0x0002,   /* U+345B */
  0x0002,   /* U+345C */
  0x0002,   /* U+345D */
  0x0002,   /* U+345E */
  0x0002,   /* U+345F */
  0x0002,   /* U+3460 */
  0x0002,   /* U+3461 */
  0x0002,   /* U+3462 */
  0x0002,   /* U+3463 */
  0x0002,   /* U+3464 */
  0x0002,   /* U+3465 */
  0x0002,   /* U+3466 */
  0x0002,   /* U+3467 */
  0x0002,   /* U+3468 */
  0x0002,   /* U+3469 */
  0x0002,   /* U+346A */
  0x0002,   /* U+346B */
  0x0002,   /* U+346C */
  0x0002,   /* U+346D */
  0x0002,   /* U+346E */
  0x0002,   /* U+346F */
  0x0002,   /* U+3470 */
  0x0002,   /* U+3471 */
  0x0002,   /* U+3472 */
  0x0002,   /* U+3473 */
  0x0002,   /* U+3474 */
  0x0002,   /* U+3475 */
  0x0002,   /* U+3476 */
  0x0002,   /* U+3477 */
  0x0002,   /* U+3478 */
  0x0002,   /* U+3479 */
  0x0002,   /* U+347A */
  0x0002,   /* U+347B */
  0x0002,   /* U+347C */
  0x0002,   /* U+347D */
  0x0002,   /* U+347E */
  0x0002,   /* U+347F */
  0x0002,   /* U+3480 */
  0x0002,   /* U+3481 */
  0x0002,   /* U+3482 */
  0x0002,   /* U+3483 */
  0x0002,   /* U+3484 */
  0x0002,   /* U+3485 */
  0x0002,   /* U+3486 */
  0x0002,   /* U+3487 */
  0x0002,   /* U+3488 */
  0x0002,   /* U+3489 */
  0x0002,   /* U+348A */
  0x0002,   /* U+348B */
  0x0002,   /* U+348C */
  0x0002,   /* U+348D */
  0x0002,   /* U+348E */
  0x0002,   /* U+348F */
  0x0002,   /* U+3490 */
  0x0002,   /* U+3491 */
  0x0002,   /* U+3492 */
  0x0002,   /* U+3493 */
  0x0002,   /* U+3494 */
  0x0002,   /* U+3495 */
  0x0002,   /* U+3496 */
  0x0002,   /* U+3497 */
  0x0002,   /* U+3498 */
  0x0002,   /* U+3499 */
  0x0002,   /* U+349A */
  0x0002,   /* U+349B */
  0x0002,   /* U+349C */
  0x0002,   /* U+349D */
  0x0002,   /* U+349E */
  0x0002,   /* U+349F */
  0x0002,   /* U+34A0 */
  0x0002,   /* U+34A1 */
  0x0002,   /* U+34A2 */
  0x0002,   /* U+34A3 */
  0x0002,   /* U+34A4 */
  0x0002,   /* U+34A5 */
  0x0002,   /* U+34A6 */
  0x0002,   /* U+34A7 */
  0x0002,   /* U+34A8 */
  0x0002,   /* U+34A9 */
  0x0002,   /* U+34AA */
  0x0002,   /* U+34AB */
  0x0002,   /* U+34AC */
  0x0002,   /* U+34AD */
  0x0002,   /* U+34AE */
  0x0002,   /* U+34AF */
  0x0002,   /* U+34B0 */
  0x0002,   /* U+34B1 */
  0x0002,   /* U+34B2 */
  0x0002,   /* U+34B3 */
  0x0002,   /* U+34B4 */
  0x0002,   /* U+34B5 */
  0x0002,   /* U+34B6 */
  0x0002,   /* U+34B7 */
  0x0002,   /* U+34B8 */
  0x0002,   /* U+34B9 */
  0x0002,   /* U+34BA */
  0x0002,   /* U+34BB */
  0x0002,   /* U+34BC */
  0x0002,   /* U+34BD */
  0x0002,   /* U+34BE */
  0x0002,   /* U+34BF */
  0x0002,   /* U+34C0 */
  0x0002,   /* U+34C1 */
  0x0002,   /* U+34C2 */
  0x0002,   /* U+34C3 */
  0x0002,   /* U+34C4 */
  0x0002,   /* U+34C5 */
  0x0002,   /* U+34C6 */
  0x0002,   /* U+34C7 */
  0x0002,   /* U+34C8 */
  0x0002,   /* U+34C9 */
  0x0002,   /* U+34CA */
  0x0002,   /* U+34CB */
  0x0002,   /* U+34CC */
  0x0002,   /* U+34CD */
  0x0002,   /* U+34CE */
  0x0002,   /* U+34CF */
  0x0002,   /* U+34D0 */
  0x0002,   /* U+34D1 */
  0x0002,   /* U+34D2 */
  0x0002,   /* U+34D3 */
  0x0002,   /* U+34D4 */
  0x0002,   /* U+34D5 */
  0x0002,   /* U+34D6 */
  0x0002,   /* U+34D7 */
  0x0002,   /* U+34D8 */
  0x0002,   /* U+34D9 */
  0x0002,   /* U+34DA */
  0x0002,   /* U+34DB */
  0x0002,   /* U+34DC */
  0x0002,   /* U+34DD */
  0x0002,   /* U+34DE */
  0x0002,   /* U+34DF */
  0x0002,   /* U+34E0 */
  0x0002,   /* U+34E1 */
  0x0002,   /* U+34E2 */
  0x0002,   /* U+34E3 */
  0x0002,   /* U+34E4 */
  0x0002,   /* U+34E5 */
  0x0002,   /* U+34E6 */
  0x0002,   /* U+34E7 */
  0x0002,   /* U+34E8 */
  0x0002,   /* U+34E9 */
  0x0002,   /* U+34EA */
  0x0002,   /* U+34EB */
  0x0002,   /* U+34EC */
  0x0002,   /* U+34ED */
  0x0002,   /* U+34EE */
  0x0002,   /* U+34EF */
  0x0002,   /* U+34F0 */
  0x0002,   /* U+34F1 */
  0x0002,   /* U+34F2 */
  0x0002,   /* U+34F3 */
  0x0002,   /* U+34F4 */
  0x0002,   /* U+34F5 */
  0x0002,   /* U+34F6 */
  0x0002,   /* U+34F7 */
  0x0002,   /* U+34F8 */
  0x0002,   /* U+34F9 */
  0x0002,   /* U+34FA */
  0x0002,   /* U+34FB */
  0x0002,   /* U+34FC */
  0x0002,   /* U+34FD */
  0x0002,   /* U+34FE */
  0x0002,   /* U+34FF */

  /* Primary weight 2 for each character. */
  0x8000,   /* U+3400 */
  0x8000,   /* U+3401 */
  0xB402,   /* U+3402 */
  0xB403,   /* U+3403 */
  0x8000,   /* U+3404 */
  0x8000,   /* U+3405 */
  0x8000,   /* U+3406 */
  0xB407,   /* U+3407 */
  0xB408,   /* U+3408 */
  0xB409,   /* U+3409 */
  0xB40A,   /* U+340A */
  0xB40B,   /* U+340B */
  0x8000,   /* U+340C */
  0xB40D,   /* U+340D */
  0xB40E,   /* U+340E */
  0xB40F,   /* U+340F */
  0xB410,   /* U+3410 */
  0xB411,   /* U+3411 */
  0xB412,   /* U+3412 */
  0xB413,   /* U+3413 */
  0xB414,   /* U+3414 */
  0xB415,   /* U+3415 */
  0x8000,   /* U+3416 */
  0xB417,   /* U+3417 */
  0xB418,   /* U+3418 */
  0xB419,   /* U+3419 */
  0xB41A,   /* U+341A */
  0xB41B,   /* U+341B */
  0x8000,   /* U+341C */
  0xB41D,   /* U+341D */
  0xB41E,   /* U+341E */
  0xB41F,   /* U+341F */
  0xB420,   /* U+3420 */
  0x8000,   /* U+3421 */
  0xB422,   /* U+3422 */
  0xB423,   /* U+3423 */
  0x8000,   /* U+3424 */
  0xB425,   /* U+3425 */
  0xB426,   /* U+3426 */
  0xB427,   /* U+3427 */
  0x8000,   /* U+3428 */
  0x8000,   /* U+3429 */
  0xB42A,   /* U+342A */
  0x8000,   /* U+342B */
  0x8000,   /* U+342C */
  0x8000,   /* U+342D */
  0x8000,   /* U+342E */
  0x8000,   /* U+342F */
  0x8000,   /* U+3430 */
  0x8001,   /* U+3431 */
  0x8002,   /* U+3432 */
  0x8003,   /* U+3433 */
  0x8004,   /* U+3434 */
  0x8005,   /* U+3435 */
  0xB436,   /* U+3436 */
  0x8006,   /* U+3437 */
  0x8000,   /* U+3438 */
  0x8001,   /* U+3439 */
  0x8002,   /* U+343A */
  0x8003,   /* U+343B */
  0x8004,   /* U+343C */
  0x8005,   /* U+343D */
  0x8006,   /* U+343E */
  0xB43F,   /* U+343F */
  0xB440,   /* U+3440 */
  0x8000,   /* U+3441 */
  0x8001,   /* U+3442 */
  0x8002,   /* U+3443 */
  0x8003,   /* U+3444 */
  0x8004,   /* U+3445 */
  0x8005,   /* U+3446 */
  0x8006,   /* U+3447 */
  0x8007,   /* U+3448 */
  0x8000,   /* U+3449 */
  0x8001,   /* U+344A */
  0x8002,   /* U+344B */
  0x8003,   /* U+344C */
  0x8004,   /* U+344D */
  0x8005,   /* U+344E */
  0x8006,   /* U+344F */
  0x8007,   /* U+3450 */
  0xB451,   /* U+3451 */
  0xB452,   /* U+3452 */
  0xB453,   /* U+3453 */
  0x8008,   /* U+3454 */
  0x8009,   /* U+3455 */
  0xB456,   /* U+3456 */
  0x8000,   /* U+3457 */
  0x8001,   /* U+3458 */
  0x8002,   /* U+3459 */
  0x8003,   /* U+345A */
  0x8004,   /* U+345B */
  0x8005,   /* U+345C */
  0x8006,   /* U+345D */
  0x8007,   /* U+345E */
  0x8008,   /* U+345F */
  0x8009,   /* U+3460 */
  0xB461,   /* U+3461 */
  0x800A,   /* U+3462 */
  0x8000,   /* U+3463 */
  0x8000,   /* U+3464 */
  0x8001,   /* U+3465 */
  0x8002,   /* U+3466 */
  0x8003,   /* U+3467 */
  0xB468,   /* U+3468 */
  0x8004,   /* U+3469 */
  0xB46A,   /* U+346A */
  0x8005,   /* U+346B */
  0xB46C,   /* U+346C */
  0xB46D,   /* U+346D */
  0x8001,   /* U+346E */
  0x8002,   /* U+346F */
  0x8003,   /* U+3470 */
  0x8004,   /* U+3471 */
  0x8005,   /* U+3472 */
  0x8000,   /* U+3473 */
  0x8001,   /* U+3474 */
  0x8002,   /* U+3475 */
  0x8003,   /* U+3476 */
  0x8004,   /* U+3477 */
  0x8005,   /* U+3478 */
  0xB479,   /* U+3479 */
  0x8006,   /* U+347A */
  0x8000,   /* U+347B */
  0x8001,   /* U+347C */
  0x8002,   /* U+347D */
  0x8003,   /* U+347E */
  0x8004,   /* U+347F */
  0x8005,   /* U+3480 */
  0x8006,   /* U+3481 */
  0x8000,   /* U+3482 */
  0x8001,   /* U+3483 */
  0x8002,   /* U+3484 */
  0x8003,   /* U+3485 */
  0x8004,   /* U+3486 */
  0x8005,   /* U+3487 */
  0x8006,   /* U+3488 */
  0x8007,   /* U+3489 */
  0x8008,   /* U+348A */
  0x8009,   /* U+348B */
  0x800A,   /* U+348C */
  0x800B,   /* U+348D */
  0x800C,   /* U+348E */
  0xB48F,   /* U+348F */
  0xB490,   /* U+3490 */
  0x8000,   /* U+3491 */
  0x8001,   /* U+3492 */
  0x8002,   /* U+3493 */
  0x8003,   /* U+3494 */
  0x8004,   /* U+3495 */
  0x8005,   /* U+3496 */
  0xB497,   /* U+3497 */
  0x8006,   /* U+3498 */
  0x8000,   /* U+3499 */
  0x8001,   /* U+349A */
  0x8002,   /* U+349B */
  0x8003,   /* U+349C */
  0x8000,   /* U+349D */
  0x8001,   /* U+349E */
  0x8000,   /* U+349F */
  0x8001,   /* U+34A0 */
  0x8000,   /* U+34A1 */
  0xB4A2,   /* U+34A2 */
  0xB4A3,   /* U+34A3 */
  0x8000,   /* U+34A4 */
  0x8001,   /* U+34A5 */
  0x8002,   /* U+34A6 */
  0x8000,   /* U+34A7 */
  0x8001,   /* U+34A8 */
  0x8000,   /* U+34A9 */
  0x8000,   /* U+34AA */
  0x8000,   /* U+34AB */
  0x8000,   /* U+34AC */
  0x8000,   /* U+34AD */
  0x8000,   /* U+34AE */
  0xB4AF,   /* U+34AF */
  0x8000,   /* U+34B0 */
  0xB4B1,   /* U+34B1 */
  0x8000,   /* U+34B2 */
  0x8000,   /* U+34B3 */
  0x8001,   /* U+34B4 */
  0x8000,   /* U+34B5 */
  0x8001,   /* U+34B6 */
  0x8002,   /* U+34B7 */
  0x8000,   /* U+34B8 */
  0x8000,   /* U+34B9 */
  0xB4BA,   /* U+34BA */
  0x8000,   /* U+34BB */
  0x8001,   /* U+34BC */
  0x8000,   /* U+34BD */
  0x8000,   /* U+34BE */
  0x8000,   /* U+34BF */
  0xB4C0,   /* U+34C0 */
  0xB4C1,   /* U+34C1 */
  0x8000,   /* U+34C2 */
  0x8000,   /* U+34C3 */
  0x8000,   /* U+34C4 */
  0x8000,   /* U+34C5 */
  0x8000,   /* U+34C6 */
  0xB4C7,   /* U+34C7 */
  0x8000,   /* U+34C8 */
  0x8000,   /* U+34C9 */
  0x8001,   /* U+34CA */
  0x8002,   /* U+34CB */
  0x8003,   /* U+34CC */
  0x8004,   /* U+34CD */
  0x8000,   /* U+34CE */
  0x8001,   /* U+34CF */
  0x8000,   /* U+34D0 */
  0x8001,   /* U+34D1 */
  0xB4D2,   /* U+34D2 */
  0x8000,   /* U+34D3 */
  0x8000,   /* U+34D4 */
  0xB4D5,   /* U+34D5 */
  0x8000,   /* U+34D6 */
  0x8000,   /* U+34D7 */
  0x8000,   /* U+34D8 */
  0xB4D9,   /* U+34D9 */
  0x8000,   /* U+34DA */
  0xB4DB,   /* U+34DB */
  0x8001,   /* U+34DC */
  0x8000,   /* U+34DD */
  0x8001,   /* U+34DE */
  0x8000,   /* U+34DF */
  0x8001,   /* U+34E0 */
  0x8000,   /* U+34E1 */
  0x8001,   /* U+34E2 */
  0x8002,   /* U+34E3 */
  0x8003,   /* U+34E4 */
  0x8004,   /* U+34E5 */
  0x8005,   /* U+34E6 */
  0x8000,   /* U+34E7 */
  0x8001,   /* U+34E8 */
  0x8002,   /* U+34E9 */
  0x8003,   /* U+34EA */
  0x8004,   /* U+34EB */
  0x8000,   /* U+34EC */
  0x8001,   /* U+34ED */
  0x8002,   /* U+34EE */
  0x8003,   /* U+34EF */
  0xB4F0,   /* U+34F0 */
  0x8000,   /* U+34F1 */
  0x8001,   /* U+34F2 */
  0x8002,   /* U+34F3 */
  0x8003,   /* U+34F4 */
  0x8004,   /* U+34F5 */
  0x8005,   /* U+34F6 */
  0x8000,   /* U+34F7 */
  0x8001,   /* U+34F8 */
  0x8002,   /* U+34F9 */
  0x8003,   /* U+34FA */
  0x8004,   /* U+34FB */
  0x8000,   /* U+34FC */
  0x8001,   /* U+34FD */
  0x8000,   /* U+34FE */
  0xB4FF,   /* U+34FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3400 */
  0x0000,   /* U+3401 */
  0x0000,   /* U+3402 */
  0x0000,   /* U+3403 */
  0x0000,   /* U+3404 */
  0x0000,   /* U+3405 */
  0x0000,   /* U+3406 */
  0x0000,   /* U+3407 */
  0x0000,   /* U+3408 */
  0x0000,   /* U+3409 */
  0x0000,   /* U+340A */
  0x0000,   /* U+340B */
  0x0000,   /* U+340C */
  0x0000,   /* U+340D */
  0x0000,   /* U+340E */
  0x0000,   /* U+340F */
  0x0000,   /* U+3410 */
  0x0000,   /* U+3411 */
  0x0000,   /* U+3412 */
  0x0000,   /* U+3413 */
  0x0000,   /* U+3414 */
  0x0000,   /* U+3415 */
  0x0000,   /* U+3416 */
  0x0000,   /* U+3417 */
  0x0000,   /* U+3418 */
  0x0000,   /* U+3419 */
  0x0000,   /* U+341A */
  0x0000,   /* U+341B */
  0x0000,   /* U+341C */
  0x0000,   /* U+341D */
  0x0000,   /* U+341E */
  0x0000,   /* U+341F */
  0x0000,   /* U+3420 */
  0x0000,   /* U+3421 */
  0x0000,   /* U+3422 */
  0x0000,   /* U+3423 */
  0x0000,   /* U+3424 */
  0x0000,   /* U+3425 */
  0x0000,   /* U+3426 */
  0x0000,   /* U+3427 */
  0x0000,   /* U+3428 */
  0x0000,   /* U+3429 */
  0x0000,   /* U+342A */
  0x0000,   /* U+342B */
  0x0000,   /* U+342C */
  0x0000,   /* U+342D */
  0x0000,   /* U+342E */
  0x0000,   /* U+342F */
  0x0000,   /* U+3430 */
  0x0000,   /* U+3431 */
  0x0000,   /* U+3432 */
  0x0000,   /* U+3433 */
  0x0000,   /* U+3434 */
  0x0000,   /* U+3435 */
  0x0000,   /* U+3436 */
  0x0000,   /* U+3437 */
  0x0000,   /* U+3438 */
  0x0000,   /* U+3439 */
  0x0000,   /* U+343A */
  0x0000,   /* U+343B */
  0x0000,   /* U+343C */
  0x0000,   /* U+343D */
  0x0000,   /* U+343E */
  0x0000,   /* U+343F */
  0x0000,   /* U+3440 */
  0x0000,   /* U+3441 */
  0x0000,   /* U+3442 */
  0x0000,   /* U+3443 */
  0x0000,   /* U+3444 */
  0x0000,   /* U+3445 */
  0x0000,   /* U+3446 */
  0x0000,   /* U+3447 */
  0x0000,   /* U+3448 */
  0x0000,   /* U+3449 */
  0x0000,   /* U+344A */
  0x0000,   /* U+344B */
  0x0000,   /* U+344C */
  0x0000,   /* U+344D */
  0x0000,   /* U+344E */
  0x0000,   /* U+344F */
  0x0000,   /* U+3450 */
  0x0000,   /* U+3451 */
  0x0000,   /* U+3452 */
  0x0000,   /* U+3453 */
  0x0000,   /* U+3454 */
  0x0000,   /* U+3455 */
  0x0000,   /* U+3456 */
  0x0000,   /* U+3457 */
  0x0000,   /* U+3458 */
  0x0000,   /* U+3459 */
  0x0000,   /* U+345A */
  0x0000,   /* U+345B */
  0x0000,   /* U+345C */
  0x0000,   /* U+345D */
  0x0000,   /* U+345E */
  0x0000,   /* U+345F */
  0x0000,   /* U+3460 */
  0x0000,   /* U+3461 */
  0x0000,   /* U+3462 */
  0x0000,   /* U+3463 */
  0x0000,   /* U+3464 */
  0x0000,   /* U+3465 */
  0x0000,   /* U+3466 */
  0x0000,   /* U+3467 */
  0x0000,   /* U+3468 */
  0x0000,   /* U+3469 */
  0x0000,   /* U+346A */
  0x0000,   /* U+346B */
  0x0000,   /* U+346C */
  0x0000,   /* U+346D */
  0x0000,   /* U+346E */
  0x0000,   /* U+346F */
  0x0000,   /* U+3470 */
  0x0000,   /* U+3471 */
  0x0000,   /* U+3472 */
  0x0000,   /* U+3473 */
  0x0000,   /* U+3474 */
  0x0000,   /* U+3475 */
  0x0000,   /* U+3476 */
  0x0000,   /* U+3477 */
  0x0000,   /* U+3478 */
  0x0000,   /* U+3479 */
  0x0000,   /* U+347A */
  0x0000,   /* U+347B */
  0x0000,   /* U+347C */
  0x0000,   /* U+347D */
  0x0000,   /* U+347E */
  0x0000,   /* U+347F */
  0x0000,   /* U+3480 */
  0x0000,   /* U+3481 */
  0x0000,   /* U+3482 */
  0x0000,   /* U+3483 */
  0x0000,   /* U+3484 */
  0x0000,   /* U+3485 */
  0x0000,   /* U+3486 */
  0x0000,   /* U+3487 */
  0x0000,   /* U+3488 */
  0x0000,   /* U+3489 */
  0x0000,   /* U+348A */
  0x0000,   /* U+348B */
  0x0000,   /* U+348C */
  0x0000,   /* U+348D */
  0x0000,   /* U+348E */
  0x0000,   /* U+348F */
  0x0000,   /* U+3490 */
  0x0000,   /* U+3491 */
  0x0000,   /* U+3492 */
  0x0000,   /* U+3493 */
  0x0000,   /* U+3494 */
  0x0000,   /* U+3495 */
  0x0000,   /* U+3496 */
  0x0000,   /* U+3497 */
  0x0000,   /* U+3498 */
  0x0000,   /* U+3499 */
  0x0000,   /* U+349A */
  0x0000,   /* U+349B */
  0x0000,   /* U+349C */
  0x0000,   /* U+349D */
  0x0000,   /* U+349E */
  0x0000,   /* U+349F */
  0x0000,   /* U+34A0 */
  0x0000,   /* U+34A1 */
  0x0000,   /* U+34A2 */
  0x0000,   /* U+34A3 */
  0x0000,   /* U+34A4 */
  0x0000,   /* U+34A5 */
  0x0000,   /* U+34A6 */
  0x0000,   /* U+34A7 */
  0x0000,   /* U+34A8 */
  0x0000,   /* U+34A9 */
  0x0000,   /* U+34AA */
  0x0000,   /* U+34AB */
  0x0000,   /* U+34AC */
  0x0000,   /* U+34AD */
  0x0000,   /* U+34AE */
  0x0000,   /* U+34AF */
  0x0000,   /* U+34B0 */
  0x0000,   /* U+34B1 */
  0x0000,   /* U+34B2 */
  0x0000,   /* U+34B3 */
  0x0000,   /* U+34B4 */
  0x0000,   /* U+34B5 */
  0x0000,   /* U+34B6 */
  0x0000,   /* U+34B7 */
  0x0000,   /* U+34B8 */
  0x0000,   /* U+34B9 */
  0x0000,   /* U+34BA */
  0x0000,   /* U+34BB */
  0x0000,   /* U+34BC */
  0x0000,   /* U+34BD */
  0x0000,   /* U+34BE */
  0x0000,   /* U+34BF */
  0x0000,   /* U+34C0 */
  0x0000,   /* U+34C1 */
  0x0000,   /* U+34C2 */
  0x0000,   /* U+34C3 */
  0x0000,   /* U+34C4 */
  0x0000,   /* U+34C5 */
  0x0000,   /* U+34C6 */
  0x0000,   /* U+34C7 */
  0x0000,   /* U+34C8 */
  0x0000,   /* U+34C9 */
  0x0000,   /* U+34CA */
  0x0000,   /* U+34CB */
  0x0000,   /* U+34CC */
  0x0000,   /* U+34CD */
  0x0000,   /* U+34CE */
  0x0000,   /* U+34CF */
  0x0000,   /* U+34D0 */
  0x0000,   /* U+34D1 */
  0x0000,   /* U+34D2 */
  0x0000,   /* U+34D3 */
  0x0000,   /* U+34D4 */
  0x0000,   /* U+34D5 */
  0x0000,   /* U+34D6 */
  0x0000,   /* U+34D7 */
  0x0000,   /* U+34D8 */
  0x0000,   /* U+34D9 */
  0x0000,   /* U+34DA */
  0x0000,   /* U+34DB */
  0x0000,   /* U+34DC */
  0x0000,   /* U+34DD */
  0x0000,   /* U+34DE */
  0x0000,   /* U+34DF */
  0x0000,   /* U+34E0 */
  0x0000,   /* U+34E1 */
  0x0000,   /* U+34E2 */
  0x0000,   /* U+34E3 */
  0x0000,   /* U+34E4 */
  0x0000,   /* U+34E5 */
  0x0000,   /* U+34E6 */
  0x0000,   /* U+34E7 */
  0x0000,   /* U+34E8 */
  0x0000,   /* U+34E9 */
  0x0000,   /* U+34EA */
  0x0000,   /* U+34EB */
  0x0000,   /* U+34EC */
  0x0000,   /* U+34ED */
  0x0000,   /* U+34EE */
  0x0000,   /* U+34EF */
  0x0000,   /* U+34F0 */
  0x0000,   /* U+34F1 */
  0x0000,   /* U+34F2 */
  0x0000,   /* U+34F3 */
  0x0000,   /* U+34F4 */
  0x0000,   /* U+34F5 */
  0x0000,   /* U+34F6 */
  0x0000,   /* U+34F7 */
  0x0000,   /* U+34F8 */
  0x0000,   /* U+34F9 */
  0x0000,   /* U+34FA */
  0x0000,   /* U+34FB */
  0x0000,   /* U+34FC */
  0x0000,   /* U+34FD */
  0x0000,   /* U+34FE */
  0x0000,   /* U+34FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3400 */
  0x0000,   /* U+3401 */
  0x0000,   /* U+3402 */
  0x0000,   /* U+3403 */
  0x0000,   /* U+3404 */
  0x0000,   /* U+3405 */
  0x0000,   /* U+3406 */
  0x0000,   /* U+3407 */
  0x0000,   /* U+3408 */
  0x0000,   /* U+3409 */
  0x0000,   /* U+340A */
  0x0000,   /* U+340B */
  0x0000,   /* U+340C */
  0x0000,   /* U+340D */
  0x0000,   /* U+340E */
  0x0000,   /* U+340F */
  0x0000,   /* U+3410 */
  0x0000,   /* U+3411 */
  0x0000,   /* U+3412 */
  0x0000,   /* U+3413 */
  0x0000,   /* U+3414 */
  0x0000,   /* U+3415 */
  0x0000,   /* U+3416 */
  0x0000,   /* U+3417 */
  0x0000,   /* U+3418 */
  0x0000,   /* U+3419 */
  0x0000,   /* U+341A */
  0x0000,   /* U+341B */
  0x0000,   /* U+341C */
  0x0000,   /* U+341D */
  0x0000,   /* U+341E */
  0x0000,   /* U+341F */
  0x0000,   /* U+3420 */
  0x0000,   /* U+3421 */
  0x0000,   /* U+3422 */
  0x0000,   /* U+3423 */
  0x0000,   /* U+3424 */
  0x0000,   /* U+3425 */
  0x0000,   /* U+3426 */
  0x0000,   /* U+3427 */
  0x0000,   /* U+3428 */
  0x0000,   /* U+3429 */
  0x0000,   /* U+342A */
  0x0000,   /* U+342B */
  0x0000,   /* U+342C */
  0x0000,   /* U+342D */
  0x0000,   /* U+342E */
  0x0000,   /* U+342F */
  0x0000,   /* U+3430 */
  0x0000,   /* U+3431 */
  0x0000,   /* U+3432 */
  0x0000,   /* U+3433 */
  0x0000,   /* U+3434 */
  0x0000,   /* U+3435 */
  0x0000,   /* U+3436 */
  0x0000,   /* U+3437 */
  0x0000,   /* U+3438 */
  0x0000,   /* U+3439 */
  0x0000,   /* U+343A */
  0x0000,   /* U+343B */
  0x0000,   /* U+343C */
  0x0000,   /* U+343D */
  0x0000,   /* U+343E */
  0x0000,   /* U+343F */
  0x0000,   /* U+3440 */
  0x0000,   /* U+3441 */
  0x0000,   /* U+3442 */
  0x0000,   /* U+3443 */
  0x0000,   /* U+3444 */
  0x0000,   /* U+3445 */
  0x0000,   /* U+3446 */
  0x0000,   /* U+3447 */
  0x0000,   /* U+3448 */
  0x0000,   /* U+3449 */
  0x0000,   /* U+344A */
  0x0000,   /* U+344B */
  0x0000,   /* U+344C */
  0x0000,   /* U+344D */
  0x0000,   /* U+344E */
  0x0000,   /* U+344F */
  0x0000,   /* U+3450 */
  0x0000,   /* U+3451 */
  0x0000,   /* U+3452 */
  0x0000,   /* U+3453 */
  0x0000,   /* U+3454 */
  0x0000,   /* U+3455 */
  0x0000,   /* U+3456 */
  0x0000,   /* U+3457 */
  0x0000,   /* U+3458 */
  0x0000,   /* U+3459 */
  0x0000,   /* U+345A */
  0x0000,   /* U+345B */
  0x0000,   /* U+345C */
  0x0000,   /* U+345D */
  0x0000,   /* U+345E */
  0x0000,   /* U+345F */
  0x0000,   /* U+3460 */
  0x0000,   /* U+3461 */
  0x0000,   /* U+3462 */
  0x0000,   /* U+3463 */
  0x0000,   /* U+3464 */
  0x0000,   /* U+3465 */
  0x0000,   /* U+3466 */
  0x0000,   /* U+3467 */
  0x0000,   /* U+3468 */
  0x0000,   /* U+3469 */
  0x0000,   /* U+346A */
  0x0000,   /* U+346B */
  0x0000,   /* U+346C */
  0x0000,   /* U+346D */
  0x0000,   /* U+346E */
  0x0000,   /* U+346F */
  0x0000,   /* U+3470 */
  0x0000,   /* U+3471 */
  0x0000,   /* U+3472 */
  0x0000,   /* U+3473 */
  0x0000,   /* U+3474 */
  0x0000,   /* U+3475 */
  0x0000,   /* U+3476 */
  0x0000,   /* U+3477 */
  0x0000,   /* U+3478 */
  0x0000,   /* U+3479 */
  0x0000,   /* U+347A */
  0x0000,   /* U+347B */
  0x0000,   /* U+347C */
  0x0000,   /* U+347D */
  0x0000,   /* U+347E */
  0x0000,   /* U+347F */
  0x0000,   /* U+3480 */
  0x0000,   /* U+3481 */
  0x0000,   /* U+3482 */
  0x0000,   /* U+3483 */
  0x0000,   /* U+3484 */
  0x0000,   /* U+3485 */
  0x0000,   /* U+3486 */
  0x0000,   /* U+3487 */
  0x0000,   /* U+3488 */
  0x0000,   /* U+3489 */
  0x0000,   /* U+348A */
  0x0000,   /* U+348B */
  0x0000,   /* U+348C */
  0x0000,   /* U+348D */
  0x0000,   /* U+348E */
  0x0000,   /* U+348F */
  0x0000,   /* U+3490 */
  0x0000,   /* U+3491 */
  0x0000,   /* U+3492 */
  0x0000,   /* U+3493 */
  0x0000,   /* U+3494 */
  0x0000,   /* U+3495 */
  0x0000,   /* U+3496 */
  0x0000,   /* U+3497 */
  0x0000,   /* U+3498 */
  0x0000,   /* U+3499 */
  0x0000,   /* U+349A */
  0x0000,   /* U+349B */
  0x0000,   /* U+349C */
  0x0000,   /* U+349D */
  0x0000,   /* U+349E */
  0x0000,   /* U+349F */
  0x0000,   /* U+34A0 */
  0x0000,   /* U+34A1 */
  0x0000,   /* U+34A2 */
  0x0000,   /* U+34A3 */
  0x0000,   /* U+34A4 */
  0x0000,   /* U+34A5 */
  0x0000,   /* U+34A6 */
  0x0000,   /* U+34A7 */
  0x0000,   /* U+34A8 */
  0x0000,   /* U+34A9 */
  0x0000,   /* U+34AA */
  0x0000,   /* U+34AB */
  0x0000,   /* U+34AC */
  0x0000,   /* U+34AD */
  0x0000,   /* U+34AE */
  0x0000,   /* U+34AF */
  0x0000,   /* U+34B0 */
  0x0000,   /* U+34B1 */
  0x0000,   /* U+34B2 */
  0x0000,   /* U+34B3 */
  0x0000,   /* U+34B4 */
  0x0000,   /* U+34B5 */
  0x0000,   /* U+34B6 */
  0x0000,   /* U+34B7 */
  0x0000,   /* U+34B8 */
  0x0000,   /* U+34B9 */
  0x0000,   /* U+34BA */
  0x0000,   /* U+34BB */
  0x0000,   /* U+34BC */
  0x0000,   /* U+34BD */
  0x0000,   /* U+34BE */
  0x0000,   /* U+34BF */
  0x0000,   /* U+34C0 */
  0x0000,   /* U+34C1 */
  0x0000,   /* U+34C2 */
  0x0000,   /* U+34C3 */
  0x0000,   /* U+34C4 */
  0x0000,   /* U+34C5 */
  0x0000,   /* U+34C6 */
  0x0000,   /* U+34C7 */
  0x0000,   /* U+34C8 */
  0x0000,   /* U+34C9 */
  0x0000,   /* U+34CA */
  0x0000,   /* U+34CB */
  0x0000,   /* U+34CC */
  0x0000,   /* U+34CD */
  0x0000,   /* U+34CE */
  0x0000,   /* U+34CF */
  0x0000,   /* U+34D0 */
  0x0000,   /* U+34D1 */
  0x0000,   /* U+34D2 */
  0x0000,   /* U+34D3 */
  0x0000,   /* U+34D4 */
  0x0000,   /* U+34D5 */
  0x0000,   /* U+34D6 */
  0x0000,   /* U+34D7 */
  0x0000,   /* U+34D8 */
  0x0000,   /* U+34D9 */
  0x0000,   /* U+34DA */
  0x0000,   /* U+34DB */
  0x0000,   /* U+34DC */
  0x0000,   /* U+34DD */
  0x0000,   /* U+34DE */
  0x0000,   /* U+34DF */
  0x0000,   /* U+34E0 */
  0x0000,   /* U+34E1 */
  0x0000,   /* U+34E2 */
  0x0000,   /* U+34E3 */
  0x0000,   /* U+34E4 */
  0x0000,   /* U+34E5 */
  0x0000,   /* U+34E6 */
  0x0000,   /* U+34E7 */
  0x0000,   /* U+34E8 */
  0x0000,   /* U+34E9 */
  0x0000,   /* U+34EA */
  0x0000,   /* U+34EB */
  0x0000,   /* U+34EC */
  0x0000,   /* U+34ED */
  0x0000,   /* U+34EE */
  0x0000,   /* U+34EF */
  0x0000,   /* U+34F0 */
  0x0000,   /* U+34F1 */
  0x0000,   /* U+34F2 */
  0x0000,   /* U+34F3 */
  0x0000,   /* U+34F4 */
  0x0000,   /* U+34F5 */
  0x0000,   /* U+34F6 */
  0x0000,   /* U+34F7 */
  0x0000,   /* U+34F8 */
  0x0000,   /* U+34F9 */
  0x0000,   /* U+34FA */
  0x0000,   /* U+34FB */
  0x0000,   /* U+34FC */
  0x0000,   /* U+34FD */
  0x0000,   /* U+34FE */
  0x0000,   /* U+34FF */
};

uint16 zh2_han_p035[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x20D8,   /* U+3500 */
  0x20D8,   /* U+3501 */
  0x20D8,   /* U+3502 */
  0x20D8,   /* U+3503 */
  0x20D8,   /* U+3504 */
  0x20D8,   /* U+3505 */
  0x20D8,   /* U+3506 */
  0x20D8,   /* U+3507 */
  0x20D8,   /* U+3508 */
  0x20D8,   /* U+3509 */
  0x20D9,   /* U+350A */
  0x20DA,   /* U+350B */
  0x20DA,   /* U+350C */
  0x20DA,   /* U+350D */
  0x20DB,   /* U+350E */
  0x20DB,   /* U+350F */
  0x20DC,   /* U+3510 */
  0x20DD,   /* U+3511 */
  0x20DE,   /* U+3512 */
  0x210F,   /* U+3513 */
  0x5C49,   /* U+3514 */
  0x2110,   /* U+3515 */
  0x5C49,   /* U+3516 */
  0x2111,   /* U+3517 */
  0x5C49,   /* U+3518 */
  0x2112,   /* U+3519 */
  0x2112,   /* U+351A */
  0x5C49,   /* U+351B */
  0x2113,   /* U+351C */
  0x2114,   /* U+351D */
  0x2114,   /* U+351E */
  0x5C49,   /* U+351F */
  0x2115,   /* U+3520 */
  0x210D,   /* U+3521 */
  0x2118,   /* U+3522 */
  0x211B,   /* U+3523 */
  0x211B,   /* U+3524 */
  0x211B,   /* U+3525 */
  0x211B,   /* U+3526 */
  0x211C,   /* U+3527 */
  0x2155,   /* U+3528 */
  0x214D,   /* U+3529 */
  0x2157,   /* U+352A */
  0x5C49,   /* U+352B */
  0x2192,   /* U+352C */
  0x2195,   /* U+352D */
  0x3CDD,   /* U+352E */
  0x21D1,   /* U+352F */
  0x21D1,   /* U+3530 */
  0x21D5,   /* U+3531 */
  0x5C49,   /* U+3532 */
  0x21D7,   /* U+3533 */
  0x21D7,   /* U+3534 */
  0x21D8,   /* U+3535 */
  0x21E4,   /* U+3536 */
  0x2211,   /* U+3537 */
  0x220D,   /* U+3538 */
  0x224E,   /* U+3539 */
  0x2250,   /* U+353A */
  0x2250,   /* U+353B */
  0x2257,   /* U+353C */
  0x2292,   /* U+353D */
  0x22CD,   /* U+353E */
  0x22CD,   /* U+353F */
  0x5C49,   /* U+3540 */
  0x22D2,   /* U+3541 */
  0x2310,   /* U+3542 */
  0x2310,   /* U+3543 */
  0x2310,   /* U+3544 */
  0x2311,   /* U+3545 */
  0x2311,   /* U+3546 */
  0x2311,   /* U+3547 */
  0x2312,   /* U+3548 */
  0x2312,   /* U+3549 */
  0x2313,   /* U+354A */
  0x2314,   /* U+354B */
  0x2314,   /* U+354C */
  0x2314,   /* U+354D */
  0x230D,   /* U+354E */
  0x2317,   /* U+354F */
  0x2318,   /* U+3550 */
  0x2318,   /* U+3551 */
  0x2319,   /* U+3552 */
  0x5C49,   /* U+3553 */
  0x5C49,   /* U+3554 */
  0x234E,   /* U+3555 */
  0x2354,   /* U+3556 */
  0x2355,   /* U+3557 */
  0x2355,   /* U+3558 */
  0x2359,   /* U+3559 */
  0x238E,   /* U+355A */
  0x238E,   /* U+355B */
  0x2390,   /* U+355C */
  0x5C49,   /* U+355D */
  0x2392,   /* U+355E */
  0x2393,   /* U+355F */
  0x238D,   /* U+3560 */
  0x2398,   /* U+3561 */
  0x42D3,   /* U+3562 */
  0x23CE,   /* U+3563 */
  0x23CE,   /* U+3564 */
  0x23CE,   /* U+3565 */
  0x23CF,   /* U+3566 */
  0x23CF,   /* U+3567 */
  0x23CF,   /* U+3568 */
  0x23D0,   /* U+3569 */
  0x23D0,   /* U+356A */
  0x23D0,   /* U+356B */
  0x23D0,   /* U+356C */
  0x23D0,   /* U+356D */
  0x23D0,   /* U+356E */
  0x23D0,   /* U+356F */
  0x23D0,   /* U+3570 */
  0x23D0,   /* U+3571 */
  0x23D0,   /* U+3572 */
  0x23D0,   /* U+3573 */
  0x23D0,   /* U+3574 */
  0x23D0,   /* U+3575 */
  0x23D0,   /* U+3576 */
  0x23D1,   /* U+3577 */
  0x23D1,   /* U+3578 */
  0x23D1,   /* U+3579 */
  0x23D1,   /* U+357A */
  0x23D1,   /* U+357B */
  0x23D1,   /* U+357C */
  0x23D1,   /* U+357D */
  0x5C49,   /* U+357E */
  0x5C49,   /* U+357F */
  0x23D2,   /* U+3580 */
  0x23D2,   /* U+3581 */
  0x23D2,   /* U+3582 */
  0x23D2,   /* U+3583 */
  0x23D2,   /* U+3584 */
  0x23D2,   /* U+3585 */
  0x23D2,   /* U+3586 */
  0x23D2,   /* U+3587 */
  0x5C49,   /* U+3588 */
  0x23D2,   /* U+3589 */
  0x23D2,   /* U+358A */
  0x5C49,   /* U+358B */
  0x5C49,   /* U+358C */
  0x5C49,   /* U+358D */
  0x5C49,   /* U+358E */
  0x23D3,   /* U+358F */
  0x23D3,   /* U+3590 */
  0x23D3,   /* U+3591 */
  0x23D3,   /* U+3592 */
  0x23D3,   /* U+3593 */
  0x23D3,   /* U+3594 */
  0x23D3,   /* U+3595 */
  0x23D3,   /* U+3596 */
  0x23D3,   /* U+3597 */
  0x23D3,   /* U+3598 */
  0x5C49,   /* U+3599 */
  0x5C49,   /* U+359A */
  0x5C49,   /* U+359B */
  0x5C49,   /* U+359C */
  0x5C49,   /* U+359D */
  0x23D3,   /* U+359E */
  0x23D4,   /* U+359F */
  0x23D4,   /* U+35A0 */
  0x23D4,   /* U+35A1 */
  0x23D4,   /* U+35A2 */
  0x23D4,   /* U+35A3 */
  0x23D4,   /* U+35A4 */
  0x23D4,   /* U+35A5 */
  0x23D4,   /* U+35A6 */
  0x23D4,   /* U+35A7 */
  0x23D4,   /* U+35A8 */
  0x23D4,   /* U+35A9 */
  0x23D4,   /* U+35AA */
  0x23D4,   /* U+35AB */
  0x23D4,   /* U+35AC */
  0x23D4,   /* U+35AD */
  0x23D4,   /* U+35AE */
  0x5C49,   /* U+35AF */
  0x5C49,   /* U+35B0 */
  0x5C49,   /* U+35B1 */
  0x5C49,   /* U+35B2 */
  0x5C49,   /* U+35B3 */
  0x5C49,   /* U+35B4 */
  0x23D4,   /* U+35B5 */
  0x23D5,   /* U+35B6 */
  0x23D5,   /* U+35B7 */
  0x23D5,   /* U+35B8 */
  0x23D5,   /* U+35B9 */
  0x23D5,   /* U+35BA */
  0x23D5,   /* U+35BB */
  0x23D5,   /* U+35BC */
  0x23D5,   /* U+35BD */
  0x23D5,   /* U+35BE */
  0x23D5,   /* U+35BF */
  0x23D5,   /* U+35C0 */
  0x23D5,   /* U+35C1 */
  0x23D5,   /* U+35C2 */
  0x23D5,   /* U+35C3 */
  0x23D5,   /* U+35C4 */
  0x23D5,   /* U+35C5 */
  0x23D5,   /* U+35C6 */
  0x23D5,   /* U+35C7 */
  0x23D5,   /* U+35C8 */
  0x23D5,   /* U+35C9 */
  0x23D5,   /* U+35CA */
  0x23D5,   /* U+35CB */
  0x23D5,   /* U+35CC */
  0x23D5,   /* U+35CD */
  0x23D5,   /* U+35CE */
  0x23D5,   /* U+35CF */
  0x5C49,   /* U+35D0 */
  0x23D5,   /* U+35D1 */
  0x23CD,   /* U+35D2 */
  0x23CD,   /* U+35D3 */
  0x23CD,   /* U+35D4 */
  0x23CD,   /* U+35D5 */
  0x23CD,   /* U+35D6 */
  0x23CD,   /* U+35D7 */
  0x23CD,   /* U+35D8 */
  0x23CD,   /* U+35D9 */
  0x23CD,   /* U+35DA */
  0x23CD,   /* U+35DB */
  0x23CD,   /* U+35DC */
  0x23CD,   /* U+35DD */
  0x23CD,   /* U+35DE */
  0x5C49,   /* U+35DF */
  0x5C49,   /* U+35E0 */
  0x5C49,   /* U+35E1 */
  0x23D7,   /* U+35E2 */
  0x23D7,   /* U+35E3 */
  0x23D7,   /* U+35E4 */
  0x23D7,   /* U+35E5 */
  0x23D7,   /* U+35E6 */
  0x23D7,   /* U+35E7 */
  0x23D7,   /* U+35E8 */
  0x23D7,   /* U+35E9 */
  0x23D7,   /* U+35EA */
  0x23D7,   /* U+35EB */
  0x23D7,   /* U+35EC */
  0x23D7,   /* U+35ED */
  0x5C49,   /* U+35EE */
  0x5C49,   /* U+35EF */
  0x23D7,   /* U+35F0 */
  0x23D8,   /* U+35F1 */
  0x23D8,   /* U+35F2 */
  0x23D8,   /* U+35F3 */
  0x23D8,   /* U+35F4 */
  0x23D8,   /* U+35F5 */
  0x23D8,   /* U+35F6 */
  0x23D8,   /* U+35F7 */
  0x5C49,   /* U+35F8 */
  0x5C49,   /* U+35F9 */
  0x23D8,   /* U+35FA */
  0x23D9,   /* U+35FB */
  0x23D9,   /* U+35FC */
  0x23D9,   /* U+35FD */
  0x23D9,   /* U+35FE */
  0x23D9,   /* U+35FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3500 */
  0x0020,   /* U+3501 */
  0x0020,   /* U+3502 */
  0x0020,   /* U+3503 */
  0x0020,   /* U+3504 */
  0x0020,   /* U+3505 */
  0x0020,   /* U+3506 */
  0x0020,   /* U+3507 */
  0x0020,   /* U+3508 */
  0x0020,   /* U+3509 */
  0x0020,   /* U+350A */
  0x0020,   /* U+350B */
  0x0020,   /* U+350C */
  0x0020,   /* U+350D */
  0x0020,   /* U+350E */
  0x0020,   /* U+350F */
  0x0020,   /* U+3510 */
  0x0020,   /* U+3511 */
  0x0020,   /* U+3512 */
  0x0020,   /* U+3513 */
  0x0020,   /* U+3514 */
  0x0020,   /* U+3515 */
  0x0020,   /* U+3516 */
  0x0020,   /* U+3517 */
  0x0020,   /* U+3518 */
  0x0020,   /* U+3519 */
  0x0020,   /* U+351A */
  0x0020,   /* U+351B */
  0x0020,   /* U+351C */
  0x0020,   /* U+351D */
  0x0020,   /* U+351E */
  0x0020,   /* U+351F */
  0x0020,   /* U+3520 */
  0x0020,   /* U+3521 */
  0x0020,   /* U+3522 */
  0x0020,   /* U+3523 */
  0x0020,   /* U+3524 */
  0x0020,   /* U+3525 */
  0x0020,   /* U+3526 */
  0x0020,   /* U+3527 */
  0x0020,   /* U+3528 */
  0x0020,   /* U+3529 */
  0x0020,   /* U+352A */
  0x0020,   /* U+352B */
  0x0020,   /* U+352C */
  0x0020,   /* U+352D */
  0x0020,   /* U+352E */
  0x0020,   /* U+352F */
  0x0020,   /* U+3530 */
  0x0020,   /* U+3531 */
  0x0020,   /* U+3532 */
  0x0020,   /* U+3533 */
  0x0020,   /* U+3534 */
  0x0020,   /* U+3535 */
  0x0020,   /* U+3536 */
  0x0020,   /* U+3537 */
  0x0020,   /* U+3538 */
  0x0020,   /* U+3539 */
  0x0020,   /* U+353A */
  0x0020,   /* U+353B */
  0x0020,   /* U+353C */
  0x0020,   /* U+353D */
  0x0020,   /* U+353E */
  0x0020,   /* U+353F */
  0x0020,   /* U+3540 */
  0x0020,   /* U+3541 */
  0x0020,   /* U+3542 */
  0x0020,   /* U+3543 */
  0x0020,   /* U+3544 */
  0x0020,   /* U+3545 */
  0x0020,   /* U+3546 */
  0x0020,   /* U+3547 */
  0x0020,   /* U+3548 */
  0x0020,   /* U+3549 */
  0x0020,   /* U+354A */
  0x0020,   /* U+354B */
  0x0020,   /* U+354C */
  0x0020,   /* U+354D */
  0x0020,   /* U+354E */
  0x0020,   /* U+354F */
  0x0020,   /* U+3550 */
  0x0020,   /* U+3551 */
  0x0020,   /* U+3552 */
  0x0020,   /* U+3553 */
  0x0020,   /* U+3554 */
  0x0020,   /* U+3555 */
  0x0020,   /* U+3556 */
  0x0020,   /* U+3557 */
  0x0020,   /* U+3558 */
  0x0020,   /* U+3559 */
  0x0020,   /* U+355A */
  0x0020,   /* U+355B */
  0x0020,   /* U+355C */
  0x0020,   /* U+355D */
  0x0020,   /* U+355E */
  0x0020,   /* U+355F */
  0x0020,   /* U+3560 */
  0x0020,   /* U+3561 */
  0x0020,   /* U+3562 */
  0x0020,   /* U+3563 */
  0x0020,   /* U+3564 */
  0x0020,   /* U+3565 */
  0x0020,   /* U+3566 */
  0x0020,   /* U+3567 */
  0x0020,   /* U+3568 */
  0x0020,   /* U+3569 */
  0x0020,   /* U+356A */
  0x0020,   /* U+356B */
  0x0020,   /* U+356C */
  0x0020,   /* U+356D */
  0x0020,   /* U+356E */
  0x0020,   /* U+356F */
  0x0020,   /* U+3570 */
  0x0020,   /* U+3571 */
  0x0020,   /* U+3572 */
  0x0020,   /* U+3573 */
  0x0020,   /* U+3574 */
  0x0020,   /* U+3575 */
  0x0020,   /* U+3576 */
  0x0020,   /* U+3577 */
  0x0020,   /* U+3578 */
  0x0020,   /* U+3579 */
  0x0020,   /* U+357A */
  0x0020,   /* U+357B */
  0x0020,   /* U+357C */
  0x0020,   /* U+357D */
  0x0020,   /* U+357E */
  0x0020,   /* U+357F */
  0x0020,   /* U+3580 */
  0x0020,   /* U+3581 */
  0x0020,   /* U+3582 */
  0x0020,   /* U+3583 */
  0x0020,   /* U+3584 */
  0x0020,   /* U+3585 */
  0x0020,   /* U+3586 */
  0x0020,   /* U+3587 */
  0x0020,   /* U+3588 */
  0x0020,   /* U+3589 */
  0x0020,   /* U+358A */
  0x0020,   /* U+358B */
  0x0020,   /* U+358C */
  0x0020,   /* U+358D */
  0x0020,   /* U+358E */
  0x0020,   /* U+358F */
  0x0020,   /* U+3590 */
  0x0020,   /* U+3591 */
  0x0020,   /* U+3592 */
  0x0020,   /* U+3593 */
  0x0020,   /* U+3594 */
  0x0020,   /* U+3595 */
  0x0020,   /* U+3596 */
  0x0020,   /* U+3597 */
  0x0020,   /* U+3598 */
  0x0020,   /* U+3599 */
  0x0020,   /* U+359A */
  0x0020,   /* U+359B */
  0x0020,   /* U+359C */
  0x0020,   /* U+359D */
  0x0020,   /* U+359E */
  0x0020,   /* U+359F */
  0x0020,   /* U+35A0 */
  0x0020,   /* U+35A1 */
  0x0020,   /* U+35A2 */
  0x0020,   /* U+35A3 */
  0x0020,   /* U+35A4 */
  0x0020,   /* U+35A5 */
  0x0020,   /* U+35A6 */
  0x0020,   /* U+35A7 */
  0x0020,   /* U+35A8 */
  0x0020,   /* U+35A9 */
  0x0020,   /* U+35AA */
  0x0020,   /* U+35AB */
  0x0020,   /* U+35AC */
  0x0020,   /* U+35AD */
  0x0020,   /* U+35AE */
  0x0020,   /* U+35AF */
  0x0020,   /* U+35B0 */
  0x0020,   /* U+35B1 */
  0x0020,   /* U+35B2 */
  0x0020,   /* U+35B3 */
  0x0020,   /* U+35B4 */
  0x0020,   /* U+35B5 */
  0x0020,   /* U+35B6 */
  0x0020,   /* U+35B7 */
  0x0020,   /* U+35B8 */
  0x0020,   /* U+35B9 */
  0x0020,   /* U+35BA */
  0x0020,   /* U+35BB */
  0x0020,   /* U+35BC */
  0x0020,   /* U+35BD */
  0x0020,   /* U+35BE */
  0x0020,   /* U+35BF */
  0x0020,   /* U+35C0 */
  0x0020,   /* U+35C1 */
  0x0020,   /* U+35C2 */
  0x0020,   /* U+35C3 */
  0x0020,   /* U+35C4 */
  0x0020,   /* U+35C5 */
  0x0020,   /* U+35C6 */
  0x0020,   /* U+35C7 */
  0x0020,   /* U+35C8 */
  0x0020,   /* U+35C9 */
  0x0020,   /* U+35CA */
  0x0020,   /* U+35CB */
  0x0020,   /* U+35CC */
  0x0020,   /* U+35CD */
  0x0020,   /* U+35CE */
  0x0020,   /* U+35CF */
  0x0020,   /* U+35D0 */
  0x0020,   /* U+35D1 */
  0x0020,   /* U+35D2 */
  0x0020,   /* U+35D3 */
  0x0020,   /* U+35D4 */
  0x0020,   /* U+35D5 */
  0x0020,   /* U+35D6 */
  0x0020,   /* U+35D7 */
  0x0020,   /* U+35D8 */
  0x0020,   /* U+35D9 */
  0x0020,   /* U+35DA */
  0x0020,   /* U+35DB */
  0x0020,   /* U+35DC */
  0x0020,   /* U+35DD */
  0x0020,   /* U+35DE */
  0x0020,   /* U+35DF */
  0x0020,   /* U+35E0 */
  0x0020,   /* U+35E1 */
  0x0020,   /* U+35E2 */
  0x0020,   /* U+35E3 */
  0x0020,   /* U+35E4 */
  0x0020,   /* U+35E5 */
  0x0020,   /* U+35E6 */
  0x0020,   /* U+35E7 */
  0x0020,   /* U+35E8 */
  0x0020,   /* U+35E9 */
  0x0020,   /* U+35EA */
  0x0020,   /* U+35EB */
  0x0020,   /* U+35EC */
  0x0020,   /* U+35ED */
  0x0020,   /* U+35EE */
  0x0020,   /* U+35EF */
  0x0020,   /* U+35F0 */
  0x0020,   /* U+35F1 */
  0x0020,   /* U+35F2 */
  0x0020,   /* U+35F3 */
  0x0020,   /* U+35F4 */
  0x0020,   /* U+35F5 */
  0x0020,   /* U+35F6 */
  0x0020,   /* U+35F7 */
  0x0020,   /* U+35F8 */
  0x0020,   /* U+35F9 */
  0x0020,   /* U+35FA */
  0x0020,   /* U+35FB */
  0x0020,   /* U+35FC */
  0x0020,   /* U+35FD */
  0x0020,   /* U+35FE */
  0x0020,   /* U+35FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3500 */
  0x0002,   /* U+3501 */
  0x0002,   /* U+3502 */
  0x0002,   /* U+3503 */
  0x0002,   /* U+3504 */
  0x0002,   /* U+3505 */
  0x0002,   /* U+3506 */
  0x0002,   /* U+3507 */
  0x0002,   /* U+3508 */
  0x0002,   /* U+3509 */
  0x0002,   /* U+350A */
  0x0002,   /* U+350B */
  0x0002,   /* U+350C */
  0x0002,   /* U+350D */
  0x0002,   /* U+350E */
  0x0002,   /* U+350F */
  0x0002,   /* U+3510 */
  0x0002,   /* U+3511 */
  0x0002,   /* U+3512 */
  0x0002,   /* U+3513 */
  0x0002,   /* U+3514 */
  0x0002,   /* U+3515 */
  0x0002,   /* U+3516 */
  0x0002,   /* U+3517 */
  0x0002,   /* U+3518 */
  0x0002,   /* U+3519 */
  0x0002,   /* U+351A */
  0x0002,   /* U+351B */
  0x0002,   /* U+351C */
  0x0002,   /* U+351D */
  0x0002,   /* U+351E */
  0x0002,   /* U+351F */
  0x0002,   /* U+3520 */
  0x0002,   /* U+3521 */
  0x0002,   /* U+3522 */
  0x0002,   /* U+3523 */
  0x0002,   /* U+3524 */
  0x0002,   /* U+3525 */
  0x0002,   /* U+3526 */
  0x0002,   /* U+3527 */
  0x0002,   /* U+3528 */
  0x0002,   /* U+3529 */
  0x0002,   /* U+352A */
  0x0002,   /* U+352B */
  0x0002,   /* U+352C */
  0x0002,   /* U+352D */
  0x0002,   /* U+352E */
  0x0002,   /* U+352F */
  0x0002,   /* U+3530 */
  0x0002,   /* U+3531 */
  0x0002,   /* U+3532 */
  0x0002,   /* U+3533 */
  0x0002,   /* U+3534 */
  0x0002,   /* U+3535 */
  0x0002,   /* U+3536 */
  0x0002,   /* U+3537 */
  0x0002,   /* U+3538 */
  0x0002,   /* U+3539 */
  0x0002,   /* U+353A */
  0x0002,   /* U+353B */
  0x0002,   /* U+353C */
  0x0002,   /* U+353D */
  0x0002,   /* U+353E */
  0x0002,   /* U+353F */
  0x0002,   /* U+3540 */
  0x0002,   /* U+3541 */
  0x0002,   /* U+3542 */
  0x0002,   /* U+3543 */
  0x0002,   /* U+3544 */
  0x0002,   /* U+3545 */
  0x0002,   /* U+3546 */
  0x0002,   /* U+3547 */
  0x0002,   /* U+3548 */
  0x0002,   /* U+3549 */
  0x0002,   /* U+354A */
  0x0002,   /* U+354B */
  0x0002,   /* U+354C */
  0x0002,   /* U+354D */
  0x0002,   /* U+354E */
  0x0002,   /* U+354F */
  0x0002,   /* U+3550 */
  0x0002,   /* U+3551 */
  0x0002,   /* U+3552 */
  0x0002,   /* U+3553 */
  0x0002,   /* U+3554 */
  0x0002,   /* U+3555 */
  0x0002,   /* U+3556 */
  0x0002,   /* U+3557 */
  0x0002,   /* U+3558 */
  0x0002,   /* U+3559 */
  0x0002,   /* U+355A */
  0x0002,   /* U+355B */
  0x0002,   /* U+355C */
  0x0002,   /* U+355D */
  0x0002,   /* U+355E */
  0x0002,   /* U+355F */
  0x0002,   /* U+3560 */
  0x0002,   /* U+3561 */
  0x0002,   /* U+3562 */
  0x0002,   /* U+3563 */
  0x0002,   /* U+3564 */
  0x0002,   /* U+3565 */
  0x0002,   /* U+3566 */
  0x0002,   /* U+3567 */
  0x0002,   /* U+3568 */
  0x0002,   /* U+3569 */
  0x0002,   /* U+356A */
  0x0002,   /* U+356B */
  0x0002,   /* U+356C */
  0x0002,   /* U+356D */
  0x0002,   /* U+356E */
  0x0002,   /* U+356F */
  0x0002,   /* U+3570 */
  0x0002,   /* U+3571 */
  0x0002,   /* U+3572 */
  0x0002,   /* U+3573 */
  0x0002,   /* U+3574 */
  0x0002,   /* U+3575 */
  0x0002,   /* U+3576 */
  0x0002,   /* U+3577 */
  0x0002,   /* U+3578 */
  0x0002,   /* U+3579 */
  0x0002,   /* U+357A */
  0x0002,   /* U+357B */
  0x0002,   /* U+357C */
  0x0002,   /* U+357D */
  0x0002,   /* U+357E */
  0x0002,   /* U+357F */
  0x0002,   /* U+3580 */
  0x0002,   /* U+3581 */
  0x0002,   /* U+3582 */
  0x0002,   /* U+3583 */
  0x0002,   /* U+3584 */
  0x0002,   /* U+3585 */
  0x0002,   /* U+3586 */
  0x0002,   /* U+3587 */
  0x0002,   /* U+3588 */
  0x0002,   /* U+3589 */
  0x0002,   /* U+358A */
  0x0002,   /* U+358B */
  0x0002,   /* U+358C */
  0x0002,   /* U+358D */
  0x0002,   /* U+358E */
  0x0002,   /* U+358F */
  0x0002,   /* U+3590 */
  0x0002,   /* U+3591 */
  0x0002,   /* U+3592 */
  0x0002,   /* U+3593 */
  0x0002,   /* U+3594 */
  0x0002,   /* U+3595 */
  0x0002,   /* U+3596 */
  0x0002,   /* U+3597 */
  0x0002,   /* U+3598 */
  0x0002,   /* U+3599 */
  0x0002,   /* U+359A */
  0x0002,   /* U+359B */
  0x0002,   /* U+359C */
  0x0002,   /* U+359D */
  0x0002,   /* U+359E */
  0x0002,   /* U+359F */
  0x0002,   /* U+35A0 */
  0x0002,   /* U+35A1 */
  0x0002,   /* U+35A2 */
  0x0002,   /* U+35A3 */
  0x0002,   /* U+35A4 */
  0x0002,   /* U+35A5 */
  0x0002,   /* U+35A6 */
  0x0002,   /* U+35A7 */
  0x0002,   /* U+35A8 */
  0x0002,   /* U+35A9 */
  0x0002,   /* U+35AA */
  0x0002,   /* U+35AB */
  0x0002,   /* U+35AC */
  0x0002,   /* U+35AD */
  0x0002,   /* U+35AE */
  0x0002,   /* U+35AF */
  0x0002,   /* U+35B0 */
  0x0002,   /* U+35B1 */
  0x0002,   /* U+35B2 */
  0x0002,   /* U+35B3 */
  0x0002,   /* U+35B4 */
  0x0002,   /* U+35B5 */
  0x0002,   /* U+35B6 */
  0x0002,   /* U+35B7 */
  0x0002,   /* U+35B8 */
  0x0002,   /* U+35B9 */
  0x0002,   /* U+35BA */
  0x0002,   /* U+35BB */
  0x0002,   /* U+35BC */
  0x0002,   /* U+35BD */
  0x0002,   /* U+35BE */
  0x0002,   /* U+35BF */
  0x0002,   /* U+35C0 */
  0x0002,   /* U+35C1 */
  0x0002,   /* U+35C2 */
  0x0002,   /* U+35C3 */
  0x0002,   /* U+35C4 */
  0x0002,   /* U+35C5 */
  0x0002,   /* U+35C6 */
  0x0002,   /* U+35C7 */
  0x0002,   /* U+35C8 */
  0x0002,   /* U+35C9 */
  0x0002,   /* U+35CA */
  0x0002,   /* U+35CB */
  0x0002,   /* U+35CC */
  0x0002,   /* U+35CD */
  0x0002,   /* U+35CE */
  0x0002,   /* U+35CF */
  0x0002,   /* U+35D0 */
  0x0002,   /* U+35D1 */
  0x0002,   /* U+35D2 */
  0x0002,   /* U+35D3 */
  0x0002,   /* U+35D4 */
  0x0002,   /* U+35D5 */
  0x0002,   /* U+35D6 */
  0x0002,   /* U+35D7 */
  0x0002,   /* U+35D8 */
  0x0002,   /* U+35D9 */
  0x0002,   /* U+35DA */
  0x0002,   /* U+35DB */
  0x0002,   /* U+35DC */
  0x0002,   /* U+35DD */
  0x0002,   /* U+35DE */
  0x0002,   /* U+35DF */
  0x0002,   /* U+35E0 */
  0x0002,   /* U+35E1 */
  0x0002,   /* U+35E2 */
  0x0002,   /* U+35E3 */
  0x0002,   /* U+35E4 */
  0x0002,   /* U+35E5 */
  0x0002,   /* U+35E6 */
  0x0002,   /* U+35E7 */
  0x0002,   /* U+35E8 */
  0x0002,   /* U+35E9 */
  0x0002,   /* U+35EA */
  0x0002,   /* U+35EB */
  0x0002,   /* U+35EC */
  0x0002,   /* U+35ED */
  0x0002,   /* U+35EE */
  0x0002,   /* U+35EF */
  0x0002,   /* U+35F0 */
  0x0002,   /* U+35F1 */
  0x0002,   /* U+35F2 */
  0x0002,   /* U+35F3 */
  0x0002,   /* U+35F4 */
  0x0002,   /* U+35F5 */
  0x0002,   /* U+35F6 */
  0x0002,   /* U+35F7 */
  0x0002,   /* U+35F8 */
  0x0002,   /* U+35F9 */
  0x0002,   /* U+35FA */
  0x0002,   /* U+35FB */
  0x0002,   /* U+35FC */
  0x0002,   /* U+35FD */
  0x0002,   /* U+35FE */
  0x0002,   /* U+35FF */

  /* Primary weight 2 for each character. */
  0x8001,   /* U+3500 */
  0x8002,   /* U+3501 */
  0x8003,   /* U+3502 */
  0x8004,   /* U+3503 */
  0x8005,   /* U+3504 */
  0x8006,   /* U+3505 */
  0x8007,   /* U+3506 */
  0x8008,   /* U+3507 */
  0x8009,   /* U+3508 */
  0x800A,   /* U+3509 */
  0x8000,   /* U+350A */
  0x8000,   /* U+350B */
  0x8001,   /* U+350C */
  0x8002,   /* U+350D */
  0x8000,   /* U+350E */
  0x8001,   /* U+350F */
  0x8000,   /* U+3510 */
  0x8000,   /* U+3511 */
  0x8000,   /* U+3512 */
  0x8000,   /* U+3513 */
  0xB514,   /* U+3514 */
  0x8000,   /* U+3515 */
  0xB516,   /* U+3516 */
  0x8000,   /* U+3517 */
  0xB518,   /* U+3518 */
  0x8000,   /* U+3519 */
  0x8001,   /* U+351A */
  0xB51B,   /* U+351B */
  0x8000,   /* U+351C */
  0x8000,   /* U+351D */
  0x8001,   /* U+351E */
  0xB51F,   /* U+351F */
  0x8000,   /* U+3520 */
  0x8000,   /* U+3521 */
  0x8000,   /* U+3522 */
  0x8000,   /* U+3523 */
  0x8001,   /* U+3524 */
  0x8002,   /* U+3525 */
  0x8003,   /* U+3526 */
  0x8000,   /* U+3527 */
  0x8000,   /* U+3528 */
  0x8000,   /* U+3529 */
  0x8000,   /* U+352A */
  0xB52B,   /* U+352B */
  0x8000,   /* U+352C */
  0x8000,   /* U+352D */
  0x8000,   /* U+352E */
  0x8000,   /* U+352F */
  0x8001,   /* U+3530 */
  0x8000,   /* U+3531 */
  0xB532,   /* U+3532 */
  0x8000,   /* U+3533 */
  0x8001,   /* U+3534 */
  0x8000,   /* U+3535 */
  0x8000,   /* U+3536 */
  0x8000,   /* U+3537 */
  0x8000,   /* U+3538 */
  0x8000,   /* U+3539 */
  0x8000,   /* U+353A */
  0x8001,   /* U+353B */
  0x8000,   /* U+353C */
  0x8000,   /* U+353D */
  0x8000,   /* U+353E */
  0x8001,   /* U+353F */
  0xB540,   /* U+3540 */
  0x8000,   /* U+3541 */
  0x8000,   /* U+3542 */
  0x8001,   /* U+3543 */
  0x8002,   /* U+3544 */
  0x8000,   /* U+3545 */
  0x8001,   /* U+3546 */
  0x8002,   /* U+3547 */
  0x8000,   /* U+3548 */
  0x8001,   /* U+3549 */
  0x8000,   /* U+354A */
  0x8000,   /* U+354B */
  0x8001,   /* U+354C */
  0x8002,   /* U+354D */
  0x8000,   /* U+354E */
  0x8000,   /* U+354F */
  0x8000,   /* U+3550 */
  0x8001,   /* U+3551 */
  0x8000,   /* U+3552 */
  0xB553,   /* U+3553 */
  0xB554,   /* U+3554 */
  0x8000,   /* U+3555 */
  0x8000,   /* U+3556 */
  0x8000,   /* U+3557 */
  0x8001,   /* U+3558 */
  0x8000,   /* U+3559 */
  0x8000,   /* U+355A */
  0x8001,   /* U+355B */
  0x8000,   /* U+355C */
  0xB55D,   /* U+355D */
  0x8000,   /* U+355E */
  0x8000,   /* U+355F */
  0x8000,   /* U+3560 */
  0x8000,   /* U+3561 */
  0x8007,   /* U+3562 */
  0x8000,   /* U+3563 */
  0x8001,   /* U+3564 */
  0x8002,   /* U+3565 */
  0x8000,   /* U+3566 */
  0x8001,   /* U+3567 */
  0x8002,   /* U+3568 */
  0x8000,   /* U+3569 */
  0x8001,   /* U+356A */
  0x8002,   /* U+356B */
  0x8003,   /* U+356C */
  0x8004,   /* U+356D */
  0x8005,   /* U+356E */
  0x8006,   /* U+356F */
  0x8007,   /* U+3570 */
  0x8008,   /* U+3571 */
  0x8009,   /* U+3572 */
  0x800A,   /* U+3573 */
  0x800B,   /* U+3574 */
  0x800C,   /* U+3575 */
  0x800D,   /* U+3576 */
  0x8000,   /* U+3577 */
  0x8001,   /* U+3578 */
  0x8002,   /* U+3579 */
  0x8003,   /* U+357A */
  0x8004,   /* U+357B */
  0x8005,   /* U+357C */
  0x8006,   /* U+357D */
  0xB57E,   /* U+357E */
  0xB57F,   /* U+357F */
  0x8000,   /* U+3580 */
  0x8001,   /* U+3581 */
  0x8002,   /* U+3582 */
  0x8003,   /* U+3583 */
  0x8004,   /* U+3584 */
  0x8005,   /* U+3585 */
  0x8006,   /* U+3586 */
  0x8007,   /* U+3587 */
  0xB588,   /* U+3588 */
  0x8008,   /* U+3589 */
  0x8009,   /* U+358A */
  0xB58B,   /* U+358B */
  0xB58C,   /* U+358C */
  0xB58D,   /* U+358D */
  0xB58E,   /* U+358E */
  0x8000,   /* U+358F */
  0x8001,   /* U+3590 */
  0x8002,   /* U+3591 */
  0x8003,   /* U+3592 */
  0x8004,   /* U+3593 */
  0x8005,   /* U+3594 */
  0x8006,   /* U+3595 */
  0x8007,   /* U+3596 */
  0x8008,   /* U+3597 */
  0x8009,   /* U+3598 */
  0xB599,   /* U+3599 */
  0xB59A,   /* U+359A */
  0xB59B,   /* U+359B */
  0xB59C,   /* U+359C */
  0xB59D,   /* U+359D */
  0x800A,   /* U+359E */
  0x8000,   /* U+359F */
  0x8001,   /* U+35A0 */
  0x8002,   /* U+35A1 */
  0x8003,   /* U+35A2 */
  0x8004,   /* U+35A3 */
  0x8005,   /* U+35A4 */
  0x8006,   /* U+35A5 */
  0x8007,   /* U+35A6 */
  0x8008,   /* U+35A7 */
  0x8009,   /* U+35A8 */
  0x800A,   /* U+35A9 */
  0x800B,   /* U+35AA */
  0x800C,   /* U+35AB */
  0x800D,   /* U+35AC */
  0x800E,   /* U+35AD */
  0x800F,   /* U+35AE */
  0xB5AF,   /* U+35AF */
  0xB5B0,   /* U+35B0 */
  0xB5B1,   /* U+35B1 */
  0xB5B2,   /* U+35B2 */
  0xB5B3,   /* U+35B3 */
  0xB5B4,   /* U+35B4 */
  0x8010,   /* U+35B5 */
  0x8000,   /* U+35B6 */
  0x8001,   /* U+35B7 */
  0x8002,   /* U+35B8 */
  0x8003,   /* U+35B9 */
  0x8004,   /* U+35BA */
  0x8005,   /* U+35BB */
  0x8006,   /* U+35BC */
  0x8007,   /* U+35BD */
  0x8008,   /* U+35BE */
  0x8009,   /* U+35BF */
  0x800A,   /* U+35C0 */
  0x800B,   /* U+35C1 */
  0x800C,   /* U+35C2 */
  0x800D,   /* U+35C3 */
  0x800E,   /* U+35C4 */
  0x800F,   /* U+35C5 */
  0x8010,   /* U+35C6 */
  0x8011,   /* U+35C7 */
  0x8012,   /* U+35C8 */
  0x8013,   /* U+35C9 */
  0x8014,   /* U+35CA */
  0x8015,   /* U+35CB */
  0x8016,   /* U+35CC */
  0x8017,   /* U+35CD */
  0x8018,   /* U+35CE */
  0x8019,   /* U+35CF */
  0xB5D0,   /* U+35D0 */
  0x801A,   /* U+35D1 */
  0x8000,   /* U+35D2 */
  0x8001,   /* U+35D3 */
  0x8002,   /* U+35D4 */
  0x8003,   /* U+35D5 */
  0x8004,   /* U+35D6 */
  0x8005,   /* U+35D7 */
  0x8006,   /* U+35D8 */
  0x8007,   /* U+35D9 */
  0x8008,   /* U+35DA */
  0x8009,   /* U+35DB */
  0x800A,   /* U+35DC */
  0x800B,   /* U+35DD */
  0x800C,   /* U+35DE */
  0xB5DF,   /* U+35DF */
  0xB5E0,   /* U+35E0 */
  0xB5E1,   /* U+35E1 */
  0x8000,   /* U+35E2 */
  0x8001,   /* U+35E3 */
  0x8002,   /* U+35E4 */
  0x8003,   /* U+35E5 */
  0x8004,   /* U+35E6 */
  0x8005,   /* U+35E7 */
  0x8006,   /* U+35E8 */
  0x8007,   /* U+35E9 */
  0x8008,   /* U+35EA */
  0x8009,   /* U+35EB */
  0x800A,   /* U+35EC */
  0x800B,   /* U+35ED */
  0xB5EE,   /* U+35EE */
  0xB5EF,   /* U+35EF */
  0x800C,   /* U+35F0 */
  0x8000,   /* U+35F1 */
  0x8001,   /* U+35F2 */
  0x8002,   /* U+35F3 */
  0x8003,   /* U+35F4 */
  0x8004,   /* U+35F5 */
  0x8005,   /* U+35F6 */
  0x8006,   /* U+35F7 */
  0xB5F8,   /* U+35F8 */
  0xB5F9,   /* U+35F9 */
  0x8007,   /* U+35FA */
  0x8000,   /* U+35FB */
  0x8001,   /* U+35FC */
  0x8002,   /* U+35FD */
  0x8003,   /* U+35FE */
  0x8004,   /* U+35FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3500 */
  0x0000,   /* U+3501 */
  0x0000,   /* U+3502 */
  0x0000,   /* U+3503 */
  0x0000,   /* U+3504 */
  0x0000,   /* U+3505 */
  0x0000,   /* U+3506 */
  0x0000,   /* U+3507 */
  0x0000,   /* U+3508 */
  0x0000,   /* U+3509 */
  0x0000,   /* U+350A */
  0x0000,   /* U+350B */
  0x0000,   /* U+350C */
  0x0000,   /* U+350D */
  0x0000,   /* U+350E */
  0x0000,   /* U+350F */
  0x0000,   /* U+3510 */
  0x0000,   /* U+3511 */
  0x0000,   /* U+3512 */
  0x0000,   /* U+3513 */
  0x0000,   /* U+3514 */
  0x0000,   /* U+3515 */
  0x0000,   /* U+3516 */
  0x0000,   /* U+3517 */
  0x0000,   /* U+3518 */
  0x0000,   /* U+3519 */
  0x0000,   /* U+351A */
  0x0000,   /* U+351B */
  0x0000,   /* U+351C */
  0x0000,   /* U+351D */
  0x0000,   /* U+351E */
  0x0000,   /* U+351F */
  0x0000,   /* U+3520 */
  0x0000,   /* U+3521 */
  0x0000,   /* U+3522 */
  0x0000,   /* U+3523 */
  0x0000,   /* U+3524 */
  0x0000,   /* U+3525 */
  0x0000,   /* U+3526 */
  0x0000,   /* U+3527 */
  0x0000,   /* U+3528 */
  0x0000,   /* U+3529 */
  0x0000,   /* U+352A */
  0x0000,   /* U+352B */
  0x0000,   /* U+352C */
  0x0000,   /* U+352D */
  0x0000,   /* U+352E */
  0x0000,   /* U+352F */
  0x0000,   /* U+3530 */
  0x0000,   /* U+3531 */
  0x0000,   /* U+3532 */
  0x0000,   /* U+3533 */
  0x0000,   /* U+3534 */
  0x0000,   /* U+3535 */
  0x0000,   /* U+3536 */
  0x0000,   /* U+3537 */
  0x0000,   /* U+3538 */
  0x0000,   /* U+3539 */
  0x0000,   /* U+353A */
  0x0000,   /* U+353B */
  0x0000,   /* U+353C */
  0x0000,   /* U+353D */
  0x0000,   /* U+353E */
  0x0000,   /* U+353F */
  0x0000,   /* U+3540 */
  0x0000,   /* U+3541 */
  0x0000,   /* U+3542 */
  0x0000,   /* U+3543 */
  0x0000,   /* U+3544 */
  0x0000,   /* U+3545 */
  0x0000,   /* U+3546 */
  0x0000,   /* U+3547 */
  0x0000,   /* U+3548 */
  0x0000,   /* U+3549 */
  0x0000,   /* U+354A */
  0x0000,   /* U+354B */
  0x0000,   /* U+354C */
  0x0000,   /* U+354D */
  0x0000,   /* U+354E */
  0x0000,   /* U+354F */
  0x0000,   /* U+3550 */
  0x0000,   /* U+3551 */
  0x0000,   /* U+3552 */
  0x0000,   /* U+3553 */
  0x0000,   /* U+3554 */
  0x0000,   /* U+3555 */
  0x0000,   /* U+3556 */
  0x0000,   /* U+3557 */
  0x0000,   /* U+3558 */
  0x0000,   /* U+3559 */
  0x0000,   /* U+355A */
  0x0000,   /* U+355B */
  0x0000,   /* U+355C */
  0x0000,   /* U+355D */
  0x0000,   /* U+355E */
  0x0000,   /* U+355F */
  0x0000,   /* U+3560 */
  0x0000,   /* U+3561 */
  0x0000,   /* U+3562 */
  0x0000,   /* U+3563 */
  0x0000,   /* U+3564 */
  0x0000,   /* U+3565 */
  0x0000,   /* U+3566 */
  0x0000,   /* U+3567 */
  0x0000,   /* U+3568 */
  0x0000,   /* U+3569 */
  0x0000,   /* U+356A */
  0x0000,   /* U+356B */
  0x0000,   /* U+356C */
  0x0000,   /* U+356D */
  0x0000,   /* U+356E */
  0x0000,   /* U+356F */
  0x0000,   /* U+3570 */
  0x0000,   /* U+3571 */
  0x0000,   /* U+3572 */
  0x0000,   /* U+3573 */
  0x0000,   /* U+3574 */
  0x0000,   /* U+3575 */
  0x0000,   /* U+3576 */
  0x0000,   /* U+3577 */
  0x0000,   /* U+3578 */
  0x0000,   /* U+3579 */
  0x0000,   /* U+357A */
  0x0000,   /* U+357B */
  0x0000,   /* U+357C */
  0x0000,   /* U+357D */
  0x0000,   /* U+357E */
  0x0000,   /* U+357F */
  0x0000,   /* U+3580 */
  0x0000,   /* U+3581 */
  0x0000,   /* U+3582 */
  0x0000,   /* U+3583 */
  0x0000,   /* U+3584 */
  0x0000,   /* U+3585 */
  0x0000,   /* U+3586 */
  0x0000,   /* U+3587 */
  0x0000,   /* U+3588 */
  0x0000,   /* U+3589 */
  0x0000,   /* U+358A */
  0x0000,   /* U+358B */
  0x0000,   /* U+358C */
  0x0000,   /* U+358D */
  0x0000,   /* U+358E */
  0x0000,   /* U+358F */
  0x0000,   /* U+3590 */
  0x0000,   /* U+3591 */
  0x0000,   /* U+3592 */
  0x0000,   /* U+3593 */
  0x0000,   /* U+3594 */
  0x0000,   /* U+3595 */
  0x0000,   /* U+3596 */
  0x0000,   /* U+3597 */
  0x0000,   /* U+3598 */
  0x0000,   /* U+3599 */
  0x0000,   /* U+359A */
  0x0000,   /* U+359B */
  0x0000,   /* U+359C */
  0x0000,   /* U+359D */
  0x0000,   /* U+359E */
  0x0000,   /* U+359F */
  0x0000,   /* U+35A0 */
  0x0000,   /* U+35A1 */
  0x0000,   /* U+35A2 */
  0x0000,   /* U+35A3 */
  0x0000,   /* U+35A4 */
  0x0000,   /* U+35A5 */
  0x0000,   /* U+35A6 */
  0x0000,   /* U+35A7 */
  0x0000,   /* U+35A8 */
  0x0000,   /* U+35A9 */
  0x0000,   /* U+35AA */
  0x0000,   /* U+35AB */
  0x0000,   /* U+35AC */
  0x0000,   /* U+35AD */
  0x0000,   /* U+35AE */
  0x0000,   /* U+35AF */
  0x0000,   /* U+35B0 */
  0x0000,   /* U+35B1 */
  0x0000,   /* U+35B2 */
  0x0000,   /* U+35B3 */
  0x0000,   /* U+35B4 */
  0x0000,   /* U+35B5 */
  0x0000,   /* U+35B6 */
  0x0000,   /* U+35B7 */
  0x0000,   /* U+35B8 */
  0x0000,   /* U+35B9 */
  0x0000,   /* U+35BA */
  0x0000,   /* U+35BB */
  0x0000,   /* U+35BC */
  0x0000,   /* U+35BD */
  0x0000,   /* U+35BE */
  0x0000,   /* U+35BF */
  0x0000,   /* U+35C0 */
  0x0000,   /* U+35C1 */
  0x0000,   /* U+35C2 */
  0x0000,   /* U+35C3 */
  0x0000,   /* U+35C4 */
  0x0000,   /* U+35C5 */
  0x0000,   /* U+35C6 */
  0x0000,   /* U+35C7 */
  0x0000,   /* U+35C8 */
  0x0000,   /* U+35C9 */
  0x0000,   /* U+35CA */
  0x0000,   /* U+35CB */
  0x0000,   /* U+35CC */
  0x0000,   /* U+35CD */
  0x0000,   /* U+35CE */
  0x0000,   /* U+35CF */
  0x0000,   /* U+35D0 */
  0x0000,   /* U+35D1 */
  0x0000,   /* U+35D2 */
  0x0000,   /* U+35D3 */
  0x0000,   /* U+35D4 */
  0x0000,   /* U+35D5 */
  0x0000,   /* U+35D6 */
  0x0000,   /* U+35D7 */
  0x0000,   /* U+35D8 */
  0x0000,   /* U+35D9 */
  0x0000,   /* U+35DA */
  0x0000,   /* U+35DB */
  0x0000,   /* U+35DC */
  0x0000,   /* U+35DD */
  0x0000,   /* U+35DE */
  0x0000,   /* U+35DF */
  0x0000,   /* U+35E0 */
  0x0000,   /* U+35E1 */
  0x0000,   /* U+35E2 */
  0x0000,   /* U+35E3 */
  0x0000,   /* U+35E4 */
  0x0000,   /* U+35E5 */
  0x0000,   /* U+35E6 */
  0x0000,   /* U+35E7 */
  0x0000,   /* U+35E8 */
  0x0000,   /* U+35E9 */
  0x0000,   /* U+35EA */
  0x0000,   /* U+35EB */
  0x0000,   /* U+35EC */
  0x0000,   /* U+35ED */
  0x0000,   /* U+35EE */
  0x0000,   /* U+35EF */
  0x0000,   /* U+35F0 */
  0x0000,   /* U+35F1 */
  0x0000,   /* U+35F2 */
  0x0000,   /* U+35F3 */
  0x0000,   /* U+35F4 */
  0x0000,   /* U+35F5 */
  0x0000,   /* U+35F6 */
  0x0000,   /* U+35F7 */
  0x0000,   /* U+35F8 */
  0x0000,   /* U+35F9 */
  0x0000,   /* U+35FA */
  0x0000,   /* U+35FB */
  0x0000,   /* U+35FC */
  0x0000,   /* U+35FD */
  0x0000,   /* U+35FE */
  0x0000,   /* U+35FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3500 */
  0x0000,   /* U+3501 */
  0x0000,   /* U+3502 */
  0x0000,   /* U+3503 */
  0x0000,   /* U+3504 */
  0x0000,   /* U+3505 */
  0x0000,   /* U+3506 */
  0x0000,   /* U+3507 */
  0x0000,   /* U+3508 */
  0x0000,   /* U+3509 */
  0x0000,   /* U+350A */
  0x0000,   /* U+350B */
  0x0000,   /* U+350C */
  0x0000,   /* U+350D */
  0x0000,   /* U+350E */
  0x0000,   /* U+350F */
  0x0000,   /* U+3510 */
  0x0000,   /* U+3511 */
  0x0000,   /* U+3512 */
  0x0000,   /* U+3513 */
  0x0000,   /* U+3514 */
  0x0000,   /* U+3515 */
  0x0000,   /* U+3516 */
  0x0000,   /* U+3517 */
  0x0000,   /* U+3518 */
  0x0000,   /* U+3519 */
  0x0000,   /* U+351A */
  0x0000,   /* U+351B */
  0x0000,   /* U+351C */
  0x0000,   /* U+351D */
  0x0000,   /* U+351E */
  0x0000,   /* U+351F */
  0x0000,   /* U+3520 */
  0x0000,   /* U+3521 */
  0x0000,   /* U+3522 */
  0x0000,   /* U+3523 */
  0x0000,   /* U+3524 */
  0x0000,   /* U+3525 */
  0x0000,   /* U+3526 */
  0x0000,   /* U+3527 */
  0x0000,   /* U+3528 */
  0x0000,   /* U+3529 */
  0x0000,   /* U+352A */
  0x0000,   /* U+352B */
  0x0000,   /* U+352C */
  0x0000,   /* U+352D */
  0x0000,   /* U+352E */
  0x0000,   /* U+352F */
  0x0000,   /* U+3530 */
  0x0000,   /* U+3531 */
  0x0000,   /* U+3532 */
  0x0000,   /* U+3533 */
  0x0000,   /* U+3534 */
  0x0000,   /* U+3535 */
  0x0000,   /* U+3536 */
  0x0000,   /* U+3537 */
  0x0000,   /* U+3538 */
  0x0000,   /* U+3539 */
  0x0000,   /* U+353A */
  0x0000,   /* U+353B */
  0x0000,   /* U+353C */
  0x0000,   /* U+353D */
  0x0000,   /* U+353E */
  0x0000,   /* U+353F */
  0x0000,   /* U+3540 */
  0x0000,   /* U+3541 */
  0x0000,   /* U+3542 */
  0x0000,   /* U+3543 */
  0x0000,   /* U+3544 */
  0x0000,   /* U+3545 */
  0x0000,   /* U+3546 */
  0x0000,   /* U+3547 */
  0x0000,   /* U+3548 */
  0x0000,   /* U+3549 */
  0x0000,   /* U+354A */
  0x0000,   /* U+354B */
  0x0000,   /* U+354C */
  0x0000,   /* U+354D */
  0x0000,   /* U+354E */
  0x0000,   /* U+354F */
  0x0000,   /* U+3550 */
  0x0000,   /* U+3551 */
  0x0000,   /* U+3552 */
  0x0000,   /* U+3553 */
  0x0000,   /* U+3554 */
  0x0000,   /* U+3555 */
  0x0000,   /* U+3556 */
  0x0000,   /* U+3557 */
  0x0000,   /* U+3558 */
  0x0000,   /* U+3559 */
  0x0000,   /* U+355A */
  0x0000,   /* U+355B */
  0x0000,   /* U+355C */
  0x0000,   /* U+355D */
  0x0000,   /* U+355E */
  0x0000,   /* U+355F */
  0x0000,   /* U+3560 */
  0x0000,   /* U+3561 */
  0x0000,   /* U+3562 */
  0x0000,   /* U+3563 */
  0x0000,   /* U+3564 */
  0x0000,   /* U+3565 */
  0x0000,   /* U+3566 */
  0x0000,   /* U+3567 */
  0x0000,   /* U+3568 */
  0x0000,   /* U+3569 */
  0x0000,   /* U+356A */
  0x0000,   /* U+356B */
  0x0000,   /* U+356C */
  0x0000,   /* U+356D */
  0x0000,   /* U+356E */
  0x0000,   /* U+356F */
  0x0000,   /* U+3570 */
  0x0000,   /* U+3571 */
  0x0000,   /* U+3572 */
  0x0000,   /* U+3573 */
  0x0000,   /* U+3574 */
  0x0000,   /* U+3575 */
  0x0000,   /* U+3576 */
  0x0000,   /* U+3577 */
  0x0000,   /* U+3578 */
  0x0000,   /* U+3579 */
  0x0000,   /* U+357A */
  0x0000,   /* U+357B */
  0x0000,   /* U+357C */
  0x0000,   /* U+357D */
  0x0000,   /* U+357E */
  0x0000,   /* U+357F */
  0x0000,   /* U+3580 */
  0x0000,   /* U+3581 */
  0x0000,   /* U+3582 */
  0x0000,   /* U+3583 */
  0x0000,   /* U+3584 */
  0x0000,   /* U+3585 */
  0x0000,   /* U+3586 */
  0x0000,   /* U+3587 */
  0x0000,   /* U+3588 */
  0x0000,   /* U+3589 */
  0x0000,   /* U+358A */
  0x0000,   /* U+358B */
  0x0000,   /* U+358C */
  0x0000,   /* U+358D */
  0x0000,   /* U+358E */
  0x0000,   /* U+358F */
  0x0000,   /* U+3590 */
  0x0000,   /* U+3591 */
  0x0000,   /* U+3592 */
  0x0000,   /* U+3593 */
  0x0000,   /* U+3594 */
  0x0000,   /* U+3595 */
  0x0000,   /* U+3596 */
  0x0000,   /* U+3597 */
  0x0000,   /* U+3598 */
  0x0000,   /* U+3599 */
  0x0000,   /* U+359A */
  0x0000,   /* U+359B */
  0x0000,   /* U+359C */
  0x0000,   /* U+359D */
  0x0000,   /* U+359E */
  0x0000,   /* U+359F */
  0x0000,   /* U+35A0 */
  0x0000,   /* U+35A1 */
  0x0000,   /* U+35A2 */
  0x0000,   /* U+35A3 */
  0x0000,   /* U+35A4 */
  0x0000,   /* U+35A5 */
  0x0000,   /* U+35A6 */
  0x0000,   /* U+35A7 */
  0x0000,   /* U+35A8 */
  0x0000,   /* U+35A9 */
  0x0000,   /* U+35AA */
  0x0000,   /* U+35AB */
  0x0000,   /* U+35AC */
  0x0000,   /* U+35AD */
  0x0000,   /* U+35AE */
  0x0000,   /* U+35AF */
  0x0000,   /* U+35B0 */
  0x0000,   /* U+35B1 */
  0x0000,   /* U+35B2 */
  0x0000,   /* U+35B3 */
  0x0000,   /* U+35B4 */
  0x0000,   /* U+35B5 */
  0x0000,   /* U+35B6 */
  0x0000,   /* U+35B7 */
  0x0000,   /* U+35B8 */
  0x0000,   /* U+35B9 */
  0x0000,   /* U+35BA */
  0x0000,   /* U+35BB */
  0x0000,   /* U+35BC */
  0x0000,   /* U+35BD */
  0x0000,   /* U+35BE */
  0x0000,   /* U+35BF */
  0x0000,   /* U+35C0 */
  0x0000,   /* U+35C1 */
  0x0000,   /* U+35C2 */
  0x0000,   /* U+35C3 */
  0x0000,   /* U+35C4 */
  0x0000,   /* U+35C5 */
  0x0000,   /* U+35C6 */
  0x0000,   /* U+35C7 */
  0x0000,   /* U+35C8 */
  0x0000,   /* U+35C9 */
  0x0000,   /* U+35CA */
  0x0000,   /* U+35CB */
  0x0000,   /* U+35CC */
  0x0000,   /* U+35CD */
  0x0000,   /* U+35CE */
  0x0000,   /* U+35CF */
  0x0000,   /* U+35D0 */
  0x0000,   /* U+35D1 */
  0x0000,   /* U+35D2 */
  0x0000,   /* U+35D3 */
  0x0000,   /* U+35D4 */
  0x0000,   /* U+35D5 */
  0x0000,   /* U+35D6 */
  0x0000,   /* U+35D7 */
  0x0000,   /* U+35D8 */
  0x0000,   /* U+35D9 */
  0x0000,   /* U+35DA */
  0x0000,   /* U+35DB */
  0x0000,   /* U+35DC */
  0x0000,   /* U+35DD */
  0x0000,   /* U+35DE */
  0x0000,   /* U+35DF */
  0x0000,   /* U+35E0 */
  0x0000,   /* U+35E1 */
  0x0000,   /* U+35E2 */
  0x0000,   /* U+35E3 */
  0x0000,   /* U+35E4 */
  0x0000,   /* U+35E5 */
  0x0000,   /* U+35E6 */
  0x0000,   /* U+35E7 */
  0x0000,   /* U+35E8 */
  0x0000,   /* U+35E9 */
  0x0000,   /* U+35EA */
  0x0000,   /* U+35EB */
  0x0000,   /* U+35EC */
  0x0000,   /* U+35ED */
  0x0000,   /* U+35EE */
  0x0000,   /* U+35EF */
  0x0000,   /* U+35F0 */
  0x0000,   /* U+35F1 */
  0x0000,   /* U+35F2 */
  0x0000,   /* U+35F3 */
  0x0000,   /* U+35F4 */
  0x0000,   /* U+35F5 */
  0x0000,   /* U+35F6 */
  0x0000,   /* U+35F7 */
  0x0000,   /* U+35F8 */
  0x0000,   /* U+35F9 */
  0x0000,   /* U+35FA */
  0x0000,   /* U+35FB */
  0x0000,   /* U+35FC */
  0x0000,   /* U+35FD */
  0x0000,   /* U+35FE */
  0x0000,   /* U+35FF */
};

uint16 zh2_han_p036[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x23D9,   /* U+3600 */
  0x23D9,   /* U+3601 */
  0x23D9,   /* U+3602 */
  0x23D9,   /* U+3603 */
  0x23D9,   /* U+3604 */
  0x23DA,   /* U+3605 */
  0x23DA,   /* U+3606 */
  0x23DA,   /* U+3607 */
  0x23DA,   /* U+3608 */
  0x23DB,   /* U+3609 */
  0x23DB,   /* U+360A */
  0x23DB,   /* U+360B */
  0x23DB,   /* U+360C */
  0x23DB,   /* U+360D */
  0x23DB,   /* U+360E */
  0x5C49,   /* U+360F */
  0x23DC,   /* U+3610 */
  0x23DC,   /* U+3611 */
  0x5C49,   /* U+3612 */
  0x23DD,   /* U+3613 */
  0x23DD,   /* U+3614 */
  0x23DE,   /* U+3615 */
  0x23DE,   /* U+3616 */
  0x23DE,   /* U+3617 */
  0x5C49,   /* U+3618 */
  0x23CE,   /* U+3619 */
  0x23CE,   /* U+361A */
  0x23E2,   /* U+361B */
  0x23E3,   /* U+361C */
  0x240E,   /* U+361D */
  0x210F,   /* U+361E */
  0x5C49,   /* U+361F */
  0x2411,   /* U+3620 */
  0x2411,   /* U+3621 */
  0x2412,   /* U+3622 */
  0x2413,   /* U+3623 */
  0x2417,   /* U+3624 */
  0x241D,   /* U+3625 */
  0x244E,   /* U+3626 */
  0x2450,   /* U+3627 */
  0x2450,   /* U+3628 */
  0x2450,   /* U+3629 */
  0x2450,   /* U+362A */
  0x2450,   /* U+362B */
  0x2450,   /* U+362C */
  0x2450,   /* U+362D */
  0x2450,   /* U+362E */
  0x5C49,   /* U+362F */
  0x2450,   /* U+3630 */
  0x2451,   /* U+3631 */
  0x2451,   /* U+3632 */
  0x2451,   /* U+3633 */
  0x2451,   /* U+3634 */
  0x2451,   /* U+3635 */
  0x2452,   /* U+3636 */
  0x2452,   /* U+3637 */
  0x2452,   /* U+3638 */
  0x2452,   /* U+3639 */
  0x2452,   /* U+363A */
  0x2452,   /* U+363B */
  0x2452,   /* U+363C */
  0x2452,   /* U+363D */
  0x5C49,   /* U+363E */
  0x2453,   /* U+363F */
  0x2453,   /* U+3640 */
  0x2453,   /* U+3641 */
  0x2453,   /* U+3642 */
  0x2453,   /* U+3643 */
  0x2453,   /* U+3644 */
  0x2453,   /* U+3645 */
  0x5C49,   /* U+3646 */
  0x2454,   /* U+3647 */
  0x2454,   /* U+3648 */
  0x2454,   /* U+3649 */
  0x2454,   /* U+364A */
  0x2454,   /* U+364B */
  0x2454,   /* U+364C */
  0x2454,   /* U+364D */
  0x2455,   /* U+364E */
  0x2455,   /* U+364F */
  0x2455,   /* U+3650 */
  0x2455,   /* U+3651 */
  0x2455,   /* U+3652 */
  0x2455,   /* U+3653 */
  0x2455,   /* U+3654 */
  0x2455,   /* U+3655 */
  0x5C49,   /* U+3656 */
  0x2455,   /* U+3657 */
  0x2455,   /* U+3658 */
  0x244D,   /* U+3659 */
  0x244D,   /* U+365A */
  0x244D,   /* U+365B */
  0x244D,   /* U+365C */
  0x244D,   /* U+365D */
  0x244D,   /* U+365E */
  0x244D,   /* U+365F */
  0x2457,   /* U+3660 */
  0x2457,   /* U+3661 */
  0x2457,   /* U+3662 */
  0x2457,   /* U+3663 */
  0x2457,   /* U+3664 */
  0x2457,   /* U+3665 */
  0x2457,   /* U+3666 */
  0x2458,   /* U+3667 */
  0x2458,   /* U+3668 */
  0x2458,   /* U+3669 */
  0x2458,   /* U+366A */
  0x2458,   /* U+366B */
  0x2458,   /* U+366C */
  0x5C49,   /* U+366D */
  0x2458,   /* U+366E */
  0x2458,   /* U+366F */
  0x2459,   /* U+3670 */
  0x2459,   /* U+3671 */
  0x2459,   /* U+3672 */
  0x2459,   /* U+3673 */
  0x2459,   /* U+3674 */
  0x2459,   /* U+3675 */
  0x2459,   /* U+3676 */
  0x245A,   /* U+3677 */
  0x245A,   /* U+3678 */
  0x245A,   /* U+3679 */
  0x245A,   /* U+367A */
  0x245B,   /* U+367B */
  0x245B,   /* U+367C */
  0x5C49,   /* U+367D */
  0x245C,   /* U+367E */
  0x5C49,   /* U+367F */
  0x245D,   /* U+3680 */
  0x2461,   /* U+3681 */
  0x2462,   /* U+3682 */
  0x2495,   /* U+3683 */
  0x5C49,   /* U+3684 */
  0x24D2,   /* U+3685 */
  0x2512,   /* U+3686 */
  0x2512,   /* U+3687 */
  0x5C49,   /* U+3688 */
  0x2551,   /* U+3689 */
  0x2555,   /* U+368A */
  0x2557,   /* U+368B */
  0x2557,   /* U+368C */
  0x255B,   /* U+368D */
  0x5C49,   /* U+368E */
  0x258F,   /* U+368F */
  0x258F,   /* U+3690 */
  0x5C49,   /* U+3691 */
  0x2590,   /* U+3692 */
  0x2590,   /* U+3693 */
  0x2591,   /* U+3694 */
  0x2591,   /* U+3695 */
  0x2591,   /* U+3696 */
  0x2591,   /* U+3697 */
  0x2591,   /* U+3698 */
  0x2591,   /* U+3699 */
  0x2592,   /* U+369A */
  0x2592,   /* U+369B */
  0x2594,   /* U+369C */
  0x2594,   /* U+369D */
  0x2594,   /* U+369E */
  0x2595,   /* U+369F */
  0x258D,   /* U+36A0 */
  0x2599,   /* U+36A1 */
  0x25CE,   /* U+36A2 */
  0x25CF,   /* U+36A3 */
  0x25CF,   /* U+36A4 */
  0x25CF,   /* U+36A5 */
  0x25CF,   /* U+36A6 */
  0x25CF,   /* U+36A7 */
  0x25CF,   /* U+36A8 */
  0x25D0,   /* U+36A9 */
  0x25D0,   /* U+36AA */
  0x25D0,   /* U+36AB */
  0x25D0,   /* U+36AC */
  0x25D0,   /* U+36AD */
  0x25D0,   /* U+36AE */
  0x25D0,   /* U+36AF */
  0x25D1,   /* U+36B0 */
  0x25D1,   /* U+36B1 */
  0x25D1,   /* U+36B2 */
  0x25D1,   /* U+36B3 */
  0x25D1,   /* U+36B4 */
  0x25D1,   /* U+36B5 */
  0x25D1,   /* U+36B6 */
  0x25D1,   /* U+36B7 */
  0x25D1,   /* U+36B8 */
  0x25D1,   /* U+36B9 */
  0x25D1,   /* U+36BA */
  0x25D1,   /* U+36BB */
  0x25D1,   /* U+36BC */
  0x25D1,   /* U+36BD */
  0x25D1,   /* U+36BE */
  0x25D1,   /* U+36BF */
  0x25D1,   /* U+36C0 */
  0x25D1,   /* U+36C1 */
  0x25D2,   /* U+36C2 */
  0x25D2,   /* U+36C3 */
  0x25D2,   /* U+36C4 */
  0x25D2,   /* U+36C5 */
  0x25D2,   /* U+36C6 */
  0x25D2,   /* U+36C7 */
  0x25D2,   /* U+36C8 */
  0x25D2,   /* U+36C9 */
  0x25D2,   /* U+36CA */
  0x5C49,   /* U+36CB */
  0x5C49,   /* U+36CC */
  0x25D3,   /* U+36CD */
  0x25D3,   /* U+36CE */
  0x25D3,   /* U+36CF */
  0x25D3,   /* U+36D0 */
  0x25D3,   /* U+36D1 */
  0x25D3,   /* U+36D2 */
  0x25D3,   /* U+36D3 */
  0x25D3,   /* U+36D4 */
  0x25D3,   /* U+36D5 */
  0x25D3,   /* U+36D6 */
  0x25D3,   /* U+36D7 */
  0x25D3,   /* U+36D8 */
  0x25D3,   /* U+36D9 */
  0x25D3,   /* U+36DA */
  0x25D3,   /* U+36DB */
  0x25D3,   /* U+36DC */
  0x25D3,   /* U+36DD */
  0x25D3,   /* U+36DE */
  0x25D3,   /* U+36DF */
  0x25D0,   /* U+36E0 */
  0x5C49,   /* U+36E1 */
  0x25D3,   /* U+36E2 */
  0x25D3,   /* U+36E3 */
  0x25D3,   /* U+36E4 */
  0x25D4,   /* U+36E5 */
  0x25D4,   /* U+36E6 */
  0x25D4,   /* U+36E7 */
  0x25D4,   /* U+36E8 */
  0x25D4,   /* U+36E9 */
  0x25D4,   /* U+36EA */
  0x25D4,   /* U+36EB */
  0x25D4,   /* U+36EC */
  0x25D4,   /* U+36ED */
  0x25D5,   /* U+36EE */
  0x25D5,   /* U+36EF */
  0x25D5,   /* U+36F0 */
  0x25D5,   /* U+36F1 */
  0x25D5,   /* U+36F2 */
  0x25D5,   /* U+36F3 */
  0x25D5,   /* U+36F4 */
  0x25D5,   /* U+36F5 */
  0x25D5,   /* U+36F6 */
  0x25D5,   /* U+36F7 */
  0x25D5,   /* U+36F8 */
  0x25D5,   /* U+36F9 */
  0x25D5,   /* U+36FA */
  0x25D5,   /* U+36FB */
  0x25D5,   /* U+36FC */
  0x25D5,   /* U+36FD */
  0x25D5,   /* U+36FE */
  0x25D5,   /* U+36FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3600 */
  0x0020,   /* U+3601 */
  0x0020,   /* U+3602 */
  0x0020,   /* U+3603 */
  0x0020,   /* U+3604 */
  0x0020,   /* U+3605 */
  0x0020,   /* U+3606 */
  0x0020,   /* U+3607 */
  0x0020,   /* U+3608 */
  0x0020,   /* U+3609 */
  0x0020,   /* U+360A */
  0x0020,   /* U+360B */
  0x0020,   /* U+360C */
  0x0020,   /* U+360D */
  0x0020,   /* U+360E */
  0x0020,   /* U+360F */
  0x0020,   /* U+3610 */
  0x0020,   /* U+3611 */
  0x0020,   /* U+3612 */
  0x0020,   /* U+3613 */
  0x0020,   /* U+3614 */
  0x0020,   /* U+3615 */
  0x0020,   /* U+3616 */
  0x0020,   /* U+3617 */
  0x0020,   /* U+3618 */
  0x0020,   /* U+3619 */
  0x0020,   /* U+361A */
  0x0020,   /* U+361B */
  0x0020,   /* U+361C */
  0x0020,   /* U+361D */
  0x0020,   /* U+361E */
  0x0020,   /* U+361F */
  0x0020,   /* U+3620 */
  0x0020,   /* U+3621 */
  0x0020,   /* U+3622 */
  0x0020,   /* U+3623 */
  0x0020,   /* U+3624 */
  0x0020,   /* U+3625 */
  0x0020,   /* U+3626 */
  0x0020,   /* U+3627 */
  0x0020,   /* U+3628 */
  0x0020,   /* U+3629 */
  0x0020,   /* U+362A */
  0x0020,   /* U+362B */
  0x0020,   /* U+362C */
  0x0020,   /* U+362D */
  0x0020,   /* U+362E */
  0x0020,   /* U+362F */
  0x0020,   /* U+3630 */
  0x0020,   /* U+3631 */
  0x0020,   /* U+3632 */
  0x0020,   /* U+3633 */
  0x0020,   /* U+3634 */
  0x0020,   /* U+3635 */
  0x0020,   /* U+3636 */
  0x0020,   /* U+3637 */
  0x0020,   /* U+3638 */
  0x0020,   /* U+3639 */
  0x0020,   /* U+363A */
  0x0020,   /* U+363B */
  0x0020,   /* U+363C */
  0x0020,   /* U+363D */
  0x0020,   /* U+363E */
  0x0020,   /* U+363F */
  0x0020,   /* U+3640 */
  0x0020,   /* U+3641 */
  0x0020,   /* U+3642 */
  0x0020,   /* U+3643 */
  0x0020,   /* U+3644 */
  0x0020,   /* U+3645 */
  0x0020,   /* U+3646 */
  0x0020,   /* U+3647 */
  0x0020,   /* U+3648 */
  0x0020,   /* U+3649 */
  0x0020,   /* U+364A */
  0x0020,   /* U+364B */
  0x0020,   /* U+364C */
  0x0020,   /* U+364D */
  0x0020,   /* U+364E */
  0x0020,   /* U+364F */
  0x0020,   /* U+3650 */
  0x0020,   /* U+3651 */
  0x0020,   /* U+3652 */
  0x0020,   /* U+3653 */
  0x0020,   /* U+3654 */
  0x0020,   /* U+3655 */
  0x0020,   /* U+3656 */
  0x0020,   /* U+3657 */
  0x0020,   /* U+3658 */
  0x0020,   /* U+3659 */
  0x0020,   /* U+365A */
  0x0020,   /* U+365B */
  0x0020,   /* U+365C */
  0x0020,   /* U+365D */
  0x0020,   /* U+365E */
  0x0020,   /* U+365F */
  0x0020,   /* U+3660 */
  0x0020,   /* U+3661 */
  0x0020,   /* U+3662 */
  0x0020,   /* U+3663 */
  0x0020,   /* U+3664 */
  0x0020,   /* U+3665 */
  0x0020,   /* U+3666 */
  0x0020,   /* U+3667 */
  0x0020,   /* U+3668 */
  0x0020,   /* U+3669 */
  0x0020,   /* U+366A */
  0x0020,   /* U+366B */
  0x0020,   /* U+366C */
  0x0020,   /* U+366D */
  0x0020,   /* U+366E */
  0x0020,   /* U+366F */
  0x0020,   /* U+3670 */
  0x0020,   /* U+3671 */
  0x0020,   /* U+3672 */
  0x0020,   /* U+3673 */
  0x0020,   /* U+3674 */
  0x0020,   /* U+3675 */
  0x0020,   /* U+3676 */
  0x0020,   /* U+3677 */
  0x0020,   /* U+3678 */
  0x0020,   /* U+3679 */
  0x0020,   /* U+367A */
  0x0020,   /* U+367B */
  0x0020,   /* U+367C */
  0x0020,   /* U+367D */
  0x0020,   /* U+367E */
  0x0020,   /* U+367F */
  0x0020,   /* U+3680 */
  0x0020,   /* U+3681 */
  0x0020,   /* U+3682 */
  0x0020,   /* U+3683 */
  0x0020,   /* U+3684 */
  0x0020,   /* U+3685 */
  0x0020,   /* U+3686 */
  0x0020,   /* U+3687 */
  0x0020,   /* U+3688 */
  0x0020,   /* U+3689 */
  0x0020,   /* U+368A */
  0x0020,   /* U+368B */
  0x0020,   /* U+368C */
  0x0020,   /* U+368D */
  0x0020,   /* U+368E */
  0x0020,   /* U+368F */
  0x0020,   /* U+3690 */
  0x0020,   /* U+3691 */
  0x0020,   /* U+3692 */
  0x0020,   /* U+3693 */
  0x0020,   /* U+3694 */
  0x0020,   /* U+3695 */
  0x0020,   /* U+3696 */
  0x0020,   /* U+3697 */
  0x0020,   /* U+3698 */
  0x0020,   /* U+3699 */
  0x0020,   /* U+369A */
  0x0020,   /* U+369B */
  0x0020,   /* U+369C */
  0x0020,   /* U+369D */
  0x0020,   /* U+369E */
  0x0020,   /* U+369F */
  0x0020,   /* U+36A0 */
  0x0020,   /* U+36A1 */
  0x0020,   /* U+36A2 */
  0x0020,   /* U+36A3 */
  0x0020,   /* U+36A4 */
  0x0020,   /* U+36A5 */
  0x0020,   /* U+36A6 */
  0x0020,   /* U+36A7 */
  0x0020,   /* U+36A8 */
  0x0020,   /* U+36A9 */
  0x0020,   /* U+36AA */
  0x0020,   /* U+36AB */
  0x0020,   /* U+36AC */
  0x0020,   /* U+36AD */
  0x0020,   /* U+36AE */
  0x0020,   /* U+36AF */
  0x0020,   /* U+36B0 */
  0x0020,   /* U+36B1 */
  0x0020,   /* U+36B2 */
  0x0020,   /* U+36B3 */
  0x0020,   /* U+36B4 */
  0x0020,   /* U+36B5 */
  0x0020,   /* U+36B6 */
  0x0020,   /* U+36B7 */
  0x0020,   /* U+36B8 */
  0x0020,   /* U+36B9 */
  0x0020,   /* U+36BA */
  0x0020,   /* U+36BB */
  0x0020,   /* U+36BC */
  0x0020,   /* U+36BD */
  0x0020,   /* U+36BE */
  0x0020,   /* U+36BF */
  0x0020,   /* U+36C0 */
  0x0020,   /* U+36C1 */
  0x0020,   /* U+36C2 */
  0x0020,   /* U+36C3 */
  0x0020,   /* U+36C4 */
  0x0020,   /* U+36C5 */
  0x0020,   /* U+36C6 */
  0x0020,   /* U+36C7 */
  0x0020,   /* U+36C8 */
  0x0020,   /* U+36C9 */
  0x0020,   /* U+36CA */
  0x0020,   /* U+36CB */
  0x0020,   /* U+36CC */
  0x0020,   /* U+36CD */
  0x0020,   /* U+36CE */
  0x0020,   /* U+36CF */
  0x0020,   /* U+36D0 */
  0x0020,   /* U+36D1 */
  0x0020,   /* U+36D2 */
  0x0020,   /* U+36D3 */
  0x0020,   /* U+36D4 */
  0x0020,   /* U+36D5 */
  0x0020,   /* U+36D6 */
  0x0020,   /* U+36D7 */
  0x0020,   /* U+36D8 */
  0x0020,   /* U+36D9 */
  0x0020,   /* U+36DA */
  0x0020,   /* U+36DB */
  0x0020,   /* U+36DC */
  0x0020,   /* U+36DD */
  0x0020,   /* U+36DE */
  0x0020,   /* U+36DF */
  0x0020,   /* U+36E0 */
  0x0020,   /* U+36E1 */
  0x0020,   /* U+36E2 */
  0x0020,   /* U+36E3 */
  0x0020,   /* U+36E4 */
  0x0020,   /* U+36E5 */
  0x0020,   /* U+36E6 */
  0x0020,   /* U+36E7 */
  0x0020,   /* U+36E8 */
  0x0020,   /* U+36E9 */
  0x0020,   /* U+36EA */
  0x0020,   /* U+36EB */
  0x0020,   /* U+36EC */
  0x0020,   /* U+36ED */
  0x0020,   /* U+36EE */
  0x0020,   /* U+36EF */
  0x0020,   /* U+36F0 */
  0x0020,   /* U+36F1 */
  0x0020,   /* U+36F2 */
  0x0020,   /* U+36F3 */
  0x0020,   /* U+36F4 */
  0x0020,   /* U+36F5 */
  0x0020,   /* U+36F6 */
  0x0020,   /* U+36F7 */
  0x0020,   /* U+36F8 */
  0x0020,   /* U+36F9 */
  0x0020,   /* U+36FA */
  0x0020,   /* U+36FB */
  0x0020,   /* U+36FC */
  0x0020,   /* U+36FD */
  0x0020,   /* U+36FE */
  0x0020,   /* U+36FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3600 */
  0x0002,   /* U+3601 */
  0x0002,   /* U+3602 */
  0x0002,   /* U+3603 */
  0x0002,   /* U+3604 */
  0x0002,   /* U+3605 */
  0x0002,   /* U+3606 */
  0x0002,   /* U+3607 */
  0x0002,   /* U+3608 */
  0x0002,   /* U+3609 */
  0x0002,   /* U+360A */
  0x0002,   /* U+360B */
  0x0002,   /* U+360C */
  0x0002,   /* U+360D */
  0x0002,   /* U+360E */
  0x0002,   /* U+360F */
  0x0002,   /* U+3610 */
  0x0002,   /* U+3611 */
  0x0002,   /* U+3612 */
  0x0002,   /* U+3613 */
  0x0002,   /* U+3614 */
  0x0002,   /* U+3615 */
  0x0002,   /* U+3616 */
  0x0002,   /* U+3617 */
  0x0002,   /* U+3618 */
  0x0002,   /* U+3619 */
  0x0002,   /* U+361A */
  0x0002,   /* U+361B */
  0x0002,   /* U+361C */
  0x0002,   /* U+361D */
  0x0002,   /* U+361E */
  0x0002,   /* U+361F */
  0x0002,   /* U+3620 */
  0x0002,   /* U+3621 */
  0x0002,   /* U+3622 */
  0x0002,   /* U+3623 */
  0x0002,   /* U+3624 */
  0x0002,   /* U+3625 */
  0x0002,   /* U+3626 */
  0x0002,   /* U+3627 */
  0x0002,   /* U+3628 */
  0x0002,   /* U+3629 */
  0x0002,   /* U+362A */
  0x0002,   /* U+362B */
  0x0002,   /* U+362C */
  0x0002,   /* U+362D */
  0x0002,   /* U+362E */
  0x0002,   /* U+362F */
  0x0002,   /* U+3630 */
  0x0002,   /* U+3631 */
  0x0002,   /* U+3632 */
  0x0002,   /* U+3633 */
  0x0002,   /* U+3634 */
  0x0002,   /* U+3635 */
  0x0002,   /* U+3636 */
  0x0002,   /* U+3637 */
  0x0002,   /* U+3638 */
  0x0002,   /* U+3639 */
  0x0002,   /* U+363A */
  0x0002,   /* U+363B */
  0x0002,   /* U+363C */
  0x0002,   /* U+363D */
  0x0002,   /* U+363E */
  0x0002,   /* U+363F */
  0x0002,   /* U+3640 */
  0x0002,   /* U+3641 */
  0x0002,   /* U+3642 */
  0x0002,   /* U+3643 */
  0x0002,   /* U+3644 */
  0x0002,   /* U+3645 */
  0x0002,   /* U+3646 */
  0x0002,   /* U+3647 */
  0x0002,   /* U+3648 */
  0x0002,   /* U+3649 */
  0x0002,   /* U+364A */
  0x0002,   /* U+364B */
  0x0002,   /* U+364C */
  0x0002,   /* U+364D */
  0x0002,   /* U+364E */
  0x0002,   /* U+364F */
  0x0002,   /* U+3650 */
  0x0002,   /* U+3651 */
  0x0002,   /* U+3652 */
  0x0002,   /* U+3653 */
  0x0002,   /* U+3654 */
  0x0002,   /* U+3655 */
  0x0002,   /* U+3656 */
  0x0002,   /* U+3657 */
  0x0002,   /* U+3658 */
  0x0002,   /* U+3659 */
  0x0002,   /* U+365A */
  0x0002,   /* U+365B */
  0x0002,   /* U+365C */
  0x0002,   /* U+365D */
  0x0002,   /* U+365E */
  0x0002,   /* U+365F */
  0x0002,   /* U+3660 */
  0x0002,   /* U+3661 */
  0x0002,   /* U+3662 */
  0x0002,   /* U+3663 */
  0x0002,   /* U+3664 */
  0x0002,   /* U+3665 */
  0x0002,   /* U+3666 */
  0x0002,   /* U+3667 */
  0x0002,   /* U+3668 */
  0x0002,   /* U+3669 */
  0x0002,   /* U+366A */
  0x0002,   /* U+366B */
  0x0002,   /* U+366C */
  0x0002,   /* U+366D */
  0x0002,   /* U+366E */
  0x0002,   /* U+366F */
  0x0002,   /* U+3670 */
  0x0002,   /* U+3671 */
  0x0002,   /* U+3672 */
  0x0002,   /* U+3673 */
  0x0002,   /* U+3674 */
  0x0002,   /* U+3675 */
  0x0002,   /* U+3676 */
  0x0002,   /* U+3677 */
  0x0002,   /* U+3678 */
  0x0002,   /* U+3679 */
  0x0002,   /* U+367A */
  0x0002,   /* U+367B */
  0x0002,   /* U+367C */
  0x0002,   /* U+367D */
  0x0002,   /* U+367E */
  0x0002,   /* U+367F */
  0x0002,   /* U+3680 */
  0x0002,   /* U+3681 */
  0x0002,   /* U+3682 */
  0x0002,   /* U+3683 */
  0x0002,   /* U+3684 */
  0x0002,   /* U+3685 */
  0x0002,   /* U+3686 */
  0x0002,   /* U+3687 */
  0x0002,   /* U+3688 */
  0x0002,   /* U+3689 */
  0x0002,   /* U+368A */
  0x0002,   /* U+368B */
  0x0002,   /* U+368C */
  0x0002,   /* U+368D */
  0x0002,   /* U+368E */
  0x0002,   /* U+368F */
  0x0002,   /* U+3690 */
  0x0002,   /* U+3691 */
  0x0002,   /* U+3692 */
  0x0002,   /* U+3693 */
  0x0002,   /* U+3694 */
  0x0002,   /* U+3695 */
  0x0002,   /* U+3696 */
  0x0002,   /* U+3697 */
  0x0002,   /* U+3698 */
  0x0002,   /* U+3699 */
  0x0002,   /* U+369A */
  0x0002,   /* U+369B */
  0x0002,   /* U+369C */
  0x0002,   /* U+369D */
  0x0002,   /* U+369E */
  0x0002,   /* U+369F */
  0x0002,   /* U+36A0 */
  0x0002,   /* U+36A1 */
  0x0002,   /* U+36A2 */
  0x0002,   /* U+36A3 */
  0x0002,   /* U+36A4 */
  0x0002,   /* U+36A5 */
  0x0002,   /* U+36A6 */
  0x0002,   /* U+36A7 */
  0x0002,   /* U+36A8 */
  0x0002,   /* U+36A9 */
  0x0002,   /* U+36AA */
  0x0002,   /* U+36AB */
  0x0002,   /* U+36AC */
  0x0002,   /* U+36AD */
  0x0002,   /* U+36AE */
  0x0002,   /* U+36AF */
  0x0002,   /* U+36B0 */
  0x0002,   /* U+36B1 */
  0x0002,   /* U+36B2 */
  0x0002,   /* U+36B3 */
  0x0002,   /* U+36B4 */
  0x0002,   /* U+36B5 */
  0x0002,   /* U+36B6 */
  0x0002,   /* U+36B7 */
  0x0002,   /* U+36B8 */
  0x0002,   /* U+36B9 */
  0x0002,   /* U+36BA */
  0x0002,   /* U+36BB */
  0x0002,   /* U+36BC */
  0x0002,   /* U+36BD */
  0x0002,   /* U+36BE */
  0x0002,   /* U+36BF */
  0x0002,   /* U+36C0 */
  0x0002,   /* U+36C1 */
  0x0002,   /* U+36C2 */
  0x0002,   /* U+36C3 */
  0x0002,   /* U+36C4 */
  0x0002,   /* U+36C5 */
  0x0002,   /* U+36C6 */
  0x0002,   /* U+36C7 */
  0x0002,   /* U+36C8 */
  0x0002,   /* U+36C9 */
  0x0002,   /* U+36CA */
  0x0002,   /* U+36CB */
  0x0002,   /* U+36CC */
  0x0002,   /* U+36CD */
  0x0002,   /* U+36CE */
  0x0002,   /* U+36CF */
  0x0002,   /* U+36D0 */
  0x0002,   /* U+36D1 */
  0x0002,   /* U+36D2 */
  0x0002,   /* U+36D3 */
  0x0002,   /* U+36D4 */
  0x0002,   /* U+36D5 */
  0x0002,   /* U+36D6 */
  0x0002,   /* U+36D7 */
  0x0002,   /* U+36D8 */
  0x0002,   /* U+36D9 */
  0x0002,   /* U+36DA */
  0x0002,   /* U+36DB */
  0x0002,   /* U+36DC */
  0x0002,   /* U+36DD */
  0x0002,   /* U+36DE */
  0x0002,   /* U+36DF */
  0x0002,   /* U+36E0 */
  0x0002,   /* U+36E1 */
  0x0002,   /* U+36E2 */
  0x0002,   /* U+36E3 */
  0x0002,   /* U+36E4 */
  0x0002,   /* U+36E5 */
  0x0002,   /* U+36E6 */
  0x0002,   /* U+36E7 */
  0x0002,   /* U+36E8 */
  0x0002,   /* U+36E9 */
  0x0002,   /* U+36EA */
  0x0002,   /* U+36EB */
  0x0002,   /* U+36EC */
  0x0002,   /* U+36ED */
  0x0002,   /* U+36EE */
  0x0002,   /* U+36EF */
  0x0002,   /* U+36F0 */
  0x0002,   /* U+36F1 */
  0x0002,   /* U+36F2 */
  0x0002,   /* U+36F3 */
  0x0002,   /* U+36F4 */
  0x0002,   /* U+36F5 */
  0x0002,   /* U+36F6 */
  0x0002,   /* U+36F7 */
  0x0002,   /* U+36F8 */
  0x0002,   /* U+36F9 */
  0x0002,   /* U+36FA */
  0x0002,   /* U+36FB */
  0x0002,   /* U+36FC */
  0x0002,   /* U+36FD */
  0x0002,   /* U+36FE */
  0x0002,   /* U+36FF */

  /* Primary weight 2 for each character. */
  0x8005,   /* U+3600 */
  0x8006,   /* U+3601 */
  0x8007,   /* U+3602 */
  0x8008,   /* U+3603 */
  0x8009,   /* U+3604 */
  0x8000,   /* U+3605 */
  0x8001,   /* U+3606 */
  0x8002,   /* U+3607 */
  0x8003,   /* U+3608 */
  0x8000,   /* U+3609 */
  0x8001,   /* U+360A */
  0x8002,   /* U+360B */
  0x8003,   /* U+360C */
  0x8004,   /* U+360D */
  0x8005,   /* U+360E */
  0xB60F,   /* U+360F */
  0x8000,   /* U+3610 */
  0x8001,   /* U+3611 */
  0xB612,   /* U+3612 */
  0x8000,   /* U+3613 */
  0x8001,   /* U+3614 */
  0x8000,   /* U+3615 */
  0x8001,   /* U+3616 */
  0x8002,   /* U+3617 */
  0xB618,   /* U+3618 */
  0x8003,   /* U+3619 */
  0x8004,   /* U+361A */
  0x8000,   /* U+361B */
  0x8000,   /* U+361C */
  0x8000,   /* U+361D */
  0x8001,   /* U+361E */
  0xB61F,   /* U+361F */
  0x8000,   /* U+3620 */
  0x8001,   /* U+3621 */
  0x8000,   /* U+3622 */
  0x8000,   /* U+3623 */
  0x8000,   /* U+3624 */
  0x8000,   /* U+3625 */
  0x8000,   /* U+3626 */
  0x8000,   /* U+3627 */
  0x8001,   /* U+3628 */
  0x8002,   /* U+3629 */
  0x8003,   /* U+362A */
  0x8004,   /* U+362B */
  0x8005,   /* U+362C */
  0x8006,   /* U+362D */
  0x8007,   /* U+362E */
  0xB62F,   /* U+362F */
  0x8008,   /* U+3630 */
  0x8000,   /* U+3631 */
  0x8001,   /* U+3632 */
  0x8002,   /* U+3633 */
  0x8003,   /* U+3634 */
  0x8004,   /* U+3635 */
  0x8000,   /* U+3636 */
  0x8001,   /* U+3637 */
  0x8002,   /* U+3638 */
  0x8003,   /* U+3639 */
  0x8004,   /* U+363A */
  0x8005,   /* U+363B */
  0x8006,   /* U+363C */
  0x8007,   /* U+363D */
  0xB63E,   /* U+363E */
  0x8000,   /* U+363F */
  0x8001,   /* U+3640 */
  0x8002,   /* U+3641 */
  0x8003,   /* U+3642 */
  0x8004,   /* U+3643 */
  0x8005,   /* U+3644 */
  0x8006,   /* U+3645 */
  0xB646,   /* U+3646 */
  0x8000,   /* U+3647 */
  0x8001,   /* U+3648 */
  0x8002,   /* U+3649 */
  0x8003,   /* U+364A */
  0x8004,   /* U+364B */
  0x8005,   /* U+364C */
  0x8006,   /* U+364D */
  0x8000,   /* U+364E */
  0x8001,   /* U+364F */
  0x8002,   /* U+3650 */
  0x8003,   /* U+3651 */
  0x8004,   /* U+3652 */
  0x8005,   /* U+3653 */
  0x8006,   /* U+3654 */
  0x8007,   /* U+3655 */
  0xB656,   /* U+3656 */
  0x8008,   /* U+3657 */
  0x8009,   /* U+3658 */
  0x8000,   /* U+3659 */
  0x8001,   /* U+365A */
  0x8002,   /* U+365B */
  0x8003,   /* U+365C */
  0x8004,   /* U+365D */
  0x8005,   /* U+365E */
  0x8006,   /* U+365F */
  0x8000,   /* U+3660 */
  0x8001,   /* U+3661 */
  0x8002,   /* U+3662 */
  0x8003,   /* U+3663 */
  0x8004,   /* U+3664 */
  0x8005,   /* U+3665 */
  0x8006,   /* U+3666 */
  0x8000,   /* U+3667 */
  0x8001,   /* U+3668 */
  0x8002,   /* U+3669 */
  0x8003,   /* U+366A */
  0x8004,   /* U+366B */
  0x8005,   /* U+366C */
  0xB66D,   /* U+366D */
  0x8006,   /* U+366E */
  0x8007,   /* U+366F */
  0x8000,   /* U+3670 */
  0x8001,   /* U+3671 */
  0x8002,   /* U+3672 */
  0x8003,   /* U+3673 */
  0x8004,   /* U+3674 */
  0x8005,   /* U+3675 */
  0x8006,   /* U+3676 */
  0x8000,   /* U+3677 */
  0x8001,   /* U+3678 */
  0x8002,   /* U+3679 */
  0x8003,   /* U+367A */
  0x8000,   /* U+367B */
  0x8001,   /* U+367C */
  0xB67D,   /* U+367D */
  0x8000,   /* U+367E */
  0xB67F,   /* U+367F */
  0x8000,   /* U+3680 */
  0x8000,   /* U+3681 */
  0x8000,   /* U+3682 */
  0x8000,   /* U+3683 */
  0xB684,   /* U+3684 */
  0x8000,   /* U+3685 */
  0x8000,   /* U+3686 */
  0x8001,   /* U+3687 */
  0xB688,   /* U+3688 */
  0x8000,   /* U+3689 */
  0x8000,   /* U+368A */
  0x8000,   /* U+368B */
  0x8001,   /* U+368C */
  0x8000,   /* U+368D */
  0xB68E,   /* U+368E */
  0x8000,   /* U+368F */
  0x8001,   /* U+3690 */
  0xB691,   /* U+3691 */
  0x8000,   /* U+3692 */
  0x8001,   /* U+3693 */
  0x8000,   /* U+3694 */
  0x8001,   /* U+3695 */
  0x8002,   /* U+3696 */
  0x8003,   /* U+3697 */
  0x8004,   /* U+3698 */
  0x8005,   /* U+3699 */
  0x8000,   /* U+369A */
  0x8001,   /* U+369B */
  0x8000,   /* U+369C */
  0x8001,   /* U+369D */
  0x8002,   /* U+369E */
  0x8000,   /* U+369F */
  0x8000,   /* U+36A0 */
  0x8000,   /* U+36A1 */
  0x8000,   /* U+36A2 */
  0x8000,   /* U+36A3 */
  0x8001,   /* U+36A4 */
  0x8002,   /* U+36A5 */
  0x8003,   /* U+36A6 */
  0x8004,   /* U+36A7 */
  0x8005,   /* U+36A8 */
  0x8000,   /* U+36A9 */
  0x8001,   /* U+36AA */
  0x8002,   /* U+36AB */
  0x8003,   /* U+36AC */
  0x8004,   /* U+36AD */
  0x8005,   /* U+36AE */
  0x8006,   /* U+36AF */
  0x8000,   /* U+36B0 */
  0x8001,   /* U+36B1 */
  0x8002,   /* U+36B2 */
  0x8003,   /* U+36B3 */
  0x8004,   /* U+36B4 */
  0x8005,   /* U+36B5 */
  0x8006,   /* U+36B6 */
  0x8007,   /* U+36B7 */
  0x8008,   /* U+36B8 */
  0x8009,   /* U+36B9 */
  0x800A,   /* U+36BA */
  0x800B,   /* U+36BB */
  0x800C,   /* U+36BC */
  0x800D,   /* U+36BD */
  0x800E,   /* U+36BE */
  0x800F,   /* U+36BF */
  0x8010,   /* U+36C0 */
  0x8011,   /* U+36C1 */
  0x8000,   /* U+36C2 */
  0x8001,   /* U+36C3 */
  0x8002,   /* U+36C4 */
  0x8003,   /* U+36C5 */
  0x8004,   /* U+36C6 */
  0x8005,   /* U+36C7 */
  0x8006,   /* U+36C8 */
  0x8007,   /* U+36C9 */
  0x8008,   /* U+36CA */
  0xB6CB,   /* U+36CB */
  0xB6CC,   /* U+36CC */
  0x8000,   /* U+36CD */
  0x8001,   /* U+36CE */
  0x8002,   /* U+36CF */
  0x8003,   /* U+36D0 */
  0x8004,   /* U+36D1 */
  0x8005,   /* U+36D2 */
  0x8006,   /* U+36D3 */
  0x8007,   /* U+36D4 */
  0x8008,   /* U+36D5 */
  0x8009,   /* U+36D6 */
  0x800A,   /* U+36D7 */
  0x800B,   /* U+36D8 */
  0x800C,   /* U+36D9 */
  0x800D,   /* U+36DA */
  0x800E,   /* U+36DB */
  0x800F,   /* U+36DC */
  0x8010,   /* U+36DD */
  0x8011,   /* U+36DE */
  0x8012,   /* U+36DF */
  0x8007,   /* U+36E0 */
  0xB6E1,   /* U+36E1 */
  0x8013,   /* U+36E2 */
  0x8014,   /* U+36E3 */
  0x8015,   /* U+36E4 */
  0x8000,   /* U+36E5 */
  0x8001,   /* U+36E6 */
  0x8002,   /* U+36E7 */
  0x8003,   /* U+36E8 */
  0x8004,   /* U+36E9 */
  0x8005,   /* U+36EA */
  0x8006,   /* U+36EB */
  0x8007,   /* U+36EC */
  0x8008,   /* U+36ED */
  0x8000,   /* U+36EE */
  0x8001,   /* U+36EF */
  0x8002,   /* U+36F0 */
  0x8003,   /* U+36F1 */
  0x8004,   /* U+36F2 */
  0x8005,   /* U+36F3 */
  0x8006,   /* U+36F4 */
  0x8007,   /* U+36F5 */
  0x8008,   /* U+36F6 */
  0x8009,   /* U+36F7 */
  0x800A,   /* U+36F8 */
  0x800B,   /* U+36F9 */
  0x800C,   /* U+36FA */
  0x800D,   /* U+36FB */
  0x800E,   /* U+36FC */
  0x800F,   /* U+36FD */
  0x8010,   /* U+36FE */
  0x8011,   /* U+36FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3600 */
  0x0000,   /* U+3601 */
  0x0000,   /* U+3602 */
  0x0000,   /* U+3603 */
  0x0000,   /* U+3604 */
  0x0000,   /* U+3605 */
  0x0000,   /* U+3606 */
  0x0000,   /* U+3607 */
  0x0000,   /* U+3608 */
  0x0000,   /* U+3609 */
  0x0000,   /* U+360A */
  0x0000,   /* U+360B */
  0x0000,   /* U+360C */
  0x0000,   /* U+360D */
  0x0000,   /* U+360E */
  0x0000,   /* U+360F */
  0x0000,   /* U+3610 */
  0x0000,   /* U+3611 */
  0x0000,   /* U+3612 */
  0x0000,   /* U+3613 */
  0x0000,   /* U+3614 */
  0x0000,   /* U+3615 */
  0x0000,   /* U+3616 */
  0x0000,   /* U+3617 */
  0x0000,   /* U+3618 */
  0x0000,   /* U+3619 */
  0x0000,   /* U+361A */
  0x0000,   /* U+361B */
  0x0000,   /* U+361C */
  0x0000,   /* U+361D */
  0x0000,   /* U+361E */
  0x0000,   /* U+361F */
  0x0000,   /* U+3620 */
  0x0000,   /* U+3621 */
  0x0000,   /* U+3622 */
  0x0000,   /* U+3623 */
  0x0000,   /* U+3624 */
  0x0000,   /* U+3625 */
  0x0000,   /* U+3626 */
  0x0000,   /* U+3627 */
  0x0000,   /* U+3628 */
  0x0000,   /* U+3629 */
  0x0000,   /* U+362A */
  0x0000,   /* U+362B */
  0x0000,   /* U+362C */
  0x0000,   /* U+362D */
  0x0000,   /* U+362E */
  0x0000,   /* U+362F */
  0x0000,   /* U+3630 */
  0x0000,   /* U+3631 */
  0x0000,   /* U+3632 */
  0x0000,   /* U+3633 */
  0x0000,   /* U+3634 */
  0x0000,   /* U+3635 */
  0x0000,   /* U+3636 */
  0x0000,   /* U+3637 */
  0x0000,   /* U+3638 */
  0x0000,   /* U+3639 */
  0x0000,   /* U+363A */
  0x0000,   /* U+363B */
  0x0000,   /* U+363C */
  0x0000,   /* U+363D */
  0x0000,   /* U+363E */
  0x0000,   /* U+363F */
  0x0000,   /* U+3640 */
  0x0000,   /* U+3641 */
  0x0000,   /* U+3642 */
  0x0000,   /* U+3643 */
  0x0000,   /* U+3644 */
  0x0000,   /* U+3645 */
  0x0000,   /* U+3646 */
  0x0000,   /* U+3647 */
  0x0000,   /* U+3648 */
  0x0000,   /* U+3649 */
  0x0000,   /* U+364A */
  0x0000,   /* U+364B */
  0x0000,   /* U+364C */
  0x0000,   /* U+364D */
  0x0000,   /* U+364E */
  0x0000,   /* U+364F */
  0x0000,   /* U+3650 */
  0x0000,   /* U+3651 */
  0x0000,   /* U+3652 */
  0x0000,   /* U+3653 */
  0x0000,   /* U+3654 */
  0x0000,   /* U+3655 */
  0x0000,   /* U+3656 */
  0x0000,   /* U+3657 */
  0x0000,   /* U+3658 */
  0x0000,   /* U+3659 */
  0x0000,   /* U+365A */
  0x0000,   /* U+365B */
  0x0000,   /* U+365C */
  0x0000,   /* U+365D */
  0x0000,   /* U+365E */
  0x0000,   /* U+365F */
  0x0000,   /* U+3660 */
  0x0000,   /* U+3661 */
  0x0000,   /* U+3662 */
  0x0000,   /* U+3663 */
  0x0000,   /* U+3664 */
  0x0000,   /* U+3665 */
  0x0000,   /* U+3666 */
  0x0000,   /* U+3667 */
  0x0000,   /* U+3668 */
  0x0000,   /* U+3669 */
  0x0000,   /* U+366A */
  0x0000,   /* U+366B */
  0x0000,   /* U+366C */
  0x0000,   /* U+366D */
  0x0000,   /* U+366E */
  0x0000,   /* U+366F */
  0x0000,   /* U+3670 */
  0x0000,   /* U+3671 */
  0x0000,   /* U+3672 */
  0x0000,   /* U+3673 */
  0x0000,   /* U+3674 */
  0x0000,   /* U+3675 */
  0x0000,   /* U+3676 */
  0x0000,   /* U+3677 */
  0x0000,   /* U+3678 */
  0x0000,   /* U+3679 */
  0x0000,   /* U+367A */
  0x0000,   /* U+367B */
  0x0000,   /* U+367C */
  0x0000,   /* U+367D */
  0x0000,   /* U+367E */
  0x0000,   /* U+367F */
  0x0000,   /* U+3680 */
  0x0000,   /* U+3681 */
  0x0000,   /* U+3682 */
  0x0000,   /* U+3683 */
  0x0000,   /* U+3684 */
  0x0000,   /* U+3685 */
  0x0000,   /* U+3686 */
  0x0000,   /* U+3687 */
  0x0000,   /* U+3688 */
  0x0000,   /* U+3689 */
  0x0000,   /* U+368A */
  0x0000,   /* U+368B */
  0x0000,   /* U+368C */
  0x0000,   /* U+368D */
  0x0000,   /* U+368E */
  0x0000,   /* U+368F */
  0x0000,   /* U+3690 */
  0x0000,   /* U+3691 */
  0x0000,   /* U+3692 */
  0x0000,   /* U+3693 */
  0x0000,   /* U+3694 */
  0x0000,   /* U+3695 */
  0x0000,   /* U+3696 */
  0x0000,   /* U+3697 */
  0x0000,   /* U+3698 */
  0x0000,   /* U+3699 */
  0x0000,   /* U+369A */
  0x0000,   /* U+369B */
  0x0000,   /* U+369C */
  0x0000,   /* U+369D */
  0x0000,   /* U+369E */
  0x0000,   /* U+369F */
  0x0000,   /* U+36A0 */
  0x0000,   /* U+36A1 */
  0x0000,   /* U+36A2 */
  0x0000,   /* U+36A3 */
  0x0000,   /* U+36A4 */
  0x0000,   /* U+36A5 */
  0x0000,   /* U+36A6 */
  0x0000,   /* U+36A7 */
  0x0000,   /* U+36A8 */
  0x0000,   /* U+36A9 */
  0x0000,   /* U+36AA */
  0x0000,   /* U+36AB */
  0x0000,   /* U+36AC */
  0x0000,   /* U+36AD */
  0x0000,   /* U+36AE */
  0x0000,   /* U+36AF */
  0x0000,   /* U+36B0 */
  0x0000,   /* U+36B1 */
  0x0000,   /* U+36B2 */
  0x0000,   /* U+36B3 */
  0x0000,   /* U+36B4 */
  0x0000,   /* U+36B5 */
  0x0000,   /* U+36B6 */
  0x0000,   /* U+36B7 */
  0x0000,   /* U+36B8 */
  0x0000,   /* U+36B9 */
  0x0000,   /* U+36BA */
  0x0000,   /* U+36BB */
  0x0000,   /* U+36BC */
  0x0000,   /* U+36BD */
  0x0000,   /* U+36BE */
  0x0000,   /* U+36BF */
  0x0000,   /* U+36C0 */
  0x0000,   /* U+36C1 */
  0x0000,   /* U+36C2 */
  0x0000,   /* U+36C3 */
  0x0000,   /* U+36C4 */
  0x0000,   /* U+36C5 */
  0x0000,   /* U+36C6 */
  0x0000,   /* U+36C7 */
  0x0000,   /* U+36C8 */
  0x0000,   /* U+36C9 */
  0x0000,   /* U+36CA */
  0x0000,   /* U+36CB */
  0x0000,   /* U+36CC */
  0x0000,   /* U+36CD */
  0x0000,   /* U+36CE */
  0x0000,   /* U+36CF */
  0x0000,   /* U+36D0 */
  0x0000,   /* U+36D1 */
  0x0000,   /* U+36D2 */
  0x0000,   /* U+36D3 */
  0x0000,   /* U+36D4 */
  0x0000,   /* U+36D5 */
  0x0000,   /* U+36D6 */
  0x0000,   /* U+36D7 */
  0x0000,   /* U+36D8 */
  0x0000,   /* U+36D9 */
  0x0000,   /* U+36DA */
  0x0000,   /* U+36DB */
  0x0000,   /* U+36DC */
  0x0000,   /* U+36DD */
  0x0000,   /* U+36DE */
  0x0000,   /* U+36DF */
  0x0000,   /* U+36E0 */
  0x0000,   /* U+36E1 */
  0x0000,   /* U+36E2 */
  0x0000,   /* U+36E3 */
  0x0000,   /* U+36E4 */
  0x0000,   /* U+36E5 */
  0x0000,   /* U+36E6 */
  0x0000,   /* U+36E7 */
  0x0000,   /* U+36E8 */
  0x0000,   /* U+36E9 */
  0x0000,   /* U+36EA */
  0x0000,   /* U+36EB */
  0x0000,   /* U+36EC */
  0x0000,   /* U+36ED */
  0x0000,   /* U+36EE */
  0x0000,   /* U+36EF */
  0x0000,   /* U+36F0 */
  0x0000,   /* U+36F1 */
  0x0000,   /* U+36F2 */
  0x0000,   /* U+36F3 */
  0x0000,   /* U+36F4 */
  0x0000,   /* U+36F5 */
  0x0000,   /* U+36F6 */
  0x0000,   /* U+36F7 */
  0x0000,   /* U+36F8 */
  0x0000,   /* U+36F9 */
  0x0000,   /* U+36FA */
  0x0000,   /* U+36FB */
  0x0000,   /* U+36FC */
  0x0000,   /* U+36FD */
  0x0000,   /* U+36FE */
  0x0000,   /* U+36FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3600 */
  0x0000,   /* U+3601 */
  0x0000,   /* U+3602 */
  0x0000,   /* U+3603 */
  0x0000,   /* U+3604 */
  0x0000,   /* U+3605 */
  0x0000,   /* U+3606 */
  0x0000,   /* U+3607 */
  0x0000,   /* U+3608 */
  0x0000,   /* U+3609 */
  0x0000,   /* U+360A */
  0x0000,   /* U+360B */
  0x0000,   /* U+360C */
  0x0000,   /* U+360D */
  0x0000,   /* U+360E */
  0x0000,   /* U+360F */
  0x0000,   /* U+3610 */
  0x0000,   /* U+3611 */
  0x0000,   /* U+3612 */
  0x0000,   /* U+3613 */
  0x0000,   /* U+3614 */
  0x0000,   /* U+3615 */
  0x0000,   /* U+3616 */
  0x0000,   /* U+3617 */
  0x0000,   /* U+3618 */
  0x0000,   /* U+3619 */
  0x0000,   /* U+361A */
  0x0000,   /* U+361B */
  0x0000,   /* U+361C */
  0x0000,   /* U+361D */
  0x0000,   /* U+361E */
  0x0000,   /* U+361F */
  0x0000,   /* U+3620 */
  0x0000,   /* U+3621 */
  0x0000,   /* U+3622 */
  0x0000,   /* U+3623 */
  0x0000,   /* U+3624 */
  0x0000,   /* U+3625 */
  0x0000,   /* U+3626 */
  0x0000,   /* U+3627 */
  0x0000,   /* U+3628 */
  0x0000,   /* U+3629 */
  0x0000,   /* U+362A */
  0x0000,   /* U+362B */
  0x0000,   /* U+362C */
  0x0000,   /* U+362D */
  0x0000,   /* U+362E */
  0x0000,   /* U+362F */
  0x0000,   /* U+3630 */
  0x0000,   /* U+3631 */
  0x0000,   /* U+3632 */
  0x0000,   /* U+3633 */
  0x0000,   /* U+3634 */
  0x0000,   /* U+3635 */
  0x0000,   /* U+3636 */
  0x0000,   /* U+3637 */
  0x0000,   /* U+3638 */
  0x0000,   /* U+3639 */
  0x0000,   /* U+363A */
  0x0000,   /* U+363B */
  0x0000,   /* U+363C */
  0x0000,   /* U+363D */
  0x0000,   /* U+363E */
  0x0000,   /* U+363F */
  0x0000,   /* U+3640 */
  0x0000,   /* U+3641 */
  0x0000,   /* U+3642 */
  0x0000,   /* U+3643 */
  0x0000,   /* U+3644 */
  0x0000,   /* U+3645 */
  0x0000,   /* U+3646 */
  0x0000,   /* U+3647 */
  0x0000,   /* U+3648 */
  0x0000,   /* U+3649 */
  0x0000,   /* U+364A */
  0x0000,   /* U+364B */
  0x0000,   /* U+364C */
  0x0000,   /* U+364D */
  0x0000,   /* U+364E */
  0x0000,   /* U+364F */
  0x0000,   /* U+3650 */
  0x0000,   /* U+3651 */
  0x0000,   /* U+3652 */
  0x0000,   /* U+3653 */
  0x0000,   /* U+3654 */
  0x0000,   /* U+3655 */
  0x0000,   /* U+3656 */
  0x0000,   /* U+3657 */
  0x0000,   /* U+3658 */
  0x0000,   /* U+3659 */
  0x0000,   /* U+365A */
  0x0000,   /* U+365B */
  0x0000,   /* U+365C */
  0x0000,   /* U+365D */
  0x0000,   /* U+365E */
  0x0000,   /* U+365F */
  0x0000,   /* U+3660 */
  0x0000,   /* U+3661 */
  0x0000,   /* U+3662 */
  0x0000,   /* U+3663 */
  0x0000,   /* U+3664 */
  0x0000,   /* U+3665 */
  0x0000,   /* U+3666 */
  0x0000,   /* U+3667 */
  0x0000,   /* U+3668 */
  0x0000,   /* U+3669 */
  0x0000,   /* U+366A */
  0x0000,   /* U+366B */
  0x0000,   /* U+366C */
  0x0000,   /* U+366D */
  0x0000,   /* U+366E */
  0x0000,   /* U+366F */
  0x0000,   /* U+3670 */
  0x0000,   /* U+3671 */
  0x0000,   /* U+3672 */
  0x0000,   /* U+3673 */
  0x0000,   /* U+3674 */
  0x0000,   /* U+3675 */
  0x0000,   /* U+3676 */
  0x0000,   /* U+3677 */
  0x0000,   /* U+3678 */
  0x0000,   /* U+3679 */
  0x0000,   /* U+367A */
  0x0000,   /* U+367B */
  0x0000,   /* U+367C */
  0x0000,   /* U+367D */
  0x0000,   /* U+367E */
  0x0000,   /* U+367F */
  0x0000,   /* U+3680 */
  0x0000,   /* U+3681 */
  0x0000,   /* U+3682 */
  0x0000,   /* U+3683 */
  0x0000,   /* U+3684 */
  0x0000,   /* U+3685 */
  0x0000,   /* U+3686 */
  0x0000,   /* U+3687 */
  0x0000,   /* U+3688 */
  0x0000,   /* U+3689 */
  0x0000,   /* U+368A */
  0x0000,   /* U+368B */
  0x0000,   /* U+368C */
  0x0000,   /* U+368D */
  0x0000,   /* U+368E */
  0x0000,   /* U+368F */
  0x0000,   /* U+3690 */
  0x0000,   /* U+3691 */
  0x0000,   /* U+3692 */
  0x0000,   /* U+3693 */
  0x0000,   /* U+3694 */
  0x0000,   /* U+3695 */
  0x0000,   /* U+3696 */
  0x0000,   /* U+3697 */
  0x0000,   /* U+3698 */
  0x0000,   /* U+3699 */
  0x0000,   /* U+369A */
  0x0000,   /* U+369B */
  0x0000,   /* U+369C */
  0x0000,   /* U+369D */
  0x0000,   /* U+369E */
  0x0000,   /* U+369F */
  0x0000,   /* U+36A0 */
  0x0000,   /* U+36A1 */
  0x0000,   /* U+36A2 */
  0x0000,   /* U+36A3 */
  0x0000,   /* U+36A4 */
  0x0000,   /* U+36A5 */
  0x0000,   /* U+36A6 */
  0x0000,   /* U+36A7 */
  0x0000,   /* U+36A8 */
  0x0000,   /* U+36A9 */
  0x0000,   /* U+36AA */
  0x0000,   /* U+36AB */
  0x0000,   /* U+36AC */
  0x0000,   /* U+36AD */
  0x0000,   /* U+36AE */
  0x0000,   /* U+36AF */
  0x0000,   /* U+36B0 */
  0x0000,   /* U+36B1 */
  0x0000,   /* U+36B2 */
  0x0000,   /* U+36B3 */
  0x0000,   /* U+36B4 */
  0x0000,   /* U+36B5 */
  0x0000,   /* U+36B6 */
  0x0000,   /* U+36B7 */
  0x0000,   /* U+36B8 */
  0x0000,   /* U+36B9 */
  0x0000,   /* U+36BA */
  0x0000,   /* U+36BB */
  0x0000,   /* U+36BC */
  0x0000,   /* U+36BD */
  0x0000,   /* U+36BE */
  0x0000,   /* U+36BF */
  0x0000,   /* U+36C0 */
  0x0000,   /* U+36C1 */
  0x0000,   /* U+36C2 */
  0x0000,   /* U+36C3 */
  0x0000,   /* U+36C4 */
  0x0000,   /* U+36C5 */
  0x0000,   /* U+36C6 */
  0x0000,   /* U+36C7 */
  0x0000,   /* U+36C8 */
  0x0000,   /* U+36C9 */
  0x0000,   /* U+36CA */
  0x0000,   /* U+36CB */
  0x0000,   /* U+36CC */
  0x0000,   /* U+36CD */
  0x0000,   /* U+36CE */
  0x0000,   /* U+36CF */
  0x0000,   /* U+36D0 */
  0x0000,   /* U+36D1 */
  0x0000,   /* U+36D2 */
  0x0000,   /* U+36D3 */
  0x0000,   /* U+36D4 */
  0x0000,   /* U+36D5 */
  0x0000,   /* U+36D6 */
  0x0000,   /* U+36D7 */
  0x0000,   /* U+36D8 */
  0x0000,   /* U+36D9 */
  0x0000,   /* U+36DA */
  0x0000,   /* U+36DB */
  0x0000,   /* U+36DC */
  0x0000,   /* U+36DD */
  0x0000,   /* U+36DE */
  0x0000,   /* U+36DF */
  0x0000,   /* U+36E0 */
  0x0000,   /* U+36E1 */
  0x0000,   /* U+36E2 */
  0x0000,   /* U+36E3 */
  0x0000,   /* U+36E4 */
  0x0000,   /* U+36E5 */
  0x0000,   /* U+36E6 */
  0x0000,   /* U+36E7 */
  0x0000,   /* U+36E8 */
  0x0000,   /* U+36E9 */
  0x0000,   /* U+36EA */
  0x0000,   /* U+36EB */
  0x0000,   /* U+36EC */
  0x0000,   /* U+36ED */
  0x0000,   /* U+36EE */
  0x0000,   /* U+36EF */
  0x0000,   /* U+36F0 */
  0x0000,   /* U+36F1 */
  0x0000,   /* U+36F2 */
  0x0000,   /* U+36F3 */
  0x0000,   /* U+36F4 */
  0x0000,   /* U+36F5 */
  0x0000,   /* U+36F6 */
  0x0000,   /* U+36F7 */
  0x0000,   /* U+36F8 */
  0x0000,   /* U+36F9 */
  0x0000,   /* U+36FA */
  0x0000,   /* U+36FB */
  0x0000,   /* U+36FC */
  0x0000,   /* U+36FD */
  0x0000,   /* U+36FE */
  0x0000,   /* U+36FF */
};

uint16 zh2_han_p037[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x25D5,   /* U+3700 */
  0x25D5,   /* U+3701 */
  0x25D5,   /* U+3702 */
  0x25D5,   /* U+3703 */
  0x25D5,   /* U+3704 */
  0x25CD,   /* U+3705 */
  0x25CD,   /* U+3706 */
  0x25CD,   /* U+3707 */
  0x25CD,   /* U+3708 */
  0x25CD,   /* U+3709 */
  0x25CD,   /* U+370A */
  0x25CD,   /* U+370B */
  0x25CD,   /* U+370C */
  0x25CD,   /* U+370D */
  0x25CD,   /* U+370E */
  0x25CD,   /* U+370F */
  0x25CD,   /* U+3710 */
  0x25CD,   /* U+3711 */
  0x25CD,   /* U+3712 */
  0x25CD,   /* U+3713 */
  0x25CD,   /* U+3714 */
  0x25D7,   /* U+3715 */
  0x25D7,   /* U+3716 */
  0x25D7,   /* U+3717 */
  0x25D7,   /* U+3718 */
  0x25D7,   /* U+3719 */
  0x25D7,   /* U+371A */
  0x25D7,   /* U+371B */
  0x25D7,   /* U+371C */
  0x25D7,   /* U+371D */
  0x25D7,   /* U+371E */
  0x25D7,   /* U+371F */
  0x25D7,   /* U+3720 */
  0x25D7,   /* U+3721 */
  0x25D7,   /* U+3722 */
  0x25D8,   /* U+3723 */
  0x25D8,   /* U+3724 */
  0x25D8,   /* U+3725 */
  0x25D8,   /* U+3726 */
  0x25D8,   /* U+3727 */
  0x25D8,   /* U+3728 */
  0x25D9,   /* U+3729 */
  0x25D9,   /* U+372A */
  0x25D9,   /* U+372B */
  0x25D9,   /* U+372C */
  0x5C49,   /* U+372D */
  0x25DA,   /* U+372E */
  0x25DA,   /* U+372F */
  0x25DB,   /* U+3730 */
  0x25DB,   /* U+3731 */
  0x25DC,   /* U+3732 */
  0x25DC,   /* U+3733 */
  0x25DC,   /* U+3734 */
  0x25DC,   /* U+3735 */
  0x5C49,   /* U+3736 */
  0x25DD,   /* U+3737 */
  0x25DD,   /* U+3738 */
  0x25DE,   /* U+3739 */
  0x25DF,   /* U+373A */
  0x25E3,   /* U+373B */
  0x25E3,   /* U+373C */
  0x260F,   /* U+373D */
  0x2610,   /* U+373E */
  0x2610,   /* U+373F */
  0x2611,   /* U+3740 */
  0x2612,   /* U+3741 */
  0x2613,   /* U+3742 */
  0x2613,   /* U+3743 */
  0x2615,   /* U+3744 */
  0x260D,   /* U+3745 */
  0x5C49,   /* U+3746 */
  0x2619,   /* U+3747 */
  0x2622,   /* U+3748 */
  0x264D,   /* U+3749 */
  0x264E,   /* U+374A */
  0x264E,   /* U+374B */
  0x264F,   /* U+374C */
  0x5C49,   /* U+374D */
  0x2650,   /* U+374E */
  0x2650,   /* U+374F */
  0x2650,   /* U+3750 */
  0x2650,   /* U+3751 */
  0x2651,   /* U+3752 */
  0x2652,   /* U+3753 */
  0x2652,   /* U+3754 */
  0x2652,   /* U+3755 */
  0x2652,   /* U+3756 */
  0x2653,   /* U+3757 */
  0x2653,   /* U+3758 */
  0x2653,   /* U+3759 */
  0x2653,   /* U+375A */
  0x2654,   /* U+375B */
  0x2654,   /* U+375C */
  0x2654,   /* U+375D */
  0x2654,   /* U+375E */
  0x2654,   /* U+375F */
  0x2654,   /* U+3760 */
  0x2654,   /* U+3761 */
  0x2655,   /* U+3762 */
  0x2655,   /* U+3763 */
  0x264D,   /* U+3764 */
  0x264D,   /* U+3765 */
  0x264D,   /* U+3766 */
  0x264D,   /* U+3767 */
  0x264D,   /* U+3768 */
  0x2657,   /* U+3769 */
  0x2657,   /* U+376A */
  0x2657,   /* U+376B */
  0x2657,   /* U+376C */
  0x2658,   /* U+376D */
  0x2658,   /* U+376E */
  0x2658,   /* U+376F */
  0x265B,   /* U+3770 */
  0x265E,   /* U+3771 */
  0x2663,   /* U+3772 */
  0x5C49,   /* U+3773 */
  0x2690,   /* U+3774 */
  0x2691,   /* U+3775 */
  0x2693,   /* U+3776 */
  0x5C49,   /* U+3777 */
  0x26D3,   /* U+3778 */
  0x26D5,   /* U+3779 */
  0x26D7,   /* U+377A */
  0x26D8,   /* U+377B */
  0x270F,   /* U+377C */
  0x2710,   /* U+377D */
  0x2711,   /* U+377E */
  0x2711,   /* U+377F */
  0x2712,   /* U+3780 */
  0x2712,   /* U+3781 */
  0x2713,   /* U+3782 */
  0x2714,   /* U+3783 */
  0x2714,   /* U+3784 */
  0x2714,   /* U+3785 */
  0x2714,   /* U+3786 */
  0x2715,   /* U+3787 */
  0x2715,   /* U+3788 */
  0x270D,   /* U+3789 */
  0x270D,   /* U+378A */
  0x274E,   /* U+378B */
  0x274F,   /* U+378C */
  0x5C49,   /* U+378D */
  0x2750,   /* U+378E */
  0x2751,   /* U+378F */
  0x2751,   /* U+3790 */
  0x2751,   /* U+3791 */
  0x2752,   /* U+3792 */
  0x2752,   /* U+3793 */
  0x2752,   /* U+3794 */
  0x2752,   /* U+3795 */
  0x2752,   /* U+3796 */
  0x2753,   /* U+3797 */
  0x2754,   /* U+3798 */
  0x2754,   /* U+3799 */
  0x2755,   /* U+379A */
  0x2755,   /* U+379B */
  0x2757,   /* U+379C */
  0x5C49,   /* U+379D */
  0x2757,   /* U+379E */
  0x2758,   /* U+379F */
  0x2758,   /* U+37A0 */
  0x275C,   /* U+37A1 */
  0x278D,   /* U+37A2 */
  0x2790,   /* U+37A3 */
  0x27CE,   /* U+37A4 */
  0x27CE,   /* U+37A5 */
  0x27CE,   /* U+37A6 */
  0x27CE,   /* U+37A7 */
  0x27CF,   /* U+37A8 */
  0x27CF,   /* U+37A9 */
  0x27CF,   /* U+37AA */
  0x27CF,   /* U+37AB */
  0x27CF,   /* U+37AC */
  0x27CF,   /* U+37AD */
  0x5C49,   /* U+37AE */
  0x5C49,   /* U+37AF */
  0x27D0,   /* U+37B0 */
  0x27D0,   /* U+37B1 */
  0x27D0,   /* U+37B2 */
  0x27D0,   /* U+37B3 */
  0x27D0,   /* U+37B4 */
  0x27D0,   /* U+37B5 */
  0x27D0,   /* U+37B6 */
  0x2790,   /* U+37B7 */
  0x27D0,   /* U+37B8 */
  0x27D1,   /* U+37B9 */
  0x27D1,   /* U+37BA */
  0x27D1,   /* U+37BB */
  0x27D1,   /* U+37BC */
  0x27D1,   /* U+37BD */
  0x27D1,   /* U+37BE */
  0x27D1,   /* U+37BF */
  0x27D1,   /* U+37C0 */
  0x27D1,   /* U+37C1 */
  0x27D1,   /* U+37C2 */
  0x27D1,   /* U+37C3 */
  0x27D2,   /* U+37C4 */
  0x27D2,   /* U+37C5 */
  0x27D2,   /* U+37C6 */
  0x27D3,   /* U+37C7 */
  0x27D3,   /* U+37C8 */
  0x27D3,   /* U+37C9 */
  0x27D3,   /* U+37CA */
  0x27D3,   /* U+37CB */
  0x27D3,   /* U+37CC */
  0x27D3,   /* U+37CD */
  0x27D3,   /* U+37CE */
  0x27D3,   /* U+37CF */
  0x27D3,   /* U+37D0 */
  0x27D3,   /* U+37D1 */
  0x27D3,   /* U+37D2 */
  0x27D3,   /* U+37D3 */
  0x27D3,   /* U+37D4 */
  0x5C49,   /* U+37D5 */
  0x27D3,   /* U+37D6 */
  0x27D4,   /* U+37D7 */
  0x27D4,   /* U+37D8 */
  0x27D4,   /* U+37D9 */
  0x27D4,   /* U+37DA */
  0x27D4,   /* U+37DB */
  0x27D4,   /* U+37DC */
  0x27D4,   /* U+37DD */
  0x27D4,   /* U+37DE */
  0x27D4,   /* U+37DF */
  0x27D4,   /* U+37E0 */
  0x5C49,   /* U+37E1 */
  0x27D4,   /* U+37E2 */
  0x5C49,   /* U+37E3 */
  0x27D4,   /* U+37E4 */
  0x5C49,   /* U+37E5 */
  0x27D5,   /* U+37E6 */
  0x27D5,   /* U+37E7 */
  0x27D5,   /* U+37E8 */
  0x27D5,   /* U+37E9 */
  0x27D5,   /* U+37EA */
  0x27D5,   /* U+37EB */
  0x27D5,   /* U+37EC */
  0x27D5,   /* U+37ED */
  0x27D5,   /* U+37EE */
  0x27D5,   /* U+37EF */
  0x27CD,   /* U+37F0 */
  0x27CD,   /* U+37F1 */
  0x27CD,   /* U+37F2 */
  0x27CD,   /* U+37F3 */
  0x27CD,   /* U+37F4 */
  0x27CD,   /* U+37F5 */
  0x27CD,   /* U+37F6 */
  0x27CD,   /* U+37F7 */
  0x27CD,   /* U+37F8 */
  0x27D7,   /* U+37F9 */
  0x27D7,   /* U+37FA */
  0x27D7,   /* U+37FB */
  0x27D7,   /* U+37FC */
  0x27D7,   /* U+37FD */
  0x27D7,   /* U+37FE */
  0x27D7,   /* U+37FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3700 */
  0x0020,   /* U+3701 */
  0x0020,   /* U+3702 */
  0x0020,   /* U+3703 */
  0x0020,   /* U+3704 */
  0x0020,   /* U+3705 */
  0x0020,   /* U+3706 */
  0x0020,   /* U+3707 */
  0x0020,   /* U+3708 */
  0x0020,   /* U+3709 */
  0x0020,   /* U+370A */
  0x0020,   /* U+370B */
  0x0020,   /* U+370C */
  0x0020,   /* U+370D */
  0x0020,   /* U+370E */
  0x0020,   /* U+370F */
  0x0020,   /* U+3710 */
  0x0020,   /* U+3711 */
  0x0020,   /* U+3712 */
  0x0020,   /* U+3713 */
  0x0020,   /* U+3714 */
  0x0020,   /* U+3715 */
  0x0020,   /* U+3716 */
  0x0020,   /* U+3717 */
  0x0020,   /* U+3718 */
  0x0020,   /* U+3719 */
  0x0020,   /* U+371A */
  0x0020,   /* U+371B */
  0x0020,   /* U+371C */
  0x0020,   /* U+371D */
  0x0020,   /* U+371E */
  0x0020,   /* U+371F */
  0x0020,   /* U+3720 */
  0x0020,   /* U+3721 */
  0x0020,   /* U+3722 */
  0x0020,   /* U+3723 */
  0x0020,   /* U+3724 */
  0x0020,   /* U+3725 */
  0x0020,   /* U+3726 */
  0x0020,   /* U+3727 */
  0x0020,   /* U+3728 */
  0x0020,   /* U+3729 */
  0x0020,   /* U+372A */
  0x0020,   /* U+372B */
  0x0020,   /* U+372C */
  0x0020,   /* U+372D */
  0x0020,   /* U+372E */
  0x0020,   /* U+372F */
  0x0020,   /* U+3730 */
  0x0020,   /* U+3731 */
  0x0020,   /* U+3732 */
  0x0020,   /* U+3733 */
  0x0020,   /* U+3734 */
  0x0020,   /* U+3735 */
  0x0020,   /* U+3736 */
  0x0020,   /* U+3737 */
  0x0020,   /* U+3738 */
  0x0020,   /* U+3739 */
  0x0020,   /* U+373A */
  0x0020,   /* U+373B */
  0x0020,   /* U+373C */
  0x0020,   /* U+373D */
  0x0020,   /* U+373E */
  0x0020,   /* U+373F */
  0x0020,   /* U+3740 */
  0x0020,   /* U+3741 */
  0x0020,   /* U+3742 */
  0x0020,   /* U+3743 */
  0x0020,   /* U+3744 */
  0x0020,   /* U+3745 */
  0x0020,   /* U+3746 */
  0x0020,   /* U+3747 */
  0x0020,   /* U+3748 */
  0x0020,   /* U+3749 */
  0x0020,   /* U+374A */
  0x0020,   /* U+374B */
  0x0020,   /* U+374C */
  0x0020,   /* U+374D */
  0x0020,   /* U+374E */
  0x0020,   /* U+374F */
  0x0020,   /* U+3750 */
  0x0020,   /* U+3751 */
  0x0020,   /* U+3752 */
  0x0020,   /* U+3753 */
  0x0020,   /* U+3754 */
  0x0020,   /* U+3755 */
  0x0020,   /* U+3756 */
  0x0020,   /* U+3757 */
  0x0020,   /* U+3758 */
  0x0020,   /* U+3759 */
  0x0020,   /* U+375A */
  0x0020,   /* U+375B */
  0x0020,   /* U+375C */
  0x0020,   /* U+375D */
  0x0020,   /* U+375E */
  0x0020,   /* U+375F */
  0x0020,   /* U+3760 */
  0x0020,   /* U+3761 */
  0x0020,   /* U+3762 */
  0x0020,   /* U+3763 */
  0x0020,   /* U+3764 */
  0x0020,   /* U+3765 */
  0x0020,   /* U+3766 */
  0x0020,   /* U+3767 */
  0x0020,   /* U+3768 */
  0x0020,   /* U+3769 */
  0x0020,   /* U+376A */
  0x0020,   /* U+376B */
  0x0020,   /* U+376C */
  0x0020,   /* U+376D */
  0x0020,   /* U+376E */
  0x0020,   /* U+376F */
  0x0020,   /* U+3770 */
  0x0020,   /* U+3771 */
  0x0020,   /* U+3772 */
  0x0020,   /* U+3773 */
  0x0020,   /* U+3774 */
  0x0020,   /* U+3775 */
  0x0020,   /* U+3776 */
  0x0020,   /* U+3777 */
  0x0020,   /* U+3778 */
  0x0020,   /* U+3779 */
  0x0020,   /* U+377A */
  0x0020,   /* U+377B */
  0x0020,   /* U+377C */
  0x0020,   /* U+377D */
  0x0020,   /* U+377E */
  0x0020,   /* U+377F */
  0x0020,   /* U+3780 */
  0x0020,   /* U+3781 */
  0x0020,   /* U+3782 */
  0x0020,   /* U+3783 */
  0x0020,   /* U+3784 */
  0x0020,   /* U+3785 */
  0x0020,   /* U+3786 */
  0x0020,   /* U+3787 */
  0x0020,   /* U+3788 */
  0x0020,   /* U+3789 */
  0x0020,   /* U+378A */
  0x0020,   /* U+378B */
  0x0020,   /* U+378C */
  0x0020,   /* U+378D */
  0x0020,   /* U+378E */
  0x0020,   /* U+378F */
  0x0020,   /* U+3790 */
  0x0020,   /* U+3791 */
  0x0020,   /* U+3792 */
  0x0020,   /* U+3793 */
  0x0020,   /* U+3794 */
  0x0020,   /* U+3795 */
  0x0020,   /* U+3796 */
  0x0020,   /* U+3797 */
  0x0020,   /* U+3798 */
  0x0020,   /* U+3799 */
  0x0020,   /* U+379A */
  0x0020,   /* U+379B */
  0x0020,   /* U+379C */
  0x0020,   /* U+379D */
  0x0020,   /* U+379E */
  0x0020,   /* U+379F */
  0x0020,   /* U+37A0 */
  0x0020,   /* U+37A1 */
  0x0020,   /* U+37A2 */
  0x0020,   /* U+37A3 */
  0x0020,   /* U+37A4 */
  0x0020,   /* U+37A5 */
  0x0020,   /* U+37A6 */
  0x0020,   /* U+37A7 */
  0x0020,   /* U+37A8 */
  0x0020,   /* U+37A9 */
  0x0020,   /* U+37AA */
  0x0020,   /* U+37AB */
  0x0020,   /* U+37AC */
  0x0020,   /* U+37AD */
  0x0020,   /* U+37AE */
  0x0020,   /* U+37AF */
  0x0020,   /* U+37B0 */
  0x0020,   /* U+37B1 */
  0x0020,   /* U+37B2 */
  0x0020,   /* U+37B3 */
  0x0020,   /* U+37B4 */
  0x0020,   /* U+37B5 */
  0x0020,   /* U+37B6 */
  0x0020,   /* U+37B7 */
  0x0020,   /* U+37B8 */
  0x0020,   /* U+37B9 */
  0x0020,   /* U+37BA */
  0x0020,   /* U+37BB */
  0x0020,   /* U+37BC */
  0x0020,   /* U+37BD */
  0x0020,   /* U+37BE */
  0x0020,   /* U+37BF */
  0x0020,   /* U+37C0 */
  0x0020,   /* U+37C1 */
  0x0020,   /* U+37C2 */
  0x0020,   /* U+37C3 */
  0x0020,   /* U+37C4 */
  0x0020,   /* U+37C5 */
  0x0020,   /* U+37C6 */
  0x0020,   /* U+37C7 */
  0x0020,   /* U+37C8 */
  0x0020,   /* U+37C9 */
  0x0020,   /* U+37CA */
  0x0020,   /* U+37CB */
  0x0020,   /* U+37CC */
  0x0020,   /* U+37CD */
  0x0020,   /* U+37CE */
  0x0020,   /* U+37CF */
  0x0020,   /* U+37D0 */
  0x0020,   /* U+37D1 */
  0x0020,   /* U+37D2 */
  0x0020,   /* U+37D3 */
  0x0020,   /* U+37D4 */
  0x0020,   /* U+37D5 */
  0x0020,   /* U+37D6 */
  0x0020,   /* U+37D7 */
  0x0020,   /* U+37D8 */
  0x0020,   /* U+37D9 */
  0x0020,   /* U+37DA */
  0x0020,   /* U+37DB */
  0x0020,   /* U+37DC */
  0x0020,   /* U+37DD */
  0x0020,   /* U+37DE */
  0x0020,   /* U+37DF */
  0x0020,   /* U+37E0 */
  0x0020,   /* U+37E1 */
  0x0020,   /* U+37E2 */
  0x0020,   /* U+37E3 */
  0x0020,   /* U+37E4 */
  0x0020,   /* U+37E5 */
  0x0020,   /* U+37E6 */
  0x0020,   /* U+37E7 */
  0x0020,   /* U+37E8 */
  0x0020,   /* U+37E9 */
  0x0020,   /* U+37EA */
  0x0020,   /* U+37EB */
  0x0020,   /* U+37EC */
  0x0020,   /* U+37ED */
  0x0020,   /* U+37EE */
  0x0020,   /* U+37EF */
  0x0020,   /* U+37F0 */
  0x0020,   /* U+37F1 */
  0x0020,   /* U+37F2 */
  0x0020,   /* U+37F3 */
  0x0020,   /* U+37F4 */
  0x0020,   /* U+37F5 */
  0x0020,   /* U+37F6 */
  0x0020,   /* U+37F7 */
  0x0020,   /* U+37F8 */
  0x0020,   /* U+37F9 */
  0x0020,   /* U+37FA */
  0x0020,   /* U+37FB */
  0x0020,   /* U+37FC */
  0x0020,   /* U+37FD */
  0x0020,   /* U+37FE */
  0x0020,   /* U+37FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3700 */
  0x0002,   /* U+3701 */
  0x0002,   /* U+3702 */
  0x0002,   /* U+3703 */
  0x0002,   /* U+3704 */
  0x0002,   /* U+3705 */
  0x0002,   /* U+3706 */
  0x0002,   /* U+3707 */
  0x0002,   /* U+3708 */
  0x0002,   /* U+3709 */
  0x0002,   /* U+370A */
  0x0002,   /* U+370B */
  0x0002,   /* U+370C */
  0x0002,   /* U+370D */
  0x0002,   /* U+370E */
  0x0002,   /* U+370F */
  0x0002,   /* U+3710 */
  0x0002,   /* U+3711 */
  0x0002,   /* U+3712 */
  0x0002,   /* U+3713 */
  0x0002,   /* U+3714 */
  0x0002,   /* U+3715 */
  0x0002,   /* U+3716 */
  0x0002,   /* U+3717 */
  0x0002,   /* U+3718 */
  0x0002,   /* U+3719 */
  0x0002,   /* U+371A */
  0x0002,   /* U+371B */
  0x0002,   /* U+371C */
  0x0002,   /* U+371D */
  0x0002,   /* U+371E */
  0x0002,   /* U+371F */
  0x0002,   /* U+3720 */
  0x0002,   /* U+3721 */
  0x0002,   /* U+3722 */
  0x0002,   /* U+3723 */
  0x0002,   /* U+3724 */
  0x0002,   /* U+3725 */
  0x0002,   /* U+3726 */
  0x0002,   /* U+3727 */
  0x0002,   /* U+3728 */
  0x0002,   /* U+3729 */
  0x0002,   /* U+372A */
  0x0002,   /* U+372B */
  0x0002,   /* U+372C */
  0x0002,   /* U+372D */
  0x0002,   /* U+372E */
  0x0002,   /* U+372F */
  0x0002,   /* U+3730 */
  0x0002,   /* U+3731 */
  0x0002,   /* U+3732 */
  0x0002,   /* U+3733 */
  0x0002,   /* U+3734 */
  0x0002,   /* U+3735 */
  0x0002,   /* U+3736 */
  0x0002,   /* U+3737 */
  0x0002,   /* U+3738 */
  0x0002,   /* U+3739 */
  0x0002,   /* U+373A */
  0x0002,   /* U+373B */
  0x0002,   /* U+373C */
  0x0002,   /* U+373D */
  0x0002,   /* U+373E */
  0x0002,   /* U+373F */
  0x0002,   /* U+3740 */
  0x0002,   /* U+3741 */
  0x0002,   /* U+3742 */
  0x0002,   /* U+3743 */
  0x0002,   /* U+3744 */
  0x0002,   /* U+3745 */
  0x0002,   /* U+3746 */
  0x0002,   /* U+3747 */
  0x0002,   /* U+3748 */
  0x0002,   /* U+3749 */
  0x0002,   /* U+374A */
  0x0002,   /* U+374B */
  0x0002,   /* U+374C */
  0x0002,   /* U+374D */
  0x0002,   /* U+374E */
  0x0002,   /* U+374F */
  0x0002,   /* U+3750 */
  0x0002,   /* U+3751 */
  0x0002,   /* U+3752 */
  0x0002,   /* U+3753 */
  0x0002,   /* U+3754 */
  0x0002,   /* U+3755 */
  0x0002,   /* U+3756 */
  0x0002,   /* U+3757 */
  0x0002,   /* U+3758 */
  0x0002,   /* U+3759 */
  0x0002,   /* U+375A */
  0x0002,   /* U+375B */
  0x0002,   /* U+375C */
  0x0002,   /* U+375D */
  0x0002,   /* U+375E */
  0x0002,   /* U+375F */
  0x0002,   /* U+3760 */
  0x0002,   /* U+3761 */
  0x0002,   /* U+3762 */
  0x0002,   /* U+3763 */
  0x0002,   /* U+3764 */
  0x0002,   /* U+3765 */
  0x0002,   /* U+3766 */
  0x0002,   /* U+3767 */
  0x0002,   /* U+3768 */
  0x0002,   /* U+3769 */
  0x0002,   /* U+376A */
  0x0002,   /* U+376B */
  0x0002,   /* U+376C */
  0x0002,   /* U+376D */
  0x0002,   /* U+376E */
  0x0002,   /* U+376F */
  0x0002,   /* U+3770 */
  0x0002,   /* U+3771 */
  0x0002,   /* U+3772 */
  0x0002,   /* U+3773 */
  0x0002,   /* U+3774 */
  0x0002,   /* U+3775 */
  0x0002,   /* U+3776 */
  0x0002,   /* U+3777 */
  0x0002,   /* U+3778 */
  0x0002,   /* U+3779 */
  0x0002,   /* U+377A */
  0x0002,   /* U+377B */
  0x0002,   /* U+377C */
  0x0002,   /* U+377D */
  0x0002,   /* U+377E */
  0x0002,   /* U+377F */
  0x0002,   /* U+3780 */
  0x0002,   /* U+3781 */
  0x0002,   /* U+3782 */
  0x0002,   /* U+3783 */
  0x0002,   /* U+3784 */
  0x0002,   /* U+3785 */
  0x0002,   /* U+3786 */
  0x0002,   /* U+3787 */
  0x0002,   /* U+3788 */
  0x0002,   /* U+3789 */
  0x0002,   /* U+378A */
  0x0002,   /* U+378B */
  0x0002,   /* U+378C */
  0x0002,   /* U+378D */
  0x0002,   /* U+378E */
  0x0002,   /* U+378F */
  0x0002,   /* U+3790 */
  0x0002,   /* U+3791 */
  0x0002,   /* U+3792 */
  0x0002,   /* U+3793 */
  0x0002,   /* U+3794 */
  0x0002,   /* U+3795 */
  0x0002,   /* U+3796 */
  0x0002,   /* U+3797 */
  0x0002,   /* U+3798 */
  0x0002,   /* U+3799 */
  0x0002,   /* U+379A */
  0x0002,   /* U+379B */
  0x0002,   /* U+379C */
  0x0002,   /* U+379D */
  0x0002,   /* U+379E */
  0x0002,   /* U+379F */
  0x0002,   /* U+37A0 */
  0x0002,   /* U+37A1 */
  0x0002,   /* U+37A2 */
  0x0002,   /* U+37A3 */
  0x0002,   /* U+37A4 */
  0x0002,   /* U+37A5 */
  0x0002,   /* U+37A6 */
  0x0002,   /* U+37A7 */
  0x0002,   /* U+37A8 */
  0x0002,   /* U+37A9 */
  0x0002,   /* U+37AA */
  0x0002,   /* U+37AB */
  0x0002,   /* U+37AC */
  0x0002,   /* U+37AD */
  0x0002,   /* U+37AE */
  0x0002,   /* U+37AF */
  0x0002,   /* U+37B0 */
  0x0002,   /* U+37B1 */
  0x0002,   /* U+37B2 */
  0x0002,   /* U+37B3 */
  0x0002,   /* U+37B4 */
  0x0002,   /* U+37B5 */
  0x0002,   /* U+37B6 */
  0x0002,   /* U+37B7 */
  0x0002,   /* U+37B8 */
  0x0002,   /* U+37B9 */
  0x0002,   /* U+37BA */
  0x0002,   /* U+37BB */
  0x0002,   /* U+37BC */
  0x0002,   /* U+37BD */
  0x0002,   /* U+37BE */
  0x0002,   /* U+37BF */
  0x0002,   /* U+37C0 */
  0x0002,   /* U+37C1 */
  0x0002,   /* U+37C2 */
  0x0002,   /* U+37C3 */
  0x0002,   /* U+37C4 */
  0x0002,   /* U+37C5 */
  0x0002,   /* U+37C6 */
  0x0002,   /* U+37C7 */
  0x0002,   /* U+37C8 */
  0x0002,   /* U+37C9 */
  0x0002,   /* U+37CA */
  0x0002,   /* U+37CB */
  0x0002,   /* U+37CC */
  0x0002,   /* U+37CD */
  0x0002,   /* U+37CE */
  0x0002,   /* U+37CF */
  0x0002,   /* U+37D0 */
  0x0002,   /* U+37D1 */
  0x0002,   /* U+37D2 */
  0x0002,   /* U+37D3 */
  0x0002,   /* U+37D4 */
  0x0002,   /* U+37D5 */
  0x0002,   /* U+37D6 */
  0x0002,   /* U+37D7 */
  0x0002,   /* U+37D8 */
  0x0002,   /* U+37D9 */
  0x0002,   /* U+37DA */
  0x0002,   /* U+37DB */
  0x0002,   /* U+37DC */
  0x0002,   /* U+37DD */
  0x0002,   /* U+37DE */
  0x0002,   /* U+37DF */
  0x0002,   /* U+37E0 */
  0x0002,   /* U+37E1 */
  0x0002,   /* U+37E2 */
  0x0002,   /* U+37E3 */
  0x0002,   /* U+37E4 */
  0x0002,   /* U+37E5 */
  0x0002,   /* U+37E6 */
  0x0002,   /* U+37E7 */
  0x0002,   /* U+37E8 */
  0x0002,   /* U+37E9 */
  0x0002,   /* U+37EA */
  0x0002,   /* U+37EB */
  0x0002,   /* U+37EC */
  0x0002,   /* U+37ED */
  0x0002,   /* U+37EE */
  0x0002,   /* U+37EF */
  0x0002,   /* U+37F0 */
  0x0002,   /* U+37F1 */
  0x0002,   /* U+37F2 */
  0x0002,   /* U+37F3 */
  0x0002,   /* U+37F4 */
  0x0002,   /* U+37F5 */
  0x0002,   /* U+37F6 */
  0x0002,   /* U+37F7 */
  0x0002,   /* U+37F8 */
  0x0002,   /* U+37F9 */
  0x0002,   /* U+37FA */
  0x0002,   /* U+37FB */
  0x0002,   /* U+37FC */
  0x0002,   /* U+37FD */
  0x0002,   /* U+37FE */
  0x0002,   /* U+37FF */

  /* Primary weight 2 for each character. */
  0x8012,   /* U+3700 */
  0x8013,   /* U+3701 */
  0x8014,   /* U+3702 */
  0x8015,   /* U+3703 */
  0x8016,   /* U+3704 */
  0x8000,   /* U+3705 */
  0x8001,   /* U+3706 */
  0x8002,   /* U+3707 */
  0x8003,   /* U+3708 */
  0x8004,   /* U+3709 */
  0x8005,   /* U+370A */
  0x8006,   /* U+370B */
  0x8007,   /* U+370C */
  0x8008,   /* U+370D */
  0x8009,   /* U+370E */
  0x800A,   /* U+370F */
  0x800B,   /* U+3710 */
  0x800C,   /* U+3711 */
  0x800D,   /* U+3712 */
  0x800E,   /* U+3713 */
  0x800F,   /* U+3714 */
  0x8000,   /* U+3715 */
  0x8001,   /* U+3716 */
  0x8002,   /* U+3717 */
  0x8003,   /* U+3718 */
  0x8004,   /* U+3719 */
  0x8005,   /* U+371A */
  0x8006,   /* U+371B */
  0x8007,   /* U+371C */
  0x8008,   /* U+371D */
  0x8009,   /* U+371E */
  0x800A,   /* U+371F */
  0x800B,   /* U+3720 */
  0x800C,   /* U+3721 */
  0x800D,   /* U+3722 */
  0x8000,   /* U+3723 */
  0x8001,   /* U+3724 */
  0x8002,   /* U+3725 */
  0x8003,   /* U+3726 */
  0x8004,   /* U+3727 */
  0x8005,   /* U+3728 */
  0x8000,   /* U+3729 */
  0x8001,   /* U+372A */
  0x8002,   /* U+372B */
  0x8003,   /* U+372C */
  0xB72D,   /* U+372D */
  0x8000,   /* U+372E */
  0x8001,   /* U+372F */
  0x8000,   /* U+3730 */
  0x8001,   /* U+3731 */
  0x8000,   /* U+3732 */
  0x8001,   /* U+3733 */
  0x8002,   /* U+3734 */
  0x8003,   /* U+3735 */
  0xB736,   /* U+3736 */
  0x8000,   /* U+3737 */
  0x8001,   /* U+3738 */
  0x8000,   /* U+3739 */
  0x8000,   /* U+373A */
  0x8000,   /* U+373B */
  0x8001,   /* U+373C */
  0x8000,   /* U+373D */
  0x8000,   /* U+373E */
  0x8001,   /* U+373F */
  0x8000,   /* U+3740 */
  0x8000,   /* U+3741 */
  0x8000,   /* U+3742 */
  0x8001,   /* U+3743 */
  0x8000,   /* U+3744 */
  0x8000,   /* U+3745 */
  0xB746,   /* U+3746 */
  0x8000,   /* U+3747 */
  0x8000,   /* U+3748 */
  0x8000,   /* U+3749 */
  0x8000,   /* U+374A */
  0x8001,   /* U+374B */
  0x8000,   /* U+374C */
  0xB74D,   /* U+374D */
  0x8000,   /* U+374E */
  0x8001,   /* U+374F */
  0x8002,   /* U+3750 */
  0x8003,   /* U+3751 */
  0x8000,   /* U+3752 */
  0x8000,   /* U+3753 */
  0x8001,   /* U+3754 */
  0x8002,   /* U+3755 */
  0x8003,   /* U+3756 */
  0x8000,   /* U+3757 */
  0x8001,   /* U+3758 */
  0x8002,   /* U+3759 */
  0x8003,   /* U+375A */
  0x8000,   /* U+375B */
  0x8001,   /* U+375C */
  0x8002,   /* U+375D */
  0x8003,   /* U+375E */
  0x8004,   /* U+375F */
  0x8005,   /* U+3760 */
  0x8006,   /* U+3761 */
  0x8000,   /* U+3762 */
  0x8001,   /* U+3763 */
  0x8001,   /* U+3764 */
  0x8002,   /* U+3765 */
  0x8003,   /* U+3766 */
  0x8004,   /* U+3767 */
  0x8005,   /* U+3768 */
  0x8000,   /* U+3769 */
  0x8001,   /* U+376A */
  0x8002,   /* U+376B */
  0x8003,   /* U+376C */
  0x8000,   /* U+376D */
  0x8001,   /* U+376E */
  0x8002,   /* U+376F */
  0x8000,   /* U+3770 */
  0x8000,   /* U+3771 */
  0x8000,   /* U+3772 */
  0xB773,   /* U+3773 */
  0x8000,   /* U+3774 */
  0x8000,   /* U+3775 */
  0x8000,   /* U+3776 */
  0xB777,   /* U+3777 */
  0x8000,   /* U+3778 */
  0x8000,   /* U+3779 */
  0x8000,   /* U+377A */
  0x8000,   /* U+377B */
  0x8000,   /* U+377C */
  0x8000,   /* U+377D */
  0x8000,   /* U+377E */
  0x8001,   /* U+377F */
  0x8000,   /* U+3780 */
  0x8001,   /* U+3781 */
  0x8000,   /* U+3782 */
  0x8000,   /* U+3783 */
  0x8001,   /* U+3784 */
  0x8002,   /* U+3785 */
  0x8003,   /* U+3786 */
  0x8000,   /* U+3787 */
  0x8001,   /* U+3788 */
  0x8000,   /* U+3789 */
  0x8001,   /* U+378A */
  0x8000,   /* U+378B */
  0x8000,   /* U+378C */
  0xB78D,   /* U+378D */
  0x8000,   /* U+378E */
  0x8000,   /* U+378F */
  0x8001,   /* U+3790 */
  0x8002,   /* U+3791 */
  0x8000,   /* U+3792 */
  0x8001,   /* U+3793 */
  0x8002,   /* U+3794 */
  0x8003,   /* U+3795 */
  0x8004,   /* U+3796 */
  0x8000,   /* U+3797 */
  0x8000,   /* U+3798 */
  0x8001,   /* U+3799 */
  0x8000,   /* U+379A */
  0x8001,   /* U+379B */
  0x8000,   /* U+379C */
  0xB79D,   /* U+379D */
  0x8001,   /* U+379E */
  0x8000,   /* U+379F */
  0x8001,   /* U+37A0 */
  0x8000,   /* U+37A1 */
  0x8000,   /* U+37A2 */
  0x8000,   /* U+37A3 */
  0x8000,   /* U+37A4 */
  0x8001,   /* U+37A5 */
  0x8002,   /* U+37A6 */
  0x8003,   /* U+37A7 */
  0x8000,   /* U+37A8 */
  0x8001,   /* U+37A9 */
  0x8002,   /* U+37AA */
  0x8003,   /* U+37AB */
  0x8004,   /* U+37AC */
  0x8005,   /* U+37AD */
  0xB7AE,   /* U+37AE */
  0xB7AF,   /* U+37AF */
  0x8000,   /* U+37B0 */
  0x8001,   /* U+37B1 */
  0x8002,   /* U+37B2 */
  0x8003,   /* U+37B3 */
  0x8004,   /* U+37B4 */
  0x8005,   /* U+37B5 */
  0x8006,   /* U+37B6 */
  0x8001,   /* U+37B7 */
  0x8007,   /* U+37B8 */
  0x8000,   /* U+37B9 */
  0x8001,   /* U+37BA */
  0x8002,   /* U+37BB */
  0x8003,   /* U+37BC */
  0x8004,   /* U+37BD */
  0x8005,   /* U+37BE */
  0x8006,   /* U+37BF */
  0x8007,   /* U+37C0 */
  0x8008,   /* U+37C1 */
  0x8009,   /* U+37C2 */
  0x800A,   /* U+37C3 */
  0x8000,   /* U+37C4 */
  0x8001,   /* U+37C5 */
  0x8002,   /* U+37C6 */
  0x8000,   /* U+37C7 */
  0x8001,   /* U+37C8 */
  0x8002,   /* U+37C9 */
  0x8003,   /* U+37CA */
  0x8004,   /* U+37CB */
  0x8005,   /* U+37CC */
  0x8006,   /* U+37CD */
  0x8007,   /* U+37CE */
  0x8008,   /* U+37CF */
  0x8009,   /* U+37D0 */
  0x800A,   /* U+37D1 */
  0x800B,   /* U+37D2 */
  0x800C,   /* U+37D3 */
  0x800D,   /* U+37D4 */
  0xB7D5,   /* U+37D5 */
  0x800E,   /* U+37D6 */
  0x8000,   /* U+37D7 */
  0x8001,   /* U+37D8 */
  0x8002,   /* U+37D9 */
  0x8003,   /* U+37DA */
  0x8004,   /* U+37DB */
  0x8005,   /* U+37DC */
  0x8006,   /* U+37DD */
  0x8007,   /* U+37DE */
  0x8008,   /* U+37DF */
  0x8009,   /* U+37E0 */
  0xB7E1,   /* U+37E1 */
  0x800A,   /* U+37E2 */
  0xB7E3,   /* U+37E3 */
  0x800B,   /* U+37E4 */
  0xB7E5,   /* U+37E5 */
  0x8000,   /* U+37E6 */
  0x8001,   /* U+37E7 */
  0x8002,   /* U+37E8 */
  0x8003,   /* U+37E9 */
  0x8004,   /* U+37EA */
  0x8005,   /* U+37EB */
  0x8006,   /* U+37EC */
  0x8007,   /* U+37ED */
  0x8008,   /* U+37EE */
  0x8009,   /* U+37EF */
  0x8000,   /* U+37F0 */
  0x8001,   /* U+37F1 */
  0x8002,   /* U+37F2 */
  0x8003,   /* U+37F3 */
  0x8004,   /* U+37F4 */
  0x8005,   /* U+37F5 */
  0x8006,   /* U+37F6 */
  0x8007,   /* U+37F7 */
  0x8008,   /* U+37F8 */
  0x8000,   /* U+37F9 */
  0x8001,   /* U+37FA */
  0x8002,   /* U+37FB */
  0x8003,   /* U+37FC */
  0x8004,   /* U+37FD */
  0x8005,   /* U+37FE */
  0x8006,   /* U+37FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3700 */
  0x0000,   /* U+3701 */
  0x0000,   /* U+3702 */
  0x0000,   /* U+3703 */
  0x0000,   /* U+3704 */
  0x0000,   /* U+3705 */
  0x0000,   /* U+3706 */
  0x0000,   /* U+3707 */
  0x0000,   /* U+3708 */
  0x0000,   /* U+3709 */
  0x0000,   /* U+370A */
  0x0000,   /* U+370B */
  0x0000,   /* U+370C */
  0x0000,   /* U+370D */
  0x0000,   /* U+370E */
  0x0000,   /* U+370F */
  0x0000,   /* U+3710 */
  0x0000,   /* U+3711 */
  0x0000,   /* U+3712 */
  0x0000,   /* U+3713 */
  0x0000,   /* U+3714 */
  0x0000,   /* U+3715 */
  0x0000,   /* U+3716 */
  0x0000,   /* U+3717 */
  0x0000,   /* U+3718 */
  0x0000,   /* U+3719 */
  0x0000,   /* U+371A */
  0x0000,   /* U+371B */
  0x0000,   /* U+371C */
  0x0000,   /* U+371D */
  0x0000,   /* U+371E */
  0x0000,   /* U+371F */
  0x0000,   /* U+3720 */
  0x0000,   /* U+3721 */
  0x0000,   /* U+3722 */
  0x0000,   /* U+3723 */
  0x0000,   /* U+3724 */
  0x0000,   /* U+3725 */
  0x0000,   /* U+3726 */
  0x0000,   /* U+3727 */
  0x0000,   /* U+3728 */
  0x0000,   /* U+3729 */
  0x0000,   /* U+372A */
  0x0000,   /* U+372B */
  0x0000,   /* U+372C */
  0x0000,   /* U+372D */
  0x0000,   /* U+372E */
  0x0000,   /* U+372F */
  0x0000,   /* U+3730 */
  0x0000,   /* U+3731 */
  0x0000,   /* U+3732 */
  0x0000,   /* U+3733 */
  0x0000,   /* U+3734 */
  0x0000,   /* U+3735 */
  0x0000,   /* U+3736 */
  0x0000,   /* U+3737 */
  0x0000,   /* U+3738 */
  0x0000,   /* U+3739 */
  0x0000,   /* U+373A */
  0x0000,   /* U+373B */
  0x0000,   /* U+373C */
  0x0000,   /* U+373D */
  0x0000,   /* U+373E */
  0x0000,   /* U+373F */
  0x0000,   /* U+3740 */
  0x0000,   /* U+3741 */
  0x0000,   /* U+3742 */
  0x0000,   /* U+3743 */
  0x0000,   /* U+3744 */
  0x0000,   /* U+3745 */
  0x0000,   /* U+3746 */
  0x0000,   /* U+3747 */
  0x0000,   /* U+3748 */
  0x0000,   /* U+3749 */
  0x0000,   /* U+374A */
  0x0000,   /* U+374B */
  0x0000,   /* U+374C */
  0x0000,   /* U+374D */
  0x0000,   /* U+374E */
  0x0000,   /* U+374F */
  0x0000,   /* U+3750 */
  0x0000,   /* U+3751 */
  0x0000,   /* U+3752 */
  0x0000,   /* U+3753 */
  0x0000,   /* U+3754 */
  0x0000,   /* U+3755 */
  0x0000,   /* U+3756 */
  0x0000,   /* U+3757 */
  0x0000,   /* U+3758 */
  0x0000,   /* U+3759 */
  0x0000,   /* U+375A */
  0x0000,   /* U+375B */
  0x0000,   /* U+375C */
  0x0000,   /* U+375D */
  0x0000,   /* U+375E */
  0x0000,   /* U+375F */
  0x0000,   /* U+3760 */
  0x0000,   /* U+3761 */
  0x0000,   /* U+3762 */
  0x0000,   /* U+3763 */
  0x0000,   /* U+3764 */
  0x0000,   /* U+3765 */
  0x0000,   /* U+3766 */
  0x0000,   /* U+3767 */
  0x0000,   /* U+3768 */
  0x0000,   /* U+3769 */
  0x0000,   /* U+376A */
  0x0000,   /* U+376B */
  0x0000,   /* U+376C */
  0x0000,   /* U+376D */
  0x0000,   /* U+376E */
  0x0000,   /* U+376F */
  0x0000,   /* U+3770 */
  0x0000,   /* U+3771 */
  0x0000,   /* U+3772 */
  0x0000,   /* U+3773 */
  0x0000,   /* U+3774 */
  0x0000,   /* U+3775 */
  0x0000,   /* U+3776 */
  0x0000,   /* U+3777 */
  0x0000,   /* U+3778 */
  0x0000,   /* U+3779 */
  0x0000,   /* U+377A */
  0x0000,   /* U+377B */
  0x0000,   /* U+377C */
  0x0000,   /* U+377D */
  0x0000,   /* U+377E */
  0x0000,   /* U+377F */
  0x0000,   /* U+3780 */
  0x0000,   /* U+3781 */
  0x0000,   /* U+3782 */
  0x0000,   /* U+3783 */
  0x0000,   /* U+3784 */
  0x0000,   /* U+3785 */
  0x0000,   /* U+3786 */
  0x0000,   /* U+3787 */
  0x0000,   /* U+3788 */
  0x0000,   /* U+3789 */
  0x0000,   /* U+378A */
  0x0000,   /* U+378B */
  0x0000,   /* U+378C */
  0x0000,   /* U+378D */
  0x0000,   /* U+378E */
  0x0000,   /* U+378F */
  0x0000,   /* U+3790 */
  0x0000,   /* U+3791 */
  0x0000,   /* U+3792 */
  0x0000,   /* U+3793 */
  0x0000,   /* U+3794 */
  0x0000,   /* U+3795 */
  0x0000,   /* U+3796 */
  0x0000,   /* U+3797 */
  0x0000,   /* U+3798 */
  0x0000,   /* U+3799 */
  0x0000,   /* U+379A */
  0x0000,   /* U+379B */
  0x0000,   /* U+379C */
  0x0000,   /* U+379D */
  0x0000,   /* U+379E */
  0x0000,   /* U+379F */
  0x0000,   /* U+37A0 */
  0x0000,   /* U+37A1 */
  0x0000,   /* U+37A2 */
  0x0000,   /* U+37A3 */
  0x0000,   /* U+37A4 */
  0x0000,   /* U+37A5 */
  0x0000,   /* U+37A6 */
  0x0000,   /* U+37A7 */
  0x0000,   /* U+37A8 */
  0x0000,   /* U+37A9 */
  0x0000,   /* U+37AA */
  0x0000,   /* U+37AB */
  0x0000,   /* U+37AC */
  0x0000,   /* U+37AD */
  0x0000,   /* U+37AE */
  0x0000,   /* U+37AF */
  0x0000,   /* U+37B0 */
  0x0000,   /* U+37B1 */
  0x0000,   /* U+37B2 */
  0x0000,   /* U+37B3 */
  0x0000,   /* U+37B4 */
  0x0000,   /* U+37B5 */
  0x0000,   /* U+37B6 */
  0x0000,   /* U+37B7 */
  0x0000,   /* U+37B8 */
  0x0000,   /* U+37B9 */
  0x0000,   /* U+37BA */
  0x0000,   /* U+37BB */
  0x0000,   /* U+37BC */
  0x0000,   /* U+37BD */
  0x0000,   /* U+37BE */
  0x0000,   /* U+37BF */
  0x0000,   /* U+37C0 */
  0x0000,   /* U+37C1 */
  0x0000,   /* U+37C2 */
  0x0000,   /* U+37C3 */
  0x0000,   /* U+37C4 */
  0x0000,   /* U+37C5 */
  0x0000,   /* U+37C6 */
  0x0000,   /* U+37C7 */
  0x0000,   /* U+37C8 */
  0x0000,   /* U+37C9 */
  0x0000,   /* U+37CA */
  0x0000,   /* U+37CB */
  0x0000,   /* U+37CC */
  0x0000,   /* U+37CD */
  0x0000,   /* U+37CE */
  0x0000,   /* U+37CF */
  0x0000,   /* U+37D0 */
  0x0000,   /* U+37D1 */
  0x0000,   /* U+37D2 */
  0x0000,   /* U+37D3 */
  0x0000,   /* U+37D4 */
  0x0000,   /* U+37D5 */
  0x0000,   /* U+37D6 */
  0x0000,   /* U+37D7 */
  0x0000,   /* U+37D8 */
  0x0000,   /* U+37D9 */
  0x0000,   /* U+37DA */
  0x0000,   /* U+37DB */
  0x0000,   /* U+37DC */
  0x0000,   /* U+37DD */
  0x0000,   /* U+37DE */
  0x0000,   /* U+37DF */
  0x0000,   /* U+37E0 */
  0x0000,   /* U+37E1 */
  0x0000,   /* U+37E2 */
  0x0000,   /* U+37E3 */
  0x0000,   /* U+37E4 */
  0x0000,   /* U+37E5 */
  0x0000,   /* U+37E6 */
  0x0000,   /* U+37E7 */
  0x0000,   /* U+37E8 */
  0x0000,   /* U+37E9 */
  0x0000,   /* U+37EA */
  0x0000,   /* U+37EB */
  0x0000,   /* U+37EC */
  0x0000,   /* U+37ED */
  0x0000,   /* U+37EE */
  0x0000,   /* U+37EF */
  0x0000,   /* U+37F0 */
  0x0000,   /* U+37F1 */
  0x0000,   /* U+37F2 */
  0x0000,   /* U+37F3 */
  0x0000,   /* U+37F4 */
  0x0000,   /* U+37F5 */
  0x0000,   /* U+37F6 */
  0x0000,   /* U+37F7 */
  0x0000,   /* U+37F8 */
  0x0000,   /* U+37F9 */
  0x0000,   /* U+37FA */
  0x0000,   /* U+37FB */
  0x0000,   /* U+37FC */
  0x0000,   /* U+37FD */
  0x0000,   /* U+37FE */
  0x0000,   /* U+37FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3700 */
  0x0000,   /* U+3701 */
  0x0000,   /* U+3702 */
  0x0000,   /* U+3703 */
  0x0000,   /* U+3704 */
  0x0000,   /* U+3705 */
  0x0000,   /* U+3706 */
  0x0000,   /* U+3707 */
  0x0000,   /* U+3708 */
  0x0000,   /* U+3709 */
  0x0000,   /* U+370A */
  0x0000,   /* U+370B */
  0x0000,   /* U+370C */
  0x0000,   /* U+370D */
  0x0000,   /* U+370E */
  0x0000,   /* U+370F */
  0x0000,   /* U+3710 */
  0x0000,   /* U+3711 */
  0x0000,   /* U+3712 */
  0x0000,   /* U+3713 */
  0x0000,   /* U+3714 */
  0x0000,   /* U+3715 */
  0x0000,   /* U+3716 */
  0x0000,   /* U+3717 */
  0x0000,   /* U+3718 */
  0x0000,   /* U+3719 */
  0x0000,   /* U+371A */
  0x0000,   /* U+371B */
  0x0000,   /* U+371C */
  0x0000,   /* U+371D */
  0x0000,   /* U+371E */
  0x0000,   /* U+371F */
  0x0000,   /* U+3720 */
  0x0000,   /* U+3721 */
  0x0000,   /* U+3722 */
  0x0000,   /* U+3723 */
  0x0000,   /* U+3724 */
  0x0000,   /* U+3725 */
  0x0000,   /* U+3726 */
  0x0000,   /* U+3727 */
  0x0000,   /* U+3728 */
  0x0000,   /* U+3729 */
  0x0000,   /* U+372A */
  0x0000,   /* U+372B */
  0x0000,   /* U+372C */
  0x0000,   /* U+372D */
  0x0000,   /* U+372E */
  0x0000,   /* U+372F */
  0x0000,   /* U+3730 */
  0x0000,   /* U+3731 */
  0x0000,   /* U+3732 */
  0x0000,   /* U+3733 */
  0x0000,   /* U+3734 */
  0x0000,   /* U+3735 */
  0x0000,   /* U+3736 */
  0x0000,   /* U+3737 */
  0x0000,   /* U+3738 */
  0x0000,   /* U+3739 */
  0x0000,   /* U+373A */
  0x0000,   /* U+373B */
  0x0000,   /* U+373C */
  0x0000,   /* U+373D */
  0x0000,   /* U+373E */
  0x0000,   /* U+373F */
  0x0000,   /* U+3740 */
  0x0000,   /* U+3741 */
  0x0000,   /* U+3742 */
  0x0000,   /* U+3743 */
  0x0000,   /* U+3744 */
  0x0000,   /* U+3745 */
  0x0000,   /* U+3746 */
  0x0000,   /* U+3747 */
  0x0000,   /* U+3748 */
  0x0000,   /* U+3749 */
  0x0000,   /* U+374A */
  0x0000,   /* U+374B */
  0x0000,   /* U+374C */
  0x0000,   /* U+374D */
  0x0000,   /* U+374E */
  0x0000,   /* U+374F */
  0x0000,   /* U+3750 */
  0x0000,   /* U+3751 */
  0x0000,   /* U+3752 */
  0x0000,   /* U+3753 */
  0x0000,   /* U+3754 */
  0x0000,   /* U+3755 */
  0x0000,   /* U+3756 */
  0x0000,   /* U+3757 */
  0x0000,   /* U+3758 */
  0x0000,   /* U+3759 */
  0x0000,   /* U+375A */
  0x0000,   /* U+375B */
  0x0000,   /* U+375C */
  0x0000,   /* U+375D */
  0x0000,   /* U+375E */
  0x0000,   /* U+375F */
  0x0000,   /* U+3760 */
  0x0000,   /* U+3761 */
  0x0000,   /* U+3762 */
  0x0000,   /* U+3763 */
  0x0000,   /* U+3764 */
  0x0000,   /* U+3765 */
  0x0000,   /* U+3766 */
  0x0000,   /* U+3767 */
  0x0000,   /* U+3768 */
  0x0000,   /* U+3769 */
  0x0000,   /* U+376A */
  0x0000,   /* U+376B */
  0x0000,   /* U+376C */
  0x0000,   /* U+376D */
  0x0000,   /* U+376E */
  0x0000,   /* U+376F */
  0x0000,   /* U+3770 */
  0x0000,   /* U+3771 */
  0x0000,   /* U+3772 */
  0x0000,   /* U+3773 */
  0x0000,   /* U+3774 */
  0x0000,   /* U+3775 */
  0x0000,   /* U+3776 */
  0x0000,   /* U+3777 */
  0x0000,   /* U+3778 */
  0x0000,   /* U+3779 */
  0x0000,   /* U+377A */
  0x0000,   /* U+377B */
  0x0000,   /* U+377C */
  0x0000,   /* U+377D */
  0x0000,   /* U+377E */
  0x0000,   /* U+377F */
  0x0000,   /* U+3780 */
  0x0000,   /* U+3781 */
  0x0000,   /* U+3782 */
  0x0000,   /* U+3783 */
  0x0000,   /* U+3784 */
  0x0000,   /* U+3785 */
  0x0000,   /* U+3786 */
  0x0000,   /* U+3787 */
  0x0000,   /* U+3788 */
  0x0000,   /* U+3789 */
  0x0000,   /* U+378A */
  0x0000,   /* U+378B */
  0x0000,   /* U+378C */
  0x0000,   /* U+378D */
  0x0000,   /* U+378E */
  0x0000,   /* U+378F */
  0x0000,   /* U+3790 */
  0x0000,   /* U+3791 */
  0x0000,   /* U+3792 */
  0x0000,   /* U+3793 */
  0x0000,   /* U+3794 */
  0x0000,   /* U+3795 */
  0x0000,   /* U+3796 */
  0x0000,   /* U+3797 */
  0x0000,   /* U+3798 */
  0x0000,   /* U+3799 */
  0x0000,   /* U+379A */
  0x0000,   /* U+379B */
  0x0000,   /* U+379C */
  0x0000,   /* U+379D */
  0x0000,   /* U+379E */
  0x0000,   /* U+379F */
  0x0000,   /* U+37A0 */
  0x0000,   /* U+37A1 */
  0x0000,   /* U+37A2 */
  0x0000,   /* U+37A3 */
  0x0000,   /* U+37A4 */
  0x0000,   /* U+37A5 */
  0x0000,   /* U+37A6 */
  0x0000,   /* U+37A7 */
  0x0000,   /* U+37A8 */
  0x0000,   /* U+37A9 */
  0x0000,   /* U+37AA */
  0x0000,   /* U+37AB */
  0x0000,   /* U+37AC */
  0x0000,   /* U+37AD */
  0x0000,   /* U+37AE */
  0x0000,   /* U+37AF */
  0x0000,   /* U+37B0 */
  0x0000,   /* U+37B1 */
  0x0000,   /* U+37B2 */
  0x0000,   /* U+37B3 */
  0x0000,   /* U+37B4 */
  0x0000,   /* U+37B5 */
  0x0000,   /* U+37B6 */
  0x0000,   /* U+37B7 */
  0x0000,   /* U+37B8 */
  0x0000,   /* U+37B9 */
  0x0000,   /* U+37BA */
  0x0000,   /* U+37BB */
  0x0000,   /* U+37BC */
  0x0000,   /* U+37BD */
  0x0000,   /* U+37BE */
  0x0000,   /* U+37BF */
  0x0000,   /* U+37C0 */
  0x0000,   /* U+37C1 */
  0x0000,   /* U+37C2 */
  0x0000,   /* U+37C3 */
  0x0000,   /* U+37C4 */
  0x0000,   /* U+37C5 */
  0x0000,   /* U+37C6 */
  0x0000,   /* U+37C7 */
  0x0000,   /* U+37C8 */
  0x0000,   /* U+37C9 */
  0x0000,   /* U+37CA */
  0x0000,   /* U+37CB */
  0x0000,   /* U+37CC */
  0x0000,   /* U+37CD */
  0x0000,   /* U+37CE */
  0x0000,   /* U+37CF */
  0x0000,   /* U+37D0 */
  0x0000,   /* U+37D1 */
  0x0000,   /* U+37D2 */
  0x0000,   /* U+37D3 */
  0x0000,   /* U+37D4 */
  0x0000,   /* U+37D5 */
  0x0000,   /* U+37D6 */
  0x0000,   /* U+37D7 */
  0x0000,   /* U+37D8 */
  0x0000,   /* U+37D9 */
  0x0000,   /* U+37DA */
  0x0000,   /* U+37DB */
  0x0000,   /* U+37DC */
  0x0000,   /* U+37DD */
  0x0000,   /* U+37DE */
  0x0000,   /* U+37DF */
  0x0000,   /* U+37E0 */
  0x0000,   /* U+37E1 */
  0x0000,   /* U+37E2 */
  0x0000,   /* U+37E3 */
  0x0000,   /* U+37E4 */
  0x0000,   /* U+37E5 */
  0x0000,   /* U+37E6 */
  0x0000,   /* U+37E7 */
  0x0000,   /* U+37E8 */
  0x0000,   /* U+37E9 */
  0x0000,   /* U+37EA */
  0x0000,   /* U+37EB */
  0x0000,   /* U+37EC */
  0x0000,   /* U+37ED */
  0x0000,   /* U+37EE */
  0x0000,   /* U+37EF */
  0x0000,   /* U+37F0 */
  0x0000,   /* U+37F1 */
  0x0000,   /* U+37F2 */
  0x0000,   /* U+37F3 */
  0x0000,   /* U+37F4 */
  0x0000,   /* U+37F5 */
  0x0000,   /* U+37F6 */
  0x0000,   /* U+37F7 */
  0x0000,   /* U+37F8 */
  0x0000,   /* U+37F9 */
  0x0000,   /* U+37FA */
  0x0000,   /* U+37FB */
  0x0000,   /* U+37FC */
  0x0000,   /* U+37FD */
  0x0000,   /* U+37FE */
  0x0000,   /* U+37FF */
};

uint16 zh2_han_p038[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x27D7,   /* U+3800 */
  0x27D7,   /* U+3801 */
  0x27D7,   /* U+3802 */
  0x5C49,   /* U+3803 */
  0x27D7,   /* U+3804 */
  0x27D8,   /* U+3805 */
  0x27D8,   /* U+3806 */
  0x27D8,   /* U+3807 */
  0x27D8,   /* U+3808 */
  0x27D8,   /* U+3809 */
  0x27D8,   /* U+380A */
  0x27D8,   /* U+380B */
  0x27D8,   /* U+380C */
  0x27D8,   /* U+380D */
  0x27D8,   /* U+380E */
  0x27D8,   /* U+380F */
  0x27D8,   /* U+3810 */
  0x27D9,   /* U+3811 */
  0x27D9,   /* U+3812 */
  0x27D9,   /* U+3813 */
  0x27D9,   /* U+3814 */
  0x27D9,   /* U+3815 */
  0x27D9,   /* U+3816 */
  0x27D9,   /* U+3817 */
  0x5C49,   /* U+3818 */
  0x27DA,   /* U+3819 */
  0x27DA,   /* U+381A */
  0x27DA,   /* U+381B */
  0x27DA,   /* U+381C */
  0x27DB,   /* U+381D */
  0x5C49,   /* U+381E */
  0x27DB,   /* U+381F */
  0x27DC,   /* U+3820 */
  0x27DC,   /* U+3821 */
  0x27DC,   /* U+3822 */
  0x27DC,   /* U+3823 */
  0x27DD,   /* U+3824 */
  0x27DE,   /* U+3825 */
  0x27DE,   /* U+3826 */
  0x27DF,   /* U+3827 */
  0x27E5,   /* U+3828 */
  0x280F,   /* U+3829 */
  0x284D,   /* U+382A */
  0x5C49,   /* U+382B */
  0x5C49,   /* U+382C */
  0x2855,   /* U+382D */
  0x2858,   /* U+382E */
  0x288E,   /* U+382F */
  0x5C49,   /* U+3830 */
  0x2894,   /* U+3831 */
  0x28CE,   /* U+3832 */
  0x5C49,   /* U+3833 */
  0x28CF,   /* U+3834 */
  0x28CF,   /* U+3835 */
  0x28CF,   /* U+3836 */
  0x28D0,   /* U+3837 */
  0x28D0,   /* U+3838 */
  0x28D0,   /* U+3839 */
  0x28D0,   /* U+383A */
  0x28D0,   /* U+383B */
  0x28D0,   /* U+383C */
  0x28D1,   /* U+383D */
  0x28D1,   /* U+383E */
  0x28D1,   /* U+383F */
  0x28D1,   /* U+3840 */
  0x28D2,   /* U+3841 */
  0x28D2,   /* U+3842 */
  0x28D2,   /* U+3843 */
  0x28D2,   /* U+3844 */
  0x28D2,   /* U+3845 */
  0x28D2,   /* U+3846 */
  0x28D3,   /* U+3847 */
  0x28D3,   /* U+3848 */
  0x28D4,   /* U+3849 */
  0x28D4,   /* U+384A */
  0x28D4,   /* U+384B */
  0x28D4,   /* U+384C */
  0x28D4,   /* U+384D */
  0x5C49,   /* U+384E */
  0x28D5,   /* U+384F */
  0x28D5,   /* U+3850 */
  0x28D5,   /* U+3851 */
  0x28D5,   /* U+3852 */
  0x28D5,   /* U+3853 */
  0x28D5,   /* U+3854 */
  0x28D5,   /* U+3855 */
  0x28D5,   /* U+3856 */
  0x28CD,   /* U+3857 */
  0x28CD,   /* U+3858 */
  0x28CD,   /* U+3859 */
  0x28CD,   /* U+385A */
  0x28CD,   /* U+385B */
  0x28D7,   /* U+385C */
  0x28D7,   /* U+385D */
  0x28D7,   /* U+385E */
  0x28D7,   /* U+385F */
  0x28D8,   /* U+3860 */
  0x28D8,   /* U+3861 */
  0x28D9,   /* U+3862 */
  0x28D9,   /* U+3863 */
  0x5C49,   /* U+3864 */
  0x28DA,   /* U+3865 */
  0x28DA,   /* U+3866 */
  0x28DD,   /* U+3867 */
  0x28DD,   /* U+3868 */
  0x28DF,   /* U+3869 */
  0x28DF,   /* U+386A */
  0x2955,   /* U+386B */
  0x5C49,   /* U+386C */
  0x2957,   /* U+386D */
  0x2959,   /* U+386E */
  0x298F,   /* U+386F */
  0x298F,   /* U+3870 */
  0x298F,   /* U+3871 */
  0x2990,   /* U+3872 */
  0x2990,   /* U+3873 */
  0x2991,   /* U+3874 */
  0x2991,   /* U+3875 */
  0x2991,   /* U+3876 */
  0x2991,   /* U+3877 */
  0x2991,   /* U+3878 */
  0x2991,   /* U+3879 */
  0x2991,   /* U+387A */
  0x2991,   /* U+387B */
  0x2992,   /* U+387C */
  0x2992,   /* U+387D */
  0x2992,   /* U+387E */
  0x2992,   /* U+387F */
  0x2992,   /* U+3880 */
  0x2992,   /* U+3881 */
  0x2992,   /* U+3882 */
  0x2993,   /* U+3883 */
  0x2993,   /* U+3884 */
  0x2993,   /* U+3885 */
  0x2993,   /* U+3886 */
  0x5C49,   /* U+3887 */
  0x2994,   /* U+3888 */
  0x2994,   /* U+3889 */
  0x2994,   /* U+388A */
  0x2994,   /* U+388B */
  0x5C49,   /* U+388C */
  0x2995,   /* U+388D */
  0x2995,   /* U+388E */
  0x2995,   /* U+388F */
  0x5C49,   /* U+3890 */
  0x298D,   /* U+3891 */
  0x2997,   /* U+3892 */
  0x2997,   /* U+3893 */
  0x2997,   /* U+3894 */
  0x2997,   /* U+3895 */
  0x2998,   /* U+3896 */
  0x2998,   /* U+3897 */
  0x2998,   /* U+3898 */
  0x2999,   /* U+3899 */
  0x2999,   /* U+389A */
  0x2999,   /* U+389B */
  0x2999,   /* U+389C */
  0x299C,   /* U+389D */
  0x299D,   /* U+389E */
  0x29CF,   /* U+389F */
  0x29D1,   /* U+38A0 */
  0x2A17,   /* U+38A1 */
  0x5C49,   /* U+38A2 */
  0x2A19,   /* U+38A3 */
  0x5C49,   /* U+38A4 */
  0x2A52,   /* U+38A5 */
  0x2A4D,   /* U+38A6 */
  0x2A8D,   /* U+38A7 */
  0x2A8F,   /* U+38A8 */
  0x2A8F,   /* U+38A9 */
  0x2A8F,   /* U+38AA */
  0x2A8F,   /* U+38AB */
  0x2A90,   /* U+38AC */
  0x2A90,   /* U+38AD */
  0x2A91,   /* U+38AE */
  0x2A91,   /* U+38AF */
  0x2A91,   /* U+38B0 */
  0x5C49,   /* U+38B1 */
  0x2A92,   /* U+38B2 */
  0x2A92,   /* U+38B3 */
  0x2A92,   /* U+38B4 */
  0x2A92,   /* U+38B5 */
  0x2A92,   /* U+38B6 */
  0x2A92,   /* U+38B7 */
  0x2A93,   /* U+38B8 */
  0x5C49,   /* U+38B9 */
  0x2A94,   /* U+38BA */
  0x2A94,   /* U+38BB */
  0x2A94,   /* U+38BC */
  0x2A95,   /* U+38BD */
  0x2A95,   /* U+38BE */
  0x5C49,   /* U+38BF */
  0x2A8D,   /* U+38C0 */
  0x2A8D,   /* U+38C1 */
  0x2A8D,   /* U+38C2 */
  0x2A97,   /* U+38C3 */
  0x2A98,   /* U+38C4 */
  0x2A98,   /* U+38C5 */
  0x2A9E,   /* U+38C6 */
  0x2AD1,   /* U+38C7 */
  0x2AD9,   /* U+38C8 */
  0x2B0F,   /* U+38C9 */
  0x5C49,   /* U+38CA */
  0x2B11,   /* U+38CB */
  0x2B11,   /* U+38CC */
  0x2B11,   /* U+38CD */
  0x2B14,   /* U+38CE */
  0x2B15,   /* U+38CF */
  0x2B15,   /* U+38D0 */
  0x2B17,   /* U+38D1 */
  0x2B18,   /* U+38D2 */
  0x2B19,   /* U+38D3 */
  0x2B4E,   /* U+38D4 */
  0x5C49,   /* U+38D5 */
  0x5C49,   /* U+38D6 */
  0x5C49,   /* U+38D7 */
  0x2B51,   /* U+38D8 */
  0x2B51,   /* U+38D9 */
  0x2B52,   /* U+38DA */
  0x2B52,   /* U+38DB */
  0x2B52,   /* U+38DC */
  0x2B52,   /* U+38DD */
  0x2B52,   /* U+38DE */
  0x2B52,   /* U+38DF */
  0x2B52,   /* U+38E0 */
  0x5C49,   /* U+38E1 */
  0x2B53,   /* U+38E2 */
  0x2B53,   /* U+38E3 */
  0x2B54,   /* U+38E4 */
  0x2B54,   /* U+38E5 */
  0x2B54,   /* U+38E6 */
  0x2B54,   /* U+38E7 */
  0x5C49,   /* U+38E8 */
  0x5C49,   /* U+38E9 */
  0x2B55,   /* U+38EA */
  0x2B55,   /* U+38EB */
  0x2B55,   /* U+38EC */
  0x2B55,   /* U+38ED */
  0x5C49,   /* U+38EE */
  0x2B4D,   /* U+38EF */
  0x2B57,   /* U+38F0 */
  0x2B57,   /* U+38F1 */
  0x2B57,   /* U+38F2 */
  0x5C49,   /* U+38F3 */
  0x5C49,   /* U+38F4 */
  0x2B59,   /* U+38F5 */
  0x2B59,   /* U+38F6 */
  0x2B5A,   /* U+38F7 */
  0x5C49,   /* U+38F8 */
  0x5C49,   /* U+38F9 */
  0x5C49,   /* U+38FA */
  0x2B8E,   /* U+38FB */
  0x2B8F,   /* U+38FC */
  0x2B8F,   /* U+38FD */
  0x2B8F,   /* U+38FE */
  0x2B8F,   /* U+38FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3800 */
  0x0020,   /* U+3801 */
  0x0020,   /* U+3802 */
  0x0020,   /* U+3803 */
  0x0020,   /* U+3804 */
  0x0020,   /* U+3805 */
  0x0020,   /* U+3806 */
  0x0020,   /* U+3807 */
  0x0020,   /* U+3808 */
  0x0020,   /* U+3809 */
  0x0020,   /* U+380A */
  0x0020,   /* U+380B */
  0x0020,   /* U+380C */
  0x0020,   /* U+380D */
  0x0020,   /* U+380E */
  0x0020,   /* U+380F */
  0x0020,   /* U+3810 */
  0x0020,   /* U+3811 */
  0x0020,   /* U+3812 */
  0x0020,   /* U+3813 */
  0x0020,   /* U+3814 */
  0x0020,   /* U+3815 */
  0x0020,   /* U+3816 */
  0x0020,   /* U+3817 */
  0x0020,   /* U+3818 */
  0x0020,   /* U+3819 */
  0x0020,   /* U+381A */
  0x0020,   /* U+381B */
  0x0020,   /* U+381C */
  0x0020,   /* U+381D */
  0x0020,   /* U+381E */
  0x0020,   /* U+381F */
  0x0020,   /* U+3820 */
  0x0020,   /* U+3821 */
  0x0020,   /* U+3822 */
  0x0020,   /* U+3823 */
  0x0020,   /* U+3824 */
  0x0020,   /* U+3825 */
  0x0020,   /* U+3826 */
  0x0020,   /* U+3827 */
  0x0020,   /* U+3828 */
  0x0020,   /* U+3829 */
  0x0020,   /* U+382A */
  0x0020,   /* U+382B */
  0x0020,   /* U+382C */
  0x0020,   /* U+382D */
  0x0020,   /* U+382E */
  0x0020,   /* U+382F */
  0x0020,   /* U+3830 */
  0x0020,   /* U+3831 */
  0x0020,   /* U+3832 */
  0x0020,   /* U+3833 */
  0x0020,   /* U+3834 */
  0x0020,   /* U+3835 */
  0x0020,   /* U+3836 */
  0x0020,   /* U+3837 */
  0x0020,   /* U+3838 */
  0x0020,   /* U+3839 */
  0x0020,   /* U+383A */
  0x0020,   /* U+383B */
  0x0020,   /* U+383C */
  0x0020,   /* U+383D */
  0x0020,   /* U+383E */
  0x0020,   /* U+383F */
  0x0020,   /* U+3840 */
  0x0020,   /* U+3841 */
  0x0020,   /* U+3842 */
  0x0020,   /* U+3843 */
  0x0020,   /* U+3844 */
  0x0020,   /* U+3845 */
  0x0020,   /* U+3846 */
  0x0020,   /* U+3847 */
  0x0020,   /* U+3848 */
  0x0020,   /* U+3849 */
  0x0020,   /* U+384A */
  0x0020,   /* U+384B */
  0x0020,   /* U+384C */
  0x0020,   /* U+384D */
  0x0020,   /* U+384E */
  0x0020,   /* U+384F */
  0x0020,   /* U+3850 */
  0x0020,   /* U+3851 */
  0x0020,   /* U+3852 */
  0x0020,   /* U+3853 */
  0x0020,   /* U+3854 */
  0x0020,   /* U+3855 */
  0x0020,   /* U+3856 */
  0x0020,   /* U+3857 */
  0x0020,   /* U+3858 */
  0x0020,   /* U+3859 */
  0x0020,   /* U+385A */
  0x0020,   /* U+385B */
  0x0020,   /* U+385C */
  0x0020,   /* U+385D */
  0x0020,   /* U+385E */
  0x0020,   /* U+385F */
  0x0020,   /* U+3860 */
  0x0020,   /* U+3861 */
  0x0020,   /* U+3862 */
  0x0020,   /* U+3863 */
  0x0020,   /* U+3864 */
  0x0020,   /* U+3865 */
  0x0020,   /* U+3866 */
  0x0020,   /* U+3867 */
  0x0020,   /* U+3868 */
  0x0020,   /* U+3869 */
  0x0020,   /* U+386A */
  0x0020,   /* U+386B */
  0x0020,   /* U+386C */
  0x0020,   /* U+386D */
  0x0020,   /* U+386E */
  0x0020,   /* U+386F */
  0x0020,   /* U+3870 */
  0x0020,   /* U+3871 */
  0x0020,   /* U+3872 */
  0x0020,   /* U+3873 */
  0x0020,   /* U+3874 */
  0x0020,   /* U+3875 */
  0x0020,   /* U+3876 */
  0x0020,   /* U+3877 */
  0x0020,   /* U+3878 */
  0x0020,   /* U+3879 */
  0x0020,   /* U+387A */
  0x0020,   /* U+387B */
  0x0020,   /* U+387C */
  0x0020,   /* U+387D */
  0x0020,   /* U+387E */
  0x0020,   /* U+387F */
  0x0020,   /* U+3880 */
  0x0020,   /* U+3881 */
  0x0020,   /* U+3882 */
  0x0020,   /* U+3883 */
  0x0020,   /* U+3884 */
  0x0020,   /* U+3885 */
  0x0020,   /* U+3886 */
  0x0020,   /* U+3887 */
  0x0020,   /* U+3888 */
  0x0020,   /* U+3889 */
  0x0020,   /* U+388A */
  0x0020,   /* U+388B */
  0x0020,   /* U+388C */
  0x0020,   /* U+388D */
  0x0020,   /* U+388E */
  0x0020,   /* U+388F */
  0x0020,   /* U+3890 */
  0x0020,   /* U+3891 */
  0x0020,   /* U+3892 */
  0x0020,   /* U+3893 */
  0x0020,   /* U+3894 */
  0x0020,   /* U+3895 */
  0x0020,   /* U+3896 */
  0x0020,   /* U+3897 */
  0x0020,   /* U+3898 */
  0x0020,   /* U+3899 */
  0x0020,   /* U+389A */
  0x0020,   /* U+389B */
  0x0020,   /* U+389C */
  0x0020,   /* U+389D */
  0x0020,   /* U+389E */
  0x0020,   /* U+389F */
  0x0020,   /* U+38A0 */
  0x0020,   /* U+38A1 */
  0x0020,   /* U+38A2 */
  0x0020,   /* U+38A3 */
  0x0020,   /* U+38A4 */
  0x0020,   /* U+38A5 */
  0x0020,   /* U+38A6 */
  0x0020,   /* U+38A7 */
  0x0020,   /* U+38A8 */
  0x0020,   /* U+38A9 */
  0x0020,   /* U+38AA */
  0x0020,   /* U+38AB */
  0x0020,   /* U+38AC */
  0x0020,   /* U+38AD */
  0x0020,   /* U+38AE */
  0x0020,   /* U+38AF */
  0x0020,   /* U+38B0 */
  0x0020,   /* U+38B1 */
  0x0020,   /* U+38B2 */
  0x0020,   /* U+38B3 */
  0x0020,   /* U+38B4 */
  0x0020,   /* U+38B5 */
  0x0020,   /* U+38B6 */
  0x0020,   /* U+38B7 */
  0x0020,   /* U+38B8 */
  0x0020,   /* U+38B9 */
  0x0020,   /* U+38BA */
  0x0020,   /* U+38BB */
  0x0020,   /* U+38BC */
  0x0020,   /* U+38BD */
  0x0020,   /* U+38BE */
  0x0020,   /* U+38BF */
  0x0020,   /* U+38C0 */
  0x0020,   /* U+38C1 */
  0x0020,   /* U+38C2 */
  0x0020,   /* U+38C3 */
  0x0020,   /* U+38C4 */
  0x0020,   /* U+38C5 */
  0x0020,   /* U+38C6 */
  0x0020,   /* U+38C7 */
  0x0020,   /* U+38C8 */
  0x0020,   /* U+38C9 */
  0x0020,   /* U+38CA */
  0x0020,   /* U+38CB */
  0x0020,   /* U+38CC */
  0x0020,   /* U+38CD */
  0x0020,   /* U+38CE */
  0x0020,   /* U+38CF */
  0x0020,   /* U+38D0 */
  0x0020,   /* U+38D1 */
  0x0020,   /* U+38D2 */
  0x0020,   /* U+38D3 */
  0x0020,   /* U+38D4 */
  0x0020,   /* U+38D5 */
  0x0020,   /* U+38D6 */
  0x0020,   /* U+38D7 */
  0x0020,   /* U+38D8 */
  0x0020,   /* U+38D9 */
  0x0020,   /* U+38DA */
  0x0020,   /* U+38DB */
  0x0020,   /* U+38DC */
  0x0020,   /* U+38DD */
  0x0020,   /* U+38DE */
  0x0020,   /* U+38DF */
  0x0020,   /* U+38E0 */
  0x0020,   /* U+38E1 */
  0x0020,   /* U+38E2 */
  0x0020,   /* U+38E3 */
  0x0020,   /* U+38E4 */
  0x0020,   /* U+38E5 */
  0x0020,   /* U+38E6 */
  0x0020,   /* U+38E7 */
  0x0020,   /* U+38E8 */
  0x0020,   /* U+38E9 */
  0x0020,   /* U+38EA */
  0x0020,   /* U+38EB */
  0x0020,   /* U+38EC */
  0x0020,   /* U+38ED */
  0x0020,   /* U+38EE */
  0x0020,   /* U+38EF */
  0x0020,   /* U+38F0 */
  0x0020,   /* U+38F1 */
  0x0020,   /* U+38F2 */
  0x0020,   /* U+38F3 */
  0x0020,   /* U+38F4 */
  0x0020,   /* U+38F5 */
  0x0020,   /* U+38F6 */
  0x0020,   /* U+38F7 */
  0x0020,   /* U+38F8 */
  0x0020,   /* U+38F9 */
  0x0020,   /* U+38FA */
  0x0020,   /* U+38FB */
  0x0020,   /* U+38FC */
  0x0020,   /* U+38FD */
  0x0020,   /* U+38FE */
  0x0020,   /* U+38FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3800 */
  0x0002,   /* U+3801 */
  0x0002,   /* U+3802 */
  0x0002,   /* U+3803 */
  0x0002,   /* U+3804 */
  0x0002,   /* U+3805 */
  0x0002,   /* U+3806 */
  0x0002,   /* U+3807 */
  0x0002,   /* U+3808 */
  0x0002,   /* U+3809 */
  0x0002,   /* U+380A */
  0x0002,   /* U+380B */
  0x0002,   /* U+380C */
  0x0002,   /* U+380D */
  0x0002,   /* U+380E */
  0x0002,   /* U+380F */
  0x0002,   /* U+3810 */
  0x0002,   /* U+3811 */
  0x0002,   /* U+3812 */
  0x0002,   /* U+3813 */
  0x0002,   /* U+3814 */
  0x0002,   /* U+3815 */
  0x0002,   /* U+3816 */
  0x0002,   /* U+3817 */
  0x0002,   /* U+3818 */
  0x0002,   /* U+3819 */
  0x0002,   /* U+381A */
  0x0002,   /* U+381B */
  0x0002,   /* U+381C */
  0x0002,   /* U+381D */
  0x0002,   /* U+381E */
  0x0002,   /* U+381F */
  0x0002,   /* U+3820 */
  0x0002,   /* U+3821 */
  0x0002,   /* U+3822 */
  0x0002,   /* U+3823 */
  0x0002,   /* U+3824 */
  0x0002,   /* U+3825 */
  0x0002,   /* U+3826 */
  0x0002,   /* U+3827 */
  0x0002,   /* U+3828 */
  0x0002,   /* U+3829 */
  0x0002,   /* U+382A */
  0x0002,   /* U+382B */
  0x0002,   /* U+382C */
  0x0002,   /* U+382D */
  0x0002,   /* U+382E */
  0x0002,   /* U+382F */
  0x0002,   /* U+3830 */
  0x0002,   /* U+3831 */
  0x0002,   /* U+3832 */
  0x0002,   /* U+3833 */
  0x0002,   /* U+3834 */
  0x0002,   /* U+3835 */
  0x0002,   /* U+3836 */
  0x0002,   /* U+3837 */
  0x0002,   /* U+3838 */
  0x0002,   /* U+3839 */
  0x0002,   /* U+383A */
  0x0002,   /* U+383B */
  0x0002,   /* U+383C */
  0x0002,   /* U+383D */
  0x0002,   /* U+383E */
  0x0002,   /* U+383F */
  0x0002,   /* U+3840 */
  0x0002,   /* U+3841 */
  0x0002,   /* U+3842 */
  0x0002,   /* U+3843 */
  0x0002,   /* U+3844 */
  0x0002,   /* U+3845 */
  0x0002,   /* U+3846 */
  0x0002,   /* U+3847 */
  0x0002,   /* U+3848 */
  0x0002,   /* U+3849 */
  0x0002,   /* U+384A */
  0x0002,   /* U+384B */
  0x0002,   /* U+384C */
  0x0002,   /* U+384D */
  0x0002,   /* U+384E */
  0x0002,   /* U+384F */
  0x0002,   /* U+3850 */
  0x0002,   /* U+3851 */
  0x0002,   /* U+3852 */
  0x0002,   /* U+3853 */
  0x0002,   /* U+3854 */
  0x0002,   /* U+3855 */
  0x0002,   /* U+3856 */
  0x0002,   /* U+3857 */
  0x0002,   /* U+3858 */
  0x0002,   /* U+3859 */
  0x0002,   /* U+385A */
  0x0002,   /* U+385B */
  0x0002,   /* U+385C */
  0x0002,   /* U+385D */
  0x0002,   /* U+385E */
  0x0002,   /* U+385F */
  0x0002,   /* U+3860 */
  0x0002,   /* U+3861 */
  0x0002,   /* U+3862 */
  0x0002,   /* U+3863 */
  0x0002,   /* U+3864 */
  0x0002,   /* U+3865 */
  0x0002,   /* U+3866 */
  0x0002,   /* U+3867 */
  0x0002,   /* U+3868 */
  0x0002,   /* U+3869 */
  0x0002,   /* U+386A */
  0x0002,   /* U+386B */
  0x0002,   /* U+386C */
  0x0002,   /* U+386D */
  0x0002,   /* U+386E */
  0x0002,   /* U+386F */
  0x0002,   /* U+3870 */
  0x0002,   /* U+3871 */
  0x0002,   /* U+3872 */
  0x0002,   /* U+3873 */
  0x0002,   /* U+3874 */
  0x0002,   /* U+3875 */
  0x0002,   /* U+3876 */
  0x0002,   /* U+3877 */
  0x0002,   /* U+3878 */
  0x0002,   /* U+3879 */
  0x0002,   /* U+387A */
  0x0002,   /* U+387B */
  0x0002,   /* U+387C */
  0x0002,   /* U+387D */
  0x0002,   /* U+387E */
  0x0002,   /* U+387F */
  0x0002,   /* U+3880 */
  0x0002,   /* U+3881 */
  0x0002,   /* U+3882 */
  0x0002,   /* U+3883 */
  0x0002,   /* U+3884 */
  0x0002,   /* U+3885 */
  0x0002,   /* U+3886 */
  0x0002,   /* U+3887 */
  0x0002,   /* U+3888 */
  0x0002,   /* U+3889 */
  0x0002,   /* U+388A */
  0x0002,   /* U+388B */
  0x0002,   /* U+388C */
  0x0002,   /* U+388D */
  0x0002,   /* U+388E */
  0x0002,   /* U+388F */
  0x0002,   /* U+3890 */
  0x0002,   /* U+3891 */
  0x0002,   /* U+3892 */
  0x0002,   /* U+3893 */
  0x0002,   /* U+3894 */
  0x0002,   /* U+3895 */
  0x0002,   /* U+3896 */
  0x0002,   /* U+3897 */
  0x0002,   /* U+3898 */
  0x0002,   /* U+3899 */
  0x0002,   /* U+389A */
  0x0002,   /* U+389B */
  0x0002,   /* U+389C */
  0x0002,   /* U+389D */
  0x0002,   /* U+389E */
  0x0002,   /* U+389F */
  0x0002,   /* U+38A0 */
  0x0002,   /* U+38A1 */
  0x0002,   /* U+38A2 */
  0x0002,   /* U+38A3 */
  0x0002,   /* U+38A4 */
  0x0002,   /* U+38A5 */
  0x0002,   /* U+38A6 */
  0x0002,   /* U+38A7 */
  0x0002,   /* U+38A8 */
  0x0002,   /* U+38A9 */
  0x0002,   /* U+38AA */
  0x0002,   /* U+38AB */
  0x0002,   /* U+38AC */
  0x0002,   /* U+38AD */
  0x0002,   /* U+38AE */
  0x0002,   /* U+38AF */
  0x0002,   /* U+38B0 */
  0x0002,   /* U+38B1 */
  0x0002,   /* U+38B2 */
  0x0002,   /* U+38B3 */
  0x0002,   /* U+38B4 */
  0x0002,   /* U+38B5 */
  0x0002,   /* U+38B6 */
  0x0002,   /* U+38B7 */
  0x0002,   /* U+38B8 */
  0x0002,   /* U+38B9 */
  0x0002,   /* U+38BA */
  0x0002,   /* U+38BB */
  0x0002,   /* U+38BC */
  0x0002,   /* U+38BD */
  0x0002,   /* U+38BE */
  0x0002,   /* U+38BF */
  0x0002,   /* U+38C0 */
  0x0002,   /* U+38C1 */
  0x0002,   /* U+38C2 */
  0x0002,   /* U+38C3 */
  0x0002,   /* U+38C4 */
  0x0002,   /* U+38C5 */
  0x0002,   /* U+38C6 */
  0x0002,   /* U+38C7 */
  0x0002,   /* U+38C8 */
  0x0002,   /* U+38C9 */
  0x0002,   /* U+38CA */
  0x0002,   /* U+38CB */
  0x0002,   /* U+38CC */
  0x0002,   /* U+38CD */
  0x0002,   /* U+38CE */
  0x0002,   /* U+38CF */
  0x0002,   /* U+38D0 */
  0x0002,   /* U+38D1 */
  0x0002,   /* U+38D2 */
  0x0002,   /* U+38D3 */
  0x0002,   /* U+38D4 */
  0x0002,   /* U+38D5 */
  0x0002,   /* U+38D6 */
  0x0002,   /* U+38D7 */
  0x0002,   /* U+38D8 */
  0x0002,   /* U+38D9 */
  0x0002,   /* U+38DA */
  0x0002,   /* U+38DB */
  0x0002,   /* U+38DC */
  0x0002,   /* U+38DD */
  0x0002,   /* U+38DE */
  0x0002,   /* U+38DF */
  0x0002,   /* U+38E0 */
  0x0002,   /* U+38E1 */
  0x0002,   /* U+38E2 */
  0x0002,   /* U+38E3 */
  0x0002,   /* U+38E4 */
  0x0002,   /* U+38E5 */
  0x0002,   /* U+38E6 */
  0x0002,   /* U+38E7 */
  0x0002,   /* U+38E8 */
  0x0002,   /* U+38E9 */
  0x0002,   /* U+38EA */
  0x0002,   /* U+38EB */
  0x0002,   /* U+38EC */
  0x0002,   /* U+38ED */
  0x0002,   /* U+38EE */
  0x0002,   /* U+38EF */
  0x0002,   /* U+38F0 */
  0x0002,   /* U+38F1 */
  0x0002,   /* U+38F2 */
  0x0002,   /* U+38F3 */
  0x0002,   /* U+38F4 */
  0x0002,   /* U+38F5 */
  0x0002,   /* U+38F6 */
  0x0002,   /* U+38F7 */
  0x0002,   /* U+38F8 */
  0x0002,   /* U+38F9 */
  0x0002,   /* U+38FA */
  0x0002,   /* U+38FB */
  0x0002,   /* U+38FC */
  0x0002,   /* U+38FD */
  0x0002,   /* U+38FE */
  0x0002,   /* U+38FF */

  /* Primary weight 2 for each character. */
  0x8007,   /* U+3800 */
  0x8008,   /* U+3801 */
  0x8009,   /* U+3802 */
  0xB803,   /* U+3803 */
  0x800A,   /* U+3804 */
  0x8000,   /* U+3805 */
  0x8001,   /* U+3806 */
  0x8002,   /* U+3807 */
  0x8003,   /* U+3808 */
  0x8004,   /* U+3809 */
  0x8005,   /* U+380A */
  0x8006,   /* U+380B */
  0x8007,   /* U+380C */
  0x8008,   /* U+380D */
  0x8009,   /* U+380E */
  0x800A,   /* U+380F */
  0x800B,   /* U+3810 */
  0x8000,   /* U+3811 */
  0x8001,   /* U+3812 */
  0x8002,   /* U+3813 */
  0x8003,   /* U+3814 */
  0x8004,   /* U+3815 */
  0x8005,   /* U+3816 */
  0x8006,   /* U+3817 */
  0xB818,   /* U+3818 */
  0x8000,   /* U+3819 */
  0x8001,   /* U+381A */
  0x8002,   /* U+381B */
  0x8003,   /* U+381C */
  0x8000,   /* U+381D */
  0xB81E,   /* U+381E */
  0x8001,   /* U+381F */
  0x8000,   /* U+3820 */
  0x8001,   /* U+3821 */
  0x8002,   /* U+3822 */
  0x8003,   /* U+3823 */
  0x8000,   /* U+3824 */
  0x8000,   /* U+3825 */
  0x8001,   /* U+3826 */
  0x8000,   /* U+3827 */
  0x8000,   /* U+3828 */
  0x8000,   /* U+3829 */
  0x8000,   /* U+382A */
  0xB82B,   /* U+382B */
  0xB82C,   /* U+382C */
  0x8000,   /* U+382D */
  0x8000,   /* U+382E */
  0x8000,   /* U+382F */
  0xB830,   /* U+3830 */
  0x8000,   /* U+3831 */
  0x8000,   /* U+3832 */
  0xB833,   /* U+3833 */
  0x8000,   /* U+3834 */
  0x8001,   /* U+3835 */
  0x8002,   /* U+3836 */
  0x8000,   /* U+3837 */
  0x8001,   /* U+3838 */
  0x8002,   /* U+3839 */
  0x8003,   /* U+383A */
  0x8004,   /* U+383B */
  0x8005,   /* U+383C */
  0x8000,   /* U+383D */
  0x8001,   /* U+383E */
  0x8002,   /* U+383F */
  0x8003,   /* U+3840 */
  0x8000,   /* U+3841 */
  0x8001,   /* U+3842 */
  0x8002,   /* U+3843 */
  0x8003,   /* U+3844 */
  0x8004,   /* U+3845 */
  0x8005,   /* U+3846 */
  0x8000,   /* U+3847 */
  0x8001,   /* U+3848 */
  0x8000,   /* U+3849 */
  0x8001,   /* U+384A */
  0x8002,   /* U+384B */
  0x8003,   /* U+384C */
  0x8004,   /* U+384D */
  0xB84E,   /* U+384E */
  0x8000,   /* U+384F */
  0x8001,   /* U+3850 */
  0x8002,   /* U+3851 */
  0x8003,   /* U+3852 */
  0x8004,   /* U+3853 */
  0x8005,   /* U+3854 */
  0x8006,   /* U+3855 */
  0x8007,   /* U+3856 */
  0x8000,   /* U+3857 */
  0x8001,   /* U+3858 */
  0x8002,   /* U+3859 */
  0x8003,   /* U+385A */
  0x8004,   /* U+385B */
  0x8000,   /* U+385C */
  0x8001,   /* U+385D */
  0x8002,   /* U+385E */
  0x8003,   /* U+385F */
  0x8000,   /* U+3860 */
  0x8001,   /* U+3861 */
  0x8000,   /* U+3862 */
  0x8001,   /* U+3863 */
  0xB864,   /* U+3864 */
  0x8000,   /* U+3865 */
  0x8001,   /* U+3866 */
  0x8000,   /* U+3867 */
  0x8001,   /* U+3868 */
  0x8000,   /* U+3869 */
  0x8001,   /* U+386A */
  0x8000,   /* U+386B */
  0xB86C,   /* U+386C */
  0x8000,   /* U+386D */
  0x8000,   /* U+386E */
  0x8000,   /* U+386F */
  0x8001,   /* U+3870 */
  0x8002,   /* U+3871 */
  0x8000,   /* U+3872 */
  0x8001,   /* U+3873 */
  0x8000,   /* U+3874 */
  0x8001,   /* U+3875 */
  0x8002,   /* U+3876 */
  0x8003,   /* U+3877 */
  0x8004,   /* U+3878 */
  0x8005,   /* U+3879 */
  0x8006,   /* U+387A */
  0x8007,   /* U+387B */
  0x8000,   /* U+387C */
  0x8001,   /* U+387D */
  0x8002,   /* U+387E */
  0x8003,   /* U+387F */
  0x8004,   /* U+3880 */
  0x8005,   /* U+3881 */
  0x8006,   /* U+3882 */
  0x8000,   /* U+3883 */
  0x8001,   /* U+3884 */
  0x8002,   /* U+3885 */
  0x8003,   /* U+3886 */
  0xB887,   /* U+3887 */
  0x8000,   /* U+3888 */
  0x8001,   /* U+3889 */
  0x8002,   /* U+388A */
  0x8003,   /* U+388B */
  0xB88C,   /* U+388C */
  0x8000,   /* U+388D */
  0x8001,   /* U+388E */
  0x8002,   /* U+388F */
  0xB890,   /* U+3890 */
  0x8000,   /* U+3891 */
  0x8000,   /* U+3892 */
  0x8001,   /* U+3893 */
  0x8002,   /* U+3894 */
  0x8003,   /* U+3895 */
  0x8000,   /* U+3896 */
  0x8001,   /* U+3897 */
  0x8002,   /* U+3898 */
  0x8000,   /* U+3899 */
  0x8001,   /* U+389A */
  0x8002,   /* U+389B */
  0x8003,   /* U+389C */
  0x8000,   /* U+389D */
  0x8000,   /* U+389E */
  0x8000,   /* U+389F */
  0x8000,   /* U+38A0 */
  0x8000,   /* U+38A1 */
  0xB8A2,   /* U+38A2 */
  0x8000,   /* U+38A3 */
  0xB8A4,   /* U+38A4 */
  0x8000,   /* U+38A5 */
  0x8000,   /* U+38A6 */
  0x8000,   /* U+38A7 */
  0x8000,   /* U+38A8 */
  0x8001,   /* U+38A9 */
  0x8002,   /* U+38AA */
  0x8003,   /* U+38AB */
  0x8000,   /* U+38AC */
  0x8001,   /* U+38AD */
  0x8000,   /* U+38AE */
  0x8001,   /* U+38AF */
  0x8002,   /* U+38B0 */
  0xB8B1,   /* U+38B1 */
  0x8000,   /* U+38B2 */
  0x8001,   /* U+38B3 */
  0x8002,   /* U+38B4 */
  0x8003,   /* U+38B5 */
  0x8004,   /* U+38B6 */
  0x8005,   /* U+38B7 */
  0x8000,   /* U+38B8 */
  0xB8B9,   /* U+38B9 */
  0x8000,   /* U+38BA */
  0x8001,   /* U+38BB */
  0x8002,   /* U+38BC */
  0x8000,   /* U+38BD */
  0x8001,   /* U+38BE */
  0xB8BF,   /* U+38BF */
  0x8001,   /* U+38C0 */
  0x8002,   /* U+38C1 */
  0x8003,   /* U+38C2 */
  0x8000,   /* U+38C3 */
  0x8000,   /* U+38C4 */
  0x8001,   /* U+38C5 */
  0x8000,   /* U+38C6 */
  0x8000,   /* U+38C7 */
  0x8000,   /* U+38C8 */
  0x8000,   /* U+38C9 */
  0xB8CA,   /* U+38CA */
  0x8000,   /* U+38CB */
  0x8001,   /* U+38CC */
  0x8002,   /* U+38CD */
  0x8000,   /* U+38CE */
  0x8000,   /* U+38CF */
  0x8001,   /* U+38D0 */
  0x8000,   /* U+38D1 */
  0x8000,   /* U+38D2 */
  0x8000,   /* U+38D3 */
  0x8000,   /* U+38D4 */
  0xB8D5,   /* U+38D5 */
  0xB8D6,   /* U+38D6 */
  0xB8D7,   /* U+38D7 */
  0x8000,   /* U+38D8 */
  0x8001,   /* U+38D9 */
  0x8000,   /* U+38DA */
  0x8001,   /* U+38DB */
  0x8002,   /* U+38DC */
  0x8003,   /* U+38DD */
  0x8004,   /* U+38DE */
  0x8005,   /* U+38DF */
  0x8006,   /* U+38E0 */
  0xB8E1,   /* U+38E1 */
  0x8000,   /* U+38E2 */
  0x8001,   /* U+38E3 */
  0x8000,   /* U+38E4 */
  0x8001,   /* U+38E5 */
  0x8002,   /* U+38E6 */
  0x8003,   /* U+38E7 */
  0xB8E8,   /* U+38E8 */
  0xB8E9,   /* U+38E9 */
  0x8000,   /* U+38EA */
  0x8001,   /* U+38EB */
  0x8002,   /* U+38EC */
  0x8003,   /* U+38ED */
  0xB8EE,   /* U+38EE */
  0x8000,   /* U+38EF */
  0x8000,   /* U+38F0 */
  0x8001,   /* U+38F1 */
  0x8002,   /* U+38F2 */
  0xB8F3,   /* U+38F3 */
  0xB8F4,   /* U+38F4 */
  0x8000,   /* U+38F5 */
  0x8001,   /* U+38F6 */
  0x8000,   /* U+38F7 */
  0xB8F8,   /* U+38F8 */
  0xB8F9,   /* U+38F9 */
  0xB8FA,   /* U+38FA */
  0x8000,   /* U+38FB */
  0x8000,   /* U+38FC */
  0x8001,   /* U+38FD */
  0x8002,   /* U+38FE */
  0x8003,   /* U+38FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3800 */
  0x0000,   /* U+3801 */
  0x0000,   /* U+3802 */
  0x0000,   /* U+3803 */
  0x0000,   /* U+3804 */
  0x0000,   /* U+3805 */
  0x0000,   /* U+3806 */
  0x0000,   /* U+3807 */
  0x0000,   /* U+3808 */
  0x0000,   /* U+3809 */
  0x0000,   /* U+380A */
  0x0000,   /* U+380B */
  0x0000,   /* U+380C */
  0x0000,   /* U+380D */
  0x0000,   /* U+380E */
  0x0000,   /* U+380F */
  0x0000,   /* U+3810 */
  0x0000,   /* U+3811 */
  0x0000,   /* U+3812 */
  0x0000,   /* U+3813 */
  0x0000,   /* U+3814 */
  0x0000,   /* U+3815 */
  0x0000,   /* U+3816 */
  0x0000,   /* U+3817 */
  0x0000,   /* U+3818 */
  0x0000,   /* U+3819 */
  0x0000,   /* U+381A */
  0x0000,   /* U+381B */
  0x0000,   /* U+381C */
  0x0000,   /* U+381D */
  0x0000,   /* U+381E */
  0x0000,   /* U+381F */
  0x0000,   /* U+3820 */
  0x0000,   /* U+3821 */
  0x0000,   /* U+3822 */
  0x0000,   /* U+3823 */
  0x0000,   /* U+3824 */
  0x0000,   /* U+3825 */
  0x0000,   /* U+3826 */
  0x0000,   /* U+3827 */
  0x0000,   /* U+3828 */
  0x0000,   /* U+3829 */
  0x0000,   /* U+382A */
  0x0000,   /* U+382B */
  0x0000,   /* U+382C */
  0x0000,   /* U+382D */
  0x0000,   /* U+382E */
  0x0000,   /* U+382F */
  0x0000,   /* U+3830 */
  0x0000,   /* U+3831 */
  0x0000,   /* U+3832 */
  0x0000,   /* U+3833 */
  0x0000,   /* U+3834 */
  0x0000,   /* U+3835 */
  0x0000,   /* U+3836 */
  0x0000,   /* U+3837 */
  0x0000,   /* U+3838 */
  0x0000,   /* U+3839 */
  0x0000,   /* U+383A */
  0x0000,   /* U+383B */
  0x0000,   /* U+383C */
  0x0000,   /* U+383D */
  0x0000,   /* U+383E */
  0x0000,   /* U+383F */
  0x0000,   /* U+3840 */
  0x0000,   /* U+3841 */
  0x0000,   /* U+3842 */
  0x0000,   /* U+3843 */
  0x0000,   /* U+3844 */
  0x0000,   /* U+3845 */
  0x0000,   /* U+3846 */
  0x0000,   /* U+3847 */
  0x0000,   /* U+3848 */
  0x0000,   /* U+3849 */
  0x0000,   /* U+384A */
  0x0000,   /* U+384B */
  0x0000,   /* U+384C */
  0x0000,   /* U+384D */
  0x0000,   /* U+384E */
  0x0000,   /* U+384F */
  0x0000,   /* U+3850 */
  0x0000,   /* U+3851 */
  0x0000,   /* U+3852 */
  0x0000,   /* U+3853 */
  0x0000,   /* U+3854 */
  0x0000,   /* U+3855 */
  0x0000,   /* U+3856 */
  0x0000,   /* U+3857 */
  0x0000,   /* U+3858 */
  0x0000,   /* U+3859 */
  0x0000,   /* U+385A */
  0x0000,   /* U+385B */
  0x0000,   /* U+385C */
  0x0000,   /* U+385D */
  0x0000,   /* U+385E */
  0x0000,   /* U+385F */
  0x0000,   /* U+3860 */
  0x0000,   /* U+3861 */
  0x0000,   /* U+3862 */
  0x0000,   /* U+3863 */
  0x0000,   /* U+3864 */
  0x0000,   /* U+3865 */
  0x0000,   /* U+3866 */
  0x0000,   /* U+3867 */
  0x0000,   /* U+3868 */
  0x0000,   /* U+3869 */
  0x0000,   /* U+386A */
  0x0000,   /* U+386B */
  0x0000,   /* U+386C */
  0x0000,   /* U+386D */
  0x0000,   /* U+386E */
  0x0000,   /* U+386F */
  0x0000,   /* U+3870 */
  0x0000,   /* U+3871 */
  0x0000,   /* U+3872 */
  0x0000,   /* U+3873 */
  0x0000,   /* U+3874 */
  0x0000,   /* U+3875 */
  0x0000,   /* U+3876 */
  0x0000,   /* U+3877 */
  0x0000,   /* U+3878 */
  0x0000,   /* U+3879 */
  0x0000,   /* U+387A */
  0x0000,   /* U+387B */
  0x0000,   /* U+387C */
  0x0000,   /* U+387D */
  0x0000,   /* U+387E */
  0x0000,   /* U+387F */
  0x0000,   /* U+3880 */
  0x0000,   /* U+3881 */
  0x0000,   /* U+3882 */
  0x0000,   /* U+3883 */
  0x0000,   /* U+3884 */
  0x0000,   /* U+3885 */
  0x0000,   /* U+3886 */
  0x0000,   /* U+3887 */
  0x0000,   /* U+3888 */
  0x0000,   /* U+3889 */
  0x0000,   /* U+388A */
  0x0000,   /* U+388B */
  0x0000,   /* U+388C */
  0x0000,   /* U+388D */
  0x0000,   /* U+388E */
  0x0000,   /* U+388F */
  0x0000,   /* U+3890 */
  0x0000,   /* U+3891 */
  0x0000,   /* U+3892 */
  0x0000,   /* U+3893 */
  0x0000,   /* U+3894 */
  0x0000,   /* U+3895 */
  0x0000,   /* U+3896 */
  0x0000,   /* U+3897 */
  0x0000,   /* U+3898 */
  0x0000,   /* U+3899 */
  0x0000,   /* U+389A */
  0x0000,   /* U+389B */
  0x0000,   /* U+389C */
  0x0000,   /* U+389D */
  0x0000,   /* U+389E */
  0x0000,   /* U+389F */
  0x0000,   /* U+38A0 */
  0x0000,   /* U+38A1 */
  0x0000,   /* U+38A2 */
  0x0000,   /* U+38A3 */
  0x0000,   /* U+38A4 */
  0x0000,   /* U+38A5 */
  0x0000,   /* U+38A6 */
  0x0000,   /* U+38A7 */
  0x0000,   /* U+38A8 */
  0x0000,   /* U+38A9 */
  0x0000,   /* U+38AA */
  0x0000,   /* U+38AB */
  0x0000,   /* U+38AC */
  0x0000,   /* U+38AD */
  0x0000,   /* U+38AE */
  0x0000,   /* U+38AF */
  0x0000,   /* U+38B0 */
  0x0000,   /* U+38B1 */
  0x0000,   /* U+38B2 */
  0x0000,   /* U+38B3 */
  0x0000,   /* U+38B4 */
  0x0000,   /* U+38B5 */
  0x0000,   /* U+38B6 */
  0x0000,   /* U+38B7 */
  0x0000,   /* U+38B8 */
  0x0000,   /* U+38B9 */
  0x0000,   /* U+38BA */
  0x0000,   /* U+38BB */
  0x0000,   /* U+38BC */
  0x0000,   /* U+38BD */
  0x0000,   /* U+38BE */
  0x0000,   /* U+38BF */
  0x0000,   /* U+38C0 */
  0x0000,   /* U+38C1 */
  0x0000,   /* U+38C2 */
  0x0000,   /* U+38C3 */
  0x0000,   /* U+38C4 */
  0x0000,   /* U+38C5 */
  0x0000,   /* U+38C6 */
  0x0000,   /* U+38C7 */
  0x0000,   /* U+38C8 */
  0x0000,   /* U+38C9 */
  0x0000,   /* U+38CA */
  0x0000,   /* U+38CB */
  0x0000,   /* U+38CC */
  0x0000,   /* U+38CD */
  0x0000,   /* U+38CE */
  0x0000,   /* U+38CF */
  0x0000,   /* U+38D0 */
  0x0000,   /* U+38D1 */
  0x0000,   /* U+38D2 */
  0x0000,   /* U+38D3 */
  0x0000,   /* U+38D4 */
  0x0000,   /* U+38D5 */
  0x0000,   /* U+38D6 */
  0x0000,   /* U+38D7 */
  0x0000,   /* U+38D8 */
  0x0000,   /* U+38D9 */
  0x0000,   /* U+38DA */
  0x0000,   /* U+38DB */
  0x0000,   /* U+38DC */
  0x0000,   /* U+38DD */
  0x0000,   /* U+38DE */
  0x0000,   /* U+38DF */
  0x0000,   /* U+38E0 */
  0x0000,   /* U+38E1 */
  0x0000,   /* U+38E2 */
  0x0000,   /* U+38E3 */
  0x0000,   /* U+38E4 */
  0x0000,   /* U+38E5 */
  0x0000,   /* U+38E6 */
  0x0000,   /* U+38E7 */
  0x0000,   /* U+38E8 */
  0x0000,   /* U+38E9 */
  0x0000,   /* U+38EA */
  0x0000,   /* U+38EB */
  0x0000,   /* U+38EC */
  0x0000,   /* U+38ED */
  0x0000,   /* U+38EE */
  0x0000,   /* U+38EF */
  0x0000,   /* U+38F0 */
  0x0000,   /* U+38F1 */
  0x0000,   /* U+38F2 */
  0x0000,   /* U+38F3 */
  0x0000,   /* U+38F4 */
  0x0000,   /* U+38F5 */
  0x0000,   /* U+38F6 */
  0x0000,   /* U+38F7 */
  0x0000,   /* U+38F8 */
  0x0000,   /* U+38F9 */
  0x0000,   /* U+38FA */
  0x0000,   /* U+38FB */
  0x0000,   /* U+38FC */
  0x0000,   /* U+38FD */
  0x0000,   /* U+38FE */
  0x0000,   /* U+38FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3800 */
  0x0000,   /* U+3801 */
  0x0000,   /* U+3802 */
  0x0000,   /* U+3803 */
  0x0000,   /* U+3804 */
  0x0000,   /* U+3805 */
  0x0000,   /* U+3806 */
  0x0000,   /* U+3807 */
  0x0000,   /* U+3808 */
  0x0000,   /* U+3809 */
  0x0000,   /* U+380A */
  0x0000,   /* U+380B */
  0x0000,   /* U+380C */
  0x0000,   /* U+380D */
  0x0000,   /* U+380E */
  0x0000,   /* U+380F */
  0x0000,   /* U+3810 */
  0x0000,   /* U+3811 */
  0x0000,   /* U+3812 */
  0x0000,   /* U+3813 */
  0x0000,   /* U+3814 */
  0x0000,   /* U+3815 */
  0x0000,   /* U+3816 */
  0x0000,   /* U+3817 */
  0x0000,   /* U+3818 */
  0x0000,   /* U+3819 */
  0x0000,   /* U+381A */
  0x0000,   /* U+381B */
  0x0000,   /* U+381C */
  0x0000,   /* U+381D */
  0x0000,   /* U+381E */
  0x0000,   /* U+381F */
  0x0000,   /* U+3820 */
  0x0000,   /* U+3821 */
  0x0000,   /* U+3822 */
  0x0000,   /* U+3823 */
  0x0000,   /* U+3824 */
  0x0000,   /* U+3825 */
  0x0000,   /* U+3826 */
  0x0000,   /* U+3827 */
  0x0000,   /* U+3828 */
  0x0000,   /* U+3829 */
  0x0000,   /* U+382A */
  0x0000,   /* U+382B */
  0x0000,   /* U+382C */
  0x0000,   /* U+382D */
  0x0000,   /* U+382E */
  0x0000,   /* U+382F */
  0x0000,   /* U+3830 */
  0x0000,   /* U+3831 */
  0x0000,   /* U+3832 */
  0x0000,   /* U+3833 */
  0x0000,   /* U+3834 */
  0x0000,   /* U+3835 */
  0x0000,   /* U+3836 */
  0x0000,   /* U+3837 */
  0x0000,   /* U+3838 */
  0x0000,   /* U+3839 */
  0x0000,   /* U+383A */
  0x0000,   /* U+383B */
  0x0000,   /* U+383C */
  0x0000,   /* U+383D */
  0x0000,   /* U+383E */
  0x0000,   /* U+383F */
  0x0000,   /* U+3840 */
  0x0000,   /* U+3841 */
  0x0000,   /* U+3842 */
  0x0000,   /* U+3843 */
  0x0000,   /* U+3844 */
  0x0000,   /* U+3845 */
  0x0000,   /* U+3846 */
  0x0000,   /* U+3847 */
  0x0000,   /* U+3848 */
  0x0000,   /* U+3849 */
  0x0000,   /* U+384A */
  0x0000,   /* U+384B */
  0x0000,   /* U+384C */
  0x0000,   /* U+384D */
  0x0000,   /* U+384E */
  0x0000,   /* U+384F */
  0x0000,   /* U+3850 */
  0x0000,   /* U+3851 */
  0x0000,   /* U+3852 */
  0x0000,   /* U+3853 */
  0x0000,   /* U+3854 */
  0x0000,   /* U+3855 */
  0x0000,   /* U+3856 */
  0x0000,   /* U+3857 */
  0x0000,   /* U+3858 */
  0x0000,   /* U+3859 */
  0x0000,   /* U+385A */
  0x0000,   /* U+385B */
  0x0000,   /* U+385C */
  0x0000,   /* U+385D */
  0x0000,   /* U+385E */
  0x0000,   /* U+385F */
  0x0000,   /* U+3860 */
  0x0000,   /* U+3861 */
  0x0000,   /* U+3862 */
  0x0000,   /* U+3863 */
  0x0000,   /* U+3864 */
  0x0000,   /* U+3865 */
  0x0000,   /* U+3866 */
  0x0000,   /* U+3867 */
  0x0000,   /* U+3868 */
  0x0000,   /* U+3869 */
  0x0000,   /* U+386A */
  0x0000,   /* U+386B */
  0x0000,   /* U+386C */
  0x0000,   /* U+386D */
  0x0000,   /* U+386E */
  0x0000,   /* U+386F */
  0x0000,   /* U+3870 */
  0x0000,   /* U+3871 */
  0x0000,   /* U+3872 */
  0x0000,   /* U+3873 */
  0x0000,   /* U+3874 */
  0x0000,   /* U+3875 */
  0x0000,   /* U+3876 */
  0x0000,   /* U+3877 */
  0x0000,   /* U+3878 */
  0x0000,   /* U+3879 */
  0x0000,   /* U+387A */
  0x0000,   /* U+387B */
  0x0000,   /* U+387C */
  0x0000,   /* U+387D */
  0x0000,   /* U+387E */
  0x0000,   /* U+387F */
  0x0000,   /* U+3880 */
  0x0000,   /* U+3881 */
  0x0000,   /* U+3882 */
  0x0000,   /* U+3883 */
  0x0000,   /* U+3884 */
  0x0000,   /* U+3885 */
  0x0000,   /* U+3886 */
  0x0000,   /* U+3887 */
  0x0000,   /* U+3888 */
  0x0000,   /* U+3889 */
  0x0000,   /* U+388A */
  0x0000,   /* U+388B */
  0x0000,   /* U+388C */
  0x0000,   /* U+388D */
  0x0000,   /* U+388E */
  0x0000,   /* U+388F */
  0x0000,   /* U+3890 */
  0x0000,   /* U+3891 */
  0x0000,   /* U+3892 */
  0x0000,   /* U+3893 */
  0x0000,   /* U+3894 */
  0x0000,   /* U+3895 */
  0x0000,   /* U+3896 */
  0x0000,   /* U+3897 */
  0x0000,   /* U+3898 */
  0x0000,   /* U+3899 */
  0x0000,   /* U+389A */
  0x0000,   /* U+389B */
  0x0000,   /* U+389C */
  0x0000,   /* U+389D */
  0x0000,   /* U+389E */
  0x0000,   /* U+389F */
  0x0000,   /* U+38A0 */
  0x0000,   /* U+38A1 */
  0x0000,   /* U+38A2 */
  0x0000,   /* U+38A3 */
  0x0000,   /* U+38A4 */
  0x0000,   /* U+38A5 */
  0x0000,   /* U+38A6 */
  0x0000,   /* U+38A7 */
  0x0000,   /* U+38A8 */
  0x0000,   /* U+38A9 */
  0x0000,   /* U+38AA */
  0x0000,   /* U+38AB */
  0x0000,   /* U+38AC */
  0x0000,   /* U+38AD */
  0x0000,   /* U+38AE */
  0x0000,   /* U+38AF */
  0x0000,   /* U+38B0 */
  0x0000,   /* U+38B1 */
  0x0000,   /* U+38B2 */
  0x0000,   /* U+38B3 */
  0x0000,   /* U+38B4 */
  0x0000,   /* U+38B5 */
  0x0000,   /* U+38B6 */
  0x0000,   /* U+38B7 */
  0x0000,   /* U+38B8 */
  0x0000,   /* U+38B9 */
  0x0000,   /* U+38BA */
  0x0000,   /* U+38BB */
  0x0000,   /* U+38BC */
  0x0000,   /* U+38BD */
  0x0000,   /* U+38BE */
  0x0000,   /* U+38BF */
  0x0000,   /* U+38C0 */
  0x0000,   /* U+38C1 */
  0x0000,   /* U+38C2 */
  0x0000,   /* U+38C3 */
  0x0000,   /* U+38C4 */
  0x0000,   /* U+38C5 */
  0x0000,   /* U+38C6 */
  0x0000,   /* U+38C7 */
  0x0000,   /* U+38C8 */
  0x0000,   /* U+38C9 */
  0x0000,   /* U+38CA */
  0x0000,   /* U+38CB */
  0x0000,   /* U+38CC */
  0x0000,   /* U+38CD */
  0x0000,   /* U+38CE */
  0x0000,   /* U+38CF */
  0x0000,   /* U+38D0 */
  0x0000,   /* U+38D1 */
  0x0000,   /* U+38D2 */
  0x0000,   /* U+38D3 */
  0x0000,   /* U+38D4 */
  0x0000,   /* U+38D5 */
  0x0000,   /* U+38D6 */
  0x0000,   /* U+38D7 */
  0x0000,   /* U+38D8 */
  0x0000,   /* U+38D9 */
  0x0000,   /* U+38DA */
  0x0000,   /* U+38DB */
  0x0000,   /* U+38DC */
  0x0000,   /* U+38DD */
  0x0000,   /* U+38DE */
  0x0000,   /* U+38DF */
  0x0000,   /* U+38E0 */
  0x0000,   /* U+38E1 */
  0x0000,   /* U+38E2 */
  0x0000,   /* U+38E3 */
  0x0000,   /* U+38E4 */
  0x0000,   /* U+38E5 */
  0x0000,   /* U+38E6 */
  0x0000,   /* U+38E7 */
  0x0000,   /* U+38E8 */
  0x0000,   /* U+38E9 */
  0x0000,   /* U+38EA */
  0x0000,   /* U+38EB */
  0x0000,   /* U+38EC */
  0x0000,   /* U+38ED */
  0x0000,   /* U+38EE */
  0x0000,   /* U+38EF */
  0x0000,   /* U+38F0 */
  0x0000,   /* U+38F1 */
  0x0000,   /* U+38F2 */
  0x0000,   /* U+38F3 */
  0x0000,   /* U+38F4 */
  0x0000,   /* U+38F5 */
  0x0000,   /* U+38F6 */
  0x0000,   /* U+38F7 */
  0x0000,   /* U+38F8 */
  0x0000,   /* U+38F9 */
  0x0000,   /* U+38FA */
  0x0000,   /* U+38FB */
  0x0000,   /* U+38FC */
  0x0000,   /* U+38FD */
  0x0000,   /* U+38FE */
  0x0000,   /* U+38FF */
};

uint16 zh2_han_p039[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x5C49,   /* U+3900 */
  0x2B90,   /* U+3901 */
  0x2B90,   /* U+3902 */
  0x2B90,   /* U+3903 */
  0x2B90,   /* U+3904 */
  0x2B90,   /* U+3905 */
  0x2B90,   /* U+3906 */
  0x2B90,   /* U+3907 */
  0x2B90,   /* U+3908 */
  0x2B90,   /* U+3909 */
  0x2B90,   /* U+390A */
  0x2B90,   /* U+390B */
  0x2B91,   /* U+390C */
  0x2B91,   /* U+390D */
  0x2B91,   /* U+390E */
  0x2B91,   /* U+390F */
  0x2B91,   /* U+3910 */
  0x2B91,   /* U+3911 */
  0x2B91,   /* U+3912 */
  0x2B91,   /* U+3913 */
  0x2B91,   /* U+3914 */
  0x2B91,   /* U+3915 */
  0x2B91,   /* U+3916 */
  0x2B91,   /* U+3917 */
  0x2B91,   /* U+3918 */
  0x2B91,   /* U+3919 */
  0x2B92,   /* U+391A */
  0x2B92,   /* U+391B */
  0x2B92,   /* U+391C */
  0x2B92,   /* U+391D */
  0x2B92,   /* U+391E */
  0x2B92,   /* U+391F */
  0x2B92,   /* U+3920 */
  0x2B92,   /* U+3921 */
  0x2B92,   /* U+3922 */
  0x2B92,   /* U+3923 */
  0x2B92,   /* U+3924 */
  0x2B92,   /* U+3925 */
  0x2B92,   /* U+3926 */
  0x2B92,   /* U+3927 */
  0x2B92,   /* U+3928 */
  0x2B92,   /* U+3929 */
  0x2B92,   /* U+392A */
  0x2B92,   /* U+392B */
  0x2B92,   /* U+392C */
  0x2B92,   /* U+392D */
  0x2B93,   /* U+392E */
  0x2B93,   /* U+392F */
  0x2B93,   /* U+3930 */
  0x2B93,   /* U+3931 */
  0x2B93,   /* U+3932 */
  0x2B93,   /* U+3933 */
  0x2B93,   /* U+3934 */
  0x2B93,   /* U+3935 */
  0x2B93,   /* U+3936 */
  0x2B93,   /* U+3937 */
  0x2B93,   /* U+3938 */
  0x2B93,   /* U+3939 */
  0x2B92,   /* U+393A */
  0x2B93,   /* U+393B */
  0x5C49,   /* U+393C */
  0x2B93,   /* U+393D */
  0x2B94,   /* U+393E */
  0x2B94,   /* U+393F */
  0x2B94,   /* U+3940 */
  0x2B94,   /* U+3941 */
  0x2B94,   /* U+3942 */
  0x2B94,   /* U+3943 */
  0x2B94,   /* U+3944 */
  0x2B94,   /* U+3945 */
  0x2B94,   /* U+3946 */
  0x2B94,   /* U+3947 */
  0x2B94,   /* U+3948 */
  0x2B94,   /* U+3949 */
  0x2B94,   /* U+394A */
  0x2B94,   /* U+394B */
  0x2B94,   /* U+394C */
  0x2B94,   /* U+394D */
  0x2B94,   /* U+394E */
  0x2B94,   /* U+394F */
  0x2B94,   /* U+3950 */
  0x2B94,   /* U+3951 */
  0x2B94,   /* U+3952 */
  0x2B94,   /* U+3953 */
  0x2B94,   /* U+3954 */
  0x2B94,   /* U+3955 */
  0x2B94,   /* U+3956 */
  0x2B94,   /* U+3957 */
  0x5C49,   /* U+3958 */
  0x5C49,   /* U+3959 */
  0x2B95,   /* U+395A */
  0x2B95,   /* U+395B */
  0x2B95,   /* U+395C */
  0x2B95,   /* U+395D */
  0x2B95,   /* U+395E */
  0x2B95,   /* U+395F */
  0x2B95,   /* U+3960 */
  0x2B95,   /* U+3961 */
  0x2B95,   /* U+3962 */
  0x2B95,   /* U+3963 */
  0x2B95,   /* U+3964 */
  0x2B95,   /* U+3965 */
  0x2B95,   /* U+3966 */
  0x2B95,   /* U+3967 */
  0x2B95,   /* U+3968 */
  0x2B95,   /* U+3969 */
  0x2B95,   /* U+396A */
  0x5C49,   /* U+396B */
  0x2B8D,   /* U+396C */
  0x2B8D,   /* U+396D */
  0x2B8D,   /* U+396E */
  0x2B8D,   /* U+396F */
  0x2B8D,   /* U+3970 */
  0x2B8D,   /* U+3971 */
  0x2B8D,   /* U+3972 */
  0x2B8D,   /* U+3973 */
  0x2B8D,   /* U+3974 */
  0x2B8D,   /* U+3975 */
  0x2B8D,   /* U+3976 */
  0x2B8D,   /* U+3977 */
  0x2B8D,   /* U+3978 */
  0x2B8D,   /* U+3979 */
  0x2B8D,   /* U+397A */
  0x2B8D,   /* U+397B */
  0x2B97,   /* U+397C */
  0x2B97,   /* U+397D */
  0x2B97,   /* U+397E */
  0x2B97,   /* U+397F */
  0x2B97,   /* U+3980 */
  0x2B97,   /* U+3981 */
  0x2B97,   /* U+3982 */
  0x2B97,   /* U+3983 */
  0x2B97,   /* U+3984 */
  0x2B97,   /* U+3985 */
  0x2B97,   /* U+3986 */
  0x2B97,   /* U+3987 */
  0x2B97,   /* U+3988 */
  0x2B98,   /* U+3989 */
  0x2B98,   /* U+398A */
  0x2B98,   /* U+398B */
  0x2B98,   /* U+398C */
  0x2B98,   /* U+398D */
  0x2B98,   /* U+398E */
  0x2B98,   /* U+398F */
  0x2B98,   /* U+3990 */
  0x2B98,   /* U+3991 */
  0x2B98,   /* U+3992 */
  0x2B98,   /* U+3993 */
  0x2B98,   /* U+3994 */
  0x2B98,   /* U+3995 */
  0x2B98,   /* U+3996 */
  0x2B99,   /* U+3997 */
  0x2B99,   /* U+3998 */
  0x2B99,   /* U+3999 */
  0x2B9A,   /* U+399A */
  0x2B9A,   /* U+399B */
  0x2B9A,   /* U+399C */
  0x2B9A,   /* U+399D */
  0x2B9A,   /* U+399E */
  0x2B9A,   /* U+399F */
  0x2B9A,   /* U+39A0 */
  0x2B9B,   /* U+39A1 */
  0x2B9B,   /* U+39A2 */
  0x2B9C,   /* U+39A3 */
  0x2B9C,   /* U+39A4 */
  0x2B9C,   /* U+39A5 */
  0x2B9C,   /* U+39A6 */
  0x2B9C,   /* U+39A7 */
  0x2B9D,   /* U+39A8 */
  0x2B9D,   /* U+39A9 */
  0x2B9D,   /* U+39AA */
  0x2B9F,   /* U+39AB */
  0x2B9F,   /* U+39AC */
  0x2BA4,   /* U+39AD */
  0x5C49,   /* U+39AE */
  0x2BCF,   /* U+39AF */
  0x2BD0,   /* U+39B0 */
  0x2BD0,   /* U+39B1 */
  0x2BD0,   /* U+39B2 */
  0x5C49,   /* U+39B3 */
  0x2BD2,   /* U+39B4 */
  0x2BD2,   /* U+39B5 */
  0x2BD2,   /* U+39B6 */
  0x2BD3,   /* U+39B7 */
  0x2BD4,   /* U+39B8 */
  0x2BD5,   /* U+39B9 */
  0x2BCD,   /* U+39BA */
  0x2BD7,   /* U+39BB */
  0x2BD7,   /* U+39BC */
  0x2BD9,   /* U+39BD */
  0x2C0F,   /* U+39BE */
  0x2C10,   /* U+39BF */
  0x2C10,   /* U+39C0 */
  0x2C11,   /* U+39C1 */
  0x2C11,   /* U+39C2 */
  0x2C4E,   /* U+39C3 */
  0x2C4E,   /* U+39C4 */
  0x2C4E,   /* U+39C5 */
  0x2C4F,   /* U+39C6 */
  0x2C4F,   /* U+39C7 */
  0x2C4F,   /* U+39C8 */
  0x2C50,   /* U+39C9 */
  0x2C50,   /* U+39CA */
  0x2C50,   /* U+39CB */
  0x2C50,   /* U+39CC */
  0x2C50,   /* U+39CD */
  0x2C50,   /* U+39CE */
  0x2C50,   /* U+39CF */
  0x2C50,   /* U+39D0 */
  0x2C50,   /* U+39D1 */
  0x2C51,   /* U+39D2 */
  0x2C51,   /* U+39D3 */
  0x2C51,   /* U+39D4 */
  0x2C51,   /* U+39D5 */
  0x2C51,   /* U+39D6 */
  0x2C51,   /* U+39D7 */
  0x2C51,   /* U+39D8 */
  0x2C51,   /* U+39D9 */
  0x2C51,   /* U+39DA */
  0x2C51,   /* U+39DB */
  0x2C51,   /* U+39DC */
  0x2C51,   /* U+39DD */
  0x5C49,   /* U+39DE */
  0x2C51,   /* U+39DF */
  0x5C49,   /* U+39E0 */
  0x2C52,   /* U+39E1 */
  0x2C52,   /* U+39E2 */
  0x2C52,   /* U+39E3 */
  0x2C52,   /* U+39E4 */
  0x2C52,   /* U+39E5 */
  0x2C52,   /* U+39E6 */
  0x2C52,   /* U+39E7 */
  0x2C52,   /* U+39E8 */
  0x2C52,   /* U+39E9 */
  0x2C52,   /* U+39EA */
  0x2C52,   /* U+39EB */
  0x2C52,   /* U+39EC */
  0x2C52,   /* U+39ED */
  0x2C52,   /* U+39EE */
  0x2C52,   /* U+39EF */
  0x2C52,   /* U+39F0 */
  0x2C52,   /* U+39F1 */
  0x2C53,   /* U+39F2 */
  0x2C53,   /* U+39F3 */
  0x2C53,   /* U+39F4 */
  0x2C53,   /* U+39F5 */
  0x2C53,   /* U+39F6 */
  0x2C53,   /* U+39F7 */
  0x2C53,   /* U+39F8 */
  0x2C54,   /* U+39F9 */
  0x2C54,   /* U+39FA */
  0x2C54,   /* U+39FB */
  0x2C54,   /* U+39FC */
  0x2C54,   /* U+39FD */
  0x2C54,   /* U+39FE */
  0x2C54,   /* U+39FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3900 */
  0x0020,   /* U+3901 */
  0x0020,   /* U+3902 */
  0x0020,   /* U+3903 */
  0x0020,   /* U+3904 */
  0x0020,   /* U+3905 */
  0x0020,   /* U+3906 */
  0x0020,   /* U+3907 */
  0x0020,   /* U+3908 */
  0x0020,   /* U+3909 */
  0x0020,   /* U+390A */
  0x0020,   /* U+390B */
  0x0020,   /* U+390C */
  0x0020,   /* U+390D */
  0x0020,   /* U+390E */
  0x0020,   /* U+390F */
  0x0020,   /* U+3910 */
  0x0020,   /* U+3911 */
  0x0020,   /* U+3912 */
  0x0020,   /* U+3913 */
  0x0020,   /* U+3914 */
  0x0020,   /* U+3915 */
  0x0020,   /* U+3916 */
  0x0020,   /* U+3917 */
  0x0020,   /* U+3918 */
  0x0020,   /* U+3919 */
  0x0020,   /* U+391A */
  0x0020,   /* U+391B */
  0x0020,   /* U+391C */
  0x0020,   /* U+391D */
  0x0020,   /* U+391E */
  0x0020,   /* U+391F */
  0x0020,   /* U+3920 */
  0x0020,   /* U+3921 */
  0x0020,   /* U+3922 */
  0x0020,   /* U+3923 */
  0x0020,   /* U+3924 */
  0x0020,   /* U+3925 */
  0x0020,   /* U+3926 */
  0x0020,   /* U+3927 */
  0x0020,   /* U+3928 */
  0x0020,   /* U+3929 */
  0x0020,   /* U+392A */
  0x0020,   /* U+392B */
  0x0020,   /* U+392C */
  0x0020,   /* U+392D */
  0x0020,   /* U+392E */
  0x0020,   /* U+392F */
  0x0020,   /* U+3930 */
  0x0020,   /* U+3931 */
  0x0020,   /* U+3932 */
  0x0020,   /* U+3933 */
  0x0020,   /* U+3934 */
  0x0020,   /* U+3935 */
  0x0020,   /* U+3936 */
  0x0020,   /* U+3937 */
  0x0020,   /* U+3938 */
  0x0020,   /* U+3939 */
  0x0020,   /* U+393A */
  0x0020,   /* U+393B */
  0x0020,   /* U+393C */
  0x0020,   /* U+393D */
  0x0020,   /* U+393E */
  0x0020,   /* U+393F */
  0x0020,   /* U+3940 */
  0x0020,   /* U+3941 */
  0x0020,   /* U+3942 */
  0x0020,   /* U+3943 */
  0x0020,   /* U+3944 */
  0x0020,   /* U+3945 */
  0x0020,   /* U+3946 */
  0x0020,   /* U+3947 */
  0x0020,   /* U+3948 */
  0x0020,   /* U+3949 */
  0x0020,   /* U+394A */
  0x0020,   /* U+394B */
  0x0020,   /* U+394C */
  0x0020,   /* U+394D */
  0x0020,   /* U+394E */
  0x0020,   /* U+394F */
  0x0020,   /* U+3950 */
  0x0020,   /* U+3951 */
  0x0020,   /* U+3952 */
  0x0020,   /* U+3953 */
  0x0020,   /* U+3954 */
  0x0020,   /* U+3955 */
  0x0020,   /* U+3956 */
  0x0020,   /* U+3957 */
  0x0020,   /* U+3958 */
  0x0020,   /* U+3959 */
  0x0020,   /* U+395A */
  0x0020,   /* U+395B */
  0x0020,   /* U+395C */
  0x0020,   /* U+395D */
  0x0020,   /* U+395E */
  0x0020,   /* U+395F */
  0x0020,   /* U+3960 */
  0x0020,   /* U+3961 */
  0x0020,   /* U+3962 */
  0x0020,   /* U+3963 */
  0x0020,   /* U+3964 */
  0x0020,   /* U+3965 */
  0x0020,   /* U+3966 */
  0x0020,   /* U+3967 */
  0x0020,   /* U+3968 */
  0x0020,   /* U+3969 */
  0x0020,   /* U+396A */
  0x0020,   /* U+396B */
  0x0020,   /* U+396C */
  0x0020,   /* U+396D */
  0x0020,   /* U+396E */
  0x0020,   /* U+396F */
  0x0020,   /* U+3970 */
  0x0020,   /* U+3971 */
  0x0020,   /* U+3972 */
  0x0020,   /* U+3973 */
  0x0020,   /* U+3974 */
  0x0020,   /* U+3975 */
  0x0020,   /* U+3976 */
  0x0020,   /* U+3977 */
  0x0020,   /* U+3978 */
  0x0020,   /* U+3979 */
  0x0020,   /* U+397A */
  0x0020,   /* U+397B */
  0x0020,   /* U+397C */
  0x0020,   /* U+397D */
  0x0020,   /* U+397E */
  0x0020,   /* U+397F */
  0x0020,   /* U+3980 */
  0x0020,   /* U+3981 */
  0x0020,   /* U+3982 */
  0x0020,   /* U+3983 */
  0x0020,   /* U+3984 */
  0x0020,   /* U+3985 */
  0x0020,   /* U+3986 */
  0x0020,   /* U+3987 */
  0x0020,   /* U+3988 */
  0x0020,   /* U+3989 */
  0x0020,   /* U+398A */
  0x0020,   /* U+398B */
  0x0020,   /* U+398C */
  0x0020,   /* U+398D */
  0x0020,   /* U+398E */
  0x0020,   /* U+398F */
  0x0020,   /* U+3990 */
  0x0020,   /* U+3991 */
  0x0020,   /* U+3992 */
  0x0020,   /* U+3993 */
  0x0020,   /* U+3994 */
  0x0020,   /* U+3995 */
  0x0020,   /* U+3996 */
  0x0020,   /* U+3997 */
  0x0020,   /* U+3998 */
  0x0020,   /* U+3999 */
  0x0020,   /* U+399A */
  0x0020,   /* U+399B */
  0x0020,   /* U+399C */
  0x0020,   /* U+399D */
  0x0020,   /* U+399E */
  0x0020,   /* U+399F */
  0x0020,   /* U+39A0 */
  0x0020,   /* U+39A1 */
  0x0020,   /* U+39A2 */
  0x0020,   /* U+39A3 */
  0x0020,   /* U+39A4 */
  0x0020,   /* U+39A5 */
  0x0020,   /* U+39A6 */
  0x0020,   /* U+39A7 */
  0x0020,   /* U+39A8 */
  0x0020,   /* U+39A9 */
  0x0020,   /* U+39AA */
  0x0020,   /* U+39AB */
  0x0020,   /* U+39AC */
  0x0020,   /* U+39AD */
  0x0020,   /* U+39AE */
  0x0020,   /* U+39AF */
  0x0020,   /* U+39B0 */
  0x0020,   /* U+39B1 */
  0x0020,   /* U+39B2 */
  0x0020,   /* U+39B3 */
  0x0020,   /* U+39B4 */
  0x0020,   /* U+39B5 */
  0x0020,   /* U+39B6 */
  0x0020,   /* U+39B7 */
  0x0020,   /* U+39B8 */
  0x0020,   /* U+39B9 */
  0x0020,   /* U+39BA */
  0x0020,   /* U+39BB */
  0x0020,   /* U+39BC */
  0x0020,   /* U+39BD */
  0x0020,   /* U+39BE */
  0x0020,   /* U+39BF */
  0x0020,   /* U+39C0 */
  0x0020,   /* U+39C1 */
  0x0020,   /* U+39C2 */
  0x0020,   /* U+39C3 */
  0x0020,   /* U+39C4 */
  0x0020,   /* U+39C5 */
  0x0020,   /* U+39C6 */
  0x0020,   /* U+39C7 */
  0x0020,   /* U+39C8 */
  0x0020,   /* U+39C9 */
  0x0020,   /* U+39CA */
  0x0020,   /* U+39CB */
  0x0020,   /* U+39CC */
  0x0020,   /* U+39CD */
  0x0020,   /* U+39CE */
  0x0020,   /* U+39CF */
  0x0020,   /* U+39D0 */
  0x0020,   /* U+39D1 */
  0x0020,   /* U+39D2 */
  0x0020,   /* U+39D3 */
  0x0020,   /* U+39D4 */
  0x0020,   /* U+39D5 */
  0x0020,   /* U+39D6 */
  0x0020,   /* U+39D7 */
  0x0020,   /* U+39D8 */
  0x0020,   /* U+39D9 */
  0x0020,   /* U+39DA */
  0x0020,   /* U+39DB */
  0x0020,   /* U+39DC */
  0x0020,   /* U+39DD */
  0x0020,   /* U+39DE */
  0x0020,   /* U+39DF */
  0x0020,   /* U+39E0 */
  0x0020,   /* U+39E1 */
  0x0020,   /* U+39E2 */
  0x0020,   /* U+39E3 */
  0x0020,   /* U+39E4 */
  0x0020,   /* U+39E5 */
  0x0020,   /* U+39E6 */
  0x0020,   /* U+39E7 */
  0x0020,   /* U+39E8 */
  0x0020,   /* U+39E9 */
  0x0020,   /* U+39EA */
  0x0020,   /* U+39EB */
  0x0020,   /* U+39EC */
  0x0020,   /* U+39ED */
  0x0020,   /* U+39EE */
  0x0020,   /* U+39EF */
  0x0020,   /* U+39F0 */
  0x0020,   /* U+39F1 */
  0x0020,   /* U+39F2 */
  0x0020,   /* U+39F3 */
  0x0020,   /* U+39F4 */
  0x0020,   /* U+39F5 */
  0x0020,   /* U+39F6 */
  0x0020,   /* U+39F7 */
  0x0020,   /* U+39F8 */
  0x0020,   /* U+39F9 */
  0x0020,   /* U+39FA */
  0x0020,   /* U+39FB */
  0x0020,   /* U+39FC */
  0x0020,   /* U+39FD */
  0x0020,   /* U+39FE */
  0x0020,   /* U+39FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3900 */
  0x0002,   /* U+3901 */
  0x0002,   /* U+3902 */
  0x0002,   /* U+3903 */
  0x0002,   /* U+3904 */
  0x0002,   /* U+3905 */
  0x0002,   /* U+3906 */
  0x0002,   /* U+3907 */
  0x0002,   /* U+3908 */
  0x0002,   /* U+3909 */
  0x0002,   /* U+390A */
  0x0002,   /* U+390B */
  0x0002,   /* U+390C */
  0x0002,   /* U+390D */
  0x0002,   /* U+390E */
  0x0002,   /* U+390F */
  0x0002,   /* U+3910 */
  0x0002,   /* U+3911 */
  0x0002,   /* U+3912 */
  0x0002,   /* U+3913 */
  0x0002,   /* U+3914 */
  0x0002,   /* U+3915 */
  0x0002,   /* U+3916 */
  0x0002,   /* U+3917 */
  0x0002,   /* U+3918 */
  0x0002,   /* U+3919 */
  0x0002,   /* U+391A */
  0x0002,   /* U+391B */
  0x0002,   /* U+391C */
  0x0002,   /* U+391D */
  0x0002,   /* U+391E */
  0x0002,   /* U+391F */
  0x0002,   /* U+3920 */
  0x0002,   /* U+3921 */
  0x0002,   /* U+3922 */
  0x0002,   /* U+3923 */
  0x0002,   /* U+3924 */
  0x0002,   /* U+3925 */
  0x0002,   /* U+3926 */
  0x0002,   /* U+3927 */
  0x0002,   /* U+3928 */
  0x0002,   /* U+3929 */
  0x0002,   /* U+392A */
  0x0002,   /* U+392B */
  0x0002,   /* U+392C */
  0x0002,   /* U+392D */
  0x0002,   /* U+392E */
  0x0002,   /* U+392F */
  0x0002,   /* U+3930 */
  0x0002,   /* U+3931 */
  0x0002,   /* U+3932 */
  0x0002,   /* U+3933 */
  0x0002,   /* U+3934 */
  0x0002,   /* U+3935 */
  0x0002,   /* U+3936 */
  0x0002,   /* U+3937 */
  0x0002,   /* U+3938 */
  0x0002,   /* U+3939 */
  0x0002,   /* U+393A */
  0x0002,   /* U+393B */
  0x0002,   /* U+393C */
  0x0002,   /* U+393D */
  0x0002,   /* U+393E */
  0x0002,   /* U+393F */
  0x0002,   /* U+3940 */
  0x0002,   /* U+3941 */
  0x0002,   /* U+3942 */
  0x0002,   /* U+3943 */
  0x0002,   /* U+3944 */
  0x0002,   /* U+3945 */
  0x0002,   /* U+3946 */
  0x0002,   /* U+3947 */
  0x0002,   /* U+3948 */
  0x0002,   /* U+3949 */
  0x0002,   /* U+394A */
  0x0002,   /* U+394B */
  0x0002,   /* U+394C */
  0x0002,   /* U+394D */
  0x0002,   /* U+394E */
  0x0002,   /* U+394F */
  0x0002,   /* U+3950 */
  0x0002,   /* U+3951 */
  0x0002,   /* U+3952 */
  0x0002,   /* U+3953 */
  0x0002,   /* U+3954 */
  0x0002,   /* U+3955 */
  0x0002,   /* U+3956 */
  0x0002,   /* U+3957 */
  0x0002,   /* U+3958 */
  0x0002,   /* U+3959 */
  0x0002,   /* U+395A */
  0x0002,   /* U+395B */
  0x0002,   /* U+395C */
  0x0002,   /* U+395D */
  0x0002,   /* U+395E */
  0x0002,   /* U+395F */
  0x0002,   /* U+3960 */
  0x0002,   /* U+3961 */
  0x0002,   /* U+3962 */
  0x0002,   /* U+3963 */
  0x0002,   /* U+3964 */
  0x0002,   /* U+3965 */
  0x0002,   /* U+3966 */
  0x0002,   /* U+3967 */
  0x0002,   /* U+3968 */
  0x0002,   /* U+3969 */
  0x0002,   /* U+396A */
  0x0002,   /* U+396B */
  0x0002,   /* U+396C */
  0x0002,   /* U+396D */
  0x0002,   /* U+396E */
  0x0002,   /* U+396F */
  0x0002,   /* U+3970 */
  0x0002,   /* U+3971 */
  0x0002,   /* U+3972 */
  0x0002,   /* U+3973 */
  0x0002,   /* U+3974 */
  0x0002,   /* U+3975 */
  0x0002,   /* U+3976 */
  0x0002,   /* U+3977 */
  0x0002,   /* U+3978 */
  0x0002,   /* U+3979 */
  0x0002,   /* U+397A */
  0x0002,   /* U+397B */
  0x0002,   /* U+397C */
  0x0002,   /* U+397D */
  0x0002,   /* U+397E */
  0x0002,   /* U+397F */
  0x0002,   /* U+3980 */
  0x0002,   /* U+3981 */
  0x0002,   /* U+3982 */
  0x0002,   /* U+3983 */
  0x0002,   /* U+3984 */
  0x0002,   /* U+3985 */
  0x0002,   /* U+3986 */
  0x0002,   /* U+3987 */
  0x0002,   /* U+3988 */
  0x0002,   /* U+3989 */
  0x0002,   /* U+398A */
  0x0002,   /* U+398B */
  0x0002,   /* U+398C */
  0x0002,   /* U+398D */
  0x0002,   /* U+398E */
  0x0002,   /* U+398F */
  0x0002,   /* U+3990 */
  0x0002,   /* U+3991 */
  0x0002,   /* U+3992 */
  0x0002,   /* U+3993 */
  0x0002,   /* U+3994 */
  0x0002,   /* U+3995 */
  0x0002,   /* U+3996 */
  0x0002,   /* U+3997 */
  0x0002,   /* U+3998 */
  0x0002,   /* U+3999 */
  0x0002,   /* U+399A */
  0x0002,   /* U+399B */
  0x0002,   /* U+399C */
  0x0002,   /* U+399D */
  0x0002,   /* U+399E */
  0x0002,   /* U+399F */
  0x0002,   /* U+39A0 */
  0x0002,   /* U+39A1 */
  0x0002,   /* U+39A2 */
  0x0002,   /* U+39A3 */
  0x0002,   /* U+39A4 */
  0x0002,   /* U+39A5 */
  0x0002,   /* U+39A6 */
  0x0002,   /* U+39A7 */
  0x0002,   /* U+39A8 */
  0x0002,   /* U+39A9 */
  0x0002,   /* U+39AA */
  0x0002,   /* U+39AB */
  0x0002,   /* U+39AC */
  0x0002,   /* U+39AD */
  0x0002,   /* U+39AE */
  0x0002,   /* U+39AF */
  0x0002,   /* U+39B0 */
  0x0002,   /* U+39B1 */
  0x0002,   /* U+39B2 */
  0x0002,   /* U+39B3 */
  0x0002,   /* U+39B4 */
  0x0002,   /* U+39B5 */
  0x0002,   /* U+39B6 */
  0x0002,   /* U+39B7 */
  0x0002,   /* U+39B8 */
  0x0002,   /* U+39B9 */
  0x0002,   /* U+39BA */
  0x0002,   /* U+39BB */
  0x0002,   /* U+39BC */
  0x0002,   /* U+39BD */
  0x0002,   /* U+39BE */
  0x0002,   /* U+39BF */
  0x0002,   /* U+39C0 */
  0x0002,   /* U+39C1 */
  0x0002,   /* U+39C2 */
  0x0002,   /* U+39C3 */
  0x0002,   /* U+39C4 */
  0x0002,   /* U+39C5 */
  0x0002,   /* U+39C6 */
  0x0002,   /* U+39C7 */
  0x0002,   /* U+39C8 */
  0x0002,   /* U+39C9 */
  0x0002,   /* U+39CA */
  0x0002,   /* U+39CB */
  0x0002,   /* U+39CC */
  0x0002,   /* U+39CD */
  0x0002,   /* U+39CE */
  0x0002,   /* U+39CF */
  0x0002,   /* U+39D0 */
  0x0002,   /* U+39D1 */
  0x0002,   /* U+39D2 */
  0x0002,   /* U+39D3 */
  0x0002,   /* U+39D4 */
  0x0002,   /* U+39D5 */
  0x0002,   /* U+39D6 */
  0x0002,   /* U+39D7 */
  0x0002,   /* U+39D8 */
  0x0002,   /* U+39D9 */
  0x0002,   /* U+39DA */
  0x0002,   /* U+39DB */
  0x0002,   /* U+39DC */
  0x0002,   /* U+39DD */
  0x0002,   /* U+39DE */
  0x0002,   /* U+39DF */
  0x0002,   /* U+39E0 */
  0x0002,   /* U+39E1 */
  0x0002,   /* U+39E2 */
  0x0002,   /* U+39E3 */
  0x0002,   /* U+39E4 */
  0x0002,   /* U+39E5 */
  0x0002,   /* U+39E6 */
  0x0002,   /* U+39E7 */
  0x0002,   /* U+39E8 */
  0x0002,   /* U+39E9 */
  0x0002,   /* U+39EA */
  0x0002,   /* U+39EB */
  0x0002,   /* U+39EC */
  0x0002,   /* U+39ED */
  0x0002,   /* U+39EE */
  0x0002,   /* U+39EF */
  0x0002,   /* U+39F0 */
  0x0002,   /* U+39F1 */
  0x0002,   /* U+39F2 */
  0x0002,   /* U+39F3 */
  0x0002,   /* U+39F4 */
  0x0002,   /* U+39F5 */
  0x0002,   /* U+39F6 */
  0x0002,   /* U+39F7 */
  0x0002,   /* U+39F8 */
  0x0002,   /* U+39F9 */
  0x0002,   /* U+39FA */
  0x0002,   /* U+39FB */
  0x0002,   /* U+39FC */
  0x0002,   /* U+39FD */
  0x0002,   /* U+39FE */
  0x0002,   /* U+39FF */

  /* Primary weight 2 for each character. */
  0xB900,   /* U+3900 */
  0x8000,   /* U+3901 */
  0x8001,   /* U+3902 */
  0x8002,   /* U+3903 */
  0x8003,   /* U+3904 */
  0x8004,   /* U+3905 */
  0x8005,   /* U+3906 */
  0x8006,   /* U+3907 */
  0x8007,   /* U+3908 */
  0x8008,   /* U+3909 */
  0x8009,   /* U+390A */
  0x800A,   /* U+390B */
  0x8000,   /* U+390C */
  0x8001,   /* U+390D */
  0x8002,   /* U+390E */
  0x8003,   /* U+390F */
  0x8004,   /* U+3910 */
  0x8005,   /* U+3911 */
  0x8006,   /* U+3912 */
  0x8007,   /* U+3913 */
  0x8008,   /* U+3914 */
  0x8009,   /* U+3915 */
  0x800A,   /* U+3916 */
  0x800B,   /* U+3917 */
  0x800C,   /* U+3918 */
  0x800D,   /* U+3919 */
  0x8000,   /* U+391A */
  0x8001,   /* U+391B */
  0x8002,   /* U+391C */
  0x8003,   /* U+391D */
  0x8004,   /* U+391E */
  0x8005,   /* U+391F */
  0x8006,   /* U+3920 */
  0x8007,   /* U+3921 */
  0x8008,   /* U+3922 */
  0x8009,   /* U+3923 */
  0x800A,   /* U+3924 */
  0x800B,   /* U+3925 */
  0x800C,   /* U+3926 */
  0x800D,   /* U+3927 */
  0x800E,   /* U+3928 */
  0x800F,   /* U+3929 */
  0x8010,   /* U+392A */
  0x8011,   /* U+392B */
  0x8012,   /* U+392C */
  0x8013,   /* U+392D */
  0x8000,   /* U+392E */
  0x8001,   /* U+392F */
  0x8002,   /* U+3930 */
  0x8003,   /* U+3931 */
  0x8004,   /* U+3932 */
  0x8005,   /* U+3933 */
  0x8006,   /* U+3934 */
  0x8007,   /* U+3935 */
  0x8008,   /* U+3936 */
  0x8009,   /* U+3937 */
  0x800A,   /* U+3938 */
  0x800B,   /* U+3939 */
  0x8014,   /* U+393A */
  0x800C,   /* U+393B */
  0xB93C,   /* U+393C */
  0x800D,   /* U+393D */
  0x8000,   /* U+393E */
  0x8001,   /* U+393F */
  0x8002,   /* U+3940 */
  0x8003,   /* U+3941 */
  0x8004,   /* U+3942 */
  0x8005,   /* U+3943 */
  0x8006,   /* U+3944 */
  0x8007,   /* U+3945 */
  0x8008,   /* U+3946 */
  0x8009,   /* U+3947 */
  0x800A,   /* U+3948 */
  0x800B,   /* U+3949 */
  0x800C,   /* U+394A */
  0x800D,   /* U+394B */
  0x800E,   /* U+394C */
  0x800F,   /* U+394D */
  0x8010,   /* U+394E */
  0x8011,   /* U+394F */
  0x8012,   /* U+3950 */
  0x8013,   /* U+3951 */
  0x8014,   /* U+3952 */
  0x8015,   /* U+3953 */
  0x8016,   /* U+3954 */
  0x8017,   /* U+3955 */
  0x8018,   /* U+3956 */
  0x8019,   /* U+3957 */
  0xB958,   /* U+3958 */
  0xB959,   /* U+3959 */
  0x8000,   /* U+395A */
  0x8001,   /* U+395B */
  0x8002,   /* U+395C */
  0x8003,   /* U+395D */
  0x8004,   /* U+395E */
  0x8005,   /* U+395F */
  0x8006,   /* U+3960 */
  0x8007,   /* U+3961 */
  0x8008,   /* U+3962 */
  0x8009,   /* U+3963 */
  0x800A,   /* U+3964 */
  0x800B,   /* U+3965 */
  0x800C,   /* U+3966 */
  0x800D,   /* U+3967 */
  0x800E,   /* U+3968 */
  0x800F,   /* U+3969 */
  0x8010,   /* U+396A */
  0xB96B,   /* U+396B */
  0x8000,   /* U+396C */
  0x8001,   /* U+396D */
  0x8002,   /* U+396E */
  0x8003,   /* U+396F */
  0x8004,   /* U+3970 */
  0x8005,   /* U+3971 */
  0x8006,   /* U+3972 */
  0x8007,   /* U+3973 */
  0x8008,   /* U+3974 */
  0x8009,   /* U+3975 */
  0x800A,   /* U+3976 */
  0x800B,   /* U+3977 */
  0x800C,   /* U+3978 */
  0x800D,   /* U+3979 */
  0x800E,   /* U+397A */
  0x800F,   /* U+397B */
  0x8000,   /* U+397C */
  0x8001,   /* U+397D */
  0x8002,   /* U+397E */
  0x8003,   /* U+397F */
  0x8004,   /* U+3980 */
  0x8005,   /* U+3981 */
  0x8006,   /* U+3982 */
  0x8007,   /* U+3983 */
  0x8008,   /* U+3984 */
  0x8009,   /* U+3985 */
  0x800A,   /* U+3986 */
  0x800B,   /* U+3987 */
  0x800C,   /* U+3988 */
  0x8000,   /* U+3989 */
  0x8001,   /* U+398A */
  0x8002,   /* U+398B */
  0x8003,   /* U+398C */
  0x8004,   /* U+398D */
  0x8005,   /* U+398E */
  0x8006,   /* U+398F */
  0x8007,   /* U+3990 */
  0x8008,   /* U+3991 */
  0x8009,   /* U+3992 */
  0x800A,   /* U+3993 */
  0x800B,   /* U+3994 */
  0x800C,   /* U+3995 */
  0x800D,   /* U+3996 */
  0x8000,   /* U+3997 */
  0x8001,   /* U+3998 */
  0x8002,   /* U+3999 */
  0x8000,   /* U+399A */
  0x8001,   /* U+399B */
  0x8002,   /* U+399C */
  0x8003,   /* U+399D */
  0x8004,   /* U+399E */
  0x8005,   /* U+399F */
  0x8006,   /* U+39A0 */
  0x8000,   /* U+39A1 */
  0x8001,   /* U+39A2 */
  0x8000,   /* U+39A3 */
  0x8001,   /* U+39A4 */
  0x8002,   /* U+39A5 */
  0x8003,   /* U+39A6 */
  0x8004,   /* U+39A7 */
  0x8000,   /* U+39A8 */
  0x8001,   /* U+39A9 */
  0x8002,   /* U+39AA */
  0x8000,   /* U+39AB */
  0x8001,   /* U+39AC */
  0x8000,   /* U+39AD */
  0xB9AE,   /* U+39AE */
  0x8000,   /* U+39AF */
  0x8000,   /* U+39B0 */
  0x8001,   /* U+39B1 */
  0x8002,   /* U+39B2 */
  0xB9B3,   /* U+39B3 */
  0x8000,   /* U+39B4 */
  0x8001,   /* U+39B5 */
  0x8002,   /* U+39B6 */
  0x8000,   /* U+39B7 */
  0x8000,   /* U+39B8 */
  0x8000,   /* U+39B9 */
  0x8000,   /* U+39BA */
  0x8000,   /* U+39BB */
  0x8001,   /* U+39BC */
  0x8000,   /* U+39BD */
  0x8000,   /* U+39BE */
  0x8000,   /* U+39BF */
  0x8001,   /* U+39C0 */
  0x8000,   /* U+39C1 */
  0x8001,   /* U+39C2 */
  0x8000,   /* U+39C3 */
  0x8001,   /* U+39C4 */
  0x8002,   /* U+39C5 */
  0x8000,   /* U+39C6 */
  0x8001,   /* U+39C7 */
  0x8002,   /* U+39C8 */
  0x8000,   /* U+39C9 */
  0x8001,   /* U+39CA */
  0x8002,   /* U+39CB */
  0x8003,   /* U+39CC */
  0x8004,   /* U+39CD */
  0x8005,   /* U+39CE */
  0x8006,   /* U+39CF */
  0x8007,   /* U+39D0 */
  0x8008,   /* U+39D1 */
  0x8000,   /* U+39D2 */
  0x8001,   /* U+39D3 */
  0x8002,   /* U+39D4 */
  0x8003,   /* U+39D5 */
  0x8004,   /* U+39D6 */
  0x8005,   /* U+39D7 */
  0x8006,   /* U+39D8 */
  0x8007,   /* U+39D9 */
  0x8008,   /* U+39DA */
  0x8009,   /* U+39DB */
  0x800A,   /* U+39DC */
  0x800B,   /* U+39DD */
  0xB9DE,   /* U+39DE */
  0x800C,   /* U+39DF */
  0xB9E0,   /* U+39E0 */
  0x8000,   /* U+39E1 */
  0x8001,   /* U+39E2 */
  0x8002,   /* U+39E3 */
  0x8003,   /* U+39E4 */
  0x8004,   /* U+39E5 */
  0x8005,   /* U+39E6 */
  0x8006,   /* U+39E7 */
  0x8007,   /* U+39E8 */
  0x8008,   /* U+39E9 */
  0x8009,   /* U+39EA */
  0x800A,   /* U+39EB */
  0x800B,   /* U+39EC */
  0x800C,   /* U+39ED */
  0x800D,   /* U+39EE */
  0x800E,   /* U+39EF */
  0x800F,   /* U+39F0 */
  0x8010,   /* U+39F1 */
  0x8000,   /* U+39F2 */
  0x8001,   /* U+39F3 */
  0x8002,   /* U+39F4 */
  0x8003,   /* U+39F5 */
  0x8004,   /* U+39F6 */
  0x8005,   /* U+39F7 */
  0x8006,   /* U+39F8 */
  0x8000,   /* U+39F9 */
  0x8001,   /* U+39FA */
  0x8002,   /* U+39FB */
  0x8003,   /* U+39FC */
  0x8004,   /* U+39FD */
  0x8005,   /* U+39FE */
  0x8006,   /* U+39FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3900 */
  0x0000,   /* U+3901 */
  0x0000,   /* U+3902 */
  0x0000,   /* U+3903 */
  0x0000,   /* U+3904 */
  0x0000,   /* U+3905 */
  0x0000,   /* U+3906 */
  0x0000,   /* U+3907 */
  0x0000,   /* U+3908 */
  0x0000,   /* U+3909 */
  0x0000,   /* U+390A */
  0x0000,   /* U+390B */
  0x0000,   /* U+390C */
  0x0000,   /* U+390D */
  0x0000,   /* U+390E */
  0x0000,   /* U+390F */
  0x0000,   /* U+3910 */
  0x0000,   /* U+3911 */
  0x0000,   /* U+3912 */
  0x0000,   /* U+3913 */
  0x0000,   /* U+3914 */
  0x0000,   /* U+3915 */
  0x0000,   /* U+3916 */
  0x0000,   /* U+3917 */
  0x0000,   /* U+3918 */
  0x0000,   /* U+3919 */
  0x0000,   /* U+391A */
  0x0000,   /* U+391B */
  0x0000,   /* U+391C */
  0x0000,   /* U+391D */
  0x0000,   /* U+391E */
  0x0000,   /* U+391F */
  0x0000,   /* U+3920 */
  0x0000,   /* U+3921 */
  0x0000,   /* U+3922 */
  0x0000,   /* U+3923 */
  0x0000,   /* U+3924 */
  0x0000,   /* U+3925 */
  0x0000,   /* U+3926 */
  0x0000,   /* U+3927 */
  0x0000,   /* U+3928 */
  0x0000,   /* U+3929 */
  0x0000,   /* U+392A */
  0x0000,   /* U+392B */
  0x0000,   /* U+392C */
  0x0000,   /* U+392D */
  0x0000,   /* U+392E */
  0x0000,   /* U+392F */
  0x0000,   /* U+3930 */
  0x0000,   /* U+3931 */
  0x0000,   /* U+3932 */
  0x0000,   /* U+3933 */
  0x0000,   /* U+3934 */
  0x0000,   /* U+3935 */
  0x0000,   /* U+3936 */
  0x0000,   /* U+3937 */
  0x0000,   /* U+3938 */
  0x0000,   /* U+3939 */
  0x0000,   /* U+393A */
  0x0000,   /* U+393B */
  0x0000,   /* U+393C */
  0x0000,   /* U+393D */
  0x0000,   /* U+393E */
  0x0000,   /* U+393F */
  0x0000,   /* U+3940 */
  0x0000,   /* U+3941 */
  0x0000,   /* U+3942 */
  0x0000,   /* U+3943 */
  0x0000,   /* U+3944 */
  0x0000,   /* U+3945 */
  0x0000,   /* U+3946 */
  0x0000,   /* U+3947 */
  0x0000,   /* U+3948 */
  0x0000,   /* U+3949 */
  0x0000,   /* U+394A */
  0x0000,   /* U+394B */
  0x0000,   /* U+394C */
  0x0000,   /* U+394D */
  0x0000,   /* U+394E */
  0x0000,   /* U+394F */
  0x0000,   /* U+3950 */
  0x0000,   /* U+3951 */
  0x0000,   /* U+3952 */
  0x0000,   /* U+3953 */
  0x0000,   /* U+3954 */
  0x0000,   /* U+3955 */
  0x0000,   /* U+3956 */
  0x0000,   /* U+3957 */
  0x0000,   /* U+3958 */
  0x0000,   /* U+3959 */
  0x0000,   /* U+395A */
  0x0000,   /* U+395B */
  0x0000,   /* U+395C */
  0x0000,   /* U+395D */
  0x0000,   /* U+395E */
  0x0000,   /* U+395F */
  0x0000,   /* U+3960 */
  0x0000,   /* U+3961 */
  0x0000,   /* U+3962 */
  0x0000,   /* U+3963 */
  0x0000,   /* U+3964 */
  0x0000,   /* U+3965 */
  0x0000,   /* U+3966 */
  0x0000,   /* U+3967 */
  0x0000,   /* U+3968 */
  0x0000,   /* U+3969 */
  0x0000,   /* U+396A */
  0x0000,   /* U+396B */
  0x0000,   /* U+396C */
  0x0000,   /* U+396D */
  0x0000,   /* U+396E */
  0x0000,   /* U+396F */
  0x0000,   /* U+3970 */
  0x0000,   /* U+3971 */
  0x0000,   /* U+3972 */
  0x0000,   /* U+3973 */
  0x0000,   /* U+3974 */
  0x0000,   /* U+3975 */
  0x0000,   /* U+3976 */
  0x0000,   /* U+3977 */
  0x0000,   /* U+3978 */
  0x0000,   /* U+3979 */
  0x0000,   /* U+397A */
  0x0000,   /* U+397B */
  0x0000,   /* U+397C */
  0x0000,   /* U+397D */
  0x0000,   /* U+397E */
  0x0000,   /* U+397F */
  0x0000,   /* U+3980 */
  0x0000,   /* U+3981 */
  0x0000,   /* U+3982 */
  0x0000,   /* U+3983 */
  0x0000,   /* U+3984 */
  0x0000,   /* U+3985 */
  0x0000,   /* U+3986 */
  0x0000,   /* U+3987 */
  0x0000,   /* U+3988 */
  0x0000,   /* U+3989 */
  0x0000,   /* U+398A */
  0x0000,   /* U+398B */
  0x0000,   /* U+398C */
  0x0000,   /* U+398D */
  0x0000,   /* U+398E */
  0x0000,   /* U+398F */
  0x0000,   /* U+3990 */
  0x0000,   /* U+3991 */
  0x0000,   /* U+3992 */
  0x0000,   /* U+3993 */
  0x0000,   /* U+3994 */
  0x0000,   /* U+3995 */
  0x0000,   /* U+3996 */
  0x0000,   /* U+3997 */
  0x0000,   /* U+3998 */
  0x0000,   /* U+3999 */
  0x0000,   /* U+399A */
  0x0000,   /* U+399B */
  0x0000,   /* U+399C */
  0x0000,   /* U+399D */
  0x0000,   /* U+399E */
  0x0000,   /* U+399F */
  0x0000,   /* U+39A0 */
  0x0000,   /* U+39A1 */
  0x0000,   /* U+39A2 */
  0x0000,   /* U+39A3 */
  0x0000,   /* U+39A4 */
  0x0000,   /* U+39A5 */
  0x0000,   /* U+39A6 */
  0x0000,   /* U+39A7 */
  0x0000,   /* U+39A8 */
  0x0000,   /* U+39A9 */
  0x0000,   /* U+39AA */
  0x0000,   /* U+39AB */
  0x0000,   /* U+39AC */
  0x0000,   /* U+39AD */
  0x0000,   /* U+39AE */
  0x0000,   /* U+39AF */
  0x0000,   /* U+39B0 */
  0x0000,   /* U+39B1 */
  0x0000,   /* U+39B2 */
  0x0000,   /* U+39B3 */
  0x0000,   /* U+39B4 */
  0x0000,   /* U+39B5 */
  0x0000,   /* U+39B6 */
  0x0000,   /* U+39B7 */
  0x0000,   /* U+39B8 */
  0x0000,   /* U+39B9 */
  0x0000,   /* U+39BA */
  0x0000,   /* U+39BB */
  0x0000,   /* U+39BC */
  0x0000,   /* U+39BD */
  0x0000,   /* U+39BE */
  0x0000,   /* U+39BF */
  0x0000,   /* U+39C0 */
  0x0000,   /* U+39C1 */
  0x0000,   /* U+39C2 */
  0x0000,   /* U+39C3 */
  0x0000,   /* U+39C4 */
  0x0000,   /* U+39C5 */
  0x0000,   /* U+39C6 */
  0x0000,   /* U+39C7 */
  0x0000,   /* U+39C8 */
  0x0000,   /* U+39C9 */
  0x0000,   /* U+39CA */
  0x0000,   /* U+39CB */
  0x0000,   /* U+39CC */
  0x0000,   /* U+39CD */
  0x0000,   /* U+39CE */
  0x0000,   /* U+39CF */
  0x0000,   /* U+39D0 */
  0x0000,   /* U+39D1 */
  0x0000,   /* U+39D2 */
  0x0000,   /* U+39D3 */
  0x0000,   /* U+39D4 */
  0x0000,   /* U+39D5 */
  0x0000,   /* U+39D6 */
  0x0000,   /* U+39D7 */
  0x0000,   /* U+39D8 */
  0x0000,   /* U+39D9 */
  0x0000,   /* U+39DA */
  0x0000,   /* U+39DB */
  0x0000,   /* U+39DC */
  0x0000,   /* U+39DD */
  0x0000,   /* U+39DE */
  0x0000,   /* U+39DF */
  0x0000,   /* U+39E0 */
  0x0000,   /* U+39E1 */
  0x0000,   /* U+39E2 */
  0x0000,   /* U+39E3 */
  0x0000,   /* U+39E4 */
  0x0000,   /* U+39E5 */
  0x0000,   /* U+39E6 */
  0x0000,   /* U+39E7 */
  0x0000,   /* U+39E8 */
  0x0000,   /* U+39E9 */
  0x0000,   /* U+39EA */
  0x0000,   /* U+39EB */
  0x0000,   /* U+39EC */
  0x0000,   /* U+39ED */
  0x0000,   /* U+39EE */
  0x0000,   /* U+39EF */
  0x0000,   /* U+39F0 */
  0x0000,   /* U+39F1 */
  0x0000,   /* U+39F2 */
  0x0000,   /* U+39F3 */
  0x0000,   /* U+39F4 */
  0x0000,   /* U+39F5 */
  0x0000,   /* U+39F6 */
  0x0000,   /* U+39F7 */
  0x0000,   /* U+39F8 */
  0x0000,   /* U+39F9 */
  0x0000,   /* U+39FA */
  0x0000,   /* U+39FB */
  0x0000,   /* U+39FC */
  0x0000,   /* U+39FD */
  0x0000,   /* U+39FE */
  0x0000,   /* U+39FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3900 */
  0x0000,   /* U+3901 */
  0x0000,   /* U+3902 */
  0x0000,   /* U+3903 */
  0x0000,   /* U+3904 */
  0x0000,   /* U+3905 */
  0x0000,   /* U+3906 */
  0x0000,   /* U+3907 */
  0x0000,   /* U+3908 */
  0x0000,   /* U+3909 */
  0x0000,   /* U+390A */
  0x0000,   /* U+390B */
  0x0000,   /* U+390C */
  0x0000,   /* U+390D */
  0x0000,   /* U+390E */
  0x0000,   /* U+390F */
  0x0000,   /* U+3910 */
  0x0000,   /* U+3911 */
  0x0000,   /* U+3912 */
  0x0000,   /* U+3913 */
  0x0000,   /* U+3914 */
  0x0000,   /* U+3915 */
  0x0000,   /* U+3916 */
  0x0000,   /* U+3917 */
  0x0000,   /* U+3918 */
  0x0000,   /* U+3919 */
  0x0000,   /* U+391A */
  0x0000,   /* U+391B */
  0x0000,   /* U+391C */
  0x0000,   /* U+391D */
  0x0000,   /* U+391E */
  0x0000,   /* U+391F */
  0x0000,   /* U+3920 */
  0x0000,   /* U+3921 */
  0x0000,   /* U+3922 */
  0x0000,   /* U+3923 */
  0x0000,   /* U+3924 */
  0x0000,   /* U+3925 */
  0x0000,   /* U+3926 */
  0x0000,   /* U+3927 */
  0x0000,   /* U+3928 */
  0x0000,   /* U+3929 */
  0x0000,   /* U+392A */
  0x0000,   /* U+392B */
  0x0000,   /* U+392C */
  0x0000,   /* U+392D */
  0x0000,   /* U+392E */
  0x0000,   /* U+392F */
  0x0000,   /* U+3930 */
  0x0000,   /* U+3931 */
  0x0000,   /* U+3932 */
  0x0000,   /* U+3933 */
  0x0000,   /* U+3934 */
  0x0000,   /* U+3935 */
  0x0000,   /* U+3936 */
  0x0000,   /* U+3937 */
  0x0000,   /* U+3938 */
  0x0000,   /* U+3939 */
  0x0000,   /* U+393A */
  0x0000,   /* U+393B */
  0x0000,   /* U+393C */
  0x0000,   /* U+393D */
  0x0000,   /* U+393E */
  0x0000,   /* U+393F */
  0x0000,   /* U+3940 */
  0x0000,   /* U+3941 */
  0x0000,   /* U+3942 */
  0x0000,   /* U+3943 */
  0x0000,   /* U+3944 */
  0x0000,   /* U+3945 */
  0x0000,   /* U+3946 */
  0x0000,   /* U+3947 */
  0x0000,   /* U+3948 */
  0x0000,   /* U+3949 */
  0x0000,   /* U+394A */
  0x0000,   /* U+394B */
  0x0000,   /* U+394C */
  0x0000,   /* U+394D */
  0x0000,   /* U+394E */
  0x0000,   /* U+394F */
  0x0000,   /* U+3950 */
  0x0000,   /* U+3951 */
  0x0000,   /* U+3952 */
  0x0000,   /* U+3953 */
  0x0000,   /* U+3954 */
  0x0000,   /* U+3955 */
  0x0000,   /* U+3956 */
  0x0000,   /* U+3957 */
  0x0000,   /* U+3958 */
  0x0000,   /* U+3959 */
  0x0000,   /* U+395A */
  0x0000,   /* U+395B */
  0x0000,   /* U+395C */
  0x0000,   /* U+395D */
  0x0000,   /* U+395E */
  0x0000,   /* U+395F */
  0x0000,   /* U+3960 */
  0x0000,   /* U+3961 */
  0x0000,   /* U+3962 */
  0x0000,   /* U+3963 */
  0x0000,   /* U+3964 */
  0x0000,   /* U+3965 */
  0x0000,   /* U+3966 */
  0x0000,   /* U+3967 */
  0x0000,   /* U+3968 */
  0x0000,   /* U+3969 */
  0x0000,   /* U+396A */
  0x0000,   /* U+396B */
  0x0000,   /* U+396C */
  0x0000,   /* U+396D */
  0x0000,   /* U+396E */
  0x0000,   /* U+396F */
  0x0000,   /* U+3970 */
  0x0000,   /* U+3971 */
  0x0000,   /* U+3972 */
  0x0000,   /* U+3973 */
  0x0000,   /* U+3974 */
  0x0000,   /* U+3975 */
  0x0000,   /* U+3976 */
  0x0000,   /* U+3977 */
  0x0000,   /* U+3978 */
  0x0000,   /* U+3979 */
  0x0000,   /* U+397A */
  0x0000,   /* U+397B */
  0x0000,   /* U+397C */
  0x0000,   /* U+397D */
  0x0000,   /* U+397E */
  0x0000,   /* U+397F */
  0x0000,   /* U+3980 */
  0x0000,   /* U+3981 */
  0x0000,   /* U+3982 */
  0x0000,   /* U+3983 */
  0x0000,   /* U+3984 */
  0x0000,   /* U+3985 */
  0x0000,   /* U+3986 */
  0x0000,   /* U+3987 */
  0x0000,   /* U+3988 */
  0x0000,   /* U+3989 */
  0x0000,   /* U+398A */
  0x0000,   /* U+398B */
  0x0000,   /* U+398C */
  0x0000,   /* U+398D */
  0x0000,   /* U+398E */
  0x0000,   /* U+398F */
  0x0000,   /* U+3990 */
  0x0000,   /* U+3991 */
  0x0000,   /* U+3992 */
  0x0000,   /* U+3993 */
  0x0000,   /* U+3994 */
  0x0000,   /* U+3995 */
  0x0000,   /* U+3996 */
  0x0000,   /* U+3997 */
  0x0000,   /* U+3998 */
  0x0000,   /* U+3999 */
  0x0000,   /* U+399A */
  0x0000,   /* U+399B */
  0x0000,   /* U+399C */
  0x0000,   /* U+399D */
  0x0000,   /* U+399E */
  0x0000,   /* U+399F */
  0x0000,   /* U+39A0 */
  0x0000,   /* U+39A1 */
  0x0000,   /* U+39A2 */
  0x0000,   /* U+39A3 */
  0x0000,   /* U+39A4 */
  0x0000,   /* U+39A5 */
  0x0000,   /* U+39A6 */
  0x0000,   /* U+39A7 */
  0x0000,   /* U+39A8 */
  0x0000,   /* U+39A9 */
  0x0000,   /* U+39AA */
  0x0000,   /* U+39AB */
  0x0000,   /* U+39AC */
  0x0000,   /* U+39AD */
  0x0000,   /* U+39AE */
  0x0000,   /* U+39AF */
  0x0000,   /* U+39B0 */
  0x0000,   /* U+39B1 */
  0x0000,   /* U+39B2 */
  0x0000,   /* U+39B3 */
  0x0000,   /* U+39B4 */
  0x0000,   /* U+39B5 */
  0x0000,   /* U+39B6 */
  0x0000,   /* U+39B7 */
  0x0000,   /* U+39B8 */
  0x0000,   /* U+39B9 */
  0x0000,   /* U+39BA */
  0x0000,   /* U+39BB */
  0x0000,   /* U+39BC */
  0x0000,   /* U+39BD */
  0x0000,   /* U+39BE */
  0x0000,   /* U+39BF */
  0x0000,   /* U+39C0 */
  0x0000,   /* U+39C1 */
  0x0000,   /* U+39C2 */
  0x0000,   /* U+39C3 */
  0x0000,   /* U+39C4 */
  0x0000,   /* U+39C5 */
  0x0000,   /* U+39C6 */
  0x0000,   /* U+39C7 */
  0x0000,   /* U+39C8 */
  0x0000,   /* U+39C9 */
  0x0000,   /* U+39CA */
  0x0000,   /* U+39CB */
  0x0000,   /* U+39CC */
  0x0000,   /* U+39CD */
  0x0000,   /* U+39CE */
  0x0000,   /* U+39CF */
  0x0000,   /* U+39D0 */
  0x0000,   /* U+39D1 */
  0x0000,   /* U+39D2 */
  0x0000,   /* U+39D3 */
  0x0000,   /* U+39D4 */
  0x0000,   /* U+39D5 */
  0x0000,   /* U+39D6 */
  0x0000,   /* U+39D7 */
  0x0000,   /* U+39D8 */
  0x0000,   /* U+39D9 */
  0x0000,   /* U+39DA */
  0x0000,   /* U+39DB */
  0x0000,   /* U+39DC */
  0x0000,   /* U+39DD */
  0x0000,   /* U+39DE */
  0x0000,   /* U+39DF */
  0x0000,   /* U+39E0 */
  0x0000,   /* U+39E1 */
  0x0000,   /* U+39E2 */
  0x0000,   /* U+39E3 */
  0x0000,   /* U+39E4 */
  0x0000,   /* U+39E5 */
  0x0000,   /* U+39E6 */
  0x0000,   /* U+39E7 */
  0x0000,   /* U+39E8 */
  0x0000,   /* U+39E9 */
  0x0000,   /* U+39EA */
  0x0000,   /* U+39EB */
  0x0000,   /* U+39EC */
  0x0000,   /* U+39ED */
  0x0000,   /* U+39EE */
  0x0000,   /* U+39EF */
  0x0000,   /* U+39F0 */
  0x0000,   /* U+39F1 */
  0x0000,   /* U+39F2 */
  0x0000,   /* U+39F3 */
  0x0000,   /* U+39F4 */
  0x0000,   /* U+39F5 */
  0x0000,   /* U+39F6 */
  0x0000,   /* U+39F7 */
  0x0000,   /* U+39F8 */
  0x0000,   /* U+39F9 */
  0x0000,   /* U+39FA */
  0x0000,   /* U+39FB */
  0x0000,   /* U+39FC */
  0x0000,   /* U+39FD */
  0x0000,   /* U+39FE */
  0x0000,   /* U+39FF */
};

uint16 zh2_han_p03A[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x2C54,   /* U+3A00 */
  0x2C54,   /* U+3A01 */
  0x2C54,   /* U+3A02 */
  0x2C54,   /* U+3A03 */
  0x2C54,   /* U+3A04 */
  0x2C54,   /* U+3A05 */
  0x2C54,   /* U+3A06 */
  0x2C54,   /* U+3A07 */
  0x5C49,   /* U+3A08 */
  0x2C55,   /* U+3A09 */
  0x2C55,   /* U+3A0A */
  0x2C55,   /* U+3A0B */
  0x2C55,   /* U+3A0C */
  0x2C55,   /* U+3A0D */
  0x2C55,   /* U+3A0E */
  0x2C55,   /* U+3A0F */
  0x2C55,   /* U+3A10 */
  0x2C55,   /* U+3A11 */
  0x2C55,   /* U+3A12 */
  0x2C55,   /* U+3A13 */
  0x2C55,   /* U+3A14 */
  0x2C55,   /* U+3A15 */
  0x2C4D,   /* U+3A16 */
  0x2C55,   /* U+3A17 */
  0x2C55,   /* U+3A18 */
  0x2C4D,   /* U+3A19 */
  0x2C4D,   /* U+3A1A */
  0x2C4D,   /* U+3A1B */
  0x2C4D,   /* U+3A1C */
  0x2C4D,   /* U+3A1D */
  0x2C4D,   /* U+3A1E */
  0x2C4D,   /* U+3A1F */
  0x2C4D,   /* U+3A20 */
  0x2C4D,   /* U+3A21 */
  0x2C4D,   /* U+3A22 */
  0x2C4D,   /* U+3A23 */
  0x2C4D,   /* U+3A24 */
  0x2C4D,   /* U+3A25 */
  0x2C4D,   /* U+3A26 */
  0x2C4D,   /* U+3A27 */
  0x2C4D,   /* U+3A28 */
  0x2C4D,   /* U+3A29 */
  0x2C4D,   /* U+3A2A */
  0x2C4D,   /* U+3A2B */
  0x2C4D,   /* U+3A2C */
  0x2C57,   /* U+3A2D */
  0x2C57,   /* U+3A2E */
  0x2C57,   /* U+3A2F */
  0x2C57,   /* U+3A30 */
  0x2C57,   /* U+3A31 */
  0x2C57,   /* U+3A32 */
  0x2C57,   /* U+3A33 */
  0x2C57,   /* U+3A34 */
  0x2C57,   /* U+3A35 */
  0x2C57,   /* U+3A36 */
  0x2C57,   /* U+3A37 */
  0x2C57,   /* U+3A38 */
  0x2C57,   /* U+3A39 */
  0x2C57,   /* U+3A3A */
  0x2C57,   /* U+3A3B */
  0x2C57,   /* U+3A3C */
  0x2C57,   /* U+3A3D */
  0x5C49,   /* U+3A3E */
  0x2C57,   /* U+3A3F */
  0x5C49,   /* U+3A40 */
  0x5C49,   /* U+3A41 */
  0x5C49,   /* U+3A42 */
  0x2C58,   /* U+3A43 */
  0x2C58,   /* U+3A44 */
  0x2C58,   /* U+3A45 */
  0x2C58,   /* U+3A46 */
  0x2C58,   /* U+3A47 */
  0x2C58,   /* U+3A48 */
  0x2C58,   /* U+3A49 */
  0x2C58,   /* U+3A4A */
  0x2C58,   /* U+3A4B */
  0x2C58,   /* U+3A4C */
  0x2C58,   /* U+3A4D */
  0x2C58,   /* U+3A4E */
  0x2C58,   /* U+3A4F */
  0x2C58,   /* U+3A50 */
  0x2C58,   /* U+3A51 */
  0x2C59,   /* U+3A52 */
  0x2C59,   /* U+3A53 */
  0x2C59,   /* U+3A54 */
  0x2C59,   /* U+3A55 */
  0x2C59,   /* U+3A56 */
  0x2C59,   /* U+3A57 */
  0x2C59,   /* U+3A58 */
  0x2C59,   /* U+3A59 */
  0x2C5A,   /* U+3A5A */
  0x2C5A,   /* U+3A5B */
  0x2C5A,   /* U+3A5C */
  0x2C5A,   /* U+3A5D */
  0x2C5A,   /* U+3A5E */
  0x2C5A,   /* U+3A5F */
  0x2C5B,   /* U+3A60 */
  0x2C5B,   /* U+3A61 */
  0x2C5B,   /* U+3A62 */
  0x2C5B,   /* U+3A63 */
  0x2C5B,   /* U+3A64 */
  0x2C5B,   /* U+3A65 */
  0x2C5B,   /* U+3A66 */
  0x2C5B,   /* U+3A67 */
  0x2C5B,   /* U+3A68 */
  0x2C5B,   /* U+3A69 */
  0x2C5B,   /* U+3A6A */
  0x2C5B,   /* U+3A6B */
  0x2C5C,   /* U+3A6C */
  0x2C5C,   /* U+3A6D */
  0x2C5D,   /* U+3A6E */
  0x2C5D,   /* U+3A6F */
  0x2C5D,   /* U+3A70 */
  0x2C5E,   /* U+3A71 */
  0x2C5E,   /* U+3A72 */
  0x2C5E,   /* U+3A73 */
  0x2C5E,   /* U+3A74 */
  0x2C4E,   /* U+3A75 */
  0x2C4E,   /* U+3A76 */
  0x2C4E,   /* U+3A77 */
  0x2C62,   /* U+3A78 */
  0x2C62,   /* U+3A79 */
  0x2C90,   /* U+3A7A */
  0x2C92,   /* U+3A7B */
  0x2C92,   /* U+3A7C */
  0x2C93,   /* U+3A7D */
  0x2C94,   /* U+3A7E */
  0x2CCF,   /* U+3A7F */
  0x2CCF,   /* U+3A80 */
  0x2CD0,   /* U+3A81 */
  0x2CD0,   /* U+3A82 */
  0x2CD1,   /* U+3A83 */
  0x2CD1,   /* U+3A84 */
  0x2CD1,   /* U+3A85 */
  0x2CD1,   /* U+3A86 */
  0x2CD2,   /* U+3A87 */
  0x2CD2,   /* U+3A88 */
  0x2CD2,   /* U+3A89 */
  0x2CD3,   /* U+3A8A */
  0x2CD3,   /* U+3A8B */
  0x2CD3,   /* U+3A8C */
  0x2CD3,   /* U+3A8D */
  0x2CD3,   /* U+3A8E */
  0x2CD4,   /* U+3A8F */
  0x2CD4,   /* U+3A90 */
  0x2CD4,   /* U+3A91 */
  0x2CD4,   /* U+3A92 */
  0x2CD4,   /* U+3A93 */
  0x2CD4,   /* U+3A94 */
  0x2CD4,   /* U+3A95 */
  0x2CD4,   /* U+3A96 */
  0x2CD4,   /* U+3A97 */
  0x5C49,   /* U+3A98 */
  0x2CD4,   /* U+3A99 */
  0x2CD4,   /* U+3A9A */
  0x2CD5,   /* U+3A9B */
  0x2CD5,   /* U+3A9C */
  0x2CD5,   /* U+3A9D */
  0x2CD5,   /* U+3A9E */
  0x2CD5,   /* U+3A9F */
  0x2CCD,   /* U+3AA0 */
  0x2CCD,   /* U+3AA1 */
  0x2CCD,   /* U+3AA2 */
  0x2CCD,   /* U+3AA3 */
  0x2CD7,   /* U+3AA4 */
  0x2CD7,   /* U+3AA5 */
  0x2CD7,   /* U+3AA6 */
  0x2CD8,   /* U+3AA7 */
  0x2CD8,   /* U+3AA8 */
  0x2CD8,   /* U+3AA9 */
  0x2CD8,   /* U+3AAA */
  0x2CDA,   /* U+3AAB */
  0x2CDA,   /* U+3AAC */
  0x2CDC,   /* U+3AAD */
  0x2CDD,   /* U+3AAE */
  0x2D0F,   /* U+3AAF */
  0x2D12,   /* U+3AB0 */
  0x2D15,   /* U+3AB1 */
  0x5C49,   /* U+3AB2 */
  0x5C49,   /* U+3AB3 */
  0x2D50,   /* U+3AB4 */
  0x2D51,   /* U+3AB5 */
  0x2D52,   /* U+3AB6 */
  0x2D53,   /* U+3AB7 */
  0x2D54,   /* U+3AB8 */
  0x2D57,   /* U+3AB9 */
  0x2D59,   /* U+3ABA */
  0x2D5F,   /* U+3ABB */
  0x2D91,   /* U+3ABC */
  0x2D91,   /* U+3ABD */
  0x2D92,   /* U+3ABE */
  0x5C49,   /* U+3ABF */
  0x2D94,   /* U+3AC0 */
  0x2D8D,   /* U+3AC1 */
  0x2D97,   /* U+3AC2 */
  0x2DCE,   /* U+3AC3 */
  0x2DD0,   /* U+3AC4 */
  0x2DD2,   /* U+3AC5 */
  0x5C49,   /* U+3AC6 */
  0x5C49,   /* U+3AC7 */
  0x5C49,   /* U+3AC8 */
  0x5C49,   /* U+3AC9 */
  0x2DD3,   /* U+3ACA */
  0x2DD3,   /* U+3ACB */
  0x5C49,   /* U+3ACC */
  0x2DD4,   /* U+3ACD */
  0x2DD7,   /* U+3ACE */
  0x2DD7,   /* U+3ACF */
  0x2E4E,   /* U+3AD0 */
  0x2E4E,   /* U+3AD1 */
  0x2E4F,   /* U+3AD2 */
  0x2E4F,   /* U+3AD3 */
  0x2E4F,   /* U+3AD4 */
  0x2E4F,   /* U+3AD5 */
  0x5C49,   /* U+3AD6 */
  0x2E4F,   /* U+3AD7 */
  0x2E50,   /* U+3AD8 */
  0x2E50,   /* U+3AD9 */
  0x2E50,   /* U+3ADA */
  0x2E51,   /* U+3ADB */
  0x2E51,   /* U+3ADC */
  0x2E51,   /* U+3ADD */
  0x2E51,   /* U+3ADE */
  0x2E51,   /* U+3ADF */
  0x2E51,   /* U+3AE0 */
  0x2E51,   /* U+3AE1 */
  0x2E51,   /* U+3AE2 */
  0x2E51,   /* U+3AE3 */
  0x2E51,   /* U+3AE4 */
  0x2E52,   /* U+3AE5 */
  0x2E52,   /* U+3AE6 */
  0x2E52,   /* U+3AE7 */
  0x2E52,   /* U+3AE8 */
  0x2E52,   /* U+3AE9 */
  0x5C49,   /* U+3AEA */
  0x2E52,   /* U+3AEB */
  0x2E52,   /* U+3AEC */
  0x5C49,   /* U+3AED */
  0x5C49,   /* U+3AEE */
  0x2E53,   /* U+3AEF */
  0x2E53,   /* U+3AF0 */
  0x2E53,   /* U+3AF1 */
  0x2E53,   /* U+3AF2 */
  0x2E53,   /* U+3AF3 */
  0x2E53,   /* U+3AF4 */
  0x2E54,   /* U+3AF5 */
  0x2E54,   /* U+3AF6 */
  0x2E54,   /* U+3AF7 */
  0x2E54,   /* U+3AF8 */
  0x2E54,   /* U+3AF9 */
  0x2E54,   /* U+3AFA */
  0x2E54,   /* U+3AFB */
  0x2E54,   /* U+3AFC */
  0x2E54,   /* U+3AFD */
  0x5C49,   /* U+3AFE */
  0x5C49,   /* U+3AFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3A00 */
  0x0020,   /* U+3A01 */
  0x0020,   /* U+3A02 */
  0x0020,   /* U+3A03 */
  0x0020,   /* U+3A04 */
  0x0020,   /* U+3A05 */
  0x0020,   /* U+3A06 */
  0x0020,   /* U+3A07 */
  0x0020,   /* U+3A08 */
  0x0020,   /* U+3A09 */
  0x0020,   /* U+3A0A */
  0x0020,   /* U+3A0B */
  0x0020,   /* U+3A0C */
  0x0020,   /* U+3A0D */
  0x0020,   /* U+3A0E */
  0x0020,   /* U+3A0F */
  0x0020,   /* U+3A10 */
  0x0020,   /* U+3A11 */
  0x0020,   /* U+3A12 */
  0x0020,   /* U+3A13 */
  0x0020,   /* U+3A14 */
  0x0020,   /* U+3A15 */
  0x0020,   /* U+3A16 */
  0x0020,   /* U+3A17 */
  0x0020,   /* U+3A18 */
  0x0020,   /* U+3A19 */
  0x0020,   /* U+3A1A */
  0x0020,   /* U+3A1B */
  0x0020,   /* U+3A1C */
  0x0020,   /* U+3A1D */
  0x0020,   /* U+3A1E */
  0x0020,   /* U+3A1F */
  0x0020,   /* U+3A20 */
  0x0020,   /* U+3A21 */
  0x0020,   /* U+3A22 */
  0x0020,   /* U+3A23 */
  0x0020,   /* U+3A24 */
  0x0020,   /* U+3A25 */
  0x0020,   /* U+3A26 */
  0x0020,   /* U+3A27 */
  0x0020,   /* U+3A28 */
  0x0020,   /* U+3A29 */
  0x0020,   /* U+3A2A */
  0x0020,   /* U+3A2B */
  0x0020,   /* U+3A2C */
  0x0020,   /* U+3A2D */
  0x0020,   /* U+3A2E */
  0x0020,   /* U+3A2F */
  0x0020,   /* U+3A30 */
  0x0020,   /* U+3A31 */
  0x0020,   /* U+3A32 */
  0x0020,   /* U+3A33 */
  0x0020,   /* U+3A34 */
  0x0020,   /* U+3A35 */
  0x0020,   /* U+3A36 */
  0x0020,   /* U+3A37 */
  0x0020,   /* U+3A38 */
  0x0020,   /* U+3A39 */
  0x0020,   /* U+3A3A */
  0x0020,   /* U+3A3B */
  0x0020,   /* U+3A3C */
  0x0020,   /* U+3A3D */
  0x0020,   /* U+3A3E */
  0x0020,   /* U+3A3F */
  0x0020,   /* U+3A40 */
  0x0020,   /* U+3A41 */
  0x0020,   /* U+3A42 */
  0x0020,   /* U+3A43 */
  0x0020,   /* U+3A44 */
  0x0020,   /* U+3A45 */
  0x0020,   /* U+3A46 */
  0x0020,   /* U+3A47 */
  0x0020,   /* U+3A48 */
  0x0020,   /* U+3A49 */
  0x0020,   /* U+3A4A */
  0x0020,   /* U+3A4B */
  0x0020,   /* U+3A4C */
  0x0020,   /* U+3A4D */
  0x0020,   /* U+3A4E */
  0x0020,   /* U+3A4F */
  0x0020,   /* U+3A50 */
  0x0020,   /* U+3A51 */
  0x0020,   /* U+3A52 */
  0x0020,   /* U+3A53 */
  0x0020,   /* U+3A54 */
  0x0020,   /* U+3A55 */
  0x0020,   /* U+3A56 */
  0x0020,   /* U+3A57 */
  0x0020,   /* U+3A58 */
  0x0020,   /* U+3A59 */
  0x0020,   /* U+3A5A */
  0x0020,   /* U+3A5B */
  0x0020,   /* U+3A5C */
  0x0020,   /* U+3A5D */
  0x0020,   /* U+3A5E */
  0x0020,   /* U+3A5F */
  0x0020,   /* U+3A60 */
  0x0020,   /* U+3A61 */
  0x0020,   /* U+3A62 */
  0x0020,   /* U+3A63 */
  0x0020,   /* U+3A64 */
  0x0020,   /* U+3A65 */
  0x0020,   /* U+3A66 */
  0x0020,   /* U+3A67 */
  0x0020,   /* U+3A68 */
  0x0020,   /* U+3A69 */
  0x0020,   /* U+3A6A */
  0x0020,   /* U+3A6B */
  0x0020,   /* U+3A6C */
  0x0020,   /* U+3A6D */
  0x0020,   /* U+3A6E */
  0x0020,   /* U+3A6F */
  0x0020,   /* U+3A70 */
  0x0020,   /* U+3A71 */
  0x0020,   /* U+3A72 */
  0x0020,   /* U+3A73 */
  0x0020,   /* U+3A74 */
  0x0020,   /* U+3A75 */
  0x0020,   /* U+3A76 */
  0x0020,   /* U+3A77 */
  0x0020,   /* U+3A78 */
  0x0020,   /* U+3A79 */
  0x0020,   /* U+3A7A */
  0x0020,   /* U+3A7B */
  0x0020,   /* U+3A7C */
  0x0020,   /* U+3A7D */
  0x0020,   /* U+3A7E */
  0x0020,   /* U+3A7F */
  0x0020,   /* U+3A80 */
  0x0020,   /* U+3A81 */
  0x0020,   /* U+3A82 */
  0x0020,   /* U+3A83 */
  0x0020,   /* U+3A84 */
  0x0020,   /* U+3A85 */
  0x0020,   /* U+3A86 */
  0x0020,   /* U+3A87 */
  0x0020,   /* U+3A88 */
  0x0020,   /* U+3A89 */
  0x0020,   /* U+3A8A */
  0x0020,   /* U+3A8B */
  0x0020,   /* U+3A8C */
  0x0020,   /* U+3A8D */
  0x0020,   /* U+3A8E */
  0x0020,   /* U+3A8F */
  0x0020,   /* U+3A90 */
  0x0020,   /* U+3A91 */
  0x0020,   /* U+3A92 */
  0x0020,   /* U+3A93 */
  0x0020,   /* U+3A94 */
  0x0020,   /* U+3A95 */
  0x0020,   /* U+3A96 */
  0x0020,   /* U+3A97 */
  0x0020,   /* U+3A98 */
  0x0020,   /* U+3A99 */
  0x0020,   /* U+3A9A */
  0x0020,   /* U+3A9B */
  0x0020,   /* U+3A9C */
  0x0020,   /* U+3A9D */
  0x0020,   /* U+3A9E */
  0x0020,   /* U+3A9F */
  0x0020,   /* U+3AA0 */
  0x0020,   /* U+3AA1 */
  0x0020,   /* U+3AA2 */
  0x0020,   /* U+3AA3 */
  0x0020,   /* U+3AA4 */
  0x0020,   /* U+3AA5 */
  0x0020,   /* U+3AA6 */
  0x0020,   /* U+3AA7 */
  0x0020,   /* U+3AA8 */
  0x0020,   /* U+3AA9 */
  0x0020,   /* U+3AAA */
  0x0020,   /* U+3AAB */
  0x0020,   /* U+3AAC */
  0x0020,   /* U+3AAD */
  0x0020,   /* U+3AAE */
  0x0020,   /* U+3AAF */
  0x0020,   /* U+3AB0 */
  0x0020,   /* U+3AB1 */
  0x0020,   /* U+3AB2 */
  0x0020,   /* U+3AB3 */
  0x0020,   /* U+3AB4 */
  0x0020,   /* U+3AB5 */
  0x0020,   /* U+3AB6 */
  0x0020,   /* U+3AB7 */
  0x0020,   /* U+3AB8 */
  0x0020,   /* U+3AB9 */
  0x0020,   /* U+3ABA */
  0x0020,   /* U+3ABB */
  0x0020,   /* U+3ABC */
  0x0020,   /* U+3ABD */
  0x0020,   /* U+3ABE */
  0x0020,   /* U+3ABF */
  0x0020,   /* U+3AC0 */
  0x0020,   /* U+3AC1 */
  0x0020,   /* U+3AC2 */
  0x0020,   /* U+3AC3 */
  0x0020,   /* U+3AC4 */
  0x0020,   /* U+3AC5 */
  0x0020,   /* U+3AC6 */
  0x0020,   /* U+3AC7 */
  0x0020,   /* U+3AC8 */
  0x0020,   /* U+3AC9 */
  0x0020,   /* U+3ACA */
  0x0020,   /* U+3ACB */
  0x0020,   /* U+3ACC */
  0x0020,   /* U+3ACD */
  0x0020,   /* U+3ACE */
  0x0020,   /* U+3ACF */
  0x0020,   /* U+3AD0 */
  0x0020,   /* U+3AD1 */
  0x0020,   /* U+3AD2 */
  0x0020,   /* U+3AD3 */
  0x0020,   /* U+3AD4 */
  0x0020,   /* U+3AD5 */
  0x0020,   /* U+3AD6 */
  0x0020,   /* U+3AD7 */
  0x0020,   /* U+3AD8 */
  0x0020,   /* U+3AD9 */
  0x0020,   /* U+3ADA */
  0x0020,   /* U+3ADB */
  0x0020,   /* U+3ADC */
  0x0020,   /* U+3ADD */
  0x0020,   /* U+3ADE */
  0x0020,   /* U+3ADF */
  0x0020,   /* U+3AE0 */
  0x0020,   /* U+3AE1 */
  0x0020,   /* U+3AE2 */
  0x0020,   /* U+3AE3 */
  0x0020,   /* U+3AE4 */
  0x0020,   /* U+3AE5 */
  0x0020,   /* U+3AE6 */
  0x0020,   /* U+3AE7 */
  0x0020,   /* U+3AE8 */
  0x0020,   /* U+3AE9 */
  0x0020,   /* U+3AEA */
  0x0020,   /* U+3AEB */
  0x0020,   /* U+3AEC */
  0x0020,   /* U+3AED */
  0x0020,   /* U+3AEE */
  0x0020,   /* U+3AEF */
  0x0020,   /* U+3AF0 */
  0x0020,   /* U+3AF1 */
  0x0020,   /* U+3AF2 */
  0x0020,   /* U+3AF3 */
  0x0020,   /* U+3AF4 */
  0x0020,   /* U+3AF5 */
  0x0020,   /* U+3AF6 */
  0x0020,   /* U+3AF7 */
  0x0020,   /* U+3AF8 */
  0x0020,   /* U+3AF9 */
  0x0020,   /* U+3AFA */
  0x0020,   /* U+3AFB */
  0x0020,   /* U+3AFC */
  0x0020,   /* U+3AFD */
  0x0020,   /* U+3AFE */
  0x0020,   /* U+3AFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3A00 */
  0x0002,   /* U+3A01 */
  0x0002,   /* U+3A02 */
  0x0002,   /* U+3A03 */
  0x0002,   /* U+3A04 */
  0x0002,   /* U+3A05 */
  0x0002,   /* U+3A06 */
  0x0002,   /* U+3A07 */
  0x0002,   /* U+3A08 */
  0x0002,   /* U+3A09 */
  0x0002,   /* U+3A0A */
  0x0002,   /* U+3A0B */
  0x0002,   /* U+3A0C */
  0x0002,   /* U+3A0D */
  0x0002,   /* U+3A0E */
  0x0002,   /* U+3A0F */
  0x0002,   /* U+3A10 */
  0x0002,   /* U+3A11 */
  0x0002,   /* U+3A12 */
  0x0002,   /* U+3A13 */
  0x0002,   /* U+3A14 */
  0x0002,   /* U+3A15 */
  0x0002,   /* U+3A16 */
  0x0002,   /* U+3A17 */
  0x0002,   /* U+3A18 */
  0x0002,   /* U+3A19 */
  0x0002,   /* U+3A1A */
  0x0002,   /* U+3A1B */
  0x0002,   /* U+3A1C */
  0x0002,   /* U+3A1D */
  0x0002,   /* U+3A1E */
  0x0002,   /* U+3A1F */
  0x0002,   /* U+3A20 */
  0x0002,   /* U+3A21 */
  0x0002,   /* U+3A22 */
  0x0002,   /* U+3A23 */
  0x0002,   /* U+3A24 */
  0x0002,   /* U+3A25 */
  0x0002,   /* U+3A26 */
  0x0002,   /* U+3A27 */
  0x0002,   /* U+3A28 */
  0x0002,   /* U+3A29 */
  0x0002,   /* U+3A2A */
  0x0002,   /* U+3A2B */
  0x0002,   /* U+3A2C */
  0x0002,   /* U+3A2D */
  0x0002,   /* U+3A2E */
  0x0002,   /* U+3A2F */
  0x0002,   /* U+3A30 */
  0x0002,   /* U+3A31 */
  0x0002,   /* U+3A32 */
  0x0002,   /* U+3A33 */
  0x0002,   /* U+3A34 */
  0x0002,   /* U+3A35 */
  0x0002,   /* U+3A36 */
  0x0002,   /* U+3A37 */
  0x0002,   /* U+3A38 */
  0x0002,   /* U+3A39 */
  0x0002,   /* U+3A3A */
  0x0002,   /* U+3A3B */
  0x0002,   /* U+3A3C */
  0x0002,   /* U+3A3D */
  0x0002,   /* U+3A3E */
  0x0002,   /* U+3A3F */
  0x0002,   /* U+3A40 */
  0x0002,   /* U+3A41 */
  0x0002,   /* U+3A42 */
  0x0002,   /* U+3A43 */
  0x0002,   /* U+3A44 */
  0x0002,   /* U+3A45 */
  0x0002,   /* U+3A46 */
  0x0002,   /* U+3A47 */
  0x0002,   /* U+3A48 */
  0x0002,   /* U+3A49 */
  0x0002,   /* U+3A4A */
  0x0002,   /* U+3A4B */
  0x0002,   /* U+3A4C */
  0x0002,   /* U+3A4D */
  0x0002,   /* U+3A4E */
  0x0002,   /* U+3A4F */
  0x0002,   /* U+3A50 */
  0x0002,   /* U+3A51 */
  0x0002,   /* U+3A52 */
  0x0002,   /* U+3A53 */
  0x0002,   /* U+3A54 */
  0x0002,   /* U+3A55 */
  0x0002,   /* U+3A56 */
  0x0002,   /* U+3A57 */
  0x0002,   /* U+3A58 */
  0x0002,   /* U+3A59 */
  0x0002,   /* U+3A5A */
  0x0002,   /* U+3A5B */
  0x0002,   /* U+3A5C */
  0x0002,   /* U+3A5D */
  0x0002,   /* U+3A5E */
  0x0002,   /* U+3A5F */
  0x0002,   /* U+3A60 */
  0x0002,   /* U+3A61 */
  0x0002,   /* U+3A62 */
  0x0002,   /* U+3A63 */
  0x0002,   /* U+3A64 */
  0x0002,   /* U+3A65 */
  0x0002,   /* U+3A66 */
  0x0002,   /* U+3A67 */
  0x0002,   /* U+3A68 */
  0x0002,   /* U+3A69 */
  0x0002,   /* U+3A6A */
  0x0002,   /* U+3A6B */
  0x0002,   /* U+3A6C */
  0x0002,   /* U+3A6D */
  0x0002,   /* U+3A6E */
  0x0002,   /* U+3A6F */
  0x0002,   /* U+3A70 */
  0x0002,   /* U+3A71 */
  0x0002,   /* U+3A72 */
  0x0002,   /* U+3A73 */
  0x0002,   /* U+3A74 */
  0x0002,   /* U+3A75 */
  0x0002,   /* U+3A76 */
  0x0002,   /* U+3A77 */
  0x0002,   /* U+3A78 */
  0x0002,   /* U+3A79 */
  0x0002,   /* U+3A7A */
  0x0002,   /* U+3A7B */
  0x0002,   /* U+3A7C */
  0x0002,   /* U+3A7D */
  0x0002,   /* U+3A7E */
  0x0002,   /* U+3A7F */
  0x0002,   /* U+3A80 */
  0x0002,   /* U+3A81 */
  0x0002,   /* U+3A82 */
  0x0002,   /* U+3A83 */
  0x0002,   /* U+3A84 */
  0x0002,   /* U+3A85 */
  0x0002,   /* U+3A86 */
  0x0002,   /* U+3A87 */
  0x0002,   /* U+3A88 */
  0x0002,   /* U+3A89 */
  0x0002,   /* U+3A8A */
  0x0002,   /* U+3A8B */
  0x0002,   /* U+3A8C */
  0x0002,   /* U+3A8D */
  0x0002,   /* U+3A8E */
  0x0002,   /* U+3A8F */
  0x0002,   /* U+3A90 */
  0x0002,   /* U+3A91 */
  0x0002,   /* U+3A92 */
  0x0002,   /* U+3A93 */
  0x0002,   /* U+3A94 */
  0x0002,   /* U+3A95 */
  0x0002,   /* U+3A96 */
  0x0002,   /* U+3A97 */
  0x0002,   /* U+3A98 */
  0x0002,   /* U+3A99 */
  0x0002,   /* U+3A9A */
  0x0002,   /* U+3A9B */
  0x0002,   /* U+3A9C */
  0x0002,   /* U+3A9D */
  0x0002,   /* U+3A9E */
  0x0002,   /* U+3A9F */
  0x0002,   /* U+3AA0 */
  0x0002,   /* U+3AA1 */
  0x0002,   /* U+3AA2 */
  0x0002,   /* U+3AA3 */
  0x0002,   /* U+3AA4 */
  0x0002,   /* U+3AA5 */
  0x0002,   /* U+3AA6 */
  0x0002,   /* U+3AA7 */
  0x0002,   /* U+3AA8 */
  0x0002,   /* U+3AA9 */
  0x0002,   /* U+3AAA */
  0x0002,   /* U+3AAB */
  0x0002,   /* U+3AAC */
  0x0002,   /* U+3AAD */
  0x0002,   /* U+3AAE */
  0x0002,   /* U+3AAF */
  0x0002,   /* U+3AB0 */
  0x0002,   /* U+3AB1 */
  0x0002,   /* U+3AB2 */
  0x0002,   /* U+3AB3 */
  0x0002,   /* U+3AB4 */
  0x0002,   /* U+3AB5 */
  0x0002,   /* U+3AB6 */
  0x0002,   /* U+3AB7 */
  0x0002,   /* U+3AB8 */
  0x0002,   /* U+3AB9 */
  0x0002,   /* U+3ABA */
  0x0002,   /* U+3ABB */
  0x0002,   /* U+3ABC */
  0x0002,   /* U+3ABD */
  0x0002,   /* U+3ABE */
  0x0002,   /* U+3ABF */
  0x0002,   /* U+3AC0 */
  0x0002,   /* U+3AC1 */
  0x0002,   /* U+3AC2 */
  0x0002,   /* U+3AC3 */
  0x0002,   /* U+3AC4 */
  0x0002,   /* U+3AC5 */
  0x0002,   /* U+3AC6 */
  0x0002,   /* U+3AC7 */
  0x0002,   /* U+3AC8 */
  0x0002,   /* U+3AC9 */
  0x0002,   /* U+3ACA */
  0x0002,   /* U+3ACB */
  0x0002,   /* U+3ACC */
  0x0002,   /* U+3ACD */
  0x0002,   /* U+3ACE */
  0x0002,   /* U+3ACF */
  0x0002,   /* U+3AD0 */
  0x0002,   /* U+3AD1 */
  0x0002,   /* U+3AD2 */
  0x0002,   /* U+3AD3 */
  0x0002,   /* U+3AD4 */
  0x0002,   /* U+3AD5 */
  0x0002,   /* U+3AD6 */
  0x0002,   /* U+3AD7 */
  0x0002,   /* U+3AD8 */
  0x0002,   /* U+3AD9 */
  0x0002,   /* U+3ADA */
  0x0002,   /* U+3ADB */
  0x0002,   /* U+3ADC */
  0x0002,   /* U+3ADD */
  0x0002,   /* U+3ADE */
  0x0002,   /* U+3ADF */
  0x0002,   /* U+3AE0 */
  0x0002,   /* U+3AE1 */
  0x0002,   /* U+3AE2 */
  0x0002,   /* U+3AE3 */
  0x0002,   /* U+3AE4 */
  0x0002,   /* U+3AE5 */
  0x0002,   /* U+3AE6 */
  0x0002,   /* U+3AE7 */
  0x0002,   /* U+3AE8 */
  0x0002,   /* U+3AE9 */
  0x0002,   /* U+3AEA */
  0x0002,   /* U+3AEB */
  0x0002,   /* U+3AEC */
  0x0002,   /* U+3AED */
  0x0002,   /* U+3AEE */
  0x0002,   /* U+3AEF */
  0x0002,   /* U+3AF0 */
  0x0002,   /* U+3AF1 */
  0x0002,   /* U+3AF2 */
  0x0002,   /* U+3AF3 */
  0x0002,   /* U+3AF4 */
  0x0002,   /* U+3AF5 */
  0x0002,   /* U+3AF6 */
  0x0002,   /* U+3AF7 */
  0x0002,   /* U+3AF8 */
  0x0002,   /* U+3AF9 */
  0x0002,   /* U+3AFA */
  0x0002,   /* U+3AFB */
  0x0002,   /* U+3AFC */
  0x0002,   /* U+3AFD */
  0x0002,   /* U+3AFE */
  0x0002,   /* U+3AFF */

  /* Primary weight 2 for each character. */
  0x8007,   /* U+3A00 */
  0x8008,   /* U+3A01 */
  0x8009,   /* U+3A02 */
  0x800A,   /* U+3A03 */
  0x800B,   /* U+3A04 */
  0x800C,   /* U+3A05 */
  0x800D,   /* U+3A06 */
  0x800E,   /* U+3A07 */
  0xBA08,   /* U+3A08 */
  0x8000,   /* U+3A09 */
  0x8001,   /* U+3A0A */
  0x8002,   /* U+3A0B */
  0x8003,   /* U+3A0C */
  0x8004,   /* U+3A0D */
  0x8005,   /* U+3A0E */
  0x8006,   /* U+3A0F */
  0x8007,   /* U+3A10 */
  0x8008,   /* U+3A11 */
  0x8009,   /* U+3A12 */
  0x800A,   /* U+3A13 */
  0x800B,   /* U+3A14 */
  0x800C,   /* U+3A15 */
  0x8000,   /* U+3A16 */
  0x800D,   /* U+3A17 */
  0x800E,   /* U+3A18 */
  0x8001,   /* U+3A19 */
  0x8002,   /* U+3A1A */
  0x8003,   /* U+3A1B */
  0x8004,   /* U+3A1C */
  0x8005,   /* U+3A1D */
  0x8006,   /* U+3A1E */
  0x8007,   /* U+3A1F */
  0x8008,   /* U+3A20 */
  0x8009,   /* U+3A21 */
  0x800A,   /* U+3A22 */
  0x800B,   /* U+3A23 */
  0x800C,   /* U+3A24 */
  0x800D,   /* U+3A25 */
  0x800E,   /* U+3A26 */
  0x800F,   /* U+3A27 */
  0x8010,   /* U+3A28 */
  0x8011,   /* U+3A29 */
  0x8012,   /* U+3A2A */
  0x8013,   /* U+3A2B */
  0x8014,   /* U+3A2C */
  0x8000,   /* U+3A2D */
  0x8001,   /* U+3A2E */
  0x8002,   /* U+3A2F */
  0x8003,   /* U+3A30 */
  0x8004,   /* U+3A31 */
  0x8005,   /* U+3A32 */
  0x8006,   /* U+3A33 */
  0x8007,   /* U+3A34 */
  0x8008,   /* U+3A35 */
  0x8009,   /* U+3A36 */
  0x800A,   /* U+3A37 */
  0x800B,   /* U+3A38 */
  0x800C,   /* U+3A39 */
  0x800D,   /* U+3A3A */
  0x800E,   /* U+3A3B */
  0x800F,   /* U+3A3C */
  0x8010,   /* U+3A3D */
  0xBA3E,   /* U+3A3E */
  0x8011,   /* U+3A3F */
  0xBA40,   /* U+3A40 */
  0xBA41,   /* U+3A41 */
  0xBA42,   /* U+3A42 */
  0x8000,   /* U+3A43 */
  0x8001,   /* U+3A44 */
  0x8002,   /* U+3A45 */
  0x8003,   /* U+3A46 */
  0x8004,   /* U+3A47 */
  0x8005,   /* U+3A48 */
  0x8006,   /* U+3A49 */
  0x8007,   /* U+3A4A */
  0x8008,   /* U+3A4B */
  0x8009,   /* U+3A4C */
  0x800A,   /* U+3A4D */
  0x800B,   /* U+3A4E */
  0x800C,   /* U+3A4F */
  0x800D,   /* U+3A50 */
  0x800E,   /* U+3A51 */
  0x8000,   /* U+3A52 */
  0x8001,   /* U+3A53 */
  0x8002,   /* U+3A54 */
  0x8003,   /* U+3A55 */
  0x8004,   /* U+3A56 */
  0x8005,   /* U+3A57 */
  0x8006,   /* U+3A58 */
  0x8007,   /* U+3A59 */
  0x8000,   /* U+3A5A */
  0x8001,   /* U+3A5B */
  0x8002,   /* U+3A5C */
  0x8003,   /* U+3A5D */
  0x8004,   /* U+3A5E */
  0x8005,   /* U+3A5F */
  0x8000,   /* U+3A60 */
  0x8001,   /* U+3A61 */
  0x8002,   /* U+3A62 */
  0x8003,   /* U+3A63 */
  0x8004,   /* U+3A64 */
  0x8005,   /* U+3A65 */
  0x8006,   /* U+3A66 */
  0x8007,   /* U+3A67 */
  0x8008,   /* U+3A68 */
  0x8009,   /* U+3A69 */
  0x800A,   /* U+3A6A */
  0x800B,   /* U+3A6B */
  0x8000,   /* U+3A6C */
  0x8001,   /* U+3A6D */
  0x8000,   /* U+3A6E */
  0x8001,   /* U+3A6F */
  0x8002,   /* U+3A70 */
  0x8000,   /* U+3A71 */
  0x8001,   /* U+3A72 */
  0x8002,   /* U+3A73 */
  0x8003,   /* U+3A74 */
  0x8003,   /* U+3A75 */
  0x8004,   /* U+3A76 */
  0x8005,   /* U+3A77 */
  0x8000,   /* U+3A78 */
  0x8001,   /* U+3A79 */
  0x8000,   /* U+3A7A */
  0x8000,   /* U+3A7B */
  0x8001,   /* U+3A7C */
  0x8000,   /* U+3A7D */
  0x8000,   /* U+3A7E */
  0x8000,   /* U+3A7F */
  0x8001,   /* U+3A80 */
  0x8000,   /* U+3A81 */
  0x8001,   /* U+3A82 */
  0x8000,   /* U+3A83 */
  0x8001,   /* U+3A84 */
  0x8002,   /* U+3A85 */
  0x8003,   /* U+3A86 */
  0x8000,   /* U+3A87 */
  0x8001,   /* U+3A88 */
  0x8002,   /* U+3A89 */
  0x8000,   /* U+3A8A */
  0x8001,   /* U+3A8B */
  0x8002,   /* U+3A8C */
  0x8003,   /* U+3A8D */
  0x8004,   /* U+3A8E */
  0x8000,   /* U+3A8F */
  0x8001,   /* U+3A90 */
  0x8002,   /* U+3A91 */
  0x8003,   /* U+3A92 */
  0x8004,   /* U+3A93 */
  0x8005,   /* U+3A94 */
  0x8006,   /* U+3A95 */
  0x8007,   /* U+3A96 */
  0x8008,   /* U+3A97 */
  0xBA98,   /* U+3A98 */
  0x8009,   /* U+3A99 */
  0x800A,   /* U+3A9A */
  0x8000,   /* U+3A9B */
  0x8001,   /* U+3A9C */
  0x8002,   /* U+3A9D */
  0x8003,   /* U+3A9E */
  0x8004,   /* U+3A9F */
  0x8000,   /* U+3AA0 */
  0x8001,   /* U+3AA1 */
  0x8002,   /* U+3AA2 */
  0x8003,   /* U+3AA3 */
  0x8000,   /* U+3AA4 */
  0x8001,   /* U+3AA5 */
  0x8002,   /* U+3AA6 */
  0x8000,   /* U+3AA7 */
  0x8001,   /* U+3AA8 */
  0x8002,   /* U+3AA9 */
  0x8003,   /* U+3AAA */
  0x8000,   /* U+3AAB */
  0x8001,   /* U+3AAC */
  0x8000,   /* U+3AAD */
  0x8000,   /* U+3AAE */
  0x8000,   /* U+3AAF */
  0x8000,   /* U+3AB0 */
  0x8000,   /* U+3AB1 */
  0xBAB2,   /* U+3AB2 */
  0xBAB3,   /* U+3AB3 */
  0x8000,   /* U+3AB4 */
  0x8000,   /* U+3AB5 */
  0x8000,   /* U+3AB6 */
  0x8000,   /* U+3AB7 */
  0x8000,   /* U+3AB8 */
  0x8000,   /* U+3AB9 */
  0x8000,   /* U+3ABA */
  0x8000,   /* U+3ABB */
  0x8000,   /* U+3ABC */
  0x8001,   /* U+3ABD */
  0x8000,   /* U+3ABE */
  0xBABF,   /* U+3ABF */
  0x8000,   /* U+3AC0 */
  0x8000,   /* U+3AC1 */
  0x8000,   /* U+3AC2 */
  0x8000,   /* U+3AC3 */
  0x8000,   /* U+3AC4 */
  0x8000,   /* U+3AC5 */
  0xBAC6,   /* U+3AC6 */
  0xBAC7,   /* U+3AC7 */
  0xBAC8,   /* U+3AC8 */
  0xBAC9,   /* U+3AC9 */
  0x8000,   /* U+3ACA */
  0x8001,   /* U+3ACB */
  0xBACC,   /* U+3ACC */
  0x8000,   /* U+3ACD */
  0x8000,   /* U+3ACE */
  0x8001,   /* U+3ACF */
  0x8000,   /* U+3AD0 */
  0x8001,   /* U+3AD1 */
  0x8000,   /* U+3AD2 */
  0x8001,   /* U+3AD3 */
  0x8002,   /* U+3AD4 */
  0x8003,   /* U+3AD5 */
  0xBAD6,   /* U+3AD6 */
  0x8004,   /* U+3AD7 */
  0x8000,   /* U+3AD8 */
  0x8001,   /* U+3AD9 */
  0x8002,   /* U+3ADA */
  0x8000,   /* U+3ADB */
  0x8001,   /* U+3ADC */
  0x8002,   /* U+3ADD */
  0x8003,   /* U+3ADE */
  0x8004,   /* U+3ADF */
  0x8005,   /* U+3AE0 */
  0x8006,   /* U+3AE1 */
  0x8007,   /* U+3AE2 */
  0x8008,   /* U+3AE3 */
  0x8009,   /* U+3AE4 */
  0x8000,   /* U+3AE5 */
  0x8001,   /* U+3AE6 */
  0x8002,   /* U+3AE7 */
  0x8003,   /* U+3AE8 */
  0x8004,   /* U+3AE9 */
  0xBAEA,   /* U+3AEA */
  0x8005,   /* U+3AEB */
  0x8006,   /* U+3AEC */
  0xBAED,   /* U+3AED */
  0xBAEE,   /* U+3AEE */
  0x8000,   /* U+3AEF */
  0x8001,   /* U+3AF0 */
  0x8002,   /* U+3AF1 */
  0x8003,   /* U+3AF2 */
  0x8004,   /* U+3AF3 */
  0x8005,   /* U+3AF4 */
  0x8000,   /* U+3AF5 */
  0x8001,   /* U+3AF6 */
  0x8002,   /* U+3AF7 */
  0x8003,   /* U+3AF8 */
  0x8004,   /* U+3AF9 */
  0x8005,   /* U+3AFA */
  0x8006,   /* U+3AFB */
  0x8007,   /* U+3AFC */
  0x8008,   /* U+3AFD */
  0xBAFE,   /* U+3AFE */
  0xBAFF,   /* U+3AFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3A00 */
  0x0000,   /* U+3A01 */
  0x0000,   /* U+3A02 */
  0x0000,   /* U+3A03 */
  0x0000,   /* U+3A04 */
  0x0000,   /* U+3A05 */
  0x0000,   /* U+3A06 */
  0x0000,   /* U+3A07 */
  0x0000,   /* U+3A08 */
  0x0000,   /* U+3A09 */
  0x0000,   /* U+3A0A */
  0x0000,   /* U+3A0B */
  0x0000,   /* U+3A0C */
  0x0000,   /* U+3A0D */
  0x0000,   /* U+3A0E */
  0x0000,   /* U+3A0F */
  0x0000,   /* U+3A10 */
  0x0000,   /* U+3A11 */
  0x0000,   /* U+3A12 */
  0x0000,   /* U+3A13 */
  0x0000,   /* U+3A14 */
  0x0000,   /* U+3A15 */
  0x0000,   /* U+3A16 */
  0x0000,   /* U+3A17 */
  0x0000,   /* U+3A18 */
  0x0000,   /* U+3A19 */
  0x0000,   /* U+3A1A */
  0x0000,   /* U+3A1B */
  0x0000,   /* U+3A1C */
  0x0000,   /* U+3A1D */
  0x0000,   /* U+3A1E */
  0x0000,   /* U+3A1F */
  0x0000,   /* U+3A20 */
  0x0000,   /* U+3A21 */
  0x0000,   /* U+3A22 */
  0x0000,   /* U+3A23 */
  0x0000,   /* U+3A24 */
  0x0000,   /* U+3A25 */
  0x0000,   /* U+3A26 */
  0x0000,   /* U+3A27 */
  0x0000,   /* U+3A28 */
  0x0000,   /* U+3A29 */
  0x0000,   /* U+3A2A */
  0x0000,   /* U+3A2B */
  0x0000,   /* U+3A2C */
  0x0000,   /* U+3A2D */
  0x0000,   /* U+3A2E */
  0x0000,   /* U+3A2F */
  0x0000,   /* U+3A30 */
  0x0000,   /* U+3A31 */
  0x0000,   /* U+3A32 */
  0x0000,   /* U+3A33 */
  0x0000,   /* U+3A34 */
  0x0000,   /* U+3A35 */
  0x0000,   /* U+3A36 */
  0x0000,   /* U+3A37 */
  0x0000,   /* U+3A38 */
  0x0000,   /* U+3A39 */
  0x0000,   /* U+3A3A */
  0x0000,   /* U+3A3B */
  0x0000,   /* U+3A3C */
  0x0000,   /* U+3A3D */
  0x0000,   /* U+3A3E */
  0x0000,   /* U+3A3F */
  0x0000,   /* U+3A40 */
  0x0000,   /* U+3A41 */
  0x0000,   /* U+3A42 */
  0x0000,   /* U+3A43 */
  0x0000,   /* U+3A44 */
  0x0000,   /* U+3A45 */
  0x0000,   /* U+3A46 */
  0x0000,   /* U+3A47 */
  0x0000,   /* U+3A48 */
  0x0000,   /* U+3A49 */
  0x0000,   /* U+3A4A */
  0x0000,   /* U+3A4B */
  0x0000,   /* U+3A4C */
  0x0000,   /* U+3A4D */
  0x0000,   /* U+3A4E */
  0x0000,   /* U+3A4F */
  0x0000,   /* U+3A50 */
  0x0000,   /* U+3A51 */
  0x0000,   /* U+3A52 */
  0x0000,   /* U+3A53 */
  0x0000,   /* U+3A54 */
  0x0000,   /* U+3A55 */
  0x0000,   /* U+3A56 */
  0x0000,   /* U+3A57 */
  0x0000,   /* U+3A58 */
  0x0000,   /* U+3A59 */
  0x0000,   /* U+3A5A */
  0x0000,   /* U+3A5B */
  0x0000,   /* U+3A5C */
  0x0000,   /* U+3A5D */
  0x0000,   /* U+3A5E */
  0x0000,   /* U+3A5F */
  0x0000,   /* U+3A60 */
  0x0000,   /* U+3A61 */
  0x0000,   /* U+3A62 */
  0x0000,   /* U+3A63 */
  0x0000,   /* U+3A64 */
  0x0000,   /* U+3A65 */
  0x0000,   /* U+3A66 */
  0x0000,   /* U+3A67 */
  0x0000,   /* U+3A68 */
  0x0000,   /* U+3A69 */
  0x0000,   /* U+3A6A */
  0x0000,   /* U+3A6B */
  0x0000,   /* U+3A6C */
  0x0000,   /* U+3A6D */
  0x0000,   /* U+3A6E */
  0x0000,   /* U+3A6F */
  0x0000,   /* U+3A70 */
  0x0000,   /* U+3A71 */
  0x0000,   /* U+3A72 */
  0x0000,   /* U+3A73 */
  0x0000,   /* U+3A74 */
  0x0000,   /* U+3A75 */
  0x0000,   /* U+3A76 */
  0x0000,   /* U+3A77 */
  0x0000,   /* U+3A78 */
  0x0000,   /* U+3A79 */
  0x0000,   /* U+3A7A */
  0x0000,   /* U+3A7B */
  0x0000,   /* U+3A7C */
  0x0000,   /* U+3A7D */
  0x0000,   /* U+3A7E */
  0x0000,   /* U+3A7F */
  0x0000,   /* U+3A80 */
  0x0000,   /* U+3A81 */
  0x0000,   /* U+3A82 */
  0x0000,   /* U+3A83 */
  0x0000,   /* U+3A84 */
  0x0000,   /* U+3A85 */
  0x0000,   /* U+3A86 */
  0x0000,   /* U+3A87 */
  0x0000,   /* U+3A88 */
  0x0000,   /* U+3A89 */
  0x0000,   /* U+3A8A */
  0x0000,   /* U+3A8B */
  0x0000,   /* U+3A8C */
  0x0000,   /* U+3A8D */
  0x0000,   /* U+3A8E */
  0x0000,   /* U+3A8F */
  0x0000,   /* U+3A90 */
  0x0000,   /* U+3A91 */
  0x0000,   /* U+3A92 */
  0x0000,   /* U+3A93 */
  0x0000,   /* U+3A94 */
  0x0000,   /* U+3A95 */
  0x0000,   /* U+3A96 */
  0x0000,   /* U+3A97 */
  0x0000,   /* U+3A98 */
  0x0000,   /* U+3A99 */
  0x0000,   /* U+3A9A */
  0x0000,   /* U+3A9B */
  0x0000,   /* U+3A9C */
  0x0000,   /* U+3A9D */
  0x0000,   /* U+3A9E */
  0x0000,   /* U+3A9F */
  0x0000,   /* U+3AA0 */
  0x0000,   /* U+3AA1 */
  0x0000,   /* U+3AA2 */
  0x0000,   /* U+3AA3 */
  0x0000,   /* U+3AA4 */
  0x0000,   /* U+3AA5 */
  0x0000,   /* U+3AA6 */
  0x0000,   /* U+3AA7 */
  0x0000,   /* U+3AA8 */
  0x0000,   /* U+3AA9 */
  0x0000,   /* U+3AAA */
  0x0000,   /* U+3AAB */
  0x0000,   /* U+3AAC */
  0x0000,   /* U+3AAD */
  0x0000,   /* U+3AAE */
  0x0000,   /* U+3AAF */
  0x0000,   /* U+3AB0 */
  0x0000,   /* U+3AB1 */
  0x0000,   /* U+3AB2 */
  0x0000,   /* U+3AB3 */
  0x0000,   /* U+3AB4 */
  0x0000,   /* U+3AB5 */
  0x0000,   /* U+3AB6 */
  0x0000,   /* U+3AB7 */
  0x0000,   /* U+3AB8 */
  0x0000,   /* U+3AB9 */
  0x0000,   /* U+3ABA */
  0x0000,   /* U+3ABB */
  0x0000,   /* U+3ABC */
  0x0000,   /* U+3ABD */
  0x0000,   /* U+3ABE */
  0x0000,   /* U+3ABF */
  0x0000,   /* U+3AC0 */
  0x0000,   /* U+3AC1 */
  0x0000,   /* U+3AC2 */
  0x0000,   /* U+3AC3 */
  0x0000,   /* U+3AC4 */
  0x0000,   /* U+3AC5 */
  0x0000,   /* U+3AC6 */
  0x0000,   /* U+3AC7 */
  0x0000,   /* U+3AC8 */
  0x0000,   /* U+3AC9 */
  0x0000,   /* U+3ACA */
  0x0000,   /* U+3ACB */
  0x0000,   /* U+3ACC */
  0x0000,   /* U+3ACD */
  0x0000,   /* U+3ACE */
  0x0000,   /* U+3ACF */
  0x0000,   /* U+3AD0 */
  0x0000,   /* U+3AD1 */
  0x0000,   /* U+3AD2 */
  0x0000,   /* U+3AD3 */
  0x0000,   /* U+3AD4 */
  0x0000,   /* U+3AD5 */
  0x0000,   /* U+3AD6 */
  0x0000,   /* U+3AD7 */
  0x0000,   /* U+3AD8 */
  0x0000,   /* U+3AD9 */
  0x0000,   /* U+3ADA */
  0x0000,   /* U+3ADB */
  0x0000,   /* U+3ADC */
  0x0000,   /* U+3ADD */
  0x0000,   /* U+3ADE */
  0x0000,   /* U+3ADF */
  0x0000,   /* U+3AE0 */
  0x0000,   /* U+3AE1 */
  0x0000,   /* U+3AE2 */
  0x0000,   /* U+3AE3 */
  0x0000,   /* U+3AE4 */
  0x0000,   /* U+3AE5 */
  0x0000,   /* U+3AE6 */
  0x0000,   /* U+3AE7 */
  0x0000,   /* U+3AE8 */
  0x0000,   /* U+3AE9 */
  0x0000,   /* U+3AEA */
  0x0000,   /* U+3AEB */
  0x0000,   /* U+3AEC */
  0x0000,   /* U+3AED */
  0x0000,   /* U+3AEE */
  0x0000,   /* U+3AEF */
  0x0000,   /* U+3AF0 */
  0x0000,   /* U+3AF1 */
  0x0000,   /* U+3AF2 */
  0x0000,   /* U+3AF3 */
  0x0000,   /* U+3AF4 */
  0x0000,   /* U+3AF5 */
  0x0000,   /* U+3AF6 */
  0x0000,   /* U+3AF7 */
  0x0000,   /* U+3AF8 */
  0x0000,   /* U+3AF9 */
  0x0000,   /* U+3AFA */
  0x0000,   /* U+3AFB */
  0x0000,   /* U+3AFC */
  0x0000,   /* U+3AFD */
  0x0000,   /* U+3AFE */
  0x0000,   /* U+3AFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3A00 */
  0x0000,   /* U+3A01 */
  0x0000,   /* U+3A02 */
  0x0000,   /* U+3A03 */
  0x0000,   /* U+3A04 */
  0x0000,   /* U+3A05 */
  0x0000,   /* U+3A06 */
  0x0000,   /* U+3A07 */
  0x0000,   /* U+3A08 */
  0x0000,   /* U+3A09 */
  0x0000,   /* U+3A0A */
  0x0000,   /* U+3A0B */
  0x0000,   /* U+3A0C */
  0x0000,   /* U+3A0D */
  0x0000,   /* U+3A0E */
  0x0000,   /* U+3A0F */
  0x0000,   /* U+3A10 */
  0x0000,   /* U+3A11 */
  0x0000,   /* U+3A12 */
  0x0000,   /* U+3A13 */
  0x0000,   /* U+3A14 */
  0x0000,   /* U+3A15 */
  0x0000,   /* U+3A16 */
  0x0000,   /* U+3A17 */
  0x0000,   /* U+3A18 */
  0x0000,   /* U+3A19 */
  0x0000,   /* U+3A1A */
  0x0000,   /* U+3A1B */
  0x0000,   /* U+3A1C */
  0x0000,   /* U+3A1D */
  0x0000,   /* U+3A1E */
  0x0000,   /* U+3A1F */
  0x0000,   /* U+3A20 */
  0x0000,   /* U+3A21 */
  0x0000,   /* U+3A22 */
  0x0000,   /* U+3A23 */
  0x0000,   /* U+3A24 */
  0x0000,   /* U+3A25 */
  0x0000,   /* U+3A26 */
  0x0000,   /* U+3A27 */
  0x0000,   /* U+3A28 */
  0x0000,   /* U+3A29 */
  0x0000,   /* U+3A2A */
  0x0000,   /* U+3A2B */
  0x0000,   /* U+3A2C */
  0x0000,   /* U+3A2D */
  0x0000,   /* U+3A2E */
  0x0000,   /* U+3A2F */
  0x0000,   /* U+3A30 */
  0x0000,   /* U+3A31 */
  0x0000,   /* U+3A32 */
  0x0000,   /* U+3A33 */
  0x0000,   /* U+3A34 */
  0x0000,   /* U+3A35 */
  0x0000,   /* U+3A36 */
  0x0000,   /* U+3A37 */
  0x0000,   /* U+3A38 */
  0x0000,   /* U+3A39 */
  0x0000,   /* U+3A3A */
  0x0000,   /* U+3A3B */
  0x0000,   /* U+3A3C */
  0x0000,   /* U+3A3D */
  0x0000,   /* U+3A3E */
  0x0000,   /* U+3A3F */
  0x0000,   /* U+3A40 */
  0x0000,   /* U+3A41 */
  0x0000,   /* U+3A42 */
  0x0000,   /* U+3A43 */
  0x0000,   /* U+3A44 */
  0x0000,   /* U+3A45 */
  0x0000,   /* U+3A46 */
  0x0000,   /* U+3A47 */
  0x0000,   /* U+3A48 */
  0x0000,   /* U+3A49 */
  0x0000,   /* U+3A4A */
  0x0000,   /* U+3A4B */
  0x0000,   /* U+3A4C */
  0x0000,   /* U+3A4D */
  0x0000,   /* U+3A4E */
  0x0000,   /* U+3A4F */
  0x0000,   /* U+3A50 */
  0x0000,   /* U+3A51 */
  0x0000,   /* U+3A52 */
  0x0000,   /* U+3A53 */
  0x0000,   /* U+3A54 */
  0x0000,   /* U+3A55 */
  0x0000,   /* U+3A56 */
  0x0000,   /* U+3A57 */
  0x0000,   /* U+3A58 */
  0x0000,   /* U+3A59 */
  0x0000,   /* U+3A5A */
  0x0000,   /* U+3A5B */
  0x0000,   /* U+3A5C */
  0x0000,   /* U+3A5D */
  0x0000,   /* U+3A5E */
  0x0000,   /* U+3A5F */
  0x0000,   /* U+3A60 */
  0x0000,   /* U+3A61 */
  0x0000,   /* U+3A62 */
  0x0000,   /* U+3A63 */
  0x0000,   /* U+3A64 */
  0x0000,   /* U+3A65 */
  0x0000,   /* U+3A66 */
  0x0000,   /* U+3A67 */
  0x0000,   /* U+3A68 */
  0x0000,   /* U+3A69 */
  0x0000,   /* U+3A6A */
  0x0000,   /* U+3A6B */
  0x0000,   /* U+3A6C */
  0x0000,   /* U+3A6D */
  0x0000,   /* U+3A6E */
  0x0000,   /* U+3A6F */
  0x0000,   /* U+3A70 */
  0x0000,   /* U+3A71 */
  0x0000,   /* U+3A72 */
  0x0000,   /* U+3A73 */
  0x0000,   /* U+3A74 */
  0x0000,   /* U+3A75 */
  0x0000,   /* U+3A76 */
  0x0000,   /* U+3A77 */
  0x0000,   /* U+3A78 */
  0x0000,   /* U+3A79 */
  0x0000,   /* U+3A7A */
  0x0000,   /* U+3A7B */
  0x0000,   /* U+3A7C */
  0x0000,   /* U+3A7D */
  0x0000,   /* U+3A7E */
  0x0000,   /* U+3A7F */
  0x0000,   /* U+3A80 */
  0x0000,   /* U+3A81 */
  0x0000,   /* U+3A82 */
  0x0000,   /* U+3A83 */
  0x0000,   /* U+3A84 */
  0x0000,   /* U+3A85 */
  0x0000,   /* U+3A86 */
  0x0000,   /* U+3A87 */
  0x0000,   /* U+3A88 */
  0x0000,   /* U+3A89 */
  0x0000,   /* U+3A8A */
  0x0000,   /* U+3A8B */
  0x0000,   /* U+3A8C */
  0x0000,   /* U+3A8D */
  0x0000,   /* U+3A8E */
  0x0000,   /* U+3A8F */
  0x0000,   /* U+3A90 */
  0x0000,   /* U+3A91 */
  0x0000,   /* U+3A92 */
  0x0000,   /* U+3A93 */
  0x0000,   /* U+3A94 */
  0x0000,   /* U+3A95 */
  0x0000,   /* U+3A96 */
  0x0000,   /* U+3A97 */
  0x0000,   /* U+3A98 */
  0x0000,   /* U+3A99 */
  0x0000,   /* U+3A9A */
  0x0000,   /* U+3A9B */
  0x0000,   /* U+3A9C */
  0x0000,   /* U+3A9D */
  0x0000,   /* U+3A9E */
  0x0000,   /* U+3A9F */
  0x0000,   /* U+3AA0 */
  0x0000,   /* U+3AA1 */
  0x0000,   /* U+3AA2 */
  0x0000,   /* U+3AA3 */
  0x0000,   /* U+3AA4 */
  0x0000,   /* U+3AA5 */
  0x0000,   /* U+3AA6 */
  0x0000,   /* U+3AA7 */
  0x0000,   /* U+3AA8 */
  0x0000,   /* U+3AA9 */
  0x0000,   /* U+3AAA */
  0x0000,   /* U+3AAB */
  0x0000,   /* U+3AAC */
  0x0000,   /* U+3AAD */
  0x0000,   /* U+3AAE */
  0x0000,   /* U+3AAF */
  0x0000,   /* U+3AB0 */
  0x0000,   /* U+3AB1 */
  0x0000,   /* U+3AB2 */
  0x0000,   /* U+3AB3 */
  0x0000,   /* U+3AB4 */
  0x0000,   /* U+3AB5 */
  0x0000,   /* U+3AB6 */
  0x0000,   /* U+3AB7 */
  0x0000,   /* U+3AB8 */
  0x0000,   /* U+3AB9 */
  0x0000,   /* U+3ABA */
  0x0000,   /* U+3ABB */
  0x0000,   /* U+3ABC */
  0x0000,   /* U+3ABD */
  0x0000,   /* U+3ABE */
  0x0000,   /* U+3ABF */
  0x0000,   /* U+3AC0 */
  0x0000,   /* U+3AC1 */
  0x0000,   /* U+3AC2 */
  0x0000,   /* U+3AC3 */
  0x0000,   /* U+3AC4 */
  0x0000,   /* U+3AC5 */
  0x0000,   /* U+3AC6 */
  0x0000,   /* U+3AC7 */
  0x0000,   /* U+3AC8 */
  0x0000,   /* U+3AC9 */
  0x0000,   /* U+3ACA */
  0x0000,   /* U+3ACB */
  0x0000,   /* U+3ACC */
  0x0000,   /* U+3ACD */
  0x0000,   /* U+3ACE */
  0x0000,   /* U+3ACF */
  0x0000,   /* U+3AD0 */
  0x0000,   /* U+3AD1 */
  0x0000,   /* U+3AD2 */
  0x0000,   /* U+3AD3 */
  0x0000,   /* U+3AD4 */
  0x0000,   /* U+3AD5 */
  0x0000,   /* U+3AD6 */
  0x0000,   /* U+3AD7 */
  0x0000,   /* U+3AD8 */
  0x0000,   /* U+3AD9 */
  0x0000,   /* U+3ADA */
  0x0000,   /* U+3ADB */
  0x0000,   /* U+3ADC */
  0x0000,   /* U+3ADD */
  0x0000,   /* U+3ADE */
  0x0000,   /* U+3ADF */
  0x0000,   /* U+3AE0 */
  0x0000,   /* U+3AE1 */
  0x0000,   /* U+3AE2 */
  0x0000,   /* U+3AE3 */
  0x0000,   /* U+3AE4 */
  0x0000,   /* U+3AE5 */
  0x0000,   /* U+3AE6 */
  0x0000,   /* U+3AE7 */
  0x0000,   /* U+3AE8 */
  0x0000,   /* U+3AE9 */
  0x0000,   /* U+3AEA */
  0x0000,   /* U+3AEB */
  0x0000,   /* U+3AEC */
  0x0000,   /* U+3AED */
  0x0000,   /* U+3AEE */
  0x0000,   /* U+3AEF */
  0x0000,   /* U+3AF0 */
  0x0000,   /* U+3AF1 */
  0x0000,   /* U+3AF2 */
  0x0000,   /* U+3AF3 */
  0x0000,   /* U+3AF4 */
  0x0000,   /* U+3AF5 */
  0x0000,   /* U+3AF6 */
  0x0000,   /* U+3AF7 */
  0x0000,   /* U+3AF8 */
  0x0000,   /* U+3AF9 */
  0x0000,   /* U+3AFA */
  0x0000,   /* U+3AFB */
  0x0000,   /* U+3AFC */
  0x0000,   /* U+3AFD */
  0x0000,   /* U+3AFE */
  0x0000,   /* U+3AFF */
};

uint16 zh2_han_p03B[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x5C49,   /* U+3B00 */
  0x2E55,   /* U+3B01 */
  0x2E55,   /* U+3B02 */
  0x2E55,   /* U+3B03 */
  0x2E55,   /* U+3B04 */
  0x2E55,   /* U+3B05 */
  0x2E55,   /* U+3B06 */
  0x2E55,   /* U+3B07 */
  0x2E55,   /* U+3B08 */
  0x2E55,   /* U+3B09 */
  0x2E55,   /* U+3B0A */
  0x2E55,   /* U+3B0B */
  0x2E55,   /* U+3B0C */
  0x2E4D,   /* U+3B0D */
  0x2E4D,   /* U+3B0E */
  0x2E4D,   /* U+3B0F */
  0x2E4D,   /* U+3B10 */
  0x2E57,   /* U+3B11 */
  0x2E57,   /* U+3B12 */
  0x2E57,   /* U+3B13 */
  0x2E57,   /* U+3B14 */
  0x2E57,   /* U+3B15 */
  0x5C49,   /* U+3B16 */
  0x2E58,   /* U+3B17 */
  0x2E58,   /* U+3B18 */
  0x2E58,   /* U+3B19 */
  0x2E58,   /* U+3B1A */
  0x2E58,   /* U+3B1B */
  0x2E58,   /* U+3B1C */
  0x2E58,   /* U+3B1D */
  0x2E58,   /* U+3B1E */
  0x2E58,   /* U+3B1F */
  0x2E59,   /* U+3B20 */
  0x2E59,   /* U+3B21 */
  0x2E59,   /* U+3B22 */
  0x2E5A,   /* U+3B23 */
  0x2E5A,   /* U+3B24 */
  0x2E5A,   /* U+3B25 */
  0x2E5A,   /* U+3B26 */
  0x5C49,   /* U+3B27 */
  0x5C49,   /* U+3B28 */
  0x2E5B,   /* U+3B29 */
  0x2E5B,   /* U+3B2A */
  0x2E5C,   /* U+3B2B */
  0x2E5E,   /* U+3B2C */
  0x2E5E,   /* U+3B2D */
  0x2E5F,   /* U+3B2E */
  0x2E61,   /* U+3B2F */
  0x2E8E,   /* U+3B30 */
  0x2E98,   /* U+3B31 */
  0x2E99,   /* U+3B32 */
  0x2ED0,   /* U+3B33 */
  0x2ED2,   /* U+3B34 */
  0x2ED2,   /* U+3B35 */
  0x2ED3,   /* U+3B36 */
  0x2ED3,   /* U+3B37 */
  0x2ED4,   /* U+3B38 */
  0x3CD4,   /* U+3B39 */
  0x5C49,   /* U+3B3A */
  0x2ECD,   /* U+3B3B */
  0x2ED7,   /* U+3B3C */
  0x2ED7,   /* U+3B3D */
  0x2ED7,   /* U+3B3E */
  0x2ED8,   /* U+3B3F */
  0x2ED9,   /* U+3B40 */
  0x2F0E,   /* U+3B41 */
  0x2F0F,   /* U+3B42 */
  0x2F0F,   /* U+3B43 */
  0x2F0F,   /* U+3B44 */
  0x5C49,   /* U+3B45 */
  0x5C49,   /* U+3B46 */
  0x2F10,   /* U+3B47 */
  0x2F10,   /* U+3B48 */
  0x2F10,   /* U+3B49 */
  0x2F10,   /* U+3B4A */
  0x2F10,   /* U+3B4B */
  0x2F10,   /* U+3B4C */
  0x2F10,   /* U+3B4D */
  0x2F10,   /* U+3B4E */
  0x2F10,   /* U+3B4F */
  0x5C49,   /* U+3B50 */
  0x2F11,   /* U+3B51 */
  0x2F11,   /* U+3B52 */
  0x2F11,   /* U+3B53 */
  0x2F11,   /* U+3B54 */
  0x2F11,   /* U+3B55 */
  0x2F11,   /* U+3B56 */
  0x5C49,   /* U+3B57 */
  0x2F12,   /* U+3B58 */
  0x2F12,   /* U+3B59 */
  0x2F12,   /* U+3B5A */
  0x2F12,   /* U+3B5B */
  0x2F12,   /* U+3B5C */
  0x2F12,   /* U+3B5D */
  0x2F12,   /* U+3B5E */
  0x2F12,   /* U+3B5F */
  0x2F12,   /* U+3B60 */
  0x2F12,   /* U+3B61 */
  0x2F12,   /* U+3B62 */
  0x2F12,   /* U+3B63 */
  0x2F12,   /* U+3B64 */
  0x2F12,   /* U+3B65 */
  0x5C49,   /* U+3B66 */
  0x2F12,   /* U+3B67 */
  0x2F13,   /* U+3B68 */
  0x2F13,   /* U+3B69 */
  0x2F13,   /* U+3B6A */
  0x2F13,   /* U+3B6B */
  0x2F13,   /* U+3B6C */
  0x2F13,   /* U+3B6D */
  0x2F13,   /* U+3B6E */
  0x2F13,   /* U+3B6F */
  0x2F13,   /* U+3B70 */
  0x2F13,   /* U+3B71 */
  0x2F13,   /* U+3B72 */
  0x2F13,   /* U+3B73 */
  0x5C49,   /* U+3B74 */
  0x2F13,   /* U+3B75 */
  0x2F14,   /* U+3B76 */
  0x2F13,   /* U+3B77 */
  0x2F14,   /* U+3B78 */
  0x2F14,   /* U+3B79 */
  0x2F14,   /* U+3B7A */
  0x2F14,   /* U+3B7B */
  0x2F14,   /* U+3B7C */
  0x2F14,   /* U+3B7D */
  0x2F14,   /* U+3B7E */
  0x2F14,   /* U+3B7F */
  0x2F14,   /* U+3B80 */
  0x2F14,   /* U+3B81 */
  0x2F14,   /* U+3B82 */
  0x2F14,   /* U+3B83 */
  0x2F14,   /* U+3B84 */
  0x2F14,   /* U+3B85 */
  0x2F14,   /* U+3B86 */
  0x2F14,   /* U+3B87 */
  0x5C49,   /* U+3B88 */
  0x2F14,   /* U+3B89 */
  0x5C49,   /* U+3B8A */
  0x2F15,   /* U+3B8B */
  0x2F15,   /* U+3B8C */
  0x2F15,   /* U+3B8D */
  0x2F15,   /* U+3B8E */
  0x2F15,   /* U+3B8F */
  0x2F15,   /* U+3B90 */
  0x2F15,   /* U+3B91 */
  0x2F15,   /* U+3B92 */
  0x2F15,   /* U+3B93 */
  0x2F15,   /* U+3B94 */
  0x2F15,   /* U+3B95 */
  0x2F15,   /* U+3B96 */
  0x2F15,   /* U+3B97 */
  0x2F15,   /* U+3B98 */
  0x2F15,   /* U+3B99 */
  0x2F15,   /* U+3B9A */
  0x2F15,   /* U+3B9B */
  0x2F15,   /* U+3B9C */
  0x2F15,   /* U+3B9D */
  0x2F15,   /* U+3B9E */
  0x2F15,   /* U+3B9F */
  0x2F15,   /* U+3BA0 */
  0x31D5,   /* U+3BA1 */
  0x2F15,   /* U+3BA2 */
  0x2F15,   /* U+3BA3 */
  0x2F0D,   /* U+3BA4 */
  0x2F0D,   /* U+3BA5 */
  0x2F0D,   /* U+3BA6 */
  0x2F0D,   /* U+3BA7 */
  0x2F0D,   /* U+3BA8 */
  0x2F0D,   /* U+3BA9 */
  0x2F0D,   /* U+3BAA */
  0x2F0D,   /* U+3BAB */
  0x2F0D,   /* U+3BAC */
  0x2F0D,   /* U+3BAD */
  0x2F0D,   /* U+3BAE */
  0x2F0D,   /* U+3BAF */
  0x2F0D,   /* U+3BB0 */
  0x2F0D,   /* U+3BB1 */
  0x2F0D,   /* U+3BB2 */
  0x2F0D,   /* U+3BB3 */
  0x2F0D,   /* U+3BB4 */
  0x2F0D,   /* U+3BB5 */
  0x2F0D,   /* U+3BB6 */
  0x2F0D,   /* U+3BB7 */
  0x2F0D,   /* U+3BB8 */
  0x2F0D,   /* U+3BB9 */
  0x2F0D,   /* U+3BBA */
  0x2F0D,   /* U+3BBB */
  0x2F0D,   /* U+3BBC */
  0x5C49,   /* U+3BBD */
  0x2F17,   /* U+3BBE */
  0x2F17,   /* U+3BBF */
  0x2F17,   /* U+3BC0 */
  0x2F17,   /* U+3BC1 */
  0x2F17,   /* U+3BC2 */
  0x2F17,   /* U+3BC3 */
  0x2F17,   /* U+3BC4 */
  0x2F17,   /* U+3BC5 */
  0x2F17,   /* U+3BC6 */
  0x2F17,   /* U+3BC7 */
  0x2F17,   /* U+3BC8 */
  0x2F17,   /* U+3BC9 */
  0x2F17,   /* U+3BCA */
  0x2F17,   /* U+3BCB */
  0x2F17,   /* U+3BCC */
  0x2F17,   /* U+3BCD */
  0x2F17,   /* U+3BCE */
  0x2F17,   /* U+3BCF */
  0x2F18,   /* U+3BD0 */
  0x5C49,   /* U+3BD1 */
  0x5C49,   /* U+3BD2 */
  0x2F18,   /* U+3BD3 */
  0x2F18,   /* U+3BD4 */
  0x2F18,   /* U+3BD5 */
  0x2F18,   /* U+3BD6 */
  0x2F18,   /* U+3BD7 */
  0x2F18,   /* U+3BD8 */
  0x2F18,   /* U+3BD9 */
  0x2F18,   /* U+3BDA */
  0x2F18,   /* U+3BDB */
  0x2F18,   /* U+3BDC */
  0x2F18,   /* U+3BDD */
  0x2F18,   /* U+3BDE */
  0x2F18,   /* U+3BDF */
  0x2F17,   /* U+3BE0 */
  0x2F18,   /* U+3BE1 */
  0x2F18,   /* U+3BE2 */
  0x2F18,   /* U+3BE3 */
  0x2F18,   /* U+3BE4 */
  0x2F18,   /* U+3BE5 */
  0x2F18,   /* U+3BE6 */
  0x2F18,   /* U+3BE7 */
  0x2F18,   /* U+3BE8 */
  0x2F18,   /* U+3BE9 */
  0x2F19,   /* U+3BEA */
  0x2F19,   /* U+3BEB */
  0x2F19,   /* U+3BEC */
  0x2F19,   /* U+3BED */
  0x2F19,   /* U+3BEE */
  0x2F19,   /* U+3BEF */
  0x2F19,   /* U+3BF0 */
  0x2F19,   /* U+3BF1 */
  0x2F19,   /* U+3BF2 */
  0x2F19,   /* U+3BF3 */
  0x2F19,   /* U+3BF4 */
  0x5C49,   /* U+3BF5 */
  0x2F19,   /* U+3BF6 */
  0x2F1A,   /* U+3BF7 */
  0x2F1A,   /* U+3BF8 */
  0x2F1A,   /* U+3BF9 */
  0x2F1A,   /* U+3BFA */
  0x2F1A,   /* U+3BFB */
  0x2F1A,   /* U+3BFC */
  0x5C49,   /* U+3BFD */
  0x2F1B,   /* U+3BFE */
  0x2F1B,   /* U+3BFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3B00 */
  0x0020,   /* U+3B01 */
  0x0020,   /* U+3B02 */
  0x0020,   /* U+3B03 */
  0x0020,   /* U+3B04 */
  0x0020,   /* U+3B05 */
  0x0020,   /* U+3B06 */
  0x0020,   /* U+3B07 */
  0x0020,   /* U+3B08 */
  0x0020,   /* U+3B09 */
  0x0020,   /* U+3B0A */
  0x0020,   /* U+3B0B */
  0x0020,   /* U+3B0C */
  0x0020,   /* U+3B0D */
  0x0020,   /* U+3B0E */
  0x0020,   /* U+3B0F */
  0x0020,   /* U+3B10 */
  0x0020,   /* U+3B11 */
  0x0020,   /* U+3B12 */
  0x0020,   /* U+3B13 */
  0x0020,   /* U+3B14 */
  0x0020,   /* U+3B15 */
  0x0020,   /* U+3B16 */
  0x0020,   /* U+3B17 */
  0x0020,   /* U+3B18 */
  0x0020,   /* U+3B19 */
  0x0020,   /* U+3B1A */
  0x0020,   /* U+3B1B */
  0x0020,   /* U+3B1C */
  0x0020,   /* U+3B1D */
  0x0020,   /* U+3B1E */
  0x0020,   /* U+3B1F */
  0x0020,   /* U+3B20 */
  0x0020,   /* U+3B21 */
  0x0020,   /* U+3B22 */
  0x0020,   /* U+3B23 */
  0x0020,   /* U+3B24 */
  0x0020,   /* U+3B25 */
  0x0020,   /* U+3B26 */
  0x0020,   /* U+3B27 */
  0x0020,   /* U+3B28 */
  0x0020,   /* U+3B29 */
  0x0020,   /* U+3B2A */
  0x0020,   /* U+3B2B */
  0x0020,   /* U+3B2C */
  0x0020,   /* U+3B2D */
  0x0020,   /* U+3B2E */
  0x0020,   /* U+3B2F */
  0x0020,   /* U+3B30 */
  0x0020,   /* U+3B31 */
  0x0020,   /* U+3B32 */
  0x0020,   /* U+3B33 */
  0x0020,   /* U+3B34 */
  0x0020,   /* U+3B35 */
  0x0020,   /* U+3B36 */
  0x0020,   /* U+3B37 */
  0x0020,   /* U+3B38 */
  0x0020,   /* U+3B39 */
  0x0020,   /* U+3B3A */
  0x0020,   /* U+3B3B */
  0x0020,   /* U+3B3C */
  0x0020,   /* U+3B3D */
  0x0020,   /* U+3B3E */
  0x0020,   /* U+3B3F */
  0x0020,   /* U+3B40 */
  0x0020,   /* U+3B41 */
  0x0020,   /* U+3B42 */
  0x0020,   /* U+3B43 */
  0x0020,   /* U+3B44 */
  0x0020,   /* U+3B45 */
  0x0020,   /* U+3B46 */
  0x0020,   /* U+3B47 */
  0x0020,   /* U+3B48 */
  0x0020,   /* U+3B49 */
  0x0020,   /* U+3B4A */
  0x0020,   /* U+3B4B */
  0x0020,   /* U+3B4C */
  0x0020,   /* U+3B4D */
  0x0020,   /* U+3B4E */
  0x0020,   /* U+3B4F */
  0x0020,   /* U+3B50 */
  0x0020,   /* U+3B51 */
  0x0020,   /* U+3B52 */
  0x0020,   /* U+3B53 */
  0x0020,   /* U+3B54 */
  0x0020,   /* U+3B55 */
  0x0020,   /* U+3B56 */
  0x0020,   /* U+3B57 */
  0x0020,   /* U+3B58 */
  0x0020,   /* U+3B59 */
  0x0020,   /* U+3B5A */
  0x0020,   /* U+3B5B */
  0x0020,   /* U+3B5C */
  0x0020,   /* U+3B5D */
  0x0020,   /* U+3B5E */
  0x0020,   /* U+3B5F */
  0x0020,   /* U+3B60 */
  0x0020,   /* U+3B61 */
  0x0020,   /* U+3B62 */
  0x0020,   /* U+3B63 */
  0x0020,   /* U+3B64 */
  0x0020,   /* U+3B65 */
  0x0020,   /* U+3B66 */
  0x0020,   /* U+3B67 */
  0x0020,   /* U+3B68 */
  0x0020,   /* U+3B69 */
  0x0020,   /* U+3B6A */
  0x0020,   /* U+3B6B */
  0x0020,   /* U+3B6C */
  0x0020,   /* U+3B6D */
  0x0020,   /* U+3B6E */
  0x0020,   /* U+3B6F */
  0x0020,   /* U+3B70 */
  0x0020,   /* U+3B71 */
  0x0020,   /* U+3B72 */
  0x0020,   /* U+3B73 */
  0x0020,   /* U+3B74 */
  0x0020,   /* U+3B75 */
  0x0020,   /* U+3B76 */
  0x0020,   /* U+3B77 */
  0x0020,   /* U+3B78 */
  0x0020,   /* U+3B79 */
  0x0020,   /* U+3B7A */
  0x0020,   /* U+3B7B */
  0x0020,   /* U+3B7C */
  0x0020,   /* U+3B7D */
  0x0020,   /* U+3B7E */
  0x0020,   /* U+3B7F */
  0x0020,   /* U+3B80 */
  0x0020,   /* U+3B81 */
  0x0020,   /* U+3B82 */
  0x0020,   /* U+3B83 */
  0x0020,   /* U+3B84 */
  0x0020,   /* U+3B85 */
  0x0020,   /* U+3B86 */
  0x0020,   /* U+3B87 */
  0x0020,   /* U+3B88 */
  0x0020,   /* U+3B89 */
  0x0020,   /* U+3B8A */
  0x0020,   /* U+3B8B */
  0x0020,   /* U+3B8C */
  0x0020,   /* U+3B8D */
  0x0020,   /* U+3B8E */
  0x0020,   /* U+3B8F */
  0x0020,   /* U+3B90 */
  0x0020,   /* U+3B91 */
  0x0020,   /* U+3B92 */
  0x0020,   /* U+3B93 */
  0x0020,   /* U+3B94 */
  0x0020,   /* U+3B95 */
  0x0020,   /* U+3B96 */
  0x0020,   /* U+3B97 */
  0x0020,   /* U+3B98 */
  0x0020,   /* U+3B99 */
  0x0020,   /* U+3B9A */
  0x0020,   /* U+3B9B */
  0x0020,   /* U+3B9C */
  0x0020,   /* U+3B9D */
  0x0020,   /* U+3B9E */
  0x0020,   /* U+3B9F */
  0x0020,   /* U+3BA0 */
  0x0020,   /* U+3BA1 */
  0x0020,   /* U+3BA2 */
  0x0020,   /* U+3BA3 */
  0x0020,   /* U+3BA4 */
  0x0020,   /* U+3BA5 */
  0x0020,   /* U+3BA6 */
  0x0020,   /* U+3BA7 */
  0x0020,   /* U+3BA8 */
  0x0020,   /* U+3BA9 */
  0x0020,   /* U+3BAA */
  0x0020,   /* U+3BAB */
  0x0020,   /* U+3BAC */
  0x0020,   /* U+3BAD */
  0x0020,   /* U+3BAE */
  0x0020,   /* U+3BAF */
  0x0020,   /* U+3BB0 */
  0x0020,   /* U+3BB1 */
  0x0020,   /* U+3BB2 */
  0x0020,   /* U+3BB3 */
  0x0020,   /* U+3BB4 */
  0x0020,   /* U+3BB5 */
  0x0020,   /* U+3BB6 */
  0x0020,   /* U+3BB7 */
  0x0020,   /* U+3BB8 */
  0x0020,   /* U+3BB9 */
  0x0020,   /* U+3BBA */
  0x0020,   /* U+3BBB */
  0x0020,   /* U+3BBC */
  0x0020,   /* U+3BBD */
  0x0020,   /* U+3BBE */
  0x0020,   /* U+3BBF */
  0x0020,   /* U+3BC0 */
  0x0020,   /* U+3BC1 */
  0x0020,   /* U+3BC2 */
  0x0020,   /* U+3BC3 */
  0x0020,   /* U+3BC4 */
  0x0020,   /* U+3BC5 */
  0x0020,   /* U+3BC6 */
  0x0020,   /* U+3BC7 */
  0x0020,   /* U+3BC8 */
  0x0020,   /* U+3BC9 */
  0x0020,   /* U+3BCA */
  0x0020,   /* U+3BCB */
  0x0020,   /* U+3BCC */
  0x0020,   /* U+3BCD */
  0x0020,   /* U+3BCE */
  0x0020,   /* U+3BCF */
  0x0020,   /* U+3BD0 */
  0x0020,   /* U+3BD1 */
  0x0020,   /* U+3BD2 */
  0x0020,   /* U+3BD3 */
  0x0020,   /* U+3BD4 */
  0x0020,   /* U+3BD5 */
  0x0020,   /* U+3BD6 */
  0x0020,   /* U+3BD7 */
  0x0020,   /* U+3BD8 */
  0x0020,   /* U+3BD9 */
  0x0020,   /* U+3BDA */
  0x0020,   /* U+3BDB */
  0x0020,   /* U+3BDC */
  0x0020,   /* U+3BDD */
  0x0020,   /* U+3BDE */
  0x0020,   /* U+3BDF */
  0x0020,   /* U+3BE0 */
  0x0020,   /* U+3BE1 */
  0x0020,   /* U+3BE2 */
  0x0020,   /* U+3BE3 */
  0x0020,   /* U+3BE4 */
  0x0020,   /* U+3BE5 */
  0x0020,   /* U+3BE6 */
  0x0020,   /* U+3BE7 */
  0x0020,   /* U+3BE8 */
  0x0020,   /* U+3BE9 */
  0x0020,   /* U+3BEA */
  0x0020,   /* U+3BEB */
  0x0020,   /* U+3BEC */
  0x0020,   /* U+3BED */
  0x0020,   /* U+3BEE */
  0x0020,   /* U+3BEF */
  0x0020,   /* U+3BF0 */
  0x0020,   /* U+3BF1 */
  0x0020,   /* U+3BF2 */
  0x0020,   /* U+3BF3 */
  0x0020,   /* U+3BF4 */
  0x0020,   /* U+3BF5 */
  0x0020,   /* U+3BF6 */
  0x0020,   /* U+3BF7 */
  0x0020,   /* U+3BF8 */
  0x0020,   /* U+3BF9 */
  0x0020,   /* U+3BFA */
  0x0020,   /* U+3BFB */
  0x0020,   /* U+3BFC */
  0x0020,   /* U+3BFD */
  0x0020,   /* U+3BFE */
  0x0020,   /* U+3BFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3B00 */
  0x0002,   /* U+3B01 */
  0x0002,   /* U+3B02 */
  0x0002,   /* U+3B03 */
  0x0002,   /* U+3B04 */
  0x0002,   /* U+3B05 */
  0x0002,   /* U+3B06 */
  0x0002,   /* U+3B07 */
  0x0002,   /* U+3B08 */
  0x0002,   /* U+3B09 */
  0x0002,   /* U+3B0A */
  0x0002,   /* U+3B0B */
  0x0002,   /* U+3B0C */
  0x0002,   /* U+3B0D */
  0x0002,   /* U+3B0E */
  0x0002,   /* U+3B0F */
  0x0002,   /* U+3B10 */
  0x0002,   /* U+3B11 */
  0x0002,   /* U+3B12 */
  0x0002,   /* U+3B13 */
  0x0002,   /* U+3B14 */
  0x0002,   /* U+3B15 */
  0x0002,   /* U+3B16 */
  0x0002,   /* U+3B17 */
  0x0002,   /* U+3B18 */
  0x0002,   /* U+3B19 */
  0x0002,   /* U+3B1A */
  0x0002,   /* U+3B1B */
  0x0002,   /* U+3B1C */
  0x0002,   /* U+3B1D */
  0x0002,   /* U+3B1E */
  0x0002,   /* U+3B1F */
  0x0002,   /* U+3B20 */
  0x0002,   /* U+3B21 */
  0x0002,   /* U+3B22 */
  0x0002,   /* U+3B23 */
  0x0002,   /* U+3B24 */
  0x0002,   /* U+3B25 */
  0x0002,   /* U+3B26 */
  0x0002,   /* U+3B27 */
  0x0002,   /* U+3B28 */
  0x0002,   /* U+3B29 */
  0x0002,   /* U+3B2A */
  0x0002,   /* U+3B2B */
  0x0002,   /* U+3B2C */
  0x0002,   /* U+3B2D */
  0x0002,   /* U+3B2E */
  0x0002,   /* U+3B2F */
  0x0002,   /* U+3B30 */
  0x0002,   /* U+3B31 */
  0x0002,   /* U+3B32 */
  0x0002,   /* U+3B33 */
  0x0002,   /* U+3B34 */
  0x0002,   /* U+3B35 */
  0x0002,   /* U+3B36 */
  0x0002,   /* U+3B37 */
  0x0002,   /* U+3B38 */
  0x0002,   /* U+3B39 */
  0x0002,   /* U+3B3A */
  0x0002,   /* U+3B3B */
  0x0002,   /* U+3B3C */
  0x0002,   /* U+3B3D */
  0x0002,   /* U+3B3E */
  0x0002,   /* U+3B3F */
  0x0002,   /* U+3B40 */
  0x0002,   /* U+3B41 */
  0x0002,   /* U+3B42 */
  0x0002,   /* U+3B43 */
  0x0002,   /* U+3B44 */
  0x0002,   /* U+3B45 */
  0x0002,   /* U+3B46 */
  0x0002,   /* U+3B47 */
  0x0002,   /* U+3B48 */
  0x0002,   /* U+3B49 */
  0x0002,   /* U+3B4A */
  0x0002,   /* U+3B4B */
  0x0002,   /* U+3B4C */
  0x0002,   /* U+3B4D */
  0x0002,   /* U+3B4E */
  0x0002,   /* U+3B4F */
  0x0002,   /* U+3B50 */
  0x0002,   /* U+3B51 */
  0x0002,   /* U+3B52 */
  0x0002,   /* U+3B53 */
  0x0002,   /* U+3B54 */
  0x0002,   /* U+3B55 */
  0x0002,   /* U+3B56 */
  0x0002,   /* U+3B57 */
  0x0002,   /* U+3B58 */
  0x0002,   /* U+3B59 */
  0x0002,   /* U+3B5A */
  0x0002,   /* U+3B5B */
  0x0002,   /* U+3B5C */
  0x0002,   /* U+3B5D */
  0x0002,   /* U+3B5E */
  0x0002,   /* U+3B5F */
  0x0002,   /* U+3B60 */
  0x0002,   /* U+3B61 */
  0x0002,   /* U+3B62 */
  0x0002,   /* U+3B63 */
  0x0002,   /* U+3B64 */
  0x0002,   /* U+3B65 */
  0x0002,   /* U+3B66 */
  0x0002,   /* U+3B67 */
  0x0002,   /* U+3B68 */
  0x0002,   /* U+3B69 */
  0x0002,   /* U+3B6A */
  0x0002,   /* U+3B6B */
  0x0002,   /* U+3B6C */
  0x0002,   /* U+3B6D */
  0x0002,   /* U+3B6E */
  0x0002,   /* U+3B6F */
  0x0002,   /* U+3B70 */
  0x0002,   /* U+3B71 */
  0x0002,   /* U+3B72 */
  0x0002,   /* U+3B73 */
  0x0002,   /* U+3B74 */
  0x0002,   /* U+3B75 */
  0x0002,   /* U+3B76 */
  0x0002,   /* U+3B77 */
  0x0002,   /* U+3B78 */
  0x0002,   /* U+3B79 */
  0x0002,   /* U+3B7A */
  0x0002,   /* U+3B7B */
  0x0002,   /* U+3B7C */
  0x0002,   /* U+3B7D */
  0x0002,   /* U+3B7E */
  0x0002,   /* U+3B7F */
  0x0002,   /* U+3B80 */
  0x0002,   /* U+3B81 */
  0x0002,   /* U+3B82 */
  0x0002,   /* U+3B83 */
  0x0002,   /* U+3B84 */
  0x0002,   /* U+3B85 */
  0x0002,   /* U+3B86 */
  0x0002,   /* U+3B87 */
  0x0002,   /* U+3B88 */
  0x0002,   /* U+3B89 */
  0x0002,   /* U+3B8A */
  0x0002,   /* U+3B8B */
  0x0002,   /* U+3B8C */
  0x0002,   /* U+3B8D */
  0x0002,   /* U+3B8E */
  0x0002,   /* U+3B8F */
  0x0002,   /* U+3B90 */
  0x0002,   /* U+3B91 */
  0x0002,   /* U+3B92 */
  0x0002,   /* U+3B93 */
  0x0002,   /* U+3B94 */
  0x0002,   /* U+3B95 */
  0x0002,   /* U+3B96 */
  0x0002,   /* U+3B97 */
  0x0002,   /* U+3B98 */
  0x0002,   /* U+3B99 */
  0x0002,   /* U+3B9A */
  0x0002,   /* U+3B9B */
  0x0002,   /* U+3B9C */
  0x0002,   /* U+3B9D */
  0x0002,   /* U+3B9E */
  0x0002,   /* U+3B9F */
  0x0002,   /* U+3BA0 */
  0x0002,   /* U+3BA1 */
  0x0002,   /* U+3BA2 */
  0x0002,   /* U+3BA3 */
  0x0002,   /* U+3BA4 */
  0x0002,   /* U+3BA5 */
  0x0002,   /* U+3BA6 */
  0x0002,   /* U+3BA7 */
  0x0002,   /* U+3BA8 */
  0x0002,   /* U+3BA9 */
  0x0002,   /* U+3BAA */
  0x0002,   /* U+3BAB */
  0x0002,   /* U+3BAC */
  0x0002,   /* U+3BAD */
  0x0002,   /* U+3BAE */
  0x0002,   /* U+3BAF */
  0x0002,   /* U+3BB0 */
  0x0002,   /* U+3BB1 */
  0x0002,   /* U+3BB2 */
  0x0002,   /* U+3BB3 */
  0x0002,   /* U+3BB4 */
  0x0002,   /* U+3BB5 */
  0x0002,   /* U+3BB6 */
  0x0002,   /* U+3BB7 */
  0x0002,   /* U+3BB8 */
  0x0002,   /* U+3BB9 */
  0x0002,   /* U+3BBA */
  0x0002,   /* U+3BBB */
  0x0002,   /* U+3BBC */
  0x0002,   /* U+3BBD */
  0x0002,   /* U+3BBE */
  0x0002,   /* U+3BBF */
  0x0002,   /* U+3BC0 */
  0x0002,   /* U+3BC1 */
  0x0002,   /* U+3BC2 */
  0x0002,   /* U+3BC3 */
  0x0002,   /* U+3BC4 */
  0x0002,   /* U+3BC5 */
  0x0002,   /* U+3BC6 */
  0x0002,   /* U+3BC7 */
  0x0002,   /* U+3BC8 */
  0x0002,   /* U+3BC9 */
  0x0002,   /* U+3BCA */
  0x0002,   /* U+3BCB */
  0x0002,   /* U+3BCC */
  0x0002,   /* U+3BCD */
  0x0002,   /* U+3BCE */
  0x0002,   /* U+3BCF */
  0x0002,   /* U+3BD0 */
  0x0002,   /* U+3BD1 */
  0x0002,   /* U+3BD2 */
  0x0002,   /* U+3BD3 */
  0x0002,   /* U+3BD4 */
  0x0002,   /* U+3BD5 */
  0x0002,   /* U+3BD6 */
  0x0002,   /* U+3BD7 */
  0x0002,   /* U+3BD8 */
  0x0002,   /* U+3BD9 */
  0x0002,   /* U+3BDA */
  0x0002,   /* U+3BDB */
  0x0002,   /* U+3BDC */
  0x0002,   /* U+3BDD */
  0x0002,   /* U+3BDE */
  0x0002,   /* U+3BDF */
  0x0002,   /* U+3BE0 */
  0x0002,   /* U+3BE1 */
  0x0002,   /* U+3BE2 */
  0x0002,   /* U+3BE3 */
  0x0002,   /* U+3BE4 */
  0x0002,   /* U+3BE5 */
  0x0002,   /* U+3BE6 */
  0x0002,   /* U+3BE7 */
  0x0002,   /* U+3BE8 */
  0x0002,   /* U+3BE9 */
  0x0002,   /* U+3BEA */
  0x0002,   /* U+3BEB */
  0x0002,   /* U+3BEC */
  0x0002,   /* U+3BED */
  0x0002,   /* U+3BEE */
  0x0002,   /* U+3BEF */
  0x0002,   /* U+3BF0 */
  0x0002,   /* U+3BF1 */
  0x0002,   /* U+3BF2 */
  0x0002,   /* U+3BF3 */
  0x0002,   /* U+3BF4 */
  0x0002,   /* U+3BF5 */
  0x0002,   /* U+3BF6 */
  0x0002,   /* U+3BF7 */
  0x0002,   /* U+3BF8 */
  0x0002,   /* U+3BF9 */
  0x0002,   /* U+3BFA */
  0x0002,   /* U+3BFB */
  0x0002,   /* U+3BFC */
  0x0002,   /* U+3BFD */
  0x0002,   /* U+3BFE */
  0x0002,   /* U+3BFF */

  /* Primary weight 2 for each character. */
  0xBB00,   /* U+3B00 */
  0x8000,   /* U+3B01 */
  0x8001,   /* U+3B02 */
  0x8002,   /* U+3B03 */
  0x8003,   /* U+3B04 */
  0x8004,   /* U+3B05 */
  0x8005,   /* U+3B06 */
  0x8006,   /* U+3B07 */
  0x8007,   /* U+3B08 */
  0x8008,   /* U+3B09 */
  0x8009,   /* U+3B0A */
  0x800A,   /* U+3B0B */
  0x800B,   /* U+3B0C */
  0x8000,   /* U+3B0D */
  0x8001,   /* U+3B0E */
  0x8002,   /* U+3B0F */
  0x8003,   /* U+3B10 */
  0x8000,   /* U+3B11 */
  0x8001,   /* U+3B12 */
  0x8002,   /* U+3B13 */
  0x8003,   /* U+3B14 */
  0x8004,   /* U+3B15 */
  0xBB16,   /* U+3B16 */
  0x8000,   /* U+3B17 */
  0x8001,   /* U+3B18 */
  0x8002,   /* U+3B19 */
  0x8003,   /* U+3B1A */
  0x8004,   /* U+3B1B */
  0x8005,   /* U+3B1C */
  0x8006,   /* U+3B1D */
  0x8007,   /* U+3B1E */
  0x8008,   /* U+3B1F */
  0x8000,   /* U+3B20 */
  0x8001,   /* U+3B21 */
  0x8002,   /* U+3B22 */
  0x8000,   /* U+3B23 */
  0x8001,   /* U+3B24 */
  0x8002,   /* U+3B25 */
  0x8003,   /* U+3B26 */
  0xBB27,   /* U+3B27 */
  0xBB28,   /* U+3B28 */
  0x8000,   /* U+3B29 */
  0x8001,   /* U+3B2A */
  0x8000,   /* U+3B2B */
  0x8000,   /* U+3B2C */
  0x8001,   /* U+3B2D */
  0x8000,   /* U+3B2E */
  0x8000,   /* U+3B2F */
  0x8000,   /* U+3B30 */
  0x8000,   /* U+3B31 */
  0x8000,   /* U+3B32 */
  0x8000,   /* U+3B33 */
  0x8000,   /* U+3B34 */
  0x8001,   /* U+3B35 */
  0x8000,   /* U+3B36 */
  0x8001,   /* U+3B37 */
  0x8000,   /* U+3B38 */
  0x8000,   /* U+3B39 */
  0xBB3A,   /* U+3B3A */
  0x8000,   /* U+3B3B */
  0x8000,   /* U+3B3C */
  0x8001,   /* U+3B3D */
  0x8002,   /* U+3B3E */
  0x8000,   /* U+3B3F */
  0x8000,   /* U+3B40 */
  0x8000,   /* U+3B41 */
  0x8000,   /* U+3B42 */
  0x8001,   /* U+3B43 */
  0x8002,   /* U+3B44 */
  0xBB45,   /* U+3B45 */
  0xBB46,   /* U+3B46 */
  0x8000,   /* U+3B47 */
  0x8001,   /* U+3B48 */
  0x8002,   /* U+3B49 */
  0x8003,   /* U+3B4A */
  0x8004,   /* U+3B4B */
  0x8005,   /* U+3B4C */
  0x8006,   /* U+3B4D */
  0x8007,   /* U+3B4E */
  0x8008,   /* U+3B4F */
  0xBB50,   /* U+3B50 */
  0x8000,   /* U+3B51 */
  0x8001,   /* U+3B52 */
  0x8002,   /* U+3B53 */
  0x8003,   /* U+3B54 */
  0x8004,   /* U+3B55 */
  0x8005,   /* U+3B56 */
  0xBB57,   /* U+3B57 */
  0x8000,   /* U+3B58 */
  0x8001,   /* U+3B59 */
  0x8002,   /* U+3B5A */
  0x8003,   /* U+3B5B */
  0x8004,   /* U+3B5C */
  0x8005,   /* U+3B5D */
  0x8006,   /* U+3B5E */
  0x8007,   /* U+3B5F */
  0x8008,   /* U+3B60 */
  0x8009,   /* U+3B61 */
  0x800A,   /* U+3B62 */
  0x800B,   /* U+3B63 */
  0x800C,   /* U+3B64 */
  0x800D,   /* U+3B65 */
  0xBB66,   /* U+3B66 */
  0x800E,   /* U+3B67 */
  0x8000,   /* U+3B68 */
  0x8001,   /* U+3B69 */
  0x8002,   /* U+3B6A */
  0x8003,   /* U+3B6B */
  0x8004,   /* U+3B6C */
  0x8005,   /* U+3B6D */
  0x8006,   /* U+3B6E */
  0x8007,   /* U+3B6F */
  0x8008,   /* U+3B70 */
  0x8009,   /* U+3B71 */
  0x800A,   /* U+3B72 */
  0x800B,   /* U+3B73 */
  0xBB74,   /* U+3B74 */
  0x800C,   /* U+3B75 */
  0x8000,   /* U+3B76 */
  0x800D,   /* U+3B77 */
  0x8001,   /* U+3B78 */
  0x8002,   /* U+3B79 */
  0x8003,   /* U+3B7A */
  0x8004,   /* U+3B7B */
  0x8005,   /* U+3B7C */
  0x8006,   /* U+3B7D */
  0x8007,   /* U+3B7E */
  0x8008,   /* U+3B7F */
  0x8009,   /* U+3B80 */
  0x800A,   /* U+3B81 */
  0x800B,   /* U+3B82 */
  0x800C,   /* U+3B83 */
  0x800D,   /* U+3B84 */
  0x800E,   /* U+3B85 */
  0x800F,   /* U+3B86 */
  0x8010,   /* U+3B87 */
  0xBB88,   /* U+3B88 */
  0x8011,   /* U+3B89 */
  0xBB8A,   /* U+3B8A */
  0x8000,   /* U+3B8B */
  0x8001,   /* U+3B8C */
  0x8002,   /* U+3B8D */
  0x8003,   /* U+3B8E */
  0x8004,   /* U+3B8F */
  0x8005,   /* U+3B90 */
  0x8006,   /* U+3B91 */
  0x8007,   /* U+3B92 */
  0x8008,   /* U+3B93 */
  0x8009,   /* U+3B94 */
  0x800A,   /* U+3B95 */
  0x800B,   /* U+3B96 */
  0x800C,   /* U+3B97 */
  0x800D,   /* U+3B98 */
  0x800E,   /* U+3B99 */
  0x800F,   /* U+3B9A */
  0x8010,   /* U+3B9B */
  0x8011,   /* U+3B9C */
  0x8012,   /* U+3B9D */
  0x8013,   /* U+3B9E */
  0x8014,   /* U+3B9F */
  0x8015,   /* U+3BA0 */
  0x8000,   /* U+3BA1 */
  0x8016,   /* U+3BA2 */
  0x8017,   /* U+3BA3 */
  0x8000,   /* U+3BA4 */
  0x8001,   /* U+3BA5 */
  0x8002,   /* U+3BA6 */
  0x8003,   /* U+3BA7 */
  0x8004,   /* U+3BA8 */
  0x8005,   /* U+3BA9 */
  0x8006,   /* U+3BAA */
  0x8007,   /* U+3BAB */
  0x8008,   /* U+3BAC */
  0x8009,   /* U+3BAD */
  0x800A,   /* U+3BAE */
  0x800B,   /* U+3BAF */
  0x800C,   /* U+3BB0 */
  0x800D,   /* U+3BB1 */
  0x800E,   /* U+3BB2 */
  0x800F,   /* U+3BB3 */
  0x8010,   /* U+3BB4 */
  0x8011,   /* U+3BB5 */
  0x8012,   /* U+3BB6 */
  0x8013,   /* U+3BB7 */
  0x8014,   /* U+3BB8 */
  0x8015,   /* U+3BB9 */
  0x8016,   /* U+3BBA */
  0x8017,   /* U+3BBB */
  0x8018,   /* U+3BBC */
  0xBBBD,   /* U+3BBD */
  0x8000,   /* U+3BBE */
  0x8001,   /* U+3BBF */
  0x8002,   /* U+3BC0 */
  0x8003,   /* U+3BC1 */
  0x8004,   /* U+3BC2 */
  0x8005,   /* U+3BC3 */
  0x8006,   /* U+3BC4 */
  0x8007,   /* U+3BC5 */
  0x8008,   /* U+3BC6 */
  0x8009,   /* U+3BC7 */
  0x800A,   /* U+3BC8 */
  0x800B,   /* U+3BC9 */
  0x800C,   /* U+3BCA */
  0x800D,   /* U+3BCB */
  0x800E,   /* U+3BCC */
  0x800F,   /* U+3BCD */
  0x8010,   /* U+3BCE */
  0x8011,   /* U+3BCF */
  0x8000,   /* U+3BD0 */
  0xBBD1,   /* U+3BD1 */
  0xBBD2,   /* U+3BD2 */
  0x8001,   /* U+3BD3 */
  0x8002,   /* U+3BD4 */
  0x8003,   /* U+3BD5 */
  0x8004,   /* U+3BD6 */
  0x8005,   /* U+3BD7 */
  0x8006,   /* U+3BD8 */
  0x8007,   /* U+3BD9 */
  0x8008,   /* U+3BDA */
  0x8009,   /* U+3BDB */
  0x800A,   /* U+3BDC */
  0x800B,   /* U+3BDD */
  0x800C,   /* U+3BDE */
  0x800D,   /* U+3BDF */
  0x8012,   /* U+3BE0 */
  0x800E,   /* U+3BE1 */
  0x800F,   /* U+3BE2 */
  0x8010,   /* U+3BE3 */
  0x8011,   /* U+3BE4 */
  0x8012,   /* U+3BE5 */
  0x8013,   /* U+3BE6 */
  0x8014,   /* U+3BE7 */
  0x8015,   /* U+3BE8 */
  0x8016,   /* U+3BE9 */
  0x8000,   /* U+3BEA */
  0x8001,   /* U+3BEB */
  0x8002,   /* U+3BEC */
  0x8003,   /* U+3BED */
  0x8004,   /* U+3BEE */
  0x8005,   /* U+3BEF */
  0x8006,   /* U+3BF0 */
  0x8007,   /* U+3BF1 */
  0x8008,   /* U+3BF2 */
  0x8009,   /* U+3BF3 */
  0x800A,   /* U+3BF4 */
  0xBBF5,   /* U+3BF5 */
  0x800B,   /* U+3BF6 */
  0x8000,   /* U+3BF7 */
  0x8001,   /* U+3BF8 */
  0x8002,   /* U+3BF9 */
  0x8003,   /* U+3BFA */
  0x8004,   /* U+3BFB */
  0x8005,   /* U+3BFC */
  0xBBFD,   /* U+3BFD */
  0x8000,   /* U+3BFE */
  0x8001,   /* U+3BFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3B00 */
  0x0000,   /* U+3B01 */
  0x0000,   /* U+3B02 */
  0x0000,   /* U+3B03 */
  0x0000,   /* U+3B04 */
  0x0000,   /* U+3B05 */
  0x0000,   /* U+3B06 */
  0x0000,   /* U+3B07 */
  0x0000,   /* U+3B08 */
  0x0000,   /* U+3B09 */
  0x0000,   /* U+3B0A */
  0x0000,   /* U+3B0B */
  0x0000,   /* U+3B0C */
  0x0000,   /* U+3B0D */
  0x0000,   /* U+3B0E */
  0x0000,   /* U+3B0F */
  0x0000,   /* U+3B10 */
  0x0000,   /* U+3B11 */
  0x0000,   /* U+3B12 */
  0x0000,   /* U+3B13 */
  0x0000,   /* U+3B14 */
  0x0000,   /* U+3B15 */
  0x0000,   /* U+3B16 */
  0x0000,   /* U+3B17 */
  0x0000,   /* U+3B18 */
  0x0000,   /* U+3B19 */
  0x0000,   /* U+3B1A */
  0x0000,   /* U+3B1B */
  0x0000,   /* U+3B1C */
  0x0000,   /* U+3B1D */
  0x0000,   /* U+3B1E */
  0x0000,   /* U+3B1F */
  0x0000,   /* U+3B20 */
  0x0000,   /* U+3B21 */
  0x0000,   /* U+3B22 */
  0x0000,   /* U+3B23 */
  0x0000,   /* U+3B24 */
  0x0000,   /* U+3B25 */
  0x0000,   /* U+3B26 */
  0x0000,   /* U+3B27 */
  0x0000,   /* U+3B28 */
  0x0000,   /* U+3B29 */
  0x0000,   /* U+3B2A */
  0x0000,   /* U+3B2B */
  0x0000,   /* U+3B2C */
  0x0000,   /* U+3B2D */
  0x0000,   /* U+3B2E */
  0x0000,   /* U+3B2F */
  0x0000,   /* U+3B30 */
  0x0000,   /* U+3B31 */
  0x0000,   /* U+3B32 */
  0x0000,   /* U+3B33 */
  0x0000,   /* U+3B34 */
  0x0000,   /* U+3B35 */
  0x0000,   /* U+3B36 */
  0x0000,   /* U+3B37 */
  0x0000,   /* U+3B38 */
  0x0000,   /* U+3B39 */
  0x0000,   /* U+3B3A */
  0x0000,   /* U+3B3B */
  0x0000,   /* U+3B3C */
  0x0000,   /* U+3B3D */
  0x0000,   /* U+3B3E */
  0x0000,   /* U+3B3F */
  0x0000,   /* U+3B40 */
  0x0000,   /* U+3B41 */
  0x0000,   /* U+3B42 */
  0x0000,   /* U+3B43 */
  0x0000,   /* U+3B44 */
  0x0000,   /* U+3B45 */
  0x0000,   /* U+3B46 */
  0x0000,   /* U+3B47 */
  0x0000,   /* U+3B48 */
  0x0000,   /* U+3B49 */
  0x0000,   /* U+3B4A */
  0x0000,   /* U+3B4B */
  0x0000,   /* U+3B4C */
  0x0000,   /* U+3B4D */
  0x0000,   /* U+3B4E */
  0x0000,   /* U+3B4F */
  0x0000,   /* U+3B50 */
  0x0000,   /* U+3B51 */
  0x0000,   /* U+3B52 */
  0x0000,   /* U+3B53 */
  0x0000,   /* U+3B54 */
  0x0000,   /* U+3B55 */
  0x0000,   /* U+3B56 */
  0x0000,   /* U+3B57 */
  0x0000,   /* U+3B58 */
  0x0000,   /* U+3B59 */
  0x0000,   /* U+3B5A */
  0x0000,   /* U+3B5B */
  0x0000,   /* U+3B5C */
  0x0000,   /* U+3B5D */
  0x0000,   /* U+3B5E */
  0x0000,   /* U+3B5F */
  0x0000,   /* U+3B60 */
  0x0000,   /* U+3B61 */
  0x0000,   /* U+3B62 */
  0x0000,   /* U+3B63 */
  0x0000,   /* U+3B64 */
  0x0000,   /* U+3B65 */
  0x0000,   /* U+3B66 */
  0x0000,   /* U+3B67 */
  0x0000,   /* U+3B68 */
  0x0000,   /* U+3B69 */
  0x0000,   /* U+3B6A */
  0x0000,   /* U+3B6B */
  0x0000,   /* U+3B6C */
  0x0000,   /* U+3B6D */
  0x0000,   /* U+3B6E */
  0x0000,   /* U+3B6F */
  0x0000,   /* U+3B70 */
  0x0000,   /* U+3B71 */
  0x0000,   /* U+3B72 */
  0x0000,   /* U+3B73 */
  0x0000,   /* U+3B74 */
  0x0000,   /* U+3B75 */
  0x0000,   /* U+3B76 */
  0x0000,   /* U+3B77 */
  0x0000,   /* U+3B78 */
  0x0000,   /* U+3B79 */
  0x0000,   /* U+3B7A */
  0x0000,   /* U+3B7B */
  0x0000,   /* U+3B7C */
  0x0000,   /* U+3B7D */
  0x0000,   /* U+3B7E */
  0x0000,   /* U+3B7F */
  0x0000,   /* U+3B80 */
  0x0000,   /* U+3B81 */
  0x0000,   /* U+3B82 */
  0x0000,   /* U+3B83 */
  0x0000,   /* U+3B84 */
  0x0000,   /* U+3B85 */
  0x0000,   /* U+3B86 */
  0x0000,   /* U+3B87 */
  0x0000,   /* U+3B88 */
  0x0000,   /* U+3B89 */
  0x0000,   /* U+3B8A */
  0x0000,   /* U+3B8B */
  0x0000,   /* U+3B8C */
  0x0000,   /* U+3B8D */
  0x0000,   /* U+3B8E */
  0x0000,   /* U+3B8F */
  0x0000,   /* U+3B90 */
  0x0000,   /* U+3B91 */
  0x0000,   /* U+3B92 */
  0x0000,   /* U+3B93 */
  0x0000,   /* U+3B94 */
  0x0000,   /* U+3B95 */
  0x0000,   /* U+3B96 */
  0x0000,   /* U+3B97 */
  0x0000,   /* U+3B98 */
  0x0000,   /* U+3B99 */
  0x0000,   /* U+3B9A */
  0x0000,   /* U+3B9B */
  0x0000,   /* U+3B9C */
  0x0000,   /* U+3B9D */
  0x0000,   /* U+3B9E */
  0x0000,   /* U+3B9F */
  0x0000,   /* U+3BA0 */
  0x0000,   /* U+3BA1 */
  0x0000,   /* U+3BA2 */
  0x0000,   /* U+3BA3 */
  0x0000,   /* U+3BA4 */
  0x0000,   /* U+3BA5 */
  0x0000,   /* U+3BA6 */
  0x0000,   /* U+3BA7 */
  0x0000,   /* U+3BA8 */
  0x0000,   /* U+3BA9 */
  0x0000,   /* U+3BAA */
  0x0000,   /* U+3BAB */
  0x0000,   /* U+3BAC */
  0x0000,   /* U+3BAD */
  0x0000,   /* U+3BAE */
  0x0000,   /* U+3BAF */
  0x0000,   /* U+3BB0 */
  0x0000,   /* U+3BB1 */
  0x0000,   /* U+3BB2 */
  0x0000,   /* U+3BB3 */
  0x0000,   /* U+3BB4 */
  0x0000,   /* U+3BB5 */
  0x0000,   /* U+3BB6 */
  0x0000,   /* U+3BB7 */
  0x0000,   /* U+3BB8 */
  0x0000,   /* U+3BB9 */
  0x0000,   /* U+3BBA */
  0x0000,   /* U+3BBB */
  0x0000,   /* U+3BBC */
  0x0000,   /* U+3BBD */
  0x0000,   /* U+3BBE */
  0x0000,   /* U+3BBF */
  0x0000,   /* U+3BC0 */
  0x0000,   /* U+3BC1 */
  0x0000,   /* U+3BC2 */
  0x0000,   /* U+3BC3 */
  0x0000,   /* U+3BC4 */
  0x0000,   /* U+3BC5 */
  0x0000,   /* U+3BC6 */
  0x0000,   /* U+3BC7 */
  0x0000,   /* U+3BC8 */
  0x0000,   /* U+3BC9 */
  0x0000,   /* U+3BCA */
  0x0000,   /* U+3BCB */
  0x0000,   /* U+3BCC */
  0x0000,   /* U+3BCD */
  0x0000,   /* U+3BCE */
  0x0000,   /* U+3BCF */
  0x0000,   /* U+3BD0 */
  0x0000,   /* U+3BD1 */
  0x0000,   /* U+3BD2 */
  0x0000,   /* U+3BD3 */
  0x0000,   /* U+3BD4 */
  0x0000,   /* U+3BD5 */
  0x0000,   /* U+3BD6 */
  0x0000,   /* U+3BD7 */
  0x0000,   /* U+3BD8 */
  0x0000,   /* U+3BD9 */
  0x0000,   /* U+3BDA */
  0x0000,   /* U+3BDB */
  0x0000,   /* U+3BDC */
  0x0000,   /* U+3BDD */
  0x0000,   /* U+3BDE */
  0x0000,   /* U+3BDF */
  0x0000,   /* U+3BE0 */
  0x0000,   /* U+3BE1 */
  0x0000,   /* U+3BE2 */
  0x0000,   /* U+3BE3 */
  0x0000,   /* U+3BE4 */
  0x0000,   /* U+3BE5 */
  0x0000,   /* U+3BE6 */
  0x0000,   /* U+3BE7 */
  0x0000,   /* U+3BE8 */
  0x0000,   /* U+3BE9 */
  0x0000,   /* U+3BEA */
  0x0000,   /* U+3BEB */
  0x0000,   /* U+3BEC */
  0x0000,   /* U+3BED */
  0x0000,   /* U+3BEE */
  0x0000,   /* U+3BEF */
  0x0000,   /* U+3BF0 */
  0x0000,   /* U+3BF1 */
  0x0000,   /* U+3BF2 */
  0x0000,   /* U+3BF3 */
  0x0000,   /* U+3BF4 */
  0x0000,   /* U+3BF5 */
  0x0000,   /* U+3BF6 */
  0x0000,   /* U+3BF7 */
  0x0000,   /* U+3BF8 */
  0x0000,   /* U+3BF9 */
  0x0000,   /* U+3BFA */
  0x0000,   /* U+3BFB */
  0x0000,   /* U+3BFC */
  0x0000,   /* U+3BFD */
  0x0000,   /* U+3BFE */
  0x0000,   /* U+3BFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3B00 */
  0x0000,   /* U+3B01 */
  0x0000,   /* U+3B02 */
  0x0000,   /* U+3B03 */
  0x0000,   /* U+3B04 */
  0x0000,   /* U+3B05 */
  0x0000,   /* U+3B06 */
  0x0000,   /* U+3B07 */
  0x0000,   /* U+3B08 */
  0x0000,   /* U+3B09 */
  0x0000,   /* U+3B0A */
  0x0000,   /* U+3B0B */
  0x0000,   /* U+3B0C */
  0x0000,   /* U+3B0D */
  0x0000,   /* U+3B0E */
  0x0000,   /* U+3B0F */
  0x0000,   /* U+3B10 */
  0x0000,   /* U+3B11 */
  0x0000,   /* U+3B12 */
  0x0000,   /* U+3B13 */
  0x0000,   /* U+3B14 */
  0x0000,   /* U+3B15 */
  0x0000,   /* U+3B16 */
  0x0000,   /* U+3B17 */
  0x0000,   /* U+3B18 */
  0x0000,   /* U+3B19 */
  0x0000,   /* U+3B1A */
  0x0000,   /* U+3B1B */
  0x0000,   /* U+3B1C */
  0x0000,   /* U+3B1D */
  0x0000,   /* U+3B1E */
  0x0000,   /* U+3B1F */
  0x0000,   /* U+3B20 */
  0x0000,   /* U+3B21 */
  0x0000,   /* U+3B22 */
  0x0000,   /* U+3B23 */
  0x0000,   /* U+3B24 */
  0x0000,   /* U+3B25 */
  0x0000,   /* U+3B26 */
  0x0000,   /* U+3B27 */
  0x0000,   /* U+3B28 */
  0x0000,   /* U+3B29 */
  0x0000,   /* U+3B2A */
  0x0000,   /* U+3B2B */
  0x0000,   /* U+3B2C */
  0x0000,   /* U+3B2D */
  0x0000,   /* U+3B2E */
  0x0000,   /* U+3B2F */
  0x0000,   /* U+3B30 */
  0x0000,   /* U+3B31 */
  0x0000,   /* U+3B32 */
  0x0000,   /* U+3B33 */
  0x0000,   /* U+3B34 */
  0x0000,   /* U+3B35 */
  0x0000,   /* U+3B36 */
  0x0000,   /* U+3B37 */
  0x0000,   /* U+3B38 */
  0x0000,   /* U+3B39 */
  0x0000,   /* U+3B3A */
  0x0000,   /* U+3B3B */
  0x0000,   /* U+3B3C */
  0x0000,   /* U+3B3D */
  0x0000,   /* U+3B3E */
  0x0000,   /* U+3B3F */
  0x0000,   /* U+3B40 */
  0x0000,   /* U+3B41 */
  0x0000,   /* U+3B42 */
  0x0000,   /* U+3B43 */
  0x0000,   /* U+3B44 */
  0x0000,   /* U+3B45 */
  0x0000,   /* U+3B46 */
  0x0000,   /* U+3B47 */
  0x0000,   /* U+3B48 */
  0x0000,   /* U+3B49 */
  0x0000,   /* U+3B4A */
  0x0000,   /* U+3B4B */
  0x0000,   /* U+3B4C */
  0x0000,   /* U+3B4D */
  0x0000,   /* U+3B4E */
  0x0000,   /* U+3B4F */
  0x0000,   /* U+3B50 */
  0x0000,   /* U+3B51 */
  0x0000,   /* U+3B52 */
  0x0000,   /* U+3B53 */
  0x0000,   /* U+3B54 */
  0x0000,   /* U+3B55 */
  0x0000,   /* U+3B56 */
  0x0000,   /* U+3B57 */
  0x0000,   /* U+3B58 */
  0x0000,   /* U+3B59 */
  0x0000,   /* U+3B5A */
  0x0000,   /* U+3B5B */
  0x0000,   /* U+3B5C */
  0x0000,   /* U+3B5D */
  0x0000,   /* U+3B5E */
  0x0000,   /* U+3B5F */
  0x0000,   /* U+3B60 */
  0x0000,   /* U+3B61 */
  0x0000,   /* U+3B62 */
  0x0000,   /* U+3B63 */
  0x0000,   /* U+3B64 */
  0x0000,   /* U+3B65 */
  0x0000,   /* U+3B66 */
  0x0000,   /* U+3B67 */
  0x0000,   /* U+3B68 */
  0x0000,   /* U+3B69 */
  0x0000,   /* U+3B6A */
  0x0000,   /* U+3B6B */
  0x0000,   /* U+3B6C */
  0x0000,   /* U+3B6D */
  0x0000,   /* U+3B6E */
  0x0000,   /* U+3B6F */
  0x0000,   /* U+3B70 */
  0x0000,   /* U+3B71 */
  0x0000,   /* U+3B72 */
  0x0000,   /* U+3B73 */
  0x0000,   /* U+3B74 */
  0x0000,   /* U+3B75 */
  0x0000,   /* U+3B76 */
  0x0000,   /* U+3B77 */
  0x0000,   /* U+3B78 */
  0x0000,   /* U+3B79 */
  0x0000,   /* U+3B7A */
  0x0000,   /* U+3B7B */
  0x0000,   /* U+3B7C */
  0x0000,   /* U+3B7D */
  0x0000,   /* U+3B7E */
  0x0000,   /* U+3B7F */
  0x0000,   /* U+3B80 */
  0x0000,   /* U+3B81 */
  0x0000,   /* U+3B82 */
  0x0000,   /* U+3B83 */
  0x0000,   /* U+3B84 */
  0x0000,   /* U+3B85 */
  0x0000,   /* U+3B86 */
  0x0000,   /* U+3B87 */
  0x0000,   /* U+3B88 */
  0x0000,   /* U+3B89 */
  0x0000,   /* U+3B8A */
  0x0000,   /* U+3B8B */
  0x0000,   /* U+3B8C */
  0x0000,   /* U+3B8D */
  0x0000,   /* U+3B8E */
  0x0000,   /* U+3B8F */
  0x0000,   /* U+3B90 */
  0x0000,   /* U+3B91 */
  0x0000,   /* U+3B92 */
  0x0000,   /* U+3B93 */
  0x0000,   /* U+3B94 */
  0x0000,   /* U+3B95 */
  0x0000,   /* U+3B96 */
  0x0000,   /* U+3B97 */
  0x0000,   /* U+3B98 */
  0x0000,   /* U+3B99 */
  0x0000,   /* U+3B9A */
  0x0000,   /* U+3B9B */
  0x0000,   /* U+3B9C */
  0x0000,   /* U+3B9D */
  0x0000,   /* U+3B9E */
  0x0000,   /* U+3B9F */
  0x0000,   /* U+3BA0 */
  0x0000,   /* U+3BA1 */
  0x0000,   /* U+3BA2 */
  0x0000,   /* U+3BA3 */
  0x0000,   /* U+3BA4 */
  0x0000,   /* U+3BA5 */
  0x0000,   /* U+3BA6 */
  0x0000,   /* U+3BA7 */
  0x0000,   /* U+3BA8 */
  0x0000,   /* U+3BA9 */
  0x0000,   /* U+3BAA */
  0x0000,   /* U+3BAB */
  0x0000,   /* U+3BAC */
  0x0000,   /* U+3BAD */
  0x0000,   /* U+3BAE */
  0x0000,   /* U+3BAF */
  0x0000,   /* U+3BB0 */
  0x0000,   /* U+3BB1 */
  0x0000,   /* U+3BB2 */
  0x0000,   /* U+3BB3 */
  0x0000,   /* U+3BB4 */
  0x0000,   /* U+3BB5 */
  0x0000,   /* U+3BB6 */
  0x0000,   /* U+3BB7 */
  0x0000,   /* U+3BB8 */
  0x0000,   /* U+3BB9 */
  0x0000,   /* U+3BBA */
  0x0000,   /* U+3BBB */
  0x0000,   /* U+3BBC */
  0x0000,   /* U+3BBD */
  0x0000,   /* U+3BBE */
  0x0000,   /* U+3BBF */
  0x0000,   /* U+3BC0 */
  0x0000,   /* U+3BC1 */
  0x0000,   /* U+3BC2 */
  0x0000,   /* U+3BC3 */
  0x0000,   /* U+3BC4 */
  0x0000,   /* U+3BC5 */
  0x0000,   /* U+3BC6 */
  0x0000,   /* U+3BC7 */
  0x0000,   /* U+3BC8 */
  0x0000,   /* U+3BC9 */
  0x0000,   /* U+3BCA */
  0x0000,   /* U+3BCB */
  0x0000,   /* U+3BCC */
  0x0000,   /* U+3BCD */
  0x0000,   /* U+3BCE */
  0x0000,   /* U+3BCF */
  0x0000,   /* U+3BD0 */
  0x0000,   /* U+3BD1 */
  0x0000,   /* U+3BD2 */
  0x0000,   /* U+3BD3 */
  0x0000,   /* U+3BD4 */
  0x0000,   /* U+3BD5 */
  0x0000,   /* U+3BD6 */
  0x0000,   /* U+3BD7 */
  0x0000,   /* U+3BD8 */
  0x0000,   /* U+3BD9 */
  0x0000,   /* U+3BDA */
  0x0000,   /* U+3BDB */
  0x0000,   /* U+3BDC */
  0x0000,   /* U+3BDD */
  0x0000,   /* U+3BDE */
  0x0000,   /* U+3BDF */
  0x0000,   /* U+3BE0 */
  0x0000,   /* U+3BE1 */
  0x0000,   /* U+3BE2 */
  0x0000,   /* U+3BE3 */
  0x0000,   /* U+3BE4 */
  0x0000,   /* U+3BE5 */
  0x0000,   /* U+3BE6 */
  0x0000,   /* U+3BE7 */
  0x0000,   /* U+3BE8 */
  0x0000,   /* U+3BE9 */
  0x0000,   /* U+3BEA */
  0x0000,   /* U+3BEB */
  0x0000,   /* U+3BEC */
  0x0000,   /* U+3BED */
  0x0000,   /* U+3BEE */
  0x0000,   /* U+3BEF */
  0x0000,   /* U+3BF0 */
  0x0000,   /* U+3BF1 */
  0x0000,   /* U+3BF2 */
  0x0000,   /* U+3BF3 */
  0x0000,   /* U+3BF4 */
  0x0000,   /* U+3BF5 */
  0x0000,   /* U+3BF6 */
  0x0000,   /* U+3BF7 */
  0x0000,   /* U+3BF8 */
  0x0000,   /* U+3BF9 */
  0x0000,   /* U+3BFA */
  0x0000,   /* U+3BFB */
  0x0000,   /* U+3BFC */
  0x0000,   /* U+3BFD */
  0x0000,   /* U+3BFE */
  0x0000,   /* U+3BFF */
};

uint16 zh2_han_p03C[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x2F1B,   /* U+3C00 */
  0x2F1B,   /* U+3C01 */
  0x2F1B,   /* U+3C02 */
  0x2F1B,   /* U+3C03 */
  0x2F1B,   /* U+3C04 */
  0x2F1B,   /* U+3C05 */
  0x2F1B,   /* U+3C06 */
  0x2F1B,   /* U+3C07 */
  0x2F1B,   /* U+3C08 */
  0x2F1C,   /* U+3C09 */
  0x2F1C,   /* U+3C0A */
  0x2F1C,   /* U+3C0B */
  0x2F1C,   /* U+3C0C */
  0x2F1C,   /* U+3C0D */
  0x2F1C,   /* U+3C0E */
  0x2F1C,   /* U+3C0F */
  0x2F1C,   /* U+3C10 */
  0x2F1C,   /* U+3C11 */
  0x2F1C,   /* U+3C12 */
  0x5C49,   /* U+3C13 */
  0x2F1D,   /* U+3C14 */
  0x2F1D,   /* U+3C15 */
  0x2F1C,   /* U+3C16 */
  0x2F1E,   /* U+3C17 */
  0x2F1E,   /* U+3C18 */
  0x2F1F,   /* U+3C19 */
  0x2F1F,   /* U+3C1A */
  0x2F1F,   /* U+3C1B */
  0x5C49,   /* U+3C1C */
  0x2F4F,   /* U+3C1D */
  0x2F4F,   /* U+3C1E */
  0x2F50,   /* U+3C1F */
  0x2F50,   /* U+3C20 */
  0x2F50,   /* U+3C21 */
  0x2F50,   /* U+3C22 */
  0x2F51,   /* U+3C23 */
  0x2F51,   /* U+3C24 */
  0x2F51,   /* U+3C25 */
  0x2F51,   /* U+3C26 */
  0x2F51,   /* U+3C27 */
  0x2F51,   /* U+3C28 */
  0x2F52,   /* U+3C29 */
  0x2F52,   /* U+3C2A */
  0x2F52,   /* U+3C2B */
  0x2F52,   /* U+3C2C */
  0x2F52,   /* U+3C2D */
  0x2F53,   /* U+3C2E */
  0x2F53,   /* U+3C2F */
  0x2F53,   /* U+3C30 */
  0x2F53,   /* U+3C31 */
  0x2F54,   /* U+3C32 */
  0x2F54,   /* U+3C33 */
  0x2F54,   /* U+3C34 */
  0x2F54,   /* U+3C35 */
  0x2F54,   /* U+3C36 */
  0x2FD2,   /* U+3C37 */
  0x5C49,   /* U+3C38 */
  0x2F55,   /* U+3C39 */
  0x2F55,   /* U+3C3A */
  0x2F55,   /* U+3C3B */
  0x2F55,   /* U+3C3C */
  0x2F55,   /* U+3C3D */
  0x2F55,   /* U+3C3E */
  0x2F4D,   /* U+3C3F */
  0x2F4D,   /* U+3C40 */
  0x2F4D,   /* U+3C41 */
  0x2F57,   /* U+3C42 */
  0x2F57,   /* U+3C43 */
  0x2F58,   /* U+3C44 */
  0x2F58,   /* U+3C45 */
  0x2F59,   /* U+3C46 */
  0x2F59,   /* U+3C47 */
  0x2F59,   /* U+3C48 */
  0x2F59,   /* U+3C49 */
  0x2F5B,   /* U+3C4A */
  0x2F5C,   /* U+3C4B */
  0x2F5E,   /* U+3C4C */
  0x2F5F,   /* U+3C4D */
  0x2F61,   /* U+3C4E */
  0x2F8E,   /* U+3C4F */
  0x5C49,   /* U+3C50 */
  0x5C49,   /* U+3C51 */
  0x2F91,   /* U+3C52 */
  0x5C49,   /* U+3C53 */
  0x2F91,   /* U+3C54 */
  0x2F94,   /* U+3C55 */
  0x2F94,   /* U+3C56 */
  0x2F8D,   /* U+3C57 */
  0x2F9A,   /* U+3C58 */
  0x2FCE,   /* U+3C59 */
  0x2FD0,   /* U+3C5A */
  0x2FD0,   /* U+3C5B */
  0x2FD0,   /* U+3C5C */
  0x5C49,   /* U+3C5D */
  0x2FD1,   /* U+3C5E */
  0x2FD1,   /* U+3C5F */
  0x2FD1,   /* U+3C60 */
  0x2FD2,   /* U+3C61 */
  0x2FD3,   /* U+3C62 */
  0x2FD3,   /* U+3C63 */
  0x2FD4,   /* U+3C64 */
  0x2FD4,   /* U+3C65 */
  0x2FD4,   /* U+3C66 */
  0x2FD4,   /* U+3C67 */
  0x2FD4,   /* U+3C68 */
  0x2FD4,   /* U+3C69 */
  0x2FD5,   /* U+3C6A */
  0x2FD5,   /* U+3C6B */
  0x2FD5,   /* U+3C6C */
  0x2FD5,   /* U+3C6D */
  0x2FD5,   /* U+3C6E */
  0x2FCD,   /* U+3C6F */
  0x2FCD,   /* U+3C70 */
  0x2FCD,   /* U+3C71 */
  0x2FCD,   /* U+3C72 */
  0x2FD7,   /* U+3C73 */
  0x2FD7,   /* U+3C74 */
  0x2FD8,   /* U+3C75 */
  0x2FD8,   /* U+3C76 */
  0x5C49,   /* U+3C77 */
  0x2FD9,   /* U+3C78 */
  0x2FDC,   /* U+3C79 */
  0x2FDC,   /* U+3C7A */
  0x2FDF,   /* U+3C7B */
  0x300F,   /* U+3C7C */
  0x3010,   /* U+3C7D */
  0x3012,   /* U+3C7E */
  0x3012,   /* U+3C7F */
  0x3013,   /* U+3C80 */
  0x3014,   /* U+3C81 */
  0x3014,   /* U+3C82 */
  0x3014,   /* U+3C83 */
  0x3015,   /* U+3C84 */
  0x300D,   /* U+3C85 */
  0x3018,   /* U+3C86 */
  0x3018,   /* U+3C87 */
  0x3018,   /* U+3C88 */
  0x3019,   /* U+3C89 */
  0x301A,   /* U+3C8A */
  0x3091,   /* U+3C8B */
  0x30CE,   /* U+3C8C */
  0x30D0,   /* U+3C8D */
  0x30D0,   /* U+3C8E */
  0x30D0,   /* U+3C8F */
  0x30D0,   /* U+3C90 */
  0x30D0,   /* U+3C91 */
  0x30D1,   /* U+3C92 */
  0x30D2,   /* U+3C93 */
  0x30D3,   /* U+3C94 */
  0x30D3,   /* U+3C95 */
  0x30D3,   /* U+3C96 */
  0x30D3,   /* U+3C97 */
  0x30D3,   /* U+3C98 */
  0x30D3,   /* U+3C99 */
  0x30D3,   /* U+3C9A */
  0x30D4,   /* U+3C9B */
  0x30D4,   /* U+3C9C */
  0x30D4,   /* U+3C9D */
  0x30D4,   /* U+3C9E */
  0x30D5,   /* U+3C9F */
  0x30D5,   /* U+3CA0 */
  0x30D5,   /* U+3CA1 */
  0x30D5,   /* U+3CA2 */
  0x30D5,   /* U+3CA3 */
  0x30CD,   /* U+3CA4 */
  0x30CD,   /* U+3CA5 */
  0x30CD,   /* U+3CA6 */
  0x30CD,   /* U+3CA7 */
  0x30CD,   /* U+3CA8 */
  0x5C49,   /* U+3CA9 */
  0x30D8,   /* U+3CAA */
  0x30D8,   /* U+3CAB */
  0x30D8,   /* U+3CAC */
  0x30D8,   /* U+3CAD */
  0x5C49,   /* U+3CAE */
  0x30DA,   /* U+3CAF */
  0x30DA,   /* U+3CB0 */
  0x30DB,   /* U+3CB1 */
  0x30E2,   /* U+3CB2 */
  0x3112,   /* U+3CB3 */
  0x3150,   /* U+3CB4 */
  0x3153,   /* U+3CB5 */
  0x3157,   /* U+3CB6 */
  0x3158,   /* U+3CB7 */
  0x318D,   /* U+3CB8 */
  0x318E,   /* U+3CB9 */
  0x318E,   /* U+3CBA */
  0x318E,   /* U+3CBB */
  0x318E,   /* U+3CBC */
  0x318F,   /* U+3CBD */
  0x318F,   /* U+3CBE */
  0x318F,   /* U+3CBF */
  0x3190,   /* U+3CC0 */
  0x3190,   /* U+3CC1 */
  0x3190,   /* U+3CC2 */
  0x3190,   /* U+3CC3 */
  0x3190,   /* U+3CC4 */
  0x3190,   /* U+3CC5 */
  0x3190,   /* U+3CC6 */
  0x3190,   /* U+3CC7 */
  0x3190,   /* U+3CC8 */
  0x3190,   /* U+3CC9 */
  0x3190,   /* U+3CCA */
  0x3191,   /* U+3CCB */
  0x3191,   /* U+3CCC */
  0x3191,   /* U+3CCD */
  0x3191,   /* U+3CCE */
  0x3191,   /* U+3CCF */
  0x3191,   /* U+3CD0 */
  0x3191,   /* U+3CD1 */
  0x3191,   /* U+3CD2 */
  0x5C49,   /* U+3CD3 */
  0x3191,   /* U+3CD4 */
  0x3191,   /* U+3CD5 */
  0x3192,   /* U+3CD6 */
  0x3192,   /* U+3CD7 */
  0x3192,   /* U+3CD8 */
  0x3192,   /* U+3CD9 */
  0x3192,   /* U+3CDA */
  0x3192,   /* U+3CDB */
  0x3192,   /* U+3CDC */
  0x3192,   /* U+3CDD */
  0x3192,   /* U+3CDE */
  0x5C49,   /* U+3CDF */
  0x3192,   /* U+3CE0 */
  0x3192,   /* U+3CE1 */
  0x3192,   /* U+3CE2 */
  0x5C49,   /* U+3CE3 */
  0x3193,   /* U+3CE4 */
  0x3193,   /* U+3CE5 */
  0x3193,   /* U+3CE6 */
  0x3193,   /* U+3CE7 */
  0x3193,   /* U+3CE8 */
  0x3193,   /* U+3CE9 */
  0x3193,   /* U+3CEA */
  0x3193,   /* U+3CEB */
  0x3193,   /* U+3CEC */
  0x3193,   /* U+3CED */
  0x3193,   /* U+3CEE */
  0x3193,   /* U+3CEF */
  0x3193,   /* U+3CF0 */
  0x3193,   /* U+3CF1 */
  0x5C49,   /* U+3CF2 */
  0x5C49,   /* U+3CF3 */
  0x3194,   /* U+3CF4 */
  0x3194,   /* U+3CF5 */
  0x3194,   /* U+3CF6 */
  0x3194,   /* U+3CF7 */
  0x3194,   /* U+3CF8 */
  0x3194,   /* U+3CF9 */
  0x3194,   /* U+3CFA */
  0x3194,   /* U+3CFB */
  0x3194,   /* U+3CFC */
  0x3194,   /* U+3CFD */
  0x3194,   /* U+3CFE */
  0x3194,   /* U+3CFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3C00 */
  0x0020,   /* U+3C01 */
  0x0020,   /* U+3C02 */
  0x0020,   /* U+3C03 */
  0x0020,   /* U+3C04 */
  0x0020,   /* U+3C05 */
  0x0020,   /* U+3C06 */
  0x0020,   /* U+3C07 */
  0x0020,   /* U+3C08 */
  0x0020,   /* U+3C09 */
  0x0020,   /* U+3C0A */
  0x0020,   /* U+3C0B */
  0x0020,   /* U+3C0C */
  0x0020,   /* U+3C0D */
  0x0020,   /* U+3C0E */
  0x0020,   /* U+3C0F */
  0x0020,   /* U+3C10 */
  0x0020,   /* U+3C11 */
  0x0020,   /* U+3C12 */
  0x0020,   /* U+3C13 */
  0x0020,   /* U+3C14 */
  0x0020,   /* U+3C15 */
  0x0020,   /* U+3C16 */
  0x0020,   /* U+3C17 */
  0x0020,   /* U+3C18 */
  0x0020,   /* U+3C19 */
  0x0020,   /* U+3C1A */
  0x0020,   /* U+3C1B */
  0x0020,   /* U+3C1C */
  0x0020,   /* U+3C1D */
  0x0020,   /* U+3C1E */
  0x0020,   /* U+3C1F */
  0x0020,   /* U+3C20 */
  0x0020,   /* U+3C21 */
  0x0020,   /* U+3C22 */
  0x0020,   /* U+3C23 */
  0x0020,   /* U+3C24 */
  0x0020,   /* U+3C25 */
  0x0020,   /* U+3C26 */
  0x0020,   /* U+3C27 */
  0x0020,   /* U+3C28 */
  0x0020,   /* U+3C29 */
  0x0020,   /* U+3C2A */
  0x0020,   /* U+3C2B */
  0x0020,   /* U+3C2C */
  0x0020,   /* U+3C2D */
  0x0020,   /* U+3C2E */
  0x0020,   /* U+3C2F */
  0x0020,   /* U+3C30 */
  0x0020,   /* U+3C31 */
  0x0020,   /* U+3C32 */
  0x0020,   /* U+3C33 */
  0x0020,   /* U+3C34 */
  0x0020,   /* U+3C35 */
  0x0020,   /* U+3C36 */
  0x0020,   /* U+3C37 */
  0x0020,   /* U+3C38 */
  0x0020,   /* U+3C39 */
  0x0020,   /* U+3C3A */
  0x0020,   /* U+3C3B */
  0x0020,   /* U+3C3C */
  0x0020,   /* U+3C3D */
  0x0020,   /* U+3C3E */
  0x0020,   /* U+3C3F */
  0x0020,   /* U+3C40 */
  0x0020,   /* U+3C41 */
  0x0020,   /* U+3C42 */
  0x0020,   /* U+3C43 */
  0x0020,   /* U+3C44 */
  0x0020,   /* U+3C45 */
  0x0020,   /* U+3C46 */
  0x0020,   /* U+3C47 */
  0x0020,   /* U+3C48 */
  0x0020,   /* U+3C49 */
  0x0020,   /* U+3C4A */
  0x0020,   /* U+3C4B */
  0x0020,   /* U+3C4C */
  0x0020,   /* U+3C4D */
  0x0020,   /* U+3C4E */
  0x0020,   /* U+3C4F */
  0x0020,   /* U+3C50 */
  0x0020,   /* U+3C51 */
  0x0020,   /* U+3C52 */
  0x0020,   /* U+3C53 */
  0x0020,   /* U+3C54 */
  0x0020,   /* U+3C55 */
  0x0020,   /* U+3C56 */
  0x0020,   /* U+3C57 */
  0x0020,   /* U+3C58 */
  0x0020,   /* U+3C59 */
  0x0020,   /* U+3C5A */
  0x0020,   /* U+3C5B */
  0x0020,   /* U+3C5C */
  0x0020,   /* U+3C5D */
  0x0020,   /* U+3C5E */
  0x0020,   /* U+3C5F */
  0x0020,   /* U+3C60 */
  0x0020,   /* U+3C61 */
  0x0020,   /* U+3C62 */
  0x0020,   /* U+3C63 */
  0x0020,   /* U+3C64 */
  0x0020,   /* U+3C65 */
  0x0020,   /* U+3C66 */
  0x0020,   /* U+3C67 */
  0x0020,   /* U+3C68 */
  0x0020,   /* U+3C69 */
  0x0020,   /* U+3C6A */
  0x0020,   /* U+3C6B */
  0x0020,   /* U+3C6C */
  0x0020,   /* U+3C6D */
  0x0020,   /* U+3C6E */
  0x0020,   /* U+3C6F */
  0x0020,   /* U+3C70 */
  0x0020,   /* U+3C71 */
  0x0020,   /* U+3C72 */
  0x0020,   /* U+3C73 */
  0x0020,   /* U+3C74 */
  0x0020,   /* U+3C75 */
  0x0020,   /* U+3C76 */
  0x0020,   /* U+3C77 */
  0x0020,   /* U+3C78 */
  0x0020,   /* U+3C79 */
  0x0020,   /* U+3C7A */
  0x0020,   /* U+3C7B */
  0x0020,   /* U+3C7C */
  0x0020,   /* U+3C7D */
  0x0020,   /* U+3C7E */
  0x0020,   /* U+3C7F */
  0x0020,   /* U+3C80 */
  0x0020,   /* U+3C81 */
  0x0020,   /* U+3C82 */
  0x0020,   /* U+3C83 */
  0x0020,   /* U+3C84 */
  0x0020,   /* U+3C85 */
  0x0020,   /* U+3C86 */
  0x0020,   /* U+3C87 */
  0x0020,   /* U+3C88 */
  0x0020,   /* U+3C89 */
  0x0020,   /* U+3C8A */
  0x0020,   /* U+3C8B */
  0x0020,   /* U+3C8C */
  0x0020,   /* U+3C8D */
  0x0020,   /* U+3C8E */
  0x0020,   /* U+3C8F */
  0x0020,   /* U+3C90 */
  0x0020,   /* U+3C91 */
  0x0020,   /* U+3C92 */
  0x0020,   /* U+3C93 */
  0x0020,   /* U+3C94 */
  0x0020,   /* U+3C95 */
  0x0020,   /* U+3C96 */
  0x0020,   /* U+3C97 */
  0x0020,   /* U+3C98 */
  0x0020,   /* U+3C99 */
  0x0020,   /* U+3C9A */
  0x0020,   /* U+3C9B */
  0x0020,   /* U+3C9C */
  0x0020,   /* U+3C9D */
  0x0020,   /* U+3C9E */
  0x0020,   /* U+3C9F */
  0x0020,   /* U+3CA0 */
  0x0020,   /* U+3CA1 */
  0x0020,   /* U+3CA2 */
  0x0020,   /* U+3CA3 */
  0x0020,   /* U+3CA4 */
  0x0020,   /* U+3CA5 */
  0x0020,   /* U+3CA6 */
  0x0020,   /* U+3CA7 */
  0x0020,   /* U+3CA8 */
  0x0020,   /* U+3CA9 */
  0x0020,   /* U+3CAA */
  0x0020,   /* U+3CAB */
  0x0020,   /* U+3CAC */
  0x0020,   /* U+3CAD */
  0x0020,   /* U+3CAE */
  0x0020,   /* U+3CAF */
  0x0020,   /* U+3CB0 */
  0x0020,   /* U+3CB1 */
  0x0020,   /* U+3CB2 */
  0x0020,   /* U+3CB3 */
  0x0020,   /* U+3CB4 */
  0x0020,   /* U+3CB5 */
  0x0020,   /* U+3CB6 */
  0x0020,   /* U+3CB7 */
  0x0020,   /* U+3CB8 */
  0x0020,   /* U+3CB9 */
  0x0020,   /* U+3CBA */
  0x0020,   /* U+3CBB */
  0x0020,   /* U+3CBC */
  0x0020,   /* U+3CBD */
  0x0020,   /* U+3CBE */
  0x0020,   /* U+3CBF */
  0x0020,   /* U+3CC0 */
  0x0020,   /* U+3CC1 */
  0x0020,   /* U+3CC2 */
  0x0020,   /* U+3CC3 */
  0x0020,   /* U+3CC4 */
  0x0020,   /* U+3CC5 */
  0x0020,   /* U+3CC6 */
  0x0020,   /* U+3CC7 */
  0x0020,   /* U+3CC8 */
  0x0020,   /* U+3CC9 */
  0x0020,   /* U+3CCA */
  0x0020,   /* U+3CCB */
  0x0020,   /* U+3CCC */
  0x0020,   /* U+3CCD */
  0x0020,   /* U+3CCE */
  0x0020,   /* U+3CCF */
  0x0020,   /* U+3CD0 */
  0x0020,   /* U+3CD1 */
  0x0020,   /* U+3CD2 */
  0x0020,   /* U+3CD3 */
  0x0020,   /* U+3CD4 */
  0x0020,   /* U+3CD5 */
  0x0020,   /* U+3CD6 */
  0x0020,   /* U+3CD7 */
  0x0020,   /* U+3CD8 */
  0x0020,   /* U+3CD9 */
  0x0020,   /* U+3CDA */
  0x0020,   /* U+3CDB */
  0x0020,   /* U+3CDC */
  0x0020,   /* U+3CDD */
  0x0020,   /* U+3CDE */
  0x0020,   /* U+3CDF */
  0x0020,   /* U+3CE0 */
  0x0020,   /* U+3CE1 */
  0x0020,   /* U+3CE2 */
  0x0020,   /* U+3CE3 */
  0x0020,   /* U+3CE4 */
  0x0020,   /* U+3CE5 */
  0x0020,   /* U+3CE6 */
  0x0020,   /* U+3CE7 */
  0x0020,   /* U+3CE8 */
  0x0020,   /* U+3CE9 */
  0x0020,   /* U+3CEA */
  0x0020,   /* U+3CEB */
  0x0020,   /* U+3CEC */
  0x0020,   /* U+3CED */
  0x0020,   /* U+3CEE */
  0x0020,   /* U+3CEF */
  0x0020,   /* U+3CF0 */
  0x0020,   /* U+3CF1 */
  0x0020,   /* U+3CF2 */
  0x0020,   /* U+3CF3 */
  0x0020,   /* U+3CF4 */
  0x0020,   /* U+3CF5 */
  0x0020,   /* U+3CF6 */
  0x0020,   /* U+3CF7 */
  0x0020,   /* U+3CF8 */
  0x0020,   /* U+3CF9 */
  0x0020,   /* U+3CFA */
  0x0020,   /* U+3CFB */
  0x0020,   /* U+3CFC */
  0x0020,   /* U+3CFD */
  0x0020,   /* U+3CFE */
  0x0020,   /* U+3CFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3C00 */
  0x0002,   /* U+3C01 */
  0x0002,   /* U+3C02 */
  0x0002,   /* U+3C03 */
  0x0002,   /* U+3C04 */
  0x0002,   /* U+3C05 */
  0x0002,   /* U+3C06 */
  0x0002,   /* U+3C07 */
  0x0002,   /* U+3C08 */
  0x0002,   /* U+3C09 */
  0x0002,   /* U+3C0A */
  0x0002,   /* U+3C0B */
  0x0002,   /* U+3C0C */
  0x0002,   /* U+3C0D */
  0x0002,   /* U+3C0E */
  0x0002,   /* U+3C0F */
  0x0002,   /* U+3C10 */
  0x0002,   /* U+3C11 */
  0x0002,   /* U+3C12 */
  0x0002,   /* U+3C13 */
  0x0002,   /* U+3C14 */
  0x0002,   /* U+3C15 */
  0x0002,   /* U+3C16 */
  0x0002,   /* U+3C17 */
  0x0002,   /* U+3C18 */
  0x0002,   /* U+3C19 */
  0x0002,   /* U+3C1A */
  0x0002,   /* U+3C1B */
  0x0002,   /* U+3C1C */
  0x0002,   /* U+3C1D */
  0x0002,   /* U+3C1E */
  0x0002,   /* U+3C1F */
  0x0002,   /* U+3C20 */
  0x0002,   /* U+3C21 */
  0x0002,   /* U+3C22 */
  0x0002,   /* U+3C23 */
  0x0002,   /* U+3C24 */
  0x0002,   /* U+3C25 */
  0x0002,   /* U+3C26 */
  0x0002,   /* U+3C27 */
  0x0002,   /* U+3C28 */
  0x0002,   /* U+3C29 */
  0x0002,   /* U+3C2A */
  0x0002,   /* U+3C2B */
  0x0002,   /* U+3C2C */
  0x0002,   /* U+3C2D */
  0x0002,   /* U+3C2E */
  0x0002,   /* U+3C2F */
  0x0002,   /* U+3C30 */
  0x0002,   /* U+3C31 */
  0x0002,   /* U+3C32 */
  0x0002,   /* U+3C33 */
  0x0002,   /* U+3C34 */
  0x0002,   /* U+3C35 */
  0x0002,   /* U+3C36 */
  0x0002,   /* U+3C37 */
  0x0002,   /* U+3C38 */
  0x0002,   /* U+3C39 */
  0x0002,   /* U+3C3A */
  0x0002,   /* U+3C3B */
  0x0002,   /* U+3C3C */
  0x0002,   /* U+3C3D */
  0x0002,   /* U+3C3E */
  0x0002,   /* U+3C3F */
  0x0002,   /* U+3C40 */
  0x0002,   /* U+3C41 */
  0x0002,   /* U+3C42 */
  0x0002,   /* U+3C43 */
  0x0002,   /* U+3C44 */
  0x0002,   /* U+3C45 */
  0x0002,   /* U+3C46 */
  0x0002,   /* U+3C47 */
  0x0002,   /* U+3C48 */
  0x0002,   /* U+3C49 */
  0x0002,   /* U+3C4A */
  0x0002,   /* U+3C4B */
  0x0002,   /* U+3C4C */
  0x0002,   /* U+3C4D */
  0x0002,   /* U+3C4E */
  0x0002,   /* U+3C4F */
  0x0002,   /* U+3C50 */
  0x0002,   /* U+3C51 */
  0x0002,   /* U+3C52 */
  0x0002,   /* U+3C53 */
  0x0002,   /* U+3C54 */
  0x0002,   /* U+3C55 */
  0x0002,   /* U+3C56 */
  0x0002,   /* U+3C57 */
  0x0002,   /* U+3C58 */
  0x0002,   /* U+3C59 */
  0x0002,   /* U+3C5A */
  0x0002,   /* U+3C5B */
  0x0002,   /* U+3C5C */
  0x0002,   /* U+3C5D */
  0x0002,   /* U+3C5E */
  0x0002,   /* U+3C5F */
  0x0002,   /* U+3C60 */
  0x0002,   /* U+3C61 */
  0x0002,   /* U+3C62 */
  0x0002,   /* U+3C63 */
  0x0002,   /* U+3C64 */
  0x0002,   /* U+3C65 */
  0x0002,   /* U+3C66 */
  0x0002,   /* U+3C67 */
  0x0002,   /* U+3C68 */
  0x0002,   /* U+3C69 */
  0x0002,   /* U+3C6A */
  0x0002,   /* U+3C6B */
  0x0002,   /* U+3C6C */
  0x0002,   /* U+3C6D */
  0x0002,   /* U+3C6E */
  0x0002,   /* U+3C6F */
  0x0002,   /* U+3C70 */
  0x0002,   /* U+3C71 */
  0x0002,   /* U+3C72 */
  0x0002,   /* U+3C73 */
  0x0002,   /* U+3C74 */
  0x0002,   /* U+3C75 */
  0x0002,   /* U+3C76 */
  0x0002,   /* U+3C77 */
  0x0002,   /* U+3C78 */
  0x0002,   /* U+3C79 */
  0x0002,   /* U+3C7A */
  0x0002,   /* U+3C7B */
  0x0002,   /* U+3C7C */
  0x0002,   /* U+3C7D */
  0x0002,   /* U+3C7E */
  0x0002,   /* U+3C7F */
  0x0002,   /* U+3C80 */
  0x0002,   /* U+3C81 */
  0x0002,   /* U+3C82 */
  0x0002,   /* U+3C83 */
  0x0002,   /* U+3C84 */
  0x0002,   /* U+3C85 */
  0x0002,   /* U+3C86 */
  0x0002,   /* U+3C87 */
  0x0002,   /* U+3C88 */
  0x0002,   /* U+3C89 */
  0x0002,   /* U+3C8A */
  0x0002,   /* U+3C8B */
  0x0002,   /* U+3C8C */
  0x0002,   /* U+3C8D */
  0x0002,   /* U+3C8E */
  0x0002,   /* U+3C8F */
  0x0002,   /* U+3C90 */
  0x0002,   /* U+3C91 */
  0x0002,   /* U+3C92 */
  0x0002,   /* U+3C93 */
  0x0002,   /* U+3C94 */
  0x0002,   /* U+3C95 */
  0x0002,   /* U+3C96 */
  0x0002,   /* U+3C97 */
  0x0002,   /* U+3C98 */
  0x0002,   /* U+3C99 */
  0x0002,   /* U+3C9A */
  0x0002,   /* U+3C9B */
  0x0002,   /* U+3C9C */
  0x0002,   /* U+3C9D */
  0x0002,   /* U+3C9E */
  0x0002,   /* U+3C9F */
  0x0002,   /* U+3CA0 */
  0x0002,   /* U+3CA1 */
  0x0002,   /* U+3CA2 */
  0x0002,   /* U+3CA3 */
  0x0002,   /* U+3CA4 */
  0x0002,   /* U+3CA5 */
  0x0002,   /* U+3CA6 */
  0x0002,   /* U+3CA7 */
  0x0002,   /* U+3CA8 */
  0x0002,   /* U+3CA9 */
  0x0002,   /* U+3CAA */
  0x0002,   /* U+3CAB */
  0x0002,   /* U+3CAC */
  0x0002,   /* U+3CAD */
  0x0002,   /* U+3CAE */
  0x0002,   /* U+3CAF */
  0x0002,   /* U+3CB0 */
  0x0002,   /* U+3CB1 */
  0x0002,   /* U+3CB2 */
  0x0002,   /* U+3CB3 */
  0x0002,   /* U+3CB4 */
  0x0002,   /* U+3CB5 */
  0x0002,   /* U+3CB6 */
  0x0002,   /* U+3CB7 */
  0x0002,   /* U+3CB8 */
  0x0002,   /* U+3CB9 */
  0x0002,   /* U+3CBA */
  0x0002,   /* U+3CBB */
  0x0002,   /* U+3CBC */
  0x0002,   /* U+3CBD */
  0x0002,   /* U+3CBE */
  0x0002,   /* U+3CBF */
  0x0002,   /* U+3CC0 */
  0x0002,   /* U+3CC1 */
  0x0002,   /* U+3CC2 */
  0x0002,   /* U+3CC3 */
  0x0002,   /* U+3CC4 */
  0x0002,   /* U+3CC5 */
  0x0002,   /* U+3CC6 */
  0x0002,   /* U+3CC7 */
  0x0002,   /* U+3CC8 */
  0x0002,   /* U+3CC9 */
  0x0002,   /* U+3CCA */
  0x0002,   /* U+3CCB */
  0x0002,   /* U+3CCC */
  0x0002,   /* U+3CCD */
  0x0002,   /* U+3CCE */
  0x0002,   /* U+3CCF */
  0x0002,   /* U+3CD0 */
  0x0002,   /* U+3CD1 */
  0x0002,   /* U+3CD2 */
  0x0002,   /* U+3CD3 */
  0x0002,   /* U+3CD4 */
  0x0002,   /* U+3CD5 */
  0x0002,   /* U+3CD6 */
  0x0002,   /* U+3CD7 */
  0x0002,   /* U+3CD8 */
  0x0002,   /* U+3CD9 */
  0x0002,   /* U+3CDA */
  0x0002,   /* U+3CDB */
  0x0002,   /* U+3CDC */
  0x0002,   /* U+3CDD */
  0x0002,   /* U+3CDE */
  0x0002,   /* U+3CDF */
  0x0002,   /* U+3CE0 */
  0x0002,   /* U+3CE1 */
  0x0002,   /* U+3CE2 */
  0x0002,   /* U+3CE3 */
  0x0002,   /* U+3CE4 */
  0x0002,   /* U+3CE5 */
  0x0002,   /* U+3CE6 */
  0x0002,   /* U+3CE7 */
  0x0002,   /* U+3CE8 */
  0x0002,   /* U+3CE9 */
  0x0002,   /* U+3CEA */
  0x0002,   /* U+3CEB */
  0x0002,   /* U+3CEC */
  0x0002,   /* U+3CED */
  0x0002,   /* U+3CEE */
  0x0002,   /* U+3CEF */
  0x0002,   /* U+3CF0 */
  0x0002,   /* U+3CF1 */
  0x0002,   /* U+3CF2 */
  0x0002,   /* U+3CF3 */
  0x0002,   /* U+3CF4 */
  0x0002,   /* U+3CF5 */
  0x0002,   /* U+3CF6 */
  0x0002,   /* U+3CF7 */
  0x0002,   /* U+3CF8 */
  0x0002,   /* U+3CF9 */
  0x0002,   /* U+3CFA */
  0x0002,   /* U+3CFB */
  0x0002,   /* U+3CFC */
  0x0002,   /* U+3CFD */
  0x0002,   /* U+3CFE */
  0x0002,   /* U+3CFF */

  /* Primary weight 2 for each character. */
  0x8002,   /* U+3C00 */
  0x8003,   /* U+3C01 */
  0x8004,   /* U+3C02 */
  0x8005,   /* U+3C03 */
  0x8006,   /* U+3C04 */
  0x8007,   /* U+3C05 */
  0x8008,   /* U+3C06 */
  0x8009,   /* U+3C07 */
  0x800A,   /* U+3C08 */
  0x8000,   /* U+3C09 */
  0x8001,   /* U+3C0A */
  0x8002,   /* U+3C0B */
  0x8003,   /* U+3C0C */
  0x8004,   /* U+3C0D */
  0x8005,   /* U+3C0E */
  0x8006,   /* U+3C0F */
  0x8007,   /* U+3C10 */
  0x8008,   /* U+3C11 */
  0x8009,   /* U+3C12 */
  0xBC13,   /* U+3C13 */
  0x8000,   /* U+3C14 */
  0x8001,   /* U+3C15 */
  0x800A,   /* U+3C16 */
  0x8000,   /* U+3C17 */
  0x8001,   /* U+3C18 */
  0x8000,   /* U+3C19 */
  0x8001,   /* U+3C1A */
  0x8002,   /* U+3C1B */
  0xBC1C,   /* U+3C1C */
  0x8000,   /* U+3C1D */
  0x8001,   /* U+3C1E */
  0x8000,   /* U+3C1F */
  0x8001,   /* U+3C20 */
  0x8002,   /* U+3C21 */
  0x8003,   /* U+3C22 */
  0x8000,   /* U+3C23 */
  0x8001,   /* U+3C24 */
  0x8002,   /* U+3C25 */
  0x8003,   /* U+3C26 */
  0x8004,   /* U+3C27 */
  0x8005,   /* U+3C28 */
  0x8000,   /* U+3C29 */
  0x8001,   /* U+3C2A */
  0x8002,   /* U+3C2B */
  0x8003,   /* U+3C2C */
  0x8004,   /* U+3C2D */
  0x8000,   /* U+3C2E */
  0x8001,   /* U+3C2F */
  0x8002,   /* U+3C30 */
  0x8003,   /* U+3C31 */
  0x8000,   /* U+3C32 */
  0x8001,   /* U+3C33 */
  0x8002,   /* U+3C34 */
  0x8003,   /* U+3C35 */
  0x8004,   /* U+3C36 */
  0x8000,   /* U+3C37 */
  0xBC38,   /* U+3C38 */
  0x8000,   /* U+3C39 */
  0x8001,   /* U+3C3A */
  0x8002,   /* U+3C3B */
  0x8003,   /* U+3C3C */
  0x8004,   /* U+3C3D */
  0x8005,   /* U+3C3E */
  0x8000,   /* U+3C3F */
  0x8001,   /* U+3C40 */
  0x8002,   /* U+3C41 */
  0x8000,   /* U+3C42 */
  0x8001,   /* U+3C43 */
  0x8000,   /* U+3C44 */
  0x8001,   /* U+3C45 */
  0x8000,   /* U+3C46 */
  0x8001,   /* U+3C47 */
  0x8002,   /* U+3C48 */
  0x8003,   /* U+3C49 */
  0x8000,   /* U+3C4A */
  0x8000,   /* U+3C4B */
  0x8000,   /* U+3C4C */
  0x8000,   /* U+3C4D */
  0x8000,   /* U+3C4E */
  0x8000,   /* U+3C4F */
  0xBC50,   /* U+3C50 */
  0xBC51,   /* U+3C51 */
  0x8000,   /* U+3C52 */
  0xBC53,   /* U+3C53 */
  0x8001,   /* U+3C54 */
  0x8000,   /* U+3C55 */
  0x8001,   /* U+3C56 */
  0x8000,   /* U+3C57 */
  0x8000,   /* U+3C58 */
  0x8000,   /* U+3C59 */
  0x8000,   /* U+3C5A */
  0x8001,   /* U+3C5B */
  0x8002,   /* U+3C5C */
  0xBC5D,   /* U+3C5D */
  0x8000,   /* U+3C5E */
  0x8001,   /* U+3C5F */
  0x8002,   /* U+3C60 */
  0x8001,   /* U+3C61 */
  0x8000,   /* U+3C62 */
  0x8001,   /* U+3C63 */
  0x8000,   /* U+3C64 */
  0x8001,   /* U+3C65 */
  0x8002,   /* U+3C66 */
  0x8003,   /* U+3C67 */
  0x8004,   /* U+3C68 */
  0x8005,   /* U+3C69 */
  0x8000,   /* U+3C6A */
  0x8001,   /* U+3C6B */
  0x8002,   /* U+3C6C */
  0x8003,   /* U+3C6D */
  0x8004,   /* U+3C6E */
  0x8000,   /* U+3C6F */
  0x8001,   /* U+3C70 */
  0x8002,   /* U+3C71 */
  0x8003,   /* U+3C72 */
  0x8000,   /* U+3C73 */
  0x8001,   /* U+3C74 */
  0x8000,   /* U+3C75 */
  0x8001,   /* U+3C76 */
  0xBC77,   /* U+3C77 */
  0x8000,   /* U+3C78 */
  0x8000,   /* U+3C79 */
  0x8001,   /* U+3C7A */
  0x8000,   /* U+3C7B */
  0x8000,   /* U+3C7C */
  0x8000,   /* U+3C7D */
  0x8000,   /* U+3C7E */
  0x8001,   /* U+3C7F */
  0x8000,   /* U+3C80 */
  0x8000,   /* U+3C81 */
  0x8001,   /* U+3C82 */
  0x8002,   /* U+3C83 */
  0x8000,   /* U+3C84 */
  0x8000,   /* U+3C85 */
  0x8000,   /* U+3C86 */
  0x8001,   /* U+3C87 */
  0x8002,   /* U+3C88 */
  0x8000,   /* U+3C89 */
  0x8000,   /* U+3C8A */
  0x8000,   /* U+3C8B */
  0x8000,   /* U+3C8C */
  0x8000,   /* U+3C8D */
  0x8001,   /* U+3C8E */
  0x8002,   /* U+3C8F */
  0x8003,   /* U+3C90 */
  0x8004,   /* U+3C91 */
  0x8000,   /* U+3C92 */
  0x8000,   /* U+3C93 */
  0x8000,   /* U+3C94 */
  0x8001,   /* U+3C95 */
  0x8002,   /* U+3C96 */
  0x8003,   /* U+3C97 */
  0x8004,   /* U+3C98 */
  0x8005,   /* U+3C99 */
  0x8006,   /* U+3C9A */
  0x8000,   /* U+3C9B */
  0x8001,   /* U+3C9C */
  0x8002,   /* U+3C9D */
  0x8003,   /* U+3C9E */
  0x8000,   /* U+3C9F */
  0x8001,   /* U+3CA0 */
  0x8002,   /* U+3CA1 */
  0x8003,   /* U+3CA2 */
  0x8004,   /* U+3CA3 */
  0x8000,   /* U+3CA4 */
  0x8001,   /* U+3CA5 */
  0x8002,   /* U+3CA6 */
  0x8003,   /* U+3CA7 */
  0x8004,   /* U+3CA8 */
  0xBCA9,   /* U+3CA9 */
  0x8000,   /* U+3CAA */
  0x8001,   /* U+3CAB */
  0x8002,   /* U+3CAC */
  0x8003,   /* U+3CAD */
  0xBCAE,   /* U+3CAE */
  0x8000,   /* U+3CAF */
  0x8001,   /* U+3CB0 */
  0x8000,   /* U+3CB1 */
  0x8000,   /* U+3CB2 */
  0x8000,   /* U+3CB3 */
  0x8000,   /* U+3CB4 */
  0x8000,   /* U+3CB5 */
  0x8000,   /* U+3CB6 */
  0x8000,   /* U+3CB7 */
  0x8000,   /* U+3CB8 */
  0x8000,   /* U+3CB9 */
  0x8001,   /* U+3CBA */
  0x8002,   /* U+3CBB */
  0x8003,   /* U+3CBC */
  0x8000,   /* U+3CBD */
  0x8001,   /* U+3CBE */
  0x8002,   /* U+3CBF */
  0x8000,   /* U+3CC0 */
  0x8001,   /* U+3CC1 */
  0x8002,   /* U+3CC2 */
  0x8003,   /* U+3CC3 */
  0x8004,   /* U+3CC4 */
  0x8005,   /* U+3CC5 */
  0x8006,   /* U+3CC6 */
  0x8007,   /* U+3CC7 */
  0x8008,   /* U+3CC8 */
  0x8009,   /* U+3CC9 */
  0x800A,   /* U+3CCA */
  0x8000,   /* U+3CCB */
  0x8001,   /* U+3CCC */
  0x8002,   /* U+3CCD */
  0x8003,   /* U+3CCE */
  0x8004,   /* U+3CCF */
  0x8005,   /* U+3CD0 */
  0x8006,   /* U+3CD1 */
  0x8007,   /* U+3CD2 */
  0xBCD3,   /* U+3CD3 */
  0x8008,   /* U+3CD4 */
  0x8009,   /* U+3CD5 */
  0x8000,   /* U+3CD6 */
  0x8001,   /* U+3CD7 */
  0x8002,   /* U+3CD8 */
  0x8003,   /* U+3CD9 */
  0x8004,   /* U+3CDA */
  0x8005,   /* U+3CDB */
  0x8006,   /* U+3CDC */
  0x8007,   /* U+3CDD */
  0x8008,   /* U+3CDE */
  0xBCDF,   /* U+3CDF */
  0x8009,   /* U+3CE0 */
  0x800A,   /* U+3CE1 */
  0x800B,   /* U+3CE2 */
  0xBCE3,   /* U+3CE3 */
  0x8000,   /* U+3CE4 */
  0x8001,   /* U+3CE5 */
  0x8002,   /* U+3CE6 */
  0x8003,   /* U+3CE7 */
  0x8004,   /* U+3CE8 */
  0x8005,   /* U+3CE9 */
  0x8006,   /* U+3CEA */
  0x8007,   /* U+3CEB */
  0x8008,   /* U+3CEC */
  0x8009,   /* U+3CED */
  0x800A,   /* U+3CEE */
  0x800B,   /* U+3CEF */
  0x800C,   /* U+3CF0 */
  0x800D,   /* U+3CF1 */
  0xBCF2,   /* U+3CF2 */
  0xBCF3,   /* U+3CF3 */
  0x8000,   /* U+3CF4 */
  0x8001,   /* U+3CF5 */
  0x8002,   /* U+3CF6 */
  0x8003,   /* U+3CF7 */
  0x8004,   /* U+3CF8 */
  0x8005,   /* U+3CF9 */
  0x8006,   /* U+3CFA */
  0x8007,   /* U+3CFB */
  0x8008,   /* U+3CFC */
  0x8009,   /* U+3CFD */
  0x800A,   /* U+3CFE */
  0x800B,   /* U+3CFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3C00 */
  0x0000,   /* U+3C01 */
  0x0000,   /* U+3C02 */
  0x0000,   /* U+3C03 */
  0x0000,   /* U+3C04 */
  0x0000,   /* U+3C05 */
  0x0000,   /* U+3C06 */
  0x0000,   /* U+3C07 */
  0x0000,   /* U+3C08 */
  0x0000,   /* U+3C09 */
  0x0000,   /* U+3C0A */
  0x0000,   /* U+3C0B */
  0x0000,   /* U+3C0C */
  0x0000,   /* U+3C0D */
  0x0000,   /* U+3C0E */
  0x0000,   /* U+3C0F */
  0x0000,   /* U+3C10 */
  0x0000,   /* U+3C11 */
  0x0000,   /* U+3C12 */
  0x0000,   /* U+3C13 */
  0x0000,   /* U+3C14 */
  0x0000,   /* U+3C15 */
  0x0000,   /* U+3C16 */
  0x0000,   /* U+3C17 */
  0x0000,   /* U+3C18 */
  0x0000,   /* U+3C19 */
  0x0000,   /* U+3C1A */
  0x0000,   /* U+3C1B */
  0x0000,   /* U+3C1C */
  0x0000,   /* U+3C1D */
  0x0000,   /* U+3C1E */
  0x0000,   /* U+3C1F */
  0x0000,   /* U+3C20 */
  0x0000,   /* U+3C21 */
  0x0000,   /* U+3C22 */
  0x0000,   /* U+3C23 */
  0x0000,   /* U+3C24 */
  0x0000,   /* U+3C25 */
  0x0000,   /* U+3C26 */
  0x0000,   /* U+3C27 */
  0x0000,   /* U+3C28 */
  0x0000,   /* U+3C29 */
  0x0000,   /* U+3C2A */
  0x0000,   /* U+3C2B */
  0x0000,   /* U+3C2C */
  0x0000,   /* U+3C2D */
  0x0000,   /* U+3C2E */
  0x0000,   /* U+3C2F */
  0x0000,   /* U+3C30 */
  0x0000,   /* U+3C31 */
  0x0000,   /* U+3C32 */
  0x0000,   /* U+3C33 */
  0x0000,   /* U+3C34 */
  0x0000,   /* U+3C35 */
  0x0000,   /* U+3C36 */
  0x0000,   /* U+3C37 */
  0x0000,   /* U+3C38 */
  0x0000,   /* U+3C39 */
  0x0000,   /* U+3C3A */
  0x0000,   /* U+3C3B */
  0x0000,   /* U+3C3C */
  0x0000,   /* U+3C3D */
  0x0000,   /* U+3C3E */
  0x0000,   /* U+3C3F */
  0x0000,   /* U+3C40 */
  0x0000,   /* U+3C41 */
  0x0000,   /* U+3C42 */
  0x0000,   /* U+3C43 */
  0x0000,   /* U+3C44 */
  0x0000,   /* U+3C45 */
  0x0000,   /* U+3C46 */
  0x0000,   /* U+3C47 */
  0x0000,   /* U+3C48 */
  0x0000,   /* U+3C49 */
  0x0000,   /* U+3C4A */
  0x0000,   /* U+3C4B */
  0x0000,   /* U+3C4C */
  0x0000,   /* U+3C4D */
  0x0000,   /* U+3C4E */
  0x0000,   /* U+3C4F */
  0x0000,   /* U+3C50 */
  0x0000,   /* U+3C51 */
  0x0000,   /* U+3C52 */
  0x0000,   /* U+3C53 */
  0x0000,   /* U+3C54 */
  0x0000,   /* U+3C55 */
  0x0000,   /* U+3C56 */
  0x0000,   /* U+3C57 */
  0x0000,   /* U+3C58 */
  0x0000,   /* U+3C59 */
  0x0000,   /* U+3C5A */
  0x0000,   /* U+3C5B */
  0x0000,   /* U+3C5C */
  0x0000,   /* U+3C5D */
  0x0000,   /* U+3C5E */
  0x0000,   /* U+3C5F */
  0x0000,   /* U+3C60 */
  0x0000,   /* U+3C61 */
  0x0000,   /* U+3C62 */
  0x0000,   /* U+3C63 */
  0x0000,   /* U+3C64 */
  0x0000,   /* U+3C65 */
  0x0000,   /* U+3C66 */
  0x0000,   /* U+3C67 */
  0x0000,   /* U+3C68 */
  0x0000,   /* U+3C69 */
  0x0000,   /* U+3C6A */
  0x0000,   /* U+3C6B */
  0x0000,   /* U+3C6C */
  0x0000,   /* U+3C6D */
  0x0000,   /* U+3C6E */
  0x0000,   /* U+3C6F */
  0x0000,   /* U+3C70 */
  0x0000,   /* U+3C71 */
  0x0000,   /* U+3C72 */
  0x0000,   /* U+3C73 */
  0x0000,   /* U+3C74 */
  0x0000,   /* U+3C75 */
  0x0000,   /* U+3C76 */
  0x0000,   /* U+3C77 */
  0x0000,   /* U+3C78 */
  0x0000,   /* U+3C79 */
  0x0000,   /* U+3C7A */
  0x0000,   /* U+3C7B */
  0x0000,   /* U+3C7C */
  0x0000,   /* U+3C7D */
  0x0000,   /* U+3C7E */
  0x0000,   /* U+3C7F */
  0x0000,   /* U+3C80 */
  0x0000,   /* U+3C81 */
  0x0000,   /* U+3C82 */
  0x0000,   /* U+3C83 */
  0x0000,   /* U+3C84 */
  0x0000,   /* U+3C85 */
  0x0000,   /* U+3C86 */
  0x0000,   /* U+3C87 */
  0x0000,   /* U+3C88 */
  0x0000,   /* U+3C89 */
  0x0000,   /* U+3C8A */
  0x0000,   /* U+3C8B */
  0x0000,   /* U+3C8C */
  0x0000,   /* U+3C8D */
  0x0000,   /* U+3C8E */
  0x0000,   /* U+3C8F */
  0x0000,   /* U+3C90 */
  0x0000,   /* U+3C91 */
  0x0000,   /* U+3C92 */
  0x0000,   /* U+3C93 */
  0x0000,   /* U+3C94 */
  0x0000,   /* U+3C95 */
  0x0000,   /* U+3C96 */
  0x0000,   /* U+3C97 */
  0x0000,   /* U+3C98 */
  0x0000,   /* U+3C99 */
  0x0000,   /* U+3C9A */
  0x0000,   /* U+3C9B */
  0x0000,   /* U+3C9C */
  0x0000,   /* U+3C9D */
  0x0000,   /* U+3C9E */
  0x0000,   /* U+3C9F */
  0x0000,   /* U+3CA0 */
  0x0000,   /* U+3CA1 */
  0x0000,   /* U+3CA2 */
  0x0000,   /* U+3CA3 */
  0x0000,   /* U+3CA4 */
  0x0000,   /* U+3CA5 */
  0x0000,   /* U+3CA6 */
  0x0000,   /* U+3CA7 */
  0x0000,   /* U+3CA8 */
  0x0000,   /* U+3CA9 */
  0x0000,   /* U+3CAA */
  0x0000,   /* U+3CAB */
  0x0000,   /* U+3CAC */
  0x0000,   /* U+3CAD */
  0x0000,   /* U+3CAE */
  0x0000,   /* U+3CAF */
  0x0000,   /* U+3CB0 */
  0x0000,   /* U+3CB1 */
  0x0000,   /* U+3CB2 */
  0x0000,   /* U+3CB3 */
  0x0000,   /* U+3CB4 */
  0x0000,   /* U+3CB5 */
  0x0000,   /* U+3CB6 */
  0x0000,   /* U+3CB7 */
  0x0000,   /* U+3CB8 */
  0x0000,   /* U+3CB9 */
  0x0000,   /* U+3CBA */
  0x0000,   /* U+3CBB */
  0x0000,   /* U+3CBC */
  0x0000,   /* U+3CBD */
  0x0000,   /* U+3CBE */
  0x0000,   /* U+3CBF */
  0x0000,   /* U+3CC0 */
  0x0000,   /* U+3CC1 */
  0x0000,   /* U+3CC2 */
  0x0000,   /* U+3CC3 */
  0x0000,   /* U+3CC4 */
  0x0000,   /* U+3CC5 */
  0x0000,   /* U+3CC6 */
  0x0000,   /* U+3CC7 */
  0x0000,   /* U+3CC8 */
  0x0000,   /* U+3CC9 */
  0x0000,   /* U+3CCA */
  0x0000,   /* U+3CCB */
  0x0000,   /* U+3CCC */
  0x0000,   /* U+3CCD */
  0x0000,   /* U+3CCE */
  0x0000,   /* U+3CCF */
  0x0000,   /* U+3CD0 */
  0x0000,   /* U+3CD1 */
  0x0000,   /* U+3CD2 */
  0x0000,   /* U+3CD3 */
  0x0000,   /* U+3CD4 */
  0x0000,   /* U+3CD5 */
  0x0000,   /* U+3CD6 */
  0x0000,   /* U+3CD7 */
  0x0000,   /* U+3CD8 */
  0x0000,   /* U+3CD9 */
  0x0000,   /* U+3CDA */
  0x0000,   /* U+3CDB */
  0x0000,   /* U+3CDC */
  0x0000,   /* U+3CDD */
  0x0000,   /* U+3CDE */
  0x0000,   /* U+3CDF */
  0x0000,   /* U+3CE0 */
  0x0000,   /* U+3CE1 */
  0x0000,   /* U+3CE2 */
  0x0000,   /* U+3CE3 */
  0x0000,   /* U+3CE4 */
  0x0000,   /* U+3CE5 */
  0x0000,   /* U+3CE6 */
  0x0000,   /* U+3CE7 */
  0x0000,   /* U+3CE8 */
  0x0000,   /* U+3CE9 */
  0x0000,   /* U+3CEA */
  0x0000,   /* U+3CEB */
  0x0000,   /* U+3CEC */
  0x0000,   /* U+3CED */
  0x0000,   /* U+3CEE */
  0x0000,   /* U+3CEF */
  0x0000,   /* U+3CF0 */
  0x0000,   /* U+3CF1 */
  0x0000,   /* U+3CF2 */
  0x0000,   /* U+3CF3 */
  0x0000,   /* U+3CF4 */
  0x0000,   /* U+3CF5 */
  0x0000,   /* U+3CF6 */
  0x0000,   /* U+3CF7 */
  0x0000,   /* U+3CF8 */
  0x0000,   /* U+3CF9 */
  0x0000,   /* U+3CFA */
  0x0000,   /* U+3CFB */
  0x0000,   /* U+3CFC */
  0x0000,   /* U+3CFD */
  0x0000,   /* U+3CFE */
  0x0000,   /* U+3CFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3C00 */
  0x0000,   /* U+3C01 */
  0x0000,   /* U+3C02 */
  0x0000,   /* U+3C03 */
  0x0000,   /* U+3C04 */
  0x0000,   /* U+3C05 */
  0x0000,   /* U+3C06 */
  0x0000,   /* U+3C07 */
  0x0000,   /* U+3C08 */
  0x0000,   /* U+3C09 */
  0x0000,   /* U+3C0A */
  0x0000,   /* U+3C0B */
  0x0000,   /* U+3C0C */
  0x0000,   /* U+3C0D */
  0x0000,   /* U+3C0E */
  0x0000,   /* U+3C0F */
  0x0000,   /* U+3C10 */
  0x0000,   /* U+3C11 */
  0x0000,   /* U+3C12 */
  0x0000,   /* U+3C13 */
  0x0000,   /* U+3C14 */
  0x0000,   /* U+3C15 */
  0x0000,   /* U+3C16 */
  0x0000,   /* U+3C17 */
  0x0000,   /* U+3C18 */
  0x0000,   /* U+3C19 */
  0x0000,   /* U+3C1A */
  0x0000,   /* U+3C1B */
  0x0000,   /* U+3C1C */
  0x0000,   /* U+3C1D */
  0x0000,   /* U+3C1E */
  0x0000,   /* U+3C1F */
  0x0000,   /* U+3C20 */
  0x0000,   /* U+3C21 */
  0x0000,   /* U+3C22 */
  0x0000,   /* U+3C23 */
  0x0000,   /* U+3C24 */
  0x0000,   /* U+3C25 */
  0x0000,   /* U+3C26 */
  0x0000,   /* U+3C27 */
  0x0000,   /* U+3C28 */
  0x0000,   /* U+3C29 */
  0x0000,   /* U+3C2A */
  0x0000,   /* U+3C2B */
  0x0000,   /* U+3C2C */
  0x0000,   /* U+3C2D */
  0x0000,   /* U+3C2E */
  0x0000,   /* U+3C2F */
  0x0000,   /* U+3C30 */
  0x0000,   /* U+3C31 */
  0x0000,   /* U+3C32 */
  0x0000,   /* U+3C33 */
  0x0000,   /* U+3C34 */
  0x0000,   /* U+3C35 */
  0x0000,   /* U+3C36 */
  0x0000,   /* U+3C37 */
  0x0000,   /* U+3C38 */
  0x0000,   /* U+3C39 */
  0x0000,   /* U+3C3A */
  0x0000,   /* U+3C3B */
  0x0000,   /* U+3C3C */
  0x0000,   /* U+3C3D */
  0x0000,   /* U+3C3E */
  0x0000,   /* U+3C3F */
  0x0000,   /* U+3C40 */
  0x0000,   /* U+3C41 */
  0x0000,   /* U+3C42 */
  0x0000,   /* U+3C43 */
  0x0000,   /* U+3C44 */
  0x0000,   /* U+3C45 */
  0x0000,   /* U+3C46 */
  0x0000,   /* U+3C47 */
  0x0000,   /* U+3C48 */
  0x0000,   /* U+3C49 */
  0x0000,   /* U+3C4A */
  0x0000,   /* U+3C4B */
  0x0000,   /* U+3C4C */
  0x0000,   /* U+3C4D */
  0x0000,   /* U+3C4E */
  0x0000,   /* U+3C4F */
  0x0000,   /* U+3C50 */
  0x0000,   /* U+3C51 */
  0x0000,   /* U+3C52 */
  0x0000,   /* U+3C53 */
  0x0000,   /* U+3C54 */
  0x0000,   /* U+3C55 */
  0x0000,   /* U+3C56 */
  0x0000,   /* U+3C57 */
  0x0000,   /* U+3C58 */
  0x0000,   /* U+3C59 */
  0x0000,   /* U+3C5A */
  0x0000,   /* U+3C5B */
  0x0000,   /* U+3C5C */
  0x0000,   /* U+3C5D */
  0x0000,   /* U+3C5E */
  0x0000,   /* U+3C5F */
  0x0000,   /* U+3C60 */
  0x0000,   /* U+3C61 */
  0x0000,   /* U+3C62 */
  0x0000,   /* U+3C63 */
  0x0000,   /* U+3C64 */
  0x0000,   /* U+3C65 */
  0x0000,   /* U+3C66 */
  0x0000,   /* U+3C67 */
  0x0000,   /* U+3C68 */
  0x0000,   /* U+3C69 */
  0x0000,   /* U+3C6A */
  0x0000,   /* U+3C6B */
  0x0000,   /* U+3C6C */
  0x0000,   /* U+3C6D */
  0x0000,   /* U+3C6E */
  0x0000,   /* U+3C6F */
  0x0000,   /* U+3C70 */
  0x0000,   /* U+3C71 */
  0x0000,   /* U+3C72 */
  0x0000,   /* U+3C73 */
  0x0000,   /* U+3C74 */
  0x0000,   /* U+3C75 */
  0x0000,   /* U+3C76 */
  0x0000,   /* U+3C77 */
  0x0000,   /* U+3C78 */
  0x0000,   /* U+3C79 */
  0x0000,   /* U+3C7A */
  0x0000,   /* U+3C7B */
  0x0000,   /* U+3C7C */
  0x0000,   /* U+3C7D */
  0x0000,   /* U+3C7E */
  0x0000,   /* U+3C7F */
  0x0000,   /* U+3C80 */
  0x0000,   /* U+3C81 */
  0x0000,   /* U+3C82 */
  0x0000,   /* U+3C83 */
  0x0000,   /* U+3C84 */
  0x0000,   /* U+3C85 */
  0x0000,   /* U+3C86 */
  0x0000,   /* U+3C87 */
  0x0000,   /* U+3C88 */
  0x0000,   /* U+3C89 */
  0x0000,   /* U+3C8A */
  0x0000,   /* U+3C8B */
  0x0000,   /* U+3C8C */
  0x0000,   /* U+3C8D */
  0x0000,   /* U+3C8E */
  0x0000,   /* U+3C8F */
  0x0000,   /* U+3C90 */
  0x0000,   /* U+3C91 */
  0x0000,   /* U+3C92 */
  0x0000,   /* U+3C93 */
  0x0000,   /* U+3C94 */
  0x0000,   /* U+3C95 */
  0x0000,   /* U+3C96 */
  0x0000,   /* U+3C97 */
  0x0000,   /* U+3C98 */
  0x0000,   /* U+3C99 */
  0x0000,   /* U+3C9A */
  0x0000,   /* U+3C9B */
  0x0000,   /* U+3C9C */
  0x0000,   /* U+3C9D */
  0x0000,   /* U+3C9E */
  0x0000,   /* U+3C9F */
  0x0000,   /* U+3CA0 */
  0x0000,   /* U+3CA1 */
  0x0000,   /* U+3CA2 */
  0x0000,   /* U+3CA3 */
  0x0000,   /* U+3CA4 */
  0x0000,   /* U+3CA5 */
  0x0000,   /* U+3CA6 */
  0x0000,   /* U+3CA7 */
  0x0000,   /* U+3CA8 */
  0x0000,   /* U+3CA9 */
  0x0000,   /* U+3CAA */
  0x0000,   /* U+3CAB */
  0x0000,   /* U+3CAC */
  0x0000,   /* U+3CAD */
  0x0000,   /* U+3CAE */
  0x0000,   /* U+3CAF */
  0x0000,   /* U+3CB0 */
  0x0000,   /* U+3CB1 */
  0x0000,   /* U+3CB2 */
  0x0000,   /* U+3CB3 */
  0x0000,   /* U+3CB4 */
  0x0000,   /* U+3CB5 */
  0x0000,   /* U+3CB6 */
  0x0000,   /* U+3CB7 */
  0x0000,   /* U+3CB8 */
  0x0000,   /* U+3CB9 */
  0x0000,   /* U+3CBA */
  0x0000,   /* U+3CBB */
  0x0000,   /* U+3CBC */
  0x0000,   /* U+3CBD */
  0x0000,   /* U+3CBE */
  0x0000,   /* U+3CBF */
  0x0000,   /* U+3CC0 */
  0x0000,   /* U+3CC1 */
  0x0000,   /* U+3CC2 */
  0x0000,   /* U+3CC3 */
  0x0000,   /* U+3CC4 */
  0x0000,   /* U+3CC5 */
  0x0000,   /* U+3CC6 */
  0x0000,   /* U+3CC7 */
  0x0000,   /* U+3CC8 */
  0x0000,   /* U+3CC9 */
  0x0000,   /* U+3CCA */
  0x0000,   /* U+3CCB */
  0x0000,   /* U+3CCC */
  0x0000,   /* U+3CCD */
  0x0000,   /* U+3CCE */
  0x0000,   /* U+3CCF */
  0x0000,   /* U+3CD0 */
  0x0000,   /* U+3CD1 */
  0x0000,   /* U+3CD2 */
  0x0000,   /* U+3CD3 */
  0x0000,   /* U+3CD4 */
  0x0000,   /* U+3CD5 */
  0x0000,   /* U+3CD6 */
  0x0000,   /* U+3CD7 */
  0x0000,   /* U+3CD8 */
  0x0000,   /* U+3CD9 */
  0x0000,   /* U+3CDA */
  0x0000,   /* U+3CDB */
  0x0000,   /* U+3CDC */
  0x0000,   /* U+3CDD */
  0x0000,   /* U+3CDE */
  0x0000,   /* U+3CDF */
  0x0000,   /* U+3CE0 */
  0x0000,   /* U+3CE1 */
  0x0000,   /* U+3CE2 */
  0x0000,   /* U+3CE3 */
  0x0000,   /* U+3CE4 */
  0x0000,   /* U+3CE5 */
  0x0000,   /* U+3CE6 */
  0x0000,   /* U+3CE7 */
  0x0000,   /* U+3CE8 */
  0x0000,   /* U+3CE9 */
  0x0000,   /* U+3CEA */
  0x0000,   /* U+3CEB */
  0x0000,   /* U+3CEC */
  0x0000,   /* U+3CED */
  0x0000,   /* U+3CEE */
  0x0000,   /* U+3CEF */
  0x0000,   /* U+3CF0 */
  0x0000,   /* U+3CF1 */
  0x0000,   /* U+3CF2 */
  0x0000,   /* U+3CF3 */
  0x0000,   /* U+3CF4 */
  0x0000,   /* U+3CF5 */
  0x0000,   /* U+3CF6 */
  0x0000,   /* U+3CF7 */
  0x0000,   /* U+3CF8 */
  0x0000,   /* U+3CF9 */
  0x0000,   /* U+3CFA */
  0x0000,   /* U+3CFB */
  0x0000,   /* U+3CFC */
  0x0000,   /* U+3CFD */
  0x0000,   /* U+3CFE */
  0x0000,   /* U+3CFF */
};

uint16 zh2_han_p03D[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x3194,   /* U+3D00 */
  0x3194,   /* U+3D01 */
  0x3194,   /* U+3D02 */
  0x3194,   /* U+3D03 */
  0x3194,   /* U+3D04 */
  0x3194,   /* U+3D05 */
  0x3194,   /* U+3D06 */
  0x3194,   /* U+3D07 */
  0x3194,   /* U+3D08 */
  0x3194,   /* U+3D09 */
  0x3194,   /* U+3D0A */
  0x3194,   /* U+3D0B */
  0x5C49,   /* U+3D0C */
  0x5C49,   /* U+3D0D */
  0x3194,   /* U+3D0E */
  0x3195,   /* U+3D0F */
  0x3195,   /* U+3D10 */
  0x3195,   /* U+3D11 */
  0x3195,   /* U+3D12 */
  0x3195,   /* U+3D13 */
  0x3195,   /* U+3D14 */
  0x3195,   /* U+3D15 */
  0x3195,   /* U+3D16 */
  0x3195,   /* U+3D17 */
  0x3195,   /* U+3D18 */
  0x3195,   /* U+3D19 */
  0x3195,   /* U+3D1A */
  0x3195,   /* U+3D1B */
  0x3195,   /* U+3D1C */
  0x3195,   /* U+3D1D */
  0x3195,   /* U+3D1E */
  0x3195,   /* U+3D1F */
  0x5C49,   /* U+3D20 */
  0x3195,   /* U+3D21 */
  0x5C49,   /* U+3D22 */
  0x5C49,   /* U+3D23 */
  0x5C49,   /* U+3D24 */
  0x318D,   /* U+3D25 */
  0x318D,   /* U+3D26 */
  0x318D,   /* U+3D27 */
  0x318D,   /* U+3D28 */
  0x318D,   /* U+3D29 */
  0x318D,   /* U+3D2A */
  0x318D,   /* U+3D2B */
  0x318D,   /* U+3D2C */
  0x318D,   /* U+3D2D */
  0x318D,   /* U+3D2E */
  0x318D,   /* U+3D2F */
  0x318D,   /* U+3D30 */
  0x318D,   /* U+3D31 */
  0x318D,   /* U+3D32 */
  0x318D,   /* U+3D33 */
  0x318D,   /* U+3D34 */
  0x318D,   /* U+3D35 */
  0x318D,   /* U+3D36 */
  0x318D,   /* U+3D37 */
  0x318D,   /* U+3D38 */
  0x5C49,   /* U+3D39 */
  0x5C49,   /* U+3D3A */
  0x5C49,   /* U+3D3B */
  0x3197,   /* U+3D3C */
  0x3197,   /* U+3D3D */
  0x3197,   /* U+3D3E */
  0x3197,   /* U+3D3F */
  0x3197,   /* U+3D40 */
  0x3197,   /* U+3D41 */
  0x3197,   /* U+3D42 */
  0x3197,   /* U+3D43 */
  0x3197,   /* U+3D44 */
  0x3197,   /* U+3D45 */
  0x3197,   /* U+3D46 */
  0x3197,   /* U+3D47 */
  0x5C49,   /* U+3D48 */
  0x5C49,   /* U+3D49 */
  0x3198,   /* U+3D4A */
  0x3198,   /* U+3D4B */
  0x3198,   /* U+3D4C */
  0x3198,   /* U+3D4D */
  0x3198,   /* U+3D4E */
  0x3198,   /* U+3D4F */
  0x3198,   /* U+3D50 */
  0x3198,   /* U+3D51 */
  0x3198,   /* U+3D52 */
  0x3198,   /* U+3D53 */
  0x3198,   /* U+3D54 */
  0x3198,   /* U+3D55 */
  0x3198,   /* U+3D56 */
  0x3198,   /* U+3D57 */
  0x3198,   /* U+3D58 */
  0x3198,   /* U+3D59 */
  0x3198,   /* U+3D5A */
  0x5C49,   /* U+3D5B */
  0x5C49,   /* U+3D5C */
  0x3199,   /* U+3D5D */
  0x3199,   /* U+3D5E */
  0x3199,   /* U+3D5F */
  0x3199,   /* U+3D60 */
  0x3199,   /* U+3D61 */
  0x3199,   /* U+3D62 */
  0x3199,   /* U+3D63 */
  0x3199,   /* U+3D64 */
  0x3199,   /* U+3D65 */
  0x3199,   /* U+3D66 */
  0x3199,   /* U+3D67 */
  0x3199,   /* U+3D68 */
  0x3199,   /* U+3D69 */
  0x3199,   /* U+3D6A */
  0x3199,   /* U+3D6B */
  0x3199,   /* U+3D6C */
  0x3199,   /* U+3D6D */
  0x3199,   /* U+3D6E */
  0x319A,   /* U+3D6F */
  0x319A,   /* U+3D70 */
  0x319A,   /* U+3D71 */
  0x319A,   /* U+3D72 */
  0x319A,   /* U+3D73 */
  0x319A,   /* U+3D74 */
  0x319A,   /* U+3D75 */
  0x319A,   /* U+3D76 */
  0x319A,   /* U+3D77 */
  0x319A,   /* U+3D78 */
  0x319A,   /* U+3D79 */
  0x319A,   /* U+3D7A */
  0x319A,   /* U+3D7B */
  0x5C49,   /* U+3D7C */
  0x319B,   /* U+3D7D */
  0x319B,   /* U+3D7E */
  0x319B,   /* U+3D7F */
  0x319B,   /* U+3D80 */
  0x319B,   /* U+3D81 */
  0x5C49,   /* U+3D82 */
  0x5C49,   /* U+3D83 */
  0x319C,   /* U+3D84 */
  0x319C,   /* U+3D85 */
  0x319C,   /* U+3D86 */
  0x319C,   /* U+3D87 */
  0x319C,   /* U+3D88 */
  0x319C,   /* U+3D89 */
  0x5C49,   /* U+3D8A */
  0x5C49,   /* U+3D8B */
  0x319D,   /* U+3D8C */
  0x319D,   /* U+3D8D */
  0x319D,   /* U+3D8E */
  0x319D,   /* U+3D8F */
  0x5C49,   /* U+3D90 */
  0x319D,   /* U+3D91 */
  0x319E,   /* U+3D92 */
  0x319E,   /* U+3D93 */
  0x319E,   /* U+3D94 */
  0x319E,   /* U+3D95 */
  0x319E,   /* U+3D96 */
  0x319E,   /* U+3D97 */
  0x319E,   /* U+3D98 */
  0x5C49,   /* U+3D99 */
  0x5C49,   /* U+3D9A */
  0x318E,   /* U+3D9B */
  0x318E,   /* U+3D9C */
  0x5C49,   /* U+3D9D */
  0x31A1,   /* U+3D9E */
  0x31A1,   /* U+3D9F */
  0x31A3,   /* U+3DA0 */
  0x31CE,   /* U+3DA1 */
  0x5C49,   /* U+3DA2 */
  0x31CF,   /* U+3DA3 */
  0x31CF,   /* U+3DA4 */
  0x31CF,   /* U+3DA5 */
  0x31D0,   /* U+3DA6 */
  0x31D0,   /* U+3DA7 */
  0x31D0,   /* U+3DA8 */
  0x31D0,   /* U+3DA9 */
  0x5C49,   /* U+3DAA */
  0x31D1,   /* U+3DAB */
  0x31D1,   /* U+3DAC */
  0x31D1,   /* U+3DAD */
  0x31D1,   /* U+3DAE */
  0x31D1,   /* U+3DAF */
  0x31D1,   /* U+3DB0 */
  0x5C49,   /* U+3DB1 */
  0x31D1,   /* U+3DB2 */
  0x31D2,   /* U+3DB3 */
  0x31D2,   /* U+3DB4 */
  0x31D2,   /* U+3DB5 */
  0x31D2,   /* U+3DB6 */
  0x5C49,   /* U+3DB7 */
  0x31D2,   /* U+3DB8 */
  0x31D3,   /* U+3DB9 */
  0x31D3,   /* U+3DBA */
  0x31D3,   /* U+3DBB */
  0x31D3,   /* U+3DBC */
  0x31D3,   /* U+3DBD */
  0x31D3,   /* U+3DBE */
  0x31D3,   /* U+3DBF */
  0x31D3,   /* U+3DC0 */
  0x5C49,   /* U+3DC1 */
  0x31D4,   /* U+3DC2 */
  0x31D4,   /* U+3DC3 */
  0x31D4,   /* U+3DC4 */
  0x31D4,   /* U+3DC5 */
  0x31D4,   /* U+3DC6 */
  0x31D4,   /* U+3DC7 */
  0x31D4,   /* U+3DC8 */
  0x31D4,   /* U+3DC9 */
  0x31D4,   /* U+3DCA */
  0x31D4,   /* U+3DCB */
  0x31D4,   /* U+3DCC */
  0x31D4,   /* U+3DCD */
  0x31D5,   /* U+3DCE */
  0x31D5,   /* U+3DCF */
  0x31D5,   /* U+3DD0 */
  0x31D5,   /* U+3DD1 */
  0x31D5,   /* U+3DD2 */
  0x31D5,   /* U+3DD3 */
  0x31D5,   /* U+3DD4 */
  0x31D5,   /* U+3DD5 */
  0x31D5,   /* U+3DD6 */
  0x31D5,   /* U+3DD7 */
  0x31D5,   /* U+3DD8 */
  0x31D5,   /* U+3DD9 */
  0x31D5,   /* U+3DDA */
  0x31D5,   /* U+3DDB */
  0x5C49,   /* U+3DDC */
  0x5C49,   /* U+3DDD */
  0x5C49,   /* U+3DDE */
  0x31CD,   /* U+3DDF */
  0x31CD,   /* U+3DE0 */
  0x31CD,   /* U+3DE1 */
  0x31CD,   /* U+3DE2 */
  0x31CD,   /* U+3DE3 */
  0x31CD,   /* U+3DE4 */
  0x31CD,   /* U+3DE5 */
  0x31CD,   /* U+3DE6 */
  0x31CD,   /* U+3DE7 */
  0x31CD,   /* U+3DE8 */
  0x5C49,   /* U+3DE9 */
  0x31CD,   /* U+3DEA */
  0x31D7,   /* U+3DEB */
  0x31D7,   /* U+3DEC */
  0x31D7,   /* U+3DED */
  0x31D7,   /* U+3DEE */
  0x31D7,   /* U+3DEF */
  0x31D7,   /* U+3DF0 */
  0x5C49,   /* U+3DF1 */
  0x5C49,   /* U+3DF2 */
  0x31D8,   /* U+3DF3 */
  0x31D8,   /* U+3DF4 */
  0x31D8,   /* U+3DF5 */
  0x31D8,   /* U+3DF6 */
  0x31D8,   /* U+3DF7 */
  0x31D8,   /* U+3DF8 */
  0x31D8,   /* U+3DF9 */
  0x31D8,   /* U+3DFA */
  0x31D8,   /* U+3DFB */
  0x5C49,   /* U+3DFC */
  0x5C49,   /* U+3DFD */
  0x31D9,   /* U+3DFE */
  0x31D9,   /* U+3DFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3D00 */
  0x0020,   /* U+3D01 */
  0x0020,   /* U+3D02 */
  0x0020,   /* U+3D03 */
  0x0020,   /* U+3D04 */
  0x0020,   /* U+3D05 */
  0x0020,   /* U+3D06 */
  0x0020,   /* U+3D07 */
  0x0020,   /* U+3D08 */
  0x0020,   /* U+3D09 */
  0x0020,   /* U+3D0A */
  0x0020,   /* U+3D0B */
  0x0020,   /* U+3D0C */
  0x0020,   /* U+3D0D */
  0x0020,   /* U+3D0E */
  0x0020,   /* U+3D0F */
  0x0020,   /* U+3D10 */
  0x0020,   /* U+3D11 */
  0x0020,   /* U+3D12 */
  0x0020,   /* U+3D13 */
  0x0020,   /* U+3D14 */
  0x0020,   /* U+3D15 */
  0x0020,   /* U+3D16 */
  0x0020,   /* U+3D17 */
  0x0020,   /* U+3D18 */
  0x0020,   /* U+3D19 */
  0x0020,   /* U+3D1A */
  0x0020,   /* U+3D1B */
  0x0020,   /* U+3D1C */
  0x0020,   /* U+3D1D */
  0x0020,   /* U+3D1E */
  0x0020,   /* U+3D1F */
  0x0020,   /* U+3D20 */
  0x0020,   /* U+3D21 */
  0x0020,   /* U+3D22 */
  0x0020,   /* U+3D23 */
  0x0020,   /* U+3D24 */
  0x0020,   /* U+3D25 */
  0x0020,   /* U+3D26 */
  0x0020,   /* U+3D27 */
  0x0020,   /* U+3D28 */
  0x0020,   /* U+3D29 */
  0x0020,   /* U+3D2A */
  0x0020,   /* U+3D2B */
  0x0020,   /* U+3D2C */
  0x0020,   /* U+3D2D */
  0x0020,   /* U+3D2E */
  0x0020,   /* U+3D2F */
  0x0020,   /* U+3D30 */
  0x0020,   /* U+3D31 */
  0x0020,   /* U+3D32 */
  0x0020,   /* U+3D33 */
  0x0020,   /* U+3D34 */
  0x0020,   /* U+3D35 */
  0x0020,   /* U+3D36 */
  0x0020,   /* U+3D37 */
  0x0020,   /* U+3D38 */
  0x0020,   /* U+3D39 */
  0x0020,   /* U+3D3A */
  0x0020,   /* U+3D3B */
  0x0020,   /* U+3D3C */
  0x0020,   /* U+3D3D */
  0x0020,   /* U+3D3E */
  0x0020,   /* U+3D3F */
  0x0020,   /* U+3D40 */
  0x0020,   /* U+3D41 */
  0x0020,   /* U+3D42 */
  0x0020,   /* U+3D43 */
  0x0020,   /* U+3D44 */
  0x0020,   /* U+3D45 */
  0x0020,   /* U+3D46 */
  0x0020,   /* U+3D47 */
  0x0020,   /* U+3D48 */
  0x0020,   /* U+3D49 */
  0x0020,   /* U+3D4A */
  0x0020,   /* U+3D4B */
  0x0020,   /* U+3D4C */
  0x0020,   /* U+3D4D */
  0x0020,   /* U+3D4E */
  0x0020,   /* U+3D4F */
  0x0020,   /* U+3D50 */
  0x0020,   /* U+3D51 */
  0x0020,   /* U+3D52 */
  0x0020,   /* U+3D53 */
  0x0020,   /* U+3D54 */
  0x0020,   /* U+3D55 */
  0x0020,   /* U+3D56 */
  0x0020,   /* U+3D57 */
  0x0020,   /* U+3D58 */
  0x0020,   /* U+3D59 */
  0x0020,   /* U+3D5A */
  0x0020,   /* U+3D5B */
  0x0020,   /* U+3D5C */
  0x0020,   /* U+3D5D */
  0x0020,   /* U+3D5E */
  0x0020,   /* U+3D5F */
  0x0020,   /* U+3D60 */
  0x0020,   /* U+3D61 */
  0x0020,   /* U+3D62 */
  0x0020,   /* U+3D63 */
  0x0020,   /* U+3D64 */
  0x0020,   /* U+3D65 */
  0x0020,   /* U+3D66 */
  0x0020,   /* U+3D67 */
  0x0020,   /* U+3D68 */
  0x0020,   /* U+3D69 */
  0x0020,   /* U+3D6A */
  0x0020,   /* U+3D6B */
  0x0020,   /* U+3D6C */
  0x0020,   /* U+3D6D */
  0x0020,   /* U+3D6E */
  0x0020,   /* U+3D6F */
  0x0020,   /* U+3D70 */
  0x0020,   /* U+3D71 */
  0x0020,   /* U+3D72 */
  0x0020,   /* U+3D73 */
  0x0020,   /* U+3D74 */
  0x0020,   /* U+3D75 */
  0x0020,   /* U+3D76 */
  0x0020,   /* U+3D77 */
  0x0020,   /* U+3D78 */
  0x0020,   /* U+3D79 */
  0x0020,   /* U+3D7A */
  0x0020,   /* U+3D7B */
  0x0020,   /* U+3D7C */
  0x0020,   /* U+3D7D */
  0x0020,   /* U+3D7E */
  0x0020,   /* U+3D7F */
  0x0020,   /* U+3D80 */
  0x0020,   /* U+3D81 */
  0x0020,   /* U+3D82 */
  0x0020,   /* U+3D83 */
  0x0020,   /* U+3D84 */
  0x0020,   /* U+3D85 */
  0x0020,   /* U+3D86 */
  0x0020,   /* U+3D87 */
  0x0020,   /* U+3D88 */
  0x0020,   /* U+3D89 */
  0x0020,   /* U+3D8A */
  0x0020,   /* U+3D8B */
  0x0020,   /* U+3D8C */
  0x0020,   /* U+3D8D */
  0x0020,   /* U+3D8E */
  0x0020,   /* U+3D8F */
  0x0020,   /* U+3D90 */
  0x0020,   /* U+3D91 */
  0x0020,   /* U+3D92 */
  0x0020,   /* U+3D93 */
  0x0020,   /* U+3D94 */
  0x0020,   /* U+3D95 */
  0x0020,   /* U+3D96 */
  0x0020,   /* U+3D97 */
  0x0020,   /* U+3D98 */
  0x0020,   /* U+3D99 */
  0x0020,   /* U+3D9A */
  0x0020,   /* U+3D9B */
  0x0020,   /* U+3D9C */
  0x0020,   /* U+3D9D */
  0x0020,   /* U+3D9E */
  0x0020,   /* U+3D9F */
  0x0020,   /* U+3DA0 */
  0x0020,   /* U+3DA1 */
  0x0020,   /* U+3DA2 */
  0x0020,   /* U+3DA3 */
  0x0020,   /* U+3DA4 */
  0x0020,   /* U+3DA5 */
  0x0020,   /* U+3DA6 */
  0x0020,   /* U+3DA7 */
  0x0020,   /* U+3DA8 */
  0x0020,   /* U+3DA9 */
  0x0020,   /* U+3DAA */
  0x0020,   /* U+3DAB */
  0x0020,   /* U+3DAC */
  0x0020,   /* U+3DAD */
  0x0020,   /* U+3DAE */
  0x0020,   /* U+3DAF */
  0x0020,   /* U+3DB0 */
  0x0020,   /* U+3DB1 */
  0x0020,   /* U+3DB2 */
  0x0020,   /* U+3DB3 */
  0x0020,   /* U+3DB4 */
  0x0020,   /* U+3DB5 */
  0x0020,   /* U+3DB6 */
  0x0020,   /* U+3DB7 */
  0x0020,   /* U+3DB8 */
  0x0020,   /* U+3DB9 */
  0x0020,   /* U+3DBA */
  0x0020,   /* U+3DBB */
  0x0020,   /* U+3DBC */
  0x0020,   /* U+3DBD */
  0x0020,   /* U+3DBE */
  0x0020,   /* U+3DBF */
  0x0020,   /* U+3DC0 */
  0x0020,   /* U+3DC1 */
  0x0020,   /* U+3DC2 */
  0x0020,   /* U+3DC3 */
  0x0020,   /* U+3DC4 */
  0x0020,   /* U+3DC5 */
  0x0020,   /* U+3DC6 */
  0x0020,   /* U+3DC7 */
  0x0020,   /* U+3DC8 */
  0x0020,   /* U+3DC9 */
  0x0020,   /* U+3DCA */
  0x0020,   /* U+3DCB */
  0x0020,   /* U+3DCC */
  0x0020,   /* U+3DCD */
  0x0020,   /* U+3DCE */
  0x0020,   /* U+3DCF */
  0x0020,   /* U+3DD0 */
  0x0020,   /* U+3DD1 */
  0x0020,   /* U+3DD2 */
  0x0020,   /* U+3DD3 */
  0x0020,   /* U+3DD4 */
  0x0020,   /* U+3DD5 */
  0x0020,   /* U+3DD6 */
  0x0020,   /* U+3DD7 */
  0x0020,   /* U+3DD8 */
  0x0020,   /* U+3DD9 */
  0x0020,   /* U+3DDA */
  0x0020,   /* U+3DDB */
  0x0020,   /* U+3DDC */
  0x0020,   /* U+3DDD */
  0x0020,   /* U+3DDE */
  0x0020,   /* U+3DDF */
  0x0020,   /* U+3DE0 */
  0x0020,   /* U+3DE1 */
  0x0020,   /* U+3DE2 */
  0x0020,   /* U+3DE3 */
  0x0020,   /* U+3DE4 */
  0x0020,   /* U+3DE5 */
  0x0020,   /* U+3DE6 */
  0x0020,   /* U+3DE7 */
  0x0020,   /* U+3DE8 */
  0x0020,   /* U+3DE9 */
  0x0020,   /* U+3DEA */
  0x0020,   /* U+3DEB */
  0x0020,   /* U+3DEC */
  0x0020,   /* U+3DED */
  0x0020,   /* U+3DEE */
  0x0020,   /* U+3DEF */
  0x0020,   /* U+3DF0 */
  0x0020,   /* U+3DF1 */
  0x0020,   /* U+3DF2 */
  0x0020,   /* U+3DF3 */
  0x0020,   /* U+3DF4 */
  0x0020,   /* U+3DF5 */
  0x0020,   /* U+3DF6 */
  0x0020,   /* U+3DF7 */
  0x0020,   /* U+3DF8 */
  0x0020,   /* U+3DF9 */
  0x0020,   /* U+3DFA */
  0x0020,   /* U+3DFB */
  0x0020,   /* U+3DFC */
  0x0020,   /* U+3DFD */
  0x0020,   /* U+3DFE */
  0x0020,   /* U+3DFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3D00 */
  0x0002,   /* U+3D01 */
  0x0002,   /* U+3D02 */
  0x0002,   /* U+3D03 */
  0x0002,   /* U+3D04 */
  0x0002,   /* U+3D05 */
  0x0002,   /* U+3D06 */
  0x0002,   /* U+3D07 */
  0x0002,   /* U+3D08 */
  0x0002,   /* U+3D09 */
  0x0002,   /* U+3D0A */
  0x0002,   /* U+3D0B */
  0x0002,   /* U+3D0C */
  0x0002,   /* U+3D0D */
  0x0002,   /* U+3D0E */
  0x0002,   /* U+3D0F */
  0x0002,   /* U+3D10 */
  0x0002,   /* U+3D11 */
  0x0002,   /* U+3D12 */
  0x0002,   /* U+3D13 */
  0x0002,   /* U+3D14 */
  0x0002,   /* U+3D15 */
  0x0002,   /* U+3D16 */
  0x0002,   /* U+3D17 */
  0x0002,   /* U+3D18 */
  0x0002,   /* U+3D19 */
  0x0002,   /* U+3D1A */
  0x0002,   /* U+3D1B */
  0x0002,   /* U+3D1C */
  0x0002,   /* U+3D1D */
  0x0002,   /* U+3D1E */
  0x0002,   /* U+3D1F */
  0x0002,   /* U+3D20 */
  0x0002,   /* U+3D21 */
  0x0002,   /* U+3D22 */
  0x0002,   /* U+3D23 */
  0x0002,   /* U+3D24 */
  0x0002,   /* U+3D25 */
  0x0002,   /* U+3D26 */
  0x0002,   /* U+3D27 */
  0x0002,   /* U+3D28 */
  0x0002,   /* U+3D29 */
  0x0002,   /* U+3D2A */
  0x0002,   /* U+3D2B */
  0x0002,   /* U+3D2C */
  0x0002,   /* U+3D2D */
  0x0002,   /* U+3D2E */
  0x0002,   /* U+3D2F */
  0x0002,   /* U+3D30 */
  0x0002,   /* U+3D31 */
  0x0002,   /* U+3D32 */
  0x0002,   /* U+3D33 */
  0x0002,   /* U+3D34 */
  0x0002,   /* U+3D35 */
  0x0002,   /* U+3D36 */
  0x0002,   /* U+3D37 */
  0x0002,   /* U+3D38 */
  0x0002,   /* U+3D39 */
  0x0002,   /* U+3D3A */
  0x0002,   /* U+3D3B */
  0x0002,   /* U+3D3C */
  0x0002,   /* U+3D3D */
  0x0002,   /* U+3D3E */
  0x0002,   /* U+3D3F */
  0x0002,   /* U+3D40 */
  0x0002,   /* U+3D41 */
  0x0002,   /* U+3D42 */
  0x0002,   /* U+3D43 */
  0x0002,   /* U+3D44 */
  0x0002,   /* U+3D45 */
  0x0002,   /* U+3D46 */
  0x0002,   /* U+3D47 */
  0x0002,   /* U+3D48 */
  0x0002,   /* U+3D49 */
  0x0002,   /* U+3D4A */
  0x0002,   /* U+3D4B */
  0x0002,   /* U+3D4C */
  0x0002,   /* U+3D4D */
  0x0002,   /* U+3D4E */
  0x0002,   /* U+3D4F */
  0x0002,   /* U+3D50 */
  0x0002,   /* U+3D51 */
  0x0002,   /* U+3D52 */
  0x0002,   /* U+3D53 */
  0x0002,   /* U+3D54 */
  0x0002,   /* U+3D55 */
  0x0002,   /* U+3D56 */
  0x0002,   /* U+3D57 */
  0x0002,   /* U+3D58 */
  0x0002,   /* U+3D59 */
  0x0002,   /* U+3D5A */
  0x0002,   /* U+3D5B */
  0x0002,   /* U+3D5C */
  0x0002,   /* U+3D5D */
  0x0002,   /* U+3D5E */
  0x0002,   /* U+3D5F */
  0x0002,   /* U+3D60 */
  0x0002,   /* U+3D61 */
  0x0002,   /* U+3D62 */
  0x0002,   /* U+3D63 */
  0x0002,   /* U+3D64 */
  0x0002,   /* U+3D65 */
  0x0002,   /* U+3D66 */
  0x0002,   /* U+3D67 */
  0x0002,   /* U+3D68 */
  0x0002,   /* U+3D69 */
  0x0002,   /* U+3D6A */
  0x0002,   /* U+3D6B */
  0x0002,   /* U+3D6C */
  0x0002,   /* U+3D6D */
  0x0002,   /* U+3D6E */
  0x0002,   /* U+3D6F */
  0x0002,   /* U+3D70 */
  0x0002,   /* U+3D71 */
  0x0002,   /* U+3D72 */
  0x0002,   /* U+3D73 */
  0x0002,   /* U+3D74 */
  0x0002,   /* U+3D75 */
  0x0002,   /* U+3D76 */
  0x0002,   /* U+3D77 */
  0x0002,   /* U+3D78 */
  0x0002,   /* U+3D79 */
  0x0002,   /* U+3D7A */
  0x0002,   /* U+3D7B */
  0x0002,   /* U+3D7C */
  0x0002,   /* U+3D7D */
  0x0002,   /* U+3D7E */
  0x0002,   /* U+3D7F */
  0x0002,   /* U+3D80 */
  0x0002,   /* U+3D81 */
  0x0002,   /* U+3D82 */
  0x0002,   /* U+3D83 */
  0x0002,   /* U+3D84 */
  0x0002,   /* U+3D85 */
  0x0002,   /* U+3D86 */
  0x0002,   /* U+3D87 */
  0x0002,   /* U+3D88 */
  0x0002,   /* U+3D89 */
  0x0002,   /* U+3D8A */
  0x0002,   /* U+3D8B */
  0x0002,   /* U+3D8C */
  0x0002,   /* U+3D8D */
  0x0002,   /* U+3D8E */
  0x0002,   /* U+3D8F */
  0x0002,   /* U+3D90 */
  0x0002,   /* U+3D91 */
  0x0002,   /* U+3D92 */
  0x0002,   /* U+3D93 */
  0x0002,   /* U+3D94 */
  0x0002,   /* U+3D95 */
  0x0002,   /* U+3D96 */
  0x0002,   /* U+3D97 */
  0x0002,   /* U+3D98 */
  0x0002,   /* U+3D99 */
  0x0002,   /* U+3D9A */
  0x0002,   /* U+3D9B */
  0x0002,   /* U+3D9C */
  0x0002,   /* U+3D9D */
  0x0002,   /* U+3D9E */
  0x0002,   /* U+3D9F */
  0x0002,   /* U+3DA0 */
  0x0002,   /* U+3DA1 */
  0x0002,   /* U+3DA2 */
  0x0002,   /* U+3DA3 */
  0x0002,   /* U+3DA4 */
  0x0002,   /* U+3DA5 */
  0x0002,   /* U+3DA6 */
  0x0002,   /* U+3DA7 */
  0x0002,   /* U+3DA8 */
  0x0002,   /* U+3DA9 */
  0x0002,   /* U+3DAA */
  0x0002,   /* U+3DAB */
  0x0002,   /* U+3DAC */
  0x0002,   /* U+3DAD */
  0x0002,   /* U+3DAE */
  0x0002,   /* U+3DAF */
  0x0002,   /* U+3DB0 */
  0x0002,   /* U+3DB1 */
  0x0002,   /* U+3DB2 */
  0x0002,   /* U+3DB3 */
  0x0002,   /* U+3DB4 */
  0x0002,   /* U+3DB5 */
  0x0002,   /* U+3DB6 */
  0x0002,   /* U+3DB7 */
  0x0002,   /* U+3DB8 */
  0x0002,   /* U+3DB9 */
  0x0002,   /* U+3DBA */
  0x0002,   /* U+3DBB */
  0x0002,   /* U+3DBC */
  0x0002,   /* U+3DBD */
  0x0002,   /* U+3DBE */
  0x0002,   /* U+3DBF */
  0x0002,   /* U+3DC0 */
  0x0002,   /* U+3DC1 */
  0x0002,   /* U+3DC2 */
  0x0002,   /* U+3DC3 */
  0x0002,   /* U+3DC4 */
  0x0002,   /* U+3DC5 */
  0x0002,   /* U+3DC6 */
  0x0002,   /* U+3DC7 */
  0x0002,   /* U+3DC8 */
  0x0002,   /* U+3DC9 */
  0x0002,   /* U+3DCA */
  0x0002,   /* U+3DCB */
  0x0002,   /* U+3DCC */
  0x0002,   /* U+3DCD */
  0x0002,   /* U+3DCE */
  0x0002,   /* U+3DCF */
  0x0002,   /* U+3DD0 */
  0x0002,   /* U+3DD1 */
  0x0002,   /* U+3DD2 */
  0x0002,   /* U+3DD3 */
  0x0002,   /* U+3DD4 */
  0x0002,   /* U+3DD5 */
  0x0002,   /* U+3DD6 */
  0x0002,   /* U+3DD7 */
  0x0002,   /* U+3DD8 */
  0x0002,   /* U+3DD9 */
  0x0002,   /* U+3DDA */
  0x0002,   /* U+3DDB */
  0x0002,   /* U+3DDC */
  0x0002,   /* U+3DDD */
  0x0002,   /* U+3DDE */
  0x0002,   /* U+3DDF */
  0x0002,   /* U+3DE0 */
  0x0002,   /* U+3DE1 */
  0x0002,   /* U+3DE2 */
  0x0002,   /* U+3DE3 */
  0x0002,   /* U+3DE4 */
  0x0002,   /* U+3DE5 */
  0x0002,   /* U+3DE6 */
  0x0002,   /* U+3DE7 */
  0x0002,   /* U+3DE8 */
  0x0002,   /* U+3DE9 */
  0x0002,   /* U+3DEA */
  0x0002,   /* U+3DEB */
  0x0002,   /* U+3DEC */
  0x0002,   /* U+3DED */
  0x0002,   /* U+3DEE */
  0x0002,   /* U+3DEF */
  0x0002,   /* U+3DF0 */
  0x0002,   /* U+3DF1 */
  0x0002,   /* U+3DF2 */
  0x0002,   /* U+3DF3 */
  0x0002,   /* U+3DF4 */
  0x0002,   /* U+3DF5 */
  0x0002,   /* U+3DF6 */
  0x0002,   /* U+3DF7 */
  0x0002,   /* U+3DF8 */
  0x0002,   /* U+3DF9 */
  0x0002,   /* U+3DFA */
  0x0002,   /* U+3DFB */
  0x0002,   /* U+3DFC */
  0x0002,   /* U+3DFD */
  0x0002,   /* U+3DFE */
  0x0002,   /* U+3DFF */

  /* Primary weight 2 for each character. */
  0x800C,   /* U+3D00 */
  0x800D,   /* U+3D01 */
  0x800E,   /* U+3D02 */
  0x800F,   /* U+3D03 */
  0x8010,   /* U+3D04 */
  0x8011,   /* U+3D05 */
  0x8012,   /* U+3D06 */
  0x8013,   /* U+3D07 */
  0x8014,   /* U+3D08 */
  0x8015,   /* U+3D09 */
  0x8016,   /* U+3D0A */
  0x8017,   /* U+3D0B */
  0xBD0C,   /* U+3D0C */
  0xBD0D,   /* U+3D0D */
  0x8018,   /* U+3D0E */
  0x8000,   /* U+3D0F */
  0x8001,   /* U+3D10 */
  0x8002,   /* U+3D11 */
  0x8003,   /* U+3D12 */
  0x8004,   /* U+3D13 */
  0x8005,   /* U+3D14 */
  0x8006,   /* U+3D15 */
  0x8007,   /* U+3D16 */
  0x8008,   /* U+3D17 */
  0x8009,   /* U+3D18 */
  0x800A,   /* U+3D19 */
  0x800B,   /* U+3D1A */
  0x800C,   /* U+3D1B */
  0x800D,   /* U+3D1C */
  0x800E,   /* U+3D1D */
  0x800F,   /* U+3D1E */
  0x8010,   /* U+3D1F */
  0xBD20,   /* U+3D20 */
  0x8011,   /* U+3D21 */
  0xBD22,   /* U+3D22 */
  0xBD23,   /* U+3D23 */
  0xBD24,   /* U+3D24 */
  0x8001,   /* U+3D25 */
  0x8002,   /* U+3D26 */
  0x8003,   /* U+3D27 */
  0x8004,   /* U+3D28 */
  0x8005,   /* U+3D29 */
  0x8006,   /* U+3D2A */
  0x8007,   /* U+3D2B */
  0x8008,   /* U+3D2C */
  0x8009,   /* U+3D2D */
  0x800A,   /* U+3D2E */
  0x800B,   /* U+3D2F */
  0x800C,   /* U+3D30 */
  0x800D,   /* U+3D31 */
  0x800E,   /* U+3D32 */
  0x800F,   /* U+3D33 */
  0x8010,   /* U+3D34 */
  0x8011,   /* U+3D35 */
  0x8012,   /* U+3D36 */
  0x8013,   /* U+3D37 */
  0x8014,   /* U+3D38 */
  0xBD39,   /* U+3D39 */
  0xBD3A,   /* U+3D3A */
  0xBD3B,   /* U+3D3B */
  0x8000,   /* U+3D3C */
  0x8001,   /* U+3D3D */
  0x8002,   /* U+3D3E */
  0x8003,   /* U+3D3F */
  0x8004,   /* U+3D40 */
  0x8005,   /* U+3D41 */
  0x8006,   /* U+3D42 */
  0x8007,   /* U+3D43 */
  0x8008,   /* U+3D44 */
  0x8009,   /* U+3D45 */
  0x800A,   /* U+3D46 */
  0x800B,   /* U+3D47 */
  0xBD48,   /* U+3D48 */
  0xBD49,   /* U+3D49 */
  0x8000,   /* U+3D4A */
  0x8001,   /* U+3D4B */
  0x8002,   /* U+3D4C */
  0x8003,   /* U+3D4D */
  0x8004,   /* U+3D4E */
  0x8005,   /* U+3D4F */
  0x8006,   /* U+3D50 */
  0x8007,   /* U+3D51 */
  0x8008,   /* U+3D52 */
  0x8009,   /* U+3D53 */
  0x800A,   /* U+3D54 */
  0x800B,   /* U+3D55 */
  0x800C,   /* U+3D56 */
  0x800D,   /* U+3D57 */
  0x800E,   /* U+3D58 */
  0x800F,   /* U+3D59 */
  0x8010,   /* U+3D5A */
  0xBD5B,   /* U+3D5B */
  0xBD5C,   /* U+3D5C */
  0x8000,   /* U+3D5D */
  0x8001,   /* U+3D5E */
  0x8002,   /* U+3D5F */
  0x8003,   /* U+3D60 */
  0x8004,   /* U+3D61 */
  0x8005,   /* U+3D62 */
  0x8006,   /* U+3D63 */
  0x8007,   /* U+3D64 */
  0x8008,   /* U+3D65 */
  0x8009,   /* U+3D66 */
  0x800A,   /* U+3D67 */
  0x800B,   /* U+3D68 */
  0x800C,   /* U+3D69 */
  0x800D,   /* U+3D6A */
  0x800E,   /* U+3D6B */
  0x800F,   /* U+3D6C */
  0x8010,   /* U+3D6D */
  0x8011,   /* U+3D6E */
  0x8000,   /* U+3D6F */
  0x8001,   /* U+3D70 */
  0x8002,   /* U+3D71 */
  0x8003,   /* U+3D72 */
  0x8004,   /* U+3D73 */
  0x8005,   /* U+3D74 */
  0x8006,   /* U+3D75 */
  0x8007,   /* U+3D76 */
  0x8008,   /* U+3D77 */
  0x8009,   /* U+3D78 */
  0x800A,   /* U+3D79 */
  0x800B,   /* U+3D7A */
  0x800C,   /* U+3D7B */
  0xBD7C,   /* U+3D7C */
  0x8000,   /* U+3D7D */
  0x8001,   /* U+3D7E */
  0x8002,   /* U+3D7F */
  0x8003,   /* U+3D80 */
  0x8004,   /* U+3D81 */
  0xBD82,   /* U+3D82 */
  0xBD83,   /* U+3D83 */
  0x8000,   /* U+3D84 */
  0x8001,   /* U+3D85 */
  0x8002,   /* U+3D86 */
  0x8003,   /* U+3D87 */
  0x8004,   /* U+3D88 */
  0x8005,   /* U+3D89 */
  0xBD8A,   /* U+3D8A */
  0xBD8B,   /* U+3D8B */
  0x8000,   /* U+3D8C */
  0x8001,   /* U+3D8D */
  0x8002,   /* U+3D8E */
  0x8003,   /* U+3D8F */
  0xBD90,   /* U+3D90 */
  0x8004,   /* U+3D91 */
  0x8000,   /* U+3D92 */
  0x8001,   /* U+3D93 */
  0x8002,   /* U+3D94 */
  0x8003,   /* U+3D95 */
  0x8004,   /* U+3D96 */
  0x8005,   /* U+3D97 */
  0x8006,   /* U+3D98 */
  0xBD99,   /* U+3D99 */
  0xBD9A,   /* U+3D9A */
  0x8004,   /* U+3D9B */
  0x8005,   /* U+3D9C */
  0xBD9D,   /* U+3D9D */
  0x8000,   /* U+3D9E */
  0x8001,   /* U+3D9F */
  0x8000,   /* U+3DA0 */
  0x8000,   /* U+3DA1 */
  0xBDA2,   /* U+3DA2 */
  0x8000,   /* U+3DA3 */
  0x8001,   /* U+3DA4 */
  0x8002,   /* U+3DA5 */
  0x8000,   /* U+3DA6 */
  0x8001,   /* U+3DA7 */
  0x8002,   /* U+3DA8 */
  0x8003,   /* U+3DA9 */
  0xBDAA,   /* U+3DAA */
  0x8000,   /* U+3DAB */
  0x8001,   /* U+3DAC */
  0x8002,   /* U+3DAD */
  0x8003,   /* U+3DAE */
  0x8004,   /* U+3DAF */
  0x8005,   /* U+3DB0 */
  0xBDB1,   /* U+3DB1 */
  0x8006,   /* U+3DB2 */
  0x8000,   /* U+3DB3 */
  0x8001,   /* U+3DB4 */
  0x8002,   /* U+3DB5 */
  0x8003,   /* U+3DB6 */
  0xBDB7,   /* U+3DB7 */
  0x8004,   /* U+3DB8 */
  0x8000,   /* U+3DB9 */
  0x8001,   /* U+3DBA */
  0x8002,   /* U+3DBB */
  0x8003,   /* U+3DBC */
  0x8004,   /* U+3DBD */
  0x8005,   /* U+3DBE */
  0x8006,   /* U+3DBF */
  0x8007,   /* U+3DC0 */
  0xBDC1,   /* U+3DC1 */
  0x8000,   /* U+3DC2 */
  0x8001,   /* U+3DC3 */
  0x8002,   /* U+3DC4 */
  0x8003,   /* U+3DC5 */
  0x8004,   /* U+3DC6 */
  0x8005,   /* U+3DC7 */
  0x8006,   /* U+3DC8 */
  0x8007,   /* U+3DC9 */
  0x8008,   /* U+3DCA */
  0x8009,   /* U+3DCB */
  0x800A,   /* U+3DCC */
  0x800B,   /* U+3DCD */
  0x8001,   /* U+3DCE */
  0x8002,   /* U+3DCF */
  0x8003,   /* U+3DD0 */
  0x8004,   /* U+3DD1 */
  0x8005,   /* U+3DD2 */
  0x8006,   /* U+3DD3 */
  0x8007,   /* U+3DD4 */
  0x8008,   /* U+3DD5 */
  0x8009,   /* U+3DD6 */
  0x800A,   /* U+3DD7 */
  0x800B,   /* U+3DD8 */
  0x800C,   /* U+3DD9 */
  0x800D,   /* U+3DDA */
  0x800E,   /* U+3DDB */
  0xBDDC,   /* U+3DDC */
  0xBDDD,   /* U+3DDD */
  0xBDDE,   /* U+3DDE */
  0x8000,   /* U+3DDF */
  0x8001,   /* U+3DE0 */
  0x8002,   /* U+3DE1 */
  0x8003,   /* U+3DE2 */
  0x8004,   /* U+3DE3 */
  0x8005,   /* U+3DE4 */
  0x8006,   /* U+3DE5 */
  0x8007,   /* U+3DE6 */
  0x8008,   /* U+3DE7 */
  0x8009,   /* U+3DE8 */
  0xBDE9,   /* U+3DE9 */
  0x800A,   /* U+3DEA */
  0x8000,   /* U+3DEB */
  0x8001,   /* U+3DEC */
  0x8002,   /* U+3DED */
  0x8003,   /* U+3DEE */
  0x8004,   /* U+3DEF */
  0x8005,   /* U+3DF0 */
  0xBDF1,   /* U+3DF1 */
  0xBDF2,   /* U+3DF2 */
  0x8000,   /* U+3DF3 */
  0x8001,   /* U+3DF4 */
  0x8002,   /* U+3DF5 */
  0x8003,   /* U+3DF6 */
  0x8004,   /* U+3DF7 */
  0x8005,   /* U+3DF8 */
  0x8006,   /* U+3DF9 */
  0x8007,   /* U+3DFA */
  0x8008,   /* U+3DFB */
  0xBDFC,   /* U+3DFC */
  0xBDFD,   /* U+3DFD */
  0x8000,   /* U+3DFE */
  0x8001,   /* U+3DFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3D00 */
  0x0000,   /* U+3D01 */
  0x0000,   /* U+3D02 */
  0x0000,   /* U+3D03 */
  0x0000,   /* U+3D04 */
  0x0000,   /* U+3D05 */
  0x0000,   /* U+3D06 */
  0x0000,   /* U+3D07 */
  0x0000,   /* U+3D08 */
  0x0000,   /* U+3D09 */
  0x0000,   /* U+3D0A */
  0x0000,   /* U+3D0B */
  0x0000,   /* U+3D0C */
  0x0000,   /* U+3D0D */
  0x0000,   /* U+3D0E */
  0x0000,   /* U+3D0F */
  0x0000,   /* U+3D10 */
  0x0000,   /* U+3D11 */
  0x0000,   /* U+3D12 */
  0x0000,   /* U+3D13 */
  0x0000,   /* U+3D14 */
  0x0000,   /* U+3D15 */
  0x0000,   /* U+3D16 */
  0x0000,   /* U+3D17 */
  0x0000,   /* U+3D18 */
  0x0000,   /* U+3D19 */
  0x0000,   /* U+3D1A */
  0x0000,   /* U+3D1B */
  0x0000,   /* U+3D1C */
  0x0000,   /* U+3D1D */
  0x0000,   /* U+3D1E */
  0x0000,   /* U+3D1F */
  0x0000,   /* U+3D20 */
  0x0000,   /* U+3D21 */
  0x0000,   /* U+3D22 */
  0x0000,   /* U+3D23 */
  0x0000,   /* U+3D24 */
  0x0000,   /* U+3D25 */
  0x0000,   /* U+3D26 */
  0x0000,   /* U+3D27 */
  0x0000,   /* U+3D28 */
  0x0000,   /* U+3D29 */
  0x0000,   /* U+3D2A */
  0x0000,   /* U+3D2B */
  0x0000,   /* U+3D2C */
  0x0000,   /* U+3D2D */
  0x0000,   /* U+3D2E */
  0x0000,   /* U+3D2F */
  0x0000,   /* U+3D30 */
  0x0000,   /* U+3D31 */
  0x0000,   /* U+3D32 */
  0x0000,   /* U+3D33 */
  0x0000,   /* U+3D34 */
  0x0000,   /* U+3D35 */
  0x0000,   /* U+3D36 */
  0x0000,   /* U+3D37 */
  0x0000,   /* U+3D38 */
  0x0000,   /* U+3D39 */
  0x0000,   /* U+3D3A */
  0x0000,   /* U+3D3B */
  0x0000,   /* U+3D3C */
  0x0000,   /* U+3D3D */
  0x0000,   /* U+3D3E */
  0x0000,   /* U+3D3F */
  0x0000,   /* U+3D40 */
  0x0000,   /* U+3D41 */
  0x0000,   /* U+3D42 */
  0x0000,   /* U+3D43 */
  0x0000,   /* U+3D44 */
  0x0000,   /* U+3D45 */
  0x0000,   /* U+3D46 */
  0x0000,   /* U+3D47 */
  0x0000,   /* U+3D48 */
  0x0000,   /* U+3D49 */
  0x0000,   /* U+3D4A */
  0x0000,   /* U+3D4B */
  0x0000,   /* U+3D4C */
  0x0000,   /* U+3D4D */
  0x0000,   /* U+3D4E */
  0x0000,   /* U+3D4F */
  0x0000,   /* U+3D50 */
  0x0000,   /* U+3D51 */
  0x0000,   /* U+3D52 */
  0x0000,   /* U+3D53 */
  0x0000,   /* U+3D54 */
  0x0000,   /* U+3D55 */
  0x0000,   /* U+3D56 */
  0x0000,   /* U+3D57 */
  0x0000,   /* U+3D58 */
  0x0000,   /* U+3D59 */
  0x0000,   /* U+3D5A */
  0x0000,   /* U+3D5B */
  0x0000,   /* U+3D5C */
  0x0000,   /* U+3D5D */
  0x0000,   /* U+3D5E */
  0x0000,   /* U+3D5F */
  0x0000,   /* U+3D60 */
  0x0000,   /* U+3D61 */
  0x0000,   /* U+3D62 */
  0x0000,   /* U+3D63 */
  0x0000,   /* U+3D64 */
  0x0000,   /* U+3D65 */
  0x0000,   /* U+3D66 */
  0x0000,   /* U+3D67 */
  0x0000,   /* U+3D68 */
  0x0000,   /* U+3D69 */
  0x0000,   /* U+3D6A */
  0x0000,   /* U+3D6B */
  0x0000,   /* U+3D6C */
  0x0000,   /* U+3D6D */
  0x0000,   /* U+3D6E */
  0x0000,   /* U+3D6F */
  0x0000,   /* U+3D70 */
  0x0000,   /* U+3D71 */
  0x0000,   /* U+3D72 */
  0x0000,   /* U+3D73 */
  0x0000,   /* U+3D74 */
  0x0000,   /* U+3D75 */
  0x0000,   /* U+3D76 */
  0x0000,   /* U+3D77 */
  0x0000,   /* U+3D78 */
  0x0000,   /* U+3D79 */
  0x0000,   /* U+3D7A */
  0x0000,   /* U+3D7B */
  0x0000,   /* U+3D7C */
  0x0000,   /* U+3D7D */
  0x0000,   /* U+3D7E */
  0x0000,   /* U+3D7F */
  0x0000,   /* U+3D80 */
  0x0000,   /* U+3D81 */
  0x0000,   /* U+3D82 */
  0x0000,   /* U+3D83 */
  0x0000,   /* U+3D84 */
  0x0000,   /* U+3D85 */
  0x0000,   /* U+3D86 */
  0x0000,   /* U+3D87 */
  0x0000,   /* U+3D88 */
  0x0000,   /* U+3D89 */
  0x0000,   /* U+3D8A */
  0x0000,   /* U+3D8B */
  0x0000,   /* U+3D8C */
  0x0000,   /* U+3D8D */
  0x0000,   /* U+3D8E */
  0x0000,   /* U+3D8F */
  0x0000,   /* U+3D90 */
  0x0000,   /* U+3D91 */
  0x0000,   /* U+3D92 */
  0x0000,   /* U+3D93 */
  0x0000,   /* U+3D94 */
  0x0000,   /* U+3D95 */
  0x0000,   /* U+3D96 */
  0x0000,   /* U+3D97 */
  0x0000,   /* U+3D98 */
  0x0000,   /* U+3D99 */
  0x0000,   /* U+3D9A */
  0x0000,   /* U+3D9B */
  0x0000,   /* U+3D9C */
  0x0000,   /* U+3D9D */
  0x0000,   /* U+3D9E */
  0x0000,   /* U+3D9F */
  0x0000,   /* U+3DA0 */
  0x0000,   /* U+3DA1 */
  0x0000,   /* U+3DA2 */
  0x0000,   /* U+3DA3 */
  0x0000,   /* U+3DA4 */
  0x0000,   /* U+3DA5 */
  0x0000,   /* U+3DA6 */
  0x0000,   /* U+3DA7 */
  0x0000,   /* U+3DA8 */
  0x0000,   /* U+3DA9 */
  0x0000,   /* U+3DAA */
  0x0000,   /* U+3DAB */
  0x0000,   /* U+3DAC */
  0x0000,   /* U+3DAD */
  0x0000,   /* U+3DAE */
  0x0000,   /* U+3DAF */
  0x0000,   /* U+3DB0 */
  0x0000,   /* U+3DB1 */
  0x0000,   /* U+3DB2 */
  0x0000,   /* U+3DB3 */
  0x0000,   /* U+3DB4 */
  0x0000,   /* U+3DB5 */
  0x0000,   /* U+3DB6 */
  0x0000,   /* U+3DB7 */
  0x0000,   /* U+3DB8 */
  0x0000,   /* U+3DB9 */
  0x0000,   /* U+3DBA */
  0x0000,   /* U+3DBB */
  0x0000,   /* U+3DBC */
  0x0000,   /* U+3DBD */
  0x0000,   /* U+3DBE */
  0x0000,   /* U+3DBF */
  0x0000,   /* U+3DC0 */
  0x0000,   /* U+3DC1 */
  0x0000,   /* U+3DC2 */
  0x0000,   /* U+3DC3 */
  0x0000,   /* U+3DC4 */
  0x0000,   /* U+3DC5 */
  0x0000,   /* U+3DC6 */
  0x0000,   /* U+3DC7 */
  0x0000,   /* U+3DC8 */
  0x0000,   /* U+3DC9 */
  0x0000,   /* U+3DCA */
  0x0000,   /* U+3DCB */
  0x0000,   /* U+3DCC */
  0x0000,   /* U+3DCD */
  0x0000,   /* U+3DCE */
  0x0000,   /* U+3DCF */
  0x0000,   /* U+3DD0 */
  0x0000,   /* U+3DD1 */
  0x0000,   /* U+3DD2 */
  0x0000,   /* U+3DD3 */
  0x0000,   /* U+3DD4 */
  0x0000,   /* U+3DD5 */
  0x0000,   /* U+3DD6 */
  0x0000,   /* U+3DD7 */
  0x0000,   /* U+3DD8 */
  0x0000,   /* U+3DD9 */
  0x0000,   /* U+3DDA */
  0x0000,   /* U+3DDB */
  0x0000,   /* U+3DDC */
  0x0000,   /* U+3DDD */
  0x0000,   /* U+3DDE */
  0x0000,   /* U+3DDF */
  0x0000,   /* U+3DE0 */
  0x0000,   /* U+3DE1 */
  0x0000,   /* U+3DE2 */
  0x0000,   /* U+3DE3 */
  0x0000,   /* U+3DE4 */
  0x0000,   /* U+3DE5 */
  0x0000,   /* U+3DE6 */
  0x0000,   /* U+3DE7 */
  0x0000,   /* U+3DE8 */
  0x0000,   /* U+3DE9 */
  0x0000,   /* U+3DEA */
  0x0000,   /* U+3DEB */
  0x0000,   /* U+3DEC */
  0x0000,   /* U+3DED */
  0x0000,   /* U+3DEE */
  0x0000,   /* U+3DEF */
  0x0000,   /* U+3DF0 */
  0x0000,   /* U+3DF1 */
  0x0000,   /* U+3DF2 */
  0x0000,   /* U+3DF3 */
  0x0000,   /* U+3DF4 */
  0x0000,   /* U+3DF5 */
  0x0000,   /* U+3DF6 */
  0x0000,   /* U+3DF7 */
  0x0000,   /* U+3DF8 */
  0x0000,   /* U+3DF9 */
  0x0000,   /* U+3DFA */
  0x0000,   /* U+3DFB */
  0x0000,   /* U+3DFC */
  0x0000,   /* U+3DFD */
  0x0000,   /* U+3DFE */
  0x0000,   /* U+3DFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3D00 */
  0x0000,   /* U+3D01 */
  0x0000,   /* U+3D02 */
  0x0000,   /* U+3D03 */
  0x0000,   /* U+3D04 */
  0x0000,   /* U+3D05 */
  0x0000,   /* U+3D06 */
  0x0000,   /* U+3D07 */
  0x0000,   /* U+3D08 */
  0x0000,   /* U+3D09 */
  0x0000,   /* U+3D0A */
  0x0000,   /* U+3D0B */
  0x0000,   /* U+3D0C */
  0x0000,   /* U+3D0D */
  0x0000,   /* U+3D0E */
  0x0000,   /* U+3D0F */
  0x0000,   /* U+3D10 */
  0x0000,   /* U+3D11 */
  0x0000,   /* U+3D12 */
  0x0000,   /* U+3D13 */
  0x0000,   /* U+3D14 */
  0x0000,   /* U+3D15 */
  0x0000,   /* U+3D16 */
  0x0000,   /* U+3D17 */
  0x0000,   /* U+3D18 */
  0x0000,   /* U+3D19 */
  0x0000,   /* U+3D1A */
  0x0000,   /* U+3D1B */
  0x0000,   /* U+3D1C */
  0x0000,   /* U+3D1D */
  0x0000,   /* U+3D1E */
  0x0000,   /* U+3D1F */
  0x0000,   /* U+3D20 */
  0x0000,   /* U+3D21 */
  0x0000,   /* U+3D22 */
  0x0000,   /* U+3D23 */
  0x0000,   /* U+3D24 */
  0x0000,   /* U+3D25 */
  0x0000,   /* U+3D26 */
  0x0000,   /* U+3D27 */
  0x0000,   /* U+3D28 */
  0x0000,   /* U+3D29 */
  0x0000,   /* U+3D2A */
  0x0000,   /* U+3D2B */
  0x0000,   /* U+3D2C */
  0x0000,   /* U+3D2D */
  0x0000,   /* U+3D2E */
  0x0000,   /* U+3D2F */
  0x0000,   /* U+3D30 */
  0x0000,   /* U+3D31 */
  0x0000,   /* U+3D32 */
  0x0000,   /* U+3D33 */
  0x0000,   /* U+3D34 */
  0x0000,   /* U+3D35 */
  0x0000,   /* U+3D36 */
  0x0000,   /* U+3D37 */
  0x0000,   /* U+3D38 */
  0x0000,   /* U+3D39 */
  0x0000,   /* U+3D3A */
  0x0000,   /* U+3D3B */
  0x0000,   /* U+3D3C */
  0x0000,   /* U+3D3D */
  0x0000,   /* U+3D3E */
  0x0000,   /* U+3D3F */
  0x0000,   /* U+3D40 */
  0x0000,   /* U+3D41 */
  0x0000,   /* U+3D42 */
  0x0000,   /* U+3D43 */
  0x0000,   /* U+3D44 */
  0x0000,   /* U+3D45 */
  0x0000,   /* U+3D46 */
  0x0000,   /* U+3D47 */
  0x0000,   /* U+3D48 */
  0x0000,   /* U+3D49 */
  0x0000,   /* U+3D4A */
  0x0000,   /* U+3D4B */
  0x0000,   /* U+3D4C */
  0x0000,   /* U+3D4D */
  0x0000,   /* U+3D4E */
  0x0000,   /* U+3D4F */
  0x0000,   /* U+3D50 */
  0x0000,   /* U+3D51 */
  0x0000,   /* U+3D52 */
  0x0000,   /* U+3D53 */
  0x0000,   /* U+3D54 */
  0x0000,   /* U+3D55 */
  0x0000,   /* U+3D56 */
  0x0000,   /* U+3D57 */
  0x0000,   /* U+3D58 */
  0x0000,   /* U+3D59 */
  0x0000,   /* U+3D5A */
  0x0000,   /* U+3D5B */
  0x0000,   /* U+3D5C */
  0x0000,   /* U+3D5D */
  0x0000,   /* U+3D5E */
  0x0000,   /* U+3D5F */
  0x0000,   /* U+3D60 */
  0x0000,   /* U+3D61 */
  0x0000,   /* U+3D62 */
  0x0000,   /* U+3D63 */
  0x0000,   /* U+3D64 */
  0x0000,   /* U+3D65 */
  0x0000,   /* U+3D66 */
  0x0000,   /* U+3D67 */
  0x0000,   /* U+3D68 */
  0x0000,   /* U+3D69 */
  0x0000,   /* U+3D6A */
  0x0000,   /* U+3D6B */
  0x0000,   /* U+3D6C */
  0x0000,   /* U+3D6D */
  0x0000,   /* U+3D6E */
  0x0000,   /* U+3D6F */
  0x0000,   /* U+3D70 */
  0x0000,   /* U+3D71 */
  0x0000,   /* U+3D72 */
  0x0000,   /* U+3D73 */
  0x0000,   /* U+3D74 */
  0x0000,   /* U+3D75 */
  0x0000,   /* U+3D76 */
  0x0000,   /* U+3D77 */
  0x0000,   /* U+3D78 */
  0x0000,   /* U+3D79 */
  0x0000,   /* U+3D7A */
  0x0000,   /* U+3D7B */
  0x0000,   /* U+3D7C */
  0x0000,   /* U+3D7D */
  0x0000,   /* U+3D7E */
  0x0000,   /* U+3D7F */
  0x0000,   /* U+3D80 */
  0x0000,   /* U+3D81 */
  0x0000,   /* U+3D82 */
  0x0000,   /* U+3D83 */
  0x0000,   /* U+3D84 */
  0x0000,   /* U+3D85 */
  0x0000,   /* U+3D86 */
  0x0000,   /* U+3D87 */
  0x0000,   /* U+3D88 */
  0x0000,   /* U+3D89 */
  0x0000,   /* U+3D8A */
  0x0000,   /* U+3D8B */
  0x0000,   /* U+3D8C */
  0x0000,   /* U+3D8D */
  0x0000,   /* U+3D8E */
  0x0000,   /* U+3D8F */
  0x0000,   /* U+3D90 */
  0x0000,   /* U+3D91 */
  0x0000,   /* U+3D92 */
  0x0000,   /* U+3D93 */
  0x0000,   /* U+3D94 */
  0x0000,   /* U+3D95 */
  0x0000,   /* U+3D96 */
  0x0000,   /* U+3D97 */
  0x0000,   /* U+3D98 */
  0x0000,   /* U+3D99 */
  0x0000,   /* U+3D9A */
  0x0000,   /* U+3D9B */
  0x0000,   /* U+3D9C */
  0x0000,   /* U+3D9D */
  0x0000,   /* U+3D9E */
  0x0000,   /* U+3D9F */
  0x0000,   /* U+3DA0 */
  0x0000,   /* U+3DA1 */
  0x0000,   /* U+3DA2 */
  0x0000,   /* U+3DA3 */
  0x0000,   /* U+3DA4 */
  0x0000,   /* U+3DA5 */
  0x0000,   /* U+3DA6 */
  0x0000,   /* U+3DA7 */
  0x0000,   /* U+3DA8 */
  0x0000,   /* U+3DA9 */
  0x0000,   /* U+3DAA */
  0x0000,   /* U+3DAB */
  0x0000,   /* U+3DAC */
  0x0000,   /* U+3DAD */
  0x0000,   /* U+3DAE */
  0x0000,   /* U+3DAF */
  0x0000,   /* U+3DB0 */
  0x0000,   /* U+3DB1 */
  0x0000,   /* U+3DB2 */
  0x0000,   /* U+3DB3 */
  0x0000,   /* U+3DB4 */
  0x0000,   /* U+3DB5 */
  0x0000,   /* U+3DB6 */
  0x0000,   /* U+3DB7 */
  0x0000,   /* U+3DB8 */
  0x0000,   /* U+3DB9 */
  0x0000,   /* U+3DBA */
  0x0000,   /* U+3DBB */
  0x0000,   /* U+3DBC */
  0x0000,   /* U+3DBD */
  0x0000,   /* U+3DBE */
  0x0000,   /* U+3DBF */
  0x0000,   /* U+3DC0 */
  0x0000,   /* U+3DC1 */
  0x0000,   /* U+3DC2 */
  0x0000,   /* U+3DC3 */
  0x0000,   /* U+3DC4 */
  0x0000,   /* U+3DC5 */
  0x0000,   /* U+3DC6 */
  0x0000,   /* U+3DC7 */
  0x0000,   /* U+3DC8 */
  0x0000,   /* U+3DC9 */
  0x0000,   /* U+3DCA */
  0x0000,   /* U+3DCB */
  0x0000,   /* U+3DCC */
  0x0000,   /* U+3DCD */
  0x0000,   /* U+3DCE */
  0x0000,   /* U+3DCF */
  0x0000,   /* U+3DD0 */
  0x0000,   /* U+3DD1 */
  0x0000,   /* U+3DD2 */
  0x0000,   /* U+3DD3 */
  0x0000,   /* U+3DD4 */
  0x0000,   /* U+3DD5 */
  0x0000,   /* U+3DD6 */
  0x0000,   /* U+3DD7 */
  0x0000,   /* U+3DD8 */
  0x0000,   /* U+3DD9 */
  0x0000,   /* U+3DDA */
  0x0000,   /* U+3DDB */
  0x0000,   /* U+3DDC */
  0x0000,   /* U+3DDD */
  0x0000,   /* U+3DDE */
  0x0000,   /* U+3DDF */
  0x0000,   /* U+3DE0 */
  0x0000,   /* U+3DE1 */
  0x0000,   /* U+3DE2 */
  0x0000,   /* U+3DE3 */
  0x0000,   /* U+3DE4 */
  0x0000,   /* U+3DE5 */
  0x0000,   /* U+3DE6 */
  0x0000,   /* U+3DE7 */
  0x0000,   /* U+3DE8 */
  0x0000,   /* U+3DE9 */
  0x0000,   /* U+3DEA */
  0x0000,   /* U+3DEB */
  0x0000,   /* U+3DEC */
  0x0000,   /* U+3DED */
  0x0000,   /* U+3DEE */
  0x0000,   /* U+3DEF */
  0x0000,   /* U+3DF0 */
  0x0000,   /* U+3DF1 */
  0x0000,   /* U+3DF2 */
  0x0000,   /* U+3DF3 */
  0x0000,   /* U+3DF4 */
  0x0000,   /* U+3DF5 */
  0x0000,   /* U+3DF6 */
  0x0000,   /* U+3DF7 */
  0x0000,   /* U+3DF8 */
  0x0000,   /* U+3DF9 */
  0x0000,   /* U+3DFA */
  0x0000,   /* U+3DFB */
  0x0000,   /* U+3DFC */
  0x0000,   /* U+3DFD */
  0x0000,   /* U+3DFE */
  0x0000,   /* U+3DFF */
};

uint16 zh2_han_p03E[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x31D9,   /* U+3E00 */
  0x31D9,   /* U+3E01 */
  0x31D9,   /* U+3E02 */
  0x5C49,   /* U+3E03 */
  0x31DA,   /* U+3E04 */
  0x31DA,   /* U+3E05 */
  0x31DB,   /* U+3E06 */
  0x31DB,   /* U+3E07 */
  0x31DC,   /* U+3E08 */
  0x31DB,   /* U+3E09 */
  0x31DC,   /* U+3E0A */
  0x31DC,   /* U+3E0B */
  0x31DC,   /* U+3E0C */
  0x31DD,   /* U+3E0D */
  0x31DE,   /* U+3E0E */
  0x31DF,   /* U+3E0F */
  0x31DF,   /* U+3E10 */
  0x31E2,   /* U+3E11 */
  0x3210,   /* U+3E12 */
  0x3210,   /* U+3E13 */
  0x5C49,   /* U+3E14 */
  0x320D,   /* U+3E15 */
  0x3251,   /* U+3E16 */
  0x3252,   /* U+3E17 */
  0x3253,   /* U+3E18 */
  0x3255,   /* U+3E19 */
  0x3290,   /* U+3E1A */
  0x32D1,   /* U+3E1B */
  0x32D4,   /* U+3E1C */
  0x3310,   /* U+3E1D */
  0x3310,   /* U+3E1E */
  0x3312,   /* U+3E1F */
  0x3312,   /* U+3E20 */
  0x3312,   /* U+3E21 */
  0x330D,   /* U+3E22 */
  0x3319,   /* U+3E23 */
  0x331A,   /* U+3E24 */
  0x331D,   /* U+3E25 */
  0x334C,   /* U+3E26 */
  0x3352,   /* U+3E27 */
  0x338E,   /* U+3E28 */
  0x338F,   /* U+3E29 */
  0x338F,   /* U+3E2A */
  0x3390,   /* U+3E2B */
  0x3390,   /* U+3E2C */
  0x3390,   /* U+3E2D */
  0x3390,   /* U+3E2E */
  0x3390,   /* U+3E2F */
  0x3391,   /* U+3E30 */
  0x3391,   /* U+3E31 */
  0x3391,   /* U+3E32 */
  0x3391,   /* U+3E33 */
  0x5C49,   /* U+3E34 */
  0x3392,   /* U+3E35 */
  0x3392,   /* U+3E36 */
  0x3392,   /* U+3E37 */
  0x3392,   /* U+3E38 */
  0x3393,   /* U+3E39 */
  0x3393,   /* U+3E3A */
  0x3393,   /* U+3E3B */
  0x3393,   /* U+3E3C */
  0x3393,   /* U+3E3D */
  0x3393,   /* U+3E3E */
  0x5C49,   /* U+3E3F */
  0x3393,   /* U+3E40 */
  0x3394,   /* U+3E41 */
  0x3394,   /* U+3E42 */
  0x3394,   /* U+3E43 */
  0x338D,   /* U+3E44 */
  0x3395,   /* U+3E45 */
  0x3395,   /* U+3E46 */
  0x3395,   /* U+3E47 */
  0x3395,   /* U+3E48 */
  0x338D,   /* U+3E49 */
  0x338D,   /* U+3E4A */
  0x338D,   /* U+3E4B */
  0x3397,   /* U+3E4C */
  0x3397,   /* U+3E4D */
  0x3397,   /* U+3E4E */
  0x3397,   /* U+3E4F */
  0x3397,   /* U+3E50 */
  0x3398,   /* U+3E51 */
  0x3398,   /* U+3E52 */
  0x3398,   /* U+3E53 */
  0x3399,   /* U+3E54 */
  0x3399,   /* U+3E55 */
  0x3399,   /* U+3E56 */
  0x339A,   /* U+3E57 */
  0x339A,   /* U+3E58 */
  0x339B,   /* U+3E59 */
  0x339D,   /* U+3E5A */
  0x339E,   /* U+3E5B */
  0x33D0,   /* U+3E5C */
  0x33D0,   /* U+3E5D */
  0x33D0,   /* U+3E5E */
  0x33D0,   /* U+3E5F */
  0x33D0,   /* U+3E60 */
  0x33D1,   /* U+3E61 */
  0x33D1,   /* U+3E62 */
  0x33D1,   /* U+3E63 */
  0x33D1,   /* U+3E64 */
  0x33D1,   /* U+3E65 */
  0x33D1,   /* U+3E66 */
  0x33D1,   /* U+3E67 */
  0x33D1,   /* U+3E68 */
  0x33D1,   /* U+3E69 */
  0x33D1,   /* U+3E6A */
  0x33D2,   /* U+3E6B */
  0x33D2,   /* U+3E6C */
  0x33D2,   /* U+3E6D */
  0x33D2,   /* U+3E6E */
  0x33D2,   /* U+3E6F */
  0x5C49,   /* U+3E70 */
  0x33D3,   /* U+3E71 */
  0x33D3,   /* U+3E72 */
  0x33D3,   /* U+3E73 */
  0x33D3,   /* U+3E74 */
  0x33D3,   /* U+3E75 */
  0x33D3,   /* U+3E76 */
  0x33D3,   /* U+3E77 */
  0x33D3,   /* U+3E78 */
  0x33D4,   /* U+3E79 */
  0x33D4,   /* U+3E7A */
  0x33D4,   /* U+3E7B */
  0x33D4,   /* U+3E7C */
  0x33D4,   /* U+3E7D */
  0x33D4,   /* U+3E7E */
  0x33D4,   /* U+3E7F */
  0x33D4,   /* U+3E80 */
  0x33D5,   /* U+3E81 */
  0x33D5,   /* U+3E82 */
  0x33D5,   /* U+3E83 */
  0x33D5,   /* U+3E84 */
  0x33D5,   /* U+3E85 */
  0x33D5,   /* U+3E86 */
  0x33CD,   /* U+3E87 */
  0x33CD,   /* U+3E88 */
  0x33CD,   /* U+3E89 */
  0x33CD,   /* U+3E8A */
  0x33CD,   /* U+3E8B */
  0x33CD,   /* U+3E8C */
  0x33CD,   /* U+3E8D */
  0x33D7,   /* U+3E8E */
  0x33D7,   /* U+3E8F */
  0x33D7,   /* U+3E90 */
  0x33D7,   /* U+3E91 */
  0x33D7,   /* U+3E92 */
  0x5C49,   /* U+3E93 */
  0x33D8,   /* U+3E94 */
  0x33D8,   /* U+3E95 */
  0x33D8,   /* U+3E96 */
  0x33D8,   /* U+3E97 */
  0x33D8,   /* U+3E98 */
  0x33D8,   /* U+3E99 */
  0x33D9,   /* U+3E9A */
  0x33D9,   /* U+3E9B */
  0x33D9,   /* U+3E9C */
  0x33DA,   /* U+3E9D */
  0x33DA,   /* U+3E9E */
  0x33DA,   /* U+3E9F */
  0x33DB,   /* U+3EA0 */
  0x33DC,   /* U+3EA1 */
  0x33DC,   /* U+3EA2 */
  0x33DD,   /* U+3EA3 */
  0x33DD,   /* U+3EA4 */
  0x33DD,   /* U+3EA5 */
  0x33DD,   /* U+3EA6 */
  0x33E1,   /* U+3EA7 */
  0x344E,   /* U+3EA8 */
  0x344E,   /* U+3EA9 */
  0x344E,   /* U+3EAA */
  0x344E,   /* U+3EAB */
  0x344F,   /* U+3EAC */
  0x344F,   /* U+3EAD */
  0x344F,   /* U+3EAE */
  0x5C49,   /* U+3EAF */
  0x3450,   /* U+3EB0 */
  0x3450,   /* U+3EB1 */
  0x3450,   /* U+3EB2 */
  0x3450,   /* U+3EB3 */
  0x3450,   /* U+3EB4 */
  0x3450,   /* U+3EB5 */
  0x5C49,   /* U+3EB6 */
  0x3451,   /* U+3EB7 */
  0x5C49,   /* U+3EB8 */
  0x3451,   /* U+3EB9 */
  0x3451,   /* U+3EBA */
  0x3451,   /* U+3EBB */
  0x3451,   /* U+3EBC */
  0x5C49,   /* U+3EBD */
  0x5C49,   /* U+3EBE */
  0x3452,   /* U+3EBF */
  0x3452,   /* U+3EC0 */
  0x3452,   /* U+3EC1 */
  0x3452,   /* U+3EC2 */
  0x3452,   /* U+3EC3 */
  0x3452,   /* U+3EC4 */
  0x3452,   /* U+3EC5 */
  0x5C49,   /* U+3EC6 */
  0x5C49,   /* U+3EC7 */
  0x5C49,   /* U+3EC8 */
  0x3453,   /* U+3EC9 */
  0x3453,   /* U+3ECA */
  0x3453,   /* U+3ECB */
  0x3453,   /* U+3ECC */
  0x3453,   /* U+3ECD */
  0x3453,   /* U+3ECE */
  0x3453,   /* U+3ECF */
  0x5C49,   /* U+3ED0 */
  0x3454,   /* U+3ED1 */
  0x3454,   /* U+3ED2 */
  0x3454,   /* U+3ED3 */
  0x3454,   /* U+3ED4 */
  0x3454,   /* U+3ED5 */
  0x3454,   /* U+3ED6 */
  0x3454,   /* U+3ED7 */
  0x3454,   /* U+3ED8 */
  0x3454,   /* U+3ED9 */
  0x5C49,   /* U+3EDA */
  0x5C49,   /* U+3EDB */
  0x5C49,   /* U+3EDC */
  0x3455,   /* U+3EDD */
  0x3455,   /* U+3EDE */
  0x3455,   /* U+3EDF */
  0x3455,   /* U+3EE0 */
  0x3455,   /* U+3EE1 */
  0x3455,   /* U+3EE2 */
  0x5C49,   /* U+3EE3 */
  0x5C49,   /* U+3EE4 */
  0x5C49,   /* U+3EE5 */
  0x5C49,   /* U+3EE6 */
  0x344D,   /* U+3EE7 */
  0x5C49,   /* U+3EE8 */
  0x5C49,   /* U+3EE9 */
  0x344D,   /* U+3EEA */
  0x3457,   /* U+3EEB */
  0x3457,   /* U+3EEC */
  0x3457,   /* U+3EED */
  0x3457,   /* U+3EEE */
  0x3457,   /* U+3EEF */
  0x3457,   /* U+3EF0 */
  0x3457,   /* U+3EF1 */
  0x3457,   /* U+3EF2 */
  0x3457,   /* U+3EF3 */
  0x5C49,   /* U+3EF4 */
  0x3458,   /* U+3EF5 */
  0x3458,   /* U+3EF6 */
  0x3458,   /* U+3EF7 */
  0x3458,   /* U+3EF8 */
  0x3458,   /* U+3EF9 */
  0x3458,   /* U+3EFA */
  0x5C49,   /* U+3EFB */
  0x3458,   /* U+3EFC */
  0x3459,   /* U+3EFD */
  0x3459,   /* U+3EFE */
  0x3459,   /* U+3EFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3E00 */
  0x0020,   /* U+3E01 */
  0x0020,   /* U+3E02 */
  0x0020,   /* U+3E03 */
  0x0020,   /* U+3E04 */
  0x0020,   /* U+3E05 */
  0x0020,   /* U+3E06 */
  0x0020,   /* U+3E07 */
  0x0020,   /* U+3E08 */
  0x0020,   /* U+3E09 */
  0x0020,   /* U+3E0A */
  0x0020,   /* U+3E0B */
  0x0020,   /* U+3E0C */
  0x0020,   /* U+3E0D */
  0x0020,   /* U+3E0E */
  0x0020,   /* U+3E0F */
  0x0020,   /* U+3E10 */
  0x0020,   /* U+3E11 */
  0x0020,   /* U+3E12 */
  0x0020,   /* U+3E13 */
  0x0020,   /* U+3E14 */
  0x0020,   /* U+3E15 */
  0x0020,   /* U+3E16 */
  0x0020,   /* U+3E17 */
  0x0020,   /* U+3E18 */
  0x0020,   /* U+3E19 */
  0x0020,   /* U+3E1A */
  0x0020,   /* U+3E1B */
  0x0020,   /* U+3E1C */
  0x0020,   /* U+3E1D */
  0x0020,   /* U+3E1E */
  0x0020,   /* U+3E1F */
  0x0020,   /* U+3E20 */
  0x0020,   /* U+3E21 */
  0x0020,   /* U+3E22 */
  0x0020,   /* U+3E23 */
  0x0020,   /* U+3E24 */
  0x0020,   /* U+3E25 */
  0x0020,   /* U+3E26 */
  0x0020,   /* U+3E27 */
  0x0020,   /* U+3E28 */
  0x0020,   /* U+3E29 */
  0x0020,   /* U+3E2A */
  0x0020,   /* U+3E2B */
  0x0020,   /* U+3E2C */
  0x0020,   /* U+3E2D */
  0x0020,   /* U+3E2E */
  0x0020,   /* U+3E2F */
  0x0020,   /* U+3E30 */
  0x0020,   /* U+3E31 */
  0x0020,   /* U+3E32 */
  0x0020,   /* U+3E33 */
  0x0020,   /* U+3E34 */
  0x0020,   /* U+3E35 */
  0x0020,   /* U+3E36 */
  0x0020,   /* U+3E37 */
  0x0020,   /* U+3E38 */
  0x0020,   /* U+3E39 */
  0x0020,   /* U+3E3A */
  0x0020,   /* U+3E3B */
  0x0020,   /* U+3E3C */
  0x0020,   /* U+3E3D */
  0x0020,   /* U+3E3E */
  0x0020,   /* U+3E3F */
  0x0020,   /* U+3E40 */
  0x0020,   /* U+3E41 */
  0x0020,   /* U+3E42 */
  0x0020,   /* U+3E43 */
  0x0020,   /* U+3E44 */
  0x0020,   /* U+3E45 */
  0x0020,   /* U+3E46 */
  0x0020,   /* U+3E47 */
  0x0020,   /* U+3E48 */
  0x0020,   /* U+3E49 */
  0x0020,   /* U+3E4A */
  0x0020,   /* U+3E4B */
  0x0020,   /* U+3E4C */
  0x0020,   /* U+3E4D */
  0x0020,   /* U+3E4E */
  0x0020,   /* U+3E4F */
  0x0020,   /* U+3E50 */
  0x0020,   /* U+3E51 */
  0x0020,   /* U+3E52 */
  0x0020,   /* U+3E53 */
  0x0020,   /* U+3E54 */
  0x0020,   /* U+3E55 */
  0x0020,   /* U+3E56 */
  0x0020,   /* U+3E57 */
  0x0020,   /* U+3E58 */
  0x0020,   /* U+3E59 */
  0x0020,   /* U+3E5A */
  0x0020,   /* U+3E5B */
  0x0020,   /* U+3E5C */
  0x0020,   /* U+3E5D */
  0x0020,   /* U+3E5E */
  0x0020,   /* U+3E5F */
  0x0020,   /* U+3E60 */
  0x0020,   /* U+3E61 */
  0x0020,   /* U+3E62 */
  0x0020,   /* U+3E63 */
  0x0020,   /* U+3E64 */
  0x0020,   /* U+3E65 */
  0x0020,   /* U+3E66 */
  0x0020,   /* U+3E67 */
  0x0020,   /* U+3E68 */
  0x0020,   /* U+3E69 */
  0x0020,   /* U+3E6A */
  0x0020,   /* U+3E6B */
  0x0020,   /* U+3E6C */
  0x0020,   /* U+3E6D */
  0x0020,   /* U+3E6E */
  0x0020,   /* U+3E6F */
  0x0020,   /* U+3E70 */
  0x0020,   /* U+3E71 */
  0x0020,   /* U+3E72 */
  0x0020,   /* U+3E73 */
  0x0020,   /* U+3E74 */
  0x0020,   /* U+3E75 */
  0x0020,   /* U+3E76 */
  0x0020,   /* U+3E77 */
  0x0020,   /* U+3E78 */
  0x0020,   /* U+3E79 */
  0x0020,   /* U+3E7A */
  0x0020,   /* U+3E7B */
  0x0020,   /* U+3E7C */
  0x0020,   /* U+3E7D */
  0x0020,   /* U+3E7E */
  0x0020,   /* U+3E7F */
  0x0020,   /* U+3E80 */
  0x0020,   /* U+3E81 */
  0x0020,   /* U+3E82 */
  0x0020,   /* U+3E83 */
  0x0020,   /* U+3E84 */
  0x0020,   /* U+3E85 */
  0x0020,   /* U+3E86 */
  0x0020,   /* U+3E87 */
  0x0020,   /* U+3E88 */
  0x0020,   /* U+3E89 */
  0x0020,   /* U+3E8A */
  0x0020,   /* U+3E8B */
  0x0020,   /* U+3E8C */
  0x0020,   /* U+3E8D */
  0x0020,   /* U+3E8E */
  0x0020,   /* U+3E8F */
  0x0020,   /* U+3E90 */
  0x0020,   /* U+3E91 */
  0x0020,   /* U+3E92 */
  0x0020,   /* U+3E93 */
  0x0020,   /* U+3E94 */
  0x0020,   /* U+3E95 */
  0x0020,   /* U+3E96 */
  0x0020,   /* U+3E97 */
  0x0020,   /* U+3E98 */
  0x0020,   /* U+3E99 */
  0x0020,   /* U+3E9A */
  0x0020,   /* U+3E9B */
  0x0020,   /* U+3E9C */
  0x0020,   /* U+3E9D */
  0x0020,   /* U+3E9E */
  0x0020,   /* U+3E9F */
  0x0020,   /* U+3EA0 */
  0x0020,   /* U+3EA1 */
  0x0020,   /* U+3EA2 */
  0x0020,   /* U+3EA3 */
  0x0020,   /* U+3EA4 */
  0x0020,   /* U+3EA5 */
  0x0020,   /* U+3EA6 */
  0x0020,   /* U+3EA7 */
  0x0020,   /* U+3EA8 */
  0x0020,   /* U+3EA9 */
  0x0020,   /* U+3EAA */
  0x0020,   /* U+3EAB */
  0x0020,   /* U+3EAC */
  0x0020,   /* U+3EAD */
  0x0020,   /* U+3EAE */
  0x0020,   /* U+3EAF */
  0x0020,   /* U+3EB0 */
  0x0020,   /* U+3EB1 */
  0x0020,   /* U+3EB2 */
  0x0020,   /* U+3EB3 */
  0x0020,   /* U+3EB4 */
  0x0020,   /* U+3EB5 */
  0x0020,   /* U+3EB6 */
  0x0020,   /* U+3EB7 */
  0x0020,   /* U+3EB8 */
  0x0020,   /* U+3EB9 */
  0x0020,   /* U+3EBA */
  0x0020,   /* U+3EBB */
  0x0020,   /* U+3EBC */
  0x0020,   /* U+3EBD */
  0x0020,   /* U+3EBE */
  0x0020,   /* U+3EBF */
  0x0020,   /* U+3EC0 */
  0x0020,   /* U+3EC1 */
  0x0020,   /* U+3EC2 */
  0x0020,   /* U+3EC3 */
  0x0020,   /* U+3EC4 */
  0x0020,   /* U+3EC5 */
  0x0020,   /* U+3EC6 */
  0x0020,   /* U+3EC7 */
  0x0020,   /* U+3EC8 */
  0x0020,   /* U+3EC9 */
  0x0020,   /* U+3ECA */
  0x0020,   /* U+3ECB */
  0x0020,   /* U+3ECC */
  0x0020,   /* U+3ECD */
  0x0020,   /* U+3ECE */
  0x0020,   /* U+3ECF */
  0x0020,   /* U+3ED0 */
  0x0020,   /* U+3ED1 */
  0x0020,   /* U+3ED2 */
  0x0020,   /* U+3ED3 */
  0x0020,   /* U+3ED4 */
  0x0020,   /* U+3ED5 */
  0x0020,   /* U+3ED6 */
  0x0020,   /* U+3ED7 */
  0x0020,   /* U+3ED8 */
  0x0020,   /* U+3ED9 */
  0x0020,   /* U+3EDA */
  0x0020,   /* U+3EDB */
  0x0020,   /* U+3EDC */
  0x0020,   /* U+3EDD */
  0x0020,   /* U+3EDE */
  0x0020,   /* U+3EDF */
  0x0020,   /* U+3EE0 */
  0x0020,   /* U+3EE1 */
  0x0020,   /* U+3EE2 */
  0x0020,   /* U+3EE3 */
  0x0020,   /* U+3EE4 */
  0x0020,   /* U+3EE5 */
  0x0020,   /* U+3EE6 */
  0x0020,   /* U+3EE7 */
  0x0020,   /* U+3EE8 */
  0x0020,   /* U+3EE9 */
  0x0020,   /* U+3EEA */
  0x0020,   /* U+3EEB */
  0x0020,   /* U+3EEC */
  0x0020,   /* U+3EED */
  0x0020,   /* U+3EEE */
  0x0020,   /* U+3EEF */
  0x0020,   /* U+3EF0 */
  0x0020,   /* U+3EF1 */
  0x0020,   /* U+3EF2 */
  0x0020,   /* U+3EF3 */
  0x0020,   /* U+3EF4 */
  0x0020,   /* U+3EF5 */
  0x0020,   /* U+3EF6 */
  0x0020,   /* U+3EF7 */
  0x0020,   /* U+3EF8 */
  0x0020,   /* U+3EF9 */
  0x0020,   /* U+3EFA */
  0x0020,   /* U+3EFB */
  0x0020,   /* U+3EFC */
  0x0020,   /* U+3EFD */
  0x0020,   /* U+3EFE */
  0x0020,   /* U+3EFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3E00 */
  0x0002,   /* U+3E01 */
  0x0002,   /* U+3E02 */
  0x0002,   /* U+3E03 */
  0x0002,   /* U+3E04 */
  0x0002,   /* U+3E05 */
  0x0002,   /* U+3E06 */
  0x0002,   /* U+3E07 */
  0x0002,   /* U+3E08 */
  0x0002,   /* U+3E09 */
  0x0002,   /* U+3E0A */
  0x0002,   /* U+3E0B */
  0x0002,   /* U+3E0C */
  0x0002,   /* U+3E0D */
  0x0002,   /* U+3E0E */
  0x0002,   /* U+3E0F */
  0x0002,   /* U+3E10 */
  0x0002,   /* U+3E11 */
  0x0002,   /* U+3E12 */
  0x0002,   /* U+3E13 */
  0x0002,   /* U+3E14 */
  0x0002,   /* U+3E15 */
  0x0002,   /* U+3E16 */
  0x0002,   /* U+3E17 */
  0x0002,   /* U+3E18 */
  0x0002,   /* U+3E19 */
  0x0002,   /* U+3E1A */
  0x0002,   /* U+3E1B */
  0x0002,   /* U+3E1C */
  0x0002,   /* U+3E1D */
  0x0002,   /* U+3E1E */
  0x0002,   /* U+3E1F */
  0x0002,   /* U+3E20 */
  0x0002,   /* U+3E21 */
  0x0002,   /* U+3E22 */
  0x0002,   /* U+3E23 */
  0x0002,   /* U+3E24 */
  0x0002,   /* U+3E25 */
  0x0002,   /* U+3E26 */
  0x0002,   /* U+3E27 */
  0x0002,   /* U+3E28 */
  0x0002,   /* U+3E29 */
  0x0002,   /* U+3E2A */
  0x0002,   /* U+3E2B */
  0x0002,   /* U+3E2C */
  0x0002,   /* U+3E2D */
  0x0002,   /* U+3E2E */
  0x0002,   /* U+3E2F */
  0x0002,   /* U+3E30 */
  0x0002,   /* U+3E31 */
  0x0002,   /* U+3E32 */
  0x0002,   /* U+3E33 */
  0x0002,   /* U+3E34 */
  0x0002,   /* U+3E35 */
  0x0002,   /* U+3E36 */
  0x0002,   /* U+3E37 */
  0x0002,   /* U+3E38 */
  0x0002,   /* U+3E39 */
  0x0002,   /* U+3E3A */
  0x0002,   /* U+3E3B */
  0x0002,   /* U+3E3C */
  0x0002,   /* U+3E3D */
  0x0002,   /* U+3E3E */
  0x0002,   /* U+3E3F */
  0x0002,   /* U+3E40 */
  0x0002,   /* U+3E41 */
  0x0002,   /* U+3E42 */
  0x0002,   /* U+3E43 */
  0x0002,   /* U+3E44 */
  0x0002,   /* U+3E45 */
  0x0002,   /* U+3E46 */
  0x0002,   /* U+3E47 */
  0x0002,   /* U+3E48 */
  0x0002,   /* U+3E49 */
  0x0002,   /* U+3E4A */
  0x0002,   /* U+3E4B */
  0x0002,   /* U+3E4C */
  0x0002,   /* U+3E4D */
  0x0002,   /* U+3E4E */
  0x0002,   /* U+3E4F */
  0x0002,   /* U+3E50 */
  0x0002,   /* U+3E51 */
  0x0002,   /* U+3E52 */
  0x0002,   /* U+3E53 */
  0x0002,   /* U+3E54 */
  0x0002,   /* U+3E55 */
  0x0002,   /* U+3E56 */
  0x0002,   /* U+3E57 */
  0x0002,   /* U+3E58 */
  0x0002,   /* U+3E59 */
  0x0002,   /* U+3E5A */
  0x0002,   /* U+3E5B */
  0x0002,   /* U+3E5C */
  0x0002,   /* U+3E5D */
  0x0002,   /* U+3E5E */
  0x0002,   /* U+3E5F */
  0x0002,   /* U+3E60 */
  0x0002,   /* U+3E61 */
  0x0002,   /* U+3E62 */
  0x0002,   /* U+3E63 */
  0x0002,   /* U+3E64 */
  0x0002,   /* U+3E65 */
  0x0002,   /* U+3E66 */
  0x0002,   /* U+3E67 */
  0x0002,   /* U+3E68 */
  0x0002,   /* U+3E69 */
  0x0002,   /* U+3E6A */
  0x0002,   /* U+3E6B */
  0x0002,   /* U+3E6C */
  0x0002,   /* U+3E6D */
  0x0002,   /* U+3E6E */
  0x0002,   /* U+3E6F */
  0x0002,   /* U+3E70 */
  0x0002,   /* U+3E71 */
  0x0002,   /* U+3E72 */
  0x0002,   /* U+3E73 */
  0x0002,   /* U+3E74 */
  0x0002,   /* U+3E75 */
  0x0002,   /* U+3E76 */
  0x0002,   /* U+3E77 */
  0x0002,   /* U+3E78 */
  0x0002,   /* U+3E79 */
  0x0002,   /* U+3E7A */
  0x0002,   /* U+3E7B */
  0x0002,   /* U+3E7C */
  0x0002,   /* U+3E7D */
  0x0002,   /* U+3E7E */
  0x0002,   /* U+3E7F */
  0x0002,   /* U+3E80 */
  0x0002,   /* U+3E81 */
  0x0002,   /* U+3E82 */
  0x0002,   /* U+3E83 */
  0x0002,   /* U+3E84 */
  0x0002,   /* U+3E85 */
  0x0002,   /* U+3E86 */
  0x0002,   /* U+3E87 */
  0x0002,   /* U+3E88 */
  0x0002,   /* U+3E89 */
  0x0002,   /* U+3E8A */
  0x0002,   /* U+3E8B */
  0x0002,   /* U+3E8C */
  0x0002,   /* U+3E8D */
  0x0002,   /* U+3E8E */
  0x0002,   /* U+3E8F */
  0x0002,   /* U+3E90 */
  0x0002,   /* U+3E91 */
  0x0002,   /* U+3E92 */
  0x0002,   /* U+3E93 */
  0x0002,   /* U+3E94 */
  0x0002,   /* U+3E95 */
  0x0002,   /* U+3E96 */
  0x0002,   /* U+3E97 */
  0x0002,   /* U+3E98 */
  0x0002,   /* U+3E99 */
  0x0002,   /* U+3E9A */
  0x0002,   /* U+3E9B */
  0x0002,   /* U+3E9C */
  0x0002,   /* U+3E9D */
  0x0002,   /* U+3E9E */
  0x0002,   /* U+3E9F */
  0x0002,   /* U+3EA0 */
  0x0002,   /* U+3EA1 */
  0x0002,   /* U+3EA2 */
  0x0002,   /* U+3EA3 */
  0x0002,   /* U+3EA4 */
  0x0002,   /* U+3EA5 */
  0x0002,   /* U+3EA6 */
  0x0002,   /* U+3EA7 */
  0x0002,   /* U+3EA8 */
  0x0002,   /* U+3EA9 */
  0x0002,   /* U+3EAA */
  0x0002,   /* U+3EAB */
  0x0002,   /* U+3EAC */
  0x0002,   /* U+3EAD */
  0x0002,   /* U+3EAE */
  0x0002,   /* U+3EAF */
  0x0002,   /* U+3EB0 */
  0x0002,   /* U+3EB1 */
  0x0002,   /* U+3EB2 */
  0x0002,   /* U+3EB3 */
  0x0002,   /* U+3EB4 */
  0x0002,   /* U+3EB5 */
  0x0002,   /* U+3EB6 */
  0x0002,   /* U+3EB7 */
  0x0002,   /* U+3EB8 */
  0x0002,   /* U+3EB9 */
  0x0002,   /* U+3EBA */
  0x0002,   /* U+3EBB */
  0x0002,   /* U+3EBC */
  0x0002,   /* U+3EBD */
  0x0002,   /* U+3EBE */
  0x0002,   /* U+3EBF */
  0x0002,   /* U+3EC0 */
  0x0002,   /* U+3EC1 */
  0x0002,   /* U+3EC2 */
  0x0002,   /* U+3EC3 */
  0x0002,   /* U+3EC4 */
  0x0002,   /* U+3EC5 */
  0x0002,   /* U+3EC6 */
  0x0002,   /* U+3EC7 */
  0x0002,   /* U+3EC8 */
  0x0002,   /* U+3EC9 */
  0x0002,   /* U+3ECA */
  0x0002,   /* U+3ECB */
  0x0002,   /* U+3ECC */
  0x0002,   /* U+3ECD */
  0x0002,   /* U+3ECE */
  0x0002,   /* U+3ECF */
  0x0002,   /* U+3ED0 */
  0x0002,   /* U+3ED1 */
  0x0002,   /* U+3ED2 */
  0x0002,   /* U+3ED3 */
  0x0002,   /* U+3ED4 */
  0x0002,   /* U+3ED5 */
  0x0002,   /* U+3ED6 */
  0x0002,   /* U+3ED7 */
  0x0002,   /* U+3ED8 */
  0x0002,   /* U+3ED9 */
  0x0002,   /* U+3EDA */
  0x0002,   /* U+3EDB */
  0x0002,   /* U+3EDC */
  0x0002,   /* U+3EDD */
  0x0002,   /* U+3EDE */
  0x0002,   /* U+3EDF */
  0x0002,   /* U+3EE0 */
  0x0002,   /* U+3EE1 */
  0x0002,   /* U+3EE2 */
  0x0002,   /* U+3EE3 */
  0x0002,   /* U+3EE4 */
  0x0002,   /* U+3EE5 */
  0x0002,   /* U+3EE6 */
  0x0002,   /* U+3EE7 */
  0x0002,   /* U+3EE8 */
  0x0002,   /* U+3EE9 */
  0x0002,   /* U+3EEA */
  0x0002,   /* U+3EEB */
  0x0002,   /* U+3EEC */
  0x0002,   /* U+3EED */
  0x0002,   /* U+3EEE */
  0x0002,   /* U+3EEF */
  0x0002,   /* U+3EF0 */
  0x0002,   /* U+3EF1 */
  0x0002,   /* U+3EF2 */
  0x0002,   /* U+3EF3 */
  0x0002,   /* U+3EF4 */
  0x0002,   /* U+3EF5 */
  0x0002,   /* U+3EF6 */
  0x0002,   /* U+3EF7 */
  0x0002,   /* U+3EF8 */
  0x0002,   /* U+3EF9 */
  0x0002,   /* U+3EFA */
  0x0002,   /* U+3EFB */
  0x0002,   /* U+3EFC */
  0x0002,   /* U+3EFD */
  0x0002,   /* U+3EFE */
  0x0002,   /* U+3EFF */

  /* Primary weight 2 for each character. */
  0x8002,   /* U+3E00 */
  0x8003,   /* U+3E01 */
  0x8004,   /* U+3E02 */
  0xBE03,   /* U+3E03 */
  0x8000,   /* U+3E04 */
  0x8001,   /* U+3E05 */
  0x8000,   /* U+3E06 */
  0x8001,   /* U+3E07 */
  0x8000,   /* U+3E08 */
  0x8002,   /* U+3E09 */
  0x8001,   /* U+3E0A */
  0x8002,   /* U+3E0B */
  0x8003,   /* U+3E0C */
  0x8000,   /* U+3E0D */
  0x8000,   /* U+3E0E */
  0x8000,   /* U+3E0F */
  0x8001,   /* U+3E10 */
  0x8000,   /* U+3E11 */
  0x8000,   /* U+3E12 */
  0x8001,   /* U+3E13 */
  0xBE14,   /* U+3E14 */
  0x8000,   /* U+3E15 */
  0x8000,   /* U+3E16 */
  0x8000,   /* U+3E17 */
  0x8000,   /* U+3E18 */
  0x8000,   /* U+3E19 */
  0x8000,   /* U+3E1A */
  0x8000,   /* U+3E1B */
  0x8000,   /* U+3E1C */
  0x8000,   /* U+3E1D */
  0x8001,   /* U+3E1E */
  0x8000,   /* U+3E1F */
  0x8001,   /* U+3E20 */
  0x8002,   /* U+3E21 */
  0x8000,   /* U+3E22 */
  0x8000,   /* U+3E23 */
  0x8000,   /* U+3E24 */
  0x8000,   /* U+3E25 */
  0x8000,   /* U+3E26 */
  0x8000,   /* U+3E27 */
  0x8000,   /* U+3E28 */
  0x8000,   /* U+3E29 */
  0x8001,   /* U+3E2A */
  0x8000,   /* U+3E2B */
  0x8001,   /* U+3E2C */
  0x8002,   /* U+3E2D */
  0x8003,   /* U+3E2E */
  0x8004,   /* U+3E2F */
  0x8000,   /* U+3E30 */
  0x8001,   /* U+3E31 */
  0x8002,   /* U+3E32 */
  0x8003,   /* U+3E33 */
  0xBE34,   /* U+3E34 */
  0x8000,   /* U+3E35 */
  0x8001,   /* U+3E36 */
  0x8002,   /* U+3E37 */
  0x8003,   /* U+3E38 */
  0x8000,   /* U+3E39 */
  0x8001,   /* U+3E3A */
  0x8002,   /* U+3E3B */
  0x8003,   /* U+3E3C */
  0x8004,   /* U+3E3D */
  0x8005,   /* U+3E3E */
  0xBE3F,   /* U+3E3F */
  0x8006,   /* U+3E40 */
  0x8000,   /* U+3E41 */
  0x8001,   /* U+3E42 */
  0x8002,   /* U+3E43 */
  0x8000,   /* U+3E44 */
  0x8000,   /* U+3E45 */
  0x8001,   /* U+3E46 */
  0x8002,   /* U+3E47 */
  0x8003,   /* U+3E48 */
  0x8001,   /* U+3E49 */
  0x8002,   /* U+3E4A */
  0x8003,   /* U+3E4B */
  0x8000,   /* U+3E4C */
  0x8001,   /* U+3E4D */
  0x8002,   /* U+3E4E */
  0x8003,   /* U+3E4F */
  0x8004,   /* U+3E50 */
  0x8000,   /* U+3E51 */
  0x8001,   /* U+3E52 */
  0x8002,   /* U+3E53 */
  0x8000,   /* U+3E54 */
  0x8001,   /* U+3E55 */
  0x8002,   /* U+3E56 */
  0x8000,   /* U+3E57 */
  0x8001,   /* U+3E58 */
  0x8000,   /* U+3E59 */
  0x8000,   /* U+3E5A */
  0x8000,   /* U+3E5B */
  0x8000,   /* U+3E5C */
  0x8001,   /* U+3E5D */
  0x8002,   /* U+3E5E */
  0x8003,   /* U+3E5F */
  0x8004,   /* U+3E60 */
  0x8000,   /* U+3E61 */
  0x8001,   /* U+3E62 */
  0x8002,   /* U+3E63 */
  0x8003,   /* U+3E64 */
  0x8004,   /* U+3E65 */
  0x8005,   /* U+3E66 */
  0x8006,   /* U+3E67 */
  0x8007,   /* U+3E68 */
  0x8008,   /* U+3E69 */
  0x8009,   /* U+3E6A */
  0x8000,   /* U+3E6B */
  0x8001,   /* U+3E6C */
  0x8002,   /* U+3E6D */
  0x8003,   /* U+3E6E */
  0x8004,   /* U+3E6F */
  0xBE70,   /* U+3E70 */
  0x8000,   /* U+3E71 */
  0x8001,   /* U+3E72 */
  0x8002,   /* U+3E73 */
  0x8003,   /* U+3E74 */
  0x8004,   /* U+3E75 */
  0x8005,   /* U+3E76 */
  0x8006,   /* U+3E77 */
  0x8007,   /* U+3E78 */
  0x8000,   /* U+3E79 */
  0x8001,   /* U+3E7A */
  0x8002,   /* U+3E7B */
  0x8003,   /* U+3E7C */
  0x8004,   /* U+3E7D */
  0x8005,   /* U+3E7E */
  0x8006,   /* U+3E7F */
  0x8007,   /* U+3E80 */
  0x8000,   /* U+3E81 */
  0x8001,   /* U+3E82 */
  0x8002,   /* U+3E83 */
  0x8003,   /* U+3E84 */
  0x8004,   /* U+3E85 */
  0x8005,   /* U+3E86 */
  0x8000,   /* U+3E87 */
  0x8001,   /* U+3E88 */
  0x8002,   /* U+3E89 */
  0x8003,   /* U+3E8A */
  0x8004,   /* U+3E8B */
  0x8005,   /* U+3E8C */
  0x8006,   /* U+3E8D */
  0x8000,   /* U+3E8E */
  0x8001,   /* U+3E8F */
  0x8002,   /* U+3E90 */
  0x8003,   /* U+3E91 */
  0x8004,   /* U+3E92 */
  0xBE93,   /* U+3E93 */
  0x8000,   /* U+3E94 */
  0x8001,   /* U+3E95 */
  0x8002,   /* U+3E96 */
  0x8003,   /* U+3E97 */
  0x8004,   /* U+3E98 */
  0x8005,   /* U+3E99 */
  0x8000,   /* U+3E9A */
  0x8001,   /* U+3E9B */
  0x8002,   /* U+3E9C */
  0x8000,   /* U+3E9D */
  0x8001,   /* U+3E9E */
  0x8002,   /* U+3E9F */
  0x8000,   /* U+3EA0 */
  0x8000,   /* U+3EA1 */
  0x8001,   /* U+3EA2 */
  0x8000,   /* U+3EA3 */
  0x8001,   /* U+3EA4 */
  0x8002,   /* U+3EA5 */
  0x8003,   /* U+3EA6 */
  0x8000,   /* U+3EA7 */
  0x8000,   /* U+3EA8 */
  0x8001,   /* U+3EA9 */
  0x8002,   /* U+3EAA */
  0x8003,   /* U+3EAB */
  0x8000,   /* U+3EAC */
  0x8001,   /* U+3EAD */
  0x8002,   /* U+3EAE */
  0xBEAF,   /* U+3EAF */
  0x8000,   /* U+3EB0 */
  0x8001,   /* U+3EB1 */
  0x8002,   /* U+3EB2 */
  0x8003,   /* U+3EB3 */
  0x8004,   /* U+3EB4 */
  0x8005,   /* U+3EB5 */
  0xBEB6,   /* U+3EB6 */
  0x8000,   /* U+3EB7 */
  0xBEB8,   /* U+3EB8 */
  0x8001,   /* U+3EB9 */
  0x8002,   /* U+3EBA */
  0x8003,   /* U+3EBB */
  0x8004,   /* U+3EBC */
  0xBEBD,   /* U+3EBD */
  0xBEBE,   /* U+3EBE */
  0x8000,   /* U+3EBF */
  0x8001,   /* U+3EC0 */
  0x8002,   /* U+3EC1 */
  0x8003,   /* U+3EC2 */
  0x8004,   /* U+3EC3 */
  0x8005,   /* U+3EC4 */
  0x8006,   /* U+3EC5 */
  0xBEC6,   /* U+3EC6 */
  0xBEC7,   /* U+3EC7 */
  0xBEC8,   /* U+3EC8 */
  0x8000,   /* U+3EC9 */
  0x8001,   /* U+3ECA */
  0x8002,   /* U+3ECB */
  0x8003,   /* U+3ECC */
  0x8004,   /* U+3ECD */
  0x8005,   /* U+3ECE */
  0x8006,   /* U+3ECF */
  0xBED0,   /* U+3ED0 */
  0x8000,   /* U+3ED1 */
  0x8001,   /* U+3ED2 */
  0x8002,   /* U+3ED3 */
  0x8003,   /* U+3ED4 */
  0x8004,   /* U+3ED5 */
  0x8005,   /* U+3ED6 */
  0x8006,   /* U+3ED7 */
  0x8007,   /* U+3ED8 */
  0x8008,   /* U+3ED9 */
  0xBEDA,   /* U+3EDA */
  0xBEDB,   /* U+3EDB */
  0xBEDC,   /* U+3EDC */
  0x8000,   /* U+3EDD */
  0x8001,   /* U+3EDE */
  0x8002,   /* U+3EDF */
  0x8003,   /* U+3EE0 */
  0x8004,   /* U+3EE1 */
  0x8005,   /* U+3EE2 */
  0xBEE3,   /* U+3EE3 */
  0xBEE4,   /* U+3EE4 */
  0xBEE5,   /* U+3EE5 */
  0xBEE6,   /* U+3EE6 */
  0x8000,   /* U+3EE7 */
  0xBEE8,   /* U+3EE8 */
  0xBEE9,   /* U+3EE9 */
  0x8001,   /* U+3EEA */
  0x8000,   /* U+3EEB */
  0x8001,   /* U+3EEC */
  0x8002,   /* U+3EED */
  0x8003,   /* U+3EEE */
  0x8004,   /* U+3EEF */
  0x8005,   /* U+3EF0 */
  0x8006,   /* U+3EF1 */
  0x8007,   /* U+3EF2 */
  0x8008,   /* U+3EF3 */
  0xBEF4,   /* U+3EF4 */
  0x8000,   /* U+3EF5 */
  0x8001,   /* U+3EF6 */
  0x8002,   /* U+3EF7 */
  0x8003,   /* U+3EF8 */
  0x8004,   /* U+3EF9 */
  0x8005,   /* U+3EFA */
  0xBEFB,   /* U+3EFB */
  0x8006,   /* U+3EFC */
  0x8000,   /* U+3EFD */
  0x8001,   /* U+3EFE */
  0x8002,   /* U+3EFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3E00 */
  0x0000,   /* U+3E01 */
  0x0000,   /* U+3E02 */
  0x0000,   /* U+3E03 */
  0x0000,   /* U+3E04 */
  0x0000,   /* U+3E05 */
  0x0000,   /* U+3E06 */
  0x0000,   /* U+3E07 */
  0x0000,   /* U+3E08 */
  0x0000,   /* U+3E09 */
  0x0000,   /* U+3E0A */
  0x0000,   /* U+3E0B */
  0x0000,   /* U+3E0C */
  0x0000,   /* U+3E0D */
  0x0000,   /* U+3E0E */
  0x0000,   /* U+3E0F */
  0x0000,   /* U+3E10 */
  0x0000,   /* U+3E11 */
  0x0000,   /* U+3E12 */
  0x0000,   /* U+3E13 */
  0x0000,   /* U+3E14 */
  0x0000,   /* U+3E15 */
  0x0000,   /* U+3E16 */
  0x0000,   /* U+3E17 */
  0x0000,   /* U+3E18 */
  0x0000,   /* U+3E19 */
  0x0000,   /* U+3E1A */
  0x0000,   /* U+3E1B */
  0x0000,   /* U+3E1C */
  0x0000,   /* U+3E1D */
  0x0000,   /* U+3E1E */
  0x0000,   /* U+3E1F */
  0x0000,   /* U+3E20 */
  0x0000,   /* U+3E21 */
  0x0000,   /* U+3E22 */
  0x0000,   /* U+3E23 */
  0x0000,   /* U+3E24 */
  0x0000,   /* U+3E25 */
  0x0000,   /* U+3E26 */
  0x0000,   /* U+3E27 */
  0x0000,   /* U+3E28 */
  0x0000,   /* U+3E29 */
  0x0000,   /* U+3E2A */
  0x0000,   /* U+3E2B */
  0x0000,   /* U+3E2C */
  0x0000,   /* U+3E2D */
  0x0000,   /* U+3E2E */
  0x0000,   /* U+3E2F */
  0x0000,   /* U+3E30 */
  0x0000,   /* U+3E31 */
  0x0000,   /* U+3E32 */
  0x0000,   /* U+3E33 */
  0x0000,   /* U+3E34 */
  0x0000,   /* U+3E35 */
  0x0000,   /* U+3E36 */
  0x0000,   /* U+3E37 */
  0x0000,   /* U+3E38 */
  0x0000,   /* U+3E39 */
  0x0000,   /* U+3E3A */
  0x0000,   /* U+3E3B */
  0x0000,   /* U+3E3C */
  0x0000,   /* U+3E3D */
  0x0000,   /* U+3E3E */
  0x0000,   /* U+3E3F */
  0x0000,   /* U+3E40 */
  0x0000,   /* U+3E41 */
  0x0000,   /* U+3E42 */
  0x0000,   /* U+3E43 */
  0x0000,   /* U+3E44 */
  0x0000,   /* U+3E45 */
  0x0000,   /* U+3E46 */
  0x0000,   /* U+3E47 */
  0x0000,   /* U+3E48 */
  0x0000,   /* U+3E49 */
  0x0000,   /* U+3E4A */
  0x0000,   /* U+3E4B */
  0x0000,   /* U+3E4C */
  0x0000,   /* U+3E4D */
  0x0000,   /* U+3E4E */
  0x0000,   /* U+3E4F */
  0x0000,   /* U+3E50 */
  0x0000,   /* U+3E51 */
  0x0000,   /* U+3E52 */
  0x0000,   /* U+3E53 */
  0x0000,   /* U+3E54 */
  0x0000,   /* U+3E55 */
  0x0000,   /* U+3E56 */
  0x0000,   /* U+3E57 */
  0x0000,   /* U+3E58 */
  0x0000,   /* U+3E59 */
  0x0000,   /* U+3E5A */
  0x0000,   /* U+3E5B */
  0x0000,   /* U+3E5C */
  0x0000,   /* U+3E5D */
  0x0000,   /* U+3E5E */
  0x0000,   /* U+3E5F */
  0x0000,   /* U+3E60 */
  0x0000,   /* U+3E61 */
  0x0000,   /* U+3E62 */
  0x0000,   /* U+3E63 */
  0x0000,   /* U+3E64 */
  0x0000,   /* U+3E65 */
  0x0000,   /* U+3E66 */
  0x0000,   /* U+3E67 */
  0x0000,   /* U+3E68 */
  0x0000,   /* U+3E69 */
  0x0000,   /* U+3E6A */
  0x0000,   /* U+3E6B */
  0x0000,   /* U+3E6C */
  0x0000,   /* U+3E6D */
  0x0000,   /* U+3E6E */
  0x0000,   /* U+3E6F */
  0x0000,   /* U+3E70 */
  0x0000,   /* U+3E71 */
  0x0000,   /* U+3E72 */
  0x0000,   /* U+3E73 */
  0x0000,   /* U+3E74 */
  0x0000,   /* U+3E75 */
  0x0000,   /* U+3E76 */
  0x0000,   /* U+3E77 */
  0x0000,   /* U+3E78 */
  0x0000,   /* U+3E79 */
  0x0000,   /* U+3E7A */
  0x0000,   /* U+3E7B */
  0x0000,   /* U+3E7C */
  0x0000,   /* U+3E7D */
  0x0000,   /* U+3E7E */
  0x0000,   /* U+3E7F */
  0x0000,   /* U+3E80 */
  0x0000,   /* U+3E81 */
  0x0000,   /* U+3E82 */
  0x0000,   /* U+3E83 */
  0x0000,   /* U+3E84 */
  0x0000,   /* U+3E85 */
  0x0000,   /* U+3E86 */
  0x0000,   /* U+3E87 */
  0x0000,   /* U+3E88 */
  0x0000,   /* U+3E89 */
  0x0000,   /* U+3E8A */
  0x0000,   /* U+3E8B */
  0x0000,   /* U+3E8C */
  0x0000,   /* U+3E8D */
  0x0000,   /* U+3E8E */
  0x0000,   /* U+3E8F */
  0x0000,   /* U+3E90 */
  0x0000,   /* U+3E91 */
  0x0000,   /* U+3E92 */
  0x0000,   /* U+3E93 */
  0x0000,   /* U+3E94 */
  0x0000,   /* U+3E95 */
  0x0000,   /* U+3E96 */
  0x0000,   /* U+3E97 */
  0x0000,   /* U+3E98 */
  0x0000,   /* U+3E99 */
  0x0000,   /* U+3E9A */
  0x0000,   /* U+3E9B */
  0x0000,   /* U+3E9C */
  0x0000,   /* U+3E9D */
  0x0000,   /* U+3E9E */
  0x0000,   /* U+3E9F */
  0x0000,   /* U+3EA0 */
  0x0000,   /* U+3EA1 */
  0x0000,   /* U+3EA2 */
  0x0000,   /* U+3EA3 */
  0x0000,   /* U+3EA4 */
  0x0000,   /* U+3EA5 */
  0x0000,   /* U+3EA6 */
  0x0000,   /* U+3EA7 */
  0x0000,   /* U+3EA8 */
  0x0000,   /* U+3EA9 */
  0x0000,   /* U+3EAA */
  0x0000,   /* U+3EAB */
  0x0000,   /* U+3EAC */
  0x0000,   /* U+3EAD */
  0x0000,   /* U+3EAE */
  0x0000,   /* U+3EAF */
  0x0000,   /* U+3EB0 */
  0x0000,   /* U+3EB1 */
  0x0000,   /* U+3EB2 */
  0x0000,   /* U+3EB3 */
  0x0000,   /* U+3EB4 */
  0x0000,   /* U+3EB5 */
  0x0000,   /* U+3EB6 */
  0x0000,   /* U+3EB7 */
  0x0000,   /* U+3EB8 */
  0x0000,   /* U+3EB9 */
  0x0000,   /* U+3EBA */
  0x0000,   /* U+3EBB */
  0x0000,   /* U+3EBC */
  0x0000,   /* U+3EBD */
  0x0000,   /* U+3EBE */
  0x0000,   /* U+3EBF */
  0x0000,   /* U+3EC0 */
  0x0000,   /* U+3EC1 */
  0x0000,   /* U+3EC2 */
  0x0000,   /* U+3EC3 */
  0x0000,   /* U+3EC4 */
  0x0000,   /* U+3EC5 */
  0x0000,   /* U+3EC6 */
  0x0000,   /* U+3EC7 */
  0x0000,   /* U+3EC8 */
  0x0000,   /* U+3EC9 */
  0x0000,   /* U+3ECA */
  0x0000,   /* U+3ECB */
  0x0000,   /* U+3ECC */
  0x0000,   /* U+3ECD */
  0x0000,   /* U+3ECE */
  0x0000,   /* U+3ECF */
  0x0000,   /* U+3ED0 */
  0x0000,   /* U+3ED1 */
  0x0000,   /* U+3ED2 */
  0x0000,   /* U+3ED3 */
  0x0000,   /* U+3ED4 */
  0x0000,   /* U+3ED5 */
  0x0000,   /* U+3ED6 */
  0x0000,   /* U+3ED7 */
  0x0000,   /* U+3ED8 */
  0x0000,   /* U+3ED9 */
  0x0000,   /* U+3EDA */
  0x0000,   /* U+3EDB */
  0x0000,   /* U+3EDC */
  0x0000,   /* U+3EDD */
  0x0000,   /* U+3EDE */
  0x0000,   /* U+3EDF */
  0x0000,   /* U+3EE0 */
  0x0000,   /* U+3EE1 */
  0x0000,   /* U+3EE2 */
  0x0000,   /* U+3EE3 */
  0x0000,   /* U+3EE4 */
  0x0000,   /* U+3EE5 */
  0x0000,   /* U+3EE6 */
  0x0000,   /* U+3EE7 */
  0x0000,   /* U+3EE8 */
  0x0000,   /* U+3EE9 */
  0x0000,   /* U+3EEA */
  0x0000,   /* U+3EEB */
  0x0000,   /* U+3EEC */
  0x0000,   /* U+3EED */
  0x0000,   /* U+3EEE */
  0x0000,   /* U+3EEF */
  0x0000,   /* U+3EF0 */
  0x0000,   /* U+3EF1 */
  0x0000,   /* U+3EF2 */
  0x0000,   /* U+3EF3 */
  0x0000,   /* U+3EF4 */
  0x0000,   /* U+3EF5 */
  0x0000,   /* U+3EF6 */
  0x0000,   /* U+3EF7 */
  0x0000,   /* U+3EF8 */
  0x0000,   /* U+3EF9 */
  0x0000,   /* U+3EFA */
  0x0000,   /* U+3EFB */
  0x0000,   /* U+3EFC */
  0x0000,   /* U+3EFD */
  0x0000,   /* U+3EFE */
  0x0000,   /* U+3EFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3E00 */
  0x0000,   /* U+3E01 */
  0x0000,   /* U+3E02 */
  0x0000,   /* U+3E03 */
  0x0000,   /* U+3E04 */
  0x0000,   /* U+3E05 */
  0x0000,   /* U+3E06 */
  0x0000,   /* U+3E07 */
  0x0000,   /* U+3E08 */
  0x0000,   /* U+3E09 */
  0x0000,   /* U+3E0A */
  0x0000,   /* U+3E0B */
  0x0000,   /* U+3E0C */
  0x0000,   /* U+3E0D */
  0x0000,   /* U+3E0E */
  0x0000,   /* U+3E0F */
  0x0000,   /* U+3E10 */
  0x0000,   /* U+3E11 */
  0x0000,   /* U+3E12 */
  0x0000,   /* U+3E13 */
  0x0000,   /* U+3E14 */
  0x0000,   /* U+3E15 */
  0x0000,   /* U+3E16 */
  0x0000,   /* U+3E17 */
  0x0000,   /* U+3E18 */
  0x0000,   /* U+3E19 */
  0x0000,   /* U+3E1A */
  0x0000,   /* U+3E1B */
  0x0000,   /* U+3E1C */
  0x0000,   /* U+3E1D */
  0x0000,   /* U+3E1E */
  0x0000,   /* U+3E1F */
  0x0000,   /* U+3E20 */
  0x0000,   /* U+3E21 */
  0x0000,   /* U+3E22 */
  0x0000,   /* U+3E23 */
  0x0000,   /* U+3E24 */
  0x0000,   /* U+3E25 */
  0x0000,   /* U+3E26 */
  0x0000,   /* U+3E27 */
  0x0000,   /* U+3E28 */
  0x0000,   /* U+3E29 */
  0x0000,   /* U+3E2A */
  0x0000,   /* U+3E2B */
  0x0000,   /* U+3E2C */
  0x0000,   /* U+3E2D */
  0x0000,   /* U+3E2E */
  0x0000,   /* U+3E2F */
  0x0000,   /* U+3E30 */
  0x0000,   /* U+3E31 */
  0x0000,   /* U+3E32 */
  0x0000,   /* U+3E33 */
  0x0000,   /* U+3E34 */
  0x0000,   /* U+3E35 */
  0x0000,   /* U+3E36 */
  0x0000,   /* U+3E37 */
  0x0000,   /* U+3E38 */
  0x0000,   /* U+3E39 */
  0x0000,   /* U+3E3A */
  0x0000,   /* U+3E3B */
  0x0000,   /* U+3E3C */
  0x0000,   /* U+3E3D */
  0x0000,   /* U+3E3E */
  0x0000,   /* U+3E3F */
  0x0000,   /* U+3E40 */
  0x0000,   /* U+3E41 */
  0x0000,   /* U+3E42 */
  0x0000,   /* U+3E43 */
  0x0000,   /* U+3E44 */
  0x0000,   /* U+3E45 */
  0x0000,   /* U+3E46 */
  0x0000,   /* U+3E47 */
  0x0000,   /* U+3E48 */
  0x0000,   /* U+3E49 */
  0x0000,   /* U+3E4A */
  0x0000,   /* U+3E4B */
  0x0000,   /* U+3E4C */
  0x0000,   /* U+3E4D */
  0x0000,   /* U+3E4E */
  0x0000,   /* U+3E4F */
  0x0000,   /* U+3E50 */
  0x0000,   /* U+3E51 */
  0x0000,   /* U+3E52 */
  0x0000,   /* U+3E53 */
  0x0000,   /* U+3E54 */
  0x0000,   /* U+3E55 */
  0x0000,   /* U+3E56 */
  0x0000,   /* U+3E57 */
  0x0000,   /* U+3E58 */
  0x0000,   /* U+3E59 */
  0x0000,   /* U+3E5A */
  0x0000,   /* U+3E5B */
  0x0000,   /* U+3E5C */
  0x0000,   /* U+3E5D */
  0x0000,   /* U+3E5E */
  0x0000,   /* U+3E5F */
  0x0000,   /* U+3E60 */
  0x0000,   /* U+3E61 */
  0x0000,   /* U+3E62 */
  0x0000,   /* U+3E63 */
  0x0000,   /* U+3E64 */
  0x0000,   /* U+3E65 */
  0x0000,   /* U+3E66 */
  0x0000,   /* U+3E67 */
  0x0000,   /* U+3E68 */
  0x0000,   /* U+3E69 */
  0x0000,   /* U+3E6A */
  0x0000,   /* U+3E6B */
  0x0000,   /* U+3E6C */
  0x0000,   /* U+3E6D */
  0x0000,   /* U+3E6E */
  0x0000,   /* U+3E6F */
  0x0000,   /* U+3E70 */
  0x0000,   /* U+3E71 */
  0x0000,   /* U+3E72 */
  0x0000,   /* U+3E73 */
  0x0000,   /* U+3E74 */
  0x0000,   /* U+3E75 */
  0x0000,   /* U+3E76 */
  0x0000,   /* U+3E77 */
  0x0000,   /* U+3E78 */
  0x0000,   /* U+3E79 */
  0x0000,   /* U+3E7A */
  0x0000,   /* U+3E7B */
  0x0000,   /* U+3E7C */
  0x0000,   /* U+3E7D */
  0x0000,   /* U+3E7E */
  0x0000,   /* U+3E7F */
  0x0000,   /* U+3E80 */
  0x0000,   /* U+3E81 */
  0x0000,   /* U+3E82 */
  0x0000,   /* U+3E83 */
  0x0000,   /* U+3E84 */
  0x0000,   /* U+3E85 */
  0x0000,   /* U+3E86 */
  0x0000,   /* U+3E87 */
  0x0000,   /* U+3E88 */
  0x0000,   /* U+3E89 */
  0x0000,   /* U+3E8A */
  0x0000,   /* U+3E8B */
  0x0000,   /* U+3E8C */
  0x0000,   /* U+3E8D */
  0x0000,   /* U+3E8E */
  0x0000,   /* U+3E8F */
  0x0000,   /* U+3E90 */
  0x0000,   /* U+3E91 */
  0x0000,   /* U+3E92 */
  0x0000,   /* U+3E93 */
  0x0000,   /* U+3E94 */
  0x0000,   /* U+3E95 */
  0x0000,   /* U+3E96 */
  0x0000,   /* U+3E97 */
  0x0000,   /* U+3E98 */
  0x0000,   /* U+3E99 */
  0x0000,   /* U+3E9A */
  0x0000,   /* U+3E9B */
  0x0000,   /* U+3E9C */
  0x0000,   /* U+3E9D */
  0x0000,   /* U+3E9E */
  0x0000,   /* U+3E9F */
  0x0000,   /* U+3EA0 */
  0x0000,   /* U+3EA1 */
  0x0000,   /* U+3EA2 */
  0x0000,   /* U+3EA3 */
  0x0000,   /* U+3EA4 */
  0x0000,   /* U+3EA5 */
  0x0000,   /* U+3EA6 */
  0x0000,   /* U+3EA7 */
  0x0000,   /* U+3EA8 */
  0x0000,   /* U+3EA9 */
  0x0000,   /* U+3EAA */
  0x0000,   /* U+3EAB */
  0x0000,   /* U+3EAC */
  0x0000,   /* U+3EAD */
  0x0000,   /* U+3EAE */
  0x0000,   /* U+3EAF */
  0x0000,   /* U+3EB0 */
  0x0000,   /* U+3EB1 */
  0x0000,   /* U+3EB2 */
  0x0000,   /* U+3EB3 */
  0x0000,   /* U+3EB4 */
  0x0000,   /* U+3EB5 */
  0x0000,   /* U+3EB6 */
  0x0000,   /* U+3EB7 */
  0x0000,   /* U+3EB8 */
  0x0000,   /* U+3EB9 */
  0x0000,   /* U+3EBA */
  0x0000,   /* U+3EBB */
  0x0000,   /* U+3EBC */
  0x0000,   /* U+3EBD */
  0x0000,   /* U+3EBE */
  0x0000,   /* U+3EBF */
  0x0000,   /* U+3EC0 */
  0x0000,   /* U+3EC1 */
  0x0000,   /* U+3EC2 */
  0x0000,   /* U+3EC3 */
  0x0000,   /* U+3EC4 */
  0x0000,   /* U+3EC5 */
  0x0000,   /* U+3EC6 */
  0x0000,   /* U+3EC7 */
  0x0000,   /* U+3EC8 */
  0x0000,   /* U+3EC9 */
  0x0000,   /* U+3ECA */
  0x0000,   /* U+3ECB */
  0x0000,   /* U+3ECC */
  0x0000,   /* U+3ECD */
  0x0000,   /* U+3ECE */
  0x0000,   /* U+3ECF */
  0x0000,   /* U+3ED0 */
  0x0000,   /* U+3ED1 */
  0x0000,   /* U+3ED2 */
  0x0000,   /* U+3ED3 */
  0x0000,   /* U+3ED4 */
  0x0000,   /* U+3ED5 */
  0x0000,   /* U+3ED6 */
  0x0000,   /* U+3ED7 */
  0x0000,   /* U+3ED8 */
  0x0000,   /* U+3ED9 */
  0x0000,   /* U+3EDA */
  0x0000,   /* U+3EDB */
  0x0000,   /* U+3EDC */
  0x0000,   /* U+3EDD */
  0x0000,   /* U+3EDE */
  0x0000,   /* U+3EDF */
  0x0000,   /* U+3EE0 */
  0x0000,   /* U+3EE1 */
  0x0000,   /* U+3EE2 */
  0x0000,   /* U+3EE3 */
  0x0000,   /* U+3EE4 */
  0x0000,   /* U+3EE5 */
  0x0000,   /* U+3EE6 */
  0x0000,   /* U+3EE7 */
  0x0000,   /* U+3EE8 */
  0x0000,   /* U+3EE9 */
  0x0000,   /* U+3EEA */
  0x0000,   /* U+3EEB */
  0x0000,   /* U+3EEC */
  0x0000,   /* U+3EED */
  0x0000,   /* U+3EEE */
  0x0000,   /* U+3EEF */
  0x0000,   /* U+3EF0 */
  0x0000,   /* U+3EF1 */
  0x0000,   /* U+3EF2 */
  0x0000,   /* U+3EF3 */
  0x0000,   /* U+3EF4 */
  0x0000,   /* U+3EF5 */
  0x0000,   /* U+3EF6 */
  0x0000,   /* U+3EF7 */
  0x0000,   /* U+3EF8 */
  0x0000,   /* U+3EF9 */
  0x0000,   /* U+3EFA */
  0x0000,   /* U+3EFB */
  0x0000,   /* U+3EFC */
  0x0000,   /* U+3EFD */
  0x0000,   /* U+3EFE */
  0x0000,   /* U+3EFF */
};

uint16 zh2_han_p03F[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x5C49,   /* U+3F00 */
  0x5C49,   /* U+3F01 */
  0x3459,   /* U+3F02 */
  0x5C49,   /* U+3F03 */
  0x345B,   /* U+3F04 */
  0x5C49,   /* U+3F05 */
  0x345B,   /* U+3F06 */
  0x345C,   /* U+3F07 */
  0x345F,   /* U+3F08 */
  0x3490,   /* U+3F09 */
  0x3490,   /* U+3F0A */
  0x3491,   /* U+3F0B */
  0x3491,   /* U+3F0C */
  0x3492,   /* U+3F0D */
  0x3492,   /* U+3F0E */
  0x3493,   /* U+3F0F */
  0x3495,   /* U+3F10 */
  0x3495,   /* U+3F11 */
  0x3495,   /* U+3F12 */
  0x348D,   /* U+3F13 */
  0x348D,   /* U+3F14 */
  0x3499,   /* U+3F15 */
  0x34A1,   /* U+3F16 */
  0x34CE,   /* U+3F17 */
  0x34CF,   /* U+3F18 */
  0x34CF,   /* U+3F19 */
  0x34D0,   /* U+3F1A */
  0x34D0,   /* U+3F1B */
  0x34D1,   /* U+3F1C */
  0x34D1,   /* U+3F1D */
  0x34D1,   /* U+3F1E */
  0x34D1,   /* U+3F1F */
  0x34D1,   /* U+3F20 */
  0x34D2,   /* U+3F21 */
  0x34D2,   /* U+3F22 */
  0x34D2,   /* U+3F23 */
  0x34D2,   /* U+3F24 */
  0x34D2,   /* U+3F25 */
  0x34D2,   /* U+3F26 */
  0x34D3,   /* U+3F27 */
  0x34D3,   /* U+3F28 */
  0x34D3,   /* U+3F29 */
  0x34D3,   /* U+3F2A */
  0x34D4,   /* U+3F2B */
  0x34D4,   /* U+3F2C */
  0x34D4,   /* U+3F2D */
  0x34D4,   /* U+3F2E */
  0x34D4,   /* U+3F2F */
  0x34D4,   /* U+3F30 */
  0x34D4,   /* U+3F31 */
  0x34D5,   /* U+3F32 */
  0x34D5,   /* U+3F33 */
  0x34D5,   /* U+3F34 */
  0x34D5,   /* U+3F35 */
  0x34D5,   /* U+3F36 */
  0x34D5,   /* U+3F37 */
  0x34CD,   /* U+3F38 */
  0x34CD,   /* U+3F39 */
  0x34CD,   /* U+3F3A */
  0x34D7,   /* U+3F3B */
  0x34D7,   /* U+3F3C */
  0x34D7,   /* U+3F3D */
  0x34D7,   /* U+3F3E */
  0x34D8,   /* U+3F3F */
  0x34D8,   /* U+3F40 */
  0x34D8,   /* U+3F41 */
  0x34D8,   /* U+3F42 */
  0x34D8,   /* U+3F43 */
  0x34D8,   /* U+3F44 */
  0x34D8,   /* U+3F45 */
  0x34D9,   /* U+3F46 */
  0x34D9,   /* U+3F47 */
  0x34DA,   /* U+3F48 */
  0x34DA,   /* U+3F49 */
  0x34DD,   /* U+3F4A */
  0x34DF,   /* U+3F4B */
  0x34CE,   /* U+3F4C */
  0x3511,   /* U+3F4D */
  0x3514,   /* U+3F4E */
  0x3515,   /* U+3F4F */
  0x350D,   /* U+3F50 */
  0x3518,   /* U+3F51 */
  0x3553,   /* U+3F52 */
  0x354D,   /* U+3F53 */
  0x5C49,   /* U+3F54 */
  0x35CE,   /* U+3F55 */
  0x35CE,   /* U+3F56 */
  0x5C49,   /* U+3F57 */
  0x35D0,   /* U+3F58 */
  0x35D0,   /* U+3F59 */
  0x35D0,   /* U+3F5A */
  0x35D1,   /* U+3F5B */
  0x35D1,   /* U+3F5C */
  0x35D2,   /* U+3F5D */
  0x5C49,   /* U+3F5E */
  0x35D3,   /* U+3F5F */
  0x35D3,   /* U+3F60 */
  0x35D4,   /* U+3F61 */
  0x35D4,   /* U+3F62 */
  0x35D4,   /* U+3F63 */
  0x35D4,   /* U+3F64 */
  0x35D5,   /* U+3F65 */
  0x35CD,   /* U+3F66 */
  0x35CD,   /* U+3F67 */
  0x35CD,   /* U+3F68 */
  0x35D7,   /* U+3F69 */
  0x35D8,   /* U+3F6A */
  0x35D9,   /* U+3F6B */
  0x35D9,   /* U+3F6C */
  0x35DA,   /* U+3F6D */
  0x35DB,   /* U+3F6E */
  0x35DE,   /* U+3F6F */
  0x3614,   /* U+3F70 */
  0x364E,   /* U+3F71 */
  0x364E,   /* U+3F72 */
  0x364F,   /* U+3F73 */
  0x364F,   /* U+3F74 */
  0x364F,   /* U+3F75 */
  0x5C49,   /* U+3F76 */
  0x3650,   /* U+3F77 */
  0x3650,   /* U+3F78 */
  0x3650,   /* U+3F79 */
  0x3650,   /* U+3F7A */
  0x3650,   /* U+3F7B */
  0x3650,   /* U+3F7C */
  0x3651,   /* U+3F7D */
  0x3651,   /* U+3F7E */
  0x3651,   /* U+3F7F */
  0x3651,   /* U+3F80 */
  0x3651,   /* U+3F81 */
  0x3651,   /* U+3F82 */
  0x3651,   /* U+3F83 */
  0x3651,   /* U+3F84 */
  0x3651,   /* U+3F85 */
  0x3651,   /* U+3F86 */
  0x3651,   /* U+3F87 */
  0x3651,   /* U+3F88 */
  0x3651,   /* U+3F89 */
  0x3652,   /* U+3F8A */
  0x3652,   /* U+3F8B */
  0x3652,   /* U+3F8C */
  0x3652,   /* U+3F8D */
  0x3652,   /* U+3F8E */
  0x3652,   /* U+3F8F */
  0x3652,   /* U+3F90 */
  0x3652,   /* U+3F91 */
  0x3652,   /* U+3F92 */
  0x3653,   /* U+3F93 */
  0x3653,   /* U+3F94 */
  0x3653,   /* U+3F95 */
  0x3653,   /* U+3F96 */
  0x3653,   /* U+3F97 */
  0x3653,   /* U+3F98 */
  0x3653,   /* U+3F99 */
  0x3653,   /* U+3F9A */
  0x3653,   /* U+3F9B */
  0x3653,   /* U+3F9C */
  0x3653,   /* U+3F9D */
  0x3653,   /* U+3F9E */
  0x3653,   /* U+3F9F */
  0x3653,   /* U+3FA0 */
  0x3653,   /* U+3FA1 */
  0x3654,   /* U+3FA2 */
  0x3654,   /* U+3FA3 */
  0x3654,   /* U+3FA4 */
  0x3654,   /* U+3FA5 */
  0x3654,   /* U+3FA6 */
  0x3654,   /* U+3FA7 */
  0x3654,   /* U+3FA8 */
  0x3654,   /* U+3FA9 */
  0x3655,   /* U+3FAA */
  0x3655,   /* U+3FAB */
  0x3655,   /* U+3FAC */
  0x3655,   /* U+3FAD */
  0x3655,   /* U+3FAE */
  0x3655,   /* U+3FAF */
  0x3655,   /* U+3FB0 */
  0x5C49,   /* U+3FB1 */
  0x3655,   /* U+3FB2 */
  0x5C49,   /* U+3FB3 */
  0x3655,   /* U+3FB4 */
  0x3655,   /* U+3FB5 */
  0x364D,   /* U+3FB6 */
  0x364D,   /* U+3FB7 */
  0x364D,   /* U+3FB8 */
  0x364D,   /* U+3FB9 */
  0x364D,   /* U+3FBA */
  0x364D,   /* U+3FBB */
  0x364D,   /* U+3FBC */
  0x364D,   /* U+3FBD */
  0x364D,   /* U+3FBE */
  0x364D,   /* U+3FBF */
  0x364D,   /* U+3FC0 */
  0x364D,   /* U+3FC1 */
  0x3657,   /* U+3FC2 */
  0x3657,   /* U+3FC3 */
  0x3657,   /* U+3FC4 */
  0x3657,   /* U+3FC5 */
  0x3657,   /* U+3FC6 */
  0x3657,   /* U+3FC7 */
  0x3657,   /* U+3FC8 */
  0x3658,   /* U+3FC9 */
  0x3658,   /* U+3FCA */
  0x3659,   /* U+3FCB */
  0x3659,   /* U+3FCC */
  0x3659,   /* U+3FCD */
  0x3659,   /* U+3FCE */
  0x3659,   /* U+3FCF */
  0x5C49,   /* U+3FD0 */
  0x365A,   /* U+3FD1 */
  0x365A,   /* U+3FD2 */
  0x365A,   /* U+3FD3 */
  0x365B,   /* U+3FD4 */
  0x365C,   /* U+3FD5 */
  0x365C,   /* U+3FD6 */
  0x365C,   /* U+3FD7 */
  0x365D,   /* U+3FD8 */
  0x365E,   /* U+3FD9 */
  0x365F,   /* U+3FDA */
  0x365F,   /* U+3FDB */
  0x3663,   /* U+3FDC */
  0x36CE,   /* U+3FDD */
  0x36D0,   /* U+3FDE */
  0x36D1,   /* U+3FDF */
  0x36D2,   /* U+3FE0 */
  0x36D2,   /* U+3FE1 */
  0x36D4,   /* U+3FE2 */
  0x36D5,   /* U+3FE3 */
  0x36D5,   /* U+3FE4 */
  0x36CD,   /* U+3FE5 */
  0x36D7,   /* U+3FE6 */
  0x36DA,   /* U+3FE7 */
  0x36DC,   /* U+3FE8 */
  0x36CE,   /* U+3FE9 */
  0x370F,   /* U+3FEA */
  0x3710,   /* U+3FEB */
  0x3710,   /* U+3FEC */
  0x3711,   /* U+3FED */
  0x3711,   /* U+3FEE */
  0x3712,   /* U+3FEF */
  0x3712,   /* U+3FF0 */
  0x3713,   /* U+3FF1 */
  0x3714,   /* U+3FF2 */
  0x3714,   /* U+3FF3 */
  0x3715,   /* U+3FF4 */
  0x3715,   /* U+3FF5 */
  0x370D,   /* U+3FF6 */
  0x370D,   /* U+3FF7 */
  0x3717,   /* U+3FF8 */
  0x3719,   /* U+3FF9 */
  0x371B,   /* U+3FFA */
  0x374F,   /* U+3FFB */
  0x3750,   /* U+3FFC */
  0x3750,   /* U+3FFD */
  0x3751,   /* U+3FFE */
  0x3751,   /* U+3FFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+3F00 */
  0x0020,   /* U+3F01 */
  0x0020,   /* U+3F02 */
  0x0020,   /* U+3F03 */
  0x0020,   /* U+3F04 */
  0x0020,   /* U+3F05 */
  0x0020,   /* U+3F06 */
  0x0020,   /* U+3F07 */
  0x0020,   /* U+3F08 */
  0x0020,   /* U+3F09 */
  0x0020,   /* U+3F0A */
  0x0020,   /* U+3F0B */
  0x0020,   /* U+3F0C */
  0x0020,   /* U+3F0D */
  0x0020,   /* U+3F0E */
  0x0020,   /* U+3F0F */
  0x0020,   /* U+3F10 */
  0x0020,   /* U+3F11 */
  0x0020,   /* U+3F12 */
  0x0020,   /* U+3F13 */
  0x0020,   /* U+3F14 */
  0x0020,   /* U+3F15 */
  0x0020,   /* U+3F16 */
  0x0020,   /* U+3F17 */
  0x0020,   /* U+3F18 */
  0x0020,   /* U+3F19 */
  0x0020,   /* U+3F1A */
  0x0020,   /* U+3F1B */
  0x0020,   /* U+3F1C */
  0x0020,   /* U+3F1D */
  0x0020,   /* U+3F1E */
  0x0020,   /* U+3F1F */
  0x0020,   /* U+3F20 */
  0x0020,   /* U+3F21 */
  0x0020,   /* U+3F22 */
  0x0020,   /* U+3F23 */
  0x0020,   /* U+3F24 */
  0x0020,   /* U+3F25 */
  0x0020,   /* U+3F26 */
  0x0020,   /* U+3F27 */
  0x0020,   /* U+3F28 */
  0x0020,   /* U+3F29 */
  0x0020,   /* U+3F2A */
  0x0020,   /* U+3F2B */
  0x0020,   /* U+3F2C */
  0x0020,   /* U+3F2D */
  0x0020,   /* U+3F2E */
  0x0020,   /* U+3F2F */
  0x0020,   /* U+3F30 */
  0x0020,   /* U+3F31 */
  0x0020,   /* U+3F32 */
  0x0020,   /* U+3F33 */
  0x0020,   /* U+3F34 */
  0x0020,   /* U+3F35 */
  0x0020,   /* U+3F36 */
  0x0020,   /* U+3F37 */
  0x0020,   /* U+3F38 */
  0x0020,   /* U+3F39 */
  0x0020,   /* U+3F3A */
  0x0020,   /* U+3F3B */
  0x0020,   /* U+3F3C */
  0x0020,   /* U+3F3D */
  0x0020,   /* U+3F3E */
  0x0020,   /* U+3F3F */
  0x0020,   /* U+3F40 */
  0x0020,   /* U+3F41 */
  0x0020,   /* U+3F42 */
  0x0020,   /* U+3F43 */
  0x0020,   /* U+3F44 */
  0x0020,   /* U+3F45 */
  0x0020,   /* U+3F46 */
  0x0020,   /* U+3F47 */
  0x0020,   /* U+3F48 */
  0x0020,   /* U+3F49 */
  0x0020,   /* U+3F4A */
  0x0020,   /* U+3F4B */
  0x0020,   /* U+3F4C */
  0x0020,   /* U+3F4D */
  0x0020,   /* U+3F4E */
  0x0020,   /* U+3F4F */
  0x0020,   /* U+3F50 */
  0x0020,   /* U+3F51 */
  0x0020,   /* U+3F52 */
  0x0020,   /* U+3F53 */
  0x0020,   /* U+3F54 */
  0x0020,   /* U+3F55 */
  0x0020,   /* U+3F56 */
  0x0020,   /* U+3F57 */
  0x0020,   /* U+3F58 */
  0x0020,   /* U+3F59 */
  0x0020,   /* U+3F5A */
  0x0020,   /* U+3F5B */
  0x0020,   /* U+3F5C */
  0x0020,   /* U+3F5D */
  0x0020,   /* U+3F5E */
  0x0020,   /* U+3F5F */
  0x0020,   /* U+3F60 */
  0x0020,   /* U+3F61 */
  0x0020,   /* U+3F62 */
  0x0020,   /* U+3F63 */
  0x0020,   /* U+3F64 */
  0x0020,   /* U+3F65 */
  0x0020,   /* U+3F66 */
  0x0020,   /* U+3F67 */
  0x0020,   /* U+3F68 */
  0x0020,   /* U+3F69 */
  0x0020,   /* U+3F6A */
  0x0020,   /* U+3F6B */
  0x0020,   /* U+3F6C */
  0x0020,   /* U+3F6D */
  0x0020,   /* U+3F6E */
  0x0020,   /* U+3F6F */
  0x0020,   /* U+3F70 */
  0x0020,   /* U+3F71 */
  0x0020,   /* U+3F72 */
  0x0020,   /* U+3F73 */
  0x0020,   /* U+3F74 */
  0x0020,   /* U+3F75 */
  0x0020,   /* U+3F76 */
  0x0020,   /* U+3F77 */
  0x0020,   /* U+3F78 */
  0x0020,   /* U+3F79 */
  0x0020,   /* U+3F7A */
  0x0020,   /* U+3F7B */
  0x0020,   /* U+3F7C */
  0x0020,   /* U+3F7D */
  0x0020,   /* U+3F7E */
  0x0020,   /* U+3F7F */
  0x0020,   /* U+3F80 */
  0x0020,   /* U+3F81 */
  0x0020,   /* U+3F82 */
  0x0020,   /* U+3F83 */
  0x0020,   /* U+3F84 */
  0x0020,   /* U+3F85 */
  0x0020,   /* U+3F86 */
  0x0020,   /* U+3F87 */
  0x0020,   /* U+3F88 */
  0x0020,   /* U+3F89 */
  0x0020,   /* U+3F8A */
  0x0020,   /* U+3F8B */
  0x0020,   /* U+3F8C */
  0x0020,   /* U+3F8D */
  0x0020,   /* U+3F8E */
  0x0020,   /* U+3F8F */
  0x0020,   /* U+3F90 */
  0x0020,   /* U+3F91 */
  0x0020,   /* U+3F92 */
  0x0020,   /* U+3F93 */
  0x0020,   /* U+3F94 */
  0x0020,   /* U+3F95 */
  0x0020,   /* U+3F96 */
  0x0020,   /* U+3F97 */
  0x0020,   /* U+3F98 */
  0x0020,   /* U+3F99 */
  0x0020,   /* U+3F9A */
  0x0020,   /* U+3F9B */
  0x0020,   /* U+3F9C */
  0x0020,   /* U+3F9D */
  0x0020,   /* U+3F9E */
  0x0020,   /* U+3F9F */
  0x0020,   /* U+3FA0 */
  0x0020,   /* U+3FA1 */
  0x0020,   /* U+3FA2 */
  0x0020,   /* U+3FA3 */
  0x0020,   /* U+3FA4 */
  0x0020,   /* U+3FA5 */
  0x0020,   /* U+3FA6 */
  0x0020,   /* U+3FA7 */
  0x0020,   /* U+3FA8 */
  0x0020,   /* U+3FA9 */
  0x0020,   /* U+3FAA */
  0x0020,   /* U+3FAB */
  0x0020,   /* U+3FAC */
  0x0020,   /* U+3FAD */
  0x0020,   /* U+3FAE */
  0x0020,   /* U+3FAF */
  0x0020,   /* U+3FB0 */
  0x0020,   /* U+3FB1 */
  0x0020,   /* U+3FB2 */
  0x0020,   /* U+3FB3 */
  0x0020,   /* U+3FB4 */
  0x0020,   /* U+3FB5 */
  0x0020,   /* U+3FB6 */
  0x0020,   /* U+3FB7 */
  0x0020,   /* U+3FB8 */
  0x0020,   /* U+3FB9 */
  0x0020,   /* U+3FBA */
  0x0020,   /* U+3FBB */
  0x0020,   /* U+3FBC */
  0x0020,   /* U+3FBD */
  0x0020,   /* U+3FBE */
  0x0020,   /* U+3FBF */
  0x0020,   /* U+3FC0 */
  0x0020,   /* U+3FC1 */
  0x0020,   /* U+3FC2 */
  0x0020,   /* U+3FC3 */
  0x0020,   /* U+3FC4 */
  0x0020,   /* U+3FC5 */
  0x0020,   /* U+3FC6 */
  0x0020,   /* U+3FC7 */
  0x0020,   /* U+3FC8 */
  0x0020,   /* U+3FC9 */
  0x0020,   /* U+3FCA */
  0x0020,   /* U+3FCB */
  0x0020,   /* U+3FCC */
  0x0020,   /* U+3FCD */
  0x0020,   /* U+3FCE */
  0x0020,   /* U+3FCF */
  0x0020,   /* U+3FD0 */
  0x0020,   /* U+3FD1 */
  0x0020,   /* U+3FD2 */
  0x0020,   /* U+3FD3 */
  0x0020,   /* U+3FD4 */
  0x0020,   /* U+3FD5 */
  0x0020,   /* U+3FD6 */
  0x0020,   /* U+3FD7 */
  0x0020,   /* U+3FD8 */
  0x0020,   /* U+3FD9 */
  0x0020,   /* U+3FDA */
  0x0020,   /* U+3FDB */
  0x0020,   /* U+3FDC */
  0x0020,   /* U+3FDD */
  0x0020,   /* U+3FDE */
  0x0020,   /* U+3FDF */
  0x0020,   /* U+3FE0 */
  0x0020,   /* U+3FE1 */
  0x0020,   /* U+3FE2 */
  0x0020,   /* U+3FE3 */
  0x0020,   /* U+3FE4 */
  0x0020,   /* U+3FE5 */
  0x0020,   /* U+3FE6 */
  0x0020,   /* U+3FE7 */
  0x0020,   /* U+3FE8 */
  0x0020,   /* U+3FE9 */
  0x0020,   /* U+3FEA */
  0x0020,   /* U+3FEB */
  0x0020,   /* U+3FEC */
  0x0020,   /* U+3FED */
  0x0020,   /* U+3FEE */
  0x0020,   /* U+3FEF */
  0x0020,   /* U+3FF0 */
  0x0020,   /* U+3FF1 */
  0x0020,   /* U+3FF2 */
  0x0020,   /* U+3FF3 */
  0x0020,   /* U+3FF4 */
  0x0020,   /* U+3FF5 */
  0x0020,   /* U+3FF6 */
  0x0020,   /* U+3FF7 */
  0x0020,   /* U+3FF8 */
  0x0020,   /* U+3FF9 */
  0x0020,   /* U+3FFA */
  0x0020,   /* U+3FFB */
  0x0020,   /* U+3FFC */
  0x0020,   /* U+3FFD */
  0x0020,   /* U+3FFE */
  0x0020,   /* U+3FFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+3F00 */
  0x0002,   /* U+3F01 */
  0x0002,   /* U+3F02 */
  0x0002,   /* U+3F03 */
  0x0002,   /* U+3F04 */
  0x0002,   /* U+3F05 */
  0x0002,   /* U+3F06 */
  0x0002,   /* U+3F07 */
  0x0002,   /* U+3F08 */
  0x0002,   /* U+3F09 */
  0x0002,   /* U+3F0A */
  0x0002,   /* U+3F0B */
  0x0002,   /* U+3F0C */
  0x0002,   /* U+3F0D */
  0x0002,   /* U+3F0E */
  0x0002,   /* U+3F0F */
  0x0002,   /* U+3F10 */
  0x0002,   /* U+3F11 */
  0x0002,   /* U+3F12 */
  0x0002,   /* U+3F13 */
  0x0002,   /* U+3F14 */
  0x0002,   /* U+3F15 */
  0x0002,   /* U+3F16 */
  0x0002,   /* U+3F17 */
  0x0002,   /* U+3F18 */
  0x0002,   /* U+3F19 */
  0x0002,   /* U+3F1A */
  0x0002,   /* U+3F1B */
  0x0002,   /* U+3F1C */
  0x0002,   /* U+3F1D */
  0x0002,   /* U+3F1E */
  0x0002,   /* U+3F1F */
  0x0002,   /* U+3F20 */
  0x0002,   /* U+3F21 */
  0x0002,   /* U+3F22 */
  0x0002,   /* U+3F23 */
  0x0002,   /* U+3F24 */
  0x0002,   /* U+3F25 */
  0x0002,   /* U+3F26 */
  0x0002,   /* U+3F27 */
  0x0002,   /* U+3F28 */
  0x0002,   /* U+3F29 */
  0x0002,   /* U+3F2A */
  0x0002,   /* U+3F2B */
  0x0002,   /* U+3F2C */
  0x0002,   /* U+3F2D */
  0x0002,   /* U+3F2E */
  0x0002,   /* U+3F2F */
  0x0002,   /* U+3F30 */
  0x0002,   /* U+3F31 */
  0x0002,   /* U+3F32 */
  0x0002,   /* U+3F33 */
  0x0002,   /* U+3F34 */
  0x0002,   /* U+3F35 */
  0x0002,   /* U+3F36 */
  0x0002,   /* U+3F37 */
  0x0002,   /* U+3F38 */
  0x0002,   /* U+3F39 */
  0x0002,   /* U+3F3A */
  0x0002,   /* U+3F3B */
  0x0002,   /* U+3F3C */
  0x0002,   /* U+3F3D */
  0x0002,   /* U+3F3E */
  0x0002,   /* U+3F3F */
  0x0002,   /* U+3F40 */
  0x0002,   /* U+3F41 */
  0x0002,   /* U+3F42 */
  0x0002,   /* U+3F43 */
  0x0002,   /* U+3F44 */
  0x0002,   /* U+3F45 */
  0x0002,   /* U+3F46 */
  0x0002,   /* U+3F47 */
  0x0002,   /* U+3F48 */
  0x0002,   /* U+3F49 */
  0x0002,   /* U+3F4A */
  0x0002,   /* U+3F4B */
  0x0002,   /* U+3F4C */
  0x0002,   /* U+3F4D */
  0x0002,   /* U+3F4E */
  0x0002,   /* U+3F4F */
  0x0002,   /* U+3F50 */
  0x0002,   /* U+3F51 */
  0x0002,   /* U+3F52 */
  0x0002,   /* U+3F53 */
  0x0002,   /* U+3F54 */
  0x0002,   /* U+3F55 */
  0x0002,   /* U+3F56 */
  0x0002,   /* U+3F57 */
  0x0002,   /* U+3F58 */
  0x0002,   /* U+3F59 */
  0x0002,   /* U+3F5A */
  0x0002,   /* U+3F5B */
  0x0002,   /* U+3F5C */
  0x0002,   /* U+3F5D */
  0x0002,   /* U+3F5E */
  0x0002,   /* U+3F5F */
  0x0002,   /* U+3F60 */
  0x0002,   /* U+3F61 */
  0x0002,   /* U+3F62 */
  0x0002,   /* U+3F63 */
  0x0002,   /* U+3F64 */
  0x0002,   /* U+3F65 */
  0x0002,   /* U+3F66 */
  0x0002,   /* U+3F67 */
  0x0002,   /* U+3F68 */
  0x0002,   /* U+3F69 */
  0x0002,   /* U+3F6A */
  0x0002,   /* U+3F6B */
  0x0002,   /* U+3F6C */
  0x0002,   /* U+3F6D */
  0x0002,   /* U+3F6E */
  0x0002,   /* U+3F6F */
  0x0002,   /* U+3F70 */
  0x0002,   /* U+3F71 */
  0x0002,   /* U+3F72 */
  0x0002,   /* U+3F73 */
  0x0002,   /* U+3F74 */
  0x0002,   /* U+3F75 */
  0x0002,   /* U+3F76 */
  0x0002,   /* U+3F77 */
  0x0002,   /* U+3F78 */
  0x0002,   /* U+3F79 */
  0x0002,   /* U+3F7A */
  0x0002,   /* U+3F7B */
  0x0002,   /* U+3F7C */
  0x0002,   /* U+3F7D */
  0x0002,   /* U+3F7E */
  0x0002,   /* U+3F7F */
  0x0002,   /* U+3F80 */
  0x0002,   /* U+3F81 */
  0x0002,   /* U+3F82 */
  0x0002,   /* U+3F83 */
  0x0002,   /* U+3F84 */
  0x0002,   /* U+3F85 */
  0x0002,   /* U+3F86 */
  0x0002,   /* U+3F87 */
  0x0002,   /* U+3F88 */
  0x0002,   /* U+3F89 */
  0x0002,   /* U+3F8A */
  0x0002,   /* U+3F8B */
  0x0002,   /* U+3F8C */
  0x0002,   /* U+3F8D */
  0x0002,   /* U+3F8E */
  0x0002,   /* U+3F8F */
  0x0002,   /* U+3F90 */
  0x0002,   /* U+3F91 */
  0x0002,   /* U+3F92 */
  0x0002,   /* U+3F93 */
  0x0002,   /* U+3F94 */
  0x0002,   /* U+3F95 */
  0x0002,   /* U+3F96 */
  0x0002,   /* U+3F97 */
  0x0002,   /* U+3F98 */
  0x0002,   /* U+3F99 */
  0x0002,   /* U+3F9A */
  0x0002,   /* U+3F9B */
  0x0002,   /* U+3F9C */
  0x0002,   /* U+3F9D */
  0x0002,   /* U+3F9E */
  0x0002,   /* U+3F9F */
  0x0002,   /* U+3FA0 */
  0x0002,   /* U+3FA1 */
  0x0002,   /* U+3FA2 */
  0x0002,   /* U+3FA3 */
  0x0002,   /* U+3FA4 */
  0x0002,   /* U+3FA5 */
  0x0002,   /* U+3FA6 */
  0x0002,   /* U+3FA7 */
  0x0002,   /* U+3FA8 */
  0x0002,   /* U+3FA9 */
  0x0002,   /* U+3FAA */
  0x0002,   /* U+3FAB */
  0x0002,   /* U+3FAC */
  0x0002,   /* U+3FAD */
  0x0002,   /* U+3FAE */
  0x0002,   /* U+3FAF */
  0x0002,   /* U+3FB0 */
  0x0002,   /* U+3FB1 */
  0x0002,   /* U+3FB2 */
  0x0002,   /* U+3FB3 */
  0x0002,   /* U+3FB4 */
  0x0002,   /* U+3FB5 */
  0x0002,   /* U+3FB6 */
  0x0002,   /* U+3FB7 */
  0x0002,   /* U+3FB8 */
  0x0002,   /* U+3FB9 */
  0x0002,   /* U+3FBA */
  0x0002,   /* U+3FBB */
  0x0002,   /* U+3FBC */
  0x0002,   /* U+3FBD */
  0x0002,   /* U+3FBE */
  0x0002,   /* U+3FBF */
  0x0002,   /* U+3FC0 */
  0x0002,   /* U+3FC1 */
  0x0002,   /* U+3FC2 */
  0x0002,   /* U+3FC3 */
  0x0002,   /* U+3FC4 */
  0x0002,   /* U+3FC5 */
  0x0002,   /* U+3FC6 */
  0x0002,   /* U+3FC7 */
  0x0002,   /* U+3FC8 */
  0x0002,   /* U+3FC9 */
  0x0002,   /* U+3FCA */
  0x0002,   /* U+3FCB */
  0x0002,   /* U+3FCC */
  0x0002,   /* U+3FCD */
  0x0002,   /* U+3FCE */
  0x0002,   /* U+3FCF */
  0x0002,   /* U+3FD0 */
  0x0002,   /* U+3FD1 */
  0x0002,   /* U+3FD2 */
  0x0002,   /* U+3FD3 */
  0x0002,   /* U+3FD4 */
  0x0002,   /* U+3FD5 */
  0x0002,   /* U+3FD6 */
  0x0002,   /* U+3FD7 */
  0x0002,   /* U+3FD8 */
  0x0002,   /* U+3FD9 */
  0x0002,   /* U+3FDA */
  0x0002,   /* U+3FDB */
  0x0002,   /* U+3FDC */
  0x0002,   /* U+3FDD */
  0x0002,   /* U+3FDE */
  0x0002,   /* U+3FDF */
  0x0002,   /* U+3FE0 */
  0x0002,   /* U+3FE1 */
  0x0002,   /* U+3FE2 */
  0x0002,   /* U+3FE3 */
  0x0002,   /* U+3FE4 */
  0x0002,   /* U+3FE5 */
  0x0002,   /* U+3FE6 */
  0x0002,   /* U+3FE7 */
  0x0002,   /* U+3FE8 */
  0x0002,   /* U+3FE9 */
  0x0002,   /* U+3FEA */
  0x0002,   /* U+3FEB */
  0x0002,   /* U+3FEC */
  0x0002,   /* U+3FED */
  0x0002,   /* U+3FEE */
  0x0002,   /* U+3FEF */
  0x0002,   /* U+3FF0 */
  0x0002,   /* U+3FF1 */
  0x0002,   /* U+3FF2 */
  0x0002,   /* U+3FF3 */
  0x0002,   /* U+3FF4 */
  0x0002,   /* U+3FF5 */
  0x0002,   /* U+3FF6 */
  0x0002,   /* U+3FF7 */
  0x0002,   /* U+3FF8 */
  0x0002,   /* U+3FF9 */
  0x0002,   /* U+3FFA */
  0x0002,   /* U+3FFB */
  0x0002,   /* U+3FFC */
  0x0002,   /* U+3FFD */
  0x0002,   /* U+3FFE */
  0x0002,   /* U+3FFF */

  /* Primary weight 2 for each character. */
  0xBF00,   /* U+3F00 */
  0xBF01,   /* U+3F01 */
  0x8003,   /* U+3F02 */
  0xBF03,   /* U+3F03 */
  0x8000,   /* U+3F04 */
  0xBF05,   /* U+3F05 */
  0x8001,   /* U+3F06 */
  0x8000,   /* U+3F07 */
  0x8000,   /* U+3F08 */
  0x8000,   /* U+3F09 */
  0x8001,   /* U+3F0A */
  0x8000,   /* U+3F0B */
  0x8001,   /* U+3F0C */
  0x8000,   /* U+3F0D */
  0x8001,   /* U+3F0E */
  0x8000,   /* U+3F0F */
  0x8000,   /* U+3F10 */
  0x8001,   /* U+3F11 */
  0x8002,   /* U+3F12 */
  0x8000,   /* U+3F13 */
  0x8001,   /* U+3F14 */
  0x8000,   /* U+3F15 */
  0x8000,   /* U+3F16 */
  0x8000,   /* U+3F17 */
  0x8000,   /* U+3F18 */
  0x8001,   /* U+3F19 */
  0x8000,   /* U+3F1A */
  0x8001,   /* U+3F1B */
  0x8000,   /* U+3F1C */
  0x8001,   /* U+3F1D */
  0x8002,   /* U+3F1E */
  0x8003,   /* U+3F1F */
  0x8004,   /* U+3F20 */
  0x8000,   /* U+3F21 */
  0x8001,   /* U+3F22 */
  0x8002,   /* U+3F23 */
  0x8003,   /* U+3F24 */
  0x8004,   /* U+3F25 */
  0x8005,   /* U+3F26 */
  0x8000,   /* U+3F27 */
  0x8001,   /* U+3F28 */
  0x8002,   /* U+3F29 */
  0x8003,   /* U+3F2A */
  0x8000,   /* U+3F2B */
  0x8001,   /* U+3F2C */
  0x8002,   /* U+3F2D */
  0x8003,   /* U+3F2E */
  0x8004,   /* U+3F2F */
  0x8005,   /* U+3F30 */
  0x8006,   /* U+3F31 */
  0x8000,   /* U+3F32 */
  0x8001,   /* U+3F33 */
  0x8002,   /* U+3F34 */
  0x8003,   /* U+3F35 */
  0x8004,   /* U+3F36 */
  0x8005,   /* U+3F37 */
  0x8000,   /* U+3F38 */
  0x8001,   /* U+3F39 */
  0x8002,   /* U+3F3A */
  0x8000,   /* U+3F3B */
  0x8001,   /* U+3F3C */
  0x8002,   /* U+3F3D */
  0x8003,   /* U+3F3E */
  0x8000,   /* U+3F3F */
  0x8001,   /* U+3F40 */
  0x8002,   /* U+3F41 */
  0x8003,   /* U+3F42 */
  0x8004,   /* U+3F43 */
  0x8005,   /* U+3F44 */
  0x8006,   /* U+3F45 */
  0x8000,   /* U+3F46 */
  0x8001,   /* U+3F47 */
  0x8000,   /* U+3F48 */
  0x8001,   /* U+3F49 */
  0x8000,   /* U+3F4A */
  0x8000,   /* U+3F4B */
  0x8001,   /* U+3F4C */
  0x8000,   /* U+3F4D */
  0x8000,   /* U+3F4E */
  0x8000,   /* U+3F4F */
  0x8000,   /* U+3F50 */
  0x8000,   /* U+3F51 */
  0x8000,   /* U+3F52 */
  0x8000,   /* U+3F53 */
  0xBF54,   /* U+3F54 */
  0x8000,   /* U+3F55 */
  0x8001,   /* U+3F56 */
  0xBF57,   /* U+3F57 */
  0x8000,   /* U+3F58 */
  0x8001,   /* U+3F59 */
  0x8002,   /* U+3F5A */
  0x8000,   /* U+3F5B */
  0x8001,   /* U+3F5C */
  0x8000,   /* U+3F5D */
  0xBF5E,   /* U+3F5E */
  0x8000,   /* U+3F5F */
  0x8001,   /* U+3F60 */
  0x8000,   /* U+3F61 */
  0x8001,   /* U+3F62 */
  0x8002,   /* U+3F63 */
  0x8003,   /* U+3F64 */
  0x8000,   /* U+3F65 */
  0x8000,   /* U+3F66 */
  0x8001,   /* U+3F67 */
  0x8002,   /* U+3F68 */
  0x8000,   /* U+3F69 */
  0x8000,   /* U+3F6A */
  0x8000,   /* U+3F6B */
  0x8001,   /* U+3F6C */
  0x8000,   /* U+3F6D */
  0x8000,   /* U+3F6E */
  0x8000,   /* U+3F6F */
  0x8000,   /* U+3F70 */
  0x8000,   /* U+3F71 */
  0x8001,   /* U+3F72 */
  0x8000,   /* U+3F73 */
  0x8001,   /* U+3F74 */
  0x8002,   /* U+3F75 */
  0xBF76,   /* U+3F76 */
  0x8000,   /* U+3F77 */
  0x8001,   /* U+3F78 */
  0x8002,   /* U+3F79 */
  0x8003,   /* U+3F7A */
  0x8004,   /* U+3F7B */
  0x8005,   /* U+3F7C */
  0x8000,   /* U+3F7D */
  0x8001,   /* U+3F7E */
  0x8002,   /* U+3F7F */
  0x8003,   /* U+3F80 */
  0x8004,   /* U+3F81 */
  0x8005,   /* U+3F82 */
  0x8006,   /* U+3F83 */
  0x8007,   /* U+3F84 */
  0x8008,   /* U+3F85 */
  0x8009,   /* U+3F86 */
  0x800A,   /* U+3F87 */
  0x800B,   /* U+3F88 */
  0x800C,   /* U+3F89 */
  0x8000,   /* U+3F8A */
  0x8001,   /* U+3F8B */
  0x8002,   /* U+3F8C */
  0x8003,   /* U+3F8D */
  0x8004,   /* U+3F8E */
  0x8005,   /* U+3F8F */
  0x8006,   /* U+3F90 */
  0x8007,   /* U+3F91 */
  0x8008,   /* U+3F92 */
  0x8000,   /* U+3F93 */
  0x8001,   /* U+3F94 */
  0x8002,   /* U+3F95 */
  0x8003,   /* U+3F96 */
  0x8004,   /* U+3F97 */
  0x8005,   /* U+3F98 */
  0x8006,   /* U+3F99 */
  0x8007,   /* U+3F9A */
  0x8008,   /* U+3F9B */
  0x8009,   /* U+3F9C */
  0x800A,   /* U+3F9D */
  0x800B,   /* U+3F9E */
  0x800C,   /* U+3F9F */
  0x800D,   /* U+3FA0 */
  0x800E,   /* U+3FA1 */
  0x8000,   /* U+3FA2 */
  0x8001,   /* U+3FA3 */
  0x8002,   /* U+3FA4 */
  0x8003,   /* U+3FA5 */
  0x8004,   /* U+3FA6 */
  0x8005,   /* U+3FA7 */
  0x8006,   /* U+3FA8 */
  0x8007,   /* U+3FA9 */
  0x8000,   /* U+3FAA */
  0x8001,   /* U+3FAB */
  0x8002,   /* U+3FAC */
  0x8003,   /* U+3FAD */
  0x8004,   /* U+3FAE */
  0x8005,   /* U+3FAF */
  0x8006,   /* U+3FB0 */
  0xBFB1,   /* U+3FB1 */
  0x8007,   /* U+3FB2 */
  0xBFB3,   /* U+3FB3 */
  0x8008,   /* U+3FB4 */
  0x8009,   /* U+3FB5 */
  0x8000,   /* U+3FB6 */
  0x8001,   /* U+3FB7 */
  0x8002,   /* U+3FB8 */
  0x8003,   /* U+3FB9 */
  0x8004,   /* U+3FBA */
  0x8005,   /* U+3FBB */
  0x8006,   /* U+3FBC */
  0x8007,   /* U+3FBD */
  0x8008,   /* U+3FBE */
  0x8009,   /* U+3FBF */
  0x800A,   /* U+3FC0 */
  0x800B,   /* U+3FC1 */
  0x8000,   /* U+3FC2 */
  0x8001,   /* U+3FC3 */
  0x8002,   /* U+3FC4 */
  0x8003,   /* U+3FC5 */
  0x8004,   /* U+3FC6 */
  0x8005,   /* U+3FC7 */
  0x8006,   /* U+3FC8 */
  0x8000,   /* U+3FC9 */
  0x8001,   /* U+3FCA */
  0x8000,   /* U+3FCB */
  0x8001,   /* U+3FCC */
  0x8002,   /* U+3FCD */
  0x8003,   /* U+3FCE */
  0x8004,   /* U+3FCF */
  0xBFD0,   /* U+3FD0 */
  0x8000,   /* U+3FD1 */
  0x8001,   /* U+3FD2 */
  0x8002,   /* U+3FD3 */
  0x8000,   /* U+3FD4 */
  0x8000,   /* U+3FD5 */
  0x8001,   /* U+3FD6 */
  0x8002,   /* U+3FD7 */
  0x8000,   /* U+3FD8 */
  0x8000,   /* U+3FD9 */
  0x8000,   /* U+3FDA */
  0x8001,   /* U+3FDB */
  0x8000,   /* U+3FDC */
  0x8000,   /* U+3FDD */
  0x8000,   /* U+3FDE */
  0x8000,   /* U+3FDF */
  0x8000,   /* U+3FE0 */
  0x8001,   /* U+3FE1 */
  0x8000,   /* U+3FE2 */
  0x8000,   /* U+3FE3 */
  0x8001,   /* U+3FE4 */
  0x8000,   /* U+3FE5 */
  0x8000,   /* U+3FE6 */
  0x8000,   /* U+3FE7 */
  0x8000,   /* U+3FE8 */
  0x8001,   /* U+3FE9 */
  0x8000,   /* U+3FEA */
  0x8000,   /* U+3FEB */
  0x8001,   /* U+3FEC */
  0x8000,   /* U+3FED */
  0x8001,   /* U+3FEE */
  0x8000,   /* U+3FEF */
  0x8001,   /* U+3FF0 */
  0x8000,   /* U+3FF1 */
  0x8000,   /* U+3FF2 */
  0x8001,   /* U+3FF3 */
  0x8000,   /* U+3FF4 */
  0x8001,   /* U+3FF5 */
  0x8000,   /* U+3FF6 */
  0x8001,   /* U+3FF7 */
  0x8000,   /* U+3FF8 */
  0x8000,   /* U+3FF9 */
  0x8000,   /* U+3FFA */
  0x8000,   /* U+3FFB */
  0x8000,   /* U+3FFC */
  0x8001,   /* U+3FFD */
  0x8000,   /* U+3FFE */
  0x8001,   /* U+3FFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+3F00 */
  0x0000,   /* U+3F01 */
  0x0000,   /* U+3F02 */
  0x0000,   /* U+3F03 */
  0x0000,   /* U+3F04 */
  0x0000,   /* U+3F05 */
  0x0000,   /* U+3F06 */
  0x0000,   /* U+3F07 */
  0x0000,   /* U+3F08 */
  0x0000,   /* U+3F09 */
  0x0000,   /* U+3F0A */
  0x0000,   /* U+3F0B */
  0x0000,   /* U+3F0C */
  0x0000,   /* U+3F0D */
  0x0000,   /* U+3F0E */
  0x0000,   /* U+3F0F */
  0x0000,   /* U+3F10 */
  0x0000,   /* U+3F11 */
  0x0000,   /* U+3F12 */
  0x0000,   /* U+3F13 */
  0x0000,   /* U+3F14 */
  0x0000,   /* U+3F15 */
  0x0000,   /* U+3F16 */
  0x0000,   /* U+3F17 */
  0x0000,   /* U+3F18 */
  0x0000,   /* U+3F19 */
  0x0000,   /* U+3F1A */
  0x0000,   /* U+3F1B */
  0x0000,   /* U+3F1C */
  0x0000,   /* U+3F1D */
  0x0000,   /* U+3F1E */
  0x0000,   /* U+3F1F */
  0x0000,   /* U+3F20 */
  0x0000,   /* U+3F21 */
  0x0000,   /* U+3F22 */
  0x0000,   /* U+3F23 */
  0x0000,   /* U+3F24 */
  0x0000,   /* U+3F25 */
  0x0000,   /* U+3F26 */
  0x0000,   /* U+3F27 */
  0x0000,   /* U+3F28 */
  0x0000,   /* U+3F29 */
  0x0000,   /* U+3F2A */
  0x0000,   /* U+3F2B */
  0x0000,   /* U+3F2C */
  0x0000,   /* U+3F2D */
  0x0000,   /* U+3F2E */
  0x0000,   /* U+3F2F */
  0x0000,   /* U+3F30 */
  0x0000,   /* U+3F31 */
  0x0000,   /* U+3F32 */
  0x0000,   /* U+3F33 */
  0x0000,   /* U+3F34 */
  0x0000,   /* U+3F35 */
  0x0000,   /* U+3F36 */
  0x0000,   /* U+3F37 */
  0x0000,   /* U+3F38 */
  0x0000,   /* U+3F39 */
  0x0000,   /* U+3F3A */
  0x0000,   /* U+3F3B */
  0x0000,   /* U+3F3C */
  0x0000,   /* U+3F3D */
  0x0000,   /* U+3F3E */
  0x0000,   /* U+3F3F */
  0x0000,   /* U+3F40 */
  0x0000,   /* U+3F41 */
  0x0000,   /* U+3F42 */
  0x0000,   /* U+3F43 */
  0x0000,   /* U+3F44 */
  0x0000,   /* U+3F45 */
  0x0000,   /* U+3F46 */
  0x0000,   /* U+3F47 */
  0x0000,   /* U+3F48 */
  0x0000,   /* U+3F49 */
  0x0000,   /* U+3F4A */
  0x0000,   /* U+3F4B */
  0x0000,   /* U+3F4C */
  0x0000,   /* U+3F4D */
  0x0000,   /* U+3F4E */
  0x0000,   /* U+3F4F */
  0x0000,   /* U+3F50 */
  0x0000,   /* U+3F51 */
  0x0000,   /* U+3F52 */
  0x0000,   /* U+3F53 */
  0x0000,   /* U+3F54 */
  0x0000,   /* U+3F55 */
  0x0000,   /* U+3F56 */
  0x0000,   /* U+3F57 */
  0x0000,   /* U+3F58 */
  0x0000,   /* U+3F59 */
  0x0000,   /* U+3F5A */
  0x0000,   /* U+3F5B */
  0x0000,   /* U+3F5C */
  0x0000,   /* U+3F5D */
  0x0000,   /* U+3F5E */
  0x0000,   /* U+3F5F */
  0x0000,   /* U+3F60 */
  0x0000,   /* U+3F61 */
  0x0000,   /* U+3F62 */
  0x0000,   /* U+3F63 */
  0x0000,   /* U+3F64 */
  0x0000,   /* U+3F65 */
  0x0000,   /* U+3F66 */
  0x0000,   /* U+3F67 */
  0x0000,   /* U+3F68 */
  0x0000,   /* U+3F69 */
  0x0000,   /* U+3F6A */
  0x0000,   /* U+3F6B */
  0x0000,   /* U+3F6C */
  0x0000,   /* U+3F6D */
  0x0000,   /* U+3F6E */
  0x0000,   /* U+3F6F */
  0x0000,   /* U+3F70 */
  0x0000,   /* U+3F71 */
  0x0000,   /* U+3F72 */
  0x0000,   /* U+3F73 */
  0x0000,   /* U+3F74 */
  0x0000,   /* U+3F75 */
  0x0000,   /* U+3F76 */
  0x0000,   /* U+3F77 */
  0x0000,   /* U+3F78 */
  0x0000,   /* U+3F79 */
  0x0000,   /* U+3F7A */
  0x0000,   /* U+3F7B */
  0x0000,   /* U+3F7C */
  0x0000,   /* U+3F7D */
  0x0000,   /* U+3F7E */
  0x0000,   /* U+3F7F */
  0x0000,   /* U+3F80 */
  0x0000,   /* U+3F81 */
  0x0000,   /* U+3F82 */
  0x0000,   /* U+3F83 */
  0x0000,   /* U+3F84 */
  0x0000,   /* U+3F85 */
  0x0000,   /* U+3F86 */
  0x0000,   /* U+3F87 */
  0x0000,   /* U+3F88 */
  0x0000,   /* U+3F89 */
  0x0000,   /* U+3F8A */
  0x0000,   /* U+3F8B */
  0x0000,   /* U+3F8C */
  0x0000,   /* U+3F8D */
  0x0000,   /* U+3F8E */
  0x0000,   /* U+3F8F */
  0x0000,   /* U+3F90 */
  0x0000,   /* U+3F91 */
  0x0000,   /* U+3F92 */
  0x0000,   /* U+3F93 */
  0x0000,   /* U+3F94 */
  0x0000,   /* U+3F95 */
  0x0000,   /* U+3F96 */
  0x0000,   /* U+3F97 */
  0x0000,   /* U+3F98 */
  0x0000,   /* U+3F99 */
  0x0000,   /* U+3F9A */
  0x0000,   /* U+3F9B */
  0x0000,   /* U+3F9C */
  0x0000,   /* U+3F9D */
  0x0000,   /* U+3F9E */
  0x0000,   /* U+3F9F */
  0x0000,   /* U+3FA0 */
  0x0000,   /* U+3FA1 */
  0x0000,   /* U+3FA2 */
  0x0000,   /* U+3FA3 */
  0x0000,   /* U+3FA4 */
  0x0000,   /* U+3FA5 */
  0x0000,   /* U+3FA6 */
  0x0000,   /* U+3FA7 */
  0x0000,   /* U+3FA8 */
  0x0000,   /* U+3FA9 */
  0x0000,   /* U+3FAA */
  0x0000,   /* U+3FAB */
  0x0000,   /* U+3FAC */
  0x0000,   /* U+3FAD */
  0x0000,   /* U+3FAE */
  0x0000,   /* U+3FAF */
  0x0000,   /* U+3FB0 */
  0x0000,   /* U+3FB1 */
  0x0000,   /* U+3FB2 */
  0x0000,   /* U+3FB3 */
  0x0000,   /* U+3FB4 */
  0x0000,   /* U+3FB5 */
  0x0000,   /* U+3FB6 */
  0x0000,   /* U+3FB7 */
  0x0000,   /* U+3FB8 */
  0x0000,   /* U+3FB9 */
  0x0000,   /* U+3FBA */
  0x0000,   /* U+3FBB */
  0x0000,   /* U+3FBC */
  0x0000,   /* U+3FBD */
  0x0000,   /* U+3FBE */
  0x0000,   /* U+3FBF */
  0x0000,   /* U+3FC0 */
  0x0000,   /* U+3FC1 */
  0x0000,   /* U+3FC2 */
  0x0000,   /* U+3FC3 */
  0x0000,   /* U+3FC4 */
  0x0000,   /* U+3FC5 */
  0x0000,   /* U+3FC6 */
  0x0000,   /* U+3FC7 */
  0x0000,   /* U+3FC8 */
  0x0000,   /* U+3FC9 */
  0x0000,   /* U+3FCA */
  0x0000,   /* U+3FCB */
  0x0000,   /* U+3FCC */
  0x0000,   /* U+3FCD */
  0x0000,   /* U+3FCE */
  0x0000,   /* U+3FCF */
  0x0000,   /* U+3FD0 */
  0x0000,   /* U+3FD1 */
  0x0000,   /* U+3FD2 */
  0x0000,   /* U+3FD3 */
  0x0000,   /* U+3FD4 */
  0x0000,   /* U+3FD5 */
  0x0000,   /* U+3FD6 */
  0x0000,   /* U+3FD7 */
  0x0000,   /* U+3FD8 */
  0x0000,   /* U+3FD9 */
  0x0000,   /* U+3FDA */
  0x0000,   /* U+3FDB */
  0x0000,   /* U+3FDC */
  0x0000,   /* U+3FDD */
  0x0000,   /* U+3FDE */
  0x0000,   /* U+3FDF */
  0x0000,   /* U+3FE0 */
  0x0000,   /* U+3FE1 */
  0x0000,   /* U+3FE2 */
  0x0000,   /* U+3FE3 */
  0x0000,   /* U+3FE4 */
  0x0000,   /* U+3FE5 */
  0x0000,   /* U+3FE6 */
  0x0000,   /* U+3FE7 */
  0x0000,   /* U+3FE8 */
  0x0000,   /* U+3FE9 */
  0x0000,   /* U+3FEA */
  0x0000,   /* U+3FEB */
  0x0000,   /* U+3FEC */
  0x0000,   /* U+3FED */
  0x0000,   /* U+3FEE */
  0x0000,   /* U+3FEF */
  0x0000,   /* U+3FF0 */
  0x0000,   /* U+3FF1 */
  0x0000,   /* U+3FF2 */
  0x0000,   /* U+3FF3 */
  0x0000,   /* U+3FF4 */
  0x0000,   /* U+3FF5 */
  0x0000,   /* U+3FF6 */
  0x0000,   /* U+3FF7 */
  0x0000,   /* U+3FF8 */
  0x0000,   /* U+3FF9 */
  0x0000,   /* U+3FFA */
  0x0000,   /* U+3FFB */
  0x0000,   /* U+3FFC */
  0x0000,   /* U+3FFD */
  0x0000,   /* U+3FFE */
  0x0000,   /* U+3FFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+3F00 */
  0x0000,   /* U+3F01 */
  0x0000,   /* U+3F02 */
  0x0000,   /* U+3F03 */
  0x0000,   /* U+3F04 */
  0x0000,   /* U+3F05 */
  0x0000,   /* U+3F06 */
  0x0000,   /* U+3F07 */
  0x0000,   /* U+3F08 */
  0x0000,   /* U+3F09 */
  0x0000,   /* U+3F0A */
  0x0000,   /* U+3F0B */
  0x0000,   /* U+3F0C */
  0x0000,   /* U+3F0D */
  0x0000,   /* U+3F0E */
  0x0000,   /* U+3F0F */
  0x0000,   /* U+3F10 */
  0x0000,   /* U+3F11 */
  0x0000,   /* U+3F12 */
  0x0000,   /* U+3F13 */
  0x0000,   /* U+3F14 */
  0x0000,   /* U+3F15 */
  0x0000,   /* U+3F16 */
  0x0000,   /* U+3F17 */
  0x0000,   /* U+3F18 */
  0x0000,   /* U+3F19 */
  0x0000,   /* U+3F1A */
  0x0000,   /* U+3F1B */
  0x0000,   /* U+3F1C */
  0x0000,   /* U+3F1D */
  0x0000,   /* U+3F1E */
  0x0000,   /* U+3F1F */
  0x0000,   /* U+3F20 */
  0x0000,   /* U+3F21 */
  0x0000,   /* U+3F22 */
  0x0000,   /* U+3F23 */
  0x0000,   /* U+3F24 */
  0x0000,   /* U+3F25 */
  0x0000,   /* U+3F26 */
  0x0000,   /* U+3F27 */
  0x0000,   /* U+3F28 */
  0x0000,   /* U+3F29 */
  0x0000,   /* U+3F2A */
  0x0000,   /* U+3F2B */
  0x0000,   /* U+3F2C */
  0x0000,   /* U+3F2D */
  0x0000,   /* U+3F2E */
  0x0000,   /* U+3F2F */
  0x0000,   /* U+3F30 */
  0x0000,   /* U+3F31 */
  0x0000,   /* U+3F32 */
  0x0000,   /* U+3F33 */
  0x0000,   /* U+3F34 */
  0x0000,   /* U+3F35 */
  0x0000,   /* U+3F36 */
  0x0000,   /* U+3F37 */
  0x0000,   /* U+3F38 */
  0x0000,   /* U+3F39 */
  0x0000,   /* U+3F3A */
  0x0000,   /* U+3F3B */
  0x0000,   /* U+3F3C */
  0x0000,   /* U+3F3D */
  0x0000,   /* U+3F3E */
  0x0000,   /* U+3F3F */
  0x0000,   /* U+3F40 */
  0x0000,   /* U+3F41 */
  0x0000,   /* U+3F42 */
  0x0000,   /* U+3F43 */
  0x0000,   /* U+3F44 */
  0x0000,   /* U+3F45 */
  0x0000,   /* U+3F46 */
  0x0000,   /* U+3F47 */
  0x0000,   /* U+3F48 */
  0x0000,   /* U+3F49 */
  0x0000,   /* U+3F4A */
  0x0000,   /* U+3F4B */
  0x0000,   /* U+3F4C */
  0x0000,   /* U+3F4D */
  0x0000,   /* U+3F4E */
  0x0000,   /* U+3F4F */
  0x0000,   /* U+3F50 */
  0x0000,   /* U+3F51 */
  0x0000,   /* U+3F52 */
  0x0000,   /* U+3F53 */
  0x0000,   /* U+3F54 */
  0x0000,   /* U+3F55 */
  0x0000,   /* U+3F56 */
  0x0000,   /* U+3F57 */
  0x0000,   /* U+3F58 */
  0x0000,   /* U+3F59 */
  0x0000,   /* U+3F5A */
  0x0000,   /* U+3F5B */
  0x0000,   /* U+3F5C */
  0x0000,   /* U+3F5D */
  0x0000,   /* U+3F5E */
  0x0000,   /* U+3F5F */
  0x0000,   /* U+3F60 */
  0x0000,   /* U+3F61 */
  0x0000,   /* U+3F62 */
  0x0000,   /* U+3F63 */
  0x0000,   /* U+3F64 */
  0x0000,   /* U+3F65 */
  0x0000,   /* U+3F66 */
  0x0000,   /* U+3F67 */
  0x0000,   /* U+3F68 */
  0x0000,   /* U+3F69 */
  0x0000,   /* U+3F6A */
  0x0000,   /* U+3F6B */
  0x0000,   /* U+3F6C */
  0x0000,   /* U+3F6D */
  0x0000,   /* U+3F6E */
  0x0000,   /* U+3F6F */
  0x0000,   /* U+3F70 */
  0x0000,   /* U+3F71 */
  0x0000,   /* U+3F72 */
  0x0000,   /* U+3F73 */
  0x0000,   /* U+3F74 */
  0x0000,   /* U+3F75 */
  0x0000,   /* U+3F76 */
  0x0000,   /* U+3F77 */
  0x0000,   /* U+3F78 */
  0x0000,   /* U+3F79 */
  0x0000,   /* U+3F7A */
  0x0000,   /* U+3F7B */
  0x0000,   /* U+3F7C */
  0x0000,   /* U+3F7D */
  0x0000,   /* U+3F7E */
  0x0000,   /* U+3F7F */
  0x0000,   /* U+3F80 */
  0x0000,   /* U+3F81 */
  0x0000,   /* U+3F82 */
  0x0000,   /* U+3F83 */
  0x0000,   /* U+3F84 */
  0x0000,   /* U+3F85 */
  0x0000,   /* U+3F86 */
  0x0000,   /* U+3F87 */
  0x0000,   /* U+3F88 */
  0x0000,   /* U+3F89 */
  0x0000,   /* U+3F8A */
  0x0000,   /* U+3F8B */
  0x0000,   /* U+3F8C */
  0x0000,   /* U+3F8D */
  0x0000,   /* U+3F8E */
  0x0000,   /* U+3F8F */
  0x0000,   /* U+3F90 */
  0x0000,   /* U+3F91 */
  0x0000,   /* U+3F92 */
  0x0000,   /* U+3F93 */
  0x0000,   /* U+3F94 */
  0x0000,   /* U+3F95 */
  0x0000,   /* U+3F96 */
  0x0000,   /* U+3F97 */
  0x0000,   /* U+3F98 */
  0x0000,   /* U+3F99 */
  0x0000,   /* U+3F9A */
  0x0000,   /* U+3F9B */
  0x0000,   /* U+3F9C */
  0x0000,   /* U+3F9D */
  0x0000,   /* U+3F9E */
  0x0000,   /* U+3F9F */
  0x0000,   /* U+3FA0 */
  0x0000,   /* U+3FA1 */
  0x0000,   /* U+3FA2 */
  0x0000,   /* U+3FA3 */
  0x0000,   /* U+3FA4 */
  0x0000,   /* U+3FA5 */
  0x0000,   /* U+3FA6 */
  0x0000,   /* U+3FA7 */
  0x0000,   /* U+3FA8 */
  0x0000,   /* U+3FA9 */
  0x0000,   /* U+3FAA */
  0x0000,   /* U+3FAB */
  0x0000,   /* U+3FAC */
  0x0000,   /* U+3FAD */
  0x0000,   /* U+3FAE */
  0x0000,   /* U+3FAF */
  0x0000,   /* U+3FB0 */
  0x0000,   /* U+3FB1 */
  0x0000,   /* U+3FB2 */
  0x0000,   /* U+3FB3 */
  0x0000,   /* U+3FB4 */
  0x0000,   /* U+3FB5 */
  0x0000,   /* U+3FB6 */
  0x0000,   /* U+3FB7 */
  0x0000,   /* U+3FB8 */
  0x0000,   /* U+3FB9 */
  0x0000,   /* U+3FBA */
  0x0000,   /* U+3FBB */
  0x0000,   /* U+3FBC */
  0x0000,   /* U+3FBD */
  0x0000,   /* U+3FBE */
  0x0000,   /* U+3FBF */
  0x0000,   /* U+3FC0 */
  0x0000,   /* U+3FC1 */
  0x0000,   /* U+3FC2 */
  0x0000,   /* U+3FC3 */
  0x0000,   /* U+3FC4 */
  0x0000,   /* U+3FC5 */
  0x0000,   /* U+3FC6 */
  0x0000,   /* U+3FC7 */
  0x0000,   /* U+3FC8 */
  0x0000,   /* U+3FC9 */
  0x0000,   /* U+3FCA */
  0x0000,   /* U+3FCB */
  0x0000,   /* U+3FCC */
  0x0000,   /* U+3FCD */
  0x0000,   /* U+3FCE */
  0x0000,   /* U+3FCF */
  0x0000,   /* U+3FD0 */
  0x0000,   /* U+3FD1 */
  0x0000,   /* U+3FD2 */
  0x0000,   /* U+3FD3 */
  0x0000,   /* U+3FD4 */
  0x0000,   /* U+3FD5 */
  0x0000,   /* U+3FD6 */
  0x0000,   /* U+3FD7 */
  0x0000,   /* U+3FD8 */
  0x0000,   /* U+3FD9 */
  0x0000,   /* U+3FDA */
  0x0000,   /* U+3FDB */
  0x0000,   /* U+3FDC */
  0x0000,   /* U+3FDD */
  0x0000,   /* U+3FDE */
  0x0000,   /* U+3FDF */
  0x0000,   /* U+3FE0 */
  0x0000,   /* U+3FE1 */
  0x0000,   /* U+3FE2 */
  0x0000,   /* U+3FE3 */
  0x0000,   /* U+3FE4 */
  0x0000,   /* U+3FE5 */
  0x0000,   /* U+3FE6 */
  0x0000,   /* U+3FE7 */
  0x0000,   /* U+3FE8 */
  0x0000,   /* U+3FE9 */
  0x0000,   /* U+3FEA */
  0x0000,   /* U+3FEB */
  0x0000,   /* U+3FEC */
  0x0000,   /* U+3FED */
  0x0000,   /* U+3FEE */
  0x0000,   /* U+3FEF */
  0x0000,   /* U+3FF0 */
  0x0000,   /* U+3FF1 */
  0x0000,   /* U+3FF2 */
  0x0000,   /* U+3FF3 */
  0x0000,   /* U+3FF4 */
  0x0000,   /* U+3FF5 */
  0x0000,   /* U+3FF6 */
  0x0000,   /* U+3FF7 */
  0x0000,   /* U+3FF8 */
  0x0000,   /* U+3FF9 */
  0x0000,   /* U+3FFA */
  0x0000,   /* U+3FFB */
  0x0000,   /* U+3FFC */
  0x0000,   /* U+3FFD */
  0x0000,   /* U+3FFE */
  0x0000,   /* U+3FFF */
};

uint16 zh2_han_p040[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x3751,   /* U+4000 */
  0x3752,   /* U+4001 */
  0x3752,   /* U+4002 */
  0x3753,   /* U+4003 */
  0x3754,   /* U+4004 */
  0x3754,   /* U+4005 */
  0x3755,   /* U+4006 */
  0x3757,   /* U+4007 */
  0x3757,   /* U+4008 */
  0x3758,   /* U+4009 */
  0x375A,   /* U+400A */
  0x5C49,   /* U+400B */
  0x5C49,   /* U+400C */
  0x3764,   /* U+400D */
  0x378E,   /* U+400E */
  0x378E,   /* U+400F */
  0x378F,   /* U+4010 */
  0x378F,   /* U+4011 */
  0x378F,   /* U+4012 */
  0x378F,   /* U+4013 */
  0x378F,   /* U+4014 */
  0x3790,   /* U+4015 */
  0x3790,   /* U+4016 */
  0x3790,   /* U+4017 */
  0x3790,   /* U+4018 */
  0x3790,   /* U+4019 */
  0x3790,   /* U+401A */
  0x3790,   /* U+401B */
  0x3790,   /* U+401C */
  0x3790,   /* U+401D */
  0x3790,   /* U+401E */
  0x3791,   /* U+401F */
  0x3791,   /* U+4020 */
  0x3791,   /* U+4021 */
  0x3791,   /* U+4022 */
  0x3791,   /* U+4023 */
  0x3791,   /* U+4024 */
  0x3791,   /* U+4025 */
  0x3791,   /* U+4026 */
  0x3792,   /* U+4027 */
  0x3792,   /* U+4028 */
  0x3792,   /* U+4029 */
  0x3792,   /* U+402A */
  0x3792,   /* U+402B */
  0x3792,   /* U+402C */
  0x3792,   /* U+402D */
  0x3792,   /* U+402E */
  0x3793,   /* U+402F */
  0x3793,   /* U+4030 */
  0x3793,   /* U+4031 */
  0x3793,   /* U+4032 */
  0x3793,   /* U+4033 */
  0x3793,   /* U+4034 */
  0x3793,   /* U+4035 */
  0x3793,   /* U+4036 */
  0x3793,   /* U+4037 */
  0x3793,   /* U+4038 */
  0x3793,   /* U+4039 */
  0x3793,   /* U+403A */
  0x3793,   /* U+403B */
  0x3793,   /* U+403C */
  0x3793,   /* U+403D */
  0x3793,   /* U+403E */
  0x3793,   /* U+403F */
  0x5C49,   /* U+4040 */
  0x3794,   /* U+4041 */
  0x3794,   /* U+4042 */
  0x3794,   /* U+4043 */
  0x3794,   /* U+4044 */
  0x3794,   /* U+4045 */
  0x3794,   /* U+4046 */
  0x3794,   /* U+4047 */
  0x3794,   /* U+4048 */
  0x3794,   /* U+4049 */
  0x3795,   /* U+404A */
  0x3795,   /* U+404B */
  0x3795,   /* U+404C */
  0x3795,   /* U+404D */
  0x3795,   /* U+404E */
  0x3795,   /* U+404F */
  0x3795,   /* U+4050 */
  0x3795,   /* U+4051 */
  0x3795,   /* U+4052 */
  0x3795,   /* U+4053 */
  0x3795,   /* U+4054 */
  0x3795,   /* U+4055 */
  0x3795,   /* U+4056 */
  0x378D,   /* U+4057 */
  0x378D,   /* U+4058 */
  0x378D,   /* U+4059 */
  0x378D,   /* U+405A */
  0x378D,   /* U+405B */
  0x378D,   /* U+405C */
  0x378D,   /* U+405D */
  0x378D,   /* U+405E */
  0x378D,   /* U+405F */
  0x378D,   /* U+4060 */
  0x5C49,   /* U+4061 */
  0x3797,   /* U+4062 */
  0x3797,   /* U+4063 */
  0x3797,   /* U+4064 */
  0x3797,   /* U+4065 */
  0x3797,   /* U+4066 */
  0x3797,   /* U+4067 */
  0x3797,   /* U+4068 */
  0x3797,   /* U+4069 */
  0x3797,   /* U+406A */
  0x3798,   /* U+406B */
  0x3798,   /* U+406C */
  0x3798,   /* U+406D */
  0x3798,   /* U+406E */
  0x3798,   /* U+406F */
  0x3798,   /* U+4070 */
  0x3798,   /* U+4071 */
  0x3798,   /* U+4072 */
  0x3798,   /* U+4073 */
  0x3799,   /* U+4074 */
  0x3799,   /* U+4075 */
  0x3799,   /* U+4076 */
  0x3799,   /* U+4077 */
  0x3799,   /* U+4078 */
  0x3799,   /* U+4079 */
  0x3799,   /* U+407A */
  0x379B,   /* U+407B */
  0x379B,   /* U+407C */
  0x379B,   /* U+407D */
  0x379B,   /* U+407E */
  0x379C,   /* U+407F */
  0x379C,   /* U+4080 */
  0x379D,   /* U+4081 */
  0x379E,   /* U+4082 */
  0x379E,   /* U+4083 */
  0x378E,   /* U+4084 */
  0x37A5,   /* U+4085 */
  0x37CF,   /* U+4086 */
  0x37D0,   /* U+4087 */
  0x37D2,   /* U+4088 */
  0x37D5,   /* U+4089 */
  0x37D8,   /* U+408A */
  0x37D8,   /* U+408B */
  0x37D8,   /* U+408C */
  0x37DB,   /* U+408D */
  0x37DF,   /* U+408E */
  0x3811,   /* U+408F */
  0x3811,   /* U+4090 */
  0x3812,   /* U+4091 */
  0x3812,   /* U+4092 */
  0x3813,   /* U+4093 */
  0x3814,   /* U+4094 */
  0x3815,   /* U+4095 */
  0x384D,   /* U+4096 */
  0x384E,   /* U+4097 */
  0x384F,   /* U+4098 */
  0x384F,   /* U+4099 */
  0x3850,   /* U+409A */
  0x3850,   /* U+409B */
  0x3850,   /* U+409C */
  0x3850,   /* U+409D */
  0x3850,   /* U+409E */
  0x3851,   /* U+409F */
  0x3851,   /* U+40A0 */
  0x3851,   /* U+40A1 */
  0x3851,   /* U+40A2 */
  0x3851,   /* U+40A3 */
  0x3851,   /* U+40A4 */
  0x3851,   /* U+40A5 */
  0x3851,   /* U+40A6 */
  0x3851,   /* U+40A7 */
  0x3851,   /* U+40A8 */
  0x3852,   /* U+40A9 */
  0x3852,   /* U+40AA */
  0x3852,   /* U+40AB */
  0x3852,   /* U+40AC */
  0x3852,   /* U+40AD */
  0x3852,   /* U+40AE */
  0x3852,   /* U+40AF */
  0x3853,   /* U+40B0 */
  0x3853,   /* U+40B1 */
  0x3853,   /* U+40B2 */
  0x3853,   /* U+40B3 */
  0x3853,   /* U+40B4 */
  0x3853,   /* U+40B5 */
  0x3853,   /* U+40B6 */
  0x3854,   /* U+40B7 */
  0x3854,   /* U+40B8 */
  0x3854,   /* U+40B9 */
  0x3854,   /* U+40BA */
  0x3854,   /* U+40BB */
  0x3854,   /* U+40BC */
  0x3854,   /* U+40BD */
  0x3854,   /* U+40BE */
  0x3854,   /* U+40BF */
  0x3854,   /* U+40C0 */
  0x3854,   /* U+40C1 */
  0x3854,   /* U+40C2 */
  0x5C49,   /* U+40C3 */
  0x3854,   /* U+40C4 */
  0x3854,   /* U+40C5 */
  0x5C49,   /* U+40C6 */
  0x3854,   /* U+40C7 */
  0x3855,   /* U+40C8 */
  0x3855,   /* U+40C9 */
  0x3855,   /* U+40CA */
  0x3855,   /* U+40CB */
  0x3855,   /* U+40CC */
  0x3855,   /* U+40CD */
  0x3855,   /* U+40CE */
  0x3855,   /* U+40CF */
  0x5C49,   /* U+40D0 */
  0x384D,   /* U+40D1 */
  0x384D,   /* U+40D2 */
  0x384D,   /* U+40D3 */
  0x384D,   /* U+40D4 */
  0x384D,   /* U+40D5 */
  0x384D,   /* U+40D6 */
  0x384D,   /* U+40D7 */
  0x3857,   /* U+40D8 */
  0x3857,   /* U+40D9 */
  0x3857,   /* U+40DA */
  0x3857,   /* U+40DB */
  0x3857,   /* U+40DC */
  0x3857,   /* U+40DD */
  0x3857,   /* U+40DE */
  0x3858,   /* U+40DF */
  0x3857,   /* U+40E0 */
  0x3858,   /* U+40E1 */
  0x3858,   /* U+40E2 */
  0x3858,   /* U+40E3 */
  0x3858,   /* U+40E4 */
  0x3858,   /* U+40E5 */
  0x3858,   /* U+40E6 */
  0x3858,   /* U+40E7 */
  0x5C49,   /* U+40E8 */
  0x3859,   /* U+40E9 */
  0x3859,   /* U+40EA */
  0x3859,   /* U+40EB */
  0x3859,   /* U+40EC */
  0x3859,   /* U+40ED */
  0x3859,   /* U+40EE */
  0x5C49,   /* U+40EF */
  0x385A,   /* U+40F0 */
  0x385B,   /* U+40F1 */
  0x385B,   /* U+40F2 */
  0x385B,   /* U+40F3 */
  0x385C,   /* U+40F4 */
  0x385C,   /* U+40F5 */
  0x385C,   /* U+40F6 */
  0x385C,   /* U+40F7 */
  0x385D,   /* U+40F8 */
  0x385D,   /* U+40F9 */
  0x385F,   /* U+40FA */
  0x3861,   /* U+40FB */
  0x5C49,   /* U+40FC */
  0x3890,   /* U+40FD */
  0x3890,   /* U+40FE */
  0x3890,   /* U+40FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4000 */
  0x0020,   /* U+4001 */
  0x0020,   /* U+4002 */
  0x0020,   /* U+4003 */
  0x0020,   /* U+4004 */
  0x0020,   /* U+4005 */
  0x0020,   /* U+4006 */
  0x0020,   /* U+4007 */
  0x0020,   /* U+4008 */
  0x0020,   /* U+4009 */
  0x0020,   /* U+400A */
  0x0020,   /* U+400B */
  0x0020,   /* U+400C */
  0x0020,   /* U+400D */
  0x0020,   /* U+400E */
  0x0020,   /* U+400F */
  0x0020,   /* U+4010 */
  0x0020,   /* U+4011 */
  0x0020,   /* U+4012 */
  0x0020,   /* U+4013 */
  0x0020,   /* U+4014 */
  0x0020,   /* U+4015 */
  0x0020,   /* U+4016 */
  0x0020,   /* U+4017 */
  0x0020,   /* U+4018 */
  0x0020,   /* U+4019 */
  0x0020,   /* U+401A */
  0x0020,   /* U+401B */
  0x0020,   /* U+401C */
  0x0020,   /* U+401D */
  0x0020,   /* U+401E */
  0x0020,   /* U+401F */
  0x0020,   /* U+4020 */
  0x0020,   /* U+4021 */
  0x0020,   /* U+4022 */
  0x0020,   /* U+4023 */
  0x0020,   /* U+4024 */
  0x0020,   /* U+4025 */
  0x0020,   /* U+4026 */
  0x0020,   /* U+4027 */
  0x0020,   /* U+4028 */
  0x0020,   /* U+4029 */
  0x0020,   /* U+402A */
  0x0020,   /* U+402B */
  0x0020,   /* U+402C */
  0x0020,   /* U+402D */
  0x0020,   /* U+402E */
  0x0020,   /* U+402F */
  0x0020,   /* U+4030 */
  0x0020,   /* U+4031 */
  0x0020,   /* U+4032 */
  0x0020,   /* U+4033 */
  0x0020,   /* U+4034 */
  0x0020,   /* U+4035 */
  0x0020,   /* U+4036 */
  0x0020,   /* U+4037 */
  0x0020,   /* U+4038 */
  0x0020,   /* U+4039 */
  0x0020,   /* U+403A */
  0x0020,   /* U+403B */
  0x0020,   /* U+403C */
  0x0020,   /* U+403D */
  0x0020,   /* U+403E */
  0x0020,   /* U+403F */
  0x0020,   /* U+4040 */
  0x0020,   /* U+4041 */
  0x0020,   /* U+4042 */
  0x0020,   /* U+4043 */
  0x0020,   /* U+4044 */
  0x0020,   /* U+4045 */
  0x0020,   /* U+4046 */
  0x0020,   /* U+4047 */
  0x0020,   /* U+4048 */
  0x0020,   /* U+4049 */
  0x0020,   /* U+404A */
  0x0020,   /* U+404B */
  0x0020,   /* U+404C */
  0x0020,   /* U+404D */
  0x0020,   /* U+404E */
  0x0020,   /* U+404F */
  0x0020,   /* U+4050 */
  0x0020,   /* U+4051 */
  0x0020,   /* U+4052 */
  0x0020,   /* U+4053 */
  0x0020,   /* U+4054 */
  0x0020,   /* U+4055 */
  0x0020,   /* U+4056 */
  0x0020,   /* U+4057 */
  0x0020,   /* U+4058 */
  0x0020,   /* U+4059 */
  0x0020,   /* U+405A */
  0x0020,   /* U+405B */
  0x0020,   /* U+405C */
  0x0020,   /* U+405D */
  0x0020,   /* U+405E */
  0x0020,   /* U+405F */
  0x0020,   /* U+4060 */
  0x0020,   /* U+4061 */
  0x0020,   /* U+4062 */
  0x0020,   /* U+4063 */
  0x0020,   /* U+4064 */
  0x0020,   /* U+4065 */
  0x0020,   /* U+4066 */
  0x0020,   /* U+4067 */
  0x0020,   /* U+4068 */
  0x0020,   /* U+4069 */
  0x0020,   /* U+406A */
  0x0020,   /* U+406B */
  0x0020,   /* U+406C */
  0x0020,   /* U+406D */
  0x0020,   /* U+406E */
  0x0020,   /* U+406F */
  0x0020,   /* U+4070 */
  0x0020,   /* U+4071 */
  0x0020,   /* U+4072 */
  0x0020,   /* U+4073 */
  0x0020,   /* U+4074 */
  0x0020,   /* U+4075 */
  0x0020,   /* U+4076 */
  0x0020,   /* U+4077 */
  0x0020,   /* U+4078 */
  0x0020,   /* U+4079 */
  0x0020,   /* U+407A */
  0x0020,   /* U+407B */
  0x0020,   /* U+407C */
  0x0020,   /* U+407D */
  0x0020,   /* U+407E */
  0x0020,   /* U+407F */
  0x0020,   /* U+4080 */
  0x0020,   /* U+4081 */
  0x0020,   /* U+4082 */
  0x0020,   /* U+4083 */
  0x0020,   /* U+4084 */
  0x0020,   /* U+4085 */
  0x0020,   /* U+4086 */
  0x0020,   /* U+4087 */
  0x0020,   /* U+4088 */
  0x0020,   /* U+4089 */
  0x0020,   /* U+408A */
  0x0020,   /* U+408B */
  0x0020,   /* U+408C */
  0x0020,   /* U+408D */
  0x0020,   /* U+408E */
  0x0020,   /* U+408F */
  0x0020,   /* U+4090 */
  0x0020,   /* U+4091 */
  0x0020,   /* U+4092 */
  0x0020,   /* U+4093 */
  0x0020,   /* U+4094 */
  0x0020,   /* U+4095 */
  0x0020,   /* U+4096 */
  0x0020,   /* U+4097 */
  0x0020,   /* U+4098 */
  0x0020,   /* U+4099 */
  0x0020,   /* U+409A */
  0x0020,   /* U+409B */
  0x0020,   /* U+409C */
  0x0020,   /* U+409D */
  0x0020,   /* U+409E */
  0x0020,   /* U+409F */
  0x0020,   /* U+40A0 */
  0x0020,   /* U+40A1 */
  0x0020,   /* U+40A2 */
  0x0020,   /* U+40A3 */
  0x0020,   /* U+40A4 */
  0x0020,   /* U+40A5 */
  0x0020,   /* U+40A6 */
  0x0020,   /* U+40A7 */
  0x0020,   /* U+40A8 */
  0x0020,   /* U+40A9 */
  0x0020,   /* U+40AA */
  0x0020,   /* U+40AB */
  0x0020,   /* U+40AC */
  0x0020,   /* U+40AD */
  0x0020,   /* U+40AE */
  0x0020,   /* U+40AF */
  0x0020,   /* U+40B0 */
  0x0020,   /* U+40B1 */
  0x0020,   /* U+40B2 */
  0x0020,   /* U+40B3 */
  0x0020,   /* U+40B4 */
  0x0020,   /* U+40B5 */
  0x0020,   /* U+40B6 */
  0x0020,   /* U+40B7 */
  0x0020,   /* U+40B8 */
  0x0020,   /* U+40B9 */
  0x0020,   /* U+40BA */
  0x0020,   /* U+40BB */
  0x0020,   /* U+40BC */
  0x0020,   /* U+40BD */
  0x0020,   /* U+40BE */
  0x0020,   /* U+40BF */
  0x0020,   /* U+40C0 */
  0x0020,   /* U+40C1 */
  0x0020,   /* U+40C2 */
  0x0020,   /* U+40C3 */
  0x0020,   /* U+40C4 */
  0x0020,   /* U+40C5 */
  0x0020,   /* U+40C6 */
  0x0020,   /* U+40C7 */
  0x0020,   /* U+40C8 */
  0x0020,   /* U+40C9 */
  0x0020,   /* U+40CA */
  0x0020,   /* U+40CB */
  0x0020,   /* U+40CC */
  0x0020,   /* U+40CD */
  0x0020,   /* U+40CE */
  0x0020,   /* U+40CF */
  0x0020,   /* U+40D0 */
  0x0020,   /* U+40D1 */
  0x0020,   /* U+40D2 */
  0x0020,   /* U+40D3 */
  0x0020,   /* U+40D4 */
  0x0020,   /* U+40D5 */
  0x0020,   /* U+40D6 */
  0x0020,   /* U+40D7 */
  0x0020,   /* U+40D8 */
  0x0020,   /* U+40D9 */
  0x0020,   /* U+40DA */
  0x0020,   /* U+40DB */
  0x0020,   /* U+40DC */
  0x0020,   /* U+40DD */
  0x0020,   /* U+40DE */
  0x0020,   /* U+40DF */
  0x0020,   /* U+40E0 */
  0x0020,   /* U+40E1 */
  0x0020,   /* U+40E2 */
  0x0020,   /* U+40E3 */
  0x0020,   /* U+40E4 */
  0x0020,   /* U+40E5 */
  0x0020,   /* U+40E6 */
  0x0020,   /* U+40E7 */
  0x0020,   /* U+40E8 */
  0x0020,   /* U+40E9 */
  0x0020,   /* U+40EA */
  0x0020,   /* U+40EB */
  0x0020,   /* U+40EC */
  0x0020,   /* U+40ED */
  0x0020,   /* U+40EE */
  0x0020,   /* U+40EF */
  0x0020,   /* U+40F0 */
  0x0020,   /* U+40F1 */
  0x0020,   /* U+40F2 */
  0x0020,   /* U+40F3 */
  0x0020,   /* U+40F4 */
  0x0020,   /* U+40F5 */
  0x0020,   /* U+40F6 */
  0x0020,   /* U+40F7 */
  0x0020,   /* U+40F8 */
  0x0020,   /* U+40F9 */
  0x0020,   /* U+40FA */
  0x0020,   /* U+40FB */
  0x0020,   /* U+40FC */
  0x0020,   /* U+40FD */
  0x0020,   /* U+40FE */
  0x0020,   /* U+40FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4000 */
  0x0002,   /* U+4001 */
  0x0002,   /* U+4002 */
  0x0002,   /* U+4003 */
  0x0002,   /* U+4004 */
  0x0002,   /* U+4005 */
  0x0002,   /* U+4006 */
  0x0002,   /* U+4007 */
  0x0002,   /* U+4008 */
  0x0002,   /* U+4009 */
  0x0002,   /* U+400A */
  0x0002,   /* U+400B */
  0x0002,   /* U+400C */
  0x0002,   /* U+400D */
  0x0002,   /* U+400E */
  0x0002,   /* U+400F */
  0x0002,   /* U+4010 */
  0x0002,   /* U+4011 */
  0x0002,   /* U+4012 */
  0x0002,   /* U+4013 */
  0x0002,   /* U+4014 */
  0x0002,   /* U+4015 */
  0x0002,   /* U+4016 */
  0x0002,   /* U+4017 */
  0x0002,   /* U+4018 */
  0x0002,   /* U+4019 */
  0x0002,   /* U+401A */
  0x0002,   /* U+401B */
  0x0002,   /* U+401C */
  0x0002,   /* U+401D */
  0x0002,   /* U+401E */
  0x0002,   /* U+401F */
  0x0002,   /* U+4020 */
  0x0002,   /* U+4021 */
  0x0002,   /* U+4022 */
  0x0002,   /* U+4023 */
  0x0002,   /* U+4024 */
  0x0002,   /* U+4025 */
  0x0002,   /* U+4026 */
  0x0002,   /* U+4027 */
  0x0002,   /* U+4028 */
  0x0002,   /* U+4029 */
  0x0002,   /* U+402A */
  0x0002,   /* U+402B */
  0x0002,   /* U+402C */
  0x0002,   /* U+402D */
  0x0002,   /* U+402E */
  0x0002,   /* U+402F */
  0x0002,   /* U+4030 */
  0x0002,   /* U+4031 */
  0x0002,   /* U+4032 */
  0x0002,   /* U+4033 */
  0x0002,   /* U+4034 */
  0x0002,   /* U+4035 */
  0x0002,   /* U+4036 */
  0x0002,   /* U+4037 */
  0x0002,   /* U+4038 */
  0x0002,   /* U+4039 */
  0x0002,   /* U+403A */
  0x0002,   /* U+403B */
  0x0002,   /* U+403C */
  0x0002,   /* U+403D */
  0x0002,   /* U+403E */
  0x0002,   /* U+403F */
  0x0002,   /* U+4040 */
  0x0002,   /* U+4041 */
  0x0002,   /* U+4042 */
  0x0002,   /* U+4043 */
  0x0002,   /* U+4044 */
  0x0002,   /* U+4045 */
  0x0002,   /* U+4046 */
  0x0002,   /* U+4047 */
  0x0002,   /* U+4048 */
  0x0002,   /* U+4049 */
  0x0002,   /* U+404A */
  0x0002,   /* U+404B */
  0x0002,   /* U+404C */
  0x0002,   /* U+404D */
  0x0002,   /* U+404E */
  0x0002,   /* U+404F */
  0x0002,   /* U+4050 */
  0x0002,   /* U+4051 */
  0x0002,   /* U+4052 */
  0x0002,   /* U+4053 */
  0x0002,   /* U+4054 */
  0x0002,   /* U+4055 */
  0x0002,   /* U+4056 */
  0x0002,   /* U+4057 */
  0x0002,   /* U+4058 */
  0x0002,   /* U+4059 */
  0x0002,   /* U+405A */
  0x0002,   /* U+405B */
  0x0002,   /* U+405C */
  0x0002,   /* U+405D */
  0x0002,   /* U+405E */
  0x0002,   /* U+405F */
  0x0002,   /* U+4060 */
  0x0002,   /* U+4061 */
  0x0002,   /* U+4062 */
  0x0002,   /* U+4063 */
  0x0002,   /* U+4064 */
  0x0002,   /* U+4065 */
  0x0002,   /* U+4066 */
  0x0002,   /* U+4067 */
  0x0002,   /* U+4068 */
  0x0002,   /* U+4069 */
  0x0002,   /* U+406A */
  0x0002,   /* U+406B */
  0x0002,   /* U+406C */
  0x0002,   /* U+406D */
  0x0002,   /* U+406E */
  0x0002,   /* U+406F */
  0x0002,   /* U+4070 */
  0x0002,   /* U+4071 */
  0x0002,   /* U+4072 */
  0x0002,   /* U+4073 */
  0x0002,   /* U+4074 */
  0x0002,   /* U+4075 */
  0x0002,   /* U+4076 */
  0x0002,   /* U+4077 */
  0x0002,   /* U+4078 */
  0x0002,   /* U+4079 */
  0x0002,   /* U+407A */
  0x0002,   /* U+407B */
  0x0002,   /* U+407C */
  0x0002,   /* U+407D */
  0x0002,   /* U+407E */
  0x0002,   /* U+407F */
  0x0002,   /* U+4080 */
  0x0002,   /* U+4081 */
  0x0002,   /* U+4082 */
  0x0002,   /* U+4083 */
  0x0002,   /* U+4084 */
  0x0002,   /* U+4085 */
  0x0002,   /* U+4086 */
  0x0002,   /* U+4087 */
  0x0002,   /* U+4088 */
  0x0002,   /* U+4089 */
  0x0002,   /* U+408A */
  0x0002,   /* U+408B */
  0x0002,   /* U+408C */
  0x0002,   /* U+408D */
  0x0002,   /* U+408E */
  0x0002,   /* U+408F */
  0x0002,   /* U+4090 */
  0x0002,   /* U+4091 */
  0x0002,   /* U+4092 */
  0x0002,   /* U+4093 */
  0x0002,   /* U+4094 */
  0x0002,   /* U+4095 */
  0x0002,   /* U+4096 */
  0x0002,   /* U+4097 */
  0x0002,   /* U+4098 */
  0x0002,   /* U+4099 */
  0x0002,   /* U+409A */
  0x0002,   /* U+409B */
  0x0002,   /* U+409C */
  0x0002,   /* U+409D */
  0x0002,   /* U+409E */
  0x0002,   /* U+409F */
  0x0002,   /* U+40A0 */
  0x0002,   /* U+40A1 */
  0x0002,   /* U+40A2 */
  0x0002,   /* U+40A3 */
  0x0002,   /* U+40A4 */
  0x0002,   /* U+40A5 */
  0x0002,   /* U+40A6 */
  0x0002,   /* U+40A7 */
  0x0002,   /* U+40A8 */
  0x0002,   /* U+40A9 */
  0x0002,   /* U+40AA */
  0x0002,   /* U+40AB */
  0x0002,   /* U+40AC */
  0x0002,   /* U+40AD */
  0x0002,   /* U+40AE */
  0x0002,   /* U+40AF */
  0x0002,   /* U+40B0 */
  0x0002,   /* U+40B1 */
  0x0002,   /* U+40B2 */
  0x0002,   /* U+40B3 */
  0x0002,   /* U+40B4 */
  0x0002,   /* U+40B5 */
  0x0002,   /* U+40B6 */
  0x0002,   /* U+40B7 */
  0x0002,   /* U+40B8 */
  0x0002,   /* U+40B9 */
  0x0002,   /* U+40BA */
  0x0002,   /* U+40BB */
  0x0002,   /* U+40BC */
  0x0002,   /* U+40BD */
  0x0002,   /* U+40BE */
  0x0002,   /* U+40BF */
  0x0002,   /* U+40C0 */
  0x0002,   /* U+40C1 */
  0x0002,   /* U+40C2 */
  0x0002,   /* U+40C3 */
  0x0002,   /* U+40C4 */
  0x0002,   /* U+40C5 */
  0x0002,   /* U+40C6 */
  0x0002,   /* U+40C7 */
  0x0002,   /* U+40C8 */
  0x0002,   /* U+40C9 */
  0x0002,   /* U+40CA */
  0x0002,   /* U+40CB */
  0x0002,   /* U+40CC */
  0x0002,   /* U+40CD */
  0x0002,   /* U+40CE */
  0x0002,   /* U+40CF */
  0x0002,   /* U+40D0 */
  0x0002,   /* U+40D1 */
  0x0002,   /* U+40D2 */
  0x0002,   /* U+40D3 */
  0x0002,   /* U+40D4 */
  0x0002,   /* U+40D5 */
  0x0002,   /* U+40D6 */
  0x0002,   /* U+40D7 */
  0x0002,   /* U+40D8 */
  0x0002,   /* U+40D9 */
  0x0002,   /* U+40DA */
  0x0002,   /* U+40DB */
  0x0002,   /* U+40DC */
  0x0002,   /* U+40DD */
  0x0002,   /* U+40DE */
  0x0002,   /* U+40DF */
  0x0002,   /* U+40E0 */
  0x0002,   /* U+40E1 */
  0x0002,   /* U+40E2 */
  0x0002,   /* U+40E3 */
  0x0002,   /* U+40E4 */
  0x0002,   /* U+40E5 */
  0x0002,   /* U+40E6 */
  0x0002,   /* U+40E7 */
  0x0002,   /* U+40E8 */
  0x0002,   /* U+40E9 */
  0x0002,   /* U+40EA */
  0x0002,   /* U+40EB */
  0x0002,   /* U+40EC */
  0x0002,   /* U+40ED */
  0x0002,   /* U+40EE */
  0x0002,   /* U+40EF */
  0x0002,   /* U+40F0 */
  0x0002,   /* U+40F1 */
  0x0002,   /* U+40F2 */
  0x0002,   /* U+40F3 */
  0x0002,   /* U+40F4 */
  0x0002,   /* U+40F5 */
  0x0002,   /* U+40F6 */
  0x0002,   /* U+40F7 */
  0x0002,   /* U+40F8 */
  0x0002,   /* U+40F9 */
  0x0002,   /* U+40FA */
  0x0002,   /* U+40FB */
  0x0002,   /* U+40FC */
  0x0002,   /* U+40FD */
  0x0002,   /* U+40FE */
  0x0002,   /* U+40FF */

  /* Primary weight 2 for each character. */
  0x8002,   /* U+4000 */
  0x8000,   /* U+4001 */
  0x8001,   /* U+4002 */
  0x8000,   /* U+4003 */
  0x8000,   /* U+4004 */
  0x8001,   /* U+4005 */
  0x8000,   /* U+4006 */
  0x8000,   /* U+4007 */
  0x8001,   /* U+4008 */
  0x8000,   /* U+4009 */
  0x8000,   /* U+400A */
  0xC00B,   /* U+400B */
  0xC00C,   /* U+400C */
  0x8000,   /* U+400D */
  0x8000,   /* U+400E */
  0x8001,   /* U+400F */
  0x8000,   /* U+4010 */
  0x8001,   /* U+4011 */
  0x8002,   /* U+4012 */
  0x8003,   /* U+4013 */
  0x8004,   /* U+4014 */
  0x8000,   /* U+4015 */
  0x8001,   /* U+4016 */
  0x8002,   /* U+4017 */
  0x8003,   /* U+4018 */
  0x8004,   /* U+4019 */
  0x8005,   /* U+401A */
  0x8006,   /* U+401B */
  0x8007,   /* U+401C */
  0x8008,   /* U+401D */
  0x8009,   /* U+401E */
  0x8000,   /* U+401F */
  0x8001,   /* U+4020 */
  0x8002,   /* U+4021 */
  0x8003,   /* U+4022 */
  0x8004,   /* U+4023 */
  0x8005,   /* U+4024 */
  0x8006,   /* U+4025 */
  0x8007,   /* U+4026 */
  0x8000,   /* U+4027 */
  0x8001,   /* U+4028 */
  0x8002,   /* U+4029 */
  0x8003,   /* U+402A */
  0x8004,   /* U+402B */
  0x8005,   /* U+402C */
  0x8006,   /* U+402D */
  0x8007,   /* U+402E */
  0x8000,   /* U+402F */
  0x8001,   /* U+4030 */
  0x8002,   /* U+4031 */
  0x8003,   /* U+4032 */
  0x8004,   /* U+4033 */
  0x8005,   /* U+4034 */
  0x8006,   /* U+4035 */
  0x8007,   /* U+4036 */
  0x8008,   /* U+4037 */
  0x8009,   /* U+4038 */
  0x800A,   /* U+4039 */
  0x800B,   /* U+403A */
  0x800C,   /* U+403B */
  0x800D,   /* U+403C */
  0x800E,   /* U+403D */
  0x800F,   /* U+403E */
  0x8010,   /* U+403F */
  0xC040,   /* U+4040 */
  0x8000,   /* U+4041 */
  0x8001,   /* U+4042 */
  0x8002,   /* U+4043 */
  0x8003,   /* U+4044 */
  0x8004,   /* U+4045 */
  0x8005,   /* U+4046 */
  0x8006,   /* U+4047 */
  0x8007,   /* U+4048 */
  0x8008,   /* U+4049 */
  0x8000,   /* U+404A */
  0x8001,   /* U+404B */
  0x8002,   /* U+404C */
  0x8003,   /* U+404D */
  0x8004,   /* U+404E */
  0x8005,   /* U+404F */
  0x8006,   /* U+4050 */
  0x8007,   /* U+4051 */
  0x8008,   /* U+4052 */
  0x8009,   /* U+4053 */
  0x800A,   /* U+4054 */
  0x800B,   /* U+4055 */
  0x800C,   /* U+4056 */
  0x8000,   /* U+4057 */
  0x8001,   /* U+4058 */
  0x8002,   /* U+4059 */
  0x8003,   /* U+405A */
  0x8004,   /* U+405B */
  0x8005,   /* U+405C */
  0x8006,   /* U+405D */
  0x8007,   /* U+405E */
  0x8008,   /* U+405F */
  0x8009,   /* U+4060 */
  0xC061,   /* U+4061 */
  0x8000,   /* U+4062 */
  0x8001,   /* U+4063 */
  0x8002,   /* U+4064 */
  0x8003,   /* U+4065 */
  0x8004,   /* U+4066 */
  0x8005,   /* U+4067 */
  0x8006,   /* U+4068 */
  0x8007,   /* U+4069 */
  0x8008,   /* U+406A */
  0x8000,   /* U+406B */
  0x8001,   /* U+406C */
  0x8002,   /* U+406D */
  0x8003,   /* U+406E */
  0x8004,   /* U+406F */
  0x8005,   /* U+4070 */
  0x8006,   /* U+4071 */
  0x8007,   /* U+4072 */
  0x8008,   /* U+4073 */
  0x8000,   /* U+4074 */
  0x8001,   /* U+4075 */
  0x8002,   /* U+4076 */
  0x8003,   /* U+4077 */
  0x8004,   /* U+4078 */
  0x8005,   /* U+4079 */
  0x8006,   /* U+407A */
  0x8000,   /* U+407B */
  0x8001,   /* U+407C */
  0x8002,   /* U+407D */
  0x8003,   /* U+407E */
  0x8000,   /* U+407F */
  0x8001,   /* U+4080 */
  0x8000,   /* U+4081 */
  0x8000,   /* U+4082 */
  0x8001,   /* U+4083 */
  0x8002,   /* U+4084 */
  0x8000,   /* U+4085 */
  0x8000,   /* U+4086 */
  0x8000,   /* U+4087 */
  0x8000,   /* U+4088 */
  0x8000,   /* U+4089 */
  0x8000,   /* U+408A */
  0x8001,   /* U+408B */
  0x8002,   /* U+408C */
  0x8000,   /* U+408D */
  0x8000,   /* U+408E */
  0x8000,   /* U+408F */
  0x8001,   /* U+4090 */
  0x8000,   /* U+4091 */
  0x8001,   /* U+4092 */
  0x8000,   /* U+4093 */
  0x8000,   /* U+4094 */
  0x8000,   /* U+4095 */
  0x8000,   /* U+4096 */
  0x8000,   /* U+4097 */
  0x8000,   /* U+4098 */
  0x8001,   /* U+4099 */
  0x8000,   /* U+409A */
  0x8001,   /* U+409B */
  0x8002,   /* U+409C */
  0x8003,   /* U+409D */
  0x8004,   /* U+409E */
  0x8000,   /* U+409F */
  0x8001,   /* U+40A0 */
  0x8002,   /* U+40A1 */
  0x8003,   /* U+40A2 */
  0x8004,   /* U+40A3 */
  0x8005,   /* U+40A4 */
  0x8006,   /* U+40A5 */
  0x8007,   /* U+40A6 */
  0x8008,   /* U+40A7 */
  0x8009,   /* U+40A8 */
  0x8000,   /* U+40A9 */
  0x8001,   /* U+40AA */
  0x8002,   /* U+40AB */
  0x8003,   /* U+40AC */
  0x8004,   /* U+40AD */
  0x8005,   /* U+40AE */
  0x8006,   /* U+40AF */
  0x8000,   /* U+40B0 */
  0x8001,   /* U+40B1 */
  0x8002,   /* U+40B2 */
  0x8003,   /* U+40B3 */
  0x8004,   /* U+40B4 */
  0x8005,   /* U+40B5 */
  0x8006,   /* U+40B6 */
  0x8000,   /* U+40B7 */
  0x8001,   /* U+40B8 */
  0x8002,   /* U+40B9 */
  0x8003,   /* U+40BA */
  0x8004,   /* U+40BB */
  0x8005,   /* U+40BC */
  0x8006,   /* U+40BD */
  0x8007,   /* U+40BE */
  0x8008,   /* U+40BF */
  0x8009,   /* U+40C0 */
  0x800A,   /* U+40C1 */
  0x800B,   /* U+40C2 */
  0xC0C3,   /* U+40C3 */
  0x800C,   /* U+40C4 */
  0x800D,   /* U+40C5 */
  0xC0C6,   /* U+40C6 */
  0x800E,   /* U+40C7 */
  0x8000,   /* U+40C8 */
  0x8001,   /* U+40C9 */
  0x8002,   /* U+40CA */
  0x8003,   /* U+40CB */
  0x8004,   /* U+40CC */
  0x8005,   /* U+40CD */
  0x8006,   /* U+40CE */
  0x8007,   /* U+40CF */
  0xC0D0,   /* U+40D0 */
  0x8001,   /* U+40D1 */
  0x8002,   /* U+40D2 */
  0x8003,   /* U+40D3 */
  0x8004,   /* U+40D4 */
  0x8005,   /* U+40D5 */
  0x8006,   /* U+40D6 */
  0x8007,   /* U+40D7 */
  0x8000,   /* U+40D8 */
  0x8001,   /* U+40D9 */
  0x8002,   /* U+40DA */
  0x8003,   /* U+40DB */
  0x8004,   /* U+40DC */
  0x8005,   /* U+40DD */
  0x8006,   /* U+40DE */
  0x8000,   /* U+40DF */
  0x8007,   /* U+40E0 */
  0x8001,   /* U+40E1 */
  0x8002,   /* U+40E2 */
  0x8003,   /* U+40E3 */
  0x8004,   /* U+40E4 */
  0x8005,   /* U+40E5 */
  0x8006,   /* U+40E6 */
  0x8007,   /* U+40E7 */
  0xC0E8,   /* U+40E8 */
  0x8000,   /* U+40E9 */
  0x8001,   /* U+40EA */
  0x8002,   /* U+40EB */
  0x8003,   /* U+40EC */
  0x8004,   /* U+40ED */
  0x8005,   /* U+40EE */
  0xC0EF,   /* U+40EF */
  0x8000,   /* U+40F0 */
  0x8000,   /* U+40F1 */
  0x8001,   /* U+40F2 */
  0x8002,   /* U+40F3 */
  0x8000,   /* U+40F4 */
  0x8001,   /* U+40F5 */
  0x8002,   /* U+40F6 */
  0x8003,   /* U+40F7 */
  0x8000,   /* U+40F8 */
  0x8001,   /* U+40F9 */
  0x8000,   /* U+40FA */
  0x8000,   /* U+40FB */
  0xC0FC,   /* U+40FC */
  0x8000,   /* U+40FD */
  0x8001,   /* U+40FE */
  0x8002,   /* U+40FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4000 */
  0x0000,   /* U+4001 */
  0x0000,   /* U+4002 */
  0x0000,   /* U+4003 */
  0x0000,   /* U+4004 */
  0x0000,   /* U+4005 */
  0x0000,   /* U+4006 */
  0x0000,   /* U+4007 */
  0x0000,   /* U+4008 */
  0x0000,   /* U+4009 */
  0x0000,   /* U+400A */
  0x0000,   /* U+400B */
  0x0000,   /* U+400C */
  0x0000,   /* U+400D */
  0x0000,   /* U+400E */
  0x0000,   /* U+400F */
  0x0000,   /* U+4010 */
  0x0000,   /* U+4011 */
  0x0000,   /* U+4012 */
  0x0000,   /* U+4013 */
  0x0000,   /* U+4014 */
  0x0000,   /* U+4015 */
  0x0000,   /* U+4016 */
  0x0000,   /* U+4017 */
  0x0000,   /* U+4018 */
  0x0000,   /* U+4019 */
  0x0000,   /* U+401A */
  0x0000,   /* U+401B */
  0x0000,   /* U+401C */
  0x0000,   /* U+401D */
  0x0000,   /* U+401E */
  0x0000,   /* U+401F */
  0x0000,   /* U+4020 */
  0x0000,   /* U+4021 */
  0x0000,   /* U+4022 */
  0x0000,   /* U+4023 */
  0x0000,   /* U+4024 */
  0x0000,   /* U+4025 */
  0x0000,   /* U+4026 */
  0x0000,   /* U+4027 */
  0x0000,   /* U+4028 */
  0x0000,   /* U+4029 */
  0x0000,   /* U+402A */
  0x0000,   /* U+402B */
  0x0000,   /* U+402C */
  0x0000,   /* U+402D */
  0x0000,   /* U+402E */
  0x0000,   /* U+402F */
  0x0000,   /* U+4030 */
  0x0000,   /* U+4031 */
  0x0000,   /* U+4032 */
  0x0000,   /* U+4033 */
  0x0000,   /* U+4034 */
  0x0000,   /* U+4035 */
  0x0000,   /* U+4036 */
  0x0000,   /* U+4037 */
  0x0000,   /* U+4038 */
  0x0000,   /* U+4039 */
  0x0000,   /* U+403A */
  0x0000,   /* U+403B */
  0x0000,   /* U+403C */
  0x0000,   /* U+403D */
  0x0000,   /* U+403E */
  0x0000,   /* U+403F */
  0x0000,   /* U+4040 */
  0x0000,   /* U+4041 */
  0x0000,   /* U+4042 */
  0x0000,   /* U+4043 */
  0x0000,   /* U+4044 */
  0x0000,   /* U+4045 */
  0x0000,   /* U+4046 */
  0x0000,   /* U+4047 */
  0x0000,   /* U+4048 */
  0x0000,   /* U+4049 */
  0x0000,   /* U+404A */
  0x0000,   /* U+404B */
  0x0000,   /* U+404C */
  0x0000,   /* U+404D */
  0x0000,   /* U+404E */
  0x0000,   /* U+404F */
  0x0000,   /* U+4050 */
  0x0000,   /* U+4051 */
  0x0000,   /* U+4052 */
  0x0000,   /* U+4053 */
  0x0000,   /* U+4054 */
  0x0000,   /* U+4055 */
  0x0000,   /* U+4056 */
  0x0000,   /* U+4057 */
  0x0000,   /* U+4058 */
  0x0000,   /* U+4059 */
  0x0000,   /* U+405A */
  0x0000,   /* U+405B */
  0x0000,   /* U+405C */
  0x0000,   /* U+405D */
  0x0000,   /* U+405E */
  0x0000,   /* U+405F */
  0x0000,   /* U+4060 */
  0x0000,   /* U+4061 */
  0x0000,   /* U+4062 */
  0x0000,   /* U+4063 */
  0x0000,   /* U+4064 */
  0x0000,   /* U+4065 */
  0x0000,   /* U+4066 */
  0x0000,   /* U+4067 */
  0x0000,   /* U+4068 */
  0x0000,   /* U+4069 */
  0x0000,   /* U+406A */
  0x0000,   /* U+406B */
  0x0000,   /* U+406C */
  0x0000,   /* U+406D */
  0x0000,   /* U+406E */
  0x0000,   /* U+406F */
  0x0000,   /* U+4070 */
  0x0000,   /* U+4071 */
  0x0000,   /* U+4072 */
  0x0000,   /* U+4073 */
  0x0000,   /* U+4074 */
  0x0000,   /* U+4075 */
  0x0000,   /* U+4076 */
  0x0000,   /* U+4077 */
  0x0000,   /* U+4078 */
  0x0000,   /* U+4079 */
  0x0000,   /* U+407A */
  0x0000,   /* U+407B */
  0x0000,   /* U+407C */
  0x0000,   /* U+407D */
  0x0000,   /* U+407E */
  0x0000,   /* U+407F */
  0x0000,   /* U+4080 */
  0x0000,   /* U+4081 */
  0x0000,   /* U+4082 */
  0x0000,   /* U+4083 */
  0x0000,   /* U+4084 */
  0x0000,   /* U+4085 */
  0x0000,   /* U+4086 */
  0x0000,   /* U+4087 */
  0x0000,   /* U+4088 */
  0x0000,   /* U+4089 */
  0x0000,   /* U+408A */
  0x0000,   /* U+408B */
  0x0000,   /* U+408C */
  0x0000,   /* U+408D */
  0x0000,   /* U+408E */
  0x0000,   /* U+408F */
  0x0000,   /* U+4090 */
  0x0000,   /* U+4091 */
  0x0000,   /* U+4092 */
  0x0000,   /* U+4093 */
  0x0000,   /* U+4094 */
  0x0000,   /* U+4095 */
  0x0000,   /* U+4096 */
  0x0000,   /* U+4097 */
  0x0000,   /* U+4098 */
  0x0000,   /* U+4099 */
  0x0000,   /* U+409A */
  0x0000,   /* U+409B */
  0x0000,   /* U+409C */
  0x0000,   /* U+409D */
  0x0000,   /* U+409E */
  0x0000,   /* U+409F */
  0x0000,   /* U+40A0 */
  0x0000,   /* U+40A1 */
  0x0000,   /* U+40A2 */
  0x0000,   /* U+40A3 */
  0x0000,   /* U+40A4 */
  0x0000,   /* U+40A5 */
  0x0000,   /* U+40A6 */
  0x0000,   /* U+40A7 */
  0x0000,   /* U+40A8 */
  0x0000,   /* U+40A9 */
  0x0000,   /* U+40AA */
  0x0000,   /* U+40AB */
  0x0000,   /* U+40AC */
  0x0000,   /* U+40AD */
  0x0000,   /* U+40AE */
  0x0000,   /* U+40AF */
  0x0000,   /* U+40B0 */
  0x0000,   /* U+40B1 */
  0x0000,   /* U+40B2 */
  0x0000,   /* U+40B3 */
  0x0000,   /* U+40B4 */
  0x0000,   /* U+40B5 */
  0x0000,   /* U+40B6 */
  0x0000,   /* U+40B7 */
  0x0000,   /* U+40B8 */
  0x0000,   /* U+40B9 */
  0x0000,   /* U+40BA */
  0x0000,   /* U+40BB */
  0x0000,   /* U+40BC */
  0x0000,   /* U+40BD */
  0x0000,   /* U+40BE */
  0x0000,   /* U+40BF */
  0x0000,   /* U+40C0 */
  0x0000,   /* U+40C1 */
  0x0000,   /* U+40C2 */
  0x0000,   /* U+40C3 */
  0x0000,   /* U+40C4 */
  0x0000,   /* U+40C5 */
  0x0000,   /* U+40C6 */
  0x0000,   /* U+40C7 */
  0x0000,   /* U+40C8 */
  0x0000,   /* U+40C9 */
  0x0000,   /* U+40CA */
  0x0000,   /* U+40CB */
  0x0000,   /* U+40CC */
  0x0000,   /* U+40CD */
  0x0000,   /* U+40CE */
  0x0000,   /* U+40CF */
  0x0000,   /* U+40D0 */
  0x0000,   /* U+40D1 */
  0x0000,   /* U+40D2 */
  0x0000,   /* U+40D3 */
  0x0000,   /* U+40D4 */
  0x0000,   /* U+40D5 */
  0x0000,   /* U+40D6 */
  0x0000,   /* U+40D7 */
  0x0000,   /* U+40D8 */
  0x0000,   /* U+40D9 */
  0x0000,   /* U+40DA */
  0x0000,   /* U+40DB */
  0x0000,   /* U+40DC */
  0x0000,   /* U+40DD */
  0x0000,   /* U+40DE */
  0x0000,   /* U+40DF */
  0x0000,   /* U+40E0 */
  0x0000,   /* U+40E1 */
  0x0000,   /* U+40E2 */
  0x0000,   /* U+40E3 */
  0x0000,   /* U+40E4 */
  0x0000,   /* U+40E5 */
  0x0000,   /* U+40E6 */
  0x0000,   /* U+40E7 */
  0x0000,   /* U+40E8 */
  0x0000,   /* U+40E9 */
  0x0000,   /* U+40EA */
  0x0000,   /* U+40EB */
  0x0000,   /* U+40EC */
  0x0000,   /* U+40ED */
  0x0000,   /* U+40EE */
  0x0000,   /* U+40EF */
  0x0000,   /* U+40F0 */
  0x0000,   /* U+40F1 */
  0x0000,   /* U+40F2 */
  0x0000,   /* U+40F3 */
  0x0000,   /* U+40F4 */
  0x0000,   /* U+40F5 */
  0x0000,   /* U+40F6 */
  0x0000,   /* U+40F7 */
  0x0000,   /* U+40F8 */
  0x0000,   /* U+40F9 */
  0x0000,   /* U+40FA */
  0x0000,   /* U+40FB */
  0x0000,   /* U+40FC */
  0x0000,   /* U+40FD */
  0x0000,   /* U+40FE */
  0x0000,   /* U+40FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4000 */
  0x0000,   /* U+4001 */
  0x0000,   /* U+4002 */
  0x0000,   /* U+4003 */
  0x0000,   /* U+4004 */
  0x0000,   /* U+4005 */
  0x0000,   /* U+4006 */
  0x0000,   /* U+4007 */
  0x0000,   /* U+4008 */
  0x0000,   /* U+4009 */
  0x0000,   /* U+400A */
  0x0000,   /* U+400B */
  0x0000,   /* U+400C */
  0x0000,   /* U+400D */
  0x0000,   /* U+400E */
  0x0000,   /* U+400F */
  0x0000,   /* U+4010 */
  0x0000,   /* U+4011 */
  0x0000,   /* U+4012 */
  0x0000,   /* U+4013 */
  0x0000,   /* U+4014 */
  0x0000,   /* U+4015 */
  0x0000,   /* U+4016 */
  0x0000,   /* U+4017 */
  0x0000,   /* U+4018 */
  0x0000,   /* U+4019 */
  0x0000,   /* U+401A */
  0x0000,   /* U+401B */
  0x0000,   /* U+401C */
  0x0000,   /* U+401D */
  0x0000,   /* U+401E */
  0x0000,   /* U+401F */
  0x0000,   /* U+4020 */
  0x0000,   /* U+4021 */
  0x0000,   /* U+4022 */
  0x0000,   /* U+4023 */
  0x0000,   /* U+4024 */
  0x0000,   /* U+4025 */
  0x0000,   /* U+4026 */
  0x0000,   /* U+4027 */
  0x0000,   /* U+4028 */
  0x0000,   /* U+4029 */
  0x0000,   /* U+402A */
  0x0000,   /* U+402B */
  0x0000,   /* U+402C */
  0x0000,   /* U+402D */
  0x0000,   /* U+402E */
  0x0000,   /* U+402F */
  0x0000,   /* U+4030 */
  0x0000,   /* U+4031 */
  0x0000,   /* U+4032 */
  0x0000,   /* U+4033 */
  0x0000,   /* U+4034 */
  0x0000,   /* U+4035 */
  0x0000,   /* U+4036 */
  0x0000,   /* U+4037 */
  0x0000,   /* U+4038 */
  0x0000,   /* U+4039 */
  0x0000,   /* U+403A */
  0x0000,   /* U+403B */
  0x0000,   /* U+403C */
  0x0000,   /* U+403D */
  0x0000,   /* U+403E */
  0x0000,   /* U+403F */
  0x0000,   /* U+4040 */
  0x0000,   /* U+4041 */
  0x0000,   /* U+4042 */
  0x0000,   /* U+4043 */
  0x0000,   /* U+4044 */
  0x0000,   /* U+4045 */
  0x0000,   /* U+4046 */
  0x0000,   /* U+4047 */
  0x0000,   /* U+4048 */
  0x0000,   /* U+4049 */
  0x0000,   /* U+404A */
  0x0000,   /* U+404B */
  0x0000,   /* U+404C */
  0x0000,   /* U+404D */
  0x0000,   /* U+404E */
  0x0000,   /* U+404F */
  0x0000,   /* U+4050 */
  0x0000,   /* U+4051 */
  0x0000,   /* U+4052 */
  0x0000,   /* U+4053 */
  0x0000,   /* U+4054 */
  0x0000,   /* U+4055 */
  0x0000,   /* U+4056 */
  0x0000,   /* U+4057 */
  0x0000,   /* U+4058 */
  0x0000,   /* U+4059 */
  0x0000,   /* U+405A */
  0x0000,   /* U+405B */
  0x0000,   /* U+405C */
  0x0000,   /* U+405D */
  0x0000,   /* U+405E */
  0x0000,   /* U+405F */
  0x0000,   /* U+4060 */
  0x0000,   /* U+4061 */
  0x0000,   /* U+4062 */
  0x0000,   /* U+4063 */
  0x0000,   /* U+4064 */
  0x0000,   /* U+4065 */
  0x0000,   /* U+4066 */
  0x0000,   /* U+4067 */
  0x0000,   /* U+4068 */
  0x0000,   /* U+4069 */
  0x0000,   /* U+406A */
  0x0000,   /* U+406B */
  0x0000,   /* U+406C */
  0x0000,   /* U+406D */
  0x0000,   /* U+406E */
  0x0000,   /* U+406F */
  0x0000,   /* U+4070 */
  0x0000,   /* U+4071 */
  0x0000,   /* U+4072 */
  0x0000,   /* U+4073 */
  0x0000,   /* U+4074 */
  0x0000,   /* U+4075 */
  0x0000,   /* U+4076 */
  0x0000,   /* U+4077 */
  0x0000,   /* U+4078 */
  0x0000,   /* U+4079 */
  0x0000,   /* U+407A */
  0x0000,   /* U+407B */
  0x0000,   /* U+407C */
  0x0000,   /* U+407D */
  0x0000,   /* U+407E */
  0x0000,   /* U+407F */
  0x0000,   /* U+4080 */
  0x0000,   /* U+4081 */
  0x0000,   /* U+4082 */
  0x0000,   /* U+4083 */
  0x0000,   /* U+4084 */
  0x0000,   /* U+4085 */
  0x0000,   /* U+4086 */
  0x0000,   /* U+4087 */
  0x0000,   /* U+4088 */
  0x0000,   /* U+4089 */
  0x0000,   /* U+408A */
  0x0000,   /* U+408B */
  0x0000,   /* U+408C */
  0x0000,   /* U+408D */
  0x0000,   /* U+408E */
  0x0000,   /* U+408F */
  0x0000,   /* U+4090 */
  0x0000,   /* U+4091 */
  0x0000,   /* U+4092 */
  0x0000,   /* U+4093 */
  0x0000,   /* U+4094 */
  0x0000,   /* U+4095 */
  0x0000,   /* U+4096 */
  0x0000,   /* U+4097 */
  0x0000,   /* U+4098 */
  0x0000,   /* U+4099 */
  0x0000,   /* U+409A */
  0x0000,   /* U+409B */
  0x0000,   /* U+409C */
  0x0000,   /* U+409D */
  0x0000,   /* U+409E */
  0x0000,   /* U+409F */
  0x0000,   /* U+40A0 */
  0x0000,   /* U+40A1 */
  0x0000,   /* U+40A2 */
  0x0000,   /* U+40A3 */
  0x0000,   /* U+40A4 */
  0x0000,   /* U+40A5 */
  0x0000,   /* U+40A6 */
  0x0000,   /* U+40A7 */
  0x0000,   /* U+40A8 */
  0x0000,   /* U+40A9 */
  0x0000,   /* U+40AA */
  0x0000,   /* U+40AB */
  0x0000,   /* U+40AC */
  0x0000,   /* U+40AD */
  0x0000,   /* U+40AE */
  0x0000,   /* U+40AF */
  0x0000,   /* U+40B0 */
  0x0000,   /* U+40B1 */
  0x0000,   /* U+40B2 */
  0x0000,   /* U+40B3 */
  0x0000,   /* U+40B4 */
  0x0000,   /* U+40B5 */
  0x0000,   /* U+40B6 */
  0x0000,   /* U+40B7 */
  0x0000,   /* U+40B8 */
  0x0000,   /* U+40B9 */
  0x0000,   /* U+40BA */
  0x0000,   /* U+40BB */
  0x0000,   /* U+40BC */
  0x0000,   /* U+40BD */
  0x0000,   /* U+40BE */
  0x0000,   /* U+40BF */
  0x0000,   /* U+40C0 */
  0x0000,   /* U+40C1 */
  0x0000,   /* U+40C2 */
  0x0000,   /* U+40C3 */
  0x0000,   /* U+40C4 */
  0x0000,   /* U+40C5 */
  0x0000,   /* U+40C6 */
  0x0000,   /* U+40C7 */
  0x0000,   /* U+40C8 */
  0x0000,   /* U+40C9 */
  0x0000,   /* U+40CA */
  0x0000,   /* U+40CB */
  0x0000,   /* U+40CC */
  0x0000,   /* U+40CD */
  0x0000,   /* U+40CE */
  0x0000,   /* U+40CF */
  0x0000,   /* U+40D0 */
  0x0000,   /* U+40D1 */
  0x0000,   /* U+40D2 */
  0x0000,   /* U+40D3 */
  0x0000,   /* U+40D4 */
  0x0000,   /* U+40D5 */
  0x0000,   /* U+40D6 */
  0x0000,   /* U+40D7 */
  0x0000,   /* U+40D8 */
  0x0000,   /* U+40D9 */
  0x0000,   /* U+40DA */
  0x0000,   /* U+40DB */
  0x0000,   /* U+40DC */
  0x0000,   /* U+40DD */
  0x0000,   /* U+40DE */
  0x0000,   /* U+40DF */
  0x0000,   /* U+40E0 */
  0x0000,   /* U+40E1 */
  0x0000,   /* U+40E2 */
  0x0000,   /* U+40E3 */
  0x0000,   /* U+40E4 */
  0x0000,   /* U+40E5 */
  0x0000,   /* U+40E6 */
  0x0000,   /* U+40E7 */
  0x0000,   /* U+40E8 */
  0x0000,   /* U+40E9 */
  0x0000,   /* U+40EA */
  0x0000,   /* U+40EB */
  0x0000,   /* U+40EC */
  0x0000,   /* U+40ED */
  0x0000,   /* U+40EE */
  0x0000,   /* U+40EF */
  0x0000,   /* U+40F0 */
  0x0000,   /* U+40F1 */
  0x0000,   /* U+40F2 */
  0x0000,   /* U+40F3 */
  0x0000,   /* U+40F4 */
  0x0000,   /* U+40F5 */
  0x0000,   /* U+40F6 */
  0x0000,   /* U+40F7 */
  0x0000,   /* U+40F8 */
  0x0000,   /* U+40F9 */
  0x0000,   /* U+40FA */
  0x0000,   /* U+40FB */
  0x0000,   /* U+40FC */
  0x0000,   /* U+40FD */
  0x0000,   /* U+40FE */
  0x0000,   /* U+40FF */
};

uint16 zh2_han_p041[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x3890,   /* U+4100 */
  0x3891,   /* U+4101 */
  0x3891,   /* U+4102 */
  0x3891,   /* U+4103 */
  0x3892,   /* U+4104 */
  0x3892,   /* U+4105 */
  0x3892,   /* U+4106 */
  0x3893,   /* U+4107 */
  0x3893,   /* U+4108 */
  0x3893,   /* U+4109 */
  0x3893,   /* U+410A */
  0x3894,   /* U+410B */
  0x3894,   /* U+410C */
  0x3894,   /* U+410D */
  0x3894,   /* U+410E */
  0x3894,   /* U+410F */
  0x3894,   /* U+4110 */
  0x3894,   /* U+4111 */
  0x3894,   /* U+4112 */
  0x3895,   /* U+4113 */
  0x3895,   /* U+4114 */
  0x3895,   /* U+4115 */
  0x3895,   /* U+4116 */
  0x5C49,   /* U+4117 */
  0x388D,   /* U+4118 */
  0x388D,   /* U+4119 */
  0x3897,   /* U+411A */
  0x3897,   /* U+411B */
  0x3897,   /* U+411C */
  0x3897,   /* U+411D */
  0x5C49,   /* U+411E */
  0x3898,   /* U+411F */
  0x3899,   /* U+4120 */
  0x3899,   /* U+4121 */
  0x389A,   /* U+4122 */
  0x5C49,   /* U+4123 */
  0x389C,   /* U+4124 */
  0x38A4,   /* U+4125 */
  0x390E,   /* U+4126 */
  0x390E,   /* U+4127 */
  0x390F,   /* U+4128 */
  0x390F,   /* U+4129 */
  0x390F,   /* U+412A */
  0x390F,   /* U+412B */
  0x390F,   /* U+412C */
  0x390F,   /* U+412D */
  0x3910,   /* U+412E */
  0x3910,   /* U+412F */
  0x3910,   /* U+4130 */
  0x3910,   /* U+4131 */
  0x3910,   /* U+4132 */
  0x3910,   /* U+4133 */
  0x3910,   /* U+4134 */
  0x5C49,   /* U+4135 */
  0x3911,   /* U+4136 */
  0x3911,   /* U+4137 */
  0x3911,   /* U+4138 */
  0x3911,   /* U+4139 */
  0x3912,   /* U+413A */
  0x3912,   /* U+413B */
  0x3912,   /* U+413C */
  0x3912,   /* U+413D */
  0x3912,   /* U+413E */
  0x3912,   /* U+413F */
  0x3912,   /* U+4140 */
  0x3912,   /* U+4141 */
  0x3912,   /* U+4142 */
  0x3912,   /* U+4143 */
  0x3912,   /* U+4144 */
  0x3912,   /* U+4145 */
  0x3912,   /* U+4146 */
  0x3912,   /* U+4147 */
  0x3912,   /* U+4148 */
  0x3912,   /* U+4149 */
  0x3912,   /* U+414A */
  0x3913,   /* U+414B */
  0x3913,   /* U+414C */
  0x3913,   /* U+414D */
  0x3913,   /* U+414E */
  0x3913,   /* U+414F */
  0x3913,   /* U+4150 */
  0x3913,   /* U+4151 */
  0x3913,   /* U+4152 */
  0x3913,   /* U+4153 */
  0x3914,   /* U+4154 */
  0x3914,   /* U+4155 */
  0x3914,   /* U+4156 */
  0x3914,   /* U+4157 */
  0x3914,   /* U+4158 */
  0x3914,   /* U+4159 */
  0x3914,   /* U+415A */
  0x3914,   /* U+415B */
  0x3914,   /* U+415C */
  0x3914,   /* U+415D */
  0x3914,   /* U+415E */
  0x3914,   /* U+415F */
  0x3915,   /* U+4160 */
  0x3915,   /* U+4161 */
  0x3915,   /* U+4162 */
  0x3915,   /* U+4163 */
  0x3915,   /* U+4164 */
  0x3915,   /* U+4165 */
  0x3915,   /* U+4166 */
  0x3915,   /* U+4167 */
  0x3915,   /* U+4168 */
  0x3915,   /* U+4169 */
  0x3915,   /* U+416A */
  0x5C49,   /* U+416B */
  0x390D,   /* U+416C */
  0x390D,   /* U+416D */
  0x390D,   /* U+416E */
  0x390D,   /* U+416F */
  0x390D,   /* U+4170 */
  0x390D,   /* U+4171 */
  0x390D,   /* U+4172 */
  0x390D,   /* U+4173 */
  0x390D,   /* U+4174 */
  0x390D,   /* U+4175 */
  0x390D,   /* U+4176 */
  0x3917,   /* U+4177 */
  0x3917,   /* U+4178 */
  0x3917,   /* U+4179 */
  0x3917,   /* U+417A */
  0x3917,   /* U+417B */
  0x3917,   /* U+417C */
  0x3917,   /* U+417D */
  0x3918,   /* U+417E */
  0x3918,   /* U+417F */
  0x3918,   /* U+4180 */
  0x3919,   /* U+4181 */
  0x3919,   /* U+4182 */
  0x3919,   /* U+4183 */
  0x3919,   /* U+4184 */
  0x3919,   /* U+4185 */
  0x5C49,   /* U+4186 */
  0x5C49,   /* U+4187 */
  0x391B,   /* U+4188 */
  0x391B,   /* U+4189 */
  0x391C,   /* U+418A */
  0x5C49,   /* U+418B */
  0x391C,   /* U+418C */
  0x391C,   /* U+418D */
  0x391D,   /* U+418E */
  0x391D,   /* U+418F */
  0x3925,   /* U+4190 */
  0x394E,   /* U+4191 */
  0x394F,   /* U+4192 */
  0x3950,   /* U+4193 */
  0x3950,   /* U+4194 */
  0x3950,   /* U+4195 */
  0x3950,   /* U+4196 */
  0x3951,   /* U+4197 */
  0x3951,   /* U+4198 */
  0x3951,   /* U+4199 */
  0x3952,   /* U+419A */
  0x3952,   /* U+419B */
  0x3952,   /* U+419C */
  0x3952,   /* U+419D */
  0x3952,   /* U+419E */
  0x3952,   /* U+419F */
  0x3952,   /* U+41A0 */
  0x3953,   /* U+41A1 */
  0x3953,   /* U+41A2 */
  0x3953,   /* U+41A3 */
  0x3953,   /* U+41A4 */
  0x3953,   /* U+41A5 */
  0x3954,   /* U+41A6 */
  0x3954,   /* U+41A7 */
  0x3954,   /* U+41A8 */
  0x3954,   /* U+41A9 */
  0x3955,   /* U+41AA */
  0x3955,   /* U+41AB */
  0x394D,   /* U+41AC */
  0x394D,   /* U+41AD */
  0x394D,   /* U+41AE */
  0x3957,   /* U+41AF */
  0x3957,   /* U+41B0 */
  0x3957,   /* U+41B1 */
  0x3957,   /* U+41B2 */
  0x3957,   /* U+41B3 */
  0x5C49,   /* U+41B4 */
  0x3958,   /* U+41B5 */
  0x3958,   /* U+41B6 */
  0x3958,   /* U+41B7 */
  0x3958,   /* U+41B8 */
  0x3958,   /* U+41B9 */
  0x3958,   /* U+41BA */
  0x3958,   /* U+41BB */
  0x3959,   /* U+41BC */
  0x3959,   /* U+41BD */
  0x395A,   /* U+41BE */
  0x395A,   /* U+41BF */
  0x395B,   /* U+41C0 */
  0x395D,   /* U+41C1 */
  0x398D,   /* U+41C2 */
  0x398F,   /* U+41C3 */
  0x398F,   /* U+41C4 */
  0x3990,   /* U+41C5 */
  0x3990,   /* U+41C6 */
  0x3991,   /* U+41C7 */
  0x3991,   /* U+41C8 */
  0x3991,   /* U+41C9 */
  0x5C49,   /* U+41CA */
  0x3992,   /* U+41CB */
  0x3993,   /* U+41CC */
  0x3993,   /* U+41CD */
  0x3994,   /* U+41CE */
  0x3994,   /* U+41CF */
  0x3994,   /* U+41D0 */
  0x3994,   /* U+41D1 */
  0x3997,   /* U+41D2 */
  0x3998,   /* U+41D3 */
  0x3999,   /* U+41D4 */
  0x399A,   /* U+41D5 */
  0x39CF,   /* U+41D6 */
  0x39D0,   /* U+41D7 */
  0x39D0,   /* U+41D8 */
  0x39D0,   /* U+41D9 */
  0x39D0,   /* U+41DA */
  0x39D0,   /* U+41DB */
  0x39D0,   /* U+41DC */
  0x39D0,   /* U+41DD */
  0x39D1,   /* U+41DE */
  0x39D1,   /* U+41DF */
  0x39D1,   /* U+41E0 */
  0x39D1,   /* U+41E1 */
  0x39D1,   /* U+41E2 */
  0x39D1,   /* U+41E3 */
  0x39D1,   /* U+41E4 */
  0x39D1,   /* U+41E5 */
  0x39D1,   /* U+41E6 */
  0x39D2,   /* U+41E7 */
  0x39D2,   /* U+41E8 */
  0x39D2,   /* U+41E9 */
  0x39D2,   /* U+41EA */
  0x39D2,   /* U+41EB */
  0x39D2,   /* U+41EC */
  0x39D2,   /* U+41ED */
  0x39D2,   /* U+41EE */
  0x39D2,   /* U+41EF */
  0x39D2,   /* U+41F0 */
  0x39D2,   /* U+41F1 */
  0x39D2,   /* U+41F2 */
  0x5C49,   /* U+41F3 */
  0x39D2,   /* U+41F4 */
  0x39D3,   /* U+41F5 */
  0x39D3,   /* U+41F6 */
  0x39D3,   /* U+41F7 */
  0x39D3,   /* U+41F8 */
  0x39D3,   /* U+41F9 */
  0x39D3,   /* U+41FA */
  0x39D3,   /* U+41FB */
  0x39D3,   /* U+41FC */
  0x39D3,   /* U+41FD */
  0x39D3,   /* U+41FE */
  0x5C49,   /* U+41FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4100 */
  0x0020,   /* U+4101 */
  0x0020,   /* U+4102 */
  0x0020,   /* U+4103 */
  0x0020,   /* U+4104 */
  0x0020,   /* U+4105 */
  0x0020,   /* U+4106 */
  0x0020,   /* U+4107 */
  0x0020,   /* U+4108 */
  0x0020,   /* U+4109 */
  0x0020,   /* U+410A */
  0x0020,   /* U+410B */
  0x0020,   /* U+410C */
  0x0020,   /* U+410D */
  0x0020,   /* U+410E */
  0x0020,   /* U+410F */
  0x0020,   /* U+4110 */
  0x0020,   /* U+4111 */
  0x0020,   /* U+4112 */
  0x0020,   /* U+4113 */
  0x0020,   /* U+4114 */
  0x0020,   /* U+4115 */
  0x0020,   /* U+4116 */
  0x0020,   /* U+4117 */
  0x0020,   /* U+4118 */
  0x0020,   /* U+4119 */
  0x0020,   /* U+411A */
  0x0020,   /* U+411B */
  0x0020,   /* U+411C */
  0x0020,   /* U+411D */
  0x0020,   /* U+411E */
  0x0020,   /* U+411F */
  0x0020,   /* U+4120 */
  0x0020,   /* U+4121 */
  0x0020,   /* U+4122 */
  0x0020,   /* U+4123 */
  0x0020,   /* U+4124 */
  0x0020,   /* U+4125 */
  0x0020,   /* U+4126 */
  0x0020,   /* U+4127 */
  0x0020,   /* U+4128 */
  0x0020,   /* U+4129 */
  0x0020,   /* U+412A */
  0x0020,   /* U+412B */
  0x0020,   /* U+412C */
  0x0020,   /* U+412D */
  0x0020,   /* U+412E */
  0x0020,   /* U+412F */
  0x0020,   /* U+4130 */
  0x0020,   /* U+4131 */
  0x0020,   /* U+4132 */
  0x0020,   /* U+4133 */
  0x0020,   /* U+4134 */
  0x0020,   /* U+4135 */
  0x0020,   /* U+4136 */
  0x0020,   /* U+4137 */
  0x0020,   /* U+4138 */
  0x0020,   /* U+4139 */
  0x0020,   /* U+413A */
  0x0020,   /* U+413B */
  0x0020,   /* U+413C */
  0x0020,   /* U+413D */
  0x0020,   /* U+413E */
  0x0020,   /* U+413F */
  0x0020,   /* U+4140 */
  0x0020,   /* U+4141 */
  0x0020,   /* U+4142 */
  0x0020,   /* U+4143 */
  0x0020,   /* U+4144 */
  0x0020,   /* U+4145 */
  0x0020,   /* U+4146 */
  0x0020,   /* U+4147 */
  0x0020,   /* U+4148 */
  0x0020,   /* U+4149 */
  0x0020,   /* U+414A */
  0x0020,   /* U+414B */
  0x0020,   /* U+414C */
  0x0020,   /* U+414D */
  0x0020,   /* U+414E */
  0x0020,   /* U+414F */
  0x0020,   /* U+4150 */
  0x0020,   /* U+4151 */
  0x0020,   /* U+4152 */
  0x0020,   /* U+4153 */
  0x0020,   /* U+4154 */
  0x0020,   /* U+4155 */
  0x0020,   /* U+4156 */
  0x0020,   /* U+4157 */
  0x0020,   /* U+4158 */
  0x0020,   /* U+4159 */
  0x0020,   /* U+415A */
  0x0020,   /* U+415B */
  0x0020,   /* U+415C */
  0x0020,   /* U+415D */
  0x0020,   /* U+415E */
  0x0020,   /* U+415F */
  0x0020,   /* U+4160 */
  0x0020,   /* U+4161 */
  0x0020,   /* U+4162 */
  0x0020,   /* U+4163 */
  0x0020,   /* U+4164 */
  0x0020,   /* U+4165 */
  0x0020,   /* U+4166 */
  0x0020,   /* U+4167 */
  0x0020,   /* U+4168 */
  0x0020,   /* U+4169 */
  0x0020,   /* U+416A */
  0x0020,   /* U+416B */
  0x0020,   /* U+416C */
  0x0020,   /* U+416D */
  0x0020,   /* U+416E */
  0x0020,   /* U+416F */
  0x0020,   /* U+4170 */
  0x0020,   /* U+4171 */
  0x0020,   /* U+4172 */
  0x0020,   /* U+4173 */
  0x0020,   /* U+4174 */
  0x0020,   /* U+4175 */
  0x0020,   /* U+4176 */
  0x0020,   /* U+4177 */
  0x0020,   /* U+4178 */
  0x0020,   /* U+4179 */
  0x0020,   /* U+417A */
  0x0020,   /* U+417B */
  0x0020,   /* U+417C */
  0x0020,   /* U+417D */
  0x0020,   /* U+417E */
  0x0020,   /* U+417F */
  0x0020,   /* U+4180 */
  0x0020,   /* U+4181 */
  0x0020,   /* U+4182 */
  0x0020,   /* U+4183 */
  0x0020,   /* U+4184 */
  0x0020,   /* U+4185 */
  0x0020,   /* U+4186 */
  0x0020,   /* U+4187 */
  0x0020,   /* U+4188 */
  0x0020,   /* U+4189 */
  0x0020,   /* U+418A */
  0x0020,   /* U+418B */
  0x0020,   /* U+418C */
  0x0020,   /* U+418D */
  0x0020,   /* U+418E */
  0x0020,   /* U+418F */
  0x0020,   /* U+4190 */
  0x0020,   /* U+4191 */
  0x0020,   /* U+4192 */
  0x0020,   /* U+4193 */
  0x0020,   /* U+4194 */
  0x0020,   /* U+4195 */
  0x0020,   /* U+4196 */
  0x0020,   /* U+4197 */
  0x0020,   /* U+4198 */
  0x0020,   /* U+4199 */
  0x0020,   /* U+419A */
  0x0020,   /* U+419B */
  0x0020,   /* U+419C */
  0x0020,   /* U+419D */
  0x0020,   /* U+419E */
  0x0020,   /* U+419F */
  0x0020,   /* U+41A0 */
  0x0020,   /* U+41A1 */
  0x0020,   /* U+41A2 */
  0x0020,   /* U+41A3 */
  0x0020,   /* U+41A4 */
  0x0020,   /* U+41A5 */
  0x0020,   /* U+41A6 */
  0x0020,   /* U+41A7 */
  0x0020,   /* U+41A8 */
  0x0020,   /* U+41A9 */
  0x0020,   /* U+41AA */
  0x0020,   /* U+41AB */
  0x0020,   /* U+41AC */
  0x0020,   /* U+41AD */
  0x0020,   /* U+41AE */
  0x0020,   /* U+41AF */
  0x0020,   /* U+41B0 */
  0x0020,   /* U+41B1 */
  0x0020,   /* U+41B2 */
  0x0020,   /* U+41B3 */
  0x0020,   /* U+41B4 */
  0x0020,   /* U+41B5 */
  0x0020,   /* U+41B6 */
  0x0020,   /* U+41B7 */
  0x0020,   /* U+41B8 */
  0x0020,   /* U+41B9 */
  0x0020,   /* U+41BA */
  0x0020,   /* U+41BB */
  0x0020,   /* U+41BC */
  0x0020,   /* U+41BD */
  0x0020,   /* U+41BE */
  0x0020,   /* U+41BF */
  0x0020,   /* U+41C0 */
  0x0020,   /* U+41C1 */
  0x0020,   /* U+41C2 */
  0x0020,   /* U+41C3 */
  0x0020,   /* U+41C4 */
  0x0020,   /* U+41C5 */
  0x0020,   /* U+41C6 */
  0x0020,   /* U+41C7 */
  0x0020,   /* U+41C8 */
  0x0020,   /* U+41C9 */
  0x0020,   /* U+41CA */
  0x0020,   /* U+41CB */
  0x0020,   /* U+41CC */
  0x0020,   /* U+41CD */
  0x0020,   /* U+41CE */
  0x0020,   /* U+41CF */
  0x0020,   /* U+41D0 */
  0x0020,   /* U+41D1 */
  0x0020,   /* U+41D2 */
  0x0020,   /* U+41D3 */
  0x0020,   /* U+41D4 */
  0x0020,   /* U+41D5 */
  0x0020,   /* U+41D6 */
  0x0020,   /* U+41D7 */
  0x0020,   /* U+41D8 */
  0x0020,   /* U+41D9 */
  0x0020,   /* U+41DA */
  0x0020,   /* U+41DB */
  0x0020,   /* U+41DC */
  0x0020,   /* U+41DD */
  0x0020,   /* U+41DE */
  0x0020,   /* U+41DF */
  0x0020,   /* U+41E0 */
  0x0020,   /* U+41E1 */
  0x0020,   /* U+41E2 */
  0x0020,   /* U+41E3 */
  0x0020,   /* U+41E4 */
  0x0020,   /* U+41E5 */
  0x0020,   /* U+41E6 */
  0x0020,   /* U+41E7 */
  0x0020,   /* U+41E8 */
  0x0020,   /* U+41E9 */
  0x0020,   /* U+41EA */
  0x0020,   /* U+41EB */
  0x0020,   /* U+41EC */
  0x0020,   /* U+41ED */
  0x0020,   /* U+41EE */
  0x0020,   /* U+41EF */
  0x0020,   /* U+41F0 */
  0x0020,   /* U+41F1 */
  0x0020,   /* U+41F2 */
  0x0020,   /* U+41F3 */
  0x0020,   /* U+41F4 */
  0x0020,   /* U+41F5 */
  0x0020,   /* U+41F6 */
  0x0020,   /* U+41F7 */
  0x0020,   /* U+41F8 */
  0x0020,   /* U+41F9 */
  0x0020,   /* U+41FA */
  0x0020,   /* U+41FB */
  0x0020,   /* U+41FC */
  0x0020,   /* U+41FD */
  0x0020,   /* U+41FE */
  0x0020,   /* U+41FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4100 */
  0x0002,   /* U+4101 */
  0x0002,   /* U+4102 */
  0x0002,   /* U+4103 */
  0x0002,   /* U+4104 */
  0x0002,   /* U+4105 */
  0x0002,   /* U+4106 */
  0x0002,   /* U+4107 */
  0x0002,   /* U+4108 */
  0x0002,   /* U+4109 */
  0x0002,   /* U+410A */
  0x0002,   /* U+410B */
  0x0002,   /* U+410C */
  0x0002,   /* U+410D */
  0x0002,   /* U+410E */
  0x0002,   /* U+410F */
  0x0002,   /* U+4110 */
  0x0002,   /* U+4111 */
  0x0002,   /* U+4112 */
  0x0002,   /* U+4113 */
  0x0002,   /* U+4114 */
  0x0002,   /* U+4115 */
  0x0002,   /* U+4116 */
  0x0002,   /* U+4117 */
  0x0002,   /* U+4118 */
  0x0002,   /* U+4119 */
  0x0002,   /* U+411A */
  0x0002,   /* U+411B */
  0x0002,   /* U+411C */
  0x0002,   /* U+411D */
  0x0002,   /* U+411E */
  0x0002,   /* U+411F */
  0x0002,   /* U+4120 */
  0x0002,   /* U+4121 */
  0x0002,   /* U+4122 */
  0x0002,   /* U+4123 */
  0x0002,   /* U+4124 */
  0x0002,   /* U+4125 */
  0x0002,   /* U+4126 */
  0x0002,   /* U+4127 */
  0x0002,   /* U+4128 */
  0x0002,   /* U+4129 */
  0x0002,   /* U+412A */
  0x0002,   /* U+412B */
  0x0002,   /* U+412C */
  0x0002,   /* U+412D */
  0x0002,   /* U+412E */
  0x0002,   /* U+412F */
  0x0002,   /* U+4130 */
  0x0002,   /* U+4131 */
  0x0002,   /* U+4132 */
  0x0002,   /* U+4133 */
  0x0002,   /* U+4134 */
  0x0002,   /* U+4135 */
  0x0002,   /* U+4136 */
  0x0002,   /* U+4137 */
  0x0002,   /* U+4138 */
  0x0002,   /* U+4139 */
  0x0002,   /* U+413A */
  0x0002,   /* U+413B */
  0x0002,   /* U+413C */
  0x0002,   /* U+413D */
  0x0002,   /* U+413E */
  0x0002,   /* U+413F */
  0x0002,   /* U+4140 */
  0x0002,   /* U+4141 */
  0x0002,   /* U+4142 */
  0x0002,   /* U+4143 */
  0x0002,   /* U+4144 */
  0x0002,   /* U+4145 */
  0x0002,   /* U+4146 */
  0x0002,   /* U+4147 */
  0x0002,   /* U+4148 */
  0x0002,   /* U+4149 */
  0x0002,   /* U+414A */
  0x0002,   /* U+414B */
  0x0002,   /* U+414C */
  0x0002,   /* U+414D */
  0x0002,   /* U+414E */
  0x0002,   /* U+414F */
  0x0002,   /* U+4150 */
  0x0002,   /* U+4151 */
  0x0002,   /* U+4152 */
  0x0002,   /* U+4153 */
  0x0002,   /* U+4154 */
  0x0002,   /* U+4155 */
  0x0002,   /* U+4156 */
  0x0002,   /* U+4157 */
  0x0002,   /* U+4158 */
  0x0002,   /* U+4159 */
  0x0002,   /* U+415A */
  0x0002,   /* U+415B */
  0x0002,   /* U+415C */
  0x0002,   /* U+415D */
  0x0002,   /* U+415E */
  0x0002,   /* U+415F */
  0x0002,   /* U+4160 */
  0x0002,   /* U+4161 */
  0x0002,   /* U+4162 */
  0x0002,   /* U+4163 */
  0x0002,   /* U+4164 */
  0x0002,   /* U+4165 */
  0x0002,   /* U+4166 */
  0x0002,   /* U+4167 */
  0x0002,   /* U+4168 */
  0x0002,   /* U+4169 */
  0x0002,   /* U+416A */
  0x0002,   /* U+416B */
  0x0002,   /* U+416C */
  0x0002,   /* U+416D */
  0x0002,   /* U+416E */
  0x0002,   /* U+416F */
  0x0002,   /* U+4170 */
  0x0002,   /* U+4171 */
  0x0002,   /* U+4172 */
  0x0002,   /* U+4173 */
  0x0002,   /* U+4174 */
  0x0002,   /* U+4175 */
  0x0002,   /* U+4176 */
  0x0002,   /* U+4177 */
  0x0002,   /* U+4178 */
  0x0002,   /* U+4179 */
  0x0002,   /* U+417A */
  0x0002,   /* U+417B */
  0x0002,   /* U+417C */
  0x0002,   /* U+417D */
  0x0002,   /* U+417E */
  0x0002,   /* U+417F */
  0x0002,   /* U+4180 */
  0x0002,   /* U+4181 */
  0x0002,   /* U+4182 */
  0x0002,   /* U+4183 */
  0x0002,   /* U+4184 */
  0x0002,   /* U+4185 */
  0x0002,   /* U+4186 */
  0x0002,   /* U+4187 */
  0x0002,   /* U+4188 */
  0x0002,   /* U+4189 */
  0x0002,   /* U+418A */
  0x0002,   /* U+418B */
  0x0002,   /* U+418C */
  0x0002,   /* U+418D */
  0x0002,   /* U+418E */
  0x0002,   /* U+418F */
  0x0002,   /* U+4190 */
  0x0002,   /* U+4191 */
  0x0002,   /* U+4192 */
  0x0002,   /* U+4193 */
  0x0002,   /* U+4194 */
  0x0002,   /* U+4195 */
  0x0002,   /* U+4196 */
  0x0002,   /* U+4197 */
  0x0002,   /* U+4198 */
  0x0002,   /* U+4199 */
  0x0002,   /* U+419A */
  0x0002,   /* U+419B */
  0x0002,   /* U+419C */
  0x0002,   /* U+419D */
  0x0002,   /* U+419E */
  0x0002,   /* U+419F */
  0x0002,   /* U+41A0 */
  0x0002,   /* U+41A1 */
  0x0002,   /* U+41A2 */
  0x0002,   /* U+41A3 */
  0x0002,   /* U+41A4 */
  0x0002,   /* U+41A5 */
  0x0002,   /* U+41A6 */
  0x0002,   /* U+41A7 */
  0x0002,   /* U+41A8 */
  0x0002,   /* U+41A9 */
  0x0002,   /* U+41AA */
  0x0002,   /* U+41AB */
  0x0002,   /* U+41AC */
  0x0002,   /* U+41AD */
  0x0002,   /* U+41AE */
  0x0002,   /* U+41AF */
  0x0002,   /* U+41B0 */
  0x0002,   /* U+41B1 */
  0x0002,   /* U+41B2 */
  0x0002,   /* U+41B3 */
  0x0002,   /* U+41B4 */
  0x0002,   /* U+41B5 */
  0x0002,   /* U+41B6 */
  0x0002,   /* U+41B7 */
  0x0002,   /* U+41B8 */
  0x0002,   /* U+41B9 */
  0x0002,   /* U+41BA */
  0x0002,   /* U+41BB */
  0x0002,   /* U+41BC */
  0x0002,   /* U+41BD */
  0x0002,   /* U+41BE */
  0x0002,   /* U+41BF */
  0x0002,   /* U+41C0 */
  0x0002,   /* U+41C1 */
  0x0002,   /* U+41C2 */
  0x0002,   /* U+41C3 */
  0x0002,   /* U+41C4 */
  0x0002,   /* U+41C5 */
  0x0002,   /* U+41C6 */
  0x0002,   /* U+41C7 */
  0x0002,   /* U+41C8 */
  0x0002,   /* U+41C9 */
  0x0002,   /* U+41CA */
  0x0002,   /* U+41CB */
  0x0002,   /* U+41CC */
  0x0002,   /* U+41CD */
  0x0002,   /* U+41CE */
  0x0002,   /* U+41CF */
  0x0002,   /* U+41D0 */
  0x0002,   /* U+41D1 */
  0x0002,   /* U+41D2 */
  0x0002,   /* U+41D3 */
  0x0002,   /* U+41D4 */
  0x0002,   /* U+41D5 */
  0x0002,   /* U+41D6 */
  0x0002,   /* U+41D7 */
  0x0002,   /* U+41D8 */
  0x0002,   /* U+41D9 */
  0x0002,   /* U+41DA */
  0x0002,   /* U+41DB */
  0x0002,   /* U+41DC */
  0x0002,   /* U+41DD */
  0x0002,   /* U+41DE */
  0x0002,   /* U+41DF */
  0x0002,   /* U+41E0 */
  0x0002,   /* U+41E1 */
  0x0002,   /* U+41E2 */
  0x0002,   /* U+41E3 */
  0x0002,   /* U+41E4 */
  0x0002,   /* U+41E5 */
  0x0002,   /* U+41E6 */
  0x0002,   /* U+41E7 */
  0x0002,   /* U+41E8 */
  0x0002,   /* U+41E9 */
  0x0002,   /* U+41EA */
  0x0002,   /* U+41EB */
  0x0002,   /* U+41EC */
  0x0002,   /* U+41ED */
  0x0002,   /* U+41EE */
  0x0002,   /* U+41EF */
  0x0002,   /* U+41F0 */
  0x0002,   /* U+41F1 */
  0x0002,   /* U+41F2 */
  0x0002,   /* U+41F3 */
  0x0002,   /* U+41F4 */
  0x0002,   /* U+41F5 */
  0x0002,   /* U+41F6 */
  0x0002,   /* U+41F7 */
  0x0002,   /* U+41F8 */
  0x0002,   /* U+41F9 */
  0x0002,   /* U+41FA */
  0x0002,   /* U+41FB */
  0x0002,   /* U+41FC */
  0x0002,   /* U+41FD */
  0x0002,   /* U+41FE */
  0x0002,   /* U+41FF */

  /* Primary weight 2 for each character. */
  0x8003,   /* U+4100 */
  0x8000,   /* U+4101 */
  0x8001,   /* U+4102 */
  0x8002,   /* U+4103 */
  0x8000,   /* U+4104 */
  0x8001,   /* U+4105 */
  0x8002,   /* U+4106 */
  0x8000,   /* U+4107 */
  0x8001,   /* U+4108 */
  0x8002,   /* U+4109 */
  0x8003,   /* U+410A */
  0x8000,   /* U+410B */
  0x8001,   /* U+410C */
  0x8002,   /* U+410D */
  0x8003,   /* U+410E */
  0x8004,   /* U+410F */
  0x8005,   /* U+4110 */
  0x8006,   /* U+4111 */
  0x8007,   /* U+4112 */
  0x8000,   /* U+4113 */
  0x8001,   /* U+4114 */
  0x8002,   /* U+4115 */
  0x8003,   /* U+4116 */
  0xC117,   /* U+4117 */
  0x8000,   /* U+4118 */
  0x8001,   /* U+4119 */
  0x8000,   /* U+411A */
  0x8001,   /* U+411B */
  0x8002,   /* U+411C */
  0x8003,   /* U+411D */
  0xC11E,   /* U+411E */
  0x8000,   /* U+411F */
  0x8000,   /* U+4120 */
  0x8001,   /* U+4121 */
  0x8000,   /* U+4122 */
  0xC123,   /* U+4123 */
  0x8000,   /* U+4124 */
  0x8000,   /* U+4125 */
  0x8000,   /* U+4126 */
  0x8001,   /* U+4127 */
  0x8000,   /* U+4128 */
  0x8001,   /* U+4129 */
  0x8002,   /* U+412A */
  0x8003,   /* U+412B */
  0x8004,   /* U+412C */
  0x8005,   /* U+412D */
  0x8000,   /* U+412E */
  0x8001,   /* U+412F */
  0x8002,   /* U+4130 */
  0x8003,   /* U+4131 */
  0x8004,   /* U+4132 */
  0x8005,   /* U+4133 */
  0x8006,   /* U+4134 */
  0xC135,   /* U+4135 */
  0x8000,   /* U+4136 */
  0x8001,   /* U+4137 */
  0x8002,   /* U+4138 */
  0x8003,   /* U+4139 */
  0x8000,   /* U+413A */
  0x8001,   /* U+413B */
  0x8002,   /* U+413C */
  0x8003,   /* U+413D */
  0x8004,   /* U+413E */
  0x8005,   /* U+413F */
  0x8006,   /* U+4140 */
  0x8007,   /* U+4141 */
  0x8008,   /* U+4142 */
  0x8009,   /* U+4143 */
  0x800A,   /* U+4144 */
  0x800B,   /* U+4145 */
  0x800C,   /* U+4146 */
  0x800D,   /* U+4147 */
  0x800E,   /* U+4148 */
  0x800F,   /* U+4149 */
  0x8010,   /* U+414A */
  0x8000,   /* U+414B */
  0x8001,   /* U+414C */
  0x8002,   /* U+414D */
  0x8003,   /* U+414E */
  0x8004,   /* U+414F */
  0x8005,   /* U+4150 */
  0x8006,   /* U+4151 */
  0x8007,   /* U+4152 */
  0x8008,   /* U+4153 */
  0x8000,   /* U+4154 */
  0x8001,   /* U+4155 */
  0x8002,   /* U+4156 */
  0x8003,   /* U+4157 */
  0x8004,   /* U+4158 */
  0x8005,   /* U+4159 */
  0x8006,   /* U+415A */
  0x8007,   /* U+415B */
  0x8008,   /* U+415C */
  0x8009,   /* U+415D */
  0x800A,   /* U+415E */
  0x800B,   /* U+415F */
  0x8000,   /* U+4160 */
  0x8001,   /* U+4161 */
  0x8002,   /* U+4162 */
  0x8003,   /* U+4163 */
  0x8004,   /* U+4164 */
  0x8005,   /* U+4165 */
  0x8006,   /* U+4166 */
  0x8007,   /* U+4167 */
  0x8008,   /* U+4168 */
  0x8009,   /* U+4169 */
  0x800A,   /* U+416A */
  0xC16B,   /* U+416B */
  0x8000,   /* U+416C */
  0x8001,   /* U+416D */
  0x8002,   /* U+416E */
  0x8003,   /* U+416F */
  0x8004,   /* U+4170 */
  0x8005,   /* U+4171 */
  0x8006,   /* U+4172 */
  0x8007,   /* U+4173 */
  0x8008,   /* U+4174 */
  0x8009,   /* U+4175 */
  0x800A,   /* U+4176 */
  0x8000,   /* U+4177 */
  0x8001,   /* U+4178 */
  0x8002,   /* U+4179 */
  0x8003,   /* U+417A */
  0x8004,   /* U+417B */
  0x8005,   /* U+417C */
  0x8006,   /* U+417D */
  0x8000,   /* U+417E */
  0x8001,   /* U+417F */
  0x8002,   /* U+4180 */
  0x8000,   /* U+4181 */
  0x8001,   /* U+4182 */
  0x8002,   /* U+4183 */
  0x8003,   /* U+4184 */
  0x8004,   /* U+4185 */
  0xC186,   /* U+4186 */
  0xC187,   /* U+4187 */
  0x8000,   /* U+4188 */
  0x8001,   /* U+4189 */
  0x8000,   /* U+418A */
  0xC18B,   /* U+418B */
  0x8001,   /* U+418C */
  0x8002,   /* U+418D */
  0x8000,   /* U+418E */
  0x8001,   /* U+418F */
  0x8000,   /* U+4190 */
  0x8000,   /* U+4191 */
  0x8000,   /* U+4192 */
  0x8000,   /* U+4193 */
  0x8001,   /* U+4194 */
  0x8002,   /* U+4195 */
  0x8003,   /* U+4196 */
  0x8000,   /* U+4197 */
  0x8001,   /* U+4198 */
  0x8002,   /* U+4199 */
  0x8000,   /* U+419A */
  0x8001,   /* U+419B */
  0x8002,   /* U+419C */
  0x8003,   /* U+419D */
  0x8004,   /* U+419E */
  0x8005,   /* U+419F */
  0x8006,   /* U+41A0 */
  0x8000,   /* U+41A1 */
  0x8001,   /* U+41A2 */
  0x8002,   /* U+41A3 */
  0x8003,   /* U+41A4 */
  0x8004,   /* U+41A5 */
  0x8000,   /* U+41A6 */
  0x8001,   /* U+41A7 */
  0x8002,   /* U+41A8 */
  0x8003,   /* U+41A9 */
  0x8000,   /* U+41AA */
  0x8001,   /* U+41AB */
  0x8000,   /* U+41AC */
  0x8001,   /* U+41AD */
  0x8002,   /* U+41AE */
  0x8000,   /* U+41AF */
  0x8001,   /* U+41B0 */
  0x8002,   /* U+41B1 */
  0x8003,   /* U+41B2 */
  0x8004,   /* U+41B3 */
  0xC1B4,   /* U+41B4 */
  0x8000,   /* U+41B5 */
  0x8001,   /* U+41B6 */
  0x8002,   /* U+41B7 */
  0x8003,   /* U+41B8 */
  0x8004,   /* U+41B9 */
  0x8005,   /* U+41BA */
  0x8006,   /* U+41BB */
  0x8000,   /* U+41BC */
  0x8001,   /* U+41BD */
  0x8000,   /* U+41BE */
  0x8001,   /* U+41BF */
  0x8000,   /* U+41C0 */
  0x8000,   /* U+41C1 */
  0x8000,   /* U+41C2 */
  0x8000,   /* U+41C3 */
  0x8001,   /* U+41C4 */
  0x8000,   /* U+41C5 */
  0x8001,   /* U+41C6 */
  0x8000,   /* U+41C7 */
  0x8001,   /* U+41C8 */
  0x8002,   /* U+41C9 */
  0xC1CA,   /* U+41CA */
  0x8000,   /* U+41CB */
  0x8000,   /* U+41CC */
  0x8001,   /* U+41CD */
  0x8000,   /* U+41CE */
  0x8001,   /* U+41CF */
  0x8002,   /* U+41D0 */
  0x8003,   /* U+41D1 */
  0x8000,   /* U+41D2 */
  0x8000,   /* U+41D3 */
  0x8000,   /* U+41D4 */
  0x8000,   /* U+41D5 */
  0x8000,   /* U+41D6 */
  0x8000,   /* U+41D7 */
  0x8001,   /* U+41D8 */
  0x8002,   /* U+41D9 */
  0x8003,   /* U+41DA */
  0x8004,   /* U+41DB */
  0x8005,   /* U+41DC */
  0x8006,   /* U+41DD */
  0x8000,   /* U+41DE */
  0x8001,   /* U+41DF */
  0x8002,   /* U+41E0 */
  0x8003,   /* U+41E1 */
  0x8004,   /* U+41E2 */
  0x8005,   /* U+41E3 */
  0x8006,   /* U+41E4 */
  0x8007,   /* U+41E5 */
  0x8008,   /* U+41E6 */
  0x8000,   /* U+41E7 */
  0x8001,   /* U+41E8 */
  0x8002,   /* U+41E9 */
  0x8003,   /* U+41EA */
  0x8004,   /* U+41EB */
  0x8005,   /* U+41EC */
  0x8006,   /* U+41ED */
  0x8007,   /* U+41EE */
  0x8008,   /* U+41EF */
  0x8009,   /* U+41F0 */
  0x800A,   /* U+41F1 */
  0x800B,   /* U+41F2 */
  0xC1F3,   /* U+41F3 */
  0x800C,   /* U+41F4 */
  0x8000,   /* U+41F5 */
  0x8001,   /* U+41F6 */
  0x8002,   /* U+41F7 */
  0x8003,   /* U+41F8 */
  0x8004,   /* U+41F9 */
  0x8005,   /* U+41FA */
  0x8006,   /* U+41FB */
  0x8007,   /* U+41FC */
  0x8008,   /* U+41FD */
  0x8009,   /* U+41FE */
  0xC1FF,   /* U+41FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4100 */
  0x0000,   /* U+4101 */
  0x0000,   /* U+4102 */
  0x0000,   /* U+4103 */
  0x0000,   /* U+4104 */
  0x0000,   /* U+4105 */
  0x0000,   /* U+4106 */
  0x0000,   /* U+4107 */
  0x0000,   /* U+4108 */
  0x0000,   /* U+4109 */
  0x0000,   /* U+410A */
  0x0000,   /* U+410B */
  0x0000,   /* U+410C */
  0x0000,   /* U+410D */
  0x0000,   /* U+410E */
  0x0000,   /* U+410F */
  0x0000,   /* U+4110 */
  0x0000,   /* U+4111 */
  0x0000,   /* U+4112 */
  0x0000,   /* U+4113 */
  0x0000,   /* U+4114 */
  0x0000,   /* U+4115 */
  0x0000,   /* U+4116 */
  0x0000,   /* U+4117 */
  0x0000,   /* U+4118 */
  0x0000,   /* U+4119 */
  0x0000,   /* U+411A */
  0x0000,   /* U+411B */
  0x0000,   /* U+411C */
  0x0000,   /* U+411D */
  0x0000,   /* U+411E */
  0x0000,   /* U+411F */
  0x0000,   /* U+4120 */
  0x0000,   /* U+4121 */
  0x0000,   /* U+4122 */
  0x0000,   /* U+4123 */
  0x0000,   /* U+4124 */
  0x0000,   /* U+4125 */
  0x0000,   /* U+4126 */
  0x0000,   /* U+4127 */
  0x0000,   /* U+4128 */
  0x0000,   /* U+4129 */
  0x0000,   /* U+412A */
  0x0000,   /* U+412B */
  0x0000,   /* U+412C */
  0x0000,   /* U+412D */
  0x0000,   /* U+412E */
  0x0000,   /* U+412F */
  0x0000,   /* U+4130 */
  0x0000,   /* U+4131 */
  0x0000,   /* U+4132 */
  0x0000,   /* U+4133 */
  0x0000,   /* U+4134 */
  0x0000,   /* U+4135 */
  0x0000,   /* U+4136 */
  0x0000,   /* U+4137 */
  0x0000,   /* U+4138 */
  0x0000,   /* U+4139 */
  0x0000,   /* U+413A */
  0x0000,   /* U+413B */
  0x0000,   /* U+413C */
  0x0000,   /* U+413D */
  0x0000,   /* U+413E */
  0x0000,   /* U+413F */
  0x0000,   /* U+4140 */
  0x0000,   /* U+4141 */
  0x0000,   /* U+4142 */
  0x0000,   /* U+4143 */
  0x0000,   /* U+4144 */
  0x0000,   /* U+4145 */
  0x0000,   /* U+4146 */
  0x0000,   /* U+4147 */
  0x0000,   /* U+4148 */
  0x0000,   /* U+4149 */
  0x0000,   /* U+414A */
  0x0000,   /* U+414B */
  0x0000,   /* U+414C */
  0x0000,   /* U+414D */
  0x0000,   /* U+414E */
  0x0000,   /* U+414F */
  0x0000,   /* U+4150 */
  0x0000,   /* U+4151 */
  0x0000,   /* U+4152 */
  0x0000,   /* U+4153 */
  0x0000,   /* U+4154 */
  0x0000,   /* U+4155 */
  0x0000,   /* U+4156 */
  0x0000,   /* U+4157 */
  0x0000,   /* U+4158 */
  0x0000,   /* U+4159 */
  0x0000,   /* U+415A */
  0x0000,   /* U+415B */
  0x0000,   /* U+415C */
  0x0000,   /* U+415D */
  0x0000,   /* U+415E */
  0x0000,   /* U+415F */
  0x0000,   /* U+4160 */
  0x0000,   /* U+4161 */
  0x0000,   /* U+4162 */
  0x0000,   /* U+4163 */
  0x0000,   /* U+4164 */
  0x0000,   /* U+4165 */
  0x0000,   /* U+4166 */
  0x0000,   /* U+4167 */
  0x0000,   /* U+4168 */
  0x0000,   /* U+4169 */
  0x0000,   /* U+416A */
  0x0000,   /* U+416B */
  0x0000,   /* U+416C */
  0x0000,   /* U+416D */
  0x0000,   /* U+416E */
  0x0000,   /* U+416F */
  0x0000,   /* U+4170 */
  0x0000,   /* U+4171 */
  0x0000,   /* U+4172 */
  0x0000,   /* U+4173 */
  0x0000,   /* U+4174 */
  0x0000,   /* U+4175 */
  0x0000,   /* U+4176 */
  0x0000,   /* U+4177 */
  0x0000,   /* U+4178 */
  0x0000,   /* U+4179 */
  0x0000,   /* U+417A */
  0x0000,   /* U+417B */
  0x0000,   /* U+417C */
  0x0000,   /* U+417D */
  0x0000,   /* U+417E */
  0x0000,   /* U+417F */
  0x0000,   /* U+4180 */
  0x0000,   /* U+4181 */
  0x0000,   /* U+4182 */
  0x0000,   /* U+4183 */
  0x0000,   /* U+4184 */
  0x0000,   /* U+4185 */
  0x0000,   /* U+4186 */
  0x0000,   /* U+4187 */
  0x0000,   /* U+4188 */
  0x0000,   /* U+4189 */
  0x0000,   /* U+418A */
  0x0000,   /* U+418B */
  0x0000,   /* U+418C */
  0x0000,   /* U+418D */
  0x0000,   /* U+418E */
  0x0000,   /* U+418F */
  0x0000,   /* U+4190 */
  0x0000,   /* U+4191 */
  0x0000,   /* U+4192 */
  0x0000,   /* U+4193 */
  0x0000,   /* U+4194 */
  0x0000,   /* U+4195 */
  0x0000,   /* U+4196 */
  0x0000,   /* U+4197 */
  0x0000,   /* U+4198 */
  0x0000,   /* U+4199 */
  0x0000,   /* U+419A */
  0x0000,   /* U+419B */
  0x0000,   /* U+419C */
  0x0000,   /* U+419D */
  0x0000,   /* U+419E */
  0x0000,   /* U+419F */
  0x0000,   /* U+41A0 */
  0x0000,   /* U+41A1 */
  0x0000,   /* U+41A2 */
  0x0000,   /* U+41A3 */
  0x0000,   /* U+41A4 */
  0x0000,   /* U+41A5 */
  0x0000,   /* U+41A6 */
  0x0000,   /* U+41A7 */
  0x0000,   /* U+41A8 */
  0x0000,   /* U+41A9 */
  0x0000,   /* U+41AA */
  0x0000,   /* U+41AB */
  0x0000,   /* U+41AC */
  0x0000,   /* U+41AD */
  0x0000,   /* U+41AE */
  0x0000,   /* U+41AF */
  0x0000,   /* U+41B0 */
  0x0000,   /* U+41B1 */
  0x0000,   /* U+41B2 */
  0x0000,   /* U+41B3 */
  0x0000,   /* U+41B4 */
  0x0000,   /* U+41B5 */
  0x0000,   /* U+41B6 */
  0x0000,   /* U+41B7 */
  0x0000,   /* U+41B8 */
  0x0000,   /* U+41B9 */
  0x0000,   /* U+41BA */
  0x0000,   /* U+41BB */
  0x0000,   /* U+41BC */
  0x0000,   /* U+41BD */
  0x0000,   /* U+41BE */
  0x0000,   /* U+41BF */
  0x0000,   /* U+41C0 */
  0x0000,   /* U+41C1 */
  0x0000,   /* U+41C2 */
  0x0000,   /* U+41C3 */
  0x0000,   /* U+41C4 */
  0x0000,   /* U+41C5 */
  0x0000,   /* U+41C6 */
  0x0000,   /* U+41C7 */
  0x0000,   /* U+41C8 */
  0x0000,   /* U+41C9 */
  0x0000,   /* U+41CA */
  0x0000,   /* U+41CB */
  0x0000,   /* U+41CC */
  0x0000,   /* U+41CD */
  0x0000,   /* U+41CE */
  0x0000,   /* U+41CF */
  0x0000,   /* U+41D0 */
  0x0000,   /* U+41D1 */
  0x0000,   /* U+41D2 */
  0x0000,   /* U+41D3 */
  0x0000,   /* U+41D4 */
  0x0000,   /* U+41D5 */
  0x0000,   /* U+41D6 */
  0x0000,   /* U+41D7 */
  0x0000,   /* U+41D8 */
  0x0000,   /* U+41D9 */
  0x0000,   /* U+41DA */
  0x0000,   /* U+41DB */
  0x0000,   /* U+41DC */
  0x0000,   /* U+41DD */
  0x0000,   /* U+41DE */
  0x0000,   /* U+41DF */
  0x0000,   /* U+41E0 */
  0x0000,   /* U+41E1 */
  0x0000,   /* U+41E2 */
  0x0000,   /* U+41E3 */
  0x0000,   /* U+41E4 */
  0x0000,   /* U+41E5 */
  0x0000,   /* U+41E6 */
  0x0000,   /* U+41E7 */
  0x0000,   /* U+41E8 */
  0x0000,   /* U+41E9 */
  0x0000,   /* U+41EA */
  0x0000,   /* U+41EB */
  0x0000,   /* U+41EC */
  0x0000,   /* U+41ED */
  0x0000,   /* U+41EE */
  0x0000,   /* U+41EF */
  0x0000,   /* U+41F0 */
  0x0000,   /* U+41F1 */
  0x0000,   /* U+41F2 */
  0x0000,   /* U+41F3 */
  0x0000,   /* U+41F4 */
  0x0000,   /* U+41F5 */
  0x0000,   /* U+41F6 */
  0x0000,   /* U+41F7 */
  0x0000,   /* U+41F8 */
  0x0000,   /* U+41F9 */
  0x0000,   /* U+41FA */
  0x0000,   /* U+41FB */
  0x0000,   /* U+41FC */
  0x0000,   /* U+41FD */
  0x0000,   /* U+41FE */
  0x0000,   /* U+41FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4100 */
  0x0000,   /* U+4101 */
  0x0000,   /* U+4102 */
  0x0000,   /* U+4103 */
  0x0000,   /* U+4104 */
  0x0000,   /* U+4105 */
  0x0000,   /* U+4106 */
  0x0000,   /* U+4107 */
  0x0000,   /* U+4108 */
  0x0000,   /* U+4109 */
  0x0000,   /* U+410A */
  0x0000,   /* U+410B */
  0x0000,   /* U+410C */
  0x0000,   /* U+410D */
  0x0000,   /* U+410E */
  0x0000,   /* U+410F */
  0x0000,   /* U+4110 */
  0x0000,   /* U+4111 */
  0x0000,   /* U+4112 */
  0x0000,   /* U+4113 */
  0x0000,   /* U+4114 */
  0x0000,   /* U+4115 */
  0x0000,   /* U+4116 */
  0x0000,   /* U+4117 */
  0x0000,   /* U+4118 */
  0x0000,   /* U+4119 */
  0x0000,   /* U+411A */
  0x0000,   /* U+411B */
  0x0000,   /* U+411C */
  0x0000,   /* U+411D */
  0x0000,   /* U+411E */
  0x0000,   /* U+411F */
  0x0000,   /* U+4120 */
  0x0000,   /* U+4121 */
  0x0000,   /* U+4122 */
  0x0000,   /* U+4123 */
  0x0000,   /* U+4124 */
  0x0000,   /* U+4125 */
  0x0000,   /* U+4126 */
  0x0000,   /* U+4127 */
  0x0000,   /* U+4128 */
  0x0000,   /* U+4129 */
  0x0000,   /* U+412A */
  0x0000,   /* U+412B */
  0x0000,   /* U+412C */
  0x0000,   /* U+412D */
  0x0000,   /* U+412E */
  0x0000,   /* U+412F */
  0x0000,   /* U+4130 */
  0x0000,   /* U+4131 */
  0x0000,   /* U+4132 */
  0x0000,   /* U+4133 */
  0x0000,   /* U+4134 */
  0x0000,   /* U+4135 */
  0x0000,   /* U+4136 */
  0x0000,   /* U+4137 */
  0x0000,   /* U+4138 */
  0x0000,   /* U+4139 */
  0x0000,   /* U+413A */
  0x0000,   /* U+413B */
  0x0000,   /* U+413C */
  0x0000,   /* U+413D */
  0x0000,   /* U+413E */
  0x0000,   /* U+413F */
  0x0000,   /* U+4140 */
  0x0000,   /* U+4141 */
  0x0000,   /* U+4142 */
  0x0000,   /* U+4143 */
  0x0000,   /* U+4144 */
  0x0000,   /* U+4145 */
  0x0000,   /* U+4146 */
  0x0000,   /* U+4147 */
  0x0000,   /* U+4148 */
  0x0000,   /* U+4149 */
  0x0000,   /* U+414A */
  0x0000,   /* U+414B */
  0x0000,   /* U+414C */
  0x0000,   /* U+414D */
  0x0000,   /* U+414E */
  0x0000,   /* U+414F */
  0x0000,   /* U+4150 */
  0x0000,   /* U+4151 */
  0x0000,   /* U+4152 */
  0x0000,   /* U+4153 */
  0x0000,   /* U+4154 */
  0x0000,   /* U+4155 */
  0x0000,   /* U+4156 */
  0x0000,   /* U+4157 */
  0x0000,   /* U+4158 */
  0x0000,   /* U+4159 */
  0x0000,   /* U+415A */
  0x0000,   /* U+415B */
  0x0000,   /* U+415C */
  0x0000,   /* U+415D */
  0x0000,   /* U+415E */
  0x0000,   /* U+415F */
  0x0000,   /* U+4160 */
  0x0000,   /* U+4161 */
  0x0000,   /* U+4162 */
  0x0000,   /* U+4163 */
  0x0000,   /* U+4164 */
  0x0000,   /* U+4165 */
  0x0000,   /* U+4166 */
  0x0000,   /* U+4167 */
  0x0000,   /* U+4168 */
  0x0000,   /* U+4169 */
  0x0000,   /* U+416A */
  0x0000,   /* U+416B */
  0x0000,   /* U+416C */
  0x0000,   /* U+416D */
  0x0000,   /* U+416E */
  0x0000,   /* U+416F */
  0x0000,   /* U+4170 */
  0x0000,   /* U+4171 */
  0x0000,   /* U+4172 */
  0x0000,   /* U+4173 */
  0x0000,   /* U+4174 */
  0x0000,   /* U+4175 */
  0x0000,   /* U+4176 */
  0x0000,   /* U+4177 */
  0x0000,   /* U+4178 */
  0x0000,   /* U+4179 */
  0x0000,   /* U+417A */
  0x0000,   /* U+417B */
  0x0000,   /* U+417C */
  0x0000,   /* U+417D */
  0x0000,   /* U+417E */
  0x0000,   /* U+417F */
  0x0000,   /* U+4180 */
  0x0000,   /* U+4181 */
  0x0000,   /* U+4182 */
  0x0000,   /* U+4183 */
  0x0000,   /* U+4184 */
  0x0000,   /* U+4185 */
  0x0000,   /* U+4186 */
  0x0000,   /* U+4187 */
  0x0000,   /* U+4188 */
  0x0000,   /* U+4189 */
  0x0000,   /* U+418A */
  0x0000,   /* U+418B */
  0x0000,   /* U+418C */
  0x0000,   /* U+418D */
  0x0000,   /* U+418E */
  0x0000,   /* U+418F */
  0x0000,   /* U+4190 */
  0x0000,   /* U+4191 */
  0x0000,   /* U+4192 */
  0x0000,   /* U+4193 */
  0x0000,   /* U+4194 */
  0x0000,   /* U+4195 */
  0x0000,   /* U+4196 */
  0x0000,   /* U+4197 */
  0x0000,   /* U+4198 */
  0x0000,   /* U+4199 */
  0x0000,   /* U+419A */
  0x0000,   /* U+419B */
  0x0000,   /* U+419C */
  0x0000,   /* U+419D */
  0x0000,   /* U+419E */
  0x0000,   /* U+419F */
  0x0000,   /* U+41A0 */
  0x0000,   /* U+41A1 */
  0x0000,   /* U+41A2 */
  0x0000,   /* U+41A3 */
  0x0000,   /* U+41A4 */
  0x0000,   /* U+41A5 */
  0x0000,   /* U+41A6 */
  0x0000,   /* U+41A7 */
  0x0000,   /* U+41A8 */
  0x0000,   /* U+41A9 */
  0x0000,   /* U+41AA */
  0x0000,   /* U+41AB */
  0x0000,   /* U+41AC */
  0x0000,   /* U+41AD */
  0x0000,   /* U+41AE */
  0x0000,   /* U+41AF */
  0x0000,   /* U+41B0 */
  0x0000,   /* U+41B1 */
  0x0000,   /* U+41B2 */
  0x0000,   /* U+41B3 */
  0x0000,   /* U+41B4 */
  0x0000,   /* U+41B5 */
  0x0000,   /* U+41B6 */
  0x0000,   /* U+41B7 */
  0x0000,   /* U+41B8 */
  0x0000,   /* U+41B9 */
  0x0000,   /* U+41BA */
  0x0000,   /* U+41BB */
  0x0000,   /* U+41BC */
  0x0000,   /* U+41BD */
  0x0000,   /* U+41BE */
  0x0000,   /* U+41BF */
  0x0000,   /* U+41C0 */
  0x0000,   /* U+41C1 */
  0x0000,   /* U+41C2 */
  0x0000,   /* U+41C3 */
  0x0000,   /* U+41C4 */
  0x0000,   /* U+41C5 */
  0x0000,   /* U+41C6 */
  0x0000,   /* U+41C7 */
  0x0000,   /* U+41C8 */
  0x0000,   /* U+41C9 */
  0x0000,   /* U+41CA */
  0x0000,   /* U+41CB */
  0x0000,   /* U+41CC */
  0x0000,   /* U+41CD */
  0x0000,   /* U+41CE */
  0x0000,   /* U+41CF */
  0x0000,   /* U+41D0 */
  0x0000,   /* U+41D1 */
  0x0000,   /* U+41D2 */
  0x0000,   /* U+41D3 */
  0x0000,   /* U+41D4 */
  0x0000,   /* U+41D5 */
  0x0000,   /* U+41D6 */
  0x0000,   /* U+41D7 */
  0x0000,   /* U+41D8 */
  0x0000,   /* U+41D9 */
  0x0000,   /* U+41DA */
  0x0000,   /* U+41DB */
  0x0000,   /* U+41DC */
  0x0000,   /* U+41DD */
  0x0000,   /* U+41DE */
  0x0000,   /* U+41DF */
  0x0000,   /* U+41E0 */
  0x0000,   /* U+41E1 */
  0x0000,   /* U+41E2 */
  0x0000,   /* U+41E3 */
  0x0000,   /* U+41E4 */
  0x0000,   /* U+41E5 */
  0x0000,   /* U+41E6 */
  0x0000,   /* U+41E7 */
  0x0000,   /* U+41E8 */
  0x0000,   /* U+41E9 */
  0x0000,   /* U+41EA */
  0x0000,   /* U+41EB */
  0x0000,   /* U+41EC */
  0x0000,   /* U+41ED */
  0x0000,   /* U+41EE */
  0x0000,   /* U+41EF */
  0x0000,   /* U+41F0 */
  0x0000,   /* U+41F1 */
  0x0000,   /* U+41F2 */
  0x0000,   /* U+41F3 */
  0x0000,   /* U+41F4 */
  0x0000,   /* U+41F5 */
  0x0000,   /* U+41F6 */
  0x0000,   /* U+41F7 */
  0x0000,   /* U+41F8 */
  0x0000,   /* U+41F9 */
  0x0000,   /* U+41FA */
  0x0000,   /* U+41FB */
  0x0000,   /* U+41FC */
  0x0000,   /* U+41FD */
  0x0000,   /* U+41FE */
  0x0000,   /* U+41FF */
};

uint16 zh2_han_p042[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x39D3,   /* U+4200 */
  0x39D4,   /* U+4201 */
  0x39D4,   /* U+4202 */
  0x39D4,   /* U+4203 */
  0x39D4,   /* U+4204 */
  0x39D4,   /* U+4205 */
  0x39D4,   /* U+4206 */
  0x39D4,   /* U+4207 */
  0x39D4,   /* U+4208 */
  0x39D4,   /* U+4209 */
  0x39D4,   /* U+420A */
  0x39D4,   /* U+420B */
  0x39D4,   /* U+420C */
  0x39D4,   /* U+420D */
  0x39D5,   /* U+420E */
  0x39D5,   /* U+420F */
  0x39D5,   /* U+4210 */
  0x39D5,   /* U+4211 */
  0x39D5,   /* U+4212 */
  0x39D5,   /* U+4213 */
  0x39D5,   /* U+4214 */
  0x39D5,   /* U+4215 */
  0x39D5,   /* U+4216 */
  0x39D5,   /* U+4217 */
  0x39D5,   /* U+4218 */
  0x39D5,   /* U+4219 */
  0x39D5,   /* U+421A */
  0x39D5,   /* U+421B */
  0x39D5,   /* U+421C */
  0x39D5,   /* U+421D */
  0x39D5,   /* U+421E */
  0x39D5,   /* U+421F */
  0x39D5,   /* U+4220 */
  0x39D5,   /* U+4221 */
  0x39D5,   /* U+4222 */
  0x39D5,   /* U+4223 */
  0x39D5,   /* U+4224 */
  0x39D5,   /* U+4225 */
  0x39D5,   /* U+4226 */
  0x39D5,   /* U+4227 */
  0x39D5,   /* U+4228 */
  0x39D5,   /* U+4229 */
  0x39CD,   /* U+422A */
  0x39CD,   /* U+422B */
  0x39CD,   /* U+422C */
  0x39CD,   /* U+422D */
  0x39CD,   /* U+422E */
  0x39CD,   /* U+422F */
  0x39CD,   /* U+4230 */
  0x39CD,   /* U+4231 */
  0x39CD,   /* U+4232 */
  0x39CD,   /* U+4233 */
  0x39CD,   /* U+4234 */
  0x39CD,   /* U+4235 */
  0x39CD,   /* U+4236 */
  0x39CD,   /* U+4237 */
  0x39D7,   /* U+4238 */
  0x39D7,   /* U+4239 */
  0x39D7,   /* U+423A */
  0x39D7,   /* U+423B */
  0x39D7,   /* U+423C */
  0x39D7,   /* U+423D */
  0x39D7,   /* U+423E */
  0x39D7,   /* U+423F */
  0x39D7,   /* U+4240 */
  0x39D7,   /* U+4241 */
  0x39D7,   /* U+4242 */
  0x39D7,   /* U+4243 */
  0x39D7,   /* U+4244 */
  0x39D7,   /* U+4245 */
  0x39D7,   /* U+4246 */
  0x39D7,   /* U+4247 */
  0x39D8,   /* U+4248 */
  0x39D8,   /* U+4249 */
  0x39D8,   /* U+424A */
  0x39D8,   /* U+424B */
  0x39D8,   /* U+424C */
  0x39D8,   /* U+424D */
  0x39D8,   /* U+424E */
  0x39D9,   /* U+424F */
  0x39D8,   /* U+4250 */
  0x39D8,   /* U+4251 */
  0x39D8,   /* U+4252 */
  0x39D8,   /* U+4253 */
  0x39D8,   /* U+4254 */
  0x39D8,   /* U+4255 */
  0x39D8,   /* U+4256 */
  0x39D8,   /* U+4257 */
  0x39D8,   /* U+4258 */
  0x39D8,   /* U+4259 */
  0x39D8,   /* U+425A */
  0x39D9,   /* U+425B */
  0x39D9,   /* U+425C */
  0x39D9,   /* U+425D */
  0x39D9,   /* U+425E */
  0x39D9,   /* U+425F */
  0x39D9,   /* U+4260 */
  0x39D9,   /* U+4261 */
  0x39D9,   /* U+4262 */
  0x39D8,   /* U+4263 */
  0x5C49,   /* U+4264 */
  0x39DA,   /* U+4265 */
  0x39DB,   /* U+4266 */
  0x39DB,   /* U+4267 */
  0x39DB,   /* U+4268 */
  0x39DB,   /* U+4269 */
  0x39DB,   /* U+426A */
  0x39DB,   /* U+426B */
  0x39DB,   /* U+426C */
  0x39DB,   /* U+426D */
  0x39DC,   /* U+426E */
  0x39DC,   /* U+426F */
  0x39DC,   /* U+4270 */
  0x39DC,   /* U+4271 */
  0x39DD,   /* U+4272 */
  0x39DD,   /* U+4273 */
  0x39DD,   /* U+4274 */
  0x4A5A,   /* U+4275 */
  0x39DE,   /* U+4276 */
  0x39CE,   /* U+4277 */
  0x39E1,   /* U+4278 */
  0x39E4,   /* U+4279 */
  0x3A0F,   /* U+427A */
  0x3A10,   /* U+427B */
  0x3A10,   /* U+427C */
  0x3A11,   /* U+427D */
  0x3A11,   /* U+427E */
  0x3A11,   /* U+427F */
  0x3A11,   /* U+4280 */
  0x3A12,   /* U+4281 */
  0x3A12,   /* U+4282 */
  0x3A12,   /* U+4283 */
  0x3A12,   /* U+4284 */
  0x3A12,   /* U+4285 */
  0x3A12,   /* U+4286 */
  0x3A13,   /* U+4287 */
  0x3A13,   /* U+4288 */
  0x3A13,   /* U+4289 */
  0x3A13,   /* U+428A */
  0x3A13,   /* U+428B */
  0x3A13,   /* U+428C */
  0x3A14,   /* U+428D */
  0x3A14,   /* U+428E */
  0x3A14,   /* U+428F */
  0x3A14,   /* U+4290 */
  0x3A14,   /* U+4291 */
  0x3A14,   /* U+4292 */
  0x3A15,   /* U+4293 */
  0x3A15,   /* U+4294 */
  0x3A15,   /* U+4295 */
  0x3A15,   /* U+4296 */
  0x3A15,   /* U+4297 */
  0x3A15,   /* U+4298 */
  0x3A15,   /* U+4299 */
  0x3A0D,   /* U+429A */
  0x3A0D,   /* U+429B */
  0x3A17,   /* U+429C */
  0x3A17,   /* U+429D */
  0x3A17,   /* U+429E */
  0x3A17,   /* U+429F */
  0x3A17,   /* U+42A0 */
  0x3A17,   /* U+42A1 */
  0x5C49,   /* U+42A2 */
  0x3A18,   /* U+42A3 */
  0x3A18,   /* U+42A4 */
  0x3A18,   /* U+42A5 */
  0x3A18,   /* U+42A6 */
  0x3A18,   /* U+42A7 */
  0x3A18,   /* U+42A8 */
  0x3A18,   /* U+42A9 */
  0x3A19,   /* U+42AA */
  0x3A19,   /* U+42AB */
  0x3A19,   /* U+42AC */
  0x3A1A,   /* U+42AD */
  0x3A1A,   /* U+42AE */
  0x3A1B,   /* U+42AF */
  0x3A1C,   /* U+42B0 */
  0x3A1D,   /* U+42B1 */
  0x3A1D,   /* U+42B2 */
  0x3A1F,   /* U+42B3 */
  0x3A1F,   /* U+42B4 */
  0x3A4E,   /* U+42B5 */
  0x3A4F,   /* U+42B6 */
  0x3A4F,   /* U+42B7 */
  0x3A4F,   /* U+42B8 */
  0x3A4F,   /* U+42B9 */
  0x3A50,   /* U+42BA */
  0x3A50,   /* U+42BB */
  0x3A50,   /* U+42BC */
  0x3A50,   /* U+42BD */
  0x3A50,   /* U+42BE */
  0x3A50,   /* U+42BF */
  0x3A50,   /* U+42C0 */
  0x3A50,   /* U+42C1 */
  0x3A50,   /* U+42C2 */
  0x3A50,   /* U+42C3 */
  0x3A50,   /* U+42C4 */
  0x5C49,   /* U+42C5 */
  0x5C49,   /* U+42C6 */
  0x5C49,   /* U+42C7 */
  0x3A51,   /* U+42C8 */
  0x3A51,   /* U+42C9 */
  0x3A51,   /* U+42CA */
  0x3A51,   /* U+42CB */
  0x3A51,   /* U+42CC */
  0x3A51,   /* U+42CD */
  0x3A51,   /* U+42CE */
  0x3A51,   /* U+42CF */
  0x3A51,   /* U+42D0 */
  0x3A51,   /* U+42D1 */
  0x3A51,   /* U+42D2 */
  0x3A51,   /* U+42D3 */
  0x3A51,   /* U+42D4 */
  0x3A52,   /* U+42D5 */
  0x3A52,   /* U+42D6 */
  0x3A52,   /* U+42D7 */
  0x3A52,   /* U+42D8 */
  0x3A52,   /* U+42D9 */
  0x3A52,   /* U+42DA */
  0x3A52,   /* U+42DB */
  0x3A52,   /* U+42DC */
  0x5C49,   /* U+42DD */
  0x5C49,   /* U+42DE */
  0x3A53,   /* U+42DF */
  0x3A53,   /* U+42E0 */
  0x3A53,   /* U+42E1 */
  0x3A53,   /* U+42E2 */
  0x3A53,   /* U+42E3 */
  0x3A53,   /* U+42E4 */
  0x3A53,   /* U+42E5 */
  0x3A53,   /* U+42E6 */
  0x3A54,   /* U+42E7 */
  0x3A54,   /* U+42E8 */
  0x3A54,   /* U+42E9 */
  0x3A54,   /* U+42EA */
  0x3A54,   /* U+42EB */
  0x3A54,   /* U+42EC */
  0x3A54,   /* U+42ED */
  0x3A54,   /* U+42EE */
  0x3A54,   /* U+42EF */
  0x3A54,   /* U+42F0 */
  0x3A54,   /* U+42F1 */
  0x3A54,   /* U+42F2 */
  0x3A55,   /* U+42F3 */
  0x3A55,   /* U+42F4 */
  0x3A55,   /* U+42F5 */
  0x3A55,   /* U+42F6 */
  0x3A55,   /* U+42F7 */
  0x3A55,   /* U+42F8 */
  0x3A55,   /* U+42F9 */
  0x3A55,   /* U+42FA */
  0x3A55,   /* U+42FB */
  0x3A55,   /* U+42FC */
  0x3A55,   /* U+42FD */
  0x3A55,   /* U+42FE */
  0x3A55,   /* U+42FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4200 */
  0x0020,   /* U+4201 */
  0x0020,   /* U+4202 */
  0x0020,   /* U+4203 */
  0x0020,   /* U+4204 */
  0x0020,   /* U+4205 */
  0x0020,   /* U+4206 */
  0x0020,   /* U+4207 */
  0x0020,   /* U+4208 */
  0x0020,   /* U+4209 */
  0x0020,   /* U+420A */
  0x0020,   /* U+420B */
  0x0020,   /* U+420C */
  0x0020,   /* U+420D */
  0x0020,   /* U+420E */
  0x0020,   /* U+420F */
  0x0020,   /* U+4210 */
  0x0020,   /* U+4211 */
  0x0020,   /* U+4212 */
  0x0020,   /* U+4213 */
  0x0020,   /* U+4214 */
  0x0020,   /* U+4215 */
  0x0020,   /* U+4216 */
  0x0020,   /* U+4217 */
  0x0020,   /* U+4218 */
  0x0020,   /* U+4219 */
  0x0020,   /* U+421A */
  0x0020,   /* U+421B */
  0x0020,   /* U+421C */
  0x0020,   /* U+421D */
  0x0020,   /* U+421E */
  0x0020,   /* U+421F */
  0x0020,   /* U+4220 */
  0x0020,   /* U+4221 */
  0x0020,   /* U+4222 */
  0x0020,   /* U+4223 */
  0x0020,   /* U+4224 */
  0x0020,   /* U+4225 */
  0x0020,   /* U+4226 */
  0x0020,   /* U+4227 */
  0x0020,   /* U+4228 */
  0x0020,   /* U+4229 */
  0x0020,   /* U+422A */
  0x0020,   /* U+422B */
  0x0020,   /* U+422C */
  0x0020,   /* U+422D */
  0x0020,   /* U+422E */
  0x0020,   /* U+422F */
  0x0020,   /* U+4230 */
  0x0020,   /* U+4231 */
  0x0020,   /* U+4232 */
  0x0020,   /* U+4233 */
  0x0020,   /* U+4234 */
  0x0020,   /* U+4235 */
  0x0020,   /* U+4236 */
  0x0020,   /* U+4237 */
  0x0020,   /* U+4238 */
  0x0020,   /* U+4239 */
  0x0020,   /* U+423A */
  0x0020,   /* U+423B */
  0x0020,   /* U+423C */
  0x0020,   /* U+423D */
  0x0020,   /* U+423E */
  0x0020,   /* U+423F */
  0x0020,   /* U+4240 */
  0x0020,   /* U+4241 */
  0x0020,   /* U+4242 */
  0x0020,   /* U+4243 */
  0x0020,   /* U+4244 */
  0x0020,   /* U+4245 */
  0x0020,   /* U+4246 */
  0x0020,   /* U+4247 */
  0x0020,   /* U+4248 */
  0x0020,   /* U+4249 */
  0x0020,   /* U+424A */
  0x0020,   /* U+424B */
  0x0020,   /* U+424C */
  0x0020,   /* U+424D */
  0x0020,   /* U+424E */
  0x0020,   /* U+424F */
  0x0020,   /* U+4250 */
  0x0020,   /* U+4251 */
  0x0020,   /* U+4252 */
  0x0020,   /* U+4253 */
  0x0020,   /* U+4254 */
  0x0020,   /* U+4255 */
  0x0020,   /* U+4256 */
  0x0020,   /* U+4257 */
  0x0020,   /* U+4258 */
  0x0020,   /* U+4259 */
  0x0020,   /* U+425A */
  0x0020,   /* U+425B */
  0x0020,   /* U+425C */
  0x0020,   /* U+425D */
  0x0020,   /* U+425E */
  0x0020,   /* U+425F */
  0x0020,   /* U+4260 */
  0x0020,   /* U+4261 */
  0x0020,   /* U+4262 */
  0x0020,   /* U+4263 */
  0x0020,   /* U+4264 */
  0x0020,   /* U+4265 */
  0x0020,   /* U+4266 */
  0x0020,   /* U+4267 */
  0x0020,   /* U+4268 */
  0x0020,   /* U+4269 */
  0x0020,   /* U+426A */
  0x0020,   /* U+426B */
  0x0020,   /* U+426C */
  0x0020,   /* U+426D */
  0x0020,   /* U+426E */
  0x0020,   /* U+426F */
  0x0020,   /* U+4270 */
  0x0020,   /* U+4271 */
  0x0020,   /* U+4272 */
  0x0020,   /* U+4273 */
  0x0020,   /* U+4274 */
  0x0020,   /* U+4275 */
  0x0020,   /* U+4276 */
  0x0020,   /* U+4277 */
  0x0020,   /* U+4278 */
  0x0020,   /* U+4279 */
  0x0020,   /* U+427A */
  0x0020,   /* U+427B */
  0x0020,   /* U+427C */
  0x0020,   /* U+427D */
  0x0020,   /* U+427E */
  0x0020,   /* U+427F */
  0x0020,   /* U+4280 */
  0x0020,   /* U+4281 */
  0x0020,   /* U+4282 */
  0x0020,   /* U+4283 */
  0x0020,   /* U+4284 */
  0x0020,   /* U+4285 */
  0x0020,   /* U+4286 */
  0x0020,   /* U+4287 */
  0x0020,   /* U+4288 */
  0x0020,   /* U+4289 */
  0x0020,   /* U+428A */
  0x0020,   /* U+428B */
  0x0020,   /* U+428C */
  0x0020,   /* U+428D */
  0x0020,   /* U+428E */
  0x0020,   /* U+428F */
  0x0020,   /* U+4290 */
  0x0020,   /* U+4291 */
  0x0020,   /* U+4292 */
  0x0020,   /* U+4293 */
  0x0020,   /* U+4294 */
  0x0020,   /* U+4295 */
  0x0020,   /* U+4296 */
  0x0020,   /* U+4297 */
  0x0020,   /* U+4298 */
  0x0020,   /* U+4299 */
  0x0020,   /* U+429A */
  0x0020,   /* U+429B */
  0x0020,   /* U+429C */
  0x0020,   /* U+429D */
  0x0020,   /* U+429E */
  0x0020,   /* U+429F */
  0x0020,   /* U+42A0 */
  0x0020,   /* U+42A1 */
  0x0020,   /* U+42A2 */
  0x0020,   /* U+42A3 */
  0x0020,   /* U+42A4 */
  0x0020,   /* U+42A5 */
  0x0020,   /* U+42A6 */
  0x0020,   /* U+42A7 */
  0x0020,   /* U+42A8 */
  0x0020,   /* U+42A9 */
  0x0020,   /* U+42AA */
  0x0020,   /* U+42AB */
  0x0020,   /* U+42AC */
  0x0020,   /* U+42AD */
  0x0020,   /* U+42AE */
  0x0020,   /* U+42AF */
  0x0020,   /* U+42B0 */
  0x0020,   /* U+42B1 */
  0x0020,   /* U+42B2 */
  0x0020,   /* U+42B3 */
  0x0020,   /* U+42B4 */
  0x0020,   /* U+42B5 */
  0x0020,   /* U+42B6 */
  0x0020,   /* U+42B7 */
  0x0020,   /* U+42B8 */
  0x0020,   /* U+42B9 */
  0x0020,   /* U+42BA */
  0x0020,   /* U+42BB */
  0x0020,   /* U+42BC */
  0x0020,   /* U+42BD */
  0x0020,   /* U+42BE */
  0x0020,   /* U+42BF */
  0x0020,   /* U+42C0 */
  0x0020,   /* U+42C1 */
  0x0020,   /* U+42C2 */
  0x0020,   /* U+42C3 */
  0x0020,   /* U+42C4 */
  0x0020,   /* U+42C5 */
  0x0020,   /* U+42C6 */
  0x0020,   /* U+42C7 */
  0x0020,   /* U+42C8 */
  0x0020,   /* U+42C9 */
  0x0020,   /* U+42CA */
  0x0020,   /* U+42CB */
  0x0020,   /* U+42CC */
  0x0020,   /* U+42CD */
  0x0020,   /* U+42CE */
  0x0020,   /* U+42CF */
  0x0020,   /* U+42D0 */
  0x0020,   /* U+42D1 */
  0x0020,   /* U+42D2 */
  0x0020,   /* U+42D3 */
  0x0020,   /* U+42D4 */
  0x0020,   /* U+42D5 */
  0x0020,   /* U+42D6 */
  0x0020,   /* U+42D7 */
  0x0020,   /* U+42D8 */
  0x0020,   /* U+42D9 */
  0x0020,   /* U+42DA */
  0x0020,   /* U+42DB */
  0x0020,   /* U+42DC */
  0x0020,   /* U+42DD */
  0x0020,   /* U+42DE */
  0x0020,   /* U+42DF */
  0x0020,   /* U+42E0 */
  0x0020,   /* U+42E1 */
  0x0020,   /* U+42E2 */
  0x0020,   /* U+42E3 */
  0x0020,   /* U+42E4 */
  0x0020,   /* U+42E5 */
  0x0020,   /* U+42E6 */
  0x0020,   /* U+42E7 */
  0x0020,   /* U+42E8 */
  0x0020,   /* U+42E9 */
  0x0020,   /* U+42EA */
  0x0020,   /* U+42EB */
  0x0020,   /* U+42EC */
  0x0020,   /* U+42ED */
  0x0020,   /* U+42EE */
  0x0020,   /* U+42EF */
  0x0020,   /* U+42F0 */
  0x0020,   /* U+42F1 */
  0x0020,   /* U+42F2 */
  0x0020,   /* U+42F3 */
  0x0020,   /* U+42F4 */
  0x0020,   /* U+42F5 */
  0x0020,   /* U+42F6 */
  0x0020,   /* U+42F7 */
  0x0020,   /* U+42F8 */
  0x0020,   /* U+42F9 */
  0x0020,   /* U+42FA */
  0x0020,   /* U+42FB */
  0x0020,   /* U+42FC */
  0x0020,   /* U+42FD */
  0x0020,   /* U+42FE */
  0x0020,   /* U+42FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4200 */
  0x0002,   /* U+4201 */
  0x0002,   /* U+4202 */
  0x0002,   /* U+4203 */
  0x0002,   /* U+4204 */
  0x0002,   /* U+4205 */
  0x0002,   /* U+4206 */
  0x0002,   /* U+4207 */
  0x0002,   /* U+4208 */
  0x0002,   /* U+4209 */
  0x0002,   /* U+420A */
  0x0002,   /* U+420B */
  0x0002,   /* U+420C */
  0x0002,   /* U+420D */
  0x0002,   /* U+420E */
  0x0002,   /* U+420F */
  0x0002,   /* U+4210 */
  0x0002,   /* U+4211 */
  0x0002,   /* U+4212 */
  0x0002,   /* U+4213 */
  0x0002,   /* U+4214 */
  0x0002,   /* U+4215 */
  0x0002,   /* U+4216 */
  0x0002,   /* U+4217 */
  0x0002,   /* U+4218 */
  0x0002,   /* U+4219 */
  0x0002,   /* U+421A */
  0x0002,   /* U+421B */
  0x0002,   /* U+421C */
  0x0002,   /* U+421D */
  0x0002,   /* U+421E */
  0x0002,   /* U+421F */
  0x0002,   /* U+4220 */
  0x0002,   /* U+4221 */
  0x0002,   /* U+4222 */
  0x0002,   /* U+4223 */
  0x0002,   /* U+4224 */
  0x0002,   /* U+4225 */
  0x0002,   /* U+4226 */
  0x0002,   /* U+4227 */
  0x0002,   /* U+4228 */
  0x0002,   /* U+4229 */
  0x0002,   /* U+422A */
  0x0002,   /* U+422B */
  0x0002,   /* U+422C */
  0x0002,   /* U+422D */
  0x0002,   /* U+422E */
  0x0002,   /* U+422F */
  0x0002,   /* U+4230 */
  0x0002,   /* U+4231 */
  0x0002,   /* U+4232 */
  0x0002,   /* U+4233 */
  0x0002,   /* U+4234 */
  0x0002,   /* U+4235 */
  0x0002,   /* U+4236 */
  0x0002,   /* U+4237 */
  0x0002,   /* U+4238 */
  0x0002,   /* U+4239 */
  0x0002,   /* U+423A */
  0x0002,   /* U+423B */
  0x0002,   /* U+423C */
  0x0002,   /* U+423D */
  0x0002,   /* U+423E */
  0x0002,   /* U+423F */
  0x0002,   /* U+4240 */
  0x0002,   /* U+4241 */
  0x0002,   /* U+4242 */
  0x0002,   /* U+4243 */
  0x0002,   /* U+4244 */
  0x0002,   /* U+4245 */
  0x0002,   /* U+4246 */
  0x0002,   /* U+4247 */
  0x0002,   /* U+4248 */
  0x0002,   /* U+4249 */
  0x0002,   /* U+424A */
  0x0002,   /* U+424B */
  0x0002,   /* U+424C */
  0x0002,   /* U+424D */
  0x0002,   /* U+424E */
  0x0002,   /* U+424F */
  0x0002,   /* U+4250 */
  0x0002,   /* U+4251 */
  0x0002,   /* U+4252 */
  0x0002,   /* U+4253 */
  0x0002,   /* U+4254 */
  0x0002,   /* U+4255 */
  0x0002,   /* U+4256 */
  0x0002,   /* U+4257 */
  0x0002,   /* U+4258 */
  0x0002,   /* U+4259 */
  0x0002,   /* U+425A */
  0x0002,   /* U+425B */
  0x0002,   /* U+425C */
  0x0002,   /* U+425D */
  0x0002,   /* U+425E */
  0x0002,   /* U+425F */
  0x0002,   /* U+4260 */
  0x0002,   /* U+4261 */
  0x0002,   /* U+4262 */
  0x0002,   /* U+4263 */
  0x0002,   /* U+4264 */
  0x0002,   /* U+4265 */
  0x0002,   /* U+4266 */
  0x0002,   /* U+4267 */
  0x0002,   /* U+4268 */
  0x0002,   /* U+4269 */
  0x0002,   /* U+426A */
  0x0002,   /* U+426B */
  0x0002,   /* U+426C */
  0x0002,   /* U+426D */
  0x0002,   /* U+426E */
  0x0002,   /* U+426F */
  0x0002,   /* U+4270 */
  0x0002,   /* U+4271 */
  0x0002,   /* U+4272 */
  0x0002,   /* U+4273 */
  0x0002,   /* U+4274 */
  0x0002,   /* U+4275 */
  0x0002,   /* U+4276 */
  0x0002,   /* U+4277 */
  0x0002,   /* U+4278 */
  0x0002,   /* U+4279 */
  0x0002,   /* U+427A */
  0x0002,   /* U+427B */
  0x0002,   /* U+427C */
  0x0002,   /* U+427D */
  0x0002,   /* U+427E */
  0x0002,   /* U+427F */
  0x0002,   /* U+4280 */
  0x0002,   /* U+4281 */
  0x0002,   /* U+4282 */
  0x0002,   /* U+4283 */
  0x0002,   /* U+4284 */
  0x0002,   /* U+4285 */
  0x0002,   /* U+4286 */
  0x0002,   /* U+4287 */
  0x0002,   /* U+4288 */
  0x0002,   /* U+4289 */
  0x0002,   /* U+428A */
  0x0002,   /* U+428B */
  0x0002,   /* U+428C */
  0x0002,   /* U+428D */
  0x0002,   /* U+428E */
  0x0002,   /* U+428F */
  0x0002,   /* U+4290 */
  0x0002,   /* U+4291 */
  0x0002,   /* U+4292 */
  0x0002,   /* U+4293 */
  0x0002,   /* U+4294 */
  0x0002,   /* U+4295 */
  0x0002,   /* U+4296 */
  0x0002,   /* U+4297 */
  0x0002,   /* U+4298 */
  0x0002,   /* U+4299 */
  0x0002,   /* U+429A */
  0x0002,   /* U+429B */
  0x0002,   /* U+429C */
  0x0002,   /* U+429D */
  0x0002,   /* U+429E */
  0x0002,   /* U+429F */
  0x0002,   /* U+42A0 */
  0x0002,   /* U+42A1 */
  0x0002,   /* U+42A2 */
  0x0002,   /* U+42A3 */
  0x0002,   /* U+42A4 */
  0x0002,   /* U+42A5 */
  0x0002,   /* U+42A6 */
  0x0002,   /* U+42A7 */
  0x0002,   /* U+42A8 */
  0x0002,   /* U+42A9 */
  0x0002,   /* U+42AA */
  0x0002,   /* U+42AB */
  0x0002,   /* U+42AC */
  0x0002,   /* U+42AD */
  0x0002,   /* U+42AE */
  0x0002,   /* U+42AF */
  0x0002,   /* U+42B0 */
  0x0002,   /* U+42B1 */
  0x0002,   /* U+42B2 */
  0x0002,   /* U+42B3 */
  0x0002,   /* U+42B4 */
  0x0002,   /* U+42B5 */
  0x0002,   /* U+42B6 */
  0x0002,   /* U+42B7 */
  0x0002,   /* U+42B8 */
  0x0002,   /* U+42B9 */
  0x0002,   /* U+42BA */
  0x0002,   /* U+42BB */
  0x0002,   /* U+42BC */
  0x0002,   /* U+42BD */
  0x0002,   /* U+42BE */
  0x0002,   /* U+42BF */
  0x0002,   /* U+42C0 */
  0x0002,   /* U+42C1 */
  0x0002,   /* U+42C2 */
  0x0002,   /* U+42C3 */
  0x0002,   /* U+42C4 */
  0x0002,   /* U+42C5 */
  0x0002,   /* U+42C6 */
  0x0002,   /* U+42C7 */
  0x0002,   /* U+42C8 */
  0x0002,   /* U+42C9 */
  0x0002,   /* U+42CA */
  0x0002,   /* U+42CB */
  0x0002,   /* U+42CC */
  0x0002,   /* U+42CD */
  0x0002,   /* U+42CE */
  0x0002,   /* U+42CF */
  0x0002,   /* U+42D0 */
  0x0002,   /* U+42D1 */
  0x0002,   /* U+42D2 */
  0x0002,   /* U+42D3 */
  0x0002,   /* U+42D4 */
  0x0002,   /* U+42D5 */
  0x0002,   /* U+42D6 */
  0x0002,   /* U+42D7 */
  0x0002,   /* U+42D8 */
  0x0002,   /* U+42D9 */
  0x0002,   /* U+42DA */
  0x0002,   /* U+42DB */
  0x0002,   /* U+42DC */
  0x0002,   /* U+42DD */
  0x0002,   /* U+42DE */
  0x0002,   /* U+42DF */
  0x0002,   /* U+42E0 */
  0x0002,   /* U+42E1 */
  0x0002,   /* U+42E2 */
  0x0002,   /* U+42E3 */
  0x0002,   /* U+42E4 */
  0x0002,   /* U+42E5 */
  0x0002,   /* U+42E6 */
  0x0002,   /* U+42E7 */
  0x0002,   /* U+42E8 */
  0x0002,   /* U+42E9 */
  0x0002,   /* U+42EA */
  0x0002,   /* U+42EB */
  0x0002,   /* U+42EC */
  0x0002,   /* U+42ED */
  0x0002,   /* U+42EE */
  0x0002,   /* U+42EF */
  0x0002,   /* U+42F0 */
  0x0002,   /* U+42F1 */
  0x0002,   /* U+42F2 */
  0x0002,   /* U+42F3 */
  0x0002,   /* U+42F4 */
  0x0002,   /* U+42F5 */
  0x0002,   /* U+42F6 */
  0x0002,   /* U+42F7 */
  0x0002,   /* U+42F8 */
  0x0002,   /* U+42F9 */
  0x0002,   /* U+42FA */
  0x0002,   /* U+42FB */
  0x0002,   /* U+42FC */
  0x0002,   /* U+42FD */
  0x0002,   /* U+42FE */
  0x0002,   /* U+42FF */

  /* Primary weight 2 for each character. */
  0x800A,   /* U+4200 */
  0x8000,   /* U+4201 */
  0x8001,   /* U+4202 */
  0x8002,   /* U+4203 */
  0x8003,   /* U+4204 */
  0x8004,   /* U+4205 */
  0x8005,   /* U+4206 */
  0x8006,   /* U+4207 */
  0x8007,   /* U+4208 */
  0x8008,   /* U+4209 */
  0x8009,   /* U+420A */
  0x800A,   /* U+420B */
  0x800B,   /* U+420C */
  0x800C,   /* U+420D */
  0x8000,   /* U+420E */
  0x8001,   /* U+420F */
  0x8002,   /* U+4210 */
  0x8003,   /* U+4211 */
  0x8004,   /* U+4212 */
  0x8005,   /* U+4213 */
  0x8006,   /* U+4214 */
  0x8007,   /* U+4215 */
  0x8008,   /* U+4216 */
  0x8009,   /* U+4217 */
  0x800A,   /* U+4218 */
  0x800B,   /* U+4219 */
  0x800C,   /* U+421A */
  0x800D,   /* U+421B */
  0x800E,   /* U+421C */
  0x800F,   /* U+421D */
  0x8010,   /* U+421E */
  0x8011,   /* U+421F */
  0x8012,   /* U+4220 */
  0x8013,   /* U+4221 */
  0x8014,   /* U+4222 */
  0x8015,   /* U+4223 */
  0x8016,   /* U+4224 */
  0x8017,   /* U+4225 */
  0x8018,   /* U+4226 */
  0x8019,   /* U+4227 */
  0x801A,   /* U+4228 */
  0x801B,   /* U+4229 */
  0x8000,   /* U+422A */
  0x8001,   /* U+422B */
  0x8002,   /* U+422C */
  0x8003,   /* U+422D */
  0x8004,   /* U+422E */
  0x8005,   /* U+422F */
  0x8006,   /* U+4230 */
  0x8007,   /* U+4231 */
  0x8008,   /* U+4232 */
  0x8009,   /* U+4233 */
  0x800A,   /* U+4234 */
  0x800B,   /* U+4235 */
  0x800C,   /* U+4236 */
  0x800D,   /* U+4237 */
  0x8000,   /* U+4238 */
  0x8001,   /* U+4239 */
  0x8002,   /* U+423A */
  0x8003,   /* U+423B */
  0x8004,   /* U+423C */
  0x8005,   /* U+423D */
  0x8006,   /* U+423E */
  0x8007,   /* U+423F */
  0x8008,   /* U+4240 */
  0x8009,   /* U+4241 */
  0x800A,   /* U+4242 */
  0x800B,   /* U+4243 */
  0x800C,   /* U+4244 */
  0x800D,   /* U+4245 */
  0x800E,   /* U+4246 */
  0x800F,   /* U+4247 */
  0x8000,   /* U+4248 */
  0x8001,   /* U+4249 */
  0x8002,   /* U+424A */
  0x8003,   /* U+424B */
  0x8004,   /* U+424C */
  0x8005,   /* U+424D */
  0x8006,   /* U+424E */
  0x8000,   /* U+424F */
  0x8007,   /* U+4250 */
  0x8008,   /* U+4251 */
  0x8009,   /* U+4252 */
  0x800A,   /* U+4253 */
  0x800B,   /* U+4254 */
  0x800C,   /* U+4255 */
  0x800D,   /* U+4256 */
  0x800E,   /* U+4257 */
  0x800F,   /* U+4258 */
  0x8010,   /* U+4259 */
  0x8011,   /* U+425A */
  0x8001,   /* U+425B */
  0x8002,   /* U+425C */
  0x8003,   /* U+425D */
  0x8004,   /* U+425E */
  0x8005,   /* U+425F */
  0x8006,   /* U+4260 */
  0x8007,   /* U+4261 */
  0x8008,   /* U+4262 */
  0x8012,   /* U+4263 */
  0xC264,   /* U+4264 */
  0x8000,   /* U+4265 */
  0x8000,   /* U+4266 */
  0x8001,   /* U+4267 */
  0x8002,   /* U+4268 */
  0x8003,   /* U+4269 */
  0x8004,   /* U+426A */
  0x8005,   /* U+426B */
  0x8006,   /* U+426C */
  0x8007,   /* U+426D */
  0x8000,   /* U+426E */
  0x8001,   /* U+426F */
  0x8002,   /* U+4270 */
  0x8003,   /* U+4271 */
  0x8000,   /* U+4272 */
  0x8001,   /* U+4273 */
  0x8002,   /* U+4274 */
  0x8001,   /* U+4275 */
  0x8000,   /* U+4276 */
  0x8000,   /* U+4277 */
  0x8000,   /* U+4278 */
  0x8000,   /* U+4279 */
  0x8000,   /* U+427A */
  0x8000,   /* U+427B */
  0x8001,   /* U+427C */
  0x8000,   /* U+427D */
  0x8001,   /* U+427E */
  0x8002,   /* U+427F */
  0x8003,   /* U+4280 */
  0x8000,   /* U+4281 */
  0x8001,   /* U+4282 */
  0x8002,   /* U+4283 */
  0x8003,   /* U+4284 */
  0x8004,   /* U+4285 */
  0x8005,   /* U+4286 */
  0x8000,   /* U+4287 */
  0x8001,   /* U+4288 */
  0x8002,   /* U+4289 */
  0x8003,   /* U+428A */
  0x8004,   /* U+428B */
  0x8005,   /* U+428C */
  0x8000,   /* U+428D */
  0x8001,   /* U+428E */
  0x8002,   /* U+428F */
  0x8003,   /* U+4290 */
  0x8004,   /* U+4291 */
  0x8005,   /* U+4292 */
  0x8000,   /* U+4293 */
  0x8001,   /* U+4294 */
  0x8002,   /* U+4295 */
  0x8003,   /* U+4296 */
  0x8004,   /* U+4297 */
  0x8005,   /* U+4298 */
  0x8006,   /* U+4299 */
  0x8000,   /* U+429A */
  0x8001,   /* U+429B */
  0x8000,   /* U+429C */
  0x8001,   /* U+429D */
  0x8002,   /* U+429E */
  0x8003,   /* U+429F */
  0x8004,   /* U+42A0 */
  0x8005,   /* U+42A1 */
  0xC2A2,   /* U+42A2 */
  0x8000,   /* U+42A3 */
  0x8001,   /* U+42A4 */
  0x8002,   /* U+42A5 */
  0x8003,   /* U+42A6 */
  0x8004,   /* U+42A7 */
  0x8005,   /* U+42A8 */
  0x8006,   /* U+42A9 */
  0x8000,   /* U+42AA */
  0x8001,   /* U+42AB */
  0x8002,   /* U+42AC */
  0x8000,   /* U+42AD */
  0x8001,   /* U+42AE */
  0x8000,   /* U+42AF */
  0x8000,   /* U+42B0 */
  0x8000,   /* U+42B1 */
  0x8001,   /* U+42B2 */
  0x8000,   /* U+42B3 */
  0x8001,   /* U+42B4 */
  0x8003,   /* U+42B5 */
  0x800E,   /* U+42B6 */
  0x800F,   /* U+42B7 */
  0x8010,   /* U+42B8 */
  0x8011,   /* U+42B9 */
  0x801D,   /* U+42BA */
  0x801E,   /* U+42BB */
  0x801F,   /* U+42BC */
  0x8020,   /* U+42BD */
  0x8021,   /* U+42BE */
  0x8022,   /* U+42BF */
  0x8023,   /* U+42C0 */
  0x8024,   /* U+42C1 */
  0x8025,   /* U+42C2 */
  0x8026,   /* U+42C3 */
  0x8027,   /* U+42C4 */
  0xC2C5,   /* U+42C5 */
  0xC2C6,   /* U+42C6 */
  0xC2C7,   /* U+42C7 */
  0x801F,   /* U+42C8 */
  0x8020,   /* U+42C9 */
  0x8021,   /* U+42CA */
  0x8022,   /* U+42CB */
  0x8023,   /* U+42CC */
  0x8024,   /* U+42CD */
  0x8025,   /* U+42CE */
  0x8026,   /* U+42CF */
  0x8027,   /* U+42D0 */
  0x8028,   /* U+42D1 */
  0x8029,   /* U+42D2 */
  0x802A,   /* U+42D3 */
  0x802B,   /* U+42D4 */
  0x8023,   /* U+42D5 */
  0x8024,   /* U+42D6 */
  0x8025,   /* U+42D7 */
  0x8026,   /* U+42D8 */
  0x8027,   /* U+42D9 */
  0x8028,   /* U+42DA */
  0x8029,   /* U+42DB */
  0x802A,   /* U+42DC */
  0xC2DD,   /* U+42DD */
  0xC2DE,   /* U+42DE */
  0x801B,   /* U+42DF */
  0x801C,   /* U+42E0 */
  0x801D,   /* U+42E1 */
  0x801E,   /* U+42E2 */
  0x801F,   /* U+42E3 */
  0x8020,   /* U+42E4 */
  0x8021,   /* U+42E5 */
  0x8022,   /* U+42E6 */
  0x8028,   /* U+42E7 */
  0x8029,   /* U+42E8 */
  0x802A,   /* U+42E9 */
  0x802B,   /* U+42EA */
  0x802C,   /* U+42EB */
  0x802D,   /* U+42EC */
  0x802E,   /* U+42ED */
  0x802F,   /* U+42EE */
  0x8030,   /* U+42EF */
  0x8031,   /* U+42F0 */
  0x8032,   /* U+42F1 */
  0x8033,   /* U+42F2 */
  0x802C,   /* U+42F3 */
  0x802D,   /* U+42F4 */
  0x802E,   /* U+42F5 */
  0x802F,   /* U+42F6 */
  0x8030,   /* U+42F7 */
  0x8031,   /* U+42F8 */
  0x8032,   /* U+42F9 */
  0x8033,   /* U+42FA */
  0x8034,   /* U+42FB */
  0x8035,   /* U+42FC */
  0x8036,   /* U+42FD */
  0x8037,   /* U+42FE */
  0x8038,   /* U+42FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4200 */
  0x0000,   /* U+4201 */
  0x0000,   /* U+4202 */
  0x0000,   /* U+4203 */
  0x0000,   /* U+4204 */
  0x0000,   /* U+4205 */
  0x0000,   /* U+4206 */
  0x0000,   /* U+4207 */
  0x0000,   /* U+4208 */
  0x0000,   /* U+4209 */
  0x0000,   /* U+420A */
  0x0000,   /* U+420B */
  0x0000,   /* U+420C */
  0x0000,   /* U+420D */
  0x0000,   /* U+420E */
  0x0000,   /* U+420F */
  0x0000,   /* U+4210 */
  0x0000,   /* U+4211 */
  0x0000,   /* U+4212 */
  0x0000,   /* U+4213 */
  0x0000,   /* U+4214 */
  0x0000,   /* U+4215 */
  0x0000,   /* U+4216 */
  0x0000,   /* U+4217 */
  0x0000,   /* U+4218 */
  0x0000,   /* U+4219 */
  0x0000,   /* U+421A */
  0x0000,   /* U+421B */
  0x0000,   /* U+421C */
  0x0000,   /* U+421D */
  0x0000,   /* U+421E */
  0x0000,   /* U+421F */
  0x0000,   /* U+4220 */
  0x0000,   /* U+4221 */
  0x0000,   /* U+4222 */
  0x0000,   /* U+4223 */
  0x0000,   /* U+4224 */
  0x0000,   /* U+4225 */
  0x0000,   /* U+4226 */
  0x0000,   /* U+4227 */
  0x0000,   /* U+4228 */
  0x0000,   /* U+4229 */
  0x0000,   /* U+422A */
  0x0000,   /* U+422B */
  0x0000,   /* U+422C */
  0x0000,   /* U+422D */
  0x0000,   /* U+422E */
  0x0000,   /* U+422F */
  0x0000,   /* U+4230 */
  0x0000,   /* U+4231 */
  0x0000,   /* U+4232 */
  0x0000,   /* U+4233 */
  0x0000,   /* U+4234 */
  0x0000,   /* U+4235 */
  0x0000,   /* U+4236 */
  0x0000,   /* U+4237 */
  0x0000,   /* U+4238 */
  0x0000,   /* U+4239 */
  0x0000,   /* U+423A */
  0x0000,   /* U+423B */
  0x0000,   /* U+423C */
  0x0000,   /* U+423D */
  0x0000,   /* U+423E */
  0x0000,   /* U+423F */
  0x0000,   /* U+4240 */
  0x0000,   /* U+4241 */
  0x0000,   /* U+4242 */
  0x0000,   /* U+4243 */
  0x0000,   /* U+4244 */
  0x0000,   /* U+4245 */
  0x0000,   /* U+4246 */
  0x0000,   /* U+4247 */
  0x0000,   /* U+4248 */
  0x0000,   /* U+4249 */
  0x0000,   /* U+424A */
  0x0000,   /* U+424B */
  0x0000,   /* U+424C */
  0x0000,   /* U+424D */
  0x0000,   /* U+424E */
  0x0000,   /* U+424F */
  0x0000,   /* U+4250 */
  0x0000,   /* U+4251 */
  0x0000,   /* U+4252 */
  0x0000,   /* U+4253 */
  0x0000,   /* U+4254 */
  0x0000,   /* U+4255 */
  0x0000,   /* U+4256 */
  0x0000,   /* U+4257 */
  0x0000,   /* U+4258 */
  0x0000,   /* U+4259 */
  0x0000,   /* U+425A */
  0x0000,   /* U+425B */
  0x0000,   /* U+425C */
  0x0000,   /* U+425D */
  0x0000,   /* U+425E */
  0x0000,   /* U+425F */
  0x0000,   /* U+4260 */
  0x0000,   /* U+4261 */
  0x0000,   /* U+4262 */
  0x0000,   /* U+4263 */
  0x0000,   /* U+4264 */
  0x0000,   /* U+4265 */
  0x0000,   /* U+4266 */
  0x0000,   /* U+4267 */
  0x0000,   /* U+4268 */
  0x0000,   /* U+4269 */
  0x0000,   /* U+426A */
  0x0000,   /* U+426B */
  0x0000,   /* U+426C */
  0x0000,   /* U+426D */
  0x0000,   /* U+426E */
  0x0000,   /* U+426F */
  0x0000,   /* U+4270 */
  0x0000,   /* U+4271 */
  0x0000,   /* U+4272 */
  0x0000,   /* U+4273 */
  0x0000,   /* U+4274 */
  0x0000,   /* U+4275 */
  0x0000,   /* U+4276 */
  0x0000,   /* U+4277 */
  0x0000,   /* U+4278 */
  0x0000,   /* U+4279 */
  0x0000,   /* U+427A */
  0x0000,   /* U+427B */
  0x0000,   /* U+427C */
  0x0000,   /* U+427D */
  0x0000,   /* U+427E */
  0x0000,   /* U+427F */
  0x0000,   /* U+4280 */
  0x0000,   /* U+4281 */
  0x0000,   /* U+4282 */
  0x0000,   /* U+4283 */
  0x0000,   /* U+4284 */
  0x0000,   /* U+4285 */
  0x0000,   /* U+4286 */
  0x0000,   /* U+4287 */
  0x0000,   /* U+4288 */
  0x0000,   /* U+4289 */
  0x0000,   /* U+428A */
  0x0000,   /* U+428B */
  0x0000,   /* U+428C */
  0x0000,   /* U+428D */
  0x0000,   /* U+428E */
  0x0000,   /* U+428F */
  0x0000,   /* U+4290 */
  0x0000,   /* U+4291 */
  0x0000,   /* U+4292 */
  0x0000,   /* U+4293 */
  0x0000,   /* U+4294 */
  0x0000,   /* U+4295 */
  0x0000,   /* U+4296 */
  0x0000,   /* U+4297 */
  0x0000,   /* U+4298 */
  0x0000,   /* U+4299 */
  0x0000,   /* U+429A */
  0x0000,   /* U+429B */
  0x0000,   /* U+429C */
  0x0000,   /* U+429D */
  0x0000,   /* U+429E */
  0x0000,   /* U+429F */
  0x0000,   /* U+42A0 */
  0x0000,   /* U+42A1 */
  0x0000,   /* U+42A2 */
  0x0000,   /* U+42A3 */
  0x0000,   /* U+42A4 */
  0x0000,   /* U+42A5 */
  0x0000,   /* U+42A6 */
  0x0000,   /* U+42A7 */
  0x0000,   /* U+42A8 */
  0x0000,   /* U+42A9 */
  0x0000,   /* U+42AA */
  0x0000,   /* U+42AB */
  0x0000,   /* U+42AC */
  0x0000,   /* U+42AD */
  0x0000,   /* U+42AE */
  0x0000,   /* U+42AF */
  0x0000,   /* U+42B0 */
  0x0000,   /* U+42B1 */
  0x0000,   /* U+42B2 */
  0x0000,   /* U+42B3 */
  0x0000,   /* U+42B4 */
  0x0000,   /* U+42B5 */
  0x0000,   /* U+42B6 */
  0x0000,   /* U+42B7 */
  0x0000,   /* U+42B8 */
  0x0000,   /* U+42B9 */
  0x0000,   /* U+42BA */
  0x0000,   /* U+42BB */
  0x0000,   /* U+42BC */
  0x0000,   /* U+42BD */
  0x0000,   /* U+42BE */
  0x0000,   /* U+42BF */
  0x0000,   /* U+42C0 */
  0x0000,   /* U+42C1 */
  0x0000,   /* U+42C2 */
  0x0000,   /* U+42C3 */
  0x0000,   /* U+42C4 */
  0x0000,   /* U+42C5 */
  0x0000,   /* U+42C6 */
  0x0000,   /* U+42C7 */
  0x0000,   /* U+42C8 */
  0x0000,   /* U+42C9 */
  0x0000,   /* U+42CA */
  0x0000,   /* U+42CB */
  0x0000,   /* U+42CC */
  0x0000,   /* U+42CD */
  0x0000,   /* U+42CE */
  0x0000,   /* U+42CF */
  0x0000,   /* U+42D0 */
  0x0000,   /* U+42D1 */
  0x0000,   /* U+42D2 */
  0x0000,   /* U+42D3 */
  0x0000,   /* U+42D4 */
  0x0000,   /* U+42D5 */
  0x0000,   /* U+42D6 */
  0x0000,   /* U+42D7 */
  0x0000,   /* U+42D8 */
  0x0000,   /* U+42D9 */
  0x0000,   /* U+42DA */
  0x0000,   /* U+42DB */
  0x0000,   /* U+42DC */
  0x0000,   /* U+42DD */
  0x0000,   /* U+42DE */
  0x0000,   /* U+42DF */
  0x0000,   /* U+42E0 */
  0x0000,   /* U+42E1 */
  0x0000,   /* U+42E2 */
  0x0000,   /* U+42E3 */
  0x0000,   /* U+42E4 */
  0x0000,   /* U+42E5 */
  0x0000,   /* U+42E6 */
  0x0000,   /* U+42E7 */
  0x0000,   /* U+42E8 */
  0x0000,   /* U+42E9 */
  0x0000,   /* U+42EA */
  0x0000,   /* U+42EB */
  0x0000,   /* U+42EC */
  0x0000,   /* U+42ED */
  0x0000,   /* U+42EE */
  0x0000,   /* U+42EF */
  0x0000,   /* U+42F0 */
  0x0000,   /* U+42F1 */
  0x0000,   /* U+42F2 */
  0x0000,   /* U+42F3 */
  0x0000,   /* U+42F4 */
  0x0000,   /* U+42F5 */
  0x0000,   /* U+42F6 */
  0x0000,   /* U+42F7 */
  0x0000,   /* U+42F8 */
  0x0000,   /* U+42F9 */
  0x0000,   /* U+42FA */
  0x0000,   /* U+42FB */
  0x0000,   /* U+42FC */
  0x0000,   /* U+42FD */
  0x0000,   /* U+42FE */
  0x0000,   /* U+42FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4200 */
  0x0000,   /* U+4201 */
  0x0000,   /* U+4202 */
  0x0000,   /* U+4203 */
  0x0000,   /* U+4204 */
  0x0000,   /* U+4205 */
  0x0000,   /* U+4206 */
  0x0000,   /* U+4207 */
  0x0000,   /* U+4208 */
  0x0000,   /* U+4209 */
  0x0000,   /* U+420A */
  0x0000,   /* U+420B */
  0x0000,   /* U+420C */
  0x0000,   /* U+420D */
  0x0000,   /* U+420E */
  0x0000,   /* U+420F */
  0x0000,   /* U+4210 */
  0x0000,   /* U+4211 */
  0x0000,   /* U+4212 */
  0x0000,   /* U+4213 */
  0x0000,   /* U+4214 */
  0x0000,   /* U+4215 */
  0x0000,   /* U+4216 */
  0x0000,   /* U+4217 */
  0x0000,   /* U+4218 */
  0x0000,   /* U+4219 */
  0x0000,   /* U+421A */
  0x0000,   /* U+421B */
  0x0000,   /* U+421C */
  0x0000,   /* U+421D */
  0x0000,   /* U+421E */
  0x0000,   /* U+421F */
  0x0000,   /* U+4220 */
  0x0000,   /* U+4221 */
  0x0000,   /* U+4222 */
  0x0000,   /* U+4223 */
  0x0000,   /* U+4224 */
  0x0000,   /* U+4225 */
  0x0000,   /* U+4226 */
  0x0000,   /* U+4227 */
  0x0000,   /* U+4228 */
  0x0000,   /* U+4229 */
  0x0000,   /* U+422A */
  0x0000,   /* U+422B */
  0x0000,   /* U+422C */
  0x0000,   /* U+422D */
  0x0000,   /* U+422E */
  0x0000,   /* U+422F */
  0x0000,   /* U+4230 */
  0x0000,   /* U+4231 */
  0x0000,   /* U+4232 */
  0x0000,   /* U+4233 */
  0x0000,   /* U+4234 */
  0x0000,   /* U+4235 */
  0x0000,   /* U+4236 */
  0x0000,   /* U+4237 */
  0x0000,   /* U+4238 */
  0x0000,   /* U+4239 */
  0x0000,   /* U+423A */
  0x0000,   /* U+423B */
  0x0000,   /* U+423C */
  0x0000,   /* U+423D */
  0x0000,   /* U+423E */
  0x0000,   /* U+423F */
  0x0000,   /* U+4240 */
  0x0000,   /* U+4241 */
  0x0000,   /* U+4242 */
  0x0000,   /* U+4243 */
  0x0000,   /* U+4244 */
  0x0000,   /* U+4245 */
  0x0000,   /* U+4246 */
  0x0000,   /* U+4247 */
  0x0000,   /* U+4248 */
  0x0000,   /* U+4249 */
  0x0000,   /* U+424A */
  0x0000,   /* U+424B */
  0x0000,   /* U+424C */
  0x0000,   /* U+424D */
  0x0000,   /* U+424E */
  0x0000,   /* U+424F */
  0x0000,   /* U+4250 */
  0x0000,   /* U+4251 */
  0x0000,   /* U+4252 */
  0x0000,   /* U+4253 */
  0x0000,   /* U+4254 */
  0x0000,   /* U+4255 */
  0x0000,   /* U+4256 */
  0x0000,   /* U+4257 */
  0x0000,   /* U+4258 */
  0x0000,   /* U+4259 */
  0x0000,   /* U+425A */
  0x0000,   /* U+425B */
  0x0000,   /* U+425C */
  0x0000,   /* U+425D */
  0x0000,   /* U+425E */
  0x0000,   /* U+425F */
  0x0000,   /* U+4260 */
  0x0000,   /* U+4261 */
  0x0000,   /* U+4262 */
  0x0000,   /* U+4263 */
  0x0000,   /* U+4264 */
  0x0000,   /* U+4265 */
  0x0000,   /* U+4266 */
  0x0000,   /* U+4267 */
  0x0000,   /* U+4268 */
  0x0000,   /* U+4269 */
  0x0000,   /* U+426A */
  0x0000,   /* U+426B */
  0x0000,   /* U+426C */
  0x0000,   /* U+426D */
  0x0000,   /* U+426E */
  0x0000,   /* U+426F */
  0x0000,   /* U+4270 */
  0x0000,   /* U+4271 */
  0x0000,   /* U+4272 */
  0x0000,   /* U+4273 */
  0x0000,   /* U+4274 */
  0x0000,   /* U+4275 */
  0x0000,   /* U+4276 */
  0x0000,   /* U+4277 */
  0x0000,   /* U+4278 */
  0x0000,   /* U+4279 */
  0x0000,   /* U+427A */
  0x0000,   /* U+427B */
  0x0000,   /* U+427C */
  0x0000,   /* U+427D */
  0x0000,   /* U+427E */
  0x0000,   /* U+427F */
  0x0000,   /* U+4280 */
  0x0000,   /* U+4281 */
  0x0000,   /* U+4282 */
  0x0000,   /* U+4283 */
  0x0000,   /* U+4284 */
  0x0000,   /* U+4285 */
  0x0000,   /* U+4286 */
  0x0000,   /* U+4287 */
  0x0000,   /* U+4288 */
  0x0000,   /* U+4289 */
  0x0000,   /* U+428A */
  0x0000,   /* U+428B */
  0x0000,   /* U+428C */
  0x0000,   /* U+428D */
  0x0000,   /* U+428E */
  0x0000,   /* U+428F */
  0x0000,   /* U+4290 */
  0x0000,   /* U+4291 */
  0x0000,   /* U+4292 */
  0x0000,   /* U+4293 */
  0x0000,   /* U+4294 */
  0x0000,   /* U+4295 */
  0x0000,   /* U+4296 */
  0x0000,   /* U+4297 */
  0x0000,   /* U+4298 */
  0x0000,   /* U+4299 */
  0x0000,   /* U+429A */
  0x0000,   /* U+429B */
  0x0000,   /* U+429C */
  0x0000,   /* U+429D */
  0x0000,   /* U+429E */
  0x0000,   /* U+429F */
  0x0000,   /* U+42A0 */
  0x0000,   /* U+42A1 */
  0x0000,   /* U+42A2 */
  0x0000,   /* U+42A3 */
  0x0000,   /* U+42A4 */
  0x0000,   /* U+42A5 */
  0x0000,   /* U+42A6 */
  0x0000,   /* U+42A7 */
  0x0000,   /* U+42A8 */
  0x0000,   /* U+42A9 */
  0x0000,   /* U+42AA */
  0x0000,   /* U+42AB */
  0x0000,   /* U+42AC */
  0x0000,   /* U+42AD */
  0x0000,   /* U+42AE */
  0x0000,   /* U+42AF */
  0x0000,   /* U+42B0 */
  0x0000,   /* U+42B1 */
  0x0000,   /* U+42B2 */
  0x0000,   /* U+42B3 */
  0x0000,   /* U+42B4 */
  0x0000,   /* U+42B5 */
  0x0000,   /* U+42B6 */
  0x0000,   /* U+42B7 */
  0x0000,   /* U+42B8 */
  0x0000,   /* U+42B9 */
  0x0000,   /* U+42BA */
  0x0000,   /* U+42BB */
  0x0000,   /* U+42BC */
  0x0000,   /* U+42BD */
  0x0000,   /* U+42BE */
  0x0000,   /* U+42BF */
  0x0000,   /* U+42C0 */
  0x0000,   /* U+42C1 */
  0x0000,   /* U+42C2 */
  0x0000,   /* U+42C3 */
  0x0000,   /* U+42C4 */
  0x0000,   /* U+42C5 */
  0x0000,   /* U+42C6 */
  0x0000,   /* U+42C7 */
  0x0000,   /* U+42C8 */
  0x0000,   /* U+42C9 */
  0x0000,   /* U+42CA */
  0x0000,   /* U+42CB */
  0x0000,   /* U+42CC */
  0x0000,   /* U+42CD */
  0x0000,   /* U+42CE */
  0x0000,   /* U+42CF */
  0x0000,   /* U+42D0 */
  0x0000,   /* U+42D1 */
  0x0000,   /* U+42D2 */
  0x0000,   /* U+42D3 */
  0x0000,   /* U+42D4 */
  0x0000,   /* U+42D5 */
  0x0000,   /* U+42D6 */
  0x0000,   /* U+42D7 */
  0x0000,   /* U+42D8 */
  0x0000,   /* U+42D9 */
  0x0000,   /* U+42DA */
  0x0000,   /* U+42DB */
  0x0000,   /* U+42DC */
  0x0000,   /* U+42DD */
  0x0000,   /* U+42DE */
  0x0000,   /* U+42DF */
  0x0000,   /* U+42E0 */
  0x0000,   /* U+42E1 */
  0x0000,   /* U+42E2 */
  0x0000,   /* U+42E3 */
  0x0000,   /* U+42E4 */
  0x0000,   /* U+42E5 */
  0x0000,   /* U+42E6 */
  0x0000,   /* U+42E7 */
  0x0000,   /* U+42E8 */
  0x0000,   /* U+42E9 */
  0x0000,   /* U+42EA */
  0x0000,   /* U+42EB */
  0x0000,   /* U+42EC */
  0x0000,   /* U+42ED */
  0x0000,   /* U+42EE */
  0x0000,   /* U+42EF */
  0x0000,   /* U+42F0 */
  0x0000,   /* U+42F1 */
  0x0000,   /* U+42F2 */
  0x0000,   /* U+42F3 */
  0x0000,   /* U+42F4 */
  0x0000,   /* U+42F5 */
  0x0000,   /* U+42F6 */
  0x0000,   /* U+42F7 */
  0x0000,   /* U+42F8 */
  0x0000,   /* U+42F9 */
  0x0000,   /* U+42FA */
  0x0000,   /* U+42FB */
  0x0000,   /* U+42FC */
  0x0000,   /* U+42FD */
  0x0000,   /* U+42FE */
  0x0000,   /* U+42FF */
};

uint16 zh2_han_p043[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x3A55,   /* U+4300 */
  0x3A55,   /* U+4301 */
  0x3A55,   /* U+4302 */
  0x3A55,   /* U+4303 */
  0x3A55,   /* U+4304 */
  0x3A4D,   /* U+4305 */
  0x3A4D,   /* U+4306 */
  0x3A4D,   /* U+4307 */
  0x3A4D,   /* U+4308 */
  0x3A4D,   /* U+4309 */
  0x3A4D,   /* U+430A */
  0x3A4D,   /* U+430B */
  0x3A57,   /* U+430C */
  0x3A57,   /* U+430D */
  0x3A57,   /* U+430E */
  0x3A57,   /* U+430F */
  0x3A57,   /* U+4310 */
  0x3A57,   /* U+4311 */
  0x3A57,   /* U+4312 */
  0x3A57,   /* U+4313 */
  0x3A57,   /* U+4314 */
  0x3A57,   /* U+4315 */
  0x3A58,   /* U+4316 */
  0x3A58,   /* U+4317 */
  0x3A58,   /* U+4318 */
  0x3A58,   /* U+4319 */
  0x3A58,   /* U+431A */
  0x3A58,   /* U+431B */
  0x3A59,   /* U+431C */
  0x3A59,   /* U+431D */
  0x3A59,   /* U+431E */
  0x3A59,   /* U+431F */
  0x3A59,   /* U+4320 */
  0x3A59,   /* U+4321 */
  0x3A59,   /* U+4322 */
  0x3A5A,   /* U+4323 */
  0x3A5A,   /* U+4324 */
  0x3A5A,   /* U+4325 */
  0x3A5A,   /* U+4326 */
  0x3A5A,   /* U+4327 */
  0x3A5B,   /* U+4328 */
  0x3A5B,   /* U+4329 */
  0x3A5C,   /* U+432A */
  0x3A5C,   /* U+432B */
  0x3A5C,   /* U+432C */
  0x3A5C,   /* U+432D */
  0x3A5D,   /* U+432E */
  0x3A5E,   /* U+432F */
  0x3A5E,   /* U+4330 */
  0x3A5E,   /* U+4331 */
  0x3A5E,   /* U+4332 */
  0x3A5F,   /* U+4333 */
  0x3A5F,   /* U+4334 */
  0x3A61,   /* U+4335 */
  0x3A4F,   /* U+4336 */
  0x3A51,   /* U+4337 */
  0x3A50,   /* U+4338 */
  0x3A51,   /* U+4339 */
  0x3A52,   /* U+433A */
  0x3A52,   /* U+433B */
  0x3A53,   /* U+433C */
  0x3A54,   /* U+433D */
  0x3A55,   /* U+433E */
  0x3A55,   /* U+433F */
  0x3A56,   /* U+4340 */
  0x3A59,   /* U+4341 */
  0x3A8F,   /* U+4342 */
  0x3A90,   /* U+4343 */
  0x3A91,   /* U+4344 */
  0x3A91,   /* U+4345 */
  0x3A91,   /* U+4346 */
  0x3A91,   /* U+4347 */
  0x3A91,   /* U+4348 */
  0x3A91,   /* U+4349 */
  0x3A92,   /* U+434A */
  0x3A94,   /* U+434B */
  0x3A94,   /* U+434C */
  0x3A8D,   /* U+434D */
  0x3A9D,   /* U+434E */
  0x5C49,   /* U+434F */
  0x3ACF,   /* U+4350 */
  0x3ACF,   /* U+4351 */
  0x3AD0,   /* U+4352 */
  0x3AD0,   /* U+4353 */
  0x3AD0,   /* U+4354 */
  0x3AD1,   /* U+4355 */
  0x3AD1,   /* U+4356 */
  0x3AD1,   /* U+4357 */
  0x3AD2,   /* U+4358 */
  0x3AD3,   /* U+4359 */
  0x3AD3,   /* U+435A */
  0x3AD4,   /* U+435B */
  0x3AD4,   /* U+435C */
  0x3AD4,   /* U+435D */
  0x5C49,   /* U+435E */
  0x3AD5,   /* U+435F */
  0x3AD7,   /* U+4360 */
  0x3AD7,   /* U+4361 */
  0x3AD8,   /* U+4362 */
  0x3AD9,   /* U+4363 */
  0x3ADA,   /* U+4364 */
  0x3ADC,   /* U+4365 */
  0x3ADF,   /* U+4366 */
  0x3B10,   /* U+4367 */
  0x3B10,   /* U+4368 */
  0x3B10,   /* U+4369 */
  0x3B11,   /* U+436A */
  0x3B11,   /* U+436B */
  0x3B11,   /* U+436C */
  0x3B11,   /* U+436D */
  0x3B12,   /* U+436E */
  0x3B12,   /* U+436F */
  0x3B12,   /* U+4370 */
  0x3B13,   /* U+4371 */
  0x3B14,   /* U+4372 */
  0x3B14,   /* U+4373 */
  0x3B14,   /* U+4374 */
  0x3B14,   /* U+4375 */
  0x3B14,   /* U+4376 */
  0x3B15,   /* U+4377 */
  0x3B0D,   /* U+4378 */
  0x3B0D,   /* U+4379 */
  0x3B17,   /* U+437A */
  0x3B18,   /* U+437B */
  0x3B18,   /* U+437C */
  0x3B1C,   /* U+437D */
  0x3B50,   /* U+437E */
  0x3B50,   /* U+437F */
  0x3B51,   /* U+4380 */
  0x3B51,   /* U+4381 */
  0x3B51,   /* U+4382 */
  0x3B51,   /* U+4383 */
  0x3B51,   /* U+4384 */
  0x3B51,   /* U+4385 */
  0x3B51,   /* U+4386 */
  0x3B52,   /* U+4387 */
  0x3B52,   /* U+4388 */
  0x3B52,   /* U+4389 */
  0x3B52,   /* U+438A */
  0x3B53,   /* U+438B */
  0x3B53,   /* U+438C */
  0x3B53,   /* U+438D */
  0x3B53,   /* U+438E */
  0x3B54,   /* U+438F */
  0x3B54,   /* U+4390 */
  0x3B54,   /* U+4391 */
  0x3B54,   /* U+4392 */
  0x3B54,   /* U+4393 */
  0x3B4D,   /* U+4394 */
  0x3B4D,   /* U+4395 */
  0x3B58,   /* U+4396 */
  0x3B58,   /* U+4397 */
  0x3B58,   /* U+4398 */
  0x3B5A,   /* U+4399 */
  0x3B5B,   /* U+439A */
  0x5C49,   /* U+439B */
  0x3B92,   /* U+439C */
  0x3B92,   /* U+439D */
  0x5C49,   /* U+439E */
  0x3BCF,   /* U+439F */
  0x3BCF,   /* U+43A0 */
  0x3BD0,   /* U+43A1 */
  0x3C0F,   /* U+43A2 */
  0x3C11,   /* U+43A3 */
  0x3C13,   /* U+43A4 */
  0x3C13,   /* U+43A5 */
  0x3C14,   /* U+43A6 */
  0x3C14,   /* U+43A7 */
  0x3C14,   /* U+43A8 */
  0x3C14,   /* U+43A9 */
  0x3C14,   /* U+43AA */
  0x3C15,   /* U+43AB */
  0x3C15,   /* U+43AC */
  0x3C17,   /* U+43AD */
  0x3C17,   /* U+43AE */
  0x3C17,   /* U+43AF */
  0x3C18,   /* U+43B0 */
  0x3C1B,   /* U+43B1 */
  0x3C4D,   /* U+43B2 */
  0x3C50,   /* U+43B3 */
  0x3C50,   /* U+43B4 */
  0x3C51,   /* U+43B5 */
  0x3C51,   /* U+43B6 */
  0x3C52,   /* U+43B7 */
  0x3C53,   /* U+43B8 */
  0x3C53,   /* U+43B9 */
  0x3C54,   /* U+43BA */
  0x3C54,   /* U+43BB */
  0x3C54,   /* U+43BC */
  0x3C54,   /* U+43BD */
  0x3C54,   /* U+43BE */
  0x3C55,   /* U+43BF */
  0x3C55,   /* U+43C0 */
  0x3C4D,   /* U+43C1 */
  0x3C4D,   /* U+43C2 */
  0x3C4D,   /* U+43C3 */
  0x3C57,   /* U+43C4 */
  0x3C57,   /* U+43C5 */
  0x3C57,   /* U+43C6 */
  0x3C57,   /* U+43C7 */
  0x3C58,   /* U+43C8 */
  0x3C5A,   /* U+43C9 */
  0x3C5C,   /* U+43CA */
  0x3C93,   /* U+43CB */
  0x3CCE,   /* U+43CC */
  0x3CCE,   /* U+43CD */
  0x3CCF,   /* U+43CE */
  0x3CCF,   /* U+43CF */
  0x3CD0,   /* U+43D0 */
  0x3CD0,   /* U+43D1 */
  0x3CD0,   /* U+43D2 */
  0x3CD0,   /* U+43D3 */
  0x3CD0,   /* U+43D4 */
  0x3CD0,   /* U+43D5 */
  0x3CD0,   /* U+43D6 */
  0x3CD0,   /* U+43D7 */
  0x3CD0,   /* U+43D8 */
  0x3CD0,   /* U+43D9 */
  0x3CD0,   /* U+43DA */
  0x3CD0,   /* U+43DB */
  0x3CD0,   /* U+43DC */
  0x3CD0,   /* U+43DD */
  0x3CD1,   /* U+43DE */
  0x3CD1,   /* U+43DF */
  0x3CD1,   /* U+43E0 */
  0x3CD1,   /* U+43E1 */
  0x3CD1,   /* U+43E2 */
  0x3CD1,   /* U+43E3 */
  0x3CD1,   /* U+43E4 */
  0x3CD1,   /* U+43E5 */
  0x3CD2,   /* U+43E6 */
  0x3CD2,   /* U+43E7 */
  0x3CD2,   /* U+43E8 */
  0x3CD2,   /* U+43E9 */
  0x3CD2,   /* U+43EA */
  0x3CD2,   /* U+43EB */
  0x3CD2,   /* U+43EC */
  0x5C49,   /* U+43ED */
  0x5C49,   /* U+43EE */
  0x3CD3,   /* U+43EF */
  0x3CD3,   /* U+43F0 */
  0x3CD3,   /* U+43F1 */
  0x3CD3,   /* U+43F2 */
  0x3CD3,   /* U+43F3 */
  0x3CD3,   /* U+43F4 */
  0x3CD3,   /* U+43F5 */
  0x3CD3,   /* U+43F6 */
  0x3CD3,   /* U+43F7 */
  0x3CD3,   /* U+43F8 */
  0x3CD3,   /* U+43F9 */
  0x3CD3,   /* U+43FA */
  0x3CD3,   /* U+43FB */
  0x3CD4,   /* U+43FC */
  0x3CD4,   /* U+43FD */
  0x3CD4,   /* U+43FE */
  0x3CD4,   /* U+43FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4300 */
  0x0020,   /* U+4301 */
  0x0020,   /* U+4302 */
  0x0020,   /* U+4303 */
  0x0020,   /* U+4304 */
  0x0020,   /* U+4305 */
  0x0020,   /* U+4306 */
  0x0020,   /* U+4307 */
  0x0020,   /* U+4308 */
  0x0020,   /* U+4309 */
  0x0020,   /* U+430A */
  0x0020,   /* U+430B */
  0x0020,   /* U+430C */
  0x0020,   /* U+430D */
  0x0020,   /* U+430E */
  0x0020,   /* U+430F */
  0x0020,   /* U+4310 */
  0x0020,   /* U+4311 */
  0x0020,   /* U+4312 */
  0x0020,   /* U+4313 */
  0x0020,   /* U+4314 */
  0x0020,   /* U+4315 */
  0x0020,   /* U+4316 */
  0x0020,   /* U+4317 */
  0x0020,   /* U+4318 */
  0x0020,   /* U+4319 */
  0x0020,   /* U+431A */
  0x0020,   /* U+431B */
  0x0020,   /* U+431C */
  0x0020,   /* U+431D */
  0x0020,   /* U+431E */
  0x0020,   /* U+431F */
  0x0020,   /* U+4320 */
  0x0020,   /* U+4321 */
  0x0020,   /* U+4322 */
  0x0020,   /* U+4323 */
  0x0020,   /* U+4324 */
  0x0020,   /* U+4325 */
  0x0020,   /* U+4326 */
  0x0020,   /* U+4327 */
  0x0020,   /* U+4328 */
  0x0020,   /* U+4329 */
  0x0020,   /* U+432A */
  0x0020,   /* U+432B */
  0x0020,   /* U+432C */
  0x0020,   /* U+432D */
  0x0020,   /* U+432E */
  0x0020,   /* U+432F */
  0x0020,   /* U+4330 */
  0x0020,   /* U+4331 */
  0x0020,   /* U+4332 */
  0x0020,   /* U+4333 */
  0x0020,   /* U+4334 */
  0x0020,   /* U+4335 */
  0x0020,   /* U+4336 */
  0x0020,   /* U+4337 */
  0x0020,   /* U+4338 */
  0x0020,   /* U+4339 */
  0x0020,   /* U+433A */
  0x0020,   /* U+433B */
  0x0020,   /* U+433C */
  0x0020,   /* U+433D */
  0x0020,   /* U+433E */
  0x0020,   /* U+433F */
  0x0020,   /* U+4340 */
  0x0020,   /* U+4341 */
  0x0020,   /* U+4342 */
  0x0020,   /* U+4343 */
  0x0020,   /* U+4344 */
  0x0020,   /* U+4345 */
  0x0020,   /* U+4346 */
  0x0020,   /* U+4347 */
  0x0020,   /* U+4348 */
  0x0020,   /* U+4349 */
  0x0020,   /* U+434A */
  0x0020,   /* U+434B */
  0x0020,   /* U+434C */
  0x0020,   /* U+434D */
  0x0020,   /* U+434E */
  0x0020,   /* U+434F */
  0x0020,   /* U+4350 */
  0x0020,   /* U+4351 */
  0x0020,   /* U+4352 */
  0x0020,   /* U+4353 */
  0x0020,   /* U+4354 */
  0x0020,   /* U+4355 */
  0x0020,   /* U+4356 */
  0x0020,   /* U+4357 */
  0x0020,   /* U+4358 */
  0x0020,   /* U+4359 */
  0x0020,   /* U+435A */
  0x0020,   /* U+435B */
  0x0020,   /* U+435C */
  0x0020,   /* U+435D */
  0x0020,   /* U+435E */
  0x0020,   /* U+435F */
  0x0020,   /* U+4360 */
  0x0020,   /* U+4361 */
  0x0020,   /* U+4362 */
  0x0020,   /* U+4363 */
  0x0020,   /* U+4364 */
  0x0020,   /* U+4365 */
  0x0020,   /* U+4366 */
  0x0020,   /* U+4367 */
  0x0020,   /* U+4368 */
  0x0020,   /* U+4369 */
  0x0020,   /* U+436A */
  0x0020,   /* U+436B */
  0x0020,   /* U+436C */
  0x0020,   /* U+436D */
  0x0020,   /* U+436E */
  0x0020,   /* U+436F */
  0x0020,   /* U+4370 */
  0x0020,   /* U+4371 */
  0x0020,   /* U+4372 */
  0x0020,   /* U+4373 */
  0x0020,   /* U+4374 */
  0x0020,   /* U+4375 */
  0x0020,   /* U+4376 */
  0x0020,   /* U+4377 */
  0x0020,   /* U+4378 */
  0x0020,   /* U+4379 */
  0x0020,   /* U+437A */
  0x0020,   /* U+437B */
  0x0020,   /* U+437C */
  0x0020,   /* U+437D */
  0x0020,   /* U+437E */
  0x0020,   /* U+437F */
  0x0020,   /* U+4380 */
  0x0020,   /* U+4381 */
  0x0020,   /* U+4382 */
  0x0020,   /* U+4383 */
  0x0020,   /* U+4384 */
  0x0020,   /* U+4385 */
  0x0020,   /* U+4386 */
  0x0020,   /* U+4387 */
  0x0020,   /* U+4388 */
  0x0020,   /* U+4389 */
  0x0020,   /* U+438A */
  0x0020,   /* U+438B */
  0x0020,   /* U+438C */
  0x0020,   /* U+438D */
  0x0020,   /* U+438E */
  0x0020,   /* U+438F */
  0x0020,   /* U+4390 */
  0x0020,   /* U+4391 */
  0x0020,   /* U+4392 */
  0x0020,   /* U+4393 */
  0x0020,   /* U+4394 */
  0x0020,   /* U+4395 */
  0x0020,   /* U+4396 */
  0x0020,   /* U+4397 */
  0x0020,   /* U+4398 */
  0x0020,   /* U+4399 */
  0x0020,   /* U+439A */
  0x0020,   /* U+439B */
  0x0020,   /* U+439C */
  0x0020,   /* U+439D */
  0x0020,   /* U+439E */
  0x0020,   /* U+439F */
  0x0020,   /* U+43A0 */
  0x0020,   /* U+43A1 */
  0x0020,   /* U+43A2 */
  0x0020,   /* U+43A3 */
  0x0020,   /* U+43A4 */
  0x0020,   /* U+43A5 */
  0x0020,   /* U+43A6 */
  0x0020,   /* U+43A7 */
  0x0020,   /* U+43A8 */
  0x0020,   /* U+43A9 */
  0x0020,   /* U+43AA */
  0x0020,   /* U+43AB */
  0x0020,   /* U+43AC */
  0x0020,   /* U+43AD */
  0x0020,   /* U+43AE */
  0x0020,   /* U+43AF */
  0x0020,   /* U+43B0 */
  0x0020,   /* U+43B1 */
  0x0020,   /* U+43B2 */
  0x0020,   /* U+43B3 */
  0x0020,   /* U+43B4 */
  0x0020,   /* U+43B5 */
  0x0020,   /* U+43B6 */
  0x0020,   /* U+43B7 */
  0x0020,   /* U+43B8 */
  0x0020,   /* U+43B9 */
  0x0020,   /* U+43BA */
  0x0020,   /* U+43BB */
  0x0020,   /* U+43BC */
  0x0020,   /* U+43BD */
  0x0020,   /* U+43BE */
  0x0020,   /* U+43BF */
  0x0020,   /* U+43C0 */
  0x0020,   /* U+43C1 */
  0x0020,   /* U+43C2 */
  0x0020,   /* U+43C3 */
  0x0020,   /* U+43C4 */
  0x0020,   /* U+43C5 */
  0x0020,   /* U+43C6 */
  0x0020,   /* U+43C7 */
  0x0020,   /* U+43C8 */
  0x0020,   /* U+43C9 */
  0x0020,   /* U+43CA */
  0x0020,   /* U+43CB */
  0x0020,   /* U+43CC */
  0x0020,   /* U+43CD */
  0x0020,   /* U+43CE */
  0x0020,   /* U+43CF */
  0x0020,   /* U+43D0 */
  0x0020,   /* U+43D1 */
  0x0020,   /* U+43D2 */
  0x0020,   /* U+43D3 */
  0x0020,   /* U+43D4 */
  0x0020,   /* U+43D5 */
  0x0020,   /* U+43D6 */
  0x0020,   /* U+43D7 */
  0x0020,   /* U+43D8 */
  0x0020,   /* U+43D9 */
  0x0020,   /* U+43DA */
  0x0020,   /* U+43DB */
  0x0020,   /* U+43DC */
  0x0020,   /* U+43DD */
  0x0020,   /* U+43DE */
  0x0020,   /* U+43DF */
  0x0020,   /* U+43E0 */
  0x0020,   /* U+43E1 */
  0x0020,   /* U+43E2 */
  0x0020,   /* U+43E3 */
  0x0020,   /* U+43E4 */
  0x0020,   /* U+43E5 */
  0x0020,   /* U+43E6 */
  0x0020,   /* U+43E7 */
  0x0020,   /* U+43E8 */
  0x0020,   /* U+43E9 */
  0x0020,   /* U+43EA */
  0x0020,   /* U+43EB */
  0x0020,   /* U+43EC */
  0x0020,   /* U+43ED */
  0x0020,   /* U+43EE */
  0x0020,   /* U+43EF */
  0x0020,   /* U+43F0 */
  0x0020,   /* U+43F1 */
  0x0020,   /* U+43F2 */
  0x0020,   /* U+43F3 */
  0x0020,   /* U+43F4 */
  0x0020,   /* U+43F5 */
  0x0020,   /* U+43F6 */
  0x0020,   /* U+43F7 */
  0x0020,   /* U+43F8 */
  0x0020,   /* U+43F9 */
  0x0020,   /* U+43FA */
  0x0020,   /* U+43FB */
  0x0020,   /* U+43FC */
  0x0020,   /* U+43FD */
  0x0020,   /* U+43FE */
  0x0020,   /* U+43FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4300 */
  0x0002,   /* U+4301 */
  0x0002,   /* U+4302 */
  0x0002,   /* U+4303 */
  0x0002,   /* U+4304 */
  0x0002,   /* U+4305 */
  0x0002,   /* U+4306 */
  0x0002,   /* U+4307 */
  0x0002,   /* U+4308 */
  0x0002,   /* U+4309 */
  0x0002,   /* U+430A */
  0x0002,   /* U+430B */
  0x0002,   /* U+430C */
  0x0002,   /* U+430D */
  0x0002,   /* U+430E */
  0x0002,   /* U+430F */
  0x0002,   /* U+4310 */
  0x0002,   /* U+4311 */
  0x0002,   /* U+4312 */
  0x0002,   /* U+4313 */
  0x0002,   /* U+4314 */
  0x0002,   /* U+4315 */
  0x0002,   /* U+4316 */
  0x0002,   /* U+4317 */
  0x0002,   /* U+4318 */
  0x0002,   /* U+4319 */
  0x0002,   /* U+431A */
  0x0002,   /* U+431B */
  0x0002,   /* U+431C */
  0x0002,   /* U+431D */
  0x0002,   /* U+431E */
  0x0002,   /* U+431F */
  0x0002,   /* U+4320 */
  0x0002,   /* U+4321 */
  0x0002,   /* U+4322 */
  0x0002,   /* U+4323 */
  0x0002,   /* U+4324 */
  0x0002,   /* U+4325 */
  0x0002,   /* U+4326 */
  0x0002,   /* U+4327 */
  0x0002,   /* U+4328 */
  0x0002,   /* U+4329 */
  0x0002,   /* U+432A */
  0x0002,   /* U+432B */
  0x0002,   /* U+432C */
  0x0002,   /* U+432D */
  0x0002,   /* U+432E */
  0x0002,   /* U+432F */
  0x0002,   /* U+4330 */
  0x0002,   /* U+4331 */
  0x0002,   /* U+4332 */
  0x0002,   /* U+4333 */
  0x0002,   /* U+4334 */
  0x0002,   /* U+4335 */
  0x0002,   /* U+4336 */
  0x0002,   /* U+4337 */
  0x0002,   /* U+4338 */
  0x0002,   /* U+4339 */
  0x0002,   /* U+433A */
  0x0002,   /* U+433B */
  0x0002,   /* U+433C */
  0x0002,   /* U+433D */
  0x0002,   /* U+433E */
  0x0002,   /* U+433F */
  0x0002,   /* U+4340 */
  0x0002,   /* U+4341 */
  0x0002,   /* U+4342 */
  0x0002,   /* U+4343 */
  0x0002,   /* U+4344 */
  0x0002,   /* U+4345 */
  0x0002,   /* U+4346 */
  0x0002,   /* U+4347 */
  0x0002,   /* U+4348 */
  0x0002,   /* U+4349 */
  0x0002,   /* U+434A */
  0x0002,   /* U+434B */
  0x0002,   /* U+434C */
  0x0002,   /* U+434D */
  0x0002,   /* U+434E */
  0x0002,   /* U+434F */
  0x0002,   /* U+4350 */
  0x0002,   /* U+4351 */
  0x0002,   /* U+4352 */
  0x0002,   /* U+4353 */
  0x0002,   /* U+4354 */
  0x0002,   /* U+4355 */
  0x0002,   /* U+4356 */
  0x0002,   /* U+4357 */
  0x0002,   /* U+4358 */
  0x0002,   /* U+4359 */
  0x0002,   /* U+435A */
  0x0002,   /* U+435B */
  0x0002,   /* U+435C */
  0x0002,   /* U+435D */
  0x0002,   /* U+435E */
  0x0002,   /* U+435F */
  0x0002,   /* U+4360 */
  0x0002,   /* U+4361 */
  0x0002,   /* U+4362 */
  0x0002,   /* U+4363 */
  0x0002,   /* U+4364 */
  0x0002,   /* U+4365 */
  0x0002,   /* U+4366 */
  0x0002,   /* U+4367 */
  0x0002,   /* U+4368 */
  0x0002,   /* U+4369 */
  0x0002,   /* U+436A */
  0x0002,   /* U+436B */
  0x0002,   /* U+436C */
  0x0002,   /* U+436D */
  0x0002,   /* U+436E */
  0x0002,   /* U+436F */
  0x0002,   /* U+4370 */
  0x0002,   /* U+4371 */
  0x0002,   /* U+4372 */
  0x0002,   /* U+4373 */
  0x0002,   /* U+4374 */
  0x0002,   /* U+4375 */
  0x0002,   /* U+4376 */
  0x0002,   /* U+4377 */
  0x0002,   /* U+4378 */
  0x0002,   /* U+4379 */
  0x0002,   /* U+437A */
  0x0002,   /* U+437B */
  0x0002,   /* U+437C */
  0x0002,   /* U+437D */
  0x0002,   /* U+437E */
  0x0002,   /* U+437F */
  0x0002,   /* U+4380 */
  0x0002,   /* U+4381 */
  0x0002,   /* U+4382 */
  0x0002,   /* U+4383 */
  0x0002,   /* U+4384 */
  0x0002,   /* U+4385 */
  0x0002,   /* U+4386 */
  0x0002,   /* U+4387 */
  0x0002,   /* U+4388 */
  0x0002,   /* U+4389 */
  0x0002,   /* U+438A */
  0x0002,   /* U+438B */
  0x0002,   /* U+438C */
  0x0002,   /* U+438D */
  0x0002,   /* U+438E */
  0x0002,   /* U+438F */
  0x0002,   /* U+4390 */
  0x0002,   /* U+4391 */
  0x0002,   /* U+4392 */
  0x0002,   /* U+4393 */
  0x0002,   /* U+4394 */
  0x0002,   /* U+4395 */
  0x0002,   /* U+4396 */
  0x0002,   /* U+4397 */
  0x0002,   /* U+4398 */
  0x0002,   /* U+4399 */
  0x0002,   /* U+439A */
  0x0002,   /* U+439B */
  0x0002,   /* U+439C */
  0x0002,   /* U+439D */
  0x0002,   /* U+439E */
  0x0002,   /* U+439F */
  0x0002,   /* U+43A0 */
  0x0002,   /* U+43A1 */
  0x0002,   /* U+43A2 */
  0x0002,   /* U+43A3 */
  0x0002,   /* U+43A4 */
  0x0002,   /* U+43A5 */
  0x0002,   /* U+43A6 */
  0x0002,   /* U+43A7 */
  0x0002,   /* U+43A8 */
  0x0002,   /* U+43A9 */
  0x0002,   /* U+43AA */
  0x0002,   /* U+43AB */
  0x0002,   /* U+43AC */
  0x0002,   /* U+43AD */
  0x0002,   /* U+43AE */
  0x0002,   /* U+43AF */
  0x0002,   /* U+43B0 */
  0x0002,   /* U+43B1 */
  0x0002,   /* U+43B2 */
  0x0002,   /* U+43B3 */
  0x0002,   /* U+43B4 */
  0x0002,   /* U+43B5 */
  0x0002,   /* U+43B6 */
  0x0002,   /* U+43B7 */
  0x0002,   /* U+43B8 */
  0x0002,   /* U+43B9 */
  0x0002,   /* U+43BA */
  0x0002,   /* U+43BB */
  0x0002,   /* U+43BC */
  0x0002,   /* U+43BD */
  0x0002,   /* U+43BE */
  0x0002,   /* U+43BF */
  0x0002,   /* U+43C0 */
  0x0002,   /* U+43C1 */
  0x0002,   /* U+43C2 */
  0x0002,   /* U+43C3 */
  0x0002,   /* U+43C4 */
  0x0002,   /* U+43C5 */
  0x0002,   /* U+43C6 */
  0x0002,   /* U+43C7 */
  0x0002,   /* U+43C8 */
  0x0002,   /* U+43C9 */
  0x0002,   /* U+43CA */
  0x0002,   /* U+43CB */
  0x0002,   /* U+43CC */
  0x0002,   /* U+43CD */
  0x0002,   /* U+43CE */
  0x0002,   /* U+43CF */
  0x0002,   /* U+43D0 */
  0x0002,   /* U+43D1 */
  0x0002,   /* U+43D2 */
  0x0002,   /* U+43D3 */
  0x0002,   /* U+43D4 */
  0x0002,   /* U+43D5 */
  0x0002,   /* U+43D6 */
  0x0002,   /* U+43D7 */
  0x0002,   /* U+43D8 */
  0x0002,   /* U+43D9 */
  0x0002,   /* U+43DA */
  0x0002,   /* U+43DB */
  0x0002,   /* U+43DC */
  0x0002,   /* U+43DD */
  0x0002,   /* U+43DE */
  0x0002,   /* U+43DF */
  0x0002,   /* U+43E0 */
  0x0002,   /* U+43E1 */
  0x0002,   /* U+43E2 */
  0x0002,   /* U+43E3 */
  0x0002,   /* U+43E4 */
  0x0002,   /* U+43E5 */
  0x0002,   /* U+43E6 */
  0x0002,   /* U+43E7 */
  0x0002,   /* U+43E8 */
  0x0002,   /* U+43E9 */
  0x0002,   /* U+43EA */
  0x0002,   /* U+43EB */
  0x0002,   /* U+43EC */
  0x0002,   /* U+43ED */
  0x0002,   /* U+43EE */
  0x0002,   /* U+43EF */
  0x0002,   /* U+43F0 */
  0x0002,   /* U+43F1 */
  0x0002,   /* U+43F2 */
  0x0002,   /* U+43F3 */
  0x0002,   /* U+43F4 */
  0x0002,   /* U+43F5 */
  0x0002,   /* U+43F6 */
  0x0002,   /* U+43F7 */
  0x0002,   /* U+43F8 */
  0x0002,   /* U+43F9 */
  0x0002,   /* U+43FA */
  0x0002,   /* U+43FB */
  0x0002,   /* U+43FC */
  0x0002,   /* U+43FD */
  0x0002,   /* U+43FE */
  0x0002,   /* U+43FF */

  /* Primary weight 2 for each character. */
  0x8039,   /* U+4300 */
  0x803A,   /* U+4301 */
  0x803B,   /* U+4302 */
  0x803C,   /* U+4303 */
  0x803D,   /* U+4304 */
  0x8001,   /* U+4305 */
  0x8002,   /* U+4306 */
  0x8003,   /* U+4307 */
  0x8004,   /* U+4308 */
  0x8005,   /* U+4309 */
  0x8006,   /* U+430A */
  0x8007,   /* U+430B */
  0x8013,   /* U+430C */
  0x8014,   /* U+430D */
  0x8015,   /* U+430E */
  0x8016,   /* U+430F */
  0x8017,   /* U+4310 */
  0x8018,   /* U+4311 */
  0x8019,   /* U+4312 */
  0x801A,   /* U+4313 */
  0x801B,   /* U+4314 */
  0x801C,   /* U+4315 */
  0x800F,   /* U+4316 */
  0x8010,   /* U+4317 */
  0x8011,   /* U+4318 */
  0x8012,   /* U+4319 */
  0x8013,   /* U+431A */
  0x8014,   /* U+431B */
  0x800A,   /* U+431C */
  0x800B,   /* U+431D */
  0x800C,   /* U+431E */
  0x800D,   /* U+431F */
  0x800E,   /* U+4320 */
  0x800F,   /* U+4321 */
  0x8010,   /* U+4322 */
  0x8004,   /* U+4323 */
  0x8005,   /* U+4324 */
  0x8006,   /* U+4325 */
  0x8007,   /* U+4326 */
  0x8008,   /* U+4327 */
  0x8001,   /* U+4328 */
  0x8002,   /* U+4329 */
  0x8001,   /* U+432A */
  0x8002,   /* U+432B */
  0x8003,   /* U+432C */
  0x8004,   /* U+432D */
  0x8001,   /* U+432E */
  0x8001,   /* U+432F */
  0x8002,   /* U+4330 */
  0x8003,   /* U+4331 */
  0x8004,   /* U+4332 */
  0x8000,   /* U+4333 */
  0x8001,   /* U+4334 */
  0x8000,   /* U+4335 */
  0x8000,   /* U+4336 */
  0x8000,   /* U+4337 */
  0x8000,   /* U+4338 */
  0x8001,   /* U+4339 */
  0x8000,   /* U+433A */
  0x8001,   /* U+433B */
  0x8000,   /* U+433C */
  0x8000,   /* U+433D */
  0x8000,   /* U+433E */
  0x8001,   /* U+433F */
  0x8000,   /* U+4340 */
  0x8000,   /* U+4341 */
  0x8000,   /* U+4342 */
  0x8000,   /* U+4343 */
  0x8000,   /* U+4344 */
  0x8001,   /* U+4345 */
  0x8002,   /* U+4346 */
  0x8003,   /* U+4347 */
  0x8004,   /* U+4348 */
  0x8005,   /* U+4349 */
  0x8000,   /* U+434A */
  0x8000,   /* U+434B */
  0x8001,   /* U+434C */
  0x8000,   /* U+434D */
  0x8000,   /* U+434E */
  0xC34F,   /* U+434F */
  0x8000,   /* U+4350 */
  0x8001,   /* U+4351 */
  0x8000,   /* U+4352 */
  0x8001,   /* U+4353 */
  0x8002,   /* U+4354 */
  0x8000,   /* U+4355 */
  0x8001,   /* U+4356 */
  0x8002,   /* U+4357 */
  0x8000,   /* U+4358 */
  0x8000,   /* U+4359 */
  0x8001,   /* U+435A */
  0x8000,   /* U+435B */
  0x8001,   /* U+435C */
  0x8002,   /* U+435D */
  0xC35E,   /* U+435E */
  0x8000,   /* U+435F */
  0x8000,   /* U+4360 */
  0x8001,   /* U+4361 */
  0x8000,   /* U+4362 */
  0x8000,   /* U+4363 */
  0x8000,   /* U+4364 */
  0x8000,   /* U+4365 */
  0x8000,   /* U+4366 */
  0x8000,   /* U+4367 */
  0x8001,   /* U+4368 */
  0x8002,   /* U+4369 */
  0x8000,   /* U+436A */
  0x8001,   /* U+436B */
  0x8002,   /* U+436C */
  0x8003,   /* U+436D */
  0x8000,   /* U+436E */
  0x8001,   /* U+436F */
  0x8002,   /* U+4370 */
  0x8000,   /* U+4371 */
  0x8000,   /* U+4372 */
  0x8001,   /* U+4373 */
  0x8002,   /* U+4374 */
  0x8003,   /* U+4375 */
  0x8004,   /* U+4376 */
  0x8000,   /* U+4377 */
  0x8000,   /* U+4378 */
  0x8001,   /* U+4379 */
  0x8000,   /* U+437A */
  0x8000,   /* U+437B */
  0x8001,   /* U+437C */
  0x8000,   /* U+437D */
  0x8000,   /* U+437E */
  0x8001,   /* U+437F */
  0x8000,   /* U+4380 */
  0x8001,   /* U+4381 */
  0x8002,   /* U+4382 */
  0x8003,   /* U+4383 */
  0x8004,   /* U+4384 */
  0x8005,   /* U+4385 */
  0x8006,   /* U+4386 */
  0x8000,   /* U+4387 */
  0x8001,   /* U+4388 */
  0x8002,   /* U+4389 */
  0x8003,   /* U+438A */
  0x8000,   /* U+438B */
  0x8001,   /* U+438C */
  0x8002,   /* U+438D */
  0x8003,   /* U+438E */
  0x8000,   /* U+438F */
  0x8001,   /* U+4390 */
  0x8002,   /* U+4391 */
  0x8003,   /* U+4392 */
  0x8004,   /* U+4393 */
  0x8000,   /* U+4394 */
  0x8001,   /* U+4395 */
  0x8000,   /* U+4396 */
  0x8001,   /* U+4397 */
  0x8002,   /* U+4398 */
  0x8000,   /* U+4399 */
  0x8000,   /* U+439A */
  0xC39B,   /* U+439B */
  0x8000,   /* U+439C */
  0x8001,   /* U+439D */
  0xC39E,   /* U+439E */
  0x8000,   /* U+439F */
  0x8001,   /* U+43A0 */
  0x8000,   /* U+43A1 */
  0x8000,   /* U+43A2 */
  0x8000,   /* U+43A3 */
  0x8000,   /* U+43A4 */
  0x8001,   /* U+43A5 */
  0x8000,   /* U+43A6 */
  0x8001,   /* U+43A7 */
  0x8002,   /* U+43A8 */
  0x8003,   /* U+43A9 */
  0x8004,   /* U+43AA */
  0x8000,   /* U+43AB */
  0x8001,   /* U+43AC */
  0x8000,   /* U+43AD */
  0x8001,   /* U+43AE */
  0x8002,   /* U+43AF */
  0x8000,   /* U+43B0 */
  0x8000,   /* U+43B1 */
  0x8000,   /* U+43B2 */
  0x8000,   /* U+43B3 */
  0x8001,   /* U+43B4 */
  0x8000,   /* U+43B5 */
  0x8001,   /* U+43B6 */
  0x8000,   /* U+43B7 */
  0x8000,   /* U+43B8 */
  0x8001,   /* U+43B9 */
  0x8000,   /* U+43BA */
  0x8001,   /* U+43BB */
  0x8002,   /* U+43BC */
  0x8003,   /* U+43BD */
  0x8004,   /* U+43BE */
  0x8000,   /* U+43BF */
  0x8001,   /* U+43C0 */
  0x8001,   /* U+43C1 */
  0x8002,   /* U+43C2 */
  0x8003,   /* U+43C3 */
  0x8000,   /* U+43C4 */
  0x8001,   /* U+43C5 */
  0x8002,   /* U+43C6 */
  0x8003,   /* U+43C7 */
  0x8000,   /* U+43C8 */
  0x8000,   /* U+43C9 */
  0x8000,   /* U+43CA */
  0x8000,   /* U+43CB */
  0x8000,   /* U+43CC */
  0x8001,   /* U+43CD */
  0x8000,   /* U+43CE */
  0x8001,   /* U+43CF */
  0x8000,   /* U+43D0 */
  0x8001,   /* U+43D1 */
  0x8002,   /* U+43D2 */
  0x8003,   /* U+43D3 */
  0x8004,   /* U+43D4 */
  0x8005,   /* U+43D5 */
  0x8006,   /* U+43D6 */
  0x8007,   /* U+43D7 */
  0x8008,   /* U+43D8 */
  0x8009,   /* U+43D9 */
  0x800A,   /* U+43DA */
  0x800B,   /* U+43DB */
  0x800C,   /* U+43DC */
  0x800D,   /* U+43DD */
  0x8000,   /* U+43DE */
  0x8001,   /* U+43DF */
  0x8002,   /* U+43E0 */
  0x8003,   /* U+43E1 */
  0x8004,   /* U+43E2 */
  0x8005,   /* U+43E3 */
  0x8006,   /* U+43E4 */
  0x8007,   /* U+43E5 */
  0x8000,   /* U+43E6 */
  0x8001,   /* U+43E7 */
  0x8002,   /* U+43E8 */
  0x8003,   /* U+43E9 */
  0x8004,   /* U+43EA */
  0x8005,   /* U+43EB */
  0x8006,   /* U+43EC */
  0xC3ED,   /* U+43ED */
  0xC3EE,   /* U+43EE */
  0x8000,   /* U+43EF */
  0x8001,   /* U+43F0 */
  0x8002,   /* U+43F1 */
  0x8003,   /* U+43F2 */
  0x8004,   /* U+43F3 */
  0x8005,   /* U+43F4 */
  0x8006,   /* U+43F5 */
  0x8007,   /* U+43F6 */
  0x8008,   /* U+43F7 */
  0x8009,   /* U+43F8 */
  0x800A,   /* U+43F9 */
  0x800B,   /* U+43FA */
  0x800C,   /* U+43FB */
  0x8001,   /* U+43FC */
  0x8002,   /* U+43FD */
  0x8003,   /* U+43FE */
  0x8004,   /* U+43FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4300 */
  0x0000,   /* U+4301 */
  0x0000,   /* U+4302 */
  0x0000,   /* U+4303 */
  0x0000,   /* U+4304 */
  0x0000,   /* U+4305 */
  0x0000,   /* U+4306 */
  0x0000,   /* U+4307 */
  0x0000,   /* U+4308 */
  0x0000,   /* U+4309 */
  0x0000,   /* U+430A */
  0x0000,   /* U+430B */
  0x0000,   /* U+430C */
  0x0000,   /* U+430D */
  0x0000,   /* U+430E */
  0x0000,   /* U+430F */
  0x0000,   /* U+4310 */
  0x0000,   /* U+4311 */
  0x0000,   /* U+4312 */
  0x0000,   /* U+4313 */
  0x0000,   /* U+4314 */
  0x0000,   /* U+4315 */
  0x0000,   /* U+4316 */
  0x0000,   /* U+4317 */
  0x0000,   /* U+4318 */
  0x0000,   /* U+4319 */
  0x0000,   /* U+431A */
  0x0000,   /* U+431B */
  0x0000,   /* U+431C */
  0x0000,   /* U+431D */
  0x0000,   /* U+431E */
  0x0000,   /* U+431F */
  0x0000,   /* U+4320 */
  0x0000,   /* U+4321 */
  0x0000,   /* U+4322 */
  0x0000,   /* U+4323 */
  0x0000,   /* U+4324 */
  0x0000,   /* U+4325 */
  0x0000,   /* U+4326 */
  0x0000,   /* U+4327 */
  0x0000,   /* U+4328 */
  0x0000,   /* U+4329 */
  0x0000,   /* U+432A */
  0x0000,   /* U+432B */
  0x0000,   /* U+432C */
  0x0000,   /* U+432D */
  0x0000,   /* U+432E */
  0x0000,   /* U+432F */
  0x0000,   /* U+4330 */
  0x0000,   /* U+4331 */
  0x0000,   /* U+4332 */
  0x0000,   /* U+4333 */
  0x0000,   /* U+4334 */
  0x0000,   /* U+4335 */
  0x0000,   /* U+4336 */
  0x0000,   /* U+4337 */
  0x0000,   /* U+4338 */
  0x0000,   /* U+4339 */
  0x0000,   /* U+433A */
  0x0000,   /* U+433B */
  0x0000,   /* U+433C */
  0x0000,   /* U+433D */
  0x0000,   /* U+433E */
  0x0000,   /* U+433F */
  0x0000,   /* U+4340 */
  0x0000,   /* U+4341 */
  0x0000,   /* U+4342 */
  0x0000,   /* U+4343 */
  0x0000,   /* U+4344 */
  0x0000,   /* U+4345 */
  0x0000,   /* U+4346 */
  0x0000,   /* U+4347 */
  0x0000,   /* U+4348 */
  0x0000,   /* U+4349 */
  0x0000,   /* U+434A */
  0x0000,   /* U+434B */
  0x0000,   /* U+434C */
  0x0000,   /* U+434D */
  0x0000,   /* U+434E */
  0x0000,   /* U+434F */
  0x0000,   /* U+4350 */
  0x0000,   /* U+4351 */
  0x0000,   /* U+4352 */
  0x0000,   /* U+4353 */
  0x0000,   /* U+4354 */
  0x0000,   /* U+4355 */
  0x0000,   /* U+4356 */
  0x0000,   /* U+4357 */
  0x0000,   /* U+4358 */
  0x0000,   /* U+4359 */
  0x0000,   /* U+435A */
  0x0000,   /* U+435B */
  0x0000,   /* U+435C */
  0x0000,   /* U+435D */
  0x0000,   /* U+435E */
  0x0000,   /* U+435F */
  0x0000,   /* U+4360 */
  0x0000,   /* U+4361 */
  0x0000,   /* U+4362 */
  0x0000,   /* U+4363 */
  0x0000,   /* U+4364 */
  0x0000,   /* U+4365 */
  0x0000,   /* U+4366 */
  0x0000,   /* U+4367 */
  0x0000,   /* U+4368 */
  0x0000,   /* U+4369 */
  0x0000,   /* U+436A */
  0x0000,   /* U+436B */
  0x0000,   /* U+436C */
  0x0000,   /* U+436D */
  0x0000,   /* U+436E */
  0x0000,   /* U+436F */
  0x0000,   /* U+4370 */
  0x0000,   /* U+4371 */
  0x0000,   /* U+4372 */
  0x0000,   /* U+4373 */
  0x0000,   /* U+4374 */
  0x0000,   /* U+4375 */
  0x0000,   /* U+4376 */
  0x0000,   /* U+4377 */
  0x0000,   /* U+4378 */
  0x0000,   /* U+4379 */
  0x0000,   /* U+437A */
  0x0000,   /* U+437B */
  0x0000,   /* U+437C */
  0x0000,   /* U+437D */
  0x0000,   /* U+437E */
  0x0000,   /* U+437F */
  0x0000,   /* U+4380 */
  0x0000,   /* U+4381 */
  0x0000,   /* U+4382 */
  0x0000,   /* U+4383 */
  0x0000,   /* U+4384 */
  0x0000,   /* U+4385 */
  0x0000,   /* U+4386 */
  0x0000,   /* U+4387 */
  0x0000,   /* U+4388 */
  0x0000,   /* U+4389 */
  0x0000,   /* U+438A */
  0x0000,   /* U+438B */
  0x0000,   /* U+438C */
  0x0000,   /* U+438D */
  0x0000,   /* U+438E */
  0x0000,   /* U+438F */
  0x0000,   /* U+4390 */
  0x0000,   /* U+4391 */
  0x0000,   /* U+4392 */
  0x0000,   /* U+4393 */
  0x0000,   /* U+4394 */
  0x0000,   /* U+4395 */
  0x0000,   /* U+4396 */
  0x0000,   /* U+4397 */
  0x0000,   /* U+4398 */
  0x0000,   /* U+4399 */
  0x0000,   /* U+439A */
  0x0000,   /* U+439B */
  0x0000,   /* U+439C */
  0x0000,   /* U+439D */
  0x0000,   /* U+439E */
  0x0000,   /* U+439F */
  0x0000,   /* U+43A0 */
  0x0000,   /* U+43A1 */
  0x0000,   /* U+43A2 */
  0x0000,   /* U+43A3 */
  0x0000,   /* U+43A4 */
  0x0000,   /* U+43A5 */
  0x0000,   /* U+43A6 */
  0x0000,   /* U+43A7 */
  0x0000,   /* U+43A8 */
  0x0000,   /* U+43A9 */
  0x0000,   /* U+43AA */
  0x0000,   /* U+43AB */
  0x0000,   /* U+43AC */
  0x0000,   /* U+43AD */
  0x0000,   /* U+43AE */
  0x0000,   /* U+43AF */
  0x0000,   /* U+43B0 */
  0x0000,   /* U+43B1 */
  0x0000,   /* U+43B2 */
  0x0000,   /* U+43B3 */
  0x0000,   /* U+43B4 */
  0x0000,   /* U+43B5 */
  0x0000,   /* U+43B6 */
  0x0000,   /* U+43B7 */
  0x0000,   /* U+43B8 */
  0x0000,   /* U+43B9 */
  0x0000,   /* U+43BA */
  0x0000,   /* U+43BB */
  0x0000,   /* U+43BC */
  0x0000,   /* U+43BD */
  0x0000,   /* U+43BE */
  0x0000,   /* U+43BF */
  0x0000,   /* U+43C0 */
  0x0000,   /* U+43C1 */
  0x0000,   /* U+43C2 */
  0x0000,   /* U+43C3 */
  0x0000,   /* U+43C4 */
  0x0000,   /* U+43C5 */
  0x0000,   /* U+43C6 */
  0x0000,   /* U+43C7 */
  0x0000,   /* U+43C8 */
  0x0000,   /* U+43C9 */
  0x0000,   /* U+43CA */
  0x0000,   /* U+43CB */
  0x0000,   /* U+43CC */
  0x0000,   /* U+43CD */
  0x0000,   /* U+43CE */
  0x0000,   /* U+43CF */
  0x0000,   /* U+43D0 */
  0x0000,   /* U+43D1 */
  0x0000,   /* U+43D2 */
  0x0000,   /* U+43D3 */
  0x0000,   /* U+43D4 */
  0x0000,   /* U+43D5 */
  0x0000,   /* U+43D6 */
  0x0000,   /* U+43D7 */
  0x0000,   /* U+43D8 */
  0x0000,   /* U+43D9 */
  0x0000,   /* U+43DA */
  0x0000,   /* U+43DB */
  0x0000,   /* U+43DC */
  0x0000,   /* U+43DD */
  0x0000,   /* U+43DE */
  0x0000,   /* U+43DF */
  0x0000,   /* U+43E0 */
  0x0000,   /* U+43E1 */
  0x0000,   /* U+43E2 */
  0x0000,   /* U+43E3 */
  0x0000,   /* U+43E4 */
  0x0000,   /* U+43E5 */
  0x0000,   /* U+43E6 */
  0x0000,   /* U+43E7 */
  0x0000,   /* U+43E8 */
  0x0000,   /* U+43E9 */
  0x0000,   /* U+43EA */
  0x0000,   /* U+43EB */
  0x0000,   /* U+43EC */
  0x0000,   /* U+43ED */
  0x0000,   /* U+43EE */
  0x0000,   /* U+43EF */
  0x0000,   /* U+43F0 */
  0x0000,   /* U+43F1 */
  0x0000,   /* U+43F2 */
  0x0000,   /* U+43F3 */
  0x0000,   /* U+43F4 */
  0x0000,   /* U+43F5 */
  0x0000,   /* U+43F6 */
  0x0000,   /* U+43F7 */
  0x0000,   /* U+43F8 */
  0x0000,   /* U+43F9 */
  0x0000,   /* U+43FA */
  0x0000,   /* U+43FB */
  0x0000,   /* U+43FC */
  0x0000,   /* U+43FD */
  0x0000,   /* U+43FE */
  0x0000,   /* U+43FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4300 */
  0x0000,   /* U+4301 */
  0x0000,   /* U+4302 */
  0x0000,   /* U+4303 */
  0x0000,   /* U+4304 */
  0x0000,   /* U+4305 */
  0x0000,   /* U+4306 */
  0x0000,   /* U+4307 */
  0x0000,   /* U+4308 */
  0x0000,   /* U+4309 */
  0x0000,   /* U+430A */
  0x0000,   /* U+430B */
  0x0000,   /* U+430C */
  0x0000,   /* U+430D */
  0x0000,   /* U+430E */
  0x0000,   /* U+430F */
  0x0000,   /* U+4310 */
  0x0000,   /* U+4311 */
  0x0000,   /* U+4312 */
  0x0000,   /* U+4313 */
  0x0000,   /* U+4314 */
  0x0000,   /* U+4315 */
  0x0000,   /* U+4316 */
  0x0000,   /* U+4317 */
  0x0000,   /* U+4318 */
  0x0000,   /* U+4319 */
  0x0000,   /* U+431A */
  0x0000,   /* U+431B */
  0x0000,   /* U+431C */
  0x0000,   /* U+431D */
  0x0000,   /* U+431E */
  0x0000,   /* U+431F */
  0x0000,   /* U+4320 */
  0x0000,   /* U+4321 */
  0x0000,   /* U+4322 */
  0x0000,   /* U+4323 */
  0x0000,   /* U+4324 */
  0x0000,   /* U+4325 */
  0x0000,   /* U+4326 */
  0x0000,   /* U+4327 */
  0x0000,   /* U+4328 */
  0x0000,   /* U+4329 */
  0x0000,   /* U+432A */
  0x0000,   /* U+432B */
  0x0000,   /* U+432C */
  0x0000,   /* U+432D */
  0x0000,   /* U+432E */
  0x0000,   /* U+432F */
  0x0000,   /* U+4330 */
  0x0000,   /* U+4331 */
  0x0000,   /* U+4332 */
  0x0000,   /* U+4333 */
  0x0000,   /* U+4334 */
  0x0000,   /* U+4335 */
  0x0000,   /* U+4336 */
  0x0000,   /* U+4337 */
  0x0000,   /* U+4338 */
  0x0000,   /* U+4339 */
  0x0000,   /* U+433A */
  0x0000,   /* U+433B */
  0x0000,   /* U+433C */
  0x0000,   /* U+433D */
  0x0000,   /* U+433E */
  0x0000,   /* U+433F */
  0x0000,   /* U+4340 */
  0x0000,   /* U+4341 */
  0x0000,   /* U+4342 */
  0x0000,   /* U+4343 */
  0x0000,   /* U+4344 */
  0x0000,   /* U+4345 */
  0x0000,   /* U+4346 */
  0x0000,   /* U+4347 */
  0x0000,   /* U+4348 */
  0x0000,   /* U+4349 */
  0x0000,   /* U+434A */
  0x0000,   /* U+434B */
  0x0000,   /* U+434C */
  0x0000,   /* U+434D */
  0x0000,   /* U+434E */
  0x0000,   /* U+434F */
  0x0000,   /* U+4350 */
  0x0000,   /* U+4351 */
  0x0000,   /* U+4352 */
  0x0000,   /* U+4353 */
  0x0000,   /* U+4354 */
  0x0000,   /* U+4355 */
  0x0000,   /* U+4356 */
  0x0000,   /* U+4357 */
  0x0000,   /* U+4358 */
  0x0000,   /* U+4359 */
  0x0000,   /* U+435A */
  0x0000,   /* U+435B */
  0x0000,   /* U+435C */
  0x0000,   /* U+435D */
  0x0000,   /* U+435E */
  0x0000,   /* U+435F */
  0x0000,   /* U+4360 */
  0x0000,   /* U+4361 */
  0x0000,   /* U+4362 */
  0x0000,   /* U+4363 */
  0x0000,   /* U+4364 */
  0x0000,   /* U+4365 */
  0x0000,   /* U+4366 */
  0x0000,   /* U+4367 */
  0x0000,   /* U+4368 */
  0x0000,   /* U+4369 */
  0x0000,   /* U+436A */
  0x0000,   /* U+436B */
  0x0000,   /* U+436C */
  0x0000,   /* U+436D */
  0x0000,   /* U+436E */
  0x0000,   /* U+436F */
  0x0000,   /* U+4370 */
  0x0000,   /* U+4371 */
  0x0000,   /* U+4372 */
  0x0000,   /* U+4373 */
  0x0000,   /* U+4374 */
  0x0000,   /* U+4375 */
  0x0000,   /* U+4376 */
  0x0000,   /* U+4377 */
  0x0000,   /* U+4378 */
  0x0000,   /* U+4379 */
  0x0000,   /* U+437A */
  0x0000,   /* U+437B */
  0x0000,   /* U+437C */
  0x0000,   /* U+437D */
  0x0000,   /* U+437E */
  0x0000,   /* U+437F */
  0x0000,   /* U+4380 */
  0x0000,   /* U+4381 */
  0x0000,   /* U+4382 */
  0x0000,   /* U+4383 */
  0x0000,   /* U+4384 */
  0x0000,   /* U+4385 */
  0x0000,   /* U+4386 */
  0x0000,   /* U+4387 */
  0x0000,   /* U+4388 */
  0x0000,   /* U+4389 */
  0x0000,   /* U+438A */
  0x0000,   /* U+438B */
  0x0000,   /* U+438C */
  0x0000,   /* U+438D */
  0x0000,   /* U+438E */
  0x0000,   /* U+438F */
  0x0000,   /* U+4390 */
  0x0000,   /* U+4391 */
  0x0000,   /* U+4392 */
  0x0000,   /* U+4393 */
  0x0000,   /* U+4394 */
  0x0000,   /* U+4395 */
  0x0000,   /* U+4396 */
  0x0000,   /* U+4397 */
  0x0000,   /* U+4398 */
  0x0000,   /* U+4399 */
  0x0000,   /* U+439A */
  0x0000,   /* U+439B */
  0x0000,   /* U+439C */
  0x0000,   /* U+439D */
  0x0000,   /* U+439E */
  0x0000,   /* U+439F */
  0x0000,   /* U+43A0 */
  0x0000,   /* U+43A1 */
  0x0000,   /* U+43A2 */
  0x0000,   /* U+43A3 */
  0x0000,   /* U+43A4 */
  0x0000,   /* U+43A5 */
  0x0000,   /* U+43A6 */
  0x0000,   /* U+43A7 */
  0x0000,   /* U+43A8 */
  0x0000,   /* U+43A9 */
  0x0000,   /* U+43AA */
  0x0000,   /* U+43AB */
  0x0000,   /* U+43AC */
  0x0000,   /* U+43AD */
  0x0000,   /* U+43AE */
  0x0000,   /* U+43AF */
  0x0000,   /* U+43B0 */
  0x0000,   /* U+43B1 */
  0x0000,   /* U+43B2 */
  0x0000,   /* U+43B3 */
  0x0000,   /* U+43B4 */
  0x0000,   /* U+43B5 */
  0x0000,   /* U+43B6 */
  0x0000,   /* U+43B7 */
  0x0000,   /* U+43B8 */
  0x0000,   /* U+43B9 */
  0x0000,   /* U+43BA */
  0x0000,   /* U+43BB */
  0x0000,   /* U+43BC */
  0x0000,   /* U+43BD */
  0x0000,   /* U+43BE */
  0x0000,   /* U+43BF */
  0x0000,   /* U+43C0 */
  0x0000,   /* U+43C1 */
  0x0000,   /* U+43C2 */
  0x0000,   /* U+43C3 */
  0x0000,   /* U+43C4 */
  0x0000,   /* U+43C5 */
  0x0000,   /* U+43C6 */
  0x0000,   /* U+43C7 */
  0x0000,   /* U+43C8 */
  0x0000,   /* U+43C9 */
  0x0000,   /* U+43CA */
  0x0000,   /* U+43CB */
  0x0000,   /* U+43CC */
  0x0000,   /* U+43CD */
  0x0000,   /* U+43CE */
  0x0000,   /* U+43CF */
  0x0000,   /* U+43D0 */
  0x0000,   /* U+43D1 */
  0x0000,   /* U+43D2 */
  0x0000,   /* U+43D3 */
  0x0000,   /* U+43D4 */
  0x0000,   /* U+43D5 */
  0x0000,   /* U+43D6 */
  0x0000,   /* U+43D7 */
  0x0000,   /* U+43D8 */
  0x0000,   /* U+43D9 */
  0x0000,   /* U+43DA */
  0x0000,   /* U+43DB */
  0x0000,   /* U+43DC */
  0x0000,   /* U+43DD */
  0x0000,   /* U+43DE */
  0x0000,   /* U+43DF */
  0x0000,   /* U+43E0 */
  0x0000,   /* U+43E1 */
  0x0000,   /* U+43E2 */
  0x0000,   /* U+43E3 */
  0x0000,   /* U+43E4 */
  0x0000,   /* U+43E5 */
  0x0000,   /* U+43E6 */
  0x0000,   /* U+43E7 */
  0x0000,   /* U+43E8 */
  0x0000,   /* U+43E9 */
  0x0000,   /* U+43EA */
  0x0000,   /* U+43EB */
  0x0000,   /* U+43EC */
  0x0000,   /* U+43ED */
  0x0000,   /* U+43EE */
  0x0000,   /* U+43EF */
  0x0000,   /* U+43F0 */
  0x0000,   /* U+43F1 */
  0x0000,   /* U+43F2 */
  0x0000,   /* U+43F3 */
  0x0000,   /* U+43F4 */
  0x0000,   /* U+43F5 */
  0x0000,   /* U+43F6 */
  0x0000,   /* U+43F7 */
  0x0000,   /* U+43F8 */
  0x0000,   /* U+43F9 */
  0x0000,   /* U+43FA */
  0x0000,   /* U+43FB */
  0x0000,   /* U+43FC */
  0x0000,   /* U+43FD */
  0x0000,   /* U+43FE */
  0x0000,   /* U+43FF */
};

uint16 zh2_han_p044[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x3CD4,   /* U+4400 */
  0x3CD4,   /* U+4401 */
  0x3CD4,   /* U+4402 */
  0x3CD4,   /* U+4403 */
  0x3CD4,   /* U+4404 */
  0x3CD4,   /* U+4405 */
  0x3CD4,   /* U+4406 */
  0x3CD4,   /* U+4407 */
  0x3CD4,   /* U+4408 */
  0x3CD4,   /* U+4409 */
  0x3CD4,   /* U+440A */
  0x3CD4,   /* U+440B */
  0x3CD4,   /* U+440C */
  0x3CD5,   /* U+440D */
  0x3CD5,   /* U+440E */
  0x3CD5,   /* U+440F */
  0x3CD5,   /* U+4410 */
  0x3CD5,   /* U+4411 */
  0x3CD5,   /* U+4412 */
  0x3CD5,   /* U+4413 */
  0x3CD5,   /* U+4414 */
  0x3CD5,   /* U+4415 */
  0x3CD5,   /* U+4416 */
  0x3CD5,   /* U+4417 */
  0x3CD5,   /* U+4418 */
  0x3CD5,   /* U+4419 */
  0x3CD5,   /* U+441A */
  0x3CD5,   /* U+441B */
  0x3CCD,   /* U+441C */
  0x3CCD,   /* U+441D */
  0x3CCD,   /* U+441E */
  0x3CCD,   /* U+441F */
  0x3CCD,   /* U+4420 */
  0x3CCD,   /* U+4421 */
  0x3CCD,   /* U+4422 */
  0x3CCD,   /* U+4423 */
  0x3CCD,   /* U+4424 */
  0x3CCD,   /* U+4425 */
  0x3CCD,   /* U+4426 */
  0x3CCD,   /* U+4427 */
  0x3CCD,   /* U+4428 */
  0x3CCD,   /* U+4429 */
  0x3CCD,   /* U+442A */
  0x3CD7,   /* U+442B */
  0x3CD7,   /* U+442C */
  0x3CD7,   /* U+442D */
  0x3CD7,   /* U+442E */
  0x3CD7,   /* U+442F */
  0x3CD7,   /* U+4430 */
  0x3CD7,   /* U+4431 */
  0x3CD7,   /* U+4432 */
  0x3CD7,   /* U+4433 */
  0x3CD7,   /* U+4434 */
  0x3CD8,   /* U+4435 */
  0x3CD8,   /* U+4436 */
  0x3CD8,   /* U+4437 */
  0x3CD8,   /* U+4438 */
  0x3CD8,   /* U+4439 */
  0x3CD8,   /* U+443A */
  0x3CD8,   /* U+443B */
  0x3CD8,   /* U+443C */
  0x3CD8,   /* U+443D */
  0x3CD9,   /* U+443E */
  0x3CD9,   /* U+443F */
  0x3CD9,   /* U+4440 */
  0x3CD9,   /* U+4441 */
  0x3CDA,   /* U+4442 */
  0x3CDA,   /* U+4443 */
  0x3CDA,   /* U+4444 */
  0x3CDA,   /* U+4445 */
  0x3CDB,   /* U+4446 */
  0x3CDB,   /* U+4447 */
  0x3CDB,   /* U+4448 */
  0x3CDC,   /* U+4449 */
  0x3CDC,   /* U+444A */
  0x3CDD,   /* U+444B */
  0x3CDD,   /* U+444C */
  0x3CDD,   /* U+444D */
  0x3CDD,   /* U+444E */
  0x3CDE,   /* U+444F */
  0x3D11,   /* U+4450 */
  0x3D18,   /* U+4451 */
  0x5C49,   /* U+4452 */
  0x3D93,   /* U+4453 */
  0x3DD0,   /* U+4454 */
  0x3DD1,   /* U+4455 */
  0x3DD4,   /* U+4456 */
  0x3DD5,   /* U+4457 */
  0x3DCD,   /* U+4458 */
  0x3E10,   /* U+4459 */
  0x3E10,   /* U+445A */
  0x3E11,   /* U+445B */
  0x3E15,   /* U+445C */
  0x3E54,   /* U+445D */
  0x3E4D,   /* U+445E */
  0x3E5B,   /* U+445F */
  0x3E8E,   /* U+4460 */
  0x3E8F,   /* U+4461 */
  0x3E8F,   /* U+4462 */
  0x3E8F,   /* U+4463 */
  0x3E90,   /* U+4464 */
  0x3E90,   /* U+4465 */
  0x3E91,   /* U+4466 */
  0x3E91,   /* U+4467 */
  0x3E91,   /* U+4468 */
  0x3E91,   /* U+4469 */
  0x3E92,   /* U+446A */
  0x3E92,   /* U+446B */
  0x3E92,   /* U+446C */
  0x3E92,   /* U+446D */
  0x3E92,   /* U+446E */
  0x3E93,   /* U+446F */
  0x3E93,   /* U+4470 */
  0x3E94,   /* U+4471 */
  0x3E94,   /* U+4472 */
  0x3E94,   /* U+4473 */
  0x3E94,   /* U+4474 */
  0x3E94,   /* U+4475 */
  0x3E94,   /* U+4476 */
  0x3E94,   /* U+4477 */
  0x3E94,   /* U+4478 */
  0x3E95,   /* U+4479 */
  0x3E95,   /* U+447A */
  0x3E95,   /* U+447B */
  0x3E8D,   /* U+447C */
  0x3E8D,   /* U+447D */
  0x3E8D,   /* U+447E */
  0x3E97,   /* U+447F */
  0x3E97,   /* U+4480 */
  0x3E97,   /* U+4481 */
  0x3E97,   /* U+4482 */
  0x3E97,   /* U+4483 */
  0x3E97,   /* U+4484 */
  0x3E97,   /* U+4485 */
  0x3E98,   /* U+4486 */
  0x3E98,   /* U+4487 */
  0x3E98,   /* U+4488 */
  0x3E9A,   /* U+4489 */
  0x3F0F,   /* U+448A */
  0x3F11,   /* U+448B */
  0x3F0D,   /* U+448C */
  0x3F0D,   /* U+448D */
  0x3F18,   /* U+448E */
  0x3F18,   /* U+448F */
  0x3F1C,   /* U+4490 */
  0x5C49,   /* U+4491 */
  0x3F4E,   /* U+4492 */
  0x3F4E,   /* U+4493 */
  0x3F4E,   /* U+4494 */
  0x3F4F,   /* U+4495 */
  0x3F4F,   /* U+4496 */
  0x3F4F,   /* U+4497 */
  0x3F4F,   /* U+4498 */
  0x3F4F,   /* U+4499 */
  0x3F50,   /* U+449A */
  0x3F50,   /* U+449B */
  0x3F50,   /* U+449C */
  0x3F50,   /* U+449D */
  0x3F50,   /* U+449E */
  0x3F50,   /* U+449F */
  0x3F50,   /* U+44A0 */
  0x3F50,   /* U+44A1 */
  0x3F50,   /* U+44A2 */
  0x3F50,   /* U+44A3 */
  0x3F50,   /* U+44A4 */
  0x3F50,   /* U+44A5 */
  0x3F51,   /* U+44A6 */
  0x3F51,   /* U+44A7 */
  0x3F51,   /* U+44A8 */
  0x3F51,   /* U+44A9 */
  0x3F51,   /* U+44AA */
  0x3F51,   /* U+44AB */
  0x3F51,   /* U+44AC */
  0x3F51,   /* U+44AD */
  0x3F51,   /* U+44AE */
  0x3F51,   /* U+44AF */
  0x3F52,   /* U+44B0 */
  0x3F52,   /* U+44B1 */
  0x3F52,   /* U+44B2 */
  0x3F52,   /* U+44B3 */
  0x3F52,   /* U+44B4 */
  0x3F52,   /* U+44B5 */
  0x3F52,   /* U+44B6 */
  0x3F52,   /* U+44B7 */
  0x3F52,   /* U+44B8 */
  0x3F52,   /* U+44B9 */
  0x3F52,   /* U+44BA */
  0x3F52,   /* U+44BB */
  0x3F52,   /* U+44BC */
  0x3F52,   /* U+44BD */
  0x3F52,   /* U+44BE */
  0x3F52,   /* U+44BF */
  0x5C49,   /* U+44C0 */
  0x5C49,   /* U+44C1 */
  0x3F53,   /* U+44C2 */
  0x3F53,   /* U+44C3 */
  0x3F53,   /* U+44C4 */
  0x3F53,   /* U+44C5 */
  0x3F53,   /* U+44C6 */
  0x3F53,   /* U+44C7 */
  0x3F53,   /* U+44C8 */
  0x3F53,   /* U+44C9 */
  0x3F53,   /* U+44CA */
  0x3F53,   /* U+44CB */
  0x3F53,   /* U+44CC */
  0x3F53,   /* U+44CD */
  0x3F53,   /* U+44CE */
  0x3F53,   /* U+44CF */
  0x3F53,   /* U+44D0 */
  0x3F53,   /* U+44D1 */
  0x3F53,   /* U+44D2 */
  0x5C49,   /* U+44D3 */
  0x3F53,   /* U+44D4 */
  0x3F54,   /* U+44D5 */
  0x3F53,   /* U+44D6 */
  0x3F54,   /* U+44D7 */
  0x3F54,   /* U+44D8 */
  0x3F54,   /* U+44D9 */
  0x3F54,   /* U+44DA */
  0x3F54,   /* U+44DB */
  0x3F54,   /* U+44DC */
  0x3F54,   /* U+44DD */
  0x3F54,   /* U+44DE */
  0x3F54,   /* U+44DF */
  0x3F54,   /* U+44E0 */
  0x3F54,   /* U+44E1 */
  0x3F54,   /* U+44E2 */
  0x3F54,   /* U+44E3 */
  0x3F54,   /* U+44E4 */
  0x3F54,   /* U+44E5 */
  0x3F54,   /* U+44E6 */
  0x3F54,   /* U+44E7 */
  0x3F54,   /* U+44E8 */
  0x3F54,   /* U+44E9 */
  0x3F54,   /* U+44EA */
  0x3F54,   /* U+44EB */
  0x3F54,   /* U+44EC */
  0x3F54,   /* U+44ED */
  0x3F55,   /* U+44EE */
  0x3F55,   /* U+44EF */
  0x3F55,   /* U+44F0 */
  0x3F55,   /* U+44F1 */
  0x3F55,   /* U+44F2 */
  0x3F55,   /* U+44F3 */
  0x3F55,   /* U+44F4 */
  0x3F55,   /* U+44F5 */
  0x3F55,   /* U+44F6 */
  0x3F55,   /* U+44F7 */
  0x3F55,   /* U+44F8 */
  0x3F55,   /* U+44F9 */
  0x3F55,   /* U+44FA */
  0x3F55,   /* U+44FB */
  0x3F4D,   /* U+44FC */
  0x3F4D,   /* U+44FD */
  0x3F4D,   /* U+44FE */
  0x3F4D,   /* U+44FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4400 */
  0x0020,   /* U+4401 */
  0x0020,   /* U+4402 */
  0x0020,   /* U+4403 */
  0x0020,   /* U+4404 */
  0x0020,   /* U+4405 */
  0x0020,   /* U+4406 */
  0x0020,   /* U+4407 */
  0x0020,   /* U+4408 */
  0x0020,   /* U+4409 */
  0x0020,   /* U+440A */
  0x0020,   /* U+440B */
  0x0020,   /* U+440C */
  0x0020,   /* U+440D */
  0x0020,   /* U+440E */
  0x0020,   /* U+440F */
  0x0020,   /* U+4410 */
  0x0020,   /* U+4411 */
  0x0020,   /* U+4412 */
  0x0020,   /* U+4413 */
  0x0020,   /* U+4414 */
  0x0020,   /* U+4415 */
  0x0020,   /* U+4416 */
  0x0020,   /* U+4417 */
  0x0020,   /* U+4418 */
  0x0020,   /* U+4419 */
  0x0020,   /* U+441A */
  0x0020,   /* U+441B */
  0x0020,   /* U+441C */
  0x0020,   /* U+441D */
  0x0020,   /* U+441E */
  0x0020,   /* U+441F */
  0x0020,   /* U+4420 */
  0x0020,   /* U+4421 */
  0x0020,   /* U+4422 */
  0x0020,   /* U+4423 */
  0x0020,   /* U+4424 */
  0x0020,   /* U+4425 */
  0x0020,   /* U+4426 */
  0x0020,   /* U+4427 */
  0x0020,   /* U+4428 */
  0x0020,   /* U+4429 */
  0x0020,   /* U+442A */
  0x0020,   /* U+442B */
  0x0020,   /* U+442C */
  0x0020,   /* U+442D */
  0x0020,   /* U+442E */
  0x0020,   /* U+442F */
  0x0020,   /* U+4430 */
  0x0020,   /* U+4431 */
  0x0020,   /* U+4432 */
  0x0020,   /* U+4433 */
  0x0020,   /* U+4434 */
  0x0020,   /* U+4435 */
  0x0020,   /* U+4436 */
  0x0020,   /* U+4437 */
  0x0020,   /* U+4438 */
  0x0020,   /* U+4439 */
  0x0020,   /* U+443A */
  0x0020,   /* U+443B */
  0x0020,   /* U+443C */
  0x0020,   /* U+443D */
  0x0020,   /* U+443E */
  0x0020,   /* U+443F */
  0x0020,   /* U+4440 */
  0x0020,   /* U+4441 */
  0x0020,   /* U+4442 */
  0x0020,   /* U+4443 */
  0x0020,   /* U+4444 */
  0x0020,   /* U+4445 */
  0x0020,   /* U+4446 */
  0x0020,   /* U+4447 */
  0x0020,   /* U+4448 */
  0x0020,   /* U+4449 */
  0x0020,   /* U+444A */
  0x0020,   /* U+444B */
  0x0020,   /* U+444C */
  0x0020,   /* U+444D */
  0x0020,   /* U+444E */
  0x0020,   /* U+444F */
  0x0020,   /* U+4450 */
  0x0020,   /* U+4451 */
  0x0020,   /* U+4452 */
  0x0020,   /* U+4453 */
  0x0020,   /* U+4454 */
  0x0020,   /* U+4455 */
  0x0020,   /* U+4456 */
  0x0020,   /* U+4457 */
  0x0020,   /* U+4458 */
  0x0020,   /* U+4459 */
  0x0020,   /* U+445A */
  0x0020,   /* U+445B */
  0x0020,   /* U+445C */
  0x0020,   /* U+445D */
  0x0020,   /* U+445E */
  0x0020,   /* U+445F */
  0x0020,   /* U+4460 */
  0x0020,   /* U+4461 */
  0x0020,   /* U+4462 */
  0x0020,   /* U+4463 */
  0x0020,   /* U+4464 */
  0x0020,   /* U+4465 */
  0x0020,   /* U+4466 */
  0x0020,   /* U+4467 */
  0x0020,   /* U+4468 */
  0x0020,   /* U+4469 */
  0x0020,   /* U+446A */
  0x0020,   /* U+446B */
  0x0020,   /* U+446C */
  0x0020,   /* U+446D */
  0x0020,   /* U+446E */
  0x0020,   /* U+446F */
  0x0020,   /* U+4470 */
  0x0020,   /* U+4471 */
  0x0020,   /* U+4472 */
  0x0020,   /* U+4473 */
  0x0020,   /* U+4474 */
  0x0020,   /* U+4475 */
  0x0020,   /* U+4476 */
  0x0020,   /* U+4477 */
  0x0020,   /* U+4478 */
  0x0020,   /* U+4479 */
  0x0020,   /* U+447A */
  0x0020,   /* U+447B */
  0x0020,   /* U+447C */
  0x0020,   /* U+447D */
  0x0020,   /* U+447E */
  0x0020,   /* U+447F */
  0x0020,   /* U+4480 */
  0x0020,   /* U+4481 */
  0x0020,   /* U+4482 */
  0x0020,   /* U+4483 */
  0x0020,   /* U+4484 */
  0x0020,   /* U+4485 */
  0x0020,   /* U+4486 */
  0x0020,   /* U+4487 */
  0x0020,   /* U+4488 */
  0x0020,   /* U+4489 */
  0x0020,   /* U+448A */
  0x0020,   /* U+448B */
  0x0020,   /* U+448C */
  0x0020,   /* U+448D */
  0x0020,   /* U+448E */
  0x0020,   /* U+448F */
  0x0020,   /* U+4490 */
  0x0020,   /* U+4491 */
  0x0020,   /* U+4492 */
  0x0020,   /* U+4493 */
  0x0020,   /* U+4494 */
  0x0020,   /* U+4495 */
  0x0020,   /* U+4496 */
  0x0020,   /* U+4497 */
  0x0020,   /* U+4498 */
  0x0020,   /* U+4499 */
  0x0020,   /* U+449A */
  0x0020,   /* U+449B */
  0x0020,   /* U+449C */
  0x0020,   /* U+449D */
  0x0020,   /* U+449E */
  0x0020,   /* U+449F */
  0x0020,   /* U+44A0 */
  0x0020,   /* U+44A1 */
  0x0020,   /* U+44A2 */
  0x0020,   /* U+44A3 */
  0x0020,   /* U+44A4 */
  0x0020,   /* U+44A5 */
  0x0020,   /* U+44A6 */
  0x0020,   /* U+44A7 */
  0x0020,   /* U+44A8 */
  0x0020,   /* U+44A9 */
  0x0020,   /* U+44AA */
  0x0020,   /* U+44AB */
  0x0020,   /* U+44AC */
  0x0020,   /* U+44AD */
  0x0020,   /* U+44AE */
  0x0020,   /* U+44AF */
  0x0020,   /* U+44B0 */
  0x0020,   /* U+44B1 */
  0x0020,   /* U+44B2 */
  0x0020,   /* U+44B3 */
  0x0020,   /* U+44B4 */
  0x0020,   /* U+44B5 */
  0x0020,   /* U+44B6 */
  0x0020,   /* U+44B7 */
  0x0020,   /* U+44B8 */
  0x0020,   /* U+44B9 */
  0x0020,   /* U+44BA */
  0x0020,   /* U+44BB */
  0x0020,   /* U+44BC */
  0x0020,   /* U+44BD */
  0x0020,   /* U+44BE */
  0x0020,   /* U+44BF */
  0x0020,   /* U+44C0 */
  0x0020,   /* U+44C1 */
  0x0020,   /* U+44C2 */
  0x0020,   /* U+44C3 */
  0x0020,   /* U+44C4 */
  0x0020,   /* U+44C5 */
  0x0020,   /* U+44C6 */
  0x0020,   /* U+44C7 */
  0x0020,   /* U+44C8 */
  0x0020,   /* U+44C9 */
  0x0020,   /* U+44CA */
  0x0020,   /* U+44CB */
  0x0020,   /* U+44CC */
  0x0020,   /* U+44CD */
  0x0020,   /* U+44CE */
  0x0020,   /* U+44CF */
  0x0020,   /* U+44D0 */
  0x0020,   /* U+44D1 */
  0x0020,   /* U+44D2 */
  0x0020,   /* U+44D3 */
  0x0020,   /* U+44D4 */
  0x0020,   /* U+44D5 */
  0x0020,   /* U+44D6 */
  0x0020,   /* U+44D7 */
  0x0020,   /* U+44D8 */
  0x0020,   /* U+44D9 */
  0x0020,   /* U+44DA */
  0x0020,   /* U+44DB */
  0x0020,   /* U+44DC */
  0x0020,   /* U+44DD */
  0x0020,   /* U+44DE */
  0x0020,   /* U+44DF */
  0x0020,   /* U+44E0 */
  0x0020,   /* U+44E1 */
  0x0020,   /* U+44E2 */
  0x0020,   /* U+44E3 */
  0x0020,   /* U+44E4 */
  0x0020,   /* U+44E5 */
  0x0020,   /* U+44E6 */
  0x0020,   /* U+44E7 */
  0x0020,   /* U+44E8 */
  0x0020,   /* U+44E9 */
  0x0020,   /* U+44EA */
  0x0020,   /* U+44EB */
  0x0020,   /* U+44EC */
  0x0020,   /* U+44ED */
  0x0020,   /* U+44EE */
  0x0020,   /* U+44EF */
  0x0020,   /* U+44F0 */
  0x0020,   /* U+44F1 */
  0x0020,   /* U+44F2 */
  0x0020,   /* U+44F3 */
  0x0020,   /* U+44F4 */
  0x0020,   /* U+44F5 */
  0x0020,   /* U+44F6 */
  0x0020,   /* U+44F7 */
  0x0020,   /* U+44F8 */
  0x0020,   /* U+44F9 */
  0x0020,   /* U+44FA */
  0x0020,   /* U+44FB */
  0x0020,   /* U+44FC */
  0x0020,   /* U+44FD */
  0x0020,   /* U+44FE */
  0x0020,   /* U+44FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4400 */
  0x0002,   /* U+4401 */
  0x0002,   /* U+4402 */
  0x0002,   /* U+4403 */
  0x0002,   /* U+4404 */
  0x0002,   /* U+4405 */
  0x0002,   /* U+4406 */
  0x0002,   /* U+4407 */
  0x0002,   /* U+4408 */
  0x0002,   /* U+4409 */
  0x0002,   /* U+440A */
  0x0002,   /* U+440B */
  0x0002,   /* U+440C */
  0x0002,   /* U+440D */
  0x0002,   /* U+440E */
  0x0002,   /* U+440F */
  0x0002,   /* U+4410 */
  0x0002,   /* U+4411 */
  0x0002,   /* U+4412 */
  0x0002,   /* U+4413 */
  0x0002,   /* U+4414 */
  0x0002,   /* U+4415 */
  0x0002,   /* U+4416 */
  0x0002,   /* U+4417 */
  0x0002,   /* U+4418 */
  0x0002,   /* U+4419 */
  0x0002,   /* U+441A */
  0x0002,   /* U+441B */
  0x0002,   /* U+441C */
  0x0002,   /* U+441D */
  0x0002,   /* U+441E */
  0x0002,   /* U+441F */
  0x0002,   /* U+4420 */
  0x0002,   /* U+4421 */
  0x0002,   /* U+4422 */
  0x0002,   /* U+4423 */
  0x0002,   /* U+4424 */
  0x0002,   /* U+4425 */
  0x0002,   /* U+4426 */
  0x0002,   /* U+4427 */
  0x0002,   /* U+4428 */
  0x0002,   /* U+4429 */
  0x0002,   /* U+442A */
  0x0002,   /* U+442B */
  0x0002,   /* U+442C */
  0x0002,   /* U+442D */
  0x0002,   /* U+442E */
  0x0002,   /* U+442F */
  0x0002,   /* U+4430 */
  0x0002,   /* U+4431 */
  0x0002,   /* U+4432 */
  0x0002,   /* U+4433 */
  0x0002,   /* U+4434 */
  0x0002,   /* U+4435 */
  0x0002,   /* U+4436 */
  0x0002,   /* U+4437 */
  0x0002,   /* U+4438 */
  0x0002,   /* U+4439 */
  0x0002,   /* U+443A */
  0x0002,   /* U+443B */
  0x0002,   /* U+443C */
  0x0002,   /* U+443D */
  0x0002,   /* U+443E */
  0x0002,   /* U+443F */
  0x0002,   /* U+4440 */
  0x0002,   /* U+4441 */
  0x0002,   /* U+4442 */
  0x0002,   /* U+4443 */
  0x0002,   /* U+4444 */
  0x0002,   /* U+4445 */
  0x0002,   /* U+4446 */
  0x0002,   /* U+4447 */
  0x0002,   /* U+4448 */
  0x0002,   /* U+4449 */
  0x0002,   /* U+444A */
  0x0002,   /* U+444B */
  0x0002,   /* U+444C */
  0x0002,   /* U+444D */
  0x0002,   /* U+444E */
  0x0002,   /* U+444F */
  0x0002,   /* U+4450 */
  0x0002,   /* U+4451 */
  0x0002,   /* U+4452 */
  0x0002,   /* U+4453 */
  0x0002,   /* U+4454 */
  0x0002,   /* U+4455 */
  0x0002,   /* U+4456 */
  0x0002,   /* U+4457 */
  0x0002,   /* U+4458 */
  0x0002,   /* U+4459 */
  0x0002,   /* U+445A */
  0x0002,   /* U+445B */
  0x0002,   /* U+445C */
  0x0002,   /* U+445D */
  0x0002,   /* U+445E */
  0x0002,   /* U+445F */
  0x0002,   /* U+4460 */
  0x0002,   /* U+4461 */
  0x0002,   /* U+4462 */
  0x0002,   /* U+4463 */
  0x0002,   /* U+4464 */
  0x0002,   /* U+4465 */
  0x0002,   /* U+4466 */
  0x0002,   /* U+4467 */
  0x0002,   /* U+4468 */
  0x0002,   /* U+4469 */
  0x0002,   /* U+446A */
  0x0002,   /* U+446B */
  0x0002,   /* U+446C */
  0x0002,   /* U+446D */
  0x0002,   /* U+446E */
  0x0002,   /* U+446F */
  0x0002,   /* U+4470 */
  0x0002,   /* U+4471 */
  0x0002,   /* U+4472 */
  0x0002,   /* U+4473 */
  0x0002,   /* U+4474 */
  0x0002,   /* U+4475 */
  0x0002,   /* U+4476 */
  0x0002,   /* U+4477 */
  0x0002,   /* U+4478 */
  0x0002,   /* U+4479 */
  0x0002,   /* U+447A */
  0x0002,   /* U+447B */
  0x0002,   /* U+447C */
  0x0002,   /* U+447D */
  0x0002,   /* U+447E */
  0x0002,   /* U+447F */
  0x0002,   /* U+4480 */
  0x0002,   /* U+4481 */
  0x0002,   /* U+4482 */
  0x0002,   /* U+4483 */
  0x0002,   /* U+4484 */
  0x0002,   /* U+4485 */
  0x0002,   /* U+4486 */
  0x0002,   /* U+4487 */
  0x0002,   /* U+4488 */
  0x0002,   /* U+4489 */
  0x0002,   /* U+448A */
  0x0002,   /* U+448B */
  0x0002,   /* U+448C */
  0x0002,   /* U+448D */
  0x0002,   /* U+448E */
  0x0002,   /* U+448F */
  0x0002,   /* U+4490 */
  0x0002,   /* U+4491 */
  0x0002,   /* U+4492 */
  0x0002,   /* U+4493 */
  0x0002,   /* U+4494 */
  0x0002,   /* U+4495 */
  0x0002,   /* U+4496 */
  0x0002,   /* U+4497 */
  0x0002,   /* U+4498 */
  0x0002,   /* U+4499 */
  0x0002,   /* U+449A */
  0x0002,   /* U+449B */
  0x0002,   /* U+449C */
  0x0002,   /* U+449D */
  0x0002,   /* U+449E */
  0x0002,   /* U+449F */
  0x0002,   /* U+44A0 */
  0x0002,   /* U+44A1 */
  0x0002,   /* U+44A2 */
  0x0002,   /* U+44A3 */
  0x0002,   /* U+44A4 */
  0x0002,   /* U+44A5 */
  0x0002,   /* U+44A6 */
  0x0002,   /* U+44A7 */
  0x0002,   /* U+44A8 */
  0x0002,   /* U+44A9 */
  0x0002,   /* U+44AA */
  0x0002,   /* U+44AB */
  0x0002,   /* U+44AC */
  0x0002,   /* U+44AD */
  0x0002,   /* U+44AE */
  0x0002,   /* U+44AF */
  0x0002,   /* U+44B0 */
  0x0002,   /* U+44B1 */
  0x0002,   /* U+44B2 */
  0x0002,   /* U+44B3 */
  0x0002,   /* U+44B4 */
  0x0002,   /* U+44B5 */
  0x0002,   /* U+44B6 */
  0x0002,   /* U+44B7 */
  0x0002,   /* U+44B8 */
  0x0002,   /* U+44B9 */
  0x0002,   /* U+44BA */
  0x0002,   /* U+44BB */
  0x0002,   /* U+44BC */
  0x0002,   /* U+44BD */
  0x0002,   /* U+44BE */
  0x0002,   /* U+44BF */
  0x0002,   /* U+44C0 */
  0x0002,   /* U+44C1 */
  0x0002,   /* U+44C2 */
  0x0002,   /* U+44C3 */
  0x0002,   /* U+44C4 */
  0x0002,   /* U+44C5 */
  0x0002,   /* U+44C6 */
  0x0002,   /* U+44C7 */
  0x0002,   /* U+44C8 */
  0x0002,   /* U+44C9 */
  0x0002,   /* U+44CA */
  0x0002,   /* U+44CB */
  0x0002,   /* U+44CC */
  0x0002,   /* U+44CD */
  0x0002,   /* U+44CE */
  0x0002,   /* U+44CF */
  0x0002,   /* U+44D0 */
  0x0002,   /* U+44D1 */
  0x0002,   /* U+44D2 */
  0x0002,   /* U+44D3 */
  0x0002,   /* U+44D4 */
  0x0002,   /* U+44D5 */
  0x0002,   /* U+44D6 */
  0x0002,   /* U+44D7 */
  0x0002,   /* U+44D8 */
  0x0002,   /* U+44D9 */
  0x0002,   /* U+44DA */
  0x0002,   /* U+44DB */
  0x0002,   /* U+44DC */
  0x0002,   /* U+44DD */
  0x0002,   /* U+44DE */
  0x0002,   /* U+44DF */
  0x0002,   /* U+44E0 */
  0x0002,   /* U+44E1 */
  0x0002,   /* U+44E2 */
  0x0002,   /* U+44E3 */
  0x0002,   /* U+44E4 */
  0x0002,   /* U+44E5 */
  0x0002,   /* U+44E6 */
  0x0002,   /* U+44E7 */
  0x0002,   /* U+44E8 */
  0x0002,   /* U+44E9 */
  0x0002,   /* U+44EA */
  0x0002,   /* U+44EB */
  0x0002,   /* U+44EC */
  0x0002,   /* U+44ED */
  0x0002,   /* U+44EE */
  0x0002,   /* U+44EF */
  0x0002,   /* U+44F0 */
  0x0002,   /* U+44F1 */
  0x0002,   /* U+44F2 */
  0x0002,   /* U+44F3 */
  0x0002,   /* U+44F4 */
  0x0002,   /* U+44F5 */
  0x0002,   /* U+44F6 */
  0x0002,   /* U+44F7 */
  0x0002,   /* U+44F8 */
  0x0002,   /* U+44F9 */
  0x0002,   /* U+44FA */
  0x0002,   /* U+44FB */
  0x0002,   /* U+44FC */
  0x0002,   /* U+44FD */
  0x0002,   /* U+44FE */
  0x0002,   /* U+44FF */

  /* Primary weight 2 for each character. */
  0x8005,   /* U+4400 */
  0x8006,   /* U+4401 */
  0x8007,   /* U+4402 */
  0x8008,   /* U+4403 */
  0x8009,   /* U+4404 */
  0x800A,   /* U+4405 */
  0x800B,   /* U+4406 */
  0x800C,   /* U+4407 */
  0x800D,   /* U+4408 */
  0x800E,   /* U+4409 */
  0x800F,   /* U+440A */
  0x8010,   /* U+440B */
  0x8011,   /* U+440C */
  0x8000,   /* U+440D */
  0x8001,   /* U+440E */
  0x8002,   /* U+440F */
  0x8003,   /* U+4410 */
  0x8004,   /* U+4411 */
  0x8005,   /* U+4412 */
  0x8006,   /* U+4413 */
  0x8007,   /* U+4414 */
  0x8008,   /* U+4415 */
  0x8009,   /* U+4416 */
  0x800A,   /* U+4417 */
  0x800B,   /* U+4418 */
  0x800C,   /* U+4419 */
  0x800D,   /* U+441A */
  0x800E,   /* U+441B */
  0x8000,   /* U+441C */
  0x8001,   /* U+441D */
  0x8002,   /* U+441E */
  0x8003,   /* U+441F */
  0x8004,   /* U+4420 */
  0x8005,   /* U+4421 */
  0x8006,   /* U+4422 */
  0x8007,   /* U+4423 */
  0x8008,   /* U+4424 */
  0x8009,   /* U+4425 */
  0x800A,   /* U+4426 */
  0x800B,   /* U+4427 */
  0x800C,   /* U+4428 */
  0x800D,   /* U+4429 */
  0x800E,   /* U+442A */
  0x8000,   /* U+442B */
  0x8001,   /* U+442C */
  0x8002,   /* U+442D */
  0x8003,   /* U+442E */
  0x8004,   /* U+442F */
  0x8005,   /* U+4430 */
  0x8006,   /* U+4431 */
  0x8007,   /* U+4432 */
  0x8008,   /* U+4433 */
  0x8009,   /* U+4434 */
  0x8000,   /* U+4435 */
  0x8001,   /* U+4436 */
  0x8002,   /* U+4437 */
  0x8003,   /* U+4438 */
  0x8004,   /* U+4439 */
  0x8005,   /* U+443A */
  0x8006,   /* U+443B */
  0x8007,   /* U+443C */
  0x8008,   /* U+443D */
  0x8000,   /* U+443E */
  0x8001,   /* U+443F */
  0x8002,   /* U+4440 */
  0x8003,   /* U+4441 */
  0x8000,   /* U+4442 */
  0x8001,   /* U+4443 */
  0x8002,   /* U+4444 */
  0x8003,   /* U+4445 */
  0x8000,   /* U+4446 */
  0x8001,   /* U+4447 */
  0x8002,   /* U+4448 */
  0x8000,   /* U+4449 */
  0x8001,   /* U+444A */
  0x8001,   /* U+444B */
  0x8002,   /* U+444C */
  0x8003,   /* U+444D */
  0x8004,   /* U+444E */
  0x8000,   /* U+444F */
  0x8000,   /* U+4450 */
  0x8000,   /* U+4451 */
  0xC452,   /* U+4452 */
  0x8000,   /* U+4453 */
  0x8000,   /* U+4454 */
  0x8000,   /* U+4455 */
  0x8000,   /* U+4456 */
  0x8000,   /* U+4457 */
  0x8000,   /* U+4458 */
  0x8000,   /* U+4459 */
  0x8001,   /* U+445A */
  0x8000,   /* U+445B */
  0x8000,   /* U+445C */
  0x8000,   /* U+445D */
  0x8000,   /* U+445E */
  0x8000,   /* U+445F */
  0x8000,   /* U+4460 */
  0x8000,   /* U+4461 */
  0x8001,   /* U+4462 */
  0x8002,   /* U+4463 */
  0x8000,   /* U+4464 */
  0x8001,   /* U+4465 */
  0x8000,   /* U+4466 */
  0x8001,   /* U+4467 */
  0x8002,   /* U+4468 */
  0x8003,   /* U+4469 */
  0x8000,   /* U+446A */
  0x8001,   /* U+446B */
  0x8002,   /* U+446C */
  0x8003,   /* U+446D */
  0x8004,   /* U+446E */
  0x8000,   /* U+446F */
  0x8001,   /* U+4470 */
  0x8000,   /* U+4471 */
  0x8001,   /* U+4472 */
  0x8002,   /* U+4473 */
  0x8003,   /* U+4474 */
  0x8004,   /* U+4475 */
  0x8005,   /* U+4476 */
  0x8006,   /* U+4477 */
  0x8007,   /* U+4478 */
  0x8000,   /* U+4479 */
  0x8001,   /* U+447A */
  0x8002,   /* U+447B */
  0x8000,   /* U+447C */
  0x8001,   /* U+447D */
  0x8002,   /* U+447E */
  0x8000,   /* U+447F */
  0x8001,   /* U+4480 */
  0x8002,   /* U+4481 */
  0x8003,   /* U+4482 */
  0x8004,   /* U+4483 */
  0x8005,   /* U+4484 */
  0x8006,   /* U+4485 */
  0x8000,   /* U+4486 */
  0x8001,   /* U+4487 */
  0x8002,   /* U+4488 */
  0x8000,   /* U+4489 */
  0x8000,   /* U+448A */
  0x8000,   /* U+448B */
  0x8000,   /* U+448C */
  0x8001,   /* U+448D */
  0x8000,   /* U+448E */
  0x8001,   /* U+448F */
  0x8000,   /* U+4490 */
  0xC491,   /* U+4491 */
  0x8000,   /* U+4492 */
  0x8001,   /* U+4493 */
  0x8002,   /* U+4494 */
  0x8000,   /* U+4495 */
  0x8001,   /* U+4496 */
  0x8002,   /* U+4497 */
  0x8003,   /* U+4498 */
  0x8004,   /* U+4499 */
  0x8000,   /* U+449A */
  0x8001,   /* U+449B */
  0x8002,   /* U+449C */
  0x8003,   /* U+449D */
  0x8004,   /* U+449E */
  0x8005,   /* U+449F */
  0x8006,   /* U+44A0 */
  0x8007,   /* U+44A1 */
  0x8008,   /* U+44A2 */
  0x8009,   /* U+44A3 */
  0x800A,   /* U+44A4 */
  0x800B,   /* U+44A5 */
  0x8000,   /* U+44A6 */
  0x8001,   /* U+44A7 */
  0x8002,   /* U+44A8 */
  0x8003,   /* U+44A9 */
  0x8004,   /* U+44AA */
  0x8005,   /* U+44AB */
  0x8006,   /* U+44AC */
  0x8007,   /* U+44AD */
  0x8008,   /* U+44AE */
  0x8009,   /* U+44AF */
  0x8000,   /* U+44B0 */
  0x8001,   /* U+44B1 */
  0x8002,   /* U+44B2 */
  0x8003,   /* U+44B3 */
  0x8004,   /* U+44B4 */
  0x8005,   /* U+44B5 */
  0x8006,   /* U+44B6 */
  0x8007,   /* U+44B7 */
  0x8008,   /* U+44B8 */
  0x8009,   /* U+44B9 */
  0x800A,   /* U+44BA */
  0x800B,   /* U+44BB */
  0x800C,   /* U+44BC */
  0x800D,   /* U+44BD */
  0x800E,   /* U+44BE */
  0x800F,   /* U+44BF */
  0xC4C0,   /* U+44C0 */
  0xC4C1,   /* U+44C1 */
  0x8000,   /* U+44C2 */
  0x8001,   /* U+44C3 */
  0x8002,   /* U+44C4 */
  0x8003,   /* U+44C5 */
  0x8004,   /* U+44C6 */
  0x8005,   /* U+44C7 */
  0x8006,   /* U+44C8 */
  0x8007,   /* U+44C9 */
  0x8008,   /* U+44CA */
  0x8009,   /* U+44CB */
  0x800A,   /* U+44CC */
  0x800B,   /* U+44CD */
  0x800C,   /* U+44CE */
  0x800D,   /* U+44CF */
  0x800E,   /* U+44D0 */
  0x800F,   /* U+44D1 */
  0x8010,   /* U+44D2 */
  0xC4D3,   /* U+44D3 */
  0x8011,   /* U+44D4 */
  0x8000,   /* U+44D5 */
  0x8012,   /* U+44D6 */
  0x8001,   /* U+44D7 */
  0x8002,   /* U+44D8 */
  0x8003,   /* U+44D9 */
  0x8004,   /* U+44DA */
  0x8005,   /* U+44DB */
  0x8006,   /* U+44DC */
  0x8007,   /* U+44DD */
  0x8008,   /* U+44DE */
  0x8009,   /* U+44DF */
  0x800A,   /* U+44E0 */
  0x800B,   /* U+44E1 */
  0x800C,   /* U+44E2 */
  0x800D,   /* U+44E3 */
  0x800E,   /* U+44E4 */
  0x800F,   /* U+44E5 */
  0x8010,   /* U+44E6 */
  0x8011,   /* U+44E7 */
  0x8012,   /* U+44E8 */
  0x8013,   /* U+44E9 */
  0x8014,   /* U+44EA */
  0x8015,   /* U+44EB */
  0x8016,   /* U+44EC */
  0x8017,   /* U+44ED */
  0x8000,   /* U+44EE */
  0x8001,   /* U+44EF */
  0x8002,   /* U+44F0 */
  0x8003,   /* U+44F1 */
  0x8004,   /* U+44F2 */
  0x8005,   /* U+44F3 */
  0x8006,   /* U+44F4 */
  0x8007,   /* U+44F5 */
  0x8008,   /* U+44F6 */
  0x8009,   /* U+44F7 */
  0x800A,   /* U+44F8 */
  0x800B,   /* U+44F9 */
  0x800C,   /* U+44FA */
  0x800D,   /* U+44FB */
  0x8000,   /* U+44FC */
  0x8001,   /* U+44FD */
  0x8002,   /* U+44FE */
  0x8003,   /* U+44FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4400 */
  0x0000,   /* U+4401 */
  0x0000,   /* U+4402 */
  0x0000,   /* U+4403 */
  0x0000,   /* U+4404 */
  0x0000,   /* U+4405 */
  0x0000,   /* U+4406 */
  0x0000,   /* U+4407 */
  0x0000,   /* U+4408 */
  0x0000,   /* U+4409 */
  0x0000,   /* U+440A */
  0x0000,   /* U+440B */
  0x0000,   /* U+440C */
  0x0000,   /* U+440D */
  0x0000,   /* U+440E */
  0x0000,   /* U+440F */
  0x0000,   /* U+4410 */
  0x0000,   /* U+4411 */
  0x0000,   /* U+4412 */
  0x0000,   /* U+4413 */
  0x0000,   /* U+4414 */
  0x0000,   /* U+4415 */
  0x0000,   /* U+4416 */
  0x0000,   /* U+4417 */
  0x0000,   /* U+4418 */
  0x0000,   /* U+4419 */
  0x0000,   /* U+441A */
  0x0000,   /* U+441B */
  0x0000,   /* U+441C */
  0x0000,   /* U+441D */
  0x0000,   /* U+441E */
  0x0000,   /* U+441F */
  0x0000,   /* U+4420 */
  0x0000,   /* U+4421 */
  0x0000,   /* U+4422 */
  0x0000,   /* U+4423 */
  0x0000,   /* U+4424 */
  0x0000,   /* U+4425 */
  0x0000,   /* U+4426 */
  0x0000,   /* U+4427 */
  0x0000,   /* U+4428 */
  0x0000,   /* U+4429 */
  0x0000,   /* U+442A */
  0x0000,   /* U+442B */
  0x0000,   /* U+442C */
  0x0000,   /* U+442D */
  0x0000,   /* U+442E */
  0x0000,   /* U+442F */
  0x0000,   /* U+4430 */
  0x0000,   /* U+4431 */
  0x0000,   /* U+4432 */
  0x0000,   /* U+4433 */
  0x0000,   /* U+4434 */
  0x0000,   /* U+4435 */
  0x0000,   /* U+4436 */
  0x0000,   /* U+4437 */
  0x0000,   /* U+4438 */
  0x0000,   /* U+4439 */
  0x0000,   /* U+443A */
  0x0000,   /* U+443B */
  0x0000,   /* U+443C */
  0x0000,   /* U+443D */
  0x0000,   /* U+443E */
  0x0000,   /* U+443F */
  0x0000,   /* U+4440 */
  0x0000,   /* U+4441 */
  0x0000,   /* U+4442 */
  0x0000,   /* U+4443 */
  0x0000,   /* U+4444 */
  0x0000,   /* U+4445 */
  0x0000,   /* U+4446 */
  0x0000,   /* U+4447 */
  0x0000,   /* U+4448 */
  0x0000,   /* U+4449 */
  0x0000,   /* U+444A */
  0x0000,   /* U+444B */
  0x0000,   /* U+444C */
  0x0000,   /* U+444D */
  0x0000,   /* U+444E */
  0x0000,   /* U+444F */
  0x0000,   /* U+4450 */
  0x0000,   /* U+4451 */
  0x0000,   /* U+4452 */
  0x0000,   /* U+4453 */
  0x0000,   /* U+4454 */
  0x0000,   /* U+4455 */
  0x0000,   /* U+4456 */
  0x0000,   /* U+4457 */
  0x0000,   /* U+4458 */
  0x0000,   /* U+4459 */
  0x0000,   /* U+445A */
  0x0000,   /* U+445B */
  0x0000,   /* U+445C */
  0x0000,   /* U+445D */
  0x0000,   /* U+445E */
  0x0000,   /* U+445F */
  0x0000,   /* U+4460 */
  0x0000,   /* U+4461 */
  0x0000,   /* U+4462 */
  0x0000,   /* U+4463 */
  0x0000,   /* U+4464 */
  0x0000,   /* U+4465 */
  0x0000,   /* U+4466 */
  0x0000,   /* U+4467 */
  0x0000,   /* U+4468 */
  0x0000,   /* U+4469 */
  0x0000,   /* U+446A */
  0x0000,   /* U+446B */
  0x0000,   /* U+446C */
  0x0000,   /* U+446D */
  0x0000,   /* U+446E */
  0x0000,   /* U+446F */
  0x0000,   /* U+4470 */
  0x0000,   /* U+4471 */
  0x0000,   /* U+4472 */
  0x0000,   /* U+4473 */
  0x0000,   /* U+4474 */
  0x0000,   /* U+4475 */
  0x0000,   /* U+4476 */
  0x0000,   /* U+4477 */
  0x0000,   /* U+4478 */
  0x0000,   /* U+4479 */
  0x0000,   /* U+447A */
  0x0000,   /* U+447B */
  0x0000,   /* U+447C */
  0x0000,   /* U+447D */
  0x0000,   /* U+447E */
  0x0000,   /* U+447F */
  0x0000,   /* U+4480 */
  0x0000,   /* U+4481 */
  0x0000,   /* U+4482 */
  0x0000,   /* U+4483 */
  0x0000,   /* U+4484 */
  0x0000,   /* U+4485 */
  0x0000,   /* U+4486 */
  0x0000,   /* U+4487 */
  0x0000,   /* U+4488 */
  0x0000,   /* U+4489 */
  0x0000,   /* U+448A */
  0x0000,   /* U+448B */
  0x0000,   /* U+448C */
  0x0000,   /* U+448D */
  0x0000,   /* U+448E */
  0x0000,   /* U+448F */
  0x0000,   /* U+4490 */
  0x0000,   /* U+4491 */
  0x0000,   /* U+4492 */
  0x0000,   /* U+4493 */
  0x0000,   /* U+4494 */
  0x0000,   /* U+4495 */
  0x0000,   /* U+4496 */
  0x0000,   /* U+4497 */
  0x0000,   /* U+4498 */
  0x0000,   /* U+4499 */
  0x0000,   /* U+449A */
  0x0000,   /* U+449B */
  0x0000,   /* U+449C */
  0x0000,   /* U+449D */
  0x0000,   /* U+449E */
  0x0000,   /* U+449F */
  0x0000,   /* U+44A0 */
  0x0000,   /* U+44A1 */
  0x0000,   /* U+44A2 */
  0x0000,   /* U+44A3 */
  0x0000,   /* U+44A4 */
  0x0000,   /* U+44A5 */
  0x0000,   /* U+44A6 */
  0x0000,   /* U+44A7 */
  0x0000,   /* U+44A8 */
  0x0000,   /* U+44A9 */
  0x0000,   /* U+44AA */
  0x0000,   /* U+44AB */
  0x0000,   /* U+44AC */
  0x0000,   /* U+44AD */
  0x0000,   /* U+44AE */
  0x0000,   /* U+44AF */
  0x0000,   /* U+44B0 */
  0x0000,   /* U+44B1 */
  0x0000,   /* U+44B2 */
  0x0000,   /* U+44B3 */
  0x0000,   /* U+44B4 */
  0x0000,   /* U+44B5 */
  0x0000,   /* U+44B6 */
  0x0000,   /* U+44B7 */
  0x0000,   /* U+44B8 */
  0x0000,   /* U+44B9 */
  0x0000,   /* U+44BA */
  0x0000,   /* U+44BB */
  0x0000,   /* U+44BC */
  0x0000,   /* U+44BD */
  0x0000,   /* U+44BE */
  0x0000,   /* U+44BF */
  0x0000,   /* U+44C0 */
  0x0000,   /* U+44C1 */
  0x0000,   /* U+44C2 */
  0x0000,   /* U+44C3 */
  0x0000,   /* U+44C4 */
  0x0000,   /* U+44C5 */
  0x0000,   /* U+44C6 */
  0x0000,   /* U+44C7 */
  0x0000,   /* U+44C8 */
  0x0000,   /* U+44C9 */
  0x0000,   /* U+44CA */
  0x0000,   /* U+44CB */
  0x0000,   /* U+44CC */
  0x0000,   /* U+44CD */
  0x0000,   /* U+44CE */
  0x0000,   /* U+44CF */
  0x0000,   /* U+44D0 */
  0x0000,   /* U+44D1 */
  0x0000,   /* U+44D2 */
  0x0000,   /* U+44D3 */
  0x0000,   /* U+44D4 */
  0x0000,   /* U+44D5 */
  0x0000,   /* U+44D6 */
  0x0000,   /* U+44D7 */
  0x0000,   /* U+44D8 */
  0x0000,   /* U+44D9 */
  0x0000,   /* U+44DA */
  0x0000,   /* U+44DB */
  0x0000,   /* U+44DC */
  0x0000,   /* U+44DD */
  0x0000,   /* U+44DE */
  0x0000,   /* U+44DF */
  0x0000,   /* U+44E0 */
  0x0000,   /* U+44E1 */
  0x0000,   /* U+44E2 */
  0x0000,   /* U+44E3 */
  0x0000,   /* U+44E4 */
  0x0000,   /* U+44E5 */
  0x0000,   /* U+44E6 */
  0x0000,   /* U+44E7 */
  0x0000,   /* U+44E8 */
  0x0000,   /* U+44E9 */
  0x0000,   /* U+44EA */
  0x0000,   /* U+44EB */
  0x0000,   /* U+44EC */
  0x0000,   /* U+44ED */
  0x0000,   /* U+44EE */
  0x0000,   /* U+44EF */
  0x0000,   /* U+44F0 */
  0x0000,   /* U+44F1 */
  0x0000,   /* U+44F2 */
  0x0000,   /* U+44F3 */
  0x0000,   /* U+44F4 */
  0x0000,   /* U+44F5 */
  0x0000,   /* U+44F6 */
  0x0000,   /* U+44F7 */
  0x0000,   /* U+44F8 */
  0x0000,   /* U+44F9 */
  0x0000,   /* U+44FA */
  0x0000,   /* U+44FB */
  0x0000,   /* U+44FC */
  0x0000,   /* U+44FD */
  0x0000,   /* U+44FE */
  0x0000,   /* U+44FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4400 */
  0x0000,   /* U+4401 */
  0x0000,   /* U+4402 */
  0x0000,   /* U+4403 */
  0x0000,   /* U+4404 */
  0x0000,   /* U+4405 */
  0x0000,   /* U+4406 */
  0x0000,   /* U+4407 */
  0x0000,   /* U+4408 */
  0x0000,   /* U+4409 */
  0x0000,   /* U+440A */
  0x0000,   /* U+440B */
  0x0000,   /* U+440C */
  0x0000,   /* U+440D */
  0x0000,   /* U+440E */
  0x0000,   /* U+440F */
  0x0000,   /* U+4410 */
  0x0000,   /* U+4411 */
  0x0000,   /* U+4412 */
  0x0000,   /* U+4413 */
  0x0000,   /* U+4414 */
  0x0000,   /* U+4415 */
  0x0000,   /* U+4416 */
  0x0000,   /* U+4417 */
  0x0000,   /* U+4418 */
  0x0000,   /* U+4419 */
  0x0000,   /* U+441A */
  0x0000,   /* U+441B */
  0x0000,   /* U+441C */
  0x0000,   /* U+441D */
  0x0000,   /* U+441E */
  0x0000,   /* U+441F */
  0x0000,   /* U+4420 */
  0x0000,   /* U+4421 */
  0x0000,   /* U+4422 */
  0x0000,   /* U+4423 */
  0x0000,   /* U+4424 */
  0x0000,   /* U+4425 */
  0x0000,   /* U+4426 */
  0x0000,   /* U+4427 */
  0x0000,   /* U+4428 */
  0x0000,   /* U+4429 */
  0x0000,   /* U+442A */
  0x0000,   /* U+442B */
  0x0000,   /* U+442C */
  0x0000,   /* U+442D */
  0x0000,   /* U+442E */
  0x0000,   /* U+442F */
  0x0000,   /* U+4430 */
  0x0000,   /* U+4431 */
  0x0000,   /* U+4432 */
  0x0000,   /* U+4433 */
  0x0000,   /* U+4434 */
  0x0000,   /* U+4435 */
  0x0000,   /* U+4436 */
  0x0000,   /* U+4437 */
  0x0000,   /* U+4438 */
  0x0000,   /* U+4439 */
  0x0000,   /* U+443A */
  0x0000,   /* U+443B */
  0x0000,   /* U+443C */
  0x0000,   /* U+443D */
  0x0000,   /* U+443E */
  0x0000,   /* U+443F */
  0x0000,   /* U+4440 */
  0x0000,   /* U+4441 */
  0x0000,   /* U+4442 */
  0x0000,   /* U+4443 */
  0x0000,   /* U+4444 */
  0x0000,   /* U+4445 */
  0x0000,   /* U+4446 */
  0x0000,   /* U+4447 */
  0x0000,   /* U+4448 */
  0x0000,   /* U+4449 */
  0x0000,   /* U+444A */
  0x0000,   /* U+444B */
  0x0000,   /* U+444C */
  0x0000,   /* U+444D */
  0x0000,   /* U+444E */
  0x0000,   /* U+444F */
  0x0000,   /* U+4450 */
  0x0000,   /* U+4451 */
  0x0000,   /* U+4452 */
  0x0000,   /* U+4453 */
  0x0000,   /* U+4454 */
  0x0000,   /* U+4455 */
  0x0000,   /* U+4456 */
  0x0000,   /* U+4457 */
  0x0000,   /* U+4458 */
  0x0000,   /* U+4459 */
  0x0000,   /* U+445A */
  0x0000,   /* U+445B */
  0x0000,   /* U+445C */
  0x0000,   /* U+445D */
  0x0000,   /* U+445E */
  0x0000,   /* U+445F */
  0x0000,   /* U+4460 */
  0x0000,   /* U+4461 */
  0x0000,   /* U+4462 */
  0x0000,   /* U+4463 */
  0x0000,   /* U+4464 */
  0x0000,   /* U+4465 */
  0x0000,   /* U+4466 */
  0x0000,   /* U+4467 */
  0x0000,   /* U+4468 */
  0x0000,   /* U+4469 */
  0x0000,   /* U+446A */
  0x0000,   /* U+446B */
  0x0000,   /* U+446C */
  0x0000,   /* U+446D */
  0x0000,   /* U+446E */
  0x0000,   /* U+446F */
  0x0000,   /* U+4470 */
  0x0000,   /* U+4471 */
  0x0000,   /* U+4472 */
  0x0000,   /* U+4473 */
  0x0000,   /* U+4474 */
  0x0000,   /* U+4475 */
  0x0000,   /* U+4476 */
  0x0000,   /* U+4477 */
  0x0000,   /* U+4478 */
  0x0000,   /* U+4479 */
  0x0000,   /* U+447A */
  0x0000,   /* U+447B */
  0x0000,   /* U+447C */
  0x0000,   /* U+447D */
  0x0000,   /* U+447E */
  0x0000,   /* U+447F */
  0x0000,   /* U+4480 */
  0x0000,   /* U+4481 */
  0x0000,   /* U+4482 */
  0x0000,   /* U+4483 */
  0x0000,   /* U+4484 */
  0x0000,   /* U+4485 */
  0x0000,   /* U+4486 */
  0x0000,   /* U+4487 */
  0x0000,   /* U+4488 */
  0x0000,   /* U+4489 */
  0x0000,   /* U+448A */
  0x0000,   /* U+448B */
  0x0000,   /* U+448C */
  0x0000,   /* U+448D */
  0x0000,   /* U+448E */
  0x0000,   /* U+448F */
  0x0000,   /* U+4490 */
  0x0000,   /* U+4491 */
  0x0000,   /* U+4492 */
  0x0000,   /* U+4493 */
  0x0000,   /* U+4494 */
  0x0000,   /* U+4495 */
  0x0000,   /* U+4496 */
  0x0000,   /* U+4497 */
  0x0000,   /* U+4498 */
  0x0000,   /* U+4499 */
  0x0000,   /* U+449A */
  0x0000,   /* U+449B */
  0x0000,   /* U+449C */
  0x0000,   /* U+449D */
  0x0000,   /* U+449E */
  0x0000,   /* U+449F */
  0x0000,   /* U+44A0 */
  0x0000,   /* U+44A1 */
  0x0000,   /* U+44A2 */
  0x0000,   /* U+44A3 */
  0x0000,   /* U+44A4 */
  0x0000,   /* U+44A5 */
  0x0000,   /* U+44A6 */
  0x0000,   /* U+44A7 */
  0x0000,   /* U+44A8 */
  0x0000,   /* U+44A9 */
  0x0000,   /* U+44AA */
  0x0000,   /* U+44AB */
  0x0000,   /* U+44AC */
  0x0000,   /* U+44AD */
  0x0000,   /* U+44AE */
  0x0000,   /* U+44AF */
  0x0000,   /* U+44B0 */
  0x0000,   /* U+44B1 */
  0x0000,   /* U+44B2 */
  0x0000,   /* U+44B3 */
  0x0000,   /* U+44B4 */
  0x0000,   /* U+44B5 */
  0x0000,   /* U+44B6 */
  0x0000,   /* U+44B7 */
  0x0000,   /* U+44B8 */
  0x0000,   /* U+44B9 */
  0x0000,   /* U+44BA */
  0x0000,   /* U+44BB */
  0x0000,   /* U+44BC */
  0x0000,   /* U+44BD */
  0x0000,   /* U+44BE */
  0x0000,   /* U+44BF */
  0x0000,   /* U+44C0 */
  0x0000,   /* U+44C1 */
  0x0000,   /* U+44C2 */
  0x0000,   /* U+44C3 */
  0x0000,   /* U+44C4 */
  0x0000,   /* U+44C5 */
  0x0000,   /* U+44C6 */
  0x0000,   /* U+44C7 */
  0x0000,   /* U+44C8 */
  0x0000,   /* U+44C9 */
  0x0000,   /* U+44CA */
  0x0000,   /* U+44CB */
  0x0000,   /* U+44CC */
  0x0000,   /* U+44CD */
  0x0000,   /* U+44CE */
  0x0000,   /* U+44CF */
  0x0000,   /* U+44D0 */
  0x0000,   /* U+44D1 */
  0x0000,   /* U+44D2 */
  0x0000,   /* U+44D3 */
  0x0000,   /* U+44D4 */
  0x0000,   /* U+44D5 */
  0x0000,   /* U+44D6 */
  0x0000,   /* U+44D7 */
  0x0000,   /* U+44D8 */
  0x0000,   /* U+44D9 */
  0x0000,   /* U+44DA */
  0x0000,   /* U+44DB */
  0x0000,   /* U+44DC */
  0x0000,   /* U+44DD */
  0x0000,   /* U+44DE */
  0x0000,   /* U+44DF */
  0x0000,   /* U+44E0 */
  0x0000,   /* U+44E1 */
  0x0000,   /* U+44E2 */
  0x0000,   /* U+44E3 */
  0x0000,   /* U+44E4 */
  0x0000,   /* U+44E5 */
  0x0000,   /* U+44E6 */
  0x0000,   /* U+44E7 */
  0x0000,   /* U+44E8 */
  0x0000,   /* U+44E9 */
  0x0000,   /* U+44EA */
  0x0000,   /* U+44EB */
  0x0000,   /* U+44EC */
  0x0000,   /* U+44ED */
  0x0000,   /* U+44EE */
  0x0000,   /* U+44EF */
  0x0000,   /* U+44F0 */
  0x0000,   /* U+44F1 */
  0x0000,   /* U+44F2 */
  0x0000,   /* U+44F3 */
  0x0000,   /* U+44F4 */
  0x0000,   /* U+44F5 */
  0x0000,   /* U+44F6 */
  0x0000,   /* U+44F7 */
  0x0000,   /* U+44F8 */
  0x0000,   /* U+44F9 */
  0x0000,   /* U+44FA */
  0x0000,   /* U+44FB */
  0x0000,   /* U+44FC */
  0x0000,   /* U+44FD */
  0x0000,   /* U+44FE */
  0x0000,   /* U+44FF */
};

uint16 zh2_han_p045[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x3F4D,   /* U+4500 */
  0x3F4D,   /* U+4501 */
  0x3F4D,   /* U+4502 */
  0x3F4D,   /* U+4503 */
  0x3F4D,   /* U+4504 */
  0x3F4D,   /* U+4505 */
  0x3F4D,   /* U+4506 */
  0x3F4D,   /* U+4507 */
  0x3F4D,   /* U+4508 */
  0x3F4D,   /* U+4509 */
  0x3F4D,   /* U+450A */
  0x3F4D,   /* U+450B */
  0x3F4D,   /* U+450C */
  0x3F4D,   /* U+450D */
  0x3F57,   /* U+450E */
  0x3F57,   /* U+450F */
  0x3F57,   /* U+4510 */
  0x3F57,   /* U+4511 */
  0x3F57,   /* U+4512 */
  0x3F57,   /* U+4513 */
  0x3F57,   /* U+4514 */
  0x3F57,   /* U+4515 */
  0x3F57,   /* U+4516 */
  0x3F57,   /* U+4517 */
  0x3F57,   /* U+4518 */
  0x3F57,   /* U+4519 */
  0x3F57,   /* U+451A */
  0x3F57,   /* U+451B */
  0x3F57,   /* U+451C */
  0x3F57,   /* U+451D */
  0x3F57,   /* U+451E */
  0x3F57,   /* U+451F */
  0x3F57,   /* U+4520 */
  0x3F57,   /* U+4521 */
  0x3F57,   /* U+4522 */
  0x3F57,   /* U+4523 */
  0x3F57,   /* U+4524 */
  0x3F57,   /* U+4525 */
  0x3F57,   /* U+4526 */
  0x3F57,   /* U+4527 */
  0x3F57,   /* U+4528 */
  0x5C49,   /* U+4529 */
  0x3F57,   /* U+452A */
  0x5C49,   /* U+452B */
  0x3F57,   /* U+452C */
  0x3F58,   /* U+452D */
  0x3F58,   /* U+452E */
  0x3F58,   /* U+452F */
  0x3F58,   /* U+4530 */
  0x3F58,   /* U+4531 */
  0x3F58,   /* U+4532 */
  0x3F58,   /* U+4533 */
  0x3F58,   /* U+4534 */
  0x3F58,   /* U+4535 */
  0x3F58,   /* U+4536 */
  0x3F58,   /* U+4537 */
  0x3F58,   /* U+4538 */
  0x3F58,   /* U+4539 */
  0x3F58,   /* U+453A */
  0x3F58,   /* U+453B */
  0x3F58,   /* U+453C */
  0x3F58,   /* U+453D */
  0x3F58,   /* U+453E */
  0x3F58,   /* U+453F */
  0x3F58,   /* U+4540 */
  0x3F58,   /* U+4541 */
  0x3F58,   /* U+4542 */
  0x5C49,   /* U+4543 */
  0x3F58,   /* U+4544 */
  0x3F59,   /* U+4545 */
  0x3F59,   /* U+4546 */
  0x3F59,   /* U+4547 */
  0x3F59,   /* U+4548 */
  0x3F59,   /* U+4549 */
  0x3F59,   /* U+454A */
  0x3F59,   /* U+454B */
  0x3F59,   /* U+454C */
  0x3F59,   /* U+454D */
  0x3F59,   /* U+454E */
  0x3F59,   /* U+454F */
  0x3F59,   /* U+4550 */
  0x3F59,   /* U+4551 */
  0x3F5A,   /* U+4552 */
  0x3F5A,   /* U+4553 */
  0x3F5A,   /* U+4554 */
  0x3F5A,   /* U+4555 */
  0x3F5A,   /* U+4556 */
  0x3F5A,   /* U+4557 */
  0x3F5A,   /* U+4558 */
  0x3F5A,   /* U+4559 */
  0x3F5A,   /* U+455A */
  0x3F5A,   /* U+455B */
  0x3F5A,   /* U+455C */
  0x3F5A,   /* U+455D */
  0x3F5B,   /* U+455E */
  0x3F5B,   /* U+455F */
  0x3F5B,   /* U+4560 */
  0x3F5B,   /* U+4561 */
  0x3F5B,   /* U+4562 */
  0x3F5B,   /* U+4563 */
  0x3F5B,   /* U+4564 */
  0x3F5B,   /* U+4565 */
  0x3F5C,   /* U+4566 */
  0x3F5C,   /* U+4567 */
  0x3F5C,   /* U+4568 */
  0x3F5C,   /* U+4569 */
  0x3F5C,   /* U+456A */
  0x3F5C,   /* U+456B */
  0x3F5C,   /* U+456C */
  0x3F5C,   /* U+456D */
  0x3F5C,   /* U+456E */
  0x3F5C,   /* U+456F */
  0x3F5C,   /* U+4570 */
  0x3F5C,   /* U+4571 */
  0x3F5C,   /* U+4572 */
  0x3F5D,   /* U+4573 */
  0x3F5D,   /* U+4574 */
  0x3F5D,   /* U+4575 */
  0x5C49,   /* U+4576 */
  0x3F5D,   /* U+4577 */
  0x3F5E,   /* U+4578 */
  0x3F5E,   /* U+4579 */
  0x3F5E,   /* U+457A */
  0x3F5F,   /* U+457B */
  0x3F5F,   /* U+457C */
  0x3F5F,   /* U+457D */
  0x3F4E,   /* U+457E */
  0x3F61,   /* U+457F */
  0x3F61,   /* U+4580 */
  0x3F62,   /* U+4581 */
  0x3F63,   /* U+4582 */
  0x3F63,   /* U+4583 */
  0x3F63,   /* U+4584 */
  0x3F64,   /* U+4585 */
  0x3F64,   /* U+4586 */
  0x3F69,   /* U+4587 */
  0x3F8E,   /* U+4588 */
  0x3F8F,   /* U+4589 */
  0x3F90,   /* U+458A */
  0x3F90,   /* U+458B */
  0x3F90,   /* U+458C */
  0x5C49,   /* U+458D */
  0x3F91,   /* U+458E */
  0x3F91,   /* U+458F */
  0x3F92,   /* U+4590 */
  0x3F92,   /* U+4591 */
  0x3F93,   /* U+4592 */
  0x3F93,   /* U+4593 */
  0x3F93,   /* U+4594 */
  0x3F93,   /* U+4595 */
  0x3F93,   /* U+4596 */
  0x3F95,   /* U+4597 */
  0x3F8D,   /* U+4598 */
  0x3F97,   /* U+4599 */
  0x3F98,   /* U+459A */
  0x3F98,   /* U+459B */
  0x3F99,   /* U+459C */
  0x3FCD,   /* U+459D */
  0x3FCF,   /* U+459E */
  0x3FCF,   /* U+459F */
  0x3FCF,   /* U+45A0 */
  0x3FD0,   /* U+45A1 */
  0x3FD0,   /* U+45A2 */
  0x3FD0,   /* U+45A3 */
  0x3FD1,   /* U+45A4 */
  0x3FD1,   /* U+45A5 */
  0x3FD1,   /* U+45A6 */
  0x3FD1,   /* U+45A7 */
  0x3FD1,   /* U+45A8 */
  0x3FD1,   /* U+45A9 */
  0x3FD1,   /* U+45AA */
  0x3FD1,   /* U+45AB */
  0x3FD1,   /* U+45AC */
  0x3FD2,   /* U+45AD */
  0x3FD2,   /* U+45AE */
  0x3FD2,   /* U+45AF */
  0x3FD2,   /* U+45B0 */
  0x3FD2,   /* U+45B1 */
  0x3FD2,   /* U+45B2 */
  0x3FD2,   /* U+45B3 */
  0x3FD2,   /* U+45B4 */
  0x3FD2,   /* U+45B5 */
  0x3FD3,   /* U+45B6 */
  0x3FD3,   /* U+45B7 */
  0x3FD3,   /* U+45B8 */
  0x3FD3,   /* U+45B9 */
  0x3FD3,   /* U+45BA */
  0x3FD3,   /* U+45BB */
  0x3FD3,   /* U+45BC */
  0x3FD3,   /* U+45BD */
  0x3FD3,   /* U+45BE */
  0x3FD4,   /* U+45BF */
  0x3FD4,   /* U+45C0 */
  0x3FD4,   /* U+45C1 */
  0x3FD4,   /* U+45C2 */
  0x3FD4,   /* U+45C3 */
  0x3FD4,   /* U+45C4 */
  0x3FD4,   /* U+45C5 */
  0x3FD4,   /* U+45C6 */
  0x3FD4,   /* U+45C7 */
  0x3FD4,   /* U+45C8 */
  0x3FD4,   /* U+45C9 */
  0x3FD4,   /* U+45CA */
  0x3FD5,   /* U+45CB */
  0x3FD5,   /* U+45CC */
  0x3FD5,   /* U+45CD */
  0x3FD5,   /* U+45CE */
  0x3FD5,   /* U+45CF */
  0x3FD5,   /* U+45D0 */
  0x3FD5,   /* U+45D1 */
  0x3FD5,   /* U+45D2 */
  0x3FD5,   /* U+45D3 */
  0x3FD5,   /* U+45D4 */
  0x3FD4,   /* U+45D5 */
  0x3FD5,   /* U+45D6 */
  0x3FCD,   /* U+45D7 */
  0x3FCD,   /* U+45D8 */
  0x3FCD,   /* U+45D9 */
  0x3FCD,   /* U+45DA */
  0x3FCD,   /* U+45DB */
  0x3FCD,   /* U+45DC */
  0x3FCD,   /* U+45DD */
  0x3FCD,   /* U+45DE */
  0x3FD7,   /* U+45DF */
  0x3FD7,   /* U+45E0 */
  0x3FD7,   /* U+45E1 */
  0x3FD7,   /* U+45E2 */
  0x3FD7,   /* U+45E3 */
  0x3FD7,   /* U+45E4 */
  0x3FD7,   /* U+45E5 */
  0x3FD7,   /* U+45E6 */
  0x3FD7,   /* U+45E7 */
  0x3FD7,   /* U+45E8 */
  0x3FD7,   /* U+45E9 */
  0x3FD7,   /* U+45EA */
  0x3FD7,   /* U+45EB */
  0x3FD7,   /* U+45EC */
  0x3FD7,   /* U+45ED */
  0x3FD7,   /* U+45EE */
  0x3FD8,   /* U+45EF */
  0x3FD8,   /* U+45F0 */
  0x3FD8,   /* U+45F1 */
  0x3FD8,   /* U+45F2 */
  0x5C49,   /* U+45F3 */
  0x3FD9,   /* U+45F4 */
  0x3FD9,   /* U+45F5 */
  0x3FD9,   /* U+45F6 */
  0x3FD9,   /* U+45F7 */
  0x3FD9,   /* U+45F8 */
  0x3FD9,   /* U+45F9 */
  0x3FD9,   /* U+45FA */
  0x3FD9,   /* U+45FB */
  0x3FDA,   /* U+45FC */
  0x3FDA,   /* U+45FD */
  0x3FDA,   /* U+45FE */
  0x3FDA,   /* U+45FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4500 */
  0x0020,   /* U+4501 */
  0x0020,   /* U+4502 */
  0x0020,   /* U+4503 */
  0x0020,   /* U+4504 */
  0x0020,   /* U+4505 */
  0x0020,   /* U+4506 */
  0x0020,   /* U+4507 */
  0x0020,   /* U+4508 */
  0x0020,   /* U+4509 */
  0x0020,   /* U+450A */
  0x0020,   /* U+450B */
  0x0020,   /* U+450C */
  0x0020,   /* U+450D */
  0x0020,   /* U+450E */
  0x0020,   /* U+450F */
  0x0020,   /* U+4510 */
  0x0020,   /* U+4511 */
  0x0020,   /* U+4512 */
  0x0020,   /* U+4513 */
  0x0020,   /* U+4514 */
  0x0020,   /* U+4515 */
  0x0020,   /* U+4516 */
  0x0020,   /* U+4517 */
  0x0020,   /* U+4518 */
  0x0020,   /* U+4519 */
  0x0020,   /* U+451A */
  0x0020,   /* U+451B */
  0x0020,   /* U+451C */
  0x0020,   /* U+451D */
  0x0020,   /* U+451E */
  0x0020,   /* U+451F */
  0x0020,   /* U+4520 */
  0x0020,   /* U+4521 */
  0x0020,   /* U+4522 */
  0x0020,   /* U+4523 */
  0x0020,   /* U+4524 */
  0x0020,   /* U+4525 */
  0x0020,   /* U+4526 */
  0x0020,   /* U+4527 */
  0x0020,   /* U+4528 */
  0x0020,   /* U+4529 */
  0x0020,   /* U+452A */
  0x0020,   /* U+452B */
  0x0020,   /* U+452C */
  0x0020,   /* U+452D */
  0x0020,   /* U+452E */
  0x0020,   /* U+452F */
  0x0020,   /* U+4530 */
  0x0020,   /* U+4531 */
  0x0020,   /* U+4532 */
  0x0020,   /* U+4533 */
  0x0020,   /* U+4534 */
  0x0020,   /* U+4535 */
  0x0020,   /* U+4536 */
  0x0020,   /* U+4537 */
  0x0020,   /* U+4538 */
  0x0020,   /* U+4539 */
  0x0020,   /* U+453A */
  0x0020,   /* U+453B */
  0x0020,   /* U+453C */
  0x0020,   /* U+453D */
  0x0020,   /* U+453E */
  0x0020,   /* U+453F */
  0x0020,   /* U+4540 */
  0x0020,   /* U+4541 */
  0x0020,   /* U+4542 */
  0x0020,   /* U+4543 */
  0x0020,   /* U+4544 */
  0x0020,   /* U+4545 */
  0x0020,   /* U+4546 */
  0x0020,   /* U+4547 */
  0x0020,   /* U+4548 */
  0x0020,   /* U+4549 */
  0x0020,   /* U+454A */
  0x0020,   /* U+454B */
  0x0020,   /* U+454C */
  0x0020,   /* U+454D */
  0x0020,   /* U+454E */
  0x0020,   /* U+454F */
  0x0020,   /* U+4550 */
  0x0020,   /* U+4551 */
  0x0020,   /* U+4552 */
  0x0020,   /* U+4553 */
  0x0020,   /* U+4554 */
  0x0020,   /* U+4555 */
  0x0020,   /* U+4556 */
  0x0020,   /* U+4557 */
  0x0020,   /* U+4558 */
  0x0020,   /* U+4559 */
  0x0020,   /* U+455A */
  0x0020,   /* U+455B */
  0x0020,   /* U+455C */
  0x0020,   /* U+455D */
  0x0020,   /* U+455E */
  0x0020,   /* U+455F */
  0x0020,   /* U+4560 */
  0x0020,   /* U+4561 */
  0x0020,   /* U+4562 */
  0x0020,   /* U+4563 */
  0x0020,   /* U+4564 */
  0x0020,   /* U+4565 */
  0x0020,   /* U+4566 */
  0x0020,   /* U+4567 */
  0x0020,   /* U+4568 */
  0x0020,   /* U+4569 */
  0x0020,   /* U+456A */
  0x0020,   /* U+456B */
  0x0020,   /* U+456C */
  0x0020,   /* U+456D */
  0x0020,   /* U+456E */
  0x0020,   /* U+456F */
  0x0020,   /* U+4570 */
  0x0020,   /* U+4571 */
  0x0020,   /* U+4572 */
  0x0020,   /* U+4573 */
  0x0020,   /* U+4574 */
  0x0020,   /* U+4575 */
  0x0020,   /* U+4576 */
  0x0020,   /* U+4577 */
  0x0020,   /* U+4578 */
  0x0020,   /* U+4579 */
  0x0020,   /* U+457A */
  0x0020,   /* U+457B */
  0x0020,   /* U+457C */
  0x0020,   /* U+457D */
  0x0020,   /* U+457E */
  0x0020,   /* U+457F */
  0x0020,   /* U+4580 */
  0x0020,   /* U+4581 */
  0x0020,   /* U+4582 */
  0x0020,   /* U+4583 */
  0x0020,   /* U+4584 */
  0x0020,   /* U+4585 */
  0x0020,   /* U+4586 */
  0x0020,   /* U+4587 */
  0x0020,   /* U+4588 */
  0x0020,   /* U+4589 */
  0x0020,   /* U+458A */
  0x0020,   /* U+458B */
  0x0020,   /* U+458C */
  0x0020,   /* U+458D */
  0x0020,   /* U+458E */
  0x0020,   /* U+458F */
  0x0020,   /* U+4590 */
  0x0020,   /* U+4591 */
  0x0020,   /* U+4592 */
  0x0020,   /* U+4593 */
  0x0020,   /* U+4594 */
  0x0020,   /* U+4595 */
  0x0020,   /* U+4596 */
  0x0020,   /* U+4597 */
  0x0020,   /* U+4598 */
  0x0020,   /* U+4599 */
  0x0020,   /* U+459A */
  0x0020,   /* U+459B */
  0x0020,   /* U+459C */
  0x0020,   /* U+459D */
  0x0020,   /* U+459E */
  0x0020,   /* U+459F */
  0x0020,   /* U+45A0 */
  0x0020,   /* U+45A1 */
  0x0020,   /* U+45A2 */
  0x0020,   /* U+45A3 */
  0x0020,   /* U+45A4 */
  0x0020,   /* U+45A5 */
  0x0020,   /* U+45A6 */
  0x0020,   /* U+45A7 */
  0x0020,   /* U+45A8 */
  0x0020,   /* U+45A9 */
  0x0020,   /* U+45AA */
  0x0020,   /* U+45AB */
  0x0020,   /* U+45AC */
  0x0020,   /* U+45AD */
  0x0020,   /* U+45AE */
  0x0020,   /* U+45AF */
  0x0020,   /* U+45B0 */
  0x0020,   /* U+45B1 */
  0x0020,   /* U+45B2 */
  0x0020,   /* U+45B3 */
  0x0020,   /* U+45B4 */
  0x0020,   /* U+45B5 */
  0x0020,   /* U+45B6 */
  0x0020,   /* U+45B7 */
  0x0020,   /* U+45B8 */
  0x0020,   /* U+45B9 */
  0x0020,   /* U+45BA */
  0x0020,   /* U+45BB */
  0x0020,   /* U+45BC */
  0x0020,   /* U+45BD */
  0x0020,   /* U+45BE */
  0x0020,   /* U+45BF */
  0x0020,   /* U+45C0 */
  0x0020,   /* U+45C1 */
  0x0020,   /* U+45C2 */
  0x0020,   /* U+45C3 */
  0x0020,   /* U+45C4 */
  0x0020,   /* U+45C5 */
  0x0020,   /* U+45C6 */
  0x0020,   /* U+45C7 */
  0x0020,   /* U+45C8 */
  0x0020,   /* U+45C9 */
  0x0020,   /* U+45CA */
  0x0020,   /* U+45CB */
  0x0020,   /* U+45CC */
  0x0020,   /* U+45CD */
  0x0020,   /* U+45CE */
  0x0020,   /* U+45CF */
  0x0020,   /* U+45D0 */
  0x0020,   /* U+45D1 */
  0x0020,   /* U+45D2 */
  0x0020,   /* U+45D3 */
  0x0020,   /* U+45D4 */
  0x0020,   /* U+45D5 */
  0x0020,   /* U+45D6 */
  0x0020,   /* U+45D7 */
  0x0020,   /* U+45D8 */
  0x0020,   /* U+45D9 */
  0x0020,   /* U+45DA */
  0x0020,   /* U+45DB */
  0x0020,   /* U+45DC */
  0x0020,   /* U+45DD */
  0x0020,   /* U+45DE */
  0x0020,   /* U+45DF */
  0x0020,   /* U+45E0 */
  0x0020,   /* U+45E1 */
  0x0020,   /* U+45E2 */
  0x0020,   /* U+45E3 */
  0x0020,   /* U+45E4 */
  0x0020,   /* U+45E5 */
  0x0020,   /* U+45E6 */
  0x0020,   /* U+45E7 */
  0x0020,   /* U+45E8 */
  0x0020,   /* U+45E9 */
  0x0020,   /* U+45EA */
  0x0020,   /* U+45EB */
  0x0020,   /* U+45EC */
  0x0020,   /* U+45ED */
  0x0020,   /* U+45EE */
  0x0020,   /* U+45EF */
  0x0020,   /* U+45F0 */
  0x0020,   /* U+45F1 */
  0x0020,   /* U+45F2 */
  0x0020,   /* U+45F3 */
  0x0020,   /* U+45F4 */
  0x0020,   /* U+45F5 */
  0x0020,   /* U+45F6 */
  0x0020,   /* U+45F7 */
  0x0020,   /* U+45F8 */
  0x0020,   /* U+45F9 */
  0x0020,   /* U+45FA */
  0x0020,   /* U+45FB */
  0x0020,   /* U+45FC */
  0x0020,   /* U+45FD */
  0x0020,   /* U+45FE */
  0x0020,   /* U+45FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4500 */
  0x0002,   /* U+4501 */
  0x0002,   /* U+4502 */
  0x0002,   /* U+4503 */
  0x0002,   /* U+4504 */
  0x0002,   /* U+4505 */
  0x0002,   /* U+4506 */
  0x0002,   /* U+4507 */
  0x0002,   /* U+4508 */
  0x0002,   /* U+4509 */
  0x0002,   /* U+450A */
  0x0002,   /* U+450B */
  0x0002,   /* U+450C */
  0x0002,   /* U+450D */
  0x0002,   /* U+450E */
  0x0002,   /* U+450F */
  0x0002,   /* U+4510 */
  0x0002,   /* U+4511 */
  0x0002,   /* U+4512 */
  0x0002,   /* U+4513 */
  0x0002,   /* U+4514 */
  0x0002,   /* U+4515 */
  0x0002,   /* U+4516 */
  0x0002,   /* U+4517 */
  0x0002,   /* U+4518 */
  0x0002,   /* U+4519 */
  0x0002,   /* U+451A */
  0x0002,   /* U+451B */
  0x0002,   /* U+451C */
  0x0002,   /* U+451D */
  0x0002,   /* U+451E */
  0x0002,   /* U+451F */
  0x0002,   /* U+4520 */
  0x0002,   /* U+4521 */
  0x0002,   /* U+4522 */
  0x0002,   /* U+4523 */
  0x0002,   /* U+4524 */
  0x0002,   /* U+4525 */
  0x0002,   /* U+4526 */
  0x0002,   /* U+4527 */
  0x0002,   /* U+4528 */
  0x0002,   /* U+4529 */
  0x0002,   /* U+452A */
  0x0002,   /* U+452B */
  0x0002,   /* U+452C */
  0x0002,   /* U+452D */
  0x0002,   /* U+452E */
  0x0002,   /* U+452F */
  0x0002,   /* U+4530 */
  0x0002,   /* U+4531 */
  0x0002,   /* U+4532 */
  0x0002,   /* U+4533 */
  0x0002,   /* U+4534 */
  0x0002,   /* U+4535 */
  0x0002,   /* U+4536 */
  0x0002,   /* U+4537 */
  0x0002,   /* U+4538 */
  0x0002,   /* U+4539 */
  0x0002,   /* U+453A */
  0x0002,   /* U+453B */
  0x0002,   /* U+453C */
  0x0002,   /* U+453D */
  0x0002,   /* U+453E */
  0x0002,   /* U+453F */
  0x0002,   /* U+4540 */
  0x0002,   /* U+4541 */
  0x0002,   /* U+4542 */
  0x0002,   /* U+4543 */
  0x0002,   /* U+4544 */
  0x0002,   /* U+4545 */
  0x0002,   /* U+4546 */
  0x0002,   /* U+4547 */
  0x0002,   /* U+4548 */
  0x0002,   /* U+4549 */
  0x0002,   /* U+454A */
  0x0002,   /* U+454B */
  0x0002,   /* U+454C */
  0x0002,   /* U+454D */
  0x0002,   /* U+454E */
  0x0002,   /* U+454F */
  0x0002,   /* U+4550 */
  0x0002,   /* U+4551 */
  0x0002,   /* U+4552 */
  0x0002,   /* U+4553 */
  0x0002,   /* U+4554 */
  0x0002,   /* U+4555 */
  0x0002,   /* U+4556 */
  0x0002,   /* U+4557 */
  0x0002,   /* U+4558 */
  0x0002,   /* U+4559 */
  0x0002,   /* U+455A */
  0x0002,   /* U+455B */
  0x0002,   /* U+455C */
  0x0002,   /* U+455D */
  0x0002,   /* U+455E */
  0x0002,   /* U+455F */
  0x0002,   /* U+4560 */
  0x0002,   /* U+4561 */
  0x0002,   /* U+4562 */
  0x0002,   /* U+4563 */
  0x0002,   /* U+4564 */
  0x0002,   /* U+4565 */
  0x0002,   /* U+4566 */
  0x0002,   /* U+4567 */
  0x0002,   /* U+4568 */
  0x0002,   /* U+4569 */
  0x0002,   /* U+456A */
  0x0002,   /* U+456B */
  0x0002,   /* U+456C */
  0x0002,   /* U+456D */
  0x0002,   /* U+456E */
  0x0002,   /* U+456F */
  0x0002,   /* U+4570 */
  0x0002,   /* U+4571 */
  0x0002,   /* U+4572 */
  0x0002,   /* U+4573 */
  0x0002,   /* U+4574 */
  0x0002,   /* U+4575 */
  0x0002,   /* U+4576 */
  0x0002,   /* U+4577 */
  0x0002,   /* U+4578 */
  0x0002,   /* U+4579 */
  0x0002,   /* U+457A */
  0x0002,   /* U+457B */
  0x0002,   /* U+457C */
  0x0002,   /* U+457D */
  0x0002,   /* U+457E */
  0x0002,   /* U+457F */
  0x0002,   /* U+4580 */
  0x0002,   /* U+4581 */
  0x0002,   /* U+4582 */
  0x0002,   /* U+4583 */
  0x0002,   /* U+4584 */
  0x0002,   /* U+4585 */
  0x0002,   /* U+4586 */
  0x0002,   /* U+4587 */
  0x0002,   /* U+4588 */
  0x0002,   /* U+4589 */
  0x0002,   /* U+458A */
  0x0002,   /* U+458B */
  0x0002,   /* U+458C */
  0x0002,   /* U+458D */
  0x0002,   /* U+458E */
  0x0002,   /* U+458F */
  0x0002,   /* U+4590 */
  0x0002,   /* U+4591 */
  0x0002,   /* U+4592 */
  0x0002,   /* U+4593 */
  0x0002,   /* U+4594 */
  0x0002,   /* U+4595 */
  0x0002,   /* U+4596 */
  0x0002,   /* U+4597 */
  0x0002,   /* U+4598 */
  0x0002,   /* U+4599 */
  0x0002,   /* U+459A */
  0x0002,   /* U+459B */
  0x0002,   /* U+459C */
  0x0002,   /* U+459D */
  0x0002,   /* U+459E */
  0x0002,   /* U+459F */
  0x0002,   /* U+45A0 */
  0x0002,   /* U+45A1 */
  0x0002,   /* U+45A2 */
  0x0002,   /* U+45A3 */
  0x0002,   /* U+45A4 */
  0x0002,   /* U+45A5 */
  0x0002,   /* U+45A6 */
  0x0002,   /* U+45A7 */
  0x0002,   /* U+45A8 */
  0x0002,   /* U+45A9 */
  0x0002,   /* U+45AA */
  0x0002,   /* U+45AB */
  0x0002,   /* U+45AC */
  0x0002,   /* U+45AD */
  0x0002,   /* U+45AE */
  0x0002,   /* U+45AF */
  0x0002,   /* U+45B0 */
  0x0002,   /* U+45B1 */
  0x0002,   /* U+45B2 */
  0x0002,   /* U+45B3 */
  0x0002,   /* U+45B4 */
  0x0002,   /* U+45B5 */
  0x0002,   /* U+45B6 */
  0x0002,   /* U+45B7 */
  0x0002,   /* U+45B8 */
  0x0002,   /* U+45B9 */
  0x0002,   /* U+45BA */
  0x0002,   /* U+45BB */
  0x0002,   /* U+45BC */
  0x0002,   /* U+45BD */
  0x0002,   /* U+45BE */
  0x0002,   /* U+45BF */
  0x0002,   /* U+45C0 */
  0x0002,   /* U+45C1 */
  0x0002,   /* U+45C2 */
  0x0002,   /* U+45C3 */
  0x0002,   /* U+45C4 */
  0x0002,   /* U+45C5 */
  0x0002,   /* U+45C6 */
  0x0002,   /* U+45C7 */
  0x0002,   /* U+45C8 */
  0x0002,   /* U+45C9 */
  0x0002,   /* U+45CA */
  0x0002,   /* U+45CB */
  0x0002,   /* U+45CC */
  0x0002,   /* U+45CD */
  0x0002,   /* U+45CE */
  0x0002,   /* U+45CF */
  0x0002,   /* U+45D0 */
  0x0002,   /* U+45D1 */
  0x0002,   /* U+45D2 */
  0x0002,   /* U+45D3 */
  0x0002,   /* U+45D4 */
  0x0002,   /* U+45D5 */
  0x0002,   /* U+45D6 */
  0x0002,   /* U+45D7 */
  0x0002,   /* U+45D8 */
  0x0002,   /* U+45D9 */
  0x0002,   /* U+45DA */
  0x0002,   /* U+45DB */
  0x0002,   /* U+45DC */
  0x0002,   /* U+45DD */
  0x0002,   /* U+45DE */
  0x0002,   /* U+45DF */
  0x0002,   /* U+45E0 */
  0x0002,   /* U+45E1 */
  0x0002,   /* U+45E2 */
  0x0002,   /* U+45E3 */
  0x0002,   /* U+45E4 */
  0x0002,   /* U+45E5 */
  0x0002,   /* U+45E6 */
  0x0002,   /* U+45E7 */
  0x0002,   /* U+45E8 */
  0x0002,   /* U+45E9 */
  0x0002,   /* U+45EA */
  0x0002,   /* U+45EB */
  0x0002,   /* U+45EC */
  0x0002,   /* U+45ED */
  0x0002,   /* U+45EE */
  0x0002,   /* U+45EF */
  0x0002,   /* U+45F0 */
  0x0002,   /* U+45F1 */
  0x0002,   /* U+45F2 */
  0x0002,   /* U+45F3 */
  0x0002,   /* U+45F4 */
  0x0002,   /* U+45F5 */
  0x0002,   /* U+45F6 */
  0x0002,   /* U+45F7 */
  0x0002,   /* U+45F8 */
  0x0002,   /* U+45F9 */
  0x0002,   /* U+45FA */
  0x0002,   /* U+45FB */
  0x0002,   /* U+45FC */
  0x0002,   /* U+45FD */
  0x0002,   /* U+45FE */
  0x0002,   /* U+45FF */

  /* Primary weight 2 for each character. */
  0x8004,   /* U+4500 */
  0x8005,   /* U+4501 */
  0x8006,   /* U+4502 */
  0x8007,   /* U+4503 */
  0x8008,   /* U+4504 */
  0x8009,   /* U+4505 */
  0x800A,   /* U+4506 */
  0x800B,   /* U+4507 */
  0x800C,   /* U+4508 */
  0x800D,   /* U+4509 */
  0x800E,   /* U+450A */
  0x800F,   /* U+450B */
  0x8010,   /* U+450C */
  0x8011,   /* U+450D */
  0x8000,   /* U+450E */
  0x8001,   /* U+450F */
  0x8002,   /* U+4510 */
  0x8003,   /* U+4511 */
  0x8004,   /* U+4512 */
  0x8005,   /* U+4513 */
  0x8006,   /* U+4514 */
  0x8007,   /* U+4515 */
  0x8008,   /* U+4516 */
  0x8009,   /* U+4517 */
  0x800A,   /* U+4518 */
  0x800B,   /* U+4519 */
  0x800C,   /* U+451A */
  0x800D,   /* U+451B */
  0x800E,   /* U+451C */
  0x800F,   /* U+451D */
  0x8010,   /* U+451E */
  0x8011,   /* U+451F */
  0x8012,   /* U+4520 */
  0x8013,   /* U+4521 */
  0x8014,   /* U+4522 */
  0x8015,   /* U+4523 */
  0x8016,   /* U+4524 */
  0x8017,   /* U+4525 */
  0x8018,   /* U+4526 */
  0x8019,   /* U+4527 */
  0x801A,   /* U+4528 */
  0xC529,   /* U+4529 */
  0x801B,   /* U+452A */
  0xC52B,   /* U+452B */
  0x801C,   /* U+452C */
  0x8000,   /* U+452D */
  0x8001,   /* U+452E */
  0x8002,   /* U+452F */
  0x8003,   /* U+4530 */
  0x8004,   /* U+4531 */
  0x8005,   /* U+4532 */
  0x8006,   /* U+4533 */
  0x8007,   /* U+4534 */
  0x8008,   /* U+4535 */
  0x8009,   /* U+4536 */
  0x800A,   /* U+4537 */
  0x800B,   /* U+4538 */
  0x800C,   /* U+4539 */
  0x800D,   /* U+453A */
  0x800E,   /* U+453B */
  0x800F,   /* U+453C */
  0x8010,   /* U+453D */
  0x8011,   /* U+453E */
  0x8012,   /* U+453F */
  0x8013,   /* U+4540 */
  0x8014,   /* U+4541 */
  0x8015,   /* U+4542 */
  0xC543,   /* U+4543 */
  0x8016,   /* U+4544 */
  0x8000,   /* U+4545 */
  0x8001,   /* U+4546 */
  0x8002,   /* U+4547 */
  0x8003,   /* U+4548 */
  0x8004,   /* U+4549 */
  0x8005,   /* U+454A */
  0x8006,   /* U+454B */
  0x8007,   /* U+454C */
  0x8008,   /* U+454D */
  0x8009,   /* U+454E */
  0x800A,   /* U+454F */
  0x800B,   /* U+4550 */
  0x800C,   /* U+4551 */
  0x8000,   /* U+4552 */
  0x8001,   /* U+4553 */
  0x8002,   /* U+4554 */
  0x8003,   /* U+4555 */
  0x8004,   /* U+4556 */
  0x8005,   /* U+4557 */
  0x8006,   /* U+4558 */
  0x8007,   /* U+4559 */
  0x8008,   /* U+455A */
  0x8009,   /* U+455B */
  0x800A,   /* U+455C */
  0x800B,   /* U+455D */
  0x8000,   /* U+455E */
  0x8001,   /* U+455F */
  0x8002,   /* U+4560 */
  0x8003,   /* U+4561 */
  0x8004,   /* U+4562 */
  0x8005,   /* U+4563 */
  0x8006,   /* U+4564 */
  0x8007,   /* U+4565 */
  0x8000,   /* U+4566 */
  0x8001,   /* U+4567 */
  0x8002,   /* U+4568 */
  0x8003,   /* U+4569 */
  0x8004,   /* U+456A */
  0x8005,   /* U+456B */
  0x8006,   /* U+456C */
  0x8007,   /* U+456D */
  0x8008,   /* U+456E */
  0x8009,   /* U+456F */
  0x800A,   /* U+4570 */
  0x800B,   /* U+4571 */
  0x800C,   /* U+4572 */
  0x8000,   /* U+4573 */
  0x8001,   /* U+4574 */
  0x8002,   /* U+4575 */
  0xC576,   /* U+4576 */
  0x8003,   /* U+4577 */
  0x8000,   /* U+4578 */
  0x8001,   /* U+4579 */
  0x8002,   /* U+457A */
  0x8000,   /* U+457B */
  0x8001,   /* U+457C */
  0x8002,   /* U+457D */
  0x8003,   /* U+457E */
  0x8000,   /* U+457F */
  0x8001,   /* U+4580 */
  0x8000,   /* U+4581 */
  0x8000,   /* U+4582 */
  0x8001,   /* U+4583 */
  0x8002,   /* U+4584 */
  0x8000,   /* U+4585 */
  0x8001,   /* U+4586 */
  0x8000,   /* U+4587 */
  0x8000,   /* U+4588 */
  0x8000,   /* U+4589 */
  0x8000,   /* U+458A */
  0x8001,   /* U+458B */
  0x8002,   /* U+458C */
  0xC58D,   /* U+458D */
  0x8000,   /* U+458E */
  0x8001,   /* U+458F */
  0x8000,   /* U+4590 */
  0x8001,   /* U+4591 */
  0x8000,   /* U+4592 */
  0x8001,   /* U+4593 */
  0x8002,   /* U+4594 */
  0x8003,   /* U+4595 */
  0x8004,   /* U+4596 */
  0x8000,   /* U+4597 */
  0x8000,   /* U+4598 */
  0x8000,   /* U+4599 */
  0x8000,   /* U+459A */
  0x8001,   /* U+459B */
  0x8000,   /* U+459C */
  0x8000,   /* U+459D */
  0x8000,   /* U+459E */
  0x8001,   /* U+459F */
  0x8002,   /* U+45A0 */
  0x8000,   /* U+45A1 */
  0x8001,   /* U+45A2 */
  0x8002,   /* U+45A3 */
  0x8000,   /* U+45A4 */
  0x8001,   /* U+45A5 */
  0x8002,   /* U+45A6 */
  0x8003,   /* U+45A7 */
  0x8004,   /* U+45A8 */
  0x8005,   /* U+45A9 */
  0x8006,   /* U+45AA */
  0x8007,   /* U+45AB */
  0x8008,   /* U+45AC */
  0x8000,   /* U+45AD */
  0x8001,   /* U+45AE */
  0x8002,   /* U+45AF */
  0x8003,   /* U+45B0 */
  0x8004,   /* U+45B1 */
  0x8005,   /* U+45B2 */
  0x8006,   /* U+45B3 */
  0x8007,   /* U+45B4 */
  0x8008,   /* U+45B5 */
  0x8000,   /* U+45B6 */
  0x8001,   /* U+45B7 */
  0x8002,   /* U+45B8 */
  0x8003,   /* U+45B9 */
  0x8004,   /* U+45BA */
  0x8005,   /* U+45BB */
  0x8006,   /* U+45BC */
  0x8007,   /* U+45BD */
  0x8008,   /* U+45BE */
  0x8000,   /* U+45BF */
  0x8001,   /* U+45C0 */
  0x8002,   /* U+45C1 */
  0x8003,   /* U+45C2 */
  0x8004,   /* U+45C3 */
  0x8005,   /* U+45C4 */
  0x8006,   /* U+45C5 */
  0x8007,   /* U+45C6 */
  0x8008,   /* U+45C7 */
  0x8009,   /* U+45C8 */
  0x800A,   /* U+45C9 */
  0x800B,   /* U+45CA */
  0x8000,   /* U+45CB */
  0x8001,   /* U+45CC */
  0x8002,   /* U+45CD */
  0x8003,   /* U+45CE */
  0x8004,   /* U+45CF */
  0x8005,   /* U+45D0 */
  0x8006,   /* U+45D1 */
  0x8007,   /* U+45D2 */
  0x8008,   /* U+45D3 */
  0x8009,   /* U+45D4 */
  0x800C,   /* U+45D5 */
  0x800A,   /* U+45D6 */
  0x8001,   /* U+45D7 */
  0x8002,   /* U+45D8 */
  0x8003,   /* U+45D9 */
  0x8004,   /* U+45DA */
  0x8005,   /* U+45DB */
  0x8006,   /* U+45DC */
  0x8007,   /* U+45DD */
  0x8008,   /* U+45DE */
  0x8000,   /* U+45DF */
  0x8001,   /* U+45E0 */
  0x8002,   /* U+45E1 */
  0x8003,   /* U+45E2 */
  0x8004,   /* U+45E3 */
  0x8005,   /* U+45E4 */
  0x8006,   /* U+45E5 */
  0x8007,   /* U+45E6 */
  0x8008,   /* U+45E7 */
  0x8009,   /* U+45E8 */
  0x800A,   /* U+45E9 */
  0x800B,   /* U+45EA */
  0x800C,   /* U+45EB */
  0x800D,   /* U+45EC */
  0x800E,   /* U+45ED */
  0x800F,   /* U+45EE */
  0x8000,   /* U+45EF */
  0x8001,   /* U+45F0 */
  0x8002,   /* U+45F1 */
  0x8003,   /* U+45F2 */
  0xC5F3,   /* U+45F3 */
  0x8000,   /* U+45F4 */
  0x8001,   /* U+45F5 */
  0x8002,   /* U+45F6 */
  0x8003,   /* U+45F7 */
  0x8004,   /* U+45F8 */
  0x8005,   /* U+45F9 */
  0x8006,   /* U+45FA */
  0x8007,   /* U+45FB */
  0x8000,   /* U+45FC */
  0x8001,   /* U+45FD */
  0x8002,   /* U+45FE */
  0x8003,   /* U+45FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4500 */
  0x0000,   /* U+4501 */
  0x0000,   /* U+4502 */
  0x0000,   /* U+4503 */
  0x0000,   /* U+4504 */
  0x0000,   /* U+4505 */
  0x0000,   /* U+4506 */
  0x0000,   /* U+4507 */
  0x0000,   /* U+4508 */
  0x0000,   /* U+4509 */
  0x0000,   /* U+450A */
  0x0000,   /* U+450B */
  0x0000,   /* U+450C */
  0x0000,   /* U+450D */
  0x0000,   /* U+450E */
  0x0000,   /* U+450F */
  0x0000,   /* U+4510 */
  0x0000,   /* U+4511 */
  0x0000,   /* U+4512 */
  0x0000,   /* U+4513 */
  0x0000,   /* U+4514 */
  0x0000,   /* U+4515 */
  0x0000,   /* U+4516 */
  0x0000,   /* U+4517 */
  0x0000,   /* U+4518 */
  0x0000,   /* U+4519 */
  0x0000,   /* U+451A */
  0x0000,   /* U+451B */
  0x0000,   /* U+451C */
  0x0000,   /* U+451D */
  0x0000,   /* U+451E */
  0x0000,   /* U+451F */
  0x0000,   /* U+4520 */
  0x0000,   /* U+4521 */
  0x0000,   /* U+4522 */
  0x0000,   /* U+4523 */
  0x0000,   /* U+4524 */
  0x0000,   /* U+4525 */
  0x0000,   /* U+4526 */
  0x0000,   /* U+4527 */
  0x0000,   /* U+4528 */
  0x0000,   /* U+4529 */
  0x0000,   /* U+452A */
  0x0000,   /* U+452B */
  0x0000,   /* U+452C */
  0x0000,   /* U+452D */
  0x0000,   /* U+452E */
  0x0000,   /* U+452F */
  0x0000,   /* U+4530 */
  0x0000,   /* U+4531 */
  0x0000,   /* U+4532 */
  0x0000,   /* U+4533 */
  0x0000,   /* U+4534 */
  0x0000,   /* U+4535 */
  0x0000,   /* U+4536 */
  0x0000,   /* U+4537 */
  0x0000,   /* U+4538 */
  0x0000,   /* U+4539 */
  0x0000,   /* U+453A */
  0x0000,   /* U+453B */
  0x0000,   /* U+453C */
  0x0000,   /* U+453D */
  0x0000,   /* U+453E */
  0x0000,   /* U+453F */
  0x0000,   /* U+4540 */
  0x0000,   /* U+4541 */
  0x0000,   /* U+4542 */
  0x0000,   /* U+4543 */
  0x0000,   /* U+4544 */
  0x0000,   /* U+4545 */
  0x0000,   /* U+4546 */
  0x0000,   /* U+4547 */
  0x0000,   /* U+4548 */
  0x0000,   /* U+4549 */
  0x0000,   /* U+454A */
  0x0000,   /* U+454B */
  0x0000,   /* U+454C */
  0x0000,   /* U+454D */
  0x0000,   /* U+454E */
  0x0000,   /* U+454F */
  0x0000,   /* U+4550 */
  0x0000,   /* U+4551 */
  0x0000,   /* U+4552 */
  0x0000,   /* U+4553 */
  0x0000,   /* U+4554 */
  0x0000,   /* U+4555 */
  0x0000,   /* U+4556 */
  0x0000,   /* U+4557 */
  0x0000,   /* U+4558 */
  0x0000,   /* U+4559 */
  0x0000,   /* U+455A */
  0x0000,   /* U+455B */
  0x0000,   /* U+455C */
  0x0000,   /* U+455D */
  0x0000,   /* U+455E */
  0x0000,   /* U+455F */
  0x0000,   /* U+4560 */
  0x0000,   /* U+4561 */
  0x0000,   /* U+4562 */
  0x0000,   /* U+4563 */
  0x0000,   /* U+4564 */
  0x0000,   /* U+4565 */
  0x0000,   /* U+4566 */
  0x0000,   /* U+4567 */
  0x0000,   /* U+4568 */
  0x0000,   /* U+4569 */
  0x0000,   /* U+456A */
  0x0000,   /* U+456B */
  0x0000,   /* U+456C */
  0x0000,   /* U+456D */
  0x0000,   /* U+456E */
  0x0000,   /* U+456F */
  0x0000,   /* U+4570 */
  0x0000,   /* U+4571 */
  0x0000,   /* U+4572 */
  0x0000,   /* U+4573 */
  0x0000,   /* U+4574 */
  0x0000,   /* U+4575 */
  0x0000,   /* U+4576 */
  0x0000,   /* U+4577 */
  0x0000,   /* U+4578 */
  0x0000,   /* U+4579 */
  0x0000,   /* U+457A */
  0x0000,   /* U+457B */
  0x0000,   /* U+457C */
  0x0000,   /* U+457D */
  0x0000,   /* U+457E */
  0x0000,   /* U+457F */
  0x0000,   /* U+4580 */
  0x0000,   /* U+4581 */
  0x0000,   /* U+4582 */
  0x0000,   /* U+4583 */
  0x0000,   /* U+4584 */
  0x0000,   /* U+4585 */
  0x0000,   /* U+4586 */
  0x0000,   /* U+4587 */
  0x0000,   /* U+4588 */
  0x0000,   /* U+4589 */
  0x0000,   /* U+458A */
  0x0000,   /* U+458B */
  0x0000,   /* U+458C */
  0x0000,   /* U+458D */
  0x0000,   /* U+458E */
  0x0000,   /* U+458F */
  0x0000,   /* U+4590 */
  0x0000,   /* U+4591 */
  0x0000,   /* U+4592 */
  0x0000,   /* U+4593 */
  0x0000,   /* U+4594 */
  0x0000,   /* U+4595 */
  0x0000,   /* U+4596 */
  0x0000,   /* U+4597 */
  0x0000,   /* U+4598 */
  0x0000,   /* U+4599 */
  0x0000,   /* U+459A */
  0x0000,   /* U+459B */
  0x0000,   /* U+459C */
  0x0000,   /* U+459D */
  0x0000,   /* U+459E */
  0x0000,   /* U+459F */
  0x0000,   /* U+45A0 */
  0x0000,   /* U+45A1 */
  0x0000,   /* U+45A2 */
  0x0000,   /* U+45A3 */
  0x0000,   /* U+45A4 */
  0x0000,   /* U+45A5 */
  0x0000,   /* U+45A6 */
  0x0000,   /* U+45A7 */
  0x0000,   /* U+45A8 */
  0x0000,   /* U+45A9 */
  0x0000,   /* U+45AA */
  0x0000,   /* U+45AB */
  0x0000,   /* U+45AC */
  0x0000,   /* U+45AD */
  0x0000,   /* U+45AE */
  0x0000,   /* U+45AF */
  0x0000,   /* U+45B0 */
  0x0000,   /* U+45B1 */
  0x0000,   /* U+45B2 */
  0x0000,   /* U+45B3 */
  0x0000,   /* U+45B4 */
  0x0000,   /* U+45B5 */
  0x0000,   /* U+45B6 */
  0x0000,   /* U+45B7 */
  0x0000,   /* U+45B8 */
  0x0000,   /* U+45B9 */
  0x0000,   /* U+45BA */
  0x0000,   /* U+45BB */
  0x0000,   /* U+45BC */
  0x0000,   /* U+45BD */
  0x0000,   /* U+45BE */
  0x0000,   /* U+45BF */
  0x0000,   /* U+45C0 */
  0x0000,   /* U+45C1 */
  0x0000,   /* U+45C2 */
  0x0000,   /* U+45C3 */
  0x0000,   /* U+45C4 */
  0x0000,   /* U+45C5 */
  0x0000,   /* U+45C6 */
  0x0000,   /* U+45C7 */
  0x0000,   /* U+45C8 */
  0x0000,   /* U+45C9 */
  0x0000,   /* U+45CA */
  0x0000,   /* U+45CB */
  0x0000,   /* U+45CC */
  0x0000,   /* U+45CD */
  0x0000,   /* U+45CE */
  0x0000,   /* U+45CF */
  0x0000,   /* U+45D0 */
  0x0000,   /* U+45D1 */
  0x0000,   /* U+45D2 */
  0x0000,   /* U+45D3 */
  0x0000,   /* U+45D4 */
  0x0000,   /* U+45D5 */
  0x0000,   /* U+45D6 */
  0x0000,   /* U+45D7 */
  0x0000,   /* U+45D8 */
  0x0000,   /* U+45D9 */
  0x0000,   /* U+45DA */
  0x0000,   /* U+45DB */
  0x0000,   /* U+45DC */
  0x0000,   /* U+45DD */
  0x0000,   /* U+45DE */
  0x0000,   /* U+45DF */
  0x0000,   /* U+45E0 */
  0x0000,   /* U+45E1 */
  0x0000,   /* U+45E2 */
  0x0000,   /* U+45E3 */
  0x0000,   /* U+45E4 */
  0x0000,   /* U+45E5 */
  0x0000,   /* U+45E6 */
  0x0000,   /* U+45E7 */
  0x0000,   /* U+45E8 */
  0x0000,   /* U+45E9 */
  0x0000,   /* U+45EA */
  0x0000,   /* U+45EB */
  0x0000,   /* U+45EC */
  0x0000,   /* U+45ED */
  0x0000,   /* U+45EE */
  0x0000,   /* U+45EF */
  0x0000,   /* U+45F0 */
  0x0000,   /* U+45F1 */
  0x0000,   /* U+45F2 */
  0x0000,   /* U+45F3 */
  0x0000,   /* U+45F4 */
  0x0000,   /* U+45F5 */
  0x0000,   /* U+45F6 */
  0x0000,   /* U+45F7 */
  0x0000,   /* U+45F8 */
  0x0000,   /* U+45F9 */
  0x0000,   /* U+45FA */
  0x0000,   /* U+45FB */
  0x0000,   /* U+45FC */
  0x0000,   /* U+45FD */
  0x0000,   /* U+45FE */
  0x0000,   /* U+45FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4500 */
  0x0000,   /* U+4501 */
  0x0000,   /* U+4502 */
  0x0000,   /* U+4503 */
  0x0000,   /* U+4504 */
  0x0000,   /* U+4505 */
  0x0000,   /* U+4506 */
  0x0000,   /* U+4507 */
  0x0000,   /* U+4508 */
  0x0000,   /* U+4509 */
  0x0000,   /* U+450A */
  0x0000,   /* U+450B */
  0x0000,   /* U+450C */
  0x0000,   /* U+450D */
  0x0000,   /* U+450E */
  0x0000,   /* U+450F */
  0x0000,   /* U+4510 */
  0x0000,   /* U+4511 */
  0x0000,   /* U+4512 */
  0x0000,   /* U+4513 */
  0x0000,   /* U+4514 */
  0x0000,   /* U+4515 */
  0x0000,   /* U+4516 */
  0x0000,   /* U+4517 */
  0x0000,   /* U+4518 */
  0x0000,   /* U+4519 */
  0x0000,   /* U+451A */
  0x0000,   /* U+451B */
  0x0000,   /* U+451C */
  0x0000,   /* U+451D */
  0x0000,   /* U+451E */
  0x0000,   /* U+451F */
  0x0000,   /* U+4520 */
  0x0000,   /* U+4521 */
  0x0000,   /* U+4522 */
  0x0000,   /* U+4523 */
  0x0000,   /* U+4524 */
  0x0000,   /* U+4525 */
  0x0000,   /* U+4526 */
  0x0000,   /* U+4527 */
  0x0000,   /* U+4528 */
  0x0000,   /* U+4529 */
  0x0000,   /* U+452A */
  0x0000,   /* U+452B */
  0x0000,   /* U+452C */
  0x0000,   /* U+452D */
  0x0000,   /* U+452E */
  0x0000,   /* U+452F */
  0x0000,   /* U+4530 */
  0x0000,   /* U+4531 */
  0x0000,   /* U+4532 */
  0x0000,   /* U+4533 */
  0x0000,   /* U+4534 */
  0x0000,   /* U+4535 */
  0x0000,   /* U+4536 */
  0x0000,   /* U+4537 */
  0x0000,   /* U+4538 */
  0x0000,   /* U+4539 */
  0x0000,   /* U+453A */
  0x0000,   /* U+453B */
  0x0000,   /* U+453C */
  0x0000,   /* U+453D */
  0x0000,   /* U+453E */
  0x0000,   /* U+453F */
  0x0000,   /* U+4540 */
  0x0000,   /* U+4541 */
  0x0000,   /* U+4542 */
  0x0000,   /* U+4543 */
  0x0000,   /* U+4544 */
  0x0000,   /* U+4545 */
  0x0000,   /* U+4546 */
  0x0000,   /* U+4547 */
  0x0000,   /* U+4548 */
  0x0000,   /* U+4549 */
  0x0000,   /* U+454A */
  0x0000,   /* U+454B */
  0x0000,   /* U+454C */
  0x0000,   /* U+454D */
  0x0000,   /* U+454E */
  0x0000,   /* U+454F */
  0x0000,   /* U+4550 */
  0x0000,   /* U+4551 */
  0x0000,   /* U+4552 */
  0x0000,   /* U+4553 */
  0x0000,   /* U+4554 */
  0x0000,   /* U+4555 */
  0x0000,   /* U+4556 */
  0x0000,   /* U+4557 */
  0x0000,   /* U+4558 */
  0x0000,   /* U+4559 */
  0x0000,   /* U+455A */
  0x0000,   /* U+455B */
  0x0000,   /* U+455C */
  0x0000,   /* U+455D */
  0x0000,   /* U+455E */
  0x0000,   /* U+455F */
  0x0000,   /* U+4560 */
  0x0000,   /* U+4561 */
  0x0000,   /* U+4562 */
  0x0000,   /* U+4563 */
  0x0000,   /* U+4564 */
  0x0000,   /* U+4565 */
  0x0000,   /* U+4566 */
  0x0000,   /* U+4567 */
  0x0000,   /* U+4568 */
  0x0000,   /* U+4569 */
  0x0000,   /* U+456A */
  0x0000,   /* U+456B */
  0x0000,   /* U+456C */
  0x0000,   /* U+456D */
  0x0000,   /* U+456E */
  0x0000,   /* U+456F */
  0x0000,   /* U+4570 */
  0x0000,   /* U+4571 */
  0x0000,   /* U+4572 */
  0x0000,   /* U+4573 */
  0x0000,   /* U+4574 */
  0x0000,   /* U+4575 */
  0x0000,   /* U+4576 */
  0x0000,   /* U+4577 */
  0x0000,   /* U+4578 */
  0x0000,   /* U+4579 */
  0x0000,   /* U+457A */
  0x0000,   /* U+457B */
  0x0000,   /* U+457C */
  0x0000,   /* U+457D */
  0x0000,   /* U+457E */
  0x0000,   /* U+457F */
  0x0000,   /* U+4580 */
  0x0000,   /* U+4581 */
  0x0000,   /* U+4582 */
  0x0000,   /* U+4583 */
  0x0000,   /* U+4584 */
  0x0000,   /* U+4585 */
  0x0000,   /* U+4586 */
  0x0000,   /* U+4587 */
  0x0000,   /* U+4588 */
  0x0000,   /* U+4589 */
  0x0000,   /* U+458A */
  0x0000,   /* U+458B */
  0x0000,   /* U+458C */
  0x0000,   /* U+458D */
  0x0000,   /* U+458E */
  0x0000,   /* U+458F */
  0x0000,   /* U+4590 */
  0x0000,   /* U+4591 */
  0x0000,   /* U+4592 */
  0x0000,   /* U+4593 */
  0x0000,   /* U+4594 */
  0x0000,   /* U+4595 */
  0x0000,   /* U+4596 */
  0x0000,   /* U+4597 */
  0x0000,   /* U+4598 */
  0x0000,   /* U+4599 */
  0x0000,   /* U+459A */
  0x0000,   /* U+459B */
  0x0000,   /* U+459C */
  0x0000,   /* U+459D */
  0x0000,   /* U+459E */
  0x0000,   /* U+459F */
  0x0000,   /* U+45A0 */
  0x0000,   /* U+45A1 */
  0x0000,   /* U+45A2 */
  0x0000,   /* U+45A3 */
  0x0000,   /* U+45A4 */
  0x0000,   /* U+45A5 */
  0x0000,   /* U+45A6 */
  0x0000,   /* U+45A7 */
  0x0000,   /* U+45A8 */
  0x0000,   /* U+45A9 */
  0x0000,   /* U+45AA */
  0x0000,   /* U+45AB */
  0x0000,   /* U+45AC */
  0x0000,   /* U+45AD */
  0x0000,   /* U+45AE */
  0x0000,   /* U+45AF */
  0x0000,   /* U+45B0 */
  0x0000,   /* U+45B1 */
  0x0000,   /* U+45B2 */
  0x0000,   /* U+45B3 */
  0x0000,   /* U+45B4 */
  0x0000,   /* U+45B5 */
  0x0000,   /* U+45B6 */
  0x0000,   /* U+45B7 */
  0x0000,   /* U+45B8 */
  0x0000,   /* U+45B9 */
  0x0000,   /* U+45BA */
  0x0000,   /* U+45BB */
  0x0000,   /* U+45BC */
  0x0000,   /* U+45BD */
  0x0000,   /* U+45BE */
  0x0000,   /* U+45BF */
  0x0000,   /* U+45C0 */
  0x0000,   /* U+45C1 */
  0x0000,   /* U+45C2 */
  0x0000,   /* U+45C3 */
  0x0000,   /* U+45C4 */
  0x0000,   /* U+45C5 */
  0x0000,   /* U+45C6 */
  0x0000,   /* U+45C7 */
  0x0000,   /* U+45C8 */
  0x0000,   /* U+45C9 */
  0x0000,   /* U+45CA */
  0x0000,   /* U+45CB */
  0x0000,   /* U+45CC */
  0x0000,   /* U+45CD */
  0x0000,   /* U+45CE */
  0x0000,   /* U+45CF */
  0x0000,   /* U+45D0 */
  0x0000,   /* U+45D1 */
  0x0000,   /* U+45D2 */
  0x0000,   /* U+45D3 */
  0x0000,   /* U+45D4 */
  0x0000,   /* U+45D5 */
  0x0000,   /* U+45D6 */
  0x0000,   /* U+45D7 */
  0x0000,   /* U+45D8 */
  0x0000,   /* U+45D9 */
  0x0000,   /* U+45DA */
  0x0000,   /* U+45DB */
  0x0000,   /* U+45DC */
  0x0000,   /* U+45DD */
  0x0000,   /* U+45DE */
  0x0000,   /* U+45DF */
  0x0000,   /* U+45E0 */
  0x0000,   /* U+45E1 */
  0x0000,   /* U+45E2 */
  0x0000,   /* U+45E3 */
  0x0000,   /* U+45E4 */
  0x0000,   /* U+45E5 */
  0x0000,   /* U+45E6 */
  0x0000,   /* U+45E7 */
  0x0000,   /* U+45E8 */
  0x0000,   /* U+45E9 */
  0x0000,   /* U+45EA */
  0x0000,   /* U+45EB */
  0x0000,   /* U+45EC */
  0x0000,   /* U+45ED */
  0x0000,   /* U+45EE */
  0x0000,   /* U+45EF */
  0x0000,   /* U+45F0 */
  0x0000,   /* U+45F1 */
  0x0000,   /* U+45F2 */
  0x0000,   /* U+45F3 */
  0x0000,   /* U+45F4 */
  0x0000,   /* U+45F5 */
  0x0000,   /* U+45F6 */
  0x0000,   /* U+45F7 */
  0x0000,   /* U+45F8 */
  0x0000,   /* U+45F9 */
  0x0000,   /* U+45FA */
  0x0000,   /* U+45FB */
  0x0000,   /* U+45FC */
  0x0000,   /* U+45FD */
  0x0000,   /* U+45FE */
  0x0000,   /* U+45FF */
};

uint16 zh2_han_p046[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x3FDA,   /* U+4600 */
  0x3FDA,   /* U+4601 */
  0x3FDB,   /* U+4602 */
  0x3FDB,   /* U+4603 */
  0x3FDB,   /* U+4604 */
  0x3FDC,   /* U+4605 */
  0x3FDC,   /* U+4606 */
  0x3FDC,   /* U+4607 */
  0x3FDC,   /* U+4608 */
  0x3FDC,   /* U+4609 */
  0x3FDD,   /* U+460A */
  0x3FDD,   /* U+460B */
  0x3FDD,   /* U+460C */
  0x3FDF,   /* U+460D */
  0x3FE2,   /* U+460E */
  0x400F,   /* U+460F */
  0x4010,   /* U+4610 */
  0x4011,   /* U+4611 */
  0x4013,   /* U+4612 */
  0x4014,   /* U+4613 */
  0x4015,   /* U+4614 */
  0x4050,   /* U+4615 */
  0x5C49,   /* U+4616 */
  0x404D,   /* U+4617 */
  0x404D,   /* U+4618 */
  0x405A,   /* U+4619 */
  0x408E,   /* U+461A */
  0x408E,   /* U+461B */
  0x408F,   /* U+461C */
  0x408F,   /* U+461D */
  0x408F,   /* U+461E */
  0x4090,   /* U+461F */
  0x4090,   /* U+4620 */
  0x4090,   /* U+4621 */
  0x4091,   /* U+4622 */
  0x4091,   /* U+4623 */
  0x4091,   /* U+4624 */
  0x4091,   /* U+4625 */
  0x4091,   /* U+4626 */
  0x4091,   /* U+4627 */
  0x4092,   /* U+4628 */
  0x4092,   /* U+4629 */
  0x4092,   /* U+462A */
  0x4092,   /* U+462B */
  0x4092,   /* U+462C */
  0x4092,   /* U+462D */
  0x4092,   /* U+462E */
  0x4093,   /* U+462F */
  0x4093,   /* U+4630 */
  0x4093,   /* U+4631 */
  0x4093,   /* U+4632 */
  0x4094,   /* U+4633 */
  0x4094,   /* U+4634 */
  0x4094,   /* U+4635 */
  0x4094,   /* U+4636 */
  0x4094,   /* U+4637 */
  0x4094,   /* U+4638 */
  0x4094,   /* U+4639 */
  0x4094,   /* U+463A */
  0x4094,   /* U+463B */
  0x4094,   /* U+463C */
  0x4094,   /* U+463D */
  0x4094,   /* U+463E */
  0x4094,   /* U+463F */
  0x4094,   /* U+4640 */
  0x4094,   /* U+4641 */
  0x4094,   /* U+4642 */
  0x4095,   /* U+4643 */
  0x4095,   /* U+4644 */
  0x4095,   /* U+4645 */
  0x4095,   /* U+4646 */
  0x4095,   /* U+4647 */
  0x4095,   /* U+4648 */
  0x4095,   /* U+4649 */
  0x4095,   /* U+464A */
  0x4095,   /* U+464B */
  0x4095,   /* U+464C */
  0x5C49,   /* U+464D */
  0x408D,   /* U+464E */
  0x408D,   /* U+464F */
  0x408D,   /* U+4650 */
  0x408D,   /* U+4651 */
  0x408D,   /* U+4652 */
  0x408D,   /* U+4653 */
  0x4097,   /* U+4654 */
  0x4097,   /* U+4655 */
  0x4097,   /* U+4656 */
  0x4097,   /* U+4657 */
  0x4097,   /* U+4658 */
  0x4097,   /* U+4659 */
  0x4097,   /* U+465A */
  0x4097,   /* U+465B */
  0x4097,   /* U+465C */
  0x5C49,   /* U+465D */
  0x4098,   /* U+465E */
  0x4098,   /* U+465F */
  0x4098,   /* U+4660 */
  0x4098,   /* U+4661 */
  0x4098,   /* U+4662 */
  0x4098,   /* U+4663 */
  0x4099,   /* U+4664 */
  0x4099,   /* U+4665 */
  0x409A,   /* U+4666 */
  0x409A,   /* U+4667 */
  0x409A,   /* U+4668 */
  0x409A,   /* U+4669 */
  0x409B,   /* U+466A */
  0x409C,   /* U+466B */
  0x409D,   /* U+466C */
  0x409D,   /* U+466D */
  0x409E,   /* U+466E */
  0x409E,   /* U+466F */
  0x409F,   /* U+4670 */
  0x40A1,   /* U+4671 */
  0x40CF,   /* U+4672 */
  0x40D0,   /* U+4673 */
  0x40D1,   /* U+4674 */
  0x40D2,   /* U+4675 */
  0x40D2,   /* U+4676 */
  0x410F,   /* U+4677 */
  0x410F,   /* U+4678 */
  0x4110,   /* U+4679 */
  0x4110,   /* U+467A */
  0x4110,   /* U+467B */
  0x4111,   /* U+467C */
  0x4111,   /* U+467D */
  0x4111,   /* U+467E */
  0x4111,   /* U+467F */
  0x4112,   /* U+4680 */
  0x4112,   /* U+4681 */
  0x4113,   /* U+4682 */
  0x4113,   /* U+4683 */
  0x4114,   /* U+4684 */
  0x4114,   /* U+4685 */
  0x4115,   /* U+4686 */
  0x4115,   /* U+4687 */
  0x4115,   /* U+4688 */
  0x4115,   /* U+4689 */
  0x410D,   /* U+468A */
  0x410D,   /* U+468B */
  0x410D,   /* U+468C */
  0x4117,   /* U+468D */
  0x4117,   /* U+468E */
  0x4118,   /* U+468F */
  0x4118,   /* U+4690 */
  0x4118,   /* U+4691 */
  0x4118,   /* U+4692 */
  0x4118,   /* U+4693 */
  0x411A,   /* U+4694 */
  0x411F,   /* U+4695 */
  0x4124,   /* U+4696 */
  0x4150,   /* U+4697 */
  0x4152,   /* U+4698 */
  0x4152,   /* U+4699 */
  0x4152,   /* U+469A */
  0x4153,   /* U+469B */
  0x4154,   /* U+469C */
  0x4154,   /* U+469D */
  0x4154,   /* U+469E */
  0x4154,   /* U+469F */
  0x4154,   /* U+46A0 */
  0x4155,   /* U+46A1 */
  0x4155,   /* U+46A2 */
  0x4155,   /* U+46A3 */
  0x5C49,   /* U+46A4 */
  0x414D,   /* U+46A5 */
  0x414D,   /* U+46A6 */
  0x4157,   /* U+46A7 */
  0x4158,   /* U+46A8 */
  0x4158,   /* U+46A9 */
  0x4159,   /* U+46AA */
  0x4159,   /* U+46AB */
  0x4158,   /* U+46AC */
  0x415E,   /* U+46AD */
  0x418E,   /* U+46AE */
  0x418E,   /* U+46AF */
  0x418E,   /* U+46B0 */
  0x418F,   /* U+46B1 */
  0x418F,   /* U+46B2 */
  0x4190,   /* U+46B3 */
  0x4190,   /* U+46B4 */
  0x4190,   /* U+46B5 */
  0x4190,   /* U+46B6 */
  0x4190,   /* U+46B7 */
  0x4190,   /* U+46B8 */
  0x4190,   /* U+46B9 */
  0x4190,   /* U+46BA */
  0x4190,   /* U+46BB */
  0x4190,   /* U+46BC */
  0x4190,   /* U+46BD */
  0x4190,   /* U+46BE */
  0x4190,   /* U+46BF */
  0x4190,   /* U+46C0 */
  0x4190,   /* U+46C1 */
  0x4190,   /* U+46C2 */
  0x4190,   /* U+46C3 */
  0x4191,   /* U+46C4 */
  0x4191,   /* U+46C5 */
  0x4191,   /* U+46C6 */
  0x4191,   /* U+46C7 */
  0x4191,   /* U+46C8 */
  0x4191,   /* U+46C9 */
  0x4191,   /* U+46CA */
  0x4191,   /* U+46CB */
  0x4191,   /* U+46CC */
  0x4191,   /* U+46CD */
  0x4191,   /* U+46CE */
  0x4191,   /* U+46CF */
  0x4191,   /* U+46D0 */
  0x4191,   /* U+46D1 */
  0x4191,   /* U+46D2 */
  0x4191,   /* U+46D3 */
  0x4192,   /* U+46D4 */
  0x4192,   /* U+46D5 */
  0x4192,   /* U+46D6 */
  0x4192,   /* U+46D7 */
  0x4192,   /* U+46D8 */
  0x4192,   /* U+46D9 */
  0x4192,   /* U+46DA */
  0x4192,   /* U+46DB */
  0x4192,   /* U+46DC */
  0x4193,   /* U+46DD */
  0x4193,   /* U+46DE */
  0x4193,   /* U+46DF */
  0x4193,   /* U+46E0 */
  0x4193,   /* U+46E1 */
  0x4193,   /* U+46E2 */
  0x4193,   /* U+46E3 */
  0x4193,   /* U+46E4 */
  0x4193,   /* U+46E5 */
  0x4193,   /* U+46E6 */
  0x4193,   /* U+46E7 */
  0x4193,   /* U+46E8 */
  0x4194,   /* U+46E9 */
  0x4194,   /* U+46EA */
  0x4194,   /* U+46EB */
  0x4194,   /* U+46EC */
  0x4194,   /* U+46ED */
  0x4194,   /* U+46EE */
  0x4194,   /* U+46EF */
  0x4194,   /* U+46F0 */
  0x4194,   /* U+46F1 */
  0x4194,   /* U+46F2 */
  0x4194,   /* U+46F3 */
  0x4194,   /* U+46F4 */
  0x4194,   /* U+46F5 */
  0x4194,   /* U+46F6 */
  0x4194,   /* U+46F7 */
  0x4194,   /* U+46F8 */
  0x4195,   /* U+46F9 */
  0x4195,   /* U+46FA */
  0x4195,   /* U+46FB */
  0x4195,   /* U+46FC */
  0x4195,   /* U+46FD */
  0x418D,   /* U+46FE */
  0x418D,   /* U+46FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4600 */
  0x0020,   /* U+4601 */
  0x0020,   /* U+4602 */
  0x0020,   /* U+4603 */
  0x0020,   /* U+4604 */
  0x0020,   /* U+4605 */
  0x0020,   /* U+4606 */
  0x0020,   /* U+4607 */
  0x0020,   /* U+4608 */
  0x0020,   /* U+4609 */
  0x0020,   /* U+460A */
  0x0020,   /* U+460B */
  0x0020,   /* U+460C */
  0x0020,   /* U+460D */
  0x0020,   /* U+460E */
  0x0020,   /* U+460F */
  0x0020,   /* U+4610 */
  0x0020,   /* U+4611 */
  0x0020,   /* U+4612 */
  0x0020,   /* U+4613 */
  0x0020,   /* U+4614 */
  0x0020,   /* U+4615 */
  0x0020,   /* U+4616 */
  0x0020,   /* U+4617 */
  0x0020,   /* U+4618 */
  0x0020,   /* U+4619 */
  0x0020,   /* U+461A */
  0x0020,   /* U+461B */
  0x0020,   /* U+461C */
  0x0020,   /* U+461D */
  0x0020,   /* U+461E */
  0x0020,   /* U+461F */
  0x0020,   /* U+4620 */
  0x0020,   /* U+4621 */
  0x0020,   /* U+4622 */
  0x0020,   /* U+4623 */
  0x0020,   /* U+4624 */
  0x0020,   /* U+4625 */
  0x0020,   /* U+4626 */
  0x0020,   /* U+4627 */
  0x0020,   /* U+4628 */
  0x0020,   /* U+4629 */
  0x0020,   /* U+462A */
  0x0020,   /* U+462B */
  0x0020,   /* U+462C */
  0x0020,   /* U+462D */
  0x0020,   /* U+462E */
  0x0020,   /* U+462F */
  0x0020,   /* U+4630 */
  0x0020,   /* U+4631 */
  0x0020,   /* U+4632 */
  0x0020,   /* U+4633 */
  0x0020,   /* U+4634 */
  0x0020,   /* U+4635 */
  0x0020,   /* U+4636 */
  0x0020,   /* U+4637 */
  0x0020,   /* U+4638 */
  0x0020,   /* U+4639 */
  0x0020,   /* U+463A */
  0x0020,   /* U+463B */
  0x0020,   /* U+463C */
  0x0020,   /* U+463D */
  0x0020,   /* U+463E */
  0x0020,   /* U+463F */
  0x0020,   /* U+4640 */
  0x0020,   /* U+4641 */
  0x0020,   /* U+4642 */
  0x0020,   /* U+4643 */
  0x0020,   /* U+4644 */
  0x0020,   /* U+4645 */
  0x0020,   /* U+4646 */
  0x0020,   /* U+4647 */
  0x0020,   /* U+4648 */
  0x0020,   /* U+4649 */
  0x0020,   /* U+464A */
  0x0020,   /* U+464B */
  0x0020,   /* U+464C */
  0x0020,   /* U+464D */
  0x0020,   /* U+464E */
  0x0020,   /* U+464F */
  0x0020,   /* U+4650 */
  0x0020,   /* U+4651 */
  0x0020,   /* U+4652 */
  0x0020,   /* U+4653 */
  0x0020,   /* U+4654 */
  0x0020,   /* U+4655 */
  0x0020,   /* U+4656 */
  0x0020,   /* U+4657 */
  0x0020,   /* U+4658 */
  0x0020,   /* U+4659 */
  0x0020,   /* U+465A */
  0x0020,   /* U+465B */
  0x0020,   /* U+465C */
  0x0020,   /* U+465D */
  0x0020,   /* U+465E */
  0x0020,   /* U+465F */
  0x0020,   /* U+4660 */
  0x0020,   /* U+4661 */
  0x0020,   /* U+4662 */
  0x0020,   /* U+4663 */
  0x0020,   /* U+4664 */
  0x0020,   /* U+4665 */
  0x0020,   /* U+4666 */
  0x0020,   /* U+4667 */
  0x0020,   /* U+4668 */
  0x0020,   /* U+4669 */
  0x0020,   /* U+466A */
  0x0020,   /* U+466B */
  0x0020,   /* U+466C */
  0x0020,   /* U+466D */
  0x0020,   /* U+466E */
  0x0020,   /* U+466F */
  0x0020,   /* U+4670 */
  0x0020,   /* U+4671 */
  0x0020,   /* U+4672 */
  0x0020,   /* U+4673 */
  0x0020,   /* U+4674 */
  0x0020,   /* U+4675 */
  0x0020,   /* U+4676 */
  0x0020,   /* U+4677 */
  0x0020,   /* U+4678 */
  0x0020,   /* U+4679 */
  0x0020,   /* U+467A */
  0x0020,   /* U+467B */
  0x0020,   /* U+467C */
  0x0020,   /* U+467D */
  0x0020,   /* U+467E */
  0x0020,   /* U+467F */
  0x0020,   /* U+4680 */
  0x0020,   /* U+4681 */
  0x0020,   /* U+4682 */
  0x0020,   /* U+4683 */
  0x0020,   /* U+4684 */
  0x0020,   /* U+4685 */
  0x0020,   /* U+4686 */
  0x0020,   /* U+4687 */
  0x0020,   /* U+4688 */
  0x0020,   /* U+4689 */
  0x0020,   /* U+468A */
  0x0020,   /* U+468B */
  0x0020,   /* U+468C */
  0x0020,   /* U+468D */
  0x0020,   /* U+468E */
  0x0020,   /* U+468F */
  0x0020,   /* U+4690 */
  0x0020,   /* U+4691 */
  0x0020,   /* U+4692 */
  0x0020,   /* U+4693 */
  0x0020,   /* U+4694 */
  0x0020,   /* U+4695 */
  0x0020,   /* U+4696 */
  0x0020,   /* U+4697 */
  0x0020,   /* U+4698 */
  0x0020,   /* U+4699 */
  0x0020,   /* U+469A */
  0x0020,   /* U+469B */
  0x0020,   /* U+469C */
  0x0020,   /* U+469D */
  0x0020,   /* U+469E */
  0x0020,   /* U+469F */
  0x0020,   /* U+46A0 */
  0x0020,   /* U+46A1 */
  0x0020,   /* U+46A2 */
  0x0020,   /* U+46A3 */
  0x0020,   /* U+46A4 */
  0x0020,   /* U+46A5 */
  0x0020,   /* U+46A6 */
  0x0020,   /* U+46A7 */
  0x0020,   /* U+46A8 */
  0x0020,   /* U+46A9 */
  0x0020,   /* U+46AA */
  0x0020,   /* U+46AB */
  0x0020,   /* U+46AC */
  0x0020,   /* U+46AD */
  0x0020,   /* U+46AE */
  0x0020,   /* U+46AF */
  0x0020,   /* U+46B0 */
  0x0020,   /* U+46B1 */
  0x0020,   /* U+46B2 */
  0x0020,   /* U+46B3 */
  0x0020,   /* U+46B4 */
  0x0020,   /* U+46B5 */
  0x0020,   /* U+46B6 */
  0x0020,   /* U+46B7 */
  0x0020,   /* U+46B8 */
  0x0020,   /* U+46B9 */
  0x0020,   /* U+46BA */
  0x0020,   /* U+46BB */
  0x0020,   /* U+46BC */
  0x0020,   /* U+46BD */
  0x0020,   /* U+46BE */
  0x0020,   /* U+46BF */
  0x0020,   /* U+46C0 */
  0x0020,   /* U+46C1 */
  0x0020,   /* U+46C2 */
  0x0020,   /* U+46C3 */
  0x0020,   /* U+46C4 */
  0x0020,   /* U+46C5 */
  0x0020,   /* U+46C6 */
  0x0020,   /* U+46C7 */
  0x0020,   /* U+46C8 */
  0x0020,   /* U+46C9 */
  0x0020,   /* U+46CA */
  0x0020,   /* U+46CB */
  0x0020,   /* U+46CC */
  0x0020,   /* U+46CD */
  0x0020,   /* U+46CE */
  0x0020,   /* U+46CF */
  0x0020,   /* U+46D0 */
  0x0020,   /* U+46D1 */
  0x0020,   /* U+46D2 */
  0x0020,   /* U+46D3 */
  0x0020,   /* U+46D4 */
  0x0020,   /* U+46D5 */
  0x0020,   /* U+46D6 */
  0x0020,   /* U+46D7 */
  0x0020,   /* U+46D8 */
  0x0020,   /* U+46D9 */
  0x0020,   /* U+46DA */
  0x0020,   /* U+46DB */
  0x0020,   /* U+46DC */
  0x0020,   /* U+46DD */
  0x0020,   /* U+46DE */
  0x0020,   /* U+46DF */
  0x0020,   /* U+46E0 */
  0x0020,   /* U+46E1 */
  0x0020,   /* U+46E2 */
  0x0020,   /* U+46E3 */
  0x0020,   /* U+46E4 */
  0x0020,   /* U+46E5 */
  0x0020,   /* U+46E6 */
  0x0020,   /* U+46E7 */
  0x0020,   /* U+46E8 */
  0x0020,   /* U+46E9 */
  0x0020,   /* U+46EA */
  0x0020,   /* U+46EB */
  0x0020,   /* U+46EC */
  0x0020,   /* U+46ED */
  0x0020,   /* U+46EE */
  0x0020,   /* U+46EF */
  0x0020,   /* U+46F0 */
  0x0020,   /* U+46F1 */
  0x0020,   /* U+46F2 */
  0x0020,   /* U+46F3 */
  0x0020,   /* U+46F4 */
  0x0020,   /* U+46F5 */
  0x0020,   /* U+46F6 */
  0x0020,   /* U+46F7 */
  0x0020,   /* U+46F8 */
  0x0020,   /* U+46F9 */
  0x0020,   /* U+46FA */
  0x0020,   /* U+46FB */
  0x0020,   /* U+46FC */
  0x0020,   /* U+46FD */
  0x0020,   /* U+46FE */
  0x0020,   /* U+46FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4600 */
  0x0002,   /* U+4601 */
  0x0002,   /* U+4602 */
  0x0002,   /* U+4603 */
  0x0002,   /* U+4604 */
  0x0002,   /* U+4605 */
  0x0002,   /* U+4606 */
  0x0002,   /* U+4607 */
  0x0002,   /* U+4608 */
  0x0002,   /* U+4609 */
  0x0002,   /* U+460A */
  0x0002,   /* U+460B */
  0x0002,   /* U+460C */
  0x0002,   /* U+460D */
  0x0002,   /* U+460E */
  0x0002,   /* U+460F */
  0x0002,   /* U+4610 */
  0x0002,   /* U+4611 */
  0x0002,   /* U+4612 */
  0x0002,   /* U+4613 */
  0x0002,   /* U+4614 */
  0x0002,   /* U+4615 */
  0x0002,   /* U+4616 */
  0x0002,   /* U+4617 */
  0x0002,   /* U+4618 */
  0x0002,   /* U+4619 */
  0x0002,   /* U+461A */
  0x0002,   /* U+461B */
  0x0002,   /* U+461C */
  0x0002,   /* U+461D */
  0x0002,   /* U+461E */
  0x0002,   /* U+461F */
  0x0002,   /* U+4620 */
  0x0002,   /* U+4621 */
  0x0002,   /* U+4622 */
  0x0002,   /* U+4623 */
  0x0002,   /* U+4624 */
  0x0002,   /* U+4625 */
  0x0002,   /* U+4626 */
  0x0002,   /* U+4627 */
  0x0002,   /* U+4628 */
  0x0002,   /* U+4629 */
  0x0002,   /* U+462A */
  0x0002,   /* U+462B */
  0x0002,   /* U+462C */
  0x0002,   /* U+462D */
  0x0002,   /* U+462E */
  0x0002,   /* U+462F */
  0x0002,   /* U+4630 */
  0x0002,   /* U+4631 */
  0x0002,   /* U+4632 */
  0x0002,   /* U+4633 */
  0x0002,   /* U+4634 */
  0x0002,   /* U+4635 */
  0x0002,   /* U+4636 */
  0x0002,   /* U+4637 */
  0x0002,   /* U+4638 */
  0x0002,   /* U+4639 */
  0x0002,   /* U+463A */
  0x0002,   /* U+463B */
  0x0002,   /* U+463C */
  0x0002,   /* U+463D */
  0x0002,   /* U+463E */
  0x0002,   /* U+463F */
  0x0002,   /* U+4640 */
  0x0002,   /* U+4641 */
  0x0002,   /* U+4642 */
  0x0002,   /* U+4643 */
  0x0002,   /* U+4644 */
  0x0002,   /* U+4645 */
  0x0002,   /* U+4646 */
  0x0002,   /* U+4647 */
  0x0002,   /* U+4648 */
  0x0002,   /* U+4649 */
  0x0002,   /* U+464A */
  0x0002,   /* U+464B */
  0x0002,   /* U+464C */
  0x0002,   /* U+464D */
  0x0002,   /* U+464E */
  0x0002,   /* U+464F */
  0x0002,   /* U+4650 */
  0x0002,   /* U+4651 */
  0x0002,   /* U+4652 */
  0x0002,   /* U+4653 */
  0x0002,   /* U+4654 */
  0x0002,   /* U+4655 */
  0x0002,   /* U+4656 */
  0x0002,   /* U+4657 */
  0x0002,   /* U+4658 */
  0x0002,   /* U+4659 */
  0x0002,   /* U+465A */
  0x0002,   /* U+465B */
  0x0002,   /* U+465C */
  0x0002,   /* U+465D */
  0x0002,   /* U+465E */
  0x0002,   /* U+465F */
  0x0002,   /* U+4660 */
  0x0002,   /* U+4661 */
  0x0002,   /* U+4662 */
  0x0002,   /* U+4663 */
  0x0002,   /* U+4664 */
  0x0002,   /* U+4665 */
  0x0002,   /* U+4666 */
  0x0002,   /* U+4667 */
  0x0002,   /* U+4668 */
  0x0002,   /* U+4669 */
  0x0002,   /* U+466A */
  0x0002,   /* U+466B */
  0x0002,   /* U+466C */
  0x0002,   /* U+466D */
  0x0002,   /* U+466E */
  0x0002,   /* U+466F */
  0x0002,   /* U+4670 */
  0x0002,   /* U+4671 */
  0x0002,   /* U+4672 */
  0x0002,   /* U+4673 */
  0x0002,   /* U+4674 */
  0x0002,   /* U+4675 */
  0x0002,   /* U+4676 */
  0x0002,   /* U+4677 */
  0x0002,   /* U+4678 */
  0x0002,   /* U+4679 */
  0x0002,   /* U+467A */
  0x0002,   /* U+467B */
  0x0002,   /* U+467C */
  0x0002,   /* U+467D */
  0x0002,   /* U+467E */
  0x0002,   /* U+467F */
  0x0002,   /* U+4680 */
  0x0002,   /* U+4681 */
  0x0002,   /* U+4682 */
  0x0002,   /* U+4683 */
  0x0002,   /* U+4684 */
  0x0002,   /* U+4685 */
  0x0002,   /* U+4686 */
  0x0002,   /* U+4687 */
  0x0002,   /* U+4688 */
  0x0002,   /* U+4689 */
  0x0002,   /* U+468A */
  0x0002,   /* U+468B */
  0x0002,   /* U+468C */
  0x0002,   /* U+468D */
  0x0002,   /* U+468E */
  0x0002,   /* U+468F */
  0x0002,   /* U+4690 */
  0x0002,   /* U+4691 */
  0x0002,   /* U+4692 */
  0x0002,   /* U+4693 */
  0x0002,   /* U+4694 */
  0x0002,   /* U+4695 */
  0x0002,   /* U+4696 */
  0x0002,   /* U+4697 */
  0x0002,   /* U+4698 */
  0x0002,   /* U+4699 */
  0x0002,   /* U+469A */
  0x0002,   /* U+469B */
  0x0002,   /* U+469C */
  0x0002,   /* U+469D */
  0x0002,   /* U+469E */
  0x0002,   /* U+469F */
  0x0002,   /* U+46A0 */
  0x0002,   /* U+46A1 */
  0x0002,   /* U+46A2 */
  0x0002,   /* U+46A3 */
  0x0002,   /* U+46A4 */
  0x0002,   /* U+46A5 */
  0x0002,   /* U+46A6 */
  0x0002,   /* U+46A7 */
  0x0002,   /* U+46A8 */
  0x0002,   /* U+46A9 */
  0x0002,   /* U+46AA */
  0x0002,   /* U+46AB */
  0x0002,   /* U+46AC */
  0x0002,   /* U+46AD */
  0x0002,   /* U+46AE */
  0x0002,   /* U+46AF */
  0x0002,   /* U+46B0 */
  0x0002,   /* U+46B1 */
  0x0002,   /* U+46B2 */
  0x0002,   /* U+46B3 */
  0x0002,   /* U+46B4 */
  0x0002,   /* U+46B5 */
  0x0002,   /* U+46B6 */
  0x0002,   /* U+46B7 */
  0x0002,   /* U+46B8 */
  0x0002,   /* U+46B9 */
  0x0002,   /* U+46BA */
  0x0002,   /* U+46BB */
  0x0002,   /* U+46BC */
  0x0002,   /* U+46BD */
  0x0002,   /* U+46BE */
  0x0002,   /* U+46BF */
  0x0002,   /* U+46C0 */
  0x0002,   /* U+46C1 */
  0x0002,   /* U+46C2 */
  0x0002,   /* U+46C3 */
  0x0002,   /* U+46C4 */
  0x0002,   /* U+46C5 */
  0x0002,   /* U+46C6 */
  0x0002,   /* U+46C7 */
  0x0002,   /* U+46C8 */
  0x0002,   /* U+46C9 */
  0x0002,   /* U+46CA */
  0x0002,   /* U+46CB */
  0x0002,   /* U+46CC */
  0x0002,   /* U+46CD */
  0x0002,   /* U+46CE */
  0x0002,   /* U+46CF */
  0x0002,   /* U+46D0 */
  0x0002,   /* U+46D1 */
  0x0002,   /* U+46D2 */
  0x0002,   /* U+46D3 */
  0x0002,   /* U+46D4 */
  0x0002,   /* U+46D5 */
  0x0002,   /* U+46D6 */
  0x0002,   /* U+46D7 */
  0x0002,   /* U+46D8 */
  0x0002,   /* U+46D9 */
  0x0002,   /* U+46DA */
  0x0002,   /* U+46DB */
  0x0002,   /* U+46DC */
  0x0002,   /* U+46DD */
  0x0002,   /* U+46DE */
  0x0002,   /* U+46DF */
  0x0002,   /* U+46E0 */
  0x0002,   /* U+46E1 */
  0x0002,   /* U+46E2 */
  0x0002,   /* U+46E3 */
  0x0002,   /* U+46E4 */
  0x0002,   /* U+46E5 */
  0x0002,   /* U+46E6 */
  0x0002,   /* U+46E7 */
  0x0002,   /* U+46E8 */
  0x0002,   /* U+46E9 */
  0x0002,   /* U+46EA */
  0x0002,   /* U+46EB */
  0x0002,   /* U+46EC */
  0x0002,   /* U+46ED */
  0x0002,   /* U+46EE */
  0x0002,   /* U+46EF */
  0x0002,   /* U+46F0 */
  0x0002,   /* U+46F1 */
  0x0002,   /* U+46F2 */
  0x0002,   /* U+46F3 */
  0x0002,   /* U+46F4 */
  0x0002,   /* U+46F5 */
  0x0002,   /* U+46F6 */
  0x0002,   /* U+46F7 */
  0x0002,   /* U+46F8 */
  0x0002,   /* U+46F9 */
  0x0002,   /* U+46FA */
  0x0002,   /* U+46FB */
  0x0002,   /* U+46FC */
  0x0002,   /* U+46FD */
  0x0002,   /* U+46FE */
  0x0002,   /* U+46FF */

  /* Primary weight 2 for each character. */
  0x8004,   /* U+4600 */
  0x8005,   /* U+4601 */
  0x8000,   /* U+4602 */
  0x8001,   /* U+4603 */
  0x8002,   /* U+4604 */
  0x8000,   /* U+4605 */
  0x8001,   /* U+4606 */
  0x8002,   /* U+4607 */
  0x8003,   /* U+4608 */
  0x8004,   /* U+4609 */
  0x8000,   /* U+460A */
  0x8001,   /* U+460B */
  0x8002,   /* U+460C */
  0x8000,   /* U+460D */
  0x8000,   /* U+460E */
  0x8000,   /* U+460F */
  0x8000,   /* U+4610 */
  0x8000,   /* U+4611 */
  0x8000,   /* U+4612 */
  0x8000,   /* U+4613 */
  0x8000,   /* U+4614 */
  0x8000,   /* U+4615 */
  0xC616,   /* U+4616 */
  0x8000,   /* U+4617 */
  0x8001,   /* U+4618 */
  0x8000,   /* U+4619 */
  0x8000,   /* U+461A */
  0x8001,   /* U+461B */
  0x8000,   /* U+461C */
  0x8001,   /* U+461D */
  0x8002,   /* U+461E */
  0x8000,   /* U+461F */
  0x8001,   /* U+4620 */
  0x8002,   /* U+4621 */
  0x8000,   /* U+4622 */
  0x8001,   /* U+4623 */
  0x8002,   /* U+4624 */
  0x8003,   /* U+4625 */
  0x8004,   /* U+4626 */
  0x8005,   /* U+4627 */
  0x8000,   /* U+4628 */
  0x8001,   /* U+4629 */
  0x8002,   /* U+462A */
  0x8003,   /* U+462B */
  0x8004,   /* U+462C */
  0x8005,   /* U+462D */
  0x8006,   /* U+462E */
  0x8000,   /* U+462F */
  0x8001,   /* U+4630 */
  0x8002,   /* U+4631 */
  0x8003,   /* U+4632 */
  0x8000,   /* U+4633 */
  0x8001,   /* U+4634 */
  0x8002,   /* U+4635 */
  0x8003,   /* U+4636 */
  0x8004,   /* U+4637 */
  0x8005,   /* U+4638 */
  0x8006,   /* U+4639 */
  0x8007,   /* U+463A */
  0x8008,   /* U+463B */
  0x8009,   /* U+463C */
  0x800A,   /* U+463D */
  0x800B,   /* U+463E */
  0x800C,   /* U+463F */
  0x800D,   /* U+4640 */
  0x800E,   /* U+4641 */
  0x800F,   /* U+4642 */
  0x8000,   /* U+4643 */
  0x8001,   /* U+4644 */
  0x8002,   /* U+4645 */
  0x8003,   /* U+4646 */
  0x8004,   /* U+4647 */
  0x8005,   /* U+4648 */
  0x8006,   /* U+4649 */
  0x8007,   /* U+464A */
  0x8008,   /* U+464B */
  0x8009,   /* U+464C */
  0xC64D,   /* U+464D */
  0x8000,   /* U+464E */
  0x8001,   /* U+464F */
  0x8002,   /* U+4650 */
  0x8003,   /* U+4651 */
  0x8004,   /* U+4652 */
  0x8005,   /* U+4653 */
  0x8000,   /* U+4654 */
  0x8001,   /* U+4655 */
  0x8002,   /* U+4656 */
  0x8003,   /* U+4657 */
  0x8004,   /* U+4658 */
  0x8005,   /* U+4659 */
  0x8006,   /* U+465A */
  0x8007,   /* U+465B */
  0x8008,   /* U+465C */
  0xC65D,   /* U+465D */
  0x8000,   /* U+465E */
  0x8001,   /* U+465F */
  0x8002,   /* U+4660 */
  0x8003,   /* U+4661 */
  0x8004,   /* U+4662 */
  0x8005,   /* U+4663 */
  0x8000,   /* U+4664 */
  0x8001,   /* U+4665 */
  0x8000,   /* U+4666 */
  0x8001,   /* U+4667 */
  0x8002,   /* U+4668 */
  0x8003,   /* U+4669 */
  0x8000,   /* U+466A */
  0x8000,   /* U+466B */
  0x8000,   /* U+466C */
  0x8001,   /* U+466D */
  0x8000,   /* U+466E */
  0x8001,   /* U+466F */
  0x8000,   /* U+4670 */
  0x8000,   /* U+4671 */
  0x8000,   /* U+4672 */
  0x8000,   /* U+4673 */
  0x8000,   /* U+4674 */
  0x8000,   /* U+4675 */
  0x8001,   /* U+4676 */
  0x8001,   /* U+4677 */
  0x8002,   /* U+4678 */
  0x8002,   /* U+4679 */
  0x8003,   /* U+467A */
  0x8004,   /* U+467B */
  0x8008,   /* U+467C */
  0x8009,   /* U+467D */
  0x800A,   /* U+467E */
  0x800B,   /* U+467F */
  0x8004,   /* U+4680 */
  0x8005,   /* U+4681 */
  0x8002,   /* U+4682 */
  0x8003,   /* U+4683 */
  0x8003,   /* U+4684 */
  0x8004,   /* U+4685 */
  0x8005,   /* U+4686 */
  0x8006,   /* U+4687 */
  0x8007,   /* U+4688 */
  0x8008,   /* U+4689 */
  0x8000,   /* U+468A */
  0x8001,   /* U+468B */
  0x8002,   /* U+468C */
  0x8004,   /* U+468D */
  0x8005,   /* U+468E */
  0x8001,   /* U+468F */
  0x8002,   /* U+4690 */
  0x8003,   /* U+4691 */
  0x8004,   /* U+4692 */
  0x8005,   /* U+4693 */
  0x8000,   /* U+4694 */
  0x8000,   /* U+4695 */
  0x8000,   /* U+4696 */
  0x8000,   /* U+4697 */
  0x8000,   /* U+4698 */
  0x8001,   /* U+4699 */
  0x8002,   /* U+469A */
  0x8000,   /* U+469B */
  0x8000,   /* U+469C */
  0x8001,   /* U+469D */
  0x8002,   /* U+469E */
  0x8003,   /* U+469F */
  0x8004,   /* U+46A0 */
  0x8000,   /* U+46A1 */
  0x8001,   /* U+46A2 */
  0x8002,   /* U+46A3 */
  0xC6A4,   /* U+46A4 */
  0x8000,   /* U+46A5 */
  0x8001,   /* U+46A6 */
  0x8000,   /* U+46A7 */
  0x8000,   /* U+46A8 */
  0x8001,   /* U+46A9 */
  0x8000,   /* U+46AA */
  0x8001,   /* U+46AB */
  0x8002,   /* U+46AC */
  0x8000,   /* U+46AD */
  0x8005,   /* U+46AE */
  0x8006,   /* U+46AF */
  0x8007,   /* U+46B0 */
  0x800F,   /* U+46B1 */
  0x8010,   /* U+46B2 */
  0x8018,   /* U+46B3 */
  0x8019,   /* U+46B4 */
  0x801A,   /* U+46B5 */
  0x801B,   /* U+46B6 */
  0x801C,   /* U+46B7 */
  0x801D,   /* U+46B8 */
  0x801E,   /* U+46B9 */
  0x801F,   /* U+46BA */
  0x8020,   /* U+46BB */
  0x8021,   /* U+46BC */
  0x8022,   /* U+46BD */
  0x8023,   /* U+46BE */
  0x8024,   /* U+46BF */
  0x8025,   /* U+46C0 */
  0x8026,   /* U+46C1 */
  0x8027,   /* U+46C2 */
  0x8028,   /* U+46C3 */
  0x8022,   /* U+46C4 */
  0x8023,   /* U+46C5 */
  0x8024,   /* U+46C6 */
  0x8025,   /* U+46C7 */
  0x8026,   /* U+46C8 */
  0x8027,   /* U+46C9 */
  0x8028,   /* U+46CA */
  0x8029,   /* U+46CB */
  0x802A,   /* U+46CC */
  0x802B,   /* U+46CD */
  0x802C,   /* U+46CE */
  0x802D,   /* U+46CF */
  0x802E,   /* U+46D0 */
  0x802F,   /* U+46D1 */
  0x8030,   /* U+46D2 */
  0x8031,   /* U+46D3 */
  0x8029,   /* U+46D4 */
  0x802A,   /* U+46D5 */
  0x802B,   /* U+46D6 */
  0x802C,   /* U+46D7 */
  0x802D,   /* U+46D8 */
  0x802E,   /* U+46D9 */
  0x802F,   /* U+46DA */
  0x8030,   /* U+46DB */
  0x8031,   /* U+46DC */
  0x801B,   /* U+46DD */
  0x801C,   /* U+46DE */
  0x801D,   /* U+46DF */
  0x801E,   /* U+46E0 */
  0x801F,   /* U+46E1 */
  0x8020,   /* U+46E2 */
  0x8021,   /* U+46E3 */
  0x8022,   /* U+46E4 */
  0x8023,   /* U+46E5 */
  0x8024,   /* U+46E6 */
  0x8025,   /* U+46E7 */
  0x8026,   /* U+46E8 */
  0x8025,   /* U+46E9 */
  0x8026,   /* U+46EA */
  0x8027,   /* U+46EB */
  0x8028,   /* U+46EC */
  0x8029,   /* U+46ED */
  0x802A,   /* U+46EE */
  0x802B,   /* U+46EF */
  0x802C,   /* U+46F0 */
  0x802D,   /* U+46F1 */
  0x802E,   /* U+46F2 */
  0x802F,   /* U+46F3 */
  0x8030,   /* U+46F4 */
  0x8031,   /* U+46F5 */
  0x8032,   /* U+46F6 */
  0x8033,   /* U+46F7 */
  0x8034,   /* U+46F8 */
  0x8023,   /* U+46F9 */
  0x8024,   /* U+46FA */
  0x8025,   /* U+46FB */
  0x8026,   /* U+46FC */
  0x8027,   /* U+46FD */
  0x8000,   /* U+46FE */
  0x8001,   /* U+46FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4600 */
  0x0000,   /* U+4601 */
  0x0000,   /* U+4602 */
  0x0000,   /* U+4603 */
  0x0000,   /* U+4604 */
  0x0000,   /* U+4605 */
  0x0000,   /* U+4606 */
  0x0000,   /* U+4607 */
  0x0000,   /* U+4608 */
  0x0000,   /* U+4609 */
  0x0000,   /* U+460A */
  0x0000,   /* U+460B */
  0x0000,   /* U+460C */
  0x0000,   /* U+460D */
  0x0000,   /* U+460E */
  0x0000,   /* U+460F */
  0x0000,   /* U+4610 */
  0x0000,   /* U+4611 */
  0x0000,   /* U+4612 */
  0x0000,   /* U+4613 */
  0x0000,   /* U+4614 */
  0x0000,   /* U+4615 */
  0x0000,   /* U+4616 */
  0x0000,   /* U+4617 */
  0x0000,   /* U+4618 */
  0x0000,   /* U+4619 */
  0x0000,   /* U+461A */
  0x0000,   /* U+461B */
  0x0000,   /* U+461C */
  0x0000,   /* U+461D */
  0x0000,   /* U+461E */
  0x0000,   /* U+461F */
  0x0000,   /* U+4620 */
  0x0000,   /* U+4621 */
  0x0000,   /* U+4622 */
  0x0000,   /* U+4623 */
  0x0000,   /* U+4624 */
  0x0000,   /* U+4625 */
  0x0000,   /* U+4626 */
  0x0000,   /* U+4627 */
  0x0000,   /* U+4628 */
  0x0000,   /* U+4629 */
  0x0000,   /* U+462A */
  0x0000,   /* U+462B */
  0x0000,   /* U+462C */
  0x0000,   /* U+462D */
  0x0000,   /* U+462E */
  0x0000,   /* U+462F */
  0x0000,   /* U+4630 */
  0x0000,   /* U+4631 */
  0x0000,   /* U+4632 */
  0x0000,   /* U+4633 */
  0x0000,   /* U+4634 */
  0x0000,   /* U+4635 */
  0x0000,   /* U+4636 */
  0x0000,   /* U+4637 */
  0x0000,   /* U+4638 */
  0x0000,   /* U+4639 */
  0x0000,   /* U+463A */
  0x0000,   /* U+463B */
  0x0000,   /* U+463C */
  0x0000,   /* U+463D */
  0x0000,   /* U+463E */
  0x0000,   /* U+463F */
  0x0000,   /* U+4640 */
  0x0000,   /* U+4641 */
  0x0000,   /* U+4642 */
  0x0000,   /* U+4643 */
  0x0000,   /* U+4644 */
  0x0000,   /* U+4645 */
  0x0000,   /* U+4646 */
  0x0000,   /* U+4647 */
  0x0000,   /* U+4648 */
  0x0000,   /* U+4649 */
  0x0000,   /* U+464A */
  0x0000,   /* U+464B */
  0x0000,   /* U+464C */
  0x0000,   /* U+464D */
  0x0000,   /* U+464E */
  0x0000,   /* U+464F */
  0x0000,   /* U+4650 */
  0x0000,   /* U+4651 */
  0x0000,   /* U+4652 */
  0x0000,   /* U+4653 */
  0x0000,   /* U+4654 */
  0x0000,   /* U+4655 */
  0x0000,   /* U+4656 */
  0x0000,   /* U+4657 */
  0x0000,   /* U+4658 */
  0x0000,   /* U+4659 */
  0x0000,   /* U+465A */
  0x0000,   /* U+465B */
  0x0000,   /* U+465C */
  0x0000,   /* U+465D */
  0x0000,   /* U+465E */
  0x0000,   /* U+465F */
  0x0000,   /* U+4660 */
  0x0000,   /* U+4661 */
  0x0000,   /* U+4662 */
  0x0000,   /* U+4663 */
  0x0000,   /* U+4664 */
  0x0000,   /* U+4665 */
  0x0000,   /* U+4666 */
  0x0000,   /* U+4667 */
  0x0000,   /* U+4668 */
  0x0000,   /* U+4669 */
  0x0000,   /* U+466A */
  0x0000,   /* U+466B */
  0x0000,   /* U+466C */
  0x0000,   /* U+466D */
  0x0000,   /* U+466E */
  0x0000,   /* U+466F */
  0x0000,   /* U+4670 */
  0x0000,   /* U+4671 */
  0x0000,   /* U+4672 */
  0x0000,   /* U+4673 */
  0x0000,   /* U+4674 */
  0x0000,   /* U+4675 */
  0x0000,   /* U+4676 */
  0x0000,   /* U+4677 */
  0x0000,   /* U+4678 */
  0x0000,   /* U+4679 */
  0x0000,   /* U+467A */
  0x0000,   /* U+467B */
  0x0000,   /* U+467C */
  0x0000,   /* U+467D */
  0x0000,   /* U+467E */
  0x0000,   /* U+467F */
  0x0000,   /* U+4680 */
  0x0000,   /* U+4681 */
  0x0000,   /* U+4682 */
  0x0000,   /* U+4683 */
  0x0000,   /* U+4684 */
  0x0000,   /* U+4685 */
  0x0000,   /* U+4686 */
  0x0000,   /* U+4687 */
  0x0000,   /* U+4688 */
  0x0000,   /* U+4689 */
  0x0000,   /* U+468A */
  0x0000,   /* U+468B */
  0x0000,   /* U+468C */
  0x0000,   /* U+468D */
  0x0000,   /* U+468E */
  0x0000,   /* U+468F */
  0x0000,   /* U+4690 */
  0x0000,   /* U+4691 */
  0x0000,   /* U+4692 */
  0x0000,   /* U+4693 */
  0x0000,   /* U+4694 */
  0x0000,   /* U+4695 */
  0x0000,   /* U+4696 */
  0x0000,   /* U+4697 */
  0x0000,   /* U+4698 */
  0x0000,   /* U+4699 */
  0x0000,   /* U+469A */
  0x0000,   /* U+469B */
  0x0000,   /* U+469C */
  0x0000,   /* U+469D */
  0x0000,   /* U+469E */
  0x0000,   /* U+469F */
  0x0000,   /* U+46A0 */
  0x0000,   /* U+46A1 */
  0x0000,   /* U+46A2 */
  0x0000,   /* U+46A3 */
  0x0000,   /* U+46A4 */
  0x0000,   /* U+46A5 */
  0x0000,   /* U+46A6 */
  0x0000,   /* U+46A7 */
  0x0000,   /* U+46A8 */
  0x0000,   /* U+46A9 */
  0x0000,   /* U+46AA */
  0x0000,   /* U+46AB */
  0x0000,   /* U+46AC */
  0x0000,   /* U+46AD */
  0x0000,   /* U+46AE */
  0x0000,   /* U+46AF */
  0x0000,   /* U+46B0 */
  0x0000,   /* U+46B1 */
  0x0000,   /* U+46B2 */
  0x0000,   /* U+46B3 */
  0x0000,   /* U+46B4 */
  0x0000,   /* U+46B5 */
  0x0000,   /* U+46B6 */
  0x0000,   /* U+46B7 */
  0x0000,   /* U+46B8 */
  0x0000,   /* U+46B9 */
  0x0000,   /* U+46BA */
  0x0000,   /* U+46BB */
  0x0000,   /* U+46BC */
  0x0000,   /* U+46BD */
  0x0000,   /* U+46BE */
  0x0000,   /* U+46BF */
  0x0000,   /* U+46C0 */
  0x0000,   /* U+46C1 */
  0x0000,   /* U+46C2 */
  0x0000,   /* U+46C3 */
  0x0000,   /* U+46C4 */
  0x0000,   /* U+46C5 */
  0x0000,   /* U+46C6 */
  0x0000,   /* U+46C7 */
  0x0000,   /* U+46C8 */
  0x0000,   /* U+46C9 */
  0x0000,   /* U+46CA */
  0x0000,   /* U+46CB */
  0x0000,   /* U+46CC */
  0x0000,   /* U+46CD */
  0x0000,   /* U+46CE */
  0x0000,   /* U+46CF */
  0x0000,   /* U+46D0 */
  0x0000,   /* U+46D1 */
  0x0000,   /* U+46D2 */
  0x0000,   /* U+46D3 */
  0x0000,   /* U+46D4 */
  0x0000,   /* U+46D5 */
  0x0000,   /* U+46D6 */
  0x0000,   /* U+46D7 */
  0x0000,   /* U+46D8 */
  0x0000,   /* U+46D9 */
  0x0000,   /* U+46DA */
  0x0000,   /* U+46DB */
  0x0000,   /* U+46DC */
  0x0000,   /* U+46DD */
  0x0000,   /* U+46DE */
  0x0000,   /* U+46DF */
  0x0000,   /* U+46E0 */
  0x0000,   /* U+46E1 */
  0x0000,   /* U+46E2 */
  0x0000,   /* U+46E3 */
  0x0000,   /* U+46E4 */
  0x0000,   /* U+46E5 */
  0x0000,   /* U+46E6 */
  0x0000,   /* U+46E7 */
  0x0000,   /* U+46E8 */
  0x0000,   /* U+46E9 */
  0x0000,   /* U+46EA */
  0x0000,   /* U+46EB */
  0x0000,   /* U+46EC */
  0x0000,   /* U+46ED */
  0x0000,   /* U+46EE */
  0x0000,   /* U+46EF */
  0x0000,   /* U+46F0 */
  0x0000,   /* U+46F1 */
  0x0000,   /* U+46F2 */
  0x0000,   /* U+46F3 */
  0x0000,   /* U+46F4 */
  0x0000,   /* U+46F5 */
  0x0000,   /* U+46F6 */
  0x0000,   /* U+46F7 */
  0x0000,   /* U+46F8 */
  0x0000,   /* U+46F9 */
  0x0000,   /* U+46FA */
  0x0000,   /* U+46FB */
  0x0000,   /* U+46FC */
  0x0000,   /* U+46FD */
  0x0000,   /* U+46FE */
  0x0000,   /* U+46FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4600 */
  0x0000,   /* U+4601 */
  0x0000,   /* U+4602 */
  0x0000,   /* U+4603 */
  0x0000,   /* U+4604 */
  0x0000,   /* U+4605 */
  0x0000,   /* U+4606 */
  0x0000,   /* U+4607 */
  0x0000,   /* U+4608 */
  0x0000,   /* U+4609 */
  0x0000,   /* U+460A */
  0x0000,   /* U+460B */
  0x0000,   /* U+460C */
  0x0000,   /* U+460D */
  0x0000,   /* U+460E */
  0x0000,   /* U+460F */
  0x0000,   /* U+4610 */
  0x0000,   /* U+4611 */
  0x0000,   /* U+4612 */
  0x0000,   /* U+4613 */
  0x0000,   /* U+4614 */
  0x0000,   /* U+4615 */
  0x0000,   /* U+4616 */
  0x0000,   /* U+4617 */
  0x0000,   /* U+4618 */
  0x0000,   /* U+4619 */
  0x0000,   /* U+461A */
  0x0000,   /* U+461B */
  0x0000,   /* U+461C */
  0x0000,   /* U+461D */
  0x0000,   /* U+461E */
  0x0000,   /* U+461F */
  0x0000,   /* U+4620 */
  0x0000,   /* U+4621 */
  0x0000,   /* U+4622 */
  0x0000,   /* U+4623 */
  0x0000,   /* U+4624 */
  0x0000,   /* U+4625 */
  0x0000,   /* U+4626 */
  0x0000,   /* U+4627 */
  0x0000,   /* U+4628 */
  0x0000,   /* U+4629 */
  0x0000,   /* U+462A */
  0x0000,   /* U+462B */
  0x0000,   /* U+462C */
  0x0000,   /* U+462D */
  0x0000,   /* U+462E */
  0x0000,   /* U+462F */
  0x0000,   /* U+4630 */
  0x0000,   /* U+4631 */
  0x0000,   /* U+4632 */
  0x0000,   /* U+4633 */
  0x0000,   /* U+4634 */
  0x0000,   /* U+4635 */
  0x0000,   /* U+4636 */
  0x0000,   /* U+4637 */
  0x0000,   /* U+4638 */
  0x0000,   /* U+4639 */
  0x0000,   /* U+463A */
  0x0000,   /* U+463B */
  0x0000,   /* U+463C */
  0x0000,   /* U+463D */
  0x0000,   /* U+463E */
  0x0000,   /* U+463F */
  0x0000,   /* U+4640 */
  0x0000,   /* U+4641 */
  0x0000,   /* U+4642 */
  0x0000,   /* U+4643 */
  0x0000,   /* U+4644 */
  0x0000,   /* U+4645 */
  0x0000,   /* U+4646 */
  0x0000,   /* U+4647 */
  0x0000,   /* U+4648 */
  0x0000,   /* U+4649 */
  0x0000,   /* U+464A */
  0x0000,   /* U+464B */
  0x0000,   /* U+464C */
  0x0000,   /* U+464D */
  0x0000,   /* U+464E */
  0x0000,   /* U+464F */
  0x0000,   /* U+4650 */
  0x0000,   /* U+4651 */
  0x0000,   /* U+4652 */
  0x0000,   /* U+4653 */
  0x0000,   /* U+4654 */
  0x0000,   /* U+4655 */
  0x0000,   /* U+4656 */
  0x0000,   /* U+4657 */
  0x0000,   /* U+4658 */
  0x0000,   /* U+4659 */
  0x0000,   /* U+465A */
  0x0000,   /* U+465B */
  0x0000,   /* U+465C */
  0x0000,   /* U+465D */
  0x0000,   /* U+465E */
  0x0000,   /* U+465F */
  0x0000,   /* U+4660 */
  0x0000,   /* U+4661 */
  0x0000,   /* U+4662 */
  0x0000,   /* U+4663 */
  0x0000,   /* U+4664 */
  0x0000,   /* U+4665 */
  0x0000,   /* U+4666 */
  0x0000,   /* U+4667 */
  0x0000,   /* U+4668 */
  0x0000,   /* U+4669 */
  0x0000,   /* U+466A */
  0x0000,   /* U+466B */
  0x0000,   /* U+466C */
  0x0000,   /* U+466D */
  0x0000,   /* U+466E */
  0x0000,   /* U+466F */
  0x0000,   /* U+4670 */
  0x0000,   /* U+4671 */
  0x0000,   /* U+4672 */
  0x0000,   /* U+4673 */
  0x0000,   /* U+4674 */
  0x0000,   /* U+4675 */
  0x0000,   /* U+4676 */
  0x0000,   /* U+4677 */
  0x0000,   /* U+4678 */
  0x0000,   /* U+4679 */
  0x0000,   /* U+467A */
  0x0000,   /* U+467B */
  0x0000,   /* U+467C */
  0x0000,   /* U+467D */
  0x0000,   /* U+467E */
  0x0000,   /* U+467F */
  0x0000,   /* U+4680 */
  0x0000,   /* U+4681 */
  0x0000,   /* U+4682 */
  0x0000,   /* U+4683 */
  0x0000,   /* U+4684 */
  0x0000,   /* U+4685 */
  0x0000,   /* U+4686 */
  0x0000,   /* U+4687 */
  0x0000,   /* U+4688 */
  0x0000,   /* U+4689 */
  0x0000,   /* U+468A */
  0x0000,   /* U+468B */
  0x0000,   /* U+468C */
  0x0000,   /* U+468D */
  0x0000,   /* U+468E */
  0x0000,   /* U+468F */
  0x0000,   /* U+4690 */
  0x0000,   /* U+4691 */
  0x0000,   /* U+4692 */
  0x0000,   /* U+4693 */
  0x0000,   /* U+4694 */
  0x0000,   /* U+4695 */
  0x0000,   /* U+4696 */
  0x0000,   /* U+4697 */
  0x0000,   /* U+4698 */
  0x0000,   /* U+4699 */
  0x0000,   /* U+469A */
  0x0000,   /* U+469B */
  0x0000,   /* U+469C */
  0x0000,   /* U+469D */
  0x0000,   /* U+469E */
  0x0000,   /* U+469F */
  0x0000,   /* U+46A0 */
  0x0000,   /* U+46A1 */
  0x0000,   /* U+46A2 */
  0x0000,   /* U+46A3 */
  0x0000,   /* U+46A4 */
  0x0000,   /* U+46A5 */
  0x0000,   /* U+46A6 */
  0x0000,   /* U+46A7 */
  0x0000,   /* U+46A8 */
  0x0000,   /* U+46A9 */
  0x0000,   /* U+46AA */
  0x0000,   /* U+46AB */
  0x0000,   /* U+46AC */
  0x0000,   /* U+46AD */
  0x0000,   /* U+46AE */
  0x0000,   /* U+46AF */
  0x0000,   /* U+46B0 */
  0x0000,   /* U+46B1 */
  0x0000,   /* U+46B2 */
  0x0000,   /* U+46B3 */
  0x0000,   /* U+46B4 */
  0x0000,   /* U+46B5 */
  0x0000,   /* U+46B6 */
  0x0000,   /* U+46B7 */
  0x0000,   /* U+46B8 */
  0x0000,   /* U+46B9 */
  0x0000,   /* U+46BA */
  0x0000,   /* U+46BB */
  0x0000,   /* U+46BC */
  0x0000,   /* U+46BD */
  0x0000,   /* U+46BE */
  0x0000,   /* U+46BF */
  0x0000,   /* U+46C0 */
  0x0000,   /* U+46C1 */
  0x0000,   /* U+46C2 */
  0x0000,   /* U+46C3 */
  0x0000,   /* U+46C4 */
  0x0000,   /* U+46C5 */
  0x0000,   /* U+46C6 */
  0x0000,   /* U+46C7 */
  0x0000,   /* U+46C8 */
  0x0000,   /* U+46C9 */
  0x0000,   /* U+46CA */
  0x0000,   /* U+46CB */
  0x0000,   /* U+46CC */
  0x0000,   /* U+46CD */
  0x0000,   /* U+46CE */
  0x0000,   /* U+46CF */
  0x0000,   /* U+46D0 */
  0x0000,   /* U+46D1 */
  0x0000,   /* U+46D2 */
  0x0000,   /* U+46D3 */
  0x0000,   /* U+46D4 */
  0x0000,   /* U+46D5 */
  0x0000,   /* U+46D6 */
  0x0000,   /* U+46D7 */
  0x0000,   /* U+46D8 */
  0x0000,   /* U+46D9 */
  0x0000,   /* U+46DA */
  0x0000,   /* U+46DB */
  0x0000,   /* U+46DC */
  0x0000,   /* U+46DD */
  0x0000,   /* U+46DE */
  0x0000,   /* U+46DF */
  0x0000,   /* U+46E0 */
  0x0000,   /* U+46E1 */
  0x0000,   /* U+46E2 */
  0x0000,   /* U+46E3 */
  0x0000,   /* U+46E4 */
  0x0000,   /* U+46E5 */
  0x0000,   /* U+46E6 */
  0x0000,   /* U+46E7 */
  0x0000,   /* U+46E8 */
  0x0000,   /* U+46E9 */
  0x0000,   /* U+46EA */
  0x0000,   /* U+46EB */
  0x0000,   /* U+46EC */
  0x0000,   /* U+46ED */
  0x0000,   /* U+46EE */
  0x0000,   /* U+46EF */
  0x0000,   /* U+46F0 */
  0x0000,   /* U+46F1 */
  0x0000,   /* U+46F2 */
  0x0000,   /* U+46F3 */
  0x0000,   /* U+46F4 */
  0x0000,   /* U+46F5 */
  0x0000,   /* U+46F6 */
  0x0000,   /* U+46F7 */
  0x0000,   /* U+46F8 */
  0x0000,   /* U+46F9 */
  0x0000,   /* U+46FA */
  0x0000,   /* U+46FB */
  0x0000,   /* U+46FC */
  0x0000,   /* U+46FD */
  0x0000,   /* U+46FE */
  0x0000,   /* U+46FF */
};

uint16 zh2_han_p047[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x418D,   /* U+4700 */
  0x418D,   /* U+4701 */
  0x418D,   /* U+4702 */
  0x4197,   /* U+4703 */
  0x4197,   /* U+4704 */
  0x4197,   /* U+4705 */
  0x4197,   /* U+4706 */
  0x4197,   /* U+4707 */
  0x4197,   /* U+4708 */
  0x4197,   /* U+4709 */
  0x4197,   /* U+470A */
  0x4198,   /* U+470B */
  0x4198,   /* U+470C */
  0x4198,   /* U+470D */
  0x4198,   /* U+470E */
  0x4198,   /* U+470F */
  0x4198,   /* U+4710 */
  0x4198,   /* U+4711 */
  0x4199,   /* U+4712 */
  0x4199,   /* U+4713 */
  0x4199,   /* U+4714 */
  0x4199,   /* U+4715 */
  0x4199,   /* U+4716 */
  0x4199,   /* U+4717 */
  0x4199,   /* U+4718 */
  0x419A,   /* U+4719 */
  0x419A,   /* U+471A */
  0x419A,   /* U+471B */
  0x419A,   /* U+471C */
  0x419A,   /* U+471D */
  0x419A,   /* U+471E */
  0x419B,   /* U+471F */
  0x419B,   /* U+4720 */
  0x419B,   /* U+4721 */
  0x419C,   /* U+4722 */
  0x4190,   /* U+4723 */
  0x4192,   /* U+4724 */
  0x4194,   /* U+4725 */
  0x4196,   /* U+4726 */
  0x4196,   /* U+4727 */
  0x4197,   /* U+4728 */
  0x419C,   /* U+4729 */
  0x41CE,   /* U+472A */
  0x41CF,   /* U+472B */
  0x41D1,   /* U+472C */
  0x41D1,   /* U+472D */
  0x41D3,   /* U+472E */
  0x41D4,   /* U+472F */
  0x41CD,   /* U+4730 */
  0x41D7,   /* U+4731 */
  0x41DB,   /* U+4732 */
  0x5C49,   /* U+4733 */
  0x4210,   /* U+4734 */
  0x4211,   /* U+4735 */
  0x4212,   /* U+4736 */
  0x4213,   /* U+4737 */
  0x4213,   /* U+4738 */
  0x4213,   /* U+4739 */
  0x4214,   /* U+473A */
  0x4215,   /* U+473B */
  0x4215,   /* U+473C */
  0x4215,   /* U+473D */
  0x4215,   /* U+473E */
  0x5C49,   /* U+473F */
  0x420D,   /* U+4740 */
  0x420D,   /* U+4741 */
  0x420D,   /* U+4742 */
  0x421A,   /* U+4743 */
  0x421E,   /* U+4744 */
  0x424F,   /* U+4745 */
  0x4250,   /* U+4746 */
  0x4250,   /* U+4747 */
  0x4251,   /* U+4748 */
  0x5C49,   /* U+4749 */
  0x4254,   /* U+474A */
  0x4254,   /* U+474B */
  0x4254,   /* U+474C */
  0x4255,   /* U+474D */
  0x4255,   /* U+474E */
  0x4257,   /* U+474F */
  0x4258,   /* U+4750 */
  0x4258,   /* U+4751 */
  0x425A,   /* U+4752 */
  0x425B,   /* U+4753 */
  0x425E,   /* U+4754 */
  0x425E,   /* U+4755 */
  0x4290,   /* U+4756 */
  0x4290,   /* U+4757 */
  0x4290,   /* U+4758 */
  0x4290,   /* U+4759 */
  0x4291,   /* U+475A */
  0x4291,   /* U+475B */
  0x4293,   /* U+475C */
  0x4294,   /* U+475D */
  0x4294,   /* U+475E */
  0x4295,   /* U+475F */
  0x428D,   /* U+4760 */
  0x4297,   /* U+4761 */
  0x4297,   /* U+4762 */
  0x4298,   /* U+4763 */
  0x4298,   /* U+4764 */
  0x4298,   /* U+4765 */
  0x4298,   /* U+4766 */
  0x42D0,   /* U+4767 */
  0x42D0,   /* U+4768 */
  0x42D1,   /* U+4769 */
  0x42D1,   /* U+476A */
  0x42D1,   /* U+476B */
  0x42D1,   /* U+476C */
  0x42D1,   /* U+476D */
  0x42D1,   /* U+476E */
  0x42D1,   /* U+476F */
  0x42D2,   /* U+4770 */
  0x42D2,   /* U+4771 */
  0x5C49,   /* U+4772 */
  0x42D3,   /* U+4773 */
  0x42D3,   /* U+4774 */
  0x42D3,   /* U+4775 */
  0x42D4,   /* U+4776 */
  0x42D4,   /* U+4777 */
  0x42D4,   /* U+4778 */
  0x42D4,   /* U+4779 */
  0x42D4,   /* U+477A */
  0x42D4,   /* U+477B */
  0x42D4,   /* U+477C */
  0x42D4,   /* U+477D */
  0x42D4,   /* U+477E */
  0x42D4,   /* U+477F */
  0x42D5,   /* U+4780 */
  0x42D5,   /* U+4781 */
  0x42D5,   /* U+4782 */
  0x42D5,   /* U+4783 */
  0x42D5,   /* U+4784 */
  0x42CD,   /* U+4785 */
  0x42CD,   /* U+4786 */
  0x5C49,   /* U+4787 */
  0x42D8,   /* U+4788 */
  0x42D9,   /* U+4789 */
  0x5C49,   /* U+478A */
  0x42DC,   /* U+478B */
  0x42D2,   /* U+478C */
  0x42D4,   /* U+478D */
  0x42D4,   /* U+478E */
  0x42D5,   /* U+478F */
  0x42D5,   /* U+4790 */
  0x430F,   /* U+4791 */
  0x4312,   /* U+4792 */
  0x4313,   /* U+4793 */
  0x4313,   /* U+4794 */
  0x431A,   /* U+4795 */
  0x434F,   /* U+4796 */
  0x434F,   /* U+4797 */
  0x434F,   /* U+4798 */
  0x4350,   /* U+4799 */
  0x4350,   /* U+479A */
  0x4350,   /* U+479B */
  0x4350,   /* U+479C */
  0x4351,   /* U+479D */
  0x4351,   /* U+479E */
  0x4351,   /* U+479F */
  0x4351,   /* U+47A0 */
  0x4351,   /* U+47A1 */
  0x4351,   /* U+47A2 */
  0x4351,   /* U+47A3 */
  0x4351,   /* U+47A4 */
  0x4352,   /* U+47A5 */
  0x4352,   /* U+47A6 */
  0x4352,   /* U+47A7 */
  0x4352,   /* U+47A8 */
  0x4352,   /* U+47A9 */
  0x4352,   /* U+47AA */
  0x4353,   /* U+47AB */
  0x4353,   /* U+47AC */
  0x4353,   /* U+47AD */
  0x4353,   /* U+47AE */
  0x4353,   /* U+47AF */
  0x4353,   /* U+47B0 */
  0x4353,   /* U+47B1 */
  0x4353,   /* U+47B2 */
  0x4354,   /* U+47B3 */
  0x4354,   /* U+47B4 */
  0x4354,   /* U+47B5 */
  0x4354,   /* U+47B6 */
  0x4354,   /* U+47B7 */
  0x4354,   /* U+47B8 */
  0x4355,   /* U+47B9 */
  0x4355,   /* U+47BA */
  0x4355,   /* U+47BB */
  0x4355,   /* U+47BC */
  0x434D,   /* U+47BD */
  0x434D,   /* U+47BE */
  0x434D,   /* U+47BF */
  0x434D,   /* U+47C0 */
  0x4357,   /* U+47C1 */
  0x4357,   /* U+47C2 */
  0x4357,   /* U+47C3 */
  0x4357,   /* U+47C4 */
  0x4357,   /* U+47C5 */
  0x4357,   /* U+47C6 */
  0x4358,   /* U+47C7 */
  0x4359,   /* U+47C8 */
  0x4359,   /* U+47C9 */
  0x4359,   /* U+47CA */
  0x4359,   /* U+47CB */
  0x435A,   /* U+47CC */
  0x435B,   /* U+47CD */
  0x435B,   /* U+47CE */
  0x435B,   /* U+47CF */
  0x435C,   /* U+47D0 */
  0x435D,   /* U+47D1 */
  0x435E,   /* U+47D2 */
  0x438E,   /* U+47D3 */
  0x438E,   /* U+47D4 */
  0x438F,   /* U+47D5 */
  0x438F,   /* U+47D6 */
  0x4390,   /* U+47D7 */
  0x4390,   /* U+47D8 */
  0x4390,   /* U+47D9 */
  0x4390,   /* U+47DA */
  0x4390,   /* U+47DB */
  0x4390,   /* U+47DC */
  0x4390,   /* U+47DD */
  0x4390,   /* U+47DE */
  0x4391,   /* U+47DF */
  0x4391,   /* U+47E0 */
  0x4391,   /* U+47E1 */
  0x4391,   /* U+47E2 */
  0x4391,   /* U+47E3 */
  0x4391,   /* U+47E4 */
  0x4391,   /* U+47E5 */
  0x4391,   /* U+47E6 */
  0x4391,   /* U+47E7 */
  0x4391,   /* U+47E8 */
  0x4391,   /* U+47E9 */
  0x4391,   /* U+47EA */
  0x4391,   /* U+47EB */
  0x4391,   /* U+47EC */
  0x4391,   /* U+47ED */
  0x4392,   /* U+47EE */
  0x4392,   /* U+47EF */
  0x4392,   /* U+47F0 */
  0x4392,   /* U+47F1 */
  0x4392,   /* U+47F2 */
  0x5C49,   /* U+47F3 */
  0x4393,   /* U+47F4 */
  0x4393,   /* U+47F5 */
  0x4393,   /* U+47F6 */
  0x4393,   /* U+47F7 */
  0x4393,   /* U+47F8 */
  0x4393,   /* U+47F9 */
  0x4393,   /* U+47FA */
  0x4393,   /* U+47FB */
  0x4394,   /* U+47FC */
  0x4393,   /* U+47FD */
  0x4394,   /* U+47FE */
  0x4394,   /* U+47FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4700 */
  0x0020,   /* U+4701 */
  0x0020,   /* U+4702 */
  0x0020,   /* U+4703 */
  0x0020,   /* U+4704 */
  0x0020,   /* U+4705 */
  0x0020,   /* U+4706 */
  0x0020,   /* U+4707 */
  0x0020,   /* U+4708 */
  0x0020,   /* U+4709 */
  0x0020,   /* U+470A */
  0x0020,   /* U+470B */
  0x0020,   /* U+470C */
  0x0020,   /* U+470D */
  0x0020,   /* U+470E */
  0x0020,   /* U+470F */
  0x0020,   /* U+4710 */
  0x0020,   /* U+4711 */
  0x0020,   /* U+4712 */
  0x0020,   /* U+4713 */
  0x0020,   /* U+4714 */
  0x0020,   /* U+4715 */
  0x0020,   /* U+4716 */
  0x0020,   /* U+4717 */
  0x0020,   /* U+4718 */
  0x0020,   /* U+4719 */
  0x0020,   /* U+471A */
  0x0020,   /* U+471B */
  0x0020,   /* U+471C */
  0x0020,   /* U+471D */
  0x0020,   /* U+471E */
  0x0020,   /* U+471F */
  0x0020,   /* U+4720 */
  0x0020,   /* U+4721 */
  0x0020,   /* U+4722 */
  0x0020,   /* U+4723 */
  0x0020,   /* U+4724 */
  0x0020,   /* U+4725 */
  0x0020,   /* U+4726 */
  0x0020,   /* U+4727 */
  0x0020,   /* U+4728 */
  0x0020,   /* U+4729 */
  0x0020,   /* U+472A */
  0x0020,   /* U+472B */
  0x0020,   /* U+472C */
  0x0020,   /* U+472D */
  0x0020,   /* U+472E */
  0x0020,   /* U+472F */
  0x0020,   /* U+4730 */
  0x0020,   /* U+4731 */
  0x0020,   /* U+4732 */
  0x0020,   /* U+4733 */
  0x0020,   /* U+4734 */
  0x0020,   /* U+4735 */
  0x0020,   /* U+4736 */
  0x0020,   /* U+4737 */
  0x0020,   /* U+4738 */
  0x0020,   /* U+4739 */
  0x0020,   /* U+473A */
  0x0020,   /* U+473B */
  0x0020,   /* U+473C */
  0x0020,   /* U+473D */
  0x0020,   /* U+473E */
  0x0020,   /* U+473F */
  0x0020,   /* U+4740 */
  0x0020,   /* U+4741 */
  0x0020,   /* U+4742 */
  0x0020,   /* U+4743 */
  0x0020,   /* U+4744 */
  0x0020,   /* U+4745 */
  0x0020,   /* U+4746 */
  0x0020,   /* U+4747 */
  0x0020,   /* U+4748 */
  0x0020,   /* U+4749 */
  0x0020,   /* U+474A */
  0x0020,   /* U+474B */
  0x0020,   /* U+474C */
  0x0020,   /* U+474D */
  0x0020,   /* U+474E */
  0x0020,   /* U+474F */
  0x0020,   /* U+4750 */
  0x0020,   /* U+4751 */
  0x0020,   /* U+4752 */
  0x0020,   /* U+4753 */
  0x0020,   /* U+4754 */
  0x0020,   /* U+4755 */
  0x0020,   /* U+4756 */
  0x0020,   /* U+4757 */
  0x0020,   /* U+4758 */
  0x0020,   /* U+4759 */
  0x0020,   /* U+475A */
  0x0020,   /* U+475B */
  0x0020,   /* U+475C */
  0x0020,   /* U+475D */
  0x0020,   /* U+475E */
  0x0020,   /* U+475F */
  0x0020,   /* U+4760 */
  0x0020,   /* U+4761 */
  0x0020,   /* U+4762 */
  0x0020,   /* U+4763 */
  0x0020,   /* U+4764 */
  0x0020,   /* U+4765 */
  0x0020,   /* U+4766 */
  0x0020,   /* U+4767 */
  0x0020,   /* U+4768 */
  0x0020,   /* U+4769 */
  0x0020,   /* U+476A */
  0x0020,   /* U+476B */
  0x0020,   /* U+476C */
  0x0020,   /* U+476D */
  0x0020,   /* U+476E */
  0x0020,   /* U+476F */
  0x0020,   /* U+4770 */
  0x0020,   /* U+4771 */
  0x0020,   /* U+4772 */
  0x0020,   /* U+4773 */
  0x0020,   /* U+4774 */
  0x0020,   /* U+4775 */
  0x0020,   /* U+4776 */
  0x0020,   /* U+4777 */
  0x0020,   /* U+4778 */
  0x0020,   /* U+4779 */
  0x0020,   /* U+477A */
  0x0020,   /* U+477B */
  0x0020,   /* U+477C */
  0x0020,   /* U+477D */
  0x0020,   /* U+477E */
  0x0020,   /* U+477F */
  0x0020,   /* U+4780 */
  0x0020,   /* U+4781 */
  0x0020,   /* U+4782 */
  0x0020,   /* U+4783 */
  0x0020,   /* U+4784 */
  0x0020,   /* U+4785 */
  0x0020,   /* U+4786 */
  0x0020,   /* U+4787 */
  0x0020,   /* U+4788 */
  0x0020,   /* U+4789 */
  0x0020,   /* U+478A */
  0x0020,   /* U+478B */
  0x0020,   /* U+478C */
  0x0020,   /* U+478D */
  0x0020,   /* U+478E */
  0x0020,   /* U+478F */
  0x0020,   /* U+4790 */
  0x0020,   /* U+4791 */
  0x0020,   /* U+4792 */
  0x0020,   /* U+4793 */
  0x0020,   /* U+4794 */
  0x0020,   /* U+4795 */
  0x0020,   /* U+4796 */
  0x0020,   /* U+4797 */
  0x0020,   /* U+4798 */
  0x0020,   /* U+4799 */
  0x0020,   /* U+479A */
  0x0020,   /* U+479B */
  0x0020,   /* U+479C */
  0x0020,   /* U+479D */
  0x0020,   /* U+479E */
  0x0020,   /* U+479F */
  0x0020,   /* U+47A0 */
  0x0020,   /* U+47A1 */
  0x0020,   /* U+47A2 */
  0x0020,   /* U+47A3 */
  0x0020,   /* U+47A4 */
  0x0020,   /* U+47A5 */
  0x0020,   /* U+47A6 */
  0x0020,   /* U+47A7 */
  0x0020,   /* U+47A8 */
  0x0020,   /* U+47A9 */
  0x0020,   /* U+47AA */
  0x0020,   /* U+47AB */
  0x0020,   /* U+47AC */
  0x0020,   /* U+47AD */
  0x0020,   /* U+47AE */
  0x0020,   /* U+47AF */
  0x0020,   /* U+47B0 */
  0x0020,   /* U+47B1 */
  0x0020,   /* U+47B2 */
  0x0020,   /* U+47B3 */
  0x0020,   /* U+47B4 */
  0x0020,   /* U+47B5 */
  0x0020,   /* U+47B6 */
  0x0020,   /* U+47B7 */
  0x0020,   /* U+47B8 */
  0x0020,   /* U+47B9 */
  0x0020,   /* U+47BA */
  0x0020,   /* U+47BB */
  0x0020,   /* U+47BC */
  0x0020,   /* U+47BD */
  0x0020,   /* U+47BE */
  0x0020,   /* U+47BF */
  0x0020,   /* U+47C0 */
  0x0020,   /* U+47C1 */
  0x0020,   /* U+47C2 */
  0x0020,   /* U+47C3 */
  0x0020,   /* U+47C4 */
  0x0020,   /* U+47C5 */
  0x0020,   /* U+47C6 */
  0x0020,   /* U+47C7 */
  0x0020,   /* U+47C8 */
  0x0020,   /* U+47C9 */
  0x0020,   /* U+47CA */
  0x0020,   /* U+47CB */
  0x0020,   /* U+47CC */
  0x0020,   /* U+47CD */
  0x0020,   /* U+47CE */
  0x0020,   /* U+47CF */
  0x0020,   /* U+47D0 */
  0x0020,   /* U+47D1 */
  0x0020,   /* U+47D2 */
  0x0020,   /* U+47D3 */
  0x0020,   /* U+47D4 */
  0x0020,   /* U+47D5 */
  0x0020,   /* U+47D6 */
  0x0020,   /* U+47D7 */
  0x0020,   /* U+47D8 */
  0x0020,   /* U+47D9 */
  0x0020,   /* U+47DA */
  0x0020,   /* U+47DB */
  0x0020,   /* U+47DC */
  0x0020,   /* U+47DD */
  0x0020,   /* U+47DE */
  0x0020,   /* U+47DF */
  0x0020,   /* U+47E0 */
  0x0020,   /* U+47E1 */
  0x0020,   /* U+47E2 */
  0x0020,   /* U+47E3 */
  0x0020,   /* U+47E4 */
  0x0020,   /* U+47E5 */
  0x0020,   /* U+47E6 */
  0x0020,   /* U+47E7 */
  0x0020,   /* U+47E8 */
  0x0020,   /* U+47E9 */
  0x0020,   /* U+47EA */
  0x0020,   /* U+47EB */
  0x0020,   /* U+47EC */
  0x0020,   /* U+47ED */
  0x0020,   /* U+47EE */
  0x0020,   /* U+47EF */
  0x0020,   /* U+47F0 */
  0x0020,   /* U+47F1 */
  0x0020,   /* U+47F2 */
  0x0020,   /* U+47F3 */
  0x0020,   /* U+47F4 */
  0x0020,   /* U+47F5 */
  0x0020,   /* U+47F6 */
  0x0020,   /* U+47F7 */
  0x0020,   /* U+47F8 */
  0x0020,   /* U+47F9 */
  0x0020,   /* U+47FA */
  0x0020,   /* U+47FB */
  0x0020,   /* U+47FC */
  0x0020,   /* U+47FD */
  0x0020,   /* U+47FE */
  0x0020,   /* U+47FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4700 */
  0x0002,   /* U+4701 */
  0x0002,   /* U+4702 */
  0x0002,   /* U+4703 */
  0x0002,   /* U+4704 */
  0x0002,   /* U+4705 */
  0x0002,   /* U+4706 */
  0x0002,   /* U+4707 */
  0x0002,   /* U+4708 */
  0x0002,   /* U+4709 */
  0x0002,   /* U+470A */
  0x0002,   /* U+470B */
  0x0002,   /* U+470C */
  0x0002,   /* U+470D */
  0x0002,   /* U+470E */
  0x0002,   /* U+470F */
  0x0002,   /* U+4710 */
  0x0002,   /* U+4711 */
  0x0002,   /* U+4712 */
  0x0002,   /* U+4713 */
  0x0002,   /* U+4714 */
  0x0002,   /* U+4715 */
  0x0002,   /* U+4716 */
  0x0002,   /* U+4717 */
  0x0002,   /* U+4718 */
  0x0002,   /* U+4719 */
  0x0002,   /* U+471A */
  0x0002,   /* U+471B */
  0x0002,   /* U+471C */
  0x0002,   /* U+471D */
  0x0002,   /* U+471E */
  0x0002,   /* U+471F */
  0x0002,   /* U+4720 */
  0x0002,   /* U+4721 */
  0x0002,   /* U+4722 */
  0x0002,   /* U+4723 */
  0x0002,   /* U+4724 */
  0x0002,   /* U+4725 */
  0x0002,   /* U+4726 */
  0x0002,   /* U+4727 */
  0x0002,   /* U+4728 */
  0x0002,   /* U+4729 */
  0x0002,   /* U+472A */
  0x0002,   /* U+472B */
  0x0002,   /* U+472C */
  0x0002,   /* U+472D */
  0x0002,   /* U+472E */
  0x0002,   /* U+472F */
  0x0002,   /* U+4730 */
  0x0002,   /* U+4731 */
  0x0002,   /* U+4732 */
  0x0002,   /* U+4733 */
  0x0002,   /* U+4734 */
  0x0002,   /* U+4735 */
  0x0002,   /* U+4736 */
  0x0002,   /* U+4737 */
  0x0002,   /* U+4738 */
  0x0002,   /* U+4739 */
  0x0002,   /* U+473A */
  0x0002,   /* U+473B */
  0x0002,   /* U+473C */
  0x0002,   /* U+473D */
  0x0002,   /* U+473E */
  0x0002,   /* U+473F */
  0x0002,   /* U+4740 */
  0x0002,   /* U+4741 */
  0x0002,   /* U+4742 */
  0x0002,   /* U+4743 */
  0x0002,   /* U+4744 */
  0x0002,   /* U+4745 */
  0x0002,   /* U+4746 */
  0x0002,   /* U+4747 */
  0x0002,   /* U+4748 */
  0x0002,   /* U+4749 */
  0x0002,   /* U+474A */
  0x0002,   /* U+474B */
  0x0002,   /* U+474C */
  0x0002,   /* U+474D */
  0x0002,   /* U+474E */
  0x0002,   /* U+474F */
  0x0002,   /* U+4750 */
  0x0002,   /* U+4751 */
  0x0002,   /* U+4752 */
  0x0002,   /* U+4753 */
  0x0002,   /* U+4754 */
  0x0002,   /* U+4755 */
  0x0002,   /* U+4756 */
  0x0002,   /* U+4757 */
  0x0002,   /* U+4758 */
  0x0002,   /* U+4759 */
  0x0002,   /* U+475A */
  0x0002,   /* U+475B */
  0x0002,   /* U+475C */
  0x0002,   /* U+475D */
  0x0002,   /* U+475E */
  0x0002,   /* U+475F */
  0x0002,   /* U+4760 */
  0x0002,   /* U+4761 */
  0x0002,   /* U+4762 */
  0x0002,   /* U+4763 */
  0x0002,   /* U+4764 */
  0x0002,   /* U+4765 */
  0x0002,   /* U+4766 */
  0x0002,   /* U+4767 */
  0x0002,   /* U+4768 */
  0x0002,   /* U+4769 */
  0x0002,   /* U+476A */
  0x0002,   /* U+476B */
  0x0002,   /* U+476C */
  0x0002,   /* U+476D */
  0x0002,   /* U+476E */
  0x0002,   /* U+476F */
  0x0002,   /* U+4770 */
  0x0002,   /* U+4771 */
  0x0002,   /* U+4772 */
  0x0002,   /* U+4773 */
  0x0002,   /* U+4774 */
  0x0002,   /* U+4775 */
  0x0002,   /* U+4776 */
  0x0002,   /* U+4777 */
  0x0002,   /* U+4778 */
  0x0002,   /* U+4779 */
  0x0002,   /* U+477A */
  0x0002,   /* U+477B */
  0x0002,   /* U+477C */
  0x0002,   /* U+477D */
  0x0002,   /* U+477E */
  0x0002,   /* U+477F */
  0x0002,   /* U+4780 */
  0x0002,   /* U+4781 */
  0x0002,   /* U+4782 */
  0x0002,   /* U+4783 */
  0x0002,   /* U+4784 */
  0x0002,   /* U+4785 */
  0x0002,   /* U+4786 */
  0x0002,   /* U+4787 */
  0x0002,   /* U+4788 */
  0x0002,   /* U+4789 */
  0x0002,   /* U+478A */
  0x0002,   /* U+478B */
  0x0002,   /* U+478C */
  0x0002,   /* U+478D */
  0x0002,   /* U+478E */
  0x0002,   /* U+478F */
  0x0002,   /* U+4790 */
  0x0002,   /* U+4791 */
  0x0002,   /* U+4792 */
  0x0002,   /* U+4793 */
  0x0002,   /* U+4794 */
  0x0002,   /* U+4795 */
  0x0002,   /* U+4796 */
  0x0002,   /* U+4797 */
  0x0002,   /* U+4798 */
  0x0002,   /* U+4799 */
  0x0002,   /* U+479A */
  0x0002,   /* U+479B */
  0x0002,   /* U+479C */
  0x0002,   /* U+479D */
  0x0002,   /* U+479E */
  0x0002,   /* U+479F */
  0x0002,   /* U+47A0 */
  0x0002,   /* U+47A1 */
  0x0002,   /* U+47A2 */
  0x0002,   /* U+47A3 */
  0x0002,   /* U+47A4 */
  0x0002,   /* U+47A5 */
  0x0002,   /* U+47A6 */
  0x0002,   /* U+47A7 */
  0x0002,   /* U+47A8 */
  0x0002,   /* U+47A9 */
  0x0002,   /* U+47AA */
  0x0002,   /* U+47AB */
  0x0002,   /* U+47AC */
  0x0002,   /* U+47AD */
  0x0002,   /* U+47AE */
  0x0002,   /* U+47AF */
  0x0002,   /* U+47B0 */
  0x0002,   /* U+47B1 */
  0x0002,   /* U+47B2 */
  0x0002,   /* U+47B3 */
  0x0002,   /* U+47B4 */
  0x0002,   /* U+47B5 */
  0x0002,   /* U+47B6 */
  0x0002,   /* U+47B7 */
  0x0002,   /* U+47B8 */
  0x0002,   /* U+47B9 */
  0x0002,   /* U+47BA */
  0x0002,   /* U+47BB */
  0x0002,   /* U+47BC */
  0x0002,   /* U+47BD */
  0x0002,   /* U+47BE */
  0x0002,   /* U+47BF */
  0x0002,   /* U+47C0 */
  0x0002,   /* U+47C1 */
  0x0002,   /* U+47C2 */
  0x0002,   /* U+47C3 */
  0x0002,   /* U+47C4 */
  0x0002,   /* U+47C5 */
  0x0002,   /* U+47C6 */
  0x0002,   /* U+47C7 */
  0x0002,   /* U+47C8 */
  0x0002,   /* U+47C9 */
  0x0002,   /* U+47CA */
  0x0002,   /* U+47CB */
  0x0002,   /* U+47CC */
  0x0002,   /* U+47CD */
  0x0002,   /* U+47CE */
  0x0002,   /* U+47CF */
  0x0002,   /* U+47D0 */
  0x0002,   /* U+47D1 */
  0x0002,   /* U+47D2 */
  0x0002,   /* U+47D3 */
  0x0002,   /* U+47D4 */
  0x0002,   /* U+47D5 */
  0x0002,   /* U+47D6 */
  0x0002,   /* U+47D7 */
  0x0002,   /* U+47D8 */
  0x0002,   /* U+47D9 */
  0x0002,   /* U+47DA */
  0x0002,   /* U+47DB */
  0x0002,   /* U+47DC */
  0x0002,   /* U+47DD */
  0x0002,   /* U+47DE */
  0x0002,   /* U+47DF */
  0x0002,   /* U+47E0 */
  0x0002,   /* U+47E1 */
  0x0002,   /* U+47E2 */
  0x0002,   /* U+47E3 */
  0x0002,   /* U+47E4 */
  0x0002,   /* U+47E5 */
  0x0002,   /* U+47E6 */
  0x0002,   /* U+47E7 */
  0x0002,   /* U+47E8 */
  0x0002,   /* U+47E9 */
  0x0002,   /* U+47EA */
  0x0002,   /* U+47EB */
  0x0002,   /* U+47EC */
  0x0002,   /* U+47ED */
  0x0002,   /* U+47EE */
  0x0002,   /* U+47EF */
  0x0002,   /* U+47F0 */
  0x0002,   /* U+47F1 */
  0x0002,   /* U+47F2 */
  0x0002,   /* U+47F3 */
  0x0002,   /* U+47F4 */
  0x0002,   /* U+47F5 */
  0x0002,   /* U+47F6 */
  0x0002,   /* U+47F7 */
  0x0002,   /* U+47F8 */
  0x0002,   /* U+47F9 */
  0x0002,   /* U+47FA */
  0x0002,   /* U+47FB */
  0x0002,   /* U+47FC */
  0x0002,   /* U+47FD */
  0x0002,   /* U+47FE */
  0x0002,   /* U+47FF */

  /* Primary weight 2 for each character. */
  0x8002,   /* U+4700 */
  0x8003,   /* U+4701 */
  0x8004,   /* U+4702 */
  0x800D,   /* U+4703 */
  0x800E,   /* U+4704 */
  0x800F,   /* U+4705 */
  0x8010,   /* U+4706 */
  0x8011,   /* U+4707 */
  0x8012,   /* U+4708 */
  0x8013,   /* U+4709 */
  0x8014,   /* U+470A */
  0x8012,   /* U+470B */
  0x8013,   /* U+470C */
  0x8014,   /* U+470D */
  0x8015,   /* U+470E */
  0x8016,   /* U+470F */
  0x8017,   /* U+4710 */
  0x8018,   /* U+4711 */
  0x8007,   /* U+4712 */
  0x8008,   /* U+4713 */
  0x8009,   /* U+4714 */
  0x800A,   /* U+4715 */
  0x800B,   /* U+4716 */
  0x800C,   /* U+4717 */
  0x800D,   /* U+4718 */
  0x8005,   /* U+4719 */
  0x8006,   /* U+471A */
  0x8007,   /* U+471B */
  0x8008,   /* U+471C */
  0x8009,   /* U+471D */
  0x800A,   /* U+471E */
  0x8003,   /* U+471F */
  0x8004,   /* U+4720 */
  0x8005,   /* U+4721 */
  0x8002,   /* U+4722 */
  0x8000,   /* U+4723 */
  0x8000,   /* U+4724 */
  0x8000,   /* U+4725 */
  0x8000,   /* U+4726 */
  0x8001,   /* U+4727 */
  0x8000,   /* U+4728 */
  0x8000,   /* U+4729 */
  0x8000,   /* U+472A */
  0x8000,   /* U+472B */
  0x8000,   /* U+472C */
  0x8001,   /* U+472D */
  0x8000,   /* U+472E */
  0x8000,   /* U+472F */
  0x8000,   /* U+4730 */
  0x8000,   /* U+4731 */
  0x8000,   /* U+4732 */
  0xC733,   /* U+4733 */
  0x8000,   /* U+4734 */
  0x8000,   /* U+4735 */
  0x8000,   /* U+4736 */
  0x8000,   /* U+4737 */
  0x8001,   /* U+4738 */
  0x8002,   /* U+4739 */
  0x8000,   /* U+473A */
  0x8000,   /* U+473B */
  0x8001,   /* U+473C */
  0x8002,   /* U+473D */
  0x8003,   /* U+473E */
  0xC73F,   /* U+473F */
  0x8000,   /* U+4740 */
  0x8001,   /* U+4741 */
  0x8002,   /* U+4742 */
  0x8000,   /* U+4743 */
  0x8000,   /* U+4744 */
  0x8000,   /* U+4745 */
  0x8000,   /* U+4746 */
  0x8001,   /* U+4747 */
  0x8000,   /* U+4748 */
  0xC749,   /* U+4749 */
  0x8000,   /* U+474A */
  0x8001,   /* U+474B */
  0x8002,   /* U+474C */
  0x8000,   /* U+474D */
  0x8001,   /* U+474E */
  0x8000,   /* U+474F */
  0x8000,   /* U+4750 */
  0x8001,   /* U+4751 */
  0x8000,   /* U+4752 */
  0x8000,   /* U+4753 */
  0x8000,   /* U+4754 */
  0x8001,   /* U+4755 */
  0x8000,   /* U+4756 */
  0x8001,   /* U+4757 */
  0x8002,   /* U+4758 */
  0x8003,   /* U+4759 */
  0x8000,   /* U+475A */
  0x8001,   /* U+475B */
  0x8000,   /* U+475C */
  0x8000,   /* U+475D */
  0x8001,   /* U+475E */
  0x8000,   /* U+475F */
  0x8000,   /* U+4760 */
  0x8000,   /* U+4761 */
  0x8001,   /* U+4762 */
  0x8000,   /* U+4763 */
  0x8001,   /* U+4764 */
  0x8002,   /* U+4765 */
  0x8003,   /* U+4766 */
  0x800F,   /* U+4767 */
  0x8010,   /* U+4768 */
  0x8012,   /* U+4769 */
  0x8013,   /* U+476A */
  0x8014,   /* U+476B */
  0x8015,   /* U+476C */
  0x8016,   /* U+476D */
  0x8017,   /* U+476E */
  0x8018,   /* U+476F */
  0x800D,   /* U+4770 */
  0x800E,   /* U+4771 */
  0xC772,   /* U+4772 */
  0x8008,   /* U+4773 */
  0x8009,   /* U+4774 */
  0x800A,   /* U+4775 */
  0x8012,   /* U+4776 */
  0x8013,   /* U+4777 */
  0x8014,   /* U+4778 */
  0x8015,   /* U+4779 */
  0x8016,   /* U+477A */
  0x8017,   /* U+477B */
  0x8018,   /* U+477C */
  0x8019,   /* U+477D */
  0x801A,   /* U+477E */
  0x801B,   /* U+477F */
  0x8009,   /* U+4780 */
  0x800A,   /* U+4781 */
  0x800B,   /* U+4782 */
  0x800C,   /* U+4783 */
  0x800D,   /* U+4784 */
  0x8000,   /* U+4785 */
  0x8001,   /* U+4786 */
  0xC787,   /* U+4787 */
  0x8005,   /* U+4788 */
  0x8002,   /* U+4789 */
  0xC78A,   /* U+478A */
  0x8000,   /* U+478B */
  0x8000,   /* U+478C */
  0x8000,   /* U+478D */
  0x8001,   /* U+478E */
  0x8000,   /* U+478F */
  0x8001,   /* U+4790 */
  0x8000,   /* U+4791 */
  0x8000,   /* U+4792 */
  0x8000,   /* U+4793 */
  0x8001,   /* U+4794 */
  0x8000,   /* U+4795 */
  0x8000,   /* U+4796 */
  0x8001,   /* U+4797 */
  0x8002,   /* U+4798 */
  0x8000,   /* U+4799 */
  0x8001,   /* U+479A */
  0x8002,   /* U+479B */
  0x8003,   /* U+479C */
  0x8000,   /* U+479D */
  0x8001,   /* U+479E */
  0x8002,   /* U+479F */
  0x8003,   /* U+47A0 */
  0x8004,   /* U+47A1 */
  0x8005,   /* U+47A2 */
  0x8006,   /* U+47A3 */
  0x8007,   /* U+47A4 */
  0x8000,   /* U+47A5 */
  0x8001,   /* U+47A6 */
  0x8002,   /* U+47A7 */
  0x8003,   /* U+47A8 */
  0x8004,   /* U+47A9 */
  0x8005,   /* U+47AA */
  0x8000,   /* U+47AB */
  0x8001,   /* U+47AC */
  0x8002,   /* U+47AD */
  0x8003,   /* U+47AE */
  0x8004,   /* U+47AF */
  0x8005,   /* U+47B0 */
  0x8006,   /* U+47B1 */
  0x8007,   /* U+47B2 */
  0x8000,   /* U+47B3 */
  0x8001,   /* U+47B4 */
  0x8002,   /* U+47B5 */
  0x8003,   /* U+47B6 */
  0x8004,   /* U+47B7 */
  0x8005,   /* U+47B8 */
  0x8000,   /* U+47B9 */
  0x8001,   /* U+47BA */
  0x8002,   /* U+47BB */
  0x8003,   /* U+47BC */
  0x8000,   /* U+47BD */
  0x8001,   /* U+47BE */
  0x8002,   /* U+47BF */
  0x8003,   /* U+47C0 */
  0x8000,   /* U+47C1 */
  0x8001,   /* U+47C2 */
  0x8002,   /* U+47C3 */
  0x8003,   /* U+47C4 */
  0x8004,   /* U+47C5 */
  0x8005,   /* U+47C6 */
  0x8000,   /* U+47C7 */
  0x8000,   /* U+47C8 */
  0x8001,   /* U+47C9 */
  0x8002,   /* U+47CA */
  0x8003,   /* U+47CB */
  0x8000,   /* U+47CC */
  0x8000,   /* U+47CD */
  0x8001,   /* U+47CE */
  0x8002,   /* U+47CF */
  0x8000,   /* U+47D0 */
  0x8000,   /* U+47D1 */
  0x8000,   /* U+47D2 */
  0x8000,   /* U+47D3 */
  0x8001,   /* U+47D4 */
  0x8000,   /* U+47D5 */
  0x8001,   /* U+47D6 */
  0x8000,   /* U+47D7 */
  0x8001,   /* U+47D8 */
  0x8002,   /* U+47D9 */
  0x8003,   /* U+47DA */
  0x8004,   /* U+47DB */
  0x8005,   /* U+47DC */
  0x8006,   /* U+47DD */
  0x8007,   /* U+47DE */
  0x8000,   /* U+47DF */
  0x8001,   /* U+47E0 */
  0x8002,   /* U+47E1 */
  0x8003,   /* U+47E2 */
  0x8004,   /* U+47E3 */
  0x8005,   /* U+47E4 */
  0x8006,   /* U+47E5 */
  0x8007,   /* U+47E6 */
  0x8008,   /* U+47E7 */
  0x8009,   /* U+47E8 */
  0x800A,   /* U+47E9 */
  0x800B,   /* U+47EA */
  0x800C,   /* U+47EB */
  0x800D,   /* U+47EC */
  0x800E,   /* U+47ED */
  0x8000,   /* U+47EE */
  0x8001,   /* U+47EF */
  0x8002,   /* U+47F0 */
  0x8003,   /* U+47F1 */
  0x8004,   /* U+47F2 */
  0xC7F3,   /* U+47F3 */
  0x8000,   /* U+47F4 */
  0x8001,   /* U+47F5 */
  0x8002,   /* U+47F6 */
  0x8003,   /* U+47F7 */
  0x8004,   /* U+47F8 */
  0x8005,   /* U+47F9 */
  0x8006,   /* U+47FA */
  0x8007,   /* U+47FB */
  0x8000,   /* U+47FC */
  0x8008,   /* U+47FD */
  0x8001,   /* U+47FE */
  0x8002,   /* U+47FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4700 */
  0x0000,   /* U+4701 */
  0x0000,   /* U+4702 */
  0x0000,   /* U+4703 */
  0x0000,   /* U+4704 */
  0x0000,   /* U+4705 */
  0x0000,   /* U+4706 */
  0x0000,   /* U+4707 */
  0x0000,   /* U+4708 */
  0x0000,   /* U+4709 */
  0x0000,   /* U+470A */
  0x0000,   /* U+470B */
  0x0000,   /* U+470C */
  0x0000,   /* U+470D */
  0x0000,   /* U+470E */
  0x0000,   /* U+470F */
  0x0000,   /* U+4710 */
  0x0000,   /* U+4711 */
  0x0000,   /* U+4712 */
  0x0000,   /* U+4713 */
  0x0000,   /* U+4714 */
  0x0000,   /* U+4715 */
  0x0000,   /* U+4716 */
  0x0000,   /* U+4717 */
  0x0000,   /* U+4718 */
  0x0000,   /* U+4719 */
  0x0000,   /* U+471A */
  0x0000,   /* U+471B */
  0x0000,   /* U+471C */
  0x0000,   /* U+471D */
  0x0000,   /* U+471E */
  0x0000,   /* U+471F */
  0x0000,   /* U+4720 */
  0x0000,   /* U+4721 */
  0x0000,   /* U+4722 */
  0x0000,   /* U+4723 */
  0x0000,   /* U+4724 */
  0x0000,   /* U+4725 */
  0x0000,   /* U+4726 */
  0x0000,   /* U+4727 */
  0x0000,   /* U+4728 */
  0x0000,   /* U+4729 */
  0x0000,   /* U+472A */
  0x0000,   /* U+472B */
  0x0000,   /* U+472C */
  0x0000,   /* U+472D */
  0x0000,   /* U+472E */
  0x0000,   /* U+472F */
  0x0000,   /* U+4730 */
  0x0000,   /* U+4731 */
  0x0000,   /* U+4732 */
  0x0000,   /* U+4733 */
  0x0000,   /* U+4734 */
  0x0000,   /* U+4735 */
  0x0000,   /* U+4736 */
  0x0000,   /* U+4737 */
  0x0000,   /* U+4738 */
  0x0000,   /* U+4739 */
  0x0000,   /* U+473A */
  0x0000,   /* U+473B */
  0x0000,   /* U+473C */
  0x0000,   /* U+473D */
  0x0000,   /* U+473E */
  0x0000,   /* U+473F */
  0x0000,   /* U+4740 */
  0x0000,   /* U+4741 */
  0x0000,   /* U+4742 */
  0x0000,   /* U+4743 */
  0x0000,   /* U+4744 */
  0x0000,   /* U+4745 */
  0x0000,   /* U+4746 */
  0x0000,   /* U+4747 */
  0x0000,   /* U+4748 */
  0x0000,   /* U+4749 */
  0x0000,   /* U+474A */
  0x0000,   /* U+474B */
  0x0000,   /* U+474C */
  0x0000,   /* U+474D */
  0x0000,   /* U+474E */
  0x0000,   /* U+474F */
  0x0000,   /* U+4750 */
  0x0000,   /* U+4751 */
  0x0000,   /* U+4752 */
  0x0000,   /* U+4753 */
  0x0000,   /* U+4754 */
  0x0000,   /* U+4755 */
  0x0000,   /* U+4756 */
  0x0000,   /* U+4757 */
  0x0000,   /* U+4758 */
  0x0000,   /* U+4759 */
  0x0000,   /* U+475A */
  0x0000,   /* U+475B */
  0x0000,   /* U+475C */
  0x0000,   /* U+475D */
  0x0000,   /* U+475E */
  0x0000,   /* U+475F */
  0x0000,   /* U+4760 */
  0x0000,   /* U+4761 */
  0x0000,   /* U+4762 */
  0x0000,   /* U+4763 */
  0x0000,   /* U+4764 */
  0x0000,   /* U+4765 */
  0x0000,   /* U+4766 */
  0x0000,   /* U+4767 */
  0x0000,   /* U+4768 */
  0x0000,   /* U+4769 */
  0x0000,   /* U+476A */
  0x0000,   /* U+476B */
  0x0000,   /* U+476C */
  0x0000,   /* U+476D */
  0x0000,   /* U+476E */
  0x0000,   /* U+476F */
  0x0000,   /* U+4770 */
  0x0000,   /* U+4771 */
  0x0000,   /* U+4772 */
  0x0000,   /* U+4773 */
  0x0000,   /* U+4774 */
  0x0000,   /* U+4775 */
  0x0000,   /* U+4776 */
  0x0000,   /* U+4777 */
  0x0000,   /* U+4778 */
  0x0000,   /* U+4779 */
  0x0000,   /* U+477A */
  0x0000,   /* U+477B */
  0x0000,   /* U+477C */
  0x0000,   /* U+477D */
  0x0000,   /* U+477E */
  0x0000,   /* U+477F */
  0x0000,   /* U+4780 */
  0x0000,   /* U+4781 */
  0x0000,   /* U+4782 */
  0x0000,   /* U+4783 */
  0x0000,   /* U+4784 */
  0x0000,   /* U+4785 */
  0x0000,   /* U+4786 */
  0x0000,   /* U+4787 */
  0x0000,   /* U+4788 */
  0x0000,   /* U+4789 */
  0x0000,   /* U+478A */
  0x0000,   /* U+478B */
  0x0000,   /* U+478C */
  0x0000,   /* U+478D */
  0x0000,   /* U+478E */
  0x0000,   /* U+478F */
  0x0000,   /* U+4790 */
  0x0000,   /* U+4791 */
  0x0000,   /* U+4792 */
  0x0000,   /* U+4793 */
  0x0000,   /* U+4794 */
  0x0000,   /* U+4795 */
  0x0000,   /* U+4796 */
  0x0000,   /* U+4797 */
  0x0000,   /* U+4798 */
  0x0000,   /* U+4799 */
  0x0000,   /* U+479A */
  0x0000,   /* U+479B */
  0x0000,   /* U+479C */
  0x0000,   /* U+479D */
  0x0000,   /* U+479E */
  0x0000,   /* U+479F */
  0x0000,   /* U+47A0 */
  0x0000,   /* U+47A1 */
  0x0000,   /* U+47A2 */
  0x0000,   /* U+47A3 */
  0x0000,   /* U+47A4 */
  0x0000,   /* U+47A5 */
  0x0000,   /* U+47A6 */
  0x0000,   /* U+47A7 */
  0x0000,   /* U+47A8 */
  0x0000,   /* U+47A9 */
  0x0000,   /* U+47AA */
  0x0000,   /* U+47AB */
  0x0000,   /* U+47AC */
  0x0000,   /* U+47AD */
  0x0000,   /* U+47AE */
  0x0000,   /* U+47AF */
  0x0000,   /* U+47B0 */
  0x0000,   /* U+47B1 */
  0x0000,   /* U+47B2 */
  0x0000,   /* U+47B3 */
  0x0000,   /* U+47B4 */
  0x0000,   /* U+47B5 */
  0x0000,   /* U+47B6 */
  0x0000,   /* U+47B7 */
  0x0000,   /* U+47B8 */
  0x0000,   /* U+47B9 */
  0x0000,   /* U+47BA */
  0x0000,   /* U+47BB */
  0x0000,   /* U+47BC */
  0x0000,   /* U+47BD */
  0x0000,   /* U+47BE */
  0x0000,   /* U+47BF */
  0x0000,   /* U+47C0 */
  0x0000,   /* U+47C1 */
  0x0000,   /* U+47C2 */
  0x0000,   /* U+47C3 */
  0x0000,   /* U+47C4 */
  0x0000,   /* U+47C5 */
  0x0000,   /* U+47C6 */
  0x0000,   /* U+47C7 */
  0x0000,   /* U+47C8 */
  0x0000,   /* U+47C9 */
  0x0000,   /* U+47CA */
  0x0000,   /* U+47CB */
  0x0000,   /* U+47CC */
  0x0000,   /* U+47CD */
  0x0000,   /* U+47CE */
  0x0000,   /* U+47CF */
  0x0000,   /* U+47D0 */
  0x0000,   /* U+47D1 */
  0x0000,   /* U+47D2 */
  0x0000,   /* U+47D3 */
  0x0000,   /* U+47D4 */
  0x0000,   /* U+47D5 */
  0x0000,   /* U+47D6 */
  0x0000,   /* U+47D7 */
  0x0000,   /* U+47D8 */
  0x0000,   /* U+47D9 */
  0x0000,   /* U+47DA */
  0x0000,   /* U+47DB */
  0x0000,   /* U+47DC */
  0x0000,   /* U+47DD */
  0x0000,   /* U+47DE */
  0x0000,   /* U+47DF */
  0x0000,   /* U+47E0 */
  0x0000,   /* U+47E1 */
  0x0000,   /* U+47E2 */
  0x0000,   /* U+47E3 */
  0x0000,   /* U+47E4 */
  0x0000,   /* U+47E5 */
  0x0000,   /* U+47E6 */
  0x0000,   /* U+47E7 */
  0x0000,   /* U+47E8 */
  0x0000,   /* U+47E9 */
  0x0000,   /* U+47EA */
  0x0000,   /* U+47EB */
  0x0000,   /* U+47EC */
  0x0000,   /* U+47ED */
  0x0000,   /* U+47EE */
  0x0000,   /* U+47EF */
  0x0000,   /* U+47F0 */
  0x0000,   /* U+47F1 */
  0x0000,   /* U+47F2 */
  0x0000,   /* U+47F3 */
  0x0000,   /* U+47F4 */
  0x0000,   /* U+47F5 */
  0x0000,   /* U+47F6 */
  0x0000,   /* U+47F7 */
  0x0000,   /* U+47F8 */
  0x0000,   /* U+47F9 */
  0x0000,   /* U+47FA */
  0x0000,   /* U+47FB */
  0x0000,   /* U+47FC */
  0x0000,   /* U+47FD */
  0x0000,   /* U+47FE */
  0x0000,   /* U+47FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4700 */
  0x0000,   /* U+4701 */
  0x0000,   /* U+4702 */
  0x0000,   /* U+4703 */
  0x0000,   /* U+4704 */
  0x0000,   /* U+4705 */
  0x0000,   /* U+4706 */
  0x0000,   /* U+4707 */
  0x0000,   /* U+4708 */
  0x0000,   /* U+4709 */
  0x0000,   /* U+470A */
  0x0000,   /* U+470B */
  0x0000,   /* U+470C */
  0x0000,   /* U+470D */
  0x0000,   /* U+470E */
  0x0000,   /* U+470F */
  0x0000,   /* U+4710 */
  0x0000,   /* U+4711 */
  0x0000,   /* U+4712 */
  0x0000,   /* U+4713 */
  0x0000,   /* U+4714 */
  0x0000,   /* U+4715 */
  0x0000,   /* U+4716 */
  0x0000,   /* U+4717 */
  0x0000,   /* U+4718 */
  0x0000,   /* U+4719 */
  0x0000,   /* U+471A */
  0x0000,   /* U+471B */
  0x0000,   /* U+471C */
  0x0000,   /* U+471D */
  0x0000,   /* U+471E */
  0x0000,   /* U+471F */
  0x0000,   /* U+4720 */
  0x0000,   /* U+4721 */
  0x0000,   /* U+4722 */
  0x0000,   /* U+4723 */
  0x0000,   /* U+4724 */
  0x0000,   /* U+4725 */
  0x0000,   /* U+4726 */
  0x0000,   /* U+4727 */
  0x0000,   /* U+4728 */
  0x0000,   /* U+4729 */
  0x0000,   /* U+472A */
  0x0000,   /* U+472B */
  0x0000,   /* U+472C */
  0x0000,   /* U+472D */
  0x0000,   /* U+472E */
  0x0000,   /* U+472F */
  0x0000,   /* U+4730 */
  0x0000,   /* U+4731 */
  0x0000,   /* U+4732 */
  0x0000,   /* U+4733 */
  0x0000,   /* U+4734 */
  0x0000,   /* U+4735 */
  0x0000,   /* U+4736 */
  0x0000,   /* U+4737 */
  0x0000,   /* U+4738 */
  0x0000,   /* U+4739 */
  0x0000,   /* U+473A */
  0x0000,   /* U+473B */
  0x0000,   /* U+473C */
  0x0000,   /* U+473D */
  0x0000,   /* U+473E */
  0x0000,   /* U+473F */
  0x0000,   /* U+4740 */
  0x0000,   /* U+4741 */
  0x0000,   /* U+4742 */
  0x0000,   /* U+4743 */
  0x0000,   /* U+4744 */
  0x0000,   /* U+4745 */
  0x0000,   /* U+4746 */
  0x0000,   /* U+4747 */
  0x0000,   /* U+4748 */
  0x0000,   /* U+4749 */
  0x0000,   /* U+474A */
  0x0000,   /* U+474B */
  0x0000,   /* U+474C */
  0x0000,   /* U+474D */
  0x0000,   /* U+474E */
  0x0000,   /* U+474F */
  0x0000,   /* U+4750 */
  0x0000,   /* U+4751 */
  0x0000,   /* U+4752 */
  0x0000,   /* U+4753 */
  0x0000,   /* U+4754 */
  0x0000,   /* U+4755 */
  0x0000,   /* U+4756 */
  0x0000,   /* U+4757 */
  0x0000,   /* U+4758 */
  0x0000,   /* U+4759 */
  0x0000,   /* U+475A */
  0x0000,   /* U+475B */
  0x0000,   /* U+475C */
  0x0000,   /* U+475D */
  0x0000,   /* U+475E */
  0x0000,   /* U+475F */
  0x0000,   /* U+4760 */
  0x0000,   /* U+4761 */
  0x0000,   /* U+4762 */
  0x0000,   /* U+4763 */
  0x0000,   /* U+4764 */
  0x0000,   /* U+4765 */
  0x0000,   /* U+4766 */
  0x0000,   /* U+4767 */
  0x0000,   /* U+4768 */
  0x0000,   /* U+4769 */
  0x0000,   /* U+476A */
  0x0000,   /* U+476B */
  0x0000,   /* U+476C */
  0x0000,   /* U+476D */
  0x0000,   /* U+476E */
  0x0000,   /* U+476F */
  0x0000,   /* U+4770 */
  0x0000,   /* U+4771 */
  0x0000,   /* U+4772 */
  0x0000,   /* U+4773 */
  0x0000,   /* U+4774 */
  0x0000,   /* U+4775 */
  0x0000,   /* U+4776 */
  0x0000,   /* U+4777 */
  0x0000,   /* U+4778 */
  0x0000,   /* U+4779 */
  0x0000,   /* U+477A */
  0x0000,   /* U+477B */
  0x0000,   /* U+477C */
  0x0000,   /* U+477D */
  0x0000,   /* U+477E */
  0x0000,   /* U+477F */
  0x0000,   /* U+4780 */
  0x0000,   /* U+4781 */
  0x0000,   /* U+4782 */
  0x0000,   /* U+4783 */
  0x0000,   /* U+4784 */
  0x0000,   /* U+4785 */
  0x0000,   /* U+4786 */
  0x0000,   /* U+4787 */
  0x0000,   /* U+4788 */
  0x0000,   /* U+4789 */
  0x0000,   /* U+478A */
  0x0000,   /* U+478B */
  0x0000,   /* U+478C */
  0x0000,   /* U+478D */
  0x0000,   /* U+478E */
  0x0000,   /* U+478F */
  0x0000,   /* U+4790 */
  0x0000,   /* U+4791 */
  0x0000,   /* U+4792 */
  0x0000,   /* U+4793 */
  0x0000,   /* U+4794 */
  0x0000,   /* U+4795 */
  0x0000,   /* U+4796 */
  0x0000,   /* U+4797 */
  0x0000,   /* U+4798 */
  0x0000,   /* U+4799 */
  0x0000,   /* U+479A */
  0x0000,   /* U+479B */
  0x0000,   /* U+479C */
  0x0000,   /* U+479D */
  0x0000,   /* U+479E */
  0x0000,   /* U+479F */
  0x0000,   /* U+47A0 */
  0x0000,   /* U+47A1 */
  0x0000,   /* U+47A2 */
  0x0000,   /* U+47A3 */
  0x0000,   /* U+47A4 */
  0x0000,   /* U+47A5 */
  0x0000,   /* U+47A6 */
  0x0000,   /* U+47A7 */
  0x0000,   /* U+47A8 */
  0x0000,   /* U+47A9 */
  0x0000,   /* U+47AA */
  0x0000,   /* U+47AB */
  0x0000,   /* U+47AC */
  0x0000,   /* U+47AD */
  0x0000,   /* U+47AE */
  0x0000,   /* U+47AF */
  0x0000,   /* U+47B0 */
  0x0000,   /* U+47B1 */
  0x0000,   /* U+47B2 */
  0x0000,   /* U+47B3 */
  0x0000,   /* U+47B4 */
  0x0000,   /* U+47B5 */
  0x0000,   /* U+47B6 */
  0x0000,   /* U+47B7 */
  0x0000,   /* U+47B8 */
  0x0000,   /* U+47B9 */
  0x0000,   /* U+47BA */
  0x0000,   /* U+47BB */
  0x0000,   /* U+47BC */
  0x0000,   /* U+47BD */
  0x0000,   /* U+47BE */
  0x0000,   /* U+47BF */
  0x0000,   /* U+47C0 */
  0x0000,   /* U+47C1 */
  0x0000,   /* U+47C2 */
  0x0000,   /* U+47C3 */
  0x0000,   /* U+47C4 */
  0x0000,   /* U+47C5 */
  0x0000,   /* U+47C6 */
  0x0000,   /* U+47C7 */
  0x0000,   /* U+47C8 */
  0x0000,   /* U+47C9 */
  0x0000,   /* U+47CA */
  0x0000,   /* U+47CB */
  0x0000,   /* U+47CC */
  0x0000,   /* U+47CD */
  0x0000,   /* U+47CE */
  0x0000,   /* U+47CF */
  0x0000,   /* U+47D0 */
  0x0000,   /* U+47D1 */
  0x0000,   /* U+47D2 */
  0x0000,   /* U+47D3 */
  0x0000,   /* U+47D4 */
  0x0000,   /* U+47D5 */
  0x0000,   /* U+47D6 */
  0x0000,   /* U+47D7 */
  0x0000,   /* U+47D8 */
  0x0000,   /* U+47D9 */
  0x0000,   /* U+47DA */
  0x0000,   /* U+47DB */
  0x0000,   /* U+47DC */
  0x0000,   /* U+47DD */
  0x0000,   /* U+47DE */
  0x0000,   /* U+47DF */
  0x0000,   /* U+47E0 */
  0x0000,   /* U+47E1 */
  0x0000,   /* U+47E2 */
  0x0000,   /* U+47E3 */
  0x0000,   /* U+47E4 */
  0x0000,   /* U+47E5 */
  0x0000,   /* U+47E6 */
  0x0000,   /* U+47E7 */
  0x0000,   /* U+47E8 */
  0x0000,   /* U+47E9 */
  0x0000,   /* U+47EA */
  0x0000,   /* U+47EB */
  0x0000,   /* U+47EC */
  0x0000,   /* U+47ED */
  0x0000,   /* U+47EE */
  0x0000,   /* U+47EF */
  0x0000,   /* U+47F0 */
  0x0000,   /* U+47F1 */
  0x0000,   /* U+47F2 */
  0x0000,   /* U+47F3 */
  0x0000,   /* U+47F4 */
  0x0000,   /* U+47F5 */
  0x0000,   /* U+47F6 */
  0x0000,   /* U+47F7 */
  0x0000,   /* U+47F8 */
  0x0000,   /* U+47F9 */
  0x0000,   /* U+47FA */
  0x0000,   /* U+47FB */
  0x0000,   /* U+47FC */
  0x0000,   /* U+47FD */
  0x0000,   /* U+47FE */
  0x0000,   /* U+47FF */
};

uint16 zh2_han_p048[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x4394,   /* U+4800 */
  0x4394,   /* U+4801 */
  0x4394,   /* U+4802 */
  0x4394,   /* U+4803 */
  0x4394,   /* U+4804 */
  0x4394,   /* U+4805 */
  0x4394,   /* U+4806 */
  0x4394,   /* U+4807 */
  0x4394,   /* U+4808 */
  0x4394,   /* U+4809 */
  0x4394,   /* U+480A */
  0x4394,   /* U+480B */
  0x4394,   /* U+480C */
  0x4395,   /* U+480D */
  0x4395,   /* U+480E */
  0x4395,   /* U+480F */
  0x4395,   /* U+4810 */
  0x4395,   /* U+4811 */
  0x4395,   /* U+4812 */
  0x4395,   /* U+4813 */
  0x4395,   /* U+4814 */
  0x4395,   /* U+4815 */
  0x4395,   /* U+4816 */
  0x438D,   /* U+4817 */
  0x438D,   /* U+4818 */
  0x438D,   /* U+4819 */
  0x438D,   /* U+481A */
  0x438D,   /* U+481B */
  0x438D,   /* U+481C */
  0x438D,   /* U+481D */
  0x4397,   /* U+481E */
  0x4397,   /* U+481F */
  0x4397,   /* U+4820 */
  0x4397,   /* U+4821 */
  0x4397,   /* U+4822 */
  0x4398,   /* U+4823 */
  0x4398,   /* U+4824 */
  0x4398,   /* U+4825 */
  0x4398,   /* U+4826 */
  0x4398,   /* U+4827 */
  0x4399,   /* U+4828 */
  0x4399,   /* U+4829 */
  0x439A,   /* U+482A */
  0x439A,   /* U+482B */
  0x439B,   /* U+482C */
  0x439C,   /* U+482D */
  0x439C,   /* U+482E */
  0x439D,   /* U+482F */
  0x439E,   /* U+4830 */
  0x43A1,   /* U+4831 */
  0x43D1,   /* U+4832 */
  0x43D1,   /* U+4833 */
  0x43D1,   /* U+4834 */
  0x43D1,   /* U+4835 */
  0x43D1,   /* U+4836 */
  0x43D2,   /* U+4837 */
  0x43D2,   /* U+4838 */
  0x43D2,   /* U+4839 */
  0x43D2,   /* U+483A */
  0x43D4,   /* U+483B */
  0x43D5,   /* U+483C */
  0x43CD,   /* U+483D */
  0x43CD,   /* U+483E */
  0x43D8,   /* U+483F */
  0x43D9,   /* U+4840 */
  0x43DC,   /* U+4841 */
  0x440E,   /* U+4842 */
  0x440E,   /* U+4843 */
  0x5C49,   /* U+4844 */
  0x440F,   /* U+4845 */
  0x4410,   /* U+4846 */
  0x4410,   /* U+4847 */
  0x4410,   /* U+4848 */
  0x4410,   /* U+4849 */
  0x4410,   /* U+484A */
  0x4410,   /* U+484B */
  0x4410,   /* U+484C */
  0x4410,   /* U+484D */
  0x4410,   /* U+484E */
  0x4411,   /* U+484F */
  0x4411,   /* U+4850 */
  0x4411,   /* U+4851 */
  0x4411,   /* U+4852 */
  0x4412,   /* U+4853 */
  0x4412,   /* U+4854 */
  0x4412,   /* U+4855 */
  0x4412,   /* U+4856 */
  0x4412,   /* U+4857 */
  0x4413,   /* U+4858 */
  0x4413,   /* U+4859 */
  0x4413,   /* U+485A */
  0x4413,   /* U+485B */
  0x4414,   /* U+485C */
  0x4414,   /* U+485D */
  0x4414,   /* U+485E */
  0x4414,   /* U+485F */
  0x4415,   /* U+4860 */
  0x4415,   /* U+4861 */
  0x4415,   /* U+4862 */
  0x4415,   /* U+4863 */
  0x4415,   /* U+4864 */
  0x440D,   /* U+4865 */
  0x440D,   /* U+4866 */
  0x440D,   /* U+4867 */
  0x440D,   /* U+4868 */
  0x440D,   /* U+4869 */
  0x440D,   /* U+486A */
  0x4417,   /* U+486B */
  0x4417,   /* U+486C */
  0x4417,   /* U+486D */
  0x4417,   /* U+486E */
  0x4417,   /* U+486F */
  0x4417,   /* U+4870 */
  0x4417,   /* U+4871 */
  0x4418,   /* U+4872 */
  0x4418,   /* U+4873 */
  0x4418,   /* U+4874 */
  0x4418,   /* U+4875 */
  0x4419,   /* U+4876 */
  0x441A,   /* U+4877 */
  0x441A,   /* U+4878 */
  0x441A,   /* U+4879 */
  0x441B,   /* U+487A */
  0x441B,   /* U+487B */
  0x441D,   /* U+487C */
  0x441F,   /* U+487D */
  0x440E,   /* U+487E */
  0x4424,   /* U+487F */
  0x440F,   /* U+4880 */
  0x4410,   /* U+4881 */
  0x4411,   /* U+4882 */
  0x4454,   /* U+4883 */
  0x4459,   /* U+4884 */
  0x4492,   /* U+4885 */
  0x4493,   /* U+4886 */
  0x4494,   /* U+4887 */
  0x4499,   /* U+4888 */
  0x4499,   /* U+4889 */
  0x44CF,   /* U+488A */
  0x44CF,   /* U+488B */
  0x44D0,   /* U+488C */
  0x44D0,   /* U+488D */
  0x44D0,   /* U+488E */
  0x5C49,   /* U+488F */
  0x44D1,   /* U+4890 */
  0x44D1,   /* U+4891 */
  0x44D2,   /* U+4892 */
  0x44D2,   /* U+4893 */
  0x44D2,   /* U+4894 */
  0x44D2,   /* U+4895 */
  0x44D2,   /* U+4896 */
  0x44D2,   /* U+4897 */
  0x5C49,   /* U+4898 */
  0x44D3,   /* U+4899 */
  0x44D3,   /* U+489A */
  0x44D3,   /* U+489B */
  0x44D4,   /* U+489C */
  0x44D4,   /* U+489D */
  0x44D4,   /* U+489E */
  0x44D4,   /* U+489F */
  0x44D4,   /* U+48A0 */
  0x44D5,   /* U+48A1 */
  0x44CD,   /* U+48A2 */
  0x44CD,   /* U+48A3 */
  0x44CD,   /* U+48A4 */
  0x44CD,   /* U+48A5 */
  0x44D7,   /* U+48A6 */
  0x44D7,   /* U+48A7 */
  0x44D7,   /* U+48A8 */
  0x44D7,   /* U+48A9 */
  0x44D8,   /* U+48AA */
  0x44D8,   /* U+48AB */
  0x44D8,   /* U+48AC */
  0x44D8,   /* U+48AD */
  0x44D9,   /* U+48AE */
  0x44DA,   /* U+48AF */
  0x44DA,   /* U+48B0 */
  0x44DB,   /* U+48B1 */
  0x44CE,   /* U+48B2 */
  0x450E,   /* U+48B3 */
  0x450F,   /* U+48B4 */
  0x4510,   /* U+48B5 */
  0x4510,   /* U+48B6 */
  0x5C49,   /* U+48B7 */
  0x4511,   /* U+48B8 */
  0x4511,   /* U+48B9 */
  0x4511,   /* U+48BA */
  0x4512,   /* U+48BB */
  0x4512,   /* U+48BC */
  0x4512,   /* U+48BD */
  0x4512,   /* U+48BE */
  0x4512,   /* U+48BF */
  0x4512,   /* U+48C0 */
  0x4512,   /* U+48C1 */
  0x4512,   /* U+48C2 */
  0x4513,   /* U+48C3 */
  0x4513,   /* U+48C4 */
  0x4513,   /* U+48C5 */
  0x4513,   /* U+48C6 */
  0x4513,   /* U+48C7 */
  0x4513,   /* U+48C8 */
  0x5C49,   /* U+48C9 */
  0x4514,   /* U+48CA */
  0x4514,   /* U+48CB */
  0x4514,   /* U+48CC */
  0x4514,   /* U+48CD */
  0x4514,   /* U+48CE */
  0x4514,   /* U+48CF */
  0x4515,   /* U+48D0 */
  0x4515,   /* U+48D1 */
  0x4515,   /* U+48D2 */
  0x450D,   /* U+48D3 */
  0x450D,   /* U+48D4 */
  0x450D,   /* U+48D5 */
  0x450D,   /* U+48D6 */
  0x450D,   /* U+48D7 */
  0x4517,   /* U+48D8 */
  0x4517,   /* U+48D9 */
  0x4517,   /* U+48DA */
  0x4517,   /* U+48DB */
  0x4517,   /* U+48DC */
  0x4518,   /* U+48DD */
  0x4518,   /* U+48DE */
  0x4518,   /* U+48DF */
  0x4518,   /* U+48E0 */
  0x4519,   /* U+48E1 */
  0x451A,   /* U+48E2 */
  0x450E,   /* U+48E3 */
  0x450E,   /* U+48E4 */
  0x454E,   /* U+48E5 */
  0x454E,   /* U+48E6 */
  0x454F,   /* U+48E7 */
  0x454F,   /* U+48E8 */
  0x4550,   /* U+48E9 */
  0x4550,   /* U+48EA */
  0x4550,   /* U+48EB */
  0x4550,   /* U+48EC */
  0x5C49,   /* U+48ED */
  0x4551,   /* U+48EE */
  0x4551,   /* U+48EF */
  0x4551,   /* U+48F0 */
  0x4551,   /* U+48F1 */
  0x4551,   /* U+48F2 */
  0x4551,   /* U+48F3 */
  0x4552,   /* U+48F4 */
  0x4552,   /* U+48F5 */
  0x4552,   /* U+48F6 */
  0x4552,   /* U+48F7 */
  0x4552,   /* U+48F8 */
  0x4552,   /* U+48F9 */
  0x4553,   /* U+48FA */
  0x4553,   /* U+48FB */
  0x4554,   /* U+48FC */
  0x4554,   /* U+48FD */
  0x4554,   /* U+48FE */
  0x4554,   /* U+48FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4800 */
  0x0020,   /* U+4801 */
  0x0020,   /* U+4802 */
  0x0020,   /* U+4803 */
  0x0020,   /* U+4804 */
  0x0020,   /* U+4805 */
  0x0020,   /* U+4806 */
  0x0020,   /* U+4807 */
  0x0020,   /* U+4808 */
  0x0020,   /* U+4809 */
  0x0020,   /* U+480A */
  0x0020,   /* U+480B */
  0x0020,   /* U+480C */
  0x0020,   /* U+480D */
  0x0020,   /* U+480E */
  0x0020,   /* U+480F */
  0x0020,   /* U+4810 */
  0x0020,   /* U+4811 */
  0x0020,   /* U+4812 */
  0x0020,   /* U+4813 */
  0x0020,   /* U+4814 */
  0x0020,   /* U+4815 */
  0x0020,   /* U+4816 */
  0x0020,   /* U+4817 */
  0x0020,   /* U+4818 */
  0x0020,   /* U+4819 */
  0x0020,   /* U+481A */
  0x0020,   /* U+481B */
  0x0020,   /* U+481C */
  0x0020,   /* U+481D */
  0x0020,   /* U+481E */
  0x0020,   /* U+481F */
  0x0020,   /* U+4820 */
  0x0020,   /* U+4821 */
  0x0020,   /* U+4822 */
  0x0020,   /* U+4823 */
  0x0020,   /* U+4824 */
  0x0020,   /* U+4825 */
  0x0020,   /* U+4826 */
  0x0020,   /* U+4827 */
  0x0020,   /* U+4828 */
  0x0020,   /* U+4829 */
  0x0020,   /* U+482A */
  0x0020,   /* U+482B */
  0x0020,   /* U+482C */
  0x0020,   /* U+482D */
  0x0020,   /* U+482E */
  0x0020,   /* U+482F */
  0x0020,   /* U+4830 */
  0x0020,   /* U+4831 */
  0x0020,   /* U+4832 */
  0x0020,   /* U+4833 */
  0x0020,   /* U+4834 */
  0x0020,   /* U+4835 */
  0x0020,   /* U+4836 */
  0x0020,   /* U+4837 */
  0x0020,   /* U+4838 */
  0x0020,   /* U+4839 */
  0x0020,   /* U+483A */
  0x0020,   /* U+483B */
  0x0020,   /* U+483C */
  0x0020,   /* U+483D */
  0x0020,   /* U+483E */
  0x0020,   /* U+483F */
  0x0020,   /* U+4840 */
  0x0020,   /* U+4841 */
  0x0020,   /* U+4842 */
  0x0020,   /* U+4843 */
  0x0020,   /* U+4844 */
  0x0020,   /* U+4845 */
  0x0020,   /* U+4846 */
  0x0020,   /* U+4847 */
  0x0020,   /* U+4848 */
  0x0020,   /* U+4849 */
  0x0020,   /* U+484A */
  0x0020,   /* U+484B */
  0x0020,   /* U+484C */
  0x0020,   /* U+484D */
  0x0020,   /* U+484E */
  0x0020,   /* U+484F */
  0x0020,   /* U+4850 */
  0x0020,   /* U+4851 */
  0x0020,   /* U+4852 */
  0x0020,   /* U+4853 */
  0x0020,   /* U+4854 */
  0x0020,   /* U+4855 */
  0x0020,   /* U+4856 */
  0x0020,   /* U+4857 */
  0x0020,   /* U+4858 */
  0x0020,   /* U+4859 */
  0x0020,   /* U+485A */
  0x0020,   /* U+485B */
  0x0020,   /* U+485C */
  0x0020,   /* U+485D */
  0x0020,   /* U+485E */
  0x0020,   /* U+485F */
  0x0020,   /* U+4860 */
  0x0020,   /* U+4861 */
  0x0020,   /* U+4862 */
  0x0020,   /* U+4863 */
  0x0020,   /* U+4864 */
  0x0020,   /* U+4865 */
  0x0020,   /* U+4866 */
  0x0020,   /* U+4867 */
  0x0020,   /* U+4868 */
  0x0020,   /* U+4869 */
  0x0020,   /* U+486A */
  0x0020,   /* U+486B */
  0x0020,   /* U+486C */
  0x0020,   /* U+486D */
  0x0020,   /* U+486E */
  0x0020,   /* U+486F */
  0x0020,   /* U+4870 */
  0x0020,   /* U+4871 */
  0x0020,   /* U+4872 */
  0x0020,   /* U+4873 */
  0x0020,   /* U+4874 */
  0x0020,   /* U+4875 */
  0x0020,   /* U+4876 */
  0x0020,   /* U+4877 */
  0x0020,   /* U+4878 */
  0x0020,   /* U+4879 */
  0x0020,   /* U+487A */
  0x0020,   /* U+487B */
  0x0020,   /* U+487C */
  0x0020,   /* U+487D */
  0x0020,   /* U+487E */
  0x0020,   /* U+487F */
  0x0020,   /* U+4880 */
  0x0020,   /* U+4881 */
  0x0020,   /* U+4882 */
  0x0020,   /* U+4883 */
  0x0020,   /* U+4884 */
  0x0020,   /* U+4885 */
  0x0020,   /* U+4886 */
  0x0020,   /* U+4887 */
  0x0020,   /* U+4888 */
  0x0020,   /* U+4889 */
  0x0020,   /* U+488A */
  0x0020,   /* U+488B */
  0x0020,   /* U+488C */
  0x0020,   /* U+488D */
  0x0020,   /* U+488E */
  0x0020,   /* U+488F */
  0x0020,   /* U+4890 */
  0x0020,   /* U+4891 */
  0x0020,   /* U+4892 */
  0x0020,   /* U+4893 */
  0x0020,   /* U+4894 */
  0x0020,   /* U+4895 */
  0x0020,   /* U+4896 */
  0x0020,   /* U+4897 */
  0x0020,   /* U+4898 */
  0x0020,   /* U+4899 */
  0x0020,   /* U+489A */
  0x0020,   /* U+489B */
  0x0020,   /* U+489C */
  0x0020,   /* U+489D */
  0x0020,   /* U+489E */
  0x0020,   /* U+489F */
  0x0020,   /* U+48A0 */
  0x0020,   /* U+48A1 */
  0x0020,   /* U+48A2 */
  0x0020,   /* U+48A3 */
  0x0020,   /* U+48A4 */
  0x0020,   /* U+48A5 */
  0x0020,   /* U+48A6 */
  0x0020,   /* U+48A7 */
  0x0020,   /* U+48A8 */
  0x0020,   /* U+48A9 */
  0x0020,   /* U+48AA */
  0x0020,   /* U+48AB */
  0x0020,   /* U+48AC */
  0x0020,   /* U+48AD */
  0x0020,   /* U+48AE */
  0x0020,   /* U+48AF */
  0x0020,   /* U+48B0 */
  0x0020,   /* U+48B1 */
  0x0020,   /* U+48B2 */
  0x0020,   /* U+48B3 */
  0x0020,   /* U+48B4 */
  0x0020,   /* U+48B5 */
  0x0020,   /* U+48B6 */
  0x0020,   /* U+48B7 */
  0x0020,   /* U+48B8 */
  0x0020,   /* U+48B9 */
  0x0020,   /* U+48BA */
  0x0020,   /* U+48BB */
  0x0020,   /* U+48BC */
  0x0020,   /* U+48BD */
  0x0020,   /* U+48BE */
  0x0020,   /* U+48BF */
  0x0020,   /* U+48C0 */
  0x0020,   /* U+48C1 */
  0x0020,   /* U+48C2 */
  0x0020,   /* U+48C3 */
  0x0020,   /* U+48C4 */
  0x0020,   /* U+48C5 */
  0x0020,   /* U+48C6 */
  0x0020,   /* U+48C7 */
  0x0020,   /* U+48C8 */
  0x0020,   /* U+48C9 */
  0x0020,   /* U+48CA */
  0x0020,   /* U+48CB */
  0x0020,   /* U+48CC */
  0x0020,   /* U+48CD */
  0x0020,   /* U+48CE */
  0x0020,   /* U+48CF */
  0x0020,   /* U+48D0 */
  0x0020,   /* U+48D1 */
  0x0020,   /* U+48D2 */
  0x0020,   /* U+48D3 */
  0x0020,   /* U+48D4 */
  0x0020,   /* U+48D5 */
  0x0020,   /* U+48D6 */
  0x0020,   /* U+48D7 */
  0x0020,   /* U+48D8 */
  0x0020,   /* U+48D9 */
  0x0020,   /* U+48DA */
  0x0020,   /* U+48DB */
  0x0020,   /* U+48DC */
  0x0020,   /* U+48DD */
  0x0020,   /* U+48DE */
  0x0020,   /* U+48DF */
  0x0020,   /* U+48E0 */
  0x0020,   /* U+48E1 */
  0x0020,   /* U+48E2 */
  0x0020,   /* U+48E3 */
  0x0020,   /* U+48E4 */
  0x0020,   /* U+48E5 */
  0x0020,   /* U+48E6 */
  0x0020,   /* U+48E7 */
  0x0020,   /* U+48E8 */
  0x0020,   /* U+48E9 */
  0x0020,   /* U+48EA */
  0x0020,   /* U+48EB */
  0x0020,   /* U+48EC */
  0x0020,   /* U+48ED */
  0x0020,   /* U+48EE */
  0x0020,   /* U+48EF */
  0x0020,   /* U+48F0 */
  0x0020,   /* U+48F1 */
  0x0020,   /* U+48F2 */
  0x0020,   /* U+48F3 */
  0x0020,   /* U+48F4 */
  0x0020,   /* U+48F5 */
  0x0020,   /* U+48F6 */
  0x0020,   /* U+48F7 */
  0x0020,   /* U+48F8 */
  0x0020,   /* U+48F9 */
  0x0020,   /* U+48FA */
  0x0020,   /* U+48FB */
  0x0020,   /* U+48FC */
  0x0020,   /* U+48FD */
  0x0020,   /* U+48FE */
  0x0020,   /* U+48FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4800 */
  0x0002,   /* U+4801 */
  0x0002,   /* U+4802 */
  0x0002,   /* U+4803 */
  0x0002,   /* U+4804 */
  0x0002,   /* U+4805 */
  0x0002,   /* U+4806 */
  0x0002,   /* U+4807 */
  0x0002,   /* U+4808 */
  0x0002,   /* U+4809 */
  0x0002,   /* U+480A */
  0x0002,   /* U+480B */
  0x0002,   /* U+480C */
  0x0002,   /* U+480D */
  0x0002,   /* U+480E */
  0x0002,   /* U+480F */
  0x0002,   /* U+4810 */
  0x0002,   /* U+4811 */
  0x0002,   /* U+4812 */
  0x0002,   /* U+4813 */
  0x0002,   /* U+4814 */
  0x0002,   /* U+4815 */
  0x0002,   /* U+4816 */
  0x0002,   /* U+4817 */
  0x0002,   /* U+4818 */
  0x0002,   /* U+4819 */
  0x0002,   /* U+481A */
  0x0002,   /* U+481B */
  0x0002,   /* U+481C */
  0x0002,   /* U+481D */
  0x0002,   /* U+481E */
  0x0002,   /* U+481F */
  0x0002,   /* U+4820 */
  0x0002,   /* U+4821 */
  0x0002,   /* U+4822 */
  0x0002,   /* U+4823 */
  0x0002,   /* U+4824 */
  0x0002,   /* U+4825 */
  0x0002,   /* U+4826 */
  0x0002,   /* U+4827 */
  0x0002,   /* U+4828 */
  0x0002,   /* U+4829 */
  0x0002,   /* U+482A */
  0x0002,   /* U+482B */
  0x0002,   /* U+482C */
  0x0002,   /* U+482D */
  0x0002,   /* U+482E */
  0x0002,   /* U+482F */
  0x0002,   /* U+4830 */
  0x0002,   /* U+4831 */
  0x0002,   /* U+4832 */
  0x0002,   /* U+4833 */
  0x0002,   /* U+4834 */
  0x0002,   /* U+4835 */
  0x0002,   /* U+4836 */
  0x0002,   /* U+4837 */
  0x0002,   /* U+4838 */
  0x0002,   /* U+4839 */
  0x0002,   /* U+483A */
  0x0002,   /* U+483B */
  0x0002,   /* U+483C */
  0x0002,   /* U+483D */
  0x0002,   /* U+483E */
  0x0002,   /* U+483F */
  0x0002,   /* U+4840 */
  0x0002,   /* U+4841 */
  0x0002,   /* U+4842 */
  0x0002,   /* U+4843 */
  0x0002,   /* U+4844 */
  0x0002,   /* U+4845 */
  0x0002,   /* U+4846 */
  0x0002,   /* U+4847 */
  0x0002,   /* U+4848 */
  0x0002,   /* U+4849 */
  0x0002,   /* U+484A */
  0x0002,   /* U+484B */
  0x0002,   /* U+484C */
  0x0002,   /* U+484D */
  0x0002,   /* U+484E */
  0x0002,   /* U+484F */
  0x0002,   /* U+4850 */
  0x0002,   /* U+4851 */
  0x0002,   /* U+4852 */
  0x0002,   /* U+4853 */
  0x0002,   /* U+4854 */
  0x0002,   /* U+4855 */
  0x0002,   /* U+4856 */
  0x0002,   /* U+4857 */
  0x0002,   /* U+4858 */
  0x0002,   /* U+4859 */
  0x0002,   /* U+485A */
  0x0002,   /* U+485B */
  0x0002,   /* U+485C */
  0x0002,   /* U+485D */
  0x0002,   /* U+485E */
  0x0002,   /* U+485F */
  0x0002,   /* U+4860 */
  0x0002,   /* U+4861 */
  0x0002,   /* U+4862 */
  0x0002,   /* U+4863 */
  0x0002,   /* U+4864 */
  0x0002,   /* U+4865 */
  0x0002,   /* U+4866 */
  0x0002,   /* U+4867 */
  0x0002,   /* U+4868 */
  0x0002,   /* U+4869 */
  0x0002,   /* U+486A */
  0x0002,   /* U+486B */
  0x0002,   /* U+486C */
  0x0002,   /* U+486D */
  0x0002,   /* U+486E */
  0x0002,   /* U+486F */
  0x0002,   /* U+4870 */
  0x0002,   /* U+4871 */
  0x0002,   /* U+4872 */
  0x0002,   /* U+4873 */
  0x0002,   /* U+4874 */
  0x0002,   /* U+4875 */
  0x0002,   /* U+4876 */
  0x0002,   /* U+4877 */
  0x0002,   /* U+4878 */
  0x0002,   /* U+4879 */
  0x0002,   /* U+487A */
  0x0002,   /* U+487B */
  0x0002,   /* U+487C */
  0x0002,   /* U+487D */
  0x0002,   /* U+487E */
  0x0002,   /* U+487F */
  0x0002,   /* U+4880 */
  0x0002,   /* U+4881 */
  0x0002,   /* U+4882 */
  0x0002,   /* U+4883 */
  0x0002,   /* U+4884 */
  0x0002,   /* U+4885 */
  0x0002,   /* U+4886 */
  0x0002,   /* U+4887 */
  0x0002,   /* U+4888 */
  0x0002,   /* U+4889 */
  0x0002,   /* U+488A */
  0x0002,   /* U+488B */
  0x0002,   /* U+488C */
  0x0002,   /* U+488D */
  0x0002,   /* U+488E */
  0x0002,   /* U+488F */
  0x0002,   /* U+4890 */
  0x0002,   /* U+4891 */
  0x0002,   /* U+4892 */
  0x0002,   /* U+4893 */
  0x0002,   /* U+4894 */
  0x0002,   /* U+4895 */
  0x0002,   /* U+4896 */
  0x0002,   /* U+4897 */
  0x0002,   /* U+4898 */
  0x0002,   /* U+4899 */
  0x0002,   /* U+489A */
  0x0002,   /* U+489B */
  0x0002,   /* U+489C */
  0x0002,   /* U+489D */
  0x0002,   /* U+489E */
  0x0002,   /* U+489F */
  0x0002,   /* U+48A0 */
  0x0002,   /* U+48A1 */
  0x0002,   /* U+48A2 */
  0x0002,   /* U+48A3 */
  0x0002,   /* U+48A4 */
  0x0002,   /* U+48A5 */
  0x0002,   /* U+48A6 */
  0x0002,   /* U+48A7 */
  0x0002,   /* U+48A8 */
  0x0002,   /* U+48A9 */
  0x0002,   /* U+48AA */
  0x0002,   /* U+48AB */
  0x0002,   /* U+48AC */
  0x0002,   /* U+48AD */
  0x0002,   /* U+48AE */
  0x0002,   /* U+48AF */
  0x0002,   /* U+48B0 */
  0x0002,   /* U+48B1 */
  0x0002,   /* U+48B2 */
  0x0002,   /* U+48B3 */
  0x0002,   /* U+48B4 */
  0x0002,   /* U+48B5 */
  0x0002,   /* U+48B6 */
  0x0002,   /* U+48B7 */
  0x0002,   /* U+48B8 */
  0x0002,   /* U+48B9 */
  0x0002,   /* U+48BA */
  0x0002,   /* U+48BB */
  0x0002,   /* U+48BC */
  0x0002,   /* U+48BD */
  0x0002,   /* U+48BE */
  0x0002,   /* U+48BF */
  0x0002,   /* U+48C0 */
  0x0002,   /* U+48C1 */
  0x0002,   /* U+48C2 */
  0x0002,   /* U+48C3 */
  0x0002,   /* U+48C4 */
  0x0002,   /* U+48C5 */
  0x0002,   /* U+48C6 */
  0x0002,   /* U+48C7 */
  0x0002,   /* U+48C8 */
  0x0002,   /* U+48C9 */
  0x0002,   /* U+48CA */
  0x0002,   /* U+48CB */
  0x0002,   /* U+48CC */
  0x0002,   /* U+48CD */
  0x0002,   /* U+48CE */
  0x0002,   /* U+48CF */
  0x0002,   /* U+48D0 */
  0x0002,   /* U+48D1 */
  0x0002,   /* U+48D2 */
  0x0002,   /* U+48D3 */
  0x0002,   /* U+48D4 */
  0x0002,   /* U+48D5 */
  0x0002,   /* U+48D6 */
  0x0002,   /* U+48D7 */
  0x0002,   /* U+48D8 */
  0x0002,   /* U+48D9 */
  0x0002,   /* U+48DA */
  0x0002,   /* U+48DB */
  0x0002,   /* U+48DC */
  0x0002,   /* U+48DD */
  0x0002,   /* U+48DE */
  0x0002,   /* U+48DF */
  0x0002,   /* U+48E0 */
  0x0002,   /* U+48E1 */
  0x0002,   /* U+48E2 */
  0x0002,   /* U+48E3 */
  0x0002,   /* U+48E4 */
  0x0002,   /* U+48E5 */
  0x0002,   /* U+48E6 */
  0x0002,   /* U+48E7 */
  0x0002,   /* U+48E8 */
  0x0002,   /* U+48E9 */
  0x0002,   /* U+48EA */
  0x0002,   /* U+48EB */
  0x0002,   /* U+48EC */
  0x0002,   /* U+48ED */
  0x0002,   /* U+48EE */
  0x0002,   /* U+48EF */
  0x0002,   /* U+48F0 */
  0x0002,   /* U+48F1 */
  0x0002,   /* U+48F2 */
  0x0002,   /* U+48F3 */
  0x0002,   /* U+48F4 */
  0x0002,   /* U+48F5 */
  0x0002,   /* U+48F6 */
  0x0002,   /* U+48F7 */
  0x0002,   /* U+48F8 */
  0x0002,   /* U+48F9 */
  0x0002,   /* U+48FA */
  0x0002,   /* U+48FB */
  0x0002,   /* U+48FC */
  0x0002,   /* U+48FD */
  0x0002,   /* U+48FE */
  0x0002,   /* U+48FF */

  /* Primary weight 2 for each character. */
  0x8003,   /* U+4800 */
  0x8004,   /* U+4801 */
  0x8005,   /* U+4802 */
  0x8006,   /* U+4803 */
  0x8007,   /* U+4804 */
  0x8008,   /* U+4805 */
  0x8009,   /* U+4806 */
  0x800A,   /* U+4807 */
  0x800B,   /* U+4808 */
  0x800C,   /* U+4809 */
  0x800D,   /* U+480A */
  0x800E,   /* U+480B */
  0x800F,   /* U+480C */
  0x8000,   /* U+480D */
  0x8001,   /* U+480E */
  0x8002,   /* U+480F */
  0x8003,   /* U+4810 */
  0x8004,   /* U+4811 */
  0x8005,   /* U+4812 */
  0x8006,   /* U+4813 */
  0x8007,   /* U+4814 */
  0x8008,   /* U+4815 */
  0x8009,   /* U+4816 */
  0x8000,   /* U+4817 */
  0x8001,   /* U+4818 */
  0x8002,   /* U+4819 */
  0x8003,   /* U+481A */
  0x8004,   /* U+481B */
  0x8005,   /* U+481C */
  0x8006,   /* U+481D */
  0x8000,   /* U+481E */
  0x8001,   /* U+481F */
  0x8002,   /* U+4820 */
  0x8003,   /* U+4821 */
  0x8004,   /* U+4822 */
  0x8000,   /* U+4823 */
  0x8001,   /* U+4824 */
  0x8002,   /* U+4825 */
  0x8003,   /* U+4826 */
  0x8004,   /* U+4827 */
  0x8000,   /* U+4828 */
  0x8001,   /* U+4829 */
  0x8000,   /* U+482A */
  0x8001,   /* U+482B */
  0x8000,   /* U+482C */
  0x8000,   /* U+482D */
  0x8001,   /* U+482E */
  0x8000,   /* U+482F */
  0x8000,   /* U+4830 */
  0x8000,   /* U+4831 */
  0x8000,   /* U+4832 */
  0x8001,   /* U+4833 */
  0x8002,   /* U+4834 */
  0x8003,   /* U+4835 */
  0x8004,   /* U+4836 */
  0x8000,   /* U+4837 */
  0x8001,   /* U+4838 */
  0x8002,   /* U+4839 */
  0x8003,   /* U+483A */
  0x8000,   /* U+483B */
  0x8000,   /* U+483C */
  0x8000,   /* U+483D */
  0x8001,   /* U+483E */
  0x8000,   /* U+483F */
  0x8000,   /* U+4840 */
  0x8000,   /* U+4841 */
  0x8001,   /* U+4842 */
  0x8002,   /* U+4843 */
  0xC844,   /* U+4844 */
  0x8006,   /* U+4845 */
  0x800E,   /* U+4846 */
  0x800F,   /* U+4847 */
  0x8010,   /* U+4848 */
  0x8011,   /* U+4849 */
  0x8012,   /* U+484A */
  0x8013,   /* U+484B */
  0x8014,   /* U+484C */
  0x8015,   /* U+484D */
  0x8016,   /* U+484E */
  0x8014,   /* U+484F */
  0x8015,   /* U+4850 */
  0x8016,   /* U+4851 */
  0x8017,   /* U+4852 */
  0x800E,   /* U+4853 */
  0x800F,   /* U+4854 */
  0x8010,   /* U+4855 */
  0x8011,   /* U+4856 */
  0x8012,   /* U+4857 */
  0x8009,   /* U+4858 */
  0x800A,   /* U+4859 */
  0x800B,   /* U+485A */
  0x800C,   /* U+485B */
  0x800D,   /* U+485C */
  0x800E,   /* U+485D */
  0x800F,   /* U+485E */
  0x8010,   /* U+485F */
  0x800D,   /* U+4860 */
  0x800E,   /* U+4861 */
  0x800F,   /* U+4862 */
  0x8010,   /* U+4863 */
  0x8011,   /* U+4864 */
  0x8001,   /* U+4865 */
  0x8002,   /* U+4866 */
  0x8003,   /* U+4867 */
  0x8004,   /* U+4868 */
  0x8005,   /* U+4869 */
  0x8006,   /* U+486A */
  0x8005,   /* U+486B */
  0x8006,   /* U+486C */
  0x8007,   /* U+486D */
  0x8008,   /* U+486E */
  0x8009,   /* U+486F */
  0x800A,   /* U+4870 */
  0x800B,   /* U+4871 */
  0x8004,   /* U+4872 */
  0x8005,   /* U+4873 */
  0x8006,   /* U+4874 */
  0x8007,   /* U+4875 */
  0x8005,   /* U+4876 */
  0x8001,   /* U+4877 */
  0x8002,   /* U+4878 */
  0x8003,   /* U+4879 */
  0x8001,   /* U+487A */
  0x8002,   /* U+487B */
  0x8000,   /* U+487C */
  0x8000,   /* U+487D */
  0x8003,   /* U+487E */
  0x8000,   /* U+487F */
  0x8000,   /* U+4880 */
  0x8000,   /* U+4881 */
  0x8000,   /* U+4882 */
  0x8000,   /* U+4883 */
  0x8000,   /* U+4884 */
  0x8000,   /* U+4885 */
  0x8000,   /* U+4886 */
  0x8000,   /* U+4887 */
  0x8000,   /* U+4888 */
  0x8001,   /* U+4889 */
  0x8000,   /* U+488A */
  0x8001,   /* U+488B */
  0x8000,   /* U+488C */
  0x8001,   /* U+488D */
  0x8002,   /* U+488E */
  0xC88F,   /* U+488F */
  0x8000,   /* U+4890 */
  0x8001,   /* U+4891 */
  0x8000,   /* U+4892 */
  0x8001,   /* U+4893 */
  0x8002,   /* U+4894 */
  0x8003,   /* U+4895 */
  0x8004,   /* U+4896 */
  0x8005,   /* U+4897 */
  0xC898,   /* U+4898 */
  0x8000,   /* U+4899 */
  0x8001,   /* U+489A */
  0x8002,   /* U+489B */
  0x8000,   /* U+489C */
  0x8001,   /* U+489D */
  0x8002,   /* U+489E */
  0x8003,   /* U+489F */
  0x8004,   /* U+48A0 */
  0x8000,   /* U+48A1 */
  0x8000,   /* U+48A2 */
  0x8001,   /* U+48A3 */
  0x8002,   /* U+48A4 */
  0x8003,   /* U+48A5 */
  0x8000,   /* U+48A6 */
  0x8001,   /* U+48A7 */
  0x8002,   /* U+48A8 */
  0x8003,   /* U+48A9 */
  0x8000,   /* U+48AA */
  0x8001,   /* U+48AB */
  0x8002,   /* U+48AC */
  0x8003,   /* U+48AD */
  0x8000,   /* U+48AE */
  0x8000,   /* U+48AF */
  0x8001,   /* U+48B0 */
  0x8000,   /* U+48B1 */
  0x8000,   /* U+48B2 */
  0x8000,   /* U+48B3 */
  0x8000,   /* U+48B4 */
  0x8000,   /* U+48B5 */
  0x8001,   /* U+48B6 */
  0xC8B7,   /* U+48B7 */
  0x8000,   /* U+48B8 */
  0x8001,   /* U+48B9 */
  0x8002,   /* U+48BA */
  0x8000,   /* U+48BB */
  0x8001,   /* U+48BC */
  0x8002,   /* U+48BD */
  0x8003,   /* U+48BE */
  0x8004,   /* U+48BF */
  0x8005,   /* U+48C0 */
  0x8006,   /* U+48C1 */
  0x8007,   /* U+48C2 */
  0x8000,   /* U+48C3 */
  0x8001,   /* U+48C4 */
  0x8002,   /* U+48C5 */
  0x8003,   /* U+48C6 */
  0x8004,   /* U+48C7 */
  0x8005,   /* U+48C8 */
  0xC8C9,   /* U+48C9 */
  0x8000,   /* U+48CA */
  0x8001,   /* U+48CB */
  0x8002,   /* U+48CC */
  0x8003,   /* U+48CD */
  0x8004,   /* U+48CE */
  0x8005,   /* U+48CF */
  0x8000,   /* U+48D0 */
  0x8001,   /* U+48D1 */
  0x8002,   /* U+48D2 */
  0x8000,   /* U+48D3 */
  0x8001,   /* U+48D4 */
  0x8002,   /* U+48D5 */
  0x8003,   /* U+48D6 */
  0x8004,   /* U+48D7 */
  0x8000,   /* U+48D8 */
  0x8001,   /* U+48D9 */
  0x8002,   /* U+48DA */
  0x8003,   /* U+48DB */
  0x8004,   /* U+48DC */
  0x8000,   /* U+48DD */
  0x8001,   /* U+48DE */
  0x8002,   /* U+48DF */
  0x8003,   /* U+48E0 */
  0x8000,   /* U+48E1 */
  0x8000,   /* U+48E2 */
  0x8001,   /* U+48E3 */
  0x8002,   /* U+48E4 */
  0x8000,   /* U+48E5 */
  0x8001,   /* U+48E6 */
  0x8000,   /* U+48E7 */
  0x8001,   /* U+48E8 */
  0x8000,   /* U+48E9 */
  0x8001,   /* U+48EA */
  0x8002,   /* U+48EB */
  0x8003,   /* U+48EC */
  0xC8ED,   /* U+48ED */
  0x8000,   /* U+48EE */
  0x8001,   /* U+48EF */
  0x8002,   /* U+48F0 */
  0x8003,   /* U+48F1 */
  0x8004,   /* U+48F2 */
  0x8005,   /* U+48F3 */
  0x8000,   /* U+48F4 */
  0x8001,   /* U+48F5 */
  0x8002,   /* U+48F6 */
  0x8003,   /* U+48F7 */
  0x8004,   /* U+48F8 */
  0x8005,   /* U+48F9 */
  0x8000,   /* U+48FA */
  0x8001,   /* U+48FB */
  0x8000,   /* U+48FC */
  0x8001,   /* U+48FD */
  0x8002,   /* U+48FE */
  0x8003,   /* U+48FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4800 */
  0x0000,   /* U+4801 */
  0x0000,   /* U+4802 */
  0x0000,   /* U+4803 */
  0x0000,   /* U+4804 */
  0x0000,   /* U+4805 */
  0x0000,   /* U+4806 */
  0x0000,   /* U+4807 */
  0x0000,   /* U+4808 */
  0x0000,   /* U+4809 */
  0x0000,   /* U+480A */
  0x0000,   /* U+480B */
  0x0000,   /* U+480C */
  0x0000,   /* U+480D */
  0x0000,   /* U+480E */
  0x0000,   /* U+480F */
  0x0000,   /* U+4810 */
  0x0000,   /* U+4811 */
  0x0000,   /* U+4812 */
  0x0000,   /* U+4813 */
  0x0000,   /* U+4814 */
  0x0000,   /* U+4815 */
  0x0000,   /* U+4816 */
  0x0000,   /* U+4817 */
  0x0000,   /* U+4818 */
  0x0000,   /* U+4819 */
  0x0000,   /* U+481A */
  0x0000,   /* U+481B */
  0x0000,   /* U+481C */
  0x0000,   /* U+481D */
  0x0000,   /* U+481E */
  0x0000,   /* U+481F */
  0x0000,   /* U+4820 */
  0x0000,   /* U+4821 */
  0x0000,   /* U+4822 */
  0x0000,   /* U+4823 */
  0x0000,   /* U+4824 */
  0x0000,   /* U+4825 */
  0x0000,   /* U+4826 */
  0x0000,   /* U+4827 */
  0x0000,   /* U+4828 */
  0x0000,   /* U+4829 */
  0x0000,   /* U+482A */
  0x0000,   /* U+482B */
  0x0000,   /* U+482C */
  0x0000,   /* U+482D */
  0x0000,   /* U+482E */
  0x0000,   /* U+482F */
  0x0000,   /* U+4830 */
  0x0000,   /* U+4831 */
  0x0000,   /* U+4832 */
  0x0000,   /* U+4833 */
  0x0000,   /* U+4834 */
  0x0000,   /* U+4835 */
  0x0000,   /* U+4836 */
  0x0000,   /* U+4837 */
  0x0000,   /* U+4838 */
  0x0000,   /* U+4839 */
  0x0000,   /* U+483A */
  0x0000,   /* U+483B */
  0x0000,   /* U+483C */
  0x0000,   /* U+483D */
  0x0000,   /* U+483E */
  0x0000,   /* U+483F */
  0x0000,   /* U+4840 */
  0x0000,   /* U+4841 */
  0x0000,   /* U+4842 */
  0x0000,   /* U+4843 */
  0x0000,   /* U+4844 */
  0x0000,   /* U+4845 */
  0x0000,   /* U+4846 */
  0x0000,   /* U+4847 */
  0x0000,   /* U+4848 */
  0x0000,   /* U+4849 */
  0x0000,   /* U+484A */
  0x0000,   /* U+484B */
  0x0000,   /* U+484C */
  0x0000,   /* U+484D */
  0x0000,   /* U+484E */
  0x0000,   /* U+484F */
  0x0000,   /* U+4850 */
  0x0000,   /* U+4851 */
  0x0000,   /* U+4852 */
  0x0000,   /* U+4853 */
  0x0000,   /* U+4854 */
  0x0000,   /* U+4855 */
  0x0000,   /* U+4856 */
  0x0000,   /* U+4857 */
  0x0000,   /* U+4858 */
  0x0000,   /* U+4859 */
  0x0000,   /* U+485A */
  0x0000,   /* U+485B */
  0x0000,   /* U+485C */
  0x0000,   /* U+485D */
  0x0000,   /* U+485E */
  0x0000,   /* U+485F */
  0x0000,   /* U+4860 */
  0x0000,   /* U+4861 */
  0x0000,   /* U+4862 */
  0x0000,   /* U+4863 */
  0x0000,   /* U+4864 */
  0x0000,   /* U+4865 */
  0x0000,   /* U+4866 */
  0x0000,   /* U+4867 */
  0x0000,   /* U+4868 */
  0x0000,   /* U+4869 */
  0x0000,   /* U+486A */
  0x0000,   /* U+486B */
  0x0000,   /* U+486C */
  0x0000,   /* U+486D */
  0x0000,   /* U+486E */
  0x0000,   /* U+486F */
  0x0000,   /* U+4870 */
  0x0000,   /* U+4871 */
  0x0000,   /* U+4872 */
  0x0000,   /* U+4873 */
  0x0000,   /* U+4874 */
  0x0000,   /* U+4875 */
  0x0000,   /* U+4876 */
  0x0000,   /* U+4877 */
  0x0000,   /* U+4878 */
  0x0000,   /* U+4879 */
  0x0000,   /* U+487A */
  0x0000,   /* U+487B */
  0x0000,   /* U+487C */
  0x0000,   /* U+487D */
  0x0000,   /* U+487E */
  0x0000,   /* U+487F */
  0x0000,   /* U+4880 */
  0x0000,   /* U+4881 */
  0x0000,   /* U+4882 */
  0x0000,   /* U+4883 */
  0x0000,   /* U+4884 */
  0x0000,   /* U+4885 */
  0x0000,   /* U+4886 */
  0x0000,   /* U+4887 */
  0x0000,   /* U+4888 */
  0x0000,   /* U+4889 */
  0x0000,   /* U+488A */
  0x0000,   /* U+488B */
  0x0000,   /* U+488C */
  0x0000,   /* U+488D */
  0x0000,   /* U+488E */
  0x0000,   /* U+488F */
  0x0000,   /* U+4890 */
  0x0000,   /* U+4891 */
  0x0000,   /* U+4892 */
  0x0000,   /* U+4893 */
  0x0000,   /* U+4894 */
  0x0000,   /* U+4895 */
  0x0000,   /* U+4896 */
  0x0000,   /* U+4897 */
  0x0000,   /* U+4898 */
  0x0000,   /* U+4899 */
  0x0000,   /* U+489A */
  0x0000,   /* U+489B */
  0x0000,   /* U+489C */
  0x0000,   /* U+489D */
  0x0000,   /* U+489E */
  0x0000,   /* U+489F */
  0x0000,   /* U+48A0 */
  0x0000,   /* U+48A1 */
  0x0000,   /* U+48A2 */
  0x0000,   /* U+48A3 */
  0x0000,   /* U+48A4 */
  0x0000,   /* U+48A5 */
  0x0000,   /* U+48A6 */
  0x0000,   /* U+48A7 */
  0x0000,   /* U+48A8 */
  0x0000,   /* U+48A9 */
  0x0000,   /* U+48AA */
  0x0000,   /* U+48AB */
  0x0000,   /* U+48AC */
  0x0000,   /* U+48AD */
  0x0000,   /* U+48AE */
  0x0000,   /* U+48AF */
  0x0000,   /* U+48B0 */
  0x0000,   /* U+48B1 */
  0x0000,   /* U+48B2 */
  0x0000,   /* U+48B3 */
  0x0000,   /* U+48B4 */
  0x0000,   /* U+48B5 */
  0x0000,   /* U+48B6 */
  0x0000,   /* U+48B7 */
  0x0000,   /* U+48B8 */
  0x0000,   /* U+48B9 */
  0x0000,   /* U+48BA */
  0x0000,   /* U+48BB */
  0x0000,   /* U+48BC */
  0x0000,   /* U+48BD */
  0x0000,   /* U+48BE */
  0x0000,   /* U+48BF */
  0x0000,   /* U+48C0 */
  0x0000,   /* U+48C1 */
  0x0000,   /* U+48C2 */
  0x0000,   /* U+48C3 */
  0x0000,   /* U+48C4 */
  0x0000,   /* U+48C5 */
  0x0000,   /* U+48C6 */
  0x0000,   /* U+48C7 */
  0x0000,   /* U+48C8 */
  0x0000,   /* U+48C9 */
  0x0000,   /* U+48CA */
  0x0000,   /* U+48CB */
  0x0000,   /* U+48CC */
  0x0000,   /* U+48CD */
  0x0000,   /* U+48CE */
  0x0000,   /* U+48CF */
  0x0000,   /* U+48D0 */
  0x0000,   /* U+48D1 */
  0x0000,   /* U+48D2 */
  0x0000,   /* U+48D3 */
  0x0000,   /* U+48D4 */
  0x0000,   /* U+48D5 */
  0x0000,   /* U+48D6 */
  0x0000,   /* U+48D7 */
  0x0000,   /* U+48D8 */
  0x0000,   /* U+48D9 */
  0x0000,   /* U+48DA */
  0x0000,   /* U+48DB */
  0x0000,   /* U+48DC */
  0x0000,   /* U+48DD */
  0x0000,   /* U+48DE */
  0x0000,   /* U+48DF */
  0x0000,   /* U+48E0 */
  0x0000,   /* U+48E1 */
  0x0000,   /* U+48E2 */
  0x0000,   /* U+48E3 */
  0x0000,   /* U+48E4 */
  0x0000,   /* U+48E5 */
  0x0000,   /* U+48E6 */
  0x0000,   /* U+48E7 */
  0x0000,   /* U+48E8 */
  0x0000,   /* U+48E9 */
  0x0000,   /* U+48EA */
  0x0000,   /* U+48EB */
  0x0000,   /* U+48EC */
  0x0000,   /* U+48ED */
  0x0000,   /* U+48EE */
  0x0000,   /* U+48EF */
  0x0000,   /* U+48F0 */
  0x0000,   /* U+48F1 */
  0x0000,   /* U+48F2 */
  0x0000,   /* U+48F3 */
  0x0000,   /* U+48F4 */
  0x0000,   /* U+48F5 */
  0x0000,   /* U+48F6 */
  0x0000,   /* U+48F7 */
  0x0000,   /* U+48F8 */
  0x0000,   /* U+48F9 */
  0x0000,   /* U+48FA */
  0x0000,   /* U+48FB */
  0x0000,   /* U+48FC */
  0x0000,   /* U+48FD */
  0x0000,   /* U+48FE */
  0x0000,   /* U+48FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4800 */
  0x0000,   /* U+4801 */
  0x0000,   /* U+4802 */
  0x0000,   /* U+4803 */
  0x0000,   /* U+4804 */
  0x0000,   /* U+4805 */
  0x0000,   /* U+4806 */
  0x0000,   /* U+4807 */
  0x0000,   /* U+4808 */
  0x0000,   /* U+4809 */
  0x0000,   /* U+480A */
  0x0000,   /* U+480B */
  0x0000,   /* U+480C */
  0x0000,   /* U+480D */
  0x0000,   /* U+480E */
  0x0000,   /* U+480F */
  0x0000,   /* U+4810 */
  0x0000,   /* U+4811 */
  0x0000,   /* U+4812 */
  0x0000,   /* U+4813 */
  0x0000,   /* U+4814 */
  0x0000,   /* U+4815 */
  0x0000,   /* U+4816 */
  0x0000,   /* U+4817 */
  0x0000,   /* U+4818 */
  0x0000,   /* U+4819 */
  0x0000,   /* U+481A */
  0x0000,   /* U+481B */
  0x0000,   /* U+481C */
  0x0000,   /* U+481D */
  0x0000,   /* U+481E */
  0x0000,   /* U+481F */
  0x0000,   /* U+4820 */
  0x0000,   /* U+4821 */
  0x0000,   /* U+4822 */
  0x0000,   /* U+4823 */
  0x0000,   /* U+4824 */
  0x0000,   /* U+4825 */
  0x0000,   /* U+4826 */
  0x0000,   /* U+4827 */
  0x0000,   /* U+4828 */
  0x0000,   /* U+4829 */
  0x0000,   /* U+482A */
  0x0000,   /* U+482B */
  0x0000,   /* U+482C */
  0x0000,   /* U+482D */
  0x0000,   /* U+482E */
  0x0000,   /* U+482F */
  0x0000,   /* U+4830 */
  0x0000,   /* U+4831 */
  0x0000,   /* U+4832 */
  0x0000,   /* U+4833 */
  0x0000,   /* U+4834 */
  0x0000,   /* U+4835 */
  0x0000,   /* U+4836 */
  0x0000,   /* U+4837 */
  0x0000,   /* U+4838 */
  0x0000,   /* U+4839 */
  0x0000,   /* U+483A */
  0x0000,   /* U+483B */
  0x0000,   /* U+483C */
  0x0000,   /* U+483D */
  0x0000,   /* U+483E */
  0x0000,   /* U+483F */
  0x0000,   /* U+4840 */
  0x0000,   /* U+4841 */
  0x0000,   /* U+4842 */
  0x0000,   /* U+4843 */
  0x0000,   /* U+4844 */
  0x0000,   /* U+4845 */
  0x0000,   /* U+4846 */
  0x0000,   /* U+4847 */
  0x0000,   /* U+4848 */
  0x0000,   /* U+4849 */
  0x0000,   /* U+484A */
  0x0000,   /* U+484B */
  0x0000,   /* U+484C */
  0x0000,   /* U+484D */
  0x0000,   /* U+484E */
  0x0000,   /* U+484F */
  0x0000,   /* U+4850 */
  0x0000,   /* U+4851 */
  0x0000,   /* U+4852 */
  0x0000,   /* U+4853 */
  0x0000,   /* U+4854 */
  0x0000,   /* U+4855 */
  0x0000,   /* U+4856 */
  0x0000,   /* U+4857 */
  0x0000,   /* U+4858 */
  0x0000,   /* U+4859 */
  0x0000,   /* U+485A */
  0x0000,   /* U+485B */
  0x0000,   /* U+485C */
  0x0000,   /* U+485D */
  0x0000,   /* U+485E */
  0x0000,   /* U+485F */
  0x0000,   /* U+4860 */
  0x0000,   /* U+4861 */
  0x0000,   /* U+4862 */
  0x0000,   /* U+4863 */
  0x0000,   /* U+4864 */
  0x0000,   /* U+4865 */
  0x0000,   /* U+4866 */
  0x0000,   /* U+4867 */
  0x0000,   /* U+4868 */
  0x0000,   /* U+4869 */
  0x0000,   /* U+486A */
  0x0000,   /* U+486B */
  0x0000,   /* U+486C */
  0x0000,   /* U+486D */
  0x0000,   /* U+486E */
  0x0000,   /* U+486F */
  0x0000,   /* U+4870 */
  0x0000,   /* U+4871 */
  0x0000,   /* U+4872 */
  0x0000,   /* U+4873 */
  0x0000,   /* U+4874 */
  0x0000,   /* U+4875 */
  0x0000,   /* U+4876 */
  0x0000,   /* U+4877 */
  0x0000,   /* U+4878 */
  0x0000,   /* U+4879 */
  0x0000,   /* U+487A */
  0x0000,   /* U+487B */
  0x0000,   /* U+487C */
  0x0000,   /* U+487D */
  0x0000,   /* U+487E */
  0x0000,   /* U+487F */
  0x0000,   /* U+4880 */
  0x0000,   /* U+4881 */
  0x0000,   /* U+4882 */
  0x0000,   /* U+4883 */
  0x0000,   /* U+4884 */
  0x0000,   /* U+4885 */
  0x0000,   /* U+4886 */
  0x0000,   /* U+4887 */
  0x0000,   /* U+4888 */
  0x0000,   /* U+4889 */
  0x0000,   /* U+488A */
  0x0000,   /* U+488B */
  0x0000,   /* U+488C */
  0x0000,   /* U+488D */
  0x0000,   /* U+488E */
  0x0000,   /* U+488F */
  0x0000,   /* U+4890 */
  0x0000,   /* U+4891 */
  0x0000,   /* U+4892 */
  0x0000,   /* U+4893 */
  0x0000,   /* U+4894 */
  0x0000,   /* U+4895 */
  0x0000,   /* U+4896 */
  0x0000,   /* U+4897 */
  0x0000,   /* U+4898 */
  0x0000,   /* U+4899 */
  0x0000,   /* U+489A */
  0x0000,   /* U+489B */
  0x0000,   /* U+489C */
  0x0000,   /* U+489D */
  0x0000,   /* U+489E */
  0x0000,   /* U+489F */
  0x0000,   /* U+48A0 */
  0x0000,   /* U+48A1 */
  0x0000,   /* U+48A2 */
  0x0000,   /* U+48A3 */
  0x0000,   /* U+48A4 */
  0x0000,   /* U+48A5 */
  0x0000,   /* U+48A6 */
  0x0000,   /* U+48A7 */
  0x0000,   /* U+48A8 */
  0x0000,   /* U+48A9 */
  0x0000,   /* U+48AA */
  0x0000,   /* U+48AB */
  0x0000,   /* U+48AC */
  0x0000,   /* U+48AD */
  0x0000,   /* U+48AE */
  0x0000,   /* U+48AF */
  0x0000,   /* U+48B0 */
  0x0000,   /* U+48B1 */
  0x0000,   /* U+48B2 */
  0x0000,   /* U+48B3 */
  0x0000,   /* U+48B4 */
  0x0000,   /* U+48B5 */
  0x0000,   /* U+48B6 */
  0x0000,   /* U+48B7 */
  0x0000,   /* U+48B8 */
  0x0000,   /* U+48B9 */
  0x0000,   /* U+48BA */
  0x0000,   /* U+48BB */
  0x0000,   /* U+48BC */
  0x0000,   /* U+48BD */
  0x0000,   /* U+48BE */
  0x0000,   /* U+48BF */
  0x0000,   /* U+48C0 */
  0x0000,   /* U+48C1 */
  0x0000,   /* U+48C2 */
  0x0000,   /* U+48C3 */
  0x0000,   /* U+48C4 */
  0x0000,   /* U+48C5 */
  0x0000,   /* U+48C6 */
  0x0000,   /* U+48C7 */
  0x0000,   /* U+48C8 */
  0x0000,   /* U+48C9 */
  0x0000,   /* U+48CA */
  0x0000,   /* U+48CB */
  0x0000,   /* U+48CC */
  0x0000,   /* U+48CD */
  0x0000,   /* U+48CE */
  0x0000,   /* U+48CF */
  0x0000,   /* U+48D0 */
  0x0000,   /* U+48D1 */
  0x0000,   /* U+48D2 */
  0x0000,   /* U+48D3 */
  0x0000,   /* U+48D4 */
  0x0000,   /* U+48D5 */
  0x0000,   /* U+48D6 */
  0x0000,   /* U+48D7 */
  0x0000,   /* U+48D8 */
  0x0000,   /* U+48D9 */
  0x0000,   /* U+48DA */
  0x0000,   /* U+48DB */
  0x0000,   /* U+48DC */
  0x0000,   /* U+48DD */
  0x0000,   /* U+48DE */
  0x0000,   /* U+48DF */
  0x0000,   /* U+48E0 */
  0x0000,   /* U+48E1 */
  0x0000,   /* U+48E2 */
  0x0000,   /* U+48E3 */
  0x0000,   /* U+48E4 */
  0x0000,   /* U+48E5 */
  0x0000,   /* U+48E6 */
  0x0000,   /* U+48E7 */
  0x0000,   /* U+48E8 */
  0x0000,   /* U+48E9 */
  0x0000,   /* U+48EA */
  0x0000,   /* U+48EB */
  0x0000,   /* U+48EC */
  0x0000,   /* U+48ED */
  0x0000,   /* U+48EE */
  0x0000,   /* U+48EF */
  0x0000,   /* U+48F0 */
  0x0000,   /* U+48F1 */
  0x0000,   /* U+48F2 */
  0x0000,   /* U+48F3 */
  0x0000,   /* U+48F4 */
  0x0000,   /* U+48F5 */
  0x0000,   /* U+48F6 */
  0x0000,   /* U+48F7 */
  0x0000,   /* U+48F8 */
  0x0000,   /* U+48F9 */
  0x0000,   /* U+48FA */
  0x0000,   /* U+48FB */
  0x0000,   /* U+48FC */
  0x0000,   /* U+48FD */
  0x0000,   /* U+48FE */
  0x0000,   /* U+48FF */
};

uint16 zh2_han_p049[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x4555,   /* U+4900 */
  0x4555,   /* U+4901 */
  0x4555,   /* U+4902 */
  0x4555,   /* U+4903 */
  0x4555,   /* U+4904 */
  0x4555,   /* U+4905 */
  0x4555,   /* U+4906 */
  0x4555,   /* U+4907 */
  0x4555,   /* U+4908 */
  0x454D,   /* U+4909 */
  0x454D,   /* U+490A */
  0x454D,   /* U+490B */
  0x454D,   /* U+490C */
  0x4557,   /* U+490D */
  0x4558,   /* U+490E */
  0x4558,   /* U+490F */
  0x4558,   /* U+4910 */
  0x4558,   /* U+4911 */
  0x4558,   /* U+4912 */
  0x455A,   /* U+4913 */
  0x455A,   /* U+4914 */
  0x455B,   /* U+4915 */
  0x455B,   /* U+4916 */
  0x455D,   /* U+4917 */
  0x455D,   /* U+4918 */
  0x4561,   /* U+4919 */
  0x45D0,   /* U+491A */
  0x460E,   /* U+491B */
  0x460F,   /* U+491C */
  0x4610,   /* U+491D */
  0x4610,   /* U+491E */
  0x4610,   /* U+491F */
  0x4610,   /* U+4920 */
  0x4611,   /* U+4921 */
  0x4611,   /* U+4922 */
  0x4611,   /* U+4923 */
  0x4612,   /* U+4924 */
  0x4612,   /* U+4925 */
  0x4612,   /* U+4926 */
  0x4612,   /* U+4927 */
  0x4612,   /* U+4928 */
  0x4612,   /* U+4929 */
  0x4612,   /* U+492A */
  0x4613,   /* U+492B */
  0x4613,   /* U+492C */
  0x4613,   /* U+492D */
  0x4613,   /* U+492E */
  0x4613,   /* U+492F */
  0x4613,   /* U+4930 */
  0x4613,   /* U+4931 */
  0x4613,   /* U+4932 */
  0x4614,   /* U+4933 */
  0x4614,   /* U+4934 */
  0x4614,   /* U+4935 */
  0x4614,   /* U+4936 */
  0x4615,   /* U+4937 */
  0x4615,   /* U+4938 */
  0x4615,   /* U+4939 */
  0x4615,   /* U+493A */
  0x4615,   /* U+493B */
  0x4615,   /* U+493C */
  0x460D,   /* U+493D */
  0x460D,   /* U+493E */
  0x460D,   /* U+493F */
  0x460D,   /* U+4940 */
  0x460D,   /* U+4941 */
  0x460D,   /* U+4942 */
  0x460D,   /* U+4943 */
  0x460D,   /* U+4944 */
  0x460D,   /* U+4945 */
  0x460D,   /* U+4946 */
  0x460D,   /* U+4947 */
  0x4617,   /* U+4948 */
  0x4617,   /* U+4949 */
  0x4617,   /* U+494A */
  0x4617,   /* U+494B */
  0x4617,   /* U+494C */
  0x4617,   /* U+494D */
  0x4617,   /* U+494E */
  0x4617,   /* U+494F */
  0x4617,   /* U+4950 */
  0x4617,   /* U+4951 */
  0x4617,   /* U+4952 */
  0x4617,   /* U+4953 */
  0x4618,   /* U+4954 */
  0x4618,   /* U+4955 */
  0x4618,   /* U+4956 */
  0x4618,   /* U+4957 */
  0x4618,   /* U+4958 */
  0x4618,   /* U+4959 */
  0x4618,   /* U+495A */
  0x4618,   /* U+495B */
  0x5C49,   /* U+495C */
  0x4619,   /* U+495D */
  0x4619,   /* U+495E */
  0x4619,   /* U+495F */
  0x4619,   /* U+4960 */
  0x4619,   /* U+4961 */
  0x4619,   /* U+4962 */
  0x4619,   /* U+4963 */
  0x4619,   /* U+4964 */
  0x5C49,   /* U+4965 */
  0x5C49,   /* U+4966 */
  0x461A,   /* U+4967 */
  0x461A,   /* U+4968 */
  0x461A,   /* U+4969 */
  0x461A,   /* U+496A */
  0x461A,   /* U+496B */
  0x461A,   /* U+496C */
  0x461A,   /* U+496D */
  0x461A,   /* U+496E */
  0x461B,   /* U+496F */
  0x461B,   /* U+4970 */
  0x461B,   /* U+4971 */
  0x461B,   /* U+4972 */
  0x461B,   /* U+4973 */
  0x5C49,   /* U+4974 */
  0x461C,   /* U+4975 */
  0x461C,   /* U+4976 */
  0x461C,   /* U+4977 */
  0x461D,   /* U+4978 */
  0x5C49,   /* U+4979 */
  0x4610,   /* U+497A */
  0x4610,   /* U+497B */
  0x4610,   /* U+497C */
  0x4611,   /* U+497D */
  0x4611,   /* U+497E */
  0x4611,   /* U+497F */
  0x4612,   /* U+4980 */
  0x4613,   /* U+4981 */
  0x4616,   /* U+4982 */
  0x4618,   /* U+4983 */
  0x4618,   /* U+4984 */
  0x4618,   /* U+4985 */
  0x4620,   /* U+4986 */
  0x464F,   /* U+4987 */
  0x4651,   /* U+4988 */
  0x4651,   /* U+4989 */
  0x4652,   /* U+498A */
  0x4657,   /* U+498B */
  0x468F,   /* U+498C */
  0x468F,   /* U+498D */
  0x4690,   /* U+498E */
  0x4690,   /* U+498F */
  0x4690,   /* U+4990 */
  0x4690,   /* U+4991 */
  0x4691,   /* U+4992 */
  0x4691,   /* U+4993 */
  0x4691,   /* U+4994 */
  0x4692,   /* U+4995 */
  0x4692,   /* U+4996 */
  0x4692,   /* U+4997 */
  0x4692,   /* U+4998 */
  0x4692,   /* U+4999 */
  0x4692,   /* U+499A */
  0x4692,   /* U+499B */
  0x4693,   /* U+499C */
  0x4693,   /* U+499D */
  0x4693,   /* U+499E */
  0x4693,   /* U+499F */
  0x4694,   /* U+49A0 */
  0x4694,   /* U+49A1 */
  0x4694,   /* U+49A2 */
  0x4694,   /* U+49A3 */
  0x4694,   /* U+49A4 */
  0x4694,   /* U+49A5 */
  0x4694,   /* U+49A6 */
  0x4694,   /* U+49A7 */
  0x4694,   /* U+49A8 */
  0x4695,   /* U+49A9 */
  0x4695,   /* U+49AA */
  0x4695,   /* U+49AB */
  0x4695,   /* U+49AC */
  0x4695,   /* U+49AD */
  0x4695,   /* U+49AE */
  0x4695,   /* U+49AF */
  0x5C49,   /* U+49B0 */
  0x4698,   /* U+49B1 */
  0x4699,   /* U+49B2 */
  0x4699,   /* U+49B3 */
  0x4699,   /* U+49B4 */
  0x469A,   /* U+49B5 */
  0x4692,   /* U+49B6 */
  0x4693,   /* U+49B7 */
  0x4695,   /* U+49B8 */
  0x46CE,   /* U+49B9 */
  0x46CE,   /* U+49BA */
  0x46CF,   /* U+49BB */
  0x46D0,   /* U+49BC */
  0x46D0,   /* U+49BD */
  0x46D0,   /* U+49BE */
  0x46D0,   /* U+49BF */
  0x46D0,   /* U+49C0 */
  0x46D1,   /* U+49C1 */
  0x46D1,   /* U+49C2 */
  0x46D1,   /* U+49C3 */
  0x46D2,   /* U+49C4 */
  0x46D2,   /* U+49C5 */
  0x46D2,   /* U+49C6 */
  0x46D2,   /* U+49C7 */
  0x46D2,   /* U+49C8 */
  0x46D3,   /* U+49C9 */
  0x46D3,   /* U+49CA */
  0x46D3,   /* U+49CB */
  0x46D3,   /* U+49CC */
  0x46D3,   /* U+49CD */
  0x46D3,   /* U+49CE */
  0x5C49,   /* U+49CF */
  0x46D4,   /* U+49D0 */
  0x46D4,   /* U+49D1 */
  0x46D4,   /* U+49D2 */
  0x46D4,   /* U+49D3 */
  0x46D4,   /* U+49D4 */
  0x46D4,   /* U+49D5 */
  0x46D4,   /* U+49D6 */
  0x46D5,   /* U+49D7 */
  0x46D5,   /* U+49D8 */
  0x46D5,   /* U+49D9 */
  0x46CD,   /* U+49DA */
  0x46CD,   /* U+49DB */
  0x46CD,   /* U+49DC */
  0x46CD,   /* U+49DD */
  0x46CD,   /* U+49DE */
  0x46CD,   /* U+49DF */
  0x46D7,   /* U+49E0 */
  0x46D7,   /* U+49E1 */
  0x46D7,   /* U+49E2 */
  0x46D7,   /* U+49E3 */
  0x46D8,   /* U+49E4 */
  0x46D8,   /* U+49E5 */
  0x46D8,   /* U+49E6 */
  0x46D9,   /* U+49E7 */
  0x46D9,   /* U+49E8 */
  0x46D8,   /* U+49E9 */
  0x46D9,   /* U+49EA */
  0x46DA,   /* U+49EB */
  0x46DA,   /* U+49EC */
  0x46DA,   /* U+49ED */
  0x46DC,   /* U+49EE */
  0x46DD,   /* U+49EF */
  0x46DE,   /* U+49F0 */
  0x474E,   /* U+49F1 */
  0x474F,   /* U+49F2 */
  0x474F,   /* U+49F3 */
  0x4750,   /* U+49F4 */
  0x4750,   /* U+49F5 */
  0x4750,   /* U+49F6 */
  0x4751,   /* U+49F7 */
  0x4751,   /* U+49F8 */
  0x4751,   /* U+49F9 */
  0x4751,   /* U+49FA */
  0x4752,   /* U+49FB */
  0x4753,   /* U+49FC */
  0x4753,   /* U+49FD */
  0x4754,   /* U+49FE */
  0x4754,   /* U+49FF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4900 */
  0x0020,   /* U+4901 */
  0x0020,   /* U+4902 */
  0x0020,   /* U+4903 */
  0x0020,   /* U+4904 */
  0x0020,   /* U+4905 */
  0x0020,   /* U+4906 */
  0x0020,   /* U+4907 */
  0x0020,   /* U+4908 */
  0x0020,   /* U+4909 */
  0x0020,   /* U+490A */
  0x0020,   /* U+490B */
  0x0020,   /* U+490C */
  0x0020,   /* U+490D */
  0x0020,   /* U+490E */
  0x0020,   /* U+490F */
  0x0020,   /* U+4910 */
  0x0020,   /* U+4911 */
  0x0020,   /* U+4912 */
  0x0020,   /* U+4913 */
  0x0020,   /* U+4914 */
  0x0020,   /* U+4915 */
  0x0020,   /* U+4916 */
  0x0020,   /* U+4917 */
  0x0020,   /* U+4918 */
  0x0020,   /* U+4919 */
  0x0020,   /* U+491A */
  0x0020,   /* U+491B */
  0x0020,   /* U+491C */
  0x0020,   /* U+491D */
  0x0020,   /* U+491E */
  0x0020,   /* U+491F */
  0x0020,   /* U+4920 */
  0x0020,   /* U+4921 */
  0x0020,   /* U+4922 */
  0x0020,   /* U+4923 */
  0x0020,   /* U+4924 */
  0x0020,   /* U+4925 */
  0x0020,   /* U+4926 */
  0x0020,   /* U+4927 */
  0x0020,   /* U+4928 */
  0x0020,   /* U+4929 */
  0x0020,   /* U+492A */
  0x0020,   /* U+492B */
  0x0020,   /* U+492C */
  0x0020,   /* U+492D */
  0x0020,   /* U+492E */
  0x0020,   /* U+492F */
  0x0020,   /* U+4930 */
  0x0020,   /* U+4931 */
  0x0020,   /* U+4932 */
  0x0020,   /* U+4933 */
  0x0020,   /* U+4934 */
  0x0020,   /* U+4935 */
  0x0020,   /* U+4936 */
  0x0020,   /* U+4937 */
  0x0020,   /* U+4938 */
  0x0020,   /* U+4939 */
  0x0020,   /* U+493A */
  0x0020,   /* U+493B */
  0x0020,   /* U+493C */
  0x0020,   /* U+493D */
  0x0020,   /* U+493E */
  0x0020,   /* U+493F */
  0x0020,   /* U+4940 */
  0x0020,   /* U+4941 */
  0x0020,   /* U+4942 */
  0x0020,   /* U+4943 */
  0x0020,   /* U+4944 */
  0x0020,   /* U+4945 */
  0x0020,   /* U+4946 */
  0x0020,   /* U+4947 */
  0x0020,   /* U+4948 */
  0x0020,   /* U+4949 */
  0x0020,   /* U+494A */
  0x0020,   /* U+494B */
  0x0020,   /* U+494C */
  0x0020,   /* U+494D */
  0x0020,   /* U+494E */
  0x0020,   /* U+494F */
  0x0020,   /* U+4950 */
  0x0020,   /* U+4951 */
  0x0020,   /* U+4952 */
  0x0020,   /* U+4953 */
  0x0020,   /* U+4954 */
  0x0020,   /* U+4955 */
  0x0020,   /* U+4956 */
  0x0020,   /* U+4957 */
  0x0020,   /* U+4958 */
  0x0020,   /* U+4959 */
  0x0020,   /* U+495A */
  0x0020,   /* U+495B */
  0x0020,   /* U+495C */
  0x0020,   /* U+495D */
  0x0020,   /* U+495E */
  0x0020,   /* U+495F */
  0x0020,   /* U+4960 */
  0x0020,   /* U+4961 */
  0x0020,   /* U+4962 */
  0x0020,   /* U+4963 */
  0x0020,   /* U+4964 */
  0x0020,   /* U+4965 */
  0x0020,   /* U+4966 */
  0x0020,   /* U+4967 */
  0x0020,   /* U+4968 */
  0x0020,   /* U+4969 */
  0x0020,   /* U+496A */
  0x0020,   /* U+496B */
  0x0020,   /* U+496C */
  0x0020,   /* U+496D */
  0x0020,   /* U+496E */
  0x0020,   /* U+496F */
  0x0020,   /* U+4970 */
  0x0020,   /* U+4971 */
  0x0020,   /* U+4972 */
  0x0020,   /* U+4973 */
  0x0020,   /* U+4974 */
  0x0020,   /* U+4975 */
  0x0020,   /* U+4976 */
  0x0020,   /* U+4977 */
  0x0020,   /* U+4978 */
  0x0020,   /* U+4979 */
  0x0020,   /* U+497A */
  0x0020,   /* U+497B */
  0x0020,   /* U+497C */
  0x0020,   /* U+497D */
  0x0020,   /* U+497E */
  0x0020,   /* U+497F */
  0x0020,   /* U+4980 */
  0x0020,   /* U+4981 */
  0x0020,   /* U+4982 */
  0x0020,   /* U+4983 */
  0x0020,   /* U+4984 */
  0x0020,   /* U+4985 */
  0x0020,   /* U+4986 */
  0x0020,   /* U+4987 */
  0x0020,   /* U+4988 */
  0x0020,   /* U+4989 */
  0x0020,   /* U+498A */
  0x0020,   /* U+498B */
  0x0020,   /* U+498C */
  0x0020,   /* U+498D */
  0x0020,   /* U+498E */
  0x0020,   /* U+498F */
  0x0020,   /* U+4990 */
  0x0020,   /* U+4991 */
  0x0020,   /* U+4992 */
  0x0020,   /* U+4993 */
  0x0020,   /* U+4994 */
  0x0020,   /* U+4995 */
  0x0020,   /* U+4996 */
  0x0020,   /* U+4997 */
  0x0020,   /* U+4998 */
  0x0020,   /* U+4999 */
  0x0020,   /* U+499A */
  0x0020,   /* U+499B */
  0x0020,   /* U+499C */
  0x0020,   /* U+499D */
  0x0020,   /* U+499E */
  0x0020,   /* U+499F */
  0x0020,   /* U+49A0 */
  0x0020,   /* U+49A1 */
  0x0020,   /* U+49A2 */
  0x0020,   /* U+49A3 */
  0x0020,   /* U+49A4 */
  0x0020,   /* U+49A5 */
  0x0020,   /* U+49A6 */
  0x0020,   /* U+49A7 */
  0x0020,   /* U+49A8 */
  0x0020,   /* U+49A9 */
  0x0020,   /* U+49AA */
  0x0020,   /* U+49AB */
  0x0020,   /* U+49AC */
  0x0020,   /* U+49AD */
  0x0020,   /* U+49AE */
  0x0020,   /* U+49AF */
  0x0020,   /* U+49B0 */
  0x0020,   /* U+49B1 */
  0x0020,   /* U+49B2 */
  0x0020,   /* U+49B3 */
  0x0020,   /* U+49B4 */
  0x0020,   /* U+49B5 */
  0x0020,   /* U+49B6 */
  0x0020,   /* U+49B7 */
  0x0020,   /* U+49B8 */
  0x0020,   /* U+49B9 */
  0x0020,   /* U+49BA */
  0x0020,   /* U+49BB */
  0x0020,   /* U+49BC */
  0x0020,   /* U+49BD */
  0x0020,   /* U+49BE */
  0x0020,   /* U+49BF */
  0x0020,   /* U+49C0 */
  0x0020,   /* U+49C1 */
  0x0020,   /* U+49C2 */
  0x0020,   /* U+49C3 */
  0x0020,   /* U+49C4 */
  0x0020,   /* U+49C5 */
  0x0020,   /* U+49C6 */
  0x0020,   /* U+49C7 */
  0x0020,   /* U+49C8 */
  0x0020,   /* U+49C9 */
  0x0020,   /* U+49CA */
  0x0020,   /* U+49CB */
  0x0020,   /* U+49CC */
  0x0020,   /* U+49CD */
  0x0020,   /* U+49CE */
  0x0020,   /* U+49CF */
  0x0020,   /* U+49D0 */
  0x0020,   /* U+49D1 */
  0x0020,   /* U+49D2 */
  0x0020,   /* U+49D3 */
  0x0020,   /* U+49D4 */
  0x0020,   /* U+49D5 */
  0x0020,   /* U+49D6 */
  0x0020,   /* U+49D7 */
  0x0020,   /* U+49D8 */
  0x0020,   /* U+49D9 */
  0x0020,   /* U+49DA */
  0x0020,   /* U+49DB */
  0x0020,   /* U+49DC */
  0x0020,   /* U+49DD */
  0x0020,   /* U+49DE */
  0x0020,   /* U+49DF */
  0x0020,   /* U+49E0 */
  0x0020,   /* U+49E1 */
  0x0020,   /* U+49E2 */
  0x0020,   /* U+49E3 */
  0x0020,   /* U+49E4 */
  0x0020,   /* U+49E5 */
  0x0020,   /* U+49E6 */
  0x0020,   /* U+49E7 */
  0x0020,   /* U+49E8 */
  0x0020,   /* U+49E9 */
  0x0020,   /* U+49EA */
  0x0020,   /* U+49EB */
  0x0020,   /* U+49EC */
  0x0020,   /* U+49ED */
  0x0020,   /* U+49EE */
  0x0020,   /* U+49EF */
  0x0020,   /* U+49F0 */
  0x0020,   /* U+49F1 */
  0x0020,   /* U+49F2 */
  0x0020,   /* U+49F3 */
  0x0020,   /* U+49F4 */
  0x0020,   /* U+49F5 */
  0x0020,   /* U+49F6 */
  0x0020,   /* U+49F7 */
  0x0020,   /* U+49F8 */
  0x0020,   /* U+49F9 */
  0x0020,   /* U+49FA */
  0x0020,   /* U+49FB */
  0x0020,   /* U+49FC */
  0x0020,   /* U+49FD */
  0x0020,   /* U+49FE */
  0x0020,   /* U+49FF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4900 */
  0x0002,   /* U+4901 */
  0x0002,   /* U+4902 */
  0x0002,   /* U+4903 */
  0x0002,   /* U+4904 */
  0x0002,   /* U+4905 */
  0x0002,   /* U+4906 */
  0x0002,   /* U+4907 */
  0x0002,   /* U+4908 */
  0x0002,   /* U+4909 */
  0x0002,   /* U+490A */
  0x0002,   /* U+490B */
  0x0002,   /* U+490C */
  0x0002,   /* U+490D */
  0x0002,   /* U+490E */
  0x0002,   /* U+490F */
  0x0002,   /* U+4910 */
  0x0002,   /* U+4911 */
  0x0002,   /* U+4912 */
  0x0002,   /* U+4913 */
  0x0002,   /* U+4914 */
  0x0002,   /* U+4915 */
  0x0002,   /* U+4916 */
  0x0002,   /* U+4917 */
  0x0002,   /* U+4918 */
  0x0002,   /* U+4919 */
  0x0002,   /* U+491A */
  0x0002,   /* U+491B */
  0x0002,   /* U+491C */
  0x0002,   /* U+491D */
  0x0002,   /* U+491E */
  0x0002,   /* U+491F */
  0x0002,   /* U+4920 */
  0x0002,   /* U+4921 */
  0x0002,   /* U+4922 */
  0x0002,   /* U+4923 */
  0x0002,   /* U+4924 */
  0x0002,   /* U+4925 */
  0x0002,   /* U+4926 */
  0x0002,   /* U+4927 */
  0x0002,   /* U+4928 */
  0x0002,   /* U+4929 */
  0x0002,   /* U+492A */
  0x0002,   /* U+492B */
  0x0002,   /* U+492C */
  0x0002,   /* U+492D */
  0x0002,   /* U+492E */
  0x0002,   /* U+492F */
  0x0002,   /* U+4930 */
  0x0002,   /* U+4931 */
  0x0002,   /* U+4932 */
  0x0002,   /* U+4933 */
  0x0002,   /* U+4934 */
  0x0002,   /* U+4935 */
  0x0002,   /* U+4936 */
  0x0002,   /* U+4937 */
  0x0002,   /* U+4938 */
  0x0002,   /* U+4939 */
  0x0002,   /* U+493A */
  0x0002,   /* U+493B */
  0x0002,   /* U+493C */
  0x0002,   /* U+493D */
  0x0002,   /* U+493E */
  0x0002,   /* U+493F */
  0x0002,   /* U+4940 */
  0x0002,   /* U+4941 */
  0x0002,   /* U+4942 */
  0x0002,   /* U+4943 */
  0x0002,   /* U+4944 */
  0x0002,   /* U+4945 */
  0x0002,   /* U+4946 */
  0x0002,   /* U+4947 */
  0x0002,   /* U+4948 */
  0x0002,   /* U+4949 */
  0x0002,   /* U+494A */
  0x0002,   /* U+494B */
  0x0002,   /* U+494C */
  0x0002,   /* U+494D */
  0x0002,   /* U+494E */
  0x0002,   /* U+494F */
  0x0002,   /* U+4950 */
  0x0002,   /* U+4951 */
  0x0002,   /* U+4952 */
  0x0002,   /* U+4953 */
  0x0002,   /* U+4954 */
  0x0002,   /* U+4955 */
  0x0002,   /* U+4956 */
  0x0002,   /* U+4957 */
  0x0002,   /* U+4958 */
  0x0002,   /* U+4959 */
  0x0002,   /* U+495A */
  0x0002,   /* U+495B */
  0x0002,   /* U+495C */
  0x0002,   /* U+495D */
  0x0002,   /* U+495E */
  0x0002,   /* U+495F */
  0x0002,   /* U+4960 */
  0x0002,   /* U+4961 */
  0x0002,   /* U+4962 */
  0x0002,   /* U+4963 */
  0x0002,   /* U+4964 */
  0x0002,   /* U+4965 */
  0x0002,   /* U+4966 */
  0x0002,   /* U+4967 */
  0x0002,   /* U+4968 */
  0x0002,   /* U+4969 */
  0x0002,   /* U+496A */
  0x0002,   /* U+496B */
  0x0002,   /* U+496C */
  0x0002,   /* U+496D */
  0x0002,   /* U+496E */
  0x0002,   /* U+496F */
  0x0002,   /* U+4970 */
  0x0002,   /* U+4971 */
  0x0002,   /* U+4972 */
  0x0002,   /* U+4973 */
  0x0002,   /* U+4974 */
  0x0002,   /* U+4975 */
  0x0002,   /* U+4976 */
  0x0002,   /* U+4977 */
  0x0002,   /* U+4978 */
  0x0002,   /* U+4979 */
  0x0002,   /* U+497A */
  0x0002,   /* U+497B */
  0x0002,   /* U+497C */
  0x0002,   /* U+497D */
  0x0002,   /* U+497E */
  0x0002,   /* U+497F */
  0x0002,   /* U+4980 */
  0x0002,   /* U+4981 */
  0x0002,   /* U+4982 */
  0x0002,   /* U+4983 */
  0x0002,   /* U+4984 */
  0x0002,   /* U+4985 */
  0x0002,   /* U+4986 */
  0x0002,   /* U+4987 */
  0x0002,   /* U+4988 */
  0x0002,   /* U+4989 */
  0x0002,   /* U+498A */
  0x0002,   /* U+498B */
  0x0002,   /* U+498C */
  0x0002,   /* U+498D */
  0x0002,   /* U+498E */
  0x0002,   /* U+498F */
  0x0002,   /* U+4990 */
  0x0002,   /* U+4991 */
  0x0002,   /* U+4992 */
  0x0002,   /* U+4993 */
  0x0002,   /* U+4994 */
  0x0002,   /* U+4995 */
  0x0002,   /* U+4996 */
  0x0002,   /* U+4997 */
  0x0002,   /* U+4998 */
  0x0002,   /* U+4999 */
  0x0002,   /* U+499A */
  0x0002,   /* U+499B */
  0x0002,   /* U+499C */
  0x0002,   /* U+499D */
  0x0002,   /* U+499E */
  0x0002,   /* U+499F */
  0x0002,   /* U+49A0 */
  0x0002,   /* U+49A1 */
  0x0002,   /* U+49A2 */
  0x0002,   /* U+49A3 */
  0x0002,   /* U+49A4 */
  0x0002,   /* U+49A5 */
  0x0002,   /* U+49A6 */
  0x0002,   /* U+49A7 */
  0x0002,   /* U+49A8 */
  0x0002,   /* U+49A9 */
  0x0002,   /* U+49AA */
  0x0002,   /* U+49AB */
  0x0002,   /* U+49AC */
  0x0002,   /* U+49AD */
  0x0002,   /* U+49AE */
  0x0002,   /* U+49AF */
  0x0002,   /* U+49B0 */
  0x0002,   /* U+49B1 */
  0x0002,   /* U+49B2 */
  0x0002,   /* U+49B3 */
  0x0002,   /* U+49B4 */
  0x0002,   /* U+49B5 */
  0x0002,   /* U+49B6 */
  0x0002,   /* U+49B7 */
  0x0002,   /* U+49B8 */
  0x0002,   /* U+49B9 */
  0x0002,   /* U+49BA */
  0x0002,   /* U+49BB */
  0x0002,   /* U+49BC */
  0x0002,   /* U+49BD */
  0x0002,   /* U+49BE */
  0x0002,   /* U+49BF */
  0x0002,   /* U+49C0 */
  0x0002,   /* U+49C1 */
  0x0002,   /* U+49C2 */
  0x0002,   /* U+49C3 */
  0x0002,   /* U+49C4 */
  0x0002,   /* U+49C5 */
  0x0002,   /* U+49C6 */
  0x0002,   /* U+49C7 */
  0x0002,   /* U+49C8 */
  0x0002,   /* U+49C9 */
  0x0002,   /* U+49CA */
  0x0002,   /* U+49CB */
  0x0002,   /* U+49CC */
  0x0002,   /* U+49CD */
  0x0002,   /* U+49CE */
  0x0002,   /* U+49CF */
  0x0002,   /* U+49D0 */
  0x0002,   /* U+49D1 */
  0x0002,   /* U+49D2 */
  0x0002,   /* U+49D3 */
  0x0002,   /* U+49D4 */
  0x0002,   /* U+49D5 */
  0x0002,   /* U+49D6 */
  0x0002,   /* U+49D7 */
  0x0002,   /* U+49D8 */
  0x0002,   /* U+49D9 */
  0x0002,   /* U+49DA */
  0x0002,   /* U+49DB */
  0x0002,   /* U+49DC */
  0x0002,   /* U+49DD */
  0x0002,   /* U+49DE */
  0x0002,   /* U+49DF */
  0x0002,   /* U+49E0 */
  0x0002,   /* U+49E1 */
  0x0002,   /* U+49E2 */
  0x0002,   /* U+49E3 */
  0x0002,   /* U+49E4 */
  0x0002,   /* U+49E5 */
  0x0002,   /* U+49E6 */
  0x0002,   /* U+49E7 */
  0x0002,   /* U+49E8 */
  0x0002,   /* U+49E9 */
  0x0002,   /* U+49EA */
  0x0002,   /* U+49EB */
  0x0002,   /* U+49EC */
  0x0002,   /* U+49ED */
  0x0002,   /* U+49EE */
  0x0002,   /* U+49EF */
  0x0002,   /* U+49F0 */
  0x0002,   /* U+49F1 */
  0x0002,   /* U+49F2 */
  0x0002,   /* U+49F3 */
  0x0002,   /* U+49F4 */
  0x0002,   /* U+49F5 */
  0x0002,   /* U+49F6 */
  0x0002,   /* U+49F7 */
  0x0002,   /* U+49F8 */
  0x0002,   /* U+49F9 */
  0x0002,   /* U+49FA */
  0x0002,   /* U+49FB */
  0x0002,   /* U+49FC */
  0x0002,   /* U+49FD */
  0x0002,   /* U+49FE */
  0x0002,   /* U+49FF */

  /* Primary weight 2 for each character. */
  0x8000,   /* U+4900 */
  0x8001,   /* U+4901 */
  0x8002,   /* U+4902 */
  0x8003,   /* U+4903 */
  0x8004,   /* U+4904 */
  0x8005,   /* U+4905 */
  0x8006,   /* U+4906 */
  0x8007,   /* U+4907 */
  0x8008,   /* U+4908 */
  0x8000,   /* U+4909 */
  0x8001,   /* U+490A */
  0x8002,   /* U+490B */
  0x8003,   /* U+490C */
  0x8000,   /* U+490D */
  0x8000,   /* U+490E */
  0x8001,   /* U+490F */
  0x8002,   /* U+4910 */
  0x8003,   /* U+4911 */
  0x8004,   /* U+4912 */
  0x8000,   /* U+4913 */
  0x8001,   /* U+4914 */
  0x8000,   /* U+4915 */
  0x8001,   /* U+4916 */
  0x8000,   /* U+4917 */
  0x8001,   /* U+4918 */
  0x8000,   /* U+4919 */
  0x8000,   /* U+491A */
  0x8007,   /* U+491B */
  0x8014,   /* U+491C */
  0x8032,   /* U+491D */
  0x8033,   /* U+491E */
  0x8034,   /* U+491F */
  0x8035,   /* U+4920 */
  0x8038,   /* U+4921 */
  0x8039,   /* U+4922 */
  0x803A,   /* U+4923 */
  0x803B,   /* U+4924 */
  0x803C,   /* U+4925 */
  0x803D,   /* U+4926 */
  0x803E,   /* U+4927 */
  0x803F,   /* U+4928 */
  0x8040,   /* U+4929 */
  0x8041,   /* U+492A */
  0x802E,   /* U+492B */
  0x802F,   /* U+492C */
  0x8030,   /* U+492D */
  0x8031,   /* U+492E */
  0x8032,   /* U+492F */
  0x8033,   /* U+4930 */
  0x8034,   /* U+4931 */
  0x8035,   /* U+4932 */
  0x8037,   /* U+4933 */
  0x8038,   /* U+4934 */
  0x8039,   /* U+4935 */
  0x803A,   /* U+4936 */
  0x8024,   /* U+4937 */
  0x8025,   /* U+4938 */
  0x8026,   /* U+4939 */
  0x8027,   /* U+493A */
  0x8028,   /* U+493B */
  0x8029,   /* U+493C */
  0x8002,   /* U+493D */
  0x8003,   /* U+493E */
  0x8004,   /* U+493F */
  0x8005,   /* U+4940 */
  0x8006,   /* U+4941 */
  0x8007,   /* U+4942 */
  0x8008,   /* U+4943 */
  0x8009,   /* U+4944 */
  0x800A,   /* U+4945 */
  0x800B,   /* U+4946 */
  0x800C,   /* U+4947 */
  0x8016,   /* U+4948 */
  0x8017,   /* U+4949 */
  0x8018,   /* U+494A */
  0x8019,   /* U+494B */
  0x801A,   /* U+494C */
  0x801B,   /* U+494D */
  0x801C,   /* U+494E */
  0x801D,   /* U+494F */
  0x801E,   /* U+4950 */
  0x801F,   /* U+4951 */
  0x8020,   /* U+4952 */
  0x8021,   /* U+4953 */
  0x801D,   /* U+4954 */
  0x801E,   /* U+4955 */
  0x801F,   /* U+4956 */
  0x8020,   /* U+4957 */
  0x8021,   /* U+4958 */
  0x8022,   /* U+4959 */
  0x8023,   /* U+495A */
  0x8024,   /* U+495B */
  0xC95C,   /* U+495C */
  0x800F,   /* U+495D */
  0x8010,   /* U+495E */
  0x8011,   /* U+495F */
  0x8012,   /* U+4960 */
  0x8013,   /* U+4961 */
  0x8014,   /* U+4962 */
  0x8015,   /* U+4963 */
  0x8016,   /* U+4964 */
  0xC965,   /* U+4965 */
  0xC966,   /* U+4966 */
  0x8004,   /* U+4967 */
  0x8005,   /* U+4968 */
  0x8006,   /* U+4969 */
  0x8007,   /* U+496A */
  0x8008,   /* U+496B */
  0x8009,   /* U+496C */
  0x800A,   /* U+496D */
  0x800B,   /* U+496E */
  0x8003,   /* U+496F */
  0x8004,   /* U+4970 */
  0x8005,   /* U+4971 */
  0x8006,   /* U+4972 */
  0x8007,   /* U+4973 */
  0xC974,   /* U+4974 */
  0x8002,   /* U+4975 */
  0x8003,   /* U+4976 */
  0x8004,   /* U+4977 */
  0x8003,   /* U+4978 */
  0xC979,   /* U+4979 */
  0x8000,   /* U+497A */
  0x8001,   /* U+497B */
  0x8002,   /* U+497C */
  0x8000,   /* U+497D */
  0x8001,   /* U+497E */
  0x8002,   /* U+497F */
  0x8000,   /* U+4980 */
  0x8000,   /* U+4981 */
  0x8000,   /* U+4982 */
  0x8000,   /* U+4983 */
  0x8001,   /* U+4984 */
  0x8002,   /* U+4985 */
  0x8000,   /* U+4986 */
  0x8000,   /* U+4987 */
  0x8000,   /* U+4988 */
  0x8001,   /* U+4989 */
  0x8000,   /* U+498A */
  0x8000,   /* U+498B */
  0x800C,   /* U+498C */
  0x800D,   /* U+498D */
  0x8013,   /* U+498E */
  0x8014,   /* U+498F */
  0x8015,   /* U+4990 */
  0x8016,   /* U+4991 */
  0x8009,   /* U+4992 */
  0x800A,   /* U+4993 */
  0x800B,   /* U+4994 */
  0x8014,   /* U+4995 */
  0x8015,   /* U+4996 */
  0x8016,   /* U+4997 */
  0x8017,   /* U+4998 */
  0x8018,   /* U+4999 */
  0x8019,   /* U+499A */
  0x801A,   /* U+499B */
  0x800A,   /* U+499C */
  0x800B,   /* U+499D */
  0x800C,   /* U+499E */
  0x800D,   /* U+499F */
  0x8015,   /* U+49A0 */
  0x8016,   /* U+49A1 */
  0x8017,   /* U+49A2 */
  0x8018,   /* U+49A3 */
  0x8019,   /* U+49A4 */
  0x801A,   /* U+49A5 */
  0x801B,   /* U+49A6 */
  0x801C,   /* U+49A7 */
  0x801D,   /* U+49A8 */
  0x800F,   /* U+49A9 */
  0x8010,   /* U+49AA */
  0x8011,   /* U+49AB */
  0x8012,   /* U+49AC */
  0x8013,   /* U+49AD */
  0x8014,   /* U+49AE */
  0x8015,   /* U+49AF */
  0xC9B0,   /* U+49B0 */
  0x8006,   /* U+49B1 */
  0x8002,   /* U+49B2 */
  0x8003,   /* U+49B3 */
  0x8004,   /* U+49B4 */
  0x8002,   /* U+49B5 */
  0x8000,   /* U+49B6 */
  0x8000,   /* U+49B7 */
  0x8000,   /* U+49B8 */
  0x8000,   /* U+49B9 */
  0x8001,   /* U+49BA */
  0x8000,   /* U+49BB */
  0x8000,   /* U+49BC */
  0x8001,   /* U+49BD */
  0x8002,   /* U+49BE */
  0x8003,   /* U+49BF */
  0x8004,   /* U+49C0 */
  0x8000,   /* U+49C1 */
  0x8001,   /* U+49C2 */
  0x8002,   /* U+49C3 */
  0x8000,   /* U+49C4 */
  0x8001,   /* U+49C5 */
  0x8002,   /* U+49C6 */
  0x8003,   /* U+49C7 */
  0x8004,   /* U+49C8 */
  0x8000,   /* U+49C9 */
  0x8001,   /* U+49CA */
  0x8002,   /* U+49CB */
  0x8003,   /* U+49CC */
  0x8004,   /* U+49CD */
  0x8005,   /* U+49CE */
  0xC9CF,   /* U+49CF */
  0x8000,   /* U+49D0 */
  0x8001,   /* U+49D1 */
  0x8002,   /* U+49D2 */
  0x8003,   /* U+49D3 */
  0x8004,   /* U+49D4 */
  0x8005,   /* U+49D5 */
  0x8006,   /* U+49D6 */
  0x8000,   /* U+49D7 */
  0x8001,   /* U+49D8 */
  0x8002,   /* U+49D9 */
  0x8000,   /* U+49DA */
  0x8001,   /* U+49DB */
  0x8002,   /* U+49DC */
  0x8003,   /* U+49DD */
  0x8004,   /* U+49DE */
  0x8005,   /* U+49DF */
  0x8000,   /* U+49E0 */
  0x8001,   /* U+49E1 */
  0x8002,   /* U+49E2 */
  0x8003,   /* U+49E3 */
  0x8000,   /* U+49E4 */
  0x8001,   /* U+49E5 */
  0x8002,   /* U+49E6 */
  0x8000,   /* U+49E7 */
  0x8001,   /* U+49E8 */
  0x8003,   /* U+49E9 */
  0x8002,   /* U+49EA */
  0x8000,   /* U+49EB */
  0x8001,   /* U+49EC */
  0x8002,   /* U+49ED */
  0x8000,   /* U+49EE */
  0x8000,   /* U+49EF */
  0x8000,   /* U+49F0 */
  0x8000,   /* U+49F1 */
  0x8000,   /* U+49F2 */
  0x8001,   /* U+49F3 */
  0x8000,   /* U+49F4 */
  0x8001,   /* U+49F5 */
  0x8002,   /* U+49F6 */
  0x8000,   /* U+49F7 */
  0x8001,   /* U+49F8 */
  0x8002,   /* U+49F9 */
  0x8003,   /* U+49FA */
  0x8000,   /* U+49FB */
  0x8000,   /* U+49FC */
  0x8001,   /* U+49FD */
  0x8000,   /* U+49FE */
  0x8001,   /* U+49FF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4900 */
  0x0000,   /* U+4901 */
  0x0000,   /* U+4902 */
  0x0000,   /* U+4903 */
  0x0000,   /* U+4904 */
  0x0000,   /* U+4905 */
  0x0000,   /* U+4906 */
  0x0000,   /* U+4907 */
  0x0000,   /* U+4908 */
  0x0000,   /* U+4909 */
  0x0000,   /* U+490A */
  0x0000,   /* U+490B */
  0x0000,   /* U+490C */
  0x0000,   /* U+490D */
  0x0000,   /* U+490E */
  0x0000,   /* U+490F */
  0x0000,   /* U+4910 */
  0x0000,   /* U+4911 */
  0x0000,   /* U+4912 */
  0x0000,   /* U+4913 */
  0x0000,   /* U+4914 */
  0x0000,   /* U+4915 */
  0x0000,   /* U+4916 */
  0x0000,   /* U+4917 */
  0x0000,   /* U+4918 */
  0x0000,   /* U+4919 */
  0x0000,   /* U+491A */
  0x0000,   /* U+491B */
  0x0000,   /* U+491C */
  0x0000,   /* U+491D */
  0x0000,   /* U+491E */
  0x0000,   /* U+491F */
  0x0000,   /* U+4920 */
  0x0000,   /* U+4921 */
  0x0000,   /* U+4922 */
  0x0000,   /* U+4923 */
  0x0000,   /* U+4924 */
  0x0000,   /* U+4925 */
  0x0000,   /* U+4926 */
  0x0000,   /* U+4927 */
  0x0000,   /* U+4928 */
  0x0000,   /* U+4929 */
  0x0000,   /* U+492A */
  0x0000,   /* U+492B */
  0x0000,   /* U+492C */
  0x0000,   /* U+492D */
  0x0000,   /* U+492E */
  0x0000,   /* U+492F */
  0x0000,   /* U+4930 */
  0x0000,   /* U+4931 */
  0x0000,   /* U+4932 */
  0x0000,   /* U+4933 */
  0x0000,   /* U+4934 */
  0x0000,   /* U+4935 */
  0x0000,   /* U+4936 */
  0x0000,   /* U+4937 */
  0x0000,   /* U+4938 */
  0x0000,   /* U+4939 */
  0x0000,   /* U+493A */
  0x0000,   /* U+493B */
  0x0000,   /* U+493C */
  0x0000,   /* U+493D */
  0x0000,   /* U+493E */
  0x0000,   /* U+493F */
  0x0000,   /* U+4940 */
  0x0000,   /* U+4941 */
  0x0000,   /* U+4942 */
  0x0000,   /* U+4943 */
  0x0000,   /* U+4944 */
  0x0000,   /* U+4945 */
  0x0000,   /* U+4946 */
  0x0000,   /* U+4947 */
  0x0000,   /* U+4948 */
  0x0000,   /* U+4949 */
  0x0000,   /* U+494A */
  0x0000,   /* U+494B */
  0x0000,   /* U+494C */
  0x0000,   /* U+494D */
  0x0000,   /* U+494E */
  0x0000,   /* U+494F */
  0x0000,   /* U+4950 */
  0x0000,   /* U+4951 */
  0x0000,   /* U+4952 */
  0x0000,   /* U+4953 */
  0x0000,   /* U+4954 */
  0x0000,   /* U+4955 */
  0x0000,   /* U+4956 */
  0x0000,   /* U+4957 */
  0x0000,   /* U+4958 */
  0x0000,   /* U+4959 */
  0x0000,   /* U+495A */
  0x0000,   /* U+495B */
  0x0000,   /* U+495C */
  0x0000,   /* U+495D */
  0x0000,   /* U+495E */
  0x0000,   /* U+495F */
  0x0000,   /* U+4960 */
  0x0000,   /* U+4961 */
  0x0000,   /* U+4962 */
  0x0000,   /* U+4963 */
  0x0000,   /* U+4964 */
  0x0000,   /* U+4965 */
  0x0000,   /* U+4966 */
  0x0000,   /* U+4967 */
  0x0000,   /* U+4968 */
  0x0000,   /* U+4969 */
  0x0000,   /* U+496A */
  0x0000,   /* U+496B */
  0x0000,   /* U+496C */
  0x0000,   /* U+496D */
  0x0000,   /* U+496E */
  0x0000,   /* U+496F */
  0x0000,   /* U+4970 */
  0x0000,   /* U+4971 */
  0x0000,   /* U+4972 */
  0x0000,   /* U+4973 */
  0x0000,   /* U+4974 */
  0x0000,   /* U+4975 */
  0x0000,   /* U+4976 */
  0x0000,   /* U+4977 */
  0x0000,   /* U+4978 */
  0x0000,   /* U+4979 */
  0x0000,   /* U+497A */
  0x0000,   /* U+497B */
  0x0000,   /* U+497C */
  0x0000,   /* U+497D */
  0x0000,   /* U+497E */
  0x0000,   /* U+497F */
  0x0000,   /* U+4980 */
  0x0000,   /* U+4981 */
  0x0000,   /* U+4982 */
  0x0000,   /* U+4983 */
  0x0000,   /* U+4984 */
  0x0000,   /* U+4985 */
  0x0000,   /* U+4986 */
  0x0000,   /* U+4987 */
  0x0000,   /* U+4988 */
  0x0000,   /* U+4989 */
  0x0000,   /* U+498A */
  0x0000,   /* U+498B */
  0x0000,   /* U+498C */
  0x0000,   /* U+498D */
  0x0000,   /* U+498E */
  0x0000,   /* U+498F */
  0x0000,   /* U+4990 */
  0x0000,   /* U+4991 */
  0x0000,   /* U+4992 */
  0x0000,   /* U+4993 */
  0x0000,   /* U+4994 */
  0x0000,   /* U+4995 */
  0x0000,   /* U+4996 */
  0x0000,   /* U+4997 */
  0x0000,   /* U+4998 */
  0x0000,   /* U+4999 */
  0x0000,   /* U+499A */
  0x0000,   /* U+499B */
  0x0000,   /* U+499C */
  0x0000,   /* U+499D */
  0x0000,   /* U+499E */
  0x0000,   /* U+499F */
  0x0000,   /* U+49A0 */
  0x0000,   /* U+49A1 */
  0x0000,   /* U+49A2 */
  0x0000,   /* U+49A3 */
  0x0000,   /* U+49A4 */
  0x0000,   /* U+49A5 */
  0x0000,   /* U+49A6 */
  0x0000,   /* U+49A7 */
  0x0000,   /* U+49A8 */
  0x0000,   /* U+49A9 */
  0x0000,   /* U+49AA */
  0x0000,   /* U+49AB */
  0x0000,   /* U+49AC */
  0x0000,   /* U+49AD */
  0x0000,   /* U+49AE */
  0x0000,   /* U+49AF */
  0x0000,   /* U+49B0 */
  0x0000,   /* U+49B1 */
  0x0000,   /* U+49B2 */
  0x0000,   /* U+49B3 */
  0x0000,   /* U+49B4 */
  0x0000,   /* U+49B5 */
  0x0000,   /* U+49B6 */
  0x0000,   /* U+49B7 */
  0x0000,   /* U+49B8 */
  0x0000,   /* U+49B9 */
  0x0000,   /* U+49BA */
  0x0000,   /* U+49BB */
  0x0000,   /* U+49BC */
  0x0000,   /* U+49BD */
  0x0000,   /* U+49BE */
  0x0000,   /* U+49BF */
  0x0000,   /* U+49C0 */
  0x0000,   /* U+49C1 */
  0x0000,   /* U+49C2 */
  0x0000,   /* U+49C3 */
  0x0000,   /* U+49C4 */
  0x0000,   /* U+49C5 */
  0x0000,   /* U+49C6 */
  0x0000,   /* U+49C7 */
  0x0000,   /* U+49C8 */
  0x0000,   /* U+49C9 */
  0x0000,   /* U+49CA */
  0x0000,   /* U+49CB */
  0x0000,   /* U+49CC */
  0x0000,   /* U+49CD */
  0x0000,   /* U+49CE */
  0x0000,   /* U+49CF */
  0x0000,   /* U+49D0 */
  0x0000,   /* U+49D1 */
  0x0000,   /* U+49D2 */
  0x0000,   /* U+49D3 */
  0x0000,   /* U+49D4 */
  0x0000,   /* U+49D5 */
  0x0000,   /* U+49D6 */
  0x0000,   /* U+49D7 */
  0x0000,   /* U+49D8 */
  0x0000,   /* U+49D9 */
  0x0000,   /* U+49DA */
  0x0000,   /* U+49DB */
  0x0000,   /* U+49DC */
  0x0000,   /* U+49DD */
  0x0000,   /* U+49DE */
  0x0000,   /* U+49DF */
  0x0000,   /* U+49E0 */
  0x0000,   /* U+49E1 */
  0x0000,   /* U+49E2 */
  0x0000,   /* U+49E3 */
  0x0000,   /* U+49E4 */
  0x0000,   /* U+49E5 */
  0x0000,   /* U+49E6 */
  0x0000,   /* U+49E7 */
  0x0000,   /* U+49E8 */
  0x0000,   /* U+49E9 */
  0x0000,   /* U+49EA */
  0x0000,   /* U+49EB */
  0x0000,   /* U+49EC */
  0x0000,   /* U+49ED */
  0x0000,   /* U+49EE */
  0x0000,   /* U+49EF */
  0x0000,   /* U+49F0 */
  0x0000,   /* U+49F1 */
  0x0000,   /* U+49F2 */
  0x0000,   /* U+49F3 */
  0x0000,   /* U+49F4 */
  0x0000,   /* U+49F5 */
  0x0000,   /* U+49F6 */
  0x0000,   /* U+49F7 */
  0x0000,   /* U+49F8 */
  0x0000,   /* U+49F9 */
  0x0000,   /* U+49FA */
  0x0000,   /* U+49FB */
  0x0000,   /* U+49FC */
  0x0000,   /* U+49FD */
  0x0000,   /* U+49FE */
  0x0000,   /* U+49FF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4900 */
  0x0000,   /* U+4901 */
  0x0000,   /* U+4902 */
  0x0000,   /* U+4903 */
  0x0000,   /* U+4904 */
  0x0000,   /* U+4905 */
  0x0000,   /* U+4906 */
  0x0000,   /* U+4907 */
  0x0000,   /* U+4908 */
  0x0000,   /* U+4909 */
  0x0000,   /* U+490A */
  0x0000,   /* U+490B */
  0x0000,   /* U+490C */
  0x0000,   /* U+490D */
  0x0000,   /* U+490E */
  0x0000,   /* U+490F */
  0x0000,   /* U+4910 */
  0x0000,   /* U+4911 */
  0x0000,   /* U+4912 */
  0x0000,   /* U+4913 */
  0x0000,   /* U+4914 */
  0x0000,   /* U+4915 */
  0x0000,   /* U+4916 */
  0x0000,   /* U+4917 */
  0x0000,   /* U+4918 */
  0x0000,   /* U+4919 */
  0x0000,   /* U+491A */
  0x0000,   /* U+491B */
  0x0000,   /* U+491C */
  0x0000,   /* U+491D */
  0x0000,   /* U+491E */
  0x0000,   /* U+491F */
  0x0000,   /* U+4920 */
  0x0000,   /* U+4921 */
  0x0000,   /* U+4922 */
  0x0000,   /* U+4923 */
  0x0000,   /* U+4924 */
  0x0000,   /* U+4925 */
  0x0000,   /* U+4926 */
  0x0000,   /* U+4927 */
  0x0000,   /* U+4928 */
  0x0000,   /* U+4929 */
  0x0000,   /* U+492A */
  0x0000,   /* U+492B */
  0x0000,   /* U+492C */
  0x0000,   /* U+492D */
  0x0000,   /* U+492E */
  0x0000,   /* U+492F */
  0x0000,   /* U+4930 */
  0x0000,   /* U+4931 */
  0x0000,   /* U+4932 */
  0x0000,   /* U+4933 */
  0x0000,   /* U+4934 */
  0x0000,   /* U+4935 */
  0x0000,   /* U+4936 */
  0x0000,   /* U+4937 */
  0x0000,   /* U+4938 */
  0x0000,   /* U+4939 */
  0x0000,   /* U+493A */
  0x0000,   /* U+493B */
  0x0000,   /* U+493C */
  0x0000,   /* U+493D */
  0x0000,   /* U+493E */
  0x0000,   /* U+493F */
  0x0000,   /* U+4940 */
  0x0000,   /* U+4941 */
  0x0000,   /* U+4942 */
  0x0000,   /* U+4943 */
  0x0000,   /* U+4944 */
  0x0000,   /* U+4945 */
  0x0000,   /* U+4946 */
  0x0000,   /* U+4947 */
  0x0000,   /* U+4948 */
  0x0000,   /* U+4949 */
  0x0000,   /* U+494A */
  0x0000,   /* U+494B */
  0x0000,   /* U+494C */
  0x0000,   /* U+494D */
  0x0000,   /* U+494E */
  0x0000,   /* U+494F */
  0x0000,   /* U+4950 */
  0x0000,   /* U+4951 */
  0x0000,   /* U+4952 */
  0x0000,   /* U+4953 */
  0x0000,   /* U+4954 */
  0x0000,   /* U+4955 */
  0x0000,   /* U+4956 */
  0x0000,   /* U+4957 */
  0x0000,   /* U+4958 */
  0x0000,   /* U+4959 */
  0x0000,   /* U+495A */
  0x0000,   /* U+495B */
  0x0000,   /* U+495C */
  0x0000,   /* U+495D */
  0x0000,   /* U+495E */
  0x0000,   /* U+495F */
  0x0000,   /* U+4960 */
  0x0000,   /* U+4961 */
  0x0000,   /* U+4962 */
  0x0000,   /* U+4963 */
  0x0000,   /* U+4964 */
  0x0000,   /* U+4965 */
  0x0000,   /* U+4966 */
  0x0000,   /* U+4967 */
  0x0000,   /* U+4968 */
  0x0000,   /* U+4969 */
  0x0000,   /* U+496A */
  0x0000,   /* U+496B */
  0x0000,   /* U+496C */
  0x0000,   /* U+496D */
  0x0000,   /* U+496E */
  0x0000,   /* U+496F */
  0x0000,   /* U+4970 */
  0x0000,   /* U+4971 */
  0x0000,   /* U+4972 */
  0x0000,   /* U+4973 */
  0x0000,   /* U+4974 */
  0x0000,   /* U+4975 */
  0x0000,   /* U+4976 */
  0x0000,   /* U+4977 */
  0x0000,   /* U+4978 */
  0x0000,   /* U+4979 */
  0x0000,   /* U+497A */
  0x0000,   /* U+497B */
  0x0000,   /* U+497C */
  0x0000,   /* U+497D */
  0x0000,   /* U+497E */
  0x0000,   /* U+497F */
  0x0000,   /* U+4980 */
  0x0000,   /* U+4981 */
  0x0000,   /* U+4982 */
  0x0000,   /* U+4983 */
  0x0000,   /* U+4984 */
  0x0000,   /* U+4985 */
  0x0000,   /* U+4986 */
  0x0000,   /* U+4987 */
  0x0000,   /* U+4988 */
  0x0000,   /* U+4989 */
  0x0000,   /* U+498A */
  0x0000,   /* U+498B */
  0x0000,   /* U+498C */
  0x0000,   /* U+498D */
  0x0000,   /* U+498E */
  0x0000,   /* U+498F */
  0x0000,   /* U+4990 */
  0x0000,   /* U+4991 */
  0x0000,   /* U+4992 */
  0x0000,   /* U+4993 */
  0x0000,   /* U+4994 */
  0x0000,   /* U+4995 */
  0x0000,   /* U+4996 */
  0x0000,   /* U+4997 */
  0x0000,   /* U+4998 */
  0x0000,   /* U+4999 */
  0x0000,   /* U+499A */
  0x0000,   /* U+499B */
  0x0000,   /* U+499C */
  0x0000,   /* U+499D */
  0x0000,   /* U+499E */
  0x0000,   /* U+499F */
  0x0000,   /* U+49A0 */
  0x0000,   /* U+49A1 */
  0x0000,   /* U+49A2 */
  0x0000,   /* U+49A3 */
  0x0000,   /* U+49A4 */
  0x0000,   /* U+49A5 */
  0x0000,   /* U+49A6 */
  0x0000,   /* U+49A7 */
  0x0000,   /* U+49A8 */
  0x0000,   /* U+49A9 */
  0x0000,   /* U+49AA */
  0x0000,   /* U+49AB */
  0x0000,   /* U+49AC */
  0x0000,   /* U+49AD */
  0x0000,   /* U+49AE */
  0x0000,   /* U+49AF */
  0x0000,   /* U+49B0 */
  0x0000,   /* U+49B1 */
  0x0000,   /* U+49B2 */
  0x0000,   /* U+49B3 */
  0x0000,   /* U+49B4 */
  0x0000,   /* U+49B5 */
  0x0000,   /* U+49B6 */
  0x0000,   /* U+49B7 */
  0x0000,   /* U+49B8 */
  0x0000,   /* U+49B9 */
  0x0000,   /* U+49BA */
  0x0000,   /* U+49BB */
  0x0000,   /* U+49BC */
  0x0000,   /* U+49BD */
  0x0000,   /* U+49BE */
  0x0000,   /* U+49BF */
  0x0000,   /* U+49C0 */
  0x0000,   /* U+49C1 */
  0x0000,   /* U+49C2 */
  0x0000,   /* U+49C3 */
  0x0000,   /* U+49C4 */
  0x0000,   /* U+49C5 */
  0x0000,   /* U+49C6 */
  0x0000,   /* U+49C7 */
  0x0000,   /* U+49C8 */
  0x0000,   /* U+49C9 */
  0x0000,   /* U+49CA */
  0x0000,   /* U+49CB */
  0x0000,   /* U+49CC */
  0x0000,   /* U+49CD */
  0x0000,   /* U+49CE */
  0x0000,   /* U+49CF */
  0x0000,   /* U+49D0 */
  0x0000,   /* U+49D1 */
  0x0000,   /* U+49D2 */
  0x0000,   /* U+49D3 */
  0x0000,   /* U+49D4 */
  0x0000,   /* U+49D5 */
  0x0000,   /* U+49D6 */
  0x0000,   /* U+49D7 */
  0x0000,   /* U+49D8 */
  0x0000,   /* U+49D9 */
  0x0000,   /* U+49DA */
  0x0000,   /* U+49DB */
  0x0000,   /* U+49DC */
  0x0000,   /* U+49DD */
  0x0000,   /* U+49DE */
  0x0000,   /* U+49DF */
  0x0000,   /* U+49E0 */
  0x0000,   /* U+49E1 */
  0x0000,   /* U+49E2 */
  0x0000,   /* U+49E3 */
  0x0000,   /* U+49E4 */
  0x0000,   /* U+49E5 */
  0x0000,   /* U+49E6 */
  0x0000,   /* U+49E7 */
  0x0000,   /* U+49E8 */
  0x0000,   /* U+49E9 */
  0x0000,   /* U+49EA */
  0x0000,   /* U+49EB */
  0x0000,   /* U+49EC */
  0x0000,   /* U+49ED */
  0x0000,   /* U+49EE */
  0x0000,   /* U+49EF */
  0x0000,   /* U+49F0 */
  0x0000,   /* U+49F1 */
  0x0000,   /* U+49F2 */
  0x0000,   /* U+49F3 */
  0x0000,   /* U+49F4 */
  0x0000,   /* U+49F5 */
  0x0000,   /* U+49F6 */
  0x0000,   /* U+49F7 */
  0x0000,   /* U+49F8 */
  0x0000,   /* U+49F9 */
  0x0000,   /* U+49FA */
  0x0000,   /* U+49FB */
  0x0000,   /* U+49FC */
  0x0000,   /* U+49FD */
  0x0000,   /* U+49FE */
  0x0000,   /* U+49FF */
};

uint16 zh2_han_p04A[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x3A0D,   /* U+4A00 */
  0x4755,   /* U+4A01 */
  0x4755,   /* U+4A02 */
  0x5C49,   /* U+4A03 */
  0x4757,   /* U+4A04 */
  0x4758,   /* U+4A05 */
  0x4758,   /* U+4A06 */
  0x4758,   /* U+4A07 */
  0x475A,   /* U+4A08 */
  0x475D,   /* U+4A09 */
  0x4764,   /* U+4A0A */
  0x478F,   /* U+4A0B */
  0x4790,   /* U+4A0C */
  0x4790,   /* U+4A0D */
  0x4791,   /* U+4A0E */
  0x4792,   /* U+4A0F */
  0x4792,   /* U+4A10 */
  0x4792,   /* U+4A11 */
  0x4792,   /* U+4A12 */
  0x4792,   /* U+4A13 */
  0x4792,   /* U+4A14 */
  0x4792,   /* U+4A15 */
  0x4792,   /* U+4A16 */
  0x4793,   /* U+4A17 */
  0x4793,   /* U+4A18 */
  0x4793,   /* U+4A19 */
  0x4794,   /* U+4A1A */
  0x4794,   /* U+4A1B */
  0x4794,   /* U+4A1C */
  0x4794,   /* U+4A1D */
  0x4795,   /* U+4A1E */
  0x4795,   /* U+4A1F */
  0x4795,   /* U+4A20 */
  0x4795,   /* U+4A21 */
  0x4795,   /* U+4A22 */
  0x4795,   /* U+4A23 */
  0x4795,   /* U+4A24 */
  0x478D,   /* U+4A25 */
  0x478D,   /* U+4A26 */
  0x478D,   /* U+4A27 */
  0x478D,   /* U+4A28 */
  0x478D,   /* U+4A29 */
  0x478D,   /* U+4A2A */
  0x4797,   /* U+4A2B */
  0x4797,   /* U+4A2C */
  0x4797,   /* U+4A2D */
  0x4797,   /* U+4A2E */
  0x4797,   /* U+4A2F */
  0x4798,   /* U+4A30 */
  0x4798,   /* U+4A31 */
  0x479A,   /* U+4A32 */
  0x479A,   /* U+4A33 */
  0x479A,   /* U+4A34 */
  0x479B,   /* U+4A35 */
  0x5C49,   /* U+4A36 */
  0x479C,   /* U+4A37 */
  0x479D,   /* U+4A38 */
  0x479F,   /* U+4A39 */
  0x47A8,   /* U+4A3A */
  0x47B8,   /* U+4A3B */
  0x47DA,   /* U+4A3C */
  0x480F,   /* U+4A3D */
  0x480F,   /* U+4A3E */
  0x4810,   /* U+4A3F */
  0x4813,   /* U+4A40 */
  0x4818,   /* U+4A41 */
  0x4850,   /* U+4A42 */
  0x4850,   /* U+4A43 */
  0x4850,   /* U+4A44 */
  0x4851,   /* U+4A45 */
  0x4851,   /* U+4A46 */
  0x4851,   /* U+4A47 */
  0x4853,   /* U+4A48 */
  0x4853,   /* U+4A49 */
  0x4854,   /* U+4A4A */
  0x4857,   /* U+4A4B */
  0x4858,   /* U+4A4C */
  0x4858,   /* U+4A4D */
  0x4859,   /* U+4A4E */
  0x485B,   /* U+4A4F */
  0x488F,   /* U+4A50 */
  0x488F,   /* U+4A51 */
  0x488F,   /* U+4A52 */
  0x4890,   /* U+4A53 */
  0x4890,   /* U+4A54 */
  0x4890,   /* U+4A55 */
  0x4890,   /* U+4A56 */
  0x4890,   /* U+4A57 */
  0x4890,   /* U+4A58 */
  0x4891,   /* U+4A59 */
  0x4891,   /* U+4A5A */
  0x4891,   /* U+4A5B */
  0x4891,   /* U+4A5C */
  0x4891,   /* U+4A5D */
  0x4891,   /* U+4A5E */
  0x4892,   /* U+4A5F */
  0x4893,   /* U+4A60 */
  0x4893,   /* U+4A61 */
  0x4893,   /* U+4A62 */
  0x4893,   /* U+4A63 */
  0x4893,   /* U+4A64 */
  0x4893,   /* U+4A65 */
  0x4893,   /* U+4A66 */
  0x4893,   /* U+4A67 */
  0x4894,   /* U+4A68 */
  0x4894,   /* U+4A69 */
  0x4894,   /* U+4A6A */
  0x4894,   /* U+4A6B */
  0x4894,   /* U+4A6C */
  0x4894,   /* U+4A6D */
  0x4894,   /* U+4A6E */
  0x4895,   /* U+4A6F */
  0x4895,   /* U+4A70 */
  0x4895,   /* U+4A71 */
  0x4895,   /* U+4A72 */
  0x4895,   /* U+4A73 */
  0x4895,   /* U+4A74 */
  0x4895,   /* U+4A75 */
  0x488D,   /* U+4A76 */
  0x488D,   /* U+4A77 */
  0x488D,   /* U+4A78 */
  0x488D,   /* U+4A79 */
  0x488D,   /* U+4A7A */
  0x488D,   /* U+4A7B */
  0x4897,   /* U+4A7C */
  0x4897,   /* U+4A7D */
  0x4897,   /* U+4A7E */
  0x4898,   /* U+4A7F */
  0x4898,   /* U+4A80 */
  0x4898,   /* U+4A81 */
  0x4898,   /* U+4A82 */
  0x4898,   /* U+4A83 */
  0x4898,   /* U+4A84 */
  0x4899,   /* U+4A85 */
  0x4899,   /* U+4A86 */
  0x489A,   /* U+4A87 */
  0x489A,   /* U+4A88 */
  0x489B,   /* U+4A89 */
  0x489C,   /* U+4A8A */
  0x489C,   /* U+4A8B */
  0x489D,   /* U+4A8C */
  0x489D,   /* U+4A8D */
  0x489E,   /* U+4A8E */
  0x48D0,   /* U+4A8F */
  0x48D1,   /* U+4A90 */
  0x48D1,   /* U+4A91 */
  0x48D1,   /* U+4A92 */
  0x48D1,   /* U+4A93 */
  0x48D3,   /* U+4A94 */
  0x48D4,   /* U+4A95 */
  0x48D5,   /* U+4A96 */
  0x48D5,   /* U+4A97 */
  0x48D5,   /* U+4A98 */
  0x48CD,   /* U+4A99 */
  0x48CD,   /* U+4A9A */
  0x48D8,   /* U+4A9B */
  0x48D9,   /* U+4A9C */
  0x48DA,   /* U+4A9D */
  0x4910,   /* U+4A9E */
  0x5C49,   /* U+4A9F */
  0x4914,   /* U+4AA0 */
  0x490D,   /* U+4AA1 */
  0x490D,   /* U+4AA2 */
  0x5C49,   /* U+4AA3 */
  0x4918,   /* U+4AA4 */
  0x491A,   /* U+4AA5 */
  0x494F,   /* U+4AA6 */
  0x494F,   /* U+4AA7 */
  0x494F,   /* U+4AA8 */
  0x4950,   /* U+4AA9 */
  0x5C49,   /* U+4AAA */
  0x4953,   /* U+4AAB */
  0x4953,   /* U+4AAC */
  0x4955,   /* U+4AAD */
  0x494D,   /* U+4AAE */
  0x494D,   /* U+4AAF */
  0x4959,   /* U+4AB0 */
  0x498F,   /* U+4AB1 */
  0x498F,   /* U+4AB2 */
  0x4990,   /* U+4AB3 */
  0x4990,   /* U+4AB4 */
  0x4990,   /* U+4AB5 */
  0x4991,   /* U+4AB6 */
  0x4991,   /* U+4AB7 */
  0x4991,   /* U+4AB8 */
  0x4991,   /* U+4AB9 */
  0x4991,   /* U+4ABA */
  0x4991,   /* U+4ABB */
  0x4991,   /* U+4ABC */
  0x4991,   /* U+4ABD */
  0x4991,   /* U+4ABE */
  0x4992,   /* U+4ABF */
  0x4992,   /* U+4AC0 */
  0x4992,   /* U+4AC1 */
  0x4992,   /* U+4AC2 */
  0x4993,   /* U+4AC3 */
  0x4993,   /* U+4AC4 */
  0x4993,   /* U+4AC5 */
  0x4993,   /* U+4AC6 */
  0x4993,   /* U+4AC7 */
  0x4993,   /* U+4AC8 */
  0x4993,   /* U+4AC9 */
  0x4993,   /* U+4ACA */
  0x4994,   /* U+4ACB */
  0x4994,   /* U+4ACC */
  0x4994,   /* U+4ACD */
  0x4994,   /* U+4ACE */
  0x4994,   /* U+4ACF */
  0x4994,   /* U+4AD0 */
  0x4994,   /* U+4AD1 */
  0x4994,   /* U+4AD2 */
  0x4994,   /* U+4AD3 */
  0x4995,   /* U+4AD4 */
  0x4995,   /* U+4AD5 */
  0x4995,   /* U+4AD6 */
  0x4995,   /* U+4AD7 */
  0x4995,   /* U+4AD8 */
  0x4995,   /* U+4AD9 */
  0x4995,   /* U+4ADA */
  0x4995,   /* U+4ADB */
  0x4995,   /* U+4ADC */
  0x4995,   /* U+4ADD */
  0x498D,   /* U+4ADE */
  0x498D,   /* U+4ADF */
  0x498D,   /* U+4AE0 */
  0x498D,   /* U+4AE1 */
  0x498D,   /* U+4AE2 */
  0x498D,   /* U+4AE3 */
  0x498D,   /* U+4AE4 */
  0x498D,   /* U+4AE5 */
  0x498D,   /* U+4AE6 */
  0x498D,   /* U+4AE7 */
  0x4997,   /* U+4AE8 */
  0x4997,   /* U+4AE9 */
  0x4997,   /* U+4AEA */
  0x4997,   /* U+4AEB */
  0x4998,   /* U+4AEC */
  0x4998,   /* U+4AED */
  0x4998,   /* U+4AEE */
  0x4998,   /* U+4AEF */
  0x4998,   /* U+4AF0 */
  0x4998,   /* U+4AF1 */
  0x4999,   /* U+4AF2 */
  0x4999,   /* U+4AF3 */
  0x4999,   /* U+4AF4 */
  0x499B,   /* U+4AF5 */
  0x499B,   /* U+4AF6 */
  0x499C,   /* U+4AF7 */
  0x49CE,   /* U+4AF8 */
  0x49CF,   /* U+4AF9 */
  0x49D0,   /* U+4AFA */
  0x49D0,   /* U+4AFB */
  0x49D0,   /* U+4AFC */
  0x49D0,   /* U+4AFD */
  0x49D1,   /* U+4AFE */
  0x49D1,   /* U+4AFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4A00 */
  0x0020,   /* U+4A01 */
  0x0020,   /* U+4A02 */
  0x0020,   /* U+4A03 */
  0x0020,   /* U+4A04 */
  0x0020,   /* U+4A05 */
  0x0020,   /* U+4A06 */
  0x0020,   /* U+4A07 */
  0x0020,   /* U+4A08 */
  0x0020,   /* U+4A09 */
  0x0020,   /* U+4A0A */
  0x0020,   /* U+4A0B */
  0x0020,   /* U+4A0C */
  0x0020,   /* U+4A0D */
  0x0020,   /* U+4A0E */
  0x0020,   /* U+4A0F */
  0x0020,   /* U+4A10 */
  0x0020,   /* U+4A11 */
  0x0020,   /* U+4A12 */
  0x0020,   /* U+4A13 */
  0x0020,   /* U+4A14 */
  0x0020,   /* U+4A15 */
  0x0020,   /* U+4A16 */
  0x0020,   /* U+4A17 */
  0x0020,   /* U+4A18 */
  0x0020,   /* U+4A19 */
  0x0020,   /* U+4A1A */
  0x0020,   /* U+4A1B */
  0x0020,   /* U+4A1C */
  0x0020,   /* U+4A1D */
  0x0020,   /* U+4A1E */
  0x0020,   /* U+4A1F */
  0x0020,   /* U+4A20 */
  0x0020,   /* U+4A21 */
  0x0020,   /* U+4A22 */
  0x0020,   /* U+4A23 */
  0x0020,   /* U+4A24 */
  0x0020,   /* U+4A25 */
  0x0020,   /* U+4A26 */
  0x0020,   /* U+4A27 */
  0x0020,   /* U+4A28 */
  0x0020,   /* U+4A29 */
  0x0020,   /* U+4A2A */
  0x0020,   /* U+4A2B */
  0x0020,   /* U+4A2C */
  0x0020,   /* U+4A2D */
  0x0020,   /* U+4A2E */
  0x0020,   /* U+4A2F */
  0x0020,   /* U+4A30 */
  0x0020,   /* U+4A31 */
  0x0020,   /* U+4A32 */
  0x0020,   /* U+4A33 */
  0x0020,   /* U+4A34 */
  0x0020,   /* U+4A35 */
  0x0020,   /* U+4A36 */
  0x0020,   /* U+4A37 */
  0x0020,   /* U+4A38 */
  0x0020,   /* U+4A39 */
  0x0020,   /* U+4A3A */
  0x0020,   /* U+4A3B */
  0x0020,   /* U+4A3C */
  0x0020,   /* U+4A3D */
  0x0020,   /* U+4A3E */
  0x0020,   /* U+4A3F */
  0x0020,   /* U+4A40 */
  0x0020,   /* U+4A41 */
  0x0020,   /* U+4A42 */
  0x0020,   /* U+4A43 */
  0x0020,   /* U+4A44 */
  0x0020,   /* U+4A45 */
  0x0020,   /* U+4A46 */
  0x0020,   /* U+4A47 */
  0x0020,   /* U+4A48 */
  0x0020,   /* U+4A49 */
  0x0020,   /* U+4A4A */
  0x0020,   /* U+4A4B */
  0x0020,   /* U+4A4C */
  0x0020,   /* U+4A4D */
  0x0020,   /* U+4A4E */
  0x0020,   /* U+4A4F */
  0x0020,   /* U+4A50 */
  0x0020,   /* U+4A51 */
  0x0020,   /* U+4A52 */
  0x0020,   /* U+4A53 */
  0x0020,   /* U+4A54 */
  0x0020,   /* U+4A55 */
  0x0020,   /* U+4A56 */
  0x0020,   /* U+4A57 */
  0x0020,   /* U+4A58 */
  0x0020,   /* U+4A59 */
  0x0020,   /* U+4A5A */
  0x0020,   /* U+4A5B */
  0x0020,   /* U+4A5C */
  0x0020,   /* U+4A5D */
  0x0020,   /* U+4A5E */
  0x0020,   /* U+4A5F */
  0x0020,   /* U+4A60 */
  0x0020,   /* U+4A61 */
  0x0020,   /* U+4A62 */
  0x0020,   /* U+4A63 */
  0x0020,   /* U+4A64 */
  0x0020,   /* U+4A65 */
  0x0020,   /* U+4A66 */
  0x0020,   /* U+4A67 */
  0x0020,   /* U+4A68 */
  0x0020,   /* U+4A69 */
  0x0020,   /* U+4A6A */
  0x0020,   /* U+4A6B */
  0x0020,   /* U+4A6C */
  0x0020,   /* U+4A6D */
  0x0020,   /* U+4A6E */
  0x0020,   /* U+4A6F */
  0x0020,   /* U+4A70 */
  0x0020,   /* U+4A71 */
  0x0020,   /* U+4A72 */
  0x0020,   /* U+4A73 */
  0x0020,   /* U+4A74 */
  0x0020,   /* U+4A75 */
  0x0020,   /* U+4A76 */
  0x0020,   /* U+4A77 */
  0x0020,   /* U+4A78 */
  0x0020,   /* U+4A79 */
  0x0020,   /* U+4A7A */
  0x0020,   /* U+4A7B */
  0x0020,   /* U+4A7C */
  0x0020,   /* U+4A7D */
  0x0020,   /* U+4A7E */
  0x0020,   /* U+4A7F */
  0x0020,   /* U+4A80 */
  0x0020,   /* U+4A81 */
  0x0020,   /* U+4A82 */
  0x0020,   /* U+4A83 */
  0x0020,   /* U+4A84 */
  0x0020,   /* U+4A85 */
  0x0020,   /* U+4A86 */
  0x0020,   /* U+4A87 */
  0x0020,   /* U+4A88 */
  0x0020,   /* U+4A89 */
  0x0020,   /* U+4A8A */
  0x0020,   /* U+4A8B */
  0x0020,   /* U+4A8C */
  0x0020,   /* U+4A8D */
  0x0020,   /* U+4A8E */
  0x0020,   /* U+4A8F */
  0x0020,   /* U+4A90 */
  0x0020,   /* U+4A91 */
  0x0020,   /* U+4A92 */
  0x0020,   /* U+4A93 */
  0x0020,   /* U+4A94 */
  0x0020,   /* U+4A95 */
  0x0020,   /* U+4A96 */
  0x0020,   /* U+4A97 */
  0x0020,   /* U+4A98 */
  0x0020,   /* U+4A99 */
  0x0020,   /* U+4A9A */
  0x0020,   /* U+4A9B */
  0x0020,   /* U+4A9C */
  0x0020,   /* U+4A9D */
  0x0020,   /* U+4A9E */
  0x0020,   /* U+4A9F */
  0x0020,   /* U+4AA0 */
  0x0020,   /* U+4AA1 */
  0x0020,   /* U+4AA2 */
  0x0020,   /* U+4AA3 */
  0x0020,   /* U+4AA4 */
  0x0020,   /* U+4AA5 */
  0x0020,   /* U+4AA6 */
  0x0020,   /* U+4AA7 */
  0x0020,   /* U+4AA8 */
  0x0020,   /* U+4AA9 */
  0x0020,   /* U+4AAA */
  0x0020,   /* U+4AAB */
  0x0020,   /* U+4AAC */
  0x0020,   /* U+4AAD */
  0x0020,   /* U+4AAE */
  0x0020,   /* U+4AAF */
  0x0020,   /* U+4AB0 */
  0x0020,   /* U+4AB1 */
  0x0020,   /* U+4AB2 */
  0x0020,   /* U+4AB3 */
  0x0020,   /* U+4AB4 */
  0x0020,   /* U+4AB5 */
  0x0020,   /* U+4AB6 */
  0x0020,   /* U+4AB7 */
  0x0020,   /* U+4AB8 */
  0x0020,   /* U+4AB9 */
  0x0020,   /* U+4ABA */
  0x0020,   /* U+4ABB */
  0x0020,   /* U+4ABC */
  0x0020,   /* U+4ABD */
  0x0020,   /* U+4ABE */
  0x0020,   /* U+4ABF */
  0x0020,   /* U+4AC0 */
  0x0020,   /* U+4AC1 */
  0x0020,   /* U+4AC2 */
  0x0020,   /* U+4AC3 */
  0x0020,   /* U+4AC4 */
  0x0020,   /* U+4AC5 */
  0x0020,   /* U+4AC6 */
  0x0020,   /* U+4AC7 */
  0x0020,   /* U+4AC8 */
  0x0020,   /* U+4AC9 */
  0x0020,   /* U+4ACA */
  0x0020,   /* U+4ACB */
  0x0020,   /* U+4ACC */
  0x0020,   /* U+4ACD */
  0x0020,   /* U+4ACE */
  0x0020,   /* U+4ACF */
  0x0020,   /* U+4AD0 */
  0x0020,   /* U+4AD1 */
  0x0020,   /* U+4AD2 */
  0x0020,   /* U+4AD3 */
  0x0020,   /* U+4AD4 */
  0x0020,   /* U+4AD5 */
  0x0020,   /* U+4AD6 */
  0x0020,   /* U+4AD7 */
  0x0020,   /* U+4AD8 */
  0x0020,   /* U+4AD9 */
  0x0020,   /* U+4ADA */
  0x0020,   /* U+4ADB */
  0x0020,   /* U+4ADC */
  0x0020,   /* U+4ADD */
  0x0020,   /* U+4ADE */
  0x0020,   /* U+4ADF */
  0x0020,   /* U+4AE0 */
  0x0020,   /* U+4AE1 */
  0x0020,   /* U+4AE2 */
  0x0020,   /* U+4AE3 */
  0x0020,   /* U+4AE4 */
  0x0020,   /* U+4AE5 */
  0x0020,   /* U+4AE6 */
  0x0020,   /* U+4AE7 */
  0x0020,   /* U+4AE8 */
  0x0020,   /* U+4AE9 */
  0x0020,   /* U+4AEA */
  0x0020,   /* U+4AEB */
  0x0020,   /* U+4AEC */
  0x0020,   /* U+4AED */
  0x0020,   /* U+4AEE */
  0x0020,   /* U+4AEF */
  0x0020,   /* U+4AF0 */
  0x0020,   /* U+4AF1 */
  0x0020,   /* U+4AF2 */
  0x0020,   /* U+4AF3 */
  0x0020,   /* U+4AF4 */
  0x0020,   /* U+4AF5 */
  0x0020,   /* U+4AF6 */
  0x0020,   /* U+4AF7 */
  0x0020,   /* U+4AF8 */
  0x0020,   /* U+4AF9 */
  0x0020,   /* U+4AFA */
  0x0020,   /* U+4AFB */
  0x0020,   /* U+4AFC */
  0x0020,   /* U+4AFD */
  0x0020,   /* U+4AFE */
  0x0020,   /* U+4AFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4A00 */
  0x0002,   /* U+4A01 */
  0x0002,   /* U+4A02 */
  0x0002,   /* U+4A03 */
  0x0002,   /* U+4A04 */
  0x0002,   /* U+4A05 */
  0x0002,   /* U+4A06 */
  0x0002,   /* U+4A07 */
  0x0002,   /* U+4A08 */
  0x0002,   /* U+4A09 */
  0x0002,   /* U+4A0A */
  0x0002,   /* U+4A0B */
  0x0002,   /* U+4A0C */
  0x0002,   /* U+4A0D */
  0x0002,   /* U+4A0E */
  0x0002,   /* U+4A0F */
  0x0002,   /* U+4A10 */
  0x0002,   /* U+4A11 */
  0x0002,   /* U+4A12 */
  0x0002,   /* U+4A13 */
  0x0002,   /* U+4A14 */
  0x0002,   /* U+4A15 */
  0x0002,   /* U+4A16 */
  0x0002,   /* U+4A17 */
  0x0002,   /* U+4A18 */
  0x0002,   /* U+4A19 */
  0x0002,   /* U+4A1A */
  0x0002,   /* U+4A1B */
  0x0002,   /* U+4A1C */
  0x0002,   /* U+4A1D */
  0x0002,   /* U+4A1E */
  0x0002,   /* U+4A1F */
  0x0002,   /* U+4A20 */
  0x0002,   /* U+4A21 */
  0x0002,   /* U+4A22 */
  0x0002,   /* U+4A23 */
  0x0002,   /* U+4A24 */
  0x0002,   /* U+4A25 */
  0x0002,   /* U+4A26 */
  0x0002,   /* U+4A27 */
  0x0002,   /* U+4A28 */
  0x0002,   /* U+4A29 */
  0x0002,   /* U+4A2A */
  0x0002,   /* U+4A2B */
  0x0002,   /* U+4A2C */
  0x0002,   /* U+4A2D */
  0x0002,   /* U+4A2E */
  0x0002,   /* U+4A2F */
  0x0002,   /* U+4A30 */
  0x0002,   /* U+4A31 */
  0x0002,   /* U+4A32 */
  0x0002,   /* U+4A33 */
  0x0002,   /* U+4A34 */
  0x0002,   /* U+4A35 */
  0x0002,   /* U+4A36 */
  0x0002,   /* U+4A37 */
  0x0002,   /* U+4A38 */
  0x0002,   /* U+4A39 */
  0x0002,   /* U+4A3A */
  0x0002,   /* U+4A3B */
  0x0002,   /* U+4A3C */
  0x0002,   /* U+4A3D */
  0x0002,   /* U+4A3E */
  0x0002,   /* U+4A3F */
  0x0002,   /* U+4A40 */
  0x0002,   /* U+4A41 */
  0x0002,   /* U+4A42 */
  0x0002,   /* U+4A43 */
  0x0002,   /* U+4A44 */
  0x0002,   /* U+4A45 */
  0x0002,   /* U+4A46 */
  0x0002,   /* U+4A47 */
  0x0002,   /* U+4A48 */
  0x0002,   /* U+4A49 */
  0x0002,   /* U+4A4A */
  0x0002,   /* U+4A4B */
  0x0002,   /* U+4A4C */
  0x0002,   /* U+4A4D */
  0x0002,   /* U+4A4E */
  0x0002,   /* U+4A4F */
  0x0002,   /* U+4A50 */
  0x0002,   /* U+4A51 */
  0x0002,   /* U+4A52 */
  0x0002,   /* U+4A53 */
  0x0002,   /* U+4A54 */
  0x0002,   /* U+4A55 */
  0x0002,   /* U+4A56 */
  0x0002,   /* U+4A57 */
  0x0002,   /* U+4A58 */
  0x0002,   /* U+4A59 */
  0x0002,   /* U+4A5A */
  0x0002,   /* U+4A5B */
  0x0002,   /* U+4A5C */
  0x0002,   /* U+4A5D */
  0x0002,   /* U+4A5E */
  0x0002,   /* U+4A5F */
  0x0002,   /* U+4A60 */
  0x0002,   /* U+4A61 */
  0x0002,   /* U+4A62 */
  0x0002,   /* U+4A63 */
  0x0002,   /* U+4A64 */
  0x0002,   /* U+4A65 */
  0x0002,   /* U+4A66 */
  0x0002,   /* U+4A67 */
  0x0002,   /* U+4A68 */
  0x0002,   /* U+4A69 */
  0x0002,   /* U+4A6A */
  0x0002,   /* U+4A6B */
  0x0002,   /* U+4A6C */
  0x0002,   /* U+4A6D */
  0x0002,   /* U+4A6E */
  0x0002,   /* U+4A6F */
  0x0002,   /* U+4A70 */
  0x0002,   /* U+4A71 */
  0x0002,   /* U+4A72 */
  0x0002,   /* U+4A73 */
  0x0002,   /* U+4A74 */
  0x0002,   /* U+4A75 */
  0x0002,   /* U+4A76 */
  0x0002,   /* U+4A77 */
  0x0002,   /* U+4A78 */
  0x0002,   /* U+4A79 */
  0x0002,   /* U+4A7A */
  0x0002,   /* U+4A7B */
  0x0002,   /* U+4A7C */
  0x0002,   /* U+4A7D */
  0x0002,   /* U+4A7E */
  0x0002,   /* U+4A7F */
  0x0002,   /* U+4A80 */
  0x0002,   /* U+4A81 */
  0x0002,   /* U+4A82 */
  0x0002,   /* U+4A83 */
  0x0002,   /* U+4A84 */
  0x0002,   /* U+4A85 */
  0x0002,   /* U+4A86 */
  0x0002,   /* U+4A87 */
  0x0002,   /* U+4A88 */
  0x0002,   /* U+4A89 */
  0x0002,   /* U+4A8A */
  0x0002,   /* U+4A8B */
  0x0002,   /* U+4A8C */
  0x0002,   /* U+4A8D */
  0x0002,   /* U+4A8E */
  0x0002,   /* U+4A8F */
  0x0002,   /* U+4A90 */
  0x0002,   /* U+4A91 */
  0x0002,   /* U+4A92 */
  0x0002,   /* U+4A93 */
  0x0002,   /* U+4A94 */
  0x0002,   /* U+4A95 */
  0x0002,   /* U+4A96 */
  0x0002,   /* U+4A97 */
  0x0002,   /* U+4A98 */
  0x0002,   /* U+4A99 */
  0x0002,   /* U+4A9A */
  0x0002,   /* U+4A9B */
  0x0002,   /* U+4A9C */
  0x0002,   /* U+4A9D */
  0x0002,   /* U+4A9E */
  0x0002,   /* U+4A9F */
  0x0002,   /* U+4AA0 */
  0x0002,   /* U+4AA1 */
  0x0002,   /* U+4AA2 */
  0x0002,   /* U+4AA3 */
  0x0002,   /* U+4AA4 */
  0x0002,   /* U+4AA5 */
  0x0002,   /* U+4AA6 */
  0x0002,   /* U+4AA7 */
  0x0002,   /* U+4AA8 */
  0x0002,   /* U+4AA9 */
  0x0002,   /* U+4AAA */
  0x0002,   /* U+4AAB */
  0x0002,   /* U+4AAC */
  0x0002,   /* U+4AAD */
  0x0002,   /* U+4AAE */
  0x0002,   /* U+4AAF */
  0x0002,   /* U+4AB0 */
  0x0002,   /* U+4AB1 */
  0x0002,   /* U+4AB2 */
  0x0002,   /* U+4AB3 */
  0x0002,   /* U+4AB4 */
  0x0002,   /* U+4AB5 */
  0x0002,   /* U+4AB6 */
  0x0002,   /* U+4AB7 */
  0x0002,   /* U+4AB8 */
  0x0002,   /* U+4AB9 */
  0x0002,   /* U+4ABA */
  0x0002,   /* U+4ABB */
  0x0002,   /* U+4ABC */
  0x0002,   /* U+4ABD */
  0x0002,   /* U+4ABE */
  0x0002,   /* U+4ABF */
  0x0002,   /* U+4AC0 */
  0x0002,   /* U+4AC1 */
  0x0002,   /* U+4AC2 */
  0x0002,   /* U+4AC3 */
  0x0002,   /* U+4AC4 */
  0x0002,   /* U+4AC5 */
  0x0002,   /* U+4AC6 */
  0x0002,   /* U+4AC7 */
  0x0002,   /* U+4AC8 */
  0x0002,   /* U+4AC9 */
  0x0002,   /* U+4ACA */
  0x0002,   /* U+4ACB */
  0x0002,   /* U+4ACC */
  0x0002,   /* U+4ACD */
  0x0002,   /* U+4ACE */
  0x0002,   /* U+4ACF */
  0x0002,   /* U+4AD0 */
  0x0002,   /* U+4AD1 */
  0x0002,   /* U+4AD2 */
  0x0002,   /* U+4AD3 */
  0x0002,   /* U+4AD4 */
  0x0002,   /* U+4AD5 */
  0x0002,   /* U+4AD6 */
  0x0002,   /* U+4AD7 */
  0x0002,   /* U+4AD8 */
  0x0002,   /* U+4AD9 */
  0x0002,   /* U+4ADA */
  0x0002,   /* U+4ADB */
  0x0002,   /* U+4ADC */
  0x0002,   /* U+4ADD */
  0x0002,   /* U+4ADE */
  0x0002,   /* U+4ADF */
  0x0002,   /* U+4AE0 */
  0x0002,   /* U+4AE1 */
  0x0002,   /* U+4AE2 */
  0x0002,   /* U+4AE3 */
  0x0002,   /* U+4AE4 */
  0x0002,   /* U+4AE5 */
  0x0002,   /* U+4AE6 */
  0x0002,   /* U+4AE7 */
  0x0002,   /* U+4AE8 */
  0x0002,   /* U+4AE9 */
  0x0002,   /* U+4AEA */
  0x0002,   /* U+4AEB */
  0x0002,   /* U+4AEC */
  0x0002,   /* U+4AED */
  0x0002,   /* U+4AEE */
  0x0002,   /* U+4AEF */
  0x0002,   /* U+4AF0 */
  0x0002,   /* U+4AF1 */
  0x0002,   /* U+4AF2 */
  0x0002,   /* U+4AF3 */
  0x0002,   /* U+4AF4 */
  0x0002,   /* U+4AF5 */
  0x0002,   /* U+4AF6 */
  0x0002,   /* U+4AF7 */
  0x0002,   /* U+4AF8 */
  0x0002,   /* U+4AF9 */
  0x0002,   /* U+4AFA */
  0x0002,   /* U+4AFB */
  0x0002,   /* U+4AFC */
  0x0002,   /* U+4AFD */
  0x0002,   /* U+4AFE */
  0x0002,   /* U+4AFF */

  /* Primary weight 2 for each character. */
  0x8002,   /* U+4A00 */
  0x8000,   /* U+4A01 */
  0x8001,   /* U+4A02 */
  0xCA03,   /* U+4A03 */
  0x8000,   /* U+4A04 */
  0x8000,   /* U+4A05 */
  0x8001,   /* U+4A06 */
  0x8002,   /* U+4A07 */
  0x8000,   /* U+4A08 */
  0x8000,   /* U+4A09 */
  0x8000,   /* U+4A0A */
  0x8000,   /* U+4A0B */
  0x8000,   /* U+4A0C */
  0x8001,   /* U+4A0D */
  0x8000,   /* U+4A0E */
  0x8000,   /* U+4A0F */
  0x8001,   /* U+4A10 */
  0x8002,   /* U+4A11 */
  0x8003,   /* U+4A12 */
  0x8004,   /* U+4A13 */
  0x8005,   /* U+4A14 */
  0x8006,   /* U+4A15 */
  0x8007,   /* U+4A16 */
  0x8000,   /* U+4A17 */
  0x8001,   /* U+4A18 */
  0x8002,   /* U+4A19 */
  0x8000,   /* U+4A1A */
  0x8001,   /* U+4A1B */
  0x8002,   /* U+4A1C */
  0x8003,   /* U+4A1D */
  0x8000,   /* U+4A1E */
  0x8001,   /* U+4A1F */
  0x8002,   /* U+4A20 */
  0x8003,   /* U+4A21 */
  0x8004,   /* U+4A22 */
  0x8005,   /* U+4A23 */
  0x8006,   /* U+4A24 */
  0x8000,   /* U+4A25 */
  0x8001,   /* U+4A26 */
  0x8002,   /* U+4A27 */
  0x8003,   /* U+4A28 */
  0x8004,   /* U+4A29 */
  0x8005,   /* U+4A2A */
  0x8000,   /* U+4A2B */
  0x8001,   /* U+4A2C */
  0x8002,   /* U+4A2D */
  0x8003,   /* U+4A2E */
  0x8004,   /* U+4A2F */
  0x8000,   /* U+4A30 */
  0x8001,   /* U+4A31 */
  0x8000,   /* U+4A32 */
  0x8001,   /* U+4A33 */
  0x8002,   /* U+4A34 */
  0x8000,   /* U+4A35 */
  0xCA36,   /* U+4A36 */
  0x8000,   /* U+4A37 */
  0x8000,   /* U+4A38 */
  0x8000,   /* U+4A39 */
  0x8000,   /* U+4A3A */
  0x8000,   /* U+4A3B */
  0x8000,   /* U+4A3C */
  0x8000,   /* U+4A3D */
  0x8001,   /* U+4A3E */
  0x8000,   /* U+4A3F */
  0x8000,   /* U+4A40 */
  0x8000,   /* U+4A41 */
  0x8000,   /* U+4A42 */
  0x8001,   /* U+4A43 */
  0x8002,   /* U+4A44 */
  0x8000,   /* U+4A45 */
  0x8001,   /* U+4A46 */
  0x8002,   /* U+4A47 */
  0x8000,   /* U+4A48 */
  0x8001,   /* U+4A49 */
  0x8000,   /* U+4A4A */
  0x8000,   /* U+4A4B */
  0x8000,   /* U+4A4C */
  0x8001,   /* U+4A4D */
  0x8000,   /* U+4A4E */
  0x8000,   /* U+4A4F */
  0x8000,   /* U+4A50 */
  0x8001,   /* U+4A51 */
  0x8002,   /* U+4A52 */
  0x8000,   /* U+4A53 */
  0x8001,   /* U+4A54 */
  0x8002,   /* U+4A55 */
  0x8003,   /* U+4A56 */
  0x8004,   /* U+4A57 */
  0x8005,   /* U+4A58 */
  0x8000,   /* U+4A59 */
  0x8001,   /* U+4A5A */
  0x8002,   /* U+4A5B */
  0x8003,   /* U+4A5C */
  0x8004,   /* U+4A5D */
  0x8005,   /* U+4A5E */
  0x8000,   /* U+4A5F */
  0x8000,   /* U+4A60 */
  0x8001,   /* U+4A61 */
  0x8002,   /* U+4A62 */
  0x8003,   /* U+4A63 */
  0x8004,   /* U+4A64 */
  0x8005,   /* U+4A65 */
  0x8006,   /* U+4A66 */
  0x8007,   /* U+4A67 */
  0x8000,   /* U+4A68 */
  0x8001,   /* U+4A69 */
  0x8002,   /* U+4A6A */
  0x8003,   /* U+4A6B */
  0x8004,   /* U+4A6C */
  0x8005,   /* U+4A6D */
  0x8006,   /* U+4A6E */
  0x8000,   /* U+4A6F */
  0x8001,   /* U+4A70 */
  0x8002,   /* U+4A71 */
  0x8003,   /* U+4A72 */
  0x8004,   /* U+4A73 */
  0x8005,   /* U+4A74 */
  0x8006,   /* U+4A75 */
  0x8000,   /* U+4A76 */
  0x8001,   /* U+4A77 */
  0x8002,   /* U+4A78 */
  0x8003,   /* U+4A79 */
  0x8004,   /* U+4A7A */
  0x8005,   /* U+4A7B */
  0x8000,   /* U+4A7C */
  0x8001,   /* U+4A7D */
  0x8002,   /* U+4A7E */
  0x8000,   /* U+4A7F */
  0x8001,   /* U+4A80 */
  0x8002,   /* U+4A81 */
  0x8003,   /* U+4A82 */
  0x8004,   /* U+4A83 */
  0x8005,   /* U+4A84 */
  0x8000,   /* U+4A85 */
  0x8001,   /* U+4A86 */
  0x8000,   /* U+4A87 */
  0x8001,   /* U+4A88 */
  0x8000,   /* U+4A89 */
  0x8000,   /* U+4A8A */
  0x8001,   /* U+4A8B */
  0x8000,   /* U+4A8C */
  0x8001,   /* U+4A8D */
  0x8000,   /* U+4A8E */
  0x8004,   /* U+4A8F */
  0x8005,   /* U+4A90 */
  0x8006,   /* U+4A91 */
  0x8007,   /* U+4A92 */
  0x8008,   /* U+4A93 */
  0x8000,   /* U+4A94 */
  0x8002,   /* U+4A95 */
  0x8006,   /* U+4A96 */
  0x8007,   /* U+4A97 */
  0x8008,   /* U+4A98 */
  0x8000,   /* U+4A99 */
  0x8001,   /* U+4A9A */
  0x8002,   /* U+4A9B */
  0x8001,   /* U+4A9C */
  0x8000,   /* U+4A9D */
  0x8000,   /* U+4A9E */
  0xCA9F,   /* U+4A9F */
  0x8000,   /* U+4AA0 */
  0x8000,   /* U+4AA1 */
  0x8001,   /* U+4AA2 */
  0xCAA3,   /* U+4AA3 */
  0x8000,   /* U+4AA4 */
  0x8000,   /* U+4AA5 */
  0x8000,   /* U+4AA6 */
  0x8001,   /* U+4AA7 */
  0x8002,   /* U+4AA8 */
  0x8000,   /* U+4AA9 */
  0xCAAA,   /* U+4AAA */
  0x8000,   /* U+4AAB */
  0x8001,   /* U+4AAC */
  0x8000,   /* U+4AAD */
  0x8000,   /* U+4AAE */
  0x8001,   /* U+4AAF */
  0x8000,   /* U+4AB0 */
  0x8005,   /* U+4AB1 */
  0x8006,   /* U+4AB2 */
  0x800D,   /* U+4AB3 */
  0x800E,   /* U+4AB4 */
  0x800F,   /* U+4AB5 */
  0x800B,   /* U+4AB6 */
  0x800C,   /* U+4AB7 */
  0x800D,   /* U+4AB8 */
  0x800E,   /* U+4AB9 */
  0x800F,   /* U+4ABA */
  0x8010,   /* U+4ABB */
  0x8011,   /* U+4ABC */
  0x8012,   /* U+4ABD */
  0x8013,   /* U+4ABE */
  0x8013,   /* U+4ABF */
  0x8014,   /* U+4AC0 */
  0x8015,   /* U+4AC1 */
  0x8016,   /* U+4AC2 */
  0x800C,   /* U+4AC3 */
  0x800D,   /* U+4AC4 */
  0x800E,   /* U+4AC5 */
  0x800F,   /* U+4AC6 */
  0x8010,   /* U+4AC7 */
  0x8011,   /* U+4AC8 */
  0x8012,   /* U+4AC9 */
  0x8013,   /* U+4ACA */
  0x800D,   /* U+4ACB */
  0x800E,   /* U+4ACC */
  0x800F,   /* U+4ACD */
  0x8010,   /* U+4ACE */
  0x8011,   /* U+4ACF */
  0x8012,   /* U+4AD0 */
  0x8013,   /* U+4AD1 */
  0x8014,   /* U+4AD2 */
  0x8015,   /* U+4AD3 */
  0x800A,   /* U+4AD4 */
  0x800B,   /* U+4AD5 */
  0x800C,   /* U+4AD6 */
  0x800D,   /* U+4AD7 */
  0x800E,   /* U+4AD8 */
  0x800F,   /* U+4AD9 */
  0x8010,   /* U+4ADA */
  0x8011,   /* U+4ADB */
  0x8012,   /* U+4ADC */
  0x8013,   /* U+4ADD */
  0x8000,   /* U+4ADE */
  0x8001,   /* U+4ADF */
  0x8002,   /* U+4AE0 */
  0x8003,   /* U+4AE1 */
  0x8004,   /* U+4AE2 */
  0x8005,   /* U+4AE3 */
  0x8006,   /* U+4AE4 */
  0x8007,   /* U+4AE5 */
  0x8008,   /* U+4AE6 */
  0x8009,   /* U+4AE7 */
  0x8001,   /* U+4AE8 */
  0x8002,   /* U+4AE9 */
  0x8003,   /* U+4AEA */
  0x8004,   /* U+4AEB */
  0x8003,   /* U+4AEC */
  0x8004,   /* U+4AED */
  0x8005,   /* U+4AEE */
  0x8006,   /* U+4AEF */
  0x8007,   /* U+4AF0 */
  0x8008,   /* U+4AF1 */
  0x8002,   /* U+4AF2 */
  0x8003,   /* U+4AF3 */
  0x8004,   /* U+4AF4 */
  0x8002,   /* U+4AF5 */
  0x8003,   /* U+4AF6 */
  0x8000,   /* U+4AF7 */
  0x8000,   /* U+4AF8 */
  0x8001,   /* U+4AF9 */
  0x8004,   /* U+4AFA */
  0x8005,   /* U+4AFB */
  0x8006,   /* U+4AFC */
  0x8007,   /* U+4AFD */
  0x8008,   /* U+4AFE */
  0x8009,   /* U+4AFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4A00 */
  0x0000,   /* U+4A01 */
  0x0000,   /* U+4A02 */
  0x0000,   /* U+4A03 */
  0x0000,   /* U+4A04 */
  0x0000,   /* U+4A05 */
  0x0000,   /* U+4A06 */
  0x0000,   /* U+4A07 */
  0x0000,   /* U+4A08 */
  0x0000,   /* U+4A09 */
  0x0000,   /* U+4A0A */
  0x0000,   /* U+4A0B */
  0x0000,   /* U+4A0C */
  0x0000,   /* U+4A0D */
  0x0000,   /* U+4A0E */
  0x0000,   /* U+4A0F */
  0x0000,   /* U+4A10 */
  0x0000,   /* U+4A11 */
  0x0000,   /* U+4A12 */
  0x0000,   /* U+4A13 */
  0x0000,   /* U+4A14 */
  0x0000,   /* U+4A15 */
  0x0000,   /* U+4A16 */
  0x0000,   /* U+4A17 */
  0x0000,   /* U+4A18 */
  0x0000,   /* U+4A19 */
  0x0000,   /* U+4A1A */
  0x0000,   /* U+4A1B */
  0x0000,   /* U+4A1C */
  0x0000,   /* U+4A1D */
  0x0000,   /* U+4A1E */
  0x0000,   /* U+4A1F */
  0x0000,   /* U+4A20 */
  0x0000,   /* U+4A21 */
  0x0000,   /* U+4A22 */
  0x0000,   /* U+4A23 */
  0x0000,   /* U+4A24 */
  0x0000,   /* U+4A25 */
  0x0000,   /* U+4A26 */
  0x0000,   /* U+4A27 */
  0x0000,   /* U+4A28 */
  0x0000,   /* U+4A29 */
  0x0000,   /* U+4A2A */
  0x0000,   /* U+4A2B */
  0x0000,   /* U+4A2C */
  0x0000,   /* U+4A2D */
  0x0000,   /* U+4A2E */
  0x0000,   /* U+4A2F */
  0x0000,   /* U+4A30 */
  0x0000,   /* U+4A31 */
  0x0000,   /* U+4A32 */
  0x0000,   /* U+4A33 */
  0x0000,   /* U+4A34 */
  0x0000,   /* U+4A35 */
  0x0000,   /* U+4A36 */
  0x0000,   /* U+4A37 */
  0x0000,   /* U+4A38 */
  0x0000,   /* U+4A39 */
  0x0000,   /* U+4A3A */
  0x0000,   /* U+4A3B */
  0x0000,   /* U+4A3C */
  0x0000,   /* U+4A3D */
  0x0000,   /* U+4A3E */
  0x0000,   /* U+4A3F */
  0x0000,   /* U+4A40 */
  0x0000,   /* U+4A41 */
  0x0000,   /* U+4A42 */
  0x0000,   /* U+4A43 */
  0x0000,   /* U+4A44 */
  0x0000,   /* U+4A45 */
  0x0000,   /* U+4A46 */
  0x0000,   /* U+4A47 */
  0x0000,   /* U+4A48 */
  0x0000,   /* U+4A49 */
  0x0000,   /* U+4A4A */
  0x0000,   /* U+4A4B */
  0x0000,   /* U+4A4C */
  0x0000,   /* U+4A4D */
  0x0000,   /* U+4A4E */
  0x0000,   /* U+4A4F */
  0x0000,   /* U+4A50 */
  0x0000,   /* U+4A51 */
  0x0000,   /* U+4A52 */
  0x0000,   /* U+4A53 */
  0x0000,   /* U+4A54 */
  0x0000,   /* U+4A55 */
  0x0000,   /* U+4A56 */
  0x0000,   /* U+4A57 */
  0x0000,   /* U+4A58 */
  0x0000,   /* U+4A59 */
  0x0000,   /* U+4A5A */
  0x0000,   /* U+4A5B */
  0x0000,   /* U+4A5C */
  0x0000,   /* U+4A5D */
  0x0000,   /* U+4A5E */
  0x0000,   /* U+4A5F */
  0x0000,   /* U+4A60 */
  0x0000,   /* U+4A61 */
  0x0000,   /* U+4A62 */
  0x0000,   /* U+4A63 */
  0x0000,   /* U+4A64 */
  0x0000,   /* U+4A65 */
  0x0000,   /* U+4A66 */
  0x0000,   /* U+4A67 */
  0x0000,   /* U+4A68 */
  0x0000,   /* U+4A69 */
  0x0000,   /* U+4A6A */
  0x0000,   /* U+4A6B */
  0x0000,   /* U+4A6C */
  0x0000,   /* U+4A6D */
  0x0000,   /* U+4A6E */
  0x0000,   /* U+4A6F */
  0x0000,   /* U+4A70 */
  0x0000,   /* U+4A71 */
  0x0000,   /* U+4A72 */
  0x0000,   /* U+4A73 */
  0x0000,   /* U+4A74 */
  0x0000,   /* U+4A75 */
  0x0000,   /* U+4A76 */
  0x0000,   /* U+4A77 */
  0x0000,   /* U+4A78 */
  0x0000,   /* U+4A79 */
  0x0000,   /* U+4A7A */
  0x0000,   /* U+4A7B */
  0x0000,   /* U+4A7C */
  0x0000,   /* U+4A7D */
  0x0000,   /* U+4A7E */
  0x0000,   /* U+4A7F */
  0x0000,   /* U+4A80 */
  0x0000,   /* U+4A81 */
  0x0000,   /* U+4A82 */
  0x0000,   /* U+4A83 */
  0x0000,   /* U+4A84 */
  0x0000,   /* U+4A85 */
  0x0000,   /* U+4A86 */
  0x0000,   /* U+4A87 */
  0x0000,   /* U+4A88 */
  0x0000,   /* U+4A89 */
  0x0000,   /* U+4A8A */
  0x0000,   /* U+4A8B */
  0x0000,   /* U+4A8C */
  0x0000,   /* U+4A8D */
  0x0000,   /* U+4A8E */
  0x0000,   /* U+4A8F */
  0x0000,   /* U+4A90 */
  0x0000,   /* U+4A91 */
  0x0000,   /* U+4A92 */
  0x0000,   /* U+4A93 */
  0x0000,   /* U+4A94 */
  0x0000,   /* U+4A95 */
  0x0000,   /* U+4A96 */
  0x0000,   /* U+4A97 */
  0x0000,   /* U+4A98 */
  0x0000,   /* U+4A99 */
  0x0000,   /* U+4A9A */
  0x0000,   /* U+4A9B */
  0x0000,   /* U+4A9C */
  0x0000,   /* U+4A9D */
  0x0000,   /* U+4A9E */
  0x0000,   /* U+4A9F */
  0x0000,   /* U+4AA0 */
  0x0000,   /* U+4AA1 */
  0x0000,   /* U+4AA2 */
  0x0000,   /* U+4AA3 */
  0x0000,   /* U+4AA4 */
  0x0000,   /* U+4AA5 */
  0x0000,   /* U+4AA6 */
  0x0000,   /* U+4AA7 */
  0x0000,   /* U+4AA8 */
  0x0000,   /* U+4AA9 */
  0x0000,   /* U+4AAA */
  0x0000,   /* U+4AAB */
  0x0000,   /* U+4AAC */
  0x0000,   /* U+4AAD */
  0x0000,   /* U+4AAE */
  0x0000,   /* U+4AAF */
  0x0000,   /* U+4AB0 */
  0x0000,   /* U+4AB1 */
  0x0000,   /* U+4AB2 */
  0x0000,   /* U+4AB3 */
  0x0000,   /* U+4AB4 */
  0x0000,   /* U+4AB5 */
  0x0000,   /* U+4AB6 */
  0x0000,   /* U+4AB7 */
  0x0000,   /* U+4AB8 */
  0x0000,   /* U+4AB9 */
  0x0000,   /* U+4ABA */
  0x0000,   /* U+4ABB */
  0x0000,   /* U+4ABC */
  0x0000,   /* U+4ABD */
  0x0000,   /* U+4ABE */
  0x0000,   /* U+4ABF */
  0x0000,   /* U+4AC0 */
  0x0000,   /* U+4AC1 */
  0x0000,   /* U+4AC2 */
  0x0000,   /* U+4AC3 */
  0x0000,   /* U+4AC4 */
  0x0000,   /* U+4AC5 */
  0x0000,   /* U+4AC6 */
  0x0000,   /* U+4AC7 */
  0x0000,   /* U+4AC8 */
  0x0000,   /* U+4AC9 */
  0x0000,   /* U+4ACA */
  0x0000,   /* U+4ACB */
  0x0000,   /* U+4ACC */
  0x0000,   /* U+4ACD */
  0x0000,   /* U+4ACE */
  0x0000,   /* U+4ACF */
  0x0000,   /* U+4AD0 */
  0x0000,   /* U+4AD1 */
  0x0000,   /* U+4AD2 */
  0x0000,   /* U+4AD3 */
  0x0000,   /* U+4AD4 */
  0x0000,   /* U+4AD5 */
  0x0000,   /* U+4AD6 */
  0x0000,   /* U+4AD7 */
  0x0000,   /* U+4AD8 */
  0x0000,   /* U+4AD9 */
  0x0000,   /* U+4ADA */
  0x0000,   /* U+4ADB */
  0x0000,   /* U+4ADC */
  0x0000,   /* U+4ADD */
  0x0000,   /* U+4ADE */
  0x0000,   /* U+4ADF */
  0x0000,   /* U+4AE0 */
  0x0000,   /* U+4AE1 */
  0x0000,   /* U+4AE2 */
  0x0000,   /* U+4AE3 */
  0x0000,   /* U+4AE4 */
  0x0000,   /* U+4AE5 */
  0x0000,   /* U+4AE6 */
  0x0000,   /* U+4AE7 */
  0x0000,   /* U+4AE8 */
  0x0000,   /* U+4AE9 */
  0x0000,   /* U+4AEA */
  0x0000,   /* U+4AEB */
  0x0000,   /* U+4AEC */
  0x0000,   /* U+4AED */
  0x0000,   /* U+4AEE */
  0x0000,   /* U+4AEF */
  0x0000,   /* U+4AF0 */
  0x0000,   /* U+4AF1 */
  0x0000,   /* U+4AF2 */
  0x0000,   /* U+4AF3 */
  0x0000,   /* U+4AF4 */
  0x0000,   /* U+4AF5 */
  0x0000,   /* U+4AF6 */
  0x0000,   /* U+4AF7 */
  0x0000,   /* U+4AF8 */
  0x0000,   /* U+4AF9 */
  0x0000,   /* U+4AFA */
  0x0000,   /* U+4AFB */
  0x0000,   /* U+4AFC */
  0x0000,   /* U+4AFD */
  0x0000,   /* U+4AFE */
  0x0000,   /* U+4AFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4A00 */
  0x0000,   /* U+4A01 */
  0x0000,   /* U+4A02 */
  0x0000,   /* U+4A03 */
  0x0000,   /* U+4A04 */
  0x0000,   /* U+4A05 */
  0x0000,   /* U+4A06 */
  0x0000,   /* U+4A07 */
  0x0000,   /* U+4A08 */
  0x0000,   /* U+4A09 */
  0x0000,   /* U+4A0A */
  0x0000,   /* U+4A0B */
  0x0000,   /* U+4A0C */
  0x0000,   /* U+4A0D */
  0x0000,   /* U+4A0E */
  0x0000,   /* U+4A0F */
  0x0000,   /* U+4A10 */
  0x0000,   /* U+4A11 */
  0x0000,   /* U+4A12 */
  0x0000,   /* U+4A13 */
  0x0000,   /* U+4A14 */
  0x0000,   /* U+4A15 */
  0x0000,   /* U+4A16 */
  0x0000,   /* U+4A17 */
  0x0000,   /* U+4A18 */
  0x0000,   /* U+4A19 */
  0x0000,   /* U+4A1A */
  0x0000,   /* U+4A1B */
  0x0000,   /* U+4A1C */
  0x0000,   /* U+4A1D */
  0x0000,   /* U+4A1E */
  0x0000,   /* U+4A1F */
  0x0000,   /* U+4A20 */
  0x0000,   /* U+4A21 */
  0x0000,   /* U+4A22 */
  0x0000,   /* U+4A23 */
  0x0000,   /* U+4A24 */
  0x0000,   /* U+4A25 */
  0x0000,   /* U+4A26 */
  0x0000,   /* U+4A27 */
  0x0000,   /* U+4A28 */
  0x0000,   /* U+4A29 */
  0x0000,   /* U+4A2A */
  0x0000,   /* U+4A2B */
  0x0000,   /* U+4A2C */
  0x0000,   /* U+4A2D */
  0x0000,   /* U+4A2E */
  0x0000,   /* U+4A2F */
  0x0000,   /* U+4A30 */
  0x0000,   /* U+4A31 */
  0x0000,   /* U+4A32 */
  0x0000,   /* U+4A33 */
  0x0000,   /* U+4A34 */
  0x0000,   /* U+4A35 */
  0x0000,   /* U+4A36 */
  0x0000,   /* U+4A37 */
  0x0000,   /* U+4A38 */
  0x0000,   /* U+4A39 */
  0x0000,   /* U+4A3A */
  0x0000,   /* U+4A3B */
  0x0000,   /* U+4A3C */
  0x0000,   /* U+4A3D */
  0x0000,   /* U+4A3E */
  0x0000,   /* U+4A3F */
  0x0000,   /* U+4A40 */
  0x0000,   /* U+4A41 */
  0x0000,   /* U+4A42 */
  0x0000,   /* U+4A43 */
  0x0000,   /* U+4A44 */
  0x0000,   /* U+4A45 */
  0x0000,   /* U+4A46 */
  0x0000,   /* U+4A47 */
  0x0000,   /* U+4A48 */
  0x0000,   /* U+4A49 */
  0x0000,   /* U+4A4A */
  0x0000,   /* U+4A4B */
  0x0000,   /* U+4A4C */
  0x0000,   /* U+4A4D */
  0x0000,   /* U+4A4E */
  0x0000,   /* U+4A4F */
  0x0000,   /* U+4A50 */
  0x0000,   /* U+4A51 */
  0x0000,   /* U+4A52 */
  0x0000,   /* U+4A53 */
  0x0000,   /* U+4A54 */
  0x0000,   /* U+4A55 */
  0x0000,   /* U+4A56 */
  0x0000,   /* U+4A57 */
  0x0000,   /* U+4A58 */
  0x0000,   /* U+4A59 */
  0x0000,   /* U+4A5A */
  0x0000,   /* U+4A5B */
  0x0000,   /* U+4A5C */
  0x0000,   /* U+4A5D */
  0x0000,   /* U+4A5E */
  0x0000,   /* U+4A5F */
  0x0000,   /* U+4A60 */
  0x0000,   /* U+4A61 */
  0x0000,   /* U+4A62 */
  0x0000,   /* U+4A63 */
  0x0000,   /* U+4A64 */
  0x0000,   /* U+4A65 */
  0x0000,   /* U+4A66 */
  0x0000,   /* U+4A67 */
  0x0000,   /* U+4A68 */
  0x0000,   /* U+4A69 */
  0x0000,   /* U+4A6A */
  0x0000,   /* U+4A6B */
  0x0000,   /* U+4A6C */
  0x0000,   /* U+4A6D */
  0x0000,   /* U+4A6E */
  0x0000,   /* U+4A6F */
  0x0000,   /* U+4A70 */
  0x0000,   /* U+4A71 */
  0x0000,   /* U+4A72 */
  0x0000,   /* U+4A73 */
  0x0000,   /* U+4A74 */
  0x0000,   /* U+4A75 */
  0x0000,   /* U+4A76 */
  0x0000,   /* U+4A77 */
  0x0000,   /* U+4A78 */
  0x0000,   /* U+4A79 */
  0x0000,   /* U+4A7A */
  0x0000,   /* U+4A7B */
  0x0000,   /* U+4A7C */
  0x0000,   /* U+4A7D */
  0x0000,   /* U+4A7E */
  0x0000,   /* U+4A7F */
  0x0000,   /* U+4A80 */
  0x0000,   /* U+4A81 */
  0x0000,   /* U+4A82 */
  0x0000,   /* U+4A83 */
  0x0000,   /* U+4A84 */
  0x0000,   /* U+4A85 */
  0x0000,   /* U+4A86 */
  0x0000,   /* U+4A87 */
  0x0000,   /* U+4A88 */
  0x0000,   /* U+4A89 */
  0x0000,   /* U+4A8A */
  0x0000,   /* U+4A8B */
  0x0000,   /* U+4A8C */
  0x0000,   /* U+4A8D */
  0x0000,   /* U+4A8E */
  0x0000,   /* U+4A8F */
  0x0000,   /* U+4A90 */
  0x0000,   /* U+4A91 */
  0x0000,   /* U+4A92 */
  0x0000,   /* U+4A93 */
  0x0000,   /* U+4A94 */
  0x0000,   /* U+4A95 */
  0x0000,   /* U+4A96 */
  0x0000,   /* U+4A97 */
  0x0000,   /* U+4A98 */
  0x0000,   /* U+4A99 */
  0x0000,   /* U+4A9A */
  0x0000,   /* U+4A9B */
  0x0000,   /* U+4A9C */
  0x0000,   /* U+4A9D */
  0x0000,   /* U+4A9E */
  0x0000,   /* U+4A9F */
  0x0000,   /* U+4AA0 */
  0x0000,   /* U+4AA1 */
  0x0000,   /* U+4AA2 */
  0x0000,   /* U+4AA3 */
  0x0000,   /* U+4AA4 */
  0x0000,   /* U+4AA5 */
  0x0000,   /* U+4AA6 */
  0x0000,   /* U+4AA7 */
  0x0000,   /* U+4AA8 */
  0x0000,   /* U+4AA9 */
  0x0000,   /* U+4AAA */
  0x0000,   /* U+4AAB */
  0x0000,   /* U+4AAC */
  0x0000,   /* U+4AAD */
  0x0000,   /* U+4AAE */
  0x0000,   /* U+4AAF */
  0x0000,   /* U+4AB0 */
  0x0000,   /* U+4AB1 */
  0x0000,   /* U+4AB2 */
  0x0000,   /* U+4AB3 */
  0x0000,   /* U+4AB4 */
  0x0000,   /* U+4AB5 */
  0x0000,   /* U+4AB6 */
  0x0000,   /* U+4AB7 */
  0x0000,   /* U+4AB8 */
  0x0000,   /* U+4AB9 */
  0x0000,   /* U+4ABA */
  0x0000,   /* U+4ABB */
  0x0000,   /* U+4ABC */
  0x0000,   /* U+4ABD */
  0x0000,   /* U+4ABE */
  0x0000,   /* U+4ABF */
  0x0000,   /* U+4AC0 */
  0x0000,   /* U+4AC1 */
  0x0000,   /* U+4AC2 */
  0x0000,   /* U+4AC3 */
  0x0000,   /* U+4AC4 */
  0x0000,   /* U+4AC5 */
  0x0000,   /* U+4AC6 */
  0x0000,   /* U+4AC7 */
  0x0000,   /* U+4AC8 */
  0x0000,   /* U+4AC9 */
  0x0000,   /* U+4ACA */
  0x0000,   /* U+4ACB */
  0x0000,   /* U+4ACC */
  0x0000,   /* U+4ACD */
  0x0000,   /* U+4ACE */
  0x0000,   /* U+4ACF */
  0x0000,   /* U+4AD0 */
  0x0000,   /* U+4AD1 */
  0x0000,   /* U+4AD2 */
  0x0000,   /* U+4AD3 */
  0x0000,   /* U+4AD4 */
  0x0000,   /* U+4AD5 */
  0x0000,   /* U+4AD6 */
  0x0000,   /* U+4AD7 */
  0x0000,   /* U+4AD8 */
  0x0000,   /* U+4AD9 */
  0x0000,   /* U+4ADA */
  0x0000,   /* U+4ADB */
  0x0000,   /* U+4ADC */
  0x0000,   /* U+4ADD */
  0x0000,   /* U+4ADE */
  0x0000,   /* U+4ADF */
  0x0000,   /* U+4AE0 */
  0x0000,   /* U+4AE1 */
  0x0000,   /* U+4AE2 */
  0x0000,   /* U+4AE3 */
  0x0000,   /* U+4AE4 */
  0x0000,   /* U+4AE5 */
  0x0000,   /* U+4AE6 */
  0x0000,   /* U+4AE7 */
  0x0000,   /* U+4AE8 */
  0x0000,   /* U+4AE9 */
  0x0000,   /* U+4AEA */
  0x0000,   /* U+4AEB */
  0x0000,   /* U+4AEC */
  0x0000,   /* U+4AED */
  0x0000,   /* U+4AEE */
  0x0000,   /* U+4AEF */
  0x0000,   /* U+4AF0 */
  0x0000,   /* U+4AF1 */
  0x0000,   /* U+4AF2 */
  0x0000,   /* U+4AF3 */
  0x0000,   /* U+4AF4 */
  0x0000,   /* U+4AF5 */
  0x0000,   /* U+4AF6 */
  0x0000,   /* U+4AF7 */
  0x0000,   /* U+4AF8 */
  0x0000,   /* U+4AF9 */
  0x0000,   /* U+4AFA */
  0x0000,   /* U+4AFB */
  0x0000,   /* U+4AFC */
  0x0000,   /* U+4AFD */
  0x0000,   /* U+4AFE */
  0x0000,   /* U+4AFF */
};

uint16 zh2_han_p04B[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x49D1,   /* U+4B00 */
  0x49D1,   /* U+4B01 */
  0x49D1,   /* U+4B02 */
  0x49D1,   /* U+4B03 */
  0x49D2,   /* U+4B04 */
  0x49D2,   /* U+4B05 */
  0x49D3,   /* U+4B06 */
  0x49D3,   /* U+4B07 */
  0x49D3,   /* U+4B08 */
  0x49D3,   /* U+4B09 */
  0x49D3,   /* U+4B0A */
  0x49D4,   /* U+4B0B */
  0x49D4,   /* U+4B0C */
  0x49D4,   /* U+4B0D */
  0x49D4,   /* U+4B0E */
  0x49D4,   /* U+4B0F */
  0x49D4,   /* U+4B10 */
  0x49D5,   /* U+4B11 */
  0x49D5,   /* U+4B12 */
  0x49D5,   /* U+4B13 */
  0x49D5,   /* U+4B14 */
  0x49D5,   /* U+4B15 */
  0x49D5,   /* U+4B16 */
  0x49D5,   /* U+4B17 */
  0x49CD,   /* U+4B18 */
  0x49CD,   /* U+4B19 */
  0x49CD,   /* U+4B1A */
  0x49D7,   /* U+4B1B */
  0x49D7,   /* U+4B1C */
  0x49D8,   /* U+4B1D */
  0x49DA,   /* U+4B1E */
  0x49DB,   /* U+4B1F */
  0x4A14,   /* U+4B20 */
  0x4A15,   /* U+4B21 */
  0x4A4E,   /* U+4B22 */
  0x4A4F,   /* U+4B23 */
  0x4A4F,   /* U+4B24 */
  0x4A4F,   /* U+4B25 */
  0x4A50,   /* U+4B26 */
  0x4A50,   /* U+4B27 */
  0x4A50,   /* U+4B28 */
  0x4A50,   /* U+4B29 */
  0x4A50,   /* U+4B2A */
  0x4A51,   /* U+4B2B */
  0x4A51,   /* U+4B2C */
  0x4A51,   /* U+4B2D */
  0x4A51,   /* U+4B2E */
  0x4A51,   /* U+4B2F */
  0x4A51,   /* U+4B30 */
  0x4A51,   /* U+4B31 */
  0x4A51,   /* U+4B32 */
  0x4A51,   /* U+4B33 */
  0x4A51,   /* U+4B34 */
  0x4A52,   /* U+4B35 */
  0x4A52,   /* U+4B36 */
  0x4A52,   /* U+4B37 */
  0x4A52,   /* U+4B38 */
  0x4A52,   /* U+4B39 */
  0x4A52,   /* U+4B3A */
  0x4A52,   /* U+4B3B */
  0x4A53,   /* U+4B3C */
  0x4A53,   /* U+4B3D */
  0x4A53,   /* U+4B3E */
  0x4A53,   /* U+4B3F */
  0x4A53,   /* U+4B40 */
  0x4A53,   /* U+4B41 */
  0x4A53,   /* U+4B42 */
  0x4A54,   /* U+4B43 */
  0x4A54,   /* U+4B44 */
  0x4A54,   /* U+4B45 */
  0x4A54,   /* U+4B46 */
  0x4A54,   /* U+4B47 */
  0x4A55,   /* U+4B48 */
  0x4A55,   /* U+4B49 */
  0x4A55,   /* U+4B4A */
  0x4A55,   /* U+4B4B */
  0x4A55,   /* U+4B4C */
  0x4A55,   /* U+4B4D */
  0x4A55,   /* U+4B4E */
  0x5C49,   /* U+4B4F */
  0x4A4D,   /* U+4B50 */
  0x4A4D,   /* U+4B51 */
  0x4A4D,   /* U+4B52 */
  0x4A4D,   /* U+4B53 */
  0x4A4D,   /* U+4B54 */
  0x4A57,   /* U+4B55 */
  0x4A57,   /* U+4B56 */
  0x4A57,   /* U+4B57 */
  0x4A58,   /* U+4B58 */
  0x4A58,   /* U+4B59 */
  0x4A58,   /* U+4B5A */
  0x4A58,   /* U+4B5B */
  0x5C49,   /* U+4B5C */
  0x4A59,   /* U+4B5D */
  0x4A59,   /* U+4B5E */
  0x4A59,   /* U+4B5F */
  0x4A59,   /* U+4B60 */
  0x4A5A,   /* U+4B61 */
  0x4A5A,   /* U+4B62 */
  0x4A5A,   /* U+4B63 */
  0x4A5A,   /* U+4B64 */
  0x4A5B,   /* U+4B65 */
  0x4A5D,   /* U+4B66 */
  0x4A5D,   /* U+4B67 */
  0x4A5E,   /* U+4B68 */
  0x4A5F,   /* U+4B69 */
  0x4A58,   /* U+4B6A */
  0x4A92,   /* U+4B6B */
  0x4A92,   /* U+4B6C */
  0x4A95,   /* U+4B6D */
  0x4A8D,   /* U+4B6E */
  0x4AD1,   /* U+4B6F */
  0x4AD4,   /* U+4B70 */
  0x4AD4,   /* U+4B71 */
  0x4AD4,   /* U+4B72 */
  0x4ADE,   /* U+4B73 */
  0x4B0E,   /* U+4B74 */
  0x4B0F,   /* U+4B75 */
  0x4B0F,   /* U+4B76 */
  0x4B10,   /* U+4B77 */
  0x4B10,   /* U+4B78 */
  0x4B10,   /* U+4B79 */
  0x4B10,   /* U+4B7A */
  0x4B10,   /* U+4B7B */
  0x4B10,   /* U+4B7C */
  0x4B10,   /* U+4B7D */
  0x4B10,   /* U+4B7E */
  0x4B11,   /* U+4B7F */
  0x4B11,   /* U+4B80 */
  0x4B11,   /* U+4B81 */
  0x4B11,   /* U+4B82 */
  0x4B11,   /* U+4B83 */
  0x4B11,   /* U+4B84 */
  0x4B11,   /* U+4B85 */
  0x4B12,   /* U+4B86 */
  0x4B12,   /* U+4B87 */
  0x4B12,   /* U+4B88 */
  0x4B12,   /* U+4B89 */
  0x4B12,   /* U+4B8A */
  0x4B12,   /* U+4B8B */
  0x4B12,   /* U+4B8C */
  0x5C49,   /* U+4B8D */
  0x4B13,   /* U+4B8E */
  0x4B13,   /* U+4B8F */
  0x4B13,   /* U+4B90 */
  0x4B13,   /* U+4B91 */
  0x4B13,   /* U+4B92 */
  0x4B14,   /* U+4B93 */
  0x4B14,   /* U+4B94 */
  0x4B14,   /* U+4B95 */
  0x4B14,   /* U+4B96 */
  0x4B14,   /* U+4B97 */
  0x4B14,   /* U+4B98 */
  0x4B14,   /* U+4B99 */
  0x4B14,   /* U+4B9A */
  0x4B14,   /* U+4B9B */
  0x4B15,   /* U+4B9C */
  0x4B15,   /* U+4B9D */
  0x4B15,   /* U+4B9E */
  0x4B15,   /* U+4B9F */
  0x4B15,   /* U+4BA0 */
  0x4B15,   /* U+4BA1 */
  0x4B15,   /* U+4BA2 */
  0x4B0D,   /* U+4BA3 */
  0x4B0D,   /* U+4BA4 */
  0x4B0D,   /* U+4BA5 */
  0x4B0D,   /* U+4BA6 */
  0x4B0D,   /* U+4BA7 */
  0x4B0D,   /* U+4BA8 */
  0x4B0D,   /* U+4BA9 */
  0x4B17,   /* U+4BAA */
  0x4B17,   /* U+4BAB */
  0x4B17,   /* U+4BAC */
  0x4B17,   /* U+4BAD */
  0x4B17,   /* U+4BAE */
  0x4B17,   /* U+4BAF */
  0x4B17,   /* U+4BB0 */
  0x4B17,   /* U+4BB1 */
  0x4B18,   /* U+4BB2 */
  0x4B18,   /* U+4BB3 */
  0x4B18,   /* U+4BB4 */
  0x4B18,   /* U+4BB5 */
  0x4B18,   /* U+4BB6 */
  0x4B19,   /* U+4BB7 */
  0x4B19,   /* U+4BB8 */
  0x4B19,   /* U+4BB9 */
  0x4B1A,   /* U+4BBA */
  0x4B1A,   /* U+4BBB */
  0x4B1A,   /* U+4BBC */
  0x4B1B,   /* U+4BBD */
  0x4B1C,   /* U+4BBE */
  0x4B1D,   /* U+4BBF */
  0x4B1E,   /* U+4BC0 */
  0x4B1F,   /* U+4BC1 */
  0x4B24,   /* U+4BC2 */
  0x4B12,   /* U+4BC3 */
  0x4B13,   /* U+4BC4 */
  0x4B16,   /* U+4BC5 */
  0x4B4D,   /* U+4BC6 */
  0x4B4E,   /* U+4BC7 */
  0x4B50,   /* U+4BC8 */
  0x4B50,   /* U+4BC9 */
  0x4B51,   /* U+4BCA */
  0x4B51,   /* U+4BCB */
  0x4B51,   /* U+4BCC */
  0x4B51,   /* U+4BCD */
  0x4B51,   /* U+4BCE */
  0x4B52,   /* U+4BCF */
  0x4B52,   /* U+4BD0 */
  0x4B52,   /* U+4BD1 */
  0x4B52,   /* U+4BD2 */
  0x4B52,   /* U+4BD3 */
  0x4B52,   /* U+4BD4 */
  0x4B53,   /* U+4BD5 */
  0x4B53,   /* U+4BD6 */
  0x4B53,   /* U+4BD7 */
  0x4B53,   /* U+4BD8 */
  0x4B53,   /* U+4BD9 */
  0x4B53,   /* U+4BDA */
  0x4B54,   /* U+4BDB */
  0x4B54,   /* U+4BDC */
  0x4B55,   /* U+4BDD */
  0x4B55,   /* U+4BDE */
  0x4B55,   /* U+4BDF */
  0x4B55,   /* U+4BE0 */
  0x4B4D,   /* U+4BE1 */
  0x4B57,   /* U+4BE2 */
  0x4B58,   /* U+4BE3 */
  0x4B59,   /* U+4BE4 */
  0x4B5A,   /* U+4BE5 */
  0x4B5B,   /* U+4BE6 */
  0x4B8E,   /* U+4BE7 */
  0x4B8F,   /* U+4BE8 */
  0x5C49,   /* U+4BE9 */
  0x4B95,   /* U+4BEA */
  0x4B98,   /* U+4BEB */
  0x4B9B,   /* U+4BEC */
  0x4BCE,   /* U+4BED */
  0x4BCE,   /* U+4BEE */
  0x4BD0,   /* U+4BEF */
  0x4BD0,   /* U+4BF0 */
  0x4BD0,   /* U+4BF1 */
  0x4BD0,   /* U+4BF2 */
  0x4BD0,   /* U+4BF3 */
  0x4BD0,   /* U+4BF4 */
  0x4BD1,   /* U+4BF5 */
  0x4BD1,   /* U+4BF6 */
  0x4BD2,   /* U+4BF7 */
  0x4BD2,   /* U+4BF8 */
  0x4BD3,   /* U+4BF9 */
  0x4BD3,   /* U+4BFA */
  0x5C49,   /* U+4BFB */
  0x4BD3,   /* U+4BFC */
  0x4BD4,   /* U+4BFD */
  0x4BD4,   /* U+4BFE */
  0x4BD4,   /* U+4BFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4B00 */
  0x0020,   /* U+4B01 */
  0x0020,   /* U+4B02 */
  0x0020,   /* U+4B03 */
  0x0020,   /* U+4B04 */
  0x0020,   /* U+4B05 */
  0x0020,   /* U+4B06 */
  0x0020,   /* U+4B07 */
  0x0020,   /* U+4B08 */
  0x0020,   /* U+4B09 */
  0x0020,   /* U+4B0A */
  0x0020,   /* U+4B0B */
  0x0020,   /* U+4B0C */
  0x0020,   /* U+4B0D */
  0x0020,   /* U+4B0E */
  0x0020,   /* U+4B0F */
  0x0020,   /* U+4B10 */
  0x0020,   /* U+4B11 */
  0x0020,   /* U+4B12 */
  0x0020,   /* U+4B13 */
  0x0020,   /* U+4B14 */
  0x0020,   /* U+4B15 */
  0x0020,   /* U+4B16 */
  0x0020,   /* U+4B17 */
  0x0020,   /* U+4B18 */
  0x0020,   /* U+4B19 */
  0x0020,   /* U+4B1A */
  0x0020,   /* U+4B1B */
  0x0020,   /* U+4B1C */
  0x0020,   /* U+4B1D */
  0x0020,   /* U+4B1E */
  0x0020,   /* U+4B1F */
  0x0020,   /* U+4B20 */
  0x0020,   /* U+4B21 */
  0x0020,   /* U+4B22 */
  0x0020,   /* U+4B23 */
  0x0020,   /* U+4B24 */
  0x0020,   /* U+4B25 */
  0x0020,   /* U+4B26 */
  0x0020,   /* U+4B27 */
  0x0020,   /* U+4B28 */
  0x0020,   /* U+4B29 */
  0x0020,   /* U+4B2A */
  0x0020,   /* U+4B2B */
  0x0020,   /* U+4B2C */
  0x0020,   /* U+4B2D */
  0x0020,   /* U+4B2E */
  0x0020,   /* U+4B2F */
  0x0020,   /* U+4B30 */
  0x0020,   /* U+4B31 */
  0x0020,   /* U+4B32 */
  0x0020,   /* U+4B33 */
  0x0020,   /* U+4B34 */
  0x0020,   /* U+4B35 */
  0x0020,   /* U+4B36 */
  0x0020,   /* U+4B37 */
  0x0020,   /* U+4B38 */
  0x0020,   /* U+4B39 */
  0x0020,   /* U+4B3A */
  0x0020,   /* U+4B3B */
  0x0020,   /* U+4B3C */
  0x0020,   /* U+4B3D */
  0x0020,   /* U+4B3E */
  0x0020,   /* U+4B3F */
  0x0020,   /* U+4B40 */
  0x0020,   /* U+4B41 */
  0x0020,   /* U+4B42 */
  0x0020,   /* U+4B43 */
  0x0020,   /* U+4B44 */
  0x0020,   /* U+4B45 */
  0x0020,   /* U+4B46 */
  0x0020,   /* U+4B47 */
  0x0020,   /* U+4B48 */
  0x0020,   /* U+4B49 */
  0x0020,   /* U+4B4A */
  0x0020,   /* U+4B4B */
  0x0020,   /* U+4B4C */
  0x0020,   /* U+4B4D */
  0x0020,   /* U+4B4E */
  0x0020,   /* U+4B4F */
  0x0020,   /* U+4B50 */
  0x0020,   /* U+4B51 */
  0x0020,   /* U+4B52 */
  0x0020,   /* U+4B53 */
  0x0020,   /* U+4B54 */
  0x0020,   /* U+4B55 */
  0x0020,   /* U+4B56 */
  0x0020,   /* U+4B57 */
  0x0020,   /* U+4B58 */
  0x0020,   /* U+4B59 */
  0x0020,   /* U+4B5A */
  0x0020,   /* U+4B5B */
  0x0020,   /* U+4B5C */
  0x0020,   /* U+4B5D */
  0x0020,   /* U+4B5E */
  0x0020,   /* U+4B5F */
  0x0020,   /* U+4B60 */
  0x0020,   /* U+4B61 */
  0x0020,   /* U+4B62 */
  0x0020,   /* U+4B63 */
  0x0020,   /* U+4B64 */
  0x0020,   /* U+4B65 */
  0x0020,   /* U+4B66 */
  0x0020,   /* U+4B67 */
  0x0020,   /* U+4B68 */
  0x0020,   /* U+4B69 */
  0x0020,   /* U+4B6A */
  0x0020,   /* U+4B6B */
  0x0020,   /* U+4B6C */
  0x0020,   /* U+4B6D */
  0x0020,   /* U+4B6E */
  0x0020,   /* U+4B6F */
  0x0020,   /* U+4B70 */
  0x0020,   /* U+4B71 */
  0x0020,   /* U+4B72 */
  0x0020,   /* U+4B73 */
  0x0020,   /* U+4B74 */
  0x0020,   /* U+4B75 */
  0x0020,   /* U+4B76 */
  0x0020,   /* U+4B77 */
  0x0020,   /* U+4B78 */
  0x0020,   /* U+4B79 */
  0x0020,   /* U+4B7A */
  0x0020,   /* U+4B7B */
  0x0020,   /* U+4B7C */
  0x0020,   /* U+4B7D */
  0x0020,   /* U+4B7E */
  0x0020,   /* U+4B7F */
  0x0020,   /* U+4B80 */
  0x0020,   /* U+4B81 */
  0x0020,   /* U+4B82 */
  0x0020,   /* U+4B83 */
  0x0020,   /* U+4B84 */
  0x0020,   /* U+4B85 */
  0x0020,   /* U+4B86 */
  0x0020,   /* U+4B87 */
  0x0020,   /* U+4B88 */
  0x0020,   /* U+4B89 */
  0x0020,   /* U+4B8A */
  0x0020,   /* U+4B8B */
  0x0020,   /* U+4B8C */
  0x0020,   /* U+4B8D */
  0x0020,   /* U+4B8E */
  0x0020,   /* U+4B8F */
  0x0020,   /* U+4B90 */
  0x0020,   /* U+4B91 */
  0x0020,   /* U+4B92 */
  0x0020,   /* U+4B93 */
  0x0020,   /* U+4B94 */
  0x0020,   /* U+4B95 */
  0x0020,   /* U+4B96 */
  0x0020,   /* U+4B97 */
  0x0020,   /* U+4B98 */
  0x0020,   /* U+4B99 */
  0x0020,   /* U+4B9A */
  0x0020,   /* U+4B9B */
  0x0020,   /* U+4B9C */
  0x0020,   /* U+4B9D */
  0x0020,   /* U+4B9E */
  0x0020,   /* U+4B9F */
  0x0020,   /* U+4BA0 */
  0x0020,   /* U+4BA1 */
  0x0020,   /* U+4BA2 */
  0x0020,   /* U+4BA3 */
  0x0020,   /* U+4BA4 */
  0x0020,   /* U+4BA5 */
  0x0020,   /* U+4BA6 */
  0x0020,   /* U+4BA7 */
  0x0020,   /* U+4BA8 */
  0x0020,   /* U+4BA9 */
  0x0020,   /* U+4BAA */
  0x0020,   /* U+4BAB */
  0x0020,   /* U+4BAC */
  0x0020,   /* U+4BAD */
  0x0020,   /* U+4BAE */
  0x0020,   /* U+4BAF */
  0x0020,   /* U+4BB0 */
  0x0020,   /* U+4BB1 */
  0x0020,   /* U+4BB2 */
  0x0020,   /* U+4BB3 */
  0x0020,   /* U+4BB4 */
  0x0020,   /* U+4BB5 */
  0x0020,   /* U+4BB6 */
  0x0020,   /* U+4BB7 */
  0x0020,   /* U+4BB8 */
  0x0020,   /* U+4BB9 */
  0x0020,   /* U+4BBA */
  0x0020,   /* U+4BBB */
  0x0020,   /* U+4BBC */
  0x0020,   /* U+4BBD */
  0x0020,   /* U+4BBE */
  0x0020,   /* U+4BBF */
  0x0020,   /* U+4BC0 */
  0x0020,   /* U+4BC1 */
  0x0020,   /* U+4BC2 */
  0x0020,   /* U+4BC3 */
  0x0020,   /* U+4BC4 */
  0x0020,   /* U+4BC5 */
  0x0020,   /* U+4BC6 */
  0x0020,   /* U+4BC7 */
  0x0020,   /* U+4BC8 */
  0x0020,   /* U+4BC9 */
  0x0020,   /* U+4BCA */
  0x0020,   /* U+4BCB */
  0x0020,   /* U+4BCC */
  0x0020,   /* U+4BCD */
  0x0020,   /* U+4BCE */
  0x0020,   /* U+4BCF */
  0x0020,   /* U+4BD0 */
  0x0020,   /* U+4BD1 */
  0x0020,   /* U+4BD2 */
  0x0020,   /* U+4BD3 */
  0x0020,   /* U+4BD4 */
  0x0020,   /* U+4BD5 */
  0x0020,   /* U+4BD6 */
  0x0020,   /* U+4BD7 */
  0x0020,   /* U+4BD8 */
  0x0020,   /* U+4BD9 */
  0x0020,   /* U+4BDA */
  0x0020,   /* U+4BDB */
  0x0020,   /* U+4BDC */
  0x0020,   /* U+4BDD */
  0x0020,   /* U+4BDE */
  0x0020,   /* U+4BDF */
  0x0020,   /* U+4BE0 */
  0x0020,   /* U+4BE1 */
  0x0020,   /* U+4BE2 */
  0x0020,   /* U+4BE3 */
  0x0020,   /* U+4BE4 */
  0x0020,   /* U+4BE5 */
  0x0020,   /* U+4BE6 */
  0x0020,   /* U+4BE7 */
  0x0020,   /* U+4BE8 */
  0x0020,   /* U+4BE9 */
  0x0020,   /* U+4BEA */
  0x0020,   /* U+4BEB */
  0x0020,   /* U+4BEC */
  0x0020,   /* U+4BED */
  0x0020,   /* U+4BEE */
  0x0020,   /* U+4BEF */
  0x0020,   /* U+4BF0 */
  0x0020,   /* U+4BF1 */
  0x0020,   /* U+4BF2 */
  0x0020,   /* U+4BF3 */
  0x0020,   /* U+4BF4 */
  0x0020,   /* U+4BF5 */
  0x0020,   /* U+4BF6 */
  0x0020,   /* U+4BF7 */
  0x0020,   /* U+4BF8 */
  0x0020,   /* U+4BF9 */
  0x0020,   /* U+4BFA */
  0x0020,   /* U+4BFB */
  0x0020,   /* U+4BFC */
  0x0020,   /* U+4BFD */
  0x0020,   /* U+4BFE */
  0x0020,   /* U+4BFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4B00 */
  0x0002,   /* U+4B01 */
  0x0002,   /* U+4B02 */
  0x0002,   /* U+4B03 */
  0x0002,   /* U+4B04 */
  0x0002,   /* U+4B05 */
  0x0002,   /* U+4B06 */
  0x0002,   /* U+4B07 */
  0x0002,   /* U+4B08 */
  0x0002,   /* U+4B09 */
  0x0002,   /* U+4B0A */
  0x0002,   /* U+4B0B */
  0x0002,   /* U+4B0C */
  0x0002,   /* U+4B0D */
  0x0002,   /* U+4B0E */
  0x0002,   /* U+4B0F */
  0x0002,   /* U+4B10 */
  0x0002,   /* U+4B11 */
  0x0002,   /* U+4B12 */
  0x0002,   /* U+4B13 */
  0x0002,   /* U+4B14 */
  0x0002,   /* U+4B15 */
  0x0002,   /* U+4B16 */
  0x0002,   /* U+4B17 */
  0x0002,   /* U+4B18 */
  0x0002,   /* U+4B19 */
  0x0002,   /* U+4B1A */
  0x0002,   /* U+4B1B */
  0x0002,   /* U+4B1C */
  0x0002,   /* U+4B1D */
  0x0002,   /* U+4B1E */
  0x0002,   /* U+4B1F */
  0x0002,   /* U+4B20 */
  0x0002,   /* U+4B21 */
  0x0002,   /* U+4B22 */
  0x0002,   /* U+4B23 */
  0x0002,   /* U+4B24 */
  0x0002,   /* U+4B25 */
  0x0002,   /* U+4B26 */
  0x0002,   /* U+4B27 */
  0x0002,   /* U+4B28 */
  0x0002,   /* U+4B29 */
  0x0002,   /* U+4B2A */
  0x0002,   /* U+4B2B */
  0x0002,   /* U+4B2C */
  0x0002,   /* U+4B2D */
  0x0002,   /* U+4B2E */
  0x0002,   /* U+4B2F */
  0x0002,   /* U+4B30 */
  0x0002,   /* U+4B31 */
  0x0002,   /* U+4B32 */
  0x0002,   /* U+4B33 */
  0x0002,   /* U+4B34 */
  0x0002,   /* U+4B35 */
  0x0002,   /* U+4B36 */
  0x0002,   /* U+4B37 */
  0x0002,   /* U+4B38 */
  0x0002,   /* U+4B39 */
  0x0002,   /* U+4B3A */
  0x0002,   /* U+4B3B */
  0x0002,   /* U+4B3C */
  0x0002,   /* U+4B3D */
  0x0002,   /* U+4B3E */
  0x0002,   /* U+4B3F */
  0x0002,   /* U+4B40 */
  0x0002,   /* U+4B41 */
  0x0002,   /* U+4B42 */
  0x0002,   /* U+4B43 */
  0x0002,   /* U+4B44 */
  0x0002,   /* U+4B45 */
  0x0002,   /* U+4B46 */
  0x0002,   /* U+4B47 */
  0x0002,   /* U+4B48 */
  0x0002,   /* U+4B49 */
  0x0002,   /* U+4B4A */
  0x0002,   /* U+4B4B */
  0x0002,   /* U+4B4C */
  0x0002,   /* U+4B4D */
  0x0002,   /* U+4B4E */
  0x0002,   /* U+4B4F */
  0x0002,   /* U+4B50 */
  0x0002,   /* U+4B51 */
  0x0002,   /* U+4B52 */
  0x0002,   /* U+4B53 */
  0x0002,   /* U+4B54 */
  0x0002,   /* U+4B55 */
  0x0002,   /* U+4B56 */
  0x0002,   /* U+4B57 */
  0x0002,   /* U+4B58 */
  0x0002,   /* U+4B59 */
  0x0002,   /* U+4B5A */
  0x0002,   /* U+4B5B */
  0x0002,   /* U+4B5C */
  0x0002,   /* U+4B5D */
  0x0002,   /* U+4B5E */
  0x0002,   /* U+4B5F */
  0x0002,   /* U+4B60 */
  0x0002,   /* U+4B61 */
  0x0002,   /* U+4B62 */
  0x0002,   /* U+4B63 */
  0x0002,   /* U+4B64 */
  0x0002,   /* U+4B65 */
  0x0002,   /* U+4B66 */
  0x0002,   /* U+4B67 */
  0x0002,   /* U+4B68 */
  0x0002,   /* U+4B69 */
  0x0002,   /* U+4B6A */
  0x0002,   /* U+4B6B */
  0x0002,   /* U+4B6C */
  0x0002,   /* U+4B6D */
  0x0002,   /* U+4B6E */
  0x0002,   /* U+4B6F */
  0x0002,   /* U+4B70 */
  0x0002,   /* U+4B71 */
  0x0002,   /* U+4B72 */
  0x0002,   /* U+4B73 */
  0x0002,   /* U+4B74 */
  0x0002,   /* U+4B75 */
  0x0002,   /* U+4B76 */
  0x0002,   /* U+4B77 */
  0x0002,   /* U+4B78 */
  0x0002,   /* U+4B79 */
  0x0002,   /* U+4B7A */
  0x0002,   /* U+4B7B */
  0x0002,   /* U+4B7C */
  0x0002,   /* U+4B7D */
  0x0002,   /* U+4B7E */
  0x0002,   /* U+4B7F */
  0x0002,   /* U+4B80 */
  0x0002,   /* U+4B81 */
  0x0002,   /* U+4B82 */
  0x0002,   /* U+4B83 */
  0x0002,   /* U+4B84 */
  0x0002,   /* U+4B85 */
  0x0002,   /* U+4B86 */
  0x0002,   /* U+4B87 */
  0x0002,   /* U+4B88 */
  0x0002,   /* U+4B89 */
  0x0002,   /* U+4B8A */
  0x0002,   /* U+4B8B */
  0x0002,   /* U+4B8C */
  0x0002,   /* U+4B8D */
  0x0002,   /* U+4B8E */
  0x0002,   /* U+4B8F */
  0x0002,   /* U+4B90 */
  0x0002,   /* U+4B91 */
  0x0002,   /* U+4B92 */
  0x0002,   /* U+4B93 */
  0x0002,   /* U+4B94 */
  0x0002,   /* U+4B95 */
  0x0002,   /* U+4B96 */
  0x0002,   /* U+4B97 */
  0x0002,   /* U+4B98 */
  0x0002,   /* U+4B99 */
  0x0002,   /* U+4B9A */
  0x0002,   /* U+4B9B */
  0x0002,   /* U+4B9C */
  0x0002,   /* U+4B9D */
  0x0002,   /* U+4B9E */
  0x0002,   /* U+4B9F */
  0x0002,   /* U+4BA0 */
  0x0002,   /* U+4BA1 */
  0x0002,   /* U+4BA2 */
  0x0002,   /* U+4BA3 */
  0x0002,   /* U+4BA4 */
  0x0002,   /* U+4BA5 */
  0x0002,   /* U+4BA6 */
  0x0002,   /* U+4BA7 */
  0x0002,   /* U+4BA8 */
  0x0002,   /* U+4BA9 */
  0x0002,   /* U+4BAA */
  0x0002,   /* U+4BAB */
  0x0002,   /* U+4BAC */
  0x0002,   /* U+4BAD */
  0x0002,   /* U+4BAE */
  0x0002,   /* U+4BAF */
  0x0002,   /* U+4BB0 */
  0x0002,   /* U+4BB1 */
  0x0002,   /* U+4BB2 */
  0x0002,   /* U+4BB3 */
  0x0002,   /* U+4BB4 */
  0x0002,   /* U+4BB5 */
  0x0002,   /* U+4BB6 */
  0x0002,   /* U+4BB7 */
  0x0002,   /* U+4BB8 */
  0x0002,   /* U+4BB9 */
  0x0002,   /* U+4BBA */
  0x0002,   /* U+4BBB */
  0x0002,   /* U+4BBC */
  0x0002,   /* U+4BBD */
  0x0002,   /* U+4BBE */
  0x0002,   /* U+4BBF */
  0x0002,   /* U+4BC0 */
  0x0002,   /* U+4BC1 */
  0x0002,   /* U+4BC2 */
  0x0002,   /* U+4BC3 */
  0x0002,   /* U+4BC4 */
  0x0002,   /* U+4BC5 */
  0x0002,   /* U+4BC6 */
  0x0002,   /* U+4BC7 */
  0x0002,   /* U+4BC8 */
  0x0002,   /* U+4BC9 */
  0x0002,   /* U+4BCA */
  0x0002,   /* U+4BCB */
  0x0002,   /* U+4BCC */
  0x0002,   /* U+4BCD */
  0x0002,   /* U+4BCE */
  0x0002,   /* U+4BCF */
  0x0002,   /* U+4BD0 */
  0x0002,   /* U+4BD1 */
  0x0002,   /* U+4BD2 */
  0x0002,   /* U+4BD3 */
  0x0002,   /* U+4BD4 */
  0x0002,   /* U+4BD5 */
  0x0002,   /* U+4BD6 */
  0x0002,   /* U+4BD7 */
  0x0002,   /* U+4BD8 */
  0x0002,   /* U+4BD9 */
  0x0002,   /* U+4BDA */
  0x0002,   /* U+4BDB */
  0x0002,   /* U+4BDC */
  0x0002,   /* U+4BDD */
  0x0002,   /* U+4BDE */
  0x0002,   /* U+4BDF */
  0x0002,   /* U+4BE0 */
  0x0002,   /* U+4BE1 */
  0x0002,   /* U+4BE2 */
  0x0002,   /* U+4BE3 */
  0x0002,   /* U+4BE4 */
  0x0002,   /* U+4BE5 */
  0x0002,   /* U+4BE6 */
  0x0002,   /* U+4BE7 */
  0x0002,   /* U+4BE8 */
  0x0002,   /* U+4BE9 */
  0x0002,   /* U+4BEA */
  0x0002,   /* U+4BEB */
  0x0002,   /* U+4BEC */
  0x0002,   /* U+4BED */
  0x0002,   /* U+4BEE */
  0x0002,   /* U+4BEF */
  0x0002,   /* U+4BF0 */
  0x0002,   /* U+4BF1 */
  0x0002,   /* U+4BF2 */
  0x0002,   /* U+4BF3 */
  0x0002,   /* U+4BF4 */
  0x0002,   /* U+4BF5 */
  0x0002,   /* U+4BF6 */
  0x0002,   /* U+4BF7 */
  0x0002,   /* U+4BF8 */
  0x0002,   /* U+4BF9 */
  0x0002,   /* U+4BFA */
  0x0002,   /* U+4BFB */
  0x0002,   /* U+4BFC */
  0x0002,   /* U+4BFD */
  0x0002,   /* U+4BFE */
  0x0002,   /* U+4BFF */

  /* Primary weight 2 for each character. */
  0x800A,   /* U+4B00 */
  0x800B,   /* U+4B01 */
  0x800C,   /* U+4B02 */
  0x800D,   /* U+4B03 */
  0x8001,   /* U+4B04 */
  0x8002,   /* U+4B05 */
  0x8003,   /* U+4B06 */
  0x8004,   /* U+4B07 */
  0x8005,   /* U+4B08 */
  0x8006,   /* U+4B09 */
  0x8007,   /* U+4B0A */
  0x8009,   /* U+4B0B */
  0x800A,   /* U+4B0C */
  0x800B,   /* U+4B0D */
  0x800C,   /* U+4B0E */
  0x800D,   /* U+4B0F */
  0x800E,   /* U+4B10 */
  0x8005,   /* U+4B11 */
  0x8006,   /* U+4B12 */
  0x8007,   /* U+4B13 */
  0x8008,   /* U+4B14 */
  0x8009,   /* U+4B15 */
  0x800A,   /* U+4B16 */
  0x800B,   /* U+4B17 */
  0x8000,   /* U+4B18 */
  0x8001,   /* U+4B19 */
  0x8002,   /* U+4B1A */
  0x8002,   /* U+4B1B */
  0x8003,   /* U+4B1C */
  0x8005,   /* U+4B1D */
  0x8000,   /* U+4B1E */
  0x8000,   /* U+4B1F */
  0x8000,   /* U+4B20 */
  0x8000,   /* U+4B21 */
  0x8004,   /* U+4B22 */
  0x8005,   /* U+4B23 */
  0x8006,   /* U+4B24 */
  0x8007,   /* U+4B25 */
  0x800E,   /* U+4B26 */
  0x800F,   /* U+4B27 */
  0x8010,   /* U+4B28 */
  0x8011,   /* U+4B29 */
  0x8012,   /* U+4B2A */
  0x8015,   /* U+4B2B */
  0x8016,   /* U+4B2C */
  0x8017,   /* U+4B2D */
  0x8018,   /* U+4B2E */
  0x8019,   /* U+4B2F */
  0x801A,   /* U+4B30 */
  0x801B,   /* U+4B31 */
  0x801C,   /* U+4B32 */
  0x801D,   /* U+4B33 */
  0x801E,   /* U+4B34 */
  0x8012,   /* U+4B35 */
  0x8013,   /* U+4B36 */
  0x8014,   /* U+4B37 */
  0x8015,   /* U+4B38 */
  0x8016,   /* U+4B39 */
  0x8017,   /* U+4B3A */
  0x8018,   /* U+4B3B */
  0x8010,   /* U+4B3C */
  0x8011,   /* U+4B3D */
  0x8012,   /* U+4B3E */
  0x8013,   /* U+4B3F */
  0x8014,   /* U+4B40 */
  0x8015,   /* U+4B41 */
  0x8016,   /* U+4B42 */
  0x8010,   /* U+4B43 */
  0x8011,   /* U+4B44 */
  0x8012,   /* U+4B45 */
  0x8013,   /* U+4B46 */
  0x8014,   /* U+4B47 */
  0x8011,   /* U+4B48 */
  0x8012,   /* U+4B49 */
  0x8013,   /* U+4B4A */
  0x8014,   /* U+4B4B */
  0x8015,   /* U+4B4C */
  0x8016,   /* U+4B4D */
  0x8017,   /* U+4B4E */
  0xCB4F,   /* U+4B4F */
  0x8000,   /* U+4B50 */
  0x8001,   /* U+4B51 */
  0x8002,   /* U+4B52 */
  0x8003,   /* U+4B53 */
  0x8004,   /* U+4B54 */
  0x8007,   /* U+4B55 */
  0x8008,   /* U+4B56 */
  0x8009,   /* U+4B57 */
  0x8009,   /* U+4B58 */
  0x800A,   /* U+4B59 */
  0x800B,   /* U+4B5A */
  0x800C,   /* U+4B5B */
  0xCB5C,   /* U+4B5C */
  0x8002,   /* U+4B5D */
  0x8003,   /* U+4B5E */
  0x8004,   /* U+4B5F */
  0x8005,   /* U+4B60 */
  0x8002,   /* U+4B61 */
  0x8003,   /* U+4B62 */
  0x8004,   /* U+4B63 */
  0x8005,   /* U+4B64 */
  0x8000,   /* U+4B65 */
  0x8001,   /* U+4B66 */
  0x8002,   /* U+4B67 */
  0x8000,   /* U+4B68 */
  0x8000,   /* U+4B69 */
  0x8000,   /* U+4B6A */
  0x8000,   /* U+4B6B */
  0x8001,   /* U+4B6C */
  0x8000,   /* U+4B6D */
  0x8000,   /* U+4B6E */
  0x8000,   /* U+4B6F */
  0x8000,   /* U+4B70 */
  0x8001,   /* U+4B71 */
  0x8002,   /* U+4B72 */
  0x8000,   /* U+4B73 */
  0x8001,   /* U+4B74 */
  0x8004,   /* U+4B75 */
  0x8005,   /* U+4B76 */
  0x8008,   /* U+4B77 */
  0x8009,   /* U+4B78 */
  0x800A,   /* U+4B79 */
  0x800B,   /* U+4B7A */
  0x800C,   /* U+4B7B */
  0x800D,   /* U+4B7C */
  0x800E,   /* U+4B7D */
  0x800F,   /* U+4B7E */
  0x801D,   /* U+4B7F */
  0x801E,   /* U+4B80 */
  0x801F,   /* U+4B81 */
  0x8020,   /* U+4B82 */
  0x8021,   /* U+4B83 */
  0x8022,   /* U+4B84 */
  0x8023,   /* U+4B85 */
  0x801A,   /* U+4B86 */
  0x801B,   /* U+4B87 */
  0x801C,   /* U+4B88 */
  0x801D,   /* U+4B89 */
  0x801E,   /* U+4B8A */
  0x801F,   /* U+4B8B */
  0x8020,   /* U+4B8C */
  0xCB8D,   /* U+4B8D */
  0x8012,   /* U+4B8E */
  0x8013,   /* U+4B8F */
  0x8014,   /* U+4B90 */
  0x8015,   /* U+4B91 */
  0x8016,   /* U+4B92 */
  0x800F,   /* U+4B93 */
  0x8010,   /* U+4B94 */
  0x8011,   /* U+4B95 */
  0x8012,   /* U+4B96 */
  0x8013,   /* U+4B97 */
  0x8014,   /* U+4B98 */
  0x8015,   /* U+4B99 */
  0x8016,   /* U+4B9A */
  0x8017,   /* U+4B9B */
  0x8016,   /* U+4B9C */
  0x8017,   /* U+4B9D */
  0x8018,   /* U+4B9E */
  0x8019,   /* U+4B9F */
  0x801A,   /* U+4BA0 */
  0x801B,   /* U+4BA1 */
  0x801C,   /* U+4BA2 */
  0x8000,   /* U+4BA3 */
  0x8001,   /* U+4BA4 */
  0x8002,   /* U+4BA5 */
  0x8003,   /* U+4BA6 */
  0x8004,   /* U+4BA7 */
  0x8005,   /* U+4BA8 */
  0x8006,   /* U+4BA9 */
  0x8009,   /* U+4BAA */
  0x800A,   /* U+4BAB */
  0x800B,   /* U+4BAC */
  0x800C,   /* U+4BAD */
  0x800D,   /* U+4BAE */
  0x800E,   /* U+4BAF */
  0x800F,   /* U+4BB0 */
  0x8010,   /* U+4BB1 */
  0x8007,   /* U+4BB2 */
  0x8008,   /* U+4BB3 */
  0x8009,   /* U+4BB4 */
  0x800A,   /* U+4BB5 */
  0x800B,   /* U+4BB6 */
  0x8003,   /* U+4BB7 */
  0x8004,   /* U+4BB8 */
  0x8005,   /* U+4BB9 */
  0x8002,   /* U+4BBA */
  0x8003,   /* U+4BBB */
  0x8004,   /* U+4BBC */
  0x8002,   /* U+4BBD */
  0x8002,   /* U+4BBE */
  0x8003,   /* U+4BBF */
  0x8002,   /* U+4BC0 */
  0x8000,   /* U+4BC1 */
  0x8000,   /* U+4BC2 */
  0x8000,   /* U+4BC3 */
  0x8000,   /* U+4BC4 */
  0x8000,   /* U+4BC5 */
  0x8000,   /* U+4BC6 */
  0x8000,   /* U+4BC7 */
  0x8000,   /* U+4BC8 */
  0x8001,   /* U+4BC9 */
  0x8000,   /* U+4BCA */
  0x8001,   /* U+4BCB */
  0x8002,   /* U+4BCC */
  0x8003,   /* U+4BCD */
  0x8004,   /* U+4BCE */
  0x8000,   /* U+4BCF */
  0x8001,   /* U+4BD0 */
  0x8002,   /* U+4BD1 */
  0x8003,   /* U+4BD2 */
  0x8004,   /* U+4BD3 */
  0x8005,   /* U+4BD4 */
  0x8000,   /* U+4BD5 */
  0x8001,   /* U+4BD6 */
  0x8002,   /* U+4BD7 */
  0x8003,   /* U+4BD8 */
  0x8004,   /* U+4BD9 */
  0x8005,   /* U+4BDA */
  0x8000,   /* U+4BDB */
  0x8001,   /* U+4BDC */
  0x8000,   /* U+4BDD */
  0x8001,   /* U+4BDE */
  0x8002,   /* U+4BDF */
  0x8003,   /* U+4BE0 */
  0x8001,   /* U+4BE1 */
  0x8000,   /* U+4BE2 */
  0x8000,   /* U+4BE3 */
  0x8000,   /* U+4BE4 */
  0x8000,   /* U+4BE5 */
  0x8000,   /* U+4BE6 */
  0x8000,   /* U+4BE7 */
  0x8000,   /* U+4BE8 */
  0xCBE9,   /* U+4BE9 */
  0x8000,   /* U+4BEA */
  0x8000,   /* U+4BEB */
  0x8000,   /* U+4BEC */
  0x8000,   /* U+4BED */
  0x8001,   /* U+4BEE */
  0x8000,   /* U+4BEF */
  0x8001,   /* U+4BF0 */
  0x8002,   /* U+4BF1 */
  0x8003,   /* U+4BF2 */
  0x8004,   /* U+4BF3 */
  0x8005,   /* U+4BF4 */
  0x8000,   /* U+4BF5 */
  0x8001,   /* U+4BF6 */
  0x8000,   /* U+4BF7 */
  0x8001,   /* U+4BF8 */
  0x8000,   /* U+4BF9 */
  0x8001,   /* U+4BFA */
  0xCBFB,   /* U+4BFB */
  0x8002,   /* U+4BFC */
  0x8000,   /* U+4BFD */
  0x8001,   /* U+4BFE */
  0x8002,   /* U+4BFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4B00 */
  0x0000,   /* U+4B01 */
  0x0000,   /* U+4B02 */
  0x0000,   /* U+4B03 */
  0x0000,   /* U+4B04 */
  0x0000,   /* U+4B05 */
  0x0000,   /* U+4B06 */
  0x0000,   /* U+4B07 */
  0x0000,   /* U+4B08 */
  0x0000,   /* U+4B09 */
  0x0000,   /* U+4B0A */
  0x0000,   /* U+4B0B */
  0x0000,   /* U+4B0C */
  0x0000,   /* U+4B0D */
  0x0000,   /* U+4B0E */
  0x0000,   /* U+4B0F */
  0x0000,   /* U+4B10 */
  0x0000,   /* U+4B11 */
  0x0000,   /* U+4B12 */
  0x0000,   /* U+4B13 */
  0x0000,   /* U+4B14 */
  0x0000,   /* U+4B15 */
  0x0000,   /* U+4B16 */
  0x0000,   /* U+4B17 */
  0x0000,   /* U+4B18 */
  0x0000,   /* U+4B19 */
  0x0000,   /* U+4B1A */
  0x0000,   /* U+4B1B */
  0x0000,   /* U+4B1C */
  0x0000,   /* U+4B1D */
  0x0000,   /* U+4B1E */
  0x0000,   /* U+4B1F */
  0x0000,   /* U+4B20 */
  0x0000,   /* U+4B21 */
  0x0000,   /* U+4B22 */
  0x0000,   /* U+4B23 */
  0x0000,   /* U+4B24 */
  0x0000,   /* U+4B25 */
  0x0000,   /* U+4B26 */
  0x0000,   /* U+4B27 */
  0x0000,   /* U+4B28 */
  0x0000,   /* U+4B29 */
  0x0000,   /* U+4B2A */
  0x0000,   /* U+4B2B */
  0x0000,   /* U+4B2C */
  0x0000,   /* U+4B2D */
  0x0000,   /* U+4B2E */
  0x0000,   /* U+4B2F */
  0x0000,   /* U+4B30 */
  0x0000,   /* U+4B31 */
  0x0000,   /* U+4B32 */
  0x0000,   /* U+4B33 */
  0x0000,   /* U+4B34 */
  0x0000,   /* U+4B35 */
  0x0000,   /* U+4B36 */
  0x0000,   /* U+4B37 */
  0x0000,   /* U+4B38 */
  0x0000,   /* U+4B39 */
  0x0000,   /* U+4B3A */
  0x0000,   /* U+4B3B */
  0x0000,   /* U+4B3C */
  0x0000,   /* U+4B3D */
  0x0000,   /* U+4B3E */
  0x0000,   /* U+4B3F */
  0x0000,   /* U+4B40 */
  0x0000,   /* U+4B41 */
  0x0000,   /* U+4B42 */
  0x0000,   /* U+4B43 */
  0x0000,   /* U+4B44 */
  0x0000,   /* U+4B45 */
  0x0000,   /* U+4B46 */
  0x0000,   /* U+4B47 */
  0x0000,   /* U+4B48 */
  0x0000,   /* U+4B49 */
  0x0000,   /* U+4B4A */
  0x0000,   /* U+4B4B */
  0x0000,   /* U+4B4C */
  0x0000,   /* U+4B4D */
  0x0000,   /* U+4B4E */
  0x0000,   /* U+4B4F */
  0x0000,   /* U+4B50 */
  0x0000,   /* U+4B51 */
  0x0000,   /* U+4B52 */
  0x0000,   /* U+4B53 */
  0x0000,   /* U+4B54 */
  0x0000,   /* U+4B55 */
  0x0000,   /* U+4B56 */
  0x0000,   /* U+4B57 */
  0x0000,   /* U+4B58 */
  0x0000,   /* U+4B59 */
  0x0000,   /* U+4B5A */
  0x0000,   /* U+4B5B */
  0x0000,   /* U+4B5C */
  0x0000,   /* U+4B5D */
  0x0000,   /* U+4B5E */
  0x0000,   /* U+4B5F */
  0x0000,   /* U+4B60 */
  0x0000,   /* U+4B61 */
  0x0000,   /* U+4B62 */
  0x0000,   /* U+4B63 */
  0x0000,   /* U+4B64 */
  0x0000,   /* U+4B65 */
  0x0000,   /* U+4B66 */
  0x0000,   /* U+4B67 */
  0x0000,   /* U+4B68 */
  0x0000,   /* U+4B69 */
  0x0000,   /* U+4B6A */
  0x0000,   /* U+4B6B */
  0x0000,   /* U+4B6C */
  0x0000,   /* U+4B6D */
  0x0000,   /* U+4B6E */
  0x0000,   /* U+4B6F */
  0x0000,   /* U+4B70 */
  0x0000,   /* U+4B71 */
  0x0000,   /* U+4B72 */
  0x0000,   /* U+4B73 */
  0x0000,   /* U+4B74 */
  0x0000,   /* U+4B75 */
  0x0000,   /* U+4B76 */
  0x0000,   /* U+4B77 */
  0x0000,   /* U+4B78 */
  0x0000,   /* U+4B79 */
  0x0000,   /* U+4B7A */
  0x0000,   /* U+4B7B */
  0x0000,   /* U+4B7C */
  0x0000,   /* U+4B7D */
  0x0000,   /* U+4B7E */
  0x0000,   /* U+4B7F */
  0x0000,   /* U+4B80 */
  0x0000,   /* U+4B81 */
  0x0000,   /* U+4B82 */
  0x0000,   /* U+4B83 */
  0x0000,   /* U+4B84 */
  0x0000,   /* U+4B85 */
  0x0000,   /* U+4B86 */
  0x0000,   /* U+4B87 */
  0x0000,   /* U+4B88 */
  0x0000,   /* U+4B89 */
  0x0000,   /* U+4B8A */
  0x0000,   /* U+4B8B */
  0x0000,   /* U+4B8C */
  0x0000,   /* U+4B8D */
  0x0000,   /* U+4B8E */
  0x0000,   /* U+4B8F */
  0x0000,   /* U+4B90 */
  0x0000,   /* U+4B91 */
  0x0000,   /* U+4B92 */
  0x0000,   /* U+4B93 */
  0x0000,   /* U+4B94 */
  0x0000,   /* U+4B95 */
  0x0000,   /* U+4B96 */
  0x0000,   /* U+4B97 */
  0x0000,   /* U+4B98 */
  0x0000,   /* U+4B99 */
  0x0000,   /* U+4B9A */
  0x0000,   /* U+4B9B */
  0x0000,   /* U+4B9C */
  0x0000,   /* U+4B9D */
  0x0000,   /* U+4B9E */
  0x0000,   /* U+4B9F */
  0x0000,   /* U+4BA0 */
  0x0000,   /* U+4BA1 */
  0x0000,   /* U+4BA2 */
  0x0000,   /* U+4BA3 */
  0x0000,   /* U+4BA4 */
  0x0000,   /* U+4BA5 */
  0x0000,   /* U+4BA6 */
  0x0000,   /* U+4BA7 */
  0x0000,   /* U+4BA8 */
  0x0000,   /* U+4BA9 */
  0x0000,   /* U+4BAA */
  0x0000,   /* U+4BAB */
  0x0000,   /* U+4BAC */
  0x0000,   /* U+4BAD */
  0x0000,   /* U+4BAE */
  0x0000,   /* U+4BAF */
  0x0000,   /* U+4BB0 */
  0x0000,   /* U+4BB1 */
  0x0000,   /* U+4BB2 */
  0x0000,   /* U+4BB3 */
  0x0000,   /* U+4BB4 */
  0x0000,   /* U+4BB5 */
  0x0000,   /* U+4BB6 */
  0x0000,   /* U+4BB7 */
  0x0000,   /* U+4BB8 */
  0x0000,   /* U+4BB9 */
  0x0000,   /* U+4BBA */
  0x0000,   /* U+4BBB */
  0x0000,   /* U+4BBC */
  0x0000,   /* U+4BBD */
  0x0000,   /* U+4BBE */
  0x0000,   /* U+4BBF */
  0x0000,   /* U+4BC0 */
  0x0000,   /* U+4BC1 */
  0x0000,   /* U+4BC2 */
  0x0000,   /* U+4BC3 */
  0x0000,   /* U+4BC4 */
  0x0000,   /* U+4BC5 */
  0x0000,   /* U+4BC6 */
  0x0000,   /* U+4BC7 */
  0x0000,   /* U+4BC8 */
  0x0000,   /* U+4BC9 */
  0x0000,   /* U+4BCA */
  0x0000,   /* U+4BCB */
  0x0000,   /* U+4BCC */
  0x0000,   /* U+4BCD */
  0x0000,   /* U+4BCE */
  0x0000,   /* U+4BCF */
  0x0000,   /* U+4BD0 */
  0x0000,   /* U+4BD1 */
  0x0000,   /* U+4BD2 */
  0x0000,   /* U+4BD3 */
  0x0000,   /* U+4BD4 */
  0x0000,   /* U+4BD5 */
  0x0000,   /* U+4BD6 */
  0x0000,   /* U+4BD7 */
  0x0000,   /* U+4BD8 */
  0x0000,   /* U+4BD9 */
  0x0000,   /* U+4BDA */
  0x0000,   /* U+4BDB */
  0x0000,   /* U+4BDC */
  0x0000,   /* U+4BDD */
  0x0000,   /* U+4BDE */
  0x0000,   /* U+4BDF */
  0x0000,   /* U+4BE0 */
  0x0000,   /* U+4BE1 */
  0x0000,   /* U+4BE2 */
  0x0000,   /* U+4BE3 */
  0x0000,   /* U+4BE4 */
  0x0000,   /* U+4BE5 */
  0x0000,   /* U+4BE6 */
  0x0000,   /* U+4BE7 */
  0x0000,   /* U+4BE8 */
  0x0000,   /* U+4BE9 */
  0x0000,   /* U+4BEA */
  0x0000,   /* U+4BEB */
  0x0000,   /* U+4BEC */
  0x0000,   /* U+4BED */
  0x0000,   /* U+4BEE */
  0x0000,   /* U+4BEF */
  0x0000,   /* U+4BF0 */
  0x0000,   /* U+4BF1 */
  0x0000,   /* U+4BF2 */
  0x0000,   /* U+4BF3 */
  0x0000,   /* U+4BF4 */
  0x0000,   /* U+4BF5 */
  0x0000,   /* U+4BF6 */
  0x0000,   /* U+4BF7 */
  0x0000,   /* U+4BF8 */
  0x0000,   /* U+4BF9 */
  0x0000,   /* U+4BFA */
  0x0000,   /* U+4BFB */
  0x0000,   /* U+4BFC */
  0x0000,   /* U+4BFD */
  0x0000,   /* U+4BFE */
  0x0000,   /* U+4BFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4B00 */
  0x0000,   /* U+4B01 */
  0x0000,   /* U+4B02 */
  0x0000,   /* U+4B03 */
  0x0000,   /* U+4B04 */
  0x0000,   /* U+4B05 */
  0x0000,   /* U+4B06 */
  0x0000,   /* U+4B07 */
  0x0000,   /* U+4B08 */
  0x0000,   /* U+4B09 */
  0x0000,   /* U+4B0A */
  0x0000,   /* U+4B0B */
  0x0000,   /* U+4B0C */
  0x0000,   /* U+4B0D */
  0x0000,   /* U+4B0E */
  0x0000,   /* U+4B0F */
  0x0000,   /* U+4B10 */
  0x0000,   /* U+4B11 */
  0x0000,   /* U+4B12 */
  0x0000,   /* U+4B13 */
  0x0000,   /* U+4B14 */
  0x0000,   /* U+4B15 */
  0x0000,   /* U+4B16 */
  0x0000,   /* U+4B17 */
  0x0000,   /* U+4B18 */
  0x0000,   /* U+4B19 */
  0x0000,   /* U+4B1A */
  0x0000,   /* U+4B1B */
  0x0000,   /* U+4B1C */
  0x0000,   /* U+4B1D */
  0x0000,   /* U+4B1E */
  0x0000,   /* U+4B1F */
  0x0000,   /* U+4B20 */
  0x0000,   /* U+4B21 */
  0x0000,   /* U+4B22 */
  0x0000,   /* U+4B23 */
  0x0000,   /* U+4B24 */
  0x0000,   /* U+4B25 */
  0x0000,   /* U+4B26 */
  0x0000,   /* U+4B27 */
  0x0000,   /* U+4B28 */
  0x0000,   /* U+4B29 */
  0x0000,   /* U+4B2A */
  0x0000,   /* U+4B2B */
  0x0000,   /* U+4B2C */
  0x0000,   /* U+4B2D */
  0x0000,   /* U+4B2E */
  0x0000,   /* U+4B2F */
  0x0000,   /* U+4B30 */
  0x0000,   /* U+4B31 */
  0x0000,   /* U+4B32 */
  0x0000,   /* U+4B33 */
  0x0000,   /* U+4B34 */
  0x0000,   /* U+4B35 */
  0x0000,   /* U+4B36 */
  0x0000,   /* U+4B37 */
  0x0000,   /* U+4B38 */
  0x0000,   /* U+4B39 */
  0x0000,   /* U+4B3A */
  0x0000,   /* U+4B3B */
  0x0000,   /* U+4B3C */
  0x0000,   /* U+4B3D */
  0x0000,   /* U+4B3E */
  0x0000,   /* U+4B3F */
  0x0000,   /* U+4B40 */
  0x0000,   /* U+4B41 */
  0x0000,   /* U+4B42 */
  0x0000,   /* U+4B43 */
  0x0000,   /* U+4B44 */
  0x0000,   /* U+4B45 */
  0x0000,   /* U+4B46 */
  0x0000,   /* U+4B47 */
  0x0000,   /* U+4B48 */
  0x0000,   /* U+4B49 */
  0x0000,   /* U+4B4A */
  0x0000,   /* U+4B4B */
  0x0000,   /* U+4B4C */
  0x0000,   /* U+4B4D */
  0x0000,   /* U+4B4E */
  0x0000,   /* U+4B4F */
  0x0000,   /* U+4B50 */
  0x0000,   /* U+4B51 */
  0x0000,   /* U+4B52 */
  0x0000,   /* U+4B53 */
  0x0000,   /* U+4B54 */
  0x0000,   /* U+4B55 */
  0x0000,   /* U+4B56 */
  0x0000,   /* U+4B57 */
  0x0000,   /* U+4B58 */
  0x0000,   /* U+4B59 */
  0x0000,   /* U+4B5A */
  0x0000,   /* U+4B5B */
  0x0000,   /* U+4B5C */
  0x0000,   /* U+4B5D */
  0x0000,   /* U+4B5E */
  0x0000,   /* U+4B5F */
  0x0000,   /* U+4B60 */
  0x0000,   /* U+4B61 */
  0x0000,   /* U+4B62 */
  0x0000,   /* U+4B63 */
  0x0000,   /* U+4B64 */
  0x0000,   /* U+4B65 */
  0x0000,   /* U+4B66 */
  0x0000,   /* U+4B67 */
  0x0000,   /* U+4B68 */
  0x0000,   /* U+4B69 */
  0x0000,   /* U+4B6A */
  0x0000,   /* U+4B6B */
  0x0000,   /* U+4B6C */
  0x0000,   /* U+4B6D */
  0x0000,   /* U+4B6E */
  0x0000,   /* U+4B6F */
  0x0000,   /* U+4B70 */
  0x0000,   /* U+4B71 */
  0x0000,   /* U+4B72 */
  0x0000,   /* U+4B73 */
  0x0000,   /* U+4B74 */
  0x0000,   /* U+4B75 */
  0x0000,   /* U+4B76 */
  0x0000,   /* U+4B77 */
  0x0000,   /* U+4B78 */
  0x0000,   /* U+4B79 */
  0x0000,   /* U+4B7A */
  0x0000,   /* U+4B7B */
  0x0000,   /* U+4B7C */
  0x0000,   /* U+4B7D */
  0x0000,   /* U+4B7E */
  0x0000,   /* U+4B7F */
  0x0000,   /* U+4B80 */
  0x0000,   /* U+4B81 */
  0x0000,   /* U+4B82 */
  0x0000,   /* U+4B83 */
  0x0000,   /* U+4B84 */
  0x0000,   /* U+4B85 */
  0x0000,   /* U+4B86 */
  0x0000,   /* U+4B87 */
  0x0000,   /* U+4B88 */
  0x0000,   /* U+4B89 */
  0x0000,   /* U+4B8A */
  0x0000,   /* U+4B8B */
  0x0000,   /* U+4B8C */
  0x0000,   /* U+4B8D */
  0x0000,   /* U+4B8E */
  0x0000,   /* U+4B8F */
  0x0000,   /* U+4B90 */
  0x0000,   /* U+4B91 */
  0x0000,   /* U+4B92 */
  0x0000,   /* U+4B93 */
  0x0000,   /* U+4B94 */
  0x0000,   /* U+4B95 */
  0x0000,   /* U+4B96 */
  0x0000,   /* U+4B97 */
  0x0000,   /* U+4B98 */
  0x0000,   /* U+4B99 */
  0x0000,   /* U+4B9A */
  0x0000,   /* U+4B9B */
  0x0000,   /* U+4B9C */
  0x0000,   /* U+4B9D */
  0x0000,   /* U+4B9E */
  0x0000,   /* U+4B9F */
  0x0000,   /* U+4BA0 */
  0x0000,   /* U+4BA1 */
  0x0000,   /* U+4BA2 */
  0x0000,   /* U+4BA3 */
  0x0000,   /* U+4BA4 */
  0x0000,   /* U+4BA5 */
  0x0000,   /* U+4BA6 */
  0x0000,   /* U+4BA7 */
  0x0000,   /* U+4BA8 */
  0x0000,   /* U+4BA9 */
  0x0000,   /* U+4BAA */
  0x0000,   /* U+4BAB */
  0x0000,   /* U+4BAC */
  0x0000,   /* U+4BAD */
  0x0000,   /* U+4BAE */
  0x0000,   /* U+4BAF */
  0x0000,   /* U+4BB0 */
  0x0000,   /* U+4BB1 */
  0x0000,   /* U+4BB2 */
  0x0000,   /* U+4BB3 */
  0x0000,   /* U+4BB4 */
  0x0000,   /* U+4BB5 */
  0x0000,   /* U+4BB6 */
  0x0000,   /* U+4BB7 */
  0x0000,   /* U+4BB8 */
  0x0000,   /* U+4BB9 */
  0x0000,   /* U+4BBA */
  0x0000,   /* U+4BBB */
  0x0000,   /* U+4BBC */
  0x0000,   /* U+4BBD */
  0x0000,   /* U+4BBE */
  0x0000,   /* U+4BBF */
  0x0000,   /* U+4BC0 */
  0x0000,   /* U+4BC1 */
  0x0000,   /* U+4BC2 */
  0x0000,   /* U+4BC3 */
  0x0000,   /* U+4BC4 */
  0x0000,   /* U+4BC5 */
  0x0000,   /* U+4BC6 */
  0x0000,   /* U+4BC7 */
  0x0000,   /* U+4BC8 */
  0x0000,   /* U+4BC9 */
  0x0000,   /* U+4BCA */
  0x0000,   /* U+4BCB */
  0x0000,   /* U+4BCC */
  0x0000,   /* U+4BCD */
  0x0000,   /* U+4BCE */
  0x0000,   /* U+4BCF */
  0x0000,   /* U+4BD0 */
  0x0000,   /* U+4BD1 */
  0x0000,   /* U+4BD2 */
  0x0000,   /* U+4BD3 */
  0x0000,   /* U+4BD4 */
  0x0000,   /* U+4BD5 */
  0x0000,   /* U+4BD6 */
  0x0000,   /* U+4BD7 */
  0x0000,   /* U+4BD8 */
  0x0000,   /* U+4BD9 */
  0x0000,   /* U+4BDA */
  0x0000,   /* U+4BDB */
  0x0000,   /* U+4BDC */
  0x0000,   /* U+4BDD */
  0x0000,   /* U+4BDE */
  0x0000,   /* U+4BDF */
  0x0000,   /* U+4BE0 */
  0x0000,   /* U+4BE1 */
  0x0000,   /* U+4BE2 */
  0x0000,   /* U+4BE3 */
  0x0000,   /* U+4BE4 */
  0x0000,   /* U+4BE5 */
  0x0000,   /* U+4BE6 */
  0x0000,   /* U+4BE7 */
  0x0000,   /* U+4BE8 */
  0x0000,   /* U+4BE9 */
  0x0000,   /* U+4BEA */
  0x0000,   /* U+4BEB */
  0x0000,   /* U+4BEC */
  0x0000,   /* U+4BED */
  0x0000,   /* U+4BEE */
  0x0000,   /* U+4BEF */
  0x0000,   /* U+4BF0 */
  0x0000,   /* U+4BF1 */
  0x0000,   /* U+4BF2 */
  0x0000,   /* U+4BF3 */
  0x0000,   /* U+4BF4 */
  0x0000,   /* U+4BF5 */
  0x0000,   /* U+4BF6 */
  0x0000,   /* U+4BF7 */
  0x0000,   /* U+4BF8 */
  0x0000,   /* U+4BF9 */
  0x0000,   /* U+4BFA */
  0x0000,   /* U+4BFB */
  0x0000,   /* U+4BFC */
  0x0000,   /* U+4BFD */
  0x0000,   /* U+4BFE */
  0x0000,   /* U+4BFF */
};

uint16 zh2_han_p04C[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,

  /* Primary weight 1 for each character. */
  0x4BD4,   /* U+4C00 */
  0x4BD4,   /* U+4C01 */
  0x4BD4,   /* U+4C02 */
  0x4BD4,   /* U+4C03 */
  0x4BD5,   /* U+4C04 */
  0x4BD5,   /* U+4C05 */
  0x4BD5,   /* U+4C06 */
  0x4BD5,   /* U+4C07 */
  0x4BCD,   /* U+4C08 */
  0x4BCD,   /* U+4C09 */
  0x4BCD,   /* U+4C0A */
  0x4BCD,   /* U+4C0B */
  0x4BD7,   /* U+4C0C */
  0x4BD7,   /* U+4C0D */
  0x4BD8,   /* U+4C0E */
  0x4BDA,   /* U+4C0F */
  0x4BDA,   /* U+4C10 */
  0x4BDA,   /* U+4C11 */
  0x4BDA,   /* U+4C12 */
  0x4BDB,   /* U+4C13 */
  0x4BDB,   /* U+4C14 */
  0x4BDC,   /* U+4C15 */
  0x4BDF,   /* U+4C16 */
  0x4C0D,   /* U+4C17 */
  0x4C17,   /* U+4C18 */
  0x4C90,   /* U+4C19 */
  0x4C90,   /* U+4C1A */
  0x4C91,   /* U+4C1B */
  0x4C92,   /* U+4C1C */
  0x4C98,   /* U+4C1D */
  0x4C9B,   /* U+4C1E */
  0x4CD0,   /* U+4C1F */
  0x4CD1,   /* U+4C20 */
  0x4CD1,   /* U+4C21 */
  0x4CD2,   /* U+4C22 */
  0x4CD2,   /* U+4C23 */
  0x4CD4,   /* U+4C24 */
  0x4CD4,   /* U+4C25 */
  0x4CD4,   /* U+4C26 */
  0x4CD4,   /* U+4C27 */
  0x4CD5,   /* U+4C28 */
  0x4CD5,   /* U+4C29 */
  0x4CCD,   /* U+4C2A */
  0x4CD8,   /* U+4C2B */
  0x4CD8,   /* U+4C2C */
  0x4CD8,   /* U+4C2D */
  0x5C49,   /* U+4C2E */
  0x4CDA,   /* U+4C2F */
  0x4CDA,   /* U+4C30 */
  0x4CE4,   /* U+4C31 */
  0x4D0D,   /* U+4C32 */
  0x5C49,   /* U+4C33 */
  0x4D0F,   /* U+4C34 */
  0x4D0F,   /* U+4C35 */
  0x5C49,   /* U+4C36 */
  0x4D10,   /* U+4C37 */
  0x4D10,   /* U+4C38 */
  0x4D10,   /* U+4C39 */
  0x4D10,   /* U+4C3A */
  0x4D10,   /* U+4C3B */
  0x4D10,   /* U+4C3C */
  0x4D10,   /* U+4C3D */
  0x4D10,   /* U+4C3E */
  0x4D11,   /* U+4C3F */
  0x4D11,   /* U+4C40 */
  0x4D11,   /* U+4C41 */
  0x4D11,   /* U+4C42 */
  0x4D11,   /* U+4C43 */
  0x4D11,   /* U+4C44 */
  0x4D11,   /* U+4C45 */
  0x4D11,   /* U+4C46 */
  0x4D11,   /* U+4C47 */
  0x4D11,   /* U+4C48 */
  0x4D11,   /* U+4C49 */
  0x4D12,   /* U+4C4A */
  0x4D12,   /* U+4C4B */
  0x4D12,   /* U+4C4C */
  0x4D12,   /* U+4C4D */
  0x4D12,   /* U+4C4E */
  0x4D13,   /* U+4C4F */
  0x4D13,   /* U+4C50 */
  0x4D13,   /* U+4C51 */
  0x4D13,   /* U+4C52 */
  0x4D13,   /* U+4C53 */
  0x4D13,   /* U+4C54 */
  0x4D13,   /* U+4C55 */
  0x4D13,   /* U+4C56 */
  0x4D13,   /* U+4C57 */
  0x4D13,   /* U+4C58 */
  0x4D14,   /* U+4C59 */
  0x4D14,   /* U+4C5A */
  0x4D14,   /* U+4C5B */
  0x4D14,   /* U+4C5C */
  0x4D14,   /* U+4C5D */
  0x4D14,   /* U+4C5E */
  0x4D14,   /* U+4C5F */
  0x4D14,   /* U+4C60 */
  0x4D14,   /* U+4C61 */
  0x4D14,   /* U+4C62 */
  0x4D14,   /* U+4C63 */
  0x4D14,   /* U+4C64 */
  0x4D14,   /* U+4C65 */
  0x4D14,   /* U+4C66 */
  0x4D14,   /* U+4C67 */
  0x5C49,   /* U+4C68 */
  0x4D14,   /* U+4C69 */
  0x5C49,   /* U+4C6A */
  0x4D15,   /* U+4C6B */
  0x4D15,   /* U+4C6C */
  0x4D15,   /* U+4C6D */
  0x4D15,   /* U+4C6E */
  0x4D15,   /* U+4C6F */
  0x4D15,   /* U+4C70 */
  0x4D15,   /* U+4C71 */
  0x4D15,   /* U+4C72 */
  0x4D15,   /* U+4C73 */
  0x4D15,   /* U+4C74 */
  0x4D0D,   /* U+4C75 */
  0x4D0D,   /* U+4C76 */
  0x4D0D,   /* U+4C77 */
  0x4D0D,   /* U+4C78 */
  0x4D0D,   /* U+4C79 */
  0x4D0D,   /* U+4C7A */
  0x4D0D,   /* U+4C7B */
  0x4D0D,   /* U+4C7C */
  0x4D0D,   /* U+4C7D */
  0x4D17,   /* U+4C7E */
  0x4D17,   /* U+4C7F */
  0x4D17,   /* U+4C80 */
  0x4D17,   /* U+4C81 */
  0x4D17,   /* U+4C82 */
  0x4D17,   /* U+4C83 */
  0x4D17,   /* U+4C84 */
  0x4D17,   /* U+4C85 */
  0x4D17,   /* U+4C86 */
  0x5C49,   /* U+4C87 */
  0x5C49,   /* U+4C88 */
  0x4D18,   /* U+4C89 */
  0x4D18,   /* U+4C8A */
  0x4D18,   /* U+4C8B */
  0x4D18,   /* U+4C8C */
  0x4D18,   /* U+4C8D */
  0x4D18,   /* U+4C8E */
  0x4D18,   /* U+4C8F */
  0x4D19,   /* U+4C90 */
  0x4D19,   /* U+4C91 */
  0x4D19,   /* U+4C92 */
  0x4D19,   /* U+4C93 */
  0x4D19,   /* U+4C94 */
  0x4D19,   /* U+4C95 */
  0x4D1A,   /* U+4C96 */
  0x4D1A,   /* U+4C97 */
  0x4D1A,   /* U+4C98 */
  0x4D1B,   /* U+4C99 */
  0x4D1C,   /* U+4C9A */
  0x4D1C,   /* U+4C9B */
  0x4D2D,   /* U+4C9C */
  0x4D10,   /* U+4C9D */
  0x4D11,   /* U+4C9E */
  0x4D11,   /* U+4C9F */
  0x4D15,   /* U+4CA0 */
  0x4D15,   /* U+4CA1 */
  0x4D16,   /* U+4CA2 */
  0x4D16,   /* U+4CA3 */
  0x4D16,   /* U+4CA4 */
  0x4D4E,   /* U+4CA5 */
  0x4D4F,   /* U+4CA6 */
  0x4D4F,   /* U+4CA7 */
  0x4D4F,   /* U+4CA8 */
  0x4D4F,   /* U+4CA9 */
  0x4D4F,   /* U+4CAA */
  0x4D4F,   /* U+4CAB */
  0x4D50,   /* U+4CAC */
  0x4D50,   /* U+4CAD */
  0x4D50,   /* U+4CAE */
  0x4D50,   /* U+4CAF */
  0x4D50,   /* U+4CB0 */
  0x4D50,   /* U+4CB1 */
  0x4D50,   /* U+4CB2 */
  0x4D50,   /* U+4CB3 */
  0x4D50,   /* U+4CB4 */
  0x4D50,   /* U+4CB5 */
  0x5C49,   /* U+4CB6 */
  0x5C49,   /* U+4CB7 */
  0x4D50,   /* U+4CB8 */
  0x4D51,   /* U+4CB9 */
  0x4D51,   /* U+4CBA */
  0x4D51,   /* U+4CBB */
  0x4D51,   /* U+4CBC */
  0x4D51,   /* U+4CBD */
  0x4D51,   /* U+4CBE */
  0x4D51,   /* U+4CBF */
  0x4D51,   /* U+4CC0 */
  0x4D51,   /* U+4CC1 */
  0x4D51,   /* U+4CC2 */
  0x4D51,   /* U+4CC3 */
  0x4D51,   /* U+4CC4 */
  0x4D51,   /* U+4CC5 */
  0x4D51,   /* U+4CC6 */
  0x4D51,   /* U+4CC7 */
  0x4D51,   /* U+4CC8 */
  0x4D51,   /* U+4CC9 */
  0x4D51,   /* U+4CCA */
  0x4D52,   /* U+4CCB */
  0x4D52,   /* U+4CCC */
  0x4D52,   /* U+4CCD */
  0x4D52,   /* U+4CCE */
  0x4D52,   /* U+4CCF */
  0x4D52,   /* U+4CD0 */
  0x4D52,   /* U+4CD1 */
  0x4D52,   /* U+4CD2 */
  0x4D52,   /* U+4CD3 */
  0x4D52,   /* U+4CD4 */
  0x4D53,   /* U+4CD5 */
  0x4D53,   /* U+4CD6 */
  0x4D53,   /* U+4CD7 */
  0x4D53,   /* U+4CD8 */
  0x4D53,   /* U+4CD9 */
  0x4D53,   /* U+4CDA */
  0x4D53,   /* U+4CDB */
  0x4D53,   /* U+4CDC */
  0x4D54,   /* U+4CDD */
  0x4D54,   /* U+4CDE */
  0x4D54,   /* U+4CDF */
  0x4D54,   /* U+4CE0 */
  0x4D54,   /* U+4CE1 */
  0x4D54,   /* U+4CE2 */
  0x4D54,   /* U+4CE3 */
  0x4D54,   /* U+4CE4 */
  0x4D54,   /* U+4CE5 */
  0x4D55,   /* U+4CE6 */
  0x4D55,   /* U+4CE7 */
  0x4D55,   /* U+4CE8 */
  0x4D55,   /* U+4CE9 */
  0x4D55,   /* U+4CEA */
  0x4D55,   /* U+4CEB */
  0x4D55,   /* U+4CEC */
  0x4D55,   /* U+4CED */
  0x4D55,   /* U+4CEE */
  0x4D55,   /* U+4CEF */
  0x4D55,   /* U+4CF0 */
  0x4D4D,   /* U+4CF1 */
  0x4D4D,   /* U+4CF2 */
  0x4D4D,   /* U+4CF3 */
  0x4D4D,   /* U+4CF4 */
  0x4D4D,   /* U+4CF5 */
  0x4D4D,   /* U+4CF6 */
  0x4D57,   /* U+4CF7 */
  0x4D57,   /* U+4CF8 */
  0x4D57,   /* U+4CF9 */
  0x4D57,   /* U+4CFA */
  0x4D57,   /* U+4CFB */
  0x4D57,   /* U+4CFC */
  0x4D57,   /* U+4CFD */
  0x4D58,   /* U+4CFE */
  0x4D58,   /* U+4CFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4C00 */
  0x0020,   /* U+4C01 */
  0x0020,   /* U+4C02 */
  0x0020,   /* U+4C03 */
  0x0020,   /* U+4C04 */
  0x0020,   /* U+4C05 */
  0x0020,   /* U+4C06 */
  0x0020,   /* U+4C07 */
  0x0020,   /* U+4C08 */
  0x0020,   /* U+4C09 */
  0x0020,   /* U+4C0A */
  0x0020,   /* U+4C0B */
  0x0020,   /* U+4C0C */
  0x0020,   /* U+4C0D */
  0x0020,   /* U+4C0E */
  0x0020,   /* U+4C0F */
  0x0020,   /* U+4C10 */
  0x0020,   /* U+4C11 */
  0x0020,   /* U+4C12 */
  0x0020,   /* U+4C13 */
  0x0020,   /* U+4C14 */
  0x0020,   /* U+4C15 */
  0x0020,   /* U+4C16 */
  0x0020,   /* U+4C17 */
  0x0020,   /* U+4C18 */
  0x0020,   /* U+4C19 */
  0x0020,   /* U+4C1A */
  0x0020,   /* U+4C1B */
  0x0020,   /* U+4C1C */
  0x0020,   /* U+4C1D */
  0x0020,   /* U+4C1E */
  0x0020,   /* U+4C1F */
  0x0020,   /* U+4C20 */
  0x0020,   /* U+4C21 */
  0x0020,   /* U+4C22 */
  0x0020,   /* U+4C23 */
  0x0020,   /* U+4C24 */
  0x0020,   /* U+4C25 */
  0x0020,   /* U+4C26 */
  0x0020,   /* U+4C27 */
  0x0020,   /* U+4C28 */
  0x0020,   /* U+4C29 */
  0x0020,   /* U+4C2A */
  0x0020,   /* U+4C2B */
  0x0020,   /* U+4C2C */
  0x0020,   /* U+4C2D */
  0x0020,   /* U+4C2E */
  0x0020,   /* U+4C2F */
  0x0020,   /* U+4C30 */
  0x0020,   /* U+4C31 */
  0x0020,   /* U+4C32 */
  0x0020,   /* U+4C33 */
  0x0020,   /* U+4C34 */
  0x0020,   /* U+4C35 */
  0x0020,   /* U+4C36 */
  0x0020,   /* U+4C37 */
  0x0020,   /* U+4C38 */
  0x0020,   /* U+4C39 */
  0x0020,   /* U+4C3A */
  0x0020,   /* U+4C3B */
  0x0020,   /* U+4C3C */
  0x0020,   /* U+4C3D */
  0x0020,   /* U+4C3E */
  0x0020,   /* U+4C3F */
  0x0020,   /* U+4C40 */
  0x0020,   /* U+4C41 */
  0x0020,   /* U+4C42 */
  0x0020,   /* U+4C43 */
  0x0020,   /* U+4C44 */
  0x0020,   /* U+4C45 */
  0x0020,   /* U+4C46 */
  0x0020,   /* U+4C47 */
  0x0020,   /* U+4C48 */
  0x0020,   /* U+4C49 */
  0x0020,   /* U+4C4A */
  0x0020,   /* U+4C4B */
  0x0020,   /* U+4C4C */
  0x0020,   /* U+4C4D */
  0x0020,   /* U+4C4E */
  0x0020,   /* U+4C4F */
  0x0020,   /* U+4C50 */
  0x0020,   /* U+4C51 */
  0x0020,   /* U+4C52 */
  0x0020,   /* U+4C53 */
  0x0020,   /* U+4C54 */
  0x0020,   /* U+4C55 */
  0x0020,   /* U+4C56 */
  0x0020,   /* U+4C57 */
  0x0020,   /* U+4C58 */
  0x0020,   /* U+4C59 */
  0x0020,   /* U+4C5A */
  0x0020,   /* U+4C5B */
  0x0020,   /* U+4C5C */
  0x0020,   /* U+4C5D */
  0x0020,   /* U+4C5E */
  0x0020,   /* U+4C5F */
  0x0020,   /* U+4C60 */
  0x0020,   /* U+4C61 */
  0x0020,   /* U+4C62 */
  0x0020,   /* U+4C63 */
  0x0020,   /* U+4C64 */
  0x0020,   /* U+4C65 */
  0x0020,   /* U+4C66 */
  0x0020,   /* U+4C67 */
  0x0020,   /* U+4C68 */
  0x0020,   /* U+4C69 */
  0x0020,   /* U+4C6A */
  0x0020,   /* U+4C6B */
  0x0020,   /* U+4C6C */
  0x0020,   /* U+4C6D */
  0x0020,   /* U+4C6E */
  0x0020,   /* U+4C6F */
  0x0020,   /* U+4C70 */
  0x0020,   /* U+4C71 */
  0x0020,   /* U+4C72 */
  0x0020,   /* U+4C73 */
  0x0020,   /* U+4C74 */
  0x0020,   /* U+4C75 */
  0x0020,   /* U+4C76 */
  0x0020,   /* U+4C77 */
  0x0020,   /* U+4C78 */
  0x0020,   /* U+4C79 */
  0x0020,   /* U+4C7A */
  0x0020,   /* U+4C7B */
  0x0020,   /* U+4C7C */
  0x0020,   /* U+4C7D */
  0x0020,   /* U+4C7E */
  0x0020,   /* U+4C7F */
  0x0020,   /* U+4C80 */
  0x0020,   /* U+4C81 */
  0x0020,   /* U+4C82 */
  0x0020,   /* U+4C83 */
  0x0020,   /* U+4C84 */
  0x0020,   /* U+4C85 */
  0x0020,   /* U+4C86 */
  0x0020,   /* U+4C87 */
  0x0020,   /* U+4C88 */
  0x0020,   /* U+4C89 */
  0x0020,   /* U+4C8A */
  0x0020,   /* U+4C8B */
  0x0020,   /* U+4C8C */
  0x0020,   /* U+4C8D */
  0x0020,   /* U+4C8E */
  0x0020,   /* U+4C8F */
  0x0020,   /* U+4C90 */
  0x0020,   /* U+4C91 */
  0x0020,   /* U+4C92 */
  0x0020,   /* U+4C93 */
  0x0020,   /* U+4C94 */
  0x0020,   /* U+4C95 */
  0x0020,   /* U+4C96 */
  0x0020,   /* U+4C97 */
  0x0020,   /* U+4C98 */
  0x0020,   /* U+4C99 */
  0x0020,   /* U+4C9A */
  0x0020,   /* U+4C9B */
  0x0020,   /* U+4C9C */
  0x0020,   /* U+4C9D */
  0x0020,   /* U+4C9E */
  0x0020,   /* U+4C9F */
  0x0020,   /* U+4CA0 */
  0x0020,   /* U+4CA1 */
  0x0020,   /* U+4CA2 */
  0x0020,   /* U+4CA3 */
  0x0020,   /* U+4CA4 */
  0x0020,   /* U+4CA5 */
  0x0020,   /* U+4CA6 */
  0x0020,   /* U+4CA7 */
  0x0020,   /* U+4CA8 */
  0x0020,   /* U+4CA9 */
  0x0020,   /* U+4CAA */
  0x0020,   /* U+4CAB */
  0x0020,   /* U+4CAC */
  0x0020,   /* U+4CAD */
  0x0020,   /* U+4CAE */
  0x0020,   /* U+4CAF */
  0x0020,   /* U+4CB0 */
  0x0020,   /* U+4CB1 */
  0x0020,   /* U+4CB2 */
  0x0020,   /* U+4CB3 */
  0x0020,   /* U+4CB4 */
  0x0020,   /* U+4CB5 */
  0x0020,   /* U+4CB6 */
  0x0020,   /* U+4CB7 */
  0x0020,   /* U+4CB8 */
  0x0020,   /* U+4CB9 */
  0x0020,   /* U+4CBA */
  0x0020,   /* U+4CBB */
  0x0020,   /* U+4CBC */
  0x0020,   /* U+4CBD */
  0x0020,   /* U+4CBE */
  0x0020,   /* U+4CBF */
  0x0020,   /* U+4CC0 */
  0x0020,   /* U+4CC1 */
  0x0020,   /* U+4CC2 */
  0x0020,   /* U+4CC3 */
  0x0020,   /* U+4CC4 */
  0x0020,   /* U+4CC5 */
  0x0020,   /* U+4CC6 */
  0x0020,   /* U+4CC7 */
  0x0020,   /* U+4CC8 */
  0x0020,   /* U+4CC9 */
  0x0020,   /* U+4CCA */
  0x0020,   /* U+4CCB */
  0x0020,   /* U+4CCC */
  0x0020,   /* U+4CCD */
  0x0020,   /* U+4CCE */
  0x0020,   /* U+4CCF */
  0x0020,   /* U+4CD0 */
  0x0020,   /* U+4CD1 */
  0x0020,   /* U+4CD2 */
  0x0020,   /* U+4CD3 */
  0x0020,   /* U+4CD4 */
  0x0020,   /* U+4CD5 */
  0x0020,   /* U+4CD6 */
  0x0020,   /* U+4CD7 */
  0x0020,   /* U+4CD8 */
  0x0020,   /* U+4CD9 */
  0x0020,   /* U+4CDA */
  0x0020,   /* U+4CDB */
  0x0020,   /* U+4CDC */
  0x0020,   /* U+4CDD */
  0x0020,   /* U+4CDE */
  0x0020,   /* U+4CDF */
  0x0020,   /* U+4CE0 */
  0x0020,   /* U+4CE1 */
  0x0020,   /* U+4CE2 */
  0x0020,   /* U+4CE3 */
  0x0020,   /* U+4CE4 */
  0x0020,   /* U+4CE5 */
  0x0020,   /* U+4CE6 */
  0x0020,   /* U+4CE7 */
  0x0020,   /* U+4CE8 */
  0x0020,   /* U+4CE9 */
  0x0020,   /* U+4CEA */
  0x0020,   /* U+4CEB */
  0x0020,   /* U+4CEC */
  0x0020,   /* U+4CED */
  0x0020,   /* U+4CEE */
  0x0020,   /* U+4CEF */
  0x0020,   /* U+4CF0 */
  0x0020,   /* U+4CF1 */
  0x0020,   /* U+4CF2 */
  0x0020,   /* U+4CF3 */
  0x0020,   /* U+4CF4 */
  0x0020,   /* U+4CF5 */
  0x0020,   /* U+4CF6 */
  0x0020,   /* U+4CF7 */
  0x0020,   /* U+4CF8 */
  0x0020,   /* U+4CF9 */
  0x0020,   /* U+4CFA */
  0x0020,   /* U+4CFB */
  0x0020,   /* U+4CFC */
  0x0020,   /* U+4CFD */
  0x0020,   /* U+4CFE */
  0x0020,   /* U+4CFF */

  /* Tertiary weight 1 for each character. */
  0x0002,   /* U+4C00 */
  0x0002,   /* U+4C01 */
  0x0002,   /* U+4C02 */
  0x0002,   /* U+4C03 */
  0x0002,   /* U+4C04 */
  0x0002,   /* U+4C05 */
  0x0002,   /* U+4C06 */
  0x0002,   /* U+4C07 */
  0x0002,   /* U+4C08 */
  0x0002,   /* U+4C09 */
  0x0002,   /* U+4C0A */
  0x0002,   /* U+4C0B */
  0x0002,   /* U+4C0C */
  0x0002,   /* U+4C0D */
  0x0002,   /* U+4C0E */
  0x0002,   /* U+4C0F */
  0x0002,   /* U+4C10 */
  0x0002,   /* U+4C11 */
  0x0002,   /* U+4C12 */
  0x0002,   /* U+4C13 */
  0x0002,   /* U+4C14 */
  0x0002,   /* U+4C15 */
  0x0002,   /* U+4C16 */
  0x0002,   /* U+4C17 */
  0x0002,   /* U+4C18 */
  0x0002,   /* U+4C19 */
  0x0002,   /* U+4C1A */
  0x0002,   /* U+4C1B */
  0x0002,   /* U+4C1C */
  0x0002,   /* U+4C1D */
  0x0002,   /* U+4C1E */
  0x0002,   /* U+4C1F */
  0x0002,   /* U+4C20 */
  0x0002,   /* U+4C21 */
  0x0002,   /* U+4C22 */
  0x0002,   /* U+4C23 */
  0x0002,   /* U+4C24 */
  0x0002,   /* U+4C25 */
  0x0002,   /* U+4C26 */
  0x0002,   /* U+4C27 */
  0x0002,   /* U+4C28 */
  0x0002,   /* U+4C29 */
  0x0002,   /* U+4C2A */
  0x0002,   /* U+4C2B */
  0x0002,   /* U+4C2C */
  0x0002,   /* U+4C2D */
  0x0002,   /* U+4C2E */
  0x0002,   /* U+4C2F */
  0x0002,   /* U+4C30 */
  0x0002,   /* U+4C31 */
  0x0002,   /* U+4C32 */
  0x0002,   /* U+4C33 */
  0x0002,   /* U+4C34 */
  0x0002,   /* U+4C35 */
  0x0002,   /* U+4C36 */
  0x0002,   /* U+4C37 */
  0x0002,   /* U+4C38 */
  0x0002,   /* U+4C39 */
  0x0002,   /* U+4C3A */
  0x0002,   /* U+4C3B */
  0x0002,   /* U+4C3C */
  0x0002,   /* U+4C3D */
  0x0002,   /* U+4C3E */
  0x0002,   /* U+4C3F */
  0x0002,   /* U+4C40 */
  0x0002,   /* U+4C41 */
  0x0002,   /* U+4C42 */
  0x0002,   /* U+4C43 */
  0x0002,   /* U+4C44 */
  0x0002,   /* U+4C45 */
  0x0002,   /* U+4C46 */
  0x0002,   /* U+4C47 */
  0x0002,   /* U+4C48 */
  0x0002,   /* U+4C49 */
  0x0002,   /* U+4C4A */
  0x0002,   /* U+4C4B */
  0x0002,   /* U+4C4C */
  0x0002,   /* U+4C4D */
  0x0002,   /* U+4C4E */
  0x0002,   /* U+4C4F */
  0x0002,   /* U+4C50 */
  0x0002,   /* U+4C51 */
  0x0002,   /* U+4C52 */
  0x0002,   /* U+4C53 */
  0x0002,   /* U+4C54 */
  0x0002,   /* U+4C55 */
  0x0002,   /* U+4C56 */
  0x0002,   /* U+4C57 */
  0x0002,   /* U+4C58 */
  0x0002,   /* U+4C59 */
  0x0002,   /* U+4C5A */
  0x0002,   /* U+4C5B */
  0x0002,   /* U+4C5C */
  0x0002,   /* U+4C5D */
  0x0002,   /* U+4C5E */
  0x0002,   /* U+4C5F */
  0x0002,   /* U+4C60 */
  0x0002,   /* U+4C61 */
  0x0002,   /* U+4C62 */
  0x0002,   /* U+4C63 */
  0x0002,   /* U+4C64 */
  0x0002,   /* U+4C65 */
  0x0002,   /* U+4C66 */
  0x0002,   /* U+4C67 */
  0x0002,   /* U+4C68 */
  0x0002,   /* U+4C69 */
  0x0002,   /* U+4C6A */
  0x0002,   /* U+4C6B */
  0x0002,   /* U+4C6C */
  0x0002,   /* U+4C6D */
  0x0002,   /* U+4C6E */
  0x0002,   /* U+4C6F */
  0x0002,   /* U+4C70 */
  0x0002,   /* U+4C71 */
  0x0002,   /* U+4C72 */
  0x0002,   /* U+4C73 */
  0x0002,   /* U+4C74 */
  0x0002,   /* U+4C75 */
  0x0002,   /* U+4C76 */
  0x0002,   /* U+4C77 */
  0x0002,   /* U+4C78 */
  0x0002,   /* U+4C79 */
  0x0002,   /* U+4C7A */
  0x0002,   /* U+4C7B */
  0x0002,   /* U+4C7C */
  0x0002,   /* U+4C7D */
  0x0002,   /* U+4C7E */
  0x0002,   /* U+4C7F */
  0x0002,   /* U+4C80 */
  0x0002,   /* U+4C81 */
  0x0002,   /* U+4C82 */
  0x0002,   /* U+4C83 */
  0x0002,   /* U+4C84 */
  0x0002,   /* U+4C85 */
  0x0002,   /* U+4C86 */
  0x0002,   /* U+4C87 */
  0x0002,   /* U+4C88 */
  0x0002,   /* U+4C89 */
  0x0002,   /* U+4C8A */
  0x0002,   /* U+4C8B */
  0x0002,   /* U+4C8C */
  0x0002,   /* U+4C8D */
  0x0002,   /* U+4C8E */
  0x0002,   /* U+4C8F */
  0x0002,   /* U+4C90 */
  0x0002,   /* U+4C91 */
  0x0002,   /* U+4C92 */
  0x0002,   /* U+4C93 */
  0x0002,   /* U+4C94 */
  0x0002,   /* U+4C95 */
  0x0002,   /* U+4C96 */
  0x0002,   /* U+4C97 */
  0x0002,   /* U+4C98 */
  0x0002,   /* U+4C99 */
  0x0002,   /* U+4C9A */
  0x0002,   /* U+4C9B */
  0x0002,   /* U+4C9C */
  0x0002,   /* U+4C9D */
  0x0002,   /* U+4C9E */
  0x0002,   /* U+4C9F */
  0x0002,   /* U+4CA0 */
  0x0002,   /* U+4CA1 */
  0x0002,   /* U+4CA2 */
  0x0002,   /* U+4CA3 */
  0x0002,   /* U+4CA4 */
  0x0002,   /* U+4CA5 */
  0x0002,   /* U+4CA6 */
  0x0002,   /* U+4CA7 */
  0x0002,   /* U+4CA8 */
  0x0002,   /* U+4CA9 */
  0x0002,   /* U+4CAA */
  0x0002,   /* U+4CAB */
  0x0002,   /* U+4CAC */
  0x0002,   /* U+4CAD */
  0x0002,   /* U+4CAE */
  0x0002,   /* U+4CAF */
  0x0002,   /* U+4CB0 */
  0x0002,   /* U+4CB1 */
  0x0002,   /* U+4CB2 */
  0x0002,   /* U+4CB3 */
  0x0002,   /* U+4CB4 */
  0x0002,   /* U+4CB5 */
  0x0002,   /* U+4CB6 */
  0x0002,   /* U+4CB7 */
  0x0002,   /* U+4CB8 */
  0x0002,   /* U+4CB9 */
  0x0002,   /* U+4CBA */
  0x0002,   /* U+4CBB */
  0x0002,   /* U+4CBC */
  0x0002,   /* U+4CBD */
  0x0002,   /* U+4CBE */
  0x0002,   /* U+4CBF */
  0x0002,   /* U+4CC0 */
  0x0002,   /* U+4CC1 */
  0x0002,   /* U+4CC2 */
  0x0002,   /* U+4CC3 */
  0x0002,   /* U+4CC4 */
  0x0002,   /* U+4CC5 */
  0x0002,   /* U+4CC6 */
  0x0002,   /* U+4CC7 */
  0x0002,   /* U+4CC8 */
  0x0002,   /* U+4CC9 */
  0x0002,   /* U+4CCA */
  0x0002,   /* U+4CCB */
  0x0002,   /* U+4CCC */
  0x0002,   /* U+4CCD */
  0x0002,   /* U+4CCE */
  0x0002,   /* U+4CCF */
  0x0002,   /* U+4CD0 */
  0x0002,   /* U+4CD1 */
  0x0002,   /* U+4CD2 */
  0x0002,   /* U+4CD3 */
  0x0002,   /* U+4CD4 */
  0x0002,   /* U+4CD5 */
  0x0002,   /* U+4CD6 */
  0x0002,   /* U+4CD7 */
  0x0002,   /* U+4CD8 */
  0x0002,   /* U+4CD9 */
  0x0002,   /* U+4CDA */
  0x0002,   /* U+4CDB */
  0x0002,   /* U+4CDC */
  0x0002,   /* U+4CDD */
  0x0002,   /* U+4CDE */
  0x0002,   /* U+4CDF */
  0x0002,   /* U+4CE0 */
  0x0002,   /* U+4CE1 */
  0x0002,   /* U+4CE2 */
  0x0002,   /* U+4CE3 */
  0x0002,   /* U+4CE4 */
  0x0002,   /* U+4CE5 */
  0x0002,   /* U+4CE6 */
  0x0002,   /* U+4CE7 */
  0x0002,   /* U+4CE8 */
  0x0002,   /* U+4CE9 */
  0x0002,   /* U+4CEA */
  0x0002,   /* U+4CEB */
  0x0002,   /* U+4CEC */
  0x0002,   /* U+4CED */
  0x0002,   /* U+4CEE */
  0x0002,   /* U+4CEF */
  0x0002,   /* U+4CF0 */
  0x0002,   /* U+4CF1 */
  0x0002,   /* U+4CF2 */
  0x0002,   /* U+4CF3 */
  0x0002,   /* U+4CF4 */
  0x0002,   /* U+4CF5 */
  0x0002,   /* U+4CF6 */
  0x0002,   /* U+4CF7 */
  0x0002,   /* U+4CF8 */
  0x0002,   /* U+4CF9 */
  0x0002,   /* U+4CFA */
  0x0002,   /* U+4CFB */
  0x0002,   /* U+4CFC */
  0x0002,   /* U+4CFD */
  0x0002,   /* U+4CFE */
  0x0002,   /* U+4CFF */

  /* Primary weight 2 for each character. */
  0x8003,   /* U+4C00 */
  0x8004,   /* U+4C01 */
  0x8005,   /* U+4C02 */
  0x8006,   /* U+4C03 */
  0x8000,   /* U+4C04 */
  0x8001,   /* U+4C05 */
  0x8002,   /* U+4C06 */
  0x8003,   /* U+4C07 */
  0x8000,   /* U+4C08 */
  0x8001,   /* U+4C09 */
  0x8002,   /* U+4C0A */
  0x8003,   /* U+4C0B */
  0x8000,   /* U+4C0C */
  0x8001,   /* U+4C0D */
  0x8000,   /* U+4C0E */
  0x8000,   /* U+4C0F */
  0x8001,   /* U+4C10 */
  0x8002,   /* U+4C11 */
  0x8003,   /* U+4C12 */
  0x8000,   /* U+4C13 */
  0x8001,   /* U+4C14 */
  0x8000,   /* U+4C15 */
  0x8000,   /* U+4C16 */
  0x8000,   /* U+4C17 */
  0x8000,   /* U+4C18 */
  0x8000,   /* U+4C19 */
  0x8001,   /* U+4C1A */
  0x8000,   /* U+4C1B */
  0x8000,   /* U+4C1C */
  0x8000,   /* U+4C1D */
  0x8000,   /* U+4C1E */
  0x8000,   /* U+4C1F */
  0x8000,   /* U+4C20 */
  0x8001,   /* U+4C21 */
  0x8000,   /* U+4C22 */
  0x8001,   /* U+4C23 */
  0x8000,   /* U+4C24 */
  0x8001,   /* U+4C25 */
  0x8002,   /* U+4C26 */
  0x8003,   /* U+4C27 */
  0x8000,   /* U+4C28 */
  0x8001,   /* U+4C29 */
  0x8000,   /* U+4C2A */
  0x8000,   /* U+4C2B */
  0x8001,   /* U+4C2C */
  0x8002,   /* U+4C2D */
  0xCC2E,   /* U+4C2E */
  0x8000,   /* U+4C2F */
  0x8001,   /* U+4C30 */
  0x8000,   /* U+4C31 */
  0x8000,   /* U+4C32 */
  0xCC33,   /* U+4C33 */
  0x8007,   /* U+4C34 */
  0x8008,   /* U+4C35 */
  0xCC36,   /* U+4C36 */
  0x8013,   /* U+4C37 */
  0x8014,   /* U+4C38 */
  0x8015,   /* U+4C39 */
  0x8016,   /* U+4C3A */
  0x8017,   /* U+4C3B */
  0x8018,   /* U+4C3C */
  0x8019,   /* U+4C3D */
  0x801A,   /* U+4C3E */
  0x801A,   /* U+4C3F */
  0x801B,   /* U+4C40 */
  0x801C,   /* U+4C41 */
  0x801D,   /* U+4C42 */
  0x801E,   /* U+4C43 */
  0x801F,   /* U+4C44 */
  0x8020,   /* U+4C45 */
  0x8021,   /* U+4C46 */
  0x8022,   /* U+4C47 */
  0x8023,   /* U+4C48 */
  0x8024,   /* U+4C49 */
  0x801E,   /* U+4C4A */
  0x801F,   /* U+4C4B */
  0x8020,   /* U+4C4C */
  0x8021,   /* U+4C4D */
  0x8022,   /* U+4C4E */
  0x801C,   /* U+4C4F */
  0x801D,   /* U+4C50 */
  0x801E,   /* U+4C51 */
  0x801F,   /* U+4C52 */
  0x8020,   /* U+4C53 */
  0x8021,   /* U+4C54 */
  0x8022,   /* U+4C55 */
  0x8023,   /* U+4C56 */
  0x8024,   /* U+4C57 */
  0x8025,   /* U+4C58 */
  0x8022,   /* U+4C59 */
  0x8023,   /* U+4C5A */
  0x8024,   /* U+4C5B */
  0x8025,   /* U+4C5C */
  0x8026,   /* U+4C5D */
  0x8027,   /* U+4C5E */
  0x8028,   /* U+4C5F */
  0x8029,   /* U+4C60 */
  0x802A,   /* U+4C61 */
  0x802B,   /* U+4C62 */
  0x802C,   /* U+4C63 */
  0x802D,   /* U+4C64 */
  0x802E,   /* U+4C65 */
  0x802F,   /* U+4C66 */
  0x8030,   /* U+4C67 */
  0xCC68,   /* U+4C68 */
  0x8031,   /* U+4C69 */
  0xCC6A,   /* U+4C6A */
  0x8025,   /* U+4C6B */
  0x8026,   /* U+4C6C */
  0x8027,   /* U+4C6D */
  0x8028,   /* U+4C6E */
  0x8029,   /* U+4C6F */
  0x802A,   /* U+4C70 */
  0x802B,   /* U+4C71 */
  0x802C,   /* U+4C72 */
  0x802D,   /* U+4C73 */
  0x802E,   /* U+4C74 */
  0x8001,   /* U+4C75 */
  0x8002,   /* U+4C76 */
  0x8003,   /* U+4C77 */
  0x8004,   /* U+4C78 */
  0x8005,   /* U+4C79 */
  0x8006,   /* U+4C7A */
  0x8007,   /* U+4C7B */
  0x8008,   /* U+4C7C */
  0x8009,   /* U+4C7D */
  0x8013,   /* U+4C7E */
  0x8014,   /* U+4C7F */
  0x8015,   /* U+4C80 */
  0x8016,   /* U+4C81 */
  0x8017,   /* U+4C82 */
  0x8018,   /* U+4C83 */
  0x8019,   /* U+4C84 */
  0x801A,   /* U+4C85 */
  0x801B,   /* U+4C86 */
  0xCC87,   /* U+4C87 */
  0xCC88,   /* U+4C88 */
  0x800D,   /* U+4C89 */
  0x800E,   /* U+4C8A */
  0x800F,   /* U+4C8B */
  0x8010,   /* U+4C8C */
  0x8011,   /* U+4C8D */
  0x8012,   /* U+4C8E */
  0x8013,   /* U+4C8F */
  0x8007,   /* U+4C90 */
  0x8008,   /* U+4C91 */
  0x8009,   /* U+4C92 */
  0x800A,   /* U+4C93 */
  0x800B,   /* U+4C94 */
  0x800C,   /* U+4C95 */
  0x8003,   /* U+4C96 */
  0x8004,   /* U+4C97 */
  0x8005,   /* U+4C98 */
  0x8004,   /* U+4C99 */
  0x8001,   /* U+4C9A */
  0x8002,   /* U+4C9B */
  0x8000,   /* U+4C9C */
  0x8000,   /* U+4C9D */
  0x8000,   /* U+4C9E */
  0x8001,   /* U+4C9F */
  0x8000,   /* U+4CA0 */
  0x8001,   /* U+4CA1 */
  0x8000,   /* U+4CA2 */
  0x8001,   /* U+4CA3 */
  0x8002,   /* U+4CA4 */
  0x8004,   /* U+4CA5 */
  0x8004,   /* U+4CA6 */
  0x8005,   /* U+4CA7 */
  0x8006,   /* U+4CA8 */
  0x8007,   /* U+4CA9 */
  0x8008,   /* U+4CAA */
  0x8009,   /* U+4CAB */
  0x8013,   /* U+4CAC */
  0x8014,   /* U+4CAD */
  0x8015,   /* U+4CAE */
  0x8016,   /* U+4CAF */
  0x8017,   /* U+4CB0 */
  0x8018,   /* U+4CB1 */
  0x8019,   /* U+4CB2 */
  0x801A,   /* U+4CB3 */
  0x801B,   /* U+4CB4 */
  0x801C,   /* U+4CB5 */
  0xCCB6,   /* U+4CB6 */
  0xCCB7,   /* U+4CB7 */
  0x801D,   /* U+4CB8 */
  0x801C,   /* U+4CB9 */
  0x801D,   /* U+4CBA */
  0x801E,   /* U+4CBB */
  0x801F,   /* U+4CBC */
  0x8020,   /* U+4CBD */
  0x8021,   /* U+4CBE */
  0x8022,   /* U+4CBF */
  0x8023,   /* U+4CC0 */
  0x8024,   /* U+4CC1 */
  0x8025,   /* U+4CC2 */
  0x8026,   /* U+4CC3 */
  0x8027,   /* U+4CC4 */
  0x8028,   /* U+4CC5 */
  0x8029,   /* U+4CC6 */
  0x802A,   /* U+4CC7 */
  0x802B,   /* U+4CC8 */
  0x802C,   /* U+4CC9 */
  0x802D,   /* U+4CCA */
  0x801E,   /* U+4CCB */
  0x801F,   /* U+4CCC */
  0x8020,   /* U+4CCD */
  0x8021,   /* U+4CCE */
  0x8022,   /* U+4CCF */
  0x8023,   /* U+4CD0 */
  0x8024,   /* U+4CD1 */
  0x8025,   /* U+4CD2 */
  0x8026,   /* U+4CD3 */
  0x8027,   /* U+4CD4 */
  0x8019,   /* U+4CD5 */
  0x801A,   /* U+4CD6 */
  0x801B,   /* U+4CD7 */
  0x801C,   /* U+4CD8 */
  0x801D,   /* U+4CD9 */
  0x801E,   /* U+4CDA */
  0x801F,   /* U+4CDB */
  0x8020,   /* U+4CDC */
  0x801A,   /* U+4CDD */
  0x801B,   /* U+4CDE */
  0x801C,   /* U+4CDF */
  0x801D,   /* U+4CE0 */
  0x801E,   /* U+4CE1 */
  0x801F,   /* U+4CE2 */
  0x8020,   /* U+4CE3 */
  0x8021,   /* U+4CE4 */
  0x8022,   /* U+4CE5 */
  0x8019,   /* U+4CE6 */
  0x801A,   /* U+4CE7 */
  0x801B,   /* U+4CE8 */
  0x801C,   /* U+4CE9 */
  0x801D,   /* U+4CEA */
  0x801E,   /* U+4CEB */
  0x801F,   /* U+4CEC */
  0x8020,   /* U+4CED */
  0x8021,   /* U+4CEE */
  0x8022,   /* U+4CEF */
  0x8023,   /* U+4CF0 */
  0x8001,   /* U+4CF1 */
  0x8002,   /* U+4CF2 */
  0x8003,   /* U+4CF3 */
  0x8004,   /* U+4CF4 */
  0x8005,   /* U+4CF5 */
  0x8006,   /* U+4CF6 */
  0x800C,   /* U+4CF7 */
  0x800D,   /* U+4CF8 */
  0x800E,   /* U+4CF9 */
  0x800F,   /* U+4CFA */
  0x8010,   /* U+4CFB */
  0x8011,   /* U+4CFC */
  0x8012,   /* U+4CFD */
  0x800B,   /* U+4CFE */
  0x800C,   /* U+4CFF */

  /* Secondary weight 2 for each character. */
  0x0000,   /* U+4C00 */
  0x0000,   /* U+4C01 */
  0x0000,   /* U+4C02 */
  0x0000,   /* U+4C03 */
  0x0000,   /* U+4C04 */
  0x0000,   /* U+4C05 */
  0x0000,   /* U+4C06 */
  0x0000,   /* U+4C07 */
  0x0000,   /* U+4C08 */
  0x0000,   /* U+4C09 */
  0x0000,   /* U+4C0A */
  0x0000,   /* U+4C0B */
  0x0000,   /* U+4C0C */
  0x0000,   /* U+4C0D */
  0x0000,   /* U+4C0E */
  0x0000,   /* U+4C0F */
  0x0000,   /* U+4C10 */
  0x0000,   /* U+4C11 */
  0x0000,   /* U+4C12 */
  0x0000,   /* U+4C13 */
  0x0000,   /* U+4C14 */
  0x0000,   /* U+4C15 */
  0x0000,   /* U+4C16 */
  0x0000,   /* U+4C17 */
  0x0000,   /* U+4C18 */
  0x0000,   /* U+4C19 */
  0x0000,   /* U+4C1A */
  0x0000,   /* U+4C1B */
  0x0000,   /* U+4C1C */
  0x0000,   /* U+4C1D */
  0x0000,   /* U+4C1E */
  0x0000,   /* U+4C1F */
  0x0000,   /* U+4C20 */
  0x0000,   /* U+4C21 */
  0x0000,   /* U+4C22 */
  0x0000,   /* U+4C23 */
  0x0000,   /* U+4C24 */
  0x0000,   /* U+4C25 */
  0x0000,   /* U+4C26 */
  0x0000,   /* U+4C27 */
  0x0000,   /* U+4C28 */
  0x0000,   /* U+4C29 */
  0x0000,   /* U+4C2A */
  0x0000,   /* U+4C2B */
  0x0000,   /* U+4C2C */
  0x0000,   /* U+4C2D */
  0x0000,   /* U+4C2E */
  0x0000,   /* U+4C2F */
  0x0000,   /* U+4C30 */
  0x0000,   /* U+4C31 */
  0x0000,   /* U+4C32 */
  0x0000,   /* U+4C33 */
  0x0000,   /* U+4C34 */
  0x0000,   /* U+4C35 */
  0x0000,   /* U+4C36 */
  0x0000,   /* U+4C37 */
  0x0000,   /* U+4C38 */
  0x0000,   /* U+4C39 */
  0x0000,   /* U+4C3A */
  0x0000,   /* U+4C3B */
  0x0000,   /* U+4C3C */
  0x0000,   /* U+4C3D */
  0x0000,   /* U+4C3E */
  0x0000,   /* U+4C3F */
  0x0000,   /* U+4C40 */
  0x0000,   /* U+4C41 */
  0x0000,   /* U+4C42 */
  0x0000,   /* U+4C43 */
  0x0000,   /* U+4C44 */
  0x0000,   /* U+4C45 */
  0x0000,   /* U+4C46 */
  0x0000,   /* U+4C47 */
  0x0000,   /* U+4C48 */
  0x0000,   /* U+4C49 */
  0x0000,   /* U+4C4A */
  0x0000,   /* U+4C4B */
  0x0000,   /* U+4C4C */
  0x0000,   /* U+4C4D */
  0x0000,   /* U+4C4E */
  0x0000,   /* U+4C4F */
  0x0000,   /* U+4C50 */
  0x0000,   /* U+4C51 */
  0x0000,   /* U+4C52 */
  0x0000,   /* U+4C53 */
  0x0000,   /* U+4C54 */
  0x0000,   /* U+4C55 */
  0x0000,   /* U+4C56 */
  0x0000,   /* U+4C57 */
  0x0000,   /* U+4C58 */
  0x0000,   /* U+4C59 */
  0x0000,   /* U+4C5A */
  0x0000,   /* U+4C5B */
  0x0000,   /* U+4C5C */
  0x0000,   /* U+4C5D */
  0x0000,   /* U+4C5E */
  0x0000,   /* U+4C5F */
  0x0000,   /* U+4C60 */
  0x0000,   /* U+4C61 */
  0x0000,   /* U+4C62 */
  0x0000,   /* U+4C63 */
  0x0000,   /* U+4C64 */
  0x0000,   /* U+4C65 */
  0x0000,   /* U+4C66 */
  0x0000,   /* U+4C67 */
  0x0000,   /* U+4C68 */
  0x0000,   /* U+4C69 */
  0x0000,   /* U+4C6A */
  0x0000,   /* U+4C6B */
  0x0000,   /* U+4C6C */
  0x0000,   /* U+4C6D */
  0x0000,   /* U+4C6E */
  0x0000,   /* U+4C6F */
  0x0000,   /* U+4C70 */
  0x0000,   /* U+4C71 */
  0x0000,   /* U+4C72 */
  0x0000,   /* U+4C73 */
  0x0000,   /* U+4C74 */
  0x0000,   /* U+4C75 */
  0x0000,   /* U+4C76 */
  0x0000,   /* U+4C77 */
  0x0000,   /* U+4C78 */
  0x0000,   /* U+4C79 */
  0x0000,   /* U+4C7A */
  0x0000,   /* U+4C7B */
  0x0000,   /* U+4C7C */
  0x0000,   /* U+4C7D */
  0x0000,   /* U+4C7E */
  0x0000,   /* U+4C7F */
  0x0000,   /* U+4C80 */
  0x0000,   /* U+4C81 */
  0x0000,   /* U+4C82 */
  0x0000,   /* U+4C83 */
  0x0000,   /* U+4C84 */
  0x0000,   /* U+4C85 */
  0x0000,   /* U+4C86 */
  0x0000,   /* U+4C87 */
  0x0000,   /* U+4C88 */
  0x0000,   /* U+4C89 */
  0x0000,   /* U+4C8A */
  0x0000,   /* U+4C8B */
  0x0000,   /* U+4C8C */
  0x0000,   /* U+4C8D */
  0x0000,   /* U+4C8E */
  0x0000,   /* U+4C8F */
  0x0000,   /* U+4C90 */
  0x0000,   /* U+4C91 */
  0x0000,   /* U+4C92 */
  0x0000,   /* U+4C93 */
  0x0000,   /* U+4C94 */
  0x0000,   /* U+4C95 */
  0x0000,   /* U+4C96 */
  0x0000,   /* U+4C97 */
  0x0000,   /* U+4C98 */
  0x0000,   /* U+4C99 */
  0x0000,   /* U+4C9A */
  0x0000,   /* U+4C9B */
  0x0000,   /* U+4C9C */
  0x0000,   /* U+4C9D */
  0x0000,   /* U+4C9E */
  0x0000,   /* U+4C9F */
  0x0000,   /* U+4CA0 */
  0x0000,   /* U+4CA1 */
  0x0000,   /* U+4CA2 */
  0x0000,   /* U+4CA3 */
  0x0000,   /* U+4CA4 */
  0x0000,   /* U+4CA5 */
  0x0000,   /* U+4CA6 */
  0x0000,   /* U+4CA7 */
  0x0000,   /* U+4CA8 */
  0x0000,   /* U+4CA9 */
  0x0000,   /* U+4CAA */
  0x0000,   /* U+4CAB */
  0x0000,   /* U+4CAC */
  0x0000,   /* U+4CAD */
  0x0000,   /* U+4CAE */
  0x0000,   /* U+4CAF */
  0x0000,   /* U+4CB0 */
  0x0000,   /* U+4CB1 */
  0x0000,   /* U+4CB2 */
  0x0000,   /* U+4CB3 */
  0x0000,   /* U+4CB4 */
  0x0000,   /* U+4CB5 */
  0x0000,   /* U+4CB6 */
  0x0000,   /* U+4CB7 */
  0x0000,   /* U+4CB8 */
  0x0000,   /* U+4CB9 */
  0x0000,   /* U+4CBA */
  0x0000,   /* U+4CBB */
  0x0000,   /* U+4CBC */
  0x0000,   /* U+4CBD */
  0x0000,   /* U+4CBE */
  0x0000,   /* U+4CBF */
  0x0000,   /* U+4CC0 */
  0x0000,   /* U+4CC1 */
  0x0000,   /* U+4CC2 */
  0x0000,   /* U+4CC3 */
  0x0000,   /* U+4CC4 */
  0x0000,   /* U+4CC5 */
  0x0000,   /* U+4CC6 */
  0x0000,   /* U+4CC7 */
  0x0000,   /* U+4CC8 */
  0x0000,   /* U+4CC9 */
  0x0000,   /* U+4CCA */
  0x0000,   /* U+4CCB */
  0x0000,   /* U+4CCC */
  0x0000,   /* U+4CCD */
  0x0000,   /* U+4CCE */
  0x0000,   /* U+4CCF */
  0x0000,   /* U+4CD0 */
  0x0000,   /* U+4CD1 */
  0x0000,   /* U+4CD2 */
  0x0000,   /* U+4CD3 */
  0x0000,   /* U+4CD4 */
  0x0000,   /* U+4CD5 */
  0x0000,   /* U+4CD6 */
  0x0000,   /* U+4CD7 */
  0x0000,   /* U+4CD8 */
  0x0000,   /* U+4CD9 */
  0x0000,   /* U+4CDA */
  0x0000,   /* U+4CDB */
  0x0000,   /* U+4CDC */
  0x0000,   /* U+4CDD */
  0x0000,   /* U+4CDE */
  0x0000,   /* U+4CDF */
  0x0000,   /* U+4CE0 */
  0x0000,   /* U+4CE1 */
  0x0000,   /* U+4CE2 */
  0x0000,   /* U+4CE3 */
  0x0000,   /* U+4CE4 */
  0x0000,   /* U+4CE5 */
  0x0000,   /* U+4CE6 */
  0x0000,   /* U+4CE7 */
  0x0000,   /* U+4CE8 */
  0x0000,   /* U+4CE9 */
  0x0000,   /* U+4CEA */
  0x0000,   /* U+4CEB */
  0x0000,   /* U+4CEC */
  0x0000,   /* U+4CED */
  0x0000,   /* U+4CEE */
  0x0000,   /* U+4CEF */
  0x0000,   /* U+4CF0 */
  0x0000,   /* U+4CF1 */
  0x0000,   /* U+4CF2 */
  0x0000,   /* U+4CF3 */
  0x0000,   /* U+4CF4 */
  0x0000,   /* U+4CF5 */
  0x0000,   /* U+4CF6 */
  0x0000,   /* U+4CF7 */
  0x0000,   /* U+4CF8 */
  0x0000,   /* U+4CF9 */
  0x0000,   /* U+4CFA */
  0x0000,   /* U+4CFB */
  0x0000,   /* U+4CFC */
  0x0000,   /* U+4CFD */
  0x0000,   /* U+4CFE */
  0x0000,   /* U+4CFF */

  /* Tertiary weight 2 for each character. */
  0x0000,   /* U+4C00 */
  0x0000,   /* U+4C01 */
  0x0000,   /* U+4C02 */
  0x0000,   /* U+4C03 */
  0x0000,   /* U+4C04 */
  0x0000,   /* U+4C05 */
  0x0000,   /* U+4C06 */
  0x0000,   /* U+4C07 */
  0x0000,   /* U+4C08 */
  0x0000,   /* U+4C09 */
  0x0000,   /* U+4C0A */
  0x0000,   /* U+4C0B */
  0x0000,   /* U+4C0C */
  0x0000,   /* U+4C0D */
  0x0000,   /* U+4C0E */
  0x0000,   /* U+4C0F */
  0x0000,   /* U+4C10 */
  0x0000,   /* U+4C11 */
  0x0000,   /* U+4C12 */
  0x0000,   /* U+4C13 */
  0x0000,   /* U+4C14 */
  0x0000,   /* U+4C15 */
  0x0000,   /* U+4C16 */
  0x0000,   /* U+4C17 */
  0x0000,   /* U+4C18 */
  0x0000,   /* U+4C19 */
  0x0000,   /* U+4C1A */
  0x0000,   /* U+4C1B */
  0x0000,   /* U+4C1C */
  0x0000,   /* U+4C1D */
  0x0000,   /* U+4C1E */
  0x0000,   /* U+4C1F */
  0x0000,   /* U+4C20 */
  0x0000,   /* U+4C21 */
  0x0000,   /* U+4C22 */
  0x0000,   /* U+4C23 */
  0x0000,   /* U+4C24 */
  0x0000,   /* U+4C25 */
  0x0000,   /* U+4C26 */
  0x0000,   /* U+4C27 */
  0x0000,   /* U+4C28 */
  0x0000,   /* U+4C29 */
  0x0000,   /* U+4C2A */
  0x0000,   /* U+4C2B */
  0x0000,   /* U+4C2C */
  0x0000,   /* U+4C2D */
  0x0000,   /* U+4C2E */
  0x0000,   /* U+4C2F */
  0x0000,   /* U+4C30 */
  0x0000,   /* U+4C31 */
  0x0000,   /* U+4C32 */
  0x0000,   /* U+4C33 */
  0x0000,   /* U+4C34 */
  0x0000,   /* U+4C35 */
  0x0000,   /* U+4C36 */
  0x0000,   /* U+4C37 */
  0x0000,   /* U+4C38 */
  0x0000,   /* U+4C39 */
  0x0000,   /* U+4C3A */
  0x0000,   /* U+4C3B */
  0x0000,   /* U+4C3C */
  0x0000,   /* U+4C3D */
  0x0000,   /* U+4C3E */
  0x0000,   /* U+4C3F */
  0x0000,   /* U+4C40 */
  0x0000,   /* U+4C41 */
  0x0000,   /* U+4C42 */
  0x0000,   /* U+4C43 */
  0x0000,   /* U+4C44 */
  0x0000,   /* U+4C45 */
  0x0000,   /* U+4C46 */
  0x0000,   /* U+4C47 */
  0x0000,   /* U+4C48 */
  0x0000,   /* U+4C49 */
  0x0000,   /* U+4C4A */
  0x0000,   /* U+4C4B */
  0x0000,   /* U+4C4C */
  0x0000,   /* U+4C4D */
  0x0000,   /* U+4C4E */
  0x0000,   /* U+4C4F */
  0x0000,   /* U+4C50 */
  0x0000,   /* U+4C51 */
  0x0000,   /* U+4C52 */
  0x0000,   /* U+4C53 */
  0x0000,   /* U+4C54 */
  0x0000,   /* U+4C55 */
  0x0000,   /* U+4C56 */
  0x0000,   /* U+4C57 */
  0x0000,   /* U+4C58 */
  0x0000,   /* U+4C59 */
  0x0000,   /* U+4C5A */
  0x0000,   /* U+4C5B */
  0x0000,   /* U+4C5C */
  0x0000,   /* U+4C5D */
  0x0000,   /* U+4C5E */
  0x0000,   /* U+4C5F */
  0x0000,   /* U+4C60 */
  0x0000,   /* U+4C61 */
  0x0000,   /* U+4C62 */
  0x0000,   /* U+4C63 */
  0x0000,   /* U+4C64 */
  0x0000,   /* U+4C65 */
  0x0000,   /* U+4C66 */
  0x0000,   /* U+4C67 */
  0x0000,   /* U+4C68 */
  0x0000,   /* U+4C69 */
  0x0000,   /* U+4C6A */
  0x0000,   /* U+4C6B */
  0x0000,   /* U+4C6C */
  0x0000,   /* U+4C6D */
  0x0000,   /* U+4C6E */
  0x0000,   /* U+4C6F */
  0x0000,   /* U+4C70 */
  0x0000,   /* U+4C71 */
  0x0000,   /* U+4C72 */
  0x0000,   /* U+4C73 */
  0x0000,   /* U+4C74 */
  0x0000,   /* U+4C75 */
  0x0000,   /* U+4C76 */
  0x0000,   /* U+4C77 */
  0x0000,   /* U+4C78 */
  0x0000,   /* U+4C79 */
  0x0000,   /* U+4C7A */
  0x0000,   /* U+4C7B */
  0x0000,   /* U+4C7C */
  0x0000,   /* U+4C7D */
  0x0000,   /* U+4C7E */
  0x0000,   /* U+4C7F */
  0x0000,   /* U+4C80 */
  0x0000,   /* U+4C81 */
  0x0000,   /* U+4C82 */
  0x0000,   /* U+4C83 */
  0x0000,   /* U+4C84 */
  0x0000,   /* U+4C85 */
  0x0000,   /* U+4C86 */
  0x0000,   /* U+4C87 */
  0x0000,   /* U+4C88 */
  0x0000,   /* U+4C89 */
  0x0000,   /* U+4C8A */
  0x0000,   /* U+4C8B */
  0x0000,   /* U+4C8C */
  0x0000,   /* U+4C8D */
  0x0000,   /* U+4C8E */
  0x0000,   /* U+4C8F */
  0x0000,   /* U+4C90 */
  0x0000,   /* U+4C91 */
  0x0000,   /* U+4C92 */
  0x0000,   /* U+4C93 */
  0x0000,   /* U+4C94 */
  0x0000,   /* U+4C95 */
  0x0000,   /* U+4C96 */
  0x0000,   /* U+4C97 */
  0x0000,   /* U+4C98 */
  0x0000,   /* U+4C99 */
  0x0000,   /* U+4C9A */
  0x0000,   /* U+4C9B */
  0x0000,   /* U+4C9C */
  0x0000,   /* U+4C9D */
  0x0000,   /* U+4C9E */
  0x0000,   /* U+4C9F */
  0x0000,   /* U+4CA0 */
  0x0000,   /* U+4CA1 */
  0x0000,   /* U+4CA2 */
  0x0000,   /* U+4CA3 */
  0x0000,   /* U+4CA4 */
  0x0000,   /* U+4CA5 */
  0x0000,   /* U+4CA6 */
  0x0000,   /* U+4CA7 */
  0x0000,   /* U+4CA8 */
  0x0000,   /* U+4CA9 */
  0x0000,   /* U+4CAA */
  0x0000,   /* U+4CAB */
  0x0000,   /* U+4CAC */
  0x0000,   /* U+4CAD */
  0x0000,   /* U+4CAE */
  0x0000,   /* U+4CAF */
  0x0000,   /* U+4CB0 */
  0x0000,   /* U+4CB1 */
  0x0000,   /* U+4CB2 */
  0x0000,   /* U+4CB3 */
  0x0000,   /* U+4CB4 */
  0x0000,   /* U+4CB5 */
  0x0000,   /* U+4CB6 */
  0x0000,   /* U+4CB7 */
  0x0000,   /* U+4CB8 */
  0x0000,   /* U+4CB9 */
  0x0000,   /* U+4CBA */
  0x0000,   /* U+4CBB */
  0x0000,   /* U+4CBC */
  0x0000,   /* U+4CBD */
  0x0000,   /* U+4CBE */
  0x0000,   /* U+4CBF */
  0x0000,   /* U+4CC0 */
  0x0000,   /* U+4CC1 */
  0x0000,   /* U+4CC2 */
  0x0000,   /* U+4CC3 */
  0x0000,   /* U+4CC4 */
  0x0000,   /* U+4CC5 */
  0x0000,   /* U+4CC6 */
  0x0000,   /* U+4CC7 */
  0x0000,   /* U+4CC8 */
  0x0000,   /* U+4CC9 */
  0x0000,   /* U+4CCA */
  0x0000,   /* U+4CCB */
  0x0000,   /* U+4CCC */
  0x0000,   /* U+4CCD */
  0x0000,   /* U+4CCE */
  0x0000,   /* U+4CCF */
  0x0000,   /* U+4CD0 */
  0x0000,   /* U+4CD1 */
  0x0000,   /* U+4CD2 */
  0x0000,   /* U+4CD3 */
  0x0000,   /* U+4CD4 */
  0x0000,   /* U+4CD5 */
  0x0000,   /* U+4CD6 */
  0x0000,   /* U+4CD7 */
  0x0000,   /* U+4CD8 */
  0x0000,   /* U+4CD9 */
  0x0000,   /* U+4CDA */
  0x0000,   /* U+4CDB */
  0x0000,   /* U+4CDC */
  0x0000,   /* U+4CDD */
  0x0000,   /* U+4CDE */
  0x0000,   /* U+4CDF */
  0x0000,   /* U+4CE0 */
  0x0000,   /* U+4CE1 */
  0x0000,   /* U+4CE2 */
  0x0000,   /* U+4CE3 */
  0x0000,   /* U+4CE4 */
  0x0000,   /* U+4CE5 */
  0x0000,   /* U+4CE6 */
  0x0000,   /* U+4CE7 */
  0x0000,   /* U+4CE8 */
  0x0000,   /* U+4CE9 */
  0x0000,   /* U+4CEA */
  0x0000,   /* U+4CEB */
  0x0000,   /* U+4CEC */
  0x0000,   /* U+4CED */
  0x0000,   /* U+4CEE */
  0x0000,   /* U+4CEF */
  0x0000,   /* U+4CF0 */
  0x0000,   /* U+4CF1 */
  0x0000,   /* U+4CF2 */
  0x0000,   /* U+4CF3 */
  0x0000,   /* U+4CF4 */
  0x0000,   /* U+4CF5 */
  0x0000,   /* U+4CF6 */
  0x0000,   /* U+4CF7 */
  0x0000,   /* U+4CF8 */
  0x0000,   /* U+4CF9 */
  0x0000,   /* U+4CFA */
  0x0000,   /* U+4CFB */
  0x0000,   /* U+4CFC */
  0x0000,   /* U+4CFD */
  0x0000,   /* U+4CFE */
  0x0000,   /* U+4CFF */
};

uint16 zh2_han_p04D[] = {
  /* Number of CEs for each character. */
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,

  /* Primary weight 1 for each character. */
  0x4D58,   /* U+4D00 */
  0x4D58,   /* U+4D01 */
  0x4D58,   /* U+4D02 */
  0x4D58,   /* U+4D03 */
  0x4D58,   /* U+4D04 */
  0x4D58,   /* U+4D05 */
  0x4D58,   /* U+4D06 */
  0x4D59,   /* U+4D07 */
  0x4D59,   /* U+4D08 */
  0x4D59,   /* U+4D09 */
  0x4D59,   /* U+4D0A */
  0x4D59,   /* U+4D0B */
  0x4D5A,   /* U+4D0C */
  0x4D5A,   /* U+4D0D */
  0x4D5B,   /* U+4D0E */
  0x4D5C,   /* U+4D0F */
  0x4D4E,   /* U+4D10 */
  0x4D63,   /* U+4D11 */
  0x4D64,   /* U+4D12 */
  0x4D50,   /* U+4D13 */
  0x4D52,   /* U+4D14 */
  0x4D52,   /* U+4D15 */
  0x4D54,   /* U+4D16 */
  0x4D55,   /* U+4D17 */
  0x4D56,   /* U+4D18 */
  0x4D59,   /* U+4D19 */
  0x4D90,   /* U+4D1A */
  0x4D93,   /* U+4D1B */
  0x4D8D,   /* U+4D1C */
  0x4D98,   /* U+4D1D */
  0x4D9A,   /* U+4D1E */
  0x4DCF,   /* U+4D1F */
  0x4DD0,   /* U+4D20 */
  0x4DD0,   /* U+4D21 */
  0x4DD0,   /* U+4D22 */
  0x4DD1,   /* U+4D23 */
  0x4DD1,   /* U+4D24 */
  0x4DD1,   /* U+4D25 */
  0x4DD3,   /* U+4D26 */
  0x4DD4,   /* U+4D27 */
  0x5C49,   /* U+4D28 */
  0x4DD7,   /* U+4D29 */
  0x4DD9,   /* U+4D2A */
  0x4DD9,   /* U+4D2B */
  0x4E0F,   /* U+4D2C */
  0x4E0F,   /* U+4D2D */
  0x4E0F,   /* U+4D2E */
  0x4E10,   /* U+4D2F */
  0x4E10,   /* U+4D30 */
  0x4E11,   /* U+4D31 */
  0x4E11,   /* U+4D32 */
  0x4E11,   /* U+4D33 */
  0x4E11,   /* U+4D34 */
  0x4E12,   /* U+4D35 */
  0x4E13,   /* U+4D36 */
  0x4E13,   /* U+4D37 */
  0x4E13,   /* U+4D38 */
  0x4E14,   /* U+4D39 */
  0x4E14,   /* U+4D3A */
  0x4E14,   /* U+4D3B */
  0x4E14,   /* U+4D3C */
  0x4E14,   /* U+4D3D */
  0x4E0D,   /* U+4D3E */
  0x4E0D,   /* U+4D3F */
  0x4E0D,   /* U+4D40 */
  0x4E17,   /* U+4D41 */
  0x4E17,   /* U+4D42 */
  0x4E18,   /* U+4D43 */
  0x4E19,   /* U+4D44 */
  0x4E17,   /* U+4D45 */
  0x4E1A,   /* U+4D46 */
  0x4E50,   /* U+4D47 */
  0x4E55,   /* U+4D48 */
  0x4E55,   /* U+4D49 */
  0x4E90,   /* U+4D4A */
  0x4E92,   /* U+4D4B */
  0x4E93,   /* U+4D4C */
  0x4E94,   /* U+4D4D */
  0x4E95,   /* U+4D4E */
  0x4E97,   /* U+4D4F */
  0x4E98,   /* U+4D50 */
  0x4ECF,   /* U+4D51 */
  0x4ED0,   /* U+4D52 */
  0x4ED0,   /* U+4D53 */
  0x4ED4,   /* U+4D54 */
  0x4ED4,   /* U+4D55 */
  0x4ED4,   /* U+4D56 */
  0x4ED5,   /* U+4D57 */
  0x4ED5,   /* U+4D58 */
  0x4ED5,   /* U+4D59 */
  0x4ECD,   /* U+4D5A */
  0x4ED7,   /* U+4D5B */
  0x4ED9,   /* U+4D5C */
  0x4F0D,   /* U+4D5D */
  0x4F0E,   /* U+4D5E */
  0x4F0F,   /* U+4D5F */
  0x4F0F,   /* U+4D60 */
  0x4F10,   /* U+4D61 */
  0x4F11,   /* U+4D62 */
  0x4F11,   /* U+4D63 */
  0x4F12,   /* U+4D64 */
  0x4F12,   /* U+4D65 */
  0x4F12,   /* U+4D66 */
  0x4F12,   /* U+4D67 */
  0x4F13,   /* U+4D68 */
  0x4F13,   /* U+4D69 */
  0x4F14,   /* U+4D6A */
  0x4F14,   /* U+4D6B */
  0x4F14,   /* U+4D6C */
  0x4F15,   /* U+4D6D */
  0x4F15,   /* U+4D6E */
  0x4F15,   /* U+4D6F */
  0x4F17,   /* U+4D70 */
  0x4F18,   /* U+4D71 */
  0x4F19,   /* U+4D72 */
  0x4F19,   /* U+4D73 */
  0x4F19,   /* U+4D74 */
  0x4F1A,   /* U+4D75 */
  0x4F91,   /* U+4D76 */
  0x4F92,   /* U+4D77 */
  0x4F95,   /* U+4D78 */
  0x4F97,   /* U+4D79 */
  0x4FCF,   /* U+4D7A */
  0x4FD7,   /* U+4D7B */
  0x4FD7,   /* U+4D7C */
  0x5011,   /* U+4D7D */
  0x5011,   /* U+4D7E */
  0x5011,   /* U+4D7F */
  0x5012,   /* U+4D80 */
  0x5014,   /* U+4D81 */
  0x504F,   /* U+4D82 */
  0x5050,   /* U+4D83 */
  0x5051,   /* U+4D84 */
  0x5052,   /* U+4D85 */
  0x5054,   /* U+4D86 */
  0x5055,   /* U+4D87 */
  0x504D,   /* U+4D88 */
  0x504D,   /* U+4D89 */
  0x5090,   /* U+4D8A */
  0x5090,   /* U+4D8B */
  0x5091,   /* U+4D8C */
  0x5092,   /* U+4D8D */
  0x5092,   /* U+4D8E */
  0x5093,   /* U+4D8F */
  0x5099,   /* U+4D90 */
  0x509C,   /* U+4D91 */
  0x50CF,   /* U+4D92 */
  0x50CF,   /* U+4D93 */
  0x510F,   /* U+4D94 */
  0x5110,   /* U+4D95 */
  0x5110,   /* U+4D96 */
  0x5111,   /* U+4D97 */
  0x5111,   /* U+4D98 */
  0x5111,   /* U+4D99 */
  0x5112,   /* U+4D9A */
  0x5112,   /* U+4D9B */
  0x5113,   /* U+4D9C */
  0x5113,   /* U+4D9D */
  0x5114,   /* U+4D9E */
  0x5114,   /* U+4D9F */
  0x5115,   /* U+4DA0 */
  0x5115,   /* U+4DA1 */
  0x5115,   /* U+4DA2 */
  0x510D,   /* U+4DA3 */
  0x510D,   /* U+4DA4 */
  0x5117,   /* U+4DA5 */
  0x5117,   /* U+4DA6 */
  0x5118,   /* U+4DA7 */
  0x5119,   /* U+4DA8 */
  0x511A,   /* U+4DA9 */
  0x511A,   /* U+4DAA */
  0x510E,   /* U+4DAB */
  0x5152,   /* U+4DAC */
  0x5150,   /* U+4DAD */
  0x5150,   /* U+4DAE */
  0x518F,   /* U+4DAF */
  0x5190,   /* U+4DB0 */
  0x5191,   /* U+4DB1 */
  0x5191,   /* U+4DB2 */
  0x51D0,   /* U+4DB3 */
  0x51D4,   /* U+4DB4 */
  0x51CD,   /* U+4DB5 */
  0xFBC0,   /* U+4DB6 */
  0xFBC0,   /* U+4DB7 */
  0xFBC0,   /* U+4DB8 */
  0xFBC0,   /* U+4DB9 */
  0xFBC0,   /* U+4DBA */
  0xFBC0,   /* U+4DBB */
  0xFBC0,   /* U+4DBC */
  0xFBC0,   /* U+4DBD */
  0xFBC0,   /* U+4DBE */
  0xFBC0,   /* U+4DBF */
  0x0EAA,   /* U+4DC0 */
  0x0EAB,   /* U+4DC1 */
  0x0EAC,   /* U+4DC2 */
  0x0EAD,   /* U+4DC3 */
  0x0EAE,   /* U+4DC4 */
  0x0EAF,   /* U+4DC5 */
  0x0EB0,   /* U+4DC6 */
  0x0EB1,   /* U+4DC7 */
  0x0EB2,   /* U+4DC8 */
  0x0EB3,   /* U+4DC9 */
  0x0EB4,   /* U+4DCA */
  0x0EB5,   /* U+4DCB */
  0x0EB6,   /* U+4DCC */
  0x0EB7,   /* U+4DCD */
  0x0EB8,   /* U+4DCE */
  0x0EB9,   /* U+4DCF */
  0x0EBA,   /* U+4DD0 */
  0x0EBB,   /* U+4DD1 */
  0x0EBC,   /* U+4DD2 */
  0x0EBD,   /* U+4DD3 */
  0x0EBE,   /* U+4DD4 */
  0x0EBF,   /* U+4DD5 */
  0x0EC0,   /* U+4DD6 */
  0x0EC1,   /* U+4DD7 */
  0x0EC2,   /* U+4DD8 */
  0x0EC3,   /* U+4DD9 */
  0x0EC4,   /* U+4DDA */
  0x0EC5,   /* U+4DDB */
  0x0EC6,   /* U+4DDC */
  0x0EC7,   /* U+4DDD */
  0x0EC8,   /* U+4DDE */
  0x0EC9,   /* U+4DDF */
  0x0ECA,   /* U+4DE0 */
  0x0ECB,   /* U+4DE1 */
  0x0ECC,   /* U+4DE2 */
  0x0ECD,   /* U+4DE3 */
  0x0ECE,   /* U+4DE4 */
  0x0ECF,   /* U+4DE5 */
  0x0ED0,   /* U+4DE6 */
  0x0ED1,   /* U+4DE7 */
  0x0ED2,   /* U+4DE8 */
  0x0ED3,   /* U+4DE9 */
  0x0ED4,   /* U+4DEA */
  0x0ED5,   /* U+4DEB */
  0x0ED6,   /* U+4DEC */
  0x0ED7,   /* U+4DED */
  0x0ED8,   /* U+4DEE */
  0x0ED9,   /* U+4DEF */
  0x0EDA,   /* U+4DF0 */
  0x0EDB,   /* U+4DF1 */
  0x0EDC,   /* U+4DF2 */
  0x0EDD,   /* U+4DF3 */
  0x0EDE,   /* U+4DF4 */
  0x0EDF,   /* U+4DF5 */
  0x0EE0,   /* U+4DF6 */
  0x0EE1,   /* U+4DF7 */
  0x0EE2,   /* U+4DF8 */
  0x0EE3,   /* U+4DF9 */
  0x0EE4,   /* U+4DFA */
  0x0EE5,   /* U+4DFB */
  0x0EE6,   /* U+4DFC */
  0x0EE7,   /* U+4DFD */
  0x0EE8,   /* U+4DFE */
  0x0EE9,   /* U+4DFF */

  /* Secondary weight 1 for each character. */
  0x0020,   /* U+4D00 */
  0x0020,   /* U+4D01 */
  0x0020,   /* U+4D02 */
  0x0020,   /* U+4D03 */
  0x0020,   /* U+4D04 */
  0x0020,   /* U+4D05 */
  0x0020,   /* U+4D06 */
  0x0020,   /* U+4D07 */
  0x0020,   /* U+4D08 */
  0x0020,   /* U+4D09 */
  0x0020,   /* U+4D0A */
  0x0020,   /* U+4D0B */
  0x0020,   /* U+4D0C */
  0x0020,   /* U+4D0D */
  0x0020,   /* U+4D0E */
  0x0020,   /* U+4D0F */
  0x0020,   /* U+4D10 */
  0x0020,   /* U+4D11 */
  0x0020,   /* U+4D12 */
  0x0020,   /* U+4D13 */
  0x0020,   /* U+4D14 */
  0x0020,   /* U+4D15 */
  0x0020,   /* U+4D16 */
  0x0020,   /* U+4D17 */
  0x0020,   /* U+4D18 */
  0x0020,   /* U+4D19 */
  0x0020,   /* U+4D1A */
  0x0020,   /* U+4D1B */
  0x0020,   /* U+4D1C */
  0x0020,   /* U+4D1D */
  0x0020,   /* U+4D1E */
  0x0020,   /* U+4D1F */
  0x0020,   /* U+4D20 */
  0x0020,   /* U+4D21 */
  0x0020,   /* U+4D22 */
  0x0020,   /* U+4D23 */
  0x0020,   /* U+4D24 */
  0x0020,   /* U+4D25 */
  0x0020,   /* U+4D26 */
  0x0020,   /* U+4D27 */
  0x0020,   /* U+4D28 */
  0x0020,   /* U+4D29 */
  0x0020,   /* U+4D2A */
  0x0020,   /* U+4D2B */
  0x0020,   /* U+4D2C */
  0x0020,   /* U+4D2D */
  0x0020,   /* U+4D2E */
  0x0020,   /* U+4D2F */
  0x0020,   /* U+4D30 */
  0x0020,   /* U+4D31 */
  0x0020,   /* U+4D32 */
  0x0020,   /* U+4D33 */
  0x0020,   /* U+4D34 */
  0x0020,   /* U+4D35 */
  0x0020,   /* U+4D36 */
  0x0020,   /* U+4D37 */
  0x0020,   /* U+4D38 */
  0x0020,   /* U+4D39 */
  0x0020,   /* U+4D3A */
  0x0020,   /* U+4D3B */
  0x0020,   /* U+4D3C */
  0x0020,   /* U+4D3D */
  0x0020,   /* U+4D3E */
  0x0020,   /* U+4D3F */
  0x0020,   /* U+4D40 */
  0x0020,   /* U+4D41 */
  0x0020,   /* U+4D42 */
  0x0020,   /* U+4D43 */
  0x0020,   /* U+4D44 */
  0x0020,   /* U+4D45 */
  0x0020,   /* U+4D46 */
  0x0020,   /* U+4D47 */
  0x0020,   /* U+4D48 */
  0x0020,   /* U+4D49 */
  0x0020,   /* U+4D4A */
  0x0020,   /* U+4D4B */
  0x0020,   /* U+4D4C */
  0x0020,   /* U+4D4D */
  0x0020,   /* U+4D4E */
  0x0020,   /* U+4D4F */
  0x0020,   /* U+4D50 */
  0x0020,   /* U+4D51 */
  0x0020,   /* U+4D52 */
  0x0020,   /* U+4D53 */
  0x0020,   /* U+4D54 */
  0x0020,   /* U+4D55 */
  0x0020,   /* U+4D56 */
  0x0020,   /* U+4D57 */
  0x0020,   /* U+4D58 */
  0x0020,   /* U+4D59 */
  0x0020,   /* U+4D5A */
  0x0020,   /* U+4D5B */
  0x0020,   /* U+4D5C */
  0x0020,   /* U+4D5D */
  0x0020,   /* U+4D5E */
  0x0020,   /* U+4D5F */
  0x0020,   /* U+4D60 */
  0x0020,   /* U+4D61 */
  0x0020,   /* U+4D62 */
  0x0020,   /* U+4D63 */
  0x0020,   /* U+4D64 */
  0x0020,   /* U+4D65 */
  0x0020,   /* U+4D66 */
  0x0020,   /* U+4D67 */
  0x0020,   /* U+4D68 */
  0x0020,   /* U+4D69 */
  0x0020,   /* U+4D6A */
  0x0020,   /* U+4D6B */
  0x0020,   /* U+4D6C */
  0x0020,   /* U+4D6D */
  0x0020,   /* U+4D6E */
  0x0020,   /* U+4D6F */
  0x0020,   /* U+4D70 */
  0x0020,   /* U+4D71 */
  0x0020,   /* U+4D72 */
  0x0020,   /* U+4D73 */
  0x0020,   /* U+4D74 */
  0x0020,   /* U+4D75 */
  0x0020,   /* U+4D76 */
  0x0020,   /* U+4D77 */
  0x0020,   /* U+4D78 */
  0x0020,   /* U+4D79 */
  0x0020,   /* U+4D7A */
  0x0020,   /* U+4D7B */
  0x0020,   /* U+4D7C */
  0