/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifdef OB_SYS_PRIV_TYPE_DEF
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_NONE, "")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_SESSION, "CREATE SESSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXEMPT_RED_PLY, "EXEMPT REDACTION POLICY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SYSDBA, "SYSDBA")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SYSOPER, "SYSOPER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SYSBACKUP, "SYSBACKUP")

/* table */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_TABLE, "CREATE TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_TABLE, "CREATE ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_TABLE, "ALTER ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_BACKUP_ANY_TABLE, "BACKUP ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_TABLE, "DROP ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_LOCK_ANY_TABLE, "LOCK ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_COMMENT_ANY_TABLE, "COMMENT ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SELECT_ANY_TABLE, "SELECT ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_INSERT_ANY_TABLE, "INSERT ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_UPDATE_ANY_TABLE, "UPDATE ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DELETE_ANY_TABLE, "DELETE ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_FLASHBACK_ANY_TABLE, "FLASHBACK ANY TABLE")

/* role */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ROLE, "CREATE ROLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_ROLE, "DROP ANY ROLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_GRANT_ANY_ROLE, "GRANT ANY ROLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_ROLE, "ALTER ANY ROLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_AUDIT_ANY, "AUDIT ANY")

/* privs */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_GRANT_ANY_PRIV, "GRANT ANY PRIVILEGE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_GRANT_ANY_OBJECT_PRIV, "GRANT ANY OBJECT PRIVILEGE")

/* index */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_INDEX, "CREATE ANY INDEX")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_INDEX, "ALTER ANY INDEX")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_INDEX, "DROP ANY INDEX")

/* view */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_VIEW, "CREATE ANY VIEW")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_VIEW, "DROP ANY VIEW")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_VIEW, "CREATE VIEW")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SELECT_ANY_DICTIONARY, "SELECT ANY DICTIONARY")

/* procedure */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_PROC, "CREATE PROCEDURE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_PROC, "CREATE ANY PROCEDURE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_PROC, "ALTER ANY PROCEDURE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_PROC, "DROP ANY PROCEDURE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXEC_ANY_PROC, "EXECUTE ANY PROCEDURE")

/* synonym*/
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_SYN, "CREATE SYNONYM")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_SYN, "CREATE ANY SYNONYM")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_SYN, "DROP ANY SYNONYM")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_PUB_SYN, "CREATE PUBLIC SYNONYM")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_PUB_SYN, "DROP PUBLIC SYNONYM")

/* sequence */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_SEQ, "CREATE SEQUENCE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_SEQ, "CREATE ANY SEQUENCE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_SEQ, "ALTER ANY SEQUENCE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_SEQ, "DROP ANY SEQUENCE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SELECT_ANY_SEQ, "SELECT ANY SEQUENCE")

/* trigger */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_TRIG, "CREATE TRIGGER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_TRIG, "CREATE ANY TRIGGER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_TRIG, "ALTER ANY TRIGGER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_TRIG, "DROP ANY TRIGGER")

/* profile */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_PROFILE, "CREATE PROFILE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_PROFILE, "ALTER PROFILE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_PROFILE, "DROP PROFILE")

/* user*/
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_USER, "CREATE USER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_BECOME_USER, "BECOME USER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_USER, "ALTER USER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_USER, "DROP USER")

/* type */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_TYPE, "CREATE TYPE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_TYPE, "CREATE ANY TYPE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_TYPE, "ALTER ANY TYPE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_TYPE, "DROP ANY TYPE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXEC_ANY_TYPE, "EXECUTE ANY TYPE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_UNDER_ANY_TYPE, "UNDER ANY TYPE")

/* RECYCLEBIN */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_PURGE_DBA_RECYCLEBIN, "PURGE DBA_RECYCLEBIN")

/* outline */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_OUTLINE, "CREATE ANY OUTLINE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_OUTLINE, "ALTER ANY OUTLINE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_OUTLINE, "DROP ANY OUTLINE")

/* syskm */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SYSKM, "SYSKM")

/* tablespace */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_TABLESPACE, "CREATE TABLESPACE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_TABLESPACE, "ALTER TABLESPACE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_TABLESPACE, "DROP TABLESPACE")

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SHOW_PROCESS, "SHOW PROCESS")

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_SYSTEM, "ALTER SYSTEM")

/* dblink */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_DBLINK, "CREATE DATABASE LINK")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_PUBLIC_DBLINK, "CREATE PUBLIC DATABASE LINK")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_DBLINK, "DROP DATABASE LINK")

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_SESSION, "ALTER SESSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_DATABASE, "ALTER DATABASE")

/* directory */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_DIRECTORY, "CREATE ANY DIRECTORY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_DIRECTORY, "DROP ANY DIRECTORY")

/* debug priv */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DEBUG_CONN_SESSION, "DEBUG CONNECT SESSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DEBUG_ANY_PROC, "DEBUG ANY PROCEDURE")

/* context */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_CONTEXT, "CREATE ANY CONTEXT")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_CONTEXT, "DROP ANY CONTEXT")

/* vpd */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXEMPT_ACCESS_POLICY, "EXEMPT ACCESS POLICY")

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_MAX, "")
#endif

/* to do*/
#ifdef asfasgasgfa

/* context */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_CONTEXT, "CREATE ANY CONTEXT")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_CONTEXT, "DROP ANY CONTEXT")

/* administer */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ADMIN_ANY_SQL_TUNING_SET, "ADMINISTER ANY SQL TUNING SET")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ADMIN_DB_TRIG, "ADMINISTER DATABASE TRIGGER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ADMIN_RESOURCE_MANAGER, "ADMINISTER RESOURCE MANAGER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ADMIN_SQL_MANAGEMENT_OBJECT, "ADMINISTER SQL MANAGEMENT OBJECT")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ADMIN_SQL_TUNING_SET, "ADMINISTER SQL TUNING SET")

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ADVISOR, "ADVISOR")

/* ANALYTIC VIEW */

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_ANALYTIC_VIEW, "CREATE ANY ANALYTIC VIEW")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_ANALYTIC_VIEW, "ALTER ANY ANALYTIC VIEW")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_ANALYTIC_VIEW, "DROP ANY ANALYTIC VIEW")

/* ASSEMBLY */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ASSEMBLY, "CREATE ASSEMBLY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_ASSEMBLY, "CREATE ANY ASSEMBLY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_ASSEMBLY, "ALTER ANY ASSEMBLY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_ASSEMBLY, "DROP ANY ASSEMBLY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXECTE_ANY_ASSEMBLY, "EXECUTE ANY ASSEMBLY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXECUTE_ASSEMBLY, "EXECUTE ASSEMBLY")

/* ATTRIBUTE DIMENSION */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ATTR_DIMENSION, "CREATE ATTRIBUTE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_ATTR_DIMENSION, "CREATE ANY ATTRIBUTE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_ATTR_DIMENSION, "ALTER ANY ATTRIBUTE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_ATTR_DIMENSION, "DROP ANY ATTRIBUTE DIMENSION")

/* CLUSTER */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_CLUSTER, "CREATE CLUSTER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_CLUSTER, "CREATE ANY CLUSTER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_CLUSTER, "ALTER ANY CLUSTER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_CLUSTER, "DROP ANY CLUSTER")

/* CUBE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_CUBE, "CREATE CUBE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_CUBE, "CREATE ANY CUBE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_CUBE, "ALTER ANY CUBE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_CUBE, "DROP ANY CUBE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SELECT_ANY_CUBE, "SELECT ANY CUBE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_UPDATE_ANY_CUBE, "UPDATE ANY CUBE")

/* CUBE BUILD PROCESS */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_CUBE_BUILD_PROCESS, "CREATE CUBE BUILD PROCESS")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_CUBE_BUILD_PROCESS, "CREATE ANY CUBE BUILD PROCESS")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_CUBE_BUILD_PROCESS, "ALTER ANY CUBE BUILD PROCESS")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_CUBE_BUILD_PROCESS, "DROP ANY CUBE BUILD PROCESS")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SELECT_ANY_CUBE_BUILD_PROCESS, "SELECT ANY CUBE BUILD PROCESS")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_UPDATE_ANY_CUBE_BUILD_PROCESS, "UPDATE ANY CUBE BUILD PROCESS")

/* CUBE DIMENSION */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_CUBE_DIMENSION, "CREATE CUBE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_CUBE_DIMENSION, "CREATE ANY CUBE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_CUBE_DIMENSION, "ALTER ANY CUBE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_CUBE_DIMENSION, "DROP ANY CUBE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SELECT_ANY_CUBE_DIMENSION, "SELECT ANY CUBE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_UPDATE_ANY_CUBE_DIMENSION, "UPDATE ANY CUBE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DELETE_ANY_CUBE_DIMENSION, "DELETE ANY CUBE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_INSERT_ANY_CUBE_DIMENSION, "INSERT ANY CUBE DIMENSION")

/* DIMENSION */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_DIMENSION, "CREATE DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_DIMENSION, "CREATE ANY DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_DIMENSION, "ALTER ANY DIMENSION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_DIMENSION, "DROP ANY DIMENSION")

/* EDITION */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_EDITION, "CREATE ANY EDITION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_EDITION, "ALTER ANY EDITION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_EDITION, "DROP ANY EDITION")

/* EVALUATION CONTEXT */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_EVALUATION_CONTEXT, "CREATE EVALUATION CONTEXT")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_EVALUATION_CONTEXT, "CREATE ANY EVALUATION CONTEXT")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_EVALUATION_CONTEXT, "ALTER ANY ASSEVALUATION CONTEXT")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_EVALUATION_CONTEXT, "DROP ANY EVALUATION CONTEXT")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXECTE_ANY_EVALUATION_CONTEXT, "EXECUTE ANY EVALUATION CONTEXT")

/* HIERARCHY */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_HIERARCHY, "CREATE HIERARCHY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_HIERARCHY, "CREATE ANY HIERARCHY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_HIERARCHY, "ALTER ANY HIERARCHY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_HIERARCHY, "DROP ANY HIERARCHY")

/* INDEXTYPE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_INDEXTYPE, "CREATE INDEXTYPE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_INDEXTYPE, "CREATE ANY INDEXTYPE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_INDEXTYPE, "ALTER ANY INDEXTYPE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_INDEXTYPE, "DROP ANY INDEXTYPE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXECUTE_ANY_INDEXTYPE, "EXECUTE ANY INDEXTYPE")

/* LIBRARY */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_LIBRARY, "CREATE LIBRARY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_LIBRARY, "CREATE ANY LIBRARY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_LIBRARY, "ALTER ANY LIBRARY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_LIBRARY, "DROP ANY LIBRARY")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXECUTE_ANY_LIBRARY, "EXECUTE ANY LIBRARY")

/* MATERIALIZED VIEW */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_MVIEW, "CREATE MATERIALIZED VIEW")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_MVIEW, "CREATE ANY MATERIALIZED VIEW")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_MVIEW, "ALTER ANY MATERIALIZED VIEW")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_MVIEW, "DROP ANY MATERIALIZED VIEW")

/* MEASURE FOLDER */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_MEASURE_FOLDER, "CREATE MEASURE FOLDER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_MEASURE_FOLDER, "CREATE ANY MEASURE FOLDER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_MEASURE_FOLDER, "ALTER ANY MEASURE FOLDER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_MEASURE_FOLDER, "DROP ANY MEASURE FOLDER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DELETE_ANY_MEASURE_FOLDER, "DELETE ANY MEASURE FOLDER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_INSERT_ANY_MEASURE_FOLDER, "INSERT ANY MEASURE FOLDER")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SELECT_ANY_MEASURE_FOLDER, "SELECT ANY MEASURE FOLDER")

/* MINING MODEL */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_MINING_MODEL, "CREATE MINING MODEL")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_MINING_MODEL, "CREATE ANY MINING MODEL")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_MINING_MODEL, "ALTER ANY MINING MODEL")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_MINING_MODEL, "DROP ANY MINING MODEL")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SELECT_ANY_MINING_MODEL, "SELECT ANY MINING MODEL")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_COMMENT_ANY_MINING_MODEL, "COMMENT ANY MINING MODEL")

/* OPERATOR */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_OPERATOR, "CREATE OPERATOR")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_OPERATOR, "CREATE ANY OPERATOR")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_OPERATOR, "ALTER ANY OPERATOR")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_OPERATOR, "DROP ANY OPERATOR")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXECUTE_ANY_OPERATOR, "EXECUTE ANY OPERATOR")


/* RULE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_RULE, "CREATE RULE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_RULE, "CREATE ANY RULE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_RULE, "ALTER ANY RULE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_RULE, "DROP ANY RULE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXECUTE_ANY_RULE, "EXECUTE ANY RULE")

/* RULE SET */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_RULE_SET, "CREATE RULE SET")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_RULE_SET, "CREATE ANY RULE SET")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_RULE_SET, "ALTER ANY RULE SET")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_RULE_SET, "DROP ANY RULE SET")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXECUTE_ANY_RULE_SET, "EXECUTE ANY RULE SET")

/* SQL PROFILE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_SQL_PROFILE, "CREATE ANY SQL PROFILE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_SQL_PROFILE, "ALTER ANY SQL PROFILE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_SQL_PROFILE, "DROP ANY SQL PROFILE")

/* SQL TRANSLATION PROFILE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_SQL_TRX_PROFILE, "CREATE SQL TRANSLATION PROFILE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_CREATE_ANY_SQL_TRX_PROFILE, "CREATE ANY SQL TRANSLATION PROFILE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ALTER_ANY_SQL_TRX_PROFILE, "ALTER ANY SQL TRANSLATION PROFILE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_DROP_ANY_SQL_TRX_PROFILE, "DROP ANY SQL TRANSLATION PROFILE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_USE_ANY_SQL_TRX_PROFILE, "USE ANY SQL TRANSLATION PROFILE")

/* TABLE-MORE*/
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_READ_ANY_TABLE, "READ ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_REDEFINE_ANY_TABLE, "REDEFINE ANY TABLE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_UNDER_ANY_TABLE, "UNDER ANY TABLE")

/* DATABASE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_EXPORT_FULL_DATABASE, "EXPORT FULL DATABASE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_IMPORT_FULL_DATABASE, "IMPORT FULL DATABASE")

/* ARCHIVE ADMIN */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_FLASHBACK_ARC_ADMIN, "FLASHBACK ARCHIVE ADMINISTER")

/* TRANSACTION */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_FORCE_ANY_TRANS, "FORCE ANY TRANSACTION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_FORCE_TRANS, "FORCE TRANSACTION")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SELECT_ANY_TRANS, "SELECT ANY TRANSACTION")


/* QUERY REWRITE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_GLOBAL_QUERY_REWRITE, "GLOBAL QUERY REWRITE")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_QUERY_REWRITE, "QUERY REWRITE")

/* LOGMINING */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_LOGMINING, "LOGMINING")

/* FILE GROUP */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_MANAGE_ANY_FILEGROUP, "MANAGE ANY FILE GROUP")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_MANAGE_FILEGROUP, "MANAGE FILE GROUP")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_READ_ANY_FILEGROUP, "READ ANY FILE GROUP")

/* QUEUE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_MANAGE_ANY_QUEUE, "MANAGE ANY QUEUE")

/* SCHEDULER */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_MANAGE_SCHEDULER, "MANAGE SCHEDULER")

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_MANAGE_TABLESPACE, "MANAGE TABLESPACE")

/* VIEW-MORE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_MERGE_ANY_VIEW, "MERGE ANY VIEW")
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_UNDER_ANY_VIEW, "UNDER ANY VIEW")

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_ON_COMMIT_REFRESH, "ON COMMIT REFRESH")

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_RESTRICTED_SESSION, "RESTRICTED SESSION")

OB_SYS_PRIV_TYPE_DEF(PRIV_ID_RESUMABLE, "RESUMABLE")

/* CONTAINER */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_SET_CONTAINER, "SET CONTAINER")

/* JOB RESOURCE */
OB_SYS_PRIV_TYPE_DEF(PRIV_ID_USE_ANY_JOB_RESOURCE, "USE ANY JOB RESOURCE")

#endif

#ifndef OCEANBASE_SHARE_SCHEMA_OB_SYS_PRIV_TYPE_
#define OCEANBASE_SHARE_SCHEMA_OB_SYS_PRIV_TYPE_

enum OB_RAW_SYS_PRIV_ID 
{
#define OB_SYS_PRIV_TYPE_DEF(priv_id, priv_name) priv_id,
#include "share/schema/ob_sys_priv_type.h"
#undef OB_SYS_PRIV_TYPE_DEF

};

#endif /* OB_SYS_PRIV_TYPE_ */
