USE mysql;

DELETE FROM  help_topic;
DELETE FROM  help_category;
DELETE FROM  help_keyword;
DELETE FROM  help_relation;

start transaction;

INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (1, 'Contents',  0 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (2, 'Data Types', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (3, 'Functions', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (4, 'Operator', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (5, 'Escape character', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (6, 'Data Definition', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (7, 'Data Manipulation', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (8, 'Transaction Statements', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (9, 'Prepared Statements', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (10, 'Compound Statements', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (11, 'Administration', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (12, 'Utility', 1 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (21, 'Numeric Types', 2 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (22, 'Date and Time Types', 2 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (23, 'String Types', 2 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (24, 'Bool Types', 2 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (31, 'Date and Time Functions', 3 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (32, 'String Functions', 3 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (33, 'GROUP BY (Aggregate) Functions', 3 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (34, 'Cast Functions', 3 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (35, 'Mathematical Functions', 3 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (39, 'Information Functions', 3 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (36, 'Other Functions', 3 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (38, 'Control Flow Functions', 3 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (37, 'Comparison Functions', 3 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (41, 'Logical Operators', 4 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (42, 'Comparison Operators', 4 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (43, 'Arithmetic Operators', 4 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (44, 'Vector Comparison Operators', 4 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (45, 'Splicing Operator', 4 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (46, 'Operator Precedence', 4 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (47, 'Bit Operators', 4 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (101, 'Flow Control Statements', 10 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (111, 'Account Management', 11 , '');
INSERT INTO help_category (help_category_id,name,parent_category_id,url) VALUES (112, 'Other Management', 11 , '');


INSERT INTO help_keyword (help_keyword_id,name) VALUES (1, 'TINYINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (2, 'BOOL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (3, 'SMALLINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (4, 'MEDIUMINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (5, 'INT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (6, 'INTEGER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (7, 'BIGINT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (8, 'FLOAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (9, 'DOUBLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (10, 'DOUBLE PRECISION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (11, 'FLOAT(p)');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (12, 'DECIMAL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (13, 'NUMERIC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (14, 'CHAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (15, 'VARCHAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (16, 'BINARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (17, 'DATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (18, 'DATETIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (19, 'TIMESTAMP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (20, 'TIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (21, 'YEAR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (22, 'CURRENT_TIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (23, 'CURTIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (24, 'CURRENT_TIMESTAMP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (25, 'CURRENT_DATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (26, 'CURDATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (27, 'DATE_ADD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (28, 'DATE_FORMAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (29, 'DATE_SUB');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (30, 'EXTRACT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (31, 'NOW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (32, 'STR_TO_DATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (33, 'TIME_TO_USEC');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (34, 'USEC_TO_TIME');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (35, 'UNIX_TIMESTAMP ');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (36, 'DATEDIFF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (37, 'TIMEDIFF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (38, 'TIMESTAMPDIFF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (39, 'PERIOD_DIFF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (40, 'CONCAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (41, 'SUBSTRING');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (42, 'SUBSTR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (43, 'TRIM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (44, 'LENGTH');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (45, 'UPPER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (46, 'LOWER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (47, 'HEX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (48, 'UNHEX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (49, 'INT2IP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (50, 'IP2INT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (51, 'LIKE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (52, 'REGEXP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (53, 'REPEAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (54, 'SUBSTRING_INDEX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (55, 'LOCATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (56, 'INSTR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (57, 'REPLACE()');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (58, 'FIELD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (59, 'ELT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (60, 'CAST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (61, 'AVG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (62, 'COUNT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (63, 'MAX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (64, 'MIN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (65, 'SUM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (66, 'GROUP_CONCAT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (67, 'ROUND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (68, 'CEIL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (69, 'FLOOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (70, 'ABS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (71, 'NEG');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (72, 'SIGN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (73, 'CONV');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (74, 'MOD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (75, 'GREATEST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (76, 'LEAST');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (77, 'ISNULL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (78, 'CASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (79, 'IF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (80, 'IFNULL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (81, 'NULLIF');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (82, 'FOUND_ROWS');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (83, 'LAST_INSERT_ID');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (84, 'COALESCE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (85, 'NVL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (86, 'Logical Operators');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (87, 'NOT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (88, 'AND');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (89, 'OR ');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (90, 'XOR');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (91, 'Arithmetic Operators');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (92, '+');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (93, '-');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (94, '*');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (95, '/');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (96, '%');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (97, '^');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (98, 'Comparison Operators');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (99, '=');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (100, '>=');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (101, '>');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (102, '<=');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (103, '<');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (104, '!=');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (105, 'BETWEEN … AND …');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (106, 'IN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (107, 'IS [NOT] NULL | TRUE | FALSE | UNKNOWN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (108, 'Vector Comparison Operators');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (109, 'Bit Operators');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (110, 'Operator Precedence');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (111, 'CREATE DATABASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (112, 'ALTER DATABASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (113, 'DROP DATABASE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (114, 'CREATE TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (115, 'ALTER TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (116, 'DROP TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (117, 'CREATE INDEX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (118, 'DROP INDEX');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (119, 'CREATE VIEW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (120, 'DROP VIEW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (121, 'ALTER VIEW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (122, 'TRUNCATE TABLE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (123, 'INSERT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (124, 'REPLACE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (125, 'UPDATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (126, 'DELETE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (127, 'SELECT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (128, 'TRANSACTION');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (129, 'CREATE RESOURCE UNIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (130, 'DROP RESOURCE UNIT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (131, 'CREATE RESOURCE POOL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (132, 'ALTER RESOURCE POOL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (133, 'DROP RESOURCE POOL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (134, 'CREATE TENANT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (135, 'ALTER TENANT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (136, 'LOCK');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (137, 'DROP TENANT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (138, 'CREATE TABLEGROUP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (139, 'DROP TABLEGROUP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (140, 'ALTER TABLEGROUP');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (141, 'CREATE USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (142, 'DROP USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (143, 'SET PASSWORD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (144, 'RENAME USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (145, 'ALTER USER');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (146, 'GRANT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (147, 'REVOKE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (148, 'SET');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (149, 'ALTER SYSTEM');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (150, 'PREPARE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (151, 'EXECUTE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (152, 'DEALLOCATE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (153, 'SHOW');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (154, 'KILL');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (155, 'DESCRIBE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (156, 'USE');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (157, 'SET TENANT');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (158, 'BOOLEAN');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (159, 'VARBINARY');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (160, 'MOD');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (161, '<>');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (162, '!');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (163, '&&');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (164, '||');
INSERT INTO help_keyword (help_keyword_id,name) VALUES (165, 'UNLOCK');



INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (1,21,  'TINYINT' , '  \n  TINYINT[(M)] [UNSIGNED] [ZEROFILL]\n\n  很小的整数。带符号的范围是-128到127。无符号的范围是0到255。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (2,21,  'BOOL,BOOLEAN' , '  \n  是TINYINT(1)的同义词。zero值被视为假。非zero值视为真。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (3,21,  'SMALLINT' , '  \n  SMALLINT[(M)] [UNSIGNED] [ZEROFILL]\n\n  小的整数。带符号的范围是-32768到32767。无符号的范围是0到65535。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (4,21,  'MEDIUMINT' , '  \n  MEDIUMINT[(M)] [UNSIGNED] [ZEROFILL]\n\n  中等大小的整数。带符号的范围是-8388608到8388607。无符号的范围是0到16777215。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (5,21,  'INT' , '  \n  INT[(M)] [UNSIGNED] [ZEROFILL]\n\n  普通大小的整数。带符号的范围是-2147483648到2147483647。无符号的范围是0到4294967295。\n\n  将非法的int值插入表之前自动改为0。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (6,21,  'INTEGER' , '  \n  INTEGER[(M)] [UNSIGNED] [ZEROFILL]\n\n  这是INT的同义词。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (7,21,  'BIGINT' , '  \n  BIGINT[(M)] [UNSIGNED] [ZEROFILL]\n\n  大整数。带符号的范围是-9223372036854775808到9223372036854775807。无符号的范围是0到18446744073709551615。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (8,21,  'FLOAT' , '\n  FLOAT[(M,D)] [UNSIGNED] [ZEROFILL]\n\n  小(单精度)浮点数。允许的值范围为-2^128 ~ +2^128，也即-3.402823466E+38到-1.175494351E-38、0和1.175494351E-38到3.402823466E+38。这些是理论限制，基于IEEE标准。实际的范围根据硬件或操作系统的不同可能稍微小些。\n\n  M是小数总位数，D是小数点后面的位数。如果M和D被省略，根据硬件允许的限制来保存值。单精度浮点数精确到大约7位小数位。\n\n  如果指定UNSIGNED，不允许负值。\n\n  使用浮点数可能会遇到意想不到的问题，因为在所有计算用双精度完成。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (9,21,  'DOUBLE' , '  \n  DOUBLE[(M,D)] [UNSIGNED] [ZEROFILL]\n\n  普通大小(双精度)浮点数。允许的值范围为：-2^1024 ~ +2^1024，也即是-1.7976931348623157E+308到-2.2250738585072014E-308、0和2.2250738585072014E-308到 1.7976931348623157E+308。这些是理论限制，基于IEEE标准。实际的范围根据硬件或操作系统的不同可能稍微小些。\nM是小数总位数，D是小数点后面的位数。如果M和D被省略，根据硬件允许的限制来保存值。双精度浮点数精确到大约15位小数位。\n\n  如果指定UNSIGNED，不允许负值。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (10,21,  'DOUBLE PRECISION' , '  \n  DOUBLE PRECISION [(M,D)] [UNSIGNED] [ZEROFILL], REAL[(M,D)] [UNSIGNED] [ZEROFILL]\n  为DOUBLE的同义词。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (11,21,  'FLOAT(p)' , '   \n  FLOAT(p) [UNSIGNED] [ZEROFILL]\n  \n  浮点数。p表示精度（以位数表示），只使用该值来确定是否结果列的数据类型为FLOAT或DOUBLE。如果p为从0到24，数据类型变为没有M或D值的FLOAT。如果p为从25到53，数据类型变为没有M或D值的DOUBLE。结果列范围与单精度FLOAT或双精度DOUBLE数据类型相同。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (12,21,  'DECIMAL' , '\n  DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]\n\n  压缩的“严格”定点数。M是小数位数(精度)的总数，D是小数点(标度)后面的位数。小数点和(负数)的‘-’符号不包括在M中。如果D是0，则值没有小数点或分数部分。DECIMAL整数最大位数(M)为90。支持的十进制数的最大位数(D)是45。如果D被省略， 默认是0。如果M被省略， 默认是10。\n\n  如果指定UNSIGNED，不允许负值。\n\n  所有DECIMAL列的基本计算(+，-，*，/)用65位精度完成。\n\n  DEC[(M[,D])] [UNSIGNED] [ZEROFILL], NUMERIC[(M[,D])] [UNSIGNED] [ZEROFILL]是DECIMAL的同义词。FIXED同义词适用于与其它服务器的兼容性。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (13,21,  'NUMERIC' , '\n  NUMERIC[(M[,D])] [UNSIGNED] [ZEROFILL]是DECIMAL的同义词。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (14,23,  'CHAR' , '\n  CHAR是CHARACTER的简写。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (15,23,  'VARCHAR' , '\n  [NATIONAL] VARCHAR(M) [BINARY]\n\n  变长字符串。M 表示最大列长度。 VARCHAR的最大实际长度由最长的行的大小和使用的字符集确定。最大有效长度是256K（262,144字节）。假设系统使用UTF8MB4字符集，每个字符占用4字节，M最大值为：（1024*256）/4 = 65536 (字符)。则M的范围是0到65536。\n\n  VARCHAR是字符CHAR VARYING的简写。\n\n  varchar类型最大长度限制：\n\n  a) 建表的时候，检查varchar型主键长度之和小于等于16K，且总长度小于1.5M，否则报错\n\n  b) 建立索引的时候，索引表中varchar类型主键之和小于等于16K，且总长度小于1.5M，否则不允许建立索引\n\n  c) 单个varchar列长度小于256K\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (16,23,  'BINARY/VARBINARY' , '\n  BINARY和VARBINARY类类似于CHAR和VARCHAR，不同的是它们包含二进制字符串而不要非二进制字符串。也就是说，它们包含字节字符串而不是字符字符串。这说明它们没有字符集，并且排序和比较基于列值字节的数值值。\n\n  BINARY和VARBINARY允许的最大长度一样，如同CHAR和VARCHAR，不同的是BINARY和VARBINARY的长度是字节长度而不是字符长度。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (17,22,  'DATE' , '\n  日期。\n\n  支持的范围为\'1000-01-01\'到\'9999-12-31\'。以\'YYYY-MM-DD\'格式显示DATE值，但允许使用字符串或数字为DATE列分配值。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (18,22,  'DATETIME' , '\n  DATETIME[(fsp)]\n\n  日期和时间的组合。支持的范围是‘1000-01-01 00:00:00.000000\'到‘9999-12-31 23:59:59.000000\'。以‘YYYY-MM-DD HH:MM:SS[.fraction] \'格式显示DATETIME值，但允许使用字符串或数字为DATETIME列分配值。fsp参数是表示秒精度，取值范围为：0-6。默认值取0；最大值为6，表示精确到微妙。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (19,22,  'TIMESTAMP' , '\n  TIMESTAMP[(fsp)]\n\n  TIMESTAMP类型的格式是按严格模式来判断，不允许“0000-00-00 00:00:00”等非法值\n\n  下列字符串类型是不合法的：\n  ‘2012^12^32’\n  ‘20070523’\n  ‘070523’\n  ‘071332’ \n\n  下列整数类型同样是不合法的：\n  19830905\n  830905\n  071332\n\n  用DEFAULT CURRENT_TIMESTAMP和ON UPDATE CURRENT_TIMESTAMP子句，列为默认值使用当前的时间戳，并且自动更新。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (20,22,  'TIME' , '\n  TIME[(fsp)]\n\n  时间。范围是 \'-838:59:59.000000\'到\'838:59:59.000000\'。以‘HH:MM:SS[.fraction]’格式显示TIME值，但允许使用字符串或数字为TIME列分配值。fsp参数是表示秒精度，取值范围为：0-6。默认值取0；最大值为6，表示精确到微妙。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (21,22,  'YEAR' , '\n  两位或四位格式的年。\n\n  默认是四位格式。在四位格式中，允许的值是1901到2155和0000。在两位格式中，允许的值是70到69，表示从1970年到2069年。以YYYY 格式显示YEAR值，但允许使用字符串或数字为YEAR列分配值。\n\n  可以指定各种格式的YEAR值：\n\n  四位字符串，范围为\'1901\'到\'2155\'。\n\n  四位数字，范围为1901到2155。\n\n  两位字符串，范围为\'00\'到\'99\'。\'00\'到\'69\'和\'70\'到\'99\'范围的值被转换为2000到2069和1970到1999范围的YEAR值。\n\n  两位整数，范围为1到99。1到69和70到99范围的值被转换为2001到2069和1970到1999范围的YEAR值。请注意两位整数范围与两位字符串范围稍有不同，因为你不能直接将零指定为数字并将它解释为2000。你必须将它指定为一个字符串\'0\'或\'00\'或它被解释为0000。\n\n  函数返回的结果，其值适合YEAR上下文，例如NOW()。\n\n  非法YEAR值被转换为0000。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (22,31,  'CURRENT_TIME' , '\n  CURRENT_TIME()和CURRENT_TIMESTAMP()这两个函数用于获取系统当前时间，但返回格式有区别。\n\n  CURRENT_TIME()是取当前时间，但不包括日期，返回格式为“HH:MI:SS”。\n\n  CURRENT_TIMESTAMP()则取当前日期+时间，返回格式为“YYYY-MM-DD HH:MI:SS”。\n\n  current_time()和current_timestamp()可以传入0-6的数字参数，表示秒后的小数点精度。\n\n' , '\nroot@test 04:09:10>SELECT CURRENT_TIME(), CURRENT_TIMESTAMP();\n+----------------+---------------------+\n| CURRENT_TIME() | CURRENT_TIMESTAMP() |\n+----------------+---------------------+\n| 16:24:09       | 2014-10-31 16:24:09 |\n+----------------+---------------------+\n1 row in set (0.00 sec)\nroot@(none) 09:59:30>select CURRENT_TIME(1);\n#可以支持传入秒后的小数位精度参数\n+-----------------+\n| CURRENT_TIME(1) |\n+-----------------+\n| 09:59:32.4      |\n+-----------------+\n1 row in set (0.00 sec)\nroot@(none) 09:59:32>select CURRENT_TIME(7);\nERROR 1426 (42000): Too big precision 7 specified for column \'curtime\'. Maximum is 6.\n#传入的精度范围是0-6，否则报错，错误码1426 (42000)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (23,31,  'CURTIME' , '\n  CURTIME()是CURRENT_TIME(),CURRENT_TIME的同义词。\n\n' , '\nmysql> select curtime(), current_time(), current_time;\n+-----------+----------------+--------------+\n| curtime() | current_time() | current_time |\n+-----------+----------------+--------------+\n| 14:45:37  | 14:45:37       | 14:45:37     |\n+-----------+----------------+--------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (24,31,  'CURRENT_TIMESTAMP' , '\n  CURRENT_TIME()和CURRENT_TIMESTAMP()这两个函数用于获取系统当前时间，但返回格式有区别。\n\n  CURRENT_TIME()是取当前时间，但不包括日期，返回格式为“HH:MI:SS”。\n\n  CURRENT_TIMESTAMP()则取当前日期+时间，返回格式为“YYYY-MM-DD HH:MI:SS”。 \n\n  current_time()和current_timestamp()可以传入0-7的数字参数，表示秒后的小数点精度。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (25,31,  'CURRENT_DATE' , '  CURRENT_DATE()返回当前日期，以‘YYYY-MM-DD’或者 YYYYMMDD的形式显示。以何种形式显示取决于函数中的内容是字符串还是数值。' , '\nmysql> select current_date, current_date+5;\n+--------------+----------------+\n| current_date | current_date+5 |\n+--------------+----------------+\n| 2015-08-27   |       20150832 |\n+--------------+----------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (26,31,  'CURDATE' , '\n  CURDATE()是CURRENT_DATE(), CURRENT_DATE的同义词。\n\n' , '\nmysql> select curdate(), current_date(), current_date;\n+------------+----------------+--------------+\n| curdate()  | current_date() | current_date |\n+------------+----------------+--------------+\n| 2015-08-27 | 2015-08-27     | 2015-08-27   |\n+------------+----------------+--------------+\n1 row in set (0.00 sec)\n\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (27,31,  'DATE_ADD' , '\n  DATE_ADD(date, INTERVAL expr unit\n\n  这个函数用来执行时间的算术计算。将date值作为基数，对expr进行相加计算，expr的值允许为负数。DATE_ADD()计算时间值是否使用夏令时，由操作系统系统根据其内部配置和相应时区设定来决定。\n\n• date参数类型只能为Time类型(DATETIME, TIMESTAMP等)或者代表时间的一个字符串，不接受其它类型。\n\n• expr的值允许为负，对一个负值相加功能等同于对一个正值相减。允许系统函数的调用结果作为该参数，但是所有结果都将作为字符串结果。\n\n• unit为单位，支持MICROSECOND、SECOND、MINUTE、HOUR、DAY、WEEK、MONTH、QUARTER、YEAR、SECOND_MICROSECOND、MINUTE_MICROSECOND、MINUTE_SECOND、HOUR_MICROSECOND、HOUR_SECOND、HOUR_MINUTE、DAY_MICROSECOND、DAY_SECOND、DAY_MINUTE、DAY_HOUR和YEAR_MONTH。其中QUARTER代表季度。\n\n• unit为复合单位时，expr必须加单引号。\n\n' , '\n\nmysql> SELECT DATE_ADD(now(), INTERVAL 5 DAY),\nDATE_ADD(\'2014-01-10\', INTERVAL 5 MICROSECOND),\nDATE_ADD(\'2014-01-10\', INTERVAL 5 SECOND),\nDATE_ADD(\'2014-01-10\', INTERVAL 5 MINUTE),\nDATE_ADD(\'2014-01-10\', INTERVAL 5 HOUR),\nDATE_ADD(\'2014-01-10\', INTERVAL 5 DAY),\nDATE_ADD(\'2014-01-10\', INTERVAL 5 WEEK),\nDATE_ADD(\'2014-01-10\', INTERVAL 5 MONTH),\nDATE_ADD(\'2014-01-10\', INTERVAL 5 QUARTER),\nDATE_ADD(\'2014-01-10\', INTERVAL 5 YEAR),\nDATE_ADD(\'2014-01-10\', INTERVAL \'5.000005\' SECOND_MICROSECOND),\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05.000005\' MINUTE_MICROSECOND),\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05\' MINUTE_SECOND),\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05:05.000005\' HOUR_MICROSECOND),\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05:05\' HOUR_SECOND),\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05\' HOUR_MINUTE),\nDATE_ADD(\'2014-01-10\', INTERVAL \'01 05:05:05.000005\' DAY_MICROSECOND),\nDATE_ADD(\'2014-01-10\', INTERVAL \'01 05:05:05\' DAY_SECOND),\nDATE_ADD(\'2014-01-10\', INTERVAL \'01 05:05\' DAY_MINUTE),\nDATE_ADD(\'2014-01-10\', INTERVAL \'01 05\' DAY_HOUR),\nDATE_ADD(\'2014-01-10\', INTERVAL \'1-01\' YEAR_MONTH) \G\n*************************** 1. row ***************************\nDATE_ADD(now(), INTERVAL 5 DAY): 2014-02-22 10:58:26.056992\nDATE_ADD(\'2014-01-10\', INTERVAL 5 MICROSECOND): 2014-01-10 00:00:00.000005\nDATE_ADD(\'2014-01-10\', INTERVAL 5 SECOND): 2014-01-10 00:00:05\nDATE_ADD(\'2014-01-10\', INTERVAL 5 MINUTE): 2014-01-10 00:05:00\nDATE_ADD(\'2014-01-10\', INTERVAL 5 HOUR): 2014-01-10 05:00:00\nDATE_ADD(\'2014-01-10\', INTERVAL 5 DAY): 2014-01-15 00:00:00\nDATE_ADD(\'2014-01-10\', INTERVAL 5 WEEK): 2014-02-14 00:00:00\nDATE_ADD(\'2014-01-10\', INTERVAL 5 MONTH): 2014-06-10 00:00:00\nDATE_ADD(\'2014-01-10\', INTERVAL 5 QUARTER): 2015-04-10 00:00:00\nDATE_ADD(\'2014-01-10\', INTERVAL 5 YEAR): 2019-01-10 00:00:00\nDATE_ADD(\'2014-01-10\', INTERVAL \'5.000005\' SECOND_MICROSECOND): 2014-01-10 00:00:05.000005\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05.000005\' MINUTE_MICROSECOND): 2014-01-10 00:05:05.000005\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05\' MINUTE_SECOND): 2014-01-10 00:05:05\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05:05.000005\' HOUR_MICROSECOND): 2014-01-10 05:05:05.000005\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05:05\' HOUR_SECOND): 2014-01-10 05:05:05\nDATE_ADD(\'2014-01-10\', INTERVAL \'05:05\' HOUR_MINUTE): 2014-01-10 05:05:00\nDATE_ADD(\'2014-01-10\', INTERVAL \'01 05:05:05.000005\' DAY_MICROSECOND): 2014-01-11 05:05:05.000005\nDATE_ADD(\'2014-01-10\', INTERVAL \'01 05:05:05\' DAY_SECOND): 2014-01-11 05:05:05\nDATE_ADD(\'2014-01-10\', INTERVAL \'01 05:05\' DAY_MINUTE): 2014-01-11 05:05:00\nDATE_ADD(\'2014-01-10\', INTERVAL \'01 05\' DAY_HOUR): 2014-01-11 05:00:00\nDATE_ADD(\'2014-01-10\', INTERVAL \'1-01\' YEAR_MONTH): 2015-02-10 00:00:00\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (28,31,  'DATE_FORMAT' , '\n  DATE_FORMAT(date, format)\n\n  DATE_FORMAT()是STR_TO_DATE()的逆函数，DATE_FORMAT()接受一个时间值date，将其按format的格式格式化成一个时间字符串。\n\n• date参数给出了被格式化的时间值，date只接受time类型和时间字符串作为参数，其具体描述参考DATE_ADD()的date参数描述。\n\n' , '\nmysql> SELECT DATE_FORMAT(\'2014-01-01\', \'%Y-%M-%d\'),\nDATE_FORMAT(\'2014-01-01\', \'%X-%V\'),DATE_FORMAT(\'2014-01-01\', \'%U\') \G\n*************************** 1. row ***************************\nDATE_FORMAT(\'2014-01-01\', \'%Y-%M-%d\'): 2014-January-01\nDATE_FORMAT(\'2014-01-01\', \'%X-%V\'): 2013-52\nDATE_FORMAT(\'2014-01-01\', \'%U\'): 00\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (29,31,  'DATE_SUB' , '\n  DATE_SUB(date, INTERVAL expr unit)\n\n  对时间进行算数计算。将date作为基数，对expr进行相减计算，expr允许为负，结果相当于做取反做加法。\n\n' , '\nmysql> SELECT DATE_SUB(\'2014-01-10\', INTERVAL 5 HOUR),\nDATE_SUB(\'2014-01-10\', INTERVAL \'05:05:05.000005\' HOUR_MICROSECOND)\G;\n*************************** 1. row ***************************\nDATE_SUB(\'2014-01-10\', INTERVAL 5 HOUR): 2014-01-09 19:00:00\nDATE_SUB(\'2014-01-10\', INTERVAL \'05:05:05.000005\' HOUR_MICROSECOND): 2014-01-09 18:54:54.999995\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (30,31,  'EXTRACT' , '\n  EXTRACT(unit FROM date)\n\n  提取date表达式中被unit指定的时间组成单元的值。\n\n• EXTRACT函数返回的结果为BIGINT类型。\n\n• 对于MICROSECOND~YEAR这种Single unit，将直接返回对应的int值。\n\n• unit为WEEK返回的是date表达式中指定的日期在该年所对应的周数， 而OceanBase将一年的第一个星期日作为该年第一周的开始，如果某年的第一个星期日不是1月1日，那么该星期日之前的日期处于第0周。例如，2013年第一个星期日是1月6日，所以SELECT EXTRACT(WEEK FROM ‘2013-01-01’)返回的结果为0，而SELECT EXTRACT(WEEK FROM ‘2013-01-06’)返回的结果是1。\n\n• 对于SECOND_MICROSECOND这种combinative unit，OceanBase将各个值拼接在一起作为返回值。例如，SELECT EXTRACT(YEAR_MONTH FROM \'2012-03-09\')返回的结果将是“201203”。\n\n' , '\nmysql> SELECT EXTRACT(WEEK FROM \'2013-01-01\'), \nEXTRACT(WEEK FROM \'2013-01-06\'),  \nEXTRACT(YEAR_MONTH FROM \'2012-03-09\'), \nEXTRACT(DAY FROM NOW())\G;\n*************************** 1. row ***************************\nEXTRACT(WEEK FROM \'2013-01-01\'): 0\nEXTRACT(WEEK FROM \'2013-01-06\'): 1\nEXTRACT(YEAR_MONTH FROM \'2012-03-09\'): 201203\nEXTRACT(DAY FROM NOW()): 18\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (31,31,  'NOW' , '\n  NOW([fsp])\n\n  和CURRENT_TIMESTAMP()函数同义。用于获取系统当前时间，精确到秒，格式为“YYYY-MM-DD HH:MI:SS”。\n\n  now()函数的括号里可以传入0-6数字参数，表示秒后面的小数点精度，默认now()相当于now(0) 。\n\n' , '\nmysql> SELECT NOW();\n+----------------------------+\n| NOW()                      |\n+----------------------------+\n| 2014-02-17 11:46:15|\n+----------------------------+\n1 row in set (0.00 sec)\nroot@(none) 09:52:46>select now(0);\n+---------------------+\n| now(0)              |\n+---------------------+\n| 2014-11-03 09:55:01 |\n+---------------------+\n1 row in set (0.00 sec)\nroot@(none) 09:55:01>select now(1);\n+-----------------------+\n| now(1)                |\n+-----------------------+\n| 2014-11-03 09:55:04.2 |\n+-----------------------+\n1 row in set (0.00 sec)\nroot@(none) 09:55:04>select now(2);\n+------------------------+\n| now(2)                 |\n+------------------------+\n| 2014-11-03 09:55:06.57 |\n+------------------------+\n1 row in set (0.00 sec)\nroot@(none) 09:55:06>select now(3);\n+-------------------------+\n| now(3)                  |\n+-------------------------+\n| 2014-11-03 09:55:09.576 |\n+-------------------------+\n1 row in set (0.00 sec)\nroot@(none) 09:55:09>select now(7);\nERROR 1426 (42000): Too big precision 7 specified for column \'now\'. Maximum is 6.\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (32,31,  'STR_TO_DATE' , '\n  STR_TO_DATE(str,format)\n\n  STR_TO_DATE函数获取一个字符串 str 和一个格式字符串format。若格式字符串包含日期和时间部分，则 STR_TO_DATE()返回一个DATETIME值，若该字符串只包含日期部分或时间部分，则返回一个DATE或TIME值。\n\n• str所包含的日期、时间或日期时间值应该在format指示的格式中被给定。若 str 包含一个非法日期、时间或日期时间值，则 STR_TO_DATE()返回NULL。同时，一个非法值会引起警告。\n\n' , 'mysql> SELECT STR_TO_DATE(\'2014-Jan-1st 5:5:5 pm\', \'%Y-%b-%D %r\');\n+-----------------------------------------------------+\n| STR_TO_DATE(\'2014-Jan-1st 5:5:5 pm\', \'%Y-%b-%D %r\') |\n+-----------------------------------------------------+\n| 2014-01-01 17:05:05                                 |\n+-----------------------------------------------------+\n1 row in set (0.00 sec)\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (33,31,  'TIME_TO_USEC' , '\n  TIME_TO_USEC(date) \n\n  将OceanBase的内部时间类型转换成一个微秒数计数。表示date所指的时刻距离“1970-01-01 00:00:00”的微秒数，这是一个UTC时间，不带时区信息。\n\n• date为被计算的时刻，且这个时刻附带时区信息，而时区信息是用户当前系统设置的时区信息。该参数为TIMESTAMP类型或者时间格式的字符串。\n\n• TIME_TO_USEC能够接受其它函数的调用结果作为参数，但是其的结果类型必须为TIMESTAMP或者时间格式的字符串。\n\n• 该函数返回值为微秒计数，返回类型为INT。\n\n\n' , '\nmysql> SELECT TIME_TO_USEC(\'2014-03-25\'), TIME_TO_USEC(now());\n+----------------------------+---------------------+\n| TIME_TO_USEC(\'2014-03-25\') | TIME_TO_USEC(now()) |\n+----------------------------+---------------------+\n|           1395676800000000 |    1395735415207794 |\n+----------------------------+---------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (34,31,  'USEC_TO_TIME' , '\n  USEC_TO_TIME(usec)\n\n  该函数为TIME_TO_USEC(date)的逆函数，表示“1970-01-01 00:00:00”增加usec后的时间，且附带了时区信息。例如在东八区调用该函数“USEC_TO_TIME(1)”，返回值为“1970-01-01 08:00:01”。\n\n• usec为一个微秒计数值。\n\n• 返回值为TIMESTAMP类型。\n\n' , 'mysql> SELECT USEC_TO_TIME(1);\n+----------------------------+\n| USEC_TO_TIME(1)            |\n+----------------------------+\n| 1970-01-01 08:00:00.000001 |\n+----------------------------+\n1 row in set (0.00 sec)\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (35,31,  'UNIX_TIMESTAMP ' , '  UNIX_TIMESTAMP(), UNIX_TIMESTAMP(date)\n\n  若无参数调用，则返回一个Unix timestamp (\'1970-01-01 00:00:00\' GMT 之后的秒数) 作为无符号整数。若用date 来调用UNIX_TIMESTAMP()，它会将参数值以\'1970-01-01 00:00:00\' GMT后的秒数的形式返回。date 可以是一个DATE 字符串、一个 DATETIME字符串、一个 TIMESTAMP或一个当地时间的YYMMDD 或YYYMMDD格式的数字。\n\n  当 UNIX_TIMESTAMP被用在 TIMESTAMP列时, 函数直接返回内部时戳值，而不进行任何隐含的 “string-to-Unix-timestamp”转化。假如你向UNIX_TIMESTAMP()传递一个溢出日期，它会返回0,但请注意只有基本范围检查会被履行(年份从1970 到 2037，月份从01到12,日期从01 到31)。\n' , '\nmysql> SELECT UNIX_TIMESTAMP();\n+------------------+\n| UNIX_TIMESTAMP() |\n+------------------+\n|       1427176668 |\n+------------------+\n1 row in set (0.00 sec)\nmysql> SELECT UNIX_TIMESTAMP(\'1997-10-04 22:23:00\')\n+---------------------------------------+\n| UNIX_TIMESTAMP(\'1997-10-04 22:23:00\') |\n+---------------------------------------+\n|                             875974980 |\n+---------------------------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (36,31,  'DATEDIFF' , '\n  DATEDIFF(expr1,expr2)\n\n  DATEDIFF()返回起始时间expr1和结束时间expr2之间的天数。expr1和expr2 为日期或日期时间表达式。计算中只用到这些值的日期部分。\n\n  此函数必须跟两个参数，多于或少于两个参数，系统执行都将参数个数不正确错误。\n\n' , '\nmysql> select datediff(\'2015-06-19\',\'1994-12-17\'), datediff(\'2015-06-19\',\'1998-06-27 10:10:10\'), datediff(now(), \'2014-01-02\')\G;\n*************************** 1. row ***************************\n         datediff(\'2015-06-19\',\'1994-12-17\'): 7489\ndatediff(\'2015-06-19\',\'1998-06-27 10:10:10\'): 6201\n               datediff(now(), \'2014-01-02\'): 533\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (37,31,  'TIMEDIFF' , '\n  TIMEDIFF(expr1,expr2)\n\n  TIMEDIFF()返回起始时间expr1和结束时间expr2之间的时间。expr1和expr2为时间或日期时间表达式，两个的类型必须一样。\n\n  TIMEDIFF()返回结果限于时间值允许的范围。另外，你也可以使用TIMESTAMPDIFF()和UNIX_TIMESTAMP()函数，这两个函数的范围值为整数类型。\n\n' , 'mysql>  select timediff(now(), \'2015-06-06 11:11:22\'), timediff(\'2015-06-06 12:12:12\', \'2014-06-05 11:11:11\')\G;\n*************************** 1. row ***************************\n                timediff(now(), \'2015-06-06 11:11:22\'): 315:00:15\ntimediff(\'2015-06-06 12:12:12\', \'2014-06-05 11:11:11\'): 838:59:59\n1 row in set, 1 warning (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (38,31,  'TIMESTAMPDIFF' , '  TIMESTAMPDIFF(unit,datetime_expr1,datetime_expr2)\n\n  返回日期或日期时间表达式datetime_expr1和datetime_expr2之间的整数差。其结果的单位由unit参数给出。unit的值为：MICROSECOND（mircoseconds）、SECOND、MINUTE、HOUR、DAY、WEEK、MONTH、QUARTER，以及YEAR。\n\n' , '\nmysql> select timestampdiff(second,now(), \'2011-01-01 11:11:11\'),  timestampdiff(second, \'2011-01-01 11:11:11\', now())\G;\n*************************** 1. row ***************************\n timestampdiff(second,now(), \'2011-01-01 11:11:11\'): -140843995\ntimestampdiff(second, \'2011-01-01 11:11:11\', now()): 140843995\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (39,31,  'PERIOD_DIFF' , '\n  PERIOD_DIFF(p1,p2)\n\n  返回周期p1和p2之间的月数。p1和p2的格式应该为 YYMM或YYYYMM。注意周期参数p1和p2不是日期值。\n\n\n' , '\nmysql> select period_diff(20150702, 20790503), period_diff(150702, 790503);\n+---------------------------------+-----------------------------+\n| period_diff(20150702, 20790503) | period_diff(150702, 790503) |\n+---------------------------------+-----------------------------+\n|                          -76777 |                      -76777 |\n+---------------------------------+-----------------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (40,32,  'CONCAT' , '\n  CONCAT(str1,…,strN)\n\n  把一个或多个字符串连接成一个字符串。左右参数都必须是字符串类型或NULL，否则报错。如果执行成功，则返回连接后的字符串；参数中有一个值是NULL结果就是NULL。\n\n  说明：str参数可以是数值类型，隐式转换为字符串处理。\n\n' , '\nmysql> select concat(\'test\'), concat(\'test\',\'OceanBase\'), concat(\'test\', \'OceanBase\', \'1.0\'), concat(\'test\',\'OceanBase\',\'1.0\', NULL)\G;\n*************************** 1. row ***************************\n                        concat(\'test\'): test\n            concat(\'test\',\'OceanBase\'): testOceanBase\n    concat(\'test\', \'OceanBase\', \'1.0\'): testOceanBase1.0\nconcat(\'test\',\'OceanBase\',\'1.0\', NULL): NULL\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (41,32,  'SUBSTRING' , '\n  SUBSTRING(str,pos),SUBSTRING(str FROM pos), SUBSTRING(str,pos,len), SUBSTRING(str FROM pos FOR len)\n和SUBSTR同语义。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (42,32,  'SUBSTR' , '\n  SUBSTR(str,pos,len)、SUBSTR(str,pos)、 SUBSTR(str FROM pos)和SUBSTR (str FROM pos FOR len) \n\n  返回一个子字符串，起始于位置pos，长度为len。使用FROM的格式为标准SQL语法。\n\n• str必须是字符串，pos和len必须是整数。任意参数为NULL，结果总为NULL。\n\n• str中的中文字符被当做字节流看待。\n\n• 不带有len参数的时，则返回的子字符串从pos位置开始到原字符串结尾。\n\n• pos值为负数时，pos的位置从字符串的结尾的字符数起；为零0时，可被看做1。\n\n• 当len小于等于0，或者pos指示的字符串位置不存在字符时，返回结果为空字符串。\n\n' , '\nmysql> SELECT SUBSTR(\'abcdefg\',3), SUBSTR(\'abcdefg\',3,2), SUBSTR(\'abcdefg\',-3), SUBSTR(\'abcdefg\',3,-2), SUBSTR(\'abcdefg\' from -4 for 2)\G;\n*************************** 1. row ***************************\n            SUBSTR(\'abcdefg\',3): cdefg\n          SUBSTR(\'abcdefg\',3,2): cd\n           SUBSTR(\'abcdefg\',-3): efg\n         SUBSTR(\'abcdefg\',3,-2): \nSUBSTR(\'abcdefg\' from -4 for 2): de\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (43,32,  'TRIM' , '\n  TRIM([[{BOTH | LEADING | TRAILING}] [remstr] FROM] str)\n\n  删除字符串所有前缀和（或）后缀。\n\n• remstr和str必须为字符串或NULL类型。当参数中有NULL时结果总为NULL。\n\n• 若未指定BOTH、LEADIN或TRAILING,则默认为BOTH。\n\n• remstr为可选项，在未指定情况下，删除空格。\n\n\n\n' , '\nmysql> SELECT TRIM(\' bar \'),\nTRIM(LEADING \'x\' FROM \'xxxbarxxx\'),\nTRIM(BOTH \'x\' FROM \'xxxbarxxx\'),\nTRIM(TRAILING \'x\' FROM \'xxxbarxxx\')\G;\n*************************** 1. row ***************************\nTRIM(\' bar \'): bar\nTRIM(LEADING \'x\' FROM \'xxxbarxxx\'): barxxx\nTRIM(BOTH \'x\' FROM \'xxxbarxxx\'): bar\nTRIM(TRAILING \'x\' FROM \'xxxbarxxx\'): xxxbar\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (44,32,  'LENGTH' , '  LENGTH(str)\n\n  返回字符串的长度，单位为字节。参数必须是字符串类型或NULL，否则报错。 如果执行成功，结果是INT型整数，表示字符串长度；当参数是NULL结果为NULL。\n\n  str参数为数值类型时，系统能隐式转换为字符串类型。\n\n' , '\nmysql> SELECT LENGTH(\'text\');\n+----------------+\n| LENGTH(\'text\') |\n+----------------+\n|              4 |\n+----------------+\n1 row in set (0.00 sec)\nmysql> select length(-1.23);\n+---------------+\n| length(-1.23) |\n+---------------+\n|             5 |\n+---------------+\n1 row in set (0.00 sec)\nmysql> select length(1233e);\nmysql> select length(1233e);\nERROR 1054 (42S22): Unknown column \'1233e\' in \'field list\'\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (45,32,  'UPPER' , '\n  UPPER(str)\n\n  将字符串转化为大写字母的字符。参数必须是字符串类型。若为NULL，结果总为NULL。\n\n  str参数为数值类型时，能隐式转换为字符串类型。\n\n  由于中文编码的字节区间与ASCII大小写字符不重合，对于中文，UPPER可以很好的兼容。\n\n' , '\nmysql> SELECT UPPER(\'OceanBase您好！\');\n+-----------------------------+\n| UPPER(\'OceanBase您好！\')    |\n+-----------------------------+\n| OCEANBASE您好！             |\n+-----------------------------+\n1 row in set (0.00 sec)\nmysql> select upper(e);\nERROR 1054 (42S22): Unknown column \'e\' in \'field list\'\nmysql> select upper(1.235.);\nERROR 1064 (42000): You have an error in your SQL syntax; \n\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (46,32,  'LOWER' , '\n  LOWER(str)\n\n  将字符串转化为小写字母的字符。参数必须是字符串类型。若为NULL，结果总为NULL。\n\n  str参数为数值类型时，能隐式转换为字符串类型。\n\n  由于中文编码的字节区间与ASCII大小写字符不重合，对于中文，LOWER可以很好的兼容。\n\n' , '\nmysql> SELECT LOWER(\'OceanBase您好！\');\n+-----------------------------+\n| LOWER(\'OceanBase您好！\')    |\n+-----------------------------+\n| oceanbase您好！             |\n+-----------------------------+\n1 row in set (0.00 sec)\nmysql> select lower(1.23) ;\n+-------------+\n| lower(1.23) |\n+-------------+\n| 1.23        |\n+-------------+\n1 row in set (0.00 sec)\nmysql> select lower(1.23h);\nERROR 1583 (42000): Incorrect parameters in the call to native function \'lower\'\nmysql> select lower(1.23e);\nERROR 1582 (42000): Incorrect parameter count in the call to native function \'lower\'\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (47,32,  'HEX' , '\n  HEX(str)\n\n  将字符串转化为十六进制数显示。输入为NULL时，输出也为NULL。\n\n  当str是数值时，输出整数的十六进制表示；\n \n  当str输入是字符串的时候，返回值为str的十六进制字符串表示， 其中每个str 里的每个字符被转化为两个十六进制数字。\n\n\n' , '\nmysql> SELECT HEX(255);\n        -> \'FF\'\nmysql> SELECT HEX(\'abc\');\n        -> 616263\nmysql> SELECT HEX(\'OceanBase\'),\nHEX(123),\nHEX(0x0123);\n+--------------------+----------+-------------+\n| HEX(\'OceanBase\')   | HEX(123) | HEX(0x0123) |\n+--------------------+----------+-------------+\n| 4F6365616E42617365 | 7B       | 0123        |\n+--------------------+----------+-------------+\n1 row in set (0.00 sec)\nmysql> select hex(0x012);\n+------------+\n| hex(0x012) |\n+------------+\n| 0012       |\n+------------+\n1 row in set (0.00 sec)\n\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (48,32,  'UNHEX' , '\n  UNHEX(str)\n\n  HEX(str)的反向操作，即将参数中的每一对十六进制数字理解为一个数字，并将其转化为该数字代表的字符。结果字符以二进制字符串的形式返回。\n\n  str必须是字符串类型或NULL。当str是合法的十六进制值时将按照十六进制到字节流的转换算法进行，当str不是十六进制字符串的时候返回NULL。当str为NULL的时候输出是NULL。\n\n' , '\nmysql> SELECT HEX(\'OceanBase\'),\nUNHEX(\'4f6365616e42617365\'),\nUNHEX(HEX(\'OceanBase\')),\nUNHEX(NULL)\G;\n*************************** 1. row ***************************\nHEX(\'OceanBase\'): 4F6365616E42617365\nUNHEX(\'4f6365616e42617365\'): OceanBase\nUNHEX(HEX(\'OceanBase\')): OceanBase\nUNHEX(NULL): NULL\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (49,32,  'INT2IP' , '\n  INT2IP(int_value)\n\n  注：INT2IP为OceanBase特有函数。\n\n  将一个整数转换成IP地址。\n\n• 输入数据类型必须为INT。若输入为NULL，则输出为NULL。若输入的数字大于MAX_INT32或小于0则输出为NULL。\n\n\n' , 'mysql> SELECT INT2IP(16777216),\n    -> HEX(16777216),\n    -> INT2IP(1);\n+------------------+---------------+-----------+\n| INT2IP(16777216) | HEX(16777216) | INT2IP(1) |\n+------------------+---------------+-----------+\n| 1.0.0.0          | 1000000       | 0.0.0.1   |\n+------------------+---------------+-----------+\n1 row in set (0.00 sec)' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (50,32,  'IP2INT' , '\n  IP2INT(\'ip_addr\')\n\n  注：IP2INT为OceanBase特有函数。\n\n  将字符串表示的IP地址转换成整数内码表示。\n\n• 输入数据类型必须为字符串类型。若输入为NULL，则输出为NULL。若输入的IP地址不是一个正确的IP地址(包含非数字字符，每一个ip segment的数值大小超过256等），则输出为NULL。\n\n• 仅支持ipv4地址，暂不支持ipv6地址。\n\n' , '\nmysql> SELECT IP2INT(\'0.0.0.1\'), \nHEX(IP2INT(\'0.0.0.1\')),\nHEX(IP2INT(\'1.0.0.0\')),\nIP2INT(\'1.0.0.257\')\G;\n*************************** 1. row ***************************\nIP2INT(\'0.0.0.1\'): 1\nHEX(IP2INT(\'0.0.0.1\')): 1\nHEX(IP2INT(\'1.0.0.0\')): 1000000\nIP2INT(\'1.0.0.257\'): NULL\n1 row in set (0.01 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (51,32,  'LIKE' , '\n  [NOT] LIKE str2 [ESCAPE str3]\n\n  字符串通配符匹配。左右参数都必须是字符串类型或NULL，否则报错。如果执行成功，结果是TRUE或者FALSE，或某一个参数是NULL结果就是NULL。\n\n  通配符包括“%”和“_”：\n\n• “%”表示匹配任何长度的任何字符，且匹配的字符可以不存在。\n\n• “_”表示只匹配单个字符，且匹配的字符必须存在。\n\n  如果你需要查找“a_c”，而不是“abc”时，可以使用OceanBase的转义字符“\\”，即可以表示为“a\\_c”。\n\n  ESCAPE用于定义转义符，即表示如果str2中包含str3，那么在匹配时，str3后的字符为普通字符处理，例如：LIKE \'abc%\' ESCAPE \'c\'，此时“c”为转义符，而“%”为普通字符，不再作为转义字符，本语句匹配的字符串为“ab%”。\n\n' , '\nmysql> SELECT \'ab%\' LIKE \'abc%\' ESCAPE \'c\';\n+------------------------------+\n| \'ab%\' LIKE \'abc%\' ESCAPE \'c\' |\n+------------------------------+\n|                            1 |\n+------------------------------+\n1 row in set (0.00 sec)\n\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (52,32,  'REGEXP' , '\n  expr [NOT] REGEXP|RLIKE pat\n\n  执行字符串表达式 expr 和模式pat 的模式匹配。若expr 匹配 pat，则返回 1; 否则返回0。若 expr 或 pat 任意一个为 NULL, 则结果为 NULL。 RLIKE 是REGEXP的同义词。\n\n  expr和pat参数都必须为字符串或NULL，支持隐式转换成字符串类型。数据类型不匹配的，报错。PATTERN必须为合法的正则表达式，否则报错。\n\n\n' , '\nmysql> select 1234 regexp 1;\n+---------------+\n| 1234 regexp 1 |\n+---------------+\n|             1 |\n+---------------+\n1 row in set (0.00 sec)\nmysql>  select \'hello\'  rlike \'h%\';\n+---------------------+\n| \'hello\'  rlike \'h%\' |\n+---------------------+\n|                   0 |\n+---------------------+\n1 row in set (0.00 sec) \n\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (53,32,  'REPEAT' , '\n  REPEAT(str, count)\n\n  返回一个由重复count次数的字符串str 组成的字符串。若 count <= 0,则返回一个空字符串。\n\n  若str 或 count 为 NULL，则返回 NULL\n\n  str为数值类型时，系统隐式转换为字符串类型。\n\n  count支持隐式转换成数值类型，如果转换失败，则相当于count为0。\n\n' , '\nmysql> select repeat(\'1\',-1),  repeat(null,null),repeat(\'test\',4);\n+----------------+-------------------+------------------+\n| repeat(\'1\',-1) | repeat(null,null) | repeat(\'test\',4) |\n+----------------+-------------------+------------------+\n|                  | NULL               | testtesttesttest |\n+----------------+-------------------+------------------+\n1 row in set (0.00 sec)\nmysql> select repeat(11111,\'2\');\n+-------------------+\n| repeat(11111,\'2\') |\n+-------------------+\n| 1111111111        |\n+-------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (54,32,  'SUBSTRING_INDEX' , '\n  SUBSTRING_INDEX(str, delim, count)\n\n  在定界符 delim 以及count 出现前，从字符串str返回字符串。若count为正值,则返回最终定界符(从左边开始)左边的一切内容。若count为负值，则返回定界符（从右边开始）右边的一切内容。任意一个参数为NULL，返回NULL；若str或delim为空字符串，则返回空串；若count=0,返回空串。\n\n  str, delim, count参数支持数值与字符串的隐式转换。\n\n\n' , '\nmysql> select substring_index(\'abcdabc\', \'abc\', 0), substring_index(\'abcdabc\', \'abc\', 1), substring_index(\'abcdabc\', \'abc\', 2), substring_index(\'abcdabc\', \'abc\', 3), substring_index(\'abcdabc\', \'abc\', -1), substring_index(\'abcdabc\', \'abc\', -2), substring_index(\'abcdabc\', \'abc\', -3)\G;\n*************************** 1. row ***************************\n substring_index(\'abcdabc\', \'abc\', 0):\n substring_index(\'abcdabc\', \'abc\', 1):\n substring_index(\'abcdabc\', \'abc\', 2): abcd\n substring_index(\'abcdabc\', \'abc\', 3): abcdabc\nsubstring_index(\'abcdabc\', \'abc\', -1):\nsubstring_index(\'abcdabc\', \'abc\', -2): dabc\nsubstring_index(\'abcdabc\', \'abc\', -3): abcdabc\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (55,32,  'LOCATE' , '\n  LOCATE(substr,str) , LOCATE(substr,str,pos)\n\n  第一个语法返回字符串 str中子字符串substr的第一个出现位置。第二个语法返回字符串 str中子字符串substr的第一个出现位置, 起始位置在pos。如若substr 不在str中，则返回值为0。\n\n' , '\nmysql> SELECT LOCATE(\'bar\', \'foobarbar\');\n        -> 4\nmysql> SELECT LOCATE(\'xbar\', \'foobar\');\n        -> 0\nmysql> SELECT LOCATE(\'bar\', \'foobarbar\',5);\n        -> 7\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (56,32,  'INSTR' , '\n  INSTR(str,substr)\n\n  返回字符串str中子字符串的第一个出现位置。这和LOCATE()的双参数形式相同，除非参数的顺序被颠倒。  \n\n' , '\nmysql> SELECT INSTR(\'foobarbar\', \'bar\');\n        -> 4\nmysql> SELECT INSTR(\'xbar\', \'foobar\');\n        -> 0\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (57,32,  'REPLACE()' , '\n  REPLACE(str, from_str, to_str)\n\n  返回字符串str以及所有被字符to_str替代的字符串from_str。\n\n' , '\nmysql> SELECT REPLACE(\'abc.efg.gpg.nowdew.abc.dabc.e\', \'abc.\', \'www\');\n+---------------------------------------------------------+\n| REPLACE(\'abc.efg.gpg.nowdew.abc.dabc.e\', \'abc.\', \'www\') |\n+---------------------------------------------------------+\n| wwwefg.gpg.nowdew.wwwdwwwe                              |\n+---------------------------------------------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (58,32,  'FIELD' , '\n  FIELD(str,str1,str2,str3,…)\n\n  返回参数str在str1,str2,str3,…列表中的索引位置（从1开始的位置）。在找不到str的情况下，返回值为0。\n\n  如果所有的对于FIELD()的参数均为字符串，则所有参数均按照字符串进行比较。如果所有的参数均为数字，则按照数字进行比较。否则，参数均按照double类型进行比较。\n\n  如果str为NULL，则返回值为0，原因是NULL不能同任何值进行同等比较。FILED()是ELT()的补数。\n\n' , '\nmysql> select field(\'abc\',\'abc1\',\'abc2\',\'abc\',\'abc4\',\'abc\'), field(NULL, \'null1\', NULL);\n+-----------------------------------------------+----------------------------+\n| field(\'abc\',\'abc1\',\'abc2\',\'abc\',\'abc4\',\'abc\') | field(NULL, \'null1\', NULL) |\n+-----------------------------------------------+----------------------------+\n|                   3 |                          0 |\n+-----------------------------------------------+----------------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (59,32,  'ELT' , '\n  ELT(N, str1, str2, str3,…)\n\n  若N=1，则返回值为str1, 若N=2，则返回值为str2，以此类推。若N小于1或大于参数的数目，则返回值为NULL。ELT()是FIELD()的补数。\n\n' , '\nmysql> select elt(3, \'abc1\', \'abc2\', \'abc\', \'abc4\', \'abc\'), elt(0, \'null1\', NULL);\n+----------------------------------------------+-----------------------+\n| elt(3, \'abc1\', \'abc2\', \'abc\', \'abc4\', \'abc\') | elt(0, \'null1\', NULL) |\n+----------------------------------------------+-----------------------+\n| abc                                          | NULL                  |\n+----------------------------------------------+-----------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (60,34,  'CAST' , '\n  CAST(expr AS type)\n\n  将某种数据类型的表达式显式转换为另一种数据类型。\n\n  将expr字段值转换为type数据类型。\n\n' , '\nmysql> SELECT CAST(123 AS BOOL);\n+-------------------+\n| CAST(123 AS bool) |\n+-------------------+\n|                 1 |\n+-------------------+\n1 row in set (0.00 sec)\n\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (61,33,  'AVG' , '\n  AVG(([DISTINCT] expr)\n\n  返回指定组中的平均值，空值被忽略。DISTINCT选项可用于返回expr的不同值的平均值。若找不到匹配的行，则AVG()返回NULL。\n\n' , '\nmysql> select * from oceanbasetest;\n+----+------+------+\n| id | ip   | ip2  |\n+----+------+------+\n|  1 |    4 | NULL |\n|  3 |    3 | NULL |\n|  4 |    3 | NULL |\n+----+------+------+\n3 rows in set (0.01 sec)\nmysql> select avg(ip2), avg(ip), avg(distinct(ip)) from oceanbasetest;\n+----------+---------+-------------------+\n| avg(ip2) | avg(ip) | avg(distinct(ip)) |\n+----------+---------+-------------------+\n|     NULL |  3.3333 |            3.5000 |\n+----------+---------+-------------------+\n1 row in set (0.00 sec)\nmysql> select avg(distinct(ip)),avg(ip),avg(ip2) from oceanbasetest;\n+-------------------+---------+----------+\n| avg(distinct(ip)) | avg(ip) | avg(ip2) |\n+-------------------+---------+----------+\n|            3.5000 |  3.3333 |     NULL |\n+-------------------+---------+----------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (62,33,  'COUNT' , '\n  COUNT([DISTINCT] expr)\n\n  COUNT([DISTINCT] expr)返回SELECT语句检索到的行中非NULL值的数目。若找不到匹配的行，则COUNT()返回0。DISTINCT选项可用于返回expr的不同值的数目。\n\n  COUNT(*)的稍微不同之处在于，它返回检索行的数目，不论其是否包含NULL值。\n\n\n' , '\nmysql> select * from oceanbasetest;\n+----+------+------+\n| id | ip   | ip2  |\n+----+------+------+\n|  1 |    4 | NULL |\n|  3 |    3 | NULL |\n|  4 |    3 | NULL |\n+----+------+------+\n3 rows in set (0.00 sec)\nmysql> select count(ip2), count(ip), count(distinct(ip)), count(*) from oceanbasetest;\n+------------+-----------+---------------------+----------+\n| count(ip2) | count(ip) | count(distinct(ip)) | count(*) |\n+------------+-----------+---------------------+----------+\n|          0 |         3 |                   2 |        3 |\n+------------+-----------+---------------------+----------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (63,33,  'MAX' , '\n  MAX([DISTINCT] expr)\n\n  返回指定数据中的最大值。\n\n  MAX()的取值可以是一个字符串参数；在这些情况下，它们返回最大字符串值。DISTINCT关键字可以被用来查找expr 的不同值的最大值，这产生的结果与省略DISTINCT 的结果相同。\n\n' , '\n\n假设表a有三行数据：id=1，num=10；id=2，num=20；id=3，num=30。\nmysql> SELECT MAX(num) FROM a;\n+-----------------+\n| MAX(num)        |\n+-----------------+\n|              30 |\n+-----------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (64,33,  'MIN' , '\n  MIN([DISTINCT] expr)\n\n  返回指定数据中的最小值。\n\n  MIN()的取值可以是一个字符串参数；在这些情况下，它们返回最小字符串值。DISTINCT关键字可以被用来查找expr 的不同值的最小值，然而，这产生的结果与省略DISTINCT 的结果相同。\n\n' , '\n假设表a有三行数据：id=1，num=10；id=2，num=20；id=3，num=30。\nmysql> SELECT MIN(num) FROM a;\n+----------------+\n| MIN(num)       |\n+----------------+\n|             10 |\n+----------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (65,33,  'SUM' , '\n  SUM([DISTINCT] expr)\n\n  返回expr 的总数。若返回集合中无任何行，则SUM()返回NULL。DISTINCT关键字可用于求得expr不同值的总和。\n \n  若找不到匹配的行，则SUM()返回NULL。\n\n\n' , '\nmysql> select * from oceanbasetest;\n+------+------+------+\n| id   | ip   | ip2  |\n+------+------+------+\n|    1 |    4 | NULL |\n|    3 |    3 | NULL |\n|    4 |    3 | NULL |\n+------+------+------+\n3 rows in set (0.00 sec)\nmysql> select sum(ip2),sum(ip),sum(distinct(ip)) from oceanbasetest;\n+----------+---------+-------------------+\n| sum(ip2) | sum(ip) | sum(distinct(ip)) |\n+----------+---------+-------------------+\n|     NULL |      10 |                 7 |\n+----------+---------+-------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (66,33,  'GROUP_CONCAT' , '\n  GROUP_CONCAT([DISTINCT] expr)\n\n  该函数返回带有来自一个组的连接的非NULL值的字符串结果。\n\n  语法: \n\n  GROUP_CONCAT([DISTINCT] expr [,expr ...]\n  [ORDER BY {unsigned_integer | col_name | expr}\n  [ASC | DESC] [,col_name ...]]\n  [SEPARATOR str_val])\n\n\n' , '\nmysql> select * from book;     //表book（书编号，书名，出版社）+--------+--------------------------------+-----------------------------+\n| bookid | bookname                       | publishname                 |\n+--------+--------------------------------+-----------------------------+\n|      1 | git help                       | alibaba group publisher     |\n|      2 | MySQL性能优化                  | 浙江大学图文出版社          |\n|      3 | JAVA编程指南                   | 机械工业出版社              |\n|      3 | JAVA编程指南                   | 机械工业出版社              |\n|      4 | 大规模分布式存储系统           | 机械工业出版社              |\n+--------+--------------------------------+-----------------------------+\n5 rows in set (0.00 sec)\n//查找书名信息\nmysql> select group_concat(bookname) from book group by bookname;\n+-----------------------------------+\n| group_concat(bookname)            |\n+-----------------------------------+\n| git help                          |\n| JAVA编程指南,JAVA编程指南         |\n| MySQL性能优化                     |\n| 大规模分布式存储系统              |\n+-----------------------------------+\n4 rows in set (0.00 sec)\n//查找书名信息，书名唯一\nmysql> select group_concat(distinct(bookname)) from book group by bookname;\n+----------------------------------+\n| group_concat(distinct(bookname)) |\n+----------------------------------+\n| git help                         |\n| JAVA编程指南                     |\n| MySQL性能优化                    |\n| 大规模分布式存储系统             |\n+----------------------------------+\n4 rows in set (0.01 sec)\n//查找书名和出版社信息，以书名分组，出版社信息降序排序显示\nmysql> select bookname, group_concat(publishname order by publishname desc separator  \';\' ) from book group by bookname;\n+--------------------------------+---------------------------------------------------------------------+\n| bookname                       | group_concat(publishname order by publishname desc separator  \';\' ) |\n+--------------------------------+---------------------------------------------------------------------+\n| git help                       | alibaba group publisher                                             |\n| JAVA编程指南                   | 机械工业出版社;机械工业出版社                                       |\n| MySQL性能优化                  | 浙江大学图文出版社                                                  |\n| 大规模分布式存储系统           | 机械工业出版社                                                      |\n+--------------------------------+---------------------------------------------------------------------+\n4 rows in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (67,35,  'ROUND' , '\n  ROUND(X), ROUND(X,D)\n\n  返回一个数值，四舍五入到指定的长度或精度。\n\n  返回参数X, 其值接近于最近似的整数。在有两个参数的情况下，返回X，其值保留到小数点后D位，而第D位的保留方式为四舍五入。若要接保留X值小数点左边的D位，可将D设为负值。 \n\n  返回值的类型同 第一个自变量相同(假设它是一个整数、双精度数或小数)。这意味着对于一个整数参数,结果也是一个整数(无小数部分)。\n当第一个参数是十进制常数时，对于准确值参数，ROUND() 使用精密数学题库：\n\n  对于准确值数字,ROUND() 使用“四舍五入” 或“舍入成最接近的数” 的规则:对于一个分数部分为 .5或大于 .5的值，正数则上舍入到邻近的整数值，负数则下舍入临近的整数值。(换言之, 其舍入的方向是数轴上远离零的方向）。对于一个分数部分小于.5 的值，正数则下舍入下一个整数值，负数则下舍入邻近的整数值，而正数则上舍入邻近的整数值。\n\n  对于近似值数字， ROUND()遵循银行家规则“四舍--大于五入--五取最接近的偶数”的规则： 一个带有任何小数部分的值会被舍入成最接近的偶数整数。\n\n' , '\nmysql> select round(2.15,2);\n+---------------+\n| round(2.15,2) |\n+---------------+\n|          2.15 |\n+---------------+\n1 row in set (0.00 sec) \nmysql> select round(2555e-2,1);\n+------------------+\n| round(2555e-2,1) |\n+------------------+\n|             25.6 |\nmysql> select round(25e-1), round(25.3e-1),round(35e-1);\n+--------------+----------------+--------------+\n| round(25e-1) | round(25.3e-1) | round(35e-1) |\n+--------------+----------------+--------------+\n|            2 |              3 |            4 |\n+--------------+----------------+--------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (68,35,  'CEIL' , '\n  CEIL(expr)\n\n  返回大于或者等于指定表达式的最小整数。\n\n  还支持比较运算，结果为BOOL值，被转化为数字类型处理，产生的结果为1(TRUE)、0 (FALSE)；\n\n  如果输入NULL，返回值为NULL。\n\n  如果输入纯数字的字符串，支持自动转换成数字类型。\n\n  返回值会被转化为一个BIGINT。\n\n\n' , '\nmysql> select ceil(1.2), ceil(-1.2), ceil(1+1.5), ceil(1=1),ceil(1<1),ceil(null);\n+-----------+------------+-------------+-----------+-----------+------------+\n| ceil(1.2) | ceil(-1.2) | ceil(1+1.5) | ceil(1=1) | ceil(1<1) | ceil(null) |\n+-----------+------------+-------------+-----------+-----------+------------+\n|         2 |         -1  |           3  |         1 |         0 |       NULL |\n+-----------+------------+-------------+-----------+-----------+------------+\n1 row in set (0.00 sec)\nmysql> select ceil(name);\nERROR 1166 (42703): Unkown column name \'name\'\nmysql> select ceil(\'2\');\n+-----------+\n| ceil(\'2\') |\n+-----------+\n|         2 |\n+-----------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (69,35,  'FLOOR' , '\n  FLOOR(expr)\n\n  和CEIL(expr)函数功能类似，返回小于或者等于指定表达式的最大整数。\n还支持比较运算，结果为BOOL值，被转化为数字类型处理，产生的结果为1(TRUE)、0 (FALSE)；\n\n  如果输入NULL，返回值为NULL。\n\n  如果输入纯数字的字符串，支持自动转换成数字类型。\n\n  返回值会被转化为一个BIGINT。\n\n' , '\nmysql> select floor(1.2), floor(-1.2), floor(1+1.5), floor(1=1),floor(1<1),floor(null);\n+------------+-------------+--------------+------------+------------+-------------+\n| floor(1.2) | floor(-1.2) | floor(1+1.5) | floor(1=1) | floor(1<1) | floor(null) |\n+------------+-------------+--------------+------------+------------+-------------+\n|          1 |          -2 |            2 |          1 |          0 |        NULL |\n+------------+-------------+--------------+------------+------------+-------------+\n1 row in set (0.00 sec)\nmysql> select floor(name);\nERROR 1166 (42703): Unkown column name \'name\'\nmysql> select floor(\'2\');\n+------------+\n| floor(\'2\') |\n+------------+\n|          2 |\n+------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (70,35,  'ABS' , '\n  ABS(expr)\n\n  绝对值函数，求表达式绝对值，函数返回值类型与数值表达式的数据类型相同。\n\n  还支持比较运算，结果为BOOL值，被转化为数字类型处理，产生的结果为1(TRUE)、0 (FALSE)；\n\n  如果输入NULL，返回值为NULL。\n\n  如果输入纯数字的字符串，支持自动转换成数字类型。\n\n  返回值会被转化为一个BIGINT。\n\n' , '\nmysql> select abs(5),abs(-5.777),abs(0),abs(1/2),abs(1-5);\n+--------+-------------+--------+----------+----------+\n| abs(5) | abs(-5.777) | abs(0) | abs(1/2) | abs(1-5) |\n+--------+-------------+--------+----------+----------+\n|      5 |       5.777 |      0 |      0.5 |        4 |\n+--------+-------------+--------+----------+----------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (71,35,  'NEG' , '\n  NEG(expr)\n\n  求补函数，对操作数执行求补运算：用零减去操作数，然后结果返回操作数。\n\n  支持比较运算，结果为BOOL值，被转化为数字类型处理，产生的结果为1(TRUE)、0 (FALSE)，再对结果求补。\n\n' , '\nmysql> select neg(1),neg(1+1),neg(2*3),neg(1=1),neg(5<1);\n+--------+----------+----------+----------+----------+\n| neg(1) | neg(1+1) | neg(2*3) | neg(1=1) | neg(5<1) |\n+--------+----------+----------+----------+----------+\n|     -1 |       -2 |       -6 |        0 |        1 |\n+--------+----------+----------+----------+----------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (72,35,  'SIGN' , '\n  SIGN(X)\n\n  SIGN(X)返回参数作为-1、 0或1的符号，该符号取决于X的值为负、零或正。\n\n  支持比较运算，结果为BOOL值，被转化为数字类型处理，产生的结果为1(TRUE)、0 (FALSE)；\n\n  如果输入NULL，返回值为NULL。\n\n  支持浮点数、十六进制数。\n\n' , '\nmysql> SELECT SIGN(-32);\n        -> -1\nmysql> SELECT SIGN(0);\n        -> 0\nmysql> SELECT SIGN(234);\n        -> 1\nmysql> select sign(null),sign(false),sign(0x01);\n+------------+-------------+------------+\n| sign(null) | sign(false) | sign(0x01) |\n+------------+-------------+------------+\n|       NULL |           0 |          1 |\n+------------+-------------+------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (73,35,  'CONV' , '\n  CONV(N, from_base, to_base)\n\n  不同数基间转换数字。返回值为一个字符串，由from_base基转化为to_base基。输入参数N可以是一个整数或字符串。最小基数为2，而最大基数则为36。如果to_base是一个负数，则N被看作一个带符号数。否则，N被看作无符号数。from_base如果是负数，则被当作整数处理，符号被忽略。N参数仅支持int类型和字符串类型输入；from_base和to_base参数仅支持十进制int类型输入，且取值范围为[-36,-2]U[2,36]。\n\n  非法输入将导致报错，其中非法输入包括以下情况：\n\n• from_base或者to_base不是一个合法的十进制int类型输入；\n\n• from_base或者to_base超出[-36,-2]U[2,36]的取值范围；\n\n• N不是一个合法的数字表示，例如取值超出0～9，a～z，A～Z的字符范围；\n\n• N超出了from_base基的取值范围，例如from_base为2，而N取值为3；\n\n• N的取值超出了int64的最大表示范围，即[-9223372036854775807, 9223372036854775807]。\n\n\n' , '\nmysql> select conv(9223372036854775807,10,2);\n+-----------------------------------------------------------------+\n| conv(9223372036854775807,10,2)                                  |\n+-----------------------------------------------------------------+\n| 111111111111111111111111111111111111111111111111111111111111111 |\n+-----------------------------------------------------------------+\n1 row in set (0.00 sec)\nmysql> select conv(\'-acc\',21,-7);\n+--------------------+\n| conv(\'-acc\',21,-7) |\n+--------------------+\n| -16425             |\n+--------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (74,35,  'MOD' , '\n  MOD(N,M)\n\n  取余函数。MOD（N，M）， N % M， N MOD M 三种形式是等效的。\n\n  MOD（）对于带有小数部分的数值也起作用，它返回除法运算后的精确余数。\n\n  N,M中任何一个参数为NULL，返回值都为NULL。M为0是，也返回NULL。\n\n' , '\nmysql> select mod(29,19), 29 mod 19, 29 % 19;\n+------------+-----------+---------+\n| mod(29,19) | 29 mod 19 | 29 % 19 |\n+------------+-----------+---------+\n|         10 |        10 |      10 |\n+------------+-----------+---------+\n1 row in set (0.00 sec)\n\nmysql> select mod(19.5, 29);\n+---------------+\n| mod(19.5, 29) |\n+---------------+\n|          19.5 |\n+---------------+\n1 row in set (0.00 sec)\n\nmysql> select mod(29, null);\n+---------------+\n| mod(29, null) |\n+---------------+\n|          NULL |\n+---------------+\n1 row in set (0.00 sec)\n\nmysql> select mod(100,0);\n+------------+\n| mod(100,0) |\n+------------+\n|       NULL |\n+------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (75,37,  'GREATEST' , '\n  GREATEST(value1, ...)\n\n  返回参数的最大值，和函数LEAST()相对。\n\n  参数至少为一个；如果参数中有NULL, 返回值为NULL。\n\n  当参数中同时存在数值和字符时，把字符隐式转换为数值类型处理，不能转换的报错。\n\n' , '\nmysql> select greatest(2), greatest(\'2\',1,0), greatest(\'a\',\'b\',\'c\'), greatest(\'a\', NULL, \'c\'), greatest(\'2014-05-15\',\'2014-06-01\')\G;\n*************************** 1. row ***************************\n                        greatest(2): 2\n                  greatest(\'2\',1,0): 2\n              greatest(\'a\',\'b\',\'c\'): c\n           greatest(\'a\', NULL, \'c\'): NULL\ngreatest(\'2014-05-15\',\'2014-06-01\'): 2014-06-01\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (76,37,  'LEAST' , '\n  LEAST(value1, ...)\n\n  返回参数的最小值，和函数GREATEST()相对。\n\n  参数至少为一个；如果参数中有NULL, 返回值为NULL。\n\n  当参数中同时存在数值和字符时，把字符隐式转换为数值类型处理，不能转换的报错。\n\n' , '\nmysql> select least(2), least(\'2\',4,9), least(\'a\',\'b\',\'c\'), least(\'a\',NULL,\'c\'), least(\'2014-05-15\',\'2014-06-01\')\G;\n*************************** 1. row ***************************\n                        least(2): 2\n                  least(\'2\',4,9): 2\n              least(\'a\',\'b\',\'c\'): a\n             least(\'a\',NULL,\'c\'): NULL\nleast(\'2014-05-15\',\'2014-06-01\'): 2014-05-15\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (77,37,  'ISNULL' , '\n  ISNULL(expr)\n\n  如果参数expr 为NULL，那么ISNULL()的返回值为1，否则范围值为0。\n\n  ISNULL()函数可以用来替代针对NULL的等值（=）比较。（使用=的NULL值比较通常都是错误的。）\n\n  ISNULL()函数同IS NULL比较操作符具有一些相同的特性。\n\n' , '\nmysql> SELECT ISNULL(null), ISNULL(\'test\'), ISNULL(123.456), ISNULL(\'10:00\');\n+--------------+----------------+-----------------+-----------------+\n| ISNULL(null) | ISNULL(\'test\') | ISNULL(123.456) | ISNULL(\'10:00\') |\n+--------------+----------------+-----------------+-----------------+\n|            1 |              0 |               0 |               0 |\n+--------------+----------------+-----------------+-----------------+\n1 row in set (0.01 sec)\nmysql> SELECT ISNULL(null+1);\n+----------------+\n| ISNULL(null+1) |\n+----------------+\n|              1 |\n+----------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (78,38,  'CASE' , '\n  格式\n\n CASE value WHEN [compare-value] THEN result [WHEN [compare-value] THEN result ...] [ELSE result] END \n\nOR:\n\n CASE WHEN [condition] THEN result [WHEN [condition] THEN result ...] [ELSE result] END \n\n  在第一个方案的返回结果中，value=compare-value。而第二个方案的返回结果是第一种条件为真。如果没有匹配的结果值，则返回结果为ELSE后的结果，如果没有ELSE部分，则返回值为NULL。\n\n' , '\nmysql> select CASE \'b\' when \'a\' then 1 when \'b\' then 2 END;\n +----------------------------------------------+\n | CASE \'b\' when \'a\' then 1 when \'b\' then 2 END |\n +----------------------------------------------+\n |                                            2 |\n +----------------------------------------------+\n 1 row in set (0.00 sec)\nmysql> select CASE concat(\'a\',\'b\') when concat(\'ab\',) then \'a\' when \'b\' then \'b\' end; +--------------------------------------------------------------------\n| CASE concat(\'a\',\'b\') when concat(\'ab\',) then \'a\' when \'b\' then \'b\' end| +--------------------------------------------------------------------\n| a                                                                   +--------------------------------------------------------------------\n 1 row in set (0.00 sec)\nmysql> select case when 1>0 then \'true\' else \'false\' end;\n+--------------------------------------------+\n| case when 1>0 then \'true\' else \'false\' end |\n+--------------------------------------------+\n| true                                       |\n+--------------------------------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (79,38,  'IF' , '\n  IF(expr1,expr2,expr3)\n\n  如果expr1的值为TRUE（即：expr1<>0 且 expr1<>NULL），返回结果为expr2;否则返回结果为expr3。\n\n  IF()返回结果可以是数值或字符串类型，它取决于使用的内容。\n\n' , '\nmysql> select if(5>6, \'T\',\'F\'), if (5>6, 1, 0), if(null, \'True\', \'False\'), if(0, \'True\', \'False\')\G;\n*************************** 1. row ***************************\n         if(5>6, \'T\',\'F\'): F\n           if (5>6, 1, 0): 0\nif(null, \'True\', \'False\'): False\n   if(0, \'True\', \'False\'): False\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (80,38,  'IFNULL' , '\n  IFNULL(expr1, expr2)\n\n  假设expr1不为 NULL，则IFNULL()的返回值为expr1;否则其返回值为expr2.IFNULL()的返回值是数值或字符串，具体情况取决于其所使用的语境。\n\n' , '\nmysql> SELECT IFNULL(\'abc\', null), IFNULL(NULL+1, NULL+2), IFNULL(1/0, 0/1);\n+---------------------+------------------------+------------------+\n| IFNULL(\'abc\', null) | IFNULL(NULL+1, NULL+2) | IFNULL(1/0, 0/1) |\n+---------------------+------------------------+------------------+\n| abc                 |                   NULL |           0.0000 |\n+---------------------+------------------------+------------------+\n1 row in set (0.01 sec)\n\n' , '');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (81,38,  'NULLIF' , '\n  NULLIF(expr1, expr2)\n\n  如果expr1=expr2成立，那么返回值为NULL，否则返回值为expr1。这和CASE WHEN expr1=expr2 THEN NULL ELSE expr1 END相同。\n\n  注意，如果参数不相等，则两次求得的值为expr1。\n\n' , '\nmysql> SELECT NULLIF(\'ABC\', 123), NULLIF(\'123\',123), NULLIF(NULL, \'abc\');\n+--------------------+-------------------+---------------------+\n| NULLIF(\'ABC\', 123) | NULLIF(\'123\',123) | NULLIF(NULL, \'abc\') |\n+--------------------+-------------------+---------------------+\n| ABC                | NULL              | NULL                |\n+--------------------+-------------------+---------------------+\n1 row in set, 1 warning (0.01 sec)\n\n' , '');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (82,39,  'FOUND_ROWS' , '\n  FOUND_ROWS()\n\n  一个SELECT语句可能包含一个LIMIT子句，用来限制数据库服务器端返回客户端的行数。在某些情况下，我们需要不再次运行该语句而得知在没有LIMIT时到底该语句返回了多少行。我们可以在SELECT语句中选择使用SQL_CALC_FOUND_ROWS, 然后调用FOUND_ROW()函数，获取该语句在没有LIMIT时返回的行数。\n\nmysql> SELECT SQL_CALC_FOUND_ROWS * FROM tbl_name\n    -> WHERE id > 100 LIMIT 10;\nmysql> SELECT FOUND_ROWS();\n\n  第二个SELECT语句返回一个数字，表示在没有LIMIT子句的情况下，第一个SELECT语句返回了多少行。（若上述的SELECT语句在不使用SQL_CALC_FOUND_ROWS选项时，使用LIMIT和不使用LIMIT时候， FOUND_ROWS()可能会返回不同的结果）。\n\n  通过FOUND_ROWS()函数返回的有效行数是瞬时的，并且不能越过SELECT SQL_CALC_FOUND_ROWS语句后面的语句。如果你后续还需要用到这个值，就需要将其保存。如：\n\nmysql> SELECT SQL_CALC_FOUND_ROWS * FROM ... ;\nmysql> SET @rows = FOUND_ROWS();\n\n  假如你正在使用SQL_CALC_FOUND_ROWS，系统必须计算出在全部结果集合中有多少行。尽管如此，这也还是比不用LIMIT而再次运行查询要快，原因是结果集合不需要被发送到客户端。\n\n  SQL_CALC_FOUND_ROWS和FOUND_ROWS()在当你希望限制一个查询返回的行数时是很有用的，同时还能不需要再次运行查询就可以确定全部结果集合中的行数。一个例子就是提供页式显示的Web脚本，该显示包含显示搜索结果其他部分的页的链接。使用FOUND_ROWS()使你确定剩下的结果需要多少其他的页。\n\n  SQL_CALC_FOUND_ROWS 和 FOUND_ROWS() 的应用对于UNION 查询比对于简单SELECT 语句更为复杂，原因是在UNION 中，LIMIT 可能会出现在多个位置。它可能适用于UNION中的独立的SELECT语句，或是整个的UNION 结果。 \nSQL_CALC_FOUND_ROWS对于 UNION的期望结果是它返回在没有全局的LIMIT的条件下而应返回的行数。SQL_CALC_FOUND_ROWS 和UNION 一同使用的条件是：\n\n  SQL_CALC_FOUND_ROWS 关键词必须出现在UNION的第一个 SELECT中。 \n\n  FOUND_ROWS()的值只有在使用 UNION ALL时才是精确的。若使用不带ALL的UNION，则会发生两次删除，而FOUND_ROWS() 的指只需近似的。\n \n  假若UNION 中没有出现LIMIT ，则SQL_CALC_FOUND_ROWS 被忽略，返回临时表中的创建的用来处理UNION的行数。 \n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (83,39,  'LAST_INSERT_ID' , '\n  LAST_INSERT_ID()\n\n  返回本session最后一次插入的自增字段值，如最近一条insert插入多条记录，LAST_INSERT_ID()返回第一条记录的自增字段值。\n\n' , '\nmysql>select LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n|                5 |\n+------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (84,36,  'COALESCE' , '\n  COALESCE(expr, expr, expr,...)\n\n  依次参考各参数表达式，遇到非NULL值即停止并返回该值。如果所有的表达式都是空值，最终将返回一个空值。\n\n  所有表达式必须是相同类型，或者可以隐性转换为相同的类型。 \n\n  如果expr2,expr3中只有一个明确是NULL，则IF()函数的结果类型为非NULL表达式的结果类型。\n\n  假如expr2 和expr3 都是字符串，且其中任何一个字符串区分大小写，则返回结果是区分大小写。\n\n' , '\nmysql> SELECT COALESCE(NULL,NULL,3,4,5), COALESCE(NULL,NULL,NULL);\n  +---------------------------+--------------------------+\n  | COALESCE(NULL,NULL,3,4,5) | COALESCE(NULL,NULL,NULL) |\n  +---------------------------+--------------------------+\n  |                         3 |                     NULL |\n  +---------------------------+--------------------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (85,36,  'NVL' , '\n  NVL(str1,replace_with)\n\n  如果str1为NULL，则替换成replace_with。\n\n  任何时候给它一个空值，它都返回一个你所选择的值。这种能够自动替换空值的能力有助于提供看上去更为完善的输出。其中str1一般是一个列名。replace_with可以是任何值：直接值（即硬编码）、对其他列的引用或者表达式。\n\n' , '\nmysql> SELECT NVL(NULL, 0), NVL(NULL, \'a\');\n+--------------+----------------+\n| NVL(NULL, 0) | NVL(NULL, \'a\') |\n+--------------+----------------+\n|            0 | a              |\n+--------------+----------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (86,41,  'Logical Operators' , '\n  在OceanBase中，逻辑操作符会把左右操作数都转成BOOL类型进行运算。逻辑运算时返回“Error”表示计算错误。\n\n  OceanBase各数据类型转换BOOL类型的规则如下：\n\n• 字符串只有是“True”、“False”、“1”和“0”才能够转换到BOOL类型，其中字符串“True”和“1”为“True”，字符串“False”和“0”为“False”。\n\n• “INT”、“FLOAT”、“DOUBLE”和“DECIMAL”转换BOOL类型时，数值不为零时为“True”，数值为零时为“False”。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (87,41,  'NOT !' , '\n  逻辑非\n\n' , '\nmysql> SELECT NOT 0, NOT 1, NOT NULL;\n+-------+-------+----------+\n| NOT 0 | NOT 1 | NOT NULL |\n+-------+-------+----------+\n|     1 |     0 |     NULL |\n+-------+-------+----------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (88,41,  'AND &&' , '\n  逻辑与\n\n' , '\nmysql> SELECT (0 AND 0), (0 AND 1), (1 AND 1), (1 AND NULL);\n+-----------+-----------+-----------+--------------+\n| (0 AND 0) | (0 AND 1) | (1 AND 1) | (1 AND NULL) |\n+-----------+-----------+-----------+--------------+\n|         0 |         0 |         1 |         NULL |\n+-----------+-----------+-----------+--------------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (89,41,  'OR ||' , '\n  逻辑或\n\n' , '\nmysql> SELECT (0 OR 0), (0 OR 1), (1 OR 1), (1 AND NULL);\n+----------+----------+----------+--------------+\n| (0 OR 0) | (0 OR 1) | (1 OR 1) | (1 AND NULL) |\n+----------+----------+----------+--------------+\n|        0 |        1 |        1 |         NULL |\n+----------+----------+----------+--------------+\n1 row in set (0.01 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (90,41,  'XOR' , '\n  逻辑异或。\n\n  当任意一个操作数为NULL时，返回值为NULL。对于 非NULL的操作数，假如一个奇数操作数为非零值，则计算所得结果为1，否则为0。\n\n' , '\nmysql> SELECT 1 XOR TRUE, 1 XOR 1, 1 XOR 2, 1 XOR NULL, 1 XOR 1 XOR 1;\n+------------+---------+---------+------------+---------------+\n| 1 XOR TRUE | 1 XOR 1 | 1 XOR 2 | 1 XOR NULL | 1 XOR 1 XOR 1 |\n+------------+---------+---------+------------+---------------+\n|          0 |       0 |       0 |       NULL |             1 |\n+------------+---------+---------+------------+---------------+\n1 row in set (0.01 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (91,43,  'Arithmetic Operators' , '\n  OceanBase中，数值计算只允许在数值类型和VARCHAR直接进行，其它类型直接报错。字符串在做算术运算时，如果无法转成DOUBLE类型则报错，比如“\'3.4he\' + 3”。字符串只有在内容全为数字或者开头是“+”或者“-”，且后面跟数字的形式才能转成DOUBLE型\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (92,43,  '+' , '\n  加法\n\n' , '\nmysql> SELECT 2+3;\n+-----+\n| 2+3 |\n+-----+\n|   5 |\n+-----+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (93,43,  '-' , '\n  减法\n\n' , '\nmysql> SELECT 2-3;\n+-----+\n| 2-3 |\n+-----+\n|  -1 |\n+-----+\n1 row in set (0.01 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (94,43,  '*' , '\n  乘法\n\n' , '\nmysql> SELECT 2*3;\n+-----+\n| 2*3 |\n+-----+\n|   6 |\n+-----+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (95,43,  '/' , '\n  除法，返回商。如果除数为“0”，则返回结果为“NULL”。\n\n' , '\nmysql> SELECT 2/3;\n+--------+\n| 2/3    |\n+--------+\n| 0.6667 |\n+--------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (96,43,  '%
MOD' , '\n  除法，返回余数。如果除数为“0”，则返回结果为“NULL”\n\n' , '\nmysql> SELECT 2%3, 2 MOD 3;\n+------+---------+\n| 2%3  | 2 MOD 3 |\n+------+---------+\n|    2 |       2 |\n+------+---------+\n1 row in set (0.01 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (97,43,  '^' , '\n  返回指定数值的指定幂运算结果。\n\n' , '\nmysql> SELECT 2^2;\n+-----+\n| 2^2 |\n+-----+\n|   0 |\n+-----+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (98,42,  'Comparison Operators' , '\n  比较运算符用于比较两个数值的大小。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (99,42,  '=' , '\n  等于\n\n' , '\nmysql> SELECT 1=0, 1=1, 1=NULL;\n+-----+-----+--------+\n| 1=0 | 1=1 | 1=NULL |\n+-----+-----+--------+\n|   0 |   1 |   NULL |\n+-----+-----+--------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (100,42,  '>=' , '\n  大于等于\n\n' , '\nmysql> SELECT 1>=0, 1>=1, 1>=2, 1>=NULL;\n+------+------+------+---------+\n| 1>=0 | 1>=1 | 1>=2 | 1>=NULL |\n+------+------+------+---------+\n|    1 |    1 |    0 |    NULL |\n+------+------+------+---------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (101,42,  '>' , '\n  大于\n\n' , '\nmysql> SELECT 1>0, 1>1, 1>2, 1>NULL;\n+-----+-----+-----+--------+\n| 1>0 | 1>1 | 1>2 | 1>NULL |\n+-----+-----+-----+--------+\n|   1 |   0 |   0 |   NULL |\n+-----+-----+-----+--------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (102,42,  '<=' , '\n  小于等于\n\n' , '\nmysql> SELECT 1<=0, 1<=1, 1<=2, 1<=NULL;\n+------+------+------+---------+\n| 1<=0 | 1<=1 | 1<=2 | 1<=NULL |\n+------+------+------+---------+\n|    0 |    1 |    1 |    NULL |\n+------+------+------+---------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (103,42,  '<' , '\n  小于\n\n' , '\nmysql> SELECT 1<0, 1<1, 1<2, 1<NULL;\n+-----+-----+-----+--------+\n| 1<0 | 1<1 | 1<2 | 1<NULL |\n+-----+-----+-----+--------+\n|   0 |   0 |   1 |   NULL |\n+-----+-----+-----+--------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (104,42,  '!=或<>' , '\n  不等于\n\n' , '\nmysql> select 1!=0, 1!=1, 1<>0, 1<>1,1!=NULL, 1<>NULL;\n+------+------+------+------+---------+---------+\n| 1!=0 | 1!=1 | 1<>0 | 1<>1 | 1!=NULL | 1<>NULL |\n+------+------+------+------+---------+---------+\n|    1 |    0 |    1 |    0 |    NULL |    NULL |\n+------+------+------+------+---------+---------+\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (105,42,  'BETWEEN … AND …' , '\n  [NOT] BETWEEN … AND …\n\n  判断是否存在或者不存在于指定范围。\n\n' , '\nmysql> SELECT 2 BETWEEN 1 AND 2,\n3 NOT BETWEEN 1 AND 2,\n1 BETWEEN null AND 0,\n1 NOT BETWEEN null AND 0\G;\n*************************** 1. row ***************************\n2 BETWEEN 1 AND 2: 1\n3 NOT BETWEEN 1 AND 2: 1\n1 BETWEEN null AND 0: 0\n1 NOT BETWEEN null AND 0: 1\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (106,42,  'IN' , '\n  [NOT] IN\n\n  判断是否存在于指定集合。\n\n' , '\nmysql> SELECT 2 IN (1, 2), 3 IN (1, 2)\G;\n*************************** 1. row ***************************\n2 IN (1, 2): 1\n3 IN (1, 2): 0\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (107,42,  'IS [NOT] NULL | TRUE | FALSE | UNKNOWN' , '\n  IS [NOT] NULL | TRUE | FALSE | UNKNOWN\n\n  判断是否为NULL、真、假或未知。如果执行成功，结果是TRUE或者FALSE，不会出现NULL。\n\n  注意：左参数必须是BOOL类型，或者是NULL，否则报错\n\n' , '\nNULL IS NULL, NULL IS TRUE,\n(0>1) IS FALSE, \nNULL IS UNKNOWN,\n0 IS NOT NULL, \nNULL IS NOT NULL,\nNULL IS NOT TRUE,\n(0>1) IS NOT FALSE,\nNULL IS NOT UNKNOWN\G;\n*************************** 1. row ***************************\n          0 IS NULL: 0\n       NULL IS NULL: 1\n       NULL IS TRUE: 0\n     (0>1) IS FALSE: 1\n    NULL IS UNKNOWN: 1\n      0 IS NOT NULL: 1\n   NULL IS NOT NULL: 0\n   NULL IS NOT TRUE: 1\n (0>1) IS NOT FALSE: 0\nNULL IS NOT UNKNOWN: 0\n1 row in set (0.00 sec)\n\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (108,44,  'Vector Comparison Operators' , '\n  向量比较运算符对两个向量（ROW）进行比较，支持“<”、“ >”、“=”、“<=”、“>=”、“!=”、 “<=>”、“in”和“not in”等8个操作符。这几个操作符都是二元操作符，被比较的两个向量的维度要求相同。\n“<=>”表示NULL-safe equal.这个操作符和=操作符执行相同的比较操作，不过在两个操作码均为NULL时，其所得值为1而不为NULL，而当一个操作码为NULL时，其所得值为0而不为NULL。\n\n  表达式（1，2）和ROW（1，2）有时被称为行构造符。两者是等同的，在其它的语境中，也是合法的。例如，以下两个语句在语义上是等同的（但是目前只有第二个语句可以被优化）：\n\n  SELECT * FROM t1 WHERE (column1, column2) = (1, 1);\n  SELECT * FROM t1 WHERE column1 = 1 AND column2 = 1;\n  向量比较操作符和普通操作符相比主要有以下不同：\n\n• 如果两个操作数的第i个标量的比较就决定了比较结果，则不再继续比较后续的数值。\n\n  向量比较操作符需要注意以下几点：\n\n• 多元向量比较，关键字ROW可以省略。例如，ROW(1,2,3) < ROW(1,3,5)等价于(1,2,3) < (1,3,4)。\n\n• in/not in操作一定是向量操作，表示左参数（不）在右集合内，集合用“（）”括起。例如，Row(1) in (Row(2), Row(3), Row(1))，等价与1 in (2, 3, 1)。\n\n• in/not in操作需要左右操作数对应位置的标量都是可以比较的，否则返回错误。例如，ROW(1,2) in (ROW(1,2), ROW(2,3), ROW(3,4))成功，ROW(1,2) in (ROW(2,1), ROW(2,3), ROW(1,3,4))失败。\n\n\n' , '\nmysql> SELECT ROW(1,2) < ROW(1, 3),\n    -> ROW(1,2,10) < ROW(1, 3, 0),\n    -> ROW(1,null) < ROW(1,0),\n    -> ROW(null, 1) < ROW(null, 2),\n    -> ROW(1,2) in (ROW(1,2), ROW(2,3), ROW(3,4), ROW(4,5)),\n    -> 1 in (1,2,3),\n    -> 1 not in (2,3,4),\n    -> ROW(1,2) not in (ROW(2,1),ROW(2,3), ROW(3,4)),\n    -> NULL = NULL,\n    -> NULL <=> NULL,\n    -> NULL <=> 1,\n    -> 1 <=> 0 \G;\n*************************** 1. row ***************************\n                                ROW(1,2) < ROW(1, 3): 1\n                          ROW(1,2,10) < ROW(1, 3, 0): 1\n                              ROW(1,null) < ROW(1,0): NULL\n                         ROW(null, 1) < ROW(null, 2): NULL\nROW(1,2) in (ROW(1,2), ROW(2,3), ROW(3,4), ROW(4,5)): 1\n                                        1 in (1,2,3): 1\n                                    1 not in (2,3,4): 1\n       ROW(1,2) not in (ROW(2,1),ROW(2,3), ROW(3,4)): 1\n                                         NULL = NULL: NULL\n                                       NULL <=> NULL: 1\n                                          NULL <=> 1: 0\n                                             1 <=> 0: 0\n1 row in set (0.00 sec)\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (109,47,  'Bit Operators' , '\n  对于比特运算，OceanBase使用BITINT（64比特）算法，这些操作符的最大范围是64比特。\n\n表 位运算符及函数\n\n表达式 含义 举例\n\nBIT_COUNT(N) 返回参数N中设置的比特数。 SELECT BIT_COUNT(29);\n  -> 4\n\n& 位运算符与。 SELECT 29 & 15;\n  -> 13\n结果为一个64比特无符号整数。\n\n~ 反转所有比特。 SELECT 29 & ~15;\n  -> 16\n  结果为一个64比特无符号整数。\n\n| 位运算或。 SELECT 29 | ~15;\n  -> 31\n  结果为一个64比特无符号整数。\n\n^ 位运算异或。 SELECT 1 ^ 1;\n  -> 0\n  结果为一个64比特无符号整数。\n\n<<  把一个BIGINT数左移两位。 SELECT 1 << 2;\n  -> 4\n  其结果为一个64比特无符号整数。\n\n>>  把一个BIGINT数右移两位。 SELECT 4 << 2;\n  -> 1\n  其结果为一个64比特无符号整数。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (110,46,  'Operator Precedence' , '\n表 优先级\n优先级 运算符\n15 !\n14 -(负号), ~\n13 ^\n12 *，/，%，MOD\n11 +，-\n10 <<, >>\n9 &\n8 |\n7 =(比较运算符等于)，<=>,>，>=，<，<=，<>，!=，IS，LIKE，REGEXP，IN\n6 BETWEEN\n5 NOT\n4 AND, &&\n3 XOR\n2 OR, ||\n1 =（赋值运算符）\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (111,6,  'CREATE DATABASE' , '语法：\n\n  CREATE DATABASE [IF NOT EXISTS] dbname \n      [create_specification_list];\n\n  create_specification_list: \n      create_specification [, create_specification…]\n\n  create_specification: \n      [DEFAULT] {CHARACTER SET | CHARSET} [=] charsetname \n      | [DEFAULT] COLLATE [=] collationname\n      | REPLICA_NUM [=] num \n      | PRIMARY_ZONE [=] zone\n\n  CREATE DATABASE用于创建数据库，并可以指定数据库的默认属性（如数据库默认字符集等）；REPLICA_NUM指定副本数；PRIMARY_ZONE指定主集群。\n' , '\ncreate database test2 default CHARACTER SET UTF8;\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (112,6,  'ALTER DATABASE' , '\n  语法：\n\n  ALTER DATABASE [dbname] \n     alter_specification_list;\n\n  alter_specification_list: \n      alter_specification [, alter_specification…]\n\n  alter_specification: \n      [DEFAULT] CHARACTER SET charsetname\n      | [DEFAULT] COLLATE [=] collationname \n      | REPLICA_NUM [=] num, \n      | PRIMARY_ZONE [=] zone\n      | {READ ONLY | READ WRITE}\n\n  修改database的属性，如字符集、校对规则、REPLICA_NUM指定副本数，PRIMARY_ZONE指定主集群等。\n\n  数据库名称可以忽略，此时，语句对应于当前默认数据库。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (113,6,  'DROP DATABASE' , '\n  语法：\n\n  DROP DATABASE [IF EXISTS] dbname\n\n  DROP DATABASE用于取消数据库中的所用表格和取消数据库。\n\n  IF EXISTS用于防止当数据库不存在时发生错误。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (114,6,  'CREATE TABLE' , '\n  语法：\n\n  CREATE TABLE [IF NOT EXIST] tblname \n    (create_definition,...)\n    [table_options] \n    [partition_options];\n\n  CREATE TABLE [IF NOT EXISTS] tblname\n    LIKE oldtblname;\n\n  create_definition: \n    colname column_definition\n    | PRIMARY KEY (index_col_name,...) [index_option]... \n    | {INDEX|KEY} [indexname] (index_col_name,...) [index_option]...\n    | UNIQUE {INDEX|KEY} [indexname] (index_col_name,...) [index_option]... \n\n  column_definition: \n      data_type [NOT NULL | NULL] [DEFAULT defaultvalue] \n      [AUTO_INCREMENT] [UNIQUE [KEY]][[PRIMARY] KEY] \n      [COMMENT ‘string’] \n\n  data_type: \n    TINYINT[(length)] [UNSIGNED] [ZEROFILL] \n    | SMALLINT[(length)] [UNSIGNED] [ZEROFILL] \n    | MEDIUMINT[(length)] [UNSIGNED] [ZEROFILL] \n    | INT[(length)] [UNSIGNED] [ZEROFILL] \n    | INTEGER[(length)] [UNSIGNED] [ZEROFILL] \n    | BIGINT[(length)] [UNSIGNED] [ZEROFILL] \n    | REAL[(length,decimals)] [UNSIGNED] [ZEROFILL] \n    | DOUBLE[(length,decimals)] [UNSIGNED] [ZEROFILL] \n    | FLOAT[(length,decimals)] [UNSIGNED] [ZEROFILL] \n    | DECIMAL[(length[,decimals])] [UNSIGNED] [ZEROFILL] \n    | NUMERIC[(length[,decimals])] [UNSIGNED] [ZEROFILL] \n    | DATE\n    | TIME[(fsp)] \n    | TIMESTAMP[(fsp)] \n    | DATETIME[(fsp)] \n    | YEAR\n    | CHAR[(length)] \n      [CHARACTER SET charset_name] [COLLATE collation_name] \n    | VARCHAR(length) \n      [CHARACTER SET charset_name] [COLLATE collation_name] \n    | BINARY[(length)] \n    | VARBINARY(length)\n\n  index_col_name: \n     col_name [(length)] [ASC | DESC]\n\n  index_option: \n    GLOBAL [LOCAL] \n    | COMMENT \'string\'\n    | COMPRESS_METHOD [=] {none | lz4_1.0 | lzo_1.0 | snappy_1.0 | zlib_1.0}\n    | BLOCK_SIZE [=] size\n    | STORING(columname_list)\n\n  table_options: \n     table_option [[,] table_option]...\n\n  table_option: \n    CHARACTER_SET [=] value\n    | COMMENT [=] ’string’ \n    | COMPRESSION [=] {none | lz4_1.0 | lzo_1.0 | snappy_1.0|zlib_1.0}\n    | EXPIRE_INFO [=] expr\n    | REPLICA_NUM [=] num\n    | TABLE_ID [=] id\n    | BLOCK_SIZE [=] size\n    | USE_BLOOM_FILTER [=] {0| 1}\n    | STEP_MERGE_NUM [=] num\n    | TABLEGROUP [=] tablegroupname\n    | ZONE_LIST [=] (zone [, zone…]), \n    | PRIMARY_ZONE [=] ‘zone’; \n    | AUTO_INCREMENT [=] num\n\n  partition_options: \n     PARTITION BY\n         HASH(expr) \n         | KEY(column_list) \n         [PARTITIONS num] \n         [partition_definition ...]\n\n  partition_definition: \n     COMMENT [=] ‘string’\n\n\n  该语句用于在OceanBase数据库中创建新表。\n\n• 使用“IF NOT EXISTS”时，即使创建的表已经存在，也不会报错，如果不指定时，则会报错。\n\n• NOT NULL，DEFAULT，AUTO_INCREMENT用于列的完整性约束。\n\n• “table_option”内容请参见表 表选项，各子句间用“,”隔开。\n\n• “index_option”中，可以指定GLOBAL，LOCAL关键字，表述全局或局部索引。默认是GLOBAL index. 创建带有Parition的表时index一定要加LOCAL关键字。如果没有加，系统将报错。\n\n   表 表选项\n\n参数 含义 举例\n\nCHARACTER_SET 指定该表所有字符串的编码，用于对外提供元数据信息。目前仅支持UTF8MB4。 CHARACTER_SET = \'utf8mb4\'\nCOMMENT 添加注释信息。 COMMENT=\'create by Bruce\'\nCOMPRESS_METHOD 存储数据时使用的压缩方法名，目前提供的方法有以下几种：\n• none（默认值，表示不作压缩）\n• lz4_1.0\n• lzo_1.0\n• snappy_1.0\n• zlib_1.0 \nCOMPRESSION = \'none\'\n\nEXPIRE_INFO 在MemTable中的动态数据和SSTable中的静态数据合并时，满足表达式的行会自动删除。\n一般可用于自动删除过期数据。 expire_info c1 < date_add(merging_frozen_time(),interval -1 HOUR);\nmerging_frozen_time()表示当前最新的合并时间，此函数只试用于过期条件。\n\nTABLE_ID 指定表的ID。如果指定的table_id小于1000，需要打开RootServer的配置项开关“ddl_system_table_switch”。 TABLE_ID =4000\n\nBLOCK_SIZET 设置Partition的微块大小。 默认为16K。\n\nUSE_BLOOM_FILTER 对本表读取数据时，是否使用Bloom Filter。\n• 0：默认值，不使用。\n• 1：使用。 USE_BLOOM_FILTER = 0\n\nSTEP_MERGE_NUM 设置渐近合并步数。\nSTEP_MERGE_NUM现在在限制是1~64。 默认值为1。\nSTEP_MERGE_NUM = 5\n\nTABLEGROUP 表所属表格组。 \n\nREPLICA_NUM 这个表的partition总副本数，默认值为3。 REPLICA_NUM = 3\n\nZONE_LIST 集群列表 \n\nPRIMARY_ZONE 主集群。 \n\nAUTO_INCREMENT  自增字段初始值 AUTO_INCREMENT = 5\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (115,6,  'ALTER TABLE' , '\nALTER TABLE tblname\nalter_specification [, alter_specification]... ;\n\nalter_specification: \n   ADD [COLUMN] colname column_definition \n  | ADD [COLUMN] (colname column_definition,...) \n  | ADD [UNIQUE]{INDEX|KEY} [indexname] (index_col_name,...) [index_options]\n  | ADD PRIMARY KEY (index_col_name,...) [index_options]\n  | ALTER [COLUMN] colname {SET DEFAULT literal | DROP DEFAULT}\n  | CHANGE [COLUMN] oldcolname newcolname column_definition\n  | MODIFY [COLUMN] colname column_definition  \n  | DROP [COLUMN] colname\n  | DROP PRIMARY KEY\n  | DROP INDEX indexname\n  | RENAME [TO] newtblname\n  | ORDER BY colname\n  | CONVERT TO CHARACTER SET charsetname [COLLATE collationname] \n  | [DEFAULT] CHARACTER SET charsetname [COLLATE collationname] \n  | table_options\n  | partition_options\n  | ADD TABLEGROUP tablegroupname\n  | MODIFY TABLEGROUP tablegroupname\n  | DROP TABLEGROUP tablegroupname\n\ncolumn_definition: \n     data_type [NOT NULL | NULL] [DEFAULT defaultvalue] \n      [AUTO_INCREMENT] [UNIQUE [KEY]] [[PRIMARY] KEY] \n      [COMMENT ‘string’] \n\ntable_options: \n     [SET] table_option [[,] table_option]... \n\ntable_option: \nCHARACTER_SET [=]charsetname\n| COMMENT [=] ’string’ \n| COMPRESS_METHOD [=] {NONE | LZ4_1.0 | LZO_1.0 | SNAPPY_1.0|ZLIB_1.0}\n| EXPIRE_INFO [=] expr\n| REPLICA_NUM [=] num\n| TABLE_ID [=] id\n| BLOCK_SIZE [=] size\n| USE_BLOOM_FILTER [=] {0| 1}\n| STEP_MERGE_NUM [=] num\n| TABLEGROUP [=] tablegroupname\n| ZONE_LIST [=] (zone [, zone…]) \n| PRIMARY_ZONE [=] zone \n| AUTO_INCREMENT [=] num\n| {READ ONLY | READ WRITE}\n\npartition_options: \n     PARTITION BY\n         HASH(expr) \n         | KEY(column_list) \n         [PARTITIONS num] \n        [partition_definition ...]\n\npartition_definition: \n COMMENT [=] ‘commenttext’\n\n\n1. 增加列\nALTER TABLE tblname \n    ADD [COLUMN] colname data_type \n    [NOT NULL | NULL] \n    [DEFAULT defaultvalue] \n• data_type请参见“数据类型”章节\n2. 修改列属性\nALTER TABLE tblname\n    ALTER [COLUMN] colname \n    [SET DEFAULT literal| DROP DEFAULT]\n3. 修改列类型\nALTER TABLE tblname\n        MODIFY colname column_definition\n4. 删除列\nALTER TABLE tblname\n    DROP [COLUMN] colname \n• 不允许删除主键列或者包含索引的列。\n5. 表重命名\nALTER TABLE tblname\n        RENAME TO newtblname\n6. 列重命名\nALTER TABLE tblname\n    CHANGE [COLUMN] oldcolname newcolname column_definition\n例1：\nALTER TABLE t2 CHANGE COLUMN d c CHAR(10); \n#把表t2的字段d改名为c，并同时修改了字段类型\n7. 设置过期数据删除\nALTER TABLE tblname\n    SET EXPIRE_INFO [ = ] expr\n例1：\nCREATE TABLE example_1(custid INT            \n    , thedate TIMESTAMP\n    , cost INT \n    , PRIMARY KEY(custid, thedate)\n     ) EXPIRE_INFO = thedate < date_sub(merging_frozen_time(), INTERVAL 2 DAY), \n     USE_BLOOM_FILTER = FALSE;\n (thedate < date_sub(merging_frozen_time(), INTERVAL 2 DAY))，表示删除（过期）thedate字段值为冻结时间2天前的数据，删除数据动作在数据合并时候真正执行。\n修改过期条件\nalter table example_1 set EXPIRE_INFO = thedate < date_sub(merging_frozen_time(), INTERVAL 1 DAY) //删除（过期）thedate字段值为1天前的数据。\n8. 设置Partition表BLOCK大小\nALTER TABLE tblname\n    SET BLOCK_SIZE [=] blocksize\n9. 设置该表的副本数\nALTER TABLE tblname\n    SET REPLICA_NUM [ = ] num\n这里是指表的副本总数多少\n10. 设置该表的压缩方式\nALTER TABLE tblname\n    SET COMPRESS_METHOD [=] {\'none\' | \'lz4_1.0\' | \'lzo_1.0\' | \'snappy_1.0\'|\'zlib_1.0\'}\n11. 设置是否使用BloomFilter\nALTER TABLE tblname\n    SET USE_BLOOM_FILTER [=] {0 | 1}\n其中0表示关闭，1表示使用。\n12. 设置注释信息\nALTER TABLE tblname\n    SET COMMENT [=] \'commentstring\'\n13. 设置渐进合并步数\nALTER TABLE tblname\n       SET STEP_MERGE_NUM [=] num\n此功能是设置渐近合并步数，STEP_MERGE_NUM现在在限制是1~64。\n14. 设置表的ZONE属性 \nALTER TABLE tblname\n      zone_specification...;\n\nzone_specification: \n    ZONE_LIST [=] (zone [, zone…]), \n    | PRIMARY_ZONE [=] zone\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (116,6,  'DROP TABLE' , '\n语法：\nDROP TABLE [IF EXISTS] tbl_list;\n\ntbl_list: \n   tblname [, tblname …] \n该语句用于删除OceanBase数据库中的表。\n使用“IF EXISTS”时，即使要删除的表不存在，也不会报错，如果不指定时，则会报错。\n• 同时删除多个表时，用“,”隔开。\n\n' , '\nDROP TABLE IF EXISTS test;\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (117,6,  'CREATE INDEX' , '\n  索引是创建在表上的，对数据库表中一列或多列的值进行排序的一种结构。其作用主要在于提高查询的速度，降低数据库系统的性能开销。\n\n  OceanBase中，新创建的索引需要等待一次每日合并后，才生效。\n\n\n语法：\n\n  CREATE [UNIQUE] INDEX indexname \n     ON tblname (index_col_name,…) \n         [index_options];\n      \n  index_options: \n        index_option [index_option…]\n\n  index_option: \n       GLOBAL [LOCAL] \n       | COMMENT \'string\'\n       | COMPRESS_METHOD [=] {NONE | LZ4_1.0 | LZO_1.0 | SNAPPY_1.0 | ZLIB_1.0}\n       | BLOCK_SIZE [=] size\n       | STORING(columname_list)\n\n  columname_list: \n      colname [, colname…]\n\n  index_col_name: \n      colname [ASC | DESC] \n\n• index_col_name中，每个列名后都支持ASC（升序）和DESC（降序）。默认就为升序。\n\n• 本语句建立索引的排列方式为：首先以index_col_name中第一个列的值排序；该列值相同的记录，按下一列名的值排序；以此类推。\n\n• 执行“SHOW INDEX FROM tblname”可以查看创建的索引。\n\n• “index_option”中，可以指定GLOBAL，LOCAL关键字，表述全局或局部索引。默认是GLOBAL　index. 创建带有Parition的表时index一定要加LOCAL关键字。如果没有加，系统将报错。\n\n• 使用可选字段STORING，表示索引表中冗余存储某些列，以提高系统查询系统。\n\n' , '\n1. 执行以下命令，创建表test。\n\n  CREATE TABLE test (c1 int primary key, c2 varchar(10));\n\n2. 执行以下命令，创建表test的索引。\n\n  CREATE INDEX test_index ON test (c1, c2 DESC);\n\n3. 执行以下命令，查看表test的索引。\n\n  SHOW INDEX FROM test;\n\n\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (118,6,  'DROP INDEX' , '\n  当索引过多时，维护开销增大，因此，需要删除不必要的索引。\n\n  （删除索引的时候需要等待一段时间才能完全删除。）\n\n  语法：\n\n  DROP INDEX indexname \n   ON tblname;\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (119,6,  'CREATE VIEW' , '\n  语法：\n\n  CREATE [OR REPLACE] VIEW viewname\n      [(column_list)] AS select_stmt\n\n  创建试图语句，如果指定了OR REPLACE子句，该语句能够替换已有的视图。\n\n  select_stmt是一种SELECT语句。它给出了视图的定义。该语句可以从基表或其他视图进行选择。\n\n  视图必须具有唯一的列名，不得有重复，就像基表那样。默认情况下，由SELECT语句检索的列名将用作视图列名。要想为视图列定义明确的名称，可使用可选的column_list子句，列出由逗号隔开的ID。column_list中的名称数目必须等于SELECT语句检索的列数。\n\n  SELECT语句检索的列可以是对表列的简单引用。也可以是使用函数、常量值、操作符等的表达式。\n\n  视图在数据库中实际上并不是以表的形式存在。每次使用时它们就会派生。视图是作为在 CREATE VIEW 语句中指定的 SELECT 语句的结果而派生出来的。\n\n  OceanBase 1.0只支持不可更新视图。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (120,6,  'DROP VIEW' , '\n  语法:\n\n  DROP VIEW [IF EXISTS] \n    viewname [, viewname…] ;\n\n  DROP VIEW能够删除1个或多个视图。必须在每个视图上有DROP权限。\n\n  使用IF EXISTS关键字来防止因不存在的视图而出错。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (121,6,  'ALTER VIEW' , '\n语法：\n\n  ALTER VIEW viewname\n     [(column_list)] AS select_statement\n\n  该语句用于更改已有视图的定义。其语法与CREATE VIEW类似。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (122,6,  'TRUNCATE TABLE' , '\n  语法：\n\n  TRUNCATE [TABLE] tblname\n\n  该语句用于完全清空指定表，但是保留表结构，包括表中定义的Partition信息。从逻辑上说，该语句与用于删除所有行的DELETE FROM语句相同。执行TRUNCATE语句，必须具有表的删除和创建权限。它属于DDL语句。\n\n  TRUNCATE TABLE语句与DELETE FROM语句有以下不同：\n\n  删减操作会取消并重新创建表，这比一行一行的删除行要快很多。\n\n  TRUNCATE TABLE语句执行结果显示影响行数始终显示为0行。\n\n  使用TRUNCATE TABLE语句，表管理程序不记得最后被使用的AUTO_INCREMENT值，但是会从头开始计数。\n\n  TRUNCATE语句不能在进行事务处理和表锁定的过程中进行，如果使用，将会报错。\n\n  只要表定义文件是合法的，则可以使用TRUNCATE TABLE把表重新创建为一个空表，即使数据或索引文件已经被破坏。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (123,7,  'INSERT' , '\n  该语句用于添加一个或多个记录到表。\n\n  语法：\n\n  INSERT [INTO] tblname \n       [(colname,...)] \n       {VALUES|VALUE} ({expr | DEFAULT},...)\n       [ ON DUPLICATE KEY UPDATE\n           colname=expr\n           [, colname=expr] ... ] ;\n\n  [(colname,...)]用于指定插入数据的列。\n\n• 同时插入多列时，用“,”隔开。\n\n• 支持ON DUPLICATE KEY UPDATE\n\n• Insert语句后面不支持set操作\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (124,7,  'REPLACE' , '\n  REPLACE的运行与INSERT很相像。只有一点除外，如果表中的一个旧记录与一个用于PRIMARY KEY或一个UNIQUE索引的新记录具有相同的值，则在新记录被插入之前，旧记录被删除格式。\n\n  为了能够使用REPLACE，必须同时拥有表的INSERT和DELETE权限。\n\n  语法：\n\nREPLACE [INTO] tblname\n       [(colname,...)] \n      {VALUES|VALUE} ({expr | DEFAULT},...);\n\n• [(colname,...)]用于指定插入数据的列。\n\n• 同时替换多列时，用“,”隔开。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (125,7,  'UPDATE' , '\n  该语句用于修改表中的字段值。\n\n  语法：\n\n  UPDATE tblname\n     SET colname1={expr1|DEFAULT} \n     [, colname2={expr2|DEFAULT}] ... \n     [WHERE where_condition] \n     [ORDER BY order_list  [ASC|DESC]] \n     [LIMIT row_count]; \n\n  order_list: \n     colname [ASC|DESC] [, colname [ASC|DESC]…]\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (126,7,  'DELETE' , '\n  该语句用于删除表中符合条件的行。\n\n  语法：\n\n  DELETE FROM tblname  \n       [WHERE where_condition] \n       [ORDER BY order_list \n       [LIMIT row_count];\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (127,7,  'SELECT' , '\n  该语句用于查询表中的内容。\n \n  基本查询\n\n  语法：\n\n  SELECT \n    [ALL | DISTINCT] \n      selectexpr [AS othername] [, selectexpr ...] \n      [FROM table_references]\n        [WHERE where_conditions] \n    [GROUP BY group_by_list] \n    [HAVING search_confitions] \n    [ORDER BY order_list] \n    [LIMIT {[offset,] rowcount | rowcount OFFSET offset}]\n        [FOR UPDATE];\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (128,8,  'TRANSACTION' , ' \n  START TRANSACTION \n    [WITH CONSISTENT SNAPSHOT];\n  BEGIN [WORK] ; \n  COMMIT [WORK] ;\n  ROLLBACK [WORK]; \n\n• WITH CONSISTENT SNAPSHOT子句用于启动一个一致的读取。该子句的效果与发布一个START TRANSACTION，后面跟一个来自任何OceanBase表的SELECT的效果一样。OceanBase 1.0语法上支持 WITH CONSISTENT SNAPSHOT子句，其WITH CONSISTENT SNAPSHOT功能暂时还未实现。\n\n• BEGIN和BEGIN WORK被作为START TRANSACTION的别名受到支持，用于对事务进行初始化。START TRANSACTION是标准的SQL语法，并且是启动一个ad-hoc(点对点)事务的推荐方法。一旦开启事务，则随后的SQL数据操作语句（即INSERT，UPDATE，DELETE，不包括REPLACE）直到显式提交时才会生效。\n\n  提交当前事务语句格式如下：\n\n  COMMIT [WORK];\n\n  回滚当前事务语句格式如下：\n\n  ROLLBACK [WORK];\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (129,11,  'CREATE RESOURCE UNIT' , '\n  语法：\n\n  CREATE RESOURCE UNIT unitname \n     MAX_CPU [=] cpunum, \n     MEMORY_SIZE [=] memsize, \n     MAX_IOPS [=] iopsnum, \n     LOG_DISK_SIZE [=] disksize, \n     [MIN_CPU [=] cpunum,] \n     [MIN_IOPS [=] iopsnum];\n\n  创建资源单元时，MAX_CPU、MEMORY_SIZE、MAX_IOPS必须指定。MIN_CPU、MIN_IOPS可选，默认值和MAX_CPU、MEMORY_SIZE、MAX_IOPS保持一致。LOG_DISK_SIZE可选，默认值和MEMORY_SIZE保持一致\n\n' , '' , 'null'); INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (130,11,  'DROP RESOURCE UNIT' , '\n  语法：\n\n  DROP RESOURCE UNIT unitname;\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (131,11,  'CREATE RESOURCE POOL' , '\n  语法：\n\n  CREATE RESOURCE POOL poolname \n   UNIT [=] unitname, \n   UNIT_NUM [=] unitnum, \n   ZONE_LIST [=] (\'zone\' [, \'zone\'...]);\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (132,11,  'ALTER RESOURCE POOL' , '\n  语法：\n\n  ALTER RESOURCE POOL poolname \n    UNIT [=] unitname, \n    UNIT_NUM [=] unitnum, \n    ZONE_LIST [=] (\'zone\' [, \'zone\'...]);\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (133,11,  'DROP RESOURCE POOL' , '\n  语法：\n\n  DROP RESOURCE POOL poolname;\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (134,11,  'CREATE TENANT' , '\n  语法：\n\n  CREATE TENANT [IF NOT EXISTS] tenantname \n     [tenant_characteristic_list]\n     [tenant_variables_list]\n\n  tenant_characteristic_list: \n    tenant_characteristic [, tenant_characteristic...]\n\n  tenant_characteristic: \n    COMMENT \'string\' \n    | {CHARACTER SET | CHARSET} [=] value \n    | REPLICA_NUM [=] num \n    | ZONE_LIST [=] (zone [, zone\u2026]) \n    | PRIMARY_ZONE [=] zone\n    | RESOURCE_POOL_LIST [=] (poolname) \n    | {READ ONLY | READ WRITE} \n\n  tenant_variables_list: \n    SET sys_variables_list \n    | SET VARIABLES sys_variables_list \n    | VARIABLES sys_variables_list \n\n  sys_variables_list: \n    sys_variables [, sys_variables...] \n\n  sys_variables: \n    sys_variable_name = expr \n  \n  如果要创建的租户名已存在，并且没有指定IF NOT EXISTS，则会出现错误。\n\n  租户名的合法性和变量名一致，最长64个字节，字符只能有大小写英文字母，数字和下划线，而且必须以字母或下划线开头，并且不能OceanBase的关键字。\n\n  只有用root用户连接根到租户（root@ROOT）才能执行CREATE TENANT去创建租户。\n\n  说明：RESOURCE_POOL_LIST为创建租户时的必填项。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (135,11,  'ALTER TENANT' , '\n  语法：\n\n  ALTER TENANT tenantname [SET] \n      [tenant_characteristic_list]\n      [tenant_variables_list]\n\n  tenant_characteristic_list: \n    tenant_characteristic [, tenant_characteristic...]\n\n  tenant_characteristic: \n    COMMENT \'string\' \n    | {CHARACTER SET | CHARSET} [=] value \n    | REPLICA_NUM [=] num \n    | ZONE_LIST [=] (zone [, zone\u2026]) \n    | PRIMARY_ZONE [=] zone \n    | RESOURCE_POOL_LIST [=] (poolname)\n    | {READ ONLY | READ WRITE} \n  tenant_variables_list: \n    VARIABLES sys_variables_list \n\n  sys_variables_list: \n    sys_variables [, sys_variables...] \n\n  sys_variables: \n    sys_variable_name = expr \n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (136,11,  'LOCK/UNLOCK' , '\n\n  语法：\n\n  ALTER TENANT tenantname LOCK|UNLOCK；\n\n  对租户进行锁定，锁定后，不能在该租户上创建新的连接，已有连接保持不变。通常用在客户费用到期未续费的场景下使用，客户费用到期后对租户进行锁定，客户续费后再进行解锁。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (137,11,  'DROP TENANT' , '\n  语法：\n\n  DROP TENANT tenantname;\n\n  删除租户\n\n  只有用root用户连接到根租户（root@ROOT）才能执行CREATE TENANT去创建租户。\n\n  只能删除掉处理“锁定”状态下的租户，对非锁定状态下的租户执行DROP是则报错。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (138,11,  'CREATE TABLEGROUP' , '\n  语法：\n\n  CREATE TABLEGROUP [IF NOT EXISTS] tablegroupname\n\n  如果要创建的TableGroup名称已存在，并且没有指定IF NOT EXISTS，则会出现错误。\n\n  TableGroup名称最长64个字符，字符只能有大小写英文字母，数字和下划线，而且必须以字母或下划线开头，并且不能OceanBase的关键字。\n\n  只有租户下的管理员权限才可以创建TableGroup。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (139,11,  'DROP TABLEGROUP' , '\n  语法：\n\n  DROP TABLEGROUP [IF EXISTS] tablegroupname\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (140,11,  'ALTER TABLEGROUP' , '\n  语法：\n\n  ALTER TABLEGROUP tablegroupname ADD [TABLES] tblname [, tblname…]\n\n  该语句用于对一个tablegroup增加多张表。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (141,11,  'CREATE USER' , '\n  语法：\n\n  CREATE USER user_specification_list;\n\n  user_specification_list: \n    user_specification [, user_specification]…;\n\n  user_specification: \n    user IDENTIFIED BY \'authstring\'\n    user IDENTIFIED BY PASSWORD \'hashstring\'\n\n• 必须拥有全局的CREATE USER权限，才可以使用CREATE USER命令。\n\n• 新建用户后，“mysql.user”表会新增一行该用户的表项。如果同名用户已经存在，则报错。\n\n• 使用自选的IDENTIFIED BY子句，可以为账户给定一个密码。\n\n• user IDENTIFIED BY \'authstring\'此处密码为明文，存入“mysql.user”表后，服务器端会变为密文存储。\n\n• user IDENTIFIED BY PASSWORD \'hashstring\'此处密码为密文。\n\n• 同时创建多个用户时，用“,”隔开。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (142,11,  'DROP USER' , '\n  DROP USER语句用于删除一个或多个OceanBase用户。\n\n  语法：\n\n  DROP USER username [, username...];\n\n• 必须拥有全局的CREATE USER权限，才可以使用DROP USER命令。\n\n• 不能对“mysql.user”表进行DELETE方式进行权限管理。\n\n• 成功删除用户后，这个用户的所有权限也会被一同删除。\n\n• 同时删除多个用户时，用“,”隔开。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (143,11,  'SET PASSWORD' , '\n  语法：\n\n  SET PASSWORD [FOR user] = password_option;\n\n  password_option: {\n  PASSWORD(‘authstring’)\n  |’hashstring’}\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (144,11,  'RENAME USER' , '\n  语法：\n\n  RENAME USER \n      \'oldusername\' TO \'newusername\'\n      [,\'oldusername\' TO \'newusername\'...];\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (145,11,  'ALTER USER' , '\n  锁定或者解锁用户。\n\n  语法：\n\n  锁定用户\n\n  ALTER USER \'user\' LOCKED;\n\n  解锁用户\n\n  ALTER USER \'user\' UNLOCKED;\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (146,11,  'GRANT' , '\n  GRANT语句用于系统管理员授予User某些权限。\n\n  语法：\n\n  GRANT priv_type \n    ON priv_level \n    TO user_specification [, user_specification]... \n        [WITH with_option ...]\n\n\n  priv_level: \n       *\n      | *.*\n      | db_name.* \n      | db_name.tbl_name\n      | tbl_name\n\n  user_specification: \n    user [IDENTIFIED BY [PASSWORD] ‘password’] \n\n  with_option:\n    GRANT OPTION\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (147,11,  'REVOKE' , '\n  REVOKE语句用于系统管理员撤销User某些权限。\n\n  语法：\n\n  REVOKE priv_type \n     ON database.tblname \n     FROM \'user\';\n\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (148,11,  'SET' , '\n  修改用户变量：\n\n  用户变量用于保存一个用户自定义的值，以便于在以后引用它，这样可以将该值从一个语句传递到另一个语句。用户变量与连接有关，即一个客户端定义的用户变量不能被其它客户端看到或使用，当客户端退出时，该客户端连接的所有变量将自动释放。\n\n  语法：\n\n  SET @var_name = expr;\n\n• 用户变量的形式为@var_name，其中变量名var_name可以由当前字符集的文字数字字符、“.”、“_”和“$”组成。\n\n• 每个变量的expr可以为整数、实数、字符串或者NULL值。\n\n• 同时定义多个用户变量时，用“,”隔开。\n\n  修改系统变量：\n\n  OceanBase维护两种变量：\n\n  • 全局变量\n\n  影响OceanBase整体操作。当OceanBase启动时，它将所有全局变量初始化为默认值。修改全局变量，必须具有SUPER权限。\n\n  • 会话变量\n\n  影响当前连接到OceanBase的客户端。在客户端连接OceanBase时，使用相应全局变量的当前值对该客户端的会话变量进行初始化。设置会话变量不需要特殊权限，但客户端只能更改自己的会话变量，而不能更改其它客户端的会话变量。\n\n  语法：\n\n  设置全局变量的格式：\n\n  SET GLOBAL system_var_name = expr;\n\n  或者\n\n  SET @@GLOBAL.system_var_name = expr;\n\n  设置会话变量的格式：\n\n  SET [SESSION | @@SESSION. | LOCAL | LOCAL. | @@]system_var_name =expr;\n\n  查看系统变量值的格式，如果指定GLOBAL或SESSION修饰符，则分别打印全局或当前会话的系统变量值；如果没有修饰符，则显示当前会话值：\n\n  SHOW [GLOBAL | SESSION] \n    VARIABLES \n    [LIKE \'system_var_name\' | WHERE expr];\n\n' , '\n  1. 执行以下命令，修改回话变量中的SQL超时时间。\n\n  SET @@SESSION.ob_tx_timeout = 900000;\n\n  2. 执行以下命令，查看“ob_tx_timeout”的值。\n\n  SHOW VARIABLES LIKE \'ob_tx_timeout\';\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (149,11,  'ALTER SYSTEM' , '\n  ALTER SYSTEM语句主要对OceanBase发送命令，执行某项指定操作。\n\n系统级管理命令\n\n  ALTER SYSTEM BOOTSTRAP\n    {REGION [=] region ZONE [=] zone SERVER [=] \'ip:port\'\n      | ZONE [=] zone SERVER [=] \'ip:port\'}\n    [,{REGION [=] region ZONE [=] zone SERVER [=] \'ip:port\'\n      | ZONE [=] zone SERVER [=] \'ip:port\'}…]\n\n\nSchema管理\n\n  刷新Schema\n\n    ALTER SYSTEM REFRESH SCHEMA {SERVER [=] \'ip:port\' | ZONE [=] \'zone\'}\n\n  新增服务器\n\n    ALTER SYSTEM ADD SERVER \'ip:port\' [,\'ip:port\'…] [ZONE [=] \'zone\']\n\n    如果指定Zone，将会对待加入Server执行Zone校验。\n\n  删除&取消删除服务器\n\n    ALTER SYSTEM DELETE SERVER \'ip:port\' [,\'ip:port\'…] [ZONE [=] \'zone\']\n\n    ALTER SYSTEM CANCEL DELETE SERVER \'ip:port\' [,\'ip:port\'…] [ZONE [=] \'zone\']\n\n  开始/暂停服务\n\n    ALTER SYSTEM {START | STOP} SERVER \'ip:port\' [,\'ip:port\'…] [ZONE=\'zone\']\n\n    开始/暂停对外的服务.\n\n  升极虚拟表schema\n\n    ALTER SYSTEM UPGRADE VIRTUAL SCHEMA\n\nZone管理\n\n  新增Zone\n\n    ALTER SYSTEM ADD ZONE \'zone\' [REGION \'region\']\n\n  删除Zone\n\n    ALTER SYSTEM DELETE ZONE \'zone\'\n\n  主动上下线Zone\n\n    ALTER SYSTEM {START|STOP} ZONE \'zone\'\n\n  变更Zone属性\n\n    ALTER SYSTEM {ALTER|CHANGE|MODIFY} ZONE \'zone\' [SET] REGION \'new_region\'\n\nSession管理\n\n  结束Session\n\n  普通Tenant kill自己的Session\n\n    KILL [CONNECTION] \'sessionid\'\n\nPartition管理\n\n  Leader改选\n\n    ALTER SYSTEM SWITCH REPLICA {LEADER | FOLLOWER}\n      {PARTITION_ID [=] \'partidx%partcount@tableid\' SERVER [=] \'ip:port\'\n        | SERVER [=] \'ip:port\' [TENANT [=] \'tenant\']\n        | ZONE [=] \'zone\' [TENANT [=] \'tenant\']}\n\n  副本删除\n\n    ALTER SYSTEM DROP REPLICA\n      PARTITION_ID [=] \'partidx%partcount@tableid\' SERVER [=] \'ip:port\'\n      [CREATE_TIMESTAMP [=] ctimestamp] [ ZONE [=] \'zone\']\n\n    删除指定ObServer上的Replica，必须指定partition_id，ObServer地址以及create_timestamp。\n\n  副本迁移/复制\n\n    ALTER SYSTEM {MOVE|COPY} REPLICA\n    PARTITION_ID [=] \'partidx%partcount@tableid\'\n    SOURCE [=] \'ip:port\' DESTINATION [=] \'ip:port\'\n\n    Replica迁移或者复制，需要指定源ObServer和目的ObServer，以及partition_id。\n\n  副本汇报\n\n    ALTER SYSTEM REPORT REPLICA [SERVER [=] \'ip:port\' | ZONE [=] \'zone\']\n\n    强制要求某个ObServer或者某个Zone内的所有ObServer进行Replica汇报。\n\n  回收无用副本\n\n    ALTER SYSTEM RECYCLE REPLICA [SERVER [=] \'ip:port\' | ZONE [=] \'zone\']\n\n\n每日合并\n\n  发起每日合并\n\n    ALTER SYSTEM MAJOR FREEZE [IGNORE ip:port\' [,\'ip:port\'…]]\n\n  打开手动合并\n\n    ALTER SYSTEM SET ENABLE_MANUAL_MEREG=\'True\'\n\n  关闭手动合并\n\n    ALTER SYSTEM SET ENABLE_MANUAL_MEREG=\'False\'\n\n  开始每日合并\n\n    ALTER SYSTEM START MERGE ZONE [=] \'zone\'\n\n  暂停每日合并\n\n    ALTER SYSTEM SUSPEND MERGE [ZONE [=] \'zone\']\n\n  恢复每日合并\n\n    ALTER SYSTEM RESUME MERGE [ZONE [=] \'zone\']\n\n  清空roottable\n\n    ALTER SYSTEM CLEAR ROOTTABLE [TENANT [=] \'tenantname\']\n\n    清空roottable以后，汇报partition。\n\n内存管理\n\n  发起Partition转储\n\n    ALTER SYSTEM MINOR FREEZE\n      {PARTITION_ID [=] \'partidx%partcount@tableid\' SERVER [=] \'ip:port\'| SERVER [=] \'ip:port\' | ZONE [=] \'zone\'}\n\n  强制挤占一部分cache\n\n  通过动态修改Cache相关配置项实现\n\n  清空location缓存 (not implement)\n\n    ALTER SYSTEM CLEAR LOCATION CACHE [SERVER [=] \'ip:port\'| ZONE [=] \'zone\']\n\n配置项\n\n  修改系统级配置\n\n    ALTER SYSTEM SET param_name = expr [COMMENT \'text\']\n      [SCOPE = conf_scope] {SERVER = \'ip:port\' | ZONE = \'zone\'}\n\n    • 同时修改多个系统配置项时，用“,”隔开。\n\n  查看系统配置项的格式：\n\n    SHOW PARAMETERS [LIKE \'pattern\' | WHERE expr]\n\n租户级管理命令\n\n  修改租户级配置\n\n    ALTER SYSTEM SET param_name = expr\n      [COMMENT \'text\']\n      [SCOPE = conf_scope]\n      [TENANT = \'tenantname\']\n\n  打开/关闭迁移开关\n\n    ALTER SYSTEM SET ENABLE_MIGRATION = {\'true\'|\'false\'}\n      [TENANT=\'tenantname\']\n\n  打开/关闭复制开关\n\n    ALTER SYSTEM SET ENABLE_REPLICATION= {\'true\'|\'false\'}\n      [TENANT=\'tenantname\']\n\n  发起Tenant级转储\n\n    ALTER SYSTEM MINOR FREEZE TENANT= \'tenantname\'\n\nCACHE管理\n\n  清空KVCache.\n\n    ALTER SYSTEM FLUSH KVCACHE\n      [TENANT [=] [\'tenantname\'|tenantname]] [CACHE [=] \'cache\']\n\n    清空KVCache, 如果没有指定 TENANT 和 CACHE 则清楚所有CACHE.\n\nSERVER管理\n\n\n  杀死某个Query线程.\n\n    KILL QUERY expr\n\n重载信息\n\n  重新加载 unit 信息\n\n    ALTER SYSTEM RELOAD UNIT\n\n  重新加载 server 信息\n\n    ALTER SYSTEM RELOAD SERVER:\n\n  重新加载 zone 信息\n\n    ALTER SYSTEM RELOAD ZONE\n\n  刷新当前server的时区信息\n\n    ALTER SYSTEM REFRESH TIME_ZONE_INFO\n\nRS\n\n  Leader改选\n\n    ALTER SYSTEM SWITCH ROOTSERVICE {LEADER | FOLLOWER} {SERVER [=] \'ip:port\' | ZONE [=]\'zone\'}\n\n任务管理\n\n  跑后台任务\n\n    ALTER SYSTEM RUN JOB STRING_VAL {SERVER [=] \'ip:port\'| ZONE [=] \'zone\'}\n\n  开始/结束升级\n\n    ALTER SYSTEM {BEGING|END} UPGRADE\n\n  解除合并错误，继续合并\n\n    ALTER CLEAR MERGE ERROR_P\n\n  取消任务\n\n    ALTER SYSTEM CANCEL [PARTION MIGRATION] TASK \'string_value\'\n\n其他\n\n  发起unit迁移\n\n    ALTER SYSTEM MIGRATE UNIT [=] int DESTINATION [=] STRING_VALUE\n\n\n  设置内部trace point及触发错误码\n\n    ALTER SYSTEM SET_TP {{TP_NO|OCCUR|FREQUENCY|ERROR_CODE} [=] int}...\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (150,9,  'PREPARE' , '\n  语法：\n\nPREPARE stmt_name \n      FROM preparable_stmt;\n\n• preparable_stmt为SQL数据操作语句，需要用单引号（\'\'）引起。\n\npreparable_stmt只能预备一条sql语句，不支持多条语句。预备好的语句在整个SQL会话期间可以使用stmt_name这个名字来执行。\n\n• 预处理语句的范围是客户端会话。在此会话内，语句被创建。其它客户端看不到它。关闭会话，系统自动将预处理语句执行释放操作；在同一个会话中，另设置一个同名的stmt_name，即使不执行DEALLOCATE/DORP命令，它会被隐含地解除分配。如果新语句包含一个错误并且不能被预备，则会返回一个错误，并且不再存在带有给定名称的预备语句。\n\n• 数据操作语句（即SELECT, REPLACE, INSERT, UPDATE, DELETE）都可以被预备执行。\n\n• 在被预备的SQL语句中，可以使用问号（?）表明一个之后执行时才绑定的参数。问号只能出现在SQL语句的常量中。一个被预备的语句也可以不包含问号。\n\n' , '\n  依次使用PREPARE查询表a中id=2的行。\n\nPREPARE stmt1 FROM SELECT name FROM a WHERE id=?;\nSET @id = 2;\nEXECUTE stmt1 USING @id;\nDEALLOCATE PREPARE stmt1;\n\n\n' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (151,9,  'EXECUTE' , '\n  语法：\n\n  EXECUTE stmtname \n      [USING @varname [, @varname] ...];\n\n• 一个使用PREPARE语句预备好的SQL语句，可以使用EXECUTE语句执行。\n\n• 如果预备语句中有问号指明的绑定变量，需要使用USING子句指明相同个数的执行时绑定的值。USING子句后只能使用SET语句定义的用户变量。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (152,9,  'DEALLOCATE' , '\n  语法：\n\n  {DEALLOCATE | DROP} PREPARE stmt_name;\n\n  删除一个指定的预备语句。一旦删除，以后就不能再执行。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (153,12,  'SHOW' , '\n  主要用于查看OceanBase有关数据库、表、列或服务器状态的等信息。\n\nSHOW CHARACTER SET [like_or_where];\nSHOW COLLATION [like_or_where];\nSHOW [FULL] COLUMNS FROM tblname [FROM dbname] [like_or_where];\nSHOW CREATE DATABASE dbname;\nSHOW CREATE TABLE tblname;\nSHOW CREATE VIEW viewname;\nSHOW DATABASES [like_or_where];\nSHOW DATABASES STATUS [like_or_where];\nSHOW ERRORS [LIMIT [offset,] rowcount];\nSHOW GRANTS FOR user;\nSHOW INDEX FROM tblname [FROM dbname];\nSHOW PRIVILEGES;\nSHOW [FULL] PROCESSLIST;\nSHOW [GLOBAL | SESSION] STATUS [like_or_where];\nSHOW TABLE STATUS [FROM dbname] [like_or_where];\nSHOW [FULL] TABLES [FROM dbname] [like_or_where];\nSHOW [GLOBAL | SESSION] VARIABLES [like_or_where];\nSHOW WARNINGS [LIMIT [offset,] rowcount];\nSHOW CREATE TENANT tenantname;\nSHOW TENANT;\nSHOW TENANT STATUS;\n\nlike_or_where:\n    LIKE \'pattern\'\n   | WHERE expr\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (154,12,  'KILL' , '\n  语法：\n\n  KILL [GLOBAL | LOCAL] [CONNECTION | QUERY] \'sessionid\' \n\n  每个与OceanBase的连接都在一个独立的线程里运行，您可以使用SHOW PROCESSLIST;语句查看哪些线程正在运行，并使用KILL thread_id语句终止一个线程。\n\n• KILL CONNECTION与不含修改符的KILL一样：它会终止与给定的thread_id。\n\n• KILL QUERY会终止连接当前正在执行的语句，但是会保持连接的原状。\n如果您拥有PROCESS权限，则您可以查看所有线程。如果您拥有SUPER权限，您可以终止所有线程和语句。否则，您只能查看和终止您自己的线程和语句。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (155,12,  'DESCRIBE' , '  \n  语法：\n\n  {DESCRIBE | DESC | EXPLAIN} tblname [colname | wild];\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (156,12,  'USE' , '\n  语法：\n\n  USE dbname\n\n  USE dbname语句可以通告客户端把dbname数据库作为默认（当前）数据库使用，用于后续语句。该数据库保持为默认数据库，直到语段的结尾，或者直到发布一个不同的USE语句。\n\n' , '' , 'null');
INSERT INTO help_topic (help_topic_id,help_category_id,name,description,example,url) VALUES (157,12,  'SET TENANT' , '\n  语法：\n\n  SET [SESSION | GLOBAL] TENANT tenantname\n\n  切换租户\n\n' , '' , 'null');


INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (1,1);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (2,2);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (3,3);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (4,4);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (5,5);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (6,6);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (7,7);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (8,8);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (9,9);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (10,10);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (11,11);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (12,12);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (13,13);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (14,14);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (15,15);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (16,16);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (17,17);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (18,18);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (19,19);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (20,20);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (21,21);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (22,22);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (23,23);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (24,24);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (25,25);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (26,26);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (27,27);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (28,28);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (29,29);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (30,30);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (31,31);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (32,32);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (33,33);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (34,34);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (35,35);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (36,36);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (37,37);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (38,38);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (39,39);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (40,40);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (41,41);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (42,42);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (43,43);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (44,44);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (45,45);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (46,46);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (47,47);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (48,48);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (49,49);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (50,50);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (51,51);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (52,52);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (53,53);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (54,54);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (55,55);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (56,56);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (57,57);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (58,58);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (59,59);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (60,60);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (61,61);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (62,62);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (63,63);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (64,64);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (65,65);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (66,66);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (67,67);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (68,68);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (69,69);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (70,70);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (71,71);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (72,72);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (73,73);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (74,74);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (75,75);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (76,76);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (77,77);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (78,78);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (79,79);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (80,80);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (81,81);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (82,82);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (83,83);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (84,84);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (85,85);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (86,86);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (87,87);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (88,88);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (89,89);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (90,90);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (91,91);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (92,92);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (93,93);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (94,94);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (95,95);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (96,96);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (97,97);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (98,98);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (99,99);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (100,100);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (101,101);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (102,102);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (103,103);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (104,104);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (105,105);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (106,106);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (107,107);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (108,108);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (109,109);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (110,110);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (111,111);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (112,112);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (113,113);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (114,114);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (115,115);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (116,116);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (117,117);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (118,118);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (119,119);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (120,120);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (121,121);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (122,122);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (123,123);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (124,124);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (125,125);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (126,126);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (127,127);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (128,128);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (129,129);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (130,130);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (131,131);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (132,132);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (133,133);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (134,134);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (135,135);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (136,136);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (137,137);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (138,138);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (139,139);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (140,140);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (141,141);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (142,142);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (143,143);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (144,144);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (145,145);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (146,146);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (147,147);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (148,148);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (149,149);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (150,150);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (151,151);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (152,152);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (153,153);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (154,154);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (155,155);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (156,156);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (157,156);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (158,2);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (159,16);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (160,96);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (161,104);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (162,87);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (163,88);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (164,89);
INSERT INTO help_relation (help_keyword_id,help_topic_id) VALUES (165,136);

commit;
