/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// AcsFileAPIService AcsFileAPI service
type AcsFileAPIService service

type AcsFileAPIAcsFileFileAddRoleRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSourceHref string
	nestedRole *NestedRole
}

func (r AcsFileAPIAcsFileFileAddRoleRequest) NestedRole(nestedRole NestedRole) AcsFileAPIAcsFileFileAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r AcsFileAPIAcsFileFileAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.AcsFileFileAddRoleExecute(r)
}

/*
AcsFileFileAddRole Method for AcsFileFileAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param fileFileAlternateContentSourceHref
 @return AcsFileAPIAcsFileFileAddRoleRequest
*/
func (a *AcsFileAPIService) AcsFileFileAddRole(ctx context.Context, fileFileAlternateContentSourceHref string) AcsFileAPIAcsFileFileAddRoleRequest {
	return AcsFileAPIAcsFileFileAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		fileFileAlternateContentSourceHref: fileFileAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *AcsFileAPIService) AcsFileFileAddRoleExecute(r AcsFileAPIAcsFileFileAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{file_file_alternate_content_source_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"file_file_alternate_content_source_href"+"}", parameterValueToString(r.fileFileAlternateContentSourceHref, "fileFileAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFileCreateRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSource *FileFileAlternateContentSource
}

func (r AcsFileAPIAcsFileFileCreateRequest) FileFileAlternateContentSource(fileFileAlternateContentSource FileFileAlternateContentSource) AcsFileAPIAcsFileFileCreateRequest {
	r.fileFileAlternateContentSource = &fileFileAlternateContentSource
	return r
}

func (r AcsFileAPIAcsFileFileCreateRequest) Execute() (*FileFileAlternateContentSourceResponse, *http.Response, error) {
	return r.ApiService.AcsFileFileCreateExecute(r)
}

/*
AcsFileFileCreate Create a file alternate content source

Alternate Content Source ViewSet for File

ACS support is provided as a tech preview in pulp_file.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return AcsFileAPIAcsFileFileCreateRequest
*/
func (a *AcsFileAPIService) AcsFileFileCreate(ctx context.Context) AcsFileAPIAcsFileFileCreateRequest {
	return AcsFileAPIAcsFileFileCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return FileFileAlternateContentSourceResponse
func (a *AcsFileAPIService) AcsFileFileCreateExecute(r AcsFileAPIAcsFileFileCreateRequest) (*FileFileAlternateContentSourceResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *FileFileAlternateContentSourceResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/acs/file/file/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.fileFileAlternateContentSource == nil {
		return localVarReturnValue, nil, reportError("fileFileAlternateContentSource is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.fileFileAlternateContentSource
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFileDeleteRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSourceHref string
}

func (r AcsFileAPIAcsFileFileDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.AcsFileFileDeleteExecute(r)
}

/*
AcsFileFileDelete Delete a file alternate content source

Trigger an asynchronous delete ACS task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param fileFileAlternateContentSourceHref
 @return AcsFileAPIAcsFileFileDeleteRequest
*/
func (a *AcsFileAPIService) AcsFileFileDelete(ctx context.Context, fileFileAlternateContentSourceHref string) AcsFileAPIAcsFileFileDeleteRequest {
	return AcsFileAPIAcsFileFileDeleteRequest{
		ApiService: a,
		ctx: ctx,
		fileFileAlternateContentSourceHref: fileFileAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *AcsFileAPIService) AcsFileFileDeleteExecute(r AcsFileAPIAcsFileFileDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{file_file_alternate_content_source_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"file_file_alternate_content_source_href"+"}", parameterValueToString(r.fileFileAlternateContentSourceHref, "fileFileAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFileListRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r AcsFileAPIAcsFileFileListRequest) Limit(limit int32) AcsFileAPIAcsFileFileListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r AcsFileAPIAcsFileFileListRequest) Name(name string) AcsFileAPIAcsFileFileListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r AcsFileAPIAcsFileFileListRequest) NameContains(nameContains string) AcsFileAPIAcsFileFileListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r AcsFileAPIAcsFileFileListRequest) NameIcontains(nameIcontains string) AcsFileAPIAcsFileFileListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r AcsFileAPIAcsFileFileListRequest) NameIn(nameIn []string) AcsFileAPIAcsFileFileListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r AcsFileAPIAcsFileFileListRequest) NameStartswith(nameStartswith string) AcsFileAPIAcsFileFileListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r AcsFileAPIAcsFileFileListRequest) Offset(offset int32) AcsFileAPIAcsFileFileListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;last_refreshed&#x60; - Last refreshed * &#x60;-last_refreshed&#x60; - Last refreshed (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r AcsFileAPIAcsFileFileListRequest) Ordering(ordering []string) AcsFileAPIAcsFileFileListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r AcsFileAPIAcsFileFileListRequest) PulpHrefIn(pulpHrefIn []string) AcsFileAPIAcsFileFileListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r AcsFileAPIAcsFileFileListRequest) PulpIdIn(pulpIdIn []string) AcsFileAPIAcsFileFileListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r AcsFileAPIAcsFileFileListRequest) Fields(fields []string) AcsFileAPIAcsFileFileListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r AcsFileAPIAcsFileFileListRequest) ExcludeFields(excludeFields []string) AcsFileAPIAcsFileFileListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r AcsFileAPIAcsFileFileListRequest) Execute() (*PaginatedfileFileAlternateContentSourceResponseList, *http.Response, error) {
	return r.ApiService.AcsFileFileListExecute(r)
}

/*
AcsFileFileList List file alternate content sources

Alternate Content Source ViewSet for File

ACS support is provided as a tech preview in pulp_file.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return AcsFileAPIAcsFileFileListRequest
*/
func (a *AcsFileAPIService) AcsFileFileList(ctx context.Context) AcsFileAPIAcsFileFileListRequest {
	return AcsFileAPIAcsFileFileListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedfileFileAlternateContentSourceResponseList
func (a *AcsFileAPIService) AcsFileFileListExecute(r AcsFileAPIAcsFileFileListRequest) (*PaginatedfileFileAlternateContentSourceResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedfileFileAlternateContentSourceResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/acs/file/file/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFileListRolesRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSourceHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r AcsFileAPIAcsFileFileListRolesRequest) Fields(fields []string) AcsFileAPIAcsFileFileListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r AcsFileAPIAcsFileFileListRolesRequest) ExcludeFields(excludeFields []string) AcsFileAPIAcsFileFileListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r AcsFileAPIAcsFileFileListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.AcsFileFileListRolesExecute(r)
}

/*
AcsFileFileListRoles Method for AcsFileFileListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param fileFileAlternateContentSourceHref
 @return AcsFileAPIAcsFileFileListRolesRequest
*/
func (a *AcsFileAPIService) AcsFileFileListRoles(ctx context.Context, fileFileAlternateContentSourceHref string) AcsFileAPIAcsFileFileListRolesRequest {
	return AcsFileAPIAcsFileFileListRolesRequest{
		ApiService: a,
		ctx: ctx,
		fileFileAlternateContentSourceHref: fileFileAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *AcsFileAPIService) AcsFileFileListRolesExecute(r AcsFileAPIAcsFileFileListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{file_file_alternate_content_source_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"file_file_alternate_content_source_href"+"}", parameterValueToString(r.fileFileAlternateContentSourceHref, "fileFileAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFileMyPermissionsRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSourceHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r AcsFileAPIAcsFileFileMyPermissionsRequest) Fields(fields []string) AcsFileAPIAcsFileFileMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r AcsFileAPIAcsFileFileMyPermissionsRequest) ExcludeFields(excludeFields []string) AcsFileAPIAcsFileFileMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r AcsFileAPIAcsFileFileMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.AcsFileFileMyPermissionsExecute(r)
}

/*
AcsFileFileMyPermissions Method for AcsFileFileMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param fileFileAlternateContentSourceHref
 @return AcsFileAPIAcsFileFileMyPermissionsRequest
*/
func (a *AcsFileAPIService) AcsFileFileMyPermissions(ctx context.Context, fileFileAlternateContentSourceHref string) AcsFileAPIAcsFileFileMyPermissionsRequest {
	return AcsFileAPIAcsFileFileMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		fileFileAlternateContentSourceHref: fileFileAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *AcsFileAPIService) AcsFileFileMyPermissionsExecute(r AcsFileAPIAcsFileFileMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{file_file_alternate_content_source_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"file_file_alternate_content_source_href"+"}", parameterValueToString(r.fileFileAlternateContentSourceHref, "fileFileAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFilePartialUpdateRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSourceHref string
	patchedfileFileAlternateContentSource *PatchedfileFileAlternateContentSource
}

func (r AcsFileAPIAcsFileFilePartialUpdateRequest) PatchedfileFileAlternateContentSource(patchedfileFileAlternateContentSource PatchedfileFileAlternateContentSource) AcsFileAPIAcsFileFilePartialUpdateRequest {
	r.patchedfileFileAlternateContentSource = &patchedfileFileAlternateContentSource
	return r
}

func (r AcsFileAPIAcsFileFilePartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.AcsFileFilePartialUpdateExecute(r)
}

/*
AcsFileFilePartialUpdate Update a file alternate content source

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param fileFileAlternateContentSourceHref
 @return AcsFileAPIAcsFileFilePartialUpdateRequest
*/
func (a *AcsFileAPIService) AcsFileFilePartialUpdate(ctx context.Context, fileFileAlternateContentSourceHref string) AcsFileAPIAcsFileFilePartialUpdateRequest {
	return AcsFileAPIAcsFileFilePartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		fileFileAlternateContentSourceHref: fileFileAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *AcsFileAPIService) AcsFileFilePartialUpdateExecute(r AcsFileAPIAcsFileFilePartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFilePartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{file_file_alternate_content_source_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"file_file_alternate_content_source_href"+"}", parameterValueToString(r.fileFileAlternateContentSourceHref, "fileFileAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedfileFileAlternateContentSource == nil {
		return localVarReturnValue, nil, reportError("patchedfileFileAlternateContentSource is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedfileFileAlternateContentSource
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFileReadRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSourceHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r AcsFileAPIAcsFileFileReadRequest) Fields(fields []string) AcsFileAPIAcsFileFileReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r AcsFileAPIAcsFileFileReadRequest) ExcludeFields(excludeFields []string) AcsFileAPIAcsFileFileReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r AcsFileAPIAcsFileFileReadRequest) Execute() (*FileFileAlternateContentSourceResponse, *http.Response, error) {
	return r.ApiService.AcsFileFileReadExecute(r)
}

/*
AcsFileFileRead Inspect a file alternate content source

Alternate Content Source ViewSet for File

ACS support is provided as a tech preview in pulp_file.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param fileFileAlternateContentSourceHref
 @return AcsFileAPIAcsFileFileReadRequest
*/
func (a *AcsFileAPIService) AcsFileFileRead(ctx context.Context, fileFileAlternateContentSourceHref string) AcsFileAPIAcsFileFileReadRequest {
	return AcsFileAPIAcsFileFileReadRequest{
		ApiService: a,
		ctx: ctx,
		fileFileAlternateContentSourceHref: fileFileAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return FileFileAlternateContentSourceResponse
func (a *AcsFileAPIService) AcsFileFileReadExecute(r AcsFileAPIAcsFileFileReadRequest) (*FileFileAlternateContentSourceResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *FileFileAlternateContentSourceResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{file_file_alternate_content_source_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"file_file_alternate_content_source_href"+"}", parameterValueToString(r.fileFileAlternateContentSourceHref, "fileFileAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFileRefreshRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSourceHref string
}

func (r AcsFileAPIAcsFileFileRefreshRequest) Execute() (*TaskGroupOperationResponse, *http.Response, error) {
	return r.ApiService.AcsFileFileRefreshExecute(r)
}

/*
AcsFileFileRefresh Refresh metadata

Trigger an asynchronous task to create Alternate Content Source content.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param fileFileAlternateContentSourceHref
 @return AcsFileAPIAcsFileFileRefreshRequest
*/
func (a *AcsFileAPIService) AcsFileFileRefresh(ctx context.Context, fileFileAlternateContentSourceHref string) AcsFileAPIAcsFileFileRefreshRequest {
	return AcsFileAPIAcsFileFileRefreshRequest{
		ApiService: a,
		ctx: ctx,
		fileFileAlternateContentSourceHref: fileFileAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return TaskGroupOperationResponse
func (a *AcsFileAPIService) AcsFileFileRefreshExecute(r AcsFileAPIAcsFileFileRefreshRequest) (*TaskGroupOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *TaskGroupOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileRefresh")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{file_file_alternate_content_source_href}refresh/"
	localVarPath = strings.Replace(localVarPath, "{"+"file_file_alternate_content_source_href"+"}", parameterValueToString(r.fileFileAlternateContentSourceHref, "fileFileAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFileRemoveRoleRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSourceHref string
	nestedRole *NestedRole
}

func (r AcsFileAPIAcsFileFileRemoveRoleRequest) NestedRole(nestedRole NestedRole) AcsFileAPIAcsFileFileRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r AcsFileAPIAcsFileFileRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.AcsFileFileRemoveRoleExecute(r)
}

/*
AcsFileFileRemoveRole Method for AcsFileFileRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param fileFileAlternateContentSourceHref
 @return AcsFileAPIAcsFileFileRemoveRoleRequest
*/
func (a *AcsFileAPIService) AcsFileFileRemoveRole(ctx context.Context, fileFileAlternateContentSourceHref string) AcsFileAPIAcsFileFileRemoveRoleRequest {
	return AcsFileAPIAcsFileFileRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		fileFileAlternateContentSourceHref: fileFileAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *AcsFileAPIService) AcsFileFileRemoveRoleExecute(r AcsFileAPIAcsFileFileRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{file_file_alternate_content_source_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"file_file_alternate_content_source_href"+"}", parameterValueToString(r.fileFileAlternateContentSourceHref, "fileFileAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type AcsFileAPIAcsFileFileUpdateRequest struct {
	ctx context.Context
	ApiService *AcsFileAPIService
	fileFileAlternateContentSourceHref string
	fileFileAlternateContentSource *FileFileAlternateContentSource
}

func (r AcsFileAPIAcsFileFileUpdateRequest) FileFileAlternateContentSource(fileFileAlternateContentSource FileFileAlternateContentSource) AcsFileAPIAcsFileFileUpdateRequest {
	r.fileFileAlternateContentSource = &fileFileAlternateContentSource
	return r
}

func (r AcsFileAPIAcsFileFileUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.AcsFileFileUpdateExecute(r)
}

/*
AcsFileFileUpdate Update a file alternate content source

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param fileFileAlternateContentSourceHref
 @return AcsFileAPIAcsFileFileUpdateRequest
*/
func (a *AcsFileAPIService) AcsFileFileUpdate(ctx context.Context, fileFileAlternateContentSourceHref string) AcsFileAPIAcsFileFileUpdateRequest {
	return AcsFileAPIAcsFileFileUpdateRequest{
		ApiService: a,
		ctx: ctx,
		fileFileAlternateContentSourceHref: fileFileAlternateContentSourceHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *AcsFileAPIService) AcsFileFileUpdateExecute(r AcsFileAPIAcsFileFileUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "AcsFileAPIService.AcsFileFileUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{file_file_alternate_content_source_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"file_file_alternate_content_source_href"+"}", parameterValueToString(r.fileFileAlternateContentSourceHref, "fileFileAlternateContentSourceHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.fileFileAlternateContentSource == nil {
		return localVarReturnValue, nil, reportError("fileFileAlternateContentSource is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.fileFileAlternateContentSource
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
