/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ContentManifestsAPIService ContentManifestsAPI service
type ContentManifestsAPIService service

type ContentManifestsAPIContentContainerManifestsListRequest struct {
	ctx context.Context
	ApiService *ContentManifestsAPIService
	digest *string
	digestIn *[]string
	limit *int32
	mediaType *[]string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	repositoryVersion *string
	repositoryVersionAdded *string
	repositoryVersionRemoved *string
	fields *[]string
	excludeFields *[]string
}

// Filter results where digest matches value
func (r ContentManifestsAPIContentContainerManifestsListRequest) Digest(digest string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.digest = &digest
	return r
}

// Filter results where digest is in a comma-separated list of values
func (r ContentManifestsAPIContentContainerManifestsListRequest) DigestIn(digestIn []string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.digestIn = &digestIn
	return r
}

// Number of results to return per page.
func (r ContentManifestsAPIContentContainerManifestsListRequest) Limit(limit int32) ContentManifestsAPIContentContainerManifestsListRequest {
	r.limit = &limit
	return r
}

// * &#x60;application/vnd.docker.distribution.manifest.v1+json&#x60; - application/vnd.docker.distribution.manifest.v1+json * &#x60;application/vnd.docker.distribution.manifest.v2+json&#x60; - application/vnd.docker.distribution.manifest.v2+json * &#x60;application/vnd.docker.distribution.manifest.list.v2+json&#x60; - application/vnd.docker.distribution.manifest.list.v2+json * &#x60;application/vnd.oci.image.manifest.v1+json&#x60; - application/vnd.oci.image.manifest.v1+json * &#x60;application/vnd.oci.image.index.v1+json&#x60; - application/vnd.oci.image.index.v1+json
func (r ContentManifestsAPIContentContainerManifestsListRequest) MediaType(mediaType []string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.mediaType = &mediaType
	return r
}

// The initial index from which to return the results.
func (r ContentManifestsAPIContentContainerManifestsListRequest) Offset(offset int32) ContentManifestsAPIContentContainerManifestsListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;upstream_id&#x60; - Upstream id * &#x60;-upstream_id&#x60; - Upstream id (descending) * &#x60;timestamp_of_interest&#x60; - Timestamp of interest * &#x60;-timestamp_of_interest&#x60; - Timestamp of interest (descending) * &#x60;digest&#x60; - Digest * &#x60;-digest&#x60; - Digest (descending) * &#x60;schema_version&#x60; - Schema version * &#x60;-schema_version&#x60; - Schema version (descending) * &#x60;media_type&#x60; - Media type * &#x60;-media_type&#x60; - Media type (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ContentManifestsAPIContentContainerManifestsListRequest) Ordering(ordering []string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ContentManifestsAPIContentContainerManifestsListRequest) PulpHrefIn(pulpHrefIn []string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ContentManifestsAPIContentContainerManifestsListRequest) PulpIdIn(pulpIdIn []string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Repository Version referenced by HREF
func (r ContentManifestsAPIContentContainerManifestsListRequest) RepositoryVersion(repositoryVersion string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.repositoryVersion = &repositoryVersion
	return r
}

// Repository Version referenced by HREF
func (r ContentManifestsAPIContentContainerManifestsListRequest) RepositoryVersionAdded(repositoryVersionAdded string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.repositoryVersionAdded = &repositoryVersionAdded
	return r
}

// Repository Version referenced by HREF
func (r ContentManifestsAPIContentContainerManifestsListRequest) RepositoryVersionRemoved(repositoryVersionRemoved string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.repositoryVersionRemoved = &repositoryVersionRemoved
	return r
}

// A list of fields to include in the response.
func (r ContentManifestsAPIContentContainerManifestsListRequest) Fields(fields []string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentManifestsAPIContentContainerManifestsListRequest) ExcludeFields(excludeFields []string) ContentManifestsAPIContentContainerManifestsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentManifestsAPIContentContainerManifestsListRequest) Execute() (*PaginatedcontainerManifestResponseList, *http.Response, error) {
	return r.ApiService.ContentContainerManifestsListExecute(r)
}

/*
ContentContainerManifestsList List manifests

ViewSet for Manifest.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ContentManifestsAPIContentContainerManifestsListRequest
*/
func (a *ContentManifestsAPIService) ContentContainerManifestsList(ctx context.Context) ContentManifestsAPIContentContainerManifestsListRequest {
	return ContentManifestsAPIContentContainerManifestsListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedcontainerManifestResponseList
func (a *ContentManifestsAPIService) ContentContainerManifestsListExecute(r ContentManifestsAPIContentContainerManifestsListRequest) (*PaginatedcontainerManifestResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedcontainerManifestResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentManifestsAPIService.ContentContainerManifestsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/content/container/manifests/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.digest != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "digest", r.digest, "")
	}
	if r.digestIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "digest__in", r.digestIn, "csv")
	}
	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.mediaType != nil {
		t := *r.mediaType
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "media_type", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "media_type", t, "multi")
		}
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.repositoryVersion != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version", r.repositoryVersion, "")
	}
	if r.repositoryVersionAdded != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_added", r.repositoryVersionAdded, "")
	}
	if r.repositoryVersionRemoved != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "repository_version_removed", r.repositoryVersionRemoved, "")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ContentManifestsAPIContentContainerManifestsReadRequest struct {
	ctx context.Context
	ApiService *ContentManifestsAPIService
	containerManifestHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ContentManifestsAPIContentContainerManifestsReadRequest) Fields(fields []string) ContentManifestsAPIContentContainerManifestsReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ContentManifestsAPIContentContainerManifestsReadRequest) ExcludeFields(excludeFields []string) ContentManifestsAPIContentContainerManifestsReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ContentManifestsAPIContentContainerManifestsReadRequest) Execute() (*ContainerManifestResponse, *http.Response, error) {
	return r.ApiService.ContentContainerManifestsReadExecute(r)
}

/*
ContentContainerManifestsRead Inspect a manifest

ViewSet for Manifest.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param containerManifestHref
 @return ContentManifestsAPIContentContainerManifestsReadRequest
*/
func (a *ContentManifestsAPIService) ContentContainerManifestsRead(ctx context.Context, containerManifestHref string) ContentManifestsAPIContentContainerManifestsReadRequest {
	return ContentManifestsAPIContentContainerManifestsReadRequest{
		ApiService: a,
		ctx: ctx,
		containerManifestHref: containerManifestHref,
	}
}

// Execute executes the request
//  @return ContainerManifestResponse
func (a *ContentManifestsAPIService) ContentContainerManifestsReadExecute(r ContentManifestsAPIContentContainerManifestsReadRequest) (*ContainerManifestResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ContainerManifestResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ContentManifestsAPIService.ContentContainerManifestsRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{container_manifest_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"container_manifest_href"+"}", parameterValueToString(r.containerManifestHref, "containerManifestHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
