/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// ExportersFilesystemAPIService ExportersFilesystemAPI service
type ExportersFilesystemAPIService service

type ExportersFilesystemAPIExportersCoreFilesystemCreateRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemAPIService
	filesystemExporter *FilesystemExporter
}

func (r ExportersFilesystemAPIExportersCoreFilesystemCreateRequest) FilesystemExporter(filesystemExporter FilesystemExporter) ExportersFilesystemAPIExportersCoreFilesystemCreateRequest {
	r.filesystemExporter = &filesystemExporter
	return r
}

func (r ExportersFilesystemAPIExportersCoreFilesystemCreateRequest) Execute() (*FilesystemExporterResponse, *http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemCreateExecute(r)
}

/*
ExportersCoreFilesystemCreate Create a filesystem exporter

Endpoint for managing FilesystemExporters.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ExportersFilesystemAPIExportersCoreFilesystemCreateRequest
*/
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemCreate(ctx context.Context) ExportersFilesystemAPIExportersCoreFilesystemCreateRequest {
	return ExportersFilesystemAPIExportersCoreFilesystemCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return FilesystemExporterResponse
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemCreateExecute(r ExportersFilesystemAPIExportersCoreFilesystemCreateRequest) (*FilesystemExporterResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *FilesystemExporterResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemAPIService.ExportersCoreFilesystemCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/exporters/core/filesystem/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.filesystemExporter == nil {
		return localVarReturnValue, nil, reportError("filesystemExporter is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.filesystemExporter
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ExportersFilesystemAPIExportersCoreFilesystemDeleteRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemAPIService
	filesystemExporterHref string
}

func (r ExportersFilesystemAPIExportersCoreFilesystemDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemDeleteExecute(r)
}

/*
ExportersCoreFilesystemDelete Delete a filesystem exporter

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param filesystemExporterHref
 @return ExportersFilesystemAPIExportersCoreFilesystemDeleteRequest
*/
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemDelete(ctx context.Context, filesystemExporterHref string) ExportersFilesystemAPIExportersCoreFilesystemDeleteRequest {
	return ExportersFilesystemAPIExportersCoreFilesystemDeleteRequest{
		ApiService: a,
		ctx: ctx,
		filesystemExporterHref: filesystemExporterHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemDeleteExecute(r ExportersFilesystemAPIExportersCoreFilesystemDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemAPIService.ExportersCoreFilesystemDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{filesystem_exporter_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"filesystem_exporter_href"+"}", parameterValueToString(r.filesystemExporterHref, "filesystemExporterHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ExportersFilesystemAPIExportersCoreFilesystemListRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) Limit(limit int32) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) Name(name string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) NameContains(nameContains string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) NameIcontains(nameIcontains string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) NameIn(nameIn []string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) NameStartswith(nameStartswith string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) Offset(offset int32) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;path&#x60; - Path * &#x60;-path&#x60; - Path (descending) * &#x60;method&#x60; - Method * &#x60;-method&#x60; - Method (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) Ordering(ordering []string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) PulpHrefIn(pulpHrefIn []string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) PulpIdIn(pulpIdIn []string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) Fields(fields []string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) ExcludeFields(excludeFields []string) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ExportersFilesystemAPIExportersCoreFilesystemListRequest) Execute() (*PaginatedFilesystemExporterResponseList, *http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemListExecute(r)
}

/*
ExportersCoreFilesystemList List filesystem exporters

Endpoint for managing FilesystemExporters.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return ExportersFilesystemAPIExportersCoreFilesystemListRequest
*/
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemList(ctx context.Context) ExportersFilesystemAPIExportersCoreFilesystemListRequest {
	return ExportersFilesystemAPIExportersCoreFilesystemListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedFilesystemExporterResponseList
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemListExecute(r ExportersFilesystemAPIExportersCoreFilesystemListRequest) (*PaginatedFilesystemExporterResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedFilesystemExporterResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemAPIService.ExportersCoreFilesystemList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/exporters/core/filesystem/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ExportersFilesystemAPIExportersCoreFilesystemPartialUpdateRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemAPIService
	filesystemExporterHref string
	patchedFilesystemExporter *PatchedFilesystemExporter
}

func (r ExportersFilesystemAPIExportersCoreFilesystemPartialUpdateRequest) PatchedFilesystemExporter(patchedFilesystemExporter PatchedFilesystemExporter) ExportersFilesystemAPIExportersCoreFilesystemPartialUpdateRequest {
	r.patchedFilesystemExporter = &patchedFilesystemExporter
	return r
}

func (r ExportersFilesystemAPIExportersCoreFilesystemPartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemPartialUpdateExecute(r)
}

/*
ExportersCoreFilesystemPartialUpdate Update a filesystem exporter

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param filesystemExporterHref
 @return ExportersFilesystemAPIExportersCoreFilesystemPartialUpdateRequest
*/
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemPartialUpdate(ctx context.Context, filesystemExporterHref string) ExportersFilesystemAPIExportersCoreFilesystemPartialUpdateRequest {
	return ExportersFilesystemAPIExportersCoreFilesystemPartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		filesystemExporterHref: filesystemExporterHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemPartialUpdateExecute(r ExportersFilesystemAPIExportersCoreFilesystemPartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemAPIService.ExportersCoreFilesystemPartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{filesystem_exporter_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"filesystem_exporter_href"+"}", parameterValueToString(r.filesystemExporterHref, "filesystemExporterHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedFilesystemExporter == nil {
		return localVarReturnValue, nil, reportError("patchedFilesystemExporter is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedFilesystemExporter
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ExportersFilesystemAPIExportersCoreFilesystemReadRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemAPIService
	filesystemExporterHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r ExportersFilesystemAPIExportersCoreFilesystemReadRequest) Fields(fields []string) ExportersFilesystemAPIExportersCoreFilesystemReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r ExportersFilesystemAPIExportersCoreFilesystemReadRequest) ExcludeFields(excludeFields []string) ExportersFilesystemAPIExportersCoreFilesystemReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r ExportersFilesystemAPIExportersCoreFilesystemReadRequest) Execute() (*FilesystemExporterResponse, *http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemReadExecute(r)
}

/*
ExportersCoreFilesystemRead Inspect a filesystem exporter

Endpoint for managing FilesystemExporters.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param filesystemExporterHref
 @return ExportersFilesystemAPIExportersCoreFilesystemReadRequest
*/
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemRead(ctx context.Context, filesystemExporterHref string) ExportersFilesystemAPIExportersCoreFilesystemReadRequest {
	return ExportersFilesystemAPIExportersCoreFilesystemReadRequest{
		ApiService: a,
		ctx: ctx,
		filesystemExporterHref: filesystemExporterHref,
	}
}

// Execute executes the request
//  @return FilesystemExporterResponse
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemReadExecute(r ExportersFilesystemAPIExportersCoreFilesystemReadRequest) (*FilesystemExporterResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *FilesystemExporterResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemAPIService.ExportersCoreFilesystemRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{filesystem_exporter_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"filesystem_exporter_href"+"}", parameterValueToString(r.filesystemExporterHref, "filesystemExporterHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type ExportersFilesystemAPIExportersCoreFilesystemUpdateRequest struct {
	ctx context.Context
	ApiService *ExportersFilesystemAPIService
	filesystemExporterHref string
	filesystemExporter *FilesystemExporter
}

func (r ExportersFilesystemAPIExportersCoreFilesystemUpdateRequest) FilesystemExporter(filesystemExporter FilesystemExporter) ExportersFilesystemAPIExportersCoreFilesystemUpdateRequest {
	r.filesystemExporter = &filesystemExporter
	return r
}

func (r ExportersFilesystemAPIExportersCoreFilesystemUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.ExportersCoreFilesystemUpdateExecute(r)
}

/*
ExportersCoreFilesystemUpdate Update a filesystem exporter

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param filesystemExporterHref
 @return ExportersFilesystemAPIExportersCoreFilesystemUpdateRequest
*/
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemUpdate(ctx context.Context, filesystemExporterHref string) ExportersFilesystemAPIExportersCoreFilesystemUpdateRequest {
	return ExportersFilesystemAPIExportersCoreFilesystemUpdateRequest{
		ApiService: a,
		ctx: ctx,
		filesystemExporterHref: filesystemExporterHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *ExportersFilesystemAPIService) ExportersCoreFilesystemUpdateExecute(r ExportersFilesystemAPIExportersCoreFilesystemUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ExportersFilesystemAPIService.ExportersCoreFilesystemUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{filesystem_exporter_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"filesystem_exporter_href"+"}", parameterValueToString(r.filesystemExporterHref, "filesystemExporterHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.filesystemExporter == nil {
		return localVarReturnValue, nil, reportError("filesystemExporter is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.filesystemExporter
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
