/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the AptRepositorySyncURL type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AptRepositorySyncURL{}

// AptRepositorySyncURL A Serializer for AptRepository Sync.
type AptRepositorySyncURL struct {
	// A remote to sync from. This will override a remote set on repository.
	Remote *string `json:"remote,omitempty"`
	// If ``True``, synchronization will remove all content that is not present in the remote repository. If ``False``, sync will be additive only.
	Mirror *bool `json:"mirror,omitempty"`
	// Using optimize sync, will skip the processing of metadata if the checksum has not changed since the last sync. This greately improves re-sync performance in such situations. If you feel the sync is missing something that has changed about the remote repository you are syncing, try using optimize=False for a full re-sync. Consider opening an issue on why we should not optimize in your use case.
	Optimize *bool `json:"optimize,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _AptRepositorySyncURL AptRepositorySyncURL

// NewAptRepositorySyncURL instantiates a new AptRepositorySyncURL object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAptRepositorySyncURL() *AptRepositorySyncURL {
	this := AptRepositorySyncURL{}
	var mirror bool = false
	this.Mirror = &mirror
	var optimize bool = true
	this.Optimize = &optimize
	return &this
}

// NewAptRepositorySyncURLWithDefaults instantiates a new AptRepositorySyncURL object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAptRepositorySyncURLWithDefaults() *AptRepositorySyncURL {
	this := AptRepositorySyncURL{}
	var mirror bool = false
	this.Mirror = &mirror
	var optimize bool = true
	this.Optimize = &optimize
	return &this
}

// GetRemote returns the Remote field value if set, zero value otherwise.
func (o *AptRepositorySyncURL) GetRemote() string {
	if o == nil || IsNil(o.Remote) {
		var ret string
		return ret
	}
	return *o.Remote
}

// GetRemoteOk returns a tuple with the Remote field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AptRepositorySyncURL) GetRemoteOk() (*string, bool) {
	if o == nil || IsNil(o.Remote) {
		return nil, false
	}
	return o.Remote, true
}

// HasRemote returns a boolean if a field has been set.
func (o *AptRepositorySyncURL) HasRemote() bool {
	if o != nil && !IsNil(o.Remote) {
		return true
	}

	return false
}

// SetRemote gets a reference to the given string and assigns it to the Remote field.
func (o *AptRepositorySyncURL) SetRemote(v string) {
	o.Remote = &v
}

// GetMirror returns the Mirror field value if set, zero value otherwise.
func (o *AptRepositorySyncURL) GetMirror() bool {
	if o == nil || IsNil(o.Mirror) {
		var ret bool
		return ret
	}
	return *o.Mirror
}

// GetMirrorOk returns a tuple with the Mirror field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AptRepositorySyncURL) GetMirrorOk() (*bool, bool) {
	if o == nil || IsNil(o.Mirror) {
		return nil, false
	}
	return o.Mirror, true
}

// HasMirror returns a boolean if a field has been set.
func (o *AptRepositorySyncURL) HasMirror() bool {
	if o != nil && !IsNil(o.Mirror) {
		return true
	}

	return false
}

// SetMirror gets a reference to the given bool and assigns it to the Mirror field.
func (o *AptRepositorySyncURL) SetMirror(v bool) {
	o.Mirror = &v
}

// GetOptimize returns the Optimize field value if set, zero value otherwise.
func (o *AptRepositorySyncURL) GetOptimize() bool {
	if o == nil || IsNil(o.Optimize) {
		var ret bool
		return ret
	}
	return *o.Optimize
}

// GetOptimizeOk returns a tuple with the Optimize field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AptRepositorySyncURL) GetOptimizeOk() (*bool, bool) {
	if o == nil || IsNil(o.Optimize) {
		return nil, false
	}
	return o.Optimize, true
}

// HasOptimize returns a boolean if a field has been set.
func (o *AptRepositorySyncURL) HasOptimize() bool {
	if o != nil && !IsNil(o.Optimize) {
		return true
	}

	return false
}

// SetOptimize gets a reference to the given bool and assigns it to the Optimize field.
func (o *AptRepositorySyncURL) SetOptimize(v bool) {
	o.Optimize = &v
}

func (o AptRepositorySyncURL) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AptRepositorySyncURL) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Remote) {
		toSerialize["remote"] = o.Remote
	}
	if !IsNil(o.Mirror) {
		toSerialize["mirror"] = o.Mirror
	}
	if !IsNil(o.Optimize) {
		toSerialize["optimize"] = o.Optimize
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AptRepositorySyncURL) UnmarshalJSON(bytes []byte) (err error) {
	varAptRepositorySyncURL := _AptRepositorySyncURL{}

	if err = json.Unmarshal(bytes, &varAptRepositorySyncURL); err == nil {
		*o = AptRepositorySyncURL(varAptRepositorySyncURL)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "remote")
		delete(additionalProperties, "mirror")
		delete(additionalProperties, "optimize")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAptRepositorySyncURL struct {
	value *AptRepositorySyncURL
	isSet bool
}

func (v NullableAptRepositorySyncURL) Get() *AptRepositorySyncURL {
	return v.value
}

func (v *NullableAptRepositorySyncURL) Set(val *AptRepositorySyncURL) {
	v.value = val
	v.isSet = true
}

func (v NullableAptRepositorySyncURL) IsSet() bool {
	return v.isSet
}

func (v *NullableAptRepositorySyncURL) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAptRepositorySyncURL(val *AptRepositorySyncURL) *NullableAptRepositorySyncURL {
	return &NullableAptRepositorySyncURL{value: val, isSet: true}
}

func (v NullableAptRepositorySyncURL) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAptRepositorySyncURL) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


