/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"encoding/json"
)

// checks if the Copy type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Copy{}

// Copy A serializer for Content Copy API.
type Copy struct {
	// A JSON document describing sources, destinations, and content to be copied
	Config map[string]interface{} `json:"config"`
	AdditionalProperties map[string]interface{}
}

type _Copy Copy

// NewCopy instantiates a new Copy object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCopy(config map[string]interface{}) *Copy {
	this := Copy{}
	this.Config = config
	return &this
}

// NewCopyWithDefaults instantiates a new Copy object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCopyWithDefaults() *Copy {
	this := Copy{}
	return &this
}

// GetConfig returns the Config field value
func (o *Copy) GetConfig() map[string]interface{} {
	if o == nil {
		var ret map[string]interface{}
		return ret
	}

	return o.Config
}

// GetConfigOk returns a tuple with the Config field value
// and a boolean to check if the value has been set.
func (o *Copy) GetConfigOk() (map[string]interface{}, bool) {
	if o == nil {
		return map[string]interface{}{}, false
	}
	return o.Config, true
}

// SetConfig sets field value
func (o *Copy) SetConfig(v map[string]interface{}) {
	o.Config = v
}

func (o Copy) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Copy) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["config"] = o.Config

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *Copy) UnmarshalJSON(bytes []byte) (err error) {
	varCopy := _Copy{}

	if err = json.Unmarshal(bytes, &varCopy); err == nil {
		*o = Copy(varCopy)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "config")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCopy struct {
	value *Copy
	isSet bool
}

func (v NullableCopy) Get() *Copy {
	return v.value
}

func (v *NullableCopy) Set(val *Copy) {
	v.value = val
	v.isSet = true
}

func (v NullableCopy) IsSet() bool {
	return v.isSet
}

func (v *NullableCopy) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCopy(val *Copy) *NullableCopy {
	return &NullableCopy{value: val, isSet: true}
}

func (v NullableCopy) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCopy) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


