/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.input;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.input.EnrollInput;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class GenericInput
extends EnrollInput {
    public static final String CONFIG_NUM = "gi_num";
    public static final String CONFIG_DISPLAY_NAME = "gi_display_name";
    public static final String CONFIG_PARAM_NAME = "gi_param_name";
    public static final String CONFIG_ENABLE = "gi_param_enable";
    public static final int DEF_NUM = 5;

    public GenericInput() {
        int num = this.getNum();
        for (int i = 0; i < num; ++i) {
            this.addConfigName(CONFIG_PARAM_NAME + i);
            this.addConfigName(CONFIG_DISPLAY_NAME + i);
            this.addConfigName(CONFIG_ENABLE + i);
        }
    }

    protected int getNum() {
        int num = 5;
        String numC = this.getConfig(CONFIG_NUM);
        if (numC != null) {
            try {
                num = Integer.parseInt(numC);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return num;
    }

    @Override
    public void init(Profile profile, ConfigStore config) throws EProfileException {
        super.init(profile, config);
    }

    @Override
    public String getName(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_GENERIC_NAME_NAME", (String[])new String[0]);
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_INPUT_GENERIC_NAME_TEXT", (String[])new String[0]);
    }

    @Override
    public Enumeration<String> getValueNames() {
        Vector<String> v = new Vector<String>();
        int num = this.getNum();
        for (int i = 0; i < num; ++i) {
            String enable = this.getConfig(CONFIG_ENABLE + i);
            if (enable == null || !enable.equals("true")) continue;
            v.addElement(this.getConfig(CONFIG_PARAM_NAME + i));
        }
        return v.elements();
    }

    @Override
    public void populate(Map<String, String> ctx, Request request) throws Exception {
        int num = this.getNum();
        for (int i = 0; i < num; ++i) {
            String enable = this.getConfig(CONFIG_ENABLE + i);
            if (enable == null || !enable.equals("true")) continue;
            String param = this.getConfig(CONFIG_PARAM_NAME + i);
            request.setExtData(param, ctx.get(param));
        }
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        int num = this.getNum();
        for (int i = 0; i < num; ++i) {
            if (name.equals(CONFIG_PARAM_NAME + i)) {
                return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_GI_PARAM_NAME", (String[])new String[0]) + i);
            }
            if (name.equals(CONFIG_DISPLAY_NAME + i)) {
                return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_GI_DISPLAY_NAME", (String[])new String[0]) + i);
            }
            if (!name.equals(CONFIG_ENABLE + i)) continue;
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_GI_ENABLE", (String[])new String[0]) + i);
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        int num = this.getNum();
        for (int i = 0; i < num; ++i) {
            String param = this.getConfig(CONFIG_PARAM_NAME + i);
            if (param == null || !param.equals(name)) continue;
            return new Descriptor("string", null, null, this.getConfig(CONFIG_DISPLAY_NAME + i));
        }
        return null;
    }
}

