/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.constraints;

import com.netscape.ca.CASigningUnit;
import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubCANameConstraints
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(SubCANameConstraints.class);
    public CertificateAuthority mCA;
    public String mIssuerNameStr = null;

    public SubCANameConstraints() {
        this.NAME = "SubCANameConstraints";
        this.DESC = "Enforces Subordinate CA name.";
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"HELP_TOKEN;configuration-policyrules-subcanamecheck", "HELP_TEXT;Checks if subordinate CA request matches the local CA. There are no parameters to change"};
        return params;
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        CertificateAuthority certAuthority = (CertificateAuthority)owner.getAuthority();
        if (certAuthority == null) {
            logger.error(CMS.getLogMessage((String)"CA_CANT_FIND_MANAGER", (Object[])new Object[0]));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Cannot find the Certificate Manager"}));
        }
        this.mCA = certAuthority;
        CASigningUnit su = this.mCA.getSigningUnit();
        CAEngine engine = CAEngine.getInstance();
        if (su == null || engine.isPreOpMode()) {
            logger.warn("SubCANameConstraints.init(): Abort due to missing signing unit or in pre-op mode");
            return;
        }
        X509CertImpl cert = su.getCertImpl();
        if (cert == null) {
            return;
        }
        X500Name issuerName = cert.getSubjectName();
        if (issuerName == null) {
            return;
        }
        this.mIssuerNameStr = issuerName.toString();
    }

    public PolicyResult apply(Request req) {
        PolicyResult result = PolicyResult.ACCEPTED;
        try {
            X509CertInfo[] certInfos = req.getExtDataInCertInfoArray("CERT_INFO");
            if (certInfos == null) {
                logger.warn(CMS.getLogMessage((String)"POLICY_NO_CERT_INFO", (Object[])new Object[]{this.getInstanceName()}));
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[]{this.NAME + ":" + this.getInstanceName()}), "");
                return PolicyResult.REJECTED;
            }
            for (int i = 0; i < certInfos.length; ++i) {
                CertificateSubjectName subName = (CertificateSubjectName)certInfos[i].get("subject");
                if (subName == null) {
                    logger.warn(CMS.getLogMessage((String)"POLICY_NO_SUBJECT_NAME_1", (Object[])new Object[]{this.getInstanceName()}));
                    this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_SUBJECT_NAME", (String[])new String[]{this.NAME + ":" + this.getInstanceName()}), "");
                    return PolicyResult.REJECTED;
                }
                String certSubjectName = subName.toString();
                if (!certSubjectName.equalsIgnoreCase(this.mIssuerNameStr)) continue;
                logger.warn(CMS.getLogMessage((String)"POLICY_SUBJECT_NAME_EXIST_1", (Object[])new Object[]{this.mIssuerNameStr}));
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_SUBJECT_NAME_EXIST", (String[])new String[]{this.NAME + ":Same As Issuer Name " + this.mIssuerNameStr}), "");
                result = PolicyResult.REJECTED;
            }
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"POLICY_NO_SUBJECT_NAME_1", (Object[])new Object[]{this.getInstanceName()}), (Throwable)e);
            String[] params = new String[]{this.getInstanceName(), e.toString()};
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])params), "");
            result = PolicyResult.REJECTED;
        }
        return result;
    }

    public Vector<String> getInstanceParams() {
        Vector<String> v = new Vector<String>();
        return v;
    }

    public Vector<String> getDefaultParams() {
        Vector<String> v = new Vector<String>();
        return v;
    }
}

