/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.cli;

import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.base.FileConfigStorage;
import com.netscape.cmscore.ldapconn.LDAPAuthenticationConfig;
import com.netscape.cmscore.ldapconn.LDAPConfig;
import com.netscape.cmscore.ldapconn.LDAPConnectionConfig;
import com.netscape.cmscore.ldapconn.LdapAuthInfo;
import com.netscape.cmscore.ldapconn.LdapBoundConnection;
import com.netscape.cmscore.ldapconn.LdapConnInfo;
import com.netscape.cmscore.ldapconn.PKISocketConfig;
import com.netscape.cmscore.ldapconn.PKISocketFactory;
import com.netscape.cmsutil.ldap.LDAPUtil;
import com.netscape.cmsutil.password.PasswordStore;
import com.netscape.cmsutil.password.PasswordStoreConfig;
import java.io.File;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPSocketFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.tomcat.util.net.jss.TomcatJSS;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;

public class SDCreateCLI
extends CommandCLI {
    public SDCreateCLI(CLI parent) {
        super("create", "Create security domain", parent);
    }

    public void createOptions() {
        Option option = new Option(null, "name", true, "Security domain name");
        option.setArgName("name");
        this.options.addOption(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandLine cmd) throws Exception {
        String name = cmd.getOptionValue("name");
        String instanceDir = CMS.getInstanceDir();
        TomcatJSS tomcatjss = TomcatJSS.getInstance();
        tomcatjss.loadConfig();
        tomcatjss.init();
        String subsystem = this.parent.getParent().getName();
        String subsystemDir = instanceDir + File.separator + subsystem;
        String subsystemConfDir = subsystemDir + File.separator + "conf";
        String configFile = subsystemConfDir + File.separator + "CS.cfg";
        logger.info("Loading " + configFile);
        FileConfigStorage storage = new FileConfigStorage(configFile);
        EngineConfig cs = new EngineConfig(storage);
        cs.load();
        LDAPConfig ldapConfig = cs.getInternalDBConfig();
        PasswordStoreConfig psc = cs.getPasswordStoreConfig();
        PasswordStore passwordStore = PasswordStore.create((PasswordStoreConfig)psc);
        LDAPConnectionConfig connConfig = ldapConfig.getConnectionConfig();
        LDAPAuthenticationConfig authConfig = ldapConfig.getAuthenticationConfig();
        LdapConnInfo connInfo = new LdapConnInfo(connConfig);
        LdapAuthInfo authInfo = new LdapAuthInfo();
        authInfo.setPasswordStore(passwordStore);
        authInfo.init(authConfig, connInfo.getHost(), connInfo.getPort(), connInfo.getSecure());
        PKISocketConfig socketConfig = cs.getSocketConfig();
        PKISocketFactory socketFactory = new PKISocketFactory();
        socketFactory.setSecure(connInfo.getSecure());
        if (authInfo.getAuthType() == 2) {
            socketFactory.setClientCertNickname(authInfo.getClientCertNickname());
        }
        socketFactory.init(socketConfig);
        LdapBoundConnection conn = new LdapBoundConnection((LDAPSocketFactory)socketFactory, connInfo, authInfo);
        try {
            String sdName = name == null ? cs.getString("securitydomain.name") : name;
            String sdDN = "ou=Security Domain," + ldapConfig.getBaseDN();
            logger.info("Adding " + sdDN);
            LDAPAttributeSet attrs = new LDAPAttributeSet();
            attrs.add(new LDAPAttribute("objectclass", new String[]{"top", "pkiSecurityDomain"}));
            attrs.add(new LDAPAttribute("name", sdName));
            attrs.add(new LDAPAttribute("ou", "Security Domain"));
            Enumeration e = attrs.getAttributes();
            while (e.hasMoreElements()) {
                LDAPAttribute attr = (LDAPAttribute)e.nextElement();
                for (String value : attr.getStringValueArray()) {
                    logger.debug("- " + attr.getName() + ": " + value);
                }
            }
            LDAPEntry entry = new LDAPEntry(sdDN, attrs);
            conn.add(entry);
            String[] clist = new String[]{"CAList", "OCSPList", "KRAList", "RAList", "TKSList", "TPSList"};
            for (int i = 0; i < clist.length; ++i) {
                String dn = "cn=" + LDAPUtil.escapeRDNValue((Object)clist[i]) + "," + sdDN;
                logger.info("Adding " + dn);
                attrs = new LDAPAttributeSet();
                attrs.add(new LDAPAttribute("objectclass", new String[]{"top", "pkiSecurityGroup"}));
                attrs.add(new LDAPAttribute("cn", clist[i]));
                Enumeration e2 = attrs.getAttributes();
                while (e2.hasMoreElements()) {
                    LDAPAttribute attr = (LDAPAttribute)e2.nextElement();
                    for (String value : attr.getStringValueArray()) {
                        logger.debug("- " + attr.getName() + ": " + value);
                    }
                }
                entry = new LDAPEntry(dn, attrs);
                conn.add(entry);
            }
        }
        finally {
            conn.disconnect();
        }
    }
}

