/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.nss;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.nss.NSSCertCLI;
import java.io.FileOutputStream;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.provider.javax.crypto.JSSKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSCertExportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(NSSCertExportCLI.class);

    public NSSCertExportCLI(NSSCertCLI nssCertCLI) {
        super("export", "Export certificate", (CLI)nssCertCLI);
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <nickname> [path]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output-file", true, "Output file path");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "format", true, "Certificate format: PEM (default), DER, RAW");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "with-chain", false, "Export with certificate chain from NSS DB");
        option.setArgName("with-chain");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String outputFile;
        String[] cmdArgs = cmd.getArgs();
        String nickname = null;
        String path = null;
        if (cmdArgs.length < 1) {
            throw new Exception("Missing required positional argument: nickname");
        }
        nickname = cmdArgs[0];
        if (cmdArgs.length >= 2) {
            logger.warn("The optional positional path argument has been deprecated. Use the --output-file option instead.");
            path = cmdArgs[1];
        }
        if ((outputFile = cmd.getOptionValue("output-file")) != null) {
            path = outputFile;
        }
        String format = cmd.getOptionValue("format", "PEM").toUpperCase();
        boolean chain = cmd.hasOption("with-chain");
        if (!(format.equals("PEM") || format.equals("DER") || format.equals("RAW"))) {
            throw new Exception("Unknown type of output format: " + format);
        }
        if (chain && format.equals("DER")) {
            throw new Exception("Unable to write chain of DER-encoded certificates; use PEM instead.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("NssX509", "Mozilla-JSS");
        JSSKeyManager km = (JSSKeyManager)kmf.getKeyManagers()[0];
        X509Certificate[] certs = chain ? km.getCertificateChain(nickname) : new X509Certificate[]{(PK11Cert)km.getCertificate(nickname)};
        byte[] output = null;
        if (format.equals("RAW")) {
            buffer = new StringBuffer();
            for (X509Certificate cert : certs) {
                buffer.append(cert.toString());
            }
            output = buffer.toString().getBytes();
        } else if (format.equals("PEM")) {
            buffer = new StringBuffer();
            for (X509Certificate cert : certs) {
                byte[] encoded = cert.getEncoded();
                buffer.append("-----BEGIN CERTIFICATE-----");
                buffer.append("\r\n");
                buffer.append(Utils.base64encodeMultiLine((byte[])encoded));
                buffer.append("-----END CERTIFICATE-----");
                buffer.append("\r\n");
            }
            output = buffer.toString().getBytes();
        } else if (format.equals("DER")) {
            for (X509Certificate cert : certs) {
                output = cert.getEncoded();
            }
        } else {
            throw new Exception("Unsupported format: " + format);
        }
        if (path == null) {
            System.out.write(output);
        } else {
            try (FileOutputStream fos = new FileOutputStream(path);){
                fos.write(output);
            }
        }
    }
}

