/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.FieldAndFormat;
import org.elasticsearch.search.fetch.subphase.FieldFetcher;
import org.elasticsearch.search.fetch.subphase.UnmappedFieldFetcher;
import org.elasticsearch.search.lookup.SourceLookup;

class FieldsOptionSourceAdapter {
    static String FIELDS_EMULATION_ERROR_MSG = "Cannot specify both 'fields' and '_source' 'includes' or 'excludes' ina search request that is targeting pre version 7.10 nodes.";
    private final SearchSourceBuilder originalSource;
    private final boolean requestShouldBeAdapted;
    private final boolean removeSourceOnResponse;
    private final SearchSourceBuilder adaptedSource;
    private FieldFetcher fieldFetcher;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FieldsOptionSourceAdapter(SearchRequest request) {
        this.originalSource = request.source() != null ? request.source() : new SearchSourceBuilder();
        List<FieldAndFormat> fetchFields = this.originalSource.fetchFields();
        boolean bl = this.requestShouldBeAdapted = request.isFieldsOptionEmulationEnabled() && fetchFields != null && !fetchFields.isEmpty();
        if (this.requestShouldBeAdapted) {
            FetchSourceContext fetchSource = this.originalSource.fetchSource();
            if (fetchSource == null || fetchSource != null && fetchSource.fetchSource()) {
                if (fetchSource != null && (fetchSource.includes().length != 0 || fetchSource.excludes().length != 0)) throw new IllegalArgumentException(FIELDS_EMULATION_ERROR_MSG);
                this.removeSourceOnResponse = false;
                this.adaptedSource = this.originalSource;
                return;
            } else {
                this.adaptedSource = this.originalSource.shallowCopy();
                this.adaptedSource.fetchSource(new FetchSourceContext(true));
                String[] includes = (String[])fetchFields.stream().map(ff -> ff.field).toArray(String[]::new);
                this.adaptedSource.fetchSource(includes, null);
                this.removeSourceOnResponse = true;
            }
            return;
        } else {
            this.removeSourceOnResponse = false;
            this.adaptedSource = null;
        }
    }

    public void adaptRequest(Version connectionVersion, Consumer<SearchSourceBuilder> sourceConsumer) {
        if (this.requestShouldBeAdapted && connectionVersion.before(Version.V_7_10_0) && this.adaptedSource != null) {
            sourceConsumer.accept(this.adaptedSource);
        }
    }

    public void adaptResponse(Version connectionVersion, SearchHit[] hits) {
        if (this.requestShouldBeAdapted && connectionVersion.before(Version.V_7_10_0)) {
            for (SearchHit hit : hits) {
                SourceLookup lookup = new SourceLookup();
                lookup.setSource(hit.getSourceAsMap());
                Map<Object, Object> documentFields = Collections.emptyMap();
                try {
                    if (this.fieldFetcher == null) {
                        List<String> fieldPatterns = this.originalSource.fetchFields().stream().map(ff -> ff.field).collect(Collectors.toList());
                        UnmappedFieldFetcher unmappedFieldFetcher = new UnmappedFieldFetcher(Collections.emptySet(), fieldPatterns);
                        this.fieldFetcher = new FieldFetcher(Collections.emptyMap(), unmappedFieldFetcher);
                    }
                    documentFields = this.fieldFetcher.fetch(lookup);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                for (Map.Entry entry : documentFields.entrySet()) {
                    hit.setDocumentField((String)entry.getKey(), (DocumentField)entry.getValue());
                }
                if (!this.removeSourceOnResponse) continue;
                hit.sourceRef(null);
            }
        }
    }

    boolean getRemoveSourceOnResponse() {
        return this.removeSourceOnResponse;
    }
}

