/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.Objects;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.indices.SystemIndices;

public class ExecutorSelector {
    private final SystemIndices systemIndices;

    ExecutorSelector(SystemIndices systemIndices) {
        this.systemIndices = systemIndices;
    }

    public String executorForGet(String indexName) {
        SystemIndexDescriptor indexDescriptor = this.systemIndices.findMatchingDescriptor(indexName);
        if (Objects.nonNull(indexDescriptor)) {
            return indexDescriptor.getThreadPoolNames().threadPoolForGet();
        }
        SystemDataStreamDescriptor dataStreamDescriptor = this.systemIndices.findMatchingDataStreamDescriptor(indexName);
        if (Objects.nonNull(dataStreamDescriptor)) {
            return dataStreamDescriptor.getThreadPoolNames().threadPoolForGet();
        }
        return "get";
    }

    public String executorForSearch(String indexName) {
        SystemIndexDescriptor indexDescriptor = this.systemIndices.findMatchingDescriptor(indexName);
        if (Objects.nonNull(indexDescriptor)) {
            return indexDescriptor.getThreadPoolNames().threadPoolForSearch();
        }
        SystemDataStreamDescriptor dataStreamDescriptor = this.systemIndices.findMatchingDataStreamDescriptor(indexName);
        if (Objects.nonNull(dataStreamDescriptor)) {
            return dataStreamDescriptor.getThreadPoolNames().threadPoolForSearch();
        }
        return "search";
    }

    public String executorForWrite(String indexName) {
        SystemIndexDescriptor indexDescriptor = this.systemIndices.findMatchingDescriptor(indexName);
        if (Objects.nonNull(indexDescriptor)) {
            return indexDescriptor.getThreadPoolNames().threadPoolForWrite();
        }
        SystemDataStreamDescriptor dataStreamDescriptor = this.systemIndices.findMatchingDataStreamDescriptor(indexName);
        if (Objects.nonNull(dataStreamDescriptor)) {
            return dataStreamDescriptor.getThreadPoolNames().threadPoolForWrite();
        }
        return "write";
    }

    public static String getWriteExecutorForShard(ExecutorSelector executorSelector, IndexShard shard) {
        return executorSelector.executorForWrite(shard.shardId().getIndexName());
    }
}

