/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.SecondaryLocation;
import org.sonarsource.kotlin.converter.KotlinTextRanges;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1479")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/sonarsource/kotlin/checks/TooManyCasesCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "maximum", "", "getMaximum", "()I", "setMaximum", "(I)V", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "Companion", "sonar-kotlin-plugin"})
public final class TooManyCasesCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="maximum", description="Maximum number of branches", defaultValue="30")
    private int maximum = 30;
    public static final int DEFAULT_MAX = 30;

    public final int getMaximum() {
        return this.maximum;
    }

    public final void setMaximum(int n) {
        this.maximum = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        int actual = expression2.getEntries().size();
        if (actual > this.maximum) {
            Collection<SecondaryLocation> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = expression2.getWhenKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "expression.whenKeyword");
            String string2 = "Reduce the number of " + expression2.getWhenKeyword().getText() + " branches from " + actual + " to at most " + this.maximum + ".";
            List<KtWhenEntry> list2 = expression2.getEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "expression.entries");
            Iterable iterable = list2;
            String string3 = string2;
            PsiElement psiElement2 = psiElement;
            KotlinFileContext kotlinFileContext2 = kotlinFileContext;
            AbstractCheck abstractCheck2 = abstractCheck;
            boolean $i$f$map = false;
            void var6_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtWhenEntry ktWhenEntry = (KtWhenEntry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                PsiElement psiElement3 = it.getArrow();
                Intrinsics.checkNotNull(psiElement3);
                collection.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, psiElement3), null));
            }
            collection = (List)destination$iv$iv;
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck2, kotlinFileContext2, psiElement2, string3, CollectionsKt.toList((Iterable)collection), null, 8, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/sonarsource/kotlin/checks/TooManyCasesCheck$Companion;", "", "()V", "DEFAULT_MAX", "", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

