/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin.surefire;

import java.util.ArrayList;
import java.util.Optional;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

@ScannerSide
public class KotlinResourcesLocator {
    private static final Logger LOGGER = Loggers.get(KotlinResourcesLocator.class);
    private final FileSystem fs;

    public KotlinResourcesLocator(FileSystem fs) {
        this.fs = fs;
    }

    public Optional<InputFile> findResourceByClassName(String className) {
        String fileName = className.replace(".", "/");
        LOGGER.info("Searching for {}", (Object)fileName);
        FilePredicates p = this.fs.predicates();
        FilePredicate fileNamePredicates = KotlinResourcesLocator.getFileNamePredicateFromSuffixes(p, fileName, new String[]{".kt"});
        if (this.fs.hasFiles(fileNamePredicates)) {
            return Optional.of((InputFile)this.fs.inputFiles(fileNamePredicates).iterator().next());
        }
        return Optional.empty();
    }

    private static FilePredicate getFileNamePredicateFromSuffixes(FilePredicates p, String fileName, String[] suffixes) {
        ArrayList<FilePredicate> fileNamePredicates = new ArrayList<FilePredicate>(suffixes.length);
        for (String suffix : suffixes) {
            fileNamePredicates.add(p.matchesPathPattern("**/" + fileName + suffix));
        }
        return p.or(fileNamePredicates);
    }
}

