/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.TooLargeObjectInPackException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.BinaryDelta;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.BlobObjectChecker;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.InflaterCache;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.PackLock;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.transport.ReceivedPackStatistics;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.LongMap;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.sha1.SHA1;

public abstract class PackParser {
    private static final int BUFFER_SIZE = 8192;
    private final ObjectDatabase objectDatabase;
    private InflaterStream inflater;
    private byte[] tempBuffer;
    private byte[] hdrBuf;
    private final SHA1 objectHasher = SHA1.newInstance();
    private final MutableObjectId tempObjectId;
    private InputStream in;
    byte[] buf;
    private long bBase;
    private int bOffset;
    int bAvail;
    private ObjectChecker objCheck;
    private boolean allowThin;
    private boolean checkObjectCollisions;
    private boolean needBaseObjectIds;
    private boolean checkEofAfterPackFooter;
    private boolean expectDataAfterPackFooter;
    private long expectedObjectCount;
    private PackedObjectInfo[] entries;
    private ObjectIdSubclassMap<ObjectId> newObjectIds;
    private int deltaCount;
    private int entryCount;
    private ObjectIdOwnerMap<DeltaChain> baseById;
    private ObjectIdSubclassMap<ObjectId> baseObjectIds;
    private LongMap<UnresolvedDelta> baseByPos;
    private BlockList<PackedObjectInfo> collisionCheckObjs;
    private MessageDigest packDigest;
    private ObjectReader readCurs;
    private String lockMessage;
    private long maxObjectSizeLimit;
    private final ReceivedPackStatistics.Builder stats = new ReceivedPackStatistics.Builder();

    protected PackParser(ObjectDatabase odb, InputStream src) {
        this.objectDatabase = odb.newCachedDatabase();
        this.in = src;
        this.inflater = new InflaterStream();
        this.readCurs = this.objectDatabase.newReader();
        this.buf = new byte[8192];
        this.tempBuffer = new byte[8192];
        this.hdrBuf = new byte[64];
        this.tempObjectId = new MutableObjectId();
        this.packDigest = Constants.newMessageDigest();
        this.checkObjectCollisions = true;
    }

    public boolean isAllowThin() {
        return this.allowThin;
    }

    public void setAllowThin(boolean allow) {
        this.allowThin = allow;
    }

    protected boolean isCheckObjectCollisions() {
        return this.checkObjectCollisions;
    }

    protected void setCheckObjectCollisions(boolean check2) {
        this.checkObjectCollisions = check2;
    }

    public void setNeedNewObjectIds(boolean b) {
        this.newObjectIds = b ? new ObjectIdSubclassMap() : null;
    }

    private boolean needNewObjectIds() {
        return this.newObjectIds != null;
    }

    public void setNeedBaseObjectIds(boolean b) {
        this.needBaseObjectIds = b;
    }

    public boolean isCheckEofAfterPackFooter() {
        return this.checkEofAfterPackFooter;
    }

    public void setCheckEofAfterPackFooter(boolean b) {
        this.checkEofAfterPackFooter = b;
    }

    public boolean isExpectDataAfterPackFooter() {
        return this.expectDataAfterPackFooter;
    }

    public void setExpectDataAfterPackFooter(boolean e) {
        this.expectDataAfterPackFooter = e;
    }

    public ObjectIdSubclassMap<ObjectId> getNewObjectIds() {
        if (this.newObjectIds != null) {
            return this.newObjectIds;
        }
        return new ObjectIdSubclassMap<ObjectId>();
    }

    public ObjectIdSubclassMap<ObjectId> getBaseObjectIds() {
        if (this.baseObjectIds != null) {
            return this.baseObjectIds;
        }
        return new ObjectIdSubclassMap<ObjectId>();
    }

    public void setObjectChecker(ObjectChecker oc) {
        this.objCheck = oc;
    }

    public void setObjectChecking(boolean on) {
        this.setObjectChecker(on ? new ObjectChecker() : null);
    }

    public String getLockMessage() {
        return this.lockMessage;
    }

    public void setLockMessage(String msg) {
        this.lockMessage = msg;
    }

    public void setMaxObjectSizeLimit(long limit) {
        this.maxObjectSizeLimit = limit;
    }

    public int getObjectCount() {
        return this.entryCount;
    }

    public PackedObjectInfo getObject(int nth) {
        return this.entries[nth];
    }

    public List<PackedObjectInfo> getSortedObjectList(Comparator<PackedObjectInfo> cmp) {
        Arrays.sort(this.entries, 0, this.entryCount, cmp);
        List<PackedObjectInfo> list = Arrays.asList(this.entries);
        if (this.entryCount < this.entries.length) {
            list = list.subList(0, this.entryCount);
        }
        return list;
    }

    public long getPackSize() {
        return -1L;
    }

    public ReceivedPackStatistics getReceivedPackStatistics() {
        return this.stats.build();
    }

    public final PackLock parse(ProgressMonitor progress) throws IOException {
        return this.parse(progress, progress);
    }

    public PackLock parse(ProgressMonitor receiving, ProgressMonitor resolving) throws IOException {
        if (receiving == null) {
            receiving = NullProgressMonitor.INSTANCE;
        }
        if (resolving == null) {
            resolving = NullProgressMonitor.INSTANCE;
        }
        if (receiving == resolving) {
            receiving.start(2);
        }
        try {
            this.readPackHeader();
            this.entries = new PackedObjectInfo[(int)this.expectedObjectCount];
            this.baseById = new ObjectIdOwnerMap();
            this.baseByPos = new LongMap();
            this.collisionCheckObjs = new BlockList();
            receiving.beginTask(JGitText.get().receivingObjects, (int)this.expectedObjectCount);
            try {
                int done = 0;
                while ((long)done < this.expectedObjectCount) {
                    this.indexOneObject();
                    receiving.update(1);
                    if (receiving.isCancelled()) {
                        throw new IOException(JGitText.get().downloadCancelled);
                    }
                    ++done;
                }
                this.readPackFooter();
                this.endInput();
            }
            finally {
                receiving.endTask();
            }
            if (!this.collisionCheckObjs.isEmpty()) {
                this.checkObjectCollision();
            }
            if (this.deltaCount > 0) {
                this.processDeltas(resolving);
            }
            this.packDigest = null;
            this.baseById = null;
            this.baseByPos = null;
        }
        finally {
            try {
                if (this.readCurs != null) {
                    this.readCurs.close();
                }
            }
            finally {
                this.readCurs = null;
            }
            try {
                this.inflater.release();
            }
            finally {
                this.inflater = null;
            }
        }
        return null;
    }

    private void processDeltas(ProgressMonitor resolving) throws IOException {
        if (resolving instanceof BatchingProgressMonitor) {
            ((BatchingProgressMonitor)resolving).setDelayStart(1000L, TimeUnit.MILLISECONDS);
        }
        resolving.beginTask(JGitText.get().resolvingDeltas, this.deltaCount);
        this.resolveDeltas(resolving);
        if ((long)this.entryCount < this.expectedObjectCount) {
            if (!this.isAllowThin()) {
                throw new IOException(MessageFormat.format(JGitText.get().packHasUnresolvedDeltas, this.expectedObjectCount - (long)this.entryCount));
            }
            this.resolveDeltasWithExternalBases(resolving);
            if ((long)this.entryCount < this.expectedObjectCount) {
                throw new IOException(MessageFormat.format(JGitText.get().packHasUnresolvedDeltas, this.expectedObjectCount - (long)this.entryCount));
            }
        }
        resolving.endTask();
    }

    private void resolveDeltas(ProgressMonitor progress) throws IOException {
        int last = this.entryCount;
        int i = 0;
        while (i < last) {
            this.resolveDeltas(this.entries[i], progress);
            if (progress.isCancelled()) {
                throw new IOException(JGitText.get().downloadCancelledDuringIndexing);
            }
            ++i;
        }
    }

    private void resolveDeltas(PackedObjectInfo oe, ProgressMonitor progress) throws IOException {
        UnresolvedDelta children = this.firstChildOf(oe);
        if (children == null) {
            return;
        }
        DeltaVisit visit = new DeltaVisit();
        visit.nextChild = children;
        ObjectTypeAndSize info = this.openDatabase(oe, new ObjectTypeAndSize());
        switch (info.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                visit.data = this.inflateAndReturn(Source.DATABASE, info.size);
                visit.id = oe;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, info.type));
            }
        }
        if (!this.checkCRC(oe.getCRC())) {
            throw new IOException(MessageFormat.format(JGitText.get().corruptionDetectedReReadingAt, oe.getOffset()));
        }
        this.resolveDeltas(visit.next(), info.type, info, progress);
    }

    private void resolveDeltas(DeltaVisit visit, int type, ObjectTypeAndSize info, ProgressMonitor progress) throws IOException {
        this.stats.addDeltaObject(type);
        do {
            progress.update(1);
            info = this.openDatabase(visit.delta, info);
            switch (info.type) {
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, info.type));
                }
            }
            byte[] delta = this.inflateAndReturn(Source.DATABASE, info.size);
            long finalSz = BinaryDelta.getResultSize(delta);
            this.checkIfTooLarge(type, finalSz);
            visit.data = BinaryDelta.apply(visit.parent.data, delta);
            delta = null;
            if (!this.checkCRC(visit.delta.crc)) {
                throw new IOException(MessageFormat.format(JGitText.get().corruptionDetectedReReadingAt, visit.delta.position));
            }
            SHA1 objectDigest = this.objectHasher.reset();
            objectDigest.update(Constants.encodedTypeString(type));
            objectDigest.update((byte)32);
            objectDigest.update(Constants.encodeASCII(visit.data.length));
            objectDigest.update((byte)0);
            objectDigest.update(visit.data);
            objectDigest.digest(this.tempObjectId);
            this.verifySafeObject(this.tempObjectId, type, visit.data);
            if (this.isCheckObjectCollisions() && this.readCurs.has(this.tempObjectId)) {
                this.checkObjectCollision(this.tempObjectId, type, visit.data, visit.delta.sizeBeforeInflating);
            }
            PackedObjectInfo oe = this.newInfo(this.tempObjectId, visit.delta, visit.parent.id);
            oe.setFullSize(finalSz);
            oe.setOffset(visit.delta.position);
            oe.setType(type);
            this.onInflatedObjectData(oe, type, visit.data);
            this.addObjectAndTrack(oe);
            visit.id = oe;
            visit.nextChild = this.firstChildOf(oe);
        } while ((visit = visit.next()) != null);
    }

    private final void checkIfTooLarge(int typeCode, long size) throws IOException {
        if (0L < this.maxObjectSizeLimit && this.maxObjectSizeLimit < size) {
            switch (typeCode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    throw new TooLargeObjectInPackException(size, this.maxObjectSizeLimit);
                }
                case 6: 
                case 7: {
                    throw new TooLargeObjectInPackException(size, this.maxObjectSizeLimit);
                }
            }
            throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
        }
        if (size > 0x7FFFFFF7L) {
            throw new TooLargeObjectInPackException(size, 0x7FFFFFF7L);
        }
    }

    protected ObjectTypeAndSize readObjectHeader(ObjectTypeAndSize info) throws IOException {
        int hdrPtr = 0;
        int c = this.readFrom(Source.DATABASE);
        this.hdrBuf[hdrPtr++] = (byte)c;
        info.type = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = this.readFrom(Source.DATABASE);
            this.hdrBuf[hdrPtr++] = (byte)c;
            sz += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        info.size = sz;
        switch (info.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.onObjectHeader(Source.DATABASE, this.hdrBuf, 0, hdrPtr);
                break;
            }
            case 6: {
                c = this.readFrom(Source.DATABASE);
                this.hdrBuf[hdrPtr++] = (byte)c;
                while ((c & 0x80) != 0) {
                    c = this.readFrom(Source.DATABASE);
                    this.hdrBuf[hdrPtr++] = (byte)c;
                }
                this.onObjectHeader(Source.DATABASE, this.hdrBuf, 0, hdrPtr);
                break;
            }
            case 7: {
                System.arraycopy(this.buf, this.fill(Source.DATABASE, 20), this.hdrBuf, hdrPtr, 20);
                this.use(20);
                this.onObjectHeader(Source.DATABASE, this.hdrBuf, 0, hdrPtr += 20);
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, info.type));
            }
        }
        return info;
    }

    private UnresolvedDelta removeBaseById(AnyObjectId id) {
        DeltaChain d = this.baseById.get(id);
        return d != null ? d.remove() : null;
    }

    private static UnresolvedDelta reverse(UnresolvedDelta c) {
        UnresolvedDelta tail = null;
        while (c != null) {
            UnresolvedDelta n = c.next;
            c.next = tail;
            tail = c;
            c = n;
        }
        return tail;
    }

    private UnresolvedDelta firstChildOf(PackedObjectInfo oe) {
        UnresolvedDelta a = PackParser.reverse(this.removeBaseById(oe));
        UnresolvedDelta b = PackParser.reverse(this.baseByPos.remove(oe.getOffset()));
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        UnresolvedDelta first = null;
        UnresolvedDelta last = null;
        while (a != null || b != null) {
            UnresolvedDelta curr;
            if (b == null || a != null && a.position < b.position) {
                curr = a;
                a = a.next;
            } else {
                curr = b;
                b = b.next;
            }
            if (last != null) {
                last.next = curr;
            } else {
                first = curr;
            }
            last = curr;
            curr.next = null;
        }
        return first;
    }

    private void resolveDeltasWithExternalBases(ProgressMonitor progress) throws IOException {
        this.growEntries(this.baseById.size());
        if (this.needBaseObjectIds) {
            this.baseObjectIds = new ObjectIdSubclassMap();
        }
        ArrayList<DeltaChain> missing = new ArrayList<DeltaChain>(64);
        for (DeltaChain baseId : this.baseById) {
            ObjectLoader ldr;
            if (baseId.head == null) continue;
            if (this.needBaseObjectIds) {
                this.baseObjectIds.add(baseId);
            }
            try {
                ldr = this.readCurs.open(baseId);
            }
            catch (MissingObjectException notFound) {
                missing.add(baseId);
                continue;
            }
            DeltaVisit visit = new DeltaVisit();
            visit.data = ldr.getCachedBytes(Integer.MAX_VALUE);
            visit.id = baseId;
            int typeCode = ldr.getType();
            PackedObjectInfo oe = this.newInfo(baseId, null, null);
            oe.setType(typeCode);
            oe.setFullSize(ldr.getSize());
            if (this.onAppendBase(typeCode, visit.data, oe)) {
                this.entries[this.entryCount++] = oe;
            }
            visit.nextChild = this.firstChildOf(oe);
            this.resolveDeltas(visit.next(), typeCode, new ObjectTypeAndSize(), progress);
            if (!progress.isCancelled()) continue;
            throw new IOException(JGitText.get().downloadCancelledDuringIndexing);
        }
        for (DeltaChain base : missing) {
            if (base.head == null) continue;
            throw new MissingObjectException((ObjectId)base, "delta base");
        }
        this.onEndThinPack();
    }

    private void growEntries(int extraObjects) {
        PackedObjectInfo[] ne = new PackedObjectInfo[(int)this.expectedObjectCount + extraObjects];
        System.arraycopy(this.entries, 0, ne, 0, this.entryCount);
        this.entries = ne;
    }

    private void readPackHeader() throws IOException {
        if (this.expectDataAfterPackFooter) {
            if (!this.in.markSupported()) {
                throw new IOException(JGitText.get().inputStreamMustSupportMark);
            }
            this.in.mark(this.buf.length);
        }
        int hdrln = Constants.PACK_SIGNATURE.length + 4 + 4;
        int p = this.fill(Source.INPUT, hdrln);
        int k = 0;
        while (k < Constants.PACK_SIGNATURE.length) {
            if (this.buf[p + k] != Constants.PACK_SIGNATURE[k]) {
                throw new IOException(JGitText.get().notAPACKFile);
            }
            ++k;
        }
        long vers = NB.decodeUInt32(this.buf, p + 4);
        if (vers != 2L && vers != 3L) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackVersion, vers));
        }
        long objectCount = NB.decodeUInt32(this.buf, p + 8);
        this.use(hdrln);
        this.setExpectedObjectCount(objectCount);
        this.onPackHeader(objectCount);
    }

    private void readPackFooter() throws IOException {
        this.sync();
        byte[] actHash = this.packDigest.digest();
        int c = this.fill(Source.INPUT, 20);
        byte[] srcHash = new byte[20];
        System.arraycopy(this.buf, c, srcHash, 0, 20);
        this.use(20);
        if (this.bAvail != 0 && !this.expectDataAfterPackFooter) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(this.buf[this.bOffset] & 0xFF)));
        }
        if (this.isCheckEofAfterPackFooter()) {
            int eof = this.in.read();
            if (eof >= 0) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(eof)));
            }
        } else if (this.bAvail > 0 && this.expectDataAfterPackFooter) {
            this.in.reset();
            IO.skipFully(this.in, this.bOffset);
        }
        if (!Arrays.equals(actHash, srcHash)) {
            throw new CorruptObjectException(JGitText.get().corruptObjectPackfileChecksumIncorrect);
        }
        this.onPackFooter(srcHash);
    }

    private void endInput() {
        this.stats.setNumBytesRead(this.streamPosition());
        this.in = null;
    }

    private void indexOneObject() throws IOException {
        long streamPosition = this.streamPosition();
        int hdrPtr = 0;
        int c = this.readFrom(Source.INPUT);
        this.hdrBuf[hdrPtr++] = (byte)c;
        int typeCode = c >> 4 & 7;
        long sz = c & 0xF;
        int shift = 4;
        while ((c & 0x80) != 0) {
            c = this.readFrom(Source.INPUT);
            this.hdrBuf[hdrPtr++] = (byte)c;
            sz += (long)(c & 0x7F) << shift;
            shift += 7;
        }
        this.checkIfTooLarge(typeCode, sz);
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.stats.addWholeObject(typeCode);
                this.onBeginWholeObject(streamPosition, typeCode, sz);
                this.onObjectHeader(Source.INPUT, this.hdrBuf, 0, hdrPtr);
                this.whole(streamPosition, typeCode, sz);
                break;
            }
            case 6: {
                this.stats.addOffsetDelta();
                c = this.readFrom(Source.INPUT);
                this.hdrBuf[hdrPtr++] = (byte)c;
                long ofs = c & 0x7F;
                while ((c & 0x80) != 0) {
                    ++ofs;
                    c = this.readFrom(Source.INPUT);
                    this.hdrBuf[hdrPtr++] = (byte)c;
                    ofs <<= 7;
                    ofs += (long)(c & 0x7F);
                }
                long base = streamPosition - ofs;
                this.onBeginOfsDelta(streamPosition, base, sz);
                this.onObjectHeader(Source.INPUT, this.hdrBuf, 0, hdrPtr);
                this.inflateAndSkip(Source.INPUT, sz);
                UnresolvedDelta n = this.onEndDelta();
                n.position = streamPosition;
                n.next = this.baseByPos.put(base, n);
                n.sizeBeforeInflating = this.streamPosition() - streamPosition;
                ++this.deltaCount;
                break;
            }
            case 7: {
                this.stats.addRefDelta();
                c = this.fill(Source.INPUT, 20);
                ObjectId base = ObjectId.fromRaw(this.buf, c);
                System.arraycopy(this.buf, c, this.hdrBuf, hdrPtr, 20);
                hdrPtr += 20;
                this.use(20);
                DeltaChain r = this.baseById.get(base);
                if (r == null) {
                    r = new DeltaChain(base);
                    this.baseById.add(r);
                }
                this.onBeginRefDelta(streamPosition, base, sz);
                this.onObjectHeader(Source.INPUT, this.hdrBuf, 0, hdrPtr);
                this.inflateAndSkip(Source.INPUT, sz);
                UnresolvedDelta n = this.onEndDelta();
                n.position = streamPosition;
                n.sizeBeforeInflating = this.streamPosition() - streamPosition;
                r.add(n);
                ++this.deltaCount;
                break;
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unknownObjectType, typeCode));
            }
        }
    }

    private void whole(long pos, int type, long sz) throws IOException {
        byte[] data;
        SHA1 objectDigest = this.objectHasher.reset();
        objectDigest.update(Constants.encodedTypeString(type));
        objectDigest.update((byte)32);
        objectDigest.update(Constants.encodeASCII(sz));
        objectDigest.update((byte)0);
        if (type == 3) {
            byte[] readBuffer = this.buffer();
            BlobObjectChecker checker = null;
            if (this.objCheck != null) {
                checker = this.objCheck.newBlobObjectChecker();
            }
            if (checker == null) {
                checker = BlobObjectChecker.NULL_CHECKER;
            }
            long cnt = 0L;
            Throwable throwable = null;
            Object var13_12 = null;
            try (InputStream inf = this.inflate(Source.INPUT, sz);){
                while (cnt < sz) {
                    int r = inf.read(readBuffer);
                    if (r <= 0) {
                        break;
                    }
                    objectDigest.update(readBuffer, 0, r);
                    checker.update(readBuffer, 0, r);
                    cnt += (long)r;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            objectDigest.digest(this.tempObjectId);
            checker.endBlob(this.tempObjectId);
            data = null;
        } else {
            data = this.inflateAndReturn(Source.INPUT, sz);
            objectDigest.update(data);
            objectDigest.digest(this.tempObjectId);
            this.verifySafeObject(this.tempObjectId, type, data);
        }
        long sizeBeforeInflating = this.streamPosition() - pos;
        PackedObjectInfo obj = this.newInfo(this.tempObjectId, null, null);
        obj.setOffset(pos);
        obj.setType(type);
        obj.setSize(sizeBeforeInflating);
        obj.setFullSize(sz);
        this.onEndWholeObject(obj);
        if (data != null) {
            this.onInflatedObjectData(obj, type, data);
        }
        this.addObjectAndTrack(obj);
        if (this.isCheckObjectCollisions()) {
            this.collisionCheckObjs.add(obj);
        }
    }

    protected void verifySafeObject(AnyObjectId id, int type, byte[] data) throws CorruptObjectException {
        if (this.objCheck != null) {
            try {
                this.objCheck.check(id, type, data);
            }
            catch (CorruptObjectException e) {
                if (e.getErrorType() != null) {
                    throw e;
                }
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().invalidObject, Constants.typeString(type), id.name(), e.getMessage()), e);
            }
        }
    }

    private void checkObjectCollision() throws IOException {
        for (PackedObjectInfo obj : this.collisionCheckObjs) {
            if (!this.readCurs.has(obj)) continue;
            this.checkObjectCollision(obj);
        }
    }

    private void checkObjectCollision(PackedObjectInfo obj) throws IOException {
        ObjectTypeAndSize info = this.openDatabase(obj, new ObjectTypeAndSize());
        byte[] readBuffer = this.buffer();
        byte[] curBuffer = new byte[readBuffer.length];
        long sz = info.size;
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (ObjectStream cur = this.readCurs.open(obj, info.type).openStream();){
                if (cur.getSize() != sz) {
                    throw new IOException(MessageFormat.format(JGitText.get().collisionOn, obj.name()));
                }
                Throwable throwable2 = null;
                Object var11_14 = null;
                try (InputStream pck = this.inflate(Source.DATABASE, sz);){
                    while (0L < sz) {
                        int n = (int)Math.min((long)readBuffer.length, sz);
                        IO.readFully(cur, curBuffer, 0, n);
                        IO.readFully(pck, readBuffer, 0, n);
                        int i = 0;
                        while (i < n) {
                            if (curBuffer[i] != readBuffer[i]) {
                                throw new IOException(MessageFormat.format(JGitText.get().collisionOn, obj.name()));
                            }
                            ++i;
                        }
                        sz -= (long)n;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                this.stats.incrementObjectsDuplicated();
                this.stats.incrementNumBytesDuplicated(obj.getSize());
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
    }

    private void checkObjectCollision(AnyObjectId obj, int type, byte[] data, long sizeBeforeInflating) throws IOException {
        try {
            ObjectLoader ldr = this.readCurs.open(obj, type);
            byte[] existingData = ldr.getCachedBytes(data.length);
            if (!Arrays.equals(data, existingData)) {
                throw new IOException(MessageFormat.format(JGitText.get().collisionOn, obj.name()));
            }
            this.stats.incrementObjectsDuplicated();
            this.stats.incrementNumBytesDuplicated(sizeBeforeInflating);
        }
        catch (MissingObjectException missingObjectException) {
            // empty catch block
        }
    }

    private long streamPosition() {
        return this.bBase + (long)this.bOffset;
    }

    private ObjectTypeAndSize openDatabase(PackedObjectInfo obj, ObjectTypeAndSize info) throws IOException {
        this.bOffset = 0;
        this.bAvail = 0;
        return this.seekDatabase(obj, info);
    }

    private ObjectTypeAndSize openDatabase(UnresolvedDelta delta, ObjectTypeAndSize info) throws IOException {
        this.bOffset = 0;
        this.bAvail = 0;
        return this.seekDatabase(delta, info);
    }

    private int readFrom(Source src) throws IOException {
        if (this.bAvail == 0) {
            this.fill(src, 1);
        }
        --this.bAvail;
        return this.buf[this.bOffset++] & 0xFF;
    }

    void use(int cnt) {
        this.bOffset += cnt;
        this.bAvail -= cnt;
    }

    int fill(Source src, int need) throws IOException {
        while (this.bAvail < need) {
            int next = this.bOffset + this.bAvail;
            int free = this.buf.length - next;
            if (free + this.bAvail < need) {
                switch (src) {
                    case INPUT: {
                        this.sync();
                        break;
                    }
                    case DATABASE: {
                        if (this.bAvail > 0) {
                            System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
                        }
                        this.bOffset = 0;
                    }
                }
                next = this.bAvail;
                free = this.buf.length - next;
            }
            switch (src) {
                case INPUT: {
                    next = this.in.read(this.buf, next, free);
                    break;
                }
                case DATABASE: {
                    next = this.readDatabase(this.buf, next, free);
                }
            }
            if (next <= 0) {
                throw new EOFException(JGitText.get().packfileIsTruncatedNoParam);
            }
            this.bAvail += next;
        }
        return this.bOffset;
    }

    private void sync() throws IOException {
        this.packDigest.update(this.buf, 0, this.bOffset);
        this.onStoreStream(this.buf, 0, this.bOffset);
        if (this.expectDataAfterPackFooter) {
            if (this.bAvail > 0) {
                this.in.reset();
                IO.skipFully(this.in, this.bOffset);
                this.bAvail = 0;
            }
            this.in.mark(this.buf.length);
        } else if (this.bAvail > 0) {
            System.arraycopy(this.buf, this.bOffset, this.buf, 0, this.bAvail);
        }
        this.bBase += (long)this.bOffset;
        this.bOffset = 0;
    }

    protected byte[] buffer() {
        return this.tempBuffer;
    }

    protected PackedObjectInfo newInfo(AnyObjectId id, UnresolvedDelta delta, ObjectId deltaBase) {
        PackedObjectInfo oe = new PackedObjectInfo(id);
        if (delta != null) {
            oe.setCRC(delta.crc);
        }
        return oe;
    }

    protected void setExpectedObjectCount(long expectedObjectCount) {
        this.expectedObjectCount = expectedObjectCount;
    }

    protected abstract void onStoreStream(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void onObjectHeader(Source var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void onObjectData(Source var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void onInflatedObjectData(PackedObjectInfo var1, int var2, byte[] var3) throws IOException;

    protected abstract void onPackHeader(long var1) throws IOException;

    protected abstract void onPackFooter(byte[] var1) throws IOException;

    protected abstract boolean onAppendBase(int var1, byte[] var2, PackedObjectInfo var3) throws IOException;

    protected abstract void onEndThinPack() throws IOException;

    protected abstract ObjectTypeAndSize seekDatabase(PackedObjectInfo var1, ObjectTypeAndSize var2) throws IOException;

    protected abstract ObjectTypeAndSize seekDatabase(UnresolvedDelta var1, ObjectTypeAndSize var2) throws IOException;

    protected abstract int readDatabase(byte[] var1, int var2, int var3) throws IOException;

    protected abstract boolean checkCRC(int var1);

    protected abstract void onBeginWholeObject(long var1, int var3, long var4) throws IOException;

    protected abstract void onEndWholeObject(PackedObjectInfo var1) throws IOException;

    protected abstract void onBeginOfsDelta(long var1, long var3, long var5) throws IOException;

    protected abstract void onBeginRefDelta(long var1, AnyObjectId var3, long var4) throws IOException;

    protected UnresolvedDelta onEndDelta() throws IOException {
        return new UnresolvedDelta();
    }

    private void inflateAndSkip(Source src, long inflatedSize) throws IOException {
        Throwable throwable = null;
        Object var5_5 = null;
        try (InputStream inf = this.inflate(src, inflatedSize);){
            IO.skipFully(inf, inflatedSize);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private byte[] inflateAndReturn(Source src, long inflatedSize) throws IOException {
        byte[] dst = new byte[(int)inflatedSize];
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream inf = this.inflate(src, inflatedSize);){
            IO.readFully(inf, dst, 0, dst.length);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return dst;
    }

    private InputStream inflate(Source src, long inflatedSize) throws IOException {
        this.inflater.open(src, inflatedSize);
        return this.inflater;
    }

    private void addObjectAndTrack(PackedObjectInfo oe) {
        this.entries[this.entryCount++] = oe;
        if (this.needNewObjectIds()) {
            this.newObjectIds.add(oe);
        }
    }

    private static class DeltaChain
    extends ObjectIdOwnerMap.Entry {
        UnresolvedDelta head;

        DeltaChain(AnyObjectId id) {
            super(id);
        }

        UnresolvedDelta remove() {
            UnresolvedDelta r = this.head;
            if (r != null) {
                this.head = null;
            }
            return r;
        }

        void add(UnresolvedDelta d) {
            d.next = this.head;
            this.head = d;
        }
    }

    private static class DeltaVisit {
        final UnresolvedDelta delta;
        ObjectId id;
        byte[] data;
        DeltaVisit parent;
        UnresolvedDelta nextChild;

        DeltaVisit() {
            this.delta = null;
        }

        DeltaVisit(DeltaVisit parent) {
            this.parent = parent;
            this.delta = parent.nextChild;
            parent.nextChild = this.delta.next;
        }

        DeltaVisit next() {
            if (this.parent != null && this.parent.nextChild == null) {
                this.parent.data = null;
                this.parent = this.parent.parent;
            }
            if (this.nextChild != null) {
                return new DeltaVisit(this);
            }
            if (this.parent != null) {
                return new DeltaVisit(this.parent);
            }
            return null;
        }
    }

    private class InflaterStream
    extends InputStream {
        private final Inflater inf = InflaterCache.get();
        private final byte[] skipBuffer = new byte[512];
        private Source src;
        private long expectedSize;
        private long actualSize;
        private int p;

        InflaterStream() {
        }

        void release() {
            this.inf.reset();
            InflaterCache.release(this.inf);
        }

        void open(Source source2, long inflatedSize) throws IOException {
            this.src = source2;
            this.expectedSize = inflatedSize;
            this.actualSize = 0L;
            this.p = PackParser.this.fill(this.src, 1);
            this.inf.setInput(PackParser.this.buf, this.p, PackParser.this.bAvail);
        }

        @Override
        public long skip(long toSkip) throws IOException {
            long n = 0L;
            while (n < toSkip) {
                int cnt = (int)Math.min((long)this.skipBuffer.length, toSkip - n);
                int r = this.read(this.skipBuffer, 0, cnt);
                if (r <= 0) break;
                n += (long)r;
            }
            return n;
        }

        @Override
        public int read() throws IOException {
            int n = this.read(this.skipBuffer, 0, 1);
            return n == 1 ? this.skipBuffer[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] dst, int pos, int cnt) throws IOException {
            try {
                int n;
                int r;
                for (n = 0; n < cnt; n += r) {
                    r = this.inf.inflate(dst, pos + n, cnt - n);
                    if (this.inf.finished()) break;
                    if (!this.inf.needsInput()) continue;
                    PackParser.this.onObjectData(this.src, PackParser.this.buf, this.p, PackParser.this.bAvail);
                    PackParser.this.use(PackParser.this.bAvail);
                    this.p = PackParser.this.fill(this.src, 1);
                    this.inf.setInput(PackParser.this.buf, this.p, PackParser.this.bAvail);
                }
                this.actualSize += (long)n;
                return n > 0 ? n : -1;
            }
            catch (DataFormatException dfe) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().packfileCorruptionDetected, dfe.getMessage()));
            }
        }

        @Override
        public void close() throws IOException {
            if (this.read(this.skipBuffer) != -1 || this.actualSize != this.expectedSize) {
                throw new CorruptObjectException(MessageFormat.format(JGitText.get().packfileCorruptionDetected, JGitText.get().wrongDecompressedLength));
            }
            int used = PackParser.this.bAvail - this.inf.getRemaining();
            if (used > 0) {
                PackParser.this.onObjectData(this.src, PackParser.this.buf, this.p, used);
                PackParser.this.use(used);
            }
            this.inf.reset();
        }
    }

    public static class ObjectTypeAndSize {
        public int type;
        public long size;
    }

    public static enum Source {
        INPUT,
        DATABASE;

    }

    public static class UnresolvedDelta {
        long position;
        int crc;
        UnresolvedDelta next;
        long sizeBeforeInflating;

        public long getOffset() {
            return this.position;
        }

        public int getCRC() {
            return this.crc;
        }

        public void setCRC(int crc32) {
            this.crc = crc32;
        }
    }
}

