/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule.internal;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.io.IOUtils;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleScope;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.Context;
import org.sonar.api.server.rule.RuleDescriptionSection;
import org.sonar.api.server.rule.RuleTagFormat;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.StringPatternValidator;
import org.sonar.api.server.rule.internal.DefaultDebtRemediationFunctions;
import org.sonar.api.server.rule.internal.DefaultNewParam;
import org.sonar.api.utils.Preconditions;

class DefaultNewRule
extends RulesDefinition.NewRule {
    static final String SECTION_ALREADY_CONTAINS_DESCRIPTION_WITHOUT_CONTEXT = "Section with key %s already added without context information. Impossible to mix for the same section key, context aware and non-context aware descriptions.";
    static final String CONTEXT_KEY_NOT_UNIQUE = "A context with key %s was already added to section with key %s";
    static final String SECTION_KEY_NOT_UNIQUE = "A section with key %s already exists";
    static final String MIXTURE_OF_CONTEXT_KEYS_BETWEEN_SECTIONS_ERROR_MESSAGE = "All sections providing contexts must provide the same contexts. Section '%s' has descriptions for contexts: %s, whereas section '%s' provides descriptions for contexts: %s. ";
    private static final StringPatternValidator EDUCATION_PRINCIPLE_KEYS_VALIDATOR = StringPatternValidator.validatorWithCommonPatternForKeys("education principle keys");
    private final String pluginKey;
    private final String repoKey;
    private final String key;
    private RuleType type;
    private String name;
    private String htmlDescription;
    private String markdownDescription;
    private String internalKey;
    private String severity = "MAJOR";
    private boolean template;
    private RuleStatus status = RuleStatus.defaultStatus();
    private DebtRemediationFunction debtRemediationFunction;
    private String gapDescription;
    private final Set<String> tags = new TreeSet<String>();
    private final Set<String> securityStandards = new TreeSet<String>();
    private final Map<String, RulesDefinition.NewParam> paramsByKey = new HashMap<String, RulesDefinition.NewParam>();
    private final RulesDefinition.DebtRemediationFunctions functions;
    private boolean activatedByDefault;
    private RuleScope scope;
    private final Set<RuleKey> deprecatedRuleKeys = new TreeSet<RuleKey>();
    private final List<RuleDescriptionSection> ruleDescriptionSections = new ArrayList<RuleDescriptionSection>();
    private final Set<String> educationPrincipleKeys = new TreeSet<String>();

    DefaultNewRule(@Nullable String pluginKey, String repoKey, String key) {
        this.pluginKey = pluginKey;
        this.repoKey = repoKey;
        this.key = key;
        this.functions = new DefaultDebtRemediationFunctions(repoKey, key);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    @CheckForNull
    public RuleScope scope() {
        return this.scope;
    }

    @Override
    public DefaultNewRule setScope(RuleScope scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public DefaultNewRule setName(String s) {
        this.name = StringUtils.trimToNull(s);
        return this;
    }

    @Override
    public DefaultNewRule setTemplate(boolean template) {
        this.template = template;
        return this;
    }

    @Override
    public DefaultNewRule setActivatedByDefault(boolean activatedByDefault) {
        this.activatedByDefault = activatedByDefault;
        return this;
    }

    @Override
    public DefaultNewRule setSeverity(String s) {
        Preconditions.checkArgument(Severity.ALL.contains(s), "Severity of rule %s is not correct: %s", this, s);
        this.severity = s;
        return this;
    }

    @Override
    public DefaultNewRule setType(RuleType t) {
        this.type = t;
        return this;
    }

    @Override
    public RulesDefinition.NewRule addDescriptionSection(RuleDescriptionSection ruleDescriptionSection) {
        this.assertRuleDescriptionSectionIsValid(ruleDescriptionSection);
        this.ruleDescriptionSections.add(ruleDescriptionSection);
        return this;
    }

    private void assertRuleDescriptionSectionIsValid(RuleDescriptionSection ruleDescriptionSection) {
        ruleDescriptionSection.getContext().ifPresent(context -> this.assertContextAwareRuleDescriptionIsValid(ruleDescriptionSection, (Context)context));
        if (ruleDescriptionSection.getContext().isEmpty()) {
            Preconditions.checkArgument(this.isSectionKeyUnique(ruleDescriptionSection.getKey()), SECTION_KEY_NOT_UNIQUE, ruleDescriptionSection.getKey());
        }
    }

    private void assertContextAwareRuleDescriptionIsValid(RuleDescriptionSection ruleDescriptionSection, Context context) {
        String sectionKey = ruleDescriptionSection.getKey();
        String contextKey = context.getKey();
        Preconditions.checkArgument(this.isContextSetForAllRuleDescriptionSectionWithKey(sectionKey), SECTION_ALREADY_CONTAINS_DESCRIPTION_WITHOUT_CONTEXT, sectionKey);
        Preconditions.checkArgument(this.isContextKeyUniqueForSectionKey(sectionKey, contextKey), CONTEXT_KEY_NOT_UNIQUE, contextKey, sectionKey);
    }

    private boolean isContextSetForAllRuleDescriptionSectionWithKey(String sectionKey) {
        return this.ruleDescriptionSections.stream().filter(section -> section.getKey().equals(sectionKey)).map(RuleDescriptionSection::getContext).allMatch(Optional::isPresent);
    }

    private boolean isContextKeyUniqueForSectionKey(String sectionKey, String contextKey) {
        return this.ruleDescriptionSections.stream().filter(section -> section.getKey().equals(sectionKey)).map(RuleDescriptionSection::getContext).filter(Optional::isPresent).map(Optional::get).noneMatch(context -> contextKey.equals(context.getKey()));
    }

    private boolean isSectionKeyUnique(String sectionKey) {
        return this.ruleDescriptionSections.stream().map(RuleDescriptionSection::getKey).noneMatch(alreadyExistingKey -> alreadyExistingKey.equals(sectionKey));
    }

    @Override
    public DefaultNewRule setHtmlDescription(@Nullable String s) {
        Preconditions.checkState(this.markdownDescription == null, "Rule '%s' already has a Markdown description", this);
        this.htmlDescription = StringUtils.trimToNull(s);
        return this;
    }

    @Override
    public DefaultNewRule setHtmlDescription(@Nullable URL classpathUrl) {
        if (classpathUrl != null) {
            try {
                this.setHtmlDescription(IOUtils.toString(classpathUrl, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to read: " + classpathUrl, e);
            }
        } else {
            this.htmlDescription = null;
        }
        return this;
    }

    @Override
    @Deprecated(since="9.6", forRemoval=true)
    public DefaultNewRule setMarkdownDescription(@Nullable String s) {
        Preconditions.checkState(this.htmlDescription == null, "Rule '%s' already has an HTML description", this);
        this.markdownDescription = StringUtils.trimToNull(s);
        return this;
    }

    @Override
    @Deprecated(since="9.6", forRemoval=true)
    public DefaultNewRule setMarkdownDescription(@Nullable URL classpathUrl) {
        if (classpathUrl != null) {
            try {
                this.setMarkdownDescription(IOUtils.toString(classpathUrl, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IllegalStateException("Fail to read: " + classpathUrl, e);
            }
        } else {
            this.markdownDescription = null;
        }
        return this;
    }

    @Override
    public DefaultNewRule setStatus(RuleStatus status) {
        Preconditions.checkArgument(RuleStatus.REMOVED != status, "Status 'REMOVED' is not accepted on rule '%s'", this);
        this.status = status;
        return this;
    }

    @Override
    public RulesDefinition.DebtRemediationFunctions debtRemediationFunctions() {
        return this.functions;
    }

    @Override
    public DefaultNewRule setDebtRemediationFunction(@Nullable DebtRemediationFunction fn) {
        this.debtRemediationFunction = fn;
        return this;
    }

    @Override
    public DefaultNewRule setGapDescription(@Nullable String s) {
        this.gapDescription = s;
        return this;
    }

    @Override
    public RulesDefinition.NewParam createParam(String paramKey) {
        Preconditions.checkArgument(!this.paramsByKey.containsKey(paramKey), "The parameter '%s' is declared several times on the rule %s", paramKey, this);
        DefaultNewParam param = new DefaultNewParam(paramKey);
        this.paramsByKey.put(paramKey, param);
        return param;
    }

    @Override
    @CheckForNull
    public RulesDefinition.NewParam param(String paramKey) {
        return this.paramsByKey.get(paramKey);
    }

    @Override
    public Collection<RulesDefinition.NewParam> params() {
        return this.paramsByKey.values();
    }

    @Override
    public DefaultNewRule addTags(String ... list) {
        for (String tag : list) {
            RuleTagFormat.validate(tag);
            this.tags.add(tag);
        }
        return this;
    }

    @Override
    public DefaultNewRule setTags(String ... list) {
        this.tags.clear();
        this.addTags(list);
        return this;
    }

    @Override
    public DefaultNewRule addOwaspTop10(RulesDefinition.OwaspTop10 ... standards) {
        return this.addOwaspTop10(RulesDefinition.OwaspTop10Version.Y2017, standards);
    }

    @Override
    public DefaultNewRule addOwaspTop10(RulesDefinition.OwaspTop10Version owaspTop10Version, RulesDefinition.OwaspTop10 ... standards) {
        Objects.requireNonNull(owaspTop10Version, "Owasp version must not be null");
        for (RulesDefinition.OwaspTop10 owaspTop10 : standards) {
            String standard = owaspTop10Version.prefix() + ":" + owaspTop10.name().toLowerCase(Locale.ENGLISH);
            this.securityStandards.add(standard);
        }
        return this;
    }

    @Override
    public DefaultNewRule addOwaspAsvs(RulesDefinition.OwaspAsvsVersion owaspAsvsVersion, String ... requirements) {
        Objects.requireNonNull(owaspAsvsVersion, "OWASP ASVS version must not be null");
        Objects.requireNonNull(requirements, "Requirements for OWASP ASVS standard must not be null");
        for (String requirement : requirements) {
            String standard = owaspAsvsVersion.prefix() + ":" + requirement;
            this.securityStandards.add(standard);
        }
        return this;
    }

    @Override
    public DefaultNewRule addPciDss(RulesDefinition.PciDssVersion pciDssVersion, String ... requirements) {
        Objects.requireNonNull(pciDssVersion, "PCI DSS version must not be null");
        Objects.requireNonNull(requirements, "Requirements for PCI DSS standard must not be null");
        for (String requirement : requirements) {
            String standard = pciDssVersion.prefix() + ":" + requirement;
            this.securityStandards.add(standard);
        }
        return this;
    }

    @Override
    public DefaultNewRule addCwe(int ... nums) {
        for (int num : nums) {
            String standard = "cwe:" + num;
            this.securityStandards.add(standard);
        }
        return this;
    }

    @Override
    public DefaultNewRule setInternalKey(@Nullable String s) {
        this.internalKey = s;
        return this;
    }

    void validate() {
        if (StringUtils.isEmpty(this.name)) {
            throw new IllegalStateException(String.format("Name of rule %s is empty", this));
        }
        if (StringUtils.isEmpty(this.htmlDescription) && StringUtils.isEmpty(this.markdownDescription)) {
            throw new IllegalStateException(String.format("One of HTML description or Markdown description must be defined for rule %s", this));
        }
        DefaultNewRule.validateSameContextKeysExistsForAllContextualizedSections(this.ruleDescriptionSections);
    }

    private static void validateSameContextKeysExistsForAllContextualizedSections(List<RuleDescriptionSection> ruleDescriptionSections) {
        Map<String, Set<String>> sectionKeyToContextKeys = ruleDescriptionSections.stream().filter(section -> section.getContext().isPresent()).collect(Collectors.groupingBy(RuleDescriptionSection::getKey, Collectors.mapping(s -> s.getContext().get().getKey(), Collectors.toSet())));
        DefaultNewRule.assertAllSectionsContainsSameContextKeys(sectionKeyToContextKeys);
    }

    private static void assertAllSectionsContainsSameContextKeys(Map<String, Set<String>> sectionKeyToContextKeys) {
        if (sectionKeyToContextKeys.isEmpty()) {
            return;
        }
        Map.Entry<String, Set<String>> referenceSectionToContexts = sectionKeyToContextKeys.entrySet().iterator().next();
        String referenceSectionKey = referenceSectionToContexts.getKey();
        Set<String> referenceContexts = referenceSectionToContexts.getValue();
        sectionKeyToContextKeys.forEach((sectionKey, contextKeys) -> Preconditions.checkArgument(contextKeys.equals(referenceContexts), MIXTURE_OF_CONTEXT_KEYS_BETWEEN_SECTIONS_ERROR_MESSAGE, referenceSectionKey, referenceContexts, sectionKey, contextKeys));
    }

    @Override
    public DefaultNewRule addDeprecatedRuleKey(String repository, String key) {
        this.deprecatedRuleKeys.add(RuleKey.of(repository, key));
        return this;
    }

    @Override
    public DefaultNewRule addEducationPrincipleKeys(String ... keys2) {
        Set<String> candidateEducationPrincipleKeys = Set.of(keys2);
        EDUCATION_PRINCIPLE_KEYS_VALIDATOR.validate(candidateEducationPrincipleKeys);
        this.educationPrincipleKeys.addAll(candidateEducationPrincipleKeys);
        return this;
    }

    String pluginKey() {
        return this.pluginKey;
    }

    String repoKey() {
        return this.repoKey;
    }

    RuleType type() {
        return this.type;
    }

    String name() {
        return this.name;
    }

    public List<RuleDescriptionSection> getRuleDescriptionSections() {
        return Collections.unmodifiableList(this.ruleDescriptionSections);
    }

    public Set<String> educationPrincipleKeys() {
        return Collections.unmodifiableSet(this.educationPrincipleKeys);
    }

    String htmlDescription() {
        return this.htmlDescription;
    }

    @Deprecated(since="9.6", forRemoval=true)
    String markdownDescription() {
        return this.markdownDescription;
    }

    @CheckForNull
    String internalKey() {
        return this.internalKey;
    }

    String severity() {
        return this.severity;
    }

    boolean template() {
        return this.template;
    }

    RuleStatus status() {
        return this.status;
    }

    DebtRemediationFunction debtRemediationFunction() {
        return this.debtRemediationFunction;
    }

    String gapDescription() {
        return this.gapDescription;
    }

    Set<String> tags() {
        return this.tags;
    }

    Set<String> securityStandards() {
        return this.securityStandards;
    }

    Map<String, RulesDefinition.NewParam> paramsByKey() {
        return this.paramsByKey;
    }

    boolean activatedByDefault() {
        return this.activatedByDefault;
    }

    Set<RuleKey> deprecatedRuleKeys() {
        return this.deprecatedRuleKeys;
    }

    public String toString() {
        return String.format("[repository=%s, key=%s]", this.repoKey, this.key);
    }
}

