/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.BaseLogger;
import org.sonar.api.utils.log.LoggerLevel;

class LogbackLogger
extends BaseLogger {
    private final Logger logback;

    LogbackLogger(Logger logback) {
        this.logback = logback;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logback.isTraceEnabled();
    }

    @Override
    void doTrace(String msg) {
        this.logback.trace(msg);
    }

    @Override
    void doTrace(String msg, @Nullable Object arg) {
        this.logback.trace(msg, arg);
    }

    @Override
    void doTrace(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.logback.trace(msg, arg1, arg2);
    }

    @Override
    void doTrace(String msg, Object ... args2) {
        this.logback.trace(msg, args2);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logback.isDebugEnabled();
    }

    @Override
    protected void doDebug(String msg) {
        this.logback.debug(msg);
    }

    @Override
    protected void doDebug(String msg, @Nullable Object arg) {
        this.logback.debug(msg, arg);
    }

    @Override
    protected void doDebug(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.logback.debug(msg, arg1, arg2);
    }

    @Override
    protected void doDebug(String msg, Object ... args2) {
        this.logback.debug(msg, args2);
    }

    @Override
    protected void doInfo(String msg) {
        this.logback.info(msg);
    }

    @Override
    protected void doInfo(String msg, @Nullable Object arg) {
        this.logback.info(msg, arg);
    }

    @Override
    protected void doInfo(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.logback.info(msg, arg1, arg2);
    }

    @Override
    protected void doInfo(String msg, Object ... args2) {
        this.logback.info(msg, args2);
    }

    @Override
    protected void doWarn(String msg) {
        this.logback.warn(msg);
    }

    @Override
    void doWarn(String msg, Throwable thrown) {
        this.logback.warn(msg, thrown);
    }

    @Override
    protected void doWarn(String msg, @Nullable Object arg) {
        this.logback.warn(msg, arg);
    }

    @Override
    protected void doWarn(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.logback.warn(msg, arg1, arg2);
    }

    @Override
    protected void doWarn(String msg, Object ... args2) {
        this.logback.warn(msg, args2);
    }

    @Override
    protected void doError(String msg) {
        this.logback.error(msg);
    }

    @Override
    protected void doError(String msg, @Nullable Object arg) {
        this.logback.error(msg, arg);
    }

    @Override
    protected void doError(String msg, @Nullable Object arg1, @Nullable Object arg2) {
        this.logback.error(msg, arg1, arg2);
    }

    @Override
    protected void doError(String msg, Object ... args2) {
        this.logback.error(msg, args2);
    }

    @Override
    protected void doError(String msg, Throwable thrown) {
        this.logback.error(msg, thrown);
    }

    @Override
    public boolean setLevel(LoggerLevel level) {
        switch (level) {
            case TRACE: {
                this.logback.setLevel(Level.TRACE);
                break;
            }
            case DEBUG: {
                this.logback.setLevel(Level.DEBUG);
                break;
            }
            case INFO: {
                this.logback.setLevel(Level.INFO);
                break;
            }
            case WARN: {
                this.logback.setLevel(Level.WARN);
                break;
            }
            case ERROR: {
                this.logback.setLevel(Level.ERROR);
                break;
            }
            default: {
                throw new IllegalArgumentException("Only TRACE, DEBUG, INFO , WARN, ERROR logging levels are supported. Got: " + level);
            }
        }
        return true;
    }

    @Override
    public LoggerLevel getLevel() {
        return LoggerLevel.valueOf(this.logback.getEffectiveLevel().levelStr);
    }

    Logger logbackLogger() {
        return this.logback;
    }
}

