/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.index;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sonar.duplications.index.ClonePart;

public class CloneGroup {
    private final ClonePart originPart;
    private final int cloneLength;
    private final List<ClonePart> parts;
    private int length;
    private int hash;

    public static Builder builder() {
        return new Builder();
    }

    private CloneGroup(Builder builder) {
        this.cloneLength = builder.length;
        this.originPart = builder.origin;
        this.parts = builder.parts;
        this.length = builder.lengthInUnits;
    }

    public ClonePart getOriginPart() {
        return this.originPart;
    }

    public int getLengthInUnits() {
        return this.length;
    }

    public int getCloneUnitLength() {
        return this.cloneLength;
    }

    public List<ClonePart> getCloneParts() {
        return this.parts;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ClonePart part : this.parts) {
            builder.append(part).append(" - ");
        }
        builder.append(this.cloneLength);
        return builder.toString();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CloneGroup another = (CloneGroup)object;
        if (another.cloneLength != this.cloneLength || this.parts.size() != another.parts.size()) {
            return false;
        }
        if (!this.originPart.equals(another.originPart)) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.parts.size(); ++i) {
            result &= another.parts.get(i).equals(this.parts.get(i));
        }
        return result;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.cloneLength != 0) {
            for (ClonePart part : this.parts) {
                h = 31 * h + part.hashCode();
            }
            h = 31 * h + this.originPart.hashCode();
            this.hash = h = 31 * h + this.cloneLength;
        }
        return h;
    }

    public static final class Builder {
        private ClonePart origin;
        private int length;
        private int lengthInUnits;
        private List<ClonePart> parts = new ArrayList<ClonePart>();

        public Builder setLength(int length) {
            this.length = length;
            return this;
        }

        public Builder setOrigin(ClonePart origin) {
            this.origin = origin;
            return this;
        }

        public Builder setParts(List<ClonePart> parts) {
            this.parts = new ArrayList<ClonePart>(parts);
            return this;
        }

        public Builder addPart(ClonePart part) {
            Objects.requireNonNull(part);
            this.parts.add(part);
            return this;
        }

        public Builder setLengthInUnits(int length) {
            this.lengthInUnits = length;
            return this;
        }

        public CloneGroup build() {
            return new CloneGroup(this);
        }
    }
}

