/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6265")
public class BucketsAccessCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure granting access to %s group is safe here.";
    private static final String SECONDARY_MSG = "Related bucket";

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_s3_bucket", (ResourceSymbol resource) -> resource.attribute("acl").reportIf(ExpressionPredicate.equalTo("authenticated-read"), String.format(MESSAGE, "AuthenticatedUsers"), resource.toSecondary(SECONDARY_MSG)).reportIf(ExpressionPredicate.matchesPattern("public-read(-write)?"), String.format(MESSAGE, "AllUsers"), resource.toSecondary(SECONDARY_MSG)));
    }
}

