/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.parser.grammar;

import com.sonar.sslr.api.GenericTokenType;
import org.sonar.iac.common.parser.grammar.Punctuator;
import org.sonar.iac.terraform.parser.grammar.HclKeyword;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;

public enum HclLexicalGrammar implements GrammarRuleKey
{
    FILE,
    ONE_LINE_BLOCK,
    BLOCK,
    EXPRESSION,
    LABEL,
    ATTRIBUTE,
    OBJECT,
    OBJECT_ELEMENT,
    TUPLE,
    FUNCTION_CALL,
    EOF,
    IDENTIFIER,
    STRING_LITERAL,
    STRING_WITHOUT_INTERPOLATION,
    TEMPLATE_LITERAL,
    NUMERIC_LITERAL,
    NUMERIC_INDEX,
    HEREDOC_LITERAL,
    SPACING,
    NEWLINE,
    LITERAL_EXPRESSION,
    VARIABLE_EXPRESSION,
    QUOTED_TEMPLATE,
    BOOLEAN_LITERAL,
    NULL,
    QUOTED_TEMPLATE_STRING_CHARACTERS;


    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        HclLexicalGrammar.lexical(b);
        HclLexicalGrammar.punctuators(b);
        HclLexicalGrammar.keywords(b);
        return b;
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        for (Punctuator p : Punctuator.values()) {
            b.rule(p).is(SPACING, p.getValue()).skip();
        }
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule(SPACING).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), b.zeroOrMore(b.commentTrivia(b.regexp("(?://(?:[^\\n\\r])*+|#(?:[^\\n\\r])*+|/\\*[\\s\\S]*?\\*/)")), b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")))).skip();
        b.rule(NEWLINE).is(b.skippedTrivia(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), b.zeroOrMore(b.commentTrivia(b.regexp("(?://(?:[^\\n\\r])*+|#(?:[^\\n\\r])*+|/\\*[\\s\\S]*?\\*/)")), b.skippedTrivia(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+"))), b.regexp("[\\n\\r\\u2028\\u2029]")).skip();
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule(IDENTIFIER).is(SPACING, b.regexp("[a-zA-Z][a-zA-Z0-9\\-\\_]*+"));
        b.rule(STRING_LITERAL).is(SPACING, b.regexp("\"(?:[^\"\\\\]*+(?:\\\\[\\s\\S])?+)*+\""));
        b.rule(STRING_WITHOUT_INTERPOLATION).is(SPACING, b.regexp("\"(?:(?:[^\"\\\\$%]|\\\\[\\s\\S]?|\\$\\$\\{|\\$(?!\\{)|%%\\{|%(?!\\{))++)?+\""));
        b.rule(TEMPLATE_LITERAL).is(SPACING, b.regexp("(?:[^$%\"]|\\$(?!\\{)|%(?!\\{))++"));
        b.rule(NUMERIC_LITERAL).is(SPACING, b.regexp("[0-9]+(?:\\.[0-9]+)?(?:[eE][+-]?[0-9]+)?"));
        b.rule(NUMERIC_INDEX).is(b.regexp("[0-9]+"));
        b.rule(HEREDOC_LITERAL).is(SPACING, b.regexp("<<-?([a-zA-Z][a-zA-Z0-9\\-\\_]*+)[\\n\\r\\u2028\\u2029][\\s\\S]*?[\\n\\r\\u2028\\u2029][\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+\\1(?!\\S)"));
        b.rule(BOOLEAN_LITERAL).is(b.firstOf(HclLexicalGrammar.word(b, "TRUE"), HclLexicalGrammar.word(b, "FALSE")));
        b.rule(NULL).is(HclLexicalGrammar.word(b, "NULL")).skip();
        b.rule(QUOTED_TEMPLATE_STRING_CHARACTERS).is(b.regexp("(?:[^\"\\\\$%]|\\\\[\\s\\S]?|\\$\\$\\{|\\$(?!\\{)|%%\\{|%(?!\\{))++"));
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        Object[] rest = new Object[HclKeyword.values().length - 2];
        for (int i = 0; i < HclKeyword.values().length; ++i) {
            HclKeyword tokenType = HclKeyword.values()[i];
            b.rule(tokenType).is(SPACING, b.regexp(tokenType.getValue()), b.nextNot(b.regexp("[a-zA-Z][a-zA-Z0-9\\-\\_]*+"))).skip();
            if (i <= 1) continue;
            rest[i - 2] = b.regexp(tokenType.getValue());
        }
    }

    private static Object word(LexerlessGrammarBuilder b, String word) {
        return b.sequence(SPACING, b.regexp("(?i)" + word), b.nextNot(b.regexp("[a-zA-Z0-9\\-\\_]")));
    }
}

