/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.common;

import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.plugins.common.DefaultQualityProfileDefinition;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

public class CommonRulesDefinition
implements RulesDefinition {
    private static final String RESOURCE_FOLDER_FORMAT = "/org/sonar/l10n/%s/rules/%s";
    private final SonarRuntime sonarRuntime;
    public final String repositoryKey;
    public final String repositoryName;
    public final String languageKey;
    private final List<Class<?>> checks;

    public CommonRulesDefinition(SonarRuntime sonarRuntime, String repositoryKey, String repositoryName, String languageKey, List<Class<?>> checks) {
        this.sonarRuntime = sonarRuntime;
        this.repositoryKey = repositoryKey;
        this.repositoryName = repositoryName;
        this.languageKey = languageKey;
        this.checks = checks;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(this.repositoryKey, this.languageKey).setName(this.repositoryName);
        String resourcePath = CommonRulesDefinition.resourcePath(this.repositoryKey, this.languageKey);
        String defaultProfilePath = DefaultQualityProfileDefinition.profilePath(this.repositoryKey, this.languageKey);
        RuleMetadataLoader ruleMetadataLoader = new RuleMetadataLoader(resourcePath, defaultProfilePath, this.sonarRuntime);
        ruleMetadataLoader.addRulesByAnnotatedClass(repository, this.checks);
        repository.done();
    }

    public static String resourcePath(String repository, String language) {
        return String.format(RESOURCE_FOLDER_FORMAT, repository, language);
    }
}

