/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.secrets.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.plugins.common.Check;
import org.sonar.plugins.common.InputFileContext;
import org.sonar.plugins.secrets.api.SecretsMatcher;

public class SecretRule {
    private final String message;
    private final List<SecretsMatcher> matchers;
    private final Predicate<String> isMatchedTextFalsePositive;

    public SecretRule(String message, SecretsMatcher ... matchers) {
        this(message, (String text) -> false, matchers);
    }

    public SecretRule(String message, Predicate<String> isMatchedTextFalsePositive, SecretsMatcher ... matchers) {
        this.message = message;
        this.matchers = Arrays.asList(matchers);
        this.isMatchedTextFalsePositive = isMatchedTextFalsePositive;
    }

    public final void analyze(Check check, InputFileContext ctx) {
        ArrayList foundSecrets = new ArrayList();
        this.matchers.stream().flatMap(matcher -> matcher.findIn(ctx.content()).stream()).filter(match -> !this.isMatchedTextFalsePositive.test(match.getText())).map(match -> ctx.newTextRangeFromFileOffsets(match.getFileStartOffset(), match.getFileEndOffset())).forEach(textRange -> {
            boolean notOverlapsExisting = foundSecrets.stream().noneMatch(foundSecret -> foundSecret.overlap(textRange));
            if (notOverlapsExisting) {
                foundSecrets.add(textRange);
                ctx.reportIssue(check.ruleKey, (TextRange)textRange, this.message);
            }
        });
    }
}

