/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.python.checks.cdk.AbstractCdkResourceCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.checks.cdk.PolicyStatement;

public abstract class AbstractIamPolicyStatementCheck
extends AbstractCdkResourceCheck {
    @Override
    protected void registerFqnConsumer() {
        this.checkFqn("aws_cdk.aws_iam.PolicyStatement", (ctx, call) -> this.checkPolicyStatement(PolicyStatement.build(ctx, call)));
        this.checkFqn("aws_cdk.aws_iam.PolicyStatement.from_json", (ctx, call) -> AbstractIamPolicyStatementCheck.getDictionaryFromJson(ctx, call).ifPresent(json -> this.checkPolicyStatementFromJson(PolicyStatement.build(ctx, json))));
        this.checkFqn("aws_cdk.aws_iam.PolicyDocument.from_json", (ctx, call) -> AbstractIamPolicyStatementCheck.getDictionaryFromJson(ctx, call).ifPresent(json -> AbstractIamPolicyStatementCheck.getPolicyStatements(ctx, json).forEach(statement -> this.checkPolicyStatementFromJson(PolicyStatement.build(ctx, statement)))));
    }

    protected void checkPolicyStatement(PolicyStatement policyStatement) {
        if (AbstractIamPolicyStatementCheck.hasAllowEffect(policyStatement.effect())) {
            this.checkAllowingPolicyStatement(policyStatement);
        }
    }

    protected void checkPolicyStatementFromJson(PolicyStatement policyStatementFormJson) {
        this.checkPolicyStatement(policyStatementFormJson);
    }

    protected static boolean hasAllowEffect(@Nullable CdkUtils.ExpressionFlow effect) {
        if (effect == null) {
            return true;
        }
        return effect.hasExpression(CdkPredicate.isFqn("aws_cdk.aws_iam.Effect.ALLOW").or(AbstractIamPolicyStatementCheck.isJsonAllow()));
    }

    protected abstract void checkAllowingPolicyStatement(PolicyStatement var1);

    protected static Optional<DictionaryLiteral> getDictionaryFromJson(SubscriptionContext ctx, CallExpression call) {
        return CdkUtils.getArgument(ctx, call, "obj", 0).flatMap(CdkUtils::getDictionary);
    }

    protected static List<DictionaryLiteral> getPolicyStatements(SubscriptionContext ctx, DictionaryLiteral json) {
        return CdkUtils.getDictionaryPair(ctx, json, "Statement").map(pair -> pair.value).flatMap(CdkUtils::getList).map(list -> CdkUtils.getDictionaryInList(ctx, list)).orElse(Collections.emptyList());
    }

    protected static CdkUtils.ExpressionFlow getSensitiveExpression(CdkUtils.ExpressionFlow expression, Predicate<Expression> predicate) {
        if (expression.hasExpression(predicate)) {
            return expression;
        }
        List listElements = CdkUtils.getList(expression).map(list -> CdkUtils.getListElements(expression.ctx(), list)).orElse(Collections.emptyList());
        return listElements.stream().filter(expressionFlow -> expressionFlow.hasExpression(predicate)).findAny().orElse(null);
    }

    private static Predicate<Expression> isJsonAllow() {
        return expression -> CdkUtils.getString(expression).filter("allow"::equalsIgnoreCase).isPresent();
    }
}

