/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.mozilla.jss.netscape.security.util.DerInputBuffer;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;

public final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private BigInteger[] components;
    private int componentLen;
    private static final int ALLOCATION_QUANTUM = 5;
    private static Map<String, ObjectIdentifier> mOIDs = new HashMap<String, ObjectIdentifier>();

    public ObjectIdentifier(String oid) {
        if (oid == null) {
            return;
        }
        int ch = 46;
        int start = 0;
        int end = 0;
        this.componentLen = 0;
        while ((end = oid.indexOf(ch, start)) != -1) {
            start = end + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new BigInteger[this.componentLen];
        start = 0;
        int i = 0;
        String comp = null;
        while ((end = oid.indexOf(ch, start)) != -1) {
            comp = oid.substring(start, end);
            this.components[i++] = new BigInteger(comp);
            start = end + 1;
        }
        comp = oid.substring(start);
        this.components[i] = new BigInteger(comp);
    }

    public ObjectIdentifier(int[] values) {
        try {
            this.componentLen = values.length;
            BigInteger[] tmp = new BigInteger[this.componentLen];
            for (int i = 0; i < this.componentLen; ++i) {
                tmp[i] = BigInteger.valueOf(values[i]);
            }
            this.components = (BigInteger[])tmp.clone();
        }
        catch (Exception t) {
            System.out.println("X509.ObjectIdentifier(), no cloning!");
        }
    }

    public ObjectIdentifier(BigInteger[] values) {
        try {
            this.componentLen = values.length;
            this.componentLen = values.length;
            BigInteger[] tmp = new BigInteger[this.componentLen];
            for (int i = 0; i < this.componentLen; ++i) {
                tmp[i] = new BigInteger(values[i].toString());
            }
            this.components = (BigInteger[])tmp.clone();
        }
        catch (Exception t) {
            System.out.println("X509.ObjectIdentifier(), no cloning!");
        }
    }

    public ObjectIdentifier(long[] values) {
        try {
            this.componentLen = values.length;
            BigInteger[] tmp = new BigInteger[this.componentLen];
            for (int i = 0; i < this.componentLen; ++i) {
                tmp[i] = BigInteger.valueOf(values[i]);
            }
            this.components = (BigInteger[])tmp.clone();
        }
        catch (Exception t) {
            System.out.println("X509.ObjectIdentifier(), no cloning!");
        }
    }

    public ObjectIdentifier(DerInputStream in) throws IOException {
        byte typeId = (byte)in.getByte();
        if (typeId != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + typeId + ")");
        }
        int bufferEnd = in.available() - in.getLength() - 1;
        if (bufferEnd < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.initFromEncoding(in, bufferEnd);
    }

    ObjectIdentifier(DerInputBuffer buf) throws IOException {
        this.initFromEncoding(new DerInputStream(buf), 0);
    }

    private void initFromEncoding(DerInputStream in, int bufferEnd) throws IOException {
        boolean firstSubid = true;
        this.components = new BigInteger[5];
        this.componentLen = 0;
        while (in.available() > bufferEnd) {
            BigInteger component = ObjectIdentifier.getComponentBigInt(in);
            if (firstSubid) {
                long x = component.intValue() < 40 ? 0L : (component.intValue() < 80 ? 1L : 2L);
                long y = (long)component.intValue() - x * 40L;
                this.components[0] = BigInteger.valueOf(x);
                this.components[1] = BigInteger.valueOf(y);
                this.componentLen = 2;
                firstSubid = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                BigInteger[] tmpComponents = new BigInteger[this.components.length + 5];
                System.arraycopy(this.components, 0, tmpComponents, 0, this.components.length);
                this.components = tmpComponents;
            }
            this.components[this.componentLen++] = component;
        }
        if (in.available() != bufferEnd) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        bytes.write(this.components[0].intValue() * 40 + this.components[1].intValue());
        for (int i = 2; i < this.componentLen; ++i) {
            ObjectIdentifier.putComponentBigInt(bytes, this.components[i]);
        }
        out.write((byte)6, bytes);
    }

    private static BigInteger getComponentBigInt(DerInputStream in) throws IOException {
        int tmp;
        BigInteger retval = BigInteger.valueOf(0L);
        do {
            retval = retval.shiftLeft(7);
            tmp = in.getByte();
            retval = retval.or(BigInteger.valueOf(tmp & 0x7F));
        } while ((tmp & 0x80) != 0);
        return retval;
    }

    private static void putComponentBigInt(DerOutputStream out, BigInteger val) {
        int blockSize = 100;
        byte[] buf = new byte[blockSize];
        BigInteger bigInt7f = BigInteger.valueOf(127L);
        BigInteger cur = new BigInteger(val.toString());
        int i = 0;
        while (true) {
            buf[i] = cur.and(bigInt7f).byteValue();
            if ((cur = cur.shiftRight(7)).compareTo(BigInteger.ZERO) == 0) break;
            ++i;
        }
        while (i > 0) {
            out.write(buf[i] | 0x80);
            --i;
        }
        out.write(buf[0]);
    }

    public boolean precedes(ObjectIdentifier other) {
        if (other == this || this.componentLen < other.componentLen) {
            return false;
        }
        if (other.componentLen < this.componentLen) {
            return true;
        }
        for (int i = 0; i < this.componentLen; ++i) {
            if (other.components[i].compareTo(this.components[i]) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        ObjectIdentifier oi;
        return other instanceof ObjectIdentifier && this.equals(oi = (ObjectIdentifier)other);
    }

    public boolean equals(ObjectIdentifier other) {
        if (other == this) {
            return true;
        }
        if (this.componentLen != other.componentLen) {
            return false;
        }
        for (int i = 0; i < this.componentLen; ++i) {
            if (this.components[i].compareTo(other.components[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int oflow = 0;
        for (int i = 0; i < this.componentLen; ++i) {
            oflow = (h & 0xFF800000) >> 23;
            h <<= 9;
            h += this.components[i].intValue();
            h ^= oflow;
        }
        return h;
    }

    public String toString() {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < this.componentLen; ++i) {
            if (i != 0) {
                retval.append(".");
            }
            retval.append(this.components[i]);
        }
        return retval.toString();
    }

    public static ObjectIdentifier getObjectIdentifier(String oid) throws IOException {
        if (oid == null) {
            throw new IOException("empty object identifier");
        }
        ObjectIdentifier thisOID = mOIDs.get(oid = oid.trim());
        if (thisOID != null) {
            return thisOID;
        }
        StringTokenizer token = new StringTokenizer(oid, ".");
        int value = Integer.valueOf(token.nextToken());
        if (value < 0 || value > 2) {
            throw new IOException("invalid oid " + oid);
        }
        value = Integer.valueOf(token.nextToken());
        if (value < 0 || value > 39) {
            throw new IOException("invalid oid " + oid);
        }
        thisOID = new ObjectIdentifier(oid);
        if (thisOID.toString().equals(oid)) {
            mOIDs.put(oid, thisOID);
            return thisOID;
        }
        throw new IOException("invalid oid " + oid);
    }

    public static ObjectIdentifier getObjectIdentifier(int[] values) throws IOException {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                retval.append(".");
            }
            retval.append(values[i]);
        }
        return ObjectIdentifier.getObjectIdentifier(retval.toString());
    }
}

