/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class CRLNumberExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 2992307666566322402L;
    public static final String NAME = "CRLNumber";
    public static final String NUMBER = "value";
    private BigInt crlNumber = null;

    private void encodeThis() throws IOException {
        if (this.crlNumber == null) {
            throw new IOException("Unintialized CRL number extension");
        }
        try (DerOutputStream os = new DerOutputStream();){
            os.putInteger(this.crlNumber);
            this.extensionValue = os.toByteArray();
        }
    }

    public CRLNumberExtension(int crlNum) throws IOException {
        this.crlNumber = new BigInt(crlNum);
        this.extensionId = PKIXExtensions.CRLNumber_Id;
        this.critical = false;
        this.encodeThis();
    }

    public CRLNumberExtension(BigInteger crlNum) throws IOException {
        this.crlNumber = new BigInt(crlNum);
        this.extensionId = PKIXExtensions.CRLNumber_Id;
        this.critical = false;
        this.encodeThis();
    }

    public CRLNumberExtension(Boolean critical, BigInteger crlNum) throws IOException {
        this.crlNumber = new BigInt(crlNum);
        this.extensionId = PKIXExtensions.CRLNumber_Id;
        this.critical = critical;
        this.encodeThis();
    }

    public CRLNumberExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.CRLNumber_Id;
        this.critical = critical;
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        for (int i = 0; i < len; ++i) {
            extValue[i] = Array.getByte(value, i);
        }
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        this.crlNumber = val.getInteger();
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (name.equalsIgnoreCase(NUMBER)) {
            if (!(obj instanceof BigInteger)) {
                throw new IOException("Attribute must be of type BigInteger.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLNumber.");
        }
        this.crlNumber = new BigInt((BigInteger)obj);
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(NUMBER)) {
            if (this.crlNumber == null) {
                return null;
            }
            return this.crlNumber.toBigInteger();
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLNumber.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(NUMBER)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLNumber.");
        }
        this.crlNumber = null;
    }

    @Override
    public String toString() {
        String s = super.toString() + "CRL Number: " + (this.crlNumber == null ? "" : this.crlNumber.toString()) + "\n";
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.CRLNumber_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(NUMBER);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

