/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.security.InvalidParameterException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.PQGParams;

public class PQGGen {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                throw new Exception("Usage: java PQGGen <keysize>");
            }
            int size = Integer.parseInt(args[0]);
            System.out.println("Generating PQG parameters for " + size + "-bit keypairs. This could take hours...");
            CryptoManager.initialize((String)".");
            PQGParams pqg = PQGParams.generate((int)size);
            System.out.println("Generated PQG Parameters.");
            System.out.println("Verifying PQG Parameters. This could take a few minutes...");
            if (!pqg.paramsAreValid()) {
                throw new Exception("ERROR: Generated parameters are invalid.");
            }
            System.out.println("Parameters are valid!");
            System.out.println("P: " + pqg.getP());
            System.out.println("Q: " + pqg.getQ());
            System.out.println("G: " + pqg.getG());
            System.out.println("H: " + pqg.getH());
            System.out.println("seed: " + pqg.getSeed());
            System.out.println("counter: " + pqg.getCounter());
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid key size: " + e);
        }
        catch (PQGParamGenException e) {
            System.err.println((Object)e);
        }
        catch (InvalidParameterException e) {
            System.err.println("Invalid key size: " + e);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

