/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class IA5CharsetEncoder
extends CharsetEncoder {
    public IA5CharsetEncoder(Charset cs) {
        super(cs, 1.0f, 1.0f);
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        while (in.remaining() >= 1) {
            in.mark();
            char c = in.get();
            if (CodingErrorAction.REPORT == this.unmappableCharacterAction() && (c & 0xFF80) != 0) {
                return CoderResult.unmappableForLength(1);
            }
            if (out.remaining() < 1) {
                in.reset();
                return CoderResult.OVERFLOW;
            }
            out.put((byte)(c & 0x7F));
        }
        return CoderResult.UNDERFLOW;
    }
}

