/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLNumberExtension;
import org.mozilla.jss.netscape.security.x509.DeltaCRLIndicatorExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.RevokedCertificate;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CRLImpl
extends X509CRL {
    public static Logger logger = LoggerFactory.getLogger(X509CRLImpl.class);
    private byte[] signedCRL = null;
    private byte[] signature = null;
    private byte[] tbsCertList = null;
    private AlgorithmId sigAlgId;
    private int version;
    private AlgorithmId infoSigAlgId;
    private X500Name issuer;
    private Date thisUpdate = null;
    private Date nextUpdate = null;
    private Hashtable<BigInteger, RevokedCertificate> revokedCerts = new Hashtable();
    private CRLExtensions extensions = null;
    private boolean entriesIncluded = true;
    private static final boolean IS_EXPLICIT = true;
    private boolean readOnly = false;

    public X509CRLImpl(byte[] crlData) throws CRLException, X509ExtensionException {
        try {
            DerValue in = new DerValue(crlData);
            this.parse(in);
            this.signedCRL = crlData;
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.getMessage(), e);
        }
    }

    public X509CRLImpl(byte[] crlData, boolean includeEntries) throws CRLException, X509ExtensionException {
        try {
            this.entriesIncluded = includeEntries;
            DerValue in = new DerValue(crlData);
            this.parse(in, includeEntries);
            this.signedCRL = crlData;
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.getMessage(), e);
        }
    }

    public X509CRLImpl(InputStream inStrm) throws CRLException, X509ExtensionException {
        try {
            DerValue val = new DerValue(inStrm);
            this.parse(val);
            this.signedCRL = val.toByteArray();
        }
        catch (IOException e) {
            throw new CRLException("Parsing error: " + e.getMessage());
        }
    }

    public X509CRLImpl(X500Name issuer, Date thisDate, Date nextDate) {
        this.issuer = issuer;
        this.thisUpdate = thisDate;
        this.nextUpdate = nextDate;
    }

    public X509CRLImpl(X500Name issuer, Date thisDate, Date nextDate, RevokedCertificate[] badCerts) throws CRLException, X509ExtensionException {
        this.issuer = issuer;
        this.thisUpdate = thisDate;
        this.nextUpdate = nextDate;
        if (badCerts != null) {
            for (int i = 0; i < badCerts.length; ++i) {
                this.revokedCerts.put(badCerts[i].getSerialNumber(), badCerts[i]);
            }
        }
    }

    public X509CRLImpl(X500Name issuer, Date thisDate, Date nextDate, RevokedCertificate[] badCerts, CRLExtensions crlExts) throws CRLException, X509ExtensionException {
        this.issuer = issuer;
        this.thisUpdate = thisDate;
        this.nextUpdate = nextDate;
        if (badCerts != null) {
            for (int i = 0; i < badCerts.length; ++i) {
                if (badCerts[i] == null) continue;
                this.revokedCerts.put(badCerts[i].getSerialNumber(), badCerts[i]);
                if (!badCerts[i].hasExtensions()) continue;
                this.version = 1;
            }
        }
        if (crlExts != null) {
            this.extensions = crlExts;
            this.version = 1;
        }
    }

    public X509CRLImpl(X500Name issuer, AlgorithmId algId, Date thisDate, Date nextDate, RevokedCertificate[] badCerts, CRLExtensions crlExts) throws CRLException, X509ExtensionException {
        this(issuer, thisDate, nextDate, badCerts, crlExts);
        this.infoSigAlgId = algId;
    }

    public X509CRLImpl(X500Name issuer, AlgorithmId algId, Date thisDate, Date nextDate, Hashtable<BigInteger, RevokedCertificate> badCerts, CRLExtensions crlExts) throws CRLException, X509ExtensionException {
        this.issuer = issuer;
        this.thisUpdate = thisDate;
        this.nextUpdate = nextDate;
        this.revokedCerts = badCerts;
        if (crlExts != null) {
            this.extensions = crlExts;
            this.version = 1;
        }
        this.infoSigAlgId = algId;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        if (this.signedCRL == null) {
            throw new CRLException("Null CRL to encode");
        }
        byte[] dup = new byte[this.signedCRL.length];
        System.arraycopy(this.signedCRL, 0, dup, 0, dup.length);
        return dup;
    }

    public boolean setSignedCRL(byte[] crl) {
        boolean done = false;
        if (this.tbsCertList != null && this.signedCRL == null) {
            this.signedCRL = new byte[crl.length];
            System.arraycopy(crl, 0, this.signedCRL, 0, this.signedCRL.length);
            done = true;
        }
        return done;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return true;
    }

    public void encodeInfo(OutputStream out) throws CRLException, X509ExtensionException {
        try (DerOutputStream seq = new DerOutputStream();){
            DerOutputStream tmp = new DerOutputStream();
            DerOutputStream rCerts = new DerOutputStream();
            if (this.version != 0) {
                tmp.putInteger(new BigInt(this.version));
            }
            this.infoSigAlgId.encode(tmp);
            this.issuer.encode(tmp);
            tmp.putUTCTime(this.thisUpdate);
            if (this.nextUpdate != null) {
                tmp.putUTCTime(this.nextUpdate);
            }
            if (!this.revokedCerts.isEmpty()) {
                Enumeration<RevokedCertificate> e = this.revokedCerts.elements();
                while (e.hasMoreElements()) {
                    ((RevokedCertImpl)e.nextElement()).encode(rCerts);
                }
                tmp.write((byte)48, rCerts);
            }
            if (this.extensions != null) {
                this.extensions.encode(tmp, true);
            }
            seq.write((byte)48, tmp);
            this.tbsCertList = seq.toByteArray();
            out.write(this.tbsCertList);
        }
        catch (IOException e) {
            throw new CRLException("Encoding error: " + e.getMessage());
        }
    }

    @Override
    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String sigProvider = null;
        this.verify(key, sigProvider);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.signedCRL == null) {
            throw new CRLException("Uninitialized CRL");
        }
        Signature sigVerf = null;
        String sigAlg = this.sigAlgId.getName();
        if (sigProvider != null && sigProvider.equals("Mozilla-JSS")) {
            if (sigAlg.equals("MD5withRSA")) {
                sigAlg = "MD5/RSA";
            } else if (sigAlg.equals("MD2withRSA")) {
                sigAlg = "MD2/RSA";
            } else if (sigAlg.equals("SHA1withRSA")) {
                sigAlg = "SHA1/RSA";
            } else if (sigAlg.equals("SHA1withDSA")) {
                sigAlg = "SHA1/DSA";
            } else if (sigAlg.equals("SHA1withEC")) {
                sigAlg = "SHA1/EC";
            } else if (sigAlg.equals("SHA256withRSA")) {
                sigAlg = "SHA256/RSA";
            } else if (sigAlg.equals("SHA384withRSA")) {
                sigAlg = "SHA384/RSA";
            } else if (sigAlg.equals("SHA512withRSA")) {
                sigAlg = "SHA512/RSA";
            } else if (sigAlg.equals("SHA256withEC")) {
                sigAlg = "SHA256/EC";
            } else if (sigAlg.equals("SHA384withEC")) {
                sigAlg = "SHA384/EC";
            } else if (sigAlg.equals("SHA512withEC")) {
                sigAlg = "SHA512/EC";
            }
        }
        sigVerf = Signature.getInstance(sigAlg, sigProvider);
        sigVerf.initVerify(key);
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        sigVerf.update(this.tbsCertList, 0, this.tbsCertList.length);
        if (!sigVerf.verify(this.signature)) {
            throw new CRLException("Signature does not match.");
        }
    }

    public void sign(PrivateKey key, String algorithm) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, X509ExtensionException {
        this.sign(key, algorithm, null);
    }

    public void sign(PrivateKey key, String algorithm, String provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, X509ExtensionException {
        try (DerOutputStream out = new DerOutputStream();){
            if (this.readOnly) {
                throw new CRLException("cannot over-write existing CRL");
            }
            Signature sigEngine = null;
            sigEngine = provider == null ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
            sigEngine.initSign(key);
            this.infoSigAlgId = this.sigAlgId = AlgorithmId.get(sigEngine.getAlgorithm());
            DerOutputStream tmp = new DerOutputStream();
            this.encodeInfo(tmp);
            this.sigAlgId.encode(tmp);
            sigEngine.update(this.tbsCertList, 0, this.tbsCertList.length);
            this.signature = sigEngine.sign();
            tmp.putBitString(this.signature);
            out.write((byte)48, tmp);
            this.signedCRL = out.toByteArray();
            this.readOnly = true;
        }
        catch (IOException e) {
            throw new CRLException("Error while encoding data: " + e.getMessage());
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("X.509 CRL v" + (this.version + 1) + "\nSignature Algorithm: " + this.sigAlgId + ", OID=" + this.sigAlgId.getOID() + "\nIssuer: " + this.issuer + "\n\nThis Update: " + this.thisUpdate + "\n");
        if (this.nextUpdate != null) {
            sb.append("Next Update: " + this.nextUpdate + "\n");
        }
        if (this.revokedCerts.isEmpty()) {
            sb.append("\nNO certificates have been revoked\n");
        } else {
            sb.append("\nRevoked Certificates:\n");
            Enumeration<RevokedCertificate> e = this.revokedCerts.elements();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement());
            }
        }
        if (this.extensions != null) {
            for (int i = 0; i < this.extensions.size(); ++i) {
                sb.append("\nCRL Extension[" + i + "]: " + this.extensions.elementAt(i));
            }
        }
        PrettyPrintFormat pp = new PrettyPrintFormat(" ", 20);
        String signaturebits = pp.toHexString(this.signature);
        sb.append("\nSignature:\n" + signaturebits);
        return sb.toString();
    }

    public boolean isRevoked(BigInteger serialNumber) {
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            return false;
        }
        return this.revokedCerts.containsKey(serialNumber);
    }

    @Override
    public boolean isRevoked(Certificate cert) {
        if (cert == null) {
            return false;
        }
        if (cert instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)cert;
            return this.isRevoked(x509Certificate.getSerialNumber());
        }
        return false;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Principal getIssuerDN() {
        return this.issuer;
    }

    @Override
    public Date getThisUpdate() {
        return new Date(this.thisUpdate.getTime());
    }

    @Override
    public Date getNextUpdate() {
        if (this.nextUpdate == null) {
            return null;
        }
        return new Date(this.nextUpdate.getTime());
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            return null;
        }
        return this.revokedCerts.get(serialNumber);
    }

    public Set<RevokedCertificate> getRevokedCertificates() {
        if (this.revokedCerts == null || this.revokedCerts.isEmpty()) {
            return null;
        }
        LinkedHashSet<RevokedCertificate> certSet = new LinkedHashSet<RevokedCertificate>(this.revokedCerts.values());
        return certSet;
    }

    public Hashtable<BigInteger, RevokedCertificate> getListOfRevokedCertificates() {
        return this.revokedCerts == null ? null : (Hashtable)this.revokedCerts.clone();
    }

    public int getNumberOfRevokedCertificates() {
        return this.revokedCerts == null ? -1 : this.revokedCerts.size();
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        if (this.tbsCertList == null) {
            throw new CRLException("Uninitialized CRL");
        }
        byte[] dup = new byte[this.tbsCertList.length];
        System.arraycopy(this.tbsCertList, 0, dup, 0, dup.length);
        return dup;
    }

    @Override
    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        byte[] dup = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, dup, 0, dup.length);
        return dup;
    }

    public boolean setSignature(byte[] crlSignature) {
        boolean done = false;
        if (this.tbsCertList != null && this.signature == null) {
            this.signature = new byte[crlSignature.length];
            System.arraycopy(crlSignature, 0, this.signature, 0, this.signature.length);
            done = true;
        }
        return done;
    }

    @Override
    public String getSigAlgName() {
        if (this.sigAlgId == null) {
            return null;
        }
        return this.sigAlgId.getName();
    }

    @Override
    public String getSigAlgOID() {
        if (this.sigAlgId == null) {
            return null;
        }
        ObjectIdentifier oid = this.sigAlgId.getOID();
        return oid.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.sigAlgId == null) {
            return null;
        }
        try {
            return this.sigAlgId.getEncodedParams();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        LinkedHashSet<String> extSet = new LinkedHashSet<String>();
        Enumeration<Extension> e = this.extensions.getElements();
        while (e.hasMoreElements()) {
            Extension ex = e.nextElement();
            if (!ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.extensions == null) {
            return null;
        }
        LinkedHashSet<String> extSet = new LinkedHashSet<String>();
        Enumeration<Extension> e = this.extensions.getElements();
        while (e.hasMoreElements()) {
            Extension ex = e.nextElement();
            if (ex.isCritical()) continue;
            extSet.add(ex.getExtensionId().toString());
        }
        return extSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.extensions == null) {
            return null;
        }
        try (DerOutputStream out = new DerOutputStream();){
            byte[] byArray;
            ObjectIdentifier findOID;
            String extAlias = OIDMap.getName(new ObjectIdentifier(oid));
            Extension crlExt = null;
            if (extAlias == null) {
                findOID = new ObjectIdentifier(oid);
                Extension ex = null;
                Enumeration<Extension> e = this.extensions.getElements();
                while (e.hasMoreElements()) {
                    ex = e.nextElement();
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals(findOID)) continue;
                    crlExt = ex;
                    break;
                }
            } else {
                crlExt = this.extensions.get(extAlias);
            }
            if (crlExt == null) {
                findOID = null;
                return findOID;
            }
            byte[] extData = crlExt.getExtensionValue();
            if (extData == null) {
                byArray = null;
                return byArray;
            }
            out.putOctetString(extData);
            byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    public BigInteger getCRLNumber() {
        try {
            CRLExtensions exts = this.getExtensions();
            if (exts == null) {
                return null;
            }
            Enumeration<Extension> e = exts.getElements();
            while (e.hasMoreElements()) {
                Extension ext = e.nextElement();
                if (!(ext instanceof CRLNumberExtension)) continue;
                CRLNumberExtension numExt = (CRLNumberExtension)ext;
                return (BigInteger)numExt.get("value");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public BigInteger getDeltaBaseCRLNumber() {
        try {
            CRLExtensions exts = this.getExtensions();
            if (exts == null) {
                return null;
            }
            Enumeration<Extension> e = exts.getElements();
            while (e.hasMoreElements()) {
                Extension ext = e.nextElement();
                if (!(ext instanceof DeltaCRLIndicatorExtension)) continue;
                DeltaCRLIndicatorExtension numExt = (DeltaCRLIndicatorExtension)ext;
                return (BigInteger)numExt.get("value");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isDeltaCRL() {
        try {
            CRLExtensions exts = this.getExtensions();
            if (exts == null) {
                return false;
            }
            Enumeration<Extension> e = exts.getElements();
            while (e.hasMoreElements()) {
                Extension ext = e.nextElement();
                if (!(ext instanceof DeltaCRLIndicatorExtension)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public CRLExtensions getExtensions() {
        return this.extensions;
    }

    public boolean areEntriesIncluded() {
        return this.entriesIncluded;
    }

    private void parse(DerValue val) throws CRLException, IOException, X509ExtensionException {
        this.parse(val, true);
    }

    private void parse(DerValue val, boolean includeEntries) throws CRLException, IOException, X509ExtensionException {
        DerValue tmp;
        AlgorithmId tmpId;
        if (this.readOnly) {
            throw new CRLException("cannot over-write existing CRL");
        }
        this.readOnly = true;
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue(), val.data.getDerValue()};
        if (val.data.available() != 0) {
            throw new CRLException("signed overrun, bytes = " + val.data.available());
        }
        if (seq[0].tag != 48) {
            throw new CRLException("signed CRL fields invalid");
        }
        this.sigAlgId = AlgorithmId.parse(seq[1]);
        this.signature = seq[2].getBitString();
        if (seq[1].data.available() != 0) {
            throw new CRLException("AlgorithmId field overrun");
        }
        if (seq[2].data.available() != 0) {
            throw new CRLException("Signature field overrun");
        }
        this.tbsCertList = seq[0].toByteArray();
        DerInputStream derStrm = seq[0].data;
        this.version = 0;
        byte nextByte = (byte)derStrm.peekByte();
        if (nextByte == 2) {
            this.version = derStrm.getInteger().toInt();
            if (this.version != 1) {
                throw new CRLException("Invalid version");
            }
        }
        if (!(tmpId = AlgorithmId.parse(tmp = derStrm.getDerValue())).equals(this.sigAlgId)) {
            throw new CRLException("Signature algorithm mismatch");
        }
        this.infoSigAlgId = tmpId;
        this.issuer = new X500Name(derStrm);
        nextByte = (byte)derStrm.peekByte();
        if (nextByte == 23) {
            this.thisUpdate = derStrm.getUTCTime();
        } else if (nextByte == 24) {
            this.thisUpdate = derStrm.getGeneralizedTime();
        } else {
            throw new CRLException("Invalid encoding for thisUpdate (tag=" + nextByte + ")");
        }
        if (derStrm.available() == 0) {
            return;
        }
        nextByte = (byte)derStrm.peekByte();
        if (nextByte == 23) {
            this.nextUpdate = derStrm.getUTCTime();
        } else if (nextByte == 24) {
            this.nextUpdate = derStrm.getGeneralizedTime();
        }
        if (derStrm.available() == 0) {
            return;
        }
        nextByte = (byte)derStrm.peekByte();
        if (nextByte == 48 && (nextByte & 0xC0) != 128) {
            if (includeEntries) {
                logger.info("X509CRLImpl: Parsing revoked certificates:");
                DerValue[] badCerts = derStrm.getSequence(4);
                for (int i = 0; i < badCerts.length; ++i) {
                    RevokedCertImpl entry = new RevokedCertImpl(badCerts[i]);
                    logger.info("X509CRLImpl: - 0x" + entry.getSerialNumber().toString(16));
                    if (entry.hasExtensions() && this.version == 0) {
                        throw new CRLException("Invalid encoding, extensions not supported in CRL v1 entries.");
                    }
                    this.revokedCerts.put(entry.getSerialNumber(), entry);
                }
            } else {
                logger.info("X509CRLImpl: Skipping revoked certificates");
                derStrm.skipSequence(4);
            }
        }
        if (derStrm.available() == 0) {
            return;
        }
        tmp = derStrm.getDerValue();
        if (tmp.isConstructed() && tmp.isContextSpecific((byte)0)) {
            if (this.version == 0) {
                throw new CRLException("Invalid encoding, extensions not supported in CRL v1.");
            }
            this.extensions = new CRLExtensions(tmp.data);
        }
    }
}

