/*---------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------------------------------------------*/

/// <reference path="./custom.d.ts" />
// tslint:disable
/**
 * Pytorch profile API
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0.0
 *
 *
 * NOTE: This file is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the file manually.
 */

import * as url from 'url'
import * as portableFetch from 'portable-fetch'
import { Configuration } from './configuration'

const BASE_PATH = '.'.replace(/\/+$/, '')

/**
 *
 * @export
 */
export const COLLECTION_FORMATS = {
  csv: ',',
  ssv: ' ',
  tsv: '\t',
  pipes: '|'
}

/**
 *
 * @export
 * @interface FetchAPI
 */
export interface FetchAPI {
  (url: string, init?: any): Promise<Response>
}

/**
 *
 * @export
 * @interface FetchArgs
 */
export interface FetchArgs {
  url: string
  options: any
}

/**
 *
 * @export
 * @class BaseAPI
 */
export class BaseAPI {
  protected configuration: Configuration

  constructor(
    configuration?: Configuration,
    protected basePath: string = BASE_PATH,
    protected fetch: FetchAPI = portableFetch
  ) {
    if (configuration) {
      this.configuration = configuration
      this.basePath = configuration.basePath || this.basePath
    }
  }
}

/**
 *
 * @export
 * @class RequiredError
 * @extends {Error}
 */
export class RequiredError extends Error {
  name: 'RequiredError'
  constructor(public field: string, msg?: string) {
    super(msg)
  }
}

/**
 *
 * @export
 * @interface CallStackTableData
 */
export interface CallStackTableData extends Array<CallStackTableDataInner> {}
/**
 *
 * @export
 * @interface CallStackTableDataInner
 */
export interface CallStackTableDataInner {
  /**
   *
   * @type {string}
   * @memberof CallStackTableDataInner
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof CallStackTableDataInner
   */
  inputShape?: string
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  calls: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  deviceSelfDuration?: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  deviceTotalDuration?: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  hostSelfDuration: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  hostTotalDuration: number
  /**
   *
   * @type {string}
   * @memberof CallStackTableDataInner
   */
  callStack?: string
  /**
   *
   * @type {string}
   * @memberof CallStackTableDataInner
   */
  tcEligible?: string
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  tcSelfRatio?: number
  /**
   *
   * @type {number}
   * @memberof CallStackTableDataInner
   */
  tcTotalRatio?: number
}
/**
 *
 * @export
 * @interface DistributedGraph
 */
export interface DistributedGraph {
  /**
   *
   * @type {DistributedGraphMetadata}
   * @memberof DistributedGraph
   */
  metadata: DistributedGraphMetadata
  /**
   *
   * @type {any}
   * @memberof DistributedGraph
   */
  data: any
}
/**
 *
 * @export
 * @interface DistributedGraphMetadata
 */
export interface DistributedGraphMetadata {
  /**
   *
   * @type {string}
   * @memberof DistributedGraphMetadata
   */
  title: string
  /**
   *
   * @type {Array<string>}
   * @memberof DistributedGraphMetadata
   */
  legends: Array<string>
  /**
   *
   * @type {string}
   * @memberof DistributedGraphMetadata
   */
  units: string
}
/**
 *
 * @export
 * @interface Environment
 */
export interface Environment {
  /**
   *
   * @type {string}
   * @memberof Environment
   */
  title: string
  /**
   *
   * @type {string}
   * @memberof Environment
   */
  value: string
}
/**
 *
 * @export
 * @interface GpuInfo
 */
export interface GpuInfo {
  /**
   *
   * @type {GpuInfoMetadata}
   * @memberof GpuInfo
   */
  metadata: GpuInfoMetadata
  /**
   *
   * @type {any}
   * @memberof GpuInfo
   */
  data: any
}
/**
 *
 * @export
 * @interface GpuInfoMetadata
 */
export interface GpuInfoMetadata {
  /**
   *
   * @type {string}
   * @memberof GpuInfoMetadata
   */
  title: string
}
/**
 *
 * @export
 * @interface GpuMetric
 */
export interface GpuMetric {
  /**
   *
   * @type {string}
   * @memberof GpuMetric
   */
  title: string
  /**
   *
   * @type {string}
   * @memberof GpuMetric
   */
  value: string
}
/**
 *
 * @export
 * @interface GpuMetrics
 */
export interface GpuMetrics {
  /**
   *
   * @type {Array<GpuMetric>}
   * @memberof GpuMetrics
   */
  data: Array<GpuMetric>
  /**
   *
   * @type {string}
   * @memberof GpuMetrics
   */
  tooltip: string
}
/**
 *
 * @export
 * @interface Graph
 */
export interface Graph {
  /**
   *
   * @type {string}
   * @memberof Graph
   */
  title?: string
  /**
   *
   * @type {Array<GraphColumn>}
   * @memberof Graph
   */
  columns: Array<GraphColumn>
  /**
   *
   * @type {Array<Array<string | number | boolean | ValueAndFormat>>}
   * @memberof Graph
   */
  rows: Array<Array<string | number | boolean | ValueAndFormat>>
}
/**
 *
 * @export
 * @interface GraphColumn
 */
export interface GraphColumn {
  /**
   *
   * @type {string}
   * @memberof GraphColumn
   */
  type: string
  /**
   *
   * @type {string}
   * @memberof GraphColumn
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof GraphColumn
   */
  role?: string
  /**
   *
   * @type {GraphColumnP}
   * @memberof GraphColumn
   */
  p?: GraphColumnP
}
/**
 *
 * @export
 * @interface GraphColumnP
 */
export interface GraphColumnP {
  /**
   *
   * @type {boolean}
   * @memberof GraphColumnP
   */
  html?: boolean
}
/**
 *
 * @export
 * @interface InlineResponse200
 */
export interface InlineResponse200 {
  /**
   *
   * @type {TableMetadata}
   * @memberof InlineResponse200
   */
  metadata: TableMetadata
  /**
   *
   * @type {OperationTableData}
   * @memberof InlineResponse200
   */
  data: OperationTableData
}
/**
 *
 * @export
 * @interface InlineResponse2001
 */
export interface InlineResponse2001 {
  /**
   *
   * @type {TableMetadata}
   * @memberof InlineResponse2001
   */
  metadata: TableMetadata
  /**
   *
   * @type {CallStackTableData}
   * @memberof InlineResponse2001
   */
  data: CallStackTableData
}
/**
 *
 * @export
 * @interface InlineResponse2002
 */
export interface InlineResponse2002 {
  /**
   *
   * @type {GpuInfoMetadata}
   * @memberof InlineResponse2002
   */
  metadata: GpuInfoMetadata
  /**
   *
   * @type {any}
   * @memberof InlineResponse2002
   */
  data: any
}
/**
 *
 * @export
 * @interface KernelGraph
 */
export interface KernelGraph {
  /**
   *
   * @type {Graph}
   * @memberof KernelGraph
   */
  total: Graph
}
/**
 *
 * @export
 * @interface MemoryCurve
 */
export interface MemoryCurve {
  /**
   *
   * @type {MemoryCurveMetadata}
   * @memberof MemoryCurve
   */
  metadata: MemoryCurveMetadata
  /**
   *
   * @type {Array<GraphColumn>}
   * @memberof MemoryCurve
   */
  columns: Array<GraphColumn>
  /**
   *
   * @type {any}
   * @memberof MemoryCurve
   */
  rows: any
}
/**
 *
 * @export
 * @interface MemoryCurveMetadata
 */
export interface MemoryCurveMetadata {
  /**
   *
   * @type {string}
   * @memberof MemoryCurveMetadata
   */
  defaultDevice: string
  /**
   *
   * @type {Array<string>}
   * @memberof MemoryCurveMetadata
   */
  devices: Array<string>
  /**
   *
   * @type {any}
   * @memberof MemoryCurveMetadata
   */
  peaks: any
  /**
   *
   * @type {any}
   * @memberof MemoryCurveMetadata
   */
  totals: any
  /**
   *
   * @type {number}
   * @memberof MemoryCurveMetadata
   */
  firstTs: number
  /**
   *
   * @type {string}
   * @memberof MemoryCurveMetadata
   */
  timeMetric: string
  /**
   *
   * @type {string}
   * @memberof MemoryCurveMetadata
   */
  memoryMetric: string
  /**
   *
   * @type {number}
   * @memberof MemoryCurveMetadata
   */
  timeFactor: number
  /**
   *
   * @type {number}
   * @memberof MemoryCurveMetadata
   */
  memoryFactor: number
}
/**
 *
 * @export
 * @interface MemoryData
 */
export interface MemoryData {
  /**
   *
   * @type {MemoryTableMetadata}
   * @memberof MemoryData
   */
  metadata: MemoryTableMetadata
  /**
   *
   * @type {Array<GraphColumn>}
   * @memberof MemoryData
   */
  columns: Array<GraphColumn>
  /**
   *
   * @type {any}
   * @memberof MemoryData
   */
  rows: any
}
/**
 *
 * @export
 * @interface MemoryEventsData
 */
export interface MemoryEventsData {
  /**
   *
   * @type {MemoryEventsTableMetadata}
   * @memberof MemoryEventsData
   */
  metadata: MemoryEventsTableMetadata
  /**
   *
   * @type {Array<GraphColumn>}
   * @memberof MemoryEventsData
   */
  columns: Array<GraphColumn>
  /**
   *
   * @type {any}
   * @memberof MemoryEventsData
   */
  rows: any
}
/**
 *
 * @export
 * @interface MemoryEventsTableMetadata
 */
export interface MemoryEventsTableMetadata {
  /**
   *
   * @type {string}
   * @memberof MemoryEventsTableMetadata
   */
  title: string
  /**
   *
   * @type {string}
   * @memberof MemoryEventsTableMetadata
   */
  defaultDevice: string
  /**
   *
   * @type {string}
   * @memberof MemoryEventsTableMetadata
   */
  search?: string
  /**
   *
   * @type {string}
   * @memberof MemoryEventsTableMetadata
   */
  sort?: string
}
/**
 *
 * @export
 * @interface MemoryTableMetadata
 */
export interface MemoryTableMetadata {
  /**
   *
   * @type {string}
   * @memberof MemoryTableMetadata
   */
  title: string
  /**
   *
   * @type {string}
   * @memberof MemoryTableMetadata
   */
  defaultDevice: string
  /**
   *
   * @type {string}
   * @memberof MemoryTableMetadata
   */
  search: string
  /**
   *
   * @type {string}
   * @memberof MemoryTableMetadata
   */
  sort: string
}
/**
 *
 * @export
 * @interface OperationTableData
 */
export interface OperationTableData extends Array<OperationTableDataInner> {}
/**
 *
 * @export
 * @interface OperationTableDataInner
 */
export interface OperationTableDataInner {
  /**
   *
   * @type {string}
   * @memberof OperationTableDataInner
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof OperationTableDataInner
   */
  inputShape?: string
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  calls: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  deviceSelfDuration?: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  deviceTotalDuration?: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  hostSelfDuration: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  hostTotalDuration: number
  /**
   *
   * @type {boolean}
   * @memberof OperationTableDataInner
   */
  hasCallStack: boolean
  /**
   *
   * @type {string}
   * @memberof OperationTableDataInner
   */
  tcEligible?: string
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  tcSelfRatio?: number
  /**
   *
   * @type {number}
   * @memberof OperationTableDataInner
   */
  tcTotalRatio?: number
}
/**
 *
 * @export
 * @interface OperatorGraph
 */
export interface OperatorGraph {
  /**
   *
   * @type {Graph}
   * @memberof OperatorGraph
   */
  deviceTotalTime?: Graph
  /**
   *
   * @type {Graph}
   * @memberof OperatorGraph
   */
  deviceSelfTime: Graph
  /**
   *
   * @type {Graph}
   * @memberof OperatorGraph
   */
  hostTotalTime: Graph
  /**
   *
   * @type {Graph}
   * @memberof OperatorGraph
   */
  hostSelfTime: Graph
}
/**
 *
 * @export
 * @interface Overview
 */
export interface Overview {
  /**
   *
   * @type {Array<Performance>}
   * @memberof Overview
   */
  performance: Array<Performance>
  /**
   *
   * @type {Array<Environment>}
   * @memberof Overview
   */
  environments: Array<Environment>
  /**
   *
   * @type {Graph}
   * @memberof Overview
   */
  steps: Graph
  /**
   *
   * @type {string}
   * @memberof Overview
   */
  recommendations: string
  /**
   *
   * @type {GpuMetrics}
   * @memberof Overview
   */
  gpuMetrics?: GpuMetrics
}
/**
 *
 * @export
 * @interface Performance
 */
export interface Performance {
  /**
   *
   * @type {string}
   * @memberof Performance
   */
  name: string
  /**
   *
   * @type {string}
   * @memberof Performance
   */
  description?: string
  /**
   *
   * @type {string}
   * @memberof Performance
   */
  value?: string
  /**
   *
   * @type {string}
   * @memberof Performance
   */
  extra?: string
  /**
   *
   * @type {Array<Performance>}
   * @memberof Performance
   */
  children?: Array<Performance>
}
/**
 *
 * @export
 * @interface Runs
 */
export interface Runs {
  /**
   *
   * @type {Array<string>}
   * @memberof Runs
   */
  runs: Array<string>
  /**
   *
   * @type {boolean}
   * @memberof Runs
   */
  loading: boolean
}
/**
 *
 * @export
 * @interface TableData
 */
export interface TableData {
  /**
   *
   * @type {Graph}
   * @memberof TableData
   */
  data: Graph
  /**
   *
   * @type {TableMetadata}
   * @memberof TableData
   */
  metadata: TableMetadata
}
/**
 *
 * @export
 * @interface TableMetadata
 */
export interface TableMetadata {
  /**
   *
   * @type {string}
   * @memberof TableMetadata
   */
  sort: string
  /**
   *
   * @type {any}
   * @memberof TableMetadata
   */
  tooltips?: any
}
/**
 *
 * @export
 * @interface TensorCoresGraph
 */
export interface TensorCoresGraph {
  /**
   *
   * @type {Graph}
   * @memberof TensorCoresGraph
   */
  total: Graph
}
/**
 *
 * @export
 * @interface ValueAndFormat
 */
export interface ValueAndFormat {
  /**
   *
   * @type {string | number | boolean}
   * @memberof ValueAndFormat
   */
  v: string | number | boolean
  /**
   *
   * @type {string}
   * @memberof ValueAndFormat
   */
  f: string
}
/**
 * DefaultApi - fetch parameter creator
 * @export
 */
export const DefaultApiFetchParamCreator = function (
  configuration?: Configuration
) {
  return {
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedCommopsGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling distributedCommopsGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling distributedCommopsGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling distributedCommopsGet.'
        )
      }
      const localVarPath = `/distributed/commops`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedGpuinfoGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling distributedGpuinfoGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling distributedGpuinfoGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling distributedGpuinfoGet.'
        )
      }
      const localVarPath = `/distributed/gpuinfo`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedOverlapGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling distributedOverlapGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling distributedOverlapGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling distributedOverlapGet.'
        )
      }
      const localVarPath = `/distributed/overlap`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedWaittimeGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling distributedWaittimeGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling distributedWaittimeGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling distributedWaittimeGet.'
        )
      }
      const localVarPath = `/distributed/waittime`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling kernelGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling kernelGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling kernelGet.'
        )
      }
      // verify required parameter 'groupBy' is not null or undefined
      if (groupBy === null || groupBy === undefined) {
        throw new RequiredError(
          'groupBy',
          'Required parameter groupBy was null or undefined when calling kernelGet.'
        )
      }
      const localVarPath = `/kernel`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (groupBy !== undefined) {
        localVarQueryParameter['group_by'] = groupBy
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} [groupBy] Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTableGet(
      run: string,
      worker: string,
      span: string,
      groupBy?: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling kernelTableGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling kernelTableGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling kernelTableGet.'
        )
      }
      const localVarPath = `/kernel/table`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (groupBy !== undefined) {
        localVarQueryParameter['group_by'] = groupBy
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTcPieGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling kernelTcPieGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling kernelTcPieGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling kernelTcPieGet.'
        )
      }
      const localVarPath = `/kernel/tc_pie`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryCurveGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling memoryCurveGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling memoryCurveGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling memoryCurveGet.'
        )
      }
      const localVarPath = `/memory_curve`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [startTs]
     * @param {number} [endTs]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryEventsGet(
      run: string,
      worker: string,
      span: string,
      startTs?: number,
      endTs?: number,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling memoryEventsGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling memoryEventsGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling memoryEventsGet.'
        )
      }
      const localVarPath = `/memory_events`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (startTs !== undefined) {
        localVarQueryParameter['start_ts'] = startTs
      }

      if (endTs !== undefined) {
        localVarQueryParameter['end_ts'] = endTs
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [startTs]
     * @param {number} [endTs]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryGet(
      run: string,
      worker: string,
      span: string,
      startTs?: number,
      endTs?: number,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling memoryGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling memoryGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling memoryGet.'
        )
      }
      const localVarPath = `/memory`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (startTs !== undefined) {
        localVarQueryParameter['start_ts'] = startTs
      }

      if (endTs !== undefined) {
        localVarQueryParameter['end_ts'] = endTs
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling operationGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling operationGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling operationGet.'
        )
      }
      // verify required parameter 'groupBy' is not null or undefined
      if (groupBy === null || groupBy === undefined) {
        throw new RequiredError(
          'groupBy',
          'Required parameter groupBy was null or undefined when calling operationGet.'
        )
      }
      const localVarPath = `/operation`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (groupBy !== undefined) {
        localVarQueryParameter['group_by'] = groupBy
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {string} opName
     * @param {string} [inputShape]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationStackGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      opName: string,
      inputShape?: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling operationStackGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling operationStackGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling operationStackGet.'
        )
      }
      // verify required parameter 'groupBy' is not null or undefined
      if (groupBy === null || groupBy === undefined) {
        throw new RequiredError(
          'groupBy',
          'Required parameter groupBy was null or undefined when calling operationStackGet.'
        )
      }
      // verify required parameter 'opName' is not null or undefined
      if (opName === null || opName === undefined) {
        throw new RequiredError(
          'opName',
          'Required parameter opName was null or undefined when calling operationStackGet.'
        )
      }
      const localVarPath = `/operation/stack`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (groupBy !== undefined) {
        localVarQueryParameter['group_by'] = groupBy
      }

      if (opName !== undefined) {
        localVarQueryParameter['op_name'] = opName
      }

      if (inputShape !== undefined) {
        localVarQueryParameter['input_shape'] = inputShape
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationTableGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling operationTableGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling operationTableGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling operationTableGet.'
        )
      }
      // verify required parameter 'groupBy' is not null or undefined
      if (groupBy === null || groupBy === undefined) {
        throw new RequiredError(
          'groupBy',
          'Required parameter groupBy was null or undefined when calling operationTableGet.'
        )
      }
      const localVarPath = `/operation/table`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      if (groupBy !== undefined) {
        localVarQueryParameter['group_by'] = groupBy
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    overviewGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling overviewGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling overviewGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling overviewGet.'
        )
      }
      const localVarPath = `/overview`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    runsGet(options: any = {}): FetchArgs {
      const localVarPath = `/runs`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    spansGet(run: string, worker: string, options: any = {}): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling spansGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling spansGet.'
        )
      }
      const localVarPath = `/spans`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    traceGet(
      run: string,
      worker: string,
      span: string,
      options: any = {}
    ): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling traceGet.'
        )
      }
      // verify required parameter 'worker' is not null or undefined
      if (worker === null || worker === undefined) {
        throw new RequiredError(
          'worker',
          'Required parameter worker was null or undefined when calling traceGet.'
        )
      }
      // verify required parameter 'span' is not null or undefined
      if (span === null || span === undefined) {
        throw new RequiredError(
          'span',
          'Required parameter span was null or undefined when calling traceGet.'
        )
      }
      const localVarPath = `/trace`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (worker !== undefined) {
        localVarQueryParameter['worker'] = worker
      }

      if (span !== undefined) {
        localVarQueryParameter['span'] = span
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    viewsGet(run: string, options: any = {}): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling viewsGet.'
        )
      }
      const localVarPath = `/views`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} view
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    workersGet(run: string, view: string, options: any = {}): FetchArgs {
      // verify required parameter 'run' is not null or undefined
      if (run === null || run === undefined) {
        throw new RequiredError(
          'run',
          'Required parameter run was null or undefined when calling workersGet.'
        )
      }
      // verify required parameter 'view' is not null or undefined
      if (view === null || view === undefined) {
        throw new RequiredError(
          'view',
          'Required parameter view was null or undefined when calling workersGet.'
        )
      }
      const localVarPath = `/workers`
      const localVarUrlObj = url.parse(localVarPath, true)
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options)
      const localVarHeaderParameter = {} as any
      const localVarQueryParameter = {} as any

      if (run !== undefined) {
        localVarQueryParameter['run'] = run
      }

      if (view !== undefined) {
        localVarQueryParameter['view'] = view
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query
      )
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search
      localVarRequestOptions.headers = Object.assign(
        {},
        localVarHeaderParameter,
        options.headers
      )

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions
      }
    }
  }
}

/**
 * DefaultApi - functional programming interface
 * @export
 */
export const DefaultApiFp = function (configuration?: Configuration) {
  return {
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedCommopsGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<InlineResponse2002> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).distributedCommopsGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedGpuinfoGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<GpuInfo> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).distributedGpuinfoGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedOverlapGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<DistributedGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).distributedOverlapGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedWaittimeGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<DistributedGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).distributedWaittimeGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<KernelGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).kernelGet(run, worker, span, groupBy, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} [groupBy] Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTableGet(
      run: string,
      worker: string,
      span: string,
      groupBy?: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<TableData> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).kernelTableGet(run, worker, span, groupBy, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTcPieGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<TensorCoresGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).kernelTcPieGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryCurveGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<MemoryCurve> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).memoryCurveGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [startTs]
     * @param {number} [endTs]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryEventsGet(
      run: string,
      worker: string,
      span: string,
      startTs?: number,
      endTs?: number,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<MemoryEventsData> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).memoryEventsGet(run, worker, span, startTs, endTs, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [startTs]
     * @param {number} [endTs]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryGet(
      run: string,
      worker: string,
      span: string,
      startTs?: number,
      endTs?: number,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<MemoryData> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).memoryGet(run, worker, span, startTs, endTs, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<OperatorGraph> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).operationGet(run, worker, span, groupBy, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {string} opName
     * @param {string} [inputShape]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationStackGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      opName: string,
      inputShape?: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<InlineResponse2001> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).operationStackGet(
        run,
        worker,
        span,
        groupBy,
        opName,
        inputShape,
        options
      )
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationTableGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<InlineResponse200> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).operationTableGet(run, worker, span, groupBy, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    overviewGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Overview> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).overviewGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    runsGet(
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Runs> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).runsGet(options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    spansGet(
      run: string,
      worker: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Array<string>> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).spansGet(run, worker, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    traceGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).traceGet(run, worker, span, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    viewsGet(
      run: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Array<string>> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).viewsGet(run, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    },
    /**
     *
     * @param {string} run
     * @param {string} view
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    workersGet(
      run: string,
      view: string,
      options?: any
    ): (fetch?: FetchAPI, basePath?: string) => Promise<Array<string>> {
      const localVarFetchArgs = DefaultApiFetchParamCreator(
        configuration
      ).workersGet(run, view, options)
      return (
        fetch: FetchAPI = portableFetch,
        basePath: string = BASE_PATH
      ) => {
        return fetch(
          basePath + localVarFetchArgs.url,
          localVarFetchArgs.options
        ).then((response) => {
          if (response.status >= 200 && response.status < 300) {
            return response.json()
          } else {
            throw response
          }
        })
      }
    }
  }
}

/**
 * DefaultApi - factory interface
 * @export
 */
export const DefaultApiFactory = function (
  configuration?: Configuration,
  fetch?: FetchAPI,
  basePath?: string
) {
  return {
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedCommopsGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).distributedCommopsGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedGpuinfoGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).distributedGpuinfoGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedOverlapGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).distributedOverlapGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    distributedWaittimeGet(
      run: string,
      worker: string,
      span: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).distributedWaittimeGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).kernelGet(
        run,
        worker,
        span,
        groupBy,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} [groupBy] Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTableGet(
      run: string,
      worker: string,
      span: string,
      groupBy?: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).kernelTableGet(
        run,
        worker,
        span,
        groupBy,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    kernelTcPieGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).kernelTcPieGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryCurveGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).memoryCurveGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [startTs]
     * @param {number} [endTs]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryEventsGet(
      run: string,
      worker: string,
      span: string,
      startTs?: number,
      endTs?: number,
      options?: any
    ) {
      return DefaultApiFp(configuration).memoryEventsGet(
        run,
        worker,
        span,
        startTs,
        endTs,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {number} [startTs]
     * @param {number} [endTs]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    memoryGet(
      run: string,
      worker: string,
      span: string,
      startTs?: number,
      endTs?: number,
      options?: any
    ) {
      return DefaultApiFp(configuration).memoryGet(
        run,
        worker,
        span,
        startTs,
        endTs,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).operationGet(
        run,
        worker,
        span,
        groupBy,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {string} opName
     * @param {string} [inputShape]
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationStackGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      opName: string,
      inputShape?: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).operationStackGet(
        run,
        worker,
        span,
        groupBy,
        opName,
        inputShape,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {string} groupBy Group By
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    operationTableGet(
      run: string,
      worker: string,
      span: string,
      groupBy: string,
      options?: any
    ) {
      return DefaultApiFp(configuration).operationTableGet(
        run,
        worker,
        span,
        groupBy,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    overviewGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).overviewGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    runsGet(options?: any) {
      return DefaultApiFp(configuration).runsGet(options)(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    spansGet(run: string, worker: string, options?: any) {
      return DefaultApiFp(configuration).spansGet(
        run,
        worker,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} worker
     * @param {string} span
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    traceGet(run: string, worker: string, span: string, options?: any) {
      return DefaultApiFp(configuration).traceGet(
        run,
        worker,
        span,
        options
      )(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    viewsGet(run: string, options?: any) {
      return DefaultApiFp(configuration).viewsGet(run, options)(fetch, basePath)
    },
    /**
     *
     * @param {string} run
     * @param {string} view
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    workersGet(run: string, view: string, options?: any) {
      return DefaultApiFp(configuration).workersGet(
        run,
        view,
        options
      )(fetch, basePath)
    }
  }
}

/**
 * DefaultApi - object-oriented interface
 * @export
 * @class DefaultApi
 * @extends {BaseAPI}
 */
export class DefaultApi extends BaseAPI {
  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public distributedCommopsGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).distributedCommopsGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public distributedGpuinfoGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).distributedGpuinfoGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public distributedOverlapGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).distributedOverlapGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public distributedWaittimeGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).distributedWaittimeGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} groupBy Group By
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public kernelGet(
    run: string,
    worker: string,
    span: string,
    groupBy: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).kernelGet(
      run,
      worker,
      span,
      groupBy,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} [groupBy] Group By
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public kernelTableGet(
    run: string,
    worker: string,
    span: string,
    groupBy?: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).kernelTableGet(
      run,
      worker,
      span,
      groupBy,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public kernelTcPieGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).kernelTcPieGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public memoryCurveGet(
    run: string,
    worker: string,
    span: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).memoryCurveGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {number} [startTs]
   * @param {number} [endTs]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public memoryEventsGet(
    run: string,
    worker: string,
    span: string,
    startTs?: number,
    endTs?: number,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).memoryEventsGet(
      run,
      worker,
      span,
      startTs,
      endTs,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {number} [startTs]
   * @param {number} [endTs]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public memoryGet(
    run: string,
    worker: string,
    span: string,
    startTs?: number,
    endTs?: number,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).memoryGet(
      run,
      worker,
      span,
      startTs,
      endTs,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} groupBy Group By
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public operationGet(
    run: string,
    worker: string,
    span: string,
    groupBy: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).operationGet(
      run,
      worker,
      span,
      groupBy,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} groupBy Group By
   * @param {string} opName
   * @param {string} [inputShape]
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public operationStackGet(
    run: string,
    worker: string,
    span: string,
    groupBy: string,
    opName: string,
    inputShape?: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).operationStackGet(
      run,
      worker,
      span,
      groupBy,
      opName,
      inputShape,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {string} groupBy Group By
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public operationTableGet(
    run: string,
    worker: string,
    span: string,
    groupBy: string,
    options?: any
  ) {
    return DefaultApiFp(this.configuration).operationTableGet(
      run,
      worker,
      span,
      groupBy,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public overviewGet(run: string, worker: string, span: string, options?: any) {
    return DefaultApiFp(this.configuration).overviewGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public runsGet(options?: any) {
    return DefaultApiFp(this.configuration).runsGet(options)(
      this.fetch,
      this.basePath
    )
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public spansGet(run: string, worker: string, options?: any) {
    return DefaultApiFp(this.configuration).spansGet(
      run,
      worker,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {string} worker
   * @param {string} span
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public traceGet(run: string, worker: string, span: string, options?: any) {
    return DefaultApiFp(this.configuration).traceGet(
      run,
      worker,
      span,
      options
    )(this.fetch, this.basePath)
  }

  /**
   *
   * @param {string} run
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public viewsGet(run: string, options?: any) {
    return DefaultApiFp(this.configuration).viewsGet(run, options)(
      this.fetch,
      this.basePath
    )
  }

  /**
   *
   * @param {string} run
   * @param {string} view
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof DefaultApi
   */
  public workersGet(run: string, view: string, options?: any) {
    return DefaultApiFp(this.configuration).workersGet(
      run,
      view,
      options
    )(this.fetch, this.basePath)
  }
}
