# This file is auto-generated by /codegen/x86_64.py
# Instruction data is based on package opcodes 0.3.14

import inspect

import peachpy.stream
import peachpy.x86_64.options
import peachpy.x86_64.isa
from peachpy.util import is_sint8, is_sint32
from peachpy.x86_64.encoding import rex, optional_rex, vex2, vex3, evex, modrm_sib_disp
from peachpy.x86_64.instructions import Instruction, BranchInstruction
from peachpy.x86_64.operand import is_al, is_ax, is_eax, is_rax, is_cl, is_xmm0, is_r8, is_r8rex, is_r16, is_r32, is_r64, \
    is_mm, is_xmm, is_ymm, is_m, is_m8, is_m16, is_m32, is_m64, is_m80, is_m128, is_m256, is_m512, \
    is_evex_xmm, is_xmmk, is_xmmkz, is_evex_ymm, is_ymmk, is_ymmkz, is_zmm, is_zmmk, is_zmmkz, is_k, is_kk, \
    is_m32k, is_m64k, is_m16kz, is_m32kz, is_m64kz, is_m128kz, is_m256kz, is_m512kz, \
    is_m64_m32bcst, is_m128_m32bcst, is_m256_m32bcst, is_m512_m32bcst, \
    is_m128_m64bcst, is_m256_m64bcst, is_m512_m64bcst, \
    is_vmx, is_vmy, is_evex_vmx, is_evex_vmy, is_vmz, is_vmxk, is_vmyk, is_vmzk, \
    is_imm, is_imm4, is_imm8, is_imm16, is_imm32, is_imm64, \
    is_rel8, is_rel32, is_label, is_er, is_sae, check_operand, format_operand_type


class PAVGUSB(Instruction):
    """Average Packed Byte Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PAVGUSB(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PAVGUSB, self).__init__("PAVGUSB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PAVGUSB\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xBF])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xBF])))
        else:
            raise SyntaxError("Invalid operand types: PAVGUSB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PMULHRW(Instruction):
    """Packed Multiply High Rounded Word"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PMULHRW(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PMULHRW, self).__init__("PMULHRW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PMULHRW\" requires 2 operands")
        self.go_name = "PMULHRW"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xB7])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xB7])))
        else:
            raise SyntaxError("Invalid operand types: PMULHRW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PF2ID(Instruction):
    """Packed Floating-Point to Integer Doubleword Converson"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PF2ID(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PF2ID, self).__init__("PF2ID", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PF2ID\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x1D])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x1D])))
        else:
            raise SyntaxError("Invalid operand types: PF2ID " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PF2IW(Instruction):
    """Packed Floating-Point to Integer Word Conversion"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PF2IW(mm, mm/m64)    [3dnow!+]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PF2IW, self).__init__("PF2IW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PF2IW\" requires 2 operands")
        self.go_name = "PF2IW"
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now_plus])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x1C])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x1C])))
        else:
            raise SyntaxError("Invalid operand types: PF2IW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PI2FW(Instruction):
    """Packed Integer to Floating-Point Word Conversion"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PI2FW(mm, mm/m64)    [3dnow!+]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PI2FW, self).__init__("PI2FW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PI2FW\" requires 2 operands")
        self.go_name = "PI2FW"
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now_plus])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x0C])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x0C])))
        else:
            raise SyntaxError("Invalid operand types: PI2FW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PI2FD(Instruction):
    """Packed Integer to Floating-Point Doubleword Conversion"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PI2FD(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PI2FD, self).__init__("PI2FD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PI2FD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x0D])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x0D])))
        else:
            raise SyntaxError("Invalid operand types: PI2FD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFADD(Instruction):
    """Packed Floating-Point Add"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFADD(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFADD, self).__init__("PFADD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFADD\" requires 2 operands")
        self.go_name = "PFADD"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x9E])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x9E])))
        else:
            raise SyntaxError("Invalid operand types: PFADD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFSUB(Instruction):
    """Packed Floating-Point Subtract"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFSUB(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFSUB, self).__init__("PFSUB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFSUB\" requires 2 operands")
        self.go_name = "PFSUB"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x9A])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x9A])))
        else:
            raise SyntaxError("Invalid operand types: PFSUB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFSUBR(Instruction):
    """Packed Floating-Point Subtract Reverse"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFSUBR(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFSUBR, self).__init__("PFSUBR", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFSUBR\" requires 2 operands")
        self.go_name = "PFSUBR"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xAA])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xAA])))
        else:
            raise SyntaxError("Invalid operand types: PFSUBR " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFMUL(Instruction):
    """Packed Floating-Point Multiply"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFMUL(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFMUL, self).__init__("PFMUL", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFMUL\" requires 2 operands")
        self.go_name = "PFMUL"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xB4])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xB4])))
        else:
            raise SyntaxError("Invalid operand types: PFMUL " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFMAX(Instruction):
    """Packed Floating-Point Maximum"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFMAX(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFMAX, self).__init__("PFMAX", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFMAX\" requires 2 operands")
        self.go_name = "PFMAX"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xA4])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xA4])))
        else:
            raise SyntaxError("Invalid operand types: PFMAX " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFMIN(Instruction):
    """Packed Floating-Point Minimum"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFMIN(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFMIN, self).__init__("PFMIN", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFMIN\" requires 2 operands")
        self.go_name = "PFMIN"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x94])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x94])))
        else:
            raise SyntaxError("Invalid operand types: PFMIN " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFACC(Instruction):
    """Packed Floating-Point Accumulate"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFACC(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFACC, self).__init__("PFACC", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFACC\" requires 2 operands")
        self.go_name = "PFACC"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xAE])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xAE])))
        else:
            raise SyntaxError("Invalid operand types: PFACC " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFNACC(Instruction):
    """Packed Floating-Point Negative Accumulate"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFNACC(mm, mm/m64)    [3dnow!+]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFNACC, self).__init__("PFNACC", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFNACC\" requires 2 operands")
        self.go_name = "PFNACC"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now_plus])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x8A])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x8A])))
        else:
            raise SyntaxError("Invalid operand types: PFNACC " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFPNACC(Instruction):
    """Packed Floating-Point Positive-Negative Accumulate"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFPNACC(mm, mm/m64)    [3dnow!+]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFPNACC, self).__init__("PFPNACC", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFPNACC\" requires 2 operands")
        self.go_name = "PFPNACC"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now_plus])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x8E])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x8E])))
        else:
            raise SyntaxError("Invalid operand types: PFPNACC " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PSWAPD(Instruction):
    """Packed Swap Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PSWAPD(mm, mm/m64)    [3dnow!+]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PSWAPD, self).__init__("PSWAPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PSWAPD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now_plus])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xBB])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xBB])))
        else:
            raise SyntaxError("Invalid operand types: PSWAPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFCMPEQ(Instruction):
    """Packed Floating-Point Compare for Equal"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFCMPEQ(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFCMPEQ, self).__init__("PFCMPEQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFCMPEQ\" requires 2 operands")
        self.go_name = "PFCMPEQ"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xB0])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xB0])))
        else:
            raise SyntaxError("Invalid operand types: PFCMPEQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFCMPGT(Instruction):
    """Packed Floating-Point Compare for Greater Than"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFCMPGT(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFCMPGT, self).__init__("PFCMPGT", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFCMPGT\" requires 2 operands")
        self.go_name = "PFCMPGT"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xA0])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xA0])))
        else:
            raise SyntaxError("Invalid operand types: PFCMPGT " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFCMPGE(Instruction):
    """Packed Floating-Point Compare for Greater or Equal"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFCMPGE(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFCMPGE, self).__init__("PFCMPGE", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFCMPGE\" requires 2 operands")
        self.go_name = "PFCMPGE"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x90])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x90])))
        else:
            raise SyntaxError("Invalid operand types: PFCMPGE " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFRCP(Instruction):
    """Packed Floating-Point Reciprocal Approximation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFRCP(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFRCP, self).__init__("PFRCP", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFRCP\" requires 2 operands")
        self.go_name = "PFRCP"
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x96])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x96])))
        else:
            raise SyntaxError("Invalid operand types: PFRCP " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFRCPIT1(Instruction):
    """Packed Floating-Point Reciprocal Iteration 1"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFRCPIT1(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFRCPIT1, self).__init__("PFRCPIT1", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFRCPIT1\" requires 2 operands")
        self.go_name = "PFRCPIT1"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xA6])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xA6])))
        else:
            raise SyntaxError("Invalid operand types: PFRCPIT1 " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFRCPIT2(Instruction):
    """Packed Floating-Point Reciprocal Iteration 2"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFRCPIT2(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFRCPIT2, self).__init__("PFRCPIT2", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFRCPIT2\" requires 2 operands")
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xB6])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xB6])))
        else:
            raise SyntaxError("Invalid operand types: PFRCPIT2 " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFRSQRT(Instruction):
    """Packed Floating-Point Reciprocal Square Root Approximation"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFRSQRT(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFRSQRT, self).__init__("PFRSQRT", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFRSQRT\" requires 2 operands")
        self.go_name = "PFRSQRT"
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0x97])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0x97])))
        else:
            raise SyntaxError("Invalid operand types: PFRSQRT " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class PFRSQIT1(Instruction):
    """Packed Floating-Point Reciprocal Square Root Iteration 1"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * PFRSQIT1(mm, mm/m64)    [3dnow!]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(PFRSQIT1, self).__init__("PFRSQIT1", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"PFRSQIT1\" requires 2 operands")
        self.go_name = "PFRSQIT1"
        self.in_regs = (True, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.mmx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.three_d_now])
        if is_mm(self.operands[0]) and is_mm(self.operands[1]):
            self.encodings.append((0x20, lambda op, rex=False: optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x0F, 0xC0 | op[0].lcode << 3 | op[1].lcode, 0xA7])))
        elif is_mm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: optional_rex(op[0].hcode, op[1].address, rex) + bytearray([0x0F, 0x0F]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([0xA7])))
        else:
            raise SyntaxError("Invalid operand types: PFRSQIT1 " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class FEMMS(Instruction):
    """Fast Exit Multimedia State"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * FEMMS()    [FEMMS]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(FEMMS, self).__init__("FEMMS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 0:
            raise SyntaxError("Instruction \"FEMMS\" requires 0 operands")
        self.encodings.append((0x00, lambda op: bytearray([0x0F, 0x0E])))
        self.isa_extensions = frozenset([peachpy.x86_64.isa.femms])
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class MOVNTSS(Instruction):
    """Store Scalar Single-Precision Floating-Point Values Using Non-Temporal Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * MOVNTSS(m32, xmm)    [SSE4A]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(MOVNTSS, self).__init__("MOVNTSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"MOVNTSS\" requires 2 operands")
        if is_m32(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: bytearray([0xF3]) + optional_rex(op[1].hcode, op[0].address, rex) + bytearray([0x0F, 0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (True, False)
            self.avx_mode = False
            self.isa_extensions = frozenset([peachpy.x86_64.isa.sse4a])
        else:
            raise SyntaxError("Invalid operand types: MOVNTSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class MOVNTSD(Instruction):
    """Store Scalar Double-Precision Floating-Point Values Using Non-Temporal Hint"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * MOVNTSD(m64, xmm)    [SSE4A]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(MOVNTSD, self).__init__("MOVNTSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"MOVNTSD\" requires 2 operands")
        if is_m64(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x30, lambda op, rex=False, sib=False, min_disp=0: bytearray([0xF2]) + optional_rex(op[1].hcode, op[0].address, rex) + bytearray([0x0F, 0x2B]) + modrm_sib_disp(op[1].lcode, op[0].address, sib, min_disp)))
            self.in_regs = (True, True)
            self.out_regs = (False, False)
            self.out_operands = (True, False)
            self.avx_mode = False
            self.isa_extensions = frozenset([peachpy.x86_64.isa.sse4a])
        else:
            raise SyntaxError("Invalid operand types: MOVNTSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class INSERTQ(Instruction):
    """Insert Field"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * INSERTQ(xmm, xmm)                [SSE4A]
            * INSERTQ(xmm, xmm, imm8, imm8)    [SSE4A]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(INSERTQ, self).__init__("INSERTQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x20, lambda op, rex=False: bytearray([0xF2]) + optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x79, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (False, True)
                self.out_regs = (True, False)
                self.out_operands = (True, False)
                self.avx_mode = False
                self.isa_extensions = frozenset([peachpy.x86_64.isa.sse4a])
            else:
                raise SyntaxError("Invalid operand types: INSERTQ " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 4:
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]) and is_imm(self.operands[3]):
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                if not is_imm8(self.operands[3]):
                    raise ValueError("Argument #3 can not be encoded as imm8")
                self.encodings.append((0x20, lambda op, rex=False: bytearray([0xF2]) + optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x78, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF, op[3] & 0xFF])))
                self.in_regs = (False, True, False, False)
                self.out_regs = (True, False, False, False)
                self.out_operands = (True, False, False, False)
                self.avx_mode = False
                self.isa_extensions = frozenset([peachpy.x86_64.isa.sse4a])
            else:
                raise SyntaxError("Invalid operand types: INSERTQ " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"INSERTQ\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class EXTRQ(Instruction):
    """Extract Field"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * EXTRQ(xmm, xmm)           [SSE4A]
            * EXTRQ(xmm, imm8, imm8)    [SSE4A]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(EXTRQ, self).__init__("EXTRQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) == 2:
            if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
                self.encodings.append((0x20, lambda op, rex=False: bytearray([0x66]) + optional_rex(op[0].hcode, op[1], rex) + bytearray([0x0F, 0x79, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
                self.in_regs = (True, True)
                self.out_regs = (True, False)
                self.out_operands = (True, False)
                self.avx_mode = False
                self.isa_extensions = frozenset([peachpy.x86_64.isa.sse4a])
            else:
                raise SyntaxError("Invalid operand types: EXTRQ " + ", ".join(map(format_operand_type, self.operands)))
        elif len(self.operands) == 3:
            if is_xmm(self.operands[0]) and is_imm(self.operands[1]) and is_imm(self.operands[2]):
                if not is_imm8(self.operands[1]):
                    raise ValueError("Argument #1 can not be encoded as imm8")
                if not is_imm8(self.operands[2]):
                    raise ValueError("Argument #2 can not be encoded as imm8")
                self.encodings.append((0x20, lambda op, rex=False: bytearray([0x66]) + optional_rex(0, op[0], rex) + bytearray([0x0F, 0x78, 0xC0 | op[0].lcode, op[1] & 0xFF, op[2] & 0xFF])))
                self.in_regs = (True, False, False)
                self.out_regs = (True, False, False)
                self.out_operands = (True, False, False)
                self.avx_mode = False
                self.isa_extensions = frozenset([peachpy.x86_64.isa.sse4a])
            else:
                raise SyntaxError("Invalid operand types: EXTRQ " + ", ".join(map(format_operand_type, self.operands)))
        else:
            raise SyntaxError("Invalid number of operands for instruction \"EXTRQ\"")
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPPERM(Instruction):
    """Packed Permute Bytes"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPPERM(xmm, xmm, xmm, xmm/m128)    [XOP]
            * VPPERM(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPPERM, self).__init__("VPPERM", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPPERM\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xA3, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0xA3, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x80, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0xA3]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA3]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPPERM " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCMOV(Instruction):
    """Packed Conditional Move"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCMOV(xmm, xmm, xmm, xmm/m128)    [XOP]
            * VPCMOV(xmm, xmm, xmm/m128, xmm)    [XOP]
            * VPCMOV(ymm, ymm, ymm, ymm/m256)    [XOP]
            * VPCMOV(ymm, ymm, ymm/m256, ymm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCMOV, self).__init__("VPCMOV", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPCMOV\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xA2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0xA2, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x80, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0xA2]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7C ^ (op[1].hlcode << 3), 0xA2, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFC ^ (op[1].hlcode << 3), 0xA2, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x84, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0xA2]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x04, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA2]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPCMOV " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPROTB(Instruction):
    """Packed Rotate Bytes"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPROTB(xmm, xmm, xmm/m128)     [XOP]
            * VPROTB(xmm, xmm/m128, imm8)    [XOP]
            * VPROTB(xmm, xmm/m128, xmm)     [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPROTB, self).__init__("VPROTB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPROTB\" requires 3 operands")
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xC0, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x90, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x90, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x90]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[1].address) + bytearray([0xC0]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x90]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True, True)
        else:
            raise SyntaxError("Invalid operand types: VPROTB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPROTW(Instruction):
    """Packed Rotate Words"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPROTW(xmm, xmm, xmm/m128)     [XOP]
            * VPROTW(xmm, xmm/m128, imm8)    [XOP]
            * VPROTW(xmm, xmm/m128, xmm)     [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPROTW, self).__init__("VPROTW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPROTW\" requires 3 operands")
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xC1, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x91, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x91, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x91]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[1].address) + bytearray([0xC1]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x91]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True, True)
        else:
            raise SyntaxError("Invalid operand types: VPROTW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPROTD(Instruction):
    """Packed Rotate Doublewords"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPROTD(xmm, xmm, xmm/m128)     [XOP]
            * VPROTD(xmm, xmm/m128, imm8)    [XOP]
            * VPROTD(xmm, xmm/m128, xmm)     [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPROTD, self).__init__("VPROTD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPROTD\" requires 3 operands")
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xC2, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x92, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x92, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[1].address) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x92]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True, True)
        else:
            raise SyntaxError("Invalid operand types: VPROTD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPROTQ(Instruction):
    """Packed Rotate Quadwords"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPROTQ(xmm, xmm, xmm/m128)     [XOP]
            * VPROTQ(xmm, xmm/m128, imm8)    [XOP]
            * VPROTQ(xmm, xmm/m128, xmm)     [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPROTQ, self).__init__("VPROTQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPROTQ\" requires 3 operands")
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xC3, 0xC0 | op[0].lcode << 3 | op[1].lcode, op[2] & 0xFF])))
            self.in_regs = (False, True, False)
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x93, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x93, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
            self.in_regs = (False, True, True)
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
            self.in_regs = (False, True, True)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_imm(self.operands[2]):
            if not is_imm8(self.operands[2]):
                raise ValueError("Argument #2 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[1].address) + bytearray([0xC3]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp) + bytearray([op[2] & 0xFF])))
            self.in_regs = (False, True, False)
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x93]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
            self.in_regs = (False, True, True)
        else:
            raise SyntaxError("Invalid operand types: VPROTQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPSHAB(Instruction):
    """Packed Shift Arithmetic Bytes"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPSHAB(xmm, xmm, xmm/m128)    [XOP]
            * VPSHAB(xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPSHAB, self).__init__("VPSHAB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPSHAB\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x98, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x98, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x98]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPSHAB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPSHAW(Instruction):
    """Packed Shift Arithmetic Words"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPSHAW(xmm, xmm, xmm/m128)    [XOP]
            * VPSHAW(xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPSHAW, self).__init__("VPSHAW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPSHAW\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x99, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x99, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x99]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x99]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPSHAW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPSHAD(Instruction):
    """Packed Shift Arithmetic Doublewords"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPSHAD(xmm, xmm, xmm/m128)    [XOP]
            * VPSHAD(xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPSHAD, self).__init__("VPSHAD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPSHAD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x9A, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x9A, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x9A]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPSHAD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPSHAQ(Instruction):
    """Packed Shift Arithmetic Quadwords"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPSHAQ(xmm, xmm, xmm/m128)    [XOP]
            * VPSHAQ(xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPSHAQ, self).__init__("VPSHAQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPSHAQ\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x9B, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x9B, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9B]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x9B]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPSHAQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPSHLB(Instruction):
    """Packed Shift Logical Bytes"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPSHLB(xmm, xmm, xmm/m128)    [XOP]
            * VPSHLB(xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPSHLB, self).__init__("VPSHLB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPSHLB\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x94, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x94, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x94]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x94]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPSHLB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPSHLW(Instruction):
    """Packed Shift Logical Words"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPSHLW(xmm, xmm, xmm/m128)    [XOP]
            * VPSHLW(xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPSHLW, self).__init__("VPSHLW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPSHLW\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x95, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x95, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x95]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x95]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPSHLW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPSHLD(Instruction):
    """Packed Shift Logical Doublewords"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPSHLD(xmm, xmm, xmm/m128)    [XOP]
            * VPSHLD(xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPSHLD, self).__init__("VPSHLD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPSHLD\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x96, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPSHLD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPSHLQ(Instruction):
    """Packed Shift Logical Quadwords"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPSHLQ(xmm, xmm, xmm/m128)    [XOP]
            * VPSHLQ(xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPSHLQ, self).__init__("VPSHLQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 3:
            raise SyntaxError("Instruction \"VPSHLQ\" requires 3 operands")
        self.in_regs = (False, True, True)
        self.out_regs = (True, False, False)
        self.out_operands = (True, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78 ^ (op[2].hlcode << 3), 0x97, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0xF8 ^ (op[1].hlcode << 3), 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x80, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp)))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]) and is_xmm(self.operands[2]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address, op[2].hlcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPSHLQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMB(Instruction):
    """Compare Packed Signed Byte Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMB(xmm, xmm, xmm/m128, imm8)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMB, self).__init__("VPCOMB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPCOMB\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xCC, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xCC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VPCOMB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMW(Instruction):
    """Compare Packed Signed Word Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMW(xmm, xmm, xmm/m128, imm8)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMW, self).__init__("VPCOMW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPCOMW\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xCD, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xCD]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VPCOMW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMD(Instruction):
    """Compare Packed Signed Doubleword Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMD(xmm, xmm, xmm/m128, imm8)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMD, self).__init__("VPCOMD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPCOMD\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xCE, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xCE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VPCOMD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMQ(Instruction):
    """Compare Packed Signed Quadword Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMQ(xmm, xmm, xmm/m128, imm8)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMQ, self).__init__("VPCOMQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPCOMQ\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xCF, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xCF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VPCOMQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMUB(Instruction):
    """Compare Packed Unsigned Byte Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMUB(xmm, xmm, xmm/m128, imm8)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMUB, self).__init__("VPCOMUB", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPCOMUB\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xEC, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xEC]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VPCOMUB " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMUW(Instruction):
    """Compare Packed Unsigned Word Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMUW(xmm, xmm, xmm/m128, imm8)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMUW, self).__init__("VPCOMUW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPCOMUW\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xED, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xED]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VPCOMUW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMUD(Instruction):
    """Compare Packed Unsigned Doubleword Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMUD(xmm, xmm, xmm/m128, imm8)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMUD, self).__init__("VPCOMUD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPCOMUD\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xEE, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xEE]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VPCOMUD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPCOMUQ(Instruction):
    """Compare Packed Unsigned Quadword Integers"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPCOMUQ(xmm, xmm, xmm/m128, imm8)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPCOMUQ, self).__init__("VPCOMUQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPCOMUQ\" requires 4 operands")
        self.in_regs = (False, True, True, False)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xEF, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3] & 0xFF])))
            self._cancelling_inputs = True
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_imm(self.operands[3]):
            if not is_imm8(self.operands[3]):
                raise ValueError("Argument #3 can not be encoded as imm8")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xEF]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3] & 0xFF])))
        else:
            raise SyntaxError("Invalid operand types: VPCOMUQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDBW(Instruction):
    """Packed Horizontal Add Signed Byte to Signed Word"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDBW(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDBW, self).__init__("VPHADDBW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDBW\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xC1, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xC1]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDBW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDBD(Instruction):
    """Packed Horizontal Add Signed Byte to Signed Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDBD(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDBD, self).__init__("VPHADDBD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDBD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xC2, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xC2]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDBD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDBQ(Instruction):
    """Packed Horizontal Add Signed Byte to Signed Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDBQ(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDBQ, self).__init__("VPHADDBQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDBQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xC3, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xC3]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDBQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDWD(Instruction):
    """Packed Horizontal Add Signed Word to Signed Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDWD(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDWD, self).__init__("VPHADDWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDWD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xC6, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xC6]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDWQ(Instruction):
    """Packed Horizontal Add Signed Word to Signed Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDWQ(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDWQ, self).__init__("VPHADDWQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDWQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xC7, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xC7]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDWQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDDQ(Instruction):
    """Packed Horizontal Add Signed Doubleword to Signed Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDDQ(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDDQ, self).__init__("VPHADDDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDDQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xCB, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xCB]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDUBW(Instruction):
    """Packed Horizontal Add Unsigned Byte to Word"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDUBW(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDUBW, self).__init__("VPHADDUBW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDUBW\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xD1, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xD1]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDUBW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDUBD(Instruction):
    """Packed Horizontal Add Unsigned Byte to Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDUBD(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDUBD, self).__init__("VPHADDUBD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDUBD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xD2, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xD2]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDUBD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDUBQ(Instruction):
    """Packed Horizontal Add Unsigned Byte to Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDUBQ(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDUBQ, self).__init__("VPHADDUBQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDUBQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xD3, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xD3]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDUBQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDUWD(Instruction):
    """Packed Horizontal Add Unsigned Word to Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDUWD(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDUWD, self).__init__("VPHADDUWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDUWD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xD6, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xD6]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDUWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDUWQ(Instruction):
    """Packed Horizontal Add Unsigned Word to Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDUWQ(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDUWQ, self).__init__("VPHADDUWQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDUWQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xD7, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xD7]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDUWQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHADDUDQ(Instruction):
    """Packed Horizontal Add Unsigned Doubleword to Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHADDUDQ(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHADDUDQ, self).__init__("VPHADDUDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHADDUDQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xDB, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xDB]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHADDUDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHSUBBW(Instruction):
    """Packed Horizontal Subtract Signed Byte to Signed Word"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHSUBBW(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHSUBBW, self).__init__("VPHSUBBW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHSUBBW\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xE1, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xE1]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHSUBBW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHSUBWD(Instruction):
    """Packed Horizontal Subtract Signed Word to Signed Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHSUBWD(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHSUBWD, self).__init__("VPHSUBWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHSUBWD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xE2, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xE2]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHSUBWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPHSUBDQ(Instruction):
    """Packed Horizontal Subtract Signed Doubleword to Signed Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPHSUBDQ(xmm, xmm/m128)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPHSUBDQ, self).__init__("VPHSUBDQ", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VPHSUBDQ\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0xE3, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0xE3]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VPHSUBDQ " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSDQH(Instruction):
    """Packed Multiply Accumulate Signed High Doubleword to Signed Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSDQH(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSDQH, self).__init__("VPMACSDQH", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSDQH\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x9F, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSDQH " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSDQL(Instruction):
    """Packed Multiply Accumulate Signed Low Doubleword to Signed Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSDQL(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSDQL, self).__init__("VPMACSDQL", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSDQL\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x97, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x97]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSDQL " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSDD(Instruction):
    """Packed Multiply Accumulate Signed Doubleword to Signed Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSDD(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSDD, self).__init__("VPMACSDD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSDD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x9E, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x9E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSDD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSWD(Instruction):
    """Packed Multiply Accumulate Signed Word to Signed Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSWD(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSWD, self).__init__("VPMACSWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSWD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x96, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x96]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSWW(Instruction):
    """Packed Multiply Accumulate Signed Word to Signed Word"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSWW(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSWW, self).__init__("VPMACSWW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSWW\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x95, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x95]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSWW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMADCSWD(Instruction):
    """Packed Multiply Add Accumulate Signed Word to Signed Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMADCSWD(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMADCSWD, self).__init__("VPMADCSWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMADCSWD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xB6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xB6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMADCSWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSSDD(Instruction):
    """Packed Multiply Accumulate with Saturation Signed Doubleword to Signed Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSSDD(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSSDD, self).__init__("VPMACSSDD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSSDD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x8E, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x8E]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSSDD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSSDQH(Instruction):
    """Packed Multiply Accumulate with Saturation Signed High Doubleword to Signed Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSSDQH(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSSDQH, self).__init__("VPMACSSDQH", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSSDQH\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x8F, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x8F]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSSDQH " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSSDQL(Instruction):
    """Packed Multiply Accumulate with Saturation Signed Low Doubleword to Signed Quadword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSSDQL(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSSDQL, self).__init__("VPMACSSDQL", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSSDQL\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x87, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x87]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSSDQL " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSSWD(Instruction):
    """Packed Multiply Accumulate with Saturation Signed Word to Signed Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSSWD(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSSWD, self).__init__("VPMACSSWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSSWD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x86, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x86]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSSWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMACSSWW(Instruction):
    """Packed Multiply Accumulate with Saturation Signed Word to Signed Word"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMACSSWW(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMACSSWW, self).__init__("VPMACSSWW", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMACSSWW\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0x85, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x85]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMACSSWW " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPMADCSSWD(Instruction):
    """Packed Multiply Add Accumulate with Saturation Signed Word to Signed Doubleword"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPMADCSSWD(xmm, xmm, xmm/m128, xmm)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPMADCSSWD, self).__init__("VPMADCSSWD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 4:
            raise SyntaxError("Instruction \"VPMADCSSWD\" requires 4 operands")
        self.in_regs = (False, True, True, True)
        self.out_regs = (True, False, False, False)
        self.out_operands = (True, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE8 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x78 ^ (op[1].hlcode << 3), 0xA6, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1000, 0x00, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0xA6]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4])))
        else:
            raise SyntaxError("Invalid operand types: VPMADCSSWD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFRCZSS(Instruction):
    """Extract Fraction Scalar Single-Precision Floating Point"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFRCZSS(xmm, xmm/m32)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFRCZSS, self).__init__("VFRCZSS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VFRCZSS\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0x82, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m32(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0x82]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VFRCZSS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFRCZSD(Instruction):
    """Extract Fraction Scalar Double-Precision Floating-Point"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFRCZSD(xmm, xmm/m64)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFRCZSD, self).__init__("VFRCZSD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VFRCZSD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0x83, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m64(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0x83]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VFRCZSD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFRCZPS(Instruction):
    """Extract Fraction Packed Single-Precision Floating-Point"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFRCZPS(xmm, xmm/m128)    [XOP]
            * VFRCZPS(ymm, ymm/m256)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFRCZPS, self).__init__("VFRCZPS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VFRCZPS\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0x80, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0x80]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7C, 0x80, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x04, op[0].hcode, op[1].address) + bytearray([0x80]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VFRCZPS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VFRCZPD(Instruction):
    """Extract Fraction Packed Double-Precision Floating-Point"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VFRCZPD(xmm, xmm/m128)    [XOP]
            * VFRCZPD(ymm, ymm/m256)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VFRCZPD, self).__init__("VFRCZPD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 2:
            raise SyntaxError("Instruction \"VFRCZPD\" requires 2 operands")
        self.in_regs = (False, True)
        self.out_regs = (True, False)
        self.out_operands = (True, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x78, 0x81, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_xmm(self.operands[0]) and is_m128(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x00, op[0].hcode, op[1].address) + bytearray([0x81]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]):
            self.encodings.append((0x00, lambda op: bytearray([0x8F, 0xE9 ^ (op[0].hcode << 7) ^ (op[1].hcode << 5), 0x7C, 0x81, 0xC0 | op[0].lcode << 3 | op[1].lcode])))
        elif is_ymm(self.operands[0]) and is_m256(self.operands[1]):
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0x8F, 0b1001, 0x04, op[0].hcode, op[1].address) + bytearray([0x81]) + modrm_sib_disp(op[0].lcode, op[1].address, sib, min_disp)))
        else:
            raise SyntaxError("Invalid operand types: VFRCZPD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMIL2PD(Instruction):
    """Permute Two-Source Double-Precision Floating-Point Vectors"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMIL2PD(xmm, xmm, xmm, xmm/m128, imm4)    [XOP]
            * VPERMIL2PD(xmm, xmm, xmm/m128, xmm, imm4)    [XOP]
            * VPERMIL2PD(ymm, ymm, ymm, ymm/m256, imm4)    [XOP]
            * VPERMIL2PD(ymm, ymm, ymm/m256, ymm, imm4)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMIL2PD, self).__init__("VPERMIL2PD", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 5:
            raise SyntaxError("Instruction \"VPERMIL2PD\" requires 5 operands")
        self.in_regs = (False, True, True, True, False)
        self.out_regs = (True, False, False, False, False)
        self.out_operands = (True, False, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x49, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4 | op[4] & 0xF])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x49, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4 | op[4] & 0xF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x49]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4 | op[4] & 0xF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x49]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4 | op[4] & 0xF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x49, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4 | op[4] & 0xF])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x49, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4 | op[4] & 0xF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x49]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4 | op[4] & 0xF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x49]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4 | op[4] & 0xF])))
        else:
            raise SyntaxError("Invalid operand types: VPERMIL2PD " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


class VPERMIL2PS(Instruction):
    """Permute Two-Source Single-Precision Floating-Point Vectors"""

    def __init__(self, *args, **kwargs):
        """Supported forms:

            * VPERMIL2PS(xmm, xmm, xmm, xmm/m128, imm4)    [XOP]
            * VPERMIL2PS(xmm, xmm, xmm/m128, xmm, imm4)    [XOP]
            * VPERMIL2PS(ymm, ymm, ymm, ymm/m256, imm4)    [XOP]
            * VPERMIL2PS(ymm, ymm, ymm/m256, ymm, imm4)    [XOP]
        """

        origin = kwargs.get("origin")
        prototype = kwargs.get("prototype")
        if origin is None and prototype is None and peachpy.x86_64.options.get_debug_level() > 0:
            origin = inspect.stack()
        super(VPERMIL2PS, self).__init__("VPERMIL2PS", origin=origin, prototype=prototype)
        self.operands = tuple(map(check_operand, args))
        if len(self.operands) != 5:
            raise SyntaxError("Instruction \"VPERMIL2PS\" requires 5 operands")
        self.in_regs = (False, True, True, True, False)
        self.out_regs = (True, False, False, False, False)
        self.out_operands = (True, False, False, False, False)
        self.avx_mode = True
        self.isa_extensions = frozenset([peachpy.x86_64.isa.xop])
        if is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_xmm(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x79 ^ (op[1].hlcode << 3), 0x48, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4 | op[4] & 0xF])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xF9 ^ (op[1].hlcode << 3), 0x48, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4 | op[4] & 0xF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_xmm(self.operands[2]) and is_m128(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x81, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x48]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4 | op[4] & 0xF])))
        elif is_xmm(self.operands[0]) and is_xmm(self.operands[1]) and is_m128(self.operands[2]) and is_xmm(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x01, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x48]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4 | op[4] & 0xF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_ymm(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[2].hcode << 5), 0x7D ^ (op[1].hlcode << 3), 0x48, 0xC0 | op[0].lcode << 3 | op[2].lcode, op[3].hlcode << 4 | op[4] & 0xF])))
            self.encodings.append((0x00, lambda op: bytearray([0xC4, 0xE3 ^ (op[0].hcode << 7) ^ (op[3].hcode << 5), 0xFD ^ (op[1].hlcode << 3), 0x48, 0xC0 | op[0].lcode << 3 | op[3].lcode, op[2].hlcode << 4 | op[4] & 0xF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_ymm(self.operands[2]) and is_m256(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x85, op[0].hcode, op[3].address, op[1].hlcode) + bytearray([0x48]) + modrm_sib_disp(op[0].lcode, op[3].address, sib, min_disp) + bytearray([op[2].hlcode << 4 | op[4] & 0xF])))
        elif is_ymm(self.operands[0]) and is_ymm(self.operands[1]) and is_m256(self.operands[2]) and is_ymm(self.operands[3]) and is_imm(self.operands[4]):
            if not is_imm4(self.operands[4]):
                raise ValueError("Argument #4 can not be encoded as imm4")
            self.encodings.append((0x10, lambda op, sib=False, min_disp=0: vex3(0xC4, 0b11, 0x05, op[0].hcode, op[2].address, op[1].hlcode) + bytearray([0x48]) + modrm_sib_disp(op[0].lcode, op[2].address, sib, min_disp) + bytearray([op[3].hlcode << 4 | op[4] & 0xF])))
        else:
            raise SyntaxError("Invalid operand types: VPERMIL2PS " + ", ".join(map(format_operand_type, self.operands)))
        if peachpy.stream.active_stream is not None:
            peachpy.stream.active_stream.add_instruction(self)


